/*
 * Copyright 2003, Dimitrios Bogiatzoules. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
b * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#define INCL_DOSERRORS
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#include <os2.h>

#include "startpmm.h"

handles		my_handles;
options		my_opts;
pmm_call	pmm_cmdline;

APIRET	startpmm_config(void);
APIRET	startpmm_setup(void);
APIRET	startpmm_exit(void);
APIRET	startpmm_set_exe(void);
int	startpmm_get_uri(const int, char**);
int	startpmm_run_pmm(void);

void    bzero(void *, size_t);
char	startpmm_version[STARTPMM_MAXVALUELEN + 1] = STARTPMM_VERSION;

/******************************************************************************/
/* the main routine ...                                                       */
/******************************************************************************/

int main(int argc, char** argv) {
	int	rc = 2;

	if (startpmm_setup() != NO_ERROR)
		goto cleanup;
	if (startpmm_get_uri(argc, argv) != NO_ERROR)
		goto cleanup;
	if (startpmm_set_exe() != NO_ERROR)
		goto cleanup;
	rc = startpmm_run_pmm();

cleanup:
	startpmm_exit();

	return rc;
}


/******************************************************************************/
/* setting up                                                                 */
/******************************************************************************/
ULONG startpmm_setup(void) {
	APIRET		rc = NO_ERROR;
	ULONG		action;
	time_t		now;
	char		timestamp[30];

	bzero(&my_handles,	sizeof(my_handles));
	bzero(&my_opts,		sizeof(my_opts));
	bzero(&pmm_cmdline,	sizeof(pmm_cmdline));

	rc = startpmm_config();
	if (rc != NO_ERROR)
		return rc;

	/* Create a file handle pointing to /dev/null */
	rc = DosOpen("nul", &my_handles.null, &action, 0UL, FILE_NORMAL,
		OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
		OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, NULL);
	if (rc != NO_ERROR)
		return rc;

	my_handles.io.in = stdin;
	my_handles.io.out = stdout;
	my_handles.io.err = stderr;

	/* If the user wants a logfile, open it */
	if (my_opts.verbose >= 1)
		my_handles.log = fopen(my_opts.logfile, "a+");
	else
		my_handles.log = fopen("nul", "a+");
	if (my_handles.log == NULL)
		return (APIRET)-1;

	now = time(NULL);
	strftime(timestamp, 30, "%Y-%m-%d %H:%M:%S", localtime(&now));

	fprintf(my_handles.log, "startpmm.exe, version %s \n", startpmm_version);
	fprintf(my_handles.log, "Started @ %s \n", timestamp);
	fprintf(my_handles.log, "Logfile --> %s \n",my_opts.logfile);
       	fprintf(my_handles.log, "PMMAIL/2 path --> %s \n",my_opts.pmm_path);
/*       	fprintf(my_handles.log, "Options --> %s \n\n",my_opts.pmm_options);*/

	return rc;
}


/******************************************************************************/
/* read the config file ....                                                  */
/******************************************************************************/
ULONG startpmm_config(void) {
	APIRET		rc = NO_ERROR;
	char		filename[STARTPMM_MAXPATHLEN + 1] = "";
	char		full_path_to_exe[STARTPMM_MAXPATHLEN + 1];
        char            drive[_MAX_DRIVE];
        char            dir[_MAX_DIR];
        char            fname[_MAX_FNAME];
        char            ext[_MAX_EXT];
	FILE*		cfg;
	char		line[STARTPMM_MAXLINELEN + 1];
	char		*option, *value_ptr;
	char		value[STARTPMM_MAXVALUELEN + 1];
	int		value_int;
	int		i, j;

	/* clear line buffer */
	bzero(&line, sizeof(line));

	/* determine the path where this program lives */
	rc = _execname(full_path_to_exe, sizeof(full_path_to_exe));

        /* now extract the drive and path */
        _splitpath(full_path_to_exe, drive, dir, fname, ext);

        /* and finally set the path to the config file */
        strlcat(filename, drive, sizeof(filename));
	strlcat(filename, dir, sizeof(filename));
	strlcat(filename, STARTPMM_CONFIGFILE, sizeof(filename));

	/* Set default options */
	my_opts.verbose = 0;
	strlcpy(my_opts.logfile, drive, sizeof(my_opts.logfile));
	strlcat(my_opts.logfile, dir, sizeof(my_opts.logfile));
	strlcat(my_opts.logfile, "startpmm.log", sizeof(my_opts.logfile));
	strlcpy(my_opts.pmm_path, "", sizeof(my_opts.pmm_path));
	strlcpy(my_opts.pmm_options, "not used in this version", sizeof(my_opts.pmm_options));


	cfg = fopen(filename, "r");
	if (cfg != NULL) {
		while(fgets(line, sizeof(line), cfg) != NULL) {
			if (line[0] == '#')
				/* Line is a comment */
				continue;
			option = (char*)&line;
			i = 0;
			while ((line[i] != '\0') && (line[i] != ' ') && (line[i] != '\t') && (line[i] != '\r') && (line[i] != '\n'))
				i++;
			if (i == 0)
				/* It's an empty line */
				continue;
			if (line[i] == '\0')
				value_ptr = NULL;
			else {
				line[i++] = '\0';
				value_ptr = (char*)&line[i];
				i = 0;
				j = 0;
				while ((value_ptr[i] != '\0') && (value_ptr[i] != '\r') && (value_ptr[i] != '\n') && (j < STARTPMM_MAXVALUELEN)) {
					switch (value_ptr[i]) {
						case ' ':
						case '\t':
							if (j > 0)
								/* Stop here */
								value_ptr[i] = '\0';
							else
								i++;
							break;
						case '\\':
							i++;
							switch (value_ptr[i++]) {
								case '\"':
									value[j++] = '\"';
									break;
								case '\\':
								default:
									value[j++] = '\\';
									break;
							}
							break;
						case '\"':
							i++;
							while ((value_ptr[i] != '\0') && (value_ptr[i] != '\r') && (value_ptr[i] != '\n') && (value_ptr[i] != '\"') && (j < STARTPMM_MAXVALUELEN))
								if (value_ptr[i] == '\\') {
									i++;
									switch (value_ptr[i++]) {
										case '\"':
											value[j++] = '\"';
											break;
										case '\\':
										default:
											value[j++] = '\\';
											break;
									}
           							} else
									value[j++] = value_ptr[i++];
							/* Skip the terminating double quote */
							if (value_ptr[i] == '\"')
								i++;
							break;
						default:
							value[j++] = value_ptr[i++];
							break;
					}
				}
				value[j] = '\0';
				if (stricmp(option, "verbose") == 0) {
					value_int = atoi(value);
					my_opts.verbose = value_int;
				} else
				if (stricmp(option, "logfile") == 0) {
					strlcpy(my_opts.logfile, value, sizeof(my_opts.logfile));
				} else
				if (stricmp(option, "pmmail_path") == 0) {
					strlcpy(my_opts.pmm_path, value, sizeof(my_opts.pmm_path));
				} else
				if (stricmp(option, "pmmail_options") == 0) {
					strlcpy(my_opts.pmm_options, value, sizeof(my_opts.pmm_options));
				}
			}
		}
		fclose(cfg);
	}
        return rc;
}


/******************************************************************************/
/* get the URI given by MOZILLA.EXE                                           */
/******************************************************************************/

int startpmm_get_uri(const int argc, char** argv) {

       /* set a dummy email adress to avoid core dumps when started without arg;-) */
       if (argc <= 1)
                argv[1] = "don\'t start this program your self. Use mozilla instead!";

        /* add a "mailto: in front of the URI */
	strlcat(pmm_cmdline.uri, "\"", sizeof(pmm_cmdline.uri));
	strlcat(pmm_cmdline.uri, "mailto:", sizeof(pmm_cmdline.uri));

        /* fetch the URI given as the first argument */
	strlcat(pmm_cmdline.uri, argv[1], sizeof(pmm_cmdline.uri));

        /* add a " at the end of the URI */
	strlcat(pmm_cmdline.uri, "\"", sizeof(pmm_cmdline.uri));

	return 0;
}


/******************************************************************************/
/* set the executable name, the path & the options                            */
/******************************************************************************/

APIRET	startpmm_set_exe(void) {
	char		temp[STARTPMM_MAXVALUELEN + 1];
	char		pmmail[STARTPMM_MAXVALUELEN + 1] = "/pmmail.exe";

	bzero(&temp, sizeof(temp));

	/* create a string of the executable including the path to it */
	strlcpy(pmm_cmdline.path, my_opts.pmm_path, sizeof(pmm_cmdline.path));
	if (my_opts.verbose >= 1)
		fprintf(my_handles.log, "pmm_cmdline.path --> %s \n", pmm_cmdline.path);

	strlcpy(pmm_cmdline.executable, my_opts.pmm_path, sizeof(pmm_cmdline.executable));
	strlcat(pmm_cmdline.executable, pmmail, sizeof(pmm_cmdline.executable));
	strlcpy(pmm_cmdline.opts, my_opts.pmm_options, sizeof(pmm_cmdline.opts));

	return 0;
}


/******************************************************************************/
/* start pmmail with the given options and URI                                */
/******************************************************************************/

int	startpmm_run_pmm(void) {
	APIRET		rc = NO_ERROR;
	char		load_error[CCHMAXPATH];
	RESULTCODES	resultcodes;
	CHAR		arg[STARTPMM_MAXLINELEN + 2];
	unsigned int	len;



	if (my_opts.verbose >= 1)
		fprintf(my_handles.log, "command line --> \"%s %s \"\n",
			pmm_cmdline.executable, pmm_cmdline.uri);



	rc = _chdir2(pmm_cmdline.path);
        if (my_opts.verbose >= 1)
		fprintf(my_handles.log, "_chdir2 rc = %ld \n",rc);


	/* Build an argument list suitable for DosExecPgm() */
	bzero(&arg, sizeof(arg));
	strlcpy(arg, pmm_cmdline.executable, sizeof(arg));
	len = strlen(arg);
/*	strlcat(arg, "  ", sizeof(arg));
	strlcat(argp, pmm_cmdline.opts, sizeof(arg));*/
	strlcat(arg, " ", sizeof(arg));
	strlcat(arg, pmm_cmdline.uri, sizeof(arg));
	arg[len] = '\0';
	len = strlen(arg);
	arg[len] = '\0';

	fflush(my_handles.log);

	rc = DosExecPgm(load_error, CCHMAXPATH, EXEC_BACKGROUND, (PSZ)&arg,
		NULL, &resultcodes, (PSZ)&pmm_cmdline.executable);

	if (rc != NO_ERROR) {
		fprintf(my_handles.log, "DosExecPgm() failed (rc = %ld)\n", rc);
		pmm_cmdline.rc = 254;
		return pmm_cmdline.rc;
	}
	if (my_opts.verbose >= 1)
		fprintf(my_handles.log, "PMMAIL/2 rc = %ld\n", resultcodes.codeResult);
	pmm_cmdline.rc = resultcodes.codeResult;

	rc = DosClose(my_handles.status.write);

	fflush(my_handles.log);

	if (my_opts.verbose >= 1)
		fprintf(my_handles.log, "startpmm rc = %u\n", pmm_cmdline.rc);

	return pmm_cmdline.rc;
}




/******************************************************************************/
/* prepare to exit the programm ....                                          */
/******************************************************************************/
ULONG startpmm_exit(void) {
	APIRET		rc = NO_ERROR;

	rc = DosClose(my_handles.pass.read);
	rc = DosClose(my_handles.pass.write);

	rc = DosClose(my_handles.status.read);
	rc = DosClose(my_handles.status.write);

	if (my_handles.log != NULL) {
		fprintf(my_handles.log, "\n");
		fclose(my_handles.log);
	}
	rc = DosClose(my_handles.null);

	return rc;
}