Unit pomu;

Interface

const
     MoonIsSet : boolean = False;

Type TTheMoonIs = string[20];
     TTheMoonShape = string[15];
     TTheMoonReal = real;

Function MoonIs : TTheMoonIs;
Function MoonShape : TTheMoonShape;
Function MoonReal : TTheMoonReal;
Function MoonState : Char;

Procedure PomNow(tm_adj : longint;
        tm_year, tm_month, tm_day,
        tm_hour, tm_min, tm_sec : word);

Procedure ResetPomTo(tm_adj : longint;
        tm_year, tm_month, tm_day,
        tm_hour, tm_min, tm_sec : word);

Procedure ReSetPom;


Implementation
uses tm_date, { for JulianDay calc, and Date Constants }
     dos,     { for system date/time access }
     use32,   { for compatability between OS/2 and DOS }
     tm_str;  { for misc string formatting/converting }

Const
        PI       = 3.141592654;
        EPOCH    = 85;
        EPSILONg = 279.611371;  {/* solar ecliptic long at EPOCH */}
        RHOg     = 282.680403;  {/* solar ecliptic long of perigee at EPOCH */}
        ECCEN    = 0.01671542;  {/* solar orbit eccentricity */}
        lzero    = 18.251907;   {/* lunar mean long at EPOCH */}
        Pzero    = 192.917585;  {/* lunar mean long of perigee at EPOCH */}
        Nzero    = 55.204723;   {/* lunar mean long of node at EPOCH */}

var
   TheMoonIs : TTheMoonIs;
   TheMoonShape : TTheMoonShape;
   TheMoonReal  : real;



{/*
 * dtor --
 *  convert degrees to radians
 */}
Function dtor(deg : real) : real;
begin
     dtor := (deg * PI / 180);
end;

{/*
 * adj360 --
 *  adjust value so 0 <= deg <= 360
 */}
function adj360(var deg : real) : real;
begin
     repeat
           if (deg < 0) then deg:=deg+360
           else if (deg > 360) then deg:=deg-360
           else break;
     until false;
end;


function potm(days: real) : real;
var
   N, Msol, Ec, LambdaSol, l, Mm, Ev, Ac, A3, Mmprime : real;
   A4, lprime, V, ldprime, D, Nm : real;
begin
     N := 360 * days / 365.2422;                            {/* sec 42 #3 */}
     adj360(N);
     Msol := N + EPSILONg - RHOg;                           {/* sec 42 #4 */}
     adj360(Msol);
     Ec := 360 / PI * ECCEN * sin(dtor(Msol));              {/* sec 42 #5 */}
     LambdaSol := N + Ec + EPSILONg;                        {/* sec 42 #6 */}
     adj360(LambdaSol);
     l := 13.1763966 * days + lzero;                        {/* sec 61 #4 */}
     adj360(l);
     Mm := l - (0.1114041 * days) - Pzero;                  {/* sec 61 #5 */}
     adj360(Mm);
     Nm := Nzero - (0.0529539 * days);                      {/* sec 61 #6 */}
     adj360(Nm);
     Ev := 1.2739 * sin(dtor(2*(l - LambdaSol) - Mm));      {/* sec 61 #7 */}
     Ac := 0.1858 * sin(dtor(Msol));                        {/* sec 61 #8 */}
     A3 := 0.37 * sin(dtor(Msol));
     Mmprime := Mm + Ev - Ac - A3;                          {/* sec 61 #9 */}
     Ec := 6.2886 * sin(dtor(Mmprime));                     {/* sec 61 #10 */}
     A4 := 0.214 * sin(dtor(2 * Mmprime));                  {/* sec 61 #11 */}
     lprime := l + Ev + Ec - Ac + A4;                       {/* sec 61 #12 */}
     V := 0.6583 * sin(dtor(2 * (lprime - LambdaSol)));     {/* sec 61 #13 */}
     ldprime := lprime + V;                                 {/* sec 61 #14 */}
     D := ldprime - LambdaSol;                              {/* sec 63 #2 */}
     potm := (50 * (1 - cos(dtor(D))));                     {/* sec 63 #3 */}
end;


Procedure PomNow{tm_adj : longint;
        tm_year, tm_month, tm_day,
        tm_hour, tm_min, tm_sec : word};

var
        tm_yday,
        tm_ye,
        tm_mo,
        tm_da,
        tm_dow,
        tm_ho,
        tm_mi,
        tm_se,
        tm_hos : word;


        cnt : longint;
        days, tomorrow : real;

        l : integer;

        st : string[80];

BEGIN
      TheMoonIs:='';
      TheMoonShape := '';
      THeMoonReal := 0;

      getdate(tm_ye, tm_mo, tm_da, tm_dow); {get system date}
      gettime(tm_ho, tm_mi, tm_se, tm_hos);   {get system time}

      if (tm_adj>0) then begin                    {do + time/date adjustment on system times}
         tm_ho := tm_ho + tm_adj;
         while tm_ho>=hoursInDay do begin
               tm_ho:=tm_Ho-hoursInDay;
               Tm_da:=Tm_Da + 1;
               if Tm_da>CDaysInMonth[tm_mo] then begin
                  tm_da:=1;
                  tm_mo:=tm_mo+1;
                  if tm_mo > MonthsInYear then begin
                     tm_mo:=1;
                     tm_ye:=tm_ye + 1;
                  end;
               end;
         end;
      end;

      if (tm_adj<0) then begin                   {do - time/date adjustment on system times}
         l := tm_ho + tm_adj;
         while l<0 do begin
               l:=l+hoursInDay;
               Tm_da:=Tm_Da - 1;
               if Tm_da=0 then begin
                  tm_mo:=tm_mo-1;
                  tm_da:=CDaysInMonth[tm_mo];
                  if tm_mo=0 then begin
                     tm_mo:=MonthsInYear;
                     tm_ye:=tm_ye - 1;
                  end;
               end;
         end;
         tm_ho:=l;
      end;

                    {check for date/time values on commandline, non-switched}
      if tm_year =  $FFFF then tm_year  :=tm_ye;
      if tm_month = $FFFF then tm_month :=tm_mo;
      if tm_day =   $FFFF then tm_day   :=tm_da;
      if tm_hour =  $FFFF then tm_hour  :=tm_ho;
      if tm_min =   $FFFF then tm_min   :=tm_mi;
      if tm_sec =   $FFFF then tm_sec   :=tm_se;

                         {work out julian date/time for date on year given }
     days := (julianDay(tm_year, tm_month,tm_day) + ((tm_hour +
             (tm_min / 60.0) + (tm_sec / 3600.0)) / 24.0));

     tm_year := tm_year-1900;                      {subtract 1900 from year}

     cnt := EPOCH;                           {do some weird calcuation <-: }
     while (cnt < tm_year) do begin
           if IsLeapYear(cnt) then days:=days+366 else days:=days+365;
           inc(cnt);
     end;
                                         {output percentage and halt if 'p'}
     TheMoonReal := potm(days) + 0.5;     {percentage of moon + .5 (for testing?)}

     if (TheMoonReal >= 100) then TheMoonIs := 'Full!'   {output the full pom output}
     else if (TheMoonReal < 1 ) then TheMoonIs := 'New!'
     else begin
        tomorrow := potm(days + 1);
        if (TheMoonReal >= 50)and(TheMoonReal < 51) then
           if (tomorrow > TheMoonReal) then TheMoonIS := 'at First Quarter.'
                                 else TheMoonIs := 'at Last Quarter.'
        else begin
            if (tomorrow > TheMoonReal) then TheMoonIs := 'a Waxing'
                                  else TheMoonIs := 'a Waning';
            if (TheMoonReal > 50) then TheMoonShape:= TheMoonShape + 'Gibbous.'
            else if (TheMoonReal < 50) then TheMoonShape := TheMoonShape + 'Crescent.';
        end;
     end;
     MoonIsSet:=TRUE;
end;

Procedure ReSetPom;
begin
     PomNow (0,$ffff,$ffff,$ffff,$ffff,$ffff,$ffff);
end;

Procedure ResetPomTo{(tm_adj : longint;
        tm_year, tm_month, tm_day,
        tm_hour, tm_min, tm_sec : word)};
begin
end;

Function MoonIs : TTheMoonIs;
begin
     if not MoonISset then ResetPom;
     MoonIs := TheMoonIs;
end;

Function MoonShape : TTheMoonShape;
begin
     if not MoonISset then ResetPom;
     MoonShape := TheMoonShape;
end;

Function MoonReal : TTheMoonReal;
begin
     if not MoonISset then ResetPom;
     MoonReal := TheMoonReal;
end;

Function MoonState : Char;
begin
     if not MoonISset then ResetPom;
     MoonState:=TheMoonIs[2];
end;

BEGIN
END.

