Unit Tm_DOS;

Interface
Uses DOS
{$IFDEF VIRTUALPASCAL}
        ,os2base
{$ENDIF}
;

Const

  fmReadOnly = 0;          {FileMode constants}
  fmWriteOnly = 1;
  fmReadWrite = 2;
  fmDenyAll = 16;
  fmDenyWrite = 32;
  fmDenyRead = 48;
  fmDenyNone = 64;
  fmNoInherit = 128;


{ Function DosDelete (FN : PathStr) : Word;}
 Function DirExist(DN : Pathstr) : Boolean;
 Function NameExist(DN : Pathstr) : Boolean;
{ Function DosAttr(FN : PathStr; At : byte) : Boolean; }
 Function QueryPath(Const PN : PathStr) : PathStr;

 FUNCTION DrivesAvail : STRING;
 FUNCTION DrivesAvailStartingAt( c : char) : STRING;
 function DriveValid(Drive: Char): Boolean;

 Function CmdLineStr(C : Char) : string;
 Function CmdLineVal(C : Char; dft : longint) : Longint;
 Function CmdLineReal(C : Char; dft : real) : real;
 Function CmdLineTog(C : Char) : Boolean;
 Function CmdLineNoTogStr(B: byte) : string;
 Function CmdLineNoTogsStr(const s : string; B: byte) : string;
 Function EnvSize : longint; {size of session environment}

 {text file stuff}
 Function AppendTextFile(const fnOrig, fnAppend : string) : byte;
 function counttextlines(var f: text; const fn: string; cmtChar : char; buf: pointer; bufsize: longint) : longint;

 Function RndFilename(const Ext: string; tries : word) : string;

 Function UUinsert(fn : string; var ofile : text) : byte;     {open fn and uuencode it into ofile}


(* function SearchBuffer(var Buffer; BufLength : Word;
                       var Match; MatLength : Word) : Word; { $FFFF if not found}
 Function FindInOpenFile(var f: file; var Target; TargetSize : word) : longint;*)


Implementation
uses TM_str{, search};
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function DirExist(DN : Pathstr) : Boolean;
var Sr : searchrec;
begin
     findfirst(NobackSlash(DN),Directory,sr);
     if (dos.DosError=0)and((sr.attr and directory)=Directory)
        then DirExist:=TRUE else Direxist:=False;
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function NameExist(DN : Pathstr) : Boolean;
var Sr : searchrec;
begin
     findfirst(NobackSlash(DN),AnyFile,sr);
     if (dos.DosError=0) then NameExist:=TRUE else Nameexist:=False;
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
(*Function DosDelete (FN : PathStr) : Word; {returns error if any}
Var Regs : Registers;
begin
  FN:=FN+#0;                  {make asciiz}
  Regs.DS := Seg(FN[1]);      {segment to String}
  Regs.DX := Ofs(FN[1]);
  Regs.AH := $41;
  Regs.AL := 0;               {Initialize}
  Intr ($21, Regs);
  if Regs.AL <> 0 then DosDelete := Regs.AX else DosDelete := 0;
end;*)
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
(*Function DosAttr (FN : PathStr; At : byte) : Boolean; {returns error if any}
Var Regs : Registers;
begin
  FN:=FN+#0;                  {make asciiz}
  Regs.DS := Seg(FN[1]);      {segment to String}
  Regs.DX := Ofs(FN[1]);
  Regs.AH := $43;
  Regs.AL := $01;               {Initialize}
  Regs.CL := At;
  Intr ($21, Regs);
  if (Regs.flags and Fcarry) <> 0 then DosAttr:=False else DosAttr:=True;
end;*)
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
(*procedure Deldirs;
var
  sr  :  searchrec;
begin
  findfirst('*.*',AnyFile xor VolumeId,sr);
  repeat
    if boolean(sr.Attr and Directory) and (sr.name[1]<>'.') then
    begin
      chdir(sr.name);
      Deldirs;
      chdir('..');
      rmdir(sr.name)
    end
    else if (sr.name[1]<>'.') then
    begin
      DosAttr(sr.name,Archive);
      DosDelete(sr.name)
    end;
    findnext(sr);
  until DOSError<>0;
end;*)
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function QueryPath(Const PN : Pathstr) : PathStr;
var b : byte;
begin
     b:=2;
     While b<=byte(pn[0]) do begin
           While (b<=byte(pn[0]))and(pn[b]<>'\') do inc(b);
           if pn[pred(b)]=':' then inc(b)
           else begin
                if DirExist(copy(pn,1,pred(b))) then QueryPath:=(copy(pn,1,pred(b)));
           end;
     end;
     if DirExist(copy(pn,1,b)) then QueryPath:=(copy(pn,1,b));
end;
{----------------------------------------------------------------------}
{--                   Command Line String                            --}
{----------------------------------------------------------------------}
Function CmdLineStr( C: char) : string;
var stmp : string;
    x    : byte;
begin
     CmdLineStr:=''; C := UPcase(c);
     if Paramcount=0 then exit;
     for x := 1 to paramcount do begin
         stmp:=Paramstr(x);
         if (stmp[1]='-')or(stmp[1]='/') then begin
            if upcase(stmp[2])=C then begin
               if stmp[0]>#2 then begin
                  if stmp[3]=':' then CmdLineStr:= copy(stmp,4,255)
                     else CmdLineStr:= copy(stmp,3,255);
               end;
            end;
         end;
     end;
end;
{----------------------------------------------------------------------}
{--                    Commandline Numeric Value                     --}
{----------------------------------------------------------------------}
Function CmdLineVal(C : Char; dft : longint) : Longint;
var s : string[30];
    L : Longint;
{$IFDEF MSDOS}
    i : integer;
{$ELSE}
    i : longint;
{$ENDIF}
begin
     CmdLineVal:=dft;
     s:=CmdLineStr(C);
     if s<>'' then begin
        val(s,L,i);
        if i=0 then CmdLineVal:=L;
     end;
end;
{----------------------------------------------------------------------}
{--                    Commandline Real Numeric Value                --}
{----------------------------------------------------------------------}
Function CmdLineReal(C : Char; dft : real) : real;
var s : string[30];
    L : real;
{$IFDEF MSDOS}
    i : integer;
{$ELSE}
    i : longint;
{$ENDIF}
begin
     CmdLinereal:=dft;
     s:=CmdLineStr(C);
     if s<>'' then begin
        val(s,L,i);
        if i=0 then CmdLineReal:=L;
     end;
end;
{----------------------------------------------------------------------}
{--                   Command Line Toggle                            --}
{----------------------------------------------------------------------}
Function CmdLineTog( C: char) : Boolean;
var stmp : string[2];
    x    : byte;
begin
     CmdLineTog:=FALSE; C := UPcase(c);
     if Paramcount=0 then exit;
     for x := 1 to paramcount do begin
         stmp:=Paramstr(x);
         if (stmp[1]='-')or(stmp[1]='/') then begin
            if upcase(stmp[2])=C then CMDLineTog:=TRUE;
         end;
     end;
end;
{----------------------------------------------------------------------}
{--                   Command Line Param not a Toggle                --}
{----------------------------------------------------------------------}
Function CmdLineNoTogStr(B: byte) : string;
var stmp : string;
    x,c  : byte;
begin
     c:=0;
     CmdLineNoTogStr:='';
     if (Paramcount=0)or(b>paramcount) then exit;
     for x := 1 to paramcount do begin
         stmp:=Paramstr(x);
         if (stmp[1]<>'-')and(stmp[1]<>'/') then begin
            inc(c);
         end;
         if (c=b) then break;
     end;
     if (c=b) then CmdLineNoTogStr:=stmp;
end;
{----------------------------------------------------------------------}
{--           Command Line Param not switched by s                   --}
{----------------------------------------------------------------------}
Function CmdLineNoTogsStr(Const S : string; B: byte) : string;
var stmp : string;
    x,c  : byte;
begin
     c:=0;
     CmdLineNoTogsStr:='';
     if (Paramcount=0)or(b>paramcount) then exit;
     for x := 1 to paramcount do begin
         stmp:=Paramstr(x);
         if ((stmp[1]<>'-')and(stmp[1]<>'/'))
            or(pos(upcase(stmp[2]),s)=0) then inc(c);
         if (c=b) then break;
     end;
     if (c=b) then CmdLineNoTogsStr:=stmp;
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{$IFDEF MSDOS}
FUNCTION DrivesAvail : STRING; ASSEMBLER;
VAR
  DriveInfo:  ARRAY[1..2] OF CHAR;
  Buffer: ARRAY[1..40] OF CHAR;
  DriveString: ARRAY[1..25] OF CHAR;
ASM
 PUSH  SI { Save Important Registers }
 PUSH  DI
 PUSH  ES
 PUSH  DS

 MOV SI, SS { The Stack Segment (SS) points to the }
 MOV DS, SI { VAR's above. Point DS to it... }
 PUSH  DS
 POP ES { ...and ES as well. }

 LEA SI, DriveInfo { DS:SI - Where we test each drive letter }
 LEA DI, Buffer { ES:DI - FCB Buffer }
 LEA BX, DriveString{ DS:BX - Our resultant string }

 MOV BYTE PTR [SI], 'A' { The character before 'A' }
{ MOV SI, FD}
 XOR CX, CX { Zero out CX }

@Scan:
 INC BYTE PTR [SI] { Next Drive Letter }
 MOV BYTE PTR [SI+1], ':'
 MOV AX, $2906 { DOS Function 29h - Parse Filename }
 INT 21h {  DS:SI - String to be parsed }
  {  ES:DI - FCB }
 LEA SI, DriveInfo { DS:SI }
 CMP AL, $FF{ AL = FFh if function fails (invalid }
 JE @NotValid { drive letter) }

 INC CX { Add one more to our string length... }
 PUSH  CX { ...and save it. }
 MOV CL, BYTE PTR DS:[SI]  { Grab the valid drive letter... }
 MOV [BX], CL  { ...and stuff it into our result }
 INC BX { Next position in result string }
 POP CX { Get our length counter back }

@NotValid:
 CMP BYTE PTR [SI], 'Z' { Did we go through all letters? }
 JNE @Scan { Nope, so next letter }

 LEA SI, DriveString{ Store DriveString to #Result }
 LES DI, @Result
 INC DI
 REP MOVSB

 XCHG  AX, DI { This is the only way to store the }
 MOV DI, WORD PTR @Result  {  length that I can get to work. }
 SUB AX, DI
 DEC AX
 STOSB

 POP DS { Restore Important Registers }
 POP ES
 POP DI
 POP SI
END;
{$ELSE}
FUNCTION DrivesAvail : STRING;
Type
    ulong = longint;
    apiret=longint;
    FSINFOBUF = Record
              UlVolser : ULONG;       (* Volume serial number *)
              Vol      : VOLUMELABEL; (* Volume label         *)
    End;
    PFSINFOBUF = ^FSINFOBUF;

Var
   ulDriveNumber : ULONG;     (* Drive number            *)
   VolumeInfo    : FSINFOBUF; (* File system info buffer *)
   rc            : APIRET;    (* Return code             *)
   x : byte;
   s : string;
BEGIN
     s:='';
     for x := 0 to 26 do if dosqueryFSinfo(ulDriveNumber,
                            FSIL_VOLSER,
                            VolumeInfo,
                            sizeof(FSINFOBUF))>=0 then s:=s+char(65+x);
     DrivesAvail := s;
END;
{$ENDIF}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
FUNCTION DrivesAvailStartingAt( c : char) : STRING;
var s : string;
    t : char;
begin
     c := upcase(c);
     s := drivesavail;
     while (s[1]<c)and(s[0]>#0) do system.delete(s,1,1);
     DrivesAvailStartingAt := s;
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{$IFDEF MSDOS}
function DriveValid(Drive: Char): Boolean; assembler;
asm
mov  ah, 19h { Select DOS function 19h }
int  21h { Call DOS for current disk drive }
mov  bl, al { Save drive code in bl }
mov  al, Drive  { Assign requested drive to al }
sub  al, 'A' { Adjust so A:=0, B:=1, etc. }
mov  dl, al { Save adjusted result in dl }
mov  ah, 0eh { Select DOS function 0eh }
int  21h { Call DOS to set default drive }
mov  ah, 19h { Select DOS function 19h }
int  21h { Get current drive again }
mov  cx, 0  { Preset result to False }
cmp  al, dl { Check if drives match }
jne  @@1 { Jump if not--drive not valid }
mov  cx, 1  { Preset result to True }
@@1:
mov  dl, bl { Restore original default drive }
mov  ah, 0eh { Select DOS function 0eh }
int  21h { Call DOS to set default drive }
xchg ax, cx { Return function result in ax }
end;
{$ELSE}
function DriveValid(Drive: Char): Boolean;
begin
     DriveValid := false;
end;
{$ENDIF}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function AppendTextFile(const fnOrig, fnAppend : string) : byte;
begin
end;

{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}

Function RndFilename(const Ext: string; tries : word) : string;
var f : file;
    s : string[12];
    c : word;
    b : byte;
begin
     s[0]:=#8;
     if ext<>'' then s:=s+'.'+ext;
     s[1]:='_'; s[8]:='_';
     if tries=0 then tries:=$FFFF;
     for c := 0 to tries do begin
         randomize;
         for b:=2 to 7 do s[b]:=char(random(26)+97);
         assign(f,s); {$I-}reset(f);{$I+}
         if IoResult=0 then break;
     end;
     if c<=tries then RndFileName:='' else RndFilename:=s;
end;
{----------------------------------------------------------------------}
{--                     COUNT TEXT LINES                             --}
{----------------------------------------------------------------------}
function counttextlines(var f: text; const fn: string; cmtChar : char; buf: pointer; bufsize: longint) : longint;
var
   line : longint;
   s : string;
   io : longint;
begin
     line:=0;  io := 0;
     filemode:=fmReadOnly+fmDenyNone;
     assign(f,fn);
     if (buf<>nil)and(bufsize>0) then settextbuf(f,buf^,bufsize);
     {$I-}Reset(f);{$I+}
     if ioresult=0 then begin
        while (not eof(f))and(io=0) do begin
              {$I-}readln(f,s);{$I+}
              io := IoResult;
              if io=0 then if (s[0]<>#0)and(s[1]<>cmtchar) then inc(line);
        end;
        close(f);
     end;
     counttextlines:=line;
end;
{----------------------------------------------------------------------}
{--                UUencode a file to a file                         --}
{----------------------------------------------------------------------}
Function UUinsert(fn : string; var ofile : text) : byte;
Const
     LastKwartsInLine = 57;
     Offset = 32;
     SixBitMask = $3F;
type
  TTriplet = Array[0..2] of Byte;
  TKwartet = Array[0..3] of Byte;
var
   os : array [0..61] of char;
   st : pchar;

   pTriplet : ^Ttriplet;
   pKwartet : ^TKwartet;

   f : file;
   fbuf : pointer;
   size : longint;

   Trips : longint;
   Remain: byte;

   Kwarts: byte;

{$IFDEF MSDOS}
    r : integer;
{$ELSE}
    r : longint;
{$ENDIF}

begin
     UUinsert:=0;
     Fbuf := nil;
     FileMode := fmReadOnly + fmDenyWrite;
     assign(f,fn); {$I-}reset(f,1); {$I+}
     if IoResult = 0 then begin
        Size:=FileSize(f);
        getmem(Fbuf,size);
        if Fbuf<>nil then begin
           blockRead(f,Fbuf^,size,r);
           close(f);
           if r=size then begin
              Trips := size div 3;
              Remain:= size mod 3;
              writeln(ofile,'begin 664 ',fnonly(fn));
              os[61]:=#0;
              os[0]:='M';
              st:=@os;
              pTriplet:=fbuf;
              Kwarts:=1;
              repeat
                    while (Kwarts<=LastKwartsInLine)and(Trips>=1) do begin
                          pKwartet:=@st[Kwarts];
                          pKwartet^[0] := (pTriplet^[0] SHR 2);
                          pKwartet^[1] := ((pTriplet^[0] SHL 4) AND $30) +
                                          ((pTriplet^[1] SHR 4) AND $0F);
                          pKwartet^[2] := ((pTriplet^[1] SHL 2) AND $3C) +
                                          ((pTriplet^[2] SHR 6) AND $03);
                          pKwartet^[3] := (pTriplet^[2] AND $3F);
                          for r:=0 to 3 do begin
                              if pKwartet^[r] = 0 then pKwartet^[r] := $40;
                               Inc(pKwartet^[r],Offset);
                          end;

                          inc(pTriplet);
                          inc(Kwarts,4);
                          dec(trips);
                    end;
                    if (Kwarts>LastKwartsInLine) then begin
                       writeln(ofile,st);
                       Kwarts:=1;
                    end;
              Until Trips<1;
              {if Kwarts=LastKwartsInLine then Kwarts:=1;}
              os[0]:=char(((kwarts-1) div 4) * 3 + offset + remain);
              if ((Kwarts<=LastKwartsInLine)and(Kwarts<>1))or(remain>0) then begin
                 if remain>0 then begin
                    fillchar(fbuf^,3,#0);
                    move(pTripLet^,fbuf^,remain);
                          pKwartet:=@st[Kwarts];
                          pKwartet^[0] := (pTriplet^[0] SHR 2);
                          pKwartet^[1] := ((pTriplet^[0] SHL 4) AND $30) +
                                          ((pTriplet^[1] SHR 4) AND $0F);
                          pKwartet^[2] := ((pTriplet^[1] SHL 2) AND $3C) +
                                          ((pTriplet^[2] SHR 6) AND $03);
                          pKwartet^[3] := (pTriplet^[2] AND $3F);
                          for r:=0 to 3 do begin
                              if pKwartet^[r] = 0 then pKwartet^[r] := $40;
                               Inc(pKwartet^[r],Offset);
                          end;
                          inc(Kwarts,4);
                 end;
                 pKwartet:=@st[Kwarts];
                 Pkwartet^[0]:=0;
                 Writeln(ofile,st);
              end;
              writeln(ofile,'`');
              writeln(ofile,'end');
{              writeln(kwarts,'  ',remain);}
           end else uuinsert:=4; {writeln('wrong read!');}
           FreeMem(Fbuf,size);
        end else begin
            {writeln('no mem!');}
            UUinsert:= 2;
        end;
     end else begin
         {writeln('what file?');}
         uuinsert := 1;
     end;
END; {uuencode}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function EnvSize : longint;
{$IFDEF VIRTUALPASCAL}
var
   pc : pchar;
   wx : longint;
begin
     pc:=environment;
     EnvSize:=0;
     if (pc=nil) or (pc^=#0) then exit;
     wx:=0;
     repeat
           inc(wx);
           inc(pc);
     until ((pc^=#0)and((pc+1)^=#0));
     EnvSize:=wx+2;
end;
{$ELSE}
begin
     envsize:=0;
end;
{$ENDIF}

{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
{----------------------------------------------------------------------}
{--                    SearchBuffer                                  --}
{----------------------------------------------------------------------}
(*function SearchBuffer(var Buffer; BufLength : Word;
                  var Match; MatLength : Word) : Word;
   {-Search through Buffer for Match. BufLength is length of range to search.
     MatLength is length of string to match. Returns number of bytes searched
     to find Match, $FFFF if not found.}
  begin
    inline(
      $1E/                   {PUSH DS                 ;Save DS}
      $FC/                   {CLD                     ;Go forward}
      $C4/$7E/<Buffer/       {LES  DI,[BP+<Buffer]    ;ES:DI => Buffer}
      $89/$FB/               {MOV  BX,DI              ;BX = Ofs(Buffer)}
      $8B/$4E/<BufLength/    {MOV  CX,[BP+<BufLength] ;CX = Length of range to scan}
      $8B/$56/<MatLength/    {MOV  DX,[BP+<MatLength] ;DX = Length of match string}
      $85/$D2/               {TEST DX,DX              ;Length(Match) = 0?}
      $74/$24/               {JZ   Error              ;If so, we're done}
      $C5/$76/<Match/        {LDS  SI,[BP+<Match]     ;DS:SI => Match buffer}
      $AC/                   {LODSB                   ;AL = Match[1]; DS:SI => Match[2]}
      $4A/                   {DEC  DX                 ;DX = MatLength-1}
      $29/$D1/               {SUB  CX,DX              ;CX = BufLength-(MatLength-1)}
      $76/$1B/               {JBE  Error              ;Error if BufLength is less}
                             {;Search for first character in Match}
                             {Next:}
      $F2/$AE/               {REPNE SCASB             ;Search forward for Match[1]}
      $75/$17/               {JNE  Error              ;Done if not found}
      $85/$D2/               {TEST DX,DX              ;If Length = 1 (DX = 0) ...}
      $74/$0C/               {JZ   Found              ; the "string" was found}
                             {;Search for remainder of Match}
      $51/                   {PUSH CX                 ;Save CX}
      $57/                   {PUSH DI                 ;Save DI}
      $56/                   {PUSH SI                 ;Save SI}
      $89/$D1/               {MOV  CX,DX              ;CX = Length(Match) - 1}
      $F3/$A6/               {REPE CMPSB              ;Does rest of string match?}
      $5E/                   {POP  SI                 ;Restore SI}
      $5F/                   {POP  DI                 ;Restore DI}
      $59/                   {POP  CX                 ;Restore CX}
      $75/$EC/               {JNE  Next               ;Try again if no match}
                             {;Calculate number of bytes searched and return}
                             {Found:}
      $4F/                   {DEC  DI                 ;DX = Offset where found}
      $89/$F8/               {MOV  AX,DI              ;AX = Offset where found}
      $29/$D8/               {SUB  AX,BX              ;Subtract starting offset}
      $EB/$03/               {JMP  SHORT SDone        ;Done}
                             {;Match was not found}
                             {Error:}
      $31/$C0/               {XOR  AX,AX              ;Return $FFFF}
      $48/                   {DEC  AX}
                             {SDone:}
      $1F/                    {POP  DS                 ;Restore DS}
      $89/$46/<SearchBuffer); {MOV [BP+<Search],AX     ;Set func result}
  end;

Function FindInOpenFile(var f: file; var Target; TargetSize : word) : longint;
type
    arr = array[1..$FFF0] of byte;
    parr= ^arr;
var
   buff     : pointer;
   buffsize : word;
   buffp    : word;
   r        : word;
   tmp      : word;
   fpos     : longint;
   found    : boolean;
begin
     buffsize:=$FFF0; buffP:=1; fpos:=0; Found := false;
     FindInOpenFile:=-1; {not found}
     if MaxAvail<BuffSize then buffsize:=MaxAvail;
     if (BuffSize>TargetSize) then begin
        reset(f,1);
        getMem(buff, buffsize);
        while (not Eof(f)) and (not found) do begin
              fpos:=FilePos(f);
              BlockRead(f, Buff^, Buffsize, r);
              tmp:=SearchBuffer(buff^,r,target,targetsize);
              if tmp=$FFFF then begin
                 seek(f, filepos(f)-pred(TargetSize));
              end else begin Found:=TRUE; FindInOpenFile:=Fpos+tmp; end;
        end;
        freemem(buff, buffsize);
     end else FindINOpenFile:=-2 {not enough mem}
end;
*)
{**********************************************************************}
{**********************************************************************}
end.
