Unit TM_DATE;

Interface

uses Use32;

Const
     MonthStr : array[1..12] of string[12] = ('January', 'February',
                'March', 'April', 'May', 'June', 'July', 'August',
                'September', 'October', 'November', 'December');
     DayStr : array[0..6] of string[15] = ('Sunday', 'Monday',
              'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
     AMPMStr  : array[FALSE..TRUE] of string[2] = ('am','pm');
     CDaysInMonth : Array [1..12] of Byte =
                    (31,28,31,30,31,30,31,31,30,31,30,31);

     MonthsInYear    = 12;
     DaysInWeek      = 7;
     SecondsInMinute = 60;
     MinutesInHour   = 60;
     HoursInDay      = 24;
     SecondsInHour   = SecondsInMinute*MinutesInHour;
     SecondsInDay    = SecondsInMinute*MinutesInHour*HoursInDay;
     HSecondsInDay   = SecondsInMinute*MinutesInHour*HoursInDay*100;


function IsLeapYear(y : Integer) : Boolean;
function Julian (Y,M,D : Word)   : LongInt; { Days  since 0000 }
Function JulianDay(y,m,d : word) : integer;
Function DaysInMonth(M,Y : word) : byte;
function TodayJulian : longint;
procedure J2date (J : longint; var Y,M,D : Word);
Function CalcDayOfWeek(Year, Month, Day : Integer) : Integer;



Function IsPM       : Boolean;
Function TodayDay   : byte;
Function TodayMonth : byte;
Function TodayYear  : Word;
Function TodayDOW   : byte;
Function HourNow    : byte;
Function Hour12Now  : byte;
Function MinuteNow  : byte;
Function SecondNow  : byte;
Function HundredthNow:byte;

Function SecondsToday: word;
Function HundredthSecondsToday: longint;


{**********************************************************************}
Implementation
uses dos;

function IsLeapYear(y : Integer) : Boolean;
begin
     IsLeapYear:=(y mod 4 = 0) and (y mod 4000 <> 0)
               and((y mod 400 <> 0) or (y mod 100 = 0));
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function TodayDay   : byte;
var
    Y, M, D, DOW : Word;
begin
    GetDate(Y, M, D, DOW);
    TodayDay := D;
end;
{----------------------------------------------------------------------}
Function TodayMonth : byte;
var
    Y, M, D, DOW : Word;
begin
    GetDate(Y, M, D, DOW);
    TodayMonth:=M;
end;
{----------------------------------------------------------------------}
Function TodayYear  : Word;
var
    Y, M, D, DOW : Word;
begin
    GetDate(Y, M, D, DOW);
    TodayYear := Y;
end;
{----------------------------------------------------------------------}
Function TodayDOW   : byte;
var
    Y, M, D, DOW : Word;
begin
    GetDate(Y, M, D, DOW);
    TodayDow := Dow;
end;
{----------------------------------------------------------------------}
Function IsPM : Boolean;
var H, M, S, D : word;
begin
     if HourNow>=12 then IsPm:=TRUE else IsPM:=FALSE;
end;
{----------------------------------------------------------------------}
Function HourNow    : byte;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     HourNow:=H;
end;
{----------------------------------------------------------------------}
Function Hour12Now    : byte;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     If H>12 then dec(h,12);
     if H=0 then H:=12;
     Hour12Now:=H;
end;
{----------------------------------------------------------------------}
Function MinuteNow  : byte;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     MinuteNow := M;
end;
{----------------------------------------------------------------------}
Function SecondNow  : byte;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     SecondNow:=S;
end;
{----------------------------------------------------------------------}
Function HundredthNow  : byte;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     HundredthNow:=D;
end;
{----------------------------------------------------------------------}
{--                         JULIAN                                   --}
{----------------------------------------------------------------------}
function Julian (Y,M,D : Word) : LongInt; { days since 0000 }
Begin
  dec(y);
  Julian := (LongInt(Y)*365) + (Y div 4) - (Y div 100) +
               (Y div 400) + JulianDay(succ(Y),M,D);
End;

procedure J2date (J : longint; var Y,M,D : Word);
Begin
  M := 1;
  Y := (J div 365);
  D := (j mod 365);
  d := D + (J div 4) - (Y div 100) + (Y div 400);
  y := Y + ( d div 365 );
  d := d mod 365;
  while d > CdaysInMOnth[1] do begin
        dec(d,DaysInMOnth(y,m));
        inc(m);
  end
End;
{----------------------------------------------------------------------}
{--                      Days in Month                               --}
{----------------------------------------------------------------------}
Function DaysInMonth(M,Y : word) : byte;
begin
     DaysInMonth:=CdaysInMonth[M];
     if (M=2)and(IsLeapyear(Y)) then DaysInMonth:=29;
end;
{----------------------------------------------------------------------}
{--                  Julian Day                                      --}
{----------------------------------------------------------------------}
Function JulianDay(y,m,d : word) : integer;
var X : Word;
    C : Byte;
Begin
  X := 0;
  For c:= 1 to pred(m) do begin
      X := X + DaysInMonth(c,y);
  End;
  JulianDay := X + D;  (* add the days of the month *)
End;
{----------------------------------------------------------------------}
{--                    Today Julian                                  --}
{----------------------------------------------------------------------}
function TodayJulian : longint;
var
    Y, M, D, DOW : Word;
begin
    GetDate(Y, M, D, DOW);
    TodayJulian := Julian(Y,M,D);
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function SecondsToday: word;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     SecondsToday:=(H*SecondsInHour)+(M*SecondsInMinute)+S;
end;
{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function HundredthSecondsToday: longint;
var H, M, S, D : word;
begin
     GetTime(H,M,S,D);
     HundredthSecondsToday:=(((H*SecondsInHour)+(M*SecondsInMinute)+S)*100)+D;
end;

{----------------------------------------------------------------------}
{--                                                                  --}
{----------------------------------------------------------------------}
Function CalcDayOfWeek(Year, Month, Day : Integer) : Integer;
Var
  Century,
  Holder  : Integer;
begin
  { First test For error conditions on input values: }
  if (Year < 0) or (Month < 1) or (Month > 12) or (Day < 1) or (Day > 31) then
    CalcDayOfWeek := -1  { Return -1 to indicate an error }
  else
  { Do the Zeller's Congruence calculation as Zeller himself }
  { described it in "Acta Mathematica" #7, Stockhold, 1887.  }
  begin
    { First we separate out the year and the century figures: }
    Century := Year div 100;
    Year    := Year MOD 100;
    { Next we adjust the month such that March remains month #3, }
    { but that January and February are months #13 and #14,     }
    { *but of the previous year*: }
    if Month < 3 then
    begin
      Inc(Month, 12);
      if Year > 0 then
        Dec(Year, 1)      { The year before 2000 is }
      else              { 1999, not 20-1...       }
      begin
        Year := 99;
        Dec(Century);
      end;
    end;

    { Here's Zeller's seminal black magic: }
    Holder := Day;                        { Start With the day of month }
    Holder := Holder + (((Month + 1) * 26) div 10); { Calc the increment }
    Holder := Holder + Year;              { Add in the year }
    Holder := Holder + (Year div 4);      { Correct For leap years  }
    Holder := Holder + (Century div 4);   { Correct For century years }
    Holder := Holder - Century - Century; { DON'T KNOW WHY HE DID THIS! }
    {***********************KLUDGE ALERT!***************************}
    While Holder < 0 do                   { Get negative values up into }
      Inc(Holder, 7);                     { positive territory before   }
                                          { taking the MOD...         }
    Holder := Holder MOD 7;               { Divide by 7 but keep the  }
                                          { remainder rather than the }
                                          { quotient }
    {***********************KLUDGE ALERT!***************************}
    { Here we "wrap" Saturday around to be the last day: }
    if Holder = 0 then
      Holder := 7;

    { Zeller kept the Sunday = 1 origin; computer weenies prefer to }
    { start everything With 0, so here's a 20th century kludge:     }
    Dec(Holder);

    CalcDayOfWeek := Holder;  { Return the end product! }
  end;
end;


END.
