/* YEPuHTML.CMD -- Converts a YEP URL log file to a simple HTML document.
 
 - use standard redirection to write HTML file. I.E. Yepuhtml >my-new.html
 - please edit the line below to reflect the path/filename of your Log,
   or specify filename on command line. I.E. Yepuhtml url.log >my-new.html
 
*/
UrlLog = 'd:\tm\url.log'

BetweenRecords = 1;

Parse arg ln
if (ln \= '') then UrlLog = ln

ret = stream(UrlLog,'c','open read')
if ret <> 'READY:' then do
    ret=lineout('STDERR','Can not open URL Log "'UrlLog'" to read.');
    exit
end

say '<HTML><HEAD>'
say '<TITLE>Yep URL Log to HTML conversion 'date('N')', 'time('C')'</title>'
say '</HEAD>'
say '<BODY>'
say '<a name="TheBegin">J</a>ump to the <a href="#TheEnd">bottom</a> of the list.'
say '<ol>'

do while lines(UrlLog)<>0
    ln = linein(UrlLog)
    
    if (ln \= '') & (BetweenRecords = 1) then do
        say '<br><li>'
        BetweenRecords = 0;
    end

    parse var ln what it_is
    select 
        when what == '' then BetweenRecords = 1
        when what == 'URL:' then say what'  <a href="'it_is'">'it_is'</a><br>'
        when what == 'Subject:' then say what'  <strong>'it_is'</strong><br>'
        otherwise say what'  'it_is'<br>'
    end
end

say '</ol>'
say '<a name="TheEnd">J</a>ump to the <a href="#TheBegin">top</a> of the list.'
say '</BODY>'
say '</HTML>'
