; FTPBrowser Patch - Y2K formatting
; 08 Mar 2009

; Search by date fails for Y2K because
; dates passed as yy-mm-dd string and not compared with this in mind

; Build ftpbtranpatch.lst with
;   wasm ftpbtranpatch.asm
;   wdis -l -s ftpbtranpatch.obj

; Use output to prepare ftpbtranpatch.pat

; Patch with
;  lxlite -X+ -B- ftpbtran.exe
;  patch /a ftpbtranpatch.pat
;  lxlite -X- -B- ftpbtran.exe

; Packed original

; ftpbtran.exe
;  6-09-97  21:17         117,530           0  ftpbtran.exe

; 59b7a84ae53caf534b76a1cb93bb08fb *ftpbtran.exe

; Unpacked original

; ftpbtran.exe
;  6-09-97  21:17         185,335           0  ftpbtran.exe

; 90150dd69c3cb2dfe52070ebd165e568 *ftpbtran.exe

;==========================================================================

; Patch subroutines placed in available space of object 1, page 38
; after expanding page to 1000h bytes and expanding object to match
; Code located at 35920..359ff

; =========================================
; Expand object 1 from 2590c to 25a00 bytes

; From lxlite -c:exemap

; ObjTable offs:     00000144
; Page shift:               9, 1 << 9 = 200
; MapTable offs:     000001A4		(page table descriptors)
; PageData offs:     00001600

;  ##  Base  Size RWEResDisShrPreInvSwpRsdLocA1632BCnfIOP
;   1 00010000 0002590C                                         
;    Index  FileOffs  Size  Attribute 
;     00000034  00026C00  1000    Valid             follows 38 in memory
;     00000035  00027C00  0FFE    Valid   
;     00000036  00028C00  1000    Valid   
;     00000037  00029C00  1000    Valid   
;     00000038  00026200  090C    Valid             slack = a00 - 90c = f4

; Object 1 size in file

; 00000140  00 00 00 00  0C 59 02 00  00 00 01 00  15 20 00 00
;                        -----------
;			 00 5a 02 00

; patch 2590c -> 25a00

; ===============================================
; Expand object 1, page 38 from 90c to 1000 bytes

; object page table entry in file
; page 38 (26h), index = 25h
; 1a4 + 25 * 8 = 2cc

; 000002C0  00 10 00 00  43 01 00 00  00 10 00 00  26 01 00 00
;                                                  -----------
; 000002D0  0C 09 00 00  4B 01 00 00  42 0A 00 00  00 00 00 00
;           -----------
;           00 0a 00 00

; patch 90c -> 1000

; object 1 page 38 in file
; offset = 126
; size = 90c
; flags = 0

; 126 * 1 << 9 = 24c00
; page base 24c00 + 1600 = 26200

;=======================================================================

;	TITLE   ftpbrowser patch
	.586p
_TEXT	SEGMENT  BYTE PUBLIC USE32 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  DWORD PUBLIC USE32 'DATA'
_DATA	ENDS
CONST	SEGMENT  DWORD PUBLIC USE32 'CONST'
CONST	ENDS
_BSS	SEGMENT  DWORD PUBLIC USE32 'BSS'
_BSS	ENDS

DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME DS: DGROUP, SS: DGROUP

_TEXT      SEGMENT
	ASSUME	CS: _TEXT

	PUBLIC	_Patch
Patch PROC NEAR
	ASSUME DS: DGROUP
	ASSUME CS: Patch

Zero:

;=================================================================
; Patch_1 @ 10F3F - call Y2K compliant date compare (Tools->Search)

; patch location in file

; page = (10f3f - 10000) / 1000 + 1 = 1
; offset = f3f

;    Index  FileOffs  Size  Attribute 
;     00000001  00005200  1000    Valid   

; 5200 + F3F = 613F

; originally

; 10F3F 8B CA  mov     ecx, edx
; 10F41 33 C0  xor     eax, eax
; 10F43 F3 A6  rep cmpsb

; patch

	; org 10F3Fh
	db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 3fh - ($ - Zero) and 0ffh dup (90h)	; align

	call	$ + 35910h - 10f3fh		; Patch_12
	nop

; from wdis, 3f -> 10f3f

; 3F E8 CC 49 02 00  call        0x00024a10
; 44 90              nop

; at load address

; 10F3F E8 CC 49 02 00  call        0x00024a10
; 10F44 90              nop

;=====================================================
; Patch_2 @ 10F50 - skip only if older (Tools->Search)

; patch location in file

; page = (10f50 - 10000) / 1000 + 1 = 1
; offset = f50

;    Index  FileOffs  Size  Attribute 
;     00000001  00005200  1000    Valid   

; 5200 + F50 = 6150

; originally

; 10F50 0F 8E 2B 02 00 00	jle     skip_11181      ; skip if file older or same

; patch

	; org	10f50h
	db 50h - ($ - Zero) and 0ffh dup (90h)	; align

	jl	$ + 11181h - 10f50h

; from wdis, 50 -> 10f50

; 50    0F 8C 2B 02 00 00         jl          0x00000281

; at load address

; 10F50   0F 8C 2B 02 00 00         jl          0x00000281

;===============================================================
; Patch_3 @ 11F42 - call Y2K compliant date compare (Local->Sync)

; patch location in file

; page = (11f42 - 10000) / 1000 + 1 = 2
; offset = f42

;    Index  FileOffs  Size  Attribute 
;     00000002  00006200  1000    Valid   

; 6200 + F42 = 7142

; originally

; 11F42 8B CA                 mov     ecx, edx
; 11F44 33 C0                 xor     eax, eax
; 11F46 F3 A6                 rep cmpsb
; 11F48

	; org 11f42h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 42h - ($ - Zero) and 0ffh dup (90h)	; align

	call	$ + 35910h - 11f42h		; Patch_12
	nop

; from wdis, 142 -> 11f42

; 142 E8 C9 39 02 00            call        0x00023b10
; 147 90                        nop

;=========================================================
; Patch_4 @ 11F53 - include if same or newer (Local->Sync)

; patch location in file

; page = (11f53 - 10000) / 1000 + 1 = 2
; offset = f53

;    Index  FileOffs  Size  Attribute 
;     00000002  00006200  1000    Valid   

; 6200 + F53 = 7153

; originally

; 11F53 7C 49 jl      short is_last?_11F9E; if before?

	; org	11f53h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 53h - ($ - Zero) and 0ffh dup (90h)	; align

	jle	short $ + 11f9eh - 11f53h	; if before or same

; from wdis, 153 -> 11f53

; 153    7E 49                     jle         L$1

;=================================================================
; Patch_4x @ 1219D - Y2K compliant file date convert (Local->Sync)

; patch location in file

; page = (1219Dh - 10000) / 1000 + 1 = 3
; offset = 19D
;   1 00010000 0002590C                                         
;    Index  FileOffs  Size  Attribute 
;     00000003  00007200  1000    Valid   

; 7200 + 19d = 739d

; Originally

; 1219D 8A 84 24 A8 05 00 00          mov     al, [esp+5A8h]  ; day
; 121A4 83 E0 1F                      and     eax, 1Fh
; 121A7 50                            push    eax
; 121A8 66 8B 84 24 AC 05 00 00       mov     ax, [esp+5ACh] ; month
; 121B0 25 FF 01 00 00                and     eax, 1FFh
; 121B5 C1 E8 05                      shr     eax, 5
; 121B8 50                            push    eax
; 121B9 8A 84 24 B1 05 00 00          mov     al, [esp+5B1h] ; year
; 121C0 25 FF 00 00 00                and     eax, 0FFh
; 121C5 D1 E8                         shr     eax, 1
; 121C7 83 C0 50                      add     eax, 80
; 121CA 50                            push    eax
; 121CB

; CB - 9D = 2E = 46t bytes

	; org	1219Dh
	db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 9dh - ($ - Zero) and 0ffh dup (90h)	; align

	; OK to kill ecx
	mov     eax, [esp+5A8h]   ; FDATE
	mov	ecx, eax
	and     ecx, 1Fh
	push    ecx		; day
	mov     ecx, eax
	shr     ecx, 5
	and     ecx, 0Fh
	push    ecx		; month
	shr     eax, 9
	and     eax, 07Fh	; year since 1980
	add     eax, 80
	cmp	ecx, 100
	jb	@p5_a
	sub	ecx, 100
@p5_a:
	push    ecx		; day
	nop
	nop

; from wdis 29D -> 1219Dh

; 29D    8B 84 24 A8 05 00 00      mov         eax,dword ptr 0x5a8[esp]
; 2A4    8B C8                     mov         ecx,eax
; 2A6    83 E1 1F                  and         ecx,0x0000001f
; 2A9    51                        push        ecx
; 2AA    8B C8                     mov         ecx,eax
; 2AC    C1 E9 05                  shr         ecx,0x05
; 2AF    83 E1 0F                  and         ecx,0x0000000f
; 2B2    51                        push        ecx
; 2B3    C1 E8 09                  shr         eax,0x09
; 2B6    83 E0 7F                  and         eax,0x0000007f
; 2B9    83 C0 50                  add         eax,0x00000050
; 2BC    83 F9 64                  cmp         ecx,0x00000064
; 2BF    72 03                     jb          L$3
; 2C1    83 E9 64                  sub         ecx,0x00000064
; 2C4                          L$3:
; 2C4    51                        push        ecx
; 2C5    90                        nop
; 2C6    90                        nop

;==========================================================
; Patch_5 @ 125E1 - Y2K compliant date compare (Site->Sync)

; patch location in file

; page = (125E1 - 10000) / 1000 + 1 = 3
; offset = 5E1

;    Index  FileOffs  Size  Attribute 
;     00000003  00007200  1000    Valid   

; 7200 + 5E1 = 77E1

; originally

; 125E1 2B FE                                sub     edi, esi
; 125E3 8B CF                                mov     ecx, edi
; 125E5 8D BC 24 24 03 00 00                 lea     edi, [esp+324h]
; 125EC 33 C0                                xor     eax, eax
; 125EE F3 A6                                rep cmpsb
; 125F0

	; org	125e1h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db (0e1h - ($ - Zero)) and 0ffh dup (90h)	; align
Patch_5:
	lea     eax, [esp+324h]

	call	$ + 35930h - (125e1h + ($ - Patch_5))	; Patch_13
	nop
	nop

; from wdis, 1e1 -> 125e1

; 1E1    8D 84 24 24 03 00 00      lea         eax,0x324[esp]
; 1E8    E8 43 33 02 00            call        0x00023530
; 1ED    90                        nop
; 1EE    90                        nop
; 1EF    90			   nop

;========================================================
; Patch_6 @ 125FF - include if newer or same (Site->Sync)

; patch location in file

; page = (125FF - 10000) / 1000 + 1 = 3
; offset = 5FF

;    Index  FileOffs  Size  Attribute 
;     00000003  00007200  1000    Valid   

; 7200 + 5FF = 77FF

; originally

; 125FF 0F 8C 6E 00 00 00                    jl      loc_12673	; if before

	; org	125ffh
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 0ffh - ($ - Zero) and 0ffh dup (90h)	; align

	jle	$ + 12673h - 125ffh		; if before or same
	nop
	nop
	nop
	nop

; from wdis, 1ff -> 125ff

; 1FF    7E 72                     jle         0x00000273
; 201    90                        nop
; 202    90                        nop
; 203    90                        nop
; 204    90                        nop

;===============================================================
; Patch_7 @ 13115 - Y2K compliant file date convert (Site->Sync)

; patch location in file

; page = (13115h - 10000) / 1000 + 1 = 4
; offset = 115

;    Index  FileOffs  Size  Attribute 
;     00000004  00008200  1000    Valid   

; 8200 + 115 = 8315

; originally

; typedef struct _FDATE           /* fdate */
; {
;    UINT   day     : 5;		; bit 0
;    UINT   month   : 4;
;    UINT   year    : 7;
; } FDATE;

; 13115 8A 94 24 94 03 00 00                    mov     dl, [esp+394h]  ; FDATE
; 1311C 89 5C 24 14                             mov     [esp+14h], ebx
; 13120 83 E2 1F                                and     edx, 1Fh        ; day
; 13123 52                                      push    edx
; 13124 8B DD                                   mov     ebx, ebp	; sync date
; 13126 66 8B 94 24 98 03 00 00                 mov     dx, [esp+398h]  ; month
; 1312E 81 E2 FF 01 00 00                       and     edx, 1FFh
; 13134 C1 EA 05                                shr     edx, 5
; 13137 52                                      push    edx
; 13138 8A 94 24 9D 03 00 00                    mov     dl, [esp+39Dh]  ; year
; 1313F 81 E2 FF 00 00 00                       and     edx, 0FFh
; 13145 D1 EA                                   shr     edx, 1
; 13147 83 C2 50                                add     edx, 80
; 1314A 52                                      push    edx
; 1314B

; 4B - 15 = 36 = 54t bytes

	; org	13115h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 15h - ($ - Zero) and 0ffh dup (90h)	; align

	; OK to kill eax
	mov     eax, [esp+394h]   ; FDATE
	mov	edx, eax
	and     edx, 1Fh
	push    edx		; day
	mov     edx, eax
	shr     edx, 5
	and     edx, 0Fh
	push    edx		; month
	shr     eax, 9
	and     eax, 07Fh	; year since 1980
	add     eax, 80
	cmp	edx, 100
	jb	@p7_a
	sub	edx, 100
@p7_a:
	push    edx		; day
	mov	ebx, ebp
	nop
	nop
	nop

; from wdis 215 -> 13115h

; 215    8B 84 24 94 03 00 00      mov         eax,dword ptr 0x394[esp]
; 21C    8B D0                     mov         edx,eax
; 21E    83 E2 1F                  and         edx,0x0000001f
; 221    52                        push        edx
; 222    8B D0                     mov         edx,eax
; 224    C1 EA 05                  shr         edx,0x05
; 227    83 E2 0F                  and         edx,0x0000000f
; 22A    52                        push        edx
; 22B    C1 E8 09                  shr         eax,0x09
; 22E    83 E0 7F                  and         eax,0x0000007f
; 231    83 C0 50                  add         eax,0x00000050
; 234    83 FA 64                  cmp         edx,0x00000064
; 237    72 03                     jb          L$2
; 239    83 EA 64                  sub         edx,0x00000064
; 23C                          L$2:
; 23C    52                        push        edx
; 23d    8B DD                     mov         ebx, ebp
; 23F    90                        nop

;=============================================================
; Patch_7x @ 13168 - Y2K compliant date compare (Local?->Sync)

; patch location in file

; page = (13168h - 10000) / 1000 + 1 = 4
; offset = 168

;    Index  FileOffs  Size  Attribute 
;     00000004  00008200  1000    Valid   

; 8200 + 168 = 8368

; originally

; 13168 33 C9                       xor     ecx, ecx
; 1316A 33 D2                       xor     edx, edx
; 1316C
; 1316C             loc_1316C:                              ; CODE XREF: ask_
; 1316C 8A 13                       mov     dl, [ebx]
; 1316E 8A 4D 00                    mov     cl, [ebp+0]
; 13171 45                          inc     ebp
; 13172 43                          inc     ebx
; 13173 84 D2                       test    dl, dl
; 13175 74 04                       jz      short loc_1317B
; 13177 3A CA                       cmp     cl, dl
; 13179 74 F1                       jz      short loc_1316C
; 1317B
; 1317B             loc_1317B:                              ; CODE XREF: ask_
; 1317B 2B CA                       sub     ecx, edx
; 1317D 8B 5C 24 14                 mov     ebx, [esp+14h]
; 13181 85 C9                       test    ecx, ecx
; 13183 7C 35                       jl      short addtosync_131BA
; 13185

; 85 - 68 = 1d = 29t bytes

	; org	13168h
	db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 68h - ($ - Zero) and 0ffh dup (90h)	; align

Patch_7x:
	push	esi
	mov	esi, ebx
	mov	ecx, 8		; hack, cough
	call	$ + 35910h - (13168h + ($ - Patch_7x))	; Patch_12
	mov	ebx, esi
	pop	esi
	jl	$ + 131BAh - (13168h + ($ - Patch_7x))	; if older - odd design
	nop
	nop
	nop

; from wdis 0468 -> 13168h

; 468    56                        push        esi
; 469    8B F3                     mov         esi,ebx
; 46B    B9 08 00 00 00            mov         ecx,0x00000008
; 470    E8 9B 27 02 00            call        0x00022c10
; 475    8B DE                     mov         ebx,esi
; 477    5E                        pop         esi
; 478    7C 40                     jl          L$6
; 47A    90                        nop
; 47B    90                        nop
; 47C    90                        nop

;==================================================================
; Patch_8 @ 135BD - Y2K compliant file date convert  (Local?->Sync)

; patch location in file

; page = (135BD - 10000) / 1000 + 1 = 4
; offset = 5BD

;    Index  FileOffs  Size  Attribute 
;     00000004  00008200  1000    Valid   

; 8200 + 5BD = 87BD

; originally

; 135BD 8A 94 24 94 03 00 00                    mov     dl, [esp+394h]  ; day
; 135C4 83 E2 1F                                and     edx, 1Fh
; 135C7 52                                      push    edx
; 135C8 66 8B 94 24 98 03 00 00                 mov     dx, [esp+398h]  ; mon
; 135D0 81 E2 FF 01 00 00                       and     edx, 1FFh
; 135D6 C1 EA 05                                shr     edx, 5
; 135D9 52                                      push    edx
; 135DA 8A 94 24 9D 03 00 00                    mov     dl, [esp+39Dh]  ; year
; 135E1 81 E2 FF 00 00 00                       and     edx, 0FFh
; 135E7 D1 EA                                   shr     edx, 1
; 135E9 83 C2 50                                add     edx, 80
; 135EC 52                                      push    edx
; 135ED

; ED - BD = 30 = 48t bytes

	; org	135BDh
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 0BDh - ($ - Zero) and 0ffh dup (90h)	; align

	; OK to kill eax
	mov     eax, [esp+394h]   ; FDATE
	mov	edx, eax
	and     edx, 1Fh
	push    edx		; day
	mov     edx, eax
	shr     edx, 5
	and     edx, 0Fh
	push    edx		; month
	shr     eax, 9
	and     eax, 07Fh	; year since 1980
	add     eax, 80
	cmp	edx, 100
	jb	@p8_a
	sub	edx, 100
@p8_a:
	push    edx		; day
	nop
	nop

; from wdis, 2bd -> 135BD

; 2BD    8B 84 24 94 03 00 00      mov         eax,dword ptr 0x394[esp]
; 2C4    8B D0                     mov         edx,eax
; 2C6    83 E2 1F                  and         edx,0x0000001f
; 2C9    52                        push        edx
; 2CA    8B D0                     mov         edx,eax
; 2CC    C1 EA 05                  shr         edx,0x05
; 2CF    83 E2 0F                  and         edx,0x0000000f
; 2D2    52                        push        edx
; 2D3    C1 E8 09                  shr         eax,0x09
; 2D6    83 E0 7F                  and         eax,0x0000007f
; 2D9    83 C0 50                  add         eax,0x00000050
; 2DC    83 FA 64                  cmp         edx,0x00000064
; 2DF    72 03                     jb          L$5
; 2E1    83 EA 64                  sub         edx,0x00000064
; 2E4                          L$5:
; 2E4    52                        push        edx
; 2E5    90                        nop
; 2E6    90                        nop

;============================================================
; Patch_9 @ 13608 - Y2K compliant date compare (Local?->Sync)

; patch location in file

; page = (13608h - 10000) / 1000 + 1 = 4
; offset = 608

;    Index  FileOffs  Size  Attribute 
;     00000004  00008200  1000    Valid   

; 8200 + 608 = 8808

; originally

; 13608 33 C9                             xor     ecx, ecx
; 1360A 33 C0                             xor     eax, eax
; 1360C
; 1360C                   loc_1360C:                              ; CODE XREF
; 1360C 8A 0A                             mov     cl, [edx]
; 1360E 8A 07                             mov     al, [edi]
; 13610 42                                inc     edx
; 13611 47                                inc     edi
; 13612 84 C0                             test    al, al
; 13614 74 04                             jz      short cmp_1361A
; 13616 3A C8                             cmp     cl, al
; 13618 74 F2                             jz      short loc_1360C
; 1361A
; 1361A                   cmp_1361A:                              ; CODE XREF
; 1361A 2B C8                             sub     ecx, eax
; 1361C 85 C9                             test    ecx, ecx
; 1361E 0F 8C 9C 00 00 00                 jl      next_136C0
; 13624

; 24 - 08 = 1c = 28t bytes

	; org	13608h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 8h - ($ - Zero) and 0ffh dup (90h)	; align

Patch_9:
	push	esi
	mov	esi, edx
	mov	ecx, 8		; hack, cough
	call	$ + 35910h - (13608h + ($ - Patch_9))	; Patch_12
	mov	edx, esi
	pop	esi
	jle	$ + 136C0h - (13608h + ($ - Patch_9))	; if older or same
	nop
	nop
	nop

; from wdis, 308 -> 13608h

; 308    56                        push        esi
; 309    8B F2                     mov         esi,edx
; 30B    B9 08 00 00 00            mov         ecx,0x00000008
; 310    E8 FB 22 02 00            call        0x00022610
; 315    8B D6                     mov         edx,esi
; 317    5E                        pop         esi
; 318    0F 8E A2 00 00 00         jle         L$6
; 31E    90                        nop
; 31F    90                        nop
; 320    90                        nop

;=========================================================================
; Patch_10 @ 17b08 - Y2K compliant date convert (after remote->local copy)

; patch location in file - fixme

; page = (17b08h - 10000) / 1000 + 1 = 8
; offset = b08

;    Index  FileOffs  Size  Attribute 
;     00000008  0000C200  1000    Valid   

; C200 + b08 = CD08

; originally

; 17B08 BA F9 14 05 00          mov     edx, offset adash_514F9
; 17B0D 8B 43 4C                mov     eax, [ebx+4Ch]  ; point at yy-mm-dd
; 17B10 E8 13 42 01 00          call    strstr?_2BD28
; 17B15 8B F8                   mov     edi, eax
; 17B17 47                      inc     edi             ; point at month
; 17B18 BA FB 14 05 00          mov     edx, offset adash_514FB
; 17B1D 8B C7                   mov     eax, edi
; 17B1F E8 04 42 01 00          call    strstr?_2BD28
; 17B24 40                      inc     eax             ; point at day
; 17B25 E8 52 D5 00 00          call    atoi?_2507C
; 17B2A 8A 4D E8                mov     cl, [ebp-18h]   ; fDateCreation
; 17B2D 8B D0                   mov     edx, eax
; 17B2F 80 E2 1F                and     dl, 1Fh
; 17B32 80 E1 E0                and     cl, 0E0h
; 17B35 0A CA                   or      cl, dl
; 17B37 8B C7                   mov     eax, edi
; 17B39 88 4D E8                mov     [ebp-18h], cl
; 17B3C E8 3B D5 00 00          call    atoi?_2507C     ; month
; 17B41 66 8B 4D E8             mov     cx, [ebp-18h]
; 17B45 C1 E0 05                shl     eax, 5
; 17B48 66 25 FF 01             and     ax, 1FFh
; 17B4C 66 81 E1 1F FE          and     cx, 0FE1Fh
; 17B51 66 0B C8                or      cx, ax
; 17B54 66 89 4D E8             mov     [ebp-18h], cx
; 17B58 8B 43 4C                mov     eax, [ebx+4Ch]  ; point at year
; 17B5B E8 1C D5 00 00          call    atoi?_2507C
; 17B60 8A 4D E9                mov     cl, [ebp-17h]
; 17B63 83 E8 50                sub     eax, 80
; 17B66 D1 E0                   shl     eax, 1
; 17B68 80 E1 01                and     cl, 1
; 17B6B 0A C8                   or      cl, al
; 17B6D 88 4D E9                mov     [ebp-17h], cl
; 17B70

; 70 - 08 = 68 = 104t bytes

; typedef struct _FDATE           /* fdate */
; {
;    UINT   day     : 5;		; bit 0
;    UINT   month   : 4;
;    UINT   year    : 7;
; } FDATE;

atoi	equ	2507ch		; atoi()
strstr	equ	2bd28h		; strstr()
adash	equ	514f9h		; "-"

Code_10	equ	17b08h

	; org	17b08h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 8h - ($ - Zero) and 0ffh dup (90h)	; align

Patch_10:
	; use ebx, edi

	mov	edi, [ebx+4Ch]		; point at yy-mm-dd
	mov	eax, edi
	; call	atoi?_2507C		; year
	call	$ + atoi - (Code_10 + ($ - Patch_10))
	cmp	eax, 80
	jae	@p11_1
	add	eax, 100
@p11_1:
	sub	eax, 80			; relative to 1980
	shl	eax, 9
	mov	ebx, eax
	mov	eax, edi
	; mov	edx, offset adash_514F9
	mov	edx, adash
	; call	strstr?_2BD28		; find dash
	call	$ + strstr - (Code_10 + ($ - Patch_10))
	inc	eax			; point at month
	mov	edi, eax
	; call	atoi?_2507C		; month
	call	$ + atoi - (Code_10 + ($ - Patch_10))
	shl	eax, 5
	or	ebx, eax
	mov	eax, edi
	; mov	edx, offset adash_514F9
	mov	edx, adash
	; call	strstr?_2BD28		; find dash
	call	$ + strstr - (Code_10 + ($ - Patch_10))
	inc	eax			; point at day
	; call	atoi?_2507C		; day
	call	$ + atoi - (Code_10 + ($ - Patch_10))
	or	eax, ebx
	mov	[ebp-18h], ax		; fDateCreation

	mov	ebx, [ebp+8]		; restore ebx

; from wdis, 608 -> 17b08

; 0608    8B 7B 4C                  mov         edi,dword ptr 0x4c[ebx]
; 060B    8B C7                     mov         eax,edi
;	     060E		; The label referred to here is an undefined location
; 060D    E8 6A D5 00 00            call        0x0000db7c
; 0612    83 F8 50                  cmp         eax,0x00000050
; 0615    73 03                     jae         L$9
; 0617    83 C0 64                  add         eax,0x00000064
; 061A                          L$9:
; 061A    83 E8 50                  sub         eax,0x00000050
; 061D    C1 E0 09                  shl         eax,0x09
; 0620    8B D8                     mov         ebx,eax
; 0622    8B C7                     mov         eax,edi
; 0624    BA F9 14 05 00            mov         edx,0x000514f9
;	     062A		; The label referred to here is an undefined location
; 0629    E8 FA 41 01 00            call        0x00014828
; 062E    40                        inc         eax
; 062F    8B F8                     mov         edi,eax
;	     0632		; The label referred to here is an undefined location
; 0631    E8 46 D5 00 00            call        0x0000db7c
; 0636    C1 E0 05                  shl         eax,0x05
; 0639    0B D8                     or          ebx,eax
; 063B    8B C7                     mov         eax,edi
; 063D    BA F9 14 05 00            mov         edx,0x000514f9
;	     0643		; The label referred to here is an undefined location
; 0642    E8 E1 41 01 00            call        0x00014828
; 0647    40                        inc         eax
;	     0649		; The label referred to here is an undefined location
; 0648    E8 2F D5 00 00            call        0x0000db7c
; 064D    0B C3                     or          eax,ebx
; 064F    66 89 45 E8               mov         word ptr -0x18[ebp],ax
; 0653    8B 5D 08                  mov         ebx,dword ptr 0x8[ebp]
; 0656    90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 ................

;======================================
; Patch_12 @ 35910 - Y2K compare helper

; patch location in file

; page = (35910 - 10000) / 1000 + 1 = 25h + 1 = 38t

;    Index  FileOffs  Size  Attribute 
;     00000038  00026200  090C    Valid             slack = a00 - 90c = f4

; 26200 + 910 = 26b10

; orginally zeros

; patch
	; org 35910h
	db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 10h - ($ - Zero) and 0ffh dup (90h)	; align
Patch_12:
	mov	ecx, edx
	xor	eax, eax
	push    eax

	mov     al, 0[esi]
	cmp     al, '8'
	jge     @p12_a
	add     al, 10h
@p12_a:
	mov     ah, al
	mov     al, 0[edi]
	cmp     al, '8'
	jge     @p12_b
	add     al, 10h
@p12_b:
	cmp     ah, al
	pop     eax
	jnz     @p12_c
	repe cmpsb
@p12_c:
	retn

; from wdis, 410 -> 35910

; 410    8B CA             mov         ecx,edx
; 412    33 C0             xor         eax,eax
; 414    50                push        eax
; 415    8A 06             mov         al,byte ptr [esi]
; 417    3C 38             cmp         al,0x38
; 419    7D 02             jge         L$1
; 41B    04 10             add         al,0x10
; 41D                  L$1:
; 41D    8A E0             mov         ah,al
; 41F    8A 07             mov         al,byte ptr [edi]
; 421    3C 38             cmp         al,0x38
; 423    7D 02             jge         L$2
; 425    04 10             add         al,0x10
; 427                  L$2:
; 427    3A E0             cmp         ah,al
; 429    58                pop         eax
; 42A    75 02             jne         L$3
; 42C    F3 A6             repe cmpsb
; 42E                  L$3:
; 42E    C3                ret

;===================================
; Patch_13 @ 35930h - Patch_5 helper

; patch location in file

; page = (35930 - 10000) / 1000 + 1 = 25h + 1 = 38t

;    Index  FileOffs  Size  Attribute 
;     00000038  00026200  090C    Valid             slack = a00 - 90c = f4

; 26200 + 930 = 26b30

; orginally zeros

; patch
	; org 35930h
	; db (256 - ($ - Zero)) and 0ffh dup (90h)	; fill
	db 30h - (($ - Zero) and 0ffh) dup (90h)	; align

	sub     edi, esi
	mov     ecx, edi
	mov	edi, eax
	jmp	Patch_12

; from wdis, 230 -> 35930

; 230    2B FE                     sub         edi,esi
; 232    8B CF                     mov         ecx,edi
; 234    8B F8                     mov         edi,eax
; 236    EB D8                     jmp         L$2

if 0
endif

Patch	ENDP
_TEXT	ENDS
END
