//----------------- LIBRARYS --------------------------------------------------
#include "connwindow.h"
#include "ui_connwindow.h"
#include <QMessageBox>
//----------------- MAINWINDOW CONSTRUCTOR ------------------------------------
ConnWindow::ConnWindow(QDialog *parent) :
        QDialog(parent),
        ui(new Ui::ConnWindow),
        sNet(new SimpleNetwork),
        oWin(new OptionWindow),
        iWin(new InfoWindow),
        server(new QTcpServer),
        wanIp("pending..."),
        http(NULL)
{
    ui->setupUi(this);
    translate();

    ui->cb_ipAdress->lineEdit()->setInputMask("000.000.000.000; ");
    ui->cb_ipAdress->lineEdit()->setText("127.0.0.1");
    ui->le_publicAddress->setText( getWanIp() );
    ui->le_localAddress->setText( sNet->getLocalAddress() );

    // ~~~~~  determining saved ips ~~~~~~~~~~~~~~~~~~~~~~~~~~~
    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()), QSettings::IniFormat);
    for( int i = 9; i >= 0; i-- )
    {
        QString tmp = settings.value( tr("ipaddr/%1").arg(i), "" ).toString();

        if( !tmp.isEmpty() )
            ui->cb_ipAdress->addItem(tmp);
    }
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // moves the window to the center of the screen
    this->move( (QApplication::desktop()->width() / 2) - (this->width()/2)-230,
                (QApplication::desktop()->height() / 2) - (this->height() / 2) );

    // delimits the port number to a valid value
    validator = new QIntValidator(1024, 65535, this);
    ui->le_portC->setValidator(validator);
    ui->le_portS->setValidator(validator);

    // window basics
    this->setFixedWidth(436);
    ui->l_statusbar->setText( tr("Start a server or connect to a peer!") );

    // creates signal slot connections
    signalSlots();
}

void ConnWindow::translate()
{
    ui->retranslateUi(this);
}

ConnWindow::~ConnWindow()
{
    delete ui;
    delete oWin;
    delete iWin;
    delete server;
    delete validator;
    delete http;
    delete byteArray;
    delete buffer;
}

void ConnWindow::signalSlots()
{
    //if connection succesfully established
    connect(sNet, SIGNAL(emitSuccessfullyConnected()),
            this, SLOT( successfullyConnected()));
    //if network error occoured
    connect(sNet, SIGNAL(emitNetworkErrorOccured(QAbstractSocket::SocketError)),
            this, SLOT (connectionFailed()));

    connect(&bCast, SIGNAL(emitServerLocated(QString)),
            this, SLOT(serverLocated(QString)) );

    connect(server, SIGNAL(newConnection()),
            this, SLOT(connected()));

    connect(oWin, SIGNAL(emitRestart()),
            this, SLOT(restart()));
}

void ConnWindow::closeEvent(QCloseEvent* e)
{
    this->done(1);    // exit by the windows "X"
}
//----------------- OPEN - OPTION WINDOW --------------------------------------
void ConnWindow::on_pb_options_clicked()
{
    oWin->open();                   // shows the OptionWindow
}
//----------------- OPEN - INFO WINDOW ----------------------------------------
void ConnWindow::on_pb_about_clicked()
{
    iWin->open();                   // shows the InfoWindow
}

/*************************************************************************
========================[ SLOTS ]=========================================
*************************************************************************/

//----------------- PORT - LINEEDIT -------------------------------------------
void ConnWindow::on_le_portC_textChanged(QString )
{
    ui->pb_server->setText( tr("Start Server") );      // auto stop server on text change
    server->close();
    ui->l_statusbar->setText( tr("Start a server or connect to a peer!") );

    ui->le_portS->setText(ui->le_portC->text());  // auto equalize the server-port-line-edit-field
    ui->pb_serverlist->setText( tr("Show Server on Port %1").arg(ui->le_portC->text()) );
}

void ConnWindow::on_le_portS_textChanged(QString )
{
    ui->pb_server->setText( tr("Start Server") );      // auto stop server on text change
    server->close();
    ui->l_statusbar->setText( tr("Start a server or connect to a peer!") );
    ui->pb_connect->setEnabled(1);

    ui->le_portC->setText(ui->le_portS->text());    // auto equalize the client-port-line-edit-field
    ui->pb_serverlist->setText( tr("Show Server on Port %1").arg(ui->le_portS->text()) );
}

//----------------- OPEN - CLOSE - SERVERLIST ---------------------------------
void ConnWindow::on_pb_open_clicked()
{
    this->setFixedWidth(666);   // opens the server-list
    this->move(this->x()-130,this->y());
    ui->pb_open->hide();
}
void ConnWindow::successfullyConnected()
{
    // ~~~~~ Save addresses ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()), QSettings::IniFormat);

    QString addr;

    if( ui->rb_ipAddress->isChecked() )
        addr = "ipaddr";
    else
        addr = "naddr";

    // looking for empty entries
    for( int i = 0; i < 10; i++ )
    {
        QString tmp = settings.value( tr("%1/%2").arg(addr).arg(i), "" ).toString();

        if( tmp.isEmpty() )
        {
            // delete duplicates
            for( int k = 0; k < 9; k++ )
            {
                QString tmp = settings.value( tr("%1/%2").arg(addr).arg(k), "" ).toString();

                if( tmp == ui->cb_ipAdress->lineEdit()->text() )
                    settings.setValue( tr("%1/%2").arg(addr).arg(k), "" );
            }

            settings.setValue( tr("%1/%2").arg(addr).arg(i), ui->cb_ipAdress->lineEdit()->text() );

            this->done(0);      // closes the ConnectionWindow and opens the MainWindow

            return;
        }
    }

    // reorder addreses
    for( int i = 0; i < 10; i++ )
    {
        QString tmp = settings.value( tr("%1/%2").arg(addr).arg(i + 1), "" ).toString();

        settings.setValue( tr("%1/%2").arg(addr).arg(i), tmp );
    }

    settings.setValue( tr("%1/%2").arg(addr).arg(9), ui->cb_ipAdress->lineEdit()->text() );

    // delete duplicates
    for( int i = 0; i < 9; i++ )
    {
        QString tmp = settings.value( tr("%1/%2").arg(addr).arg(i), "" ).toString();

        if( tmp == ui->cb_ipAdress->lineEdit()->text() )
            settings.setValue( tr("%1/%2").arg(addr).arg(i), "" );
    }
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    this->done(0);      // closes the ConnectionWindow and opens the MainWindow
}
void ConnWindow::on_pb_close_clicked()
{
    this->setFixedWidth(436);   // closes the server-list
    this->move(this->x()+130,this->y());
    ui->pb_open->show();
}

//----------------- EXIT ------------------------------------------------------
void ConnWindow::on_pb_exit_clicked()
{
    exit(0);
}

void ConnWindow::restart()
{
    QProcess::startDetached( "\"" + QApplication::applicationFilePath() + "\"" );
    exit(0);
}

void ConnWindow::connectionFailed()
{
    ui->l_statusbar->setText("Connection failed!!!");
}
//----------------- CONNECTED-Method ------------------------------------------
void ConnWindow::connected()
{
    delete sNet;
    sNet = new SimpleNetwork(server->nextPendingConnection());  // renew the object of simplenetwork

    signalSlots();

    this->done(0);
}
//----------------- SERVER-Clicked---------------------------------------------
void ConnWindow::on_pb_server_clicked()
{
    if( ui->le_portS->text().toInt() < 1024 )
    {
        QMessageBox::information( 0, "Important", "The local port must be over 1024!");
        return;
    }

    // if server allready open -> close server
    if( server->isListening() )
    {
        ui->pb_server->setText( tr("Start Server") );
        server->close();
        ui->l_statusbar->setText( tr("Start a server or connect to a peer!") );
        ui->pb_connect->setDisabled(false);
        bCast.stopBroadcast();
    }

    else
    {
        // server will be started with port of the server-line-edit-field
        if( !server->listen( QHostAddress::Any,ui->le_portS->text().toInt()) )
        {
            QMessageBox::warning(0, "Problem detected", server->errorString() );
            return;
        }

        ui->pb_server->setText("Stop Server");
        ui->pb_connect->setDisabled(true);
        ui->l_statusbar->setText( tr("Server is open on Port: %1").arg(server->serverPort()) );
        bCast.startBroadcast( ui->le_portS->text().toInt() );
    }
}
//----------------- CONNECT-Clicked -------------------------------------------
void ConnWindow::on_pb_connect_clicked()
{
    ui->l_statusbar->setText("Connect to Server...");
    QCoreApplication::processEvents(); qApp->processEvents();

    // connection will be established
    if( !sNet->connectToServer( ui->cb_ipAdress->currentText(), ui->le_portC->text().toInt()) )
       ui->l_statusbar->setText("Connection failed!");
}

// ==[ is triggered by GUI,
//     -> broadcasts the lan ]==
void ConnWindow::on_pb_serverlist_clicked()
{
    if( ui->pb_serverlist->isChecked() )
    {
        ui->lw_serverlist->clear();
        ui->pb_serverlist->setText( tr("Searching on port %1").arg(ui->le_portC->text()) );
        ui->l_statusbar->setText( tr("Searching for server on port %1").arg(ui->le_portC->text()) );
        bCast.searchAvailableServer( ui->le_portC->text().toInt() );
    }

    else
    {
        ui->pb_serverlist->setText( tr("Show Server on Port %1").arg(ui->le_portC->text()) );
        ui->l_statusbar->setText( tr("Start a server or connect to a peer!") );
        bCast.stopSearch();
    }
}

// ==[ is triggered by bCast,
//     -> receives an available server ]==
void ConnWindow::serverLocated(QString srvName)
{
    // if the name already exists
    for( int i = 0; i < ui->lw_serverlist->count(); i++ )
        if( ui->lw_serverlist->item(i)->text() == srvName )
            return;

    ui->lw_serverlist->addItem(srvName);
}

// ==[ is triggered by GUI,
//     -> gets the current clicked item name ]==
void ConnWindow::on_lw_serverlist_itemClicked(QListWidgetItem* item)
{
    QString ipName = item->text();
    QString ip = ipName.remove( ipName.left(ipName.indexOf('@') + 1) );

    ui->cb_ipAdress->lineEdit()->setText(ip);
}

// ==[ is triggered by GUI,
//     -> gets the current double clicked item name and establishes a connection" ]==
void ConnWindow::on_lw_serverlist_itemDoubleClicked(QListWidgetItem* item)
{
    QString ipName = item->text();
    QString ip = ipName.remove( ipName.left(ipName.indexOf('@') + 1) );

    ui->cb_ipAdress->lineEdit()->setText(ip);

    on_pb_connect_clicked();
}

void ConnWindow::on_rb_nameAddress_clicked()
{
    ui->cb_ipAdress->clear();
    ui->cb_ipAdress->lineEdit()->setText("localhost");
    ui->cb_ipAdress->lineEdit()->setInputMask("");

    // ~~~~~  determining saved name addr ~~~~~~~~~~~~~~~~~~~~~~~~~~~
    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()), QSettings::IniFormat);
    for( int i = 9; i >= 0; i-- )
    {
        QString tmp = settings.value( tr("naddr/%1").arg(i), "" ).toString();

        if( !tmp.isEmpty() )
            ui->cb_ipAdress->addItem(tmp);
    }
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}

void ConnWindow::on_rb_ipAddress_clicked()
{
    ui->cb_ipAdress->clear();
    ui->cb_ipAdress->lineEdit()->setText("127.0.0.1");
    ui->cb_ipAdress->lineEdit()->setInputMask("000.000.000.000; ");

    // ~~~~~  determining saved name addr ~~~~~~~~~~~~~~~~~~~~~~~~~~~
    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()), QSettings::IniFormat);
    for( int i = 9; i >= 0; i-- )
    {
        QString tmp = settings.value( tr("ipaddr/%1").arg(i), "" ).toString();

        if( !tmp.isEmpty() )
            ui->cb_ipAdress->addItem(tmp);
    }
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}

QString& ConnWindow::getWanIp()
{
    if( wanIp != "pending..." )
        return wanIp;

    if( http == NULL )
    {
        QUrl url("http://neroniuos.bplaced.net/qtcumber/php/getip.php");

        http = new QHttp;

        byteArray = new QByteArray;
        buffer = new QBuffer(byteArray);

        buffer->open(QIODevice::WriteOnly);

        http->setHost(url.host(), 80);
        http->get(url.path(), buffer);

        connect( http, SIGNAL(requestFinished(int,bool)),
                 this, SLOT(httpRequestFinished(int,bool)) );

        return wanIp;
    }


    if( wanIp == "pending..." )
        return wanIp;

    return wanIp = "na";
}

void ConnWindow::httpRequestFinished(int requestId, bool error)
{
    if( byteArray->count() <= 0 )
    {
        ui->le_publicAddress->setText("na");

        return;
    }

    QString str(*byteArray);

    wanIp = str;

    QHostAddress add;
    if( add.setAddress(wanIp) )
        ui->le_publicAddress->setText(wanIp);
}

void ConnWindow::on_pb_help_clicked()
{
    QMessageBox::information( 0, "Port", tr("In case of an internet connection, be sure that the port is open on your router!") );
}
