#ifndef FILEHANDLER_H
#define FILEHANDLER_H

#include <QString>
#include <QStringList>
#include <QFile>
#include <QDir>

class FileHandler
{

public:
    FileHandler();
    ~FileHandler();
    static QString cutFilePath(const QString& path);
    QStringList& getFiles(const QString& path);
    QStringList& getFolders(const QString& path);
    QStringList& getFoldersFiles(const QString& path);
    QString& getAbsolutePath();
    void setFileList(QStringList fileList);
    QStringList& getFileList();
    qint64 getTotalFileSize();
    QFile* getNextFile();

private:
    void recursiveDirectory(const QString& path);
    void recursiveFile(const QString& path);
    void reset();

private:
    QStringList folderNames;
    QStringList fileNames;
    QStringList folderFileNames;
    QString absolutePath;
    QFile* file;
};

#endif // FILEHANDLER_H
