#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QFontDatabase>
#include <QDropEvent>
#include "connwindow.h"
#include "optionwindow.h"
#include "messagewindow.h"
#include "pluginterface.h"
#include "infowindow.h"
#include "filehandler.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    //initialize signal slots
    void signalSlots();

public:
    explicit MainWindow(SimpleNetwork *simpleNetwork, QWidget *parent = 0);
    ~MainWindow();
    void translate();


private:
    void request(QByteArray);
    void transmit();
    void declineRequest();
    void cancelBrowse();
    bool loadPlugin();
    void successfullTransmit();
    void receivedFile();
    void resetReceiveTransfer();


private:
    Ui::MainWindow *ui;
    ConnWindow *cWin;
    SimpleNetwork *sNet;
    OptionWindow *oWin;
    InfoWindow *iWin;
    MessageWindow *mWin;
    FileHandler fHandler;
    float totalFileSizeIn;
    float totalFileSizeOut;
    QFile *file;
    QStringList fileNames;
    QVector <PlugInterface *> plugInterface;
    QVector <QPushButton *> plugInButton;
    QWidget *currentPluginWidget;
    QTimer blinkTimer;

protected:
    void closeEvent( QCloseEvent *event );
    void dragEnterEvent(QDragEnterEvent *e);
    void dropEvent(QDropEvent *e);

private slots:
    //push button click events
    void on_pb_about_clicked();
    void on_pb_res_cancel_clicked();
    void on_pb_trans_cancel_clicked();
    void on_pb_browse_clicked();
    void on_pb_options_clicked();
    void on_pb_exit_clicked();
    //    void on_pb_close_clicked();
    //    void on_pb_open_clicked();
    void on_pb_disconnect_clicked();


private slots:
    void disconnected();
    void dataReceived(int,QByteArray);
    void fileReceived(int);
    void customPath(QString);
    void optionAccept(QString);
    void defaultPath();
    void fileProgressIn(int,qint64,qint64);
    void fileProgressOut(int,qint64,qint64);
    void downSpeed(int);
    void upSpeed(int);
    void executePlugIn();
    void requestDecline();
    void transmitTerminated(int);
    void blinker();
};

#endif // MAINWINDOW_H
