#include "messagewindow.h"
#include "ui_messagewindow.h"
#include <QMessageBox>

MessageWindow::MessageWindow(QDialog *parent) :
        QDialog(parent),
        ui(new Ui::MessageWindow)
{
    ui->setupUi(this);
    translate();
    ui->rb_save->setChecked(true);

    //moves the window to the center of the screen
    this->move( (QApplication::desktop()->width() / 2) - (this->width() / 2),
                (QApplication::desktop()->height() / 2) - (this->height() / 2) );
}

MessageWindow::~MessageWindow()
{
    delete ui;
}

void MessageWindow::translate()
{
    ui->retranslateUi(this);
}

void MessageWindow::on_pb_ok_clicked()
{
    // use default path to save file
    if(ui->rb_save->isChecked())
    {
        emit emitDefaultPath();
    }

    // use custom path to save file
    else if(ui->rb_saveAt->isChecked())
    {
        QString tmpPath = QFileDialog::getExistingDirectory(0,"Save at",QDir::homePath());

        QFileInfo tmpInfo(tmpPath);
        if( !tmpInfo.isWritable() )
        {
            QMessageBox::warning( 0, "No permissions", "You have no write permissions for this directory.\n"
                                  "Please choose another one.");
            return;
        }

        if( tmpPath.isEmpty() )
            return;

        emit emitCustomPath(tmpPath);
    }

    this->close();
}

void MessageWindow::on_pb_cancel_clicked()
{
    emit emitRequestDecline();
    this->close();
}
void MessageWindow::setData(QString name, double count, double size, QString allocation)
{
    if(allocation=="file")
    {
        if( name.count() > 19 )
            this->setWindowTitle( tr("QtCumber - Save %1").arg(name.left(20) + "..." +
                                                               name.right(name.count() - name.lastIndexOf('.'))) );
        else
            this->setWindowTitle( tr("QtCumber - Save %1").arg(name) );

        if( name.count() > 30 )
            ui->l_filename->setText( name.left(26) + "..." +
                                     name.right(name.count() - name.lastIndexOf('.')) );
        else
            ui->l_filename->setText(name);

        ui->l_filecount->setText(tr("+ %1").arg(count - 1));
        ui->l_totalmb->setText(tr("%1").arg(size));
    }
    else if(allocation=="folder")
    {
        //Folder
    }

}

