/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Returns information about the currently selected project  *
 *                                                            *
 *  Last modified: 09/04/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No project loaded! Trying to load project..."/* No: try to load one */
    rc=LoadProject("")                                /* If succeeded, rc = 0 */
    IF rc <> "0" THEN DO
      say "No project loaded! Exiting ..."            /* Failed, exiting ... */
      exit
    END 
   END

  SetInfoText("Printing project information ...")     /* Set a descriptive info text */

                    /* Use the GetProjectInfo() command to list the project info */
  say "General Information:"
  say "* Project Name: " GetProjectInfo("NAME")
  IF GetProjectInfo("TYPE") <> "Picture List" THEN   /* If project is no picture list */
    say "* Full Name: " GetProjectInfo("FULLNAME")     /* print complete name */
  say "* Size: " GetProjectInfo("SIZE") " bytes"
  say "* Type: " GetProjectInfo("TYPE")", Format: " GetProjectInfo("FORMAT")
  say "* Width: " GetProjectInfo("WIDTH")", Height: " GetProjectInfo("HEIGHT")
  say "* Frames: " GetProjectInfo("FRAMES")
  say "* Timecode: " GetProjectInfo("TIMECODEMODE")

  audiomode=GetProjectInfo("AUDIOMODE")              /* Check if project has audio */
  IF audiomode <> NULL THEN DO
    say "Audio Information:"
    say "* Audio Mode: " audiomode                     /* Print audio info */
    say "* Samples per Second: " GetProjectInfo("SAMPLESPERSECOND")
    say "* Bits per Sample: " GetProjectInfo("BITSPERSAMPLE")
  END
