@echo off
cls
echo EAGLE Demo Installation
echo .

rem --- Dispatcher ----------------------------------------------------------

if "%1"=="?" goto USAGE
if "%1"=="" goto DEFAULT
if "%2"=="" goto CUSTOM_1
if "%3"=="" goto CUSTOM_2
if not "%4"=="" goto USAGE
if "%3"=="." goto CUSTOM_3
if "%3"=="\EAGLE\DEMO" goto CUSTOM_3

:USAGE
echo Usage:  a:install            for default installation
echo         b:install b:         for default installation from drive B:
echo         a:install a: d:      for default installation from drive A: to D:
echo         a:install a: d: .    to install into current directory on drive D:
goto END

rem --- Default Installation ------------------------------------------------

:DEFAULT
%0 A: C: \EAGLE\DEMO
goto END

rem --- Installation from drive %1 to C:\EAGLE\DEMO -------------------------

:CUSTOM_1
%0 %1 C: \EAGLE\DEMO
goto END

rem --- Installation from drive %1 into \EAGLE\DEMO on drive %2 -------------

:CUSTOM_2
%0 %1 %2 \EAGLE\DEMO
goto END

rem --- Installation from drive %1 into current directory on drive %2 -------

:CUSTOM_3
if not "%3"=="." echo Installing EAGLE from %1 to %2%3
if     "%3"=="." echo Installing EAGLE from %1 to
if     "%3"=="." cd %2
echo .
echo (Press Ctrl-Break to cancel - call "install ?" for installation info)
pause

if "%3"=="." goto CURRENT
md %2\EAGLE
md %2%3
:CURRENT
echo check > %2%3\CHECK
if exist %2%3\CHECK goto DIROK1
echo Cannot access directory %2%3
goto END
:DIROK1
del %2%3\CHECK
goto INSTALL

:INSTALL
if not exist %2%3\*.* goto INSTALL1
echo .
echo .
echo The destination directory is not empty.
echo If you continue the installation some of these files may be overwritten!
echo .
echo Please make sure you have a backup copy of these files or cancel
echo the installation now and create a backup copy (or install EAGLE
echo into a different directory).
echo .
echo (Press Ctrl-Break to cancel - call "install ?" for installation info)
pause

:INSTALL1
if exist %1README copy %1README %2%3 >nul
if not exist %1EAGLEDMO.EXE goto INSTALL2
%1EAGLEDMO.EXE -y %2%3\
if errorlevel 1 goto INSTFAILURE

:INSTALL2
if not exist %1EAGLELBR.EXE goto COMPLETED
%1EAGLELBR.EXE -y %2%3\
if errorlevel 1 goto INSTFAILURE

:COMPLETED
%2
cd %3
echo /* --------------- EAGLE Installation ---------------- */  > makeicon.cmd
echo dir     = directory()                                      >> makeicon.cmd
echo parm    = "%%"                                             >> makeicon.cmd
echo exefull = dir"\EAGLE.EXE"                                  >> makeicon.cmd
echo title   = "EAGLE Demo"                                 >> makeicon.cmd
echo call load                                                  >> makeicon.cmd
echo call SysCreateObject "WPProgram", title, "<WP_DESKTOP>", "EXENAME="exefull";PARAMETERS="parm";PROGTYPE=PM;STARTUPDIR="dir";", "update" >> makeicon.cmd
echo /* --- Load the function library, if necessary --- */      >> makeicon.cmd
echo load:                                                      >> makeicon.cmd
echo if \RxFuncQuery("SysLoadFuncs") then return                >> makeicon.cmd
echo call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"    >> makeicon.cmd
echo call SysLoadFuncs                                          >> makeicon.cmd
echo return                                                     >> makeicon.cmd
call makeicon.cmd
del makeicon.cmd
echo .
echo End of EAGLE Demo Installation
pause
goto END

:INSTFAILURE
echo .
echo Error during EAGLE Demo Installation
pause
goto END

:END

