#!/bin/bash

function package_and_upload()
{
    echo -e "\e[1;32m$1\e[0m"
    tar -caf $1.tar.gz $1
    
    user=mattbas6
    server=mattbas.org
    directory=public_html/knotter_plugins
    dir_string=$user@$server:$directory
    scp $1.tar.gz  $dir_string/packages/$1.tar.gz
    scp -r $1 $dir_string/plugins
    
    echo
}

for i in $*
do
    if [ -d $i -a -f $i/plugin_$i.json ]
    then
        package_and_upload $i
    fi
done

 
