/* REXX */
/* This rexx utility is for use with JVWbg*/
/* This particular example is setup for making a random lockup screen image */
/*  You will need to setup the lockup screen setting for your system to the correct */
/*  file with the MyOutputFile variable */
/*  This could be executed in your startup.cmd file for a background image and */
/*  by the alarm utility (or cron) every few hours for your lockup screen */

/* There is one optional parameter for this routine, it is "LockUp", */
/* which will cause an alternate output file to be chosen */

'@echo off'

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/*Place your directories into these variables.  These directories */
/*should hold your image files that will be used as possible inputs */
/*If you have only one directory, the simplest thing to do is */
/*place it in both variables below */
MainDirectory = "E:\images\g"
SecondDirectory = "E:\images\f"

/*Indicate the desired output file here, use a full path */
/*You should also place this file in the appropriate section */
/*of the desktop settings notebook (Background or Lockup) */
/*This is setup so that the user can call this REXX routine */
/*with a single parameter indicating which file to use and */
/*which optional JVWbg parameters shoud be used */

Parse Upper Arg param1
If param1 = "LOCKUP" Then Do
   OptionalParameters = ""
   MyOutputFile = "c:\os2\bitmap\lockup.bmp"
   End  /* Do */
Else Do
   OptionalParameters = "-s"
   MyOutputFile = "c:\os2\bitmap\background.bmp"
   End /* Do */

/*Indicate the full path to the JVWbg.exe file here */
JVWbg = "c:\image\JVWbg"

which_one = random(1, 990)   /* Seeding the random function a little */
which_one = random(3, 789)
which_one = random(6, 234)

/*Choose a directory, this example weights the odds towards one particular directory */

which_one = random(1,5)  
if which_one = 1 then
   change_direct = directory(MainDirectory)          /*put your path here */
else
   change_direct = directory(SecondDirectory)
 
/*Looking for jpegs only, change to other file format to suit your setup */
call SysFileTree "*.jpg",  "files", "F"

which_one = random(1,files.0)   /*Choose a file randomly*/
FullPath = substr(files.which_one, 38)  /*The 38 is extra info in front of file name */
drive    = filespec("drive", fullpath)
path     = filespec("path", fullpath)
fullname = filespec("name", fullpath)
dotpos   = lastpos(".", fullname)

cmd = JVWbg OptionalParameters FullPath MyOutputFile
cmd
/* You can undefine the following 2 lines to have the OS/2 window */
/* exit after the file has been created */

/*cmd = 'exit'*/
/*cmd*/

Exit
