/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* Outbound Functions                                     26 Sep 96  */
/*********************************************************************/

Parse Upper Arg Winhandle WinName OurNick Verb Parm1 Parms
Parse Arg xWinHandle xWinName xUs xVerb xParm1 xParms
Parse Upper Arg yWinHandle yWinName yOurNick yVerb yParm1 yParm2 yParm3 yParms
Parse Arg zWinHandle zWinName zOurNick zVerb zParm1 zParm2 zParm3 zParms
Parse Arg AllArgs

Pool = 'OS2ENVIRONMENT'
CMD = Value('COMSPEC',, Pool)
DataDir = Value('DataDir',, Pool)
IF ((Right(DataDir, 1) \= '\') & (DataDir \= '')) then
   Value('DataDir', DataDir'\', Pool)
CurrentList = DataDir || 'Current.Lst'
ServerList = DataDir || 'Servers.Lst'
DMIMsg = '*DMI*'
OS2Msg = '*OS2*'
ErrStr = '*[Error]*'
Version = '1.25'
Title = '-=-=-=-=-= DMI v'|| Version ||' =-=-=-=-=-'

SIGNAL ON SYNTAX
/* LineOut('C:\IRC-Out.Txt', AllArgs); LineOut('C:\IRC-Out.Txt');*/ /* For debugging */

If (Pos('/', Verb) = 0) then 
   Return 'OK'
If (Pos('/', Verb) = 1) then do        /* Check for '/' meaning a command */
   If (Verb = '/DMI') then do          /* DMI Variable Viewing/Setting */
      if (Parm1 <> '') then do
         if (Parms <> '') then do
            Value(Parm1, xParms, Pool)
            IrcRexxDisplay(DMIMsg xParm1 'set to ' || xParms || '.', WinHandle)
         end
         else do
            TempStr = Value(Parm1,,Pool)
            IrcRexxDisplay(DMIMsg xParm1 'is currently set to '||TempStr||'.', WinHandle)
         end
      end
      else IrcRexxDisplay(ErrStr "Usage: /DMI <variable> [new value]", Winhandle)
      Return ''
   end
   If (Verb = '/DW') then do
      if (Parm1 <> '') then do
         IrcRexxCommand("/WHO *" || xParm1 || "*", WinHandle)
      end
      else do
         IrcRexxDisplay(ErrStr 'Usage: /DW <Domain>', WinHandle)
      end
      Return ''
   end
   If (Verb = '/LIST') then do
      If Parm1 = '' then do
         IrcRexxDisplay(ErrStr 'Are you sure you want to list EVERY channel?', WinHandle)
         Return ''
      end
      else Return 'OK'
   end
   If (Verb = '/NAMES') then do
      If Parm1 = '' then do
         IrcRexxDisplay(ErrStr 'Are you sure you want to list everyone on IRC?', WinHandle)
         Return ''
      end
      else Return 'OK'
   end
   If (Verb = '/JOIN') then do                 /* Join handler */
      if Parm1 = '' then do
         IrcRexxDisplay(ErrStr 'Usage: /JOIN <Channel>', WinHandle)
         Return ''
      end
      else Return 'OK'
   end
   If (Verb = '/KICK') then do                 /* Kick handler */
      If Parm1 = '' then do
         IrcRexxDisplay(ErrStr 'Usage: /KICK <User> [Reason]', WinHandle)
      end
      if Parms == '' then
         IrcRexxSend('KICK' xWinName xParm1 ':DMI v' || Version, WinHandle)
      else
         IrcRexxSend('KICK' xWinName xParm1 ':' || xParms, WinHandle)
      Return ''
   end
   If (Verb == '/NOTICE') then do               /* Notice */
      if ((Parm1 == '') | (Parms == '')) then
         IrcRexxDisplay(ErrStr 'Usage: /NOTICE <User> <Text>', WinHandle)
      else do
         IrcRexxSend('NOTICE' xParm1 ':'|| xParms, WinHandle)
         IrcRexxDisplay('-> ='xParm1'=' xParms, WinHandle)
      end
      Return ''
   end
   If (Verb == '/CALC') then do
      if (Parm1 == '') then
         IrcRexxDisplay(ErrStr 'Usage: /CALC <Expression for OS2Bot to calculate>', WinHandle)
      else 
         IrcRexxSend('PRIVMSG OS2bot :CALC' xParm1 xParms, WinHandle)
      Return ''
   end
   If (Verb == '/PHONE') then do
      if (Parm1 == '') then
         IrcRexxDisplay(ErrStr 'Usage: /PHONE <Expression for OS2Bot to calculate>', WinHandle)
      else 
         IrcRexxSend('PRIVMSG OS2bot :PHONE' xParm1 xParms, WinHandle)
      Return ''
   end
   If (Verb == '/WHOIS') then do
      if Parm1 <> '' then do
         Value('GetInfo', 'ON', Pool)
         Value('CmdHandle', WinHandle, Pool)
         IrcRexxSend('WHOIS' xParm1 xParms, WinHandle)
      end
      else IrcRexxDisplay(ErrStr 'Usage: /WHOIS <User to check>', WinHandle)
      Return ''
   end
   If (Verb == '/IDLE') then do
      if Parm1 <> '' then do
         Value('GetIdle', 'ON', Pool)
         Value('IdleNick', xParm1, Pool)
         Value('CmdHandle', WinHandle, Pool)
         IrcRexxSend('WHOIS' xParm1, WinHandle)
      end
      else IrcRexxDisplay(ErrStr 'Usage: /IDLE <User to check>', WinHandle)
      Return ''
   end
   If Verb = '/HOST' then do              /* Host function (doing a HOST command) */
      if (Parm1 <> '') then do
         Address CMD 'HOST' xParm1 '|RXQUEUE'
         do Temp = 1 to Queued()
            Parse pull ThisLine
            If ThisLine = '' then iterate
            IrcRexxDisplay(OS2Msg ThisLine, WinHandle)
         end
      end
      else IrcRexxDisplay(ErrStr "Usage: /HOST <Site to look up>", WinHandle)
      Return ''
   end
   If Verb = '/OSPING' then do              /* Host function (doing a HOST command) */
      if (Parm1 <> '') then do
         Address CMD 'PING' xParm1 '25 5 |RXQUEUE'
         do Temp = 1 to Queued()
            Parse pull ThisLine
            If ThisLine = '' then iterate
            IrcRexxDisplay(OS2Msg ThisLine, WinHandle)
         end
      end
      else IrcRexxDisplay(ErrStr "Usage: /OSPING <Site to check>", WinHandle)
      Return ''
   end
   If (Verb = '/OSSEND') then do            /* OS command send function */
      if (Parm1 <> '') then do
         Address CMD xParm1 xParms '|RXQUEUE'
         do Temp = 1 to Queued()
            Parse pull ThisLine
            If ThisLine = '' then iterate
            IrcRexxSend('PRIVMSG' xWinName ':'ThisLine, WinHandle)
            IrcRexxDisplay('>' ThisLine, WinHandle)
         end
      end
      else IrcRexxDisplay(ErrStr 'Usage: /OSSEND <Command> [Parameters]', WinHandle)
      Return ''
   end
   If (Verb = '/OSMSG') then do            /* OS command send function */
      if ((Parm1 <> '') & (Parms <> '')) then do
         Address CMD xParm1 xParms '|RXQUEUE'
         do Temp = 1 to Queued()
            Parse pull ThisLine
            If ThisLine = '' then
               iterate
            IrcRexxSend('PRIVMSG' xParm1 ':'ThisLine, WinHandle)
            IrcRexxDisplay('-> *'xParm1'*' ThisLine, WinHandle)
         end
      end
      else
         IrcRexxDisplay(ErrStr 'Usage: /OSMSG <Nick> <Command> [Parameters]', WinHandle)
      Return ''
   end
   If (Verb = '/EXEC') then do            /* OS command send function */
      if (Parm1 <> '') then do
         Address CMD xParm1 xParms '|RXQUEUE'
         do Temp = 1 to Queued()
            Parse pull ThisLine
            If ThisLine = '' then iterate
            IrcRexxDisplay(OS2Msg ThisLine, WinHandle)
         end
      end
      else
         IrcRexxDisplay(ErrStr 'Usage: /EXEC <Command> [Parameters]', WinHandle)
      Return ''
   end
   If (Verb = '/CUTLOG') then do            /* OS command send function */
      if ((Pos('#', Parm1) = 1) | (Pos('&', Parm1) = 1)) then
         Address CMD 'SHORTEN' ParseName(xParm1)'.log' xParms '|RXQUEUE'
      else do
         IrcRexxCommand('/LOG OFF', WinHandle)
         Address CMD 'SHORTEN' ParseName(xWinName)'.log' xParms '|RXQUEUE'
         IrcRexxCommand('/LOG ON', WinHandle)
      end
      do Temp = 1 to Queued()
         Parse pull ThisLine
         If ThisLine = '' then iterate
         IrcRexxDisplay(OS2Msg ThisLine, WinHandle)
      end
      Return ''
   end
   If (Verb = '/WALL') then do
      if (Parm1 <> '') then do
         Value('Walling', 'ON', Pool)
         if ((Pos('#', Parm1) >= 1) | (Pos('&', Parm1) >= 1)) then do
            Value('WallMsg', '[Wall/'xParm1'] 'xParms, Pool)
            IrcRexxSend('NAMES' xParm1, WinHandle)
         end
         else do
            Value('WallMsg', '[Wall/'xWinName'] 'xParm1 xParms, Pool)
            IrcRexxSend('NAMES' xWinName, WinHandle)
         end
      end
      else IrcRexxDisplay(ErrMsg 'Usage: /WALL <Channel> <Message>', WinHandle)
      Return ''
   end
   If (Verb = '/WALLOP') then do
      if (Parm1 <> '') then do
         Value('WallOping', 'ON', Pool)
         if ((Pos('#', Parm1) >= 1) | (Pos('&', Parm1) >= 1)) then do
            Value('WallMsg', '[WallOp/'xParm1'] 'xParms, Pool)
            IrcRexxSend('NAMES' xParm1, WinHandle)
         end
         else do
            Value('WallMsg', '[Wall/'xWinName'] 'xParm1 xParms, Pool)
            IrcRexxSend('NAMES' xWinName, WinHandle)
         end
      end
      else IrcRexxDisplay(ErrMsg 'Usage: /WALLOP <Channel> <Message>', WinHandle)
      Return ''
   end
   If (Verb = '/GETSERVERS') then do        /* Split Finder routines*/
      Value('CmdHandle', WinHandle, Pool)
      Value('GetSrvr','ON',Pool)
      Value('srvrs.','',Pool)
      Value('srvrs.0','0',Pool)
      Value('cnt','0',Pool)
      IrcRexxDisplay(DMIMsg 'Getting list of active servers...(This may take a few moments)', WinHandle)
      IrcRexxSend('LINKS', WinHandle)
      Return ''
   end
   If (Verb = '/FINDSPLIT') then do
      Value('CmdHandle', WinHandle, Pool)
      Value('getcurr','ON',Pool)
      Value('currsvrs.','',Pool)
      Value('currsvrs.0','0',Pool)
      Value('currcnt','0',Pool)
      IrcRexxDisplay(DMIMsg 'Getting list of active servers...(This may take a few moments)',WinHandle)
      IrcRexxSend('LINKS', WinHandle)
      Return ''
   end
   If (Verb == '/WRITESVR') then do
      CALL library
      SysFileDelete(ServerList)
      LineOut(ServerList, '#Begin_List#', 1)
      Count = Value('cnt',,Pool)
      do s = 1 to Count
         tempword = Value('srvrs.'s,,Pool)
         LineOut(ServerList, tempword)
      end
      LineOut(ServerList)
      IrcRexxDisplay(DMIMsg Value('Cnt',, Pool) 'servers written to' ServerList, WinHandle)
      Return ''
   end
   If (Verb == '/WRITECURRSVR') then do
      CALL library
      SysFileDelete(CurrentList)
      LineOut(CurrentList, '#Begin_List#', 1)
      cnt = Value('currcnt',,Pool)
      do s = 1 to cnt
         tempword = Value('currsvrs.'s,,Pool)
         LineOut(CurrentList, tempword)
      end
      LineOut(CurrentList)
      IrcRexxDisplay(DMIMsg Value('currcnt',, Pool) 'servers written to' CurrentList, WinHandle)
      IrcRexxCommand('/SPLITTERS', WinHandle)
      Return ''
   end
   If Verb = '/SPLITTERS' then do
      IrcRexxDisplay(DMIMsg 'Looking for split servers...', WinHandle)
      LineIn(ServerList, 1, 0)
      Do While Lines(ServerList)
         tmpline = LineIn(ServerList)
         drop aresult.
         if (SysFileSearch(TmpLine, CurrentList, 'aresult.') == 0) then do
            if (aresult.0 = 0) then do
               IrcRexxDisplay(DMIMsg 'Currently split:' tmpline '', WinHandle)
            end
         end
      end
      LineOut(ServerList)
      IrcRexxCommand('/ADDNEW', WinHandle)
      Return ''
   end
   If (Verb == '/ADDNEW') then do
      IrcRexxDisplay(DMIMsg 'Looking for new servers...', WinHandle)
      Do While Lines(CurrentList)
         tmpline = LineIn(CurrentList)
         drop aresult.
         if (SysFileSearch(tmpline, ServerList, 'aresult.') = 0) then do
            if (aresult.0 = 0) then do
               IrcRexxDisplay(DMIMsg 'New server found & added: 'tmpline'', WinHandle)
               LineOut(ServerList, TmpLine)
            end
         end
      end
      LineOut(ServerList)
      LineOut(CurrentList)
      Return ''
   end
   If (Verb == '/CSTAT') then do
      Value('CmdHandle', WinHandle, Pool)
      Value('CStating','ON', Pool)
      if (Parm1 <> '') then
         Temp = xParm1
      else
         Temp = xWinName
      IrcRexxSend('NAMES' Temp, WinHandle)
      IrcRexxSend('MODE' Temp, WinHandle)
      IrcRexxSend('LIST' Temp, WinHandle)
      Return ''
   end
   If (Verb = '/RESET') then do             /* Reset Message Queue */
      hdrline = '-=-=-=-=-= DMI v'|| Version ||' Message Log =-=-=-=-=-'
      CALL Library
      MessageLog = DataDir || 'Messages.Log'
      SysFileDelete(MessageLog)
      LineOut(MessageLog, hdrline, 1)
      LineOut(MessageLog)
      IrcRexxDisplay(DMIMsg 'Message log file reset', WinHandle)
      Return ''
   end
   If (Verb == '/PLAY') then Return PlayMsg('N')   /* View the Message Queue */
   If (Verb == '/LPLAY') then Return PlayMsg('L')  /* View the Message Queue with user@host info */
   If (Verb == '/CHECK') then do                   /* Check the number of messages in the buffer */
      MessageLog = DataDir || 'Messages.Log'
      MsgLog = Value('MsgLog',,Pool)
      counter = 0
      if (MsgLog \= 'ON') then
         IrcRexxDisplay(DMIMsg 'Message log is disabled.', WinHandle)
      Do While Lines(MessageLog)
         message = LineIn(MessageLog)
         Parse Var message nick id msg
         if nick = '-=-=-=-=-=' then
            NOP
         else
            counter = counter + 1
      end
      if (counter < 1) then IrcRexxDisplay(DMIMsg 'There are no messages saved.', WinHandle)
      if (counter = 1) then IrcRexxDisplay(DMIMsg 'There is 1 message logged', WinHandle)
      if (counter > 1) then IrcRexxDisplay(DMIMsg 'There are' counter 'messages logged', WinHandle)
      LineOut(MessageLog)
      Return ''
   end
   If (Verb == '/GONE') then do              /* Set away, turn on MSG Logger */
     if (Parm1 <> '') then do
         IrcRexxSend('AWAY :('xParm1 xParms') since' Time('C') Date('U')'', WinHandle)
         IrcRexxCommand('/ALLME is gone! ('xParm1 xParms') [Recording]', WinHandle)
         Value('MsgLog', 'ON', Pool)
      end
      else do
         AwayMsg = Value('AwayMsg',,Pool)
         IrcRexxSend('AWAY :('AwayMsg') since' Time('C') Date('U')'', WinHandle)
         IrcRexxCommand('/ME is gone! ('AwayMsg') [Recording]', WinHandle)
         IrcRexxCommand('/DMI MsgLog ON', WinHandle)
      end
      Return ''
   end
   If (Verb == '/BACK') then do              /* Turn of MSG Logger, reset Away, play MSGs */
      IrcRexxCommand('/DMI MsgLog OFF', WinHandle)
      PlayMsg('N')
      IrcRexxCommand('/AWAY', WinHandle)
      IrcRexxCommand('/ALLME is back.', WinHandle)
      Return ''
   end
   If (Verb == '/ALIAS') then Return Alias(AllArgs)
   If (Verb == '/AUTO') then Return AutoMode(AllArgs)
   If (Verb = '/XDCC') then Return XDCC_Out(AllArgs)
   If (Verb = '/HELP' | Verb = '/?') then Return ViewHelp(Parm1)
   AliasList = DataDir || 'Aliases.Lst'
   do while Lines(AliasList)           /* Line isn't a normal command, check for alias */
      Fileline = LineIn(AliasList)
      if Fileline = '' then leave
      Parse Var FileLine Alias CodeLine
      If Verb = Translate(Alias) then do
         Interpret CodeLine
         Return ''
      end
   end
   Return "OK"                         /* If we got here, no command - Pass it to client */
end
Return 'OK'                            /* We should not get here, but just in case... */

PlayMsg:
   Parse Upper Arg Option
   MsgLog = Value('MsgLog',,Pool)
   MessageLog = DataDir || 'Messages.Log'
   counter = 0
   hdrline = '-=-=-=-=-= DMI v'|| Version ||' Message Log =-=-=-=-=-'
   if (MsgLog \= 'ON') then IrcRexxDisplay(DMIMsg 'Message log disabled.', WinHandle)
   Do While Lines(MessageLog)
      message = LineIn(MessageLog)
      Parse Var message nick id day mon yr times msg
      if nick = '-=-=-=-=-=' then do
         IrcRexxDisplay(hdrline, WinHandle)
      end
      else do
         counter = counter + 1
         If (Option == 'L') then
            IrcRexxDisplay(counter || ':' '*' || nick || '*' || '' id '' || day mon yr times msg, WinHandle)
         else
            IrcRexxDisplay(counter || ':' '*' || nick || '*' msg, WinHandle)
      end
   end
   LineOut(MessageLog)
   IrcRexxDisplay(hdrline, WinHandle)
Return ''

ParseName:                             /* This is a mess, but it works.    */
   Parse arg TextName
   TempName = Strip(Substr(Translate(TextName ,'','/'), 1, 8))
   Parse var TempName Temp1 Temp2 Temp3 Temp4 Temp5 Temp6 Temp7 Temp8
   TempName = Temp1||Temp2||Temp3||Temp4||Temp5||Temp6||Temp7||Temp8
Return TempName

ViewHelp:
   Parse Upper Arg TmpFile
   If (TmpFile == '') then
      HelpFile = Stream(DataDir || 'MAIN.HLP', 'C', 'QUERY EXISTS')
   else
      HelpFile = Stream(DataDir || TmpFile || '.HLP', 'C', 'QUERY EXISTS')
   If (HelpFile \= '') then do
      IrcRexxDisplay(Center(Title, 78),WinHandle)
      do while Lines(HelpFile)
         TempLine = LineIn(HelpFile)
         If (Pos('%', TempLine) = 1) then
            IrcRexxDisplay(Center(Substr(TempLine, 4), Substr(TempLine, 2, 2)), WinHandle)
         else
            IrcRexxDisplay(TempLine, WinHandle)
      end
   end
   else
      IrcRexxDisplay(ErrStr 'That is not a valid help menu!', WinHandle)
Return ''

Library:
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of DMI-Cmd.Cmd.', WinHandle);
Return ''

