/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* XDCC Functions                                         26 Sep 96  */
/*********************************************************************/

XDCC_In:
   Parse Upper Arg WinHandle OurNick Prefix Cmd Chan Nick Func Parm1 Parm2 Rest
   Parse Arg xWinHandle xOurNick xPrefix xCmd xChan xNick xFunc xParm1 xParm2 Rest

   DMIMsg = '*DMI*'
   ErrStr = '*[Error]*'
   Pool = 'OS2ENVIRONMENT'
   DataDir = Value('DataDir',, Pool)
   XDCCList = DataDir || Value('XDCCList',, Pool)
   TotalSent = Value('TotalSent',, Pool)

   SIGNAL ON SYNTAX
   TotalSize = 0
   Func = Strip(Func,, '')
   xFunc = Strip(xFunc,, '')
   Parm1 = Strip(Strip(Parm1,, ''),, '#')
   xParm1 = Strip(Strip(xParm1,, ''),, '#')
   if Parm1 <> '' then do
      IrcRexxDisplay(DMIMsg 'XDCC' xFunc Parm1 'Received from' xPrefix, WinHandle)
   end
   else do
      IrcRexxDisplay(DMIMsg 'XDCC' xFunc 'Received from' xPrefix, WinHandle)
   end
   Call GetNickId
   NotNick = 'NOTICE' FromNick ':'
   Select
      When (Func = 'LIST') then do  /* LIST command */
         LineNo = 0
         TotalSize = 0
         Call Library
         DescFile = Stream(XDCCList || '.DIZ', 'C', 'QUERY EXISTS')
         if DescFile \= '' then ExtDesc = 1
         IrcRexxSend(NotNick || 'Files offered: (/MSG' xOurNick 'XDCC SEND #N for pack N)', WinHandle)
         do while Lines(XDCCList)
            Fileline = LineIn(XDCCList)
            if Fileline = '' then leave
            LineNo = LineNo + 1
            Drop FStem.
            Parse Var Fileline FSpec FDesc
            SysFileTree(FSpec, Files., 'FO')
            If Files.0 <= 0 then do
               IrcRexxSend('NOTICE' OurNick ':Missing File on line' LineNo 'of XDCC Offer list' XDCCList'.', WinHandle)
               iterate
            End
            else do
               TempSize = 0
               Files.Size = 0
               do TempCount = 1 to Files.0
                  TempSize = Trunc((Stream(Files.TempCount, 'C', 'QUERY SIZE') / 1024), 1)
                  Files.Size = Files.Size + TempSize
               end
               if Files.Size >= 1000 then do
                  Files.Megs = TRUE
                  Files.Size = Trunc(Files.Size / 1024, 1)
               end
               if (ExtDesc = 1) then do
                  PackDesc.0 = 0
                  if ((SysFileSearch('Pack'||LineNo, DescFile, 'TempDesc.') = 0) & (TempDesc.0 > 0)) then do
                     do TempCount = 1 to TempDesc.0
                        parse var TempDesc.TempCount dummy PackDesc.TempCount
                     end
                     PackDesc.0 = TempDesc.0
                  end
               end
               if (Files.Megs == TRUE) then do
                  TotalSize = Trunc(TotalSize + (Files.Size * 1024), 0)
                  PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'M'
               end
               else do
                  TotalSize = Trunc((TotalSize + Files.Size), 0)
                  PackInfo = ''Right(Files.0, 2)':'Right(Files.Size, 5)'K'
               end
               IrcRexxSend(NotNick'#'LineNo': ['PackInfo']' FDesc, WinHandle)
               if (ExtDesc = 1) then do
                  do TempCount = 1 to PackDesc.0
                     IrcRexxSend(NotNick || '               ' PackDesc.TempCount, WinHandle)
                  end
               end
            end
         end
         IrcRexxSend(NotNick'Total Offered: 'TotalSize'K. Total Sent: 'TotalSent'K.', WinHandle);
         Return ''
      end
      When Func = 'SEND' then do   /* SEND command */
         If Parm1 = '' then do
            IrcRexxSend(NotNick || 'You didn''t include the file number. Try again.', WinHandle)
            IrcRexxSend(NotNick || '/MSG' xOurNick 'XDCC SEND #N for pack N', WinHandle)
         End
         else do
            LineNo = 0
            do while Lines(XDCCList)
               Fileline = LineIn(XDCCList)
               if Fileline = '' then iterate
               LineNo = LineNo + 1
               Drop FStem.
               Parse Var Fileline FSpec FDesc
               if LineNo = Parm1 then do
                  Call Library
                  SysFileTree(FSpec, Files., 'FO')
                  If Files.0 = 0 then do
                     IrcRexxSend('NOTICE' OurNick ':Missing File on line' LineNo 'of XDCC Offer list' XDCCList'.', WinHandle)
                     leave
                  End
                  else do
                     Files.Size = 0
                     TempSize = 0
                     do TempCount = 1 to Files.0
                        TempSize = Trunc((Stream(Files.TempCount, 'C', 'QUERY SIZE') / 1024), 0)
                        Files.Size = Files.Size + TempSize
                     end
                     FileSize = Files.Size || 'K'
                     IrcRexxSend(NotNick || 'Sending you "'FDesc'" ('FileSize').', WinHandle)
                     IrcRexxDisplay(DMIMsg 'Sending "'FDesc'"('FileSize') to 'FromNick'.', WinHandle)
                     Value('TotalSent', TotalSent + Files.Size, Pool)
                     do TempCount = 1 to Files.0
                        IrcRexxCommand('/DCC SEND' FromNick Files.TempCount, WinHandle)
                        logentry = Date('N') Time('C') Files.TempCount 'sent to' xPrefix
                        Lineout(DataDir'XDCC.Log', LogEntry)
                     end
                     Lineout(DataDir'XDCC.Log')
                     Return ''
                  end
               end
            end
            IrcRexxSend(NotNick || 'That File is not available! Range: [1..'||LineNo||']', WinHandle)
         end
         Return ''
      end
      When Func = 'HELP' then do   /* HELP routine */
         IrcRexxSend(NotNick || 'Available Commands are:', WinHandle)
         IrcRexxSend(NotNick || '/MSG' xOurNick 'XDCC LIST for a list of available files', WinHandle)
         IrcRexxSend(NotNick || '/MSG' xOurNick 'XDCC SEND #N to get pack number N', WinHandle)
         IrcRexxSend(NotNick || '/MSG' xOurNick 'XDCC HELP for help', WinHandle)
      end
      Otherwise do
         IrcRexxSend(NotNick || 'Unknown XDCC Command! Try XDCC HELP', WinHandle)
         Return ''
      end
   End
Return ''

GetNickId:
   Pos1 = Pos('!', xPrefix)
   FromNick = SubStr(xPrefix, 2, Pos1 - 2)
   FromId = SubStr(xPrefix, Pos1 + 1)
Return

library:
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of XDCC_In.Cmd.', WinHandle);
Return ''
