#include "jabber.h"

struct config etc = {NULL, NULL, NULL, "<j ", "</j>", 0};
pair *cmdtable;

int main(int argc, char *argv[])
{
	signal(SIGTERM, (void (*)())sig_die);
	signal(SIGKILL, (void (*)())sig_die);
	signal(SIGINT, (void (*)())sig_die);

	etc.arg = arg2pair(argc,argv);

	if(pair_get(etc.arg,"-D") != NULL)
		etc.debug = 1;

	DBUG("Starting Jabber Client","")

	cmdtable = pair_new(NULL,"connect",NULL,CMD_CONNECT);
	cmdtable = pair_new(cmdtable,"login",NULL,CMD_LOGIN);
	cmdtable = pair_new(cmdtable,"logout",NULL,CMD_LOGOUT);
	cmdtable = pair_new(cmdtable,"message",NULL,CMD_MESSAGE);
	cmdtable = pair_new(cmdtable,"who",NULL,CMD_WHO);
	cmdtable = pair_new(cmdtable,"w",NULL,CMD_WHO);
	cmdtable = pair_new(cmdtable,"status",NULL,CMD_STATUS);
	cmdtable = pair_new(cmdtable,"add",NULL,CMD_ADD);
	cmdtable = pair_new(cmdtable,"quit",NULL,CMD_EXIT);
	cmdtable = pair_new(cmdtable,"exit",NULL,CMD_EXIT);
	cmdtable = pair_new(cmdtable,"help",NULL,CMD_HELP);
	cmdtable = pair_new(cmdtable,"?",NULL,CMD_HELP);

	collect_packets(&dispatch);

	return 0;
}


void sig_die()
{
	DBUG("EXITING","")
	longjmp(env_io,1);
}

