#include "jabber.h"

void deliver_message(	char *from_id,
			char *from_user,
			char *to_id,
			char *to_user,
			char *subject,
			char *say,
			char *thread,
			char *ext,
			int priority)
{
	char *str = NULL;

	DBUG("Delivering Message, to",to_id)

	str = print_message(from_id,from_user,subject,say,thread,ext,priority,to_id,to_user);
	server->packets = packet_add(server->packets,str,NULL);
	free(str);
}

char *print_message(	char *from_id,
			char *from_user,
			char *subject,
			char *say,
			char *thread,
			char *ext,
			int priority,
			char *to_id,
			char *to_user)
{
	char *ret = NULL;
	char intbuff[20];

	DBUG("Printing Message","")
	ret = strgrow(ret,"<j type='message'>",1,0);
	if(to_id != NULL)
	{
		ret = strgrow(ret,"<to",1,0);
		if(to_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(to_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"</to>",1,0);
	}
	if(from_id != NULL)
	{
		ret = strgrow(ret,"<from",1,0);
		if(from_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(from_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"</from>",1,0);
	}
	if(priority != 0)
	{
		ret = strgrow(ret,"<priority>",1,0);
		sprintf(intbuff,"%d",priority);
		ret = strgrow(ret,intbuff,1,0);
		ret = strgrow(ret,"</priority>",1,0);
	}
	if(thread != NULL)
	{
		ret = strgrow(ret,"<thread>",1,0);
		ret = strgrow(ret,tag_escape(thread),1,1);
		ret = strgrow(ret,"</thread>",1,0);
	}
	if(ext != NULL)
	{
		ret = strgrow(ret,"<ext>",1,0);
		ret = strgrow(ret,ext,1,0);
		ret = strgrow(ret,"</ext>",1,0);
	}
	if(subject != NULL)
	{
		ret = strgrow(ret,"<subject>",1,0);
		ret = strgrow(ret,tag_escape(subject),1,1);
		ret = strgrow(ret,"</subject>",1,0);
	}
	if(say != NULL)
	{
		ret = strgrow(ret,"<say>",1,0);
		ret = strgrow(ret,tag_escape(say),1,1);
		ret = strgrow(ret,"</say>",1,0);
	}
	ret = strgrow(ret,"</j>",1,0);

	return ret;
}


void deliver_login(char *user, char *pass, char *nick)
{
	char *buff = NULL;

	DBUG("Delivering Login information for",user)
	buff = strgrow(buff,"<j type='login'><user>",1,0);
	buff = strgrow(buff,user,1,0);
	buff = strgrow(buff,"</user><pass>",1,0);
	buff = strgrow(buff,pass,1,0);
	buff = strgrow(buff,"</pass><nick>",1,0);
	buff = strgrow(buff,nick,1,0);
	buff = strgrow(buff,"</nick></j>",1,0);
	server->packets = packet_add(server->packets,buff,"");
	free(buff);
}

void deliver_connection()
{
	char *buff = NULL;

	DBUG("Delivering Connection information","")
	buff = strgrow(buff,"<j type='connection'><ver>",1,0);
	buff = strgrow(buff,VERSION,1,0);
	buff = strgrow(buff,"</ver><protocol>",1,0);
	buff = strgrow(buff,PROTOCOL,1,0);
	buff = strgrow(buff,"</protocol></j>",1,0);
	server->packets = packet_add(server->packets,buff,"");
	free(buff);
}


