#include "jabberbox.h"

void config_init()
{
	int nbytes, f;
	char buff[MAXMSG], *conf_data, *new, *old;
	char *config = DEFAULT_CONFIG;
	tap tp = {NULL,NULL,0};

	if(pair_getval(etc.arg,"-c") != NULL)
		config = pair_getval(etc.arg,"-c");

	DBUG("Configuring using",config)

	f = open(config,O_RDONLY);
	if(f < 0)
	{
		DBUG("Failed reading configuration file",config)
	}else{
		conf_data = malloc(1);
		conf_data[0] = '\0';
		while(1)
		{
			nbytes = read(f,buff,MAXMSG-1);
			if(nbytes <= 0)
				break;
			buff[nbytes] = '\0';
			new = malloc(nbytes + strlen(conf_data) + 1);
			strcat(new,conf_data);
			strcat(new,buff);
			old = conf_data;
			conf_data = new;
			free(old);
		}
		DBUG("Read in config file","");
		tp.h_tag = &config_handle_transports;
		tag_parse(&tp, conf_data, NULL);

		if(pair_getval(etc.transports, "jabberbox") != NULL)
		{
			tp.h_tag = &config_handle_jabberbox;
			tag_parse(&tp, pair_getval(etc.transports, "jabberbox"), NULL);
		}
	}

	if(pair_get(etc.vars, "local") == NULL)
		etc.vars = pair_new(etc.vars, "local", DEFAULT_LOCAL, 0);
	if(pair_get(etc.vars, "log") == NULL)
		etc.vars = pair_new(etc.vars, "log", DEFAULT_LOG, 0);
}

void config_handle_transports(tag *t, void *v)
{
	etc.transports = pair_new(etc.transports, t->name, t->contents, 0);
}

void config_handle_jabberbox(tag *t, void *v)
{
	etc.vars = pair_new(etc.vars, t->name, t->contents, 0);
}

