/*******************************************************************
*                                                                  *
*  MODULE : broadcast.c                                            *
*                                                                  *
*  Function: Realization of Broadcast Operations                   *
*                                                                  *
*******************************************************************/

#include "system.h"

#define WITH_HOST 1
#define NO_HOST   0 

/*******************************************************************
*                                                                  *
*  IMPORT :                                                        *
*                                                                  *
*      asend, areceive from MAILBOX                                *
*                                                                  *
*******************************************************************/

void general_broadcast (data,size,j,host_opt)

char *data;   /* pointer to the data element */
int j, size;  /* process j sends data of size bytes */
int host_opt; /* indicates participation of host    */

/*   Communication Patterns for broadcast of process j

     0    1    2    3    4    5    j    7    8    9   10  
            <----------------------
       <-   ------------------------------------->
            -----------------> 
            ------->            -------->
            ->        ->        ->        ->        ->

    if host_opt == NO_HOST, host gets no copy

*/

{ int steph, distance;
  int i, n;

  i = pcb.i;  /* number of the calling process */

  n = pcb.p;    /* total number of processes     */

  if (j!=1)   /* send value to process 1 */
    { if (i==j) asend (j,1,data,size);     /* j sends to 1 */
      if (i==1) areceive (1,j,data,size);  /* 1 recvs form j */
    }

  if ((i==0)&&(j!=0))  /* host get its result from process 1 */
    { if (host_opt == WITH_HOST)
         areceive (0,1,data,size);   /* 0 gets from 1 */
      return;
    }

  distance = 1;
  while (distance < n)    /* log n (base 2) loop */
    distance = 2*distance;

  /* send to host */

  if ((host_opt == WITH_HOST) && (i==1) && (j!=0) && (target_model == 0))
     asend (1,0,data,size);

  /* send values back to all processors */

  while (distance > 1)
    { steph = distance;
      distance = distance / 2;
      if ( ((i-1) % steph) == 0)
         { /* if i+distance exists send the new result */
           if ( (i+distance) <= n)
             asend (i,i+distance,data,size);
         }
      if ( ((i-1) % steph) == distance)
         areceive (i,i-distance,data,size);
    }

  /* now all processes have in data the broadcast value */
}

process_broadcast (data,size,j)
char *data;  /* pointer to the data element */
int j, size;  /* process j sends data of size bytes */
{ general_broadcast (data,size,j,WITH_HOST); }

/*******************************************************************
*                                                                  *
*  FORTRAN - Interface                                             *
*                                                                  *
*    dalib_broadcast (data, size, j)                               *
*      - broadcast to host and all node from process j             *
*                                                                  *
*    dalib_node_broadcast (data, size, j)                          *
*      - broadcast to host and all node from process j             *
*                                                                  *
*******************************************************************/

void dalib_broadcast__ (data,size,j)
int *data, *size, *j;
{ int pos;
  general_broadcast (data, *size, *j, WITH_HOST);
}

void dalib_node_broadcast__ (data,size,j)
int *data, *size, *j;
{ int pos;
  general_broadcast (data, *size, *j, NO_HOST);
}
