/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                    *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Aug 92                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  MAIN of HOST PROGRAM (for PVM)                                  *
*                                                                  *
*  MODULE : mhost.c                                                *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*  - enrolls host in PVM                                           *
*  - initiates node processes                                      *
*  - calls hostmodule ()                                           *
*                                                                  *
*******************************************************************/

/*******************************************************************
*                                                                  *
*  Interface to Adaptor:                                           *
*                                                                  *
*    dalib_pid ()                                                  *
*    dalib_nproc ()                                                *
*                                                                  *
*******************************************************************/

/* not needed: #include <machine/param.h> */
#include <stdio.h>
#include <string.h>
#include "system.h"
#include "pvm3.h"

int NP;          /* number of node processes */
int my_id;       /* number of my process: 0 (host), 1 .. NP */

#define INIT_MSGID 9999

#if defined(IBM)
void hostmodule ();
#else
void hostmodule_ ();
#endif

int MAIN__ (argc, argv)
int argc;
char **argv;

{ int i, j;
  int ntasks;
  int me;

  unsigned long startt;   /* start timer value */
  int htrace_flag;

  /* evaluation of parameters */

  my_id = 0;

  target_model = 0;   /* with host */

  /* enroll in PVM */

  tids[0] = pvm_mytid();

  if (tids[0] < 0)
      { /* there is an error , illegal tid */
        if (tids[0] == PvmSysErr)
            printf ("pvmd not responding\n");
          else
            printf ("illegal tid\n");
        exit (-1);
      }

  /* Get number of hosts in configuartion */

  pvm_config (&NP, (int*) 0, (struct hostinfo**) 0);
  eval_arg (NP, MAXP, &NP, &trace_flag);
  trace_flag = 0;   /* not realized yet */

  /* create node processes */

  ntasks = pvm_spawn ("node.exe", (char**)0, PvmTaskDefault, "", NP, tids+1);

  if (ntasks != NP)
     { if (ntasks < 0)
           printf ("host: pvm_spawn has error code %d\n", ntasks);
         else
           printf ("host: pvm_spawn creates only %d tasks\n", ntasks);
       exit(-1);
     }

  printf ("host has spawn %d node processes\n", NP);

  for (i=1; i<=NP; i++)
    if (tids[i] < 0)
      { pvm_perror ("spawn failure");
        pvm_exit ();
        exit(-1);
      }

  /* make initial message */

  pvm_initsend (PvmDataRaw);
  pvm_pkbyte (&NP, 4, 1);
  pvm_pkbyte (tids, (NP+1)*4, 1);
  pvm_mcast  (tids+1, NP, INIT_MSGID);

  printf ("host has send initial message\n");

  /* wait for response of nodes */

  for (i=1; i<=NP; i++)
    { pvm_recv (-1, INIT_MSGID - 1);
      pvm_upkbyte (&me, 4, 1);
      printf ("Node process %d responded\n", me);
    }

  /* definition of the process control block */

  pcb.i       = my_id;
  pcb.p       = NP;

  random_block_init ();
  dalib_init_walltime ();

  /* initialization of tracing */

#if defined(IBM)
  hostmodule ();
#else
  hostmodule_ ();
#endif
  pvm_exit ();
}

/*******************************************************************
*                                                                  *
*  number and ids of processes                                     *
*                                                                  *
*******************************************************************/

int dalib_pid_ ()
{
   return (my_id);
}

int dalib_nproc_ ()
{ return (NP); }
