/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Apr 93                                                   *
*  Last Update : Apr 93                                                   *
*                                                                         *
*  This Module is part of the DALIB / UNILIB                              *
*                                                                         *
*  Module      : overlap0.c                                               *
*                                                                         *
*  Function    : fill out overlapping areas (without communication)       *
*                                                                         *
*   source  : is a source array                                           *
*   target  : is the target, conform with source, but has an overlap      *
*                                                                         *
**************************************************************************/

# undef DEBUG

     /*********************************************************
     *                                                        *
     *  Overlap of one segment (without communication)        *
     *                                                        *
     *   l1      N1                              r1           *
     *  -----------------------------------------------       *
     *  |T    | Sxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx |     |       *
     *  -----------------------------------------------       *
     *                                                        *
     *  this function works for every size, also for          *
     *  whole rows of two-dimensional arrays , ...            *
     *                                                        *
     *********************************************************/

void dalib_local_overlap (target, source, N1, l1, r1)

unsigned char *target, *source;
int N1, l1, r1;

{  unsigned char *tptr, *sptr;

#ifdef DEBUG
   printf ("dalib_local_overlap, N1 = %d, l1 = %d, r1 = %d\n", N1, l1, r1);
#endif

  /* copy left overlap area, target (1:l1) = source (N1-l1+1:N1) */

  tptr = target;
  sptr = source + N1 - l1;
  dalib_memcpy (tptr, sptr, l1);

  /* copy source to target , target (l1:l1+N1) = source(1:N1)
     only necessary if source and target are not the same      */

  tptr += l1;
  if (tptr != source)
     dalib_memcpy (tptr, source, N1);

  /* copy right overlap area, target (N1+l1+1:N1+l1+r1) = source(1:r1) */

  tptr += N1;
  dalib_memcpy (tptr, source, r1);

#ifdef DEBUG
   printf ("dalib_local_overlap ready\n");
#endif

}  /* dalib_local_overlap */

     /*********************************************************
     *                                                        *
     *  Overlapping of two-dimensional segments               *
     *                                                        *
     *      l2      N2                              r2        *
     *     -----------------------------------------------    *
     *     |T      ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,       |    *
     * l1  |       ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,       |    *
     *     |     | Sxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx |     |    *
     * N1  |     | xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx |     |    *
     *     |     | xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx |     |    *
     *     |       ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,       |    *
     * r1  |       ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,       |    *
     *     -----------------------------------------------    *
     *                                                        *
     *********************************************************/

void dalib_overlap_seg2 (last_dim_flag, target, source, N1, l1, r1, N2, l2, r2)

int last_dim_flag;
unsigned char *target, *source;
int N1, l1, r1, N2, l2, r2;

{ int step, i;
  unsigned char *tptr, *sptr;

#ifdef DEBUG
   printf ("dalib_overlap_seg2\n");
   printf ("N1 = %d, l1 = %d, r1 = %d\n", N1, l1, r1);
   printf ("N2 = %d, l2 = %d, r2 = %d\n", N2, l2, r2);
#endif

  step = N1 + l1 + r1;

  /* step 1 : overlap in the rows, that is area with ,,,,,  */

  tptr = target + l2 * step;
  sptr = source;

  for (i=0; i<N2; i++)
   { dalib_local_overlap (tptr, sptr, N1, l1, r1);
     tptr += step;
     sptr += N1;
   }

  /* step 2 : overlap in the last dimension */

  if (last_dim_flag)
     dalib_local_overlap (target, target + l2 * step,
                          N2 * step, l2 * step, r2 * step);

}  /* dalib_overlap_seg2 */

     /*********************************************************
     *                                                        *
     *  Overlapping of three-dimensional segments             *
     *                                                        *
     *********************************************************/

void dalib_overlap_seg3 (last_dim_flag, target, source,
                         N1, l1, r1, N2, l2, r2, N3, l3, r3)

int last_dim_flag;
unsigned char *target, *source;
int N1, l1, r1, N2, l2, r2, N3, l3, r3;

{ int step, i;
  unsigned char *tptr, *sptr;

#ifdef DEBUG
   printf ("dalib_overlap_seg3\n");
   printf ("N1 = %d, l1 = %d, r1 = %d\n", N1, l1, r1);
   printf ("N2 = %d, l2 = %d, r2 = %d\n", N2, l2, r2);
   printf ("N3 = %d, l3 = %d, r3 = %d\n", N3, l3, r3);
#endif

  step = (N1+l1+r1) * (N2+l2+r2);

  /* step 1 : overlap in the first dimensions */

  tptr = target + l3 * step;
  sptr = source;

  for (i=0; i<N3; i++)
   { dalib_overlap_seg2 (1, tptr, sptr, N1, l1, r1, N2, l2, r2);
     tptr += step;
     sptr += N1*N2;
   }

  /* step 2 : overlap in the last dimension */

  if (last_dim_flag)
       dalib_local_overlap (target, target + l3 * step,
                              N3 * step, l3 * step, r3 * step);

}  /* dalib_overlap_seg3 */

     /*********************************************************
     *                                                        *
     *  Overlapping of four-dimensional segments              *
     *                                                        *
     *********************************************************/

void dalib_overlap_seg4 (last_dim_flag, target, source,
                         N1, l1, r1, N2, l2, r2,
                         N3, l3, r3, N4, l4, r4)

int last_dim_flag;
unsigned char *target, *source;
int N1, l1, r1, N2, l2, r2, N3, l3, r3, N4, l4, r4;

{ int step, i;
  unsigned char *tptr, *sptr;

  step = (N1+l1+r1) * (N2+l2+r2) * (N3+l3+r3);

  /* step 1 : overlap in the first dimensions */

  tptr = target + l4 * step;
  sptr = source;

  for (i=0; i<N4; i++)
   { dalib_overlap_seg3 (1, tptr, sptr, N1, l1, r1, N2, l2, r2, N3, l3, r3);
     tptr += step;
     sptr += N1*N2*N3;
   }

  /* step 2 : overlap in the last dimension */

  if (last_dim_flag)
     dalib_local_overlap (target, target + l4 * step,
                          N4 * step, l4 * step, r4 * step);

}  /* dalib_overlap_seg4 */

/**************************************************************************
*                                                                         *
*  Overlapping of replicated arrays or host arrays (no communication)     *
*                                                                         *
**************************************************************************/

void dalib_loverlap1__ (target, source, N1, l1, r1, size)

unsigned char *target, *source;
int *N1, *l1, *r1, *size;

/*   source is (N1), target is (N1+l1+r1), size is number of bytes */

{ int bytes;

  bytes = *size;
  dalib_local_overlap (target, source, *N1*bytes, *l1*bytes, *r1*bytes);

}  /* dalib_loverlap1 */

void dalib_loverlap2__ (target, source, N1, l1, r1, N2, l2, r2, size)

unsigned char *target, *source;
int *N1, *l1, *r1, *N2, *l2, *r2, *size;

{ int bytes;

  bytes = *size;
  dalib_overlap_seg2 (1, target, source, *N1*bytes, *l1*bytes, *r1*bytes,
                                      *N2, *l2, *r2);
} /* dalib_loverlap2_ */

void dalib_loverlap3__ (target, source, N1, l1, r1, N2, l2, r2, N3, l3, r3, size)

unsigned char *target, *source;
int *N1, *l1, *r1, *N2, *l2, *r2, *N3, *l3, *r3, *size;

{ int bytes;

  bytes = *size;
  dalib_overlap_seg3 (1, target, source, *N1*bytes, *l1*bytes, *r1*bytes,
                                      *N2, *l2, *r2, *N3, *l3, *r3);

} /* dalib_loverlap_seg3_ */

void dalib_loverlap4__ (target, source, N1, l1, r1, N2, l2, r2,
                                       N3, l3, r3, N4, l4, r4, size)

unsigned char *target, *source;
int *N1, *l1, *r1, *N2, *l2, *r2, *N3, *l3, *r3, *N4, *l4, *r4, *size;

{ int bytes;

  bytes = *size;
  dalib_overlap_seg4 (1, target, source, *N1*bytes, *l1*bytes, *r1*bytes,
                      *N2, *l2, *r2, *N3, *l3, *r3, *N4, *l4, *r4);

} /* dalib_loverlap4_ */
