C     data parallel source program

      program prime
      integer wn, n, s, ws, k
      logical*1 a(:), pa(:)
c     pa is replicated on all nodes
cmf$  layout pa(:serial)
      print *, 'Input value n for range from 1 to n : '
      read *, n
c     compute wn
      call cm_timer_clear (0)
      call cm_timer_start (0)
      wn = 1
      do while (wn*wn .lt. n)
         wn = wn + 1
      end do
      print *, 'Root of n = ', wn
      allocate (pa(1:wn),a(1:n))
c     compute primes from 2 to wn
      pa = .true.
      pa(1) = .false.
      k = 2
      do while (k*k .le. n)
         pa (k*k:wn:k) = .false.
         k = k + 1
         do while (.not. pa(k))
           k = k + 1
         end do
      end do
      ws = count (pa)
      print *, 'there are ', ws, ' primes until ', wn
c     compute prime from wn+1 to n
      a = .true.
      a(1) = .false.
      k = 2
      do while (k*k .le. n)
c        no broadcast of pa(k) is required as it is replicated
         if (pa(k)) a(k*k:n:k) = .false.
         k = k + 1
      end do
      s = count (a)
      call cm_timer_stop (0)
      print *, 'there are ',s,' primes until ', n
      call cm_timer_print (0)
      deallocate (a, pa)
      end
