# include "CallGraF.h"
# include "yyCGFns.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "CallGrap.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 15 "CallGraphFns.puma"

#define NoCallNodes NoCallGraph
#define NoCallNode  NoCallGraph
#define NoCallEdges NoCallGraph

static tCallGraph FoundCallNode;

tCallGraph  TheCallGraph;   /* for Output */

void CallGraphError (s)
char s[];
{  fprintf (stderr, "Internal Error for Call Graph : %s\n", s);
}



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CallGraphFns, routine %s failed\n", yyFunction);
 exit (1);
}

tCallGraph InsertNode ARGS((tCallGraph NodeList, tObject Decl, int kind));
tCallGraph CallGraphSearchNode ARGS((tObject Decl, int kind));
static tCallGraph LocalSearchNode ARGS((tCallGraph CG, tObject Decl, int kind));
static tCallGraph EdgeListInsert ARGS((tCallGraph edgelist, tCallGraph node));
void CallGraphInsertEdge ARGS((tCallGraph source, tCallGraph target));

tCallGraph InsertNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph NodeList, tObject Decl, register int kind)
# else
(NodeList, Decl, kind)
 register tCallGraph NodeList;
 tObject Decl;
 register int kind;
# endif
{
# line 61 "CallGraphFns.puma"
 {
  register tCallGraph yyV1;
  {
# line 62 "CallGraphFns.puma"
   if (! (NodeList == NoCallGraph)) goto yyL1;
  {
# line 63 "CallGraphFns.puma"
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV1,kCallNode)
    yyV1->CallNode.val = Decl;
    yyV1->CallNode.unitkind = kind;
    yyV1->CallNode.calling = NoCallEdges;
    yyV1->CallNode.called_by = NoCallEdges;
   FoundCallNode = yyV1;
  }
  }
  {
  register tCallGraph yyV2;
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV2,kCallNodeList)
    yyV2->CallNodeList.Elem = FoundCallNode;
    yyV2->CallNodeList.Next = NoCallNodes;
   return yyV2;
  }
 }
yyL1:;

# line 67 "CallGraphFns.puma"
  {
# line 68 "CallGraphFns.puma"
   if (! (Decl == NodeList->CallNodeList.Elem->CallNode.val)) goto yyL2;
  {
# line 69 "CallGraphFns.puma"
   FoundCallNode = NodeList->CallNodeList.Elem;
  }
  }
   return NodeList;
yyL2:;

# line 73 "CallGraphFns.puma"
  {
# line 74 "CallGraphFns.puma"
   NodeList->CallNodeList.Next = InsertNode (NodeList->CallNodeList.Next, Decl, kind);
  }
   return NodeList;

}

tCallGraph CallGraphSearchNode
# if defined __STDC__ | defined __cplusplus
(tObject Decl, register int kind)
# else
(Decl, kind)
 tObject Decl;
 register int kind;
# endif
{
# line 80 "CallGraphFns.puma"
   return LocalSearchNode (TheCallGraph, Decl, kind);

}

static tCallGraph LocalSearchNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph CG, tObject Decl, register int kind)
# else
(CG, Decl, kind)
 register tCallGraph CG;
 tObject Decl;
 register int kind;
# endif
{
# line 86 "CallGraphFns.puma"
  {
# line 87 "CallGraphFns.puma"
   if (! (Decl == NoObject)) goto yyL1;
  {
# line 88 "CallGraphFns.puma"
   CallGraphError ("No Object for Searching Node");
  }
  }
   return NoCallNode;
yyL1:;

  if (CG->Kind == kCallGraph) {
  if (equalint (kind, 0)) {
# line 92 "CallGraphFns.puma"
  {
# line 93 "CallGraphFns.puma"
   CG->CallGraph.UserNodes = InsertNode (CG->CallGraph.UserNodes, Decl, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 1)) {
# line 97 "CallGraphFns.puma"
  {
# line 98 "CallGraphFns.puma"
   CG->CallGraph.IntrinsicNodes = InsertNode (CG->CallGraph.IntrinsicNodes, Decl, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 2)) {
# line 102 "CallGraphFns.puma"
  {
# line 103 "CallGraphFns.puma"
   CG->CallGraph.ExternalNodes = InsertNode (CG->CallGraph.ExternalNodes, Decl, kind);
  }
   return FoundCallNode;

  }
  }
 yyAbort ("LocalSearchNode");
}

static tCallGraph EdgeListInsert
# if defined __STDC__ | defined __cplusplus
(register tCallGraph edgelist, register tCallGraph node)
# else
(edgelist, node)
 register tCallGraph edgelist;
 register tCallGraph node;
# endif
{
# line 109 "CallGraphFns.puma"
 {
  {
# line 110 "CallGraphFns.puma"
   if (! (edgelist == NoCallEdges)) goto yyL1;
  }
  {
  register tCallGraph yyV1;
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolMaxPtr,CallGraph_Alloc,CallGraph_NodeSize,MakeCallGraph,yyV1,kCallEdgeList)
    yyV1->CallEdgeList.Node = node;
    yyV1->CallEdgeList.count = 1;
    yyV1->CallEdgeList.Next = NoCallEdges;
   return yyV1;
  }
 }
yyL1:;

# line 114 "CallGraphFns.puma"
  {
# line 115 "CallGraphFns.puma"
   if (! (node == edgelist->CallEdgeList.Node)) goto yyL2;
  {
# line 116 "CallGraphFns.puma"
   edgelist->CallEdgeList.count = edgelist->CallEdgeList.count + 1;
  }
  }
   return edgelist;
yyL2:;

# line 120 "CallGraphFns.puma"
  {
# line 121 "CallGraphFns.puma"
   edgelist->CallEdgeList.Next = EdgeListInsert (edgelist->CallEdgeList.Next, node);
  }
   return edgelist;

}

void CallGraphInsertEdge
# if defined __STDC__ | defined __cplusplus
(register tCallGraph source, register tCallGraph target)
# else
(source, target)
 register tCallGraph source;
 register tCallGraph target;
# endif
{
  if (source == NoCallGraph) return;
  if (target == NoCallGraph) return;
# line 127 "CallGraphFns.puma"
  {
# line 128 "CallGraphFns.puma"
   if (! (source == NoCallNode)) goto yyL1;
  {
# line 129 "CallGraphFns.puma"
   CallGraphError ("Insert edge with source == NIL");
  }
  }
   return;
yyL1:;

# line 132 "CallGraphFns.puma"
  {
# line 133 "CallGraphFns.puma"
   if (! (target == NoCallNode)) goto yyL2;
  {
# line 134 "CallGraphFns.puma"
   CallGraphError ("Insert edge with target == NIL");
  }
  }
   return;
yyL2:;

# line 137 "CallGraphFns.puma"
  {
# line 139 "CallGraphFns.puma"
   source->CallNode.calling = EdgeListInsert (source->CallNode.calling, target);
# line 140 "CallGraphFns.puma"
   target->CallNode.called_by = EdgeListInsert (target->CallNode.called_by, source);
  }
   return;

;
}

void BeginCallGraphFns ()
{
# line 52 "CallGraphFns.puma"


TheCallGraph  = mCallGraph (NoCallNodes, NoCallNodes, NoCallNodes);
                /* all three lists are empty */


}

void CloseCallGraphFns ()
{
}
