# include "DepGraph.h"
# define yyALLOC(ptr, size)	if ((ptr = (tDepGraph) DepGraph_PoolFreePtr) >= (tDepGraph) DepGraph_PoolMaxPtr) \
  ptr = DepGraph_Alloc (); \
  DepGraph_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyDGraph.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
}
# else
# include <stdio.h>
# include "yyDGraph.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
# endif

/* line 82 "fortran.dg" */


#define MaxDepGraphs      150
#define MaxAllDepNode    3000
#define MaxAllDepEdge   10000

tDepNode DepNodeArray [MaxAllDepNode];
tDepEdge DepEdgeArray [MaxAllDepEdge];

int CountDepGraph;     /* counts graphs */
int CountDepNode;      /* counts nodes of all graphs */
int CountDepEdge;      /* counts edges of all graphs */

int CurrentDepGraph;   /* 1 .. CountDepGraph, current DepGraph */

typedef struct {
    tTree ast;
    int FirstNode;             /* points into DepNodeArray */
    int FirstEdge;             /* points into DepEdgeArray */
    int CountNode;             /* number of nodes in a DepGraph */
    int CountEdge;             /* number of edges in a DepGraph */
    } DepGraphRec;

DepGraphRec DepGraphArray [MaxDepGraphs];

/* help functions */

void DepGraphError (s)
char * s;
{ fprintf (stderr,"Internal Error for Dependence Graph : %s\\n", s);
}

void DepGraphOpenCheck ()     /* assert: there is an open graph */
{ if (CurrentDepGraph == 0)        /* no graph opened */
     DepGraphError ("No open graph");
}

void DepGraphLOpenCheck ()     /* assert: last created graph is open */
{ if (CurrentDepGraph != CountDepGraph)
     DepGraphError ("last created graph must be open");
}

void DepGraphCloseCheck ()    /* assert: all graphs are closed */
{ if (CurrentDepGraph != 0)
     DepGraphError ("Already graph opened");
}

void DepCreateGraph  (ast)
tTree ast;
{  if (CountDepGraph == MaxDepGraphs)
      DepGraphError ("maximal number of dependence graphs");
   DepGraphArray [CountDepGraph].ast = ast;
   DepGraphArray [CountDepGraph].FirstNode = CountDepNode;
   DepGraphArray [CountDepGraph].FirstEdge = CountDepEdge;
   DepGraphArray [CountDepGraph].CountNode = 0;
   DepGraphArray [CountDepGraph].CountEdge = 0;
   CountDepGraph += 1;
   CurrentDepGraph = CountDepGraph;
   printf ("Graph has been opened, Id = %d\\n", CurrentDepGraph);
} /* DepCreateGraph */

void DepCloseGraph ()
{  DepGraphOpenCheck ();
   printf ("Current Graph = %d will be closed\\n", CurrentDepGraph);
   printf ("%d Nodes have been inserted \\n",
                 DepGraphArray [CurrentDepGraph-1].CountNode);
   printf ("Nodes created until now : %d\\n", CountDepNode);
   CurrentDepGraph = 0;
} /* DepCloseGraph */

void DepDestroyGraph (N)
tTree N;
{ /* not realized yet */
}

void DepOpenGraph (N)
tTree N;
{  short Found;
   int DG;
   DepGraphCloseCheck ();
   DG = 0;
   Found = 0;
   while ((! Found) && (DG < CountDepGraph) )
     {  Found = (DepGraphArray [DG].ast == N);
        if (!Found) DG += 1;
     }
   if (!Found)
      DepGraphError ("No Dependence Graph for AST");
   CurrentDepGraph = DG+1;
   printf ("Graph %d has been opened\n", CurrentDepGraph);
} /* DepOpenGraph */

/* Inserting Node or Edge in a opened dependence graph */

DepNodeIndex DepGraphNodeInsert (DN)
tDepNode DN;
{  DepGraphLOpenCheck ();
   if (CountDepNode == MaxAllDepNode)
      DepGraphError ("Maximal Number of Nodes reached");
   DepNodeArray [CountDepNode] = DN;
   CountDepNode += 1;
   DepGraphArray [CurrentDepGraph-1].CountNode += 1;
   /* MaxDepNode is only a dummy check */
   if (DepGraphArray [CurrentDepGraph-1].CountNode == MaxDepNode)
      DepGraphError ("Maximal Number of Nodes for one Graph reached");
   return (DepGraphArray [CurrentDepGraph-1].CountNode);
} /* DepGraphNodeInsert */

DepEdgeIndex DepGraphEdgeInsert (DE)
tDepEdge DE;

{  DepGraphLOpenCheck ();
   if (CountDepEdge == MaxAllDepEdge)
      DepGraphError ("Maximal Number of Edges reached");
   DepEdgeArray [CountDepEdge] = DE;
   CountDepEdge += 1;
   DepGraphArray [CurrentDepGraph-1].CountEdge += 1;
   if (DepGraphArray [CurrentDepGraph-1].CountEdge == MaxDepEdge)
      DepGraphError ("Maximal Number of Edges for one Graph reached");
   return (DepGraphArray [CurrentDepGraph-1].CountEdge);
} /* DepGraphEdgeInsert */


/* Queries for the nodes of a dependence graph */

void DepGraphAllNodes (count, Defs, Uses)
int *count;
DepNodeSet *Defs, *Uses;
{  int i, first;
   DepGraphOpenCheck ();
   MakeSet (Defs, MaxDepNode);
   MakeSet (Uses, MaxDepNode);
   *count = DepGraphArray [CurrentDepGraph-1].CountNode;
   first = DepGraphArray [CurrentDepGraph-1].FirstNode;
   for (i=0;i<*count;i++)
      { if (DepNodeArray [first+i]->DepNode.NodeKind == 0)  /* Use */
           Include (Uses, i+1); /* note: indexes are numbered from 1 to n */
        else if (DepNodeArray [first+i]->DepNode.NodeKind == 1)  /* Def */
           Include (Defs, i+1);
        else
           { Include (Uses, i+1); Include (Defs, i+1); }
      }
}  /* DepGraphAllNodes */

void DepGraphGetForStmt (N, defs, uses)
tTree N;  /* stands for a ACF:statement node in the abstract syntax */
DepNodeSet *defs, *uses;

{ int i, anz, first, kind;
  tDepNode DN;
  DepGraphOpenCheck ();
  MakeSet (defs, MaxDepNode);
  MakeSet (uses, MaxDepNode);
  anz   = DepGraphArray[CurrentDepGraph-1].CountNode;
  first = DepGraphArray[CurrentDepGraph-1].FirstNode;
  for (i=0;i<anz;i++)
    { DN = DepNodeArray [first+i];
      if (DN->DepNode.Stat == N)
        { if (DN->DepNode.NodeKind == 0)
             Include (defs, i+1);
           else if (DN->DepNode.NodeKind == 1)
             Include (uses, i+1);
           else { Include (defs, i+1); Include (uses, i+1); }
        }
    }
} /* DepGraphGetForStmt */

DepNodeIndex DepGraphSearchNode ( ac )
tTree ac;

{  int Pos;
   DepGraphRec * PDG;
   int First, Nodes;
   short Found;
   tDepNode tDN;

   DepGraphOpenCheck;
   PDG = & (DepGraphArray[CurrentDepGraph]);
   Nodes = PDG->CountNode;
   First = PDG->FirstNode;
   Found = 0; Pos = 1;
   while ( (Pos <= Nodes) && (!Found) )
     { tDN = DepNodeArray [First + Pos -1];
       Found = (tDN->DepNode.Access == ac);
       if (!Found) Pos += 1;
     }
   if (Found)
      return (Pos);
    else DepGraphError ("Dependence Node not found");
} /* DepGraphSearchNode */

tDepNode DepGraphGetNode (DN)
DepNodeIndex DN;
{  DepGraphOpenCheck ();
   if ( (DN <= 0) || (DN > DepGraphArray[CurrentDepGraph-1].CountNode) )
      DepGraphError ("Illegal Dependence Node");
   return (DepNodeArray [DepGraphArray[CurrentDepGraph-1].FirstNode+DN-1]);
} /* DepGraphGetNode */

/* Queries for the edges of a dependence graph */

int DepGraphAllEdges ()

/* returns number of edges in the openend dependence graph */

{ DepGraphOpenCheck ();
  return (DepGraphArray[CurrentDepGraph].CountEdge);
}  /* DepGraphAllEdges */

tDepEdge DepGraphGetEdge ( DE )
DepEdgeIndex DE;
{  DepGraphOpenCheck ();
   if ( (DE <= 0) || (DE > DepGraphArray[CurrentDepGraph-1].CountEdge) )
      DepGraphError ("Illegal Dependence Edge");
   return (DepEdgeArray [DepGraphArray[CurrentDepGraph-1].FirstEdge+DE-1]);
} /* DepGraphGetEdge */

void DepGraphSearchEdge ( DN1, DN2, found, DE)
DepNodeIndex DN1, DN2;
short *found;
DepEdgeIndex DE;

{  int Pos;
   DepGraphRec * PDG;
   int First, Edges;
   short Found;
   tDepEdge tDE;

   DepGraphOpenCheck;
   PDG = & (DepGraphArray[CurrentDepGraph]);
   Edges = PDG->CountEdge;
   First = PDG->FirstEdge;
   Found = 0; Pos = 1;
   while ( (Pos <= Edges) && (!Found) )
     { tDE = DepEdgeArray [First + Pos];
       Found =    (tDE->DepEdge.Source == DN1)
               && (tDE->DepEdge.Target == DN2);
       if (!Found) Pos += 1;
     }
   if (Found) DE = Pos;
} /* DepGraphSearchEdge */



# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tDepGraph DepGraphRoot;
unsigned long DepGraph_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoDepGraph;
char * DepGraph_PoolFreePtr	= (char *) NoDepGraph;
char * DepGraph_PoolMaxPtr	= (char *) NoDepGraph;
static unsigned short yyMaxSize	= 0;
unsigned short DepGraph_NodeSize [2 + 1] = { 0,
 sizeof (yDepNode),
 sizeof (yDepEdge),
};
char * DepGraph_NodeName [2 + 1] = {
 "NoDepGraph",
 "DepNode",
 "DepEdge",
};
static DepGraph_tKind yyTypeRange [2 + 1] = { 0,
 kDepNode,
 kDepEdge,
};

tDepGraph DepGraph_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 2; i ++) {
   DepGraph_NodeSize [i] = (DepGraph_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (DepGraph_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 DepGraph_PoolFreePtr = yyBlockList->yyBlock;
 DepGraph_PoolMaxPtr = DepGraph_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 DepGraph_HeapUsed += yyBlockSize;
 return (tDepGraph) DepGraph_PoolFreePtr;
}

tDepGraph MakeDepGraph
# if defined __STDC__ | defined __cplusplus
 (DepGraph_tKind yyKind)
# else
 (yyKind) DepGraph_tKind yyKind;
# endif
{
 register tDepGraph yyt;
 yyALLOC (yyt, DepGraph_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool DepGraph_IsType
# if defined __STDC__ | defined __cplusplus
 (register tDepGraph yyt, register DepGraph_tKind yyKind)
# else
 (yyt, yyKind) register tDepGraph yyt; register DepGraph_tKind yyKind;
# endif
{
 return yyt != NoDepGraph && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}


tDepGraph mDepNode
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pNodeKind, tTree pAccess, tTree pStat, tTree pOuterLoops)
# else
(pName, pNodeKind, pAccess, pStat, pOuterLoops)
tIdent pName;
int pNodeKind;
tTree pAccess;
tTree pStat;
tTree pOuterLoops;
# endif
{
 register tDepGraph yyt;
 yyALLOC (yyt, DepGraph_NodeSize [kDepNode])
 yyt->Kind = kDepNode;
 yyt->yyHead.yyMark = 0;
 yyt->DepNode.Name = pName;
 yyt->DepNode.NodeKind = pNodeKind;
 yyt->DepNode.Access = pAccess;
 yyt->DepNode.Stat = pStat;
 yyt->DepNode.OuterLoops = pOuterLoops;
 return yyt;
}

tDepGraph mDepEdge
# if defined __STDC__ | defined __cplusplus
(int pSource, int pTarget, Predicate pPred)
# else
(pSource, pTarget, pPred)
int pSource;
int pTarget;
Predicate pPred;
# endif
{
 register tDepGraph yyt;
 yyALLOC (yyt, DepGraph_NodeSize [kDepEdge])
 yyt->Kind = kDepEdge;
 yyt->yyHead.yyMark = 0;
 yyt->DepEdge.Source = pSource;
 yyt->DepEdge.Target = pTarget;
 yyt->DepEdge.Pred = pPred;
 return yyt;
}

typedef tDepGraph * yyPtrtTree;

static FILE * yyf;

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

void BeginDepGraph ()
{
/* line 326 "fortran.dg" */

CountDepGraph   = 0;
CurrentDepGraph = 0;
CountDepNode    = 0;
CountDepEdge    = 0;

}

void CloseDepGraph ()
{
/* line 333 "fortran.dg" */


}
