# include "Tree.h"
# define yyALLOC(ptr, size)    if ((ptr = (tTree) Tree_PoolFreePtr) >= (tTree) Tree_PoolMaxPtr) \
  ptr = Tree_Alloc (); \
  Tree_PoolFreePtr += size;
# define yyFREE(ptr, size)    
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyTree.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
}
# else
# include <stdio.h>
# include "yyTree.w"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMe.h"
# include "Idents.h"
# include "Sets.h"
# endif

/* line 52 "ast.cg" */


tIdent DefaultId ()
{ return (MakeIdent (" ", 1)); }



# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tTree TreeRoot;
unsigned long Tree_HeapUsed = 0;

static yytBlockPtr yyBlockList    = (yytBlockPtr) NoTree;
char * Tree_PoolFreePtr    = (char *) NoTree;
char * Tree_PoolMaxPtr    = (char *) NoTree;
static unsigned short yyMaxSize    = 0;
unsigned short Tree_NodeSize [249 + 1] = { 0,
 sizeof (yCOMP_UNIT),
 sizeof (yBODY_NODE),
 sizeof (yTYPE_NODE),
 sizeof (yDUMMY_TYPE),
 sizeof (yVOID_TYPE),
 sizeof (yINTEGER_TYPE),
 sizeof (yCARDINAL_TYPE),
 sizeof (yREAL_TYPE),
 sizeof (yBOOLEAN_TYPE),
 sizeof (yCOMPLEX_TYPE),
 sizeof (yCHAR_TYPE),
 sizeof (ySTRING_TYPE),
 sizeof (yINDEX_TYPE),
 sizeof (yTYPE_ID),
 sizeof (yARRAY_TYPE),
 sizeof (yRECORD_TYPE),
 sizeof (yUNION_TYPE),
 sizeof (yENUM_TYPE),
 sizeof (yDYNAMIC),
 sizeof (yPOINTER_TYPE),
 sizeof (yARRAY1_TYPE),
 sizeof (yFUNCTION_TYPE),
 sizeof (yTYPE_NODE_LIST),
 sizeof (yTYPE_EMPTY),
 sizeof (yTYPE_LIST),
 sizeof (yDECL_NODE),
 sizeof (yMODULE_DECL),
 sizeof (yPROGRAM_DECL),
 sizeof (yPROC_DECL),
 sizeof (yFUNC_DECL),
 sizeof (yBLOCK_DATA_DECL),
 sizeof (yTYPE_DECL),
 sizeof (yNAME_DECL),
 sizeof (yRENAME_DECL),
 sizeof (yENTITY_DECL),
 sizeof (yVAR_DECL),
 sizeof (yCOMMON_DECL),
 sizeof (yNAMELIST_DECL),
 sizeof (yTEMPLATE_DECL),
 sizeof (yPROCESSORS_DECL),
 sizeof (yINHERIT_DECL),
 sizeof (ySTMT_FUNC_DECL),
 sizeof (yINTERFACE_DECL),
 sizeof (yEXT_PROC_DECL),
 sizeof (yEXT_FUNC_DECL),
 sizeof (yVAL_PARAM_DECL),
 sizeof (yVAR_PARAM_DECL),
 sizeof (yPROC_PARAM_DECL),
 sizeof (yFUNC_PARAM_DECL),
 sizeof (yELIPSIS_PARAM_DECL),
 sizeof (yRET_PARAM_DECL),
 sizeof (yIMPLICIT_DECL),
 sizeof (yUSE_DECL),
 sizeof (yONLY_USE_DECL),
 sizeof (yEQV_DECL),
 sizeof (yDATA_DECL),
 sizeof (yDIMENSION_DECL),
 sizeof (yINIT_DATA_DECL),
 sizeof (yTYPESPEC_DECL),
 sizeof (yALLOCATABLE_DECL),
 sizeof (yEXTERNAL_DECL),
 sizeof (yINTENT_DECL),
 sizeof (yINTRINSIC_DECL),
 sizeof (yOPTIONAL_DECL),
 sizeof (yPOINTER_DECL),
 sizeof (ySAVE_DECL),
 sizeof (yTARGET_DECL),
 sizeof (yPARAMETER_DECL),
 sizeof (yPUBLIC_DECL),
 sizeof (yPRIVATE_DECL),
 sizeof (yDISTRIBUTE_DECL),
 sizeof (yALIGN_DECL),
 sizeof (yDYNAMIC_DECL),
 sizeof (ySEQUENCE_DECL),
 sizeof (yNOSEQUENCE_DECL),
 sizeof (yDECL_NODE_LIST),
 sizeof (yDECL_EMPTY),
 sizeof (yDECL_LIST),
 sizeof (yDISTRIBUTION_SPEC),
 sizeof (yHOST_DISTRIBUTION),
 sizeof (yREPL_DISTRIBUTION),
 sizeof (yNODE_DISTRIBUTION),
 sizeof (yDISTRIBUTION_FORMAT),
 sizeof (yBLOCK_DISTRIBUTION),
 sizeof (yCYCLIC_DISTRIBUTION),
 sizeof (ySERIAL_DISTRIBUTION),
 sizeof (yDIST_FORMAT_LIST),
 sizeof (yDIST_EMPTY),
 sizeof (yDIST_LIST),
 sizeof (yGENERIC_SPEC),
 sizeof (yNO_GENERIC_SPEC),
 sizeof (yID_GENERIC_SPEC),
 sizeof (yOP_GENERIC_SPEC),
 sizeof (yASSIGN_GENERIC_SPEC),
 sizeof (yACF_NODE_LIST),
 sizeof (yACF_EMPTY),
 sizeof (yACF_LIST),
 sizeof (yACF_NODE),
 sizeof (yACF_DUMMY),
 sizeof (yACF_BASIC),
 sizeof (yACF_IF),
 sizeof (yACF_WHERE),
 sizeof (yACF_SWITCH),
 sizeof (yACF_ALTER),
 sizeof (yACF_CASE),
 sizeof (yACF_WHILE),
 sizeof (yACF_REPEAT),
 sizeof (yACF_WITH),
 sizeof (yACF_LOOP),
 sizeof (yACF_DO),
 sizeof (yACF_DOLOCAL),
 sizeof (yACF_DOVEC),
 sizeof (yACF_DOALL),
 sizeof (yACF_FORALL),
 sizeof (yACF_ON),
 sizeof (yACF_BODY),
 sizeof (yACF_FLOW_GRAPH),
 sizeof (yACF_ENTRY),
 sizeof (yACF_FLOW_KIND),
 sizeof (yACF_COMPLEX_FLOW),
 sizeof (yACF_INTERVAL_FLOW),
 sizeof (yACF_SIMPLE_FLOW),
 sizeof (ySELECTED_ACF_NODE_LIST),
 sizeof (ySELECTED_ACF_EMPTY),
 sizeof (ySELECTED_ACF_LIST),
 sizeof (ySELECTED_ACF_NODE),
 sizeof (yBT_STMT),
 sizeof (yEXP_STMT),
 sizeof (yASSIGN_STMT),
 sizeof (yPTR_ASSIGN_STMT),
 sizeof (yLABEL_ASSIGN_STMT),
 sizeof (yCALL_STMT),
 sizeof (yIO_STMT),
 sizeof (yGOTO_STMT),
 sizeof (yASS_GOTO_STMT),
 sizeof (yCOMP_GOTO_STMT),
 sizeof (yCOMP_IF_STMT),
 sizeof (yRETURN_STMT),
 sizeof (yPAUSE_STMT),
 sizeof (yEXIT_STMT),
 sizeof (yCYCLE_STMT),
 sizeof (ySTOP_STMT),
 sizeof (yFORMAT_STMT),
 sizeof (yALLOCATE_STMT),
 sizeof (yDEALLOCATE_STMT),
 sizeof (yNULLIFY_STMT),
 sizeof (yREDUCE_STMT),
 sizeof (yGLOBAL_STMT),
 sizeof (yALIGN_STMT),
 sizeof (yDISTRIBUTE_STMT),
 sizeof (yLABEL_USE_LIST),
 sizeof (yLABEL_EMPTY),
 sizeof (yLABEL_LIST),
 sizeof (yOP),
 sizeof (yOP_EQ),
 sizeof (yOP_NE),
 sizeof (yOP_LT),
 sizeof (yOP_GT),
 sizeof (yOP_GE),
 sizeof (yOP_LE),
 sizeof (yOP_PLUS),
 sizeof (yOP_MINUS),
 sizeof (yOP_XOR),
 sizeof (yOP_OR),
 sizeof (yOP_CONCAT),
 sizeof (yOP_TIMES),
 sizeof (yOP_DIVIDE),
 sizeof (yOP_DIV),
 sizeof (yOP_AND),
 sizeof (yOP_EQV),
 sizeof (yOP_NEQV),
 sizeof (yOP_EXPO),
 sizeof (yOP_MOD),
 sizeof (yOP_IN),
 sizeof (yOP_DEFINED),
 sizeof (yOP_ASSIGN),
 sizeof (yOP_LEFT),
 sizeof (yOP_RIGHT),
 sizeof (yOP_LIST),
 sizeof (yOP_IOR),
 sizeof (yOP_IXOR),
 sizeof (yOP_IAND),
 sizeof (yOP1_NOT),
 sizeof (yOP1_SIGN),
 sizeof (yOP1_INOT),
 sizeof (yOP1_SIZE),
 sizeof (yOP1_DEC),
 sizeof (yOP1_INC),
 sizeof (yOP1_ADDRESS),
 sizeof (yOP1_DEREF),
 sizeof (yBT_EXP),
 sizeof (yDUMMY_EXP),
 sizeof (yCONST_EXP),
 sizeof (yOP_EXP),
 sizeof (yOP1_EXP),
 sizeof (ySLICE_EXP),
 sizeof (yPOSTFIX_EXP),
 sizeof (yCALL_EXP),
 sizeof (yCAST_EXP),
 sizeof (yINDEXED_EXP),
 sizeof (ySELECTED_EXP),
 sizeof (yASSIGN_EXP),
 sizeof (yUSED_EXP),
 sizeof (yCOND_EXP),
 sizeof (yVAR_EXP),
 sizeof (yFUNC_CALL_EXP),
 sizeof (yNAMED_EXP),
 sizeof (yDO_EXP),
 sizeof (yTYPE_EXP),
 sizeof (yARRAY_EXP),
 sizeof (yBT_EXP_LIST),
 sizeof (yBTE_EMPTY),
 sizeof (yBTE_LIST),
 sizeof (yBT_VAR),
 sizeof (yDUMMY_VAR),
 sizeof (yUSED_VAR),
 sizeof (yINDEXED_VAR),
 sizeof (ySUBSTRING_VAR),
 sizeof (ySELECTED_VAR),
 sizeof (yLOOP_VAR),
 sizeof (yADDR),
 sizeof (yDO_VAR),
 sizeof (yBT_VAR_LIST),
 sizeof (yBTV_EMPTY),
 sizeof (yBTV_LIST),
 sizeof (yBT_PARAM),
 sizeof (yVAR_PARAM),
 sizeof (yVALUE_PARAM),
 sizeof (yNAMED_PARAM),
 sizeof (yPROC_PARAM),
 sizeof (yFUNC_PARAM),
 sizeof (yFORMAT_PARAM),
 sizeof (yRETURN_PARAM),
 sizeof (yNO_PARAM),
 sizeof (yBT_PARAM_LIST),
 sizeof (yBTP_EMPTY),
 sizeof (yBTP_LIST),
 sizeof (yCONSTANT),
 sizeof (yBOOL_CONSTANT),
 sizeof (yINT_CONSTANT),
 sizeof (yREAL_CONSTANT),
 sizeof (yDREAL_CONSTANT),
 sizeof (yCHAR_CONSTANT),
 sizeof (ySTRING_CONSTANT),
 sizeof (yCOMPLEX_CONSTANT),
 sizeof (yPROC_OBJ),
 sizeof (yVAR_OBJ),
 sizeof (yTYPE_OBJ),
 sizeof (yREC_COMP),
};
char * Tree_NodeName [249 + 1] = {
 "NoTree",
 "COMP_UNIT",
 "BODY_NODE",
 "TYPE_NODE",
 "DUMMY_TYPE",
 "VOID_TYPE",
 "INTEGER_TYPE",
 "CARDINAL_TYPE",
 "REAL_TYPE",
 "BOOLEAN_TYPE",
 "COMPLEX_TYPE",
 "CHAR_TYPE",
 "STRING_TYPE",
 "INDEX_TYPE",
 "TYPE_ID",
 "ARRAY_TYPE",
 "RECORD_TYPE",
 "UNION_TYPE",
 "ENUM_TYPE",
 "DYNAMIC",
 "POINTER_TYPE",
 "ARRAY1_TYPE",
 "FUNCTION_TYPE",
 "TYPE_NODE_LIST",
 "TYPE_EMPTY",
 "TYPE_LIST",
 "DECL_NODE",
 "MODULE_DECL",
 "PROGRAM_DECL",
 "PROC_DECL",
 "FUNC_DECL",
 "BLOCK_DATA_DECL",
 "TYPE_DECL",
 "NAME_DECL",
 "RENAME_DECL",
 "ENTITY_DECL",
 "VAR_DECL",
 "COMMON_DECL",
 "NAMELIST_DECL",
 "TEMPLATE_DECL",
 "PROCESSORS_DECL",
 "INHERIT_DECL",
 "STMT_FUNC_DECL",
 "INTERFACE_DECL",
 "EXT_PROC_DECL",
 "EXT_FUNC_DECL",
 "VAL_PARAM_DECL",
 "VAR_PARAM_DECL",
 "PROC_PARAM_DECL",
 "FUNC_PARAM_DECL",
 "ELIPSIS_PARAM_DECL",
 "RET_PARAM_DECL",
 "IMPLICIT_DECL",
 "USE_DECL",
 "ONLY_USE_DECL",
 "EQV_DECL",
 "DATA_DECL",
 "DIMENSION_DECL",
 "INIT_DATA_DECL",
 "TYPESPEC_DECL",
 "ALLOCATABLE_DECL",
 "EXTERNAL_DECL",
 "INTENT_DECL",
 "INTRINSIC_DECL",
 "OPTIONAL_DECL",
 "POINTER_DECL",
 "SAVE_DECL",
 "TARGET_DECL",
 "PARAMETER_DECL",
 "PUBLIC_DECL",
 "PRIVATE_DECL",
 "DISTRIBUTE_DECL",
 "ALIGN_DECL",
 "DYNAMIC_DECL",
 "SEQUENCE_DECL",
 "NOSEQUENCE_DECL",
 "DECL_NODE_LIST",
 "DECL_EMPTY",
 "DECL_LIST",
 "DISTRIBUTION_SPEC",
 "HOST_DISTRIBUTION",
 "REPL_DISTRIBUTION",
 "NODE_DISTRIBUTION",
 "DISTRIBUTION_FORMAT",
 "BLOCK_DISTRIBUTION",
 "CYCLIC_DISTRIBUTION",
 "SERIAL_DISTRIBUTION",
 "DIST_FORMAT_LIST",
 "DIST_EMPTY",
 "DIST_LIST",
 "GENERIC_SPEC",
 "NO_GENERIC_SPEC",
 "ID_GENERIC_SPEC",
 "OP_GENERIC_SPEC",
 "ASSIGN_GENERIC_SPEC",
 "ACF_NODE_LIST",
 "ACF_EMPTY",
 "ACF_LIST",
 "ACF_NODE",
 "ACF_DUMMY",
 "ACF_BASIC",
 "ACF_IF",
 "ACF_WHERE",
 "ACF_SWITCH",
 "ACF_ALTER",
 "ACF_CASE",
 "ACF_WHILE",
 "ACF_REPEAT",
 "ACF_WITH",
 "ACF_LOOP",
 "ACF_DO",
 "ACF_DOLOCAL",
 "ACF_DOVEC",
 "ACF_DOALL",
 "ACF_FORALL",
 "ACF_ON",
 "ACF_BODY",
 "ACF_FLOW_GRAPH",
 "ACF_ENTRY",
 "ACF_FLOW_KIND",
 "ACF_COMPLEX_FLOW",
 "ACF_INTERVAL_FLOW",
 "ACF_SIMPLE_FLOW",
 "SELECTED_ACF_NODE_LIST",
 "SELECTED_ACF_EMPTY",
 "SELECTED_ACF_LIST",
 "SELECTED_ACF_NODE",
 "BT_STMT",
 "EXP_STMT",
 "ASSIGN_STMT",
 "PTR_ASSIGN_STMT",
 "LABEL_ASSIGN_STMT",
 "CALL_STMT",
 "IO_STMT",
 "GOTO_STMT",
 "ASS_GOTO_STMT",
 "COMP_GOTO_STMT",
 "COMP_IF_STMT",
 "RETURN_STMT",
 "PAUSE_STMT",
 "EXIT_STMT",
 "CYCLE_STMT",
 "STOP_STMT",
 "FORMAT_STMT",
 "ALLOCATE_STMT",
 "DEALLOCATE_STMT",
 "NULLIFY_STMT",
 "REDUCE_STMT",
 "GLOBAL_STMT",
 "ALIGN_STMT",
 "DISTRIBUTE_STMT",
 "LABEL_USE_LIST",
 "LABEL_EMPTY",
 "LABEL_LIST",
 "OP",
 "OP_EQ",
 "OP_NE",
 "OP_LT",
 "OP_GT",
 "OP_GE",
 "OP_LE",
 "OP_PLUS",
 "OP_MINUS",
 "OP_XOR",
 "OP_OR",
 "OP_CONCAT",
 "OP_TIMES",
 "OP_DIVIDE",
 "OP_DIV",
 "OP_AND",
 "OP_EQV",
 "OP_NEQV",
 "OP_EXPO",
 "OP_MOD",
 "OP_IN",
 "OP_DEFINED",
 "OP_ASSIGN",
 "OP_LEFT",
 "OP_RIGHT",
 "OP_LIST",
 "OP_IOR",
 "OP_IXOR",
 "OP_IAND",
 "OP1_NOT",
 "OP1_SIGN",
 "OP1_INOT",
 "OP1_SIZE",
 "OP1_DEC",
 "OP1_INC",
 "OP1_ADDRESS",
 "OP1_DEREF",
 "BT_EXP",
 "DUMMY_EXP",
 "CONST_EXP",
 "OP_EXP",
 "OP1_EXP",
 "SLICE_EXP",
 "POSTFIX_EXP",
 "CALL_EXP",
 "CAST_EXP",
 "INDEXED_EXP",
 "SELECTED_EXP",
 "ASSIGN_EXP",
 "USED_EXP",
 "COND_EXP",
 "VAR_EXP",
 "FUNC_CALL_EXP",
 "NAMED_EXP",
 "DO_EXP",
 "TYPE_EXP",
 "ARRAY_EXP",
 "BT_EXP_LIST",
 "BTE_EMPTY",
 "BTE_LIST",
 "BT_VAR",
 "DUMMY_VAR",
 "USED_VAR",
 "INDEXED_VAR",
 "SUBSTRING_VAR",
 "SELECTED_VAR",
 "LOOP_VAR",
 "ADDR",
 "DO_VAR",
 "BT_VAR_LIST",
 "BTV_EMPTY",
 "BTV_LIST",
 "BT_PARAM",
 "VAR_PARAM",
 "VALUE_PARAM",
 "NAMED_PARAM",
 "PROC_PARAM",
 "FUNC_PARAM",
 "FORMAT_PARAM",
 "RETURN_PARAM",
 "NO_PARAM",
 "BT_PARAM_LIST",
 "BTP_EMPTY",
 "BTP_LIST",
 "CONSTANT",
 "BOOL_CONSTANT",
 "INT_CONSTANT",
 "REAL_CONSTANT",
 "DREAL_CONSTANT",
 "CHAR_CONSTANT",
 "STRING_CONSTANT",
 "COMPLEX_CONSTANT",
 "PROC_OBJ",
 "VAR_OBJ",
 "TYPE_OBJ",
 "REC_COMP",
};
static Tree_tKind yyTypeRange [249 + 1] = { 0,
 kCOMP_UNIT,
 kBODY_NODE,
 kFUNCTION_TYPE,
 kDUMMY_TYPE,
 kVOID_TYPE,
 kINTEGER_TYPE,
 kCARDINAL_TYPE,
 kREAL_TYPE,
 kBOOLEAN_TYPE,
 kCOMPLEX_TYPE,
 kCHAR_TYPE,
 kSTRING_TYPE,
 kINDEX_TYPE,
 kTYPE_ID,
 kARRAY_TYPE,
 kRECORD_TYPE,
 kUNION_TYPE,
 kENUM_TYPE,
 kDYNAMIC,
 kPOINTER_TYPE,
 kARRAY1_TYPE,
 kFUNCTION_TYPE,
 kTYPE_LIST,
 kTYPE_EMPTY,
 kTYPE_LIST,
 kNOSEQUENCE_DECL,
 kMODULE_DECL,
 kPROGRAM_DECL,
 kPROC_DECL,
 kFUNC_DECL,
 kBLOCK_DATA_DECL,
 kTYPE_DECL,
 kNAME_DECL,
 kRENAME_DECL,
 kENTITY_DECL,
 kVAR_DECL,
 kCOMMON_DECL,
 kNAMELIST_DECL,
 kTEMPLATE_DECL,
 kPROCESSORS_DECL,
 kINHERIT_DECL,
 kSTMT_FUNC_DECL,
 kINTERFACE_DECL,
 kEXT_PROC_DECL,
 kEXT_FUNC_DECL,
 kVAL_PARAM_DECL,
 kVAR_PARAM_DECL,
 kPROC_PARAM_DECL,
 kFUNC_PARAM_DECL,
 kELIPSIS_PARAM_DECL,
 kRET_PARAM_DECL,
 kIMPLICIT_DECL,
 kUSE_DECL,
 kONLY_USE_DECL,
 kEQV_DECL,
 kDATA_DECL,
 kDIMENSION_DECL,
 kINIT_DATA_DECL,
 kTYPESPEC_DECL,
 kALLOCATABLE_DECL,
 kEXTERNAL_DECL,
 kINTENT_DECL,
 kINTRINSIC_DECL,
 kOPTIONAL_DECL,
 kPOINTER_DECL,
 kSAVE_DECL,
 kTARGET_DECL,
 kPARAMETER_DECL,
 kPUBLIC_DECL,
 kPRIVATE_DECL,
 kDISTRIBUTE_DECL,
 kALIGN_DECL,
 kDYNAMIC_DECL,
 kSEQUENCE_DECL,
 kNOSEQUENCE_DECL,
 kDECL_LIST,
 kDECL_EMPTY,
 kDECL_LIST,
 kNODE_DISTRIBUTION,
 kHOST_DISTRIBUTION,
 kREPL_DISTRIBUTION,
 kNODE_DISTRIBUTION,
 kSERIAL_DISTRIBUTION,
 kBLOCK_DISTRIBUTION,
 kCYCLIC_DISTRIBUTION,
 kSERIAL_DISTRIBUTION,
 kDIST_LIST,
 kDIST_EMPTY,
 kDIST_LIST,
 kASSIGN_GENERIC_SPEC,
 kNO_GENERIC_SPEC,
 kID_GENERIC_SPEC,
 kOP_GENERIC_SPEC,
 kASSIGN_GENERIC_SPEC,
 kACF_LIST,
 kACF_EMPTY,
 kACF_LIST,
 kACF_ENTRY,
 kACF_DUMMY,
 kACF_BASIC,
 kACF_IF,
 kACF_WHERE,
 kACF_SWITCH,
 kACF_ALTER,
 kACF_CASE,
 kACF_WHILE,
 kACF_REPEAT,
 kACF_WITH,
 kACF_LOOP,
 kACF_DO,
 kACF_DOLOCAL,
 kACF_DOVEC,
 kACF_DOALL,
 kACF_FORALL,
 kACF_ON,
 kACF_BODY,
 kACF_FLOW_GRAPH,
 kACF_ENTRY,
 kACF_SIMPLE_FLOW,
 kACF_COMPLEX_FLOW,
 kACF_INTERVAL_FLOW,
 kACF_SIMPLE_FLOW,
 kSELECTED_ACF_LIST,
 kSELECTED_ACF_EMPTY,
 kSELECTED_ACF_LIST,
 kSELECTED_ACF_NODE,
 kDISTRIBUTE_STMT,
 kEXP_STMT,
 kASSIGN_STMT,
 kPTR_ASSIGN_STMT,
 kLABEL_ASSIGN_STMT,
 kCALL_STMT,
 kIO_STMT,
 kGOTO_STMT,
 kASS_GOTO_STMT,
 kCOMP_GOTO_STMT,
 kCOMP_IF_STMT,
 kRETURN_STMT,
 kPAUSE_STMT,
 kEXIT_STMT,
 kCYCLE_STMT,
 kSTOP_STMT,
 kFORMAT_STMT,
 kALLOCATE_STMT,
 kDEALLOCATE_STMT,
 kNULLIFY_STMT,
 kREDUCE_STMT,
 kGLOBAL_STMT,
 kALIGN_STMT,
 kDISTRIBUTE_STMT,
 kLABEL_LIST,
 kLABEL_EMPTY,
 kLABEL_LIST,
 kOP1_DEREF,
 kOP_EQ,
 kOP_NE,
 kOP_LT,
 kOP_GT,
 kOP_GE,
 kOP_LE,
 kOP_PLUS,
 kOP_MINUS,
 kOP_XOR,
 kOP_OR,
 kOP_CONCAT,
 kOP_TIMES,
 kOP_DIVIDE,
 kOP_DIV,
 kOP_AND,
 kOP_EQV,
 kOP_NEQV,
 kOP_EXPO,
 kOP_MOD,
 kOP_IN,
 kOP_DEFINED,
 kOP_ASSIGN,
 kOP_LEFT,
 kOP_RIGHT,
 kOP_LIST,
 kOP_IOR,
 kOP_IXOR,
 kOP_IAND,
 kOP1_NOT,
 kOP1_SIGN,
 kOP1_INOT,
 kOP1_SIZE,
 kOP1_DEC,
 kOP1_INC,
 kOP1_ADDRESS,
 kOP1_DEREF,
 kARRAY_EXP,
 kDUMMY_EXP,
 kCONST_EXP,
 kOP_EXP,
 kOP1_EXP,
 kSLICE_EXP,
 kPOSTFIX_EXP,
 kCALL_EXP,
 kCAST_EXP,
 kINDEXED_EXP,
 kSELECTED_EXP,
 kASSIGN_EXP,
 kUSED_EXP,
 kCOND_EXP,
 kVAR_EXP,
 kFUNC_CALL_EXP,
 kNAMED_EXP,
 kDO_EXP,
 kTYPE_EXP,
 kARRAY_EXP,
 kBTE_LIST,
 kBTE_EMPTY,
 kBTE_LIST,
 kDO_VAR,
 kDUMMY_VAR,
 kUSED_VAR,
 kINDEXED_VAR,
 kSUBSTRING_VAR,
 kSELECTED_VAR,
 kLOOP_VAR,
 kADDR,
 kDO_VAR,
 kBTV_LIST,
 kBTV_EMPTY,
 kBTV_LIST,
 kNO_PARAM,
 kVAR_PARAM,
 kVALUE_PARAM,
 kNAMED_PARAM,
 kPROC_PARAM,
 kFUNC_PARAM,
 kFORMAT_PARAM,
 kRETURN_PARAM,
 kNO_PARAM,
 kBTP_LIST,
 kBTP_EMPTY,
 kBTP_LIST,
 kCOMPLEX_CONSTANT,
 kBOOL_CONSTANT,
 kINT_CONSTANT,
 kREAL_CONSTANT,
 kDREAL_CONSTANT,
 kCHAR_CONSTANT,
 kSTRING_CONSTANT,
 kCOMPLEX_CONSTANT,
 kPROC_OBJ,
 kVAR_OBJ,
 kTYPE_OBJ,
 kREC_COMP,
};

tTree Tree_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 249; i ++) {
   Tree_NodeSize [i] = (Tree_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Tree_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Tree_PoolFreePtr = yyBlockList->yyBlock;
 Tree_PoolMaxPtr = Tree_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Tree_HeapUsed += yyBlockSize;
 return (tTree) Tree_PoolFreePtr;
}

tTree MakeTree
# if defined __STDC__ | defined __cplusplus
 (Tree_tKind yyKind)
# else
 (yyKind) Tree_tKind yyKind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

bool Tree_IsType
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt, register Tree_tKind yyKind)
# else
 (yyt, yyKind) register tTree yyt; register Tree_tKind yyKind;
# endif
{
 return yyt != NoTree && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}


tTree mCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
(tTree pCOMP_ELEMENTS)
# else
(pCOMP_ELEMENTS)
tTree pCOMP_ELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_UNIT])
 yyt->Kind = kCOMP_UNIT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_UNIT.COMP_ELEMENTS = pCOMP_ELEMENTS;
 return yyt;
}

tTree mBODY_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pDECLS, tTree pSTATS, tTree pINTERNALS)
# else
(pDECLS, pSTATS, pINTERNALS)
tTree pDECLS;
tTree pSTATS;
tTree pINTERNALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBODY_NODE])
 yyt->Kind = kBODY_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BODY_NODE.DECLS = pDECLS;
 yyt->BODY_NODE.STATS = pSTATS;
 yyt->BODY_NODE.INTERNALS = pINTERNALS;
 return yyt;
}

tTree mTYPE_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_NODE])
 yyt->Kind = kTYPE_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_TYPE])
 yyt->Kind = kDUMMY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mVOID_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVOID_TYPE])
 yyt->Kind = kVOID_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
(int psize)
# else
(psize)
int psize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTEGER_TYPE])
 yyt->Kind = kINTEGER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTEGER_TYPE.size = psize;
 return yyt;
}

tTree mCARDINAL_TYPE
# if defined __STDC__ | defined __cplusplus
(int psize)
# else
(psize)
int psize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCARDINAL_TYPE])
 yyt->Kind = kCARDINAL_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CARDINAL_TYPE.size = psize;
 return yyt;
}

tTree mREAL_TYPE
# if defined __STDC__ | defined __cplusplus
(int psize)
# else
(psize)
int psize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_TYPE])
 yyt->Kind = kREAL_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_TYPE.size = psize;
 return yyt;
}

tTree mBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
(int psize)
# else
(psize)
int psize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOLEAN_TYPE])
 yyt->Kind = kBOOLEAN_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOLEAN_TYPE.size = psize;
 return yyt;
}

tTree mCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
(int psize)
# else
(psize)
int psize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_TYPE])
 yyt->Kind = kCOMPLEX_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_TYPE.size = psize;
 return yyt;
}

tTree mCHAR_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCHAR_TYPE])
 yyt->Kind = kCHAR_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pLENGTH)
# else
(pLENGTH)
tTree pLENGTH;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_TYPE])
 yyt->Kind = kSTRING_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_TYPE.LENGTH = pLENGTH;
 return yyt;
}

tTree mINDEX_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER, tTree pUPPER)
# else
(pLOWER, pUPPER)
tTree pLOWER;
tTree pUPPER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEX_TYPE])
 yyt->Kind = kINDEX_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEX_TYPE.LOWER = pLOWER;
 yyt->INDEX_TYPE.UPPER = pUPPER;
 beginint(yyt->INDEX_TYPE.left_overlap)
 beginint(yyt->INDEX_TYPE.right_overlap)
 return yyt;
}

tTree mTYPE_ID
# if defined __STDC__ | defined __cplusplus
(tTree pID)
# else
(pID)
tTree pID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_ID])
 yyt->Kind = kTYPE_ID;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_ID.ID = pID;
 return yyt;
}

tTree mARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY_INDEX_TYPES, tTree pARRAY_COMP_TYPE)
# else
(pARRAY_INDEX_TYPES, pARRAY_COMP_TYPE)
tTree pARRAY_INDEX_TYPES;
tTree pARRAY_COMP_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_TYPE])
 yyt->Kind = kARRAY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES = pARRAY_INDEX_TYPES;
 yyt->ARRAY_TYPE.ARRAY_COMP_TYPE = pARRAY_COMP_TYPE;
 return yyt;
}

tTree mRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pCOMPONENTS)
# else
(pName, pCOMPONENTS)
tIdent pName;
tTree pCOMPONENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRECORD_TYPE])
 yyt->Kind = kRECORD_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RECORD_TYPE.Name = pName;
 yyt->RECORD_TYPE.COMPONENTS = pCOMPONENTS;
 return yyt;
}

tTree mUNION_TYPE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pCOMPONENTS)
# else
(pName, pCOMPONENTS)
tIdent pName;
tTree pCOMPONENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNION_TYPE])
 yyt->Kind = kUNION_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->UNION_TYPE.Name = pName;
 yyt->UNION_TYPE.COMPONENTS = pCOMPONENTS;
 return yyt;
}

tTree mENUM_TYPE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pCOMPONENTS)
# else
(pName, pCOMPONENTS)
tIdent pName;
tTree pCOMPONENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kENUM_TYPE])
 yyt->Kind = kENUM_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ENUM_TYPE.Name = pName;
 yyt->ENUM_TYPE.COMPONENTS = pCOMPONENTS;
 return yyt;
}

tTree mDYNAMIC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDYNAMIC])
 yyt->Kind = kDYNAMIC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->DYNAMIC.Shape)
 beginint(yyt->DYNAMIC.left_overlap)
 beginint(yyt->DYNAMIC.right_overlap)
 return yyt;
}

tTree mPOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pPTR_COMP)
# else
(pPTR_COMP)
tTree pPTR_COMP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_TYPE])
 yyt->Kind = kPOINTER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_TYPE.PTR_COMP = pPTR_COMP;
 return yyt;
}

tTree mARRAY1_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE, tTree pARRAY1_COMP_TYPE)
# else
(pSIZE, pARRAY1_COMP_TYPE)
tTree pSIZE;
tTree pARRAY1_COMP_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY1_TYPE])
 yyt->Kind = kARRAY1_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY1_TYPE.SIZE = pSIZE;
 yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE = pARRAY1_COMP_TYPE;
 return yyt;
}

tTree mFUNCTION_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pFORMALS, tTree pRESULT_TYPE)
# else
(pFORMALS, pRESULT_TYPE)
tTree pFORMALS;
tTree pRESULT_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNCTION_TYPE])
 yyt->Kind = kFUNCTION_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNCTION_TYPE.FORMALS = pFORMALS;
 yyt->FUNCTION_TYPE.RESULT_TYPE = pRESULT_TYPE;
 return yyt;
}

tTree mTYPE_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_NODE_LIST])
 yyt->Kind = kTYPE_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mTYPE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_EMPTY])
 yyt->Kind = kTYPE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mTYPE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_LIST])
 yyt->Kind = kTYPE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_LIST.Elem = pElem;
 yyt->TYPE_LIST.Next = pNext;
 return yyt;
}

tTree mDECL_NODE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE])
 yyt->Kind = kDECL_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_NODE.Name = pName;
 yyt->DECL_NODE.Pos = pPos;
 return yyt;
}

tTree mMODULE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pMODULE_BODY)
# else
(pName, pPos, pMODULE_BODY)
tIdent pName;
int pPos;
tTree pMODULE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMODULE_DECL])
 yyt->Kind = kMODULE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MODULE_DECL.Name = pName;
 yyt->MODULE_DECL.Pos = pPos;
 yyt->MODULE_DECL.MODULE_BODY = pMODULE_BODY;
 return yyt;
}

tTree mPROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS, tTree pPROGRAM_BODY)
# else
(pName, pPos, pFORMALS, pPROGRAM_BODY)
tIdent pName;
int pPos;
tTree pFORMALS;
tTree pPROGRAM_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROGRAM_DECL])
 yyt->Kind = kPROGRAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROGRAM_DECL.Name = pName;
 yyt->PROGRAM_DECL.Pos = pPos;
 yyt->PROGRAM_DECL.FORMALS = pFORMALS;
 yyt->PROGRAM_DECL.PROGRAM_BODY = pPROGRAM_BODY;
 return yyt;
}

tTree mPROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS, tTree pPROC_BODY)
# else
(pName, pPos, pFORMALS, pPROC_BODY)
tIdent pName;
int pPos;
tTree pFORMALS;
tTree pPROC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_DECL])
 yyt->Kind = kPROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_DECL.Name = pName;
 yyt->PROC_DECL.Pos = pPos;
 yyt->PROC_DECL.FORMALS = pFORMALS;
 yyt->PROC_DECL.PROC_BODY = pPROC_BODY;
 beginbool(yyt->PROC_DECL.IsRecursive)
 beginbool(yyt->PROC_DECL.IsPure)
 beginint(yyt->PROC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mFUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS, tTree pFUNC_BODY, tTree pRESULT_TYPE, tIdent pRESULT_ID)
# else
(pName, pPos, pFORMALS, pFUNC_BODY, pRESULT_TYPE, pRESULT_ID)
tIdent pName;
int pPos;
tTree pFORMALS;
tTree pFUNC_BODY;
tTree pRESULT_TYPE;
tIdent pRESULT_ID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_DECL])
 yyt->Kind = kFUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_DECL.Name = pName;
 yyt->FUNC_DECL.Pos = pPos;
 yyt->FUNC_DECL.FORMALS = pFORMALS;
 yyt->FUNC_DECL.FUNC_BODY = pFUNC_BODY;
 yyt->FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->FUNC_DECL.RESULT_ID = pRESULT_ID;
 beginbool(yyt->FUNC_DECL.IsRecursive)
 beginbool(yyt->FUNC_DECL.IsPure)
 beginint(yyt->FUNC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pDATA_BODY)
# else
(pName, pPos, pDATA_BODY)
tIdent pName;
int pPos;
tTree pDATA_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DATA_DECL])
 yyt->Kind = kBLOCK_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DATA_DECL.Name = pName;
 yyt->BLOCK_DATA_DECL.Pos = pPos;
 yyt->BLOCK_DATA_DECL.DATA_BODY = pDATA_BODY;
 return yyt;
}

tTree mTYPE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_DECL])
 yyt->Kind = kTYPE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_DECL.Name = pName;
 yyt->TYPE_DECL.Pos = pPos;
 yyt->TYPE_DECL.VAL = pVAL;
 return yyt;
}

tTree mNAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAME_DECL])
 yyt->Kind = kNAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAME_DECL.Name = pName;
 yyt->NAME_DECL.Pos = pPos;
 return yyt;
}

tTree mRENAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tIdent poldname)
# else
(pName, pPos, poldname)
tIdent pName;
int pPos;
tIdent poldname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRENAME_DECL])
 yyt->Kind = kRENAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RENAME_DECL.Name = pName;
 yyt->RENAME_DECL.Pos = pPos;
 yyt->RENAME_DECL.oldname = poldname;
 return yyt;
}

tTree mENTITY_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pATTRIBUTES)
# else
(pName, pPos, pATTRIBUTES)
tIdent pName;
int pPos;
tTree pATTRIBUTES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kENTITY_DECL])
 yyt->Kind = kENTITY_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ENTITY_DECL.Name = pName;
 yyt->ENTITY_DECL.Pos = pPos;
 yyt->ENTITY_DECL.ATTRIBUTES = pATTRIBUTES;
 return yyt;
}

tTree mVAR_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_DECL])
 yyt->Kind = kVAR_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_DECL.Name = pName;
 yyt->VAR_DECL.Pos = pPos;
 yyt->VAR_DECL.VAL = pVAL;
 return yyt;
}

tTree mCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pIDS)
# else
(pName, pPos, pIDS)
tIdent pName;
int pPos;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMMON_DECL])
 yyt->Kind = kCOMMON_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMMON_DECL.Name = pName;
 yyt->COMMON_DECL.Pos = pPos;
 yyt->COMMON_DECL.IDS = pIDS;
 return yyt;
}

tTree mNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pIDS)
# else
(pName, pPos, pIDS)
tIdent pName;
int pPos;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMELIST_DECL])
 yyt->Kind = kNAMELIST_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMELIST_DECL.Name = pName;
 yyt->NAMELIST_DECL.Pos = pPos;
 yyt->NAMELIST_DECL.IDS = pIDS;
 return yyt;
}

tTree mTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pDIMENSIONS)
# else
(pName, pPos, pDIMENSIONS)
tIdent pName;
int pPos;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTEMPLATE_DECL])
 yyt->Kind = kTEMPLATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TEMPLATE_DECL.Name = pName;
 yyt->TEMPLATE_DECL.Pos = pPos;
 yyt->TEMPLATE_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mPROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pDIMENSIONS)
# else
(pName, pPos, pDIMENSIONS)
tIdent pName;
int pPos;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSORS_DECL])
 yyt->Kind = kPROCESSORS_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSORS_DECL.Name = pName;
 yyt->PROCESSORS_DECL.Pos = pPos;
 yyt->PROCESSORS_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINHERIT_DECL])
 yyt->Kind = kINHERIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INHERIT_DECL.Name = pName;
 yyt->INHERIT_DECL.Pos = pPos;
 return yyt;
}

tTree mSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS, tTree pRESULT_TYPE, tTree pFFUNC_BODY)
# else
(pName, pPos, pFORMALS, pRESULT_TYPE, pFFUNC_BODY)
tIdent pName;
int pPos;
tTree pFORMALS;
tTree pRESULT_TYPE;
tTree pFFUNC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTMT_FUNC_DECL])
 yyt->Kind = kSTMT_FUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STMT_FUNC_DECL.Name = pName;
 yyt->STMT_FUNC_DECL.Pos = pPos;
 yyt->STMT_FUNC_DECL.FORMALS = pFORMALS;
 yyt->STMT_FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->STMT_FUNC_DECL.FFUNC_BODY = pFFUNC_BODY;
 return yyt;
}

tTree mINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pSPEC, tTree pITEMS)
# else
(pName, pPos, pSPEC, pITEMS)
tIdent pName;
int pPos;
tTree pSPEC;
tTree pITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTERFACE_DECL])
 yyt->Kind = kINTERFACE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTERFACE_DECL.Name = pName;
 yyt->INTERFACE_DECL.Pos = pPos;
 yyt->INTERFACE_DECL.SPEC = pSPEC;
 yyt->INTERFACE_DECL.ITEMS = pITEMS;
 return yyt;
}

tTree mEXT_PROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS)
# else
(pName, pPos, pFORMALS)
tIdent pName;
int pPos;
tTree pFORMALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXT_PROC_DECL])
 yyt->Kind = kEXT_PROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXT_PROC_DECL.Name = pName;
 yyt->EXT_PROC_DECL.Pos = pPos;
 yyt->EXT_PROC_DECL.FORMALS = pFORMALS;
 return yyt;
}

tTree mEXT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMALS, tTree pRESULT_TYPE)
# else
(pName, pPos, pFORMALS, pRESULT_TYPE)
tIdent pName;
int pPos;
tTree pFORMALS;
tTree pRESULT_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXT_FUNC_DECL])
 yyt->Kind = kEXT_FUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXT_FUNC_DECL.Name = pName;
 yyt->EXT_FUNC_DECL.Pos = pPos;
 yyt->EXT_FUNC_DECL.FORMALS = pFORMALS;
 yyt->EXT_FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 return yyt;
}

tTree mVAL_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAL_PARAM_DECL])
 yyt->Kind = kVAL_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAL_PARAM_DECL.Name = pName;
 yyt->VAL_PARAM_DECL.Pos = pPos;
 yyt->VAL_PARAM_DECL.VAL = pVAL;
 return yyt;
}

tTree mVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM_DECL])
 yyt->Kind = kVAR_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM_DECL.Name = pName;
 yyt->VAR_PARAM_DECL.Pos = pPos;
 yyt->VAR_PARAM_DECL.VAL = pVAL;
 return yyt;
}

tTree mPROC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMAL)
# else
(pName, pPos, pFORMAL)
tIdent pName;
int pPos;
tTree pFORMAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_PARAM_DECL])
 yyt->Kind = kPROC_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_PARAM_DECL.Name = pName;
 yyt->PROC_PARAM_DECL.Pos = pPos;
 yyt->PROC_PARAM_DECL.FORMAL = pFORMAL;
 return yyt;
}

tTree mFUNC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pFORMAL, tTree pRESULT_TYPE)
# else
(pName, pPos, pFORMAL, pRESULT_TYPE)
tIdent pName;
int pPos;
tTree pFORMAL;
tTree pRESULT_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_PARAM_DECL])
 yyt->Kind = kFUNC_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_PARAM_DECL.Name = pName;
 yyt->FUNC_PARAM_DECL.Pos = pPos;
 yyt->FUNC_PARAM_DECL.FORMAL = pFORMAL;
 yyt->FUNC_PARAM_DECL.RESULT_TYPE = pRESULT_TYPE;
 return yyt;
}

tTree mELIPSIS_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kELIPSIS_PARAM_DECL])
 yyt->Kind = kELIPSIS_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ELIPSIS_PARAM_DECL.Name = pName;
 yyt->ELIPSIS_PARAM_DECL.Pos = pPos;
 return yyt;
}

tTree mRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRET_PARAM_DECL])
 yyt->Kind = kRET_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RET_PARAM_DECL.Name = pName;
 yyt->RET_PARAM_DECL.Pos = pPos;
 return yyt;
}

tTree mIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tIdent pfirst, tIdent plast, tTree pVAL)
# else
(pName, pPos, pfirst, plast, pVAL)
tIdent pName;
int pPos;
tIdent pfirst;
tIdent plast;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIMPLICIT_DECL])
 yyt->Kind = kIMPLICIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IMPLICIT_DECL.Name = pName;
 yyt->IMPLICIT_DECL.Pos = pPos;
 yyt->IMPLICIT_DECL.first = pfirst;
 yyt->IMPLICIT_DECL.last = plast;
 yyt->IMPLICIT_DECL.VAL = pVAL;
 return yyt;
}

tTree mUSE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tIdent puse, tTree pRENAMINGS)
# else
(pName, pPos, puse, pRENAMINGS)
tIdent pName;
int pPos;
tIdent puse;
tTree pRENAMINGS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSE_DECL])
 yyt->Kind = kUSE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USE_DECL.Name = pName;
 yyt->USE_DECL.Pos = pPos;
 yyt->USE_DECL.use = puse;
 yyt->USE_DECL.RENAMINGS = pRENAMINGS;
 return yyt;
}

tTree mONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tIdent puse, tTree pNAMES)
# else
(pName, pPos, puse, pNAMES)
tIdent pName;
int pPos;
tIdent puse;
tTree pNAMES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kONLY_USE_DECL])
 yyt->Kind = kONLY_USE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ONLY_USE_DECL.Name = pName;
 yyt->ONLY_USE_DECL.Pos = pPos;
 yyt->ONLY_USE_DECL.use = puse;
 yyt->ONLY_USE_DECL.NAMES = pNAMES;
 return yyt;
}

tTree mEQV_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVARS)
# else
(pName, pPos, pVARS)
tIdent pName;
int pPos;
tTree pVARS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEQV_DECL])
 yyt->Kind = kEQV_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EQV_DECL.Name = pName;
 yyt->EQV_DECL.Pos = pPos;
 yyt->EQV_DECL.VARS = pVARS;
 return yyt;
}

tTree mDATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVARS, tTree pVALS)
# else
(pName, pPos, pVARS, pVALS)
tIdent pName;
int pPos;
tTree pVARS;
tTree pVALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDATA_DECL])
 yyt->Kind = kDATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DATA_DECL.Name = pName;
 yyt->DATA_DECL.Pos = pPos;
 yyt->DATA_DECL.VARS = pVARS;
 yyt->DATA_DECL.VALS = pVALS;
 return yyt;
}

tTree mDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pINDEXES)
# else
(pName, pPos, pINDEXES)
tIdent pName;
int pPos;
tTree pINDEXES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIMENSION_DECL])
 yyt->Kind = kDIMENSION_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIMENSION_DECL.Name = pName;
 yyt->DIMENSION_DECL.Pos = pPos;
 yyt->DIMENSION_DECL.INDEXES = pINDEXES;
 return yyt;
}

tTree mINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINIT_DATA_DECL])
 yyt->Kind = kINIT_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INIT_DATA_DECL.Name = pName;
 yyt->INIT_DATA_DECL.Pos = pPos;
 yyt->INIT_DATA_DECL.VAL = pVAL;
 return yyt;
}

tTree mTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPESPEC_DECL])
 yyt->Kind = kTYPESPEC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPESPEC_DECL.Name = pName;
 yyt->TYPESPEC_DECL.Pos = pPos;
 yyt->TYPESPEC_DECL.VAL = pVAL;
 return yyt;
}

tTree mALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATABLE_DECL])
 yyt->Kind = kALLOCATABLE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATABLE_DECL.Name = pName;
 yyt->ALLOCATABLE_DECL.Pos = pPos;
 return yyt;
}

tTree mEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXTERNAL_DECL])
 yyt->Kind = kEXTERNAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXTERNAL_DECL.Name = pName;
 yyt->EXTERNAL_DECL.Pos = pPos;
 return yyt;
}

tTree mINTENT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, int pintent)
# else
(pName, pPos, pintent)
tIdent pName;
int pPos;
int pintent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTENT_DECL])
 yyt->Kind = kINTENT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTENT_DECL.Name = pName;
 yyt->INTENT_DECL.Pos = pPos;
 yyt->INTENT_DECL.intent = pintent;
 return yyt;
}

tTree mINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTRINSIC_DECL])
 yyt->Kind = kINTRINSIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTRINSIC_DECL.Name = pName;
 yyt->INTRINSIC_DECL.Pos = pPos;
 return yyt;
}

tTree mOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOPTIONAL_DECL])
 yyt->Kind = kOPTIONAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OPTIONAL_DECL.Name = pName;
 yyt->OPTIONAL_DECL.Pos = pPos;
 return yyt;
}

tTree mPOINTER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_DECL])
 yyt->Kind = kPOINTER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_DECL.Name = pName;
 yyt->POINTER_DECL.Pos = pPos;
 return yyt;
}

tTree mSAVE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSAVE_DECL])
 yyt->Kind = kSAVE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SAVE_DECL.Name = pName;
 yyt->SAVE_DECL.Pos = pPos;
 return yyt;
}

tTree mTARGET_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTARGET_DECL])
 yyt->Kind = kTARGET_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TARGET_DECL.Name = pName;
 yyt->TARGET_DECL.Pos = pPos;
 return yyt;
}

tTree mPARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pVAL)
# else
(pName, pPos, pVAL)
tIdent pName;
int pPos;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARAMETER_DECL])
 yyt->Kind = kPARAMETER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PARAMETER_DECL.Name = pName;
 yyt->PARAMETER_DECL.Pos = pPos;
 yyt->PARAMETER_DECL.VAL = pVAL;
 return yyt;
}

tTree mPUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPUBLIC_DECL])
 yyt->Kind = kPUBLIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PUBLIC_DECL.Name = pName;
 yyt->PUBLIC_DECL.Pos = pPos;
 return yyt;
}

tTree mPRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPRIVATE_DECL])
 yyt->Kind = kPRIVATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PRIVATE_DECL.Name = pName;
 yyt->PRIVATE_DECL.Pos = pPos;
 return yyt;
}

tTree mDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pDISTRIBUTION, tIdent ptarget)
# else
(pName, pPos, pDISTRIBUTION, ptarget)
tIdent pName;
int pPos;
tTree pDISTRIBUTION;
tIdent ptarget;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTE_DECL])
 yyt->Kind = kDISTRIBUTE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTE_DECL.Name = pName;
 yyt->DISTRIBUTE_DECL.Pos = pPos;
 yyt->DISTRIBUTE_DECL.DISTRIBUTION = pDISTRIBUTION;
 yyt->DISTRIBUTE_DECL.target = ptarget;
 return yyt;
}

tTree mALIGN_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos, tTree pALIGN_SOURCE, tTree pALIGN_SPEC)
# else
(pName, pPos, pALIGN_SOURCE, pALIGN_SPEC)
tIdent pName;
int pPos;
tTree pALIGN_SOURCE;
tTree pALIGN_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_DECL])
 yyt->Kind = kALIGN_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_DECL.Name = pName;
 yyt->ALIGN_DECL.Pos = pPos;
 yyt->ALIGN_DECL.ALIGN_SOURCE = pALIGN_SOURCE;
 yyt->ALIGN_DECL.ALIGN_SPEC = pALIGN_SPEC;
 return yyt;
}

tTree mDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDYNAMIC_DECL])
 yyt->Kind = kDYNAMIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DYNAMIC_DECL.Name = pName;
 yyt->DYNAMIC_DECL.Pos = pPos;
 return yyt;
}

tTree mSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSEQUENCE_DECL])
 yyt->Kind = kSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SEQUENCE_DECL.Name = pName;
 yyt->SEQUENCE_DECL.Pos = pPos;
 return yyt;
}

tTree mNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pName, int pPos)
# else
(pName, pPos)
tIdent pName;
int pPos;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNOSEQUENCE_DECL])
 yyt->Kind = kNOSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NOSEQUENCE_DECL.Name = pName;
 yyt->NOSEQUENCE_DECL.Pos = pPos;
 return yyt;
}

tTree mDECL_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE_LIST])
 yyt->Kind = kDECL_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_EMPTY])
 yyt->Kind = kDECL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_LIST])
 yyt->Kind = kDECL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_LIST.Elem = pElem;
 yyt->DECL_LIST.Next = pNext;
 return yyt;
}

tTree mDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_SPEC])
 yyt->Kind = kDISTRIBUTION_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mHOST_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kHOST_DISTRIBUTION])
 yyt->Kind = kHOST_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREPL_DISTRIBUTION])
 yyt->Kind = kREPL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pMAPPING)
# else
(pMAPPING)
tTree pMAPPING;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNODE_DISTRIBUTION])
 yyt->Kind = kNODE_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NODE_DISTRIBUTION.MAPPING = pMAPPING;
 return yyt;
}

tTree mDISTRIBUTION_FORMAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_FORMAT])
 yyt->Kind = kDISTRIBUTION_FORMAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DISTRIBUTION])
 yyt->Kind = kBLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLIC_DISTRIBUTION])
 yyt->Kind = kCYCLIC_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLIC_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mSERIAL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSERIAL_DISTRIBUTION])
 yyt->Kind = kSERIAL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_FORMAT_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_FORMAT_LIST])
 yyt->Kind = kDIST_FORMAT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_EMPTY])
 yyt->Kind = kDIST_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_LIST])
 yyt->Kind = kDIST_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIST_LIST.Elem = pElem;
 yyt->DIST_LIST.Next = pNext;
 return yyt;
}

tTree mGENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGENERIC_SPEC])
 yyt->Kind = kGENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNO_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_GENERIC_SPEC])
 yyt->Kind = kNO_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tIdent pname)
# else
(pname)
tIdent pname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kID_GENERIC_SPEC])
 yyt->Kind = kID_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ID_GENERIC_SPEC.name = pname;
 return yyt;
}

tTree mOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tTree pOPERATOR)
# else
(pOPERATOR)
tTree pOPERATOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GENERIC_SPEC])
 yyt->Kind = kOP_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_GENERIC_SPEC.OPERATOR = pOPERATOR;
 return yyt;
}

tTree mASSIGN_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_GENERIC_SPEC])
 yyt->Kind = kASSIGN_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE_LIST])
 yyt->Kind = kACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_EMPTY])
 yyt->Kind = kACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LIST])
 yyt->Kind = kACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ACF_LIST.Elem = pElem;
 yyt->ACF_LIST.Next = pNext;
 return yyt;
}

tTree mACF_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE])
 yyt->Kind = kACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_NODE.Label)
 beginint(yyt->ACF_NODE.Line)
 return yyt;
}

tTree mACF_DUMMY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DUMMY])
 yyt->Kind = kACF_DUMMY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DUMMY.Label)
 beginint(yyt->ACF_DUMMY.Line)
 return yyt;
}

tTree mACF_BASIC
# if defined __STDC__ | defined __cplusplus
(tTree pBASIC_STMT)
# else
(pBASIC_STMT)
tTree pBASIC_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BASIC])
 yyt->Kind = kACF_BASIC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BASIC.Label)
 beginint(yyt->ACF_BASIC.Line)
 yyt->ACF_BASIC.BASIC_STMT = pBASIC_STMT;
 return yyt;
}

tTree mACF_IF
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, tTree pTHEN_PART, tTree pELSE_PART)
# else
(pIF_EXP, pTHEN_PART, pELSE_PART)
tTree pIF_EXP;
tTree pTHEN_PART;
tTree pELSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_IF])
 yyt->Kind = kACF_IF;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_IF.Label)
 beginint(yyt->ACF_IF.Line)
 yyt->ACF_IF.IF_EXP = pIF_EXP;
 yyt->ACF_IF.THEN_PART = pTHEN_PART;
 yyt->ACF_IF.ELSE_PART = pELSE_PART;
 return yyt;
}

tTree mACF_WHERE
# if defined __STDC__ | defined __cplusplus
(tTree pWHERE_EXP, tTree pTRUE_PART, tTree pFALSE_PART)
# else
(pWHERE_EXP, pTRUE_PART, pFALSE_PART)
tTree pWHERE_EXP;
tTree pTRUE_PART;
tTree pFALSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHERE])
 yyt->Kind = kACF_WHERE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHERE.Label)
 beginint(yyt->ACF_WHERE.Line)
 yyt->ACF_WHERE.WHERE_EXP = pWHERE_EXP;
 yyt->ACF_WHERE.TRUE_PART = pTRUE_PART;
 yyt->ACF_WHERE.FALSE_PART = pFALSE_PART;
 return yyt;
}

tTree mACF_SWITCH
# if defined __STDC__ | defined __cplusplus
(tTree pSWITCH_EXP, tTree pSWITCH_STMT)
# else
(pSWITCH_EXP, pSWITCH_STMT)
tTree pSWITCH_EXP;
tTree pSWITCH_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_SWITCH])
 yyt->Kind = kACF_SWITCH;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_SWITCH.Label)
 beginint(yyt->ACF_SWITCH.Line)
 yyt->ACF_SWITCH.SWITCH_EXP = pSWITCH_EXP;
 yyt->ACF_SWITCH.SWITCH_STMT = pSWITCH_STMT;
 return yyt;
}

tTree mACF_ALTER
# if defined __STDC__ | defined __cplusplus
(tTree pALTER_EXP, tTree pALTER_STMT)
# else
(pALTER_EXP, pALTER_STMT)
tTree pALTER_EXP;
tTree pALTER_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ALTER])
 yyt->Kind = kACF_ALTER;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ALTER.Label)
 beginint(yyt->ACF_ALTER.Line)
 yyt->ACF_ALTER.ALTER_EXP = pALTER_EXP;
 yyt->ACF_ALTER.ALTER_STMT = pALTER_STMT;
 return yyt;
}

tTree mACF_CASE
# if defined __STDC__ | defined __cplusplus
(tTree pCASE_EXP, tTree pCASE_ALTS, tTree pCASE_OTHERWISE)
# else
(pCASE_EXP, pCASE_ALTS, pCASE_OTHERWISE)
tTree pCASE_EXP;
tTree pCASE_ALTS;
tTree pCASE_OTHERWISE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_CASE])
 yyt->Kind = kACF_CASE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_CASE.Label)
 beginint(yyt->ACF_CASE.Line)
 yyt->ACF_CASE.CASE_EXP = pCASE_EXP;
 yyt->ACF_CASE.CASE_ALTS = pCASE_ALTS;
 yyt->ACF_CASE.CASE_OTHERWISE = pCASE_OTHERWISE;
 return yyt;
}

tTree mACF_WHILE
# if defined __STDC__ | defined __cplusplus
(tTree pWHILE_EXP, tTree pWHILE_BODY)
# else
(pWHILE_EXP, pWHILE_BODY)
tTree pWHILE_EXP;
tTree pWHILE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHILE])
 yyt->Kind = kACF_WHILE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHILE.Label)
 beginint(yyt->ACF_WHILE.Line)
 yyt->ACF_WHILE.WHILE_EXP = pWHILE_EXP;
 yyt->ACF_WHILE.WHILE_BODY = pWHILE_BODY;
 return yyt;
}

tTree mACF_REPEAT
# if defined __STDC__ | defined __cplusplus
(tTree pREPEAT_BODY, tTree pREPEAT_EXP)
# else
(pREPEAT_BODY, pREPEAT_EXP)
tTree pREPEAT_BODY;
tTree pREPEAT_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_REPEAT])
 yyt->Kind = kACF_REPEAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_REPEAT.Label)
 beginint(yyt->ACF_REPEAT.Line)
 yyt->ACF_REPEAT.REPEAT_BODY = pREPEAT_BODY;
 yyt->ACF_REPEAT.REPEAT_EXP = pREPEAT_EXP;
 return yyt;
}

tTree mACF_WITH
# if defined __STDC__ | defined __cplusplus
(tTree pWITH_VARS, tTree pWITH_BODY)
# else
(pWITH_VARS, pWITH_BODY)
tTree pWITH_VARS;
tTree pWITH_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WITH])
 yyt->Kind = kACF_WITH;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WITH.Label)
 beginint(yyt->ACF_WITH.Line)
 yyt->ACF_WITH.WITH_VARS = pWITH_VARS;
 yyt->ACF_WITH.WITH_BODY = pWITH_BODY;
 return yyt;
}

tTree mACF_LOOP
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_BODY)
# else
(pLOOP_BODY)
tTree pLOOP_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LOOP])
 yyt->Kind = kACF_LOOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_LOOP.Label)
 beginint(yyt->ACF_LOOP.Line)
 yyt->ACF_LOOP.LOOP_BODY = pLOOP_BODY;
 return yyt;
}

tTree mACF_DO
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pDO_RANGE, tTree pDO_BODY)
# else
(pDO_ID, pDO_RANGE, pDO_BODY)
tTree pDO_ID;
tTree pDO_RANGE;
tTree pDO_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DO])
 yyt->Kind = kACF_DO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DO.Label)
 beginint(yyt->ACF_DO.Line)
 yyt->ACF_DO.DO_ID = pDO_ID;
 yyt->ACF_DO.DO_RANGE = pDO_RANGE;
 yyt->ACF_DO.DO_BODY = pDO_BODY;
 return yyt;
}

tTree mACF_DOLOCAL
# if defined __STDC__ | defined __cplusplus
(tTree pDOLOCAL_ID, tTree pDOLOCAL_RANGE, tTree pDOLOCAL_BODY)
# else
(pDOLOCAL_ID, pDOLOCAL_RANGE, pDOLOCAL_BODY)
tTree pDOLOCAL_ID;
tTree pDOLOCAL_RANGE;
tTree pDOLOCAL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DOLOCAL])
 yyt->Kind = kACF_DOLOCAL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DOLOCAL.Label)
 beginint(yyt->ACF_DOLOCAL.Line)
 yyt->ACF_DOLOCAL.DOLOCAL_ID = pDOLOCAL_ID;
 yyt->ACF_DOLOCAL.DOLOCAL_RANGE = pDOLOCAL_RANGE;
 yyt->ACF_DOLOCAL.DOLOCAL_BODY = pDOLOCAL_BODY;
 return yyt;
}

tTree mACF_DOVEC
# if defined __STDC__ | defined __cplusplus
(tTree pDOVEC_ID, tTree pDOVEC_RANGE, tTree pDOVEC_BODY)
# else
(pDOVEC_ID, pDOVEC_RANGE, pDOVEC_BODY)
tTree pDOVEC_ID;
tTree pDOVEC_RANGE;
tTree pDOVEC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DOVEC])
 yyt->Kind = kACF_DOVEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DOVEC.Label)
 beginint(yyt->ACF_DOVEC.Line)
 yyt->ACF_DOVEC.DOVEC_ID = pDOVEC_ID;
 yyt->ACF_DOVEC.DOVEC_RANGE = pDOVEC_RANGE;
 yyt->ACF_DOVEC.DOVEC_BODY = pDOVEC_BODY;
 return yyt;
}

tTree mACF_DOALL
# if defined __STDC__ | defined __cplusplus
(tTree pDOALL_NEW, tTree pDOALL_ID, tTree pDOALL_RANGE, tTree pDOALL_BODY)
# else
(pDOALL_NEW, pDOALL_ID, pDOALL_RANGE, pDOALL_BODY)
tTree pDOALL_NEW;
tTree pDOALL_ID;
tTree pDOALL_RANGE;
tTree pDOALL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DOALL])
 yyt->Kind = kACF_DOALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DOALL.Label)
 beginint(yyt->ACF_DOALL.Line)
 yyt->ACF_DOALL.DOALL_NEW = pDOALL_NEW;
 yyt->ACF_DOALL.DOALL_ID = pDOALL_ID;
 yyt->ACF_DOALL.DOALL_RANGE = pDOALL_RANGE;
 yyt->ACF_DOALL.DOALL_BODY = pDOALL_BODY;
 return yyt;
}

tTree mACF_FORALL
# if defined __STDC__ | defined __cplusplus
(tTree pFORALL_ID, tTree pFORALL_RANGE, tTree pFORALL_BODY)
# else
(pFORALL_ID, pFORALL_RANGE, pFORALL_BODY)
tTree pFORALL_ID;
tTree pFORALL_RANGE;
tTree pFORALL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FORALL])
 yyt->Kind = kACF_FORALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FORALL.Label)
 beginint(yyt->ACF_FORALL.Line)
 yyt->ACF_FORALL.FORALL_ID = pFORALL_ID;
 yyt->ACF_FORALL.FORALL_RANGE = pFORALL_RANGE;
 yyt->ACF_FORALL.FORALL_BODY = pFORALL_BODY;
 return yyt;
}

tTree mACF_ON
# if defined __STDC__ | defined __cplusplus
(tTree pON_VAR, tTree pON_STMT)
# else
(pON_VAR, pON_STMT)
tTree pON_VAR;
tTree pON_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ON])
 yyt->Kind = kACF_ON;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ON.Label)
 beginint(yyt->ACF_ON.Line)
 yyt->ACF_ON.ON_VAR = pON_VAR;
 yyt->ACF_ON.ON_STMT = pON_STMT;
 return yyt;
}

tTree mACF_BODY
# if defined __STDC__ | defined __cplusplus
(tTree pNEW_BODY)
# else
(pNEW_BODY)
tTree pNEW_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BODY])
 yyt->Kind = kACF_BODY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BODY.Label)
 beginint(yyt->ACF_BODY.Line)
 yyt->ACF_BODY.NEW_BODY = pNEW_BODY;
 begintDefinitions(yyt->ACF_BODY.Entries)
 return yyt;
}

tTree mACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
(tTree pFLOW_NODES)
# else
(pFLOW_NODES)
tTree pFLOW_NODES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_GRAPH])
 yyt->Kind = kACF_FLOW_GRAPH;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FLOW_GRAPH.Label)
 beginint(yyt->ACF_FLOW_GRAPH.Line)
 yyt->ACF_FLOW_GRAPH.FLOW_NODES = pFLOW_NODES;
 return yyt;
}

tTree mACF_ENTRY
# if defined __STDC__ | defined __cplusplus
(tTree pENTRY_DECL)
# else
(pENTRY_DECL)
tTree pENTRY_DECL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ENTRY])
 yyt->Kind = kACF_ENTRY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ENTRY.Label)
 beginint(yyt->ACF_ENTRY.Line)
 yyt->ACF_ENTRY.ENTRY_DECL = pENTRY_DECL;
 return yyt;
}

tTree mACF_FLOW_KIND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_KIND])
 yyt->Kind = kACF_FLOW_KIND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_COMPLEX_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_COMPLEX_FLOW])
 yyt->Kind = kACF_COMPLEX_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_INTERVAL_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_INTERVAL_FLOW])
 yyt->Kind = kACF_INTERVAL_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_SIMPLE_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_SIMPLE_FLOW])
 yyt->Kind = kACF_SIMPLE_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE_LIST])
 yyt->Kind = kSELECTED_ACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_EMPTY])
 yyt->Kind = kSELECTED_ACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_LIST])
 yyt->Kind = kSELECTED_ACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_LIST.Elem = pElem;
 yyt->SELECTED_ACF_LIST.Next = pNext;
 return yyt;
}

tTree mSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pSELECT_LIST, tTree pSELECT_ACFS)
# else
(pSELECT_LIST, pSELECT_ACFS)
tTree pSELECT_LIST;
tTree pSELECT_ACFS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE])
 yyt->Kind = kSELECTED_ACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_NODE.SELECT_LIST = pSELECT_LIST;
 yyt->SELECTED_ACF_NODE.SELECT_ACFS = pSELECT_ACFS;
 return yyt;
}

tTree mBT_STMT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_STMT])
 yyt->Kind = kBT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mEXP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pSTMT_EXP)
# else
(pSTMT_EXP)
tTree pSTMT_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXP_STMT])
 yyt->Kind = kEXP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXP_STMT.STMT_EXP = pSTMT_EXP;
 return yyt;
}

tTree mASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_STMT])
 yyt->Kind = kASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mPTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPTR_ASSIGN_STMT])
 yyt->Kind = kPTR_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PTR_ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->PTR_ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(int passign_label, tTree pLABEL_VAR)
# else
(passign_label, pLABEL_VAR)
int passign_label;
tTree pLABEL_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_ASSIGN_STMT])
 yyt->Kind = kLABEL_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_ASSIGN_STMT.assign_label = passign_label;
 yyt->LABEL_ASSIGN_STMT.LABEL_VAR = pLABEL_VAR;
 return yyt;
}

tTree mCALL_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pCALL_ID, tTree pCALL_PARAMS)
# else
(pCALL_ID, pCALL_PARAMS)
tTree pCALL_ID;
tTree pCALL_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCALL_STMT])
 yyt->Kind = kCALL_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CALL_STMT.CALL_ID = pCALL_ID;
 yyt->CALL_STMT.CALL_PARAMS = pCALL_PARAMS;
 return yyt;
}

tTree mIO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pIO_SPECS, tTree pIO_ITEMS)
# else
(pID, pIO_SPECS, pIO_ITEMS)
tTree pID;
tTree pIO_SPECS;
tTree pIO_ITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIO_STMT])
 yyt->Kind = kIO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IO_STMT.ID = pID;
 yyt->IO_STMT.IO_SPECS = pIO_SPECS;
 yyt->IO_STMT.IO_ITEMS = pIO_ITEMS;
 return yyt;
}

tTree mGOTO_STMT
# if defined __STDC__ | defined __cplusplus
(int pGOTO_LABEL)
# else
(pGOTO_LABEL)
int pGOTO_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGOTO_STMT])
 yyt->Kind = kGOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GOTO_STMT.GOTO_LABEL = pGOTO_LABEL;
 return yyt;
}

tTree mASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_VAR, tTree pLABELS)
# else
(pGOTO_VAR, pLABELS)
tTree pGOTO_VAR;
tTree pLABELS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASS_GOTO_STMT])
 yyt->Kind = kASS_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASS_GOTO_STMT.GOTO_VAR = pGOTO_VAR;
 yyt->ASS_GOTO_STMT.LABELS = pLABELS;
 return yyt;
}

tTree mCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_LABELS, tTree pGOTO_EXP)
# else
(pGOTO_LABELS, pGOTO_EXP)
tTree pGOTO_LABELS;
tTree pGOTO_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_GOTO_STMT])
 yyt->Kind = kCOMP_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_GOTO_STMT.GOTO_LABELS = pGOTO_LABELS;
 yyt->COMP_GOTO_STMT.GOTO_EXP = pGOTO_EXP;
 return yyt;
}

tTree mCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, int pIF_LT_LABEL, int pIF_EQ_LABEL, int pIF_GT_LABEL)
# else
(pIF_EXP, pIF_LT_LABEL, pIF_EQ_LABEL, pIF_GT_LABEL)
tTree pIF_EXP;
int pIF_LT_LABEL;
int pIF_EQ_LABEL;
int pIF_GT_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_IF_STMT])
 yyt->Kind = kCOMP_IF_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_IF_STMT.IF_EXP = pIF_EXP;
 yyt->COMP_IF_STMT.IF_LT_LABEL = pIF_LT_LABEL;
 yyt->COMP_IF_STMT.IF_EQ_LABEL = pIF_EQ_LABEL;
 yyt->COMP_IF_STMT.IF_GT_LABEL = pIF_GT_LABEL;
 return yyt;
}

tTree mRETURN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRETURN_EXP)
# else
(pRETURN_EXP)
tTree pRETURN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_STMT])
 yyt->Kind = kRETURN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_STMT.RETURN_EXP = pRETURN_EXP;
 return yyt;
}

tTree mPAUSE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPAUSE_CONST)
# else
(pPAUSE_CONST)
tTree pPAUSE_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPAUSE_STMT])
 yyt->Kind = kPAUSE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PAUSE_STMT.PAUSE_CONST = pPAUSE_CONST;
 return yyt;
}

tTree mEXIT_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXIT_STMT])
 yyt->Kind = kEXIT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXIT_STMT.loopid = ploopid;
 return yyt;
}

tTree mCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLE_STMT])
 yyt->Kind = kCYCLE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLE_STMT.loopid = ploopid;
 return yyt;
}

tTree mSTOP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pSTOP_CONST)
# else
(pSTOP_CONST)
tTree pSTOP_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTOP_STMT])
 yyt->Kind = kSTOP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STOP_STMT.STOP_CONST = pSTOP_CONST;
 return yyt;
}

tTree mFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pFORMAT_PARAMS)
# else
(pFORMAT_PARAMS)
tTree pFORMAT_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_STMT])
 yyt->Kind = kFORMAT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_STMT.FORMAT_PARAMS = pFORMAT_PARAMS;
 return yyt;
}

tTree mALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTAT)
# else
(pPARAMS, pSTAT)
tTree pPARAMS;
tTree pSTAT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATE_STMT])
 yyt->Kind = kALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->ALLOCATE_STMT.STAT = pSTAT;
 return yyt;
}

tTree mDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTAT)
# else
(pPARAMS, pSTAT)
tTree pPARAMS;
tTree pSTAT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEALLOCATE_STMT])
 yyt->Kind = kDEALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DEALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->DEALLOCATE_STMT.STAT = pSTAT;
 return yyt;
}

tTree mNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS)
# else
(pPARAMS)
tTree pPARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNULLIFY_STMT])
 yyt->Kind = kNULLIFY_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NULLIFY_STMT.PARAMS = pPARAMS;
 return yyt;
}

tTree mREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRED_FUNC, tTree pRED_PARAMS)
# else
(pRED_FUNC, pRED_PARAMS)
tTree pRED_FUNC;
tTree pRED_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDUCE_STMT])
 yyt->Kind = kREDUCE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDUCE_STMT.RED_FUNC = pRED_FUNC;
 yyt->REDUCE_STMT.RED_PARAMS = pRED_PARAMS;
 return yyt;
}

tTree mGLOBAL_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent pfunc, tTree pARRAY, tTree pINDEXED_ARRAY, tTree pINDEXES, tTree pMASK)
# else
(pfunc, pARRAY, pINDEXED_ARRAY, pINDEXES, pMASK)
tIdent pfunc;
tTree pARRAY;
tTree pINDEXED_ARRAY;
tTree pINDEXES;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGLOBAL_STMT])
 yyt->Kind = kGLOBAL_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GLOBAL_STMT.func = pfunc;
 yyt->GLOBAL_STMT.ARRAY = pARRAY;
 yyt->GLOBAL_STMT.INDEXED_ARRAY = pINDEXED_ARRAY;
 yyt->GLOBAL_STMT.INDEXES = pINDEXES;
 yyt->GLOBAL_STMT.MASK = pMASK;
 return yyt;
}

tTree mALIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pALIGNEE, tTree pALIGN_SPEC)
# else
(pALIGNEE, pALIGN_SPEC)
tTree pALIGNEE;
tTree pALIGN_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_STMT])
 yyt->Kind = kALIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_STMT.ALIGNEE = pALIGNEE;
 yyt->ALIGN_STMT.ALIGN_SPEC = pALIGN_SPEC;
 return yyt;
}

tTree mDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pDISTRIBUTEE, tTree pDISTRIBUTION, tIdent ptarget)
# else
(pDISTRIBUTEE, pDISTRIBUTION, ptarget)
tTree pDISTRIBUTEE;
tTree pDISTRIBUTION;
tIdent ptarget;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTE_STMT])
 yyt->Kind = kDISTRIBUTE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTE_STMT.DISTRIBUTEE = pDISTRIBUTEE;
 yyt->DISTRIBUTE_STMT.DISTRIBUTION = pDISTRIBUTION;
 yyt->DISTRIBUTE_STMT.target = ptarget;
 return yyt;
}

tTree mLABEL_USE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_USE_LIST])
 yyt->Kind = kLABEL_USE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_EMPTY])
 yyt->Kind = kLABEL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_LIST
# if defined __STDC__ | defined __cplusplus
(int pElem, tTree pNext)
# else
(pElem, pNext)
int pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_LIST])
 yyt->Kind = kLABEL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_LIST.Elem = pElem;
 yyt->LABEL_LIST.Next = pNext;
 return yyt;
}

tTree mOP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP])
 yyt->Kind = kOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQ
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQ])
 yyt->Kind = kOP_EQ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NE])
 yyt->Kind = kOP_NE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LT])
 yyt->Kind = kOP_LT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GT])
 yyt->Kind = kOP_GT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GE])
 yyt->Kind = kOP_GE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LE])
 yyt->Kind = kOP_LE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_PLUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_PLUS])
 yyt->Kind = kOP_PLUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_MINUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_MINUS])
 yyt->Kind = kOP_MINUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_XOR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_XOR])
 yyt->Kind = kOP_XOR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_OR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_OR])
 yyt->Kind = kOP_OR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_CONCAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_CONCAT])
 yyt->Kind = kOP_CONCAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_TIMES
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_TIMES])
 yyt->Kind = kOP_TIMES;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DIVIDE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DIVIDE])
 yyt->Kind = kOP_DIVIDE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DIV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DIV])
 yyt->Kind = kOP_DIV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_AND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_AND])
 yyt->Kind = kOP_AND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQV])
 yyt->Kind = kOP_EQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NEQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NEQV])
 yyt->Kind = kOP_NEQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EXPO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXPO])
 yyt->Kind = kOP_EXPO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_MOD
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_MOD])
 yyt->Kind = kOP_MOD;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_IN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_IN])
 yyt->Kind = kOP_IN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DEFINED
# if defined __STDC__ | defined __cplusplus
(tIdent popname)
# else
(popname)
tIdent popname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DEFINED])
 yyt->Kind = kOP_DEFINED;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_DEFINED.opname = popname;
 return yyt;
}

tTree mOP_ASSIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_ASSIGN])
 yyt->Kind = kOP_ASSIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LEFT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LEFT])
 yyt->Kind = kOP_LEFT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_RIGHT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_RIGHT])
 yyt->Kind = kOP_RIGHT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LIST])
 yyt->Kind = kOP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_IOR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_IOR])
 yyt->Kind = kOP_IOR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_IXOR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_IXOR])
 yyt->Kind = kOP_IXOR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_IAND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_IAND])
 yyt->Kind = kOP_IAND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_NOT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_NOT])
 yyt->Kind = kOP1_NOT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_SIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_SIGN])
 yyt->Kind = kOP1_SIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_INOT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_INOT])
 yyt->Kind = kOP1_INOT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_SIZE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_SIZE])
 yyt->Kind = kOP1_SIZE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_DEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_DEC])
 yyt->Kind = kOP1_DEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_INC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_INC])
 yyt->Kind = kOP1_INC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_ADDRESS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_ADDRESS])
 yyt->Kind = kOP1_ADDRESS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_DEREF
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_DEREF])
 yyt->Kind = kOP1_DEREF;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBT_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP])
 yyt->Kind = kBT_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_EXP])
 yyt->Kind = kDUMMY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mCONST_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pC)
# else
(pC)
tTree pC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONST_EXP])
 yyt->Kind = kCONST_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CONST_EXP.C = pC;
 return yyt;
}

tTree mOP_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP, tTree pOPND1, tTree pOPND2)
# else
(pEXP_OP, pOPND1, pOPND2)
tTree pEXP_OP;
tTree pOPND1;
tTree pOPND2;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXP])
 yyt->Kind = kOP_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_EXP.EXP_OP = pEXP_OP;
 yyt->OP_EXP.OPND1 = pOPND1;
 yyt->OP_EXP.OPND2 = pOPND2;
 return yyt;
}

tTree mOP1_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP1, tTree pOPND)
# else
(pEXP_OP1, pOPND)
tTree pEXP_OP1;
tTree pOPND;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_EXP])
 yyt->Kind = kOP1_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP1_EXP.EXP_OP1 = pEXP_OP1;
 yyt->OP1_EXP.OPND = pOPND;
 return yyt;
}

tTree mSLICE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pSTART, tTree pSTOP, tTree pINC)
# else
(pSTART, pSTOP, pINC)
tTree pSTART;
tTree pSTOP;
tTree pINC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSLICE_EXP])
 yyt->Kind = kSLICE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SLICE_EXP.START = pSTART;
 yyt->SLICE_EXP.STOP = pSTOP;
 yyt->SLICE_EXP.INC = pINC;
 return yyt;
}

tTree mPOSTFIX_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pPOSTFIX_OP, tTree pOPND)
# else
(pPOSTFIX_OP, pOPND)
tTree pPOSTFIX_OP;
tTree pOPND;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOSTFIX_EXP])
 yyt->Kind = kPOSTFIX_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POSTFIX_EXP.POSTFIX_OP = pPOSTFIX_OP;
 yyt->POSTFIX_EXP.OPND = pOPND;
 return yyt;
}

tTree mCALL_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pFUNC_ID, tTree pFUNC_PARAMS)
# else
(pFUNC_ID, pFUNC_PARAMS)
tTree pFUNC_ID;
tTree pFUNC_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCALL_EXP])
 yyt->Kind = kCALL_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CALL_EXP.FUNC_ID = pFUNC_ID;
 yyt->CALL_EXP.FUNC_PARAMS = pFUNC_PARAMS;
 return yyt;
}

tTree mCAST_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pCAST)
# else
(pID, pCAST)
tTree pID;
tTree pCAST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCAST_EXP])
 yyt->Kind = kCAST_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CAST_EXP.ID = pID;
 yyt->CAST_EXP.CAST = pCAST;
 return yyt;
}

tTree mINDEXED_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pIND_EXP, tTree pINDEX)
# else
(pIND_EXP, pINDEX)
tTree pIND_EXP;
tTree pINDEX;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEXED_EXP])
 yyt->Kind = kINDEXED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEXED_EXP.IND_EXP = pIND_EXP;
 yyt->INDEXED_EXP.INDEX = pINDEX;
 return yyt;
}

tTree mSELECTED_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pSELEC_EXP, tTree pSELECTOR)
# else
(pSELEC_EXP, pSELECTOR)
tTree pSELEC_EXP;
tTree pSELECTOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_EXP])
 yyt->Kind = kSELECTED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_EXP.SELEC_EXP = pSELEC_EXP;
 yyt->SELECTED_EXP.SELECTOR = pSELECTOR;
 return yyt;
}

tTree mASSIGN_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_OP, tTree pLHS, tTree pRHS)
# else
(pASSIGN_OP, pLHS, pRHS)
tTree pASSIGN_OP;
tTree pLHS;
tTree pRHS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_EXP])
 yyt->Kind = kASSIGN_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASSIGN_EXP.ASSIGN_OP = pASSIGN_OP;
 yyt->ASSIGN_EXP.LHS = pLHS;
 yyt->ASSIGN_EXP.RHS = pRHS;
 return yyt;
}

tTree mUSED_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pVARNAME)
# else
(pVARNAME)
tTree pVARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSED_EXP])
 yyt->Kind = kUSED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USED_EXP.VARNAME = pVARNAME;
 return yyt;
}

tTree mCOND_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pCOND, tTree pTRUE_EXP, tTree pFALSE_EXP)
# else
(pCOND, pTRUE_EXP, pFALSE_EXP)
tTree pCOND;
tTree pTRUE_EXP;
tTree pFALSE_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOND_EXP])
 yyt->Kind = kCOND_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COND_EXP.COND = pCOND;
 yyt->COND_EXP.TRUE_EXP = pTRUE_EXP;
 yyt->COND_EXP.FALSE_EXP = pFALSE_EXP;
 return yyt;
}

tTree mVAR_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_EXP])
 yyt->Kind = kVAR_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_EXP.V = pV;
 return yyt;
}

tTree mFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pFUNC_ID, tTree pFUNC_PARAMS)
# else
(pFUNC_ID, pFUNC_PARAMS)
tTree pFUNC_ID;
tTree pFUNC_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_CALL_EXP])
 yyt->Kind = kFUNC_CALL_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_CALL_EXP.FUNC_ID = pFUNC_ID;
 yyt->FUNC_CALL_EXP.FUNC_PARAMS = pFUNC_PARAMS;
 return yyt;
}

tTree mNAMED_EXP
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_EXP])
 yyt->Kind = kNAMED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_EXP.Name = pName;
 yyt->NAMED_EXP.VAL = pVAL;
 return yyt;
}

tTree mDO_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_EXP])
 yyt->Kind = kDO_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_EXP.DO_ID = pDO_ID;
 yyt->DO_EXP.RANGE = pRANGE;
 yyt->DO_EXP.BODY = pBODY;
 return yyt;
}

tTree mTYPE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pELEMENTS)
# else
(pID, pELEMENTS)
tTree pID;
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_EXP])
 yyt->Kind = kTYPE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_EXP.ID = pID;
 yyt->TYPE_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mARRAY_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pELEMENTS)
# else
(pELEMENTS)
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_EXP])
 yyt->Kind = kARRAY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mBT_EXP_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP_LIST])
 yyt->Kind = kBT_EXP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_EMPTY])
 yyt->Kind = kBTE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_LIST])
 yyt->Kind = kBTE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTE_LIST.Elem = pElem;
 yyt->BTE_LIST.Next = pNext;
 return yyt;
}

tTree mBT_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR])
 yyt->Kind = kBT_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_VAR])
 yyt->Kind = kDUMMY_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUSED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVARNAME)
# else
(pVARNAME)
tTree pVARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSED_VAR])
 yyt->Kind = kUSED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USED_VAR.VARNAME = pVARNAME;
 return yyt;
}

tTree mINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXPS)
# else
(pIND_VAR, pIND_EXPS)
tTree pIND_VAR;
tTree pIND_EXPS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEXED_VAR])
 yyt->Kind = kINDEXED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEXED_VAR.IND_VAR = pIND_VAR;
 yyt->INDEXED_VAR.IND_EXPS = pIND_EXPS;
 return yyt;
}

tTree mSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXP)
# else
(pIND_VAR, pIND_EXP)
tTree pIND_VAR;
tTree pIND_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSUBSTRING_VAR])
 yyt->Kind = kSUBSTRING_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SUBSTRING_VAR.IND_VAR = pIND_VAR;
 yyt->SUBSTRING_VAR.IND_EXP = pIND_EXP;
 return yyt;
}

tTree mSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pSELEC_VAR, tTree pSELECTOR)
# else
(pSELEC_VAR, pSELECTOR)
tTree pSELEC_VAR;
tTree pSELECTOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_VAR])
 yyt->Kind = kSELECTED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_VAR.SELEC_VAR = pSELEC_VAR;
 yyt->SELECTED_VAR.SELECTOR = pSELECTOR;
 return yyt;
}

tTree mLOOP_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_VARNAME)
# else
(pLOOP_VARNAME)
tTree pLOOP_VARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLOOP_VAR])
 yyt->Kind = kLOOP_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LOOP_VAR.LOOP_VARNAME = pLOOP_VARNAME;
 return yyt;
}

tTree mADDR
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kADDR])
 yyt->Kind = kADDR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ADDR.E = pE;
 return yyt;
}

tTree mDO_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_VAR])
 yyt->Kind = kDO_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_VAR.DO_ID = pDO_ID;
 yyt->DO_VAR.RANGE = pRANGE;
 yyt->DO_VAR.BODY = pBODY;
 return yyt;
}

tTree mBT_VAR_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR_LIST])
 yyt->Kind = kBT_VAR_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_EMPTY])
 yyt->Kind = kBTV_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_LIST])
 yyt->Kind = kBTV_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTV_LIST.Elem = pElem;
 yyt->BTV_LIST.Next = pNext;
 return yyt;
}

tTree mBT_PARAM
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM])
 yyt->Kind = kBT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mVAR_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM])
 yyt->Kind = kVAR_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM.V = pV;
 return yyt;
}

tTree mVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVALUE_PARAM])
 yyt->Kind = kVALUE_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VALUE_PARAM.E = pE;
 return yyt;
}

tTree mNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_PARAM])
 yyt->Kind = kNAMED_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_PARAM.Name = pName;
 yyt->NAMED_PARAM.VAL = pVAL;
 return yyt;
}

tTree mPROC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pP)
# else
(pP)
tTree pP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_PARAM])
 yyt->Kind = kPROC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_PARAM.P = pP;
 return yyt;
}

tTree mFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pF)
# else
(pF)
tTree pF;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_PARAM])
 yyt->Kind = kFUNC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_PARAM.F = pF;
 return yyt;
}

tTree mFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
(tStringRef pS)
# else
(pS)
tStringRef pS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_PARAM])
 yyt->Kind = kFORMAT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_PARAM.S = pS;
 return yyt;
}

tTree mRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
(int plabel)
# else
(plabel)
int plabel;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_PARAM])
 yyt->Kind = kRETURN_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_PARAM.label = plabel;
 return yyt;
}

tTree mNO_PARAM
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_PARAM])
 yyt->Kind = kNO_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBT_PARAM_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM_LIST])
 yyt->Kind = kBT_PARAM_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_EMPTY])
 yyt->Kind = kBTP_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_LIST])
 yyt->Kind = kBTP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTP_LIST.Elem = pElem;
 yyt->BTP_LIST.Next = pNext;
 return yyt;
}

tTree mCONSTANT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONSTANT])
 yyt->Kind = kCONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOL_CONSTANT])
 yyt->Kind = kBOOL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOL_CONSTANT.value = pvalue;
 return yyt;
}

tTree mINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINT_CONSTANT])
 yyt->Kind = kINT_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INT_CONSTANT.value = pvalue;
 return yyt;
}

tTree mREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue)
# else
(pvalue)
tStringRef pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_CONSTANT])
 yyt->Kind = kREAL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_CONSTANT.value = pvalue;
 return yyt;
}

tTree mDREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue)
# else
(pvalue)
tStringRef pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDREAL_CONSTANT])
 yyt->Kind = kDREAL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DREAL_CONSTANT.value = pvalue;
 return yyt;
}

tTree mCHAR_CONSTANT
# if defined __STDC__ | defined __cplusplus
(char pvalue)
# else
(pvalue)
char pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCHAR_CONSTANT])
 yyt->Kind = kCHAR_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CHAR_CONSTANT.value = pvalue;
 return yyt;
}

tTree mSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue)
# else
(pvalue)
tStringRef pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_CONSTANT])
 yyt->Kind = kSTRING_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_CONSTANT.value = pvalue;
 return yyt;
}

tTree mCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef prvalue, tStringRef pivalue)
# else
(prvalue, pivalue)
tStringRef prvalue;
tStringRef pivalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_CONSTANT])
 yyt->Kind = kCOMPLEX_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_CONSTANT.rvalue = prvalue;
 yyt->COMPLEX_CONSTANT.ivalue = pivalue;
 return yyt;
}

tTree mPROC_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_OBJ])
 yyt->Kind = kPROC_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_OBJ.Ident = pIdent;
 begintDefinitions(yyt->PROC_OBJ.Object)
 return yyt;
}

tTree mVAR_OBJ
# if defined __STDC__ | defined __cplusplus
(int pPos, tIdent pIdent)
# else
(pPos, pIdent)
int pPos;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_OBJ])
 yyt->Kind = kVAR_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_OBJ.Pos = pPos;
 yyt->VAR_OBJ.Ident = pIdent;
 begintDefinitions(yyt->VAR_OBJ.Object)
 return yyt;
}

tTree mTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_OBJ])
 yyt->Kind = kTYPE_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TYPE_OBJ.Object)
 return yyt;
}

tTree mREC_COMP
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREC_COMP])
 yyt->Kind = kREC_COMP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REC_COMP.Ident = pIdent;
 begintDefinitions(yyt->REC_COMP.Object)
 return yyt;
}

typedef tTree * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kCOMP_UNIT:
yyt = yyt->COMP_UNIT.COMP_ELEMENTS; break;
case kBODY_NODE:
yyMark (yyt->BODY_NODE.DECLS);
yyMark (yyt->BODY_NODE.STATS);
yyt = yyt->BODY_NODE.INTERNALS; break;
case kSTRING_TYPE:
yyt = yyt->STRING_TYPE.LENGTH; break;
case kINDEX_TYPE:
yyMark (yyt->INDEX_TYPE.LOWER);
yyt = yyt->INDEX_TYPE.UPPER; break;
case kTYPE_ID:
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
yyMark (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kUNION_TYPE:
yyt = yyt->UNION_TYPE.COMPONENTS; break;
case kENUM_TYPE:
yyt = yyt->ENUM_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kARRAY1_TYPE:
yyMark (yyt->ARRAY1_TYPE.SIZE);
yyt = yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE; break;
case kFUNCTION_TYPE:
yyMark (yyt->FUNCTION_TYPE.FORMALS);
yyt = yyt->FUNCTION_TYPE.RESULT_TYPE; break;
case kTYPE_LIST:
yyMark (yyt->TYPE_LIST.Elem);
yyt = yyt->TYPE_LIST.Next; break;
case kMODULE_DECL:
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
yyMark (yyt->PROGRAM_DECL.FORMALS);
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
yyMark (yyt->PROC_DECL.FORMALS);
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
yyMark (yyt->FUNC_DECL.FORMALS);
yyMark (yyt->FUNC_DECL.FUNC_BODY);
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL:
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kTYPE_DECL:
yyt = yyt->TYPE_DECL.VAL; break;
case kENTITY_DECL:
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSTMT_FUNC_DECL:
yyMark (yyt->STMT_FUNC_DECL.FORMALS);
yyMark (yyt->STMT_FUNC_DECL.RESULT_TYPE);
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
yyMark (yyt->INTERFACE_DECL.SPEC);
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kEXT_PROC_DECL:
yyt = yyt->EXT_PROC_DECL.FORMALS; break;
case kEXT_FUNC_DECL:
yyMark (yyt->EXT_FUNC_DECL.FORMALS);
yyt = yyt->EXT_FUNC_DECL.RESULT_TYPE; break;
case kVAL_PARAM_DECL:
yyt = yyt->VAL_PARAM_DECL.VAL; break;
case kVAR_PARAM_DECL:
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kPROC_PARAM_DECL:
yyt = yyt->PROC_PARAM_DECL.FORMAL; break;
case kFUNC_PARAM_DECL:
yyMark (yyt->FUNC_PARAM_DECL.FORMAL);
yyt = yyt->FUNC_PARAM_DECL.RESULT_TYPE; break;
case kIMPLICIT_DECL:
yyt = yyt->IMPLICIT_DECL.VAL; break;
case kUSE_DECL:
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
yyMark (yyt->DATA_DECL.VARS);
yyt = yyt->DATA_DECL.VALS; break;
case kDIMENSION_DECL:
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kPARAMETER_DECL:
yyt = yyt->PARAMETER_DECL.VAL; break;
case kDISTRIBUTE_DECL:
yyt = yyt->DISTRIBUTE_DECL.DISTRIBUTION; break;
case kALIGN_DECL:
yyMark (yyt->ALIGN_DECL.ALIGN_SOURCE);
yyt = yyt->ALIGN_DECL.ALIGN_SPEC; break;
case kDECL_LIST:
yyMark (yyt->DECL_LIST.Elem);
yyt = yyt->DECL_LIST.Next; break;
case kNODE_DISTRIBUTION:
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kBLOCK_DISTRIBUTION:
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kDIST_LIST:
yyMark (yyt->DIST_LIST.Elem);
yyt = yyt->DIST_LIST.Next; break;
case kOP_GENERIC_SPEC:
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
yyMark (yyt->ACF_LIST.Elem);
yyt = yyt->ACF_LIST.Next; break;
case kACF_BASIC:
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
yyMark (yyt->ACF_IF.IF_EXP);
yyMark (yyt->ACF_IF.THEN_PART);
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
yyMark (yyt->ACF_WHERE.WHERE_EXP);
yyMark (yyt->ACF_WHERE.TRUE_PART);
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_SWITCH:
yyMark (yyt->ACF_SWITCH.SWITCH_EXP);
yyt = yyt->ACF_SWITCH.SWITCH_STMT; break;
case kACF_ALTER:
yyMark (yyt->ACF_ALTER.ALTER_EXP);
yyt = yyt->ACF_ALTER.ALTER_STMT; break;
case kACF_CASE:
yyMark (yyt->ACF_CASE.CASE_EXP);
yyMark (yyt->ACF_CASE.CASE_ALTS);
yyt = yyt->ACF_CASE.CASE_OTHERWISE; break;
case kACF_WHILE:
yyMark (yyt->ACF_WHILE.WHILE_EXP);
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
yyMark (yyt->ACF_REPEAT.REPEAT_BODY);
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_WITH:
yyMark (yyt->ACF_WITH.WITH_VARS);
yyt = yyt->ACF_WITH.WITH_BODY; break;
case kACF_LOOP:
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
yyMark (yyt->ACF_DO.DO_ID);
yyMark (yyt->ACF_DO.DO_RANGE);
yyt = yyt->ACF_DO.DO_BODY; break;
case kACF_DOLOCAL:
yyMark (yyt->ACF_DOLOCAL.DOLOCAL_ID);
yyMark (yyt->ACF_DOLOCAL.DOLOCAL_RANGE);
yyt = yyt->ACF_DOLOCAL.DOLOCAL_BODY; break;
case kACF_DOVEC:
yyMark (yyt->ACF_DOVEC.DOVEC_ID);
yyMark (yyt->ACF_DOVEC.DOVEC_RANGE);
yyt = yyt->ACF_DOVEC.DOVEC_BODY; break;
case kACF_DOALL:
yyMark (yyt->ACF_DOALL.DOALL_NEW);
yyMark (yyt->ACF_DOALL.DOALL_ID);
yyMark (yyt->ACF_DOALL.DOALL_RANGE);
yyt = yyt->ACF_DOALL.DOALL_BODY; break;
case kACF_FORALL:
yyMark (yyt->ACF_FORALL.FORALL_ID);
yyMark (yyt->ACF_FORALL.FORALL_RANGE);
yyt = yyt->ACF_FORALL.FORALL_BODY; break;
case kACF_ON:
yyMark (yyt->ACF_ON.ON_VAR);
yyt = yyt->ACF_ON.ON_STMT; break;
case kACF_BODY:
yyt = yyt->ACF_BODY.NEW_BODY; break;
case kACF_FLOW_GRAPH:
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kSELECTED_ACF_LIST:
yyMark (yyt->SELECTED_ACF_LIST.Elem);
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
yyMark (yyt->SELECTED_ACF_NODE.SELECT_LIST);
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kEXP_STMT:
yyt = yyt->EXP_STMT.STMT_EXP; break;
case kASSIGN_STMT:
yyMark (yyt->ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
yyMark (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
yyMark (yyt->CALL_STMT.CALL_ID);
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
yyMark (yyt->IO_STMT.ID);
yyMark (yyt->IO_STMT.IO_SPECS);
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kASS_GOTO_STMT:
yyMark (yyt->ASS_GOTO_STMT.GOTO_VAR);
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
yyMark (yyt->COMP_GOTO_STMT.GOTO_LABELS);
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kSTOP_STMT:
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kALLOCATE_STMT:
yyMark (yyt->ALLOCATE_STMT.PARAMS);
yyt = yyt->ALLOCATE_STMT.STAT; break;
case kDEALLOCATE_STMT:
yyMark (yyt->DEALLOCATE_STMT.PARAMS);
yyt = yyt->DEALLOCATE_STMT.STAT; break;
case kNULLIFY_STMT:
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
yyMark (yyt->REDUCE_STMT.RED_FUNC);
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kGLOBAL_STMT:
yyMark (yyt->GLOBAL_STMT.ARRAY);
yyMark (yyt->GLOBAL_STMT.INDEXED_ARRAY);
yyMark (yyt->GLOBAL_STMT.INDEXES);
yyt = yyt->GLOBAL_STMT.MASK; break;
case kALIGN_STMT:
yyMark (yyt->ALIGN_STMT.ALIGNEE);
yyt = yyt->ALIGN_STMT.ALIGN_SPEC; break;
case kDISTRIBUTE_STMT:
yyMark (yyt->DISTRIBUTE_STMT.DISTRIBUTEE);
yyt = yyt->DISTRIBUTE_STMT.DISTRIBUTION; break;
case kLABEL_LIST:
yyt = yyt->LABEL_LIST.Next; break;
case kCONST_EXP:
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
yyMark (yyt->OP_EXP.EXP_OP);
yyMark (yyt->OP_EXP.OPND1);
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
yyMark (yyt->OP1_EXP.EXP_OP1);
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
yyMark (yyt->SLICE_EXP.START);
yyMark (yyt->SLICE_EXP.STOP);
yyt = yyt->SLICE_EXP.INC; break;
case kPOSTFIX_EXP:
yyMark (yyt->POSTFIX_EXP.POSTFIX_OP);
yyt = yyt->POSTFIX_EXP.OPND; break;
case kCALL_EXP:
yyMark (yyt->CALL_EXP.FUNC_ID);
yyt = yyt->CALL_EXP.FUNC_PARAMS; break;
case kCAST_EXP:
yyMark (yyt->CAST_EXP.ID);
yyt = yyt->CAST_EXP.CAST; break;
case kINDEXED_EXP:
yyMark (yyt->INDEXED_EXP.IND_EXP);
yyt = yyt->INDEXED_EXP.INDEX; break;
case kSELECTED_EXP:
yyMark (yyt->SELECTED_EXP.SELEC_EXP);
yyt = yyt->SELECTED_EXP.SELECTOR; break;
case kASSIGN_EXP:
yyMark (yyt->ASSIGN_EXP.ASSIGN_OP);
yyMark (yyt->ASSIGN_EXP.LHS);
yyt = yyt->ASSIGN_EXP.RHS; break;
case kUSED_EXP:
yyt = yyt->USED_EXP.VARNAME; break;
case kCOND_EXP:
yyMark (yyt->COND_EXP.COND);
yyMark (yyt->COND_EXP.TRUE_EXP);
yyt = yyt->COND_EXP.FALSE_EXP; break;
case kVAR_EXP:
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
yyMark (yyt->FUNC_CALL_EXP.FUNC_ID);
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
yyMark (yyt->DO_EXP.DO_ID);
yyMark (yyt->DO_EXP.RANGE);
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
yyMark (yyt->TYPE_EXP.ID);
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kBTE_LIST:
yyMark (yyt->BTE_LIST.Elem);
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
yyMark (yyt->INDEXED_VAR.IND_VAR);
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
yyMark (yyt->SUBSTRING_VAR.IND_VAR);
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
yyMark (yyt->SELECTED_VAR.SELEC_VAR);
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kADDR:
yyt = yyt->ADDR.E; break;
case kDO_VAR:
yyMark (yyt->DO_VAR.DO_ID);
yyMark (yyt->DO_VAR.RANGE);
yyt = yyt->DO_VAR.BODY; break;
case kBTV_LIST:
yyMark (yyt->BTV_LIST.Elem);
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyt = yyt->FUNC_PARAM.F; break;
case kBTP_LIST:
yyMark (yyt->BTP_LIST.Elem);
yyt = yyt->BTP_LIST.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tTree yyTreeStore [yyInitTreeStoreSize];
static tTree * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;
extern void exit ();

static Tree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteTree ();

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) (void) fputs ("NoTree", yyf);
 else yyWriteHex ((unsigned char *) & yyt, sizeof (yyt));
 yyWriteNl ();
}

static void yWriteNodeCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("COMP_ELEMENTS"); yyWriteAdr (yyt->COMP_UNIT.COMP_ELEMENTS);
}

static void yWriteNodeBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DECLS"); yyWriteAdr (yyt->BODY_NODE.DECLS);
 yyWriteSelector ("STATS"); yyWriteAdr (yyt->BODY_NODE.STATS);
 yyWriteSelector ("INTERNALS"); yyWriteAdr (yyt->BODY_NODE.INTERNALS);
}

static void yWriteNodeINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("size"); writeint (yyt->INTEGER_TYPE.size) yyWriteNl ();
}

static void yWriteNodeCARDINAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("size"); writeint (yyt->CARDINAL_TYPE.size) yyWriteNl ();
}

static void yWriteNodeREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("size"); writeint (yyt->REAL_TYPE.size) yyWriteNl ();
}

static void yWriteNodeBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("size"); writeint (yyt->BOOLEAN_TYPE.size) yyWriteNl ();
}

static void yWriteNodeCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("size"); writeint (yyt->COMPLEX_TYPE.size) yyWriteNl ();
}

static void yWriteNodeSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LENGTH"); yyWriteAdr (yyt->STRING_TYPE.LENGTH);
}

static void yWriteNodeINDEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->INDEX_TYPE.LOWER);
 yyWriteSelector ("UPPER"); yyWriteAdr (yyt->INDEX_TYPE.UPPER);
 yyWriteSelector ("left_overlap"); writeint (yyt->INDEX_TYPE.left_overlap) yyWriteNl ();
 yyWriteSelector ("right_overlap"); writeint (yyt->INDEX_TYPE.right_overlap) yyWriteNl ();
}

static void yWriteNodeTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_ID.ID);
}

static void yWriteNodeARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY_INDEX_TYPES"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
 yyWriteSelector ("ARRAY_COMP_TYPE"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_COMP_TYPE);
}

static void yWriteNodeRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
 yyWriteSelector ("COMPONENTS"); yyWriteAdr (yyt->RECORD_TYPE.COMPONENTS);
}

static void yWriteNodeUNION_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->UNION_TYPE.Name) yyWriteNl ();
 yyWriteSelector ("COMPONENTS"); yyWriteAdr (yyt->UNION_TYPE.COMPONENTS);
}

static void yWriteNodeENUM_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->ENUM_TYPE.Name) yyWriteNl ();
 yyWriteSelector ("COMPONENTS"); yyWriteAdr (yyt->ENUM_TYPE.COMPONENTS);
}

static void yWriteNodeDYNAMIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Shape"); writetTree (yyt->DYNAMIC.Shape) yyWriteNl ();
 yyWriteSelector ("left_overlap"); writeint (yyt->DYNAMIC.left_overlap) yyWriteNl ();
 yyWriteSelector ("right_overlap"); writeint (yyt->DYNAMIC.right_overlap) yyWriteNl ();
}

static void yWriteNodePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PTR_COMP"); yyWriteAdr (yyt->POINTER_TYPE.PTR_COMP);
}

static void yWriteNodeARRAY1_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->ARRAY1_TYPE.SIZE);
 yyWriteSelector ("ARRAY1_COMP_TYPE"); yyWriteAdr (yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE);
}

static void yWriteNodeFUNCTION_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->FUNCTION_TYPE.FORMALS);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->FUNCTION_TYPE.RESULT_TYPE);
}

static void yWriteNodeTYPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->TYPE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->TYPE_LIST.Next);
}

static void yWriteNodeDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->DECL_NODE.Name) yyWriteNl ();
 yyWriteSelector ("Pos"); writeint (yyt->DECL_NODE.Pos) yyWriteNl ();
}

static void yWriteNodeMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("MODULE_BODY"); yyWriteAdr (yyt->MODULE_DECL.MODULE_BODY);
}

static void yWriteNodePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROGRAM_DECL.FORMALS);
 yyWriteSelector ("PROGRAM_BODY"); yyWriteAdr (yyt->PROGRAM_DECL.PROGRAM_BODY);
}

static void yWriteNodePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROC_DECL.FORMALS);
 yyWriteSelector ("PROC_BODY"); yyWriteAdr (yyt->PROC_DECL.PROC_BODY);
 yyWriteSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writeint (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->FUNC_DECL.FORMALS);
 yyWriteSelector ("FUNC_BODY"); yyWriteAdr (yyt->FUNC_DECL.FUNC_BODY);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyWriteSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writeint (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DATA_BODY"); yyWriteAdr (yyt->BLOCK_DATA_DECL.DATA_BODY);
}

static void yWriteNodeTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPE_DECL.VAL);
}

static void yWriteNodeNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteNodeENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ATTRIBUTES"); yyWriteAdr (yyt->ENTITY_DECL.ATTRIBUTES);
}

static void yWriteNodeVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_DECL.VAL);
}

static void yWriteNodeCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->COMMON_DECL.IDS);
}

static void yWriteNodeNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->NAMELIST_DECL.IDS);
}

static void yWriteNodeTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->TEMPLATE_DECL.DIMENSIONS);
}

static void yWriteNodePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->PROCESSORS_DECL.DIMENSIONS);
}

static void yWriteNodeINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->STMT_FUNC_DECL.FORMALS);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->STMT_FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("FFUNC_BODY"); yyWriteAdr (yyt->STMT_FUNC_DECL.FFUNC_BODY);
}

static void yWriteNodeINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("SPEC"); yyWriteAdr (yyt->INTERFACE_DECL.SPEC);
 yyWriteSelector ("ITEMS"); yyWriteAdr (yyt->INTERFACE_DECL.ITEMS);
}

static void yWriteNodeEXT_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->EXT_PROC_DECL.FORMALS);
}

static void yWriteNodeEXT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->EXT_FUNC_DECL.FORMALS);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->EXT_FUNC_DECL.RESULT_TYPE);
}

static void yWriteNodeVAL_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAL_PARAM_DECL.VAL);
}

static void yWriteNodeVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_PARAM_DECL.VAL);
}

static void yWriteNodePROC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMAL"); yyWriteAdr (yyt->PROC_PARAM_DECL.FORMAL);
}

static void yWriteNodeFUNC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMAL"); yyWriteAdr (yyt->FUNC_PARAM_DECL.FORMAL);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->FUNC_PARAM_DECL.RESULT_TYPE);
}

static void yWriteNodeELIPSIS_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyWriteSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->IMPLICIT_DECL.VAL);
}

static void yWriteNodeUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("RENAMINGS"); yyWriteAdr (yyt->USE_DECL.RENAMINGS);
}

static void yWriteNodeONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("NAMES"); yyWriteAdr (yyt->ONLY_USE_DECL.NAMES);
}

static void yWriteNodeEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->EQV_DECL.VARS);
}

static void yWriteNodeDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->DATA_DECL.VARS);
 yyWriteSelector ("VALS"); yyWriteAdr (yyt->DATA_DECL.VALS);
}

static void yWriteNodeDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->DIMENSION_DECL.INDEXES);
}

static void yWriteNodeINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->INIT_DATA_DECL.VAL);
}

static void yWriteNodeTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPESPEC_DECL.VAL);
}

static void yWriteNodeALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteNodeINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PARAMETER_DECL.VAL);
}

static void yWriteNodePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->DISTRIBUTE_DECL.DISTRIBUTION);
 yyWriteSelector ("target"); writetIdent (yyt->DISTRIBUTE_DECL.target) yyWriteNl ();
}

static void yWriteNodeALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ALIGN_SOURCE"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_SOURCE);
 yyWriteSelector ("ALIGN_SPEC"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_SPEC);
}

static void yWriteNodeDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DECL_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DECL_LIST.Next);
}

static void yWriteNodeNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("MAPPING"); yyWriteAdr (yyt->NODE_DISTRIBUTION.MAPPING);
}

static void yWriteNodeBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->BLOCK_DISTRIBUTION.SIZE);
}

static void yWriteNodeCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->CYCLIC_DISTRIBUTION.SIZE);
}

static void yWriteNodeDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DIST_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DIST_LIST.Next);
}

static void yWriteNodeID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteNodeOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("OPERATOR"); yyWriteAdr (yyt->OP_GENERIC_SPEC.OPERATOR);
}

static void yWriteNodeACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->ACF_LIST.Next);
}

static void yWriteNodeACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteNodeACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
}

static void yWriteNodeACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("BASIC_STMT"); yyWriteAdr (yyt->ACF_BASIC.BASIC_STMT);
}

static void yWriteNodeACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->ACF_IF.IF_EXP);
 yyWriteSelector ("THEN_PART"); yyWriteAdr (yyt->ACF_IF.THEN_PART);
 yyWriteSelector ("ELSE_PART"); yyWriteAdr (yyt->ACF_IF.ELSE_PART);
}

static void yWriteNodeACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHERE_EXP"); yyWriteAdr (yyt->ACF_WHERE.WHERE_EXP);
 yyWriteSelector ("TRUE_PART"); yyWriteAdr (yyt->ACF_WHERE.TRUE_PART);
 yyWriteSelector ("FALSE_PART"); yyWriteAdr (yyt->ACF_WHERE.FALSE_PART);
}

static void yWriteNodeACF_SWITCH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("SWITCH_EXP"); yyWriteAdr (yyt->ACF_SWITCH.SWITCH_EXP);
 yyWriteSelector ("SWITCH_STMT"); yyWriteAdr (yyt->ACF_SWITCH.SWITCH_STMT);
}

static void yWriteNodeACF_ALTER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ALTER_EXP"); yyWriteAdr (yyt->ACF_ALTER.ALTER_EXP);
 yyWriteSelector ("ALTER_STMT"); yyWriteAdr (yyt->ACF_ALTER.ALTER_STMT);
}

static void yWriteNodeACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("CASE_EXP"); yyWriteAdr (yyt->ACF_CASE.CASE_EXP);
 yyWriteSelector ("CASE_ALTS"); yyWriteAdr (yyt->ACF_CASE.CASE_ALTS);
 yyWriteSelector ("CASE_OTHERWISE"); yyWriteAdr (yyt->ACF_CASE.CASE_OTHERWISE);
}

static void yWriteNodeACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHILE_EXP"); yyWriteAdr (yyt->ACF_WHILE.WHILE_EXP);
 yyWriteSelector ("WHILE_BODY"); yyWriteAdr (yyt->ACF_WHILE.WHILE_BODY);
}

static void yWriteNodeACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("REPEAT_BODY"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_BODY);
 yyWriteSelector ("REPEAT_EXP"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_EXP);
}

static void yWriteNodeACF_WITH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WITH_VARS"); yyWriteAdr (yyt->ACF_WITH.WITH_VARS);
 yyWriteSelector ("WITH_BODY"); yyWriteAdr (yyt->ACF_WITH.WITH_BODY);
}

static void yWriteNodeACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("LOOP_BODY"); yyWriteAdr (yyt->ACF_LOOP.LOOP_BODY);
}

static void yWriteNodeACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->ACF_DO.DO_ID);
 yyWriteSelector ("DO_RANGE"); yyWriteAdr (yyt->ACF_DO.DO_RANGE);
 yyWriteSelector ("DO_BODY"); yyWriteAdr (yyt->ACF_DO.DO_BODY);
}

static void yWriteNodeACF_DOLOCAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DOLOCAL_ID"); yyWriteAdr (yyt->ACF_DOLOCAL.DOLOCAL_ID);
 yyWriteSelector ("DOLOCAL_RANGE"); yyWriteAdr (yyt->ACF_DOLOCAL.DOLOCAL_RANGE);
 yyWriteSelector ("DOLOCAL_BODY"); yyWriteAdr (yyt->ACF_DOLOCAL.DOLOCAL_BODY);
}

static void yWriteNodeACF_DOVEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DOVEC_ID"); yyWriteAdr (yyt->ACF_DOVEC.DOVEC_ID);
 yyWriteSelector ("DOVEC_RANGE"); yyWriteAdr (yyt->ACF_DOVEC.DOVEC_RANGE);
 yyWriteSelector ("DOVEC_BODY"); yyWriteAdr (yyt->ACF_DOVEC.DOVEC_BODY);
}

static void yWriteNodeACF_DOALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DOALL_NEW"); yyWriteAdr (yyt->ACF_DOALL.DOALL_NEW);
 yyWriteSelector ("DOALL_ID"); yyWriteAdr (yyt->ACF_DOALL.DOALL_ID);
 yyWriteSelector ("DOALL_RANGE"); yyWriteAdr (yyt->ACF_DOALL.DOALL_RANGE);
 yyWriteSelector ("DOALL_BODY"); yyWriteAdr (yyt->ACF_DOALL.DOALL_BODY);
}

static void yWriteNodeACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FORALL_ID"); yyWriteAdr (yyt->ACF_FORALL.FORALL_ID);
 yyWriteSelector ("FORALL_RANGE"); yyWriteAdr (yyt->ACF_FORALL.FORALL_RANGE);
 yyWriteSelector ("FORALL_BODY"); yyWriteAdr (yyt->ACF_FORALL.FORALL_BODY);
}

static void yWriteNodeACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ON_VAR"); yyWriteAdr (yyt->ACF_ON.ON_VAR);
 yyWriteSelector ("ON_STMT"); yyWriteAdr (yyt->ACF_ON.ON_STMT);
}

static void yWriteNodeACF_BODY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("NEW_BODY"); yyWriteAdr (yyt->ACF_BODY.NEW_BODY);
 yyWriteSelector ("Entries"); writetDefinitions (yyt->ACF_BODY.Entries) yyWriteNl ();
}

static void yWriteNodeACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FLOW_NODES"); yyWriteAdr (yyt->ACF_FLOW_GRAPH.FLOW_NODES);
}

static void yWriteNodeACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ENTRY_DECL"); yyWriteAdr (yyt->ACF_ENTRY.ENTRY_DECL);
}

static void yWriteNodeSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Next);
}

static void yWriteNodeSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELECT_LIST"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_LIST);
 yyWriteSelector ("SELECT_ACFS"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_ACFS);
}

static void yWriteNodeEXP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("STMT_EXP"); yyWriteAdr (yyt->EXP_STMT.STMT_EXP);
}

static void yWriteNodeASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodeLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
 yyWriteSelector ("LABEL_VAR"); yyWriteAdr (yyt->LABEL_ASSIGN_STMT.LABEL_VAR);
}

static void yWriteNodeCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("CALL_ID"); yyWriteAdr (yyt->CALL_STMT.CALL_ID);
 yyWriteSelector ("CALL_PARAMS"); yyWriteAdr (yyt->CALL_STMT.CALL_PARAMS);
}

static void yWriteNodeIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->IO_STMT.ID);
 yyWriteSelector ("IO_SPECS"); yyWriteAdr (yyt->IO_STMT.IO_SPECS);
 yyWriteSelector ("IO_ITEMS"); yyWriteAdr (yyt->IO_STMT.IO_ITEMS);
}

static void yWriteNodeGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteNodeASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_VAR"); yyWriteAdr (yyt->ASS_GOTO_STMT.GOTO_VAR);
 yyWriteSelector ("LABELS"); yyWriteAdr (yyt->ASS_GOTO_STMT.LABELS);
}

static void yWriteNodeCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABELS"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_LABELS);
 yyWriteSelector ("GOTO_EXP"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_EXP);
}

static void yWriteNodeCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->COMP_IF_STMT.IF_EXP);
 yyWriteSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteNodeRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RETURN_EXP"); yyWriteAdr (yyt->RETURN_STMT.RETURN_EXP);
}

static void yWriteNodePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PAUSE_CONST"); yyWriteAdr (yyt->PAUSE_STMT.PAUSE_CONST);
}

static void yWriteNodeEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("STOP_CONST"); yyWriteAdr (yyt->STOP_STMT.STOP_CONST);
}

static void yWriteNodeFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FORMAT_PARAMS"); yyWriteAdr (yyt->FORMAT_STMT.FORMAT_PARAMS);
}

static void yWriteNodeALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->ALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STAT"); yyWriteAdr (yyt->ALLOCATE_STMT.STAT);
}

static void yWriteNodeDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->DEALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STAT"); yyWriteAdr (yyt->DEALLOCATE_STMT.STAT);
}

static void yWriteNodeNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->NULLIFY_STMT.PARAMS);
}

static void yWriteNodeREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RED_FUNC"); yyWriteAdr (yyt->REDUCE_STMT.RED_FUNC);
 yyWriteSelector ("RED_PARAMS"); yyWriteAdr (yyt->REDUCE_STMT.RED_PARAMS);
}

static void yWriteNodeGLOBAL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("func"); writetIdent (yyt->GLOBAL_STMT.func) yyWriteNl ();
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->GLOBAL_STMT.ARRAY);
 yyWriteSelector ("INDEXED_ARRAY"); yyWriteAdr (yyt->GLOBAL_STMT.INDEXED_ARRAY);
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->GLOBAL_STMT.INDEXES);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->GLOBAL_STMT.MASK);
}

static void yWriteNodeALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ALIGNEE"); yyWriteAdr (yyt->ALIGN_STMT.ALIGNEE);
 yyWriteSelector ("ALIGN_SPEC"); yyWriteAdr (yyt->ALIGN_STMT.ALIGN_SPEC);
}

static void yWriteNodeDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DISTRIBUTEE"); yyWriteAdr (yyt->DISTRIBUTE_STMT.DISTRIBUTEE);
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->DISTRIBUTE_STMT.DISTRIBUTION);
 yyWriteSelector ("target"); writetIdent (yyt->DISTRIBUTE_STMT.target) yyWriteNl ();
}

static void yWriteNodeLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
 yyWriteSelector ("Next"); yyWriteAdr (yyt->LABEL_LIST.Next);
}

static void yWriteNodeOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteNodeCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("C"); yyWriteAdr (yyt->CONST_EXP.C);
}

static void yWriteNodeOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP"); yyWriteAdr (yyt->OP_EXP.EXP_OP);
 yyWriteSelector ("OPND1"); yyWriteAdr (yyt->OP_EXP.OPND1);
 yyWriteSelector ("OPND2"); yyWriteAdr (yyt->OP_EXP.OPND2);
}

static void yWriteNodeOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP1"); yyWriteAdr (yyt->OP1_EXP.EXP_OP1);
 yyWriteSelector ("OPND"); yyWriteAdr (yyt->OP1_EXP.OPND);
}

static void yWriteNodeSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("START"); yyWriteAdr (yyt->SLICE_EXP.START);
 yyWriteSelector ("STOP"); yyWriteAdr (yyt->SLICE_EXP.STOP);
 yyWriteSelector ("INC"); yyWriteAdr (yyt->SLICE_EXP.INC);
}

static void yWriteNodePOSTFIX_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("POSTFIX_OP"); yyWriteAdr (yyt->POSTFIX_EXP.POSTFIX_OP);
 yyWriteSelector ("OPND"); yyWriteAdr (yyt->POSTFIX_EXP.OPND);
}

static void yWriteNodeCALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FUNC_ID"); yyWriteAdr (yyt->CALL_EXP.FUNC_ID);
 yyWriteSelector ("FUNC_PARAMS"); yyWriteAdr (yyt->CALL_EXP.FUNC_PARAMS);
}

static void yWriteNodeCAST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->CAST_EXP.ID);
 yyWriteSelector ("CAST"); yyWriteAdr (yyt->CAST_EXP.CAST);
}

static void yWriteNodeINDEXED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_EXP"); yyWriteAdr (yyt->INDEXED_EXP.IND_EXP);
 yyWriteSelector ("INDEX"); yyWriteAdr (yyt->INDEXED_EXP.INDEX);
}

static void yWriteNodeSELECTED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELEC_EXP"); yyWriteAdr (yyt->SELECTED_EXP.SELEC_EXP);
 yyWriteSelector ("SELECTOR"); yyWriteAdr (yyt->SELECTED_EXP.SELECTOR);
}

static void yWriteNodeASSIGN_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_OP"); yyWriteAdr (yyt->ASSIGN_EXP.ASSIGN_OP);
 yyWriteSelector ("LHS"); yyWriteAdr (yyt->ASSIGN_EXP.LHS);
 yyWriteSelector ("RHS"); yyWriteAdr (yyt->ASSIGN_EXP.RHS);
}

static void yWriteNodeUSED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VARNAME"); yyWriteAdr (yyt->USED_EXP.VARNAME);
}

static void yWriteNodeCOND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("COND"); yyWriteAdr (yyt->COND_EXP.COND);
 yyWriteSelector ("TRUE_EXP"); yyWriteAdr (yyt->COND_EXP.TRUE_EXP);
 yyWriteSelector ("FALSE_EXP"); yyWriteAdr (yyt->COND_EXP.FALSE_EXP);
}

static void yWriteNodeVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_EXP.V);
}

static void yWriteNodeFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FUNC_ID"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_ID);
 yyWriteSelector ("FUNC_PARAMS"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_PARAMS);
}

static void yWriteNodeNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_EXP.VAL);
}

static void yWriteNodeDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_EXP.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_EXP.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_EXP.BODY);
}

static void yWriteNodeTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_EXP.ID);
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->TYPE_EXP.ELEMENTS);
}

static void yWriteNodeARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->ARRAY_EXP.ELEMENTS);
}

static void yWriteNodeBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTE_LIST.Next);
}

static void yWriteNodeUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VARNAME"); yyWriteAdr (yyt->USED_VAR.VARNAME);
}

static void yWriteNodeINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->INDEXED_VAR.IND_VAR);
 yyWriteSelector ("IND_EXPS"); yyWriteAdr (yyt->INDEXED_VAR.IND_EXPS);
}

static void yWriteNodeSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_VAR);
 yyWriteSelector ("IND_EXP"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_EXP);
}

static void yWriteNodeSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELEC_VAR"); yyWriteAdr (yyt->SELECTED_VAR.SELEC_VAR);
 yyWriteSelector ("SELECTOR"); yyWriteAdr (yyt->SELECTED_VAR.SELECTOR);
}

static void yWriteNodeLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LOOP_VARNAME"); yyWriteAdr (yyt->LOOP_VAR.LOOP_VARNAME);
}

static void yWriteNodeADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->ADDR.E);
}

static void yWriteNodeDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_VAR.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_VAR.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_VAR.BODY);
}

static void yWriteNodeBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTV_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTV_LIST.Next);
}

static void yWriteNodeVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_PARAM.V);
}

static void yWriteNodeVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->VALUE_PARAM.E);
}

static void yWriteNodeNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_PARAM.VAL);
}

static void yWriteNodePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("P"); yyWriteAdr (yyt->PROC_PARAM.P);
}

static void yWriteNodeFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("F"); yyWriteAdr (yyt->FUNC_PARAM.F);
}

static void yWriteNodeFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteNodeRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteNodeBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTP_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTP_LIST.Next);
}

static void yWriteNodeBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeDREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->DREAL_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeCHAR_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writechar (yyt->CHAR_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyWriteSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWriteNodePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyWriteSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

void WriteTreeNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoTree) { (void) fputs ("NoTree\n", yyf); return; }

 switch (yyt->Kind) {
case kCOMP_UNIT: (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_UNIT (yyt); break;
case kBODY_NODE: (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBODY_NODE (yyt); break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kVOID_TYPE: (void) fputs (Tree_NodeName [kVOID_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kINTEGER_TYPE: (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTEGER_TYPE (yyt); break;
case kCARDINAL_TYPE: (void) fputs (Tree_NodeName [kCARDINAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCARDINAL_TYPE (yyt); break;
case kREAL_TYPE: (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_TYPE (yyt); break;
case kBOOLEAN_TYPE: (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOLEAN_TYPE (yyt); break;
case kCOMPLEX_TYPE: (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_TYPE (yyt); break;
case kCHAR_TYPE: (void) fputs (Tree_NodeName [kCHAR_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kSTRING_TYPE: (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_TYPE (yyt); break;
case kINDEX_TYPE: (void) fputs (Tree_NodeName [kINDEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEX_TYPE (yyt); break;
case kTYPE_ID: (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_ID (yyt); break;
case kARRAY_TYPE: (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_TYPE (yyt); break;
case kRECORD_TYPE: (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRECORD_TYPE (yyt); break;
case kUNION_TYPE: (void) fputs (Tree_NodeName [kUNION_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUNION_TYPE (yyt); break;
case kENUM_TYPE: (void) fputs (Tree_NodeName [kENUM_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeENUM_TYPE (yyt); break;
case kDYNAMIC: (void) fputs (Tree_NodeName [kDYNAMIC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDYNAMIC (yyt); break;
case kPOINTER_TYPE: (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_TYPE (yyt); break;
case kARRAY1_TYPE: (void) fputs (Tree_NodeName [kARRAY1_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY1_TYPE (yyt); break;
case kFUNCTION_TYPE: (void) fputs (Tree_NodeName [kFUNCTION_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNCTION_TYPE (yyt); break;
case kTYPE_NODE_LIST: (void) fputs (Tree_NodeName [kTYPE_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kTYPE_EMPTY: (void) fputs (Tree_NodeName [kTYPE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kTYPE_LIST: (void) fputs (Tree_NodeName [kTYPE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_LIST (yyt); break;
case kDECL_NODE: (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_NODE (yyt); break;
case kMODULE_DECL: (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMODULE_DECL (yyt); break;
case kPROGRAM_DECL: (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROGRAM_DECL (yyt); break;
case kPROC_DECL: (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_DECL (yyt); break;
case kFUNC_DECL: (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_DECL (yyt); break;
case kBLOCK_DATA_DECL: (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DATA_DECL (yyt); break;
case kTYPE_DECL: (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_DECL (yyt); break;
case kNAME_DECL: (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAME_DECL (yyt); break;
case kRENAME_DECL: (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRENAME_DECL (yyt); break;
case kENTITY_DECL: (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeENTITY_DECL (yyt); break;
case kVAR_DECL: (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_DECL (yyt); break;
case kCOMMON_DECL: (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMMON_DECL (yyt); break;
case kNAMELIST_DECL: (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMELIST_DECL (yyt); break;
case kTEMPLATE_DECL: (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTEMPLATE_DECL (yyt); break;
case kPROCESSORS_DECL: (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSORS_DECL (yyt); break;
case kINHERIT_DECL: (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINHERIT_DECL (yyt); break;
case kSTMT_FUNC_DECL: (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTMT_FUNC_DECL (yyt); break;
case kINTERFACE_DECL: (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTERFACE_DECL (yyt); break;
case kEXT_PROC_DECL: (void) fputs (Tree_NodeName [kEXT_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXT_PROC_DECL (yyt); break;
case kEXT_FUNC_DECL: (void) fputs (Tree_NodeName [kEXT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXT_FUNC_DECL (yyt); break;
case kVAL_PARAM_DECL: (void) fputs (Tree_NodeName [kVAL_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAL_PARAM_DECL (yyt); break;
case kVAR_PARAM_DECL: (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM_DECL (yyt); break;
case kPROC_PARAM_DECL: (void) fputs (Tree_NodeName [kPROC_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_PARAM_DECL (yyt); break;
case kFUNC_PARAM_DECL: (void) fputs (Tree_NodeName [kFUNC_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_PARAM_DECL (yyt); break;
case kELIPSIS_PARAM_DECL: (void) fputs (Tree_NodeName [kELIPSIS_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeELIPSIS_PARAM_DECL (yyt); break;
case kRET_PARAM_DECL: (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRET_PARAM_DECL (yyt); break;
case kIMPLICIT_DECL: (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIMPLICIT_DECL (yyt); break;
case kUSE_DECL: (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSE_DECL (yyt); break;
case kONLY_USE_DECL: (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeONLY_USE_DECL (yyt); break;
case kEQV_DECL: (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEQV_DECL (yyt); break;
case kDATA_DECL: (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDATA_DECL (yyt); break;
case kDIMENSION_DECL: (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIMENSION_DECL (yyt); break;
case kINIT_DATA_DECL: (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINIT_DATA_DECL (yyt); break;
case kTYPESPEC_DECL: (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPESPEC_DECL (yyt); break;
case kALLOCATABLE_DECL: (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATABLE_DECL (yyt); break;
case kEXTERNAL_DECL: (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXTERNAL_DECL (yyt); break;
case kINTENT_DECL: (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTENT_DECL (yyt); break;
case kINTRINSIC_DECL: (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTRINSIC_DECL (yyt); break;
case kOPTIONAL_DECL: (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOPTIONAL_DECL (yyt); break;
case kPOINTER_DECL: (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_DECL (yyt); break;
case kSAVE_DECL: (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSAVE_DECL (yyt); break;
case kTARGET_DECL: (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTARGET_DECL (yyt); break;
case kPARAMETER_DECL: (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePARAMETER_DECL (yyt); break;
case kPUBLIC_DECL: (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePUBLIC_DECL (yyt); break;
case kPRIVATE_DECL: (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePRIVATE_DECL (yyt); break;
case kDISTRIBUTE_DECL: (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTE_DECL (yyt); break;
case kALIGN_DECL: (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_DECL (yyt); break;
case kDYNAMIC_DECL: (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDYNAMIC_DECL (yyt); break;
case kSEQUENCE_DECL: (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSEQUENCE_DECL (yyt); break;
case kNOSEQUENCE_DECL: (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNOSEQUENCE_DECL (yyt); break;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_LIST: (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_LIST (yyt); break;
case kDISTRIBUTION_SPEC: (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kHOST_DISTRIBUTION: (void) fputs (Tree_NodeName [kHOST_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kREPL_DISTRIBUTION: (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kNODE_DISTRIBUTION: (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNODE_DISTRIBUTION (yyt); break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf);
 break;
case kBLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DISTRIBUTION (yyt); break;
case kCYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLIC_DISTRIBUTION (yyt); break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_LIST: (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIST_LIST (yyt); break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kID_GENERIC_SPEC: (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeID_GENERIC_SPEC (yyt); break;
case kOP_GENERIC_SPEC: (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_GENERIC_SPEC (yyt); break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_LIST: (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LIST (yyt); break;
case kACF_NODE: (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_NODE (yyt); break;
case kACF_DUMMY: (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DUMMY (yyt); break;
case kACF_BASIC: (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BASIC (yyt); break;
case kACF_IF: (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_IF (yyt); break;
case kACF_WHERE: (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHERE (yyt); break;
case kACF_SWITCH: (void) fputs (Tree_NodeName [kACF_SWITCH], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_SWITCH (yyt); break;
case kACF_ALTER: (void) fputs (Tree_NodeName [kACF_ALTER], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ALTER (yyt); break;
case kACF_CASE: (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_CASE (yyt); break;
case kACF_WHILE: (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHILE (yyt); break;
case kACF_REPEAT: (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_REPEAT (yyt); break;
case kACF_WITH: (void) fputs (Tree_NodeName [kACF_WITH], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WITH (yyt); break;
case kACF_LOOP: (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LOOP (yyt); break;
case kACF_DO: (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DO (yyt); break;
case kACF_DOLOCAL: (void) fputs (Tree_NodeName [kACF_DOLOCAL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DOLOCAL (yyt); break;
case kACF_DOVEC: (void) fputs (Tree_NodeName [kACF_DOVEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DOVEC (yyt); break;
case kACF_DOALL: (void) fputs (Tree_NodeName [kACF_DOALL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DOALL (yyt); break;
case kACF_FORALL: (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FORALL (yyt); break;
case kACF_ON: (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ON (yyt); break;
case kACF_BODY: (void) fputs (Tree_NodeName [kACF_BODY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BODY (yyt); break;
case kACF_FLOW_GRAPH: (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FLOW_GRAPH (yyt); break;
case kACF_ENTRY: (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ENTRY (yyt); break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_LIST (yyt); break;
case kSELECTED_ACF_NODE: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_NODE (yyt); break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf);
 break;
case kEXP_STMT: (void) fputs (Tree_NodeName [kEXP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXP_STMT (yyt); break;
case kASSIGN_STMT: (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSIGN_STMT (yyt); break;
case kPTR_ASSIGN_STMT: (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePTR_ASSIGN_STMT (yyt); break;
case kLABEL_ASSIGN_STMT: (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_ASSIGN_STMT (yyt); break;
case kCALL_STMT: (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCALL_STMT (yyt); break;
case kIO_STMT: (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIO_STMT (yyt); break;
case kGOTO_STMT: (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGOTO_STMT (yyt); break;
case kASS_GOTO_STMT: (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASS_GOTO_STMT (yyt); break;
case kCOMP_GOTO_STMT: (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_GOTO_STMT (yyt); break;
case kCOMP_IF_STMT: (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_IF_STMT (yyt); break;
case kRETURN_STMT: (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_STMT (yyt); break;
case kPAUSE_STMT: (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePAUSE_STMT (yyt); break;
case kEXIT_STMT: (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXIT_STMT (yyt); break;
case kCYCLE_STMT: (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLE_STMT (yyt); break;
case kSTOP_STMT: (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTOP_STMT (yyt); break;
case kFORMAT_STMT: (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_STMT (yyt); break;
case kALLOCATE_STMT: (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATE_STMT (yyt); break;
case kDEALLOCATE_STMT: (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEALLOCATE_STMT (yyt); break;
case kNULLIFY_STMT: (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNULLIFY_STMT (yyt); break;
case kREDUCE_STMT: (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDUCE_STMT (yyt); break;
case kGLOBAL_STMT: (void) fputs (Tree_NodeName [kGLOBAL_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGLOBAL_STMT (yyt); break;
case kALIGN_STMT: (void) fputs (Tree_NodeName [kALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_STMT (yyt); break;
case kDISTRIBUTE_STMT: (void) fputs (Tree_NodeName [kDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTE_STMT (yyt); break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_LIST: (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_LIST (yyt); break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DIV: (void) fputs (Tree_NodeName [kOP_DIV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_MOD: (void) fputs (Tree_NodeName [kOP_MOD], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_IN: (void) fputs (Tree_NodeName [kOP_IN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DEFINED: (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_DEFINED (yyt); break;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LEFT: (void) fputs (Tree_NodeName [kOP_LEFT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_RIGHT: (void) fputs (Tree_NodeName [kOP_RIGHT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LIST: (void) fputs (Tree_NodeName [kOP_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_IOR: (void) fputs (Tree_NodeName [kOP_IOR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_IXOR: (void) fputs (Tree_NodeName [kOP_IXOR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_IAND: (void) fputs (Tree_NodeName [kOP_IAND], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_INOT: (void) fputs (Tree_NodeName [kOP1_INOT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_SIZE: (void) fputs (Tree_NodeName [kOP1_SIZE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_DEC: (void) fputs (Tree_NodeName [kOP1_DEC], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_INC: (void) fputs (Tree_NodeName [kOP1_INC], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_ADDRESS: (void) fputs (Tree_NodeName [kOP1_ADDRESS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_DEREF: (void) fputs (Tree_NodeName [kOP1_DEREF], yyf); (void) fputc ('\n', yyf);
 break;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kCONST_EXP: (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCONST_EXP (yyt); break;
case kOP_EXP: (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_EXP (yyt); break;
case kOP1_EXP: (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP1_EXP (yyt); break;
case kSLICE_EXP: (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSLICE_EXP (yyt); break;
case kPOSTFIX_EXP: (void) fputs (Tree_NodeName [kPOSTFIX_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOSTFIX_EXP (yyt); break;
case kCALL_EXP: (void) fputs (Tree_NodeName [kCALL_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCALL_EXP (yyt); break;
case kCAST_EXP: (void) fputs (Tree_NodeName [kCAST_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCAST_EXP (yyt); break;
case kINDEXED_EXP: (void) fputs (Tree_NodeName [kINDEXED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEXED_EXP (yyt); break;
case kSELECTED_EXP: (void) fputs (Tree_NodeName [kSELECTED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_EXP (yyt); break;
case kASSIGN_EXP: (void) fputs (Tree_NodeName [kASSIGN_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSIGN_EXP (yyt); break;
case kUSED_EXP: (void) fputs (Tree_NodeName [kUSED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSED_EXP (yyt); break;
case kCOND_EXP: (void) fputs (Tree_NodeName [kCOND_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOND_EXP (yyt); break;
case kVAR_EXP: (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_EXP (yyt); break;
case kFUNC_CALL_EXP: (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_CALL_EXP (yyt); break;
case kNAMED_EXP: (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_EXP (yyt); break;
case kDO_EXP: (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_EXP (yyt); break;
case kTYPE_EXP: (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_EXP (yyt); break;
case kARRAY_EXP: (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_EXP (yyt); break;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_LIST: (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTE_LIST (yyt); break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kUSED_VAR: (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSED_VAR (yyt); break;
case kINDEXED_VAR: (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEXED_VAR (yyt); break;
case kSUBSTRING_VAR: (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSUBSTRING_VAR (yyt); break;
case kSELECTED_VAR: (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_VAR (yyt); break;
case kLOOP_VAR: (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLOOP_VAR (yyt); break;
case kADDR: (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeADDR (yyt); break;
case kDO_VAR: (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_VAR (yyt); break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_LIST: (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTV_LIST (yyt); break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf);
 break;
case kVAR_PARAM: (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM (yyt); break;
case kVALUE_PARAM: (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVALUE_PARAM (yyt); break;
case kNAMED_PARAM: (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_PARAM (yyt); break;
case kPROC_PARAM: (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_PARAM (yyt); break;
case kFUNC_PARAM: (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_PARAM (yyt); break;
case kFORMAT_PARAM: (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_PARAM (yyt); break;
case kRETURN_PARAM: (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_PARAM (yyt); break;
case kNO_PARAM: (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf);
 break;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_LIST: (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTP_LIST (yyt); break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf);
 break;
case kBOOL_CONSTANT: (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOL_CONSTANT (yyt); break;
case kINT_CONSTANT: (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINT_CONSTANT (yyt); break;
case kREAL_CONSTANT: (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_CONSTANT (yyt); break;
case kDREAL_CONSTANT: (void) fputs (Tree_NodeName [kDREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDREAL_CONSTANT (yyt); break;
case kCHAR_CONSTANT: (void) fputs (Tree_NodeName [kCHAR_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCHAR_CONSTANT (yyt); break;
case kSTRING_CONSTANT: (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_CONSTANT (yyt); break;
case kCOMPLEX_CONSTANT: (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_CONSTANT (yyt); break;
case kPROC_OBJ: (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_OBJ (yyt); break;
case kVAR_OBJ: (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_OBJ (yyt); break;
case kTYPE_OBJ: (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_OBJ (yyt); break;
case kREC_COMP: (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREC_COMP (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tTree yyt)
# else
 (yys, yyt) char * yys; tTree yyt;
# endif
{ yyIndentSelector (yys); writetTree (yyt) }

static void yWriteCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DECLS", yyt->BODY_NODE.DECLS);
 yyIndentSelectorTree ("STATS", yyt->BODY_NODE.STATS);
}

static void yWriteINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("size"); writeint (yyt->INTEGER_TYPE.size) yyWriteNl ();
}

static void yWriteCARDINAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCARDINAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("size"); writeint (yyt->CARDINAL_TYPE.size) yyWriteNl ();
}

static void yWriteREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("size"); writeint (yyt->REAL_TYPE.size) yyWriteNl ();
}

static void yWriteBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("size"); writeint (yyt->BOOLEAN_TYPE.size) yyWriteNl ();
}

static void yWriteCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("size"); writeint (yyt->COMPLEX_TYPE.size) yyWriteNl ();
}

static void yWriteSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("LOWER", yyt->INDEX_TYPE.LOWER);
 yyIndentSelector ("left_overlap"); writeint (yyt->INDEX_TYPE.left_overlap) yyWriteNl ();
 yyIndentSelector ("right_overlap"); writeint (yyt->INDEX_TYPE.right_overlap) yyWriteNl ();
}

static void yWriteTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ARRAY_INDEX_TYPES", yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
}

static void yWriteRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
}

static void yWriteUNION_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUNION_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->UNION_TYPE.Name) yyWriteNl ();
}

static void yWriteENUM_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kENUM_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ENUM_TYPE.Name) yyWriteNl ();
}

static void yWriteDYNAMIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDYNAMIC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Shape"); writetTree (yyt->DYNAMIC.Shape) yyWriteNl ();
 yyIndentSelector ("left_overlap"); writeint (yyt->DYNAMIC.left_overlap) yyWriteNl ();
 yyIndentSelector ("right_overlap"); writeint (yyt->DYNAMIC.right_overlap) yyWriteNl ();
}

static void yWritePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARRAY1_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY1_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SIZE", yyt->ARRAY1_TYPE.SIZE);
}

static void yWriteFUNCTION_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNCTION_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("FORMALS", yyt->FUNCTION_TYPE.FORMALS);
}

static void yWriteTYPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->TYPE_LIST.Elem);
}

static void yWriteDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->DECL_NODE.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->DECL_NODE.Pos) yyWriteNl ();
}

static void yWriteMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->MODULE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->MODULE_DECL.Pos) yyWriteNl ();
}

static void yWritePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PROGRAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PROGRAM_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROGRAM_DECL.FORMALS);
}

static void yWritePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PROC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PROC_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROC_DECL.FORMALS);
 yyIndentSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writeint (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->FUNC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->FUNC_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("FUNC_BODY", yyt->FUNC_DECL.FUNC_BODY);
 yyIndentSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyIndentSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writeint (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->BLOCK_DATA_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->BLOCK_DATA_DECL.Pos) yyWriteNl ();
}

static void yWriteTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->TYPE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->TYPE_DECL.Pos) yyWriteNl ();
}

static void yWriteNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAME_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->NAME_DECL.Pos) yyWriteNl ();
}

static void yWriteRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->RENAME_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->RENAME_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ENTITY_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->ENTITY_DECL.Pos) yyWriteNl ();
}

static void yWriteVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->VAR_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->VAR_DECL.Pos) yyWriteNl ();
}

static void yWriteCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->COMMON_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->COMMON_DECL.Pos) yyWriteNl ();
}

static void yWriteNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMELIST_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->NAMELIST_DECL.Pos) yyWriteNl ();
}

static void yWriteTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->TEMPLATE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->TEMPLATE_DECL.Pos) yyWriteNl ();
}

static void yWritePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PROCESSORS_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PROCESSORS_DECL.Pos) yyWriteNl ();
}

static void yWriteINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->INHERIT_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->INHERIT_DECL.Pos) yyWriteNl ();
}

static void yWriteSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->STMT_FUNC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->STMT_FUNC_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->STMT_FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("RESULT_TYPE", yyt->STMT_FUNC_DECL.RESULT_TYPE);
}

static void yWriteINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->INTERFACE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->INTERFACE_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("SPEC", yyt->INTERFACE_DECL.SPEC);
}

static void yWriteEXT_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXT_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->EXT_PROC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->EXT_PROC_DECL.Pos) yyWriteNl ();
}

static void yWriteEXT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->EXT_FUNC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->EXT_FUNC_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->EXT_FUNC_DECL.FORMALS);
}

static void yWriteVAL_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAL_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->VAL_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->VAL_PARAM_DECL.Pos) yyWriteNl ();
}

static void yWriteVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->VAR_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->VAR_PARAM_DECL.Pos) yyWriteNl ();
}

static void yWritePROC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PROC_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PROC_PARAM_DECL.Pos) yyWriteNl ();
}

static void yWriteFUNC_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->FUNC_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->FUNC_PARAM_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FORMAL", yyt->FUNC_PARAM_DECL.FORMAL);
}

static void yWriteELIPSIS_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kELIPSIS_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ELIPSIS_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->ELIPSIS_PARAM_DECL.Pos) yyWriteNl ();
}

static void yWriteRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->RET_PARAM_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->RET_PARAM_DECL.Pos) yyWriteNl ();
}

static void yWriteIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->IMPLICIT_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->IMPLICIT_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyIndentSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
}

static void yWriteUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->USE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->USE_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
}

static void yWriteONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ONLY_USE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->ONLY_USE_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
}

static void yWriteEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->EQV_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->EQV_DECL.Pos) yyWriteNl ();
}

static void yWriteDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->DATA_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->DATA_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("VARS", yyt->DATA_DECL.VARS);
}

static void yWriteDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->DIMENSION_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->DIMENSION_DECL.Pos) yyWriteNl ();
}

static void yWriteINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->INIT_DATA_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->INIT_DATA_DECL.Pos) yyWriteNl ();
}

static void yWriteTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->TYPESPEC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->TYPESPEC_DECL.Pos) yyWriteNl ();
}

static void yWriteALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ALLOCATABLE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->ALLOCATABLE_DECL.Pos) yyWriteNl ();
}

static void yWriteEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->EXTERNAL_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->EXTERNAL_DECL.Pos) yyWriteNl ();
}

static void yWriteINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->INTENT_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->INTENT_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->INTRINSIC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->INTRINSIC_DECL.Pos) yyWriteNl ();
}

static void yWriteOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->OPTIONAL_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->OPTIONAL_DECL.Pos) yyWriteNl ();
}

static void yWritePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->POINTER_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->POINTER_DECL.Pos) yyWriteNl ();
}

static void yWriteSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->SAVE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->SAVE_DECL.Pos) yyWriteNl ();
}

static void yWriteTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->TARGET_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->TARGET_DECL.Pos) yyWriteNl ();
}

static void yWritePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PARAMETER_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PARAMETER_DECL.Pos) yyWriteNl ();
}

static void yWritePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PUBLIC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PUBLIC_DECL.Pos) yyWriteNl ();
}

static void yWritePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->PRIVATE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->PRIVATE_DECL.Pos) yyWriteNl ();
}

static void yWriteDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->DISTRIBUTE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->DISTRIBUTE_DECL.Pos) yyWriteNl ();
 yyIndentSelector ("target"); writetIdent (yyt->DISTRIBUTE_DECL.target) yyWriteNl ();
}

static void yWriteALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->ALIGN_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->ALIGN_DECL.Pos) yyWriteNl ();
 yyIndentSelectorTree ("ALIGN_SOURCE", yyt->ALIGN_DECL.ALIGN_SOURCE);
}

static void yWriteDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->DYNAMIC_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->DYNAMIC_DECL.Pos) yyWriteNl ();
}

static void yWriteSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->SEQUENCE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->SEQUENCE_DECL.Pos) yyWriteNl ();
}

static void yWriteNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NOSEQUENCE_DECL.Name) yyWriteNl ();
 yyIndentSelector ("Pos"); writeint (yyt->NOSEQUENCE_DECL.Pos) yyWriteNl ();
}

static void yWriteDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DECL_LIST.Elem);
}

static void yWriteNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DIST_LIST.Elem);
}

static void yWriteID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
}

static void yWriteACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->ACF_LIST.Elem);
}

static void yWriteACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DUMMY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DUMMY.Line) yyWriteNl ();
}

static void yWriteACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BASIC.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BASIC.Line) yyWriteNl ();
}

static void yWriteACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_IF.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_IF.Line) yyWriteNl ();
 yyIndentSelectorTree ("IF_EXP", yyt->ACF_IF.IF_EXP);
 yyIndentSelectorTree ("THEN_PART", yyt->ACF_IF.THEN_PART);
}

static void yWriteACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHERE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHERE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHERE_EXP", yyt->ACF_WHERE.WHERE_EXP);
 yyIndentSelectorTree ("TRUE_PART", yyt->ACF_WHERE.TRUE_PART);
}

static void yWriteACF_SWITCH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_SWITCH], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_SWITCH.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_SWITCH.Line) yyWriteNl ();
 yyIndentSelectorTree ("SWITCH_EXP", yyt->ACF_SWITCH.SWITCH_EXP);
}

static void yWriteACF_ALTER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ALTER], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ALTER.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ALTER.Line) yyWriteNl ();
 yyIndentSelectorTree ("ALTER_EXP", yyt->ACF_ALTER.ALTER_EXP);
}

static void yWriteACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_CASE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_CASE.Line) yyWriteNl ();
 yyIndentSelectorTree ("CASE_EXP", yyt->ACF_CASE.CASE_EXP);
 yyIndentSelectorTree ("CASE_ALTS", yyt->ACF_CASE.CASE_ALTS);
}

static void yWriteACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHILE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHILE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHILE_EXP", yyt->ACF_WHILE.WHILE_EXP);
}

static void yWriteACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_REPEAT.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_REPEAT.Line) yyWriteNl ();
 yyIndentSelectorTree ("REPEAT_BODY", yyt->ACF_REPEAT.REPEAT_BODY);
}

static void yWriteACF_WITH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WITH], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WITH.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WITH.Line) yyWriteNl ();
 yyIndentSelectorTree ("WITH_VARS", yyt->ACF_WITH.WITH_VARS);
}

static void yWriteACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_LOOP.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_LOOP.Line) yyWriteNl ();
}

static void yWriteACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DO.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DO.Line) yyWriteNl ();
 yyIndentSelectorTree ("DO_ID", yyt->ACF_DO.DO_ID);
 yyIndentSelectorTree ("DO_RANGE", yyt->ACF_DO.DO_RANGE);
}

static void yWriteACF_DOLOCAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DOLOCAL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DOLOCAL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DOLOCAL.Line) yyWriteNl ();
 yyIndentSelectorTree ("DOLOCAL_ID", yyt->ACF_DOLOCAL.DOLOCAL_ID);
 yyIndentSelectorTree ("DOLOCAL_RANGE", yyt->ACF_DOLOCAL.DOLOCAL_RANGE);
}

static void yWriteACF_DOVEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DOVEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DOVEC.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DOVEC.Line) yyWriteNl ();
 yyIndentSelectorTree ("DOVEC_ID", yyt->ACF_DOVEC.DOVEC_ID);
 yyIndentSelectorTree ("DOVEC_RANGE", yyt->ACF_DOVEC.DOVEC_RANGE);
}

static void yWriteACF_DOALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DOALL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DOALL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DOALL.Line) yyWriteNl ();
 yyIndentSelectorTree ("DOALL_NEW", yyt->ACF_DOALL.DOALL_NEW);
 yyIndentSelectorTree ("DOALL_ID", yyt->ACF_DOALL.DOALL_ID);
 yyIndentSelectorTree ("DOALL_RANGE", yyt->ACF_DOALL.DOALL_RANGE);
}

static void yWriteACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FORALL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FORALL.Line) yyWriteNl ();
 yyIndentSelectorTree ("FORALL_ID", yyt->ACF_FORALL.FORALL_ID);
 yyIndentSelectorTree ("FORALL_RANGE", yyt->ACF_FORALL.FORALL_RANGE);
}

static void yWriteACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ON.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ON.Line) yyWriteNl ();
 yyIndentSelectorTree ("ON_VAR", yyt->ACF_ON.ON_VAR);
}

static void yWriteACF_BODY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BODY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BODY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BODY.Line) yyWriteNl ();
 yyIndentSelector ("Entries"); writetDefinitions (yyt->ACF_BODY.Entries) yyWriteNl ();
}

static void yWriteACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FLOW_GRAPH.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FLOW_GRAPH.Line) yyWriteNl ();
}

static void yWriteACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ENTRY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ENTRY.Line) yyWriteNl ();
}

static void yWriteSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SELECTED_ACF_LIST.Elem);
}

static void yWriteSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELECT_LIST", yyt->SELECTED_ACF_NODE.SELECT_LIST);
}

static void yWriteEXP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXP_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->ASSIGN_STMT.ASSIGN_VAR);
}

static void yWritePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
}

static void yWriteLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
}

static void yWriteCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("CALL_ID", yyt->CALL_STMT.CALL_ID);
}

static void yWriteIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->IO_STMT.ID);
 yyIndentSelectorTree ("IO_SPECS", yyt->IO_STMT.IO_SPECS);
}

static void yWriteGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_VAR", yyt->ASS_GOTO_STMT.GOTO_VAR);
}

static void yWriteCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_LABELS", yyt->COMP_GOTO_STMT.GOTO_LABELS);
}

static void yWriteCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWritePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->ALLOCATE_STMT.PARAMS);
}

static void yWriteDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->DEALLOCATE_STMT.PARAMS);
}

static void yWriteNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("RED_FUNC", yyt->REDUCE_STMT.RED_FUNC);
}

static void yWriteGLOBAL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGLOBAL_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("func"); writetIdent (yyt->GLOBAL_STMT.func) yyWriteNl ();
 yyIndentSelectorTree ("ARRAY", yyt->GLOBAL_STMT.ARRAY);
 yyIndentSelectorTree ("INDEXED_ARRAY", yyt->GLOBAL_STMT.INDEXED_ARRAY);
 yyIndentSelectorTree ("INDEXES", yyt->GLOBAL_STMT.INDEXES);
}

static void yWriteALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ALIGNEE", yyt->ALIGN_STMT.ALIGNEE);
}

static void yWriteDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DISTRIBUTEE", yyt->DISTRIBUTE_STMT.DISTRIBUTEE);
 yyIndentSelector ("target"); writetIdent (yyt->DISTRIBUTE_STMT.target) yyWriteNl ();
}

static void yWriteLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
}

static void yWriteOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP", yyt->OP_EXP.EXP_OP);
 yyIndentSelectorTree ("OPND1", yyt->OP_EXP.OPND1);
}

static void yWriteOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP1", yyt->OP1_EXP.EXP_OP1);
}

static void yWriteSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("START", yyt->SLICE_EXP.START);
 yyIndentSelectorTree ("STOP", yyt->SLICE_EXP.STOP);
}

static void yWritePOSTFIX_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOSTFIX_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("POSTFIX_OP", yyt->POSTFIX_EXP.POSTFIX_OP);
}

static void yWriteCALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCALL_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("FUNC_ID", yyt->CALL_EXP.FUNC_ID);
}

static void yWriteCAST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCAST_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->CAST_EXP.ID);
}

static void yWriteINDEXED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEXED_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_EXP", yyt->INDEXED_EXP.IND_EXP);
}

static void yWriteSELECTED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELEC_EXP", yyt->SELECTED_EXP.SELEC_EXP);
}

static void yWriteASSIGN_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSIGN_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_OP", yyt->ASSIGN_EXP.ASSIGN_OP);
 yyIndentSelectorTree ("LHS", yyt->ASSIGN_EXP.LHS);
}

static void yWriteUSED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSED_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCOND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOND_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("COND", yyt->COND_EXP.COND);
 yyIndentSelectorTree ("TRUE_EXP", yyt->COND_EXP.TRUE_EXP);
}

static void yWriteVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("FUNC_ID", yyt->FUNC_CALL_EXP.FUNC_ID);
}

static void yWriteNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
}

static void yWriteDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_EXP.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_EXP.RANGE);
}

static void yWriteTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->TYPE_EXP.ID);
}

static void yWriteARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTE_LIST.Elem);
}

static void yWriteUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->INDEXED_VAR.IND_VAR);
}

static void yWriteSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->SUBSTRING_VAR.IND_VAR);
}

static void yWriteSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELEC_VAR", yyt->SELECTED_VAR.SELEC_VAR);
}

static void yWriteLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_VAR.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_VAR.RANGE);
}

static void yWriteBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTV_LIST.Elem);
}

static void yWriteVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
}

static void yWritePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTP_LIST.Elem);
}

static void yWriteBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
}

static void yWriteDREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->DREAL_CONSTANT.value) yyWriteNl ();
}

static void yWriteCHAR_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCHAR_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writechar (yyt->CHAR_CONSTANT.value) yyWriteNl ();
}

static void yWriteSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyIndentSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWritePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
}

static void yWriteTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

static void yyWriteTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoTree) { (void) fputs (" NoTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kCOMP_UNIT: yWriteCOMP_UNIT (yyt); yyIndentSelector ("COMP_ELEMENTS"); yyt = yyt->COMP_UNIT.COMP_ELEMENTS; break;
case kBODY_NODE: yWriteBODY_NODE (yyt); yyIndentSelector ("INTERNALS"); yyt = yyt->BODY_NODE.INTERNALS; break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kVOID_TYPE: (void) fputs (Tree_NodeName [kVOID_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kINTEGER_TYPE: yWriteINTEGER_TYPE (yyt); goto yyExit;
case kCARDINAL_TYPE: yWriteCARDINAL_TYPE (yyt); goto yyExit;
case kREAL_TYPE: yWriteREAL_TYPE (yyt); goto yyExit;
case kBOOLEAN_TYPE: yWriteBOOLEAN_TYPE (yyt); goto yyExit;
case kCOMPLEX_TYPE: yWriteCOMPLEX_TYPE (yyt); goto yyExit;
case kCHAR_TYPE: (void) fputs (Tree_NodeName [kCHAR_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSTRING_TYPE: yWriteSTRING_TYPE (yyt); yyIndentSelector ("LENGTH"); yyt = yyt->STRING_TYPE.LENGTH; break;
case kINDEX_TYPE: yWriteINDEX_TYPE (yyt); yyIndentSelector ("UPPER"); yyt = yyt->INDEX_TYPE.UPPER; break;
case kTYPE_ID: yWriteTYPE_ID (yyt); yyIndentSelector ("ID"); yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE: yWriteARRAY_TYPE (yyt); yyIndentSelector ("ARRAY_COMP_TYPE"); yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE: yWriteRECORD_TYPE (yyt); yyIndentSelector ("COMPONENTS"); yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kUNION_TYPE: yWriteUNION_TYPE (yyt); yyIndentSelector ("COMPONENTS"); yyt = yyt->UNION_TYPE.COMPONENTS; break;
case kENUM_TYPE: yWriteENUM_TYPE (yyt); yyIndentSelector ("COMPONENTS"); yyt = yyt->ENUM_TYPE.COMPONENTS; break;
case kDYNAMIC: yWriteDYNAMIC (yyt); goto yyExit;
case kPOINTER_TYPE: yWritePOINTER_TYPE (yyt); yyIndentSelector ("PTR_COMP"); yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kARRAY1_TYPE: yWriteARRAY1_TYPE (yyt); yyIndentSelector ("ARRAY1_COMP_TYPE"); yyt = yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE; break;
case kFUNCTION_TYPE: yWriteFUNCTION_TYPE (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->FUNCTION_TYPE.RESULT_TYPE; break;
case kTYPE_NODE_LIST: (void) fputs (Tree_NodeName [kTYPE_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kTYPE_EMPTY: (void) fputs (Tree_NodeName [kTYPE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kTYPE_LIST: yWriteTYPE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->TYPE_LIST.Next; break;
case kDECL_NODE: yWriteDECL_NODE (yyt); goto yyExit;
case kMODULE_DECL: yWriteMODULE_DECL (yyt); yyIndentSelector ("MODULE_BODY"); yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL: yWritePROGRAM_DECL (yyt); yyIndentSelector ("PROGRAM_BODY"); yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL: yWritePROC_DECL (yyt); yyIndentSelector ("PROC_BODY"); yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL: yWriteFUNC_DECL (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL: yWriteBLOCK_DATA_DECL (yyt); yyIndentSelector ("DATA_BODY"); yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kTYPE_DECL: yWriteTYPE_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPE_DECL.VAL; break;
case kNAME_DECL: yWriteNAME_DECL (yyt); goto yyExit;
case kRENAME_DECL: yWriteRENAME_DECL (yyt); goto yyExit;
case kENTITY_DECL: yWriteENTITY_DECL (yyt); yyIndentSelector ("ATTRIBUTES"); yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL: yWriteVAR_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL: yWriteCOMMON_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL: yWriteNAMELIST_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL: yWriteTEMPLATE_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL: yWritePROCESSORS_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kINHERIT_DECL: yWriteINHERIT_DECL (yyt); goto yyExit;
case kSTMT_FUNC_DECL: yWriteSTMT_FUNC_DECL (yyt); yyIndentSelector ("FFUNC_BODY"); yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL: yWriteINTERFACE_DECL (yyt); yyIndentSelector ("ITEMS"); yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kEXT_PROC_DECL: yWriteEXT_PROC_DECL (yyt); yyIndentSelector ("FORMALS"); yyt = yyt->EXT_PROC_DECL.FORMALS; break;
case kEXT_FUNC_DECL: yWriteEXT_FUNC_DECL (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->EXT_FUNC_DECL.RESULT_TYPE; break;
case kVAL_PARAM_DECL: yWriteVAL_PARAM_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAL_PARAM_DECL.VAL; break;
case kVAR_PARAM_DECL: yWriteVAR_PARAM_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kPROC_PARAM_DECL: yWritePROC_PARAM_DECL (yyt); yyIndentSelector ("FORMAL"); yyt = yyt->PROC_PARAM_DECL.FORMAL; break;
case kFUNC_PARAM_DECL: yWriteFUNC_PARAM_DECL (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->FUNC_PARAM_DECL.RESULT_TYPE; break;
case kELIPSIS_PARAM_DECL: yWriteELIPSIS_PARAM_DECL (yyt); goto yyExit;
case kRET_PARAM_DECL: yWriteRET_PARAM_DECL (yyt); goto yyExit;
case kIMPLICIT_DECL: yWriteIMPLICIT_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->IMPLICIT_DECL.VAL; break;
case kUSE_DECL: yWriteUSE_DECL (yyt); yyIndentSelector ("RENAMINGS"); yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL: yWriteONLY_USE_DECL (yyt); yyIndentSelector ("NAMES"); yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL: yWriteEQV_DECL (yyt); yyIndentSelector ("VARS"); yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL: yWriteDATA_DECL (yyt); yyIndentSelector ("VALS"); yyt = yyt->DATA_DECL.VALS; break;
case kDIMENSION_DECL: yWriteDIMENSION_DECL (yyt); yyIndentSelector ("INDEXES"); yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL: yWriteINIT_DATA_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL: yWriteTYPESPEC_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL: yWriteALLOCATABLE_DECL (yyt); goto yyExit;
case kEXTERNAL_DECL: yWriteEXTERNAL_DECL (yyt); goto yyExit;
case kINTENT_DECL: yWriteINTENT_DECL (yyt); goto yyExit;
case kINTRINSIC_DECL: yWriteINTRINSIC_DECL (yyt); goto yyExit;
case kOPTIONAL_DECL: yWriteOPTIONAL_DECL (yyt); goto yyExit;
case kPOINTER_DECL: yWritePOINTER_DECL (yyt); goto yyExit;
case kSAVE_DECL: yWriteSAVE_DECL (yyt); goto yyExit;
case kTARGET_DECL: yWriteTARGET_DECL (yyt); goto yyExit;
case kPARAMETER_DECL: yWritePARAMETER_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL: yWritePUBLIC_DECL (yyt); goto yyExit;
case kPRIVATE_DECL: yWritePRIVATE_DECL (yyt); goto yyExit;
case kDISTRIBUTE_DECL: yWriteDISTRIBUTE_DECL (yyt); yyIndentSelector ("DISTRIBUTION"); yyt = yyt->DISTRIBUTE_DECL.DISTRIBUTION; break;
case kALIGN_DECL: yWriteALIGN_DECL (yyt); yyIndentSelector ("ALIGN_SPEC"); yyt = yyt->ALIGN_DECL.ALIGN_SPEC; break;
case kDYNAMIC_DECL: yWriteDYNAMIC_DECL (yyt); goto yyExit;
case kSEQUENCE_DECL: yWriteSEQUENCE_DECL (yyt); goto yyExit;
case kNOSEQUENCE_DECL: yWriteNOSEQUENCE_DECL (yyt); goto yyExit;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_LIST: yWriteDECL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DECL_LIST.Next; break;
case kDISTRIBUTION_SPEC: (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kHOST_DISTRIBUTION: (void) fputs (Tree_NodeName [kHOST_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kREPL_DISTRIBUTION: (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNODE_DISTRIBUTION: yWriteNODE_DISTRIBUTION (yyt); yyIndentSelector ("MAPPING"); yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBLOCK_DISTRIBUTION: yWriteBLOCK_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION: yWriteCYCLIC_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_LIST: yWriteDIST_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DIST_LIST.Next; break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kID_GENERIC_SPEC: yWriteID_GENERIC_SPEC (yyt); goto yyExit;
case kOP_GENERIC_SPEC: yWriteOP_GENERIC_SPEC (yyt); yyIndentSelector ("OPERATOR"); yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_LIST: yWriteACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->ACF_LIST.Next; break;
case kACF_NODE: yWriteACF_NODE (yyt); goto yyExit;
case kACF_DUMMY: yWriteACF_DUMMY (yyt); goto yyExit;
case kACF_BASIC: yWriteACF_BASIC (yyt); yyIndentSelector ("BASIC_STMT"); yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF: yWriteACF_IF (yyt); yyIndentSelector ("ELSE_PART"); yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE: yWriteACF_WHERE (yyt); yyIndentSelector ("FALSE_PART"); yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_SWITCH: yWriteACF_SWITCH (yyt); yyIndentSelector ("SWITCH_STMT"); yyt = yyt->ACF_SWITCH.SWITCH_STMT; break;
case kACF_ALTER: yWriteACF_ALTER (yyt); yyIndentSelector ("ALTER_STMT"); yyt = yyt->ACF_ALTER.ALTER_STMT; break;
case kACF_CASE: yWriteACF_CASE (yyt); yyIndentSelector ("CASE_OTHERWISE"); yyt = yyt->ACF_CASE.CASE_OTHERWISE; break;
case kACF_WHILE: yWriteACF_WHILE (yyt); yyIndentSelector ("WHILE_BODY"); yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT: yWriteACF_REPEAT (yyt); yyIndentSelector ("REPEAT_EXP"); yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_WITH: yWriteACF_WITH (yyt); yyIndentSelector ("WITH_BODY"); yyt = yyt->ACF_WITH.WITH_BODY; break;
case kACF_LOOP: yWriteACF_LOOP (yyt); yyIndentSelector ("LOOP_BODY"); yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO: yWriteACF_DO (yyt); yyIndentSelector ("DO_BODY"); yyt = yyt->ACF_DO.DO_BODY; break;
case kACF_DOLOCAL: yWriteACF_DOLOCAL (yyt); yyIndentSelector ("DOLOCAL_BODY"); yyt = yyt->ACF_DOLOCAL.DOLOCAL_BODY; break;
case kACF_DOVEC: yWriteACF_DOVEC (yyt); yyIndentSelector ("DOVEC_BODY"); yyt = yyt->ACF_DOVEC.DOVEC_BODY; break;
case kACF_DOALL: yWriteACF_DOALL (yyt); yyIndentSelector ("DOALL_BODY"); yyt = yyt->ACF_DOALL.DOALL_BODY; break;
case kACF_FORALL: yWriteACF_FORALL (yyt); yyIndentSelector ("FORALL_BODY"); yyt = yyt->ACF_FORALL.FORALL_BODY; break;
case kACF_ON: yWriteACF_ON (yyt); yyIndentSelector ("ON_STMT"); yyt = yyt->ACF_ON.ON_STMT; break;
case kACF_BODY: yWriteACF_BODY (yyt); yyIndentSelector ("NEW_BODY"); yyt = yyt->ACF_BODY.NEW_BODY; break;
case kACF_FLOW_GRAPH: yWriteACF_FLOW_GRAPH (yyt); yyIndentSelector ("FLOW_NODES"); yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY: yWriteACF_ENTRY (yyt); yyIndentSelector ("ENTRY_DECL"); yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_LIST: yWriteSELECTED_ACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE: yWriteSELECTED_ACF_NODE (yyt); yyIndentSelector ("SELECT_ACFS"); yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kEXP_STMT: yWriteEXP_STMT (yyt); yyIndentSelector ("STMT_EXP"); yyt = yyt->EXP_STMT.STMT_EXP; break;
case kASSIGN_STMT: yWriteASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT: yWritePTR_ASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT: yWriteLABEL_ASSIGN_STMT (yyt); yyIndentSelector ("LABEL_VAR"); yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT: yWriteCALL_STMT (yyt); yyIndentSelector ("CALL_PARAMS"); yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT: yWriteIO_STMT (yyt); yyIndentSelector ("IO_ITEMS"); yyt = yyt->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT: yWriteGOTO_STMT (yyt); goto yyExit;
case kASS_GOTO_STMT: yWriteASS_GOTO_STMT (yyt); yyIndentSelector ("LABELS"); yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT: yWriteCOMP_GOTO_STMT (yyt); yyIndentSelector ("GOTO_EXP"); yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT: yWriteCOMP_IF_STMT (yyt); yyIndentSelector ("IF_EXP"); yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT: yWriteRETURN_STMT (yyt); yyIndentSelector ("RETURN_EXP"); yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT: yWritePAUSE_STMT (yyt); yyIndentSelector ("PAUSE_CONST"); yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT: yWriteEXIT_STMT (yyt); goto yyExit;
case kCYCLE_STMT: yWriteCYCLE_STMT (yyt); goto yyExit;
case kSTOP_STMT: yWriteSTOP_STMT (yyt); yyIndentSelector ("STOP_CONST"); yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT: yWriteFORMAT_STMT (yyt); yyIndentSelector ("FORMAT_PARAMS"); yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kALLOCATE_STMT: yWriteALLOCATE_STMT (yyt); yyIndentSelector ("STAT"); yyt = yyt->ALLOCATE_STMT.STAT; break;
case kDEALLOCATE_STMT: yWriteDEALLOCATE_STMT (yyt); yyIndentSelector ("STAT"); yyt = yyt->DEALLOCATE_STMT.STAT; break;
case kNULLIFY_STMT: yWriteNULLIFY_STMT (yyt); yyIndentSelector ("PARAMS"); yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT: yWriteREDUCE_STMT (yyt); yyIndentSelector ("RED_PARAMS"); yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kGLOBAL_STMT: yWriteGLOBAL_STMT (yyt); yyIndentSelector ("MASK"); yyt = yyt->GLOBAL_STMT.MASK; break;
case kALIGN_STMT: yWriteALIGN_STMT (yyt); yyIndentSelector ("ALIGN_SPEC"); yyt = yyt->ALIGN_STMT.ALIGN_SPEC; break;
case kDISTRIBUTE_STMT: yWriteDISTRIBUTE_STMT (yyt); yyIndentSelector ("DISTRIBUTION"); yyt = yyt->DISTRIBUTE_STMT.DISTRIBUTION; break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_LIST: yWriteLABEL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->LABEL_LIST.Next; break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DIV: (void) fputs (Tree_NodeName [kOP_DIV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_MOD: (void) fputs (Tree_NodeName [kOP_MOD], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_IN: (void) fputs (Tree_NodeName [kOP_IN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DEFINED: yWriteOP_DEFINED (yyt); goto yyExit;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LEFT: (void) fputs (Tree_NodeName [kOP_LEFT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_RIGHT: (void) fputs (Tree_NodeName [kOP_RIGHT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LIST: (void) fputs (Tree_NodeName [kOP_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_IOR: (void) fputs (Tree_NodeName [kOP_IOR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_IXOR: (void) fputs (Tree_NodeName [kOP_IXOR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_IAND: (void) fputs (Tree_NodeName [kOP_IAND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_INOT: (void) fputs (Tree_NodeName [kOP1_INOT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_SIZE: (void) fputs (Tree_NodeName [kOP1_SIZE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_DEC: (void) fputs (Tree_NodeName [kOP1_DEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_INC: (void) fputs (Tree_NodeName [kOP1_INC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_ADDRESS: (void) fputs (Tree_NodeName [kOP1_ADDRESS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_DEREF: (void) fputs (Tree_NodeName [kOP1_DEREF], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCONST_EXP: yWriteCONST_EXP (yyt); yyIndentSelector ("C"); yyt = yyt->CONST_EXP.C; break;
case kOP_EXP: yWriteOP_EXP (yyt); yyIndentSelector ("OPND2"); yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP: yWriteOP1_EXP (yyt); yyIndentSelector ("OPND"); yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP: yWriteSLICE_EXP (yyt); yyIndentSelector ("INC"); yyt = yyt->SLICE_EXP.INC; break;
case kPOSTFIX_EXP: yWritePOSTFIX_EXP (yyt); yyIndentSelector ("OPND"); yyt = yyt->POSTFIX_EXP.OPND; break;
case kCALL_EXP: yWriteCALL_EXP (yyt); yyIndentSelector ("FUNC_PARAMS"); yyt = yyt->CALL_EXP.FUNC_PARAMS; break;
case kCAST_EXP: yWriteCAST_EXP (yyt); yyIndentSelector ("CAST"); yyt = yyt->CAST_EXP.CAST; break;
case kINDEXED_EXP: yWriteINDEXED_EXP (yyt); yyIndentSelector ("INDEX"); yyt = yyt->INDEXED_EXP.INDEX; break;
case kSELECTED_EXP: yWriteSELECTED_EXP (yyt); yyIndentSelector ("SELECTOR"); yyt = yyt->SELECTED_EXP.SELECTOR; break;
case kASSIGN_EXP: yWriteASSIGN_EXP (yyt); yyIndentSelector ("RHS"); yyt = yyt->ASSIGN_EXP.RHS; break;
case kUSED_EXP: yWriteUSED_EXP (yyt); yyIndentSelector ("VARNAME"); yyt = yyt->USED_EXP.VARNAME; break;
case kCOND_EXP: yWriteCOND_EXP (yyt); yyIndentSelector ("FALSE_EXP"); yyt = yyt->COND_EXP.FALSE_EXP; break;
case kVAR_EXP: yWriteVAR_EXP (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP: yWriteFUNC_CALL_EXP (yyt); yyIndentSelector ("FUNC_PARAMS"); yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP: yWriteNAMED_EXP (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP: yWriteDO_EXP (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP: yWriteTYPE_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP: yWriteARRAY_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_LIST: yWriteBTE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTE_LIST.Next; break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUSED_VAR: yWriteUSED_VAR (yyt); yyIndentSelector ("VARNAME"); yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR: yWriteINDEXED_VAR (yyt); yyIndentSelector ("IND_EXPS"); yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR: yWriteSUBSTRING_VAR (yyt); yyIndentSelector ("IND_EXP"); yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR: yWriteSELECTED_VAR (yyt); yyIndentSelector ("SELECTOR"); yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR: yWriteLOOP_VAR (yyt); yyIndentSelector ("LOOP_VARNAME"); yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kADDR: yWriteADDR (yyt); yyIndentSelector ("E"); yyt = yyt->ADDR.E; break;
case kDO_VAR: yWriteDO_VAR (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_VAR.BODY; break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_LIST: yWriteBTV_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTV_LIST.Next; break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kVAR_PARAM: yWriteVAR_PARAM (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM: yWriteVALUE_PARAM (yyt); yyIndentSelector ("E"); yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM: yWriteNAMED_PARAM (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM: yWritePROC_PARAM (yyt); yyIndentSelector ("P"); yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM: yWriteFUNC_PARAM (yyt); yyIndentSelector ("F"); yyt = yyt->FUNC_PARAM.F; break;
case kFORMAT_PARAM: yWriteFORMAT_PARAM (yyt); goto yyExit;
case kRETURN_PARAM: yWriteRETURN_PARAM (yyt); goto yyExit;
case kNO_PARAM: (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_LIST: yWriteBTP_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTP_LIST.Next; break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBOOL_CONSTANT: yWriteBOOL_CONSTANT (yyt); goto yyExit;
case kINT_CONSTANT: yWriteINT_CONSTANT (yyt); goto yyExit;
case kREAL_CONSTANT: yWriteREAL_CONSTANT (yyt); goto yyExit;
case kDREAL_CONSTANT: yWriteDREAL_CONSTANT (yyt); goto yyExit;
case kCHAR_CONSTANT: yWriteCHAR_CONSTANT (yyt); goto yyExit;
case kSTRING_CONSTANT: yWriteSTRING_CONSTANT (yyt); goto yyExit;
case kCOMPLEX_CONSTANT: yWriteCOMPLEX_CONSTANT (yyt); goto yyExit;
case kPROC_OBJ: yWritePROC_OBJ (yyt); goto yyExit;
case kVAR_OBJ: yWriteVAR_OBJ (yyt); goto yyExit;
case kTYPE_OBJ: yWriteTYPE_OBJ (yyt); goto yyExit;
case kREC_COMP: yWriteREC_COMP (yyt); goto yyExit;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil    0374
# define yyNoLabel    0375
# define yyLabelDef    0376
# define yyLabelUse    0377

tTree ReverseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register tTree yyNew, yyNext, yyTail;
 yyNew = yyOld;
 yyTail = yyOld;
 for (;;) {
  switch (yyOld->Kind) {
  default: goto yyExit;
  }
  yyNew = yyOld;
  yyOld = yyNext;
 }
yyExit:
 switch (yyTail->Kind) {
 default: ;
 }
 return yyNew;
}

# define yyInitOldToNewStoreSize 32

typedef struct { tTree yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld, tTree yyNew)
# else
 (yyOld, yyNew) tTree yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tTree yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
}

static tTree yyCopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tTree yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoTree) { * yyNew = NoTree; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, Tree_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kCOMP_UNIT: (* yyNew)->COMP_UNIT = yyt->COMP_UNIT;
yyt = yyt->COMP_UNIT.COMP_ELEMENTS;
yyNew = & (* yyNew)->COMP_UNIT.COMP_ELEMENTS; break;
case kBODY_NODE: (* yyNew)->BODY_NODE = yyt->BODY_NODE;
copytTree ((* yyNew)->BODY_NODE.DECLS, yyt->BODY_NODE.DECLS)
copytTree ((* yyNew)->BODY_NODE.STATS, yyt->BODY_NODE.STATS)
yyt = yyt->BODY_NODE.INTERNALS;
yyNew = & (* yyNew)->BODY_NODE.INTERNALS; break;
case kTYPE_NODE: (* yyNew)->TYPE_NODE = yyt->TYPE_NODE;
return;
case kDUMMY_TYPE: (* yyNew)->DUMMY_TYPE = yyt->DUMMY_TYPE;
return;
case kVOID_TYPE: (* yyNew)->VOID_TYPE = yyt->VOID_TYPE;
return;
case kINTEGER_TYPE: (* yyNew)->INTEGER_TYPE = yyt->INTEGER_TYPE;
copyint ((* yyNew)->INTEGER_TYPE.size, yyt->INTEGER_TYPE.size)
return;
case kCARDINAL_TYPE: (* yyNew)->CARDINAL_TYPE = yyt->CARDINAL_TYPE;
copyint ((* yyNew)->CARDINAL_TYPE.size, yyt->CARDINAL_TYPE.size)
return;
case kREAL_TYPE: (* yyNew)->REAL_TYPE = yyt->REAL_TYPE;
copyint ((* yyNew)->REAL_TYPE.size, yyt->REAL_TYPE.size)
return;
case kBOOLEAN_TYPE: (* yyNew)->BOOLEAN_TYPE = yyt->BOOLEAN_TYPE;
copyint ((* yyNew)->BOOLEAN_TYPE.size, yyt->BOOLEAN_TYPE.size)
return;
case kCOMPLEX_TYPE: (* yyNew)->COMPLEX_TYPE = yyt->COMPLEX_TYPE;
copyint ((* yyNew)->COMPLEX_TYPE.size, yyt->COMPLEX_TYPE.size)
return;
case kCHAR_TYPE: (* yyNew)->CHAR_TYPE = yyt->CHAR_TYPE;
return;
case kSTRING_TYPE: (* yyNew)->STRING_TYPE = yyt->STRING_TYPE;
yyt = yyt->STRING_TYPE.LENGTH;
yyNew = & (* yyNew)->STRING_TYPE.LENGTH; break;
case kINDEX_TYPE: (* yyNew)->INDEX_TYPE = yyt->INDEX_TYPE;
copytTree ((* yyNew)->INDEX_TYPE.LOWER, yyt->INDEX_TYPE.LOWER)
copyint ((* yyNew)->INDEX_TYPE.left_overlap, yyt->INDEX_TYPE.left_overlap)
copyint ((* yyNew)->INDEX_TYPE.right_overlap, yyt->INDEX_TYPE.right_overlap)
yyt = yyt->INDEX_TYPE.UPPER;
yyNew = & (* yyNew)->INDEX_TYPE.UPPER; break;
case kTYPE_ID: (* yyNew)->TYPE_ID = yyt->TYPE_ID;
yyt = yyt->TYPE_ID.ID;
yyNew = & (* yyNew)->TYPE_ID.ID; break;
case kARRAY_TYPE: (* yyNew)->ARRAY_TYPE = yyt->ARRAY_TYPE;
copytTree ((* yyNew)->ARRAY_TYPE.ARRAY_INDEX_TYPES, yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES)
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE;
yyNew = & (* yyNew)->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE: (* yyNew)->RECORD_TYPE = yyt->RECORD_TYPE;
copytIdent ((* yyNew)->RECORD_TYPE.Name, yyt->RECORD_TYPE.Name)
yyt = yyt->RECORD_TYPE.COMPONENTS;
yyNew = & (* yyNew)->RECORD_TYPE.COMPONENTS; break;
case kUNION_TYPE: (* yyNew)->UNION_TYPE = yyt->UNION_TYPE;
copytIdent ((* yyNew)->UNION_TYPE.Name, yyt->UNION_TYPE.Name)
yyt = yyt->UNION_TYPE.COMPONENTS;
yyNew = & (* yyNew)->UNION_TYPE.COMPONENTS; break;
case kENUM_TYPE: (* yyNew)->ENUM_TYPE = yyt->ENUM_TYPE;
copytIdent ((* yyNew)->ENUM_TYPE.Name, yyt->ENUM_TYPE.Name)
yyt = yyt->ENUM_TYPE.COMPONENTS;
yyNew = & (* yyNew)->ENUM_TYPE.COMPONENTS; break;
case kDYNAMIC: (* yyNew)->DYNAMIC = yyt->DYNAMIC;
copytTree ((* yyNew)->DYNAMIC.Shape, yyt->DYNAMIC.Shape)
copyint ((* yyNew)->DYNAMIC.left_overlap, yyt->DYNAMIC.left_overlap)
copyint ((* yyNew)->DYNAMIC.right_overlap, yyt->DYNAMIC.right_overlap)
return;
case kPOINTER_TYPE: (* yyNew)->POINTER_TYPE = yyt->POINTER_TYPE;
yyt = yyt->POINTER_TYPE.PTR_COMP;
yyNew = & (* yyNew)->POINTER_TYPE.PTR_COMP; break;
case kARRAY1_TYPE: (* yyNew)->ARRAY1_TYPE = yyt->ARRAY1_TYPE;
copytTree ((* yyNew)->ARRAY1_TYPE.SIZE, yyt->ARRAY1_TYPE.SIZE)
yyt = yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE;
yyNew = & (* yyNew)->ARRAY1_TYPE.ARRAY1_COMP_TYPE; break;
case kFUNCTION_TYPE: (* yyNew)->FUNCTION_TYPE = yyt->FUNCTION_TYPE;
copytTree ((* yyNew)->FUNCTION_TYPE.FORMALS, yyt->FUNCTION_TYPE.FORMALS)
yyt = yyt->FUNCTION_TYPE.RESULT_TYPE;
yyNew = & (* yyNew)->FUNCTION_TYPE.RESULT_TYPE; break;
case kTYPE_NODE_LIST: (* yyNew)->TYPE_NODE_LIST = yyt->TYPE_NODE_LIST;
return;
case kTYPE_EMPTY: (* yyNew)->TYPE_EMPTY = yyt->TYPE_EMPTY;
return;
case kTYPE_LIST: (* yyNew)->TYPE_LIST = yyt->TYPE_LIST;
copytTree ((* yyNew)->TYPE_LIST.Elem, yyt->TYPE_LIST.Elem)
yyt = yyt->TYPE_LIST.Next;
yyNew = & (* yyNew)->TYPE_LIST.Next; break;
case kDECL_NODE: (* yyNew)->DECL_NODE = yyt->DECL_NODE;
copytIdent ((* yyNew)->DECL_NODE.Name, yyt->DECL_NODE.Name)
copyint ((* yyNew)->DECL_NODE.Pos, yyt->DECL_NODE.Pos)
return;
case kMODULE_DECL: (* yyNew)->MODULE_DECL = yyt->MODULE_DECL;
copytIdent ((* yyNew)->MODULE_DECL.Name, yyt->MODULE_DECL.Name)
copyint ((* yyNew)->MODULE_DECL.Pos, yyt->MODULE_DECL.Pos)
yyt = yyt->MODULE_DECL.MODULE_BODY;
yyNew = & (* yyNew)->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL: (* yyNew)->PROGRAM_DECL = yyt->PROGRAM_DECL;
copytIdent ((* yyNew)->PROGRAM_DECL.Name, yyt->PROGRAM_DECL.Name)
copyint ((* yyNew)->PROGRAM_DECL.Pos, yyt->PROGRAM_DECL.Pos)
copytTree ((* yyNew)->PROGRAM_DECL.FORMALS, yyt->PROGRAM_DECL.FORMALS)
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY;
yyNew = & (* yyNew)->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL: (* yyNew)->PROC_DECL = yyt->PROC_DECL;
copytIdent ((* yyNew)->PROC_DECL.Name, yyt->PROC_DECL.Name)
copyint ((* yyNew)->PROC_DECL.Pos, yyt->PROC_DECL.Pos)
copytTree ((* yyNew)->PROC_DECL.FORMALS, yyt->PROC_DECL.FORMALS)
copybool ((* yyNew)->PROC_DECL.IsRecursive, yyt->PROC_DECL.IsRecursive)
copybool ((* yyNew)->PROC_DECL.IsPure, yyt->PROC_DECL.IsPure)
copyint ((* yyNew)->PROC_DECL.HPFExtrinsic, yyt->PROC_DECL.HPFExtrinsic)
yyt = yyt->PROC_DECL.PROC_BODY;
yyNew = & (* yyNew)->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL: (* yyNew)->FUNC_DECL = yyt->FUNC_DECL;
copytIdent ((* yyNew)->FUNC_DECL.Name, yyt->FUNC_DECL.Name)
copyint ((* yyNew)->FUNC_DECL.Pos, yyt->FUNC_DECL.Pos)
copytTree ((* yyNew)->FUNC_DECL.FORMALS, yyt->FUNC_DECL.FORMALS)
copytTree ((* yyNew)->FUNC_DECL.FUNC_BODY, yyt->FUNC_DECL.FUNC_BODY)
copytIdent ((* yyNew)->FUNC_DECL.RESULT_ID, yyt->FUNC_DECL.RESULT_ID)
copybool ((* yyNew)->FUNC_DECL.IsRecursive, yyt->FUNC_DECL.IsRecursive)
copybool ((* yyNew)->FUNC_DECL.IsPure, yyt->FUNC_DECL.IsPure)
copyint ((* yyNew)->FUNC_DECL.HPFExtrinsic, yyt->FUNC_DECL.HPFExtrinsic)
yyt = yyt->FUNC_DECL.RESULT_TYPE;
yyNew = & (* yyNew)->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL: (* yyNew)->BLOCK_DATA_DECL = yyt->BLOCK_DATA_DECL;
copytIdent ((* yyNew)->BLOCK_DATA_DECL.Name, yyt->BLOCK_DATA_DECL.Name)
copyint ((* yyNew)->BLOCK_DATA_DECL.Pos, yyt->BLOCK_DATA_DECL.Pos)
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY;
yyNew = & (* yyNew)->BLOCK_DATA_DECL.DATA_BODY; break;
case kTYPE_DECL: (* yyNew)->TYPE_DECL = yyt->TYPE_DECL;
copytIdent ((* yyNew)->TYPE_DECL.Name, yyt->TYPE_DECL.Name)
copyint ((* yyNew)->TYPE_DECL.Pos, yyt->TYPE_DECL.Pos)
yyt = yyt->TYPE_DECL.VAL;
yyNew = & (* yyNew)->TYPE_DECL.VAL; break;
case kNAME_DECL: (* yyNew)->NAME_DECL = yyt->NAME_DECL;
copytIdent ((* yyNew)->NAME_DECL.Name, yyt->NAME_DECL.Name)
copyint ((* yyNew)->NAME_DECL.Pos, yyt->NAME_DECL.Pos)
return;
case kRENAME_DECL: (* yyNew)->RENAME_DECL = yyt->RENAME_DECL;
copytIdent ((* yyNew)->RENAME_DECL.Name, yyt->RENAME_DECL.Name)
copyint ((* yyNew)->RENAME_DECL.Pos, yyt->RENAME_DECL.Pos)
copytIdent ((* yyNew)->RENAME_DECL.oldname, yyt->RENAME_DECL.oldname)
return;
case kENTITY_DECL: (* yyNew)->ENTITY_DECL = yyt->ENTITY_DECL;
copytIdent ((* yyNew)->ENTITY_DECL.Name, yyt->ENTITY_DECL.Name)
copyint ((* yyNew)->ENTITY_DECL.Pos, yyt->ENTITY_DECL.Pos)
yyt = yyt->ENTITY_DECL.ATTRIBUTES;
yyNew = & (* yyNew)->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL: (* yyNew)->VAR_DECL = yyt->VAR_DECL;
copytIdent ((* yyNew)->VAR_DECL.Name, yyt->VAR_DECL.Name)
copyint ((* yyNew)->VAR_DECL.Pos, yyt->VAR_DECL.Pos)
yyt = yyt->VAR_DECL.VAL;
yyNew = & (* yyNew)->VAR_DECL.VAL; break;
case kCOMMON_DECL: (* yyNew)->COMMON_DECL = yyt->COMMON_DECL;
copytIdent ((* yyNew)->COMMON_DECL.Name, yyt->COMMON_DECL.Name)
copyint ((* yyNew)->COMMON_DECL.Pos, yyt->COMMON_DECL.Pos)
yyt = yyt->COMMON_DECL.IDS;
yyNew = & (* yyNew)->COMMON_DECL.IDS; break;
case kNAMELIST_DECL: (* yyNew)->NAMELIST_DECL = yyt->NAMELIST_DECL;
copytIdent ((* yyNew)->NAMELIST_DECL.Name, yyt->NAMELIST_DECL.Name)
copyint ((* yyNew)->NAMELIST_DECL.Pos, yyt->NAMELIST_DECL.Pos)
yyt = yyt->NAMELIST_DECL.IDS;
yyNew = & (* yyNew)->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL: (* yyNew)->TEMPLATE_DECL = yyt->TEMPLATE_DECL;
copytIdent ((* yyNew)->TEMPLATE_DECL.Name, yyt->TEMPLATE_DECL.Name)
copyint ((* yyNew)->TEMPLATE_DECL.Pos, yyt->TEMPLATE_DECL.Pos)
yyt = yyt->TEMPLATE_DECL.DIMENSIONS;
yyNew = & (* yyNew)->TEMPLATE_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL: (* yyNew)->PROCESSORS_DECL = yyt->PROCESSORS_DECL;
copytIdent ((* yyNew)->PROCESSORS_DECL.Name, yyt->PROCESSORS_DECL.Name)
copyint ((* yyNew)->PROCESSORS_DECL.Pos, yyt->PROCESSORS_DECL.Pos)
yyt = yyt->PROCESSORS_DECL.DIMENSIONS;
yyNew = & (* yyNew)->PROCESSORS_DECL.DIMENSIONS; break;
case kINHERIT_DECL: (* yyNew)->INHERIT_DECL = yyt->INHERIT_DECL;
copytIdent ((* yyNew)->INHERIT_DECL.Name, yyt->INHERIT_DECL.Name)
copyint ((* yyNew)->INHERIT_DECL.Pos, yyt->INHERIT_DECL.Pos)
return;
case kSTMT_FUNC_DECL: (* yyNew)->STMT_FUNC_DECL = yyt->STMT_FUNC_DECL;
copytIdent ((* yyNew)->STMT_FUNC_DECL.Name, yyt->STMT_FUNC_DECL.Name)
copyint ((* yyNew)->STMT_FUNC_DECL.Pos, yyt->STMT_FUNC_DECL.Pos)
copytTree ((* yyNew)->STMT_FUNC_DECL.FORMALS, yyt->STMT_FUNC_DECL.FORMALS)
copytTree ((* yyNew)->STMT_FUNC_DECL.RESULT_TYPE, yyt->STMT_FUNC_DECL.RESULT_TYPE)
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY;
yyNew = & (* yyNew)->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL: (* yyNew)->INTERFACE_DECL = yyt->INTERFACE_DECL;
copytIdent ((* yyNew)->INTERFACE_DECL.Name, yyt->INTERFACE_DECL.Name)
copyint ((* yyNew)->INTERFACE_DECL.Pos, yyt->INTERFACE_DECL.Pos)
copytTree ((* yyNew)->INTERFACE_DECL.SPEC, yyt->INTERFACE_DECL.SPEC)
yyt = yyt->INTERFACE_DECL.ITEMS;
yyNew = & (* yyNew)->INTERFACE_DECL.ITEMS; break;
case kEXT_PROC_DECL: (* yyNew)->EXT_PROC_DECL = yyt->EXT_PROC_DECL;
copytIdent ((* yyNew)->EXT_PROC_DECL.Name, yyt->EXT_PROC_DECL.Name)
copyint ((* yyNew)->EXT_PROC_DECL.Pos, yyt->EXT_PROC_DECL.Pos)
yyt = yyt->EXT_PROC_DECL.FORMALS;
yyNew = & (* yyNew)->EXT_PROC_DECL.FORMALS; break;
case kEXT_FUNC_DECL: (* yyNew)->EXT_FUNC_DECL = yyt->EXT_FUNC_DECL;
copytIdent ((* yyNew)->EXT_FUNC_DECL.Name, yyt->EXT_FUNC_DECL.Name)
copyint ((* yyNew)->EXT_FUNC_DECL.Pos, yyt->EXT_FUNC_DECL.Pos)
copytTree ((* yyNew)->EXT_FUNC_DECL.FORMALS, yyt->EXT_FUNC_DECL.FORMALS)
yyt = yyt->EXT_FUNC_DECL.RESULT_TYPE;
yyNew = & (* yyNew)->EXT_FUNC_DECL.RESULT_TYPE; break;
case kVAL_PARAM_DECL: (* yyNew)->VAL_PARAM_DECL = yyt->VAL_PARAM_DECL;
copytIdent ((* yyNew)->VAL_PARAM_DECL.Name, yyt->VAL_PARAM_DECL.Name)
copyint ((* yyNew)->VAL_PARAM_DECL.Pos, yyt->VAL_PARAM_DECL.Pos)
yyt = yyt->VAL_PARAM_DECL.VAL;
yyNew = & (* yyNew)->VAL_PARAM_DECL.VAL; break;
case kVAR_PARAM_DECL: (* yyNew)->VAR_PARAM_DECL = yyt->VAR_PARAM_DECL;
copytIdent ((* yyNew)->VAR_PARAM_DECL.Name, yyt->VAR_PARAM_DECL.Name)
copyint ((* yyNew)->VAR_PARAM_DECL.Pos, yyt->VAR_PARAM_DECL.Pos)
yyt = yyt->VAR_PARAM_DECL.VAL;
yyNew = & (* yyNew)->VAR_PARAM_DECL.VAL; break;
case kPROC_PARAM_DECL: (* yyNew)->PROC_PARAM_DECL = yyt->PROC_PARAM_DECL;
copytIdent ((* yyNew)->PROC_PARAM_DECL.Name, yyt->PROC_PARAM_DECL.Name)
copyint ((* yyNew)->PROC_PARAM_DECL.Pos, yyt->PROC_PARAM_DECL.Pos)
yyt = yyt->PROC_PARAM_DECL.FORMAL;
yyNew = & (* yyNew)->PROC_PARAM_DECL.FORMAL; break;
case kFUNC_PARAM_DECL: (* yyNew)->FUNC_PARAM_DECL = yyt->FUNC_PARAM_DECL;
copytIdent ((* yyNew)->FUNC_PARAM_DECL.Name, yyt->FUNC_PARAM_DECL.Name)
copyint ((* yyNew)->FUNC_PARAM_DECL.Pos, yyt->FUNC_PARAM_DECL.Pos)
copytTree ((* yyNew)->FUNC_PARAM_DECL.FORMAL, yyt->FUNC_PARAM_DECL.FORMAL)
yyt = yyt->FUNC_PARAM_DECL.RESULT_TYPE;
yyNew = & (* yyNew)->FUNC_PARAM_DECL.RESULT_TYPE; break;
case kELIPSIS_PARAM_DECL: (* yyNew)->ELIPSIS_PARAM_DECL = yyt->ELIPSIS_PARAM_DECL;
copytIdent ((* yyNew)->ELIPSIS_PARAM_DECL.Name, yyt->ELIPSIS_PARAM_DECL.Name)
copyint ((* yyNew)->ELIPSIS_PARAM_DECL.Pos, yyt->ELIPSIS_PARAM_DECL.Pos)
return;
case kRET_PARAM_DECL: (* yyNew)->RET_PARAM_DECL = yyt->RET_PARAM_DECL;
copytIdent ((* yyNew)->RET_PARAM_DECL.Name, yyt->RET_PARAM_DECL.Name)
copyint ((* yyNew)->RET_PARAM_DECL.Pos, yyt->RET_PARAM_DECL.Pos)
return;
case kIMPLICIT_DECL: (* yyNew)->IMPLICIT_DECL = yyt->IMPLICIT_DECL;
copytIdent ((* yyNew)->IMPLICIT_DECL.Name, yyt->IMPLICIT_DECL.Name)
copyint ((* yyNew)->IMPLICIT_DECL.Pos, yyt->IMPLICIT_DECL.Pos)
copytIdent ((* yyNew)->IMPLICIT_DECL.first, yyt->IMPLICIT_DECL.first)
copytIdent ((* yyNew)->IMPLICIT_DECL.last, yyt->IMPLICIT_DECL.last)
yyt = yyt->IMPLICIT_DECL.VAL;
yyNew = & (* yyNew)->IMPLICIT_DECL.VAL; break;
case kUSE_DECL: (* yyNew)->USE_DECL = yyt->USE_DECL;
copytIdent ((* yyNew)->USE_DECL.Name, yyt->USE_DECL.Name)
copyint ((* yyNew)->USE_DECL.Pos, yyt->USE_DECL.Pos)
copytIdent ((* yyNew)->USE_DECL.use, yyt->USE_DECL.use)
yyt = yyt->USE_DECL.RENAMINGS;
yyNew = & (* yyNew)->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL: (* yyNew)->ONLY_USE_DECL = yyt->ONLY_USE_DECL;
copytIdent ((* yyNew)->ONLY_USE_DECL.Name, yyt->ONLY_USE_DECL.Name)
copyint ((* yyNew)->ONLY_USE_DECL.Pos, yyt->ONLY_USE_DECL.Pos)
copytIdent ((* yyNew)->ONLY_USE_DECL.use, yyt->ONLY_USE_DECL.use)
yyt = yyt->ONLY_USE_DECL.NAMES;
yyNew = & (* yyNew)->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL: (* yyNew)->EQV_DECL = yyt->EQV_DECL;
copytIdent ((* yyNew)->EQV_DECL.Name, yyt->EQV_DECL.Name)
copyint ((* yyNew)->EQV_DECL.Pos, yyt->EQV_DECL.Pos)
yyt = yyt->EQV_DECL.VARS;
yyNew = & (* yyNew)->EQV_DECL.VARS; break;
case kDATA_DECL: (* yyNew)->DATA_DECL = yyt->DATA_DECL;
copytIdent ((* yyNew)->DATA_DECL.Name, yyt->DATA_DECL.Name)
copyint ((* yyNew)->DATA_DECL.Pos, yyt->DATA_DECL.Pos)
copytTree ((* yyNew)->DATA_DECL.VARS, yyt->DATA_DECL.VARS)
yyt = yyt->DATA_DECL.VALS;
yyNew = & (* yyNew)->DATA_DECL.VALS; break;
case kDIMENSION_DECL: (* yyNew)->DIMENSION_DECL = yyt->DIMENSION_DECL;
copytIdent ((* yyNew)->DIMENSION_DECL.Name, yyt->DIMENSION_DECL.Name)
copyint ((* yyNew)->DIMENSION_DECL.Pos, yyt->DIMENSION_DECL.Pos)
yyt = yyt->DIMENSION_DECL.INDEXES;
yyNew = & (* yyNew)->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL: (* yyNew)->INIT_DATA_DECL = yyt->INIT_DATA_DECL;
copytIdent ((* yyNew)->INIT_DATA_DECL.Name, yyt->INIT_DATA_DECL.Name)
copyint ((* yyNew)->INIT_DATA_DECL.Pos, yyt->INIT_DATA_DECL.Pos)
yyt = yyt->INIT_DATA_DECL.VAL;
yyNew = & (* yyNew)->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL: (* yyNew)->TYPESPEC_DECL = yyt->TYPESPEC_DECL;
copytIdent ((* yyNew)->TYPESPEC_DECL.Name, yyt->TYPESPEC_DECL.Name)
copyint ((* yyNew)->TYPESPEC_DECL.Pos, yyt->TYPESPEC_DECL.Pos)
yyt = yyt->TYPESPEC_DECL.VAL;
yyNew = & (* yyNew)->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL: (* yyNew)->ALLOCATABLE_DECL = yyt->ALLOCATABLE_DECL;
copytIdent ((* yyNew)->ALLOCATABLE_DECL.Name, yyt->ALLOCATABLE_DECL.Name)
copyint ((* yyNew)->ALLOCATABLE_DECL.Pos, yyt->ALLOCATABLE_DECL.Pos)
return;
case kEXTERNAL_DECL: (* yyNew)->EXTERNAL_DECL = yyt->EXTERNAL_DECL;
copytIdent ((* yyNew)->EXTERNAL_DECL.Name, yyt->EXTERNAL_DECL.Name)
copyint ((* yyNew)->EXTERNAL_DECL.Pos, yyt->EXTERNAL_DECL.Pos)
return;
case kINTENT_DECL: (* yyNew)->INTENT_DECL = yyt->INTENT_DECL;
copytIdent ((* yyNew)->INTENT_DECL.Name, yyt->INTENT_DECL.Name)
copyint ((* yyNew)->INTENT_DECL.Pos, yyt->INTENT_DECL.Pos)
copyint ((* yyNew)->INTENT_DECL.intent, yyt->INTENT_DECL.intent)
return;
case kINTRINSIC_DECL: (* yyNew)->INTRINSIC_DECL = yyt->INTRINSIC_DECL;
copytIdent ((* yyNew)->INTRINSIC_DECL.Name, yyt->INTRINSIC_DECL.Name)
copyint ((* yyNew)->INTRINSIC_DECL.Pos, yyt->INTRINSIC_DECL.Pos)
return;
case kOPTIONAL_DECL: (* yyNew)->OPTIONAL_DECL = yyt->OPTIONAL_DECL;
copytIdent ((* yyNew)->OPTIONAL_DECL.Name, yyt->OPTIONAL_DECL.Name)
copyint ((* yyNew)->OPTIONAL_DECL.Pos, yyt->OPTIONAL_DECL.Pos)
return;
case kPOINTER_DECL: (* yyNew)->POINTER_DECL = yyt->POINTER_DECL;
copytIdent ((* yyNew)->POINTER_DECL.Name, yyt->POINTER_DECL.Name)
copyint ((* yyNew)->POINTER_DECL.Pos, yyt->POINTER_DECL.Pos)
return;
case kSAVE_DECL: (* yyNew)->SAVE_DECL = yyt->SAVE_DECL;
copytIdent ((* yyNew)->SAVE_DECL.Name, yyt->SAVE_DECL.Name)
copyint ((* yyNew)->SAVE_DECL.Pos, yyt->SAVE_DECL.Pos)
return;
case kTARGET_DECL: (* yyNew)->TARGET_DECL = yyt->TARGET_DECL;
copytIdent ((* yyNew)->TARGET_DECL.Name, yyt->TARGET_DECL.Name)
copyint ((* yyNew)->TARGET_DECL.Pos, yyt->TARGET_DECL.Pos)
return;
case kPARAMETER_DECL: (* yyNew)->PARAMETER_DECL = yyt->PARAMETER_DECL;
copytIdent ((* yyNew)->PARAMETER_DECL.Name, yyt->PARAMETER_DECL.Name)
copyint ((* yyNew)->PARAMETER_DECL.Pos, yyt->PARAMETER_DECL.Pos)
yyt = yyt->PARAMETER_DECL.VAL;
yyNew = & (* yyNew)->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL: (* yyNew)->PUBLIC_DECL = yyt->PUBLIC_DECL;
copytIdent ((* yyNew)->PUBLIC_DECL.Name, yyt->PUBLIC_DECL.Name)
copyint ((* yyNew)->PUBLIC_DECL.Pos, yyt->PUBLIC_DECL.Pos)
return;
case kPRIVATE_DECL: (* yyNew)->PRIVATE_DECL = yyt->PRIVATE_DECL;
copytIdent ((* yyNew)->PRIVATE_DECL.Name, yyt->PRIVATE_DECL.Name)
copyint ((* yyNew)->PRIVATE_DECL.Pos, yyt->PRIVATE_DECL.Pos)
return;
case kDISTRIBUTE_DECL: (* yyNew)->DISTRIBUTE_DECL = yyt->DISTRIBUTE_DECL;
copytIdent ((* yyNew)->DISTRIBUTE_DECL.Name, yyt->DISTRIBUTE_DECL.Name)
copyint ((* yyNew)->DISTRIBUTE_DECL.Pos, yyt->DISTRIBUTE_DECL.Pos)
copytIdent ((* yyNew)->DISTRIBUTE_DECL.target, yyt->DISTRIBUTE_DECL.target)
yyt = yyt->DISTRIBUTE_DECL.DISTRIBUTION;
yyNew = & (* yyNew)->DISTRIBUTE_DECL.DISTRIBUTION; break;
case kALIGN_DECL: (* yyNew)->ALIGN_DECL = yyt->ALIGN_DECL;
copytIdent ((* yyNew)->ALIGN_DECL.Name, yyt->ALIGN_DECL.Name)
copyint ((* yyNew)->ALIGN_DECL.Pos, yyt->ALIGN_DECL.Pos)
copytTree ((* yyNew)->ALIGN_DECL.ALIGN_SOURCE, yyt->ALIGN_DECL.ALIGN_SOURCE)
yyt = yyt->ALIGN_DECL.ALIGN_SPEC;
yyNew = & (* yyNew)->ALIGN_DECL.ALIGN_SPEC; break;
case kDYNAMIC_DECL: (* yyNew)->DYNAMIC_DECL = yyt->DYNAMIC_DECL;
copytIdent ((* yyNew)->DYNAMIC_DECL.Name, yyt->DYNAMIC_DECL.Name)
copyint ((* yyNew)->DYNAMIC_DECL.Pos, yyt->DYNAMIC_DECL.Pos)
return;
case kSEQUENCE_DECL: (* yyNew)->SEQUENCE_DECL = yyt->SEQUENCE_DECL;
copytIdent ((* yyNew)->SEQUENCE_DECL.Name, yyt->SEQUENCE_DECL.Name)
copyint ((* yyNew)->SEQUENCE_DECL.Pos, yyt->SEQUENCE_DECL.Pos)
return;
case kNOSEQUENCE_DECL: (* yyNew)->NOSEQUENCE_DECL = yyt->NOSEQUENCE_DECL;
copytIdent ((* yyNew)->NOSEQUENCE_DECL.Name, yyt->NOSEQUENCE_DECL.Name)
copyint ((* yyNew)->NOSEQUENCE_DECL.Pos, yyt->NOSEQUENCE_DECL.Pos)
return;
case kDECL_NODE_LIST: (* yyNew)->DECL_NODE_LIST = yyt->DECL_NODE_LIST;
return;
case kDECL_EMPTY: (* yyNew)->DECL_EMPTY = yyt->DECL_EMPTY;
return;
case kDECL_LIST: (* yyNew)->DECL_LIST = yyt->DECL_LIST;
copytTree ((* yyNew)->DECL_LIST.Elem, yyt->DECL_LIST.Elem)
yyt = yyt->DECL_LIST.Next;
yyNew = & (* yyNew)->DECL_LIST.Next; break;
case kDISTRIBUTION_SPEC: (* yyNew)->DISTRIBUTION_SPEC = yyt->DISTRIBUTION_SPEC;
return;
case kHOST_DISTRIBUTION: (* yyNew)->HOST_DISTRIBUTION = yyt->HOST_DISTRIBUTION;
return;
case kREPL_DISTRIBUTION: (* yyNew)->REPL_DISTRIBUTION = yyt->REPL_DISTRIBUTION;
return;
case kNODE_DISTRIBUTION: (* yyNew)->NODE_DISTRIBUTION = yyt->NODE_DISTRIBUTION;
yyt = yyt->NODE_DISTRIBUTION.MAPPING;
yyNew = & (* yyNew)->NODE_DISTRIBUTION.MAPPING; break;
case kDISTRIBUTION_FORMAT: (* yyNew)->DISTRIBUTION_FORMAT = yyt->DISTRIBUTION_FORMAT;
return;
case kBLOCK_DISTRIBUTION: (* yyNew)->BLOCK_DISTRIBUTION = yyt->BLOCK_DISTRIBUTION;
yyt = yyt->BLOCK_DISTRIBUTION.SIZE;
yyNew = & (* yyNew)->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION: (* yyNew)->CYCLIC_DISTRIBUTION = yyt->CYCLIC_DISTRIBUTION;
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE;
yyNew = & (* yyNew)->CYCLIC_DISTRIBUTION.SIZE; break;
case kSERIAL_DISTRIBUTION: (* yyNew)->SERIAL_DISTRIBUTION = yyt->SERIAL_DISTRIBUTION;
return;
case kDIST_FORMAT_LIST: (* yyNew)->DIST_FORMAT_LIST = yyt->DIST_FORMAT_LIST;
return;
case kDIST_EMPTY: (* yyNew)->DIST_EMPTY = yyt->DIST_EMPTY;
return;
case kDIST_LIST: (* yyNew)->DIST_LIST = yyt->DIST_LIST;
copytTree ((* yyNew)->DIST_LIST.Elem, yyt->DIST_LIST.Elem)
yyt = yyt->DIST_LIST.Next;
yyNew = & (* yyNew)->DIST_LIST.Next; break;
case kGENERIC_SPEC: (* yyNew)->GENERIC_SPEC = yyt->GENERIC_SPEC;
return;
case kNO_GENERIC_SPEC: (* yyNew)->NO_GENERIC_SPEC = yyt->NO_GENERIC_SPEC;
return;
case kID_GENERIC_SPEC: (* yyNew)->ID_GENERIC_SPEC = yyt->ID_GENERIC_SPEC;
copytIdent ((* yyNew)->ID_GENERIC_SPEC.name, yyt->ID_GENERIC_SPEC.name)
return;
case kOP_GENERIC_SPEC: (* yyNew)->OP_GENERIC_SPEC = yyt->OP_GENERIC_SPEC;
yyt = yyt->OP_GENERIC_SPEC.OPERATOR;
yyNew = & (* yyNew)->OP_GENERIC_SPEC.OPERATOR; break;
case kASSIGN_GENERIC_SPEC: (* yyNew)->ASSIGN_GENERIC_SPEC = yyt->ASSIGN_GENERIC_SPEC;
return;
case kACF_NODE_LIST: (* yyNew)->ACF_NODE_LIST = yyt->ACF_NODE_LIST;
return;
case kACF_EMPTY: (* yyNew)->ACF_EMPTY = yyt->ACF_EMPTY;
return;
case kACF_LIST: (* yyNew)->ACF_LIST = yyt->ACF_LIST;
copytTree ((* yyNew)->ACF_LIST.Elem, yyt->ACF_LIST.Elem)
yyt = yyt->ACF_LIST.Next;
yyNew = & (* yyNew)->ACF_LIST.Next; break;
case kACF_NODE: (* yyNew)->ACF_NODE = yyt->ACF_NODE;
copyint ((* yyNew)->ACF_NODE.Label, yyt->ACF_NODE.Label)
copyint ((* yyNew)->ACF_NODE.Line, yyt->ACF_NODE.Line)
return;
case kACF_DUMMY: (* yyNew)->ACF_DUMMY = yyt->ACF_DUMMY;
copyint ((* yyNew)->ACF_DUMMY.Label, yyt->ACF_DUMMY.Label)
copyint ((* yyNew)->ACF_DUMMY.Line, yyt->ACF_DUMMY.Line)
return;
case kACF_BASIC: (* yyNew)->ACF_BASIC = yyt->ACF_BASIC;
copyint ((* yyNew)->ACF_BASIC.Label, yyt->ACF_BASIC.Label)
copyint ((* yyNew)->ACF_BASIC.Line, yyt->ACF_BASIC.Line)
yyt = yyt->ACF_BASIC.BASIC_STMT;
yyNew = & (* yyNew)->ACF_BASIC.BASIC_STMT; break;
case kACF_IF: (* yyNew)->ACF_IF = yyt->ACF_IF;
copyint ((* yyNew)->ACF_IF.Label, yyt->ACF_IF.Label)
copyint ((* yyNew)->ACF_IF.Line, yyt->ACF_IF.Line)
copytTree ((* yyNew)->ACF_IF.IF_EXP, yyt->ACF_IF.IF_EXP)
copytTree ((* yyNew)->ACF_IF.THEN_PART, yyt->ACF_IF.THEN_PART)
yyt = yyt->ACF_IF.ELSE_PART;
yyNew = & (* yyNew)->ACF_IF.ELSE_PART; break;
case kACF_WHERE: (* yyNew)->ACF_WHERE = yyt->ACF_WHERE;
copyint ((* yyNew)->ACF_WHERE.Label, yyt->ACF_WHERE.Label)
copyint ((* yyNew)->ACF_WHERE.Line, yyt->ACF_WHERE.Line)
copytTree ((* yyNew)->ACF_WHERE.WHERE_EXP, yyt->ACF_WHERE.WHERE_EXP)
copytTree ((* yyNew)->ACF_WHERE.TRUE_PART, yyt->ACF_WHERE.TRUE_PART)
yyt = yyt->ACF_WHERE.FALSE_PART;
yyNew = & (* yyNew)->ACF_WHERE.FALSE_PART; break;
case kACF_SWITCH: (* yyNew)->ACF_SWITCH = yyt->ACF_SWITCH;
copyint ((* yyNew)->ACF_SWITCH.Label, yyt->ACF_SWITCH.Label)
copyint ((* yyNew)->ACF_SWITCH.Line, yyt->ACF_SWITCH.Line)
copytTree ((* yyNew)->ACF_SWITCH.SWITCH_EXP, yyt->ACF_SWITCH.SWITCH_EXP)
yyt = yyt->ACF_SWITCH.SWITCH_STMT;
yyNew = & (* yyNew)->ACF_SWITCH.SWITCH_STMT; break;
case kACF_ALTER: (* yyNew)->ACF_ALTER = yyt->ACF_ALTER;
copyint ((* yyNew)->ACF_ALTER.Label, yyt->ACF_ALTER.Label)
copyint ((* yyNew)->ACF_ALTER.Line, yyt->ACF_ALTER.Line)
copytTree ((* yyNew)->ACF_ALTER.ALTER_EXP, yyt->ACF_ALTER.ALTER_EXP)
yyt = yyt->ACF_ALTER.ALTER_STMT;
yyNew = & (* yyNew)->ACF_ALTER.ALTER_STMT; break;
case kACF_CASE: (* yyNew)->ACF_CASE = yyt->ACF_CASE;
copyint ((* yyNew)->ACF_CASE.Label, yyt->ACF_CASE.Label)
copyint ((* yyNew)->ACF_CASE.Line, yyt->ACF_CASE.Line)
copytTree ((* yyNew)->ACF_CASE.CASE_EXP, yyt->ACF_CASE.CASE_EXP)
copytTree ((* yyNew)->ACF_CASE.CASE_ALTS, yyt->ACF_CASE.CASE_ALTS)
yyt = yyt->ACF_CASE.CASE_OTHERWISE;
yyNew = & (* yyNew)->ACF_CASE.CASE_OTHERWISE; break;
case kACF_WHILE: (* yyNew)->ACF_WHILE = yyt->ACF_WHILE;
copyint ((* yyNew)->ACF_WHILE.Label, yyt->ACF_WHILE.Label)
copyint ((* yyNew)->ACF_WHILE.Line, yyt->ACF_WHILE.Line)
copytTree ((* yyNew)->ACF_WHILE.WHILE_EXP, yyt->ACF_WHILE.WHILE_EXP)
yyt = yyt->ACF_WHILE.WHILE_BODY;
yyNew = & (* yyNew)->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT: (* yyNew)->ACF_REPEAT = yyt->ACF_REPEAT;
copyint ((* yyNew)->ACF_REPEAT.Label, yyt->ACF_REPEAT.Label)
copyint ((* yyNew)->ACF_REPEAT.Line, yyt->ACF_REPEAT.Line)
copytTree ((* yyNew)->ACF_REPEAT.REPEAT_BODY, yyt->ACF_REPEAT.REPEAT_BODY)
yyt = yyt->ACF_REPEAT.REPEAT_EXP;
yyNew = & (* yyNew)->ACF_REPEAT.REPEAT_EXP; break;
case kACF_WITH: (* yyNew)->ACF_WITH = yyt->ACF_WITH;
copyint ((* yyNew)->ACF_WITH.Label, yyt->ACF_WITH.Label)
copyint ((* yyNew)->ACF_WITH.Line, yyt->ACF_WITH.Line)
copytTree ((* yyNew)->ACF_WITH.WITH_VARS, yyt->ACF_WITH.WITH_VARS)
yyt = yyt->ACF_WITH.WITH_BODY;
yyNew = & (* yyNew)->ACF_WITH.WITH_BODY; break;
case kACF_LOOP: (* yyNew)->ACF_LOOP = yyt->ACF_LOOP;
copyint ((* yyNew)->ACF_LOOP.Label, yyt->ACF_LOOP.Label)
copyint ((* yyNew)->ACF_LOOP.Line, yyt->ACF_LOOP.Line)
yyt = yyt->ACF_LOOP.LOOP_BODY;
yyNew = & (* yyNew)->ACF_LOOP.LOOP_BODY; break;
case kACF_DO: (* yyNew)->ACF_DO = yyt->ACF_DO;
copyint ((* yyNew)->ACF_DO.Label, yyt->ACF_DO.Label)
copyint ((* yyNew)->ACF_DO.Line, yyt->ACF_DO.Line)
copytTree ((* yyNew)->ACF_DO.DO_ID, yyt->ACF_DO.DO_ID)
copytTree ((* yyNew)->ACF_DO.DO_RANGE, yyt->ACF_DO.DO_RANGE)
yyt = yyt->ACF_DO.DO_BODY;
yyNew = & (* yyNew)->ACF_DO.DO_BODY; break;
case kACF_DOLOCAL: (* yyNew)->ACF_DOLOCAL = yyt->ACF_DOLOCAL;
copyint ((* yyNew)->ACF_DOLOCAL.Label, yyt->ACF_DOLOCAL.Label)
copyint ((* yyNew)->ACF_DOLOCAL.Line, yyt->ACF_DOLOCAL.Line)
copytTree ((* yyNew)->ACF_DOLOCAL.DOLOCAL_ID, yyt->ACF_DOLOCAL.DOLOCAL_ID)
copytTree ((* yyNew)->ACF_DOLOCAL.DOLOCAL_RANGE, yyt->ACF_DOLOCAL.DOLOCAL_RANGE)
yyt = yyt->ACF_DOLOCAL.DOLOCAL_BODY;
yyNew = & (* yyNew)->ACF_DOLOCAL.DOLOCAL_BODY; break;
case kACF_DOVEC: (* yyNew)->ACF_DOVEC = yyt->ACF_DOVEC;
copyint ((* yyNew)->ACF_DOVEC.Label, yyt->ACF_DOVEC.Label)
copyint ((* yyNew)->ACF_DOVEC.Line, yyt->ACF_DOVEC.Line)
copytTree ((* yyNew)->ACF_DOVEC.DOVEC_ID, yyt->ACF_DOVEC.DOVEC_ID)
copytTree ((* yyNew)->ACF_DOVEC.DOVEC_RANGE, yyt->ACF_DOVEC.DOVEC_RANGE)
yyt = yyt->ACF_DOVEC.DOVEC_BODY;
yyNew = & (* yyNew)->ACF_DOVEC.DOVEC_BODY; break;
case kACF_DOALL: (* yyNew)->ACF_DOALL = yyt->ACF_DOALL;
copyint ((* yyNew)->ACF_DOALL.Label, yyt->ACF_DOALL.Label)
copyint ((* yyNew)->ACF_DOALL.Line, yyt->ACF_DOALL.Line)
copytTree ((* yyNew)->ACF_DOALL.DOALL_NEW, yyt->ACF_DOALL.DOALL_NEW)
copytTree ((* yyNew)->ACF_DOALL.DOALL_ID, yyt->ACF_DOALL.DOALL_ID)
copytTree ((* yyNew)->ACF_DOALL.DOALL_RANGE, yyt->ACF_DOALL.DOALL_RANGE)
yyt = yyt->ACF_DOALL.DOALL_BODY;
yyNew = & (* yyNew)->ACF_DOALL.DOALL_BODY; break;
case kACF_FORALL: (* yyNew)->ACF_FORALL = yyt->ACF_FORALL;
copyint ((* yyNew)->ACF_FORALL.Label, yyt->ACF_FORALL.Label)
copyint ((* yyNew)->ACF_FORALL.Line, yyt->ACF_FORALL.Line)
copytTree ((* yyNew)->ACF_FORALL.FORALL_ID, yyt->ACF_FORALL.FORALL_ID)
copytTree ((* yyNew)->ACF_FORALL.FORALL_RANGE, yyt->ACF_FORALL.FORALL_RANGE)
yyt = yyt->ACF_FORALL.FORALL_BODY;
yyNew = & (* yyNew)->ACF_FORALL.FORALL_BODY; break;
case kACF_ON: (* yyNew)->ACF_ON = yyt->ACF_ON;
copyint ((* yyNew)->ACF_ON.Label, yyt->ACF_ON.Label)
copyint ((* yyNew)->ACF_ON.Line, yyt->ACF_ON.Line)
copytTree ((* yyNew)->ACF_ON.ON_VAR, yyt->ACF_ON.ON_VAR)
yyt = yyt->ACF_ON.ON_STMT;
yyNew = & (* yyNew)->ACF_ON.ON_STMT; break;
case kACF_BODY: (* yyNew)->ACF_BODY = yyt->ACF_BODY;
copyint ((* yyNew)->ACF_BODY.Label, yyt->ACF_BODY.Label)
copyint ((* yyNew)->ACF_BODY.Line, yyt->ACF_BODY.Line)
copytDefinitions ((* yyNew)->ACF_BODY.Entries, yyt->ACF_BODY.Entries)
yyt = yyt->ACF_BODY.NEW_BODY;
yyNew = & (* yyNew)->ACF_BODY.NEW_BODY; break;
case kACF_FLOW_GRAPH: (* yyNew)->ACF_FLOW_GRAPH = yyt->ACF_FLOW_GRAPH;
copyint ((* yyNew)->ACF_FLOW_GRAPH.Label, yyt->ACF_FLOW_GRAPH.Label)
copyint ((* yyNew)->ACF_FLOW_GRAPH.Line, yyt->ACF_FLOW_GRAPH.Line)
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES;
yyNew = & (* yyNew)->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY: (* yyNew)->ACF_ENTRY = yyt->ACF_ENTRY;
copyint ((* yyNew)->ACF_ENTRY.Label, yyt->ACF_ENTRY.Label)
copyint ((* yyNew)->ACF_ENTRY.Line, yyt->ACF_ENTRY.Line)
yyt = yyt->ACF_ENTRY.ENTRY_DECL;
yyNew = & (* yyNew)->ACF_ENTRY.ENTRY_DECL; break;
case kACF_FLOW_KIND: (* yyNew)->ACF_FLOW_KIND = yyt->ACF_FLOW_KIND;
return;
case kACF_COMPLEX_FLOW: (* yyNew)->ACF_COMPLEX_FLOW = yyt->ACF_COMPLEX_FLOW;
return;
case kACF_INTERVAL_FLOW: (* yyNew)->ACF_INTERVAL_FLOW = yyt->ACF_INTERVAL_FLOW;
return;
case kACF_SIMPLE_FLOW: (* yyNew)->ACF_SIMPLE_FLOW = yyt->ACF_SIMPLE_FLOW;
return;
case kSELECTED_ACF_NODE_LIST: (* yyNew)->SELECTED_ACF_NODE_LIST = yyt->SELECTED_ACF_NODE_LIST;
return;
case kSELECTED_ACF_EMPTY: (* yyNew)->SELECTED_ACF_EMPTY = yyt->SELECTED_ACF_EMPTY;
return;
case kSELECTED_ACF_LIST: (* yyNew)->SELECTED_ACF_LIST = yyt->SELECTED_ACF_LIST;
copytTree ((* yyNew)->SELECTED_ACF_LIST.Elem, yyt->SELECTED_ACF_LIST.Elem)
yyt = yyt->SELECTED_ACF_LIST.Next;
yyNew = & (* yyNew)->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE: (* yyNew)->SELECTED_ACF_NODE = yyt->SELECTED_ACF_NODE;
copytTree ((* yyNew)->SELECTED_ACF_NODE.SELECT_LIST, yyt->SELECTED_ACF_NODE.SELECT_LIST)
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS;
yyNew = & (* yyNew)->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kBT_STMT: (* yyNew)->BT_STMT = yyt->BT_STMT;
return;
case kEXP_STMT: (* yyNew)->EXP_STMT = yyt->EXP_STMT;
yyt = yyt->EXP_STMT.STMT_EXP;
yyNew = & (* yyNew)->EXP_STMT.STMT_EXP; break;
case kASSIGN_STMT: (* yyNew)->ASSIGN_STMT = yyt->ASSIGN_STMT;
copytTree ((* yyNew)->ASSIGN_STMT.ASSIGN_VAR, yyt->ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP;
yyNew = & (* yyNew)->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT: (* yyNew)->PTR_ASSIGN_STMT = yyt->PTR_ASSIGN_STMT;
copytTree ((* yyNew)->PTR_ASSIGN_STMT.ASSIGN_VAR, yyt->PTR_ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP;
yyNew = & (* yyNew)->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT: (* yyNew)->LABEL_ASSIGN_STMT = yyt->LABEL_ASSIGN_STMT;
copyint ((* yyNew)->LABEL_ASSIGN_STMT.assign_label, yyt->LABEL_ASSIGN_STMT.assign_label)
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR;
yyNew = & (* yyNew)->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT: (* yyNew)->CALL_STMT = yyt->CALL_STMT;
copytTree ((* yyNew)->CALL_STMT.CALL_ID, yyt->CALL_STMT.CALL_ID)
yyt = yyt->CALL_STMT.CALL_PARAMS;
yyNew = & (* yyNew)->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT: (* yyNew)->IO_STMT = yyt->IO_STMT;
copytTree ((* yyNew)->IO_STMT.ID, yyt->IO_STMT.ID)
copytTree ((* yyNew)->IO_STMT.IO_SPECS, yyt->IO_STMT.IO_SPECS)
yyt = yyt->IO_STMT.IO_ITEMS;
yyNew = & (* yyNew)->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT: (* yyNew)->GOTO_STMT = yyt->GOTO_STMT;
copyint ((* yyNew)->GOTO_STMT.GOTO_LABEL, yyt->GOTO_STMT.GOTO_LABEL)
return;
case kASS_GOTO_STMT: (* yyNew)->ASS_GOTO_STMT = yyt->ASS_GOTO_STMT;
copytTree ((* yyNew)->ASS_GOTO_STMT.GOTO_VAR, yyt->ASS_GOTO_STMT.GOTO_VAR)
yyt = yyt->ASS_GOTO_STMT.LABELS;
yyNew = & (* yyNew)->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT: (* yyNew)->COMP_GOTO_STMT = yyt->COMP_GOTO_STMT;
copytTree ((* yyNew)->COMP_GOTO_STMT.GOTO_LABELS, yyt->COMP_GOTO_STMT.GOTO_LABELS)
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP;
yyNew = & (* yyNew)->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT: (* yyNew)->COMP_IF_STMT = yyt->COMP_IF_STMT;
copyint ((* yyNew)->COMP_IF_STMT.IF_LT_LABEL, yyt->COMP_IF_STMT.IF_LT_LABEL)
copyint ((* yyNew)->COMP_IF_STMT.IF_EQ_LABEL, yyt->COMP_IF_STMT.IF_EQ_LABEL)
copyint ((* yyNew)->COMP_IF_STMT.IF_GT_LABEL, yyt->COMP_IF_STMT.IF_GT_LABEL)
yyt = yyt->COMP_IF_STMT.IF_EXP;
yyNew = & (* yyNew)->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT: (* yyNew)->RETURN_STMT = yyt->RETURN_STMT;
yyt = yyt->RETURN_STMT.RETURN_EXP;
yyNew = & (* yyNew)->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT: (* yyNew)->PAUSE_STMT = yyt->PAUSE_STMT;
yyt = yyt->PAUSE_STMT.PAUSE_CONST;
yyNew = & (* yyNew)->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT: (* yyNew)->EXIT_STMT = yyt->EXIT_STMT;
copytIdent ((* yyNew)->EXIT_STMT.loopid, yyt->EXIT_STMT.loopid)
return;
case kCYCLE_STMT: (* yyNew)->CYCLE_STMT = yyt->CYCLE_STMT;
copytIdent ((* yyNew)->CYCLE_STMT.loopid, yyt->CYCLE_STMT.loopid)
return;
case kSTOP_STMT: (* yyNew)->STOP_STMT = yyt->STOP_STMT;
yyt = yyt->STOP_STMT.STOP_CONST;
yyNew = & (* yyNew)->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT: (* yyNew)->FORMAT_STMT = yyt->FORMAT_STMT;
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS;
yyNew = & (* yyNew)->FORMAT_STMT.FORMAT_PARAMS; break;
case kALLOCATE_STMT: (* yyNew)->ALLOCATE_STMT = yyt->ALLOCATE_STMT;
copytTree ((* yyNew)->ALLOCATE_STMT.PARAMS, yyt->ALLOCATE_STMT.PARAMS)
yyt = yyt->ALLOCATE_STMT.STAT;
yyNew = & (* yyNew)->ALLOCATE_STMT.STAT; break;
case kDEALLOCATE_STMT: (* yyNew)->DEALLOCATE_STMT = yyt->DEALLOCATE_STMT;
copytTree ((* yyNew)->DEALLOCATE_STMT.PARAMS, yyt->DEALLOCATE_STMT.PARAMS)
yyt = yyt->DEALLOCATE_STMT.STAT;
yyNew = & (* yyNew)->DEALLOCATE_STMT.STAT; break;
case kNULLIFY_STMT: (* yyNew)->NULLIFY_STMT = yyt->NULLIFY_STMT;
yyt = yyt->NULLIFY_STMT.PARAMS;
yyNew = & (* yyNew)->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT: (* yyNew)->REDUCE_STMT = yyt->REDUCE_STMT;
copytTree ((* yyNew)->REDUCE_STMT.RED_FUNC, yyt->REDUCE_STMT.RED_FUNC)
yyt = yyt->REDUCE_STMT.RED_PARAMS;
yyNew = & (* yyNew)->REDUCE_STMT.RED_PARAMS; break;
case kGLOBAL_STMT: (* yyNew)->GLOBAL_STMT = yyt->GLOBAL_STMT;
copytIdent ((* yyNew)->GLOBAL_STMT.func, yyt->GLOBAL_STMT.func)
copytTree ((* yyNew)->GLOBAL_STMT.ARRAY, yyt->GLOBAL_STMT.ARRAY)
copytTree ((* yyNew)->GLOBAL_STMT.INDEXED_ARRAY, yyt->GLOBAL_STMT.INDEXED_ARRAY)
copytTree ((* yyNew)->GLOBAL_STMT.INDEXES, yyt->GLOBAL_STMT.INDEXES)
yyt = yyt->GLOBAL_STMT.MASK;
yyNew = & (* yyNew)->GLOBAL_STMT.MASK; break;
case kALIGN_STMT: (* yyNew)->ALIGN_STMT = yyt->ALIGN_STMT;
copytTree ((* yyNew)->ALIGN_STMT.ALIGNEE, yyt->ALIGN_STMT.ALIGNEE)
yyt = yyt->ALIGN_STMT.ALIGN_SPEC;
yyNew = & (* yyNew)->ALIGN_STMT.ALIGN_SPEC; break;
case kDISTRIBUTE_STMT: (* yyNew)->DISTRIBUTE_STMT = yyt->DISTRIBUTE_STMT;
copytTree ((* yyNew)->DISTRIBUTE_STMT.DISTRIBUTEE, yyt->DISTRIBUTE_STMT.DISTRIBUTEE)
copytIdent ((* yyNew)->DISTRIBUTE_STMT.target, yyt->DISTRIBUTE_STMT.target)
yyt = yyt->DISTRIBUTE_STMT.DISTRIBUTION;
yyNew = & (* yyNew)->DISTRIBUTE_STMT.DISTRIBUTION; break;
case kLABEL_USE_LIST: (* yyNew)->LABEL_USE_LIST = yyt->LABEL_USE_LIST;
return;
case kLABEL_EMPTY: (* yyNew)->LABEL_EMPTY = yyt->LABEL_EMPTY;
return;
case kLABEL_LIST: (* yyNew)->LABEL_LIST = yyt->LABEL_LIST;
copyint ((* yyNew)->LABEL_LIST.Elem, yyt->LABEL_LIST.Elem)
yyt = yyt->LABEL_LIST.Next;
yyNew = & (* yyNew)->LABEL_LIST.Next; break;
case kOP: (* yyNew)->OP = yyt->OP;
return;
case kOP_EQ: (* yyNew)->OP_EQ = yyt->OP_EQ;
return;
case kOP_NE: (* yyNew)->OP_NE = yyt->OP_NE;
return;
case kOP_LT: (* yyNew)->OP_LT = yyt->OP_LT;
return;
case kOP_GT: (* yyNew)->OP_GT = yyt->OP_GT;
return;
case kOP_GE: (* yyNew)->OP_GE = yyt->OP_GE;
return;
case kOP_LE: (* yyNew)->OP_LE = yyt->OP_LE;
return;
case kOP_PLUS: (* yyNew)->OP_PLUS = yyt->OP_PLUS;
return;
case kOP_MINUS: (* yyNew)->OP_MINUS = yyt->OP_MINUS;
return;
case kOP_XOR: (* yyNew)->OP_XOR = yyt->OP_XOR;
return;
case kOP_OR: (* yyNew)->OP_OR = yyt->OP_OR;
return;
case kOP_CONCAT: (* yyNew)->OP_CONCAT = yyt->OP_CONCAT;
return;
case kOP_TIMES: (* yyNew)->OP_TIMES = yyt->OP_TIMES;
return;
case kOP_DIVIDE: (* yyNew)->OP_DIVIDE = yyt->OP_DIVIDE;
return;
case kOP_DIV: (* yyNew)->OP_DIV = yyt->OP_DIV;
return;
case kOP_AND: (* yyNew)->OP_AND = yyt->OP_AND;
return;
case kOP_EQV: (* yyNew)->OP_EQV = yyt->OP_EQV;
return;
case kOP_NEQV: (* yyNew)->OP_NEQV = yyt->OP_NEQV;
return;
case kOP_EXPO: (* yyNew)->OP_EXPO = yyt->OP_EXPO;
return;
case kOP_MOD: (* yyNew)->OP_MOD = yyt->OP_MOD;
return;
case kOP_IN: (* yyNew)->OP_IN = yyt->OP_IN;
return;
case kOP_DEFINED: (* yyNew)->OP_DEFINED = yyt->OP_DEFINED;
copytIdent ((* yyNew)->OP_DEFINED.opname, yyt->OP_DEFINED.opname)
return;
case kOP_ASSIGN: (* yyNew)->OP_ASSIGN = yyt->OP_ASSIGN;
return;
case kOP_LEFT: (* yyNew)->OP_LEFT = yyt->OP_LEFT;
return;
case kOP_RIGHT: (* yyNew)->OP_RIGHT = yyt->OP_RIGHT;
return;
case kOP_LIST: (* yyNew)->OP_LIST = yyt->OP_LIST;
return;
case kOP_IOR: (* yyNew)->OP_IOR = yyt->OP_IOR;
return;
case kOP_IXOR: (* yyNew)->OP_IXOR = yyt->OP_IXOR;
return;
case kOP_IAND: (* yyNew)->OP_IAND = yyt->OP_IAND;
return;
case kOP1_NOT: (* yyNew)->OP1_NOT = yyt->OP1_NOT;
return;
case kOP1_SIGN: (* yyNew)->OP1_SIGN = yyt->OP1_SIGN;
return;
case kOP1_INOT: (* yyNew)->OP1_INOT = yyt->OP1_INOT;
return;
case kOP1_SIZE: (* yyNew)->OP1_SIZE = yyt->OP1_SIZE;
return;
case kOP1_DEC: (* yyNew)->OP1_DEC = yyt->OP1_DEC;
return;
case kOP1_INC: (* yyNew)->OP1_INC = yyt->OP1_INC;
return;
case kOP1_ADDRESS: (* yyNew)->OP1_ADDRESS = yyt->OP1_ADDRESS;
return;
case kOP1_DEREF: (* yyNew)->OP1_DEREF = yyt->OP1_DEREF;
return;
case kBT_EXP: (* yyNew)->BT_EXP = yyt->BT_EXP;
return;
case kDUMMY_EXP: (* yyNew)->DUMMY_EXP = yyt->DUMMY_EXP;
return;
case kCONST_EXP: (* yyNew)->CONST_EXP = yyt->CONST_EXP;
yyt = yyt->CONST_EXP.C;
yyNew = & (* yyNew)->CONST_EXP.C; break;
case kOP_EXP: (* yyNew)->OP_EXP = yyt->OP_EXP;
copytTree ((* yyNew)->OP_EXP.EXP_OP, yyt->OP_EXP.EXP_OP)
copytTree ((* yyNew)->OP_EXP.OPND1, yyt->OP_EXP.OPND1)
yyt = yyt->OP_EXP.OPND2;
yyNew = & (* yyNew)->OP_EXP.OPND2; break;
case kOP1_EXP: (* yyNew)->OP1_EXP = yyt->OP1_EXP;
copytTree ((* yyNew)->OP1_EXP.EXP_OP1, yyt->OP1_EXP.EXP_OP1)
yyt = yyt->OP1_EXP.OPND;
yyNew = & (* yyNew)->OP1_EXP.OPND; break;
case kSLICE_EXP: (* yyNew)->SLICE_EXP = yyt->SLICE_EXP;
copytTree ((* yyNew)->SLICE_EXP.START, yyt->SLICE_EXP.START)
copytTree ((* yyNew)->SLICE_EXP.STOP, yyt->SLICE_EXP.STOP)
yyt = yyt->SLICE_EXP.INC;
yyNew = & (* yyNew)->SLICE_EXP.INC; break;
case kPOSTFIX_EXP: (* yyNew)->POSTFIX_EXP = yyt->POSTFIX_EXP;
copytTree ((* yyNew)->POSTFIX_EXP.POSTFIX_OP, yyt->POSTFIX_EXP.POSTFIX_OP)
yyt = yyt->POSTFIX_EXP.OPND;
yyNew = & (* yyNew)->POSTFIX_EXP.OPND; break;
case kCALL_EXP: (* yyNew)->CALL_EXP = yyt->CALL_EXP;
copytTree ((* yyNew)->CALL_EXP.FUNC_ID, yyt->CALL_EXP.FUNC_ID)
yyt = yyt->CALL_EXP.FUNC_PARAMS;
yyNew = & (* yyNew)->CALL_EXP.FUNC_PARAMS; break;
case kCAST_EXP: (* yyNew)->CAST_EXP = yyt->CAST_EXP;
copytTree ((* yyNew)->CAST_EXP.ID, yyt->CAST_EXP.ID)
yyt = yyt->CAST_EXP.CAST;
yyNew = & (* yyNew)->CAST_EXP.CAST; break;
case kINDEXED_EXP: (* yyNew)->INDEXED_EXP = yyt->INDEXED_EXP;
copytTree ((* yyNew)->INDEXED_EXP.IND_EXP, yyt->INDEXED_EXP.IND_EXP)
yyt = yyt->INDEXED_EXP.INDEX;
yyNew = & (* yyNew)->INDEXED_EXP.INDEX; break;
case kSELECTED_EXP: (* yyNew)->SELECTED_EXP = yyt->SELECTED_EXP;
copytTree ((* yyNew)->SELECTED_EXP.SELEC_EXP, yyt->SELECTED_EXP.SELEC_EXP)
yyt = yyt->SELECTED_EXP.SELECTOR;
yyNew = & (* yyNew)->SELECTED_EXP.SELECTOR; break;
case kASSIGN_EXP: (* yyNew)->ASSIGN_EXP = yyt->ASSIGN_EXP;
copytTree ((* yyNew)->ASSIGN_EXP.ASSIGN_OP, yyt->ASSIGN_EXP.ASSIGN_OP)
copytTree ((* yyNew)->ASSIGN_EXP.LHS, yyt->ASSIGN_EXP.LHS)
yyt = yyt->ASSIGN_EXP.RHS;
yyNew = & (* yyNew)->ASSIGN_EXP.RHS; break;
case kUSED_EXP: (* yyNew)->USED_EXP = yyt->USED_EXP;
yyt = yyt->USED_EXP.VARNAME;
yyNew = & (* yyNew)->USED_EXP.VARNAME; break;
case kCOND_EXP: (* yyNew)->COND_EXP = yyt->COND_EXP;
copytTree ((* yyNew)->COND_EXP.COND, yyt->COND_EXP.COND)
copytTree ((* yyNew)->COND_EXP.TRUE_EXP, yyt->COND_EXP.TRUE_EXP)
yyt = yyt->COND_EXP.FALSE_EXP;
yyNew = & (* yyNew)->COND_EXP.FALSE_EXP; break;
case kVAR_EXP: (* yyNew)->VAR_EXP = yyt->VAR_EXP;
yyt = yyt->VAR_EXP.V;
yyNew = & (* yyNew)->VAR_EXP.V; break;
case kFUNC_CALL_EXP: (* yyNew)->FUNC_CALL_EXP = yyt->FUNC_CALL_EXP;
copytTree ((* yyNew)->FUNC_CALL_EXP.FUNC_ID, yyt->FUNC_CALL_EXP.FUNC_ID)
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS;
yyNew = & (* yyNew)->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP: (* yyNew)->NAMED_EXP = yyt->NAMED_EXP;
copytIdent ((* yyNew)->NAMED_EXP.Name, yyt->NAMED_EXP.Name)
yyt = yyt->NAMED_EXP.VAL;
yyNew = & (* yyNew)->NAMED_EXP.VAL; break;
case kDO_EXP: (* yyNew)->DO_EXP = yyt->DO_EXP;
copytTree ((* yyNew)->DO_EXP.DO_ID, yyt->DO_EXP.DO_ID)
copytTree ((* yyNew)->DO_EXP.RANGE, yyt->DO_EXP.RANGE)
yyt = yyt->DO_EXP.BODY;
yyNew = & (* yyNew)->DO_EXP.BODY; break;
case kTYPE_EXP: (* yyNew)->TYPE_EXP = yyt->TYPE_EXP;
copytTree ((* yyNew)->TYPE_EXP.ID, yyt->TYPE_EXP.ID)
yyt = yyt->TYPE_EXP.ELEMENTS;
yyNew = & (* yyNew)->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP: (* yyNew)->ARRAY_EXP = yyt->ARRAY_EXP;
yyt = yyt->ARRAY_EXP.ELEMENTS;
yyNew = & (* yyNew)->ARRAY_EXP.ELEMENTS; break;
case kBT_EXP_LIST: (* yyNew)->BT_EXP_LIST = yyt->BT_EXP_LIST;
return;
case kBTE_EMPTY: (* yyNew)->BTE_EMPTY = yyt->BTE_EMPTY;
return;
case kBTE_LIST: (* yyNew)->BTE_LIST = yyt->BTE_LIST;
copytTree ((* yyNew)->BTE_LIST.Elem, yyt->BTE_LIST.Elem)
yyt = yyt->BTE_LIST.Next;
yyNew = & (* yyNew)->BTE_LIST.Next; break;
case kBT_VAR: (* yyNew)->BT_VAR = yyt->BT_VAR;
return;
case kDUMMY_VAR: (* yyNew)->DUMMY_VAR = yyt->DUMMY_VAR;
return;
case kUSED_VAR: (* yyNew)->USED_VAR = yyt->USED_VAR;
yyt = yyt->USED_VAR.VARNAME;
yyNew = & (* yyNew)->USED_VAR.VARNAME; break;
case kINDEXED_VAR: (* yyNew)->INDEXED_VAR = yyt->INDEXED_VAR;
copytTree ((* yyNew)->INDEXED_VAR.IND_VAR, yyt->INDEXED_VAR.IND_VAR)
yyt = yyt->INDEXED_VAR.IND_EXPS;
yyNew = & (* yyNew)->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR: (* yyNew)->SUBSTRING_VAR = yyt->SUBSTRING_VAR;
copytTree ((* yyNew)->SUBSTRING_VAR.IND_VAR, yyt->SUBSTRING_VAR.IND_VAR)
yyt = yyt->SUBSTRING_VAR.IND_EXP;
yyNew = & (* yyNew)->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR: (* yyNew)->SELECTED_VAR = yyt->SELECTED_VAR;
copytTree ((* yyNew)->SELECTED_VAR.SELEC_VAR, yyt->SELECTED_VAR.SELEC_VAR)
yyt = yyt->SELECTED_VAR.SELECTOR;
yyNew = & (* yyNew)->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR: (* yyNew)->LOOP_VAR = yyt->LOOP_VAR;
yyt = yyt->LOOP_VAR.LOOP_VARNAME;
yyNew = & (* yyNew)->LOOP_VAR.LOOP_VARNAME; break;
case kADDR: (* yyNew)->ADDR = yyt->ADDR;
yyt = yyt->ADDR.E;
yyNew = & (* yyNew)->ADDR.E; break;
case kDO_VAR: (* yyNew)->DO_VAR = yyt->DO_VAR;
copytTree ((* yyNew)->DO_VAR.DO_ID, yyt->DO_VAR.DO_ID)
copytTree ((* yyNew)->DO_VAR.RANGE, yyt->DO_VAR.RANGE)
yyt = yyt->DO_VAR.BODY;
yyNew = & (* yyNew)->DO_VAR.BODY; break;
case kBT_VAR_LIST: (* yyNew)->BT_VAR_LIST = yyt->BT_VAR_LIST;
return;
case kBTV_EMPTY: (* yyNew)->BTV_EMPTY = yyt->BTV_EMPTY;
return;
case kBTV_LIST: (* yyNew)->BTV_LIST = yyt->BTV_LIST;
copytTree ((* yyNew)->BTV_LIST.Elem, yyt->BTV_LIST.Elem)
yyt = yyt->BTV_LIST.Next;
yyNew = & (* yyNew)->BTV_LIST.Next; break;
case kBT_PARAM: (* yyNew)->BT_PARAM = yyt->BT_PARAM;
return;
case kVAR_PARAM: (* yyNew)->VAR_PARAM = yyt->VAR_PARAM;
yyt = yyt->VAR_PARAM.V;
yyNew = & (* yyNew)->VAR_PARAM.V; break;
case kVALUE_PARAM: (* yyNew)->VALUE_PARAM = yyt->VALUE_PARAM;
yyt = yyt->VALUE_PARAM.E;
yyNew = & (* yyNew)->VALUE_PARAM.E; break;
case kNAMED_PARAM: (* yyNew)->NAMED_PARAM = yyt->NAMED_PARAM;
copytIdent ((* yyNew)->NAMED_PARAM.Name, yyt->NAMED_PARAM.Name)
yyt = yyt->NAMED_PARAM.VAL;
yyNew = & (* yyNew)->NAMED_PARAM.VAL; break;
case kPROC_PARAM: (* yyNew)->PROC_PARAM = yyt->PROC_PARAM;
yyt = yyt->PROC_PARAM.P;
yyNew = & (* yyNew)->PROC_PARAM.P; break;
case kFUNC_PARAM: (* yyNew)->FUNC_PARAM = yyt->FUNC_PARAM;
yyt = yyt->FUNC_PARAM.F;
yyNew = & (* yyNew)->FUNC_PARAM.F; break;
case kFORMAT_PARAM: (* yyNew)->FORMAT_PARAM = yyt->FORMAT_PARAM;
copytStringRef ((* yyNew)->FORMAT_PARAM.S, yyt->FORMAT_PARAM.S)
return;
case kRETURN_PARAM: (* yyNew)->RETURN_PARAM = yyt->RETURN_PARAM;
copyint ((* yyNew)->RETURN_PARAM.label, yyt->RETURN_PARAM.label)
return;
case kNO_PARAM: (* yyNew)->NO_PARAM = yyt->NO_PARAM;
return;
case kBT_PARAM_LIST: (* yyNew)->BT_PARAM_LIST = yyt->BT_PARAM_LIST;
return;
case kBTP_EMPTY: (* yyNew)->BTP_EMPTY = yyt->BTP_EMPTY;
return;
case kBTP_LIST: (* yyNew)->BTP_LIST = yyt->BTP_LIST;
copytTree ((* yyNew)->BTP_LIST.Elem, yyt->BTP_LIST.Elem)
yyt = yyt->BTP_LIST.Next;
yyNew = & (* yyNew)->BTP_LIST.Next; break;
case kCONSTANT: (* yyNew)->CONSTANT = yyt->CONSTANT;
return;
case kBOOL_CONSTANT: (* yyNew)->BOOL_CONSTANT = yyt->BOOL_CONSTANT;
copyint ((* yyNew)->BOOL_CONSTANT.value, yyt->BOOL_CONSTANT.value)
return;
case kINT_CONSTANT: (* yyNew)->INT_CONSTANT = yyt->INT_CONSTANT;
copyint ((* yyNew)->INT_CONSTANT.value, yyt->INT_CONSTANT.value)
return;
case kREAL_CONSTANT: (* yyNew)->REAL_CONSTANT = yyt->REAL_CONSTANT;
copytStringRef ((* yyNew)->REAL_CONSTANT.value, yyt->REAL_CONSTANT.value)
return;
case kDREAL_CONSTANT: (* yyNew)->DREAL_CONSTANT = yyt->DREAL_CONSTANT;
copytStringRef ((* yyNew)->DREAL_CONSTANT.value, yyt->DREAL_CONSTANT.value)
return;
case kCHAR_CONSTANT: (* yyNew)->CHAR_CONSTANT = yyt->CHAR_CONSTANT;
copychar ((* yyNew)->CHAR_CONSTANT.value, yyt->CHAR_CONSTANT.value)
return;
case kSTRING_CONSTANT: (* yyNew)->STRING_CONSTANT = yyt->STRING_CONSTANT;
copytStringRef ((* yyNew)->STRING_CONSTANT.value, yyt->STRING_CONSTANT.value)
return;
case kCOMPLEX_CONSTANT: (* yyNew)->COMPLEX_CONSTANT = yyt->COMPLEX_CONSTANT;
copytStringRef ((* yyNew)->COMPLEX_CONSTANT.rvalue, yyt->COMPLEX_CONSTANT.rvalue)
copytStringRef ((* yyNew)->COMPLEX_CONSTANT.ivalue, yyt->COMPLEX_CONSTANT.ivalue)
return;
case kPROC_OBJ: (* yyNew)->PROC_OBJ = yyt->PROC_OBJ;
copytIdent ((* yyNew)->PROC_OBJ.Ident, yyt->PROC_OBJ.Ident)
copytDefinitions ((* yyNew)->PROC_OBJ.Object, yyt->PROC_OBJ.Object)
return;
case kVAR_OBJ: (* yyNew)->VAR_OBJ = yyt->VAR_OBJ;
copyint ((* yyNew)->VAR_OBJ.Pos, yyt->VAR_OBJ.Pos)
copytIdent ((* yyNew)->VAR_OBJ.Ident, yyt->VAR_OBJ.Ident)
copytDefinitions ((* yyNew)->VAR_OBJ.Object, yyt->VAR_OBJ.Object)
return;
case kTYPE_OBJ: (* yyNew)->TYPE_OBJ = yyt->TYPE_OBJ;
copytIdent ((* yyNew)->TYPE_OBJ.Ident, yyt->TYPE_OBJ.Ident)
copytDefinitions ((* yyNew)->TYPE_OBJ.Object, yyt->TYPE_OBJ.Object)
return;
case kREC_COMP: (* yyNew)->REC_COMP = yyt->REC_COMP;
copytIdent ((* yyNew)->REC_COMP.Ident, yyt->REC_COMP.Ident)
copytDefinitions ((* yyNew)->REC_COMP.Object, yyt->REC_COMP.Object)
return;
  default: ;
  }
 }
}

tTree CopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 tTree yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyTree (yyt, & yyNew);
 return yyNew;
}

static bool yyCheckTree ARGS((tTree yyt));

bool CheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyMark (yyt);
 return yyCheckTree (yyt);
}

static bool yyCheckChild
# if defined __STDC__ | defined __cplusplus
 (tTree yyParent, tTree yyyChild, Tree_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tTree yyParent, yyyChild;
 Tree_tKind yyType;
 char * yySelector;
# endif
{
 bool yySuccess = Tree_IsType (yyyChild, yyType);
 if (! yySuccess) {
  (void) fputs ("CheckTree: parent = ", stderr);
  WriteTreeNode (stderr, yyParent);
  (void) fprintf (stderr, "\nselector: %s child = ", yySelector);
  WriteTreeNode (stderr, yyyChild);
  (void) fputc ('\n', stderr);
 }
 return yyCheckTree (yyyChild) && yySuccess;
}

static bool yyCheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 bool yyResult;
 if (yyt == NoTree) return false;
 else if (yyt->yyHead.yyMark == 0) return true;
 yyt->yyHead.yyMark = 0;

 yyResult = true;
 switch (yyt->Kind) {
case kCOMP_UNIT:
yyResult = yyCheckChild (yyt, yyt->COMP_UNIT.COMP_ELEMENTS, kDECL_NODE_LIST, "COMP_ELEMENTS") && yyResult;
break;
case kBODY_NODE:
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.DECLS, kDECL_NODE_LIST, "DECLS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.STATS, kACF_NODE_LIST, "STATS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.INTERNALS, kDECL_NODE_LIST, "INTERNALS") && yyResult;
break;
case kSTRING_TYPE:
yyResult = yyCheckChild (yyt, yyt->STRING_TYPE.LENGTH, kBT_EXP, "LENGTH") && yyResult;
break;
case kINDEX_TYPE:
yyResult = yyCheckChild (yyt, yyt->INDEX_TYPE.LOWER, kBT_EXP, "LOWER") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INDEX_TYPE.UPPER, kBT_EXP, "UPPER") && yyResult;
break;
case kTYPE_ID:
yyResult = yyCheckChild (yyt, yyt->TYPE_ID.ID, kTYPE_OBJ, "ID") && yyResult;
break;
case kARRAY_TYPE:
yyResult = yyCheckChild (yyt, yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES, kTYPE_NODE_LIST, "ARRAY_INDEX_TYPES") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ARRAY_TYPE.ARRAY_COMP_TYPE, kTYPE_NODE, "ARRAY_COMP_TYPE") && yyResult;
break;
case kRECORD_TYPE:
yyResult = yyCheckChild (yyt, yyt->RECORD_TYPE.COMPONENTS, kDECL_NODE_LIST, "COMPONENTS") && yyResult;
break;
case kUNION_TYPE:
yyResult = yyCheckChild (yyt, yyt->UNION_TYPE.COMPONENTS, kDECL_NODE_LIST, "COMPONENTS") && yyResult;
break;
case kENUM_TYPE:
yyResult = yyCheckChild (yyt, yyt->ENUM_TYPE.COMPONENTS, kDECL_NODE_LIST, "COMPONENTS") && yyResult;
break;
case kPOINTER_TYPE:
yyResult = yyCheckChild (yyt, yyt->POINTER_TYPE.PTR_COMP, kTYPE_NODE, "PTR_COMP") && yyResult;
break;
case kARRAY1_TYPE:
yyResult = yyCheckChild (yyt, yyt->ARRAY1_TYPE.SIZE, kBT_EXP, "SIZE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE, kTYPE_NODE, "ARRAY1_COMP_TYPE") && yyResult;
break;
case kFUNCTION_TYPE:
yyResult = yyCheckChild (yyt, yyt->FUNCTION_TYPE.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNCTION_TYPE.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
break;
case kTYPE_LIST:
yyResult = yyCheckChild (yyt, yyt->TYPE_LIST.Elem, kTYPE_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->TYPE_LIST.Next, kTYPE_NODE_LIST, "Next") && yyResult;
break;
case kMODULE_DECL:
yyResult = yyCheckChild (yyt, yyt->MODULE_DECL.MODULE_BODY, kBODY_NODE, "MODULE_BODY") && yyResult;
break;
case kPROGRAM_DECL:
yyResult = yyCheckChild (yyt, yyt->PROGRAM_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROGRAM_DECL.PROGRAM_BODY, kBODY_NODE, "PROGRAM_BODY") && yyResult;
break;
case kPROC_DECL:
yyResult = yyCheckChild (yyt, yyt->PROC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROC_DECL.PROC_BODY, kBODY_NODE, "PROC_BODY") && yyResult;
break;
case kFUNC_DECL:
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.FUNC_BODY, kBODY_NODE, "FUNC_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
break;
case kBLOCK_DATA_DECL:
yyResult = yyCheckChild (yyt, yyt->BLOCK_DATA_DECL.DATA_BODY, kBODY_NODE, "DATA_BODY") && yyResult;
break;
case kTYPE_DECL:
yyResult = yyCheckChild (yyt, yyt->TYPE_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kENTITY_DECL:
yyResult = yyCheckChild (yyt, yyt->ENTITY_DECL.ATTRIBUTES, kDECL_LIST, "ATTRIBUTES") && yyResult;
break;
case kVAR_DECL:
yyResult = yyCheckChild (yyt, yyt->VAR_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kCOMMON_DECL:
yyResult = yyCheckChild (yyt, yyt->COMMON_DECL.IDS, kDECL_NODE_LIST, "IDS") && yyResult;
break;
case kNAMELIST_DECL:
yyResult = yyCheckChild (yyt, yyt->NAMELIST_DECL.IDS, kDECL_NODE_LIST, "IDS") && yyResult;
break;
case kTEMPLATE_DECL:
yyResult = yyCheckChild (yyt, yyt->TEMPLATE_DECL.DIMENSIONS, kTYPE_NODE_LIST, "DIMENSIONS") && yyResult;
break;
case kPROCESSORS_DECL:
yyResult = yyCheckChild (yyt, yyt->PROCESSORS_DECL.DIMENSIONS, kTYPE_NODE_LIST, "DIMENSIONS") && yyResult;
break;
case kSTMT_FUNC_DECL:
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.FFUNC_BODY, kBT_EXP, "FFUNC_BODY") && yyResult;
break;
case kINTERFACE_DECL:
yyResult = yyCheckChild (yyt, yyt->INTERFACE_DECL.SPEC, kGENERIC_SPEC, "SPEC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INTERFACE_DECL.ITEMS, kDECL_NODE_LIST, "ITEMS") && yyResult;
break;
case kEXT_PROC_DECL:
yyResult = yyCheckChild (yyt, yyt->EXT_PROC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
break;
case kEXT_FUNC_DECL:
yyResult = yyCheckChild (yyt, yyt->EXT_FUNC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->EXT_FUNC_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
break;
case kVAL_PARAM_DECL:
yyResult = yyCheckChild (yyt, yyt->VAL_PARAM_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kVAR_PARAM_DECL:
yyResult = yyCheckChild (yyt, yyt->VAR_PARAM_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kPROC_PARAM_DECL:
yyResult = yyCheckChild (yyt, yyt->PROC_PARAM_DECL.FORMAL, kDECL_NODE_LIST, "FORMAL") && yyResult;
break;
case kFUNC_PARAM_DECL:
yyResult = yyCheckChild (yyt, yyt->FUNC_PARAM_DECL.FORMAL, kDECL_NODE_LIST, "FORMAL") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_PARAM_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
break;
case kIMPLICIT_DECL:
yyResult = yyCheckChild (yyt, yyt->IMPLICIT_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kUSE_DECL:
yyResult = yyCheckChild (yyt, yyt->USE_DECL.RENAMINGS, kDECL_NODE_LIST, "RENAMINGS") && yyResult;
break;
case kONLY_USE_DECL:
yyResult = yyCheckChild (yyt, yyt->ONLY_USE_DECL.NAMES, kDECL_NODE_LIST, "NAMES") && yyResult;
break;
case kEQV_DECL:
yyResult = yyCheckChild (yyt, yyt->EQV_DECL.VARS, kBT_VAR_LIST, "VARS") && yyResult;
break;
case kDATA_DECL:
yyResult = yyCheckChild (yyt, yyt->DATA_DECL.VARS, kBT_VAR_LIST, "VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DATA_DECL.VALS, kBT_EXP_LIST, "VALS") && yyResult;
break;
case kDIMENSION_DECL:
yyResult = yyCheckChild (yyt, yyt->DIMENSION_DECL.INDEXES, kTYPE_NODE_LIST, "INDEXES") && yyResult;
break;
case kINIT_DATA_DECL:
yyResult = yyCheckChild (yyt, yyt->INIT_DATA_DECL.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kTYPESPEC_DECL:
yyResult = yyCheckChild (yyt, yyt->TYPESPEC_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kPARAMETER_DECL:
yyResult = yyCheckChild (yyt, yyt->PARAMETER_DECL.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kDISTRIBUTE_DECL:
yyResult = yyCheckChild (yyt, yyt->DISTRIBUTE_DECL.DISTRIBUTION, kDISTRIBUTION_SPEC, "DISTRIBUTION") && yyResult;
break;
case kALIGN_DECL:
yyResult = yyCheckChild (yyt, yyt->ALIGN_DECL.ALIGN_SOURCE, kBT_EXP_LIST, "ALIGN_SOURCE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALIGN_DECL.ALIGN_SPEC, kBT_VAR, "ALIGN_SPEC") && yyResult;
break;
case kDECL_LIST:
yyResult = yyCheckChild (yyt, yyt->DECL_LIST.Elem, kDECL_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DECL_LIST.Next, kDECL_NODE_LIST, "Next") && yyResult;
break;
case kNODE_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->NODE_DISTRIBUTION.MAPPING, kDIST_FORMAT_LIST, "MAPPING") && yyResult;
break;
case kBLOCK_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->BLOCK_DISTRIBUTION.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kCYCLIC_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->CYCLIC_DISTRIBUTION.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kDIST_LIST:
yyResult = yyCheckChild (yyt, yyt->DIST_LIST.Elem, kDISTRIBUTION_FORMAT, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DIST_LIST.Next, kDIST_FORMAT_LIST, "Next") && yyResult;
break;
case kOP_GENERIC_SPEC:
yyResult = yyCheckChild (yyt, yyt->OP_GENERIC_SPEC.OPERATOR, kOP, "OPERATOR") && yyResult;
break;
case kACF_LIST:
yyResult = yyCheckChild (yyt, yyt->ACF_LIST.Elem, kACF_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_LIST.Next, kACF_NODE_LIST, "Next") && yyResult;
break;
case kACF_BASIC:
yyResult = yyCheckChild (yyt, yyt->ACF_BASIC.BASIC_STMT, kBT_STMT, "BASIC_STMT") && yyResult;
break;
case kACF_IF:
yyResult = yyCheckChild (yyt, yyt->ACF_IF.IF_EXP, kBT_EXP, "IF_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_IF.THEN_PART, kACF_NODE_LIST, "THEN_PART") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_IF.ELSE_PART, kACF_NODE_LIST, "ELSE_PART") && yyResult;
break;
case kACF_WHERE:
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.WHERE_EXP, kBT_EXP, "WHERE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.TRUE_PART, kACF_NODE_LIST, "TRUE_PART") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.FALSE_PART, kACF_NODE_LIST, "FALSE_PART") && yyResult;
break;
case kACF_SWITCH:
yyResult = yyCheckChild (yyt, yyt->ACF_SWITCH.SWITCH_EXP, kBT_EXP, "SWITCH_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_SWITCH.SWITCH_STMT, kACF_NODE, "SWITCH_STMT") && yyResult;
break;
case kACF_ALTER:
yyResult = yyCheckChild (yyt, yyt->ACF_ALTER.ALTER_EXP, kBT_EXP, "ALTER_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_ALTER.ALTER_STMT, kACF_NODE, "ALTER_STMT") && yyResult;
break;
case kACF_CASE:
yyResult = yyCheckChild (yyt, yyt->ACF_CASE.CASE_EXP, kBT_EXP, "CASE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_CASE.CASE_ALTS, kSELECTED_ACF_NODE_LIST, "CASE_ALTS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_CASE.CASE_OTHERWISE, kACF_NODE_LIST, "CASE_OTHERWISE") && yyResult;
break;
case kACF_WHILE:
yyResult = yyCheckChild (yyt, yyt->ACF_WHILE.WHILE_EXP, kBT_EXP, "WHILE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHILE.WHILE_BODY, kACF_NODE_LIST, "WHILE_BODY") && yyResult;
break;
case kACF_REPEAT:
yyResult = yyCheckChild (yyt, yyt->ACF_REPEAT.REPEAT_BODY, kACF_NODE_LIST, "REPEAT_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_REPEAT.REPEAT_EXP, kBT_EXP, "REPEAT_EXP") && yyResult;
break;
case kACF_WITH:
yyResult = yyCheckChild (yyt, yyt->ACF_WITH.WITH_VARS, kBT_VAR_LIST, "WITH_VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WITH.WITH_BODY, kACF_NODE_LIST, "WITH_BODY") && yyResult;
break;
case kACF_LOOP:
yyResult = yyCheckChild (yyt, yyt->ACF_LOOP.LOOP_BODY, kACF_NODE_LIST, "LOOP_BODY") && yyResult;
break;
case kACF_DO:
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_RANGE, kSLICE_EXP, "DO_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_BODY, kACF_NODE_LIST, "DO_BODY") && yyResult;
break;
case kACF_DOLOCAL:
yyResult = yyCheckChild (yyt, yyt->ACF_DOLOCAL.DOLOCAL_ID, kBT_VAR, "DOLOCAL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOLOCAL.DOLOCAL_RANGE, kSLICE_EXP, "DOLOCAL_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOLOCAL.DOLOCAL_BODY, kACF_NODE_LIST, "DOLOCAL_BODY") && yyResult;
break;
case kACF_DOVEC:
yyResult = yyCheckChild (yyt, yyt->ACF_DOVEC.DOVEC_ID, kBT_VAR, "DOVEC_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOVEC.DOVEC_RANGE, kSLICE_EXP, "DOVEC_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOVEC.DOVEC_BODY, kACF_NODE_LIST, "DOVEC_BODY") && yyResult;
break;
case kACF_DOALL:
yyResult = yyCheckChild (yyt, yyt->ACF_DOALL.DOALL_NEW, kBT_VAR_LIST, "DOALL_NEW") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOALL.DOALL_ID, kBT_VAR, "DOALL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOALL.DOALL_RANGE, kSLICE_EXP, "DOALL_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DOALL.DOALL_BODY, kACF_NODE_LIST, "DOALL_BODY") && yyResult;
break;
case kACF_FORALL:
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_ID, kBT_VAR, "FORALL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_RANGE, kSLICE_EXP, "FORALL_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_BODY, kACF_NODE_LIST, "FORALL_BODY") && yyResult;
break;
case kACF_ON:
yyResult = yyCheckChild (yyt, yyt->ACF_ON.ON_VAR, kBT_VAR, "ON_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_ON.ON_STMT, kACF_NODE, "ON_STMT") && yyResult;
break;
case kACF_BODY:
yyResult = yyCheckChild (yyt, yyt->ACF_BODY.NEW_BODY, kBODY_NODE, "NEW_BODY") && yyResult;
break;
case kACF_FLOW_GRAPH:
yyResult = yyCheckChild (yyt, yyt->ACF_FLOW_GRAPH.FLOW_NODES, kACF_NODE_LIST, "FLOW_NODES") && yyResult;
break;
case kACF_ENTRY:
yyResult = yyCheckChild (yyt, yyt->ACF_ENTRY.ENTRY_DECL, kDECL_NODE, "ENTRY_DECL") && yyResult;
break;
case kSELECTED_ACF_LIST:
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_LIST.Elem, kSELECTED_ACF_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_LIST.Next, kSELECTED_ACF_NODE_LIST, "Next") && yyResult;
break;
case kSELECTED_ACF_NODE:
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_NODE.SELECT_LIST, kBT_EXP_LIST, "SELECT_LIST") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_NODE.SELECT_ACFS, kACF_NODE_LIST, "SELECT_ACFS") && yyResult;
break;
case kEXP_STMT:
yyResult = yyCheckChild (yyt, yyt->EXP_STMT.STMT_EXP, kBT_EXP, "STMT_EXP") && yyResult;
break;
case kASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->ASSIGN_STMT.ASSIGN_VAR, kBT_VAR, "ASSIGN_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSIGN_STMT.ASSIGN_EXP, kBT_EXP, "ASSIGN_EXP") && yyResult;
break;
case kPTR_ASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->PTR_ASSIGN_STMT.ASSIGN_VAR, kBT_VAR, "ASSIGN_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PTR_ASSIGN_STMT.ASSIGN_EXP, kBT_EXP, "ASSIGN_EXP") && yyResult;
break;
case kLABEL_ASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->LABEL_ASSIGN_STMT.LABEL_VAR, kBT_VAR, "LABEL_VAR") && yyResult;
break;
case kCALL_STMT:
yyResult = yyCheckChild (yyt, yyt->CALL_STMT.CALL_ID, kPROC_OBJ, "CALL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CALL_STMT.CALL_PARAMS, kBT_PARAM_LIST, "CALL_PARAMS") && yyResult;
break;
case kIO_STMT:
yyResult = yyCheckChild (yyt, yyt->IO_STMT.ID, kPROC_OBJ, "ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IO_STMT.IO_SPECS, kBT_PARAM_LIST, "IO_SPECS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IO_STMT.IO_ITEMS, kBT_PARAM_LIST, "IO_ITEMS") && yyResult;
break;
case kASS_GOTO_STMT:
yyResult = yyCheckChild (yyt, yyt->ASS_GOTO_STMT.GOTO_VAR, kBT_VAR, "GOTO_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASS_GOTO_STMT.LABELS, kLABEL_USE_LIST, "LABELS") && yyResult;
break;
case kCOMP_GOTO_STMT:
yyResult = yyCheckChild (yyt, yyt->COMP_GOTO_STMT.GOTO_LABELS, kLABEL_USE_LIST, "GOTO_LABELS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->COMP_GOTO_STMT.GOTO_EXP, kBT_EXP, "GOTO_EXP") && yyResult;
break;
case kCOMP_IF_STMT:
yyResult = yyCheckChild (yyt, yyt->COMP_IF_STMT.IF_EXP, kBT_EXP, "IF_EXP") && yyResult;
break;
case kRETURN_STMT:
yyResult = yyCheckChild (yyt, yyt->RETURN_STMT.RETURN_EXP, kBT_EXP, "RETURN_EXP") && yyResult;
break;
case kPAUSE_STMT:
yyResult = yyCheckChild (yyt, yyt->PAUSE_STMT.PAUSE_CONST, kCONSTANT, "PAUSE_CONST") && yyResult;
break;
case kSTOP_STMT:
yyResult = yyCheckChild (yyt, yyt->STOP_STMT.STOP_CONST, kBT_EXP, "STOP_CONST") && yyResult;
break;
case kFORMAT_STMT:
yyResult = yyCheckChild (yyt, yyt->FORMAT_STMT.FORMAT_PARAMS, kBT_PARAM_LIST, "FORMAT_PARAMS") && yyResult;
break;
case kALLOCATE_STMT:
yyResult = yyCheckChild (yyt, yyt->ALLOCATE_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALLOCATE_STMT.STAT, kBT_VAR, "STAT") && yyResult;
break;
case kDEALLOCATE_STMT:
yyResult = yyCheckChild (yyt, yyt->DEALLOCATE_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DEALLOCATE_STMT.STAT, kBT_VAR, "STAT") && yyResult;
break;
case kNULLIFY_STMT:
yyResult = yyCheckChild (yyt, yyt->NULLIFY_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
break;
case kREDUCE_STMT:
yyResult = yyCheckChild (yyt, yyt->REDUCE_STMT.RED_FUNC, kPROC_OBJ, "RED_FUNC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDUCE_STMT.RED_PARAMS, kBT_PARAM_LIST, "RED_PARAMS") && yyResult;
break;
case kGLOBAL_STMT:
yyResult = yyCheckChild (yyt, yyt->GLOBAL_STMT.ARRAY, kBT_PARAM, "ARRAY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->GLOBAL_STMT.INDEXED_ARRAY, kBT_PARAM, "INDEXED_ARRAY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->GLOBAL_STMT.INDEXES, kBT_PARAM_LIST, "INDEXES") && yyResult;
yyResult = yyCheckChild (yyt, yyt->GLOBAL_STMT.MASK, kBT_PARAM, "MASK") && yyResult;
break;
case kALIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->ALIGN_STMT.ALIGNEE, kBT_VAR, "ALIGNEE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALIGN_STMT.ALIGN_SPEC, kBT_VAR, "ALIGN_SPEC") && yyResult;
break;
case kDISTRIBUTE_STMT:
yyResult = yyCheckChild (yyt, yyt->DISTRIBUTE_STMT.DISTRIBUTEE, kBT_VAR, "DISTRIBUTEE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DISTRIBUTE_STMT.DISTRIBUTION, kDISTRIBUTION_SPEC, "DISTRIBUTION") && yyResult;
break;
case kLABEL_LIST:
yyResult = yyCheckChild (yyt, yyt->LABEL_LIST.Next, kLABEL_USE_LIST, "Next") && yyResult;
break;
case kCONST_EXP:
yyResult = yyCheckChild (yyt, yyt->CONST_EXP.C, kCONSTANT, "C") && yyResult;
break;
case kOP_EXP:
yyResult = yyCheckChild (yyt, yyt->OP_EXP.EXP_OP, kOP, "EXP_OP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP_EXP.OPND1, kBT_EXP, "OPND1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP_EXP.OPND2, kBT_EXP, "OPND2") && yyResult;
break;
case kOP1_EXP:
yyResult = yyCheckChild (yyt, yyt->OP1_EXP.EXP_OP1, kOP, "EXP_OP1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP1_EXP.OPND, kBT_EXP, "OPND") && yyResult;
break;
case kSLICE_EXP:
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.START, kBT_EXP, "START") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.STOP, kBT_EXP, "STOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.INC, kBT_EXP, "INC") && yyResult;
break;
case kPOSTFIX_EXP:
yyResult = yyCheckChild (yyt, yyt->POSTFIX_EXP.POSTFIX_OP, kOP, "POSTFIX_OP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->POSTFIX_EXP.OPND, kBT_EXP, "OPND") && yyResult;
break;
case kCALL_EXP:
yyResult = yyCheckChild (yyt, yyt->CALL_EXP.FUNC_ID, kBT_EXP, "FUNC_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CALL_EXP.FUNC_PARAMS, kBT_PARAM_LIST, "FUNC_PARAMS") && yyResult;
break;
case kCAST_EXP:
yyResult = yyCheckChild (yyt, yyt->CAST_EXP.ID, kTYPE_NODE, "ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CAST_EXP.CAST, kBT_EXP, "CAST") && yyResult;
break;
case kINDEXED_EXP:
yyResult = yyCheckChild (yyt, yyt->INDEXED_EXP.IND_EXP, kBT_EXP, "IND_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INDEXED_EXP.INDEX, kBT_EXP, "INDEX") && yyResult;
break;
case kSELECTED_EXP:
yyResult = yyCheckChild (yyt, yyt->SELECTED_EXP.SELEC_EXP, kBT_EXP, "SELEC_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_EXP.SELECTOR, kREC_COMP, "SELECTOR") && yyResult;
break;
case kASSIGN_EXP:
yyResult = yyCheckChild (yyt, yyt->ASSIGN_EXP.ASSIGN_OP, kOP, "ASSIGN_OP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSIGN_EXP.LHS, kBT_EXP, "LHS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSIGN_EXP.RHS, kBT_EXP, "RHS") && yyResult;
break;
case kUSED_EXP:
yyResult = yyCheckChild (yyt, yyt->USED_EXP.VARNAME, kVAR_OBJ, "VARNAME") && yyResult;
break;
case kCOND_EXP:
yyResult = yyCheckChild (yyt, yyt->COND_EXP.COND, kBT_EXP, "COND") && yyResult;
yyResult = yyCheckChild (yyt, yyt->COND_EXP.TRUE_EXP, kBT_EXP, "TRUE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->COND_EXP.FALSE_EXP, kBT_EXP, "FALSE_EXP") && yyResult;
break;
case kVAR_EXP:
yyResult = yyCheckChild (yyt, yyt->VAR_EXP.V, kBT_VAR, "V") && yyResult;
break;
case kFUNC_CALL_EXP:
yyResult = yyCheckChild (yyt, yyt->FUNC_CALL_EXP.FUNC_ID, kPROC_OBJ, "FUNC_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_CALL_EXP.FUNC_PARAMS, kBT_PARAM_LIST, "FUNC_PARAMS") && yyResult;
break;
case kNAMED_EXP:
yyResult = yyCheckChild (yyt, yyt->NAMED_EXP.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kDO_EXP:
yyResult = yyCheckChild (yyt, yyt->DO_EXP.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_EXP.RANGE, kSLICE_EXP, "RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_EXP.BODY, kBT_EXP_LIST, "BODY") && yyResult;
break;
case kTYPE_EXP:
yyResult = yyCheckChild (yyt, yyt->TYPE_EXP.ID, kTYPE_OBJ, "ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->TYPE_EXP.ELEMENTS, kBT_EXP_LIST, "ELEMENTS") && yyResult;
break;
case kARRAY_EXP:
yyResult = yyCheckChild (yyt, yyt->ARRAY_EXP.ELEMENTS, kBT_EXP_LIST, "ELEMENTS") && yyResult;
break;
case kBTE_LIST:
yyResult = yyCheckChild (yyt, yyt->BTE_LIST.Elem, kBT_EXP, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTE_LIST.Next, kBT_EXP_LIST, "Next") && yyResult;
break;
case kUSED_VAR:
yyResult = yyCheckChild (yyt, yyt->USED_VAR.VARNAME, kVAR_OBJ, "VARNAME") && yyResult;
break;
case kINDEXED_VAR:
yyResult = yyCheckChild (yyt, yyt->INDEXED_VAR.IND_VAR, kBT_VAR, "IND_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INDEXED_VAR.IND_EXPS, kBT_EXP_LIST, "IND_EXPS") && yyResult;
break;
case kSUBSTRING_VAR:
yyResult = yyCheckChild (yyt, yyt->SUBSTRING_VAR.IND_VAR, kBT_VAR, "IND_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SUBSTRING_VAR.IND_EXP, kBT_EXP, "IND_EXP") && yyResult;
break;
case kSELECTED_VAR:
yyResult = yyCheckChild (yyt, yyt->SELECTED_VAR.SELEC_VAR, kBT_VAR, "SELEC_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_VAR.SELECTOR, kREC_COMP, "SELECTOR") && yyResult;
break;
case kLOOP_VAR:
yyResult = yyCheckChild (yyt, yyt->LOOP_VAR.LOOP_VARNAME, kVAR_OBJ, "LOOP_VARNAME") && yyResult;
break;
case kADDR:
yyResult = yyCheckChild (yyt, yyt->ADDR.E, kBT_EXP, "E") && yyResult;
break;
case kDO_VAR:
yyResult = yyCheckChild (yyt, yyt->DO_VAR.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_VAR.RANGE, kSLICE_EXP, "RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_VAR.BODY, kBT_VAR_LIST, "BODY") && yyResult;
break;
case kBTV_LIST:
yyResult = yyCheckChild (yyt, yyt->BTV_LIST.Elem, kBT_VAR, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTV_LIST.Next, kBT_VAR_LIST, "Next") && yyResult;
break;
case kVAR_PARAM:
yyResult = yyCheckChild (yyt, yyt->VAR_PARAM.V, kBT_VAR, "V") && yyResult;
break;
case kVALUE_PARAM:
yyResult = yyCheckChild (yyt, yyt->VALUE_PARAM.E, kBT_EXP, "E") && yyResult;
break;
case kNAMED_PARAM:
yyResult = yyCheckChild (yyt, yyt->NAMED_PARAM.VAL, kBT_PARAM, "VAL") && yyResult;
break;
case kPROC_PARAM:
yyResult = yyCheckChild (yyt, yyt->PROC_PARAM.P, kPROC_OBJ, "P") && yyResult;
break;
case kFUNC_PARAM:
yyResult = yyCheckChild (yyt, yyt->FUNC_PARAM.F, kPROC_OBJ, "F") && yyResult;
break;
case kBTP_LIST:
yyResult = yyCheckChild (yyt, yyt->BTP_LIST.Elem, kBT_PARAM, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTP_LIST.Next, kBT_PARAM_LIST, "Next") && yyResult;
break;
 default: ;
 }
 return yyResult;
}

void InitTree
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 register tTree yyr;
 for (;;) {
  yyt->yyHead.yyIsComp0 = 0;
  yyt->yyHead.yyIsDone0 = 0;
  switch (yyt->Kind) {
case kCOMP_UNIT:
yyr = yyt->COMP_UNIT.COMP_ELEMENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_UNIT.COMP_ELEMENTS; break;
case kBODY_NODE:
yyr = yyt->BODY_NODE.DECLS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BODY_NODE.STATS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BODY_NODE.INTERNALS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->BODY_NODE.INTERNALS; break;
case kSTRING_TYPE:
yyr = yyt->STRING_TYPE.LENGTH; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->STRING_TYPE.LENGTH; break;
case kINDEX_TYPE:
yyr = yyt->INDEX_TYPE.LOWER; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INDEX_TYPE.UPPER; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->INDEX_TYPE.UPPER; break;
case kTYPE_ID:
yyr = yyt->TYPE_ID.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
yyr = yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
yyr = yyt->RECORD_TYPE.COMPONENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kUNION_TYPE:
yyr = yyt->UNION_TYPE.COMPONENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->UNION_TYPE.COMPONENTS; break;
case kENUM_TYPE:
yyr = yyt->ENUM_TYPE.COMPONENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ENUM_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyr = yyt->POINTER_TYPE.PTR_COMP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kARRAY1_TYPE:
yyr = yyt->ARRAY1_TYPE.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARRAY1_TYPE.ARRAY1_COMP_TYPE; break;
case kFUNCTION_TYPE:
yyr = yyt->FUNCTION_TYPE.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNCTION_TYPE.RESULT_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNCTION_TYPE.RESULT_TYPE; break;
case kTYPE_LIST:
yyr = yyt->TYPE_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->TYPE_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_LIST.Next; break;
case kMODULE_DECL:
yyr = yyt->MODULE_DECL.MODULE_BODY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
yyr = yyt->PROGRAM_DECL.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROGRAM_DECL.PROGRAM_BODY; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
yyr = yyt->PROC_DECL.FORMALS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROC_DECL.PROC_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
yyr = yyt->FUNC_DECL.FORMALS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_DECL.FUNC_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL:
yyr = yyt->BLOCK_DATA_DECL.DATA_BODY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kTYPE_DECL:
yyr = yyt->TYPE_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_DECL.VAL; break;
case kENTITY_DECL:
yyr = yyt->ENTITY_DECL.ATTRIBUTES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
yyr = yyt->VAR_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
yyr = yyt->COMMON_DECL.IDS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
yyr = yyt->NAMELIST_DECL.IDS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
yyr = yyt->TEMPLATE_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
yyr = yyt->PROCESSORS_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSTMT_FUNC_DECL:
yyr = yyt->STMT_FUNC_DECL.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->STMT_FUNC_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->STMT_FUNC_DECL.FFUNC_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
yyr = yyt->INTERFACE_DECL.SPEC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INTERFACE_DECL.ITEMS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kEXT_PROC_DECL:
yyr = yyt->EXT_PROC_DECL.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->EXT_PROC_DECL.FORMALS; break;
case kEXT_FUNC_DECL:
yyr = yyt->EXT_FUNC_DECL.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->EXT_FUNC_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->EXT_FUNC_DECL.RESULT_TYPE; break;
case kVAL_PARAM_DECL:
yyr = yyt->VAL_PARAM_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAL_PARAM_DECL.VAL; break;
case kVAR_PARAM_DECL:
yyr = yyt->VAR_PARAM_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kPROC_PARAM_DECL:
yyr = yyt->PROC_PARAM_DECL.FORMAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROC_PARAM_DECL.FORMAL; break;
case kFUNC_PARAM_DECL:
yyr = yyt->FUNC_PARAM_DECL.FORMAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_PARAM_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_PARAM_DECL.RESULT_TYPE; break;
case kIMPLICIT_DECL:
yyr = yyt->IMPLICIT_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->IMPLICIT_DECL.VAL; break;
case kUSE_DECL:
yyr = yyt->USE_DECL.RENAMINGS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
yyr = yyt->ONLY_USE_DECL.NAMES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
yyr = yyt->EQV_DECL.VARS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
yyr = yyt->DATA_DECL.VARS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DATA_DECL.VALS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DATA_DECL.VALS; break;
case kDIMENSION_DECL:
yyr = yyt->DIMENSION_DECL.INDEXES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
yyr = yyt->INIT_DATA_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
yyr = yyt->TYPESPEC_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kPARAMETER_DECL:
yyr = yyt->PARAMETER_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PARAMETER_DECL.VAL; break;
case kDISTRIBUTE_DECL:
yyr = yyt->DISTRIBUTE_DECL.DISTRIBUTION; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->DISTRIBUTE_DECL.DISTRIBUTION; break;
case kALIGN_DECL:
yyr = yyt->ALIGN_DECL.ALIGN_SOURCE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALIGN_DECL.ALIGN_SPEC; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALIGN_DECL.ALIGN_SPEC; break;
case kDECL_LIST:
yyr = yyt->DECL_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DECL_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DECL_LIST.Next; break;
case kNODE_DISTRIBUTION:
yyr = yyt->NODE_DISTRIBUTION.MAPPING; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kBLOCK_DISTRIBUTION:
yyr = yyt->BLOCK_DISTRIBUTION.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyr = yyt->CYCLIC_DISTRIBUTION.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kDIST_LIST:
yyr = yyt->DIST_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DIST_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DIST_LIST.Next; break;
case kOP_GENERIC_SPEC:
yyr = yyt->OP_GENERIC_SPEC.OPERATOR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
yyr = yyt->ACF_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_LIST.Next; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_LIST.Next; break;
case kACF_BASIC:
yyr = yyt->ACF_BASIC.BASIC_STMT; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
yyr = yyt->ACF_IF.IF_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_IF.THEN_PART; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_IF.ELSE_PART; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
yyr = yyt->ACF_WHERE.WHERE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHERE.TRUE_PART; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHERE.FALSE_PART; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_SWITCH:
yyr = yyt->ACF_SWITCH.SWITCH_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_SWITCH.SWITCH_STMT; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_SWITCH.SWITCH_STMT; break;
case kACF_ALTER:
yyr = yyt->ACF_ALTER.ALTER_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_ALTER.ALTER_STMT; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_ALTER.ALTER_STMT; break;
case kACF_CASE:
yyr = yyt->ACF_CASE.CASE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_CASE.CASE_ALTS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_CASE.CASE_OTHERWISE; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_CASE.CASE_OTHERWISE; break;
case kACF_WHILE:
yyr = yyt->ACF_WHILE.WHILE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHILE.WHILE_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
yyr = yyt->ACF_REPEAT.REPEAT_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_REPEAT.REPEAT_EXP; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_WITH:
yyr = yyt->ACF_WITH.WITH_VARS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WITH.WITH_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_WITH.WITH_BODY; break;
case kACF_LOOP:
yyr = yyt->ACF_LOOP.LOOP_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
yyr = yyt->ACF_DO.DO_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_DO.DO_BODY; break;
case kACF_DOLOCAL:
yyr = yyt->ACF_DOLOCAL.DOLOCAL_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOLOCAL.DOLOCAL_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOLOCAL.DOLOCAL_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_DOLOCAL.DOLOCAL_BODY; break;
case kACF_DOVEC:
yyr = yyt->ACF_DOVEC.DOVEC_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOVEC.DOVEC_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOVEC.DOVEC_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_DOVEC.DOVEC_BODY; break;
case kACF_DOALL:
yyr = yyt->ACF_DOALL.DOALL_NEW; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOALL.DOALL_ID; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOALL.DOALL_RANGE; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DOALL.DOALL_BODY; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_DOALL.DOALL_BODY; break;
case kACF_FORALL:
yyr = yyt->ACF_FORALL.FORALL_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_FORALL.FORALL_BODY; break;
case kACF_ON:
yyr = yyt->ACF_ON.ON_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_ON.ON_STMT; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_ON.ON_STMT; break;
case kACF_BODY:
yyr = yyt->ACF_BODY.NEW_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_BODY.NEW_BODY; break;
case kACF_FLOW_GRAPH:
yyr = yyt->ACF_FLOW_GRAPH.FLOW_NODES; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
yyr = yyt->ACF_ENTRY.ENTRY_DECL; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kSELECTED_ACF_LIST:
yyr = yyt->SELECTED_ACF_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_ACF_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
yyr = yyt->SELECTED_ACF_NODE.SELECT_LIST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_ACF_NODE.SELECT_ACFS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kEXP_STMT:
yyr = yyt->EXP_STMT.STMT_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->EXP_STMT.STMT_EXP; break;
case kASSIGN_STMT:
yyr = yyt->ASSIGN_STMT.ASSIGN_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASSIGN_STMT.ASSIGN_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
yyr = yyt->PTR_ASSIGN_STMT.ASSIGN_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
yyr = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
yyr = yyt->CALL_STMT.CALL_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->CALL_STMT.CALL_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
yyr = yyt->IO_STMT.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IO_STMT.IO_SPECS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IO_STMT.IO_ITEMS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kASS_GOTO_STMT:
yyr = yyt->ASS_GOTO_STMT.GOTO_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASS_GOTO_STMT.LABELS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
yyr = yyt->COMP_GOTO_STMT.GOTO_LABELS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->COMP_GOTO_STMT.GOTO_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
yyr = yyt->COMP_IF_STMT.IF_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyr = yyt->RETURN_STMT.RETURN_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyr = yyt->PAUSE_STMT.PAUSE_CONST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kSTOP_STMT:
yyr = yyt->STOP_STMT.STOP_CONST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyr = yyt->FORMAT_STMT.FORMAT_PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kALLOCATE_STMT:
yyr = yyt->ALLOCATE_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALLOCATE_STMT.STAT; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALLOCATE_STMT.STAT; break;
case kDEALLOCATE_STMT:
yyr = yyt->DEALLOCATE_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DEALLOCATE_STMT.STAT; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DEALLOCATE_STMT.STAT; break;
case kNULLIFY_STMT:
yyr = yyt->NULLIFY_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
yyr = yyt->REDUCE_STMT.RED_FUNC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDUCE_STMT.RED_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kGLOBAL_STMT:
yyr = yyt->GLOBAL_STMT.ARRAY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->GLOBAL_STMT.INDEXED_ARRAY; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->GLOBAL_STMT.INDEXES; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->GLOBAL_STMT.MASK; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->GLOBAL_STMT.MASK; break;
case kALIGN_STMT:
yyr = yyt->ALIGN_STMT.ALIGNEE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALIGN_STMT.ALIGN_SPEC; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALIGN_STMT.ALIGN_SPEC; break;
case kDISTRIBUTE_STMT:
yyr = yyt->DISTRIBUTE_STMT.DISTRIBUTEE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DISTRIBUTE_STMT.DISTRIBUTION; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DISTRIBUTE_STMT.DISTRIBUTION; break;
case kLABEL_LIST:
yyr = yyt->LABEL_LIST.Next; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LABEL_LIST.Next; break;
case kCONST_EXP:
yyr = yyt->CONST_EXP.C; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
yyr = yyt->OP_EXP.EXP_OP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP_EXP.OPND1; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP_EXP.OPND2; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
yyr = yyt->OP1_EXP.EXP_OP1; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP1_EXP.OPND; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
yyr = yyt->SLICE_EXP.START; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SLICE_EXP.STOP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SLICE_EXP.INC; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->SLICE_EXP.INC; break;
case kPOSTFIX_EXP:
yyr = yyt->POSTFIX_EXP.POSTFIX_OP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->POSTFIX_EXP.OPND; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->POSTFIX_EXP.OPND; break;
case kCALL_EXP:
yyr = yyt->CALL_EXP.FUNC_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->CALL_EXP.FUNC_PARAMS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->CALL_EXP.FUNC_PARAMS; break;
case kCAST_EXP:
yyr = yyt->CAST_EXP.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->CAST_EXP.CAST; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->CAST_EXP.CAST; break;
case kINDEXED_EXP:
yyr = yyt->INDEXED_EXP.IND_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INDEXED_EXP.INDEX; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INDEXED_EXP.INDEX; break;
case kSELECTED_EXP:
yyr = yyt->SELECTED_EXP.SELEC_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_EXP.SELECTOR; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_EXP.SELECTOR; break;
case kASSIGN_EXP:
yyr = yyt->ASSIGN_EXP.ASSIGN_OP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASSIGN_EXP.LHS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASSIGN_EXP.RHS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASSIGN_EXP.RHS; break;
case kUSED_EXP:
yyr = yyt->USED_EXP.VARNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->USED_EXP.VARNAME; break;
case kCOND_EXP:
yyr = yyt->COND_EXP.COND; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->COND_EXP.TRUE_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->COND_EXP.FALSE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->COND_EXP.FALSE_EXP; break;
case kVAR_EXP:
yyr = yyt->VAR_EXP.V; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
yyr = yyt->FUNC_CALL_EXP.FUNC_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_CALL_EXP.FUNC_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
yyr = yyt->NAMED_EXP.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
yyr = yyt->DO_EXP.DO_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_EXP.RANGE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_EXP.BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
yyr = yyt->TYPE_EXP.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->TYPE_EXP.ELEMENTS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyr = yyt->ARRAY_EXP.ELEMENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kBTE_LIST:
yyr = yyt->BTE_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTE_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyr = yyt->USED_VAR.VARNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
yyr = yyt->INDEXED_VAR.IND_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INDEXED_VAR.IND_EXPS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
yyr = yyt->SUBSTRING_VAR.IND_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SUBSTRING_VAR.IND_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
yyr = yyt->SELECTED_VAR.SELEC_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_VAR.SELECTOR; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyr = yyt->LOOP_VAR.LOOP_VARNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kADDR:
yyr = yyt->ADDR.E; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ADDR.E; break;
case kDO_VAR:
yyr = yyt->DO_VAR.DO_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_VAR.RANGE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_VAR.BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->DO_VAR.BODY; break;
case kBTV_LIST:
yyr = yyt->BTV_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTV_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
yyr = yyt->VAR_PARAM.V; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyr = yyt->VALUE_PARAM.E; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
yyr = yyt->NAMED_PARAM.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyr = yyt->PROC_PARAM.P; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyr = yyt->FUNC_PARAM.F; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_PARAM.F; break;
case kBTP_LIST:
yyr = yyt->BTP_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTP_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTP_LIST.Next; break;
  default: return;
  }
 }
}

void BeginTree ()
{
}

void CloseTree ()
{
}
