/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Date        : Nov 92                                                   *
*  Last Update : Jan 93                                                   *
*                                                                         *
*  Module      : xoptions                                                 *
*                                                                         *
*  Function    : Athena Widgets for setting options of ADAPTOR            *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*  Update :    Jan 93, Werner Meurer, GMD, I1.HR                          *
*                                                                         *
*    - make help available                                                *
*    - split (yes|no)                                                     *
*    - more target machines (CM5, KSR1)                                   *
*    - static size of arrays can be specified                             *
*    - minimal number of processors can be asked for interactively        *
*                                                                         *
**************************************************************************/


/****************************************************************************
*                                                                           *
*     Options - Menu       -------------------------------------------      *
*                          |                                         |      *
*                          |  Machine  Model  Arrays  Language       |      *
*                          |                                         |      *
*                          -------------------------------------------      *
*                                                                           *
*                                                                           *
****************************************************************************/

#include "xglobal.h"
#include "xhelp.h"
#include "xoptions.h"
#include "xreadint.h"
#include "global.h"

bool check_options ();  /* imported from adapt */

#define DEBUG(x)	

void OptDone();

static Widget pshell;  /* global used */

static Widget label_machine, label_model, label_array, label_language,
       label_ddefault, label_split, label_minproc;
static Widget menu_machine, menu_model, menu_array, menu_language,
       menu_ddefault, menu_split, menu_minproc;
static Widget top_machine, top_model, top_array, top_language,
       top_ddefault, top_split, top_minproc;

static Widget optdialog,optdone,lentry;

/***************************************************************************
*                                                                          *
*   Possible Values for the Options                                        *
*                                                                          *
*     most things are imported from global.h                               *
*                                                                          *
***************************************************************************/



static char minproc_string [10];

/***************************************************************************
*                                                                          *
*   Selection Functions for the different Options                          *
*                                                                          *
***************************************************************************/

void select_machine  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    name = XtName (w);
    printf("Machine %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    target_machine = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

void select_model  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    name = XtName (w);
    printf("Model %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    target_model = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

void set_static(size)
int size;
{
	if (size == 0)
		array_kind = DYNAMIC_ARRAYS; /* dynamic */
	else
	{
		array_kind = STATIC_ARRAYS; /* static */
		StaticArraySize = size;	/* set array size */
	}
}

/************************************************************************/
/* get_int_from_widget()						*/
/* INPUT:	w is the widget which called the procedure		*/
/*		client_data is the user defined data (parameter)	*/
/*		call_data is x-window defined data			*/
/* OUTPUT:	failure messages in the message window			*/
/************************************************************************/
void get_int_from_widget (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    name = XtName (w);
DEBUG(printf("get_int_from_widget\n"));
    if (strcmp(name,array_items[no_array-1]) == 0) /* spezific for array_kind 	*/
    {
	open_integer_input_window(w,client_data,garbage);
    }
}

/************************************************************************/
/* select_array()							*/
/* INPUT:	w is the widget which called the procedure		*/
/*		client_data is the user defined data (parameter)	*/
/*		call_data is x-window defined data			*/
/* OUTPUT:	selected array type					*/
/* The procedure sets array type 					*/
/************************************************************************/
void select_array  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{
    Widget parent;
    char name[20];
DEBUG(printf("select_array\n"));
    if ((int) client_data == 0)
	strcpy(name,array_items[(int) client_data]);
    else
	sprintf(name,"s=%d",StaticArraySize);
    printf("For Arrays %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    array_kind = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

/************************************************************************/
/* get_int()								*/
/* INPUT:	w is the widget which called the procedure		*/
/*		client_data is the user defined data (parameter)	*/
/*		call_data is x-window defined data			*/
/* OUTPUT:	none							*/
/* The procedure calles the procedures to get an integer input form an	*/
/* new window			 					*/
/************************************************************************/
void get_int(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
DEBUG(printf("get_int\n"));
	get_int_from_widget(w,client_data,call_data);
	select_array(w,client_data,call_data);
}

/************************************************************************/
/* select_split()							*/
/* INPUT:	w is the widget which called the procedure		*/
/*		client_data is the user defined data (parameter)	*/
/*		call_data is x-window defined data			*/
/* OUTPUT:	Split yes/no						*/
/* sets the split flag							*/
/************************************************************************/
void select_split(w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    name = XtName (w);
DEBUG(printf("select_split\n"));
    printf("Split %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    split_flag = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

void select_language  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    name = XtName (w);
DEBUG(printf("select_language\n"));
    printf("Language %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    target_language = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

void select_ddefault  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    name = XtName (w);
DEBUG(printf("select_ddefault"));
    printf("Distribution %s has been selected.\n", name);
 
    /* set the new selected value global for translation */

    ddefault_kind = (int) client_data;

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, name, NULL);
    XtManageChild (parent);
}

void select_minproc  (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   char *name;
    Widget parent;
    int  sdata;
    name = XtName (w);
DEBUG(printf("select_minproc\n"));
    printf("Minimal Procs item %s has been selected.\n", name);
 
    /* set the new selected value global for translation */
    sdata = (int) client_data;
    if (sdata == 0) MinProc = 1;
    if (sdata == 1) MinProc = 2;
    if (sdata == 2) MinProc = 4;
    if (sdata == 3) MinProc = 8;
    if (sdata == 4) MinProc += 1;
    if (sdata == 5) MinProc -= 1;
    if (sdata == 6) MinProc *= 2;
    if (sdata == 7) MinProc /= 2;
    if (MinProc <= 0) MinProc = 1;
    sprintf (minproc_string, "p=%d", MinProc);

    /* set the selected label */
    parent = XtParent (w);
    parent = XtParent (parent);
    XtUnmanageChild (parent);
    XtVaSetValues (parent, XtNlabel, minproc_string, NULL);
    XtManageChild (parent);
}

/***************************************************************************
*                                                                          *
*   Pop Up of the Options Menu                                             *
*                                                                          *
***************************************************************************/

void PopupOptions(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
   Widget poswidget = (Widget) client_data;
   Position x, y;
   Dimension width, height;
DEBUG(printf("PopupOptions\n"));

   /* * get the coordinates of the middle of poswidget widget.  */

   XtVaGetValues(poswidget,
              XtNwidth, &width,
              XtNheight, &height,
              NULL);

   /* translate coordinates in application top-level window
    * into coordinates from root window origin.               */

   XtTranslateCoords(poswidget,        /* Widget */
           (Position) width/2,        /* x */
           (Position) height/2,       /* y */
           &x, &y);          /* coords on root window */

   /* move popup shell to this position (it's not visible yet) */

   XtVaSetValues(pshell,
                   XtNx, x,
                   XtNy, y+70, /* +70 to see the message window */
                   NULL);

   XtPopup(pshell, XtGrabNonexclusive);
}

/***************************************************************************
*                                                                          *
*   Command for quitting the Opton Menu                                    *
*                                                                          *
***************************************************************************/

void OptDone(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to dialog */
XtPointer call_data;
{
DEBUG(printf("OptDone\n"));
	/****************************************************************/
	/* If the window for integer size input is open, you		*/
	/* must not quit options					*/
	/****************************************************************/
	if (sshell != 0)
	{
		strcpy(last_message,"Input window for array size is open");
		set_message();
		return;
	}
	if (check_options())
	{
        	Widget dialog = (Widget) client_data;
        	XtPopdown(pshell);
	}
	else
	{       /* last_message has been set by check_options */
		set_message();
	}
}

void GenOptionsShell (topLevel)
Widget topLevel;

{
  int i, n;
  Arg args[10];

DEBUG(printf("GenOptionsShell\n"));
  pshell = XtVaCreatePopupShell(
          "Options",
          transientShellWidgetClass,
          topLevel,
          NULL);              /* terminate varargs list */

  optdialog = XtVaCreateManagedWidget(
              "optdialog",            /* widget name   */
              formWidgetClass,        /* widget class */
              pshell,                 /* parent widget*/
              NULL);                  /* terminate varargs list */

  optdone = XtVaCreateManagedWidget(
          "optdone",                      /* widget name   */
          commandWidgetClass,             /* widget class */
          optdialog,                      /* parent widget*/
          XtNlabel, "Quit Options",
          NULL);              /* terminate varargs list */

  XtAddCallback (optdone, XtNcallback, OptDone, optdialog);

  /********************************************************
  *                                                       *
  *   T A R G E T   M A C H I N E   M E N U               *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Target Machine  "); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;

  label_machine = XtCreateManagedWidget ("Machine", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_machine);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_machine); n++;

  top_machine  = XtCreateManagedWidget(machine_items[target_machine],
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_machine = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_machine, NULL, 0);

  for (i=0;i<no_machine;i++)
    { lentry = XtCreateManagedWidget (machine_items[i],
                        smeBSBObjectClass, menu_machine, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_machine, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   T A R G E T   M O D E L     M E N U                 *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Model     "); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_machine); n++;

  label_model = XtCreateManagedWidget ("Model", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_model);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_model); n++;
  XtSetArg (args[n], XtNfromHoriz, label_machine); n++;

  top_model  = XtCreateManagedWidget(model_items[target_model],
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_model = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_model, NULL, 0);

  for (i=0;i<no_model;i++)
    { lentry = XtCreateManagedWidget (model_items[i],
                        smeBSBObjectClass, menu_model, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_model, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   A R R A Y   K I N D      M E N U                    *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Arrays     "); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_model); n++;

  label_array = XtCreateManagedWidget ("Arrays", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_array);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_array); n++;
  XtSetArg (args[n], XtNfromHoriz, label_model); n++;
  if (array_kind == 1)
  {
	char label[MAXLENGTH];
	sprintf(label,"s=%d",StaticArraySize);
	top_array  = XtCreateManagedWidget(label,
                          menuButtonWidgetClass, optdialog,
                          args, n);
  }
  else
  {
	top_array  = XtCreateManagedWidget(array_items[array_kind],
                          menuButtonWidgetClass, optdialog,
                          args, n);
  }

  menu_array = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_array, NULL, 0);

  for (i=0;i<no_array;i++)
    { lentry = XtCreateManagedWidget (array_items[i],
                        smeBSBObjectClass, menu_array, NULL, 0);
      XtAddCallback (lentry, XtNcallback,
	get_int, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   S P L I T      M E N U                              *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Split "); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_array); n++;

  label_split = XtCreateManagedWidget ("Split", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_split);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_split); n++;
  XtSetArg (args[n], XtNfromHoriz, label_array); n++;

  top_split= XtCreateManagedWidget(split_items[split_flag],
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_split= XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_split, NULL, 0);

  for (i=0;i<no_split;i++)
    { lentry = XtCreateManagedWidget (split_items[i],
                        smeBSBObjectClass, menu_split, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_split, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   T A R G E T   L A N G U A G E     M E N U           *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Language   "); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_split); n++;

  label_language = XtCreateManagedWidget ("Language", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_language);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_language); n++;
  XtSetArg (args[n], XtNfromHoriz, label_split); n++;

  top_language  = XtCreateManagedWidget(language_items[target_language],
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_language = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_language, NULL, 0);

  for (i=0;i<no_language;i++)
    { lentry = XtCreateManagedWidget (language_items[i],
                        smeBSBObjectClass, menu_language, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_language, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   D E F A U L T  D I S T R I B U T I O N   M E N U    *
  *                                                       *
  ********************************************************/

  n = 0;
  XtSetArg (args[n], XtNlabel, "Default Dst"); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_language); n++;

  label_ddefault = XtCreateManagedWidget ("Distribution", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_ddefault);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_ddefault); n++;
  XtSetArg (args[n], XtNfromHoriz, label_language); n++;

  top_ddefault  = XtCreateManagedWidget(ddefault_items[ddefault_kind],
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_ddefault = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_ddefault, NULL, 0);

  for (i=0;i<no_ddefault;i++)
    { lentry = XtCreateManagedWidget (ddefault_items[i],
                        smeBSBObjectClass, menu_ddefault, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_ddefault, (XtPointer) i);
    }

  /********************************************************
  *                                                       *
  *   M i n i m a l    P R O C          M E N U           *
  *                                                       *
  ********************************************************/

  /* MinProc global from global.h, minimal number of processors */
  sprintf (minproc_string, "p=%d", MinProc);

  n = 0;
  XtSetArg (args[n], XtNlabel, "MinProc"); n++;
  XtSetArg (args[n], XtNborderWidth, 0); n++;
  XtSetArg (args[n], XtNfromVert, optdone); n++;
  XtSetArg (args[n], XtNfromHoriz, label_ddefault); n++;

  label_minproc = XtCreateManagedWidget ("MinProc", labelWidgetClass,
                          optdialog, args, n);

  make_help_available (label_minproc);

  n = 0;
  XtSetArg (args[n], XtNfromVert, label_minproc); n++;
  XtSetArg (args[n], XtNfromHoriz, label_ddefault); n++;

  top_minproc  = XtCreateManagedWidget(minproc_string,
                          menuButtonWidgetClass, optdialog,
                          args, n);

  menu_minproc = XtCreatePopupShell("menu", simpleMenuWidgetClass,
                                    top_minproc, NULL, 0);

  for (i=0;i<(no_minproc - 1);i++)
    { lentry = XtCreateManagedWidget (minproc_items[i],
                        smeBSBObjectClass, menu_minproc, NULL, 0);
      XtAddCallback (lentry, XtNcallback, select_minproc, (XtPointer) i);
    }
  lentry = XtCreateManagedWidget (minproc_items[i],
                    smeBSBObjectClass, menu_minproc, NULL, 0);
  XtAddCallback (lentry, XtNcallback, open_integer_input_window, (XtPointer) i);
DEBUG(printf("GenOptionsShell ende\n"));
}

void set_minproc(number)
int number;
{
DEBUG(printf("set_minproc\n"));
	MinProc = number;
}

/************************************************************************/
/* integer_init_or_writeback()						*/
/* INPUT:	name is the name of the grandpa's Widget		*/
/*		number is the integer value to write back		*/
/*		mode is an integer which desides to itit or writeback	*/
/*		Its value can be INIT or WRITEBACK			*/
/* OUTPUT:	stores the integer value				*/
/* return value:	0 if writebackmode				*/
/*			init value on initmode				*/
/************************************************************************/
int integer_init_or_writeback(name,number,mode)
char *name;
int number;
int mode;
{
DEBUG(printf("integer_init_or_writeback\n"));

/* set StaticArraySize or init with its value				*/
	if (strcmp(name,array_items[no_array-1]) == 0)
	{
	    if (mode == WRITEBACK)
	    {
		char array_label[MAXLENGTH];
		set_static(number);
		sprintf (array_label, "s=%d", StaticArraySize);
		/* set the selected label */
		XtUnmanageChild (top_array);
		XtVaSetValues (top_array, XtNlabel, array_label, NULL);
		XtManageChild (top_array);
	    }
	    else
		return(StaticArraySize);
	}
/* set MinProc and the label of the Widget with MinProc or init with 	*/
/* its value								*/
	if (strcmp(name,minproc_items[no_minproc-1]) == 0)
	{
	    if (mode == WRITEBACK)
	    {
		set_minproc(number);
		sprintf (minproc_string, "p=%d", MinProc);
		/* set the selected label */
		XtUnmanageChild (top_minproc);
		XtVaSetValues (top_minproc, XtNlabel, minproc_string, NULL);
		XtManageChild (top_minproc);
	    }
	    else
		return(MinProc);
	}
/* return 0 on writebackmode						*/
DEBUG(printf("integer_init_or_writeback ende\n"));
	return(0);
}
