/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                           *
*  Date        : Nov 92                                                   *
*  Last Update : April 92                                                 *
*                                                                         *
*  Module      : xvars                                                    *
*                                                                         *
*  Function    : Athena Widgets for handling definitions of a unit        *
*                                                                         *
*  Export :                                                               *
*                                                                         *
*                                                                         *
**************************************************************************/

/****************************************************************************
*                                                                           *
*    list :  vars                                                           *
*                                                                           *
****************************************************************************/

#include "xglobal.h"      /* import vars, VarCount */
#include "Definitions.h"  
#include <Idents.h>

extern char * malloc();    /* no include file specified */

Widget vars_popup, vars_menu;

/****************************************************************************
*                                                                           *
*   VarButton: is called when button is released                            *
*              pops vars_popup up if it is button3                          *
*                                                                           *
****************************************************************************/

void VarButton (w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;
{
  if (event->xbutton.button == Button3)
    {   XtVaSetValues (vars_popup, XtNx, event->xbutton.x_root, 
                                   XtNy, event->xbutton.y_root, NULL); 
        XtPopup (vars_popup, XtGrabNonexclusive);
    }
}

/****************************************************************************
*                                                                           *
*   For a given declaration tree the position in the source                 *
*   will be hightlighted (called by unit- and var-select                    *
*                                                                           *
****************************************************************************/

void show_selected_decl (); /* imported from units.c */

void VarSelect (w, client_data, call_data)
Widget w;
XtPointer  client_data;
XawListReturnStruct *call_data;

{ XawListReturnStruct *unit_data;
  tEntries Declarations;
  tIdent Ident;
  tObject Decl;

  if (call_data->list_index >= VarCount)
      printf ("No function \n");
   else
    { Declarations = UnitDeclarations;

      /* now search the entry for var */

      Ident = MakeIdent (call_data->string, strlen (call_data->string));
      Decl = GetDeclEntry (Ident, Declarations);

      if (Decl == NoObject)
         printf ("Entry for %s not found \n", call_data->string);
       else
         { WriteTree (stdout, Decl->Object.decl);
           show_selected_decl (Decl->Object.decl);
         }
    }
}

/* predefined list of unit items : must not be empty  */

static String var_items [] =
   { "<list_of_vars>" };

void VarMenuSelect (w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{   Widget menu, father;
    char *name;
    int i = (int) client_data;
    printf ("This function will be realized in a future version\n");
    XtPopdown (vars_popup);
}

void init_vars (parent)
Widget parent;
{ int n;
  Arg args[10];
  Widget entry;
  int x, y;

  n = 0;
  XtSetArg (args[n], XtNnumberStrings, 1);  n++;
  XtSetArg (args[n], XtNlist, var_items);  n++;
  XtSetArg (args[n], XtNdefaultColumns, 1);  n++;
  XtSetArg (args[n], XtNcolumnSpacing, 15);  n++;

  vars = XtCreateManagedWidget(
          "vars",                         /* widget name */
          listWidgetClass,                 /* widget class */
          parent,                          /* parent widget*/
          args, n);                        /* varargs list */

  VarCount = 0;

  XtAddCallback(vars, XtNcallback, VarSelect, 0);

  XtAddEventHandler (vars, ButtonReleaseMask, FALSE, VarButton, 0);

  vars_popup =  XtCreatePopupShell ("VarMenu", transientShellWidgetClass,
                            vars, NULL, 0);

  vars_menu =  XtCreateManagedWidget ("varmenu", boxWidgetClass,
                            vars_popup, NULL, 0);

  entry = XtCreateManagedWidget ("Show Definitions",
                  commandWidgetClass, vars_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, VarMenuSelect, (XtPointer) 1);
  entry = XtCreateManagedWidget ("Show Uses",
                  commandWidgetClass, vars_menu, NULL, 0);
  XtAddCallback (entry, XtNcallback, VarMenuSelect, (XtPointer) 2);
}

void show_vars (Declarations)
tDefinitions Declarations;

{  tObject Elem;
   char Item[150];
   int i; 
   String H;

   VarCount = 0;
   while (Declarations->Kind != kENTRY_EMPTY )
      { Elem = Declarations->ENTRY_LIST.Elem;
        GetString (Elem->Object.ident, Item);
        if (VarCount == MaxVarItems)
           printf ("ERROR: maximal number of Variable Items reached\n");
        VarItems[VarCount] =  malloc (strlen (Item) + 1);
        strcpy (VarItems[VarCount],Item);
        VarCount += 1;
        Declarations = Declarations->ENTRY_LIST.Next;
      }

   /* There are VarCount Entries */

   /* reverse the list: 0 <-> N-1, 1 <-> N-2, ... */

   for (i=0;i<VarCount/2;i++)
     { H = VarItems[i];
       VarItems[i] = VarItems[VarCount-1-i];
       VarItems[VarCount-1-i] = H;
     }

   XawListChange (vars, VarItems, VarCount, -1, TRUE);

} /* show_vars */
