#define INCL_OS2MM
#define INCL_MMIOOS2
#include <os2.h>
#include <os2me.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

int main(int argc, char *argv[]) {
      LONG rc;
      const char* argv0=strrchr(argv[0],'/');
      argv0=argv0?argv0:strrchr(argv[0],'\\');
      argv0=argv0?argv0+1:argv[0];
      
      if (argc<2) {
	printf("   Usage: %s {sound_file}\n\n   Plays sound file using mciSendCommand interface.\n",argv0);
	return 0;
	}
      char* infile=argv[1];
	
	printf("%s: started with '%s'\n",argv0,infile);

	{
    	USHORT usDeviceID;
		{
	    	MCI_OPEN_PARMS mciopenparms;
			memset(&mciopenparms, 0, sizeof(mciopenparms));
   			mciopenparms.pszDeviceType="waveaudio";

			rc = mciSendCommand(0, MCI_OPEN, MCI_WAIT, (PVOID) &mciopenparms,0);
			printf("%s: waveaudio open - %ld\n",argv0,rc);
			usDeviceID = mciopenparms.usDeviceID;
		}
		{
     		MCI_LOAD_PARMS mciloadparms;
	   		memset(&mciloadparms, 0, sizeof(mciloadparms));
     		{
		   		MMIOINFO mmioinfoSS;
 		  		memset(&mmioinfoSS, 0, sizeof(mmioinfoSS));
		   		mmioinfoSS.ulTranslate = MMIO_TRANSLATEHEADER | MMIO_TRANSLATEDATA;
  			  	mciloadparms.pszElementName = (PSZ)mmioOpen(infile, &mmioinfoSS, MMIO_READ);
				printf("%s: open - %ld\n", argv0, (HMMIO)mciloadparms.pszElementName);
			}
			rc = mciSendCommand(usDeviceID , MCI_LOAD, MCI_WAIT | MCI_OPEN_MMIO | MCI_READONLY, (PVOID) &mciloadparms, 0);
			printf("%s: mci load - %ld\n",argv0,rc);
		}
		{
     		MCI_PLAY_PARMS mciplayparms;
	   		memset(&mciplayparms, 0, sizeof(mciplayparms));
			rc = mciSendCommand(usDeviceID , MCI_PLAY, MCI_WAIT, (PVOID) &mciplayparms, 0);
			printf("%s: mci play - %ld\n",argv0,rc);
		}
	}

	return 0;
}

