/* Converts anything to anything by ntim. Public Domain. Based on: */

/* Public Domain.  Auther: Russell O'Connor */

/* Converts anything to (Vorbis/FLAC) */

#define INCL_OS2MM
#define INCL_MMIOOS2
#include <os2.h>
#include <os2me.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/timeb.h>

char buf[131072];
//char buf[4096];

int main(int argc, char *argv[])
{
      MMIOINFO mmIn, mmOut;
      HMMIO in, out;
      int result = 0;
      LONG rc;
	
      char* outfile="test.wav";
      char* wave="WAVE";
      const char* argv0=strrchr(argv[0],'/');
      argv0=argv0?argv0:strrchr(argv[0],'\\');
      argv0=argv0?argv0+1:argv[0];

      if (argc<2) {
	printf(
"   Usage: %s {sound_file} [test.wav [WAVE]]] \n"
"\n"
"   Decompress first sound file and save result in second\n"
"   (test.wav) with FourCC IOProc (WAVE).\n"
"\n"
"   Feel free to use any combinations of installed sound IOPROC.\n"
"   (First type detected by extension, second - by FourCC. Second\n"
"   sound type should support writing).\n"
"\n"
"   For example:\n"
"\n"
"	%s test.apl test.ogg OGGS\n"
"     or\n"
"	%s test.ogg test.wav WAVE\n",argv0,argv0,argv0);
	return 0;
	}

      char* infile=argv[1];
      outfile=argc>2?argv[2]:outfile;
      wave=argc>3?argv[3]:wave;

      memset(&mmIn, 0, sizeof(mmIn));
      memset(&mmOut, 0, sizeof(mmOut));

      printf("%s '%s' -> '%s' (%s): ",argv0,infile,outfile,wave);fflush(stdout);
      struct timeb start;
      ftime (&start);     

      mmIn.ulTranslate = MMIO_TRANSLATEHEADER | MMIO_TRANSLATEDATA;
      in = mmioOpen(infile, &mmIn, MMIO_READ | MMIO_DENYNONE);

      if (in) {
       mmOut.ulTranslate = MMIO_TRANSLATEHEADER | MMIO_TRANSLATEDATA;
       mmOut.fccIOProc=mmioStringToFOURCC( wave, 0 );
       out = mmioOpen(outfile, &mmOut, MMIO_WRITE | MMIO_CREATE | MMIO_DENYNONE);
      
       if (out) {
        LONG headerLength = 0;

        rc = mmioQueryHeaderLength(in, &headerLength, 0, 0);
        if (MMIO_SUCCESS==rc && headerLength > 0) {
         void *header = malloc(headerLength);
         LONG bytesRead = 0;
         
         memset(header, 0, headerLength);
         rc = mmioGetHeader(in, header, headerLength, &bytesRead, 0, 0);
         if (MMIO_SUCCESS==rc) {
          LONG bytesWrite = 0;

          rc = mmioSetHeader(out, header, headerLength, &bytesWrite, 0,0);
          if (MMIO_SUCCESS==rc) {
           LONG nRead, nWrite;

           while(1) {
            nRead = mmioRead(in, buf, sizeof(buf));
            if (nRead<=0) {
               if (nRead<0) {
                 printf("read failed.\n");
               }
               break;
            }
            nWrite = mmioWrite(out, buf, nRead);
            if (nWrite != nRead) {
                printf("write failed.\n");
            }
            printf("-");
	    fflush(stdout);
           }
	   struct timeb stop;
           ftime (&stop);     
	   printf(" total: %ld msec\n", (stop.time-start.time)*1000+stop.millitm-start.millitm);
          } else {
             printf("Can't write output header.\n");
	     result = -1;
          }

         } else {
            printf("Can't read input header.\n");
	    result = -1;
         }
         free(header);
        } else {
            printf("Can't read input header length.\n");
  	    result = -1;
        }

        mmioClose(out, 0);
     
       } else {
         printf("Can't open %s:%ld.\n",outfile,mmOut.ulErrorRet);
         result = -1;
       } 
     
      mmioClose(in, 0);
      
      } else {
         printf("Can't open %s:%ld.\n",infile,mmIn.ulErrorRet);
         result = -1;
      }

      return result;
}
