#!/usr/bin/perl -w
# this script converts the number of frames to time value in srt files format.

use strict;

my $fps = 30;

while (<>)
{
	s/\s+$//;
	my $hour = int($_ / (3600 * $fps));
	$_ -= $hour * 3600 * $fps;
	my $min = int($_ / (60 * $fps));
	$_ -= $min * 60 * $fps;
	my $sec = int($_ / $fps);
	$_ -= $sec * $fps;
	$_ *= (100 / $fps);
	print sprintf("%d:%02d:%02d.%02d,", $hour, $min, $sec, $_);
}
print "\n";
