/* s7, a Scheme interpreter
 *
 *    derived from:
 */

/* T I N Y S C H E M E    1 . 3 9
 *   Dimitrios Souflis (dsouflis@acm.org)
 *   Based on MiniScheme (original credits follow)
 * (MINISCM)               coded by Atsushi Moriwaki (11/5/1989)
 * (MINISCM)           E-MAIL :  moriwaki@kurims.kurims.kyoto-u.ac.jp
 * (MINISCM) This version has been modified by R.C. Secrist.
 * (MINISCM)
 * (MINISCM) Mini-Scheme is now maintained by Akira KIDA.
 * (MINISCM)
 * (MINISCM) This is a revised and modified version by Akira KIDA.
 * (MINISCM)	current version is 0.85k4 (15 May 1994)
 */


/* s7, Bill Schottstaedt, Aug-08
 *
 *   changes from tinyScheme:
 *        just two files: s7.c and s7.h, source-level embeddable (no library, no run-time init files)
 *        full continuations, call-with-exit for goto or return, dynamic-wind
 *        ratios and complex numbers (and ints are 64-bit by default)
 *          optional multiprecision arithmetic for all numeric types and functions
 *        generalized set!, procedure-with-setter, applicable objects
 *        defmacro and define-macro
 *        keywords, hash tables, block comments, define*
 *        format
 *        error handling using error and catch
 *        in sndlib, the run macro works giving s7 a (somewhat limited) byte compiler
 *        no invidious distinction between built-in and "foreign"
 *          (this makes it easy to extend built-in operators like "+" -- see s7.html for a simple example)
 *        lists, strings, vectors, and hash-tables are (set-)applicable objects
 *        true multiple-values
 *        multidimensional vectors
 *        hooks (conditions)
 *
 *   differences from r5rs:
 *        no syntax-rules or any of its friends
 *        no force or delay
 *        no inexact integer or ratio (so, for example, truncate returns an exact integer), no exact complex or exact real
 *           (exact? has no obvious meaning in regard to complex numbers anyway -- are we referring to the polar or
 *            the rectangular form, and are both real and imaginary parts included? -- why can't they be separate?)
 *           In s7, exact? is a synonym for rational?, inexact->exact is a synonym for rationalize.
 *        '#' does not stand for an unknown digit, and the '@' complex number notation is ignored
 *           I also choose not to include numbers such as +i (= 0+i) -- include the real part!
 *        modulo, remainder, and quotient take integer, ratio, or real args 
 *        lcm and gcd can take integer or ratio args
 *        continuation? function to distinguish a continuation from a procedure
 *        log takes an optional 2nd arg (base)
 *        '.' and an exponent can occur in a number in any base -- they do not mean "base 10"!  
 *           However, the exponent itself is always in base 10 (this follows gmp usage).
 *
 *   other additions: 
 *        random for any numeric type and any numeric argument, including 0 ferchrissake!
 *        sinh, cosh, tanh, asinh, acosh, atanh
 *        read-line, read-byte, write-byte, *stdin*, *stdout*, and *stderr*
 *        logior, logxor, logand, lognot, ash, integer-length, integer-decode-float, nan?, infinite?
 *        procedure-source, procedure-arity, procedure-documentation, help
 *          if the initial expression in a function body is a string constant, it is assumed to be a documentation string
 *        symbol-table, symbol->value, global-environment, current-environment, procedure-environment, initial-environment, environment?
 *        provide, provided?, defined?
 *        port-line-number, port-filename
 *        object->string, eval-string
 *        reverse!, list-set!, sort!, make-list
 *        gc, *load-hook*, *error-hook*, *error-info*, *unbound-variable-hook*
 *        *features*, *load-path*, *vector-print-length*, *#readers*
 *        define-constant, pi, most-positive-fixnum, most-negative-fixnum, constant?
 *        stacktrace, trace and untrace, *trace-hook*, __func__, macroexpand
 *        length, copy, fill!, reverse, map, for-each are generic
 *        make-type creates a new scheme type
 *        symbol-access modifies symbol value lookup
 *        member and assoc accept an optional 3rd argument, the comparison function
 *
 *
 * Mike Scholz provided the FreeBSD support (complex trig funcs, etc)
 * Rick Taube and Andrew Burnson provided the MS Visual C++ support
 *
 *
 * Documentation is in s7.h and s7.html.  s7test.scm is a regression test.
 *
 *
 * ---------------- compile time switches ---------------- 
 */

#include <mus-config.h>

/* 
 * Your config file goes here, or just replace that #include line with the defines you need.
 * The compile-time switches involve booleans, complex numbers, and multiprecision arithmetic.
 * Currently we assume we have setjmp.h (used by the error handlers).
 *
 * s7.h includes stdbool.h if HAVE_STDBOOL_H is 1 and we're not in C++.
 * 
 * The *gc-stats* output includes timing info if HAVE_GETTIMEOFDAY.  In this
 *   case we also assume we can load <time.h> and <sys/time.h>.
 *
 *
 * Complex number support (which is problematic in C++, Solaris, and netBSD)
 *   is on the WITH_COMPLEX switch. On a Mac, or in Linux, if you're not using C++,
 *   you can use:
 *
 *   #define WITH_COMPLEX 1
 *   #define HAVE_COMPLEX_TRIG 1
 *
 *   Define the first if your compiler has any support for complex numbers.
 *   Define the second if functions like csin are defined in the math library.
 *
 *   In C++ use:
 *
 *   #define WITH_COMPLEX 1
 *   #define HAVE_COMPLEX_TRIG 0
 *
 *   Some systems (freeBSD) have complex.h, but not the trig funcs, so
 *   WITH_COMPLEX means we can find
 *
 *      cimag creal cabs csqrt carg conj
 *
 *   and HAVE_COMPLEX_TRIG means we have
 *
 *      cacos cacosh casin casinh catan catanh ccos ccosh cexp clog cpow csin csinh ctan ctanh
 *
 * When WITH_COMPLEX is 0 or undefined, the complex functions are stubs that simply return their
 *   argument -- this will be very confusing for the s7 user because, for example, (sqrt -2)
 *   will return something bogus (it will not signal an error).
 *
 * Snd's configure.ac has m4 code to handle WITH_COMPLEX and HAVE_COMPLEX_TRIG.
 *
 *
 * To get multiprecision arithmetic, set WITH_GMP to 1.
 *   You'll also need libgmp, libmpfr, and libmpc (version 0.8.0 or later)
 */


/* ---------------- initial sizes ---------------- */

#define INITIAL_HEAP_SIZE 128000
/* the heap grows as needed, this is its initial size. 
 *
 *    this size is not very important (it can be 32 or maybe smaller, but has to be bigger than the trigger/temp space):
 *      8k: 2432, 32k: 2419, 128k: 2401, 512k: 2394, 8192k: 2417
 *    (valgrind timings from 23-Feb-10 running s7test.scm)
 *
 * If the initial heap is small, s7 can run in less than 1 Mbyte of memory.
 * As of 5-May-2011, the heap size must be a multiple of 32.
 */

#define SYMBOL_TABLE_SIZE 19259
/* names are hashed into the symbol table (a vector) and collisions are chained as lists. 
 */

#define INITIAL_STACK_SIZE 2048         
/* the stack grows as needed, each frame takes 4 entries, this is its initial size.
 *   this needs to be big enough to handle the eval_c_string's at startup (ca 100) 
 *   In s7test.scm, the maximum stack size is ca 440.  In snd-test.scm, it's ca 200.
 */

#define INITIAL_PROTECTED_OBJECTS_SIZE 16  
/* a vector of objects that are (semi-permanently) protected from the GC, grows as needed */

#define GC_TEMPS_SIZE 256
/* the number of recent objects that are temporarily gc-protected; 8 works for s7test and snd-test. 
 *    For the FFI, this sets the lag between a call on s7_cons and the first moment when its result
 *    might be vulnerable to the GC. 
 */

#define INITIAL_TRACE_LIST_SIZE 2
/* a list of currently-traced functions */



/* ---------------- scheme choices ---------------- */

#ifndef WITH_GMP
  #define WITH_GMP 0
  /* this includes multiprecision arithmetic for all numeric types and functions, using gmp, mpfr, and mpc
   * WITH_GMP adds the following functions: bignum, bignum?, bignum-precision
   * using gmp with precision=128 is about 3 times slower than using C doubles and long long ints
   */
#endif

#if WITH_GMP
  #define DEFAULT_BIGNUM_PRECISION 128
#endif

#ifndef WITH_EXTRA_EXPONENT_MARKERS
  #define WITH_EXTRA_EXPONENT_MARKERS 1
  /* if 1, s7 recognizes "d", "f", "l", and "s" as exponent markers, in addition to "e" (also "D", "F", "L", "S")
   */
#endif

#ifndef WITH_UNQUOTE_SPLICING
  #define WITH_UNQUOTE_SPLICING 0
  /* backwards compatibility */
#endif



#ifndef S7_DEBUGGING
  #define S7_DEBUGGING 0
#endif


#ifndef WITH_OPTIMIZATION
#define WITH_OPTIMIZATION 1
  /* this currently speeds s7 up by about a factor of 1/3 (248 -> 157) -- not sure it's worth all the code. 
   *    a lot of the current optimization choices are just experiments (I'll clean up this mess some day).
   *    the completely unrealistic goal, of course, is to replace the run macro.
   */
#endif

#define DISPLAY(Obj) s7_object_to_c_string(sc, Obj)
#define DISPLAY_80(Obj) object_to_truncated_string(sc, Obj)


/* -------------------------------------------------------------------------------- */

/* s7.c is organized as follows:
 *
 *    structs and type flags
 *    constants
 *    GC
 *    stacks
 *    symbols
 *    environments
 *    keywords
 *    continuations
 *    numbers
 *    characters
 *    strings
 *    ports
 *    lists
 *    vectors and hash-tables
 *    objects and functions
 *    hooks
 *    eq?
 *    generic length, copy, fill!
 *    format
 *    error handlers, stacktrace, trace
 *    sundry leftovers
 *    multiple-values, quasiquote
 *    eval
 *    multiprecision arithmetic
 *    initialization
 *
 * naming conventions: s7_* usually are C accessible (s7.h), g_* are scheme accessible (FFI), H_* are documentation strings,
 *   *_1 are auxilliary functions, big_* refer to gmp and friends, scheme "?" corresponds to C "_is_", scheme "->" to C "_to_".
 */

#if __cplusplus
  #ifndef WITH_COMPLEX
    #define WITH_COMPLEX 1
  #endif
  #ifndef HAVE_COMPLEX_TRIG
    #define HAVE_COMPLEX_TRIG 0
  #endif
#endif


#ifndef _MSC_VER
  #include <unistd.h>
#endif
#include <limits.h>
#include <ctype.h>
#ifndef _MSC_VER
  #include <strings.h>
  #include <errno.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <stdarg.h>

#if __cplusplus
  #include <cmath>
#else
  #include <math.h>
#endif

#if WITH_COMPLEX
  #if __cplusplus
    #include <complex>
  #else
    #include <complex.h>
  #endif
#endif

#include <setjmp.h>

#include "s7.h"

#ifndef M_PI
  #define M_PI 3.1415926535897932384626433832795029L
#endif

#ifndef INFINITY
  #define INFINITY (-log(0.0))
#endif

#ifndef NAN
  #define NAN (INFINITY / INFINITY)
#endif

enum {OP_NO_OP, 
      OP_READ_INTERNAL, OP_EVAL, 
      OP_EVAL_ARGS, OP_EVAL_ARGS1, OP_EVAL_ARGS2, OP_EVAL_ARGS3, OP_EVAL_ARGS4, OP_EVAL_ARGS5,
      OP_APPLY, OP_EVAL_MACRO, OP_LAMBDA, OP_QUOTE, 
      OP_DEFINE, OP_DEFINE1, OP_BEGIN, OP_BEGIN1, OP_IF, OP_IF1, OP_SET, OP_SET1, OP_SET2, 
      OP_LET, OP_LET1, OP_LET_STAR, OP_LET_STAR1, 
      OP_LETREC, OP_LETREC1, OP_COND, OP_COND1, 
      OP_AND, OP_AND1, OP_OR, OP_OR1, OP_DEFMACRO, OP_DEFMACRO_STAR,
      OP_DEFINE_MACRO, OP_DEFINE_MACRO_STAR, OP_DEFINE_EXPANSION,
      OP_CASE, OP_CASE1, OP_READ_LIST, OP_READ_DOT, OP_READ_QUOTE, 
      OP_READ_QUASIQUOTE, OP_READ_QUASIQUOTE_VECTOR, OP_READ_UNQUOTE, OP_READ_APPLY_VALUES,
      OP_READ_VECTOR, OP_READ_DONE, 
      OP_LOAD_RETURN_IF_EOF, OP_LOAD_CLOSE_AND_POP_IF_EOF, OP_EVAL_STRING, OP_EVAL_DONE,
      OP_CATCH, OP_DYNAMIC_WIND, OP_DEFINE_CONSTANT, OP_DEFINE_CONSTANT1, 
      OP_DO, OP_DO_END, OP_DO_END1, OP_DO_STEP, OP_DO_STEP2, OP_DO_INIT,
      OP_DEFINE_STAR, OP_LAMBDA_STAR, OP_ERROR_QUIT, OP_UNWIND_INPUT, OP_UNWIND_OUTPUT, 
      OP_TRACE_RETURN, OP_ERROR_HOOK_QUIT, OP_TRACE_HOOK_QUIT, OP_WITH_ENV, OP_WITH_ENV1,
      OP_FOR_EACH, OP_FOR_EACH_SIMPLE, OP_MAP, OP_MAP_SIMPLE, OP_BARRIER, OP_DEACTIVATE_GOTO,
      OP_DEFINE_BACRO, OP_DEFINE_BACRO_STAR, 
      OP_GET_OUTPUT_STRING, OP_SORT, OP_SORT1, OP_SORT2, OP_SORT3, OP_SORT4, OP_SORT_TWO, OP_SORT_OBJECT,
      OP_EVAL_STRING_1, OP_EVAL_STRING_2, OP_HOOK_APPLY, 
      OP_MEMBER_IF, OP_ASSOC_IF, OP_MEMBER_IF1, OP_ASSOC_IF1,
      
      OP_QUOTE_UNCHECKED, OP_LAMBDA_UNCHECKED, OP_LET_UNCHECKED, OP_CASE_UNCHECKED, 
      OP_SET_UNCHECKED, OP_SET_SYMBOL_C, OP_SET_SYMBOL_S, OP_SET_SYMBOL_P, OP_SET_NORMAL, OP_SET_PAIR,
      OP_LET_STAR_UNCHECKED, OP_LETREC_UNCHECKED, OP_COND_UNCHECKED,
      OP_LAMBDA_STAR_UNCHECKED, OP_DO_UNCHECKED, OP_DEFINE_UNCHECKED, OP_DEFINE_STAR_UNCHECKED,
      OP_LET_NO_VARS, OP_NAMED_LET, OP_NAMED_LET_NO_VARS, OP_CASE_PAIR,
      OP_IF_P_P_P, OP_IF_P_P, OP_IF_P_P_X, OP_IF_P_X_P, OP_IF_P_X, OP_IF_P_X_X, 
      OP_IF_PPP, OP_IF_PP, OP_IF_PPX, OP_IF_PXP, OP_IF_PX, OP_IF_PXX, 
      OP_IF_X_P_P, OP_IF_X_P, OP_IF_X_P_X, OP_IF_X_X_P, OP_IF_X_X, OP_IF_X_X_X,
      OP_AND_UNCHECKED, OP_AND_P, OP_AND_P1, OP_OR_UNCHECKED, OP_OR_P, OP_OR_P1,
      
#if WITH_OPTIMIZATION
      OP_SAFE_AND, OP_SAFE_AND1, OP_SAFE_OR, OP_SAFE_OR1, OP_SAFE_IF1, OP_SAFE_IF2,
      OP_SAFE_OR_S, OP_SAFE_AND_S, OP_SIMPLE_DO, OP_SIMPLE_DO_STEP, OP_DOTIMES, OP_DOTIMES_STEP, OP_SIMPLE_DOTIMES,
      OP_SAFE_IF1_1, OP_SAFE_IF2_1,
      OP_SAFE_C_P_1, OP_EVAL_ARGS_P_1, OP_EVAL_ARGS_P_2, OP_EVAL_ARGS_P_3, OP_EVAL_ARGS_P_4,
      OP_INCREMENT_1, OP_DECREMENT_1, OP_SET_CDR, OP_SET_CONS,
      OP_SAFE_C_ZZ_1, OP_SAFE_C_ZZ_2, OP_SAFE_C_SZ_1, OP_SAFE_C_ZS_1,
      OP_SAFE_C_ZXX_1, OP_SAFE_C_XZX_1, OP_SAFE_C_XXZ_1, 
      OP_SAFE_C_ZZX_1, OP_SAFE_C_ZZX_2, OP_SAFE_C_ZXZ_1, OP_SAFE_C_ZXZ_2, OP_SAFE_C_XZZ_1, OP_SAFE_C_XZZ_2, 
      OP_SAFE_C_ZZZ_1, OP_SAFE_C_ZZZ_2, OP_SAFE_C_ZZZ_3, 
#endif
      OP_MAX_DEFINED_1};

#define OP_MAX_DEFINED (OP_MAX_DEFINED_1 + 1)


#if ((defined(SIZEOF_VOID_P)) && (SIZEOF_VOID_P == 4))
  #define opcode_t unsigned int
#else
  #define opcode_t unsigned long long int
#endif


static const char *op_names[OP_MAX_DEFINED + 1] = 
  {"no-op",
   "read-internal", "eval", "eval-args", "eval-args", "eval-args", "eval-args", "eval-args", "eval-args",
   "apply", "eval-macro", "lambda", 
   "quote", "define", "define", "begin", "begin", "if", "if", "set!", "set!", "set!", 
   "let", "let", "let*", "let*", "letrec", "letrec", 
   "cond", "cond", "and", "and", "or", "or", "defmacro", "defmacro*",
   "define-macro", "define-macro*", "define-expansion", "case", "case", 
   "read-list", "read-dot", "read-quote", "read-quasiquote", "read-quasiquote-vector", 
   "read-unquote", "read-apply-values", "read-vector", "read-done", 
   "load-return-if-eof", "load-close-and-stop-if-eof", "eval-string", "eval-done", "catch", 
   "dynamic-wind", "define-constant", "define-constant", "do", "do", "do", 
   "do", "do", "do", "define*", "lambda*", 
   "error-quit", "unwind-input", "unwind-output", "trace-return", "error-hook-quit", 
   "trace-hook-quit", "with-environment", "with-environment", "for-each", "for-each", "map", "map",
   "barrier", "deactivate-goto", "define-bacro", "define-bacro*", 
   "get-output-string", "sort", "sort", "sort", "sort", "sort", "sort", "sort",
   "eval-string", "eval-string", "hook-apply", 
   "member-if", "assoc-if", "member-if", "assoc-if",
   "quote-unchecked", "lambda-unchecked", "let-unchecked", "case-unchecked", 
   "set-unchecked", "set-symbol-c", "set-symbol-s", "set-symbol-p", "set-normal", "set-pair",
   "let*-unchecked", "letrec-unchecked", "cond-unchecked",
   "lambda*-unchecked", "do-unchecked", "define-unchecked", "define*-unchecked",
   "let", "let", "let", "case-pair",

   "if-p-p-p", "if-p-p", "if-p-p-x", "if-p-x-p", "if-p-x", "if-p-x-x", 
   "if-ppp", "if-pp", "if-ppx", "if-pxp", "if-px", "if-pxx", 
   "if-x-p-p", "if-x-p", "if-x-p-x", "if-x-x-p", "if-x-x", "if-x-x-x",
   "and-unchecked", "and-p", "and-p1", "or-unchecked", "or-p", "or-p1", 

#if WITH_OPTIMIZATION
   "safe-and", "safe-and", "safe-or", "safe-or", "safe-if1", "safe-if2",
   "safe-or-s", "safe-and-s", "simple-do", "simple-do-step", "safe-do", "safe-do-step",
   "safe-if", "safe-if", 
   "safe-c-p-1", "eval-args-p-1", "eval-args-p-2", "eval-args-p-3", "eval-args-p-4",
   "increment-1", "decrement-1", "set-cdr", "set-cons",
   "safe-c-zz-1", "safe-c-zz-2",
   "op_safe_c_zxx_1", "op_safe_c_xzx_1", "op_safe_c_xxz_1", 
   "op_safe_c_zzx_1", "op_safe_c_zzx_2", "op_safe_c_zxz_1", "op_safe_c_zxz_2", "op_safe_c_xzz_1", "op_safe_c_xzz_2", 
   "op_safe_c_zzz_1", "op_safe_c_zzz_2", "op_safe_c_zzz_3", 
#endif

   "op-max"
};


#if WITH_OPTIMIZATION
enum{SAFE_C_P, SAFE_C_PP, SAFE_C_CP, SAFE_C_SP, SAFE_C_PC, SAFE_C_PS, SAFE_C_PQ, SAFE_C_QP};

enum{OP_NOT_AN_OP, HOP_NOT_AN_OP,
     OP_THUNK, HOP_THUNK, 
     OP_CLOSURE_S, HOP_CLOSURE_S, OP_CLOSURE_C, HOP_CLOSURE_C, OP_CLOSURE_Q, HOP_CLOSURE_Q, 
     OP_CLOSURE_SS, HOP_CLOSURE_SS, OP_CLOSURE_SC, HOP_CLOSURE_SC, OP_CLOSURE_CS, HOP_CLOSURE_CS, OP_CLOSURE_CC, HOP_CLOSURE_CC, 
     OP_CLOSURE_opSq, HOP_CLOSURE_opSq, OP_CLOSURE_opSq_S, HOP_CLOSURE_opSq_S, OP_CLOSURE_opSq_opSq, HOP_CLOSURE_opSq_opSq, 
     OP_CLOSURE_S_opSq, HOP_CLOSURE_S_opSq, OP_CLOSURE_SSS, HOP_CLOSURE_SSS,
     OP_CLOSURE_ALL_S, HOP_CLOSURE_ALL_S, OP_CLOSURE_ALL_C, HOP_CLOSURE_ALL_C, OP_CLOSURE_ALL_G, HOP_CLOSURE_ALL_G, 

     OP_SAFE_THUNK, HOP_SAFE_THUNK,
     OP_SAFE_CLOSURE_S, HOP_SAFE_CLOSURE_S, OP_SAFE_CLOSURE_C, HOP_SAFE_CLOSURE_C, OP_SAFE_CLOSURE_Q, HOP_SAFE_CLOSURE_Q, 
     OP_SAFE_CLOSURE_SS, HOP_SAFE_CLOSURE_SS, OP_SAFE_CLOSURE_SC, HOP_SAFE_CLOSURE_SC, OP_SAFE_CLOSURE_CS, HOP_SAFE_CLOSURE_CS, OP_SAFE_CLOSURE_CC, HOP_SAFE_CLOSURE_CC, 
     OP_SAFE_CLOSURE_opSq, HOP_SAFE_CLOSURE_opSq, OP_SAFE_CLOSURE_opSq_S, HOP_SAFE_CLOSURE_opSq_S, OP_SAFE_CLOSURE_opSq_opSq, HOP_SAFE_CLOSURE_opSq_opSq, 
     OP_SAFE_CLOSURE_S_opSq, HOP_SAFE_CLOSURE_S_opSq, OP_SAFE_CLOSURE_SSS, HOP_SAFE_CLOSURE_SSS,
     OP_SAFE_CLOSURE_ALL_S, HOP_SAFE_CLOSURE_ALL_S, OP_SAFE_CLOSURE_ALL_C, HOP_SAFE_CLOSURE_ALL_C, OP_SAFE_CLOSURE_ALL_G, HOP_SAFE_CLOSURE_ALL_G, 

     OP_SAFE_C_C, HOP_SAFE_C_C, OP_SAFE_C_S, HOP_SAFE_C_S, OP_SAFE_DO_C_S, HOP_SAFE_DO_C_S, 
     OP_SAFE_C_SS, HOP_SAFE_C_SS, OP_SAFE_C_SC, HOP_SAFE_C_SC, OP_SAFE_C_CS, HOP_SAFE_C_CS, 
     OP_SAFE_C_Q, HOP_SAFE_C_Q, OP_SAFE_C_SQ, HOP_SAFE_C_SQ, OP_SAFE_C_QS, HOP_SAFE_C_QS, OP_SAFE_C_QQ, HOP_SAFE_C_QQ, 
     OP_SAFE_C_QC, HOP_SAFE_C_QC, OP_SAFE_C_CQ, HOP_SAFE_C_CQ,
     OP_SAFE_C_XXX, HOP_SAFE_C_XXX, OP_SAFE_C_SSS, HOP_SAFE_C_SSS,
     OP_SAFE_C_ALL_S, HOP_SAFE_C_ALL_S, OP_SAFE_C_ALL_G, HOP_SAFE_C_ALL_G,

     OP_SAFE_C_opCq, HOP_SAFE_C_opCq, OP_SAFE_C_opQq, HOP_SAFE_C_opQq, OP_SAFE_C_opSq, HOP_SAFE_C_opSq, 
     OP_SAFE_C_opSSq, HOP_SAFE_C_opSSq, OP_SAFE_C_opSCq, HOP_SAFE_C_opSCq, OP_SAFE_C_opSQq, HOP_SAFE_C_opSQq, 
     OP_SAFE_C_opCSq, HOP_SAFE_C_opCSq, OP_SAFE_C_S_opSq, HOP_SAFE_C_S_opSq,
     OP_SAFE_C_C_opSCq, HOP_SAFE_C_C_opSCq, 
     OP_SAFE_C_S_opSCq, HOP_SAFE_C_S_opSCq, OP_SAFE_C_S_opCSq, HOP_SAFE_C_S_opCSq, 
     OP_SAFE_C_opSq_S, HOP_SAFE_C_opSq_S, OP_SAFE_C_opSq_C, HOP_SAFE_C_opSq_C, 
     OP_SAFE_C_opSq_opSq, HOP_SAFE_C_opSq_opSq, OP_SAFE_C_S_opSSq, HOP_SAFE_C_S_opSSq, OP_SAFE_C_C_opSq, HOP_SAFE_C_C_opSq, 
     OP_SAFE_C_C_opCSq, HOP_SAFE_C_C_opCSq, OP_SAFE_C_opCSq_C, HOP_SAFE_C_opCSq_C, 
     OP_SAFE_C_S_opCq, HOP_SAFE_C_S_opCq, OP_SAFE_C_opSSq_C, HOP_SAFE_C_opSSq_C, OP_SAFE_C_C_opSSq, HOP_SAFE_C_C_opSSq, 
     OP_SAFE_C_C_opCq, HOP_SAFE_C_C_opCq, OP_SAFE_C_opCq_S, HOP_SAFE_C_opCq_S, 
     OP_SAFE_C_opCq_opCq, HOP_SAFE_C_opCq_opCq, OP_SAFE_C_opCq_C, HOP_SAFE_C_opCq_C, 
     OP_SAFE_C_opSCq_opSCq, HOP_SAFE_C_opSCq_opSCq, OP_SAFE_C_opSSq_opSSq, HOP_SAFE_C_opSSq_opSSq,
     OP_SAFE_C_opSSq_S, HOP_SAFE_C_opSSq_S, OP_SAFE_C_opSCq_S, HOP_SAFE_C_opSCq_S, OP_SAFE_C_opCSq_S, HOP_SAFE_C_opCSq_S,
     OP_SAFE_C_opSCq_C, HOP_SAFE_C_opSCq_C, OP_SAFE_C_opQSq, HOP_SAFE_C_opQSq, 
     OP_SAFE_C_opXXXq, HOP_SAFE_C_opXXXq, 
     OP_SAFE_C_opSq_opAq, HOP_SAFE_C_opSq_opAq, OP_SAFE_C_opSCq_opACq, HOP_SAFE_C_opSCq_opACq, 

     /* these can't be embedded, and have to be the last thing called */
     OP_C_LS, HOP_C_LS, OP_C_L_opSq, HOP_C_L_opSq, OP_C_L, HOP_C_L, OP_C_LL, HOP_C_LL, OP_C_CLL, HOP_C_CLL,
     OP_C_ALL_G, HOP_C_ALL_G, 
     OP_C_S_opSq, HOP_C_S_opSq, 

     OP_VECTOR_C, HOP_VECTOR_C, OP_VECTOR_S, HOP_VECTOR_S, 
     OP_STRING_C, HOP_STRING_C, OP_STRING_S, HOP_STRING_S, 
     OP_C_OBJECT_C, HOP_C_OBJECT_C, OP_C_OBJECT_S, HOP_C_OBJECT_S, 
     OP_PAIR_C, HOP_PAIR_C, OP_PAIR_S, HOP_PAIR_S, 
     OP_HASH_TABLE_C, HOP_HASH_TABLE_C, OP_HASH_TABLE_S, HOP_HASH_TABLE_S, 
     
     OP_UNKNOWN_C, HOP_UNKNOWN_C, OP_UNKNOWN_S, HOP_UNKNOWN_S,
     OP_UNKNOWN_SS, HOP_UNKNOWN_SS, OP_UNKNOWN_SSS, HOP_UNKNOWN_SSS, 
     OP_UNKNOWN_SC, HOP_UNKNOWN_SC, OP_UNKNOWN_CS, HOP_UNKNOWN_CS, OP_UNKNOWN_CC, HOP_UNKNOWN_CC, 
     OP_UNKNOWN_opSq, HOP_UNKNOWN_opSq, OP_UNKNOWN_opSq_S, HOP_UNKNOWN_opSq_S, OP_UNKNOWN_opSq_opSq, HOP_UNKNOWN_opSq_opSq,      
     OP_UNKNOWN_S_opSq, HOP_UNKNOWN_S_opSq,

     OP_SAFE_C_opSAFE_CLOSURE_SSq, HOP_SAFE_C_opSAFE_CLOSURE_SSq, OP_SAFE_C_opSAFE_CLOSURE_opSq_Sq, HOP_SAFE_C_opSAFE_CLOSURE_opSq_Sq,

     OP_SAFE_C_P, HOP_SAFE_C_P,
     OP_SAFE_C_opSq_P, HOP_SAFE_C_opSq_P, OP_SAFE_C_SP, HOP_SAFE_C_SP, OP_SAFE_C_CP, HOP_SAFE_C_CP, 
     OP_SAFE_C_PS, HOP_SAFE_C_PS, OP_SAFE_C_PC, HOP_SAFE_C_PC, 

     OP_SAFE_C_Z, HOP_SAFE_C_Z, OP_SAFE_C_ZZ, HOP_SAFE_C_ZZ, OP_SAFE_C_SZ, HOP_SAFE_C_SZ, OP_SAFE_C_ZS, HOP_SAFE_C_ZS, 
     OP_SAFE_C_CZ, HOP_SAFE_C_CZ, OP_SAFE_C_ZC, HOP_SAFE_C_ZC, OP_SAFE_C_QZ, HOP_SAFE_C_QZ, OP_SAFE_C_ZQ, HOP_SAFE_C_ZQ, 

     OP_SAFE_C_ZXX, HOP_SAFE_C_ZXX, OP_SAFE_C_XZX, HOP_SAFE_C_XZX, OP_SAFE_C_XXZ, HOP_SAFE_C_XXZ,
     OP_SAFE_C_ZZX, HOP_SAFE_C_ZZX, OP_SAFE_C_ZXZ, HOP_SAFE_C_ZXZ, OP_SAFE_C_XZZ, HOP_SAFE_C_XZZ, 
     OP_SAFE_C_ZZZ, HOP_SAFE_C_ZZZ,

     OPT_MAX_DEFINED
};

#if 0
static const char *opt_names[OPT_MAX_DEFINED + 1] =
  {  
     "op_not_an_op", "hop_not_an_op",
     "op_thunk", "hop_thunk", 
     "op_closure_s", "hop_closure_s", "op_closure_c", "hop_closure_c", "op_closure_q", "hop_closure_q", 
     "op_closure_ss", "hop_closure_ss", "op_closure_sc", "hop_closure_sc", "op_closure_cs", "hop_closure_cs", "op_closure_cc", "hop_closure_cc", 
     "op_closure_opsq", "hop_closure_opsq", "op_closure_opsq_s", "hop_closure_opsq_s", "op_closure_opsq_opsq", "hop_closure_opsq_opsq", 
     "op_closure_s_opsq", "hop_closure_s_opsq", "op_closure_sss", "hop_closure_sss",
     "op_closure_all_s", "hop_closure_all_s", "op_closure_all_c", "hop_closure_all_c", "op_closure_all_g", "hop_closure_all_g", 

     "op_safe_thunk", "hop_safe_thunk",
     "op_safe_closure_s", "hop_safe_closure_s", "op_safe_closure_c", "hop_safe_closure_c", "op_safe_closure_q", "hop_safe_closure_q", 
     "op_safe_closure_ss", "hop_safe_closure_ss", "op_safe_closure_sc", "hop_safe_closure_sc", "op_safe_closure_cs", "hop_safe_closure_cs", "op_safe_closure_cc", "hop_safe_closure_cc", 
     "op_safe_closure_opsq", "hop_safe_closure_opsq", "op_safe_closure_opsq_s", "hop_safe_closure_opsq_s", "op_safe_closure_opsq_opsq", "hop_safe_closure_opsq_opsq", 
     "op_safe_closure_s_opsq", "hop_safe_closure_s_opsq", "op_safe_closure_sss", "hop_safe_closure_sss",
     "op_safe_closure_all_s", "hop_safe_closure_all_s", "op_safe_closure_all_c", "hop_safe_closure_all_c", "op_safe_closure_all_g", "hop_safe_closure_all_g", 

     "op_safe_c_c", "hop_safe_c_c", "op_safe_c_s", "hop_safe_c_s", "op_safe_do_c_s", "hop_safe_do_c_s", 
     "op_safe_c_ss", "hop_safe_c_ss", "op_safe_c_sc", "hop_safe_c_sc", "op_safe_c_cs", "hop_safe_c_cs", 
     "op_safe_c_q", "hop_safe_c_q", "op_safe_c_sq", "hop_safe_c_sq", "op_safe_c_qs", "hop_safe_c_qs", "op_safe_c_qq", "hop_safe_c_qq", 
     "op_safe_c_qc", "hop_safe_c_qc", "op_safe_c_cq", "hop_safe_c_cq",
     "op_safe_c_xxx", "hop_safe_c_xxx", "op_safe_c_sss", "hop_safe_c_sss",
     "op_safe_c_all_s", "hop_safe_c_all_s", "op_safe_c_all_g", "hop_safe_c_all_g",

     "op_safe_c_opcq", "hop_safe_c_opcq", "op_safe_c_opqq", "hop_safe_c_opqq", "op_safe_c_opsq", "hop_safe_c_opsq", 
     "op_safe_c_opssq", "hop_safe_c_opssq", "op_safe_c_opscq", "hop_safe_c_opscq", "op_safe_c_opsqq", "hop_safe_c_opsqq", 
     "op_safe_c_opcsq", "hop_safe_c_opcsq", "op_safe_c_s_opsq", "hop_safe_c_s_opsq", 
     "op_safe_c_c_opscq", "hop_safe_c_c_opscq", 
     "op_safe_c_s_opscq", "hop_safe_c_s_opscq", "op_safe_c_s_opcsq", "hop_safe_c_s_opcsq", 
     "op_safe_c_opsq_s", "hop_safe_c_opsq_s", "op_safe_c_opsq_c", "hop_safe_c_opsq_c", 
     "op_safe_c_opsq_opsq", "hop_safe_c_opsq_opsq", "op_safe_c_s_opssq", "hop_safe_c_s_opssq", "op_safe_c_c_opsq", "hop_safe_c_c_opsq", 
     "op_safe_c_c_opcsq", "hop_safe_c_c_opcsq", "op_safe_c_opcsq_c", "hop_safe_c_opcsq_c", 
     "op_safe_c_s_opcq", "hop_safe_c_s_opcq", "op_safe_c_opssq_c", "hop_safe_c_opssq_c", "op_safe_c_c_opssq", "hop_safe_c_c_opssq", 
     "op_safe_c_c_opcq", "hop_safe_c_c_opcq", "op_safe_c_opcq_s", "hop_safe_c_opcq_s", 
     "op_safe_c_opcq_opcq", "hop_safe_c_opcq_opcq", "op_safe_c_opcq_c", "hop_safe_c_opcq_c", 
     "op_safe_c_opscq_opscq", "hop_safe_c_opscq_opscq", "op_safe_c_opssq_opssq", "hop_safe_c_opssq_opssq",
     "op_safe_c_opssq_s", "hop_safe_c_opssq_s", "op_safe_c_opscq_s", "hop_safe_c_opscq_s", "op_safe_c_opcsq_s", "hop_safe_c_opcsq_s",
     "op_safe_c_opscq_c", "hop_safe_c_opscq_c", "op_safe_c_opqsq", "hop_safe_c_opqsq", 
     "op_safe_c_opxxxq", "hop_safe_c_opxxxq", 
     "op_safe_c_opsq_opaq", "hop_safe_c_opsq_opaq", "op_safe_c_opscq_opacq", "hop_safe_c_opscq_opacq", 

     "op_c_ls", "hop_c_ls", "op_c_l_opsq", "hop_c_l_opsq", "op_c_l", "hop_c_l", "op_c_ll", "hop_c_ll", "op_c_cll", "hop_c_cll",
     "op_c_all_g", "hop_c_all_g", 
     "op_c_s_opsq", "hop_c_s_opsq", 

     "op_vector_c", "hop_vector_c", "op_vector_s", "hop_vector_s", 
     "op_string_c", "hop_string_c", "op_string_s", "hop_string_s", 
     "op_c_object_c", "hop_c_object_c", "op_c_object_s", "hop_c_object_s", 
     "op_pair_c", "hop_pair_c", "op_pair_s", "hop_pair_s", 
     "op_hash_table_c", "hop_hash_table_c", "op_hash_table_s", "hop_hash_table_s", 
     
     "op_unknown_c", "hop_unknown_c", "op_unknown_s", "hop_unknown_s",
     "op_unknown_ss", "hop_unknown_ss", "op_unknown_sss", "hop_unknown_sss", 
     "op_unknown_sc", "hop_unknown_sc", "op_unknown_cs", "hop_unknown_cs", "op_unknown_cc", "hop_unknown_cc", 
     "op_unknown_opsq", "hop_unknown_opsq", "op_unknown_opsq_s", "hop_unknown_opsq_s", "op_unknown_opsq_opsq", "hop_unknown_opsq_opsq",      
     "op_unknown_s_opsq", "hop_unknown_s_opsq", 

     "op_safe_c_opsafe_closure_ssq", "hop_safe_c_opsafe_closure_ssq", "op_safe_c_opsafe_closure_opsq_sq", "hop_safe_c_opsafe_closure_opsq_sq",

     "op_safe_c_p", "hop_safe_c_p",
     "op_safe_c_opsq_p", "hop_safe_c_opsq_p", "op_safe_c_sp", "hop_safe_c_sp", "op_safe_c_cp", "hop_safe_c_cp", 
     "op_safe_c_ps", "hop_safe_c_ps", "op_safe_c_pc", "hop_safe_c_pc", 

     "op_safe_c_z", "hop_safe_c_z", "op_safe_c_zz", "hop_safe_c_zz", "op_safe_c_sz", "hop_safe_c_sz", "op_safe_c_zs", "hop_safe_c_zs", 
     "op_safe_c_cz", "hop_safe_c_cz", "op_safe_c_zc", "hop_safe_c_zc", "op_safe_c_qz", "hop_safe_c_qz", "op_safe_c_zq", "hop_safe_c_zq", 

     "op_safe_c_zxx", "hop_safe_c_zxx", "op_safe_c_xzx", "hop_safe_c_xzx", "op_safe_c_xxz", "hop_safe_c_xxz",
     "op_safe_c_zzx", "hop_safe_c_zzx", "op_safe_c_zxz", "hop_safe_c_zxz", "op_safe_c_xzz", "hop_safe_c_xzz", 
     "op_safe_c_zzz", "hop_safe_c_zzz",

     "opt-max",
  };
#endif

#endif


#define NUM_SMALL_INTS 256

typedef enum {TOKEN_EOF, TOKEN_LEFT_PAREN, TOKEN_RIGHT_PAREN, TOKEN_DOT, TOKEN_ATOM, TOKEN_QUOTE, TOKEN_DOUBLE_QUOTE, 
	      TOKEN_BACK_QUOTE, TOKEN_COMMA, TOKEN_AT_MARK, TOKEN_SHARP_CONST, TOKEN_VECTOR} token_t;


typedef struct s7_num_t {
  unsigned int type;
  union {
    
    s7_Int integer_value;
    
    s7_Double real_value;
    
    struct {
      s7_Int numerator;
      s7_Int denominator;
    } fraction_value;
    
    struct {
      s7_Double real;
      s7_Double imag;
    } complex_value;
    
    unsigned long ul_value; /* these two are not used by s7 in any way */
    unsigned long long ull_value;

  } value;
} s7_num_t;


typedef enum {FILE_PORT, STRING_PORT, FUNCTION_PORT} port_type_t;

typedef struct s7_port_t {
  bool is_closed;
  port_type_t type;
  bool needs_free;
  FILE *file;
  unsigned int line_number;
  unsigned int file_number;
  char *filename;
  char *value;
  unsigned int size, point;        /* these limit the in-core portion of a string-port to 2^31 bytes */
  s7_pointer (*input_function)(s7_scheme *sc, s7_read_t read_choice, s7_pointer port);
  void (*output_function)(s7_scheme *sc, unsigned char c, s7_pointer port);
  void *data;
  /* a version of string ports using a pointer to the current location and a pointer to the end
   *   (rather than an integer for both, indexing from the base string) was not faster.
   */
} s7_port_t;


typedef struct s7_func_t {
  s7_function ff;
  const char *name;
  char *doc;
  unsigned int required_args, optional_args, all_args;
  bool rest_arg;
  s7_pointer setter;
  s7_pointer arity_list;
#if WITH_OPTIMIZATION
  unsigned int id;
  s7_pointer (*chooser)(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr);
#endif
} s7_func_t;


typedef struct {               /* call/cc */
  s7_pointer stack;
  s7_pointer *stack_start, *stack_end, *op_stack;
  unsigned int stack_size, op_stack_loc, op_stack_size;
} s7_continuation_t;


typedef struct s7_vdims_t {
  unsigned int ndims;
  s7_Int *dims, *offsets;
  s7_pointer original;
} s7_vdims_t;


/* cell structure */
typedef struct s7_cell {
  union {
    unsigned int flag;
    unsigned char type_field;
  } tf;
  int hloc;
  union {
    
    struct {
      unsigned int length;
      unsigned int hash;
      char *svalue;
      s7_pointer global_slot;
      s7_pointer local_slot;
    } string;
    
    s7_num_t number;
    
    s7_port_t *port;
    
    unsigned char cvalue;

    unsigned int op;
    
    void *c_pointer;
    
    struct {
      s7_Int length;
      s7_pointer *elements;
      union {
	s7_vdims_t *dim_info;
	unsigned int entries;          
	/* was s7_Int but that costs us 4 bytes per object everywhere in the 32-bit case
	 */
      } vextra;
      union {
	unsigned int fill_ptr;
	s7_pointer (*hash_func)(s7_scheme *sc, s7_pointer table, s7_pointer key);
      } hf;
    } vector;
    
    s7_func_t *ffptr;      /* C functions, macros */
    
    struct {
      s7_pointer car, cdr, ecdr;
      unsigned int line;
      unsigned int data;
    } cons;

    struct {
      s7_pointer car, cdr, ecdr;
      long long int id;
    } sym;

    struct {               /* additional object types (C and Scheme) */
      int type;
      void *value;
      s7_pointer (*apply)(s7_scheme *sc, s7_pointer obj, s7_pointer args);
      s7_pointer (*set)(s7_scheme *sc, s7_pointer obj, s7_pointer args);
    } fobj;
    
    s7_continuation_t *continuation;
    
    struct {               /* call-with-exit */
      unsigned int goto_loc, op_stack_loc;
      bool active;
    } rexit;
    
    struct {               /* catch */
      unsigned int goto_loc, op_stack_loc;
      s7_pointer tag;
      s7_pointer handler;
    } rcatch; /* C++ reserves "catch" I guess */
    
    struct {               /* dynamic-wind */
      s7_pointer in, out, body;
      unsigned int state;
    } winder;

    struct {               /* hook */
      s7_pointer functions, arity, documentation;
    } hook;

  } object;
} s7_cell;


typedef struct {
  s7_cell obj;
  int accessor;
  void *accessor_data; /* FFI-accessible */
  void *op_data;       /*   same purpose, but only s7-accessible */
} s7_extended_cell;


typedef struct {
  s7_pointer *objs;
  int size, top, ref;
  int *refs;
} shared_info;

typedef struct {
  char *str;
  int len, loc;
  s7_pointer args;
} format_data;

static s7_pointer *small_ints, *small_negative_ints, *chars;
static s7_pointer real_zero; 

struct s7_scheme {  
  opcode_t op;
  s7_pointer value;
  s7_pointer args;                    /* arguments of current function */
  s7_pointer code, cur_code;          /* current code */
  s7_pointer envir;                   /* current environment */
  token_t tok;
  bool from_eval;

  s7_pointer stack;                   /* stack is a vector */
  unsigned int stack_size;
  s7_pointer *stack_start, *stack_end, *stack_resize_trigger;
  
  s7_pointer *op_stack, *op_stack_now, *op_stack_end;
  unsigned int op_stack_size;

  s7_cell **heap, **free_heap, **free_heap_top, **free_heap_trigger;
  unsigned int heap_size;

  /* "int" or "unsigned int" seems safe here:
   *      sizeof(s7_cell) = 28 in 32-bit machines, 32 in 64
   *      so to get more than 2^32 actual objects would require ca 140 GBytes RAM
   *      vectors might be full of the same object (sc->NIL for example), so there
   *      we need ca 38 GBytes RAM (8 bytes per pointer).  
   */
  
  s7_pointer protected_objects;       /* a vector of gc-protected objects */
  unsigned int protected_objects_size, protected_objects_loc;

  struct s7_cell _NIL;
  s7_pointer NIL;                     /* empty list */
  
  struct s7_cell _T;
  s7_pointer T;                       /* #t */
  
  struct s7_cell _F;
  s7_pointer F;                       /* #f */
  
  struct s7_cell _EOF_OBJECT;         /* can't use EOF here because it's taken by C or glibc? */
  s7_pointer EOF_OBJECT;              /* #<eof> */
  
  struct s7_cell _UNDEFINED;  
  s7_pointer UNDEFINED;               /* #<undefined> */
  
  struct s7_cell _UNSPECIFIED;
  s7_pointer UNSPECIFIED;             /* #<unspecified> */
  
  struct s7_cell _NO_VALUE;
  s7_pointer NO_VALUE;                /* the (values) value */

  struct s7_cell _ELSE;
  s7_pointer ELSE;                    /* else */  

  struct s7_cell _GC_NIL;             /* marker for empty slot in gc-protected vector */
  s7_pointer GC_NIL;
  
  s7_pointer symbol_table;            /* symbol table */
  s7_pointer global_env;              /* global environment */
  s7_pointer initial_env;             /* original bindings of predefined functions */
  
  s7_pointer LAMBDA, LAMBDA_STAR, QUOTE, UNQUOTE, MACROEXPAND;
  s7_pointer APPLY, VECTOR, CDR, SET, QQ_VALUES, QQ_LIST, QQ_APPLY, QQ_APPEND, MULTIVECTOR;
  s7_pointer ERROR, WRONG_TYPE_ARG, WRONG_TYPE_ARG_INFO, OUT_OF_RANGE, OUT_OF_RANGE_INFO;
  s7_pointer SIMPLE_WRONG_TYPE_ARG_INFO, SIMPLE_OUT_OF_RANGE_INFO;
  s7_pointer FORMAT_ERROR, WRONG_NUMBER_OF_ARGS, READ_ERROR, SYNTAX_ERROR, TOO_MANY_ARGUMENTS, NOT_ENOUGH_ARGUMENTS;
  s7_pointer KEY_KEY, KEY_OPTIONAL, KEY_REST, KEY_ALLOW_OTHER_KEYS;
  s7_pointer __FUNC__;
  s7_pointer OBJECT_SET;              /* applicable object set method */
  s7_pointer FEED_TO;                 /* => */
  s7_pointer VECTOR_SET, STRING_SET, LIST_SET, HASH_TABLE_SET, HASH_TABLE_ITERATE;
  s7_pointer S_IS_TYPE, S_TYPE_MAKE, S_TYPE_REF, S_TYPE_ARG;
  s7_pointer s_function_args;
#if WITH_UNQUOTE_SPLICING
  s7_pointer UNQUOTE_SPLICING;
#endif
  s7_pointer QUOTE_UNCHECKED, CASE_UNCHECKED, SET_UNCHECKED, LAMBDA_UNCHECKED, LET_UNCHECKED;
  s7_pointer LET_STAR_UNCHECKED, LETREC_UNCHECKED, COND_UNCHECKED, SET_SYMBOL_C, SET_SYMBOL_S, SET_SYMBOL_P, SET_NORMAL, SET_PAIR;
  s7_pointer LAMBDA_STAR_UNCHECKED, DO_UNCHECKED, DEFINE_UNCHECKED, DEFINE_STAR_UNCHECKED, CASE_PAIR;
  s7_pointer LET_NO_VARS, NAMED_LET, NAMED_LET_NO_VARS, AND_UNCHECKED, AND_P, OR_UNCHECKED, OR_P;
  s7_pointer IF_P_P_P, IF_P_P, IF_P_P_X, IF_P_X_P, IF_P_X, IF_P_X_X, IF_X_P_P, IF_X_P, IF_X_P_X, IF_X_X_P, IF_X_X, IF_X_X_X;

#if WITH_OPTIMIZATION
  s7_pointer SAFE_AND, SAFE_OR, SAFE_IF1, SAFE_IF2, SAFE_OR_S, SAFE_AND_S;
  s7_pointer INCREMENT_1, DECREMENT_1, SET_CDR, SET_CONS, SIMPLE_DO, DOTIMES, SIMPLE_DOTIMES;
  int safe_do_level, safe_do_ids_size;
  long long int *safe_do_ids;
#endif
  
  s7_pointer input_port;              /* current-input-port */
  s7_pointer input_port_stack;        /*   input port stack (load and read internally) */
  s7_pointer output_port;             /* current-output-port */
  s7_pointer error_port;              /* current-error-port */
  s7_pointer error_info;              /* the vector bound to *error-info* */
  bool input_is_file;
  s7_pointer standard_input, standard_output, standard_error;

  s7_pointer sharp_readers;           /* the binding pair for the global *#readers* list */
  s7_pointer vector_print_length;     /* same for *vector-print-length* */
  s7_pointer trace_hook;              /* *trace-hook* hook object */
  s7_pointer load_hook;               /* *load-hook* hook object */
  s7_pointer unbound_variable_hook;   /* *unbound-variable-hook* hook object */
  s7_pointer error_hook;              /* *error-hook* hook object */

  bool gc_off, gc_stats;              /* gc_off: if true, the GC won't run, gc_stats: if true, print stats during GC */
  unsigned int gensym_counter;
  bool symbol_table_is_locked;  

  #define INITIAL_STRBUF_SIZE 1024
  unsigned int strbuf_size;
  char *strbuf;
  
  char *read_line_buf;
  unsigned int read_line_buf_size;

  s7_pointer w, x, y, z;         /* evaluator local vars */
  s7_pointer temp1, temp2, temp3;

  struct s7_cell _TEMP_CELL, _TEMP_CELL_1, _TEMP_CELL_2, _TEMP_CELL_3;
  s7_pointer TEMP_CELL, TEMP_CELL_1, TEMP_CELL_2, TEMP_CELL_3;
  struct s7_cell _T1_1, _T2_1, _T2_2, _T3_1, _T3_2, _T3_3;
  s7_pointer T1_1, T2_1, T2_2, T3_1, T3_2, T3_3;

  jmp_buf goto_start;
  bool longjmp_ok;
  void (*error_exiter)(void);
  bool (*begin_hook)(s7_scheme *sc);
  
  s7_pointer *trace_list;
  int trace_list_size, trace_top, trace_depth;
  int no_values, current_line, s7_call_line, safety;
  const char *current_file, *s7_call_file, *s7_call_name;

  shared_info *circle_info;
  format_data **fdats;
  int num_fdats;

  s7_pointer *strings, *vectors, *input_ports, *output_ports, *continuations, *c_objects, *hash_tables;
  int strings_size, vectors_size, input_ports_size, output_ports_size, continuations_size, c_objects_size, hash_tables_size;
  int strings_loc, vectors_loc, input_ports_loc, output_ports_loc, continuations_loc, c_objects_loc, hash_tables_loc;

  void *default_rng;
#if WITH_GMP
  void *default_big_rng;
#endif
};


#define T_UNTYPED              0
#define T_NIL                  1
#define T_STRING               2
#define T_NUMBER               3
#define T_SYMBOL               4
#define T_PAIR                 5
#define T_CLOSURE              6
#define T_CLOSURE_STAR         7
#define T_CONTINUATION         8
#define T_CHARACTER            9
#define T_INPUT_PORT          10
#define T_VECTOR              11
#define T_MACRO               12
#define T_BACRO               13
#define T_C_OBJECT            14
#define T_GOTO                15
#define T_OUTPUT_PORT         16
#define T_CATCH               17
#define T_DYNAMIC_WIND        18
#define T_HASH_TABLE          19
#define T_BOOLEAN             20
#define T_SYNTAX              21
#define T_HOOK                22
#define T_ENVIRONMENT         23
#define T_STACK               24
#define T_COUNTER             25
#define T_C_MACRO             26
#define T_C_POINTER           27
#define T_C_FUNCTION          28
#define T_C_ANY_ARGS_FUNCTION 29
#define T_C_OPT_ARGS_FUNCTION 30
#define T_C_RST_ARGS_FUNCTION 31
#define T_C_LST_ARGS_FUNCTION 32

#define BUILT_IN_TYPES        33

/* T_STACK and T_COUNTER are internal types, mainly for the GC mark process's benefit
 */

#define TYPE_BITS                     8
#define typeflag(p)                   ((p)->tf.flag)
#define type(p)                       ((p)->tf.type_field)

#define T_IMMUTABLE                   (1 << (TYPE_BITS + 0))
#define is_immutable(p)               ((typeflag(p) & T_IMMUTABLE) != 0)
#define set_immutable(p)              typeflag(p) |= (T_IMMUTABLE | T_DONT_COPY)
/* immutable means the value can't be changed via set! or bind -- this is separate from the symbol access stuff
 */

#define T_DONT_COPY                   (1 << (TYPE_BITS + 1))
#define dont_copy(p)                  ((typeflag(p) & T_DONT_COPY) != 0)
#define dont_copy_cdr(p)              ((typeflag(p) & (T_PROCEDURE | T_ANY_MACRO)) != 0)
/* dont_copy means the object is not copied when saved in a continuation */

#define T_PROCEDURE                   (1 << (TYPE_BITS + 2))
#define is_procedure(p)               ((typeflag(p) & T_PROCEDURE) != 0)
/* closure, c_function, procedure-with-setter, settable object, goto or continuation */

#define T_SAFE_PROCEDURE              (1 << (TYPE_BITS + 3))
#define is_safe_procedure(p)          ((typeflag(p) & T_SAFE_PROCEDURE) != 0)
/* c_functions that do not return or modify the arg list directly (no :rest arg in particular),
 *    and that can't call apply themselves either directly or via s7_call.
 *    I think the latter would be safe if they gc_protect the called function.  
 */

#define T_ANY_MACRO                   (1 << (TYPE_BITS + 4))
#define is_any_macro(p)               ((typeflag(p) & T_ANY_MACRO) != 0)
/* this marks scheme and C-defined macros */

#define T_DONT_EVAL_ARGS              (1 << (TYPE_BITS + 5))
#define dont_eval_args(p)             ((typeflag(p) & T_DONT_EVAL_ARGS) != 0)

#define T_EXPANSION                   (1 << (TYPE_BITS + 6))
#define is_expansion(p)               ((typeflag(p) & T_EXPANSION) != 0)
/* this marks macros from define-expansion */

#define T_GLOBAL                      (1 << (TYPE_BITS + 7))
#define is_global(p)                  ((typeflag(p) & T_GLOBAL) != 0)
/* this marks something defined (bound) at the top-level, and never defined locally */
#define set_global(p)                 typeflag(p) |= T_GLOBAL
#define set_local(p)                  typeflag(p) = (typeflag(p) & ~(T_DONT_EVAL_ARGS | T_GLOBAL | T_SYNTACTIC))

#define T_MULTIPLE_VALUE              (1 << (TYPE_BITS + 8))
#define is_multiple_value(p)          ((typeflag(p) & T_MULTIPLE_VALUE) != 0)
#define set_multiple_value(p)         typeflag(p) |= T_MULTIPLE_VALUE
#define multiple_value(p)             p
/* this bit marks a list (from "values") that is waiting for a
 *    chance to be spliced into its caller's argument list.  It is normally
 *    on only for a very short time.
 */

#define T_PENDING_REMOVAL             (1 << (TYPE_BITS + 9))
#define is_pending_removal(p)         ((typeflag(p) & T_PENDING_REMOVAL) != 0)
#define set_pending_removal(p)        typeflag(p) |= T_PENDING_REMOVAL
#define clear_pending_removal(p)      typeflag(p) &= ~(T_PENDING_REMOVAL)
/* this bit is for circle checks during removal of a global function from the heap
 */

#define T_KEYWORD                     (1 << (TYPE_BITS + 10))
#define is_keyword(p)                 ((typeflag(p) & T_KEYWORD) != 0)
/* this bit distinguishes a symbol from a symbol that is also a keyword
 */

#define T_SYNTACTIC                   (1 << (TYPE_BITS + 11))
#define is_syntactic(p)               ((typeflag(p) & T_SYNTACTIC) != 0)
/* this marks syntax objects */


#define T_OVERLAY                     (1 << (TYPE_BITS + 12))
#define set_overlay(p)                typeflag(p)  |= T_OVERLAY
#define is_overlaid(p)                ((typeflag(p) & T_OVERLAY) != 0)
/* optimizer flag that marks a cell whose ecdr points to the previous cell in a list
 */

#define T_OPTIMIZED                   (1 << (TYPE_BITS + 13))
#define set_optimized(p)              typeflag(p)  |= T_OPTIMIZED
#define is_optimized(p)               ((typeflag(p) & T_OPTIMIZED) != 0)
#define clear_optimized(p)            typeflag(p) &= ~(T_OPTIMIZED)
/* optimizer flag for an expression that has optimization info
 */

#define T_CHECKED                     (1 << (TYPE_BITS + 14))
#define set_checked(p)                typeflag(p)  |= T_CHECKED
#define is_checked(p)                 ((typeflag(p) & T_CHECKED) != 0)
#define is_not_checked(p)             ((typeflag(p) & T_CHECKED) == 0)
/* optimizer flag that an expression has been checked for possible optimization 
 *    (trying to avoid circular lists during the optimization scan)
 */

#define T_UNSAFE                      (1 << (TYPE_BITS + 15))
#define set_unsafe(p)                 typeflag(p)  |= T_UNSAFE
#define is_unsafe(p)                  ((typeflag(p) & T_UNSAFE) != 0)
#define clear_unsafe(p)               typeflag(p)  &= (~T_UNSAFE)
/* optimizer flag saying "this expression is not completely self-contained.  It might involve the stack, etc"
 */

#define T_SAFE_CLOSURE                (1 << (TYPE_BITS + 16))
#define set_safe_closure(p)           typeflag(p)  |= T_SAFE_CLOSURE
#define is_safe_closure(p)            ((typeflag(p) & T_SAFE_CLOSURE) != 0)
#define clear_safe_closure(p)         typeflag(p)  &= (~T_SAFE_CLOSURE)
/* optimizer flag for a closure body that is completely simple (every expression is safe)
 */

#define T_SETTER                      (1 << (TYPE_BITS + 17))
#define set_setter(p)                 typeflag(p)  |= T_SETTER
#define is_setter(p)                  ((typeflag(p) & T_SETTER) != 0)
/* optimizer flag for a procedure that sets some variable (set-car! for example).
 */

#define T_GC_MARK                     (1 << (TYPE_BITS + 23))
#define is_marked(p)                  ((typeflag(p) &  T_GC_MARK) != 0)
#define set_mark(p)                   typeflag(p)  |= T_GC_MARK
#define clear_mark(p)                 typeflag(p)  &= (~T_GC_MARK)
/* using bit 23 for this makes a big difference in the GC
 */

#define UNUSED_BITS                   0x7c000000

#define set_type(p, f)                typeflag(p) = f

#define is_true(Sc, p)                ((p) != Sc->F)
#define is_false(Sc, p)               ((p) == Sc->F)
#ifdef _MSC_VER
  #define make_boolean(sc, Val)       (((Val) & 0xff) ? sc->T : sc->F)
#else
  #define make_boolean(sc, Val)       ((Val) ? sc->T : sc->F)
#endif

#define is_unspecified(p)             (p == sc->UNSPECIFIED)

#define is_pair(p)                    (type(p) == T_PAIR)
#define is_null(p)                    (p == sc->NIL)
#define is_not_null(p)                (p != sc->NIL)
#define car(p)                        ((p)->object.cons.car)
#define cdr(p)                        ((p)->object.cons.cdr)
#define ecdr(p)                       ((p)->object.cons.ecdr)
#define caar(p)                       car(car(p))
#define cadr(p)                       car(cdr(p))
#define cdar(p)                       cdr(car(p))
#define cddr(p)                       cdr(cdr(p))
#define caaar(p)                      car(car(car(p)))
#define cadar(p)                      car(cdr(car(p)))
#define cdadr(p)                      cdr(car(cdr(p)))
#define caddr(p)                      car(cdr(cdr(p)))
#define caadr(p)                      car(car(cdr(p)))
#define cdaar(p)                      cdr(car(car(p)))
#define cdddr(p)                      cdr(cdr(cdr(p)))
#define cddar(p)                      cdr(cdr(car(p)))
#define caaadr(p)                     car(car(car(cdr(p))))
#define caadar(p)                     car(car(cdr(car(p))))
#define cadaar(p)                     car(cdr(car(car(p))))
#define cadddr(p)                     car(cdr(cdr(cdr(p))))
#define caaddr(p)                     car(car(cdr(cdr(p))))
#define cddddr(p)                     cdr(cdr(cdr(cdr(p))))
#define caddar(p)                     car(cdr(cdr(car(p))))
#define cdadar(p)                     cdr(car(cdr(car(p))))
#define cdaddr(p)                     cdr(car(cdr(cdr(p))))

#define caaaar(p)                     car(car(car(car(p))))
#define cadadr(p)                     car(cdr(car(cdr(p))))
#define cdaadr(p)                     cdr(car(car(cdr(p))))
#define cdaaar(p)                     cdr(car(car(car(p))))
#define cdddar(p)                     cdr(cdr(cdr(car(p))))
#define cddadr(p)                     cdr(cdr(car(cdr(p))))
#define cddaar(p)                     cdr(cdr(car(car(p))))


#if defined(__GNUC__)
  #define cons(Sc, A, B)              ({ s7_pointer _x_; \
                                         NEW_CELL_NO_CHECK(Sc, _x_); \
                                         car(_x_) = A; \
                                         cdr(_x_) = B; \
                                         set_type(_x_, T_PAIR); \
                                         if (sc->free_heap_top <= sc->free_heap_trigger) {sc->temp3 = _x_; try_to_call_gc(sc); sc->temp3 = sc->NIL;} \
                                         _x_; })
#else
  #define cons(Sc, A, B)              s7_cons(Sc, A, B)
  /* TODO: I think the non-GNUC s7_cons needs GC protection similar to cons above */
#endif

#define list_1(Sc, A)                 cons(Sc, A, sc->NIL)
#define list_2(Sc, A, B)              cons_unchecked(Sc, A, cons(Sc, B, sc->NIL))
#define list_3(Sc, A, B, C)           cons_unchecked(Sc, A, cons_unchecked(Sc, B, cons(Sc, C, sc->NIL)))
#define list_4(Sc, A, B, C, D)        cons_unchecked(Sc, A, cons_unchecked(Sc, B, cons_unchecked(Sc, C, cons(Sc, D, sc->NIL))))

#define pair_line_number(p)           (p)->object.cons.line
#define port_file_number(p)           (p)->object.port->file_number
#define optimize_data(p)              (p)->object.cons.data
#define set_optimize_data(P, X)       (P)->object.cons.data = ((X) + hop) /* this unchecking saves about 40 currently (2%) */
#define clear_optimize_data(P)        optimize_data(P) = 0
#define optimize_data_match(P, Q)     ((optimize_data(P) & 0xfffe) == Q)

#define frame_id(p)                   (p)->object.sym.id
#define symbol_id(p)                  (p)->object.sym.id
/* we need 64-bits here, I think, since we don't want this thing to wrap around, and frames are created at a great rate 
 *    callgrind says this is faster than an unsigned int!
 */

#define string_value(p)               ((p)->object.string.svalue)
#define string_length(p)              ((p)->object.string.length)
#define string_hash(p)                ((p)->object.string.hash)
#define character(p)                  ((p)->object.cvalue)

#define symbol_name(p)                string_value(car(p))
#define symbol_name_length(p)         string_length(car(p))
#define symbol_value(p)               cdr(p)
#define set_symbol_value(p, Val)      cdr(p) = (Val)
#define symbol_global_slot(p)         (car(p))->object.string.global_slot
#define symbol_local_slot(p)          (car(p))->object.string.local_slot
#define symbol_hash(p)                (car(p))->object.string.hash
#define symbol_accessor(p)            ((s7_extended_cell *)p)->accessor
#define symbol_accessor_data(p)       ((s7_extended_cell *)p)->accessor_data
#define symbol_op_data(p)             ((s7_extended_cell *)p)->op_data

#define is_syntax(p)                  (type(p) == T_SYNTAX)
#define syntax_opcode(p)              ((p)->hloc)

#define is_environment(p)             (type(p) == T_ENVIRONMENT)

#define vector_length(p)              ((p)->object.vector.length)
#define vector_element(p, i)          ((p)->object.vector.elements[i])
#define vector_elements(p)            (p)->object.vector.elements
#define vector_fill_pointer(p)        ((p)->object.vector.hf.fill_ptr)

#define vector_dimension(p, i)        ((p)->object.vector.vextra.dim_info->dims[i])
#define vector_ndims(p)               ((p)->object.vector.vextra.dim_info->ndims)
#define vector_offset(p, i)           ((p)->object.vector.vextra.dim_info->offsets[i])
#define vector_is_multidimensional(p) ((p)->object.vector.vextra.dim_info)
#define shared_vector(p)              ((p)->object.vector.vextra.dim_info->original)

#define hash_table_length(p)          (p)->object.vector.length
#define hash_table_elements(p)        (p)->object.vector.elements
#define hash_table_entries(p)         (p)->object.vector.vextra.entries
#define hash_table_function(p)        (p)->object.vector.hf.hash_func

#define small_int(Val)                small_ints[Val]

#define is_input_port(p)              (type(p) == T_INPUT_PORT) 
#define is_output_port(p)             (type(p) == T_OUTPUT_PORT)
#define is_string_port(p)             ((p)->object.port->type == STRING_PORT)
#define is_file_port(p)               ((p)->object.port->type == FILE_PORT)
#define is_function_port(p)           ((p)->object.port->type == FUNCTION_PORT)
#define port_type(p)                  (p)->object.port->type
#define port_line_number(p)           (p)->object.port->line_number
#define port_filename(p)              (p)->object.port->filename
#define port_file(p)                  (p)->object.port->file
#define port_is_closed(p)             (p)->object.port->is_closed
#define port_string(p)                (p)->object.port->value
#define port_string_length(p)         (p)->object.port->size
#define port_string_point(p)          (p)->object.port->point
#define port_needs_free(p)            (p)->object.port->needs_free
#define port_output_function(p)       (p)->object.port->output_function
#define port_input_function(p)        (p)->object.port->input_function
#define port_data(p)                  (p)->object.port->data

#define is_c_function(f)              (type(f) >= T_C_FUNCTION)
#define c_function(f)                 (f)->object.ffptr
#define c_function_call(f)            (f)->object.ffptr->ff
#define c_function_name(f)            (f)->object.ffptr->name
#define c_function_documentation(f)   (f)->object.ffptr->doc
#define c_function_required_args(f)   (f)->object.ffptr->required_args
#define c_function_optional_args(f)   (f)->object.ffptr->optional_args
#define c_function_has_rest_arg(f)    (f)->object.ffptr->rest_arg
#define c_function_all_args(f)        (f)->object.ffptr->all_args
#define c_function_arity_list(f)      (f)->object.ffptr->arity_list
#define c_function_setter(f)          (f)->object.ffptr->setter
#if WITH_OPTIMIZATION
#define c_function_class(f)           (f)->object.ffptr->id
#define c_function_chooser(f)         (f)->object.ffptr->chooser
#define c_function_choice(Sc, F, Args, X) (c_function_chooser(F))(Sc, F, Args, X)
#endif

#define is_c_macro(p)                 (type(p) == T_C_MACRO)
#define c_macro_call(f)               (f)->object.ffptr->ff
#define c_macro_name(f)               (f)->object.ffptr->name
#define c_macro_required_args(f)      (f)->object.ffptr->required_args
#define c_macro_all_args(f)           (f)->object.ffptr->all_args

#define continuation(p)               (p)->object.continuation
#define continuation_stack(p)         (p)->object.continuation->stack
#define continuation_stack_end(p)     (p)->object.continuation->stack_end
#define continuation_stack_start(p)   (p)->object.continuation->stack_start
#define continuation_stack_size(p)    (p)->object.continuation->stack_size
#define continuation_stack_top(p)     (continuation_stack_end(p) - continuation_stack_start(p))
#define continuation_op_stack(p)      (p)->object.continuation->op_stack
#define continuation_op_loc(p)        (p)->object.continuation->op_stack_loc
#define continuation_op_size(p)       (p)->object.continuation->op_stack_size

#define call_exit_goto_loc(p)         (p)->object.rexit.goto_loc
#define call_exit_op_loc(p)           (p)->object.rexit.op_stack_loc
#define call_exit_active(p)           (p)->object.rexit.active

#define s7_stack_top(Sc)              ((Sc)->stack_end - (Sc)->stack_start)

#define is_continuation(p)            (type(p) == T_CONTINUATION)
#define is_goto(p)                    (type(p) == T_GOTO)
#define is_macro(p)                   (type(p) == T_MACRO)
#define is_bacro(p)                   (type(p) == T_BACRO)

#define is_closure(p)                 (type(p) == T_CLOSURE)
#define is_closure_star(p)            (type(p) == T_CLOSURE_STAR)
#define closure_source(Obj)           car(Obj)
#define closure_args(Obj)             car(closure_source(Obj))
#define closure_body(Obj)             cdr(closure_source(Obj))
#define closure_environment(Obj)      cdr(Obj)

#define catch_tag(p)                  (p)->object.rcatch.tag
#define catch_goto_loc(p)             (p)->object.rcatch.goto_loc
#define catch_op_loc(p)               (p)->object.rcatch.op_stack_loc
#define catch_handler(p)              (p)->object.rcatch.handler

enum {DWIND_INIT, DWIND_BODY, DWIND_FINISH};
#define dynamic_wind_state(p)         (p)->object.winder.state
#define dynamic_wind_in(p)            (p)->object.winder.in
#define dynamic_wind_out(p)           (p)->object.winder.out
#define dynamic_wind_body(p)          (p)->object.winder.body

#define is_c_object(p)                (type(p) == T_C_OBJECT)
#define object_type(p)                (p)->object.fobj.type
#define object_value(p)               (p)->object.fobj.value
#define object_ref(p)                 (p)->object.fobj.apply
#define object_set(p)                 (p)->object.fobj.set

#define is_hook(p)                    (type(p) == T_HOOK)
#define hook_arity(p)                 (p)->object.hook.arity
#define hook_functions(p)             (p)->object.hook.functions
#define hook_documentation(p)         (p)->object.hook.documentation

#define raw_pointer(p)                (p)->object.c_pointer


#define NUM_INT      0
#define NUM_RATIO    1
#define NUM_REAL     2
#define NUM_REAL2    3
#define NUM_COMPLEX  4
#define NO_NUM       8
#define NO_NUM_SHIFT 3
#define IS_NUM(n)    (n < NO_NUM)

#if WITH_GMP
#define T_BIG_INTEGER 0
#define T_BIG_RATIO 1
#define T_BIG_REAL 2
#define T_BIG_COMPLEX 3
#endif

#define number(p)                     (p)->object.number
#define number_type(p)                (p)->object.number.type
#define num_type(n)                   (n.type)

#define numerator(n)                  n.value.fraction_value.numerator
#define denominator(n)                n.value.fraction_value.denominator
#define fraction(n)                   (((long double)numerator(n)) / ((long double)denominator(n)))

#define real_part(n)                  n.value.complex_value.real
#define imag_part(n)                  n.value.complex_value.imag
#define integer(n)                    n.value.integer_value
#define complex_real_part(p)          real_part(number(p))
#define complex_imag_part(p)          imag_part(number(p))


#define S7_LLONG_MAX 9223372036854775807LL
#define S7_LLONG_MIN (-S7_LLONG_MAX - 1LL)

#define S7_LONG_MAX 2147483647LL
#define S7_LONG_MIN (-S7_LONG_MAX - 1LL)

#define S7_SHORT_MAX 32767
#define S7_SHORT_MIN -32768

static s7_Int s7_Int_max = 0, s7_Int_min = 0;

/* 9007199254740991LL is where a truncated double starts to skip integers (expt 2 53) = ca 1e16 
 *   :(ceiling (+ 1e16 1))
 *   10000000000000000
 *   :(> 9007199254740993.0 9007199254740992.0)
 *   #f ; in non-gmp 64-bit doubles
 *
 * but we can't fix this except in the gmp case because:
 *   :(integer-decode-float (+ (expt 2.0 62) 100))
 *   (4503599627370496 10 1)
 *   :(integer-decode-float (+ (expt 2.0 62) 500))
 *   (4503599627370496 10 1)
 *   :(> (+ (expt 2.0 62) 500) (+ (expt 2.0 62) 100))
 *   #f ; non-gmp again
 *
 * i.e. the bits are identical.  We can't even detect when it has happened, so should
 *   we just give an error for any floor (or whatever) of an arg>1e16?  (sin has a similar problem)?
 *   I think in the non-gmp case I'll throw an error in these cases because the results are
 *   bogus:
 *   :(floor (+ (expt 2.0 62) 512))
 *   4611686018427387904
 *   :(floor (+ (expt 2.0 62) 513))
 *   4611686018427388928
 *
 * another case at the edge: (round 9007199254740992.51) -> 9007199254740992
 *
 * This spells trouble for normal arithmetic in this range.  If no gmp,
 *    (- (+ (expt 2.0 62) 512) (+ (expt 2.0 62) 513)) = -1024.0 (should be -1.0)
 *    but we don't currently give an error in this case -- not sure what the right thing is.
 */


#if __cplusplus
  using namespace std;
  typedef complex<s7_Double> s7_Complex;
  static s7_Double Real(complex<s7_Double> x) {return(real(x));} /* protect the C++ name */
  static s7_Double Imag(complex<s7_Double> x) {return(imag(x));}
#endif

#define real(n)                       n.value.real_value


static int safe_strlen(const char *str)
{
  /* this is safer than strlen, and slightly faster */
  char *tmp = (char *)str;
  if (!tmp) return(0);
  while (*tmp++) {};
  return(tmp - str - 1);
}


static char *copy_string_with_len(const char *str, int len)
{
  char *newstr;
  newstr = (char *)malloc((len + 1) * sizeof(char));
  if (len != 0)
    memcpy((void *)newstr, (void *)str, len + 1);
  else newstr[0] = 0;
  return(newstr);
}


static char *copy_string(const char *str)
{
  return(copy_string_with_len(str, safe_strlen(str)));
}


#define strings_are_equal(Str1, Str2) (strcmp(Str1, Str2) == 0)
/* newlib code here was slower -- this should only be used for internal strings -- scheme
 *   strings can have embedded nulls.
 */

#define scheme_strings_are_equal(Str1, Str2) (scheme_strcmp(Str1, Str2) == 0)
/* here Str1 and Str2 are s7_pointers
 */


static int safe_strcmp(const char *s1, const char *s2)
{
  int val;
  if (s1 == NULL)
    {
      if (s2 == NULL)
	return(0);
      return(-1);
    }
  if (s2 == NULL)
    return(1);

  val = strcmp(s1, s2); /* strcmp can return stuff like -97, but we want -1, 0, or 1 */

  if (val <= -1)
    return(-1);
  if (val >= 1)
    return(1);
  return(val);
}


static bool is_proper_list(s7_scheme *sc, s7_pointer lst);
static void mark_embedded_objects(s7_pointer a); /* called by gc, calls fobj's mark func */
static s7_pointer eval(s7_scheme *sc, opcode_t first_op);
static s7_pointer division_by_zero_error(s7_scheme *sc, const char *caller, s7_pointer arg);
static s7_pointer file_error(s7_scheme *sc, const char *caller, const char *descr, const char *name);
static s7_pointer safe_reverse_in_place(s7_scheme *sc, s7_pointer list);
static s7_pointer cons_unchecked(s7_scheme *sc, s7_pointer a, s7_pointer b);
static s7_pointer permanent_cons(s7_pointer a, s7_pointer b, int type);
static void free_object(s7_pointer a);
static char *object_print(s7_scheme *sc, s7_pointer a);
static s7_pointer make_atom(s7_scheme *sc, char *q, int radix, bool want_symbol);
static bool object_is_applicable(s7_pointer x);
static void write_string(s7_scheme *sc, const char *s, s7_pointer pt);
static s7_pointer eval_symbol(s7_scheme *sc, s7_pointer sym);
static s7_pointer eval_error(s7_scheme *sc, const char *errmsg, s7_pointer obj);
static s7_pointer apply_error(s7_scheme *sc, s7_pointer obj, s7_pointer args);
static bool is_thunk(s7_scheme *sc, s7_pointer x);
static int remember_file_name(s7_scheme *sc, const char *file);
static const char *type_name(s7_pointer arg);
static s7_pointer make_string_uncopied(s7_scheme *sc, char *str);
static s7_pointer make_protected_string(s7_scheme *sc, const char *str);
static s7_pointer s7_copy(s7_scheme *sc, s7_pointer obj);
static s7_pointer splice_in_values(s7_scheme *sc, s7_pointer args);
static s7_pointer vector_copy(s7_scheme *sc, s7_pointer old_vect);
static void pop_input_port(s7_scheme *sc);
static bool s7_is_negative(s7_pointer obj);
static bool s7_is_positive(s7_pointer obj);
static s7_pointer apply_list_star(s7_scheme *sc, s7_pointer d);
static bool args_match(s7_scheme *sc, s7_pointer x, int args);
static s7_pointer read_error(s7_scheme *sc, const char *errmsg);
static s7_pointer object_to_vector(s7_scheme *sc, s7_pointer obj);
static char *object_to_truncated_string(s7_scheme *sc, s7_pointer p);

static bool tracing, trace_all;

#if WITH_OPTIMIZATION
static bool body_is_safe(s7_scheme *sc, s7_pointer body);
#endif




/* -------------------------------- constants -------------------------------- */

s7_pointer s7_f(s7_scheme *sc) 
{
  return(sc->F);
}


s7_pointer s7_t(s7_scheme *sc) 
{
  return(sc->T);
}


s7_pointer s7_nil(s7_scheme *sc) 
{
  return(sc->NIL);
}


s7_pointer s7_undefined(s7_scheme *sc) 
{
  return(sc->UNDEFINED);
}


s7_pointer s7_unspecified(s7_scheme *sc) 
{
  return(sc->UNSPECIFIED);
}


bool s7_is_unspecified(s7_scheme *sc, s7_pointer val)
{
  return((is_unspecified(val)) || (val == sc->NO_VALUE));
}


s7_pointer s7_eof_object(s7_scheme *sc)          /* returns #<eof> -- not equivalent to "eof-object?" */
{
  return(sc->EOF_OBJECT);
}


static s7_pointer g_not(s7_scheme *sc, s7_pointer args)
{
  #define H_not "(not obj) returns #t if obj is #f, otherwise #t: (not '()) -> #f"
  return(make_boolean(sc, is_false(sc, car(args))));
}


bool s7_boolean(s7_scheme *sc, s7_pointer x)
{
  return(x != sc->F);
}


bool s7_is_boolean(s7_pointer x)
{
  return(type(x) == T_BOOLEAN);
}


s7_pointer s7_make_boolean(s7_scheme *sc, bool x)
{
  return(make_boolean(sc, x));
}


static s7_pointer g_is_boolean(s7_scheme *sc, s7_pointer args)
{
  #define H_is_boolean "(boolean? obj) returns #t if obj is #f or #t: (boolean? '()) -> #f"
  return(s7_make_boolean(sc, s7_is_boolean(car(args))));
}


bool s7_is_constant(s7_pointer p) 
{ 
  /* this means "always evaluates to the same thing", sort of
   *   not "evaluates to itself":
   *   (let ((x 'x)) (and (not (constant? x)) (equal? x (eval x))))
   *   (and (constant? (list + 1)) (not (equal? (list + 1) (eval (list + 1)))))
   */
  return((type(p) != T_SYMBOL) ||
	 ((typeflag(p) & (T_KEYWORD | T_IMMUTABLE)) != 0));
}


static s7_pointer g_is_constant(s7_scheme *sc, s7_pointer args)
{
  #define H_is_constant "(constant? obj) returns #t if obj is a constant (unsettable): (constant? pi) -> #t"
  return(s7_make_boolean(sc, s7_is_constant(car(args))));
}




/* -------------------------------- GC -------------------------------- */

#define is_gc_nil(p) ((p) == sc->GC_NIL)

int s7_gc_protect(s7_scheme *sc, s7_pointer x)
{
  unsigned int i, loc, size, new_size;

  loc = sc->protected_objects_loc++;
  size = sc->protected_objects_size;

  if (sc->protected_objects_loc >= size)
    sc->protected_objects_loc = 0;

  if (is_gc_nil(vector_element(sc->protected_objects, loc)))
    {
      vector_element(sc->protected_objects, loc) = x;
      return(loc);
    }
  
  for (i = 0; i < size; i++)
    {
      if (is_gc_nil(vector_element(sc->protected_objects, i)))
	{
	  vector_element(sc->protected_objects, i) = x;
	  return(i);
	}
    }
  
  new_size = 2 * size;
  vector_elements(sc->protected_objects) = (s7_pointer *)realloc(vector_elements(sc->protected_objects), new_size * sizeof(s7_pointer));
  for (i = size; i < new_size; i++)
    vector_element(sc->protected_objects, i) = sc->GC_NIL;
  vector_length(sc->protected_objects) = new_size;
  sc->protected_objects_size = new_size;
  sc->protected_objects_loc = size + 1;

  vector_element(sc->protected_objects, size) = x;
  return(size);
}


void s7_gc_unprotect(s7_scheme *sc, s7_pointer x)
{
  unsigned int i;

  for (i = 0; i < sc->protected_objects_size; i++)
    if (vector_element(sc->protected_objects, i) == x)
      {
	vector_element(sc->protected_objects, i) = sc->GC_NIL;
	sc->protected_objects_loc = i;
	return;
      }
}


void s7_gc_unprotect_at(s7_scheme *sc, int loc)
{
  if ((loc >= 0) &&
      (loc < (int)sc->protected_objects_size))
    {
      vector_element(sc->protected_objects, loc) = sc->GC_NIL;
      sc->protected_objects_loc = loc;
    }
}


s7_pointer s7_gc_protected_at(s7_scheme *sc, int loc)
{
  s7_pointer obj;

  obj = sc->UNSPECIFIED;
  if ((loc >= 0) &&
      (loc < (int)sc->protected_objects_size))
    obj = vector_element(sc->protected_objects, loc);

  if (obj == sc->GC_NIL)
    return(sc->UNSPECIFIED);

  return(obj);
}


static void sweep(s7_scheme *sc)
{
  int i, j;
  if (sc->strings_loc > 0)
    {
      for (i = 0, j = 0; i < sc->strings_loc; i++)
	{
	  if (type(sc->strings[i]) == 0)
	    free(string_value(sc->strings[i]));
	  else sc->strings[j++] = sc->strings[i];
	}
      sc->strings_loc = j;
    }

  if (sc->c_objects_loc > 0)
    {
      for (i = 0, j = 0; i < sc->c_objects_loc; i++)
	{
	  if (type(sc->c_objects[i]) == 0)
	    free_object(sc->c_objects[i]);
	  else sc->c_objects[j++] = sc->c_objects[i];
	}
      sc->c_objects_loc = j;
    }

  if (sc->vectors_loc > 0)
    {
      for (i = 0, j = 0; i < sc->vectors_loc; i++)
	{
	  if (type(sc->vectors[i]) == 0)
	    {
	      s7_pointer a;
	      a = sc->vectors[i];
	      if (vector_length(a) > 0)
		{
		  if (vector_is_multidimensional(a))
		    {
		      if (shared_vector(a) == sc->F)
			{
			  free(a->object.vector.vextra.dim_info->dims);
			  free(a->object.vector.vextra.dim_info->offsets);
			  free(vector_elements(a));
			}
		      free(a->object.vector.vextra.dim_info);
		    }
		  else 
		    {
		      free(vector_elements(a));
		    }
		}
	    }
	  else sc->vectors[j++] = sc->vectors[i];
	}
      sc->vectors_loc = j;
    }

  if (sc->hash_tables_loc > 0)
    {
      for (i = 0, j = 0; i < sc->hash_tables_loc; i++)
	{
	  if (type(sc->hash_tables[i]) == 0)
	    {
	      if (hash_table_length(sc->hash_tables[i]) > 0)
		free(hash_table_elements(sc->hash_tables[i]));
	    }
	  else sc->hash_tables[j++] = sc->hash_tables[i];
	}
      sc->hash_tables_loc = j;
    }

  if (sc->input_ports_loc > 0)
    {
      for (i = 0, j = 0; i < sc->input_ports_loc; i++)
	{
	  if (type(sc->input_ports[i]) == 0)
	    {
	      s7_pointer a;
	      a = sc->input_ports[i];
	      if (port_needs_free(a))
		{
		  if (port_string(a))
		    {
		      free(port_string(a));
		      port_string(a) = NULL;
		    }
		  port_needs_free(a) = false;
		}
	      
	      if (port_filename(a))
		{
		  free(port_filename(a));
		  port_filename(a) = NULL;
		}
	      
	      free(a->object.port);
	      
	    }
	  else sc->input_ports[j++] = sc->input_ports[i];
	}
      sc->input_ports_loc = j;
    }

  if (sc->output_ports_loc > 0)
    {
      for (i = 0, j = 0; i < sc->output_ports_loc; i++)
	{
	  if (type(sc->output_ports[i]) == 0)
	    {
	      s7_close_output_port(sc, sc->output_ports[i]);
	      free(sc->output_ports[i]->object.port);
	    }
	  else sc->output_ports[j++] = sc->output_ports[i];
	}
      sc->output_ports_loc = j;
    }

  if (sc->continuations_loc > 0)
    {
      for (i = 0, j = 0; i < sc->continuations_loc; i++)
	{
	  if (type(sc->continuations[i]) == 0)
	    {
	      free(continuation(sc->continuations[i]));
	    }
	  else sc->continuations[j++] = sc->continuations[i];
	}
      sc->continuations_loc = j;
    }
}


static void add_string(s7_scheme *sc, s7_pointer p)
{
  if (sc->strings_loc == sc->strings_size)
    {
      sc->strings_size *= 2;
      sc->strings = (s7_pointer *)realloc(sc->strings, sc->strings_size * sizeof(s7_pointer));
    }
  sc->strings[sc->strings_loc++] = p;
}


static void add_c_object(s7_scheme *sc, s7_pointer p)
{
  if (sc->c_objects_loc == sc->c_objects_size)
    {
      sc->c_objects_size *= 2;
      sc->c_objects = (s7_pointer *)realloc(sc->c_objects, sc->c_objects_size * sizeof(s7_pointer));
    }
  sc->c_objects[sc->c_objects_loc++] = p;
}


static void add_hash_table(s7_scheme *sc, s7_pointer p)
{
  if (sc->hash_tables_loc == sc->hash_tables_size)
    {
      sc->hash_tables_size *= 2;
      sc->hash_tables = (s7_pointer *)realloc(sc->hash_tables, sc->hash_tables_size * sizeof(s7_pointer));
    }
  sc->hash_tables[sc->hash_tables_loc++] = p;
}


static void add_vector(s7_scheme *sc, s7_pointer p)
{
  if (sc->vectors_loc == sc->vectors_size)
    {
      sc->vectors_size *= 2;
      sc->vectors = (s7_pointer *)realloc(sc->vectors, sc->vectors_size * sizeof(s7_pointer));
    }
  sc->vectors[sc->vectors_loc++] = p;
}


static void add_input_port(s7_scheme *sc, s7_pointer p)
{
  if (sc->input_ports_loc == sc->input_ports_size)
    {
      sc->input_ports_size *= 2;
      sc->input_ports = (s7_pointer *)realloc(sc->input_ports, sc->input_ports_size * sizeof(s7_pointer));
    }
  sc->input_ports[sc->input_ports_loc++] = p;
}


static void add_output_port(s7_scheme *sc, s7_pointer p)
{
  if (sc->output_ports_loc == sc->output_ports_size)
    {
      sc->output_ports_size *= 2;
      sc->output_ports = (s7_pointer *)realloc(sc->output_ports, sc->output_ports_size * sizeof(s7_pointer));
    }
  sc->output_ports[sc->output_ports_loc++] = p;
}


static void add_continuation(s7_scheme *sc, s7_pointer p)
{
  if (sc->continuations_loc == sc->continuations_size)
    {
      sc->continuations_size *= 2;
      sc->continuations = (s7_pointer *)realloc(sc->continuations, sc->continuations_size * sizeof(s7_pointer));
    }
  sc->continuations[sc->continuations_loc++] = p;
}


#define INIT_GC_CACHE_SIZE 512
static void init_gc_caches(s7_scheme *sc)
{
  sc->strings_size = INIT_GC_CACHE_SIZE;
  sc->strings_loc = 0;
  sc->strings = (s7_pointer *)malloc(sc->strings_size * sizeof(s7_pointer));
  sc->vectors_size = INIT_GC_CACHE_SIZE;
  sc->vectors_loc = 0;
  sc->vectors = (s7_pointer *)malloc(sc->vectors_size * sizeof(s7_pointer));
  sc->hash_tables_size = INIT_GC_CACHE_SIZE;
  sc->hash_tables_loc = 0;
  sc->hash_tables = (s7_pointer *)malloc(sc->hash_tables_size * sizeof(s7_pointer));
  sc->input_ports_size = INIT_GC_CACHE_SIZE;
  sc->input_ports_loc = 0;
  sc->input_ports = (s7_pointer *)malloc(sc->input_ports_size * sizeof(s7_pointer));
  sc->output_ports_size = INIT_GC_CACHE_SIZE;
  sc->output_ports_loc = 0;
  sc->output_ports = (s7_pointer *)malloc(sc->output_ports_size * sizeof(s7_pointer));
  sc->continuations_size = INIT_GC_CACHE_SIZE;
  sc->continuations_loc = 0;
  sc->continuations = (s7_pointer *)malloc(sc->continuations_size * sizeof(s7_pointer));
  sc->c_objects_size = INIT_GC_CACHE_SIZE;
  sc->c_objects_loc = 0;
  sc->c_objects = (s7_pointer *)malloc(sc->c_objects_size * sizeof(s7_pointer));
}


static void (*mark_function[BUILT_IN_TYPES])(s7_pointer p);
#define S7_MARK(Obj) do {s7_pointer _p_; _p_ = Obj; (*mark_function[type(_p_)])(_p_);} while (0)

static void mark_vector_1(s7_pointer p, s7_Int top)
{
  s7_pointer *tp, *tend;

  set_mark(p);

  tp = (s7_pointer *)(vector_elements(p));
  if (!tp) return;
  tend = (s7_pointer *)(tp + top);
  
  if ((top % 8) == 0)
    {
      while (tp < tend) 
	{
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	  S7_MARK(*tp++);
	}
    }
  else
    {
      while (tp < tend) 
	S7_MARK(*tp++);
    }
}


static void mark_environment(s7_pointer env)
{
  s7_pointer x;
  for (x = env; is_environment(x) && (!is_marked(x)); x = cdr(x)) 
    { 
      s7_pointer y;
      for (y = car(x); is_pair(y); y = ecdr(y))
	if (!is_marked(y)) /* we know it's a pair, and its car is a symbol */
	  {
	    set_mark(y);
	    S7_MARK(cdr(y));
	  }
      set_mark(x); /* we handle car above, and cdr in the loop */
    }
}


static void just_mark(s7_pointer p)
{
  set_mark(p);
}

static void mark_noop(s7_pointer p)
{
}

static void mark_pair(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      set_mark(p);
      S7_MARK(car(p));
      S7_MARK(cdr(p));
    }
}

static void mark_closure(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      set_mark(p);
      S7_MARK(closure_source(p));
      mark_environment(closure_environment(p));
    }
}

static void mark_stack(s7_pointer p)
{
}

static void mark_stack_1(s7_pointer p, s7_Int top)
{
  s7_pointer *tp, *tend;

  set_mark(p);

  tp = (s7_pointer *)(vector_elements(p));
  if (!tp) return;
  tend = (s7_pointer *)(tp + top);
  
  while (tp < tend) 
    {
      S7_MARK(*tp++);
      S7_MARK(*tp++);
      S7_MARK(*tp++);
      tp++;
    }
}



static void mark_continuation(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      unsigned int i;
      set_mark(p);
      mark_stack_1(continuation_stack(p), continuation_stack_top(p));
      for (i = 0; i < continuation_op_loc(p); i++)
	S7_MARK(continuation_op_stack(p)[i]);
    }
}

static void mark_vector(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      /* If a subvector (an inner dimension) of a vector is the only remaining reference
       *    to the main vector, we want to make sure the main vector is not GC'd until
       *    the subvector is also GC-able.  The shared_vector field either points to the
       *    parent vector, or it is sc->F, so we need to check for a vector parent if
       *    the current is multidimensional (this will include 1-dim slices).  We need
       *    to keep the parent case separate (i.e. sc->F means the current is the original)
       *    so that we only free once (or remove_from_heap once).
       */

      if ((vector_is_multidimensional(p)) &&
	  (s7_is_vector(shared_vector(p))))
	{
	  /* set_mark(shared_vector(p)); */
	  S7_MARK(shared_vector(p));
	}
      mark_vector_1(p, vector_length(p));
    }
}

static void mark_c_object(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      set_mark(p);
      mark_embedded_objects(p);
    }
}

static void mark_catch(s7_pointer p)
{
  if (!is_marked(p))
    {
      set_mark(p);
      S7_MARK(catch_tag(p));
      S7_MARK(catch_handler(p));
    }
}

static void mark_dynamic_wind(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      set_mark(p);
      S7_MARK(dynamic_wind_in(p));
      S7_MARK(dynamic_wind_out(p));
      S7_MARK(dynamic_wind_body(p));
    }
}

static void mark_hash_table(s7_pointer p)
{
  if (!is_marked(p))
    mark_vector_1(p, hash_table_length(p));
}

static void mark_hook(s7_pointer p)
{
  if (!is_marked(p)) 
    {
      set_mark(p);
      S7_MARK(hook_functions(p));
      S7_MARK(hook_arity(p));
      S7_MARK(hook_documentation(p));
    }
}


static void init_mark_functions(void)
{
  mark_function[T_UNTYPED]             = just_mark;
  mark_function[T_NIL]                 = mark_noop;
  mark_function[T_STRING]              = just_mark;
  mark_function[T_NUMBER]              = just_mark;
  mark_function[T_SYMBOL]              = mark_noop;
  mark_function[T_PAIR]                = mark_pair;
  mark_function[T_CLOSURE]             = mark_closure;
  mark_function[T_CLOSURE_STAR]        = mark_closure;
  mark_function[T_CONTINUATION]        = mark_continuation;
  mark_function[T_CHARACTER]           = mark_noop;
  mark_function[T_INPUT_PORT]          = just_mark;
  mark_function[T_VECTOR]              = mark_vector;
  mark_function[T_MACRO]               = mark_closure;
  mark_function[T_BACRO]               = mark_closure;
  mark_function[T_C_OBJECT]            = mark_c_object;
  mark_function[T_GOTO]                = just_mark;
  mark_function[T_OUTPUT_PORT]         = just_mark;
  mark_function[T_CATCH]               = mark_catch;
  mark_function[T_DYNAMIC_WIND]        = mark_dynamic_wind;
  mark_function[T_HASH_TABLE]          = mark_hash_table;
  mark_function[T_BOOLEAN]             = mark_noop;
  mark_function[T_SYNTAX]              = mark_noop;
  mark_function[T_HOOK]                = mark_hook;
  mark_function[T_ENVIRONMENT]         = mark_environment;
  mark_function[T_STACK]               = mark_stack;
  mark_function[T_COUNTER]             = mark_pair;
  mark_function[T_C_MACRO]             = just_mark;
  mark_function[T_C_POINTER]           = just_mark;
  mark_function[T_C_FUNCTION]          = just_mark;
  mark_function[T_C_ANY_ARGS_FUNCTION] = just_mark;
  mark_function[T_C_OPT_ARGS_FUNCTION] = just_mark;
  mark_function[T_C_RST_ARGS_FUNCTION] = just_mark;
  mark_function[T_C_LST_ARGS_FUNCTION] = just_mark;
}


static void mark_op_stack(s7_scheme *sc)
{
  s7_pointer *p, *tp;
  tp = sc->op_stack_now;
  p = sc->op_stack;
  while (p < tp)
    S7_MARK(*p++);
}


static void mark_global_env(s7_scheme *sc)
{
  s7_pointer ge;
  s7_pointer *tmp, *top;

  ge = sc->global_env;
  tmp = vector_elements(ge);
  top = (s7_pointer *)(tmp + vector_fill_pointer(ge));

  set_mark(ge);

  while (tmp < top)
    S7_MARK(cdr(*tmp++));
}


void s7_mark_object(s7_pointer p)
{
  S7_MARK(p);
}

#define GC_TRIGGER_SIZE 64


#if HAVE_GETTIMEOFDAY && (!_MSC_VER)
  #include <time.h>
  #include <sys/time.h>
  static struct timeval start_time;
  static struct timezone z0;
#endif

static int gc(s7_scheme *sc)
{
  s7_cell **old_free_heap_top;
  /* mark all live objects (the symbol table is in permanent memory, not the heap) */
  #define GC_CALL(P, Tp) p = (*tp++); if (is_marked(p)) clear_mark(p); else {if (typeflag(p) != 0) {typeflag(p) = 0; (*fp++) = p;}}

  if (sc->gc_stats)
    {
      fprintf(stdout, "gc ");
#if HAVE_GETTIMEOFDAY && (!_MSC_VER)
      gettimeofday(&start_time, &z0);
#endif
    }

  mark_global_env(sc);
  S7_MARK(sc->args);
  mark_environment(sc->envir);
  S7_MARK(sc->code);
  S7_MARK(sc->cur_code);
  mark_stack_1(sc->stack, s7_stack_top(sc));
  S7_MARK(sc->w);
  S7_MARK(sc->x);
  S7_MARK(sc->y);
  S7_MARK(sc->z);
  S7_MARK(sc->value);  

  S7_MARK(sc->temp1);
  S7_MARK(sc->temp2);
  S7_MARK(sc->temp3);

  set_mark(sc->input_port);
  S7_MARK(sc->input_port_stack);
  set_mark(sc->output_port);
  set_mark(sc->error_port);

  mark_pair(sc->TEMP_CELL_1);
  mark_pair(sc->TEMP_CELL_2);
  mark_pair(sc->TEMP_CELL_3);
  S7_MARK(car(sc->T1_1));
  S7_MARK(car(sc->T2_1));
  S7_MARK(car(sc->T2_2));
  S7_MARK(car(sc->T3_1));
  S7_MARK(car(sc->T3_2));
  S7_MARK(car(sc->T3_3));

  S7_MARK(sc->protected_objects);
  {
    s7_pointer *tmps, *tmps_top;
    tmps = sc->free_heap_top;
    tmps_top = tmps + GC_TEMPS_SIZE;
    if (tmps_top > (sc->free_heap + INITIAL_HEAP_SIZE))
      tmps_top = (s7_pointer *)(sc->free_heap + INITIAL_HEAP_SIZE);
    while (tmps < tmps_top)
      S7_MARK(*tmps++);
  }
  mark_op_stack(sc);

  /* free up all unmarked objects */
  old_free_heap_top = sc->free_heap_top;

  {
    s7_pointer *fp, *tp, *heap_top;
    fp = sc->free_heap_top;

    tp = sc->heap;
    heap_top = (s7_pointer *)(sc->heap + sc->heap_size);

    while (tp < heap_top)          /* != here or ^ makes no difference */
      {
	s7_pointer p;
	/* from here down is GC_CALL, but I wanted one case explicit for readability
	 */
	p = (*tp++);

	if (is_marked(p))          /* this order is faster than checking typeflag(p) != 0 first */
	  clear_mark(p);
	else 
	  {
	    if (typeflag(p) != 0) /* if 0, it's an already-free object -- the free_heap is usually not empty when we call the GC */
	      {
		typeflag(p) = 0;  /* (this is needed -- otherwise we try to free some objects twice) */
		(*fp++) = p;
	      }
	  }
	/* this looks crazy, but it speeds up the entire GC process by 25%!
	 *   going from 16 to 32 saves .2% so it may not matter.
	 */
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);

	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
	GC_CALL(p, tp);
      }

    sc->free_heap_top = fp;
    sweep(sc);
  }

  if (sc->gc_stats)
    {
#if HAVE_GETTIMEOFDAY && (!_MSC_VER)
      struct timeval t0;
      double secs;
      gettimeofday(&t0, &z0);
      secs = (t0.tv_sec - start_time.tv_sec) +  0.000001 * (t0.tv_usec - start_time.tv_usec);
      fprintf(stdout, "freed %d/%d, time: %f\n", (int)(sc->free_heap_top - old_free_heap_top), sc->heap_size, secs);
#else
      fprintf(stdout, "freed %d/%d\n", (int)(sc->free_heap_top - old_free_heap_top), sc->heap_size);
#endif
    }

  return(sc->free_heap_top - old_free_heap_top); /* needed by cell allocator to decide when to increase heap size */
}


#define WITH_DUMP_HEAP 0
#if WITH_DUMP_HEAP
static s7_pointer g_dump_heap(s7_scheme *sc, s7_pointer args)
{
  FILE *fd;
  s7_pointer *tp;
  int i;

  gc(sc);

  fd = fopen("heap.data", "w");
  for (tp = sc->heap; (*tp); tp++)
    {
      s7_pointer p;
      p = (*tp);
      if (typeflag(p) != 0)
	fprintf(fd, "%s\n", s7_object_to_c_string(sc, p));
    }

  fflush(fd);
  fclose(fd);
  return(sc->NIL);
}
#endif


#define NEW_CELL(Sc, Obj) \
  do {						\
    if (Sc->free_heap_top <= Sc->free_heap_trigger) try_to_call_gc(sc);	\
    Obj = (*(--(Sc->free_heap_top))); \
    } while (0)

#define NEW_CELL_NO_CHECK(Sc, Obj) do {Obj = (*(--(Sc->free_heap_top)));} while (0)
  /* since sc->free_heap_trigger is GC_TRIGGER_SIZE above the free heap base, we don't need
   *   to check it repeatedly after the 1st such check.
   */


static void try_to_call_gc(s7_scheme *sc)
{
  /* called only from NEW_CELL and cons */
  unsigned int freed_heap = 0;
  
  if (!(sc->gc_off))
    freed_heap = gc(sc);
  
  if (freed_heap < sc->heap_size / 4) /* was 1000, setting it to 2 made no difference in run time */
    {
      /* alloc more heap */
      unsigned int old_size;
      old_size = sc->heap_size;
      
      if (sc->heap_size < 512000)
	sc->heap_size *= 2;
      else sc->heap_size += 512000;
      
      sc->heap = (s7_cell **)realloc(sc->heap, sc->heap_size * sizeof(s7_cell *));
      if (!(sc->heap))
	fprintf(stderr, "heap reallocation failed! tried to get %lu bytes\n", (unsigned long)(sc->heap_size * sizeof(s7_cell *)));
      
      sc->free_heap = (s7_cell **)realloc(sc->free_heap, sc->heap_size * sizeof(s7_cell *));
      if (!(sc->free_heap))
	fprintf(stderr, "free heap reallocation failed! tried to get %lu bytes\n", (unsigned long)(sc->heap_size * sizeof(s7_cell *)));	  
      
      sc->free_heap_trigger = (s7_cell **)(sc->free_heap + GC_TRIGGER_SIZE);
      sc->free_heap_top = sc->free_heap;
      
      { 
	/* optimization suggested by K Matheussen */
	unsigned int k;
	s7_cell *cells = (s7_cell *)calloc(sc->heap_size - old_size, sizeof(s7_cell));
	for (k = old_size; k < sc->heap_size; k++)
	  {
	    sc->heap[k] = &cells[k - old_size];
	    (*sc->free_heap_top++) = sc->heap[k];
	    sc->heap[k]->hloc = k;
	  }
      }
    }
}

  /* originally I tried to mark each temporary value until I was done with it, but
   *   that way madness lies... By delaying GC of _every_ %$^#%@ pointer, I can dispense
   *   with hundreds of individual protections.  So the free_heap's last GC_TEMPS_SIZE
   *   allocated pointers are protected during the mark sweep.
   */


static s7_pointer g_gc(s7_scheme *sc, s7_pointer args)
{
  #define H_gc "(gc (on #t)) runs the garbage collector.  If 'on' is supplied, it turns the GC on or off. \
Evaluation produces a surprising amount of garbage, so don't leave the GC off for very long!"

  if (is_not_null(args))
    {
      if (!s7_is_boolean(car(args)))
	return(s7_wrong_type_arg_error(sc, "gc", 0, car(args), "#f (turn GC off) or #t (turn it on)"));	

      sc->gc_off = (car(args) == sc->F);
      if (sc->gc_off) return(sc->F);
    }

  gc(sc);
  return(sc->UNSPECIFIED);
}


s7_pointer s7_gc_on(s7_scheme *sc, bool on)
{
  sc->gc_off = !on;
  return(s7_make_boolean(sc, on));
}


static s7_pointer g_gc_stats_set(s7_scheme *sc, s7_pointer args)
{
  if (s7_is_boolean(cadr(args)))
    {
      sc->gc_stats = (cadr(args) != sc->F);      
      return(cadr(args));
    }
  return(sc->ERROR);
}


void s7_gc_stats(s7_scheme *sc, bool on)
{
  sc->gc_stats = on;
  s7_symbol_set_value(sc, s7_make_symbol(sc, "*gc-stats*"), make_boolean(sc, on));
}


static s7_pointer g_safety_set(s7_scheme *sc, s7_pointer args)
{
  if (s7_is_integer(cadr(args)))
    {
      sc->safety = s7_integer(cadr(args));
      return(cadr(args));
    }
  return(sc->ERROR);
}


static s7_pointer g_safety_bind(s7_scheme *sc, s7_pointer args)
{
  return(sc->ERROR);
}


#define NOT_IN_HEAP -1

void s7_remove_from_heap(s7_scheme *sc, s7_pointer x)
{
  int loc;
  /* global functions are very rarely redefined, so we can remove the function body from
   *   the heap when it is defined.  If redefined, we currently lose the memory held by the
   *   old definition.  (It is not trivial to recover this memory because it is allocated
   *   in blocks, not by the pointer, I think, but s7_define is the point to try).
   * 
   * There is at least one problem with this: if, for example, a function has
   *    a quoted (constant) list, then uses list-set! to change an element of it,
   *    then a GC happens, and the new element is GC'd because no one in the heap
   *    points to it, then we call the function again, and it tries to access
   *    that element.  I wonder if removal should be on a switch, so the user can
   *    choose a "safety" level.
   *
   *    (define (bad-idea)
   *      (let ((lst '(1 2 3))) ; or #(1 2 3) and vector-ref|set
   *        (let ((result (list-ref lst 1)))
   *          (list-set! lst 1 (* 2.0 16.6))
   *          (gc)
   *          result)))
   * 
   *     put that in a file, load it (to force removal), than call bad-idea a few times.
   * so... if *safety* is not 0, remove-from-heap is disabled.
   */

  /* (catch #t (lambda () (set! *safety* "hi")) (lambda args args)) */

  if (is_pending_removal(x)) return;
  set_pending_removal(x);

  /* the procedure body being removed can be circular, so we need this bit to warn us
   *   that we've already seen this node.  We have to go out to the leaves and remove
   *   nodes in reverse order because the GC might be called while we're at it.  The
   *   top node is globally accessible, so the GC will not move anything if we work
   *   backwards.  But working backwards means we have to watch out for circles explicitly.
   *   The bit is unset later since the caller might change a removed procedure's body
   *   directly, and we want the subsequent redefinition to see anything new in the
   *   otherwise removed nodes. 
   */

  switch (type(x))
    {
    case T_PAIR:
      s7_remove_from_heap(sc, car(x));
      s7_remove_from_heap(sc, cdr(x));
      break;

    case T_UNTYPED:
    case T_NIL:
    case T_BOOLEAN:
      return;
      /* not break! */

    case T_STRING:
    case T_NUMBER:
    case T_CHARACTER:
    case T_C_OBJECT:
    case T_C_OPT_ARGS_FUNCTION:
    case T_C_RST_ARGS_FUNCTION:
    case T_C_LST_ARGS_FUNCTION:
    case T_C_ANY_ARGS_FUNCTION:
    case T_C_FUNCTION:
    case T_C_MACRO:
    case T_C_POINTER:
    case T_HOOK:
    case T_COUNTER:
    case T_ENVIRONMENT:
      break;

    case T_SYMBOL:
    case T_SYNTAX:
      /* here hloc is usually NOT_IN_HEAP, but in the syntax case can be the syntax op code */
      return;

    case T_CLOSURE:
    case T_CLOSURE_STAR:
    case T_MACRO:
    case T_BACRO:
      s7_remove_from_heap(sc, closure_source(x));
      break;

      /* not sure any of these can exist as code-level constants */
    case T_CONTINUATION:
    case T_GOTO:
    case T_INPUT_PORT:
    case T_OUTPUT_PORT:
    case T_CATCH:
    case T_DYNAMIC_WIND:
      break;

    case T_HASH_TABLE:
      {
	s7_Int i;
	for (i = 0; i < hash_table_length(x); i++)
	  if (is_not_null(hash_table_elements(x)[i]))
	    s7_remove_from_heap(sc, hash_table_elements(x)[i]);
      }
      break;

    case T_VECTOR:
      {
	s7_Int i;
	if ((!vector_is_multidimensional(x)) ||
	    (shared_vector(x) == sc->F))
	  {
	    for (i = 0; i < vector_length(x); i++)
	      s7_remove_from_heap(sc, vector_element(x, i));
	  }
      }
      break;
    }

  clear_pending_removal(x);
  loc = x->hloc;
  if (loc != NOT_IN_HEAP)
    {
      x->hloc = NOT_IN_HEAP;
      sc->heap[loc] = (s7_cell *)calloc(1, sizeof(s7_cell));
      (*sc->free_heap_top++) = sc->heap[loc];
      sc->heap[loc]->hloc = loc;
    }
}


/* permanent memory for objects that we know will not (normally) be deallocated */

#define PERMANENT_HEAP_SIZE 65536
static unsigned char *permanent_heap = NULL, *permanent_heap_top = NULL;

static unsigned char *permanent_calloc(int bytes)
{
  unsigned char *cur;
  if (bytes >= PERMANENT_HEAP_SIZE)
    {
      /* this actually can happen!  I wrote a file unwittingly that had gmp's output from (ash 1 92233720360)
       *   or some big number like that -- 16 million digits.  During a subsequent load, s7 decided it was a 
       *   symbol name(!) and tried to store it permanently in the symbol table.  segfault.
       */
      return((unsigned char *)calloc(bytes, sizeof(unsigned char)));
    }
  if ((permanent_heap + bytes) >= permanent_heap_top)
    {
      permanent_heap = (unsigned char *)calloc(PERMANENT_HEAP_SIZE, sizeof(unsigned char));
      permanent_heap_top = (unsigned char *)(permanent_heap + PERMANENT_HEAP_SIZE);
    }
  cur = permanent_heap;
  permanent_heap += bytes;
  return(cur);
}




/* -------------------------------- stacks -------------------------------- */

#define OP_STACK_INITIAL_SIZE 1024
#define push_op_stack(Sc, Op) (*Sc->op_stack_now++) = Op
#define pop_op_stack(Sc)      (*(--(Sc->op_stack_now)))

static void initialize_op_stack(s7_scheme *sc)
{
  int i;
  sc->op_stack = (s7_pointer *)malloc(OP_STACK_INITIAL_SIZE * sizeof(s7_pointer));
  sc->op_stack_size = OP_STACK_INITIAL_SIZE;
  sc->op_stack_now = sc->op_stack;
  sc->op_stack_end = (s7_pointer *)(sc->op_stack + sc->op_stack_size);
  for (i = 0; i < OP_STACK_INITIAL_SIZE; i++)
    sc->op_stack[i] = sc->NIL;
}


static void resize_op_stack(s7_scheme *sc)
{
  int i, loc, new_size;
  loc = (int)(sc->op_stack_now - sc->op_stack);
  new_size = sc->op_stack_size * 2;
  sc->op_stack = (s7_pointer *)realloc((void *)(sc->op_stack), new_size * sizeof(s7_pointer));
  for (i = sc->op_stack_size; i < new_size; i++)
    sc->op_stack[i] = sc->NIL;
  sc->op_stack_size = new_size;
  sc->op_stack_now = (s7_pointer *)(sc->op_stack + loc);
  sc->op_stack_end = (s7_pointer *)(sc->op_stack + sc->op_stack_size);
}


static void stack_reset(s7_scheme *sc) 
{ 
  sc->stack_end = sc->stack_start;
} 


#define stack_code(Stack, Loc)        vector_element(Stack, Loc - 3)
#define stack_environment(Stack, Loc) vector_element(Stack, Loc - 2)
#define stack_args(Stack, Loc)        vector_element(Stack, Loc - 1)
#define stack_op(Stack, Loc)          ((opcode_t)(vector_element(Stack, Loc)))


static void pop_stack(s7_scheme *sc) 
{ 
  /* avoid "if..then" here and in push_stack -- these 2 are called a zillion times 
   *   using pointer decrements here is much slower
   */
  sc->stack_end -= 4;
  sc->op =    (opcode_t)(sc->stack_end[3]);
  sc->args =  sc->stack_end[2];
  sc->envir = sc->stack_end[1];
  sc->code =  sc->stack_end[0];
} 


static void push_stack(s7_scheme *sc, opcode_t op, s7_pointer args, s7_pointer code)
{ 
  sc->stack_end[0] = code;
  sc->stack_end[1] = sc->envir;
  sc->stack_end[2] = args;
  sc->stack_end[3] = (s7_pointer)op;
  sc->stack_end += 4;
}


static void increase_stack_size(s7_scheme *sc)
{
  int i, new_size, loc;

  loc = s7_stack_top(sc);
  new_size = sc->stack_size * 2;

  vector_elements(sc->stack) = (s7_pointer *)realloc(vector_elements(sc->stack), new_size * sizeof(s7_pointer));
  for (i = sc->stack_size; i < new_size; i++)
    vector_element(sc->stack, i) = sc->NIL;
  vector_length(sc->stack) = new_size;
  sc->stack_size = new_size;

  sc->stack_start = vector_elements(sc->stack);
  sc->stack_end = (s7_pointer *)(sc->stack_start + loc);
  sc->stack_resize_trigger = (s7_pointer *)(sc->stack_start + sc->stack_size / 2);
} 


static s7_pointer g_stack_size(s7_scheme *sc, s7_pointer args)
{
  return(s7_make_integer(sc, (sc->stack_end - sc->stack_start) / 4));
}




/* -------------------------------- symbols -------------------------------- */

#define HASH_MULT 4

static int symbol_table_hash(const char *key, unsigned int *loc) 
{ 
  unsigned int hashed = 0;
  const char *c; 
  for (c = key; *c; c++) 
    hashed = *c + hashed * HASH_MULT;
  if (loc) (*loc) = hashed;
  return(hashed % SYMBOL_TABLE_SIZE); 

  /* using ints here is much faster, and the symbol table will not be enormous, so it's worth splitting out this case */

  /* chain lengths (after s7test using mult=37): 
   *   all chars: 43 159 329 441 395 349 217 152 69 35 12 4 1 0 0 1          max: 15
   *    4 chars: 572 528 307 183 128 90 50 48 41 35 34 23 21 ...             max: 182!
   *    8 chars: 114 307 404 411 301 197 146 98 77 35 28 18 11 16 ...        max: 79
   *    16 chars: 44 160 344 400 435 348 206 143 72 31 16 4 0 1 0 0 0 2 1... max: 18
   *
   * currently the hash calculation is ca 8 (s7test) and the find_by_name process 3,
   *   if we use 4 chars, this calc goes to 6/7 but the find calc to 8/9
   *
   * the multiplier (4 currently) doesn't matter:
   *   mult  1: 1744
   *         2: 1743
   *         3: 1743
   *         7: 1744
   *         8: 1743
   *        16: 1745
   *        17: 1746
   *        32: 1746
   *        37: 1744
   *        39: 1744
   */
} 


static s7_pointer new_symbol(s7_scheme *sc, const char *name, int location) 
{ 
  s7_pointer x, str; 
  
  str = s7_make_permanent_string(name);

  /* x = permanent_cons(str, sc->NIL, T_SYMBOL | T_DONT_COPY); */
  x = (s7_cell *)permanent_calloc(sizeof(s7_extended_cell));
  x->hloc = NOT_IN_HEAP;
  car(x) = str;
  cdr(x) = sc->NIL;
  set_type(x, T_SYMBOL | T_DONT_COPY);

  symbol_global_slot(x) = sc->NIL;
  symbol_id(x) = 0;
  symbol_accessor(x) = -1;

  if ((symbol_name_length(x) > 1) &&                           /* not 0, otherwise : is a keyword */
      ((name[0] == ':') ||
       (name[symbol_name_length(x) - 1] == ':')))
    typeflag(x) |= (T_IMMUTABLE | T_KEYWORD); 

  vector_element(sc->symbol_table, location) = permanent_cons(x, vector_element(sc->symbol_table, location), 
							      T_PAIR | T_IMMUTABLE | T_DONT_COPY);
  return(x); 
} 


static s7_pointer symbol_table_find_by_name(s7_scheme *sc, const char *name, int location) 
{ 
  s7_pointer x; 
  for (x = vector_element(sc->symbol_table, location); is_not_null(x); x = cdr(x)) 
    { 
      const char *s; 
      s = symbol_name(car(x)); 
      if ((s) && (*s == *name) && (strings_are_equal(name, s)))
	return(car(x)); 
    }
  return(sc->NIL); 
} 


static s7_pointer g_symbol_table(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_table "(symbol-table) returns the s7 symbol table (a vector)"
  return(vector_copy(sc, sc->symbol_table));
}


void s7_for_each_symbol_name(s7_scheme *sc, bool (*symbol_func)(const char *symbol_name, void *data), void *data)
{
  int i; 
  s7_pointer x; 

  for (i = 0; i < vector_length(sc->symbol_table); i++) 
    for (x  = vector_element(sc->symbol_table, i); is_not_null(x); x = cdr(x)) 
      if (symbol_func(symbol_name(car(x)), data))
	return;
}


void s7_for_each_symbol(s7_scheme *sc, bool (*symbol_func)(const char *symbol_name, s7_pointer value, void *data), void *data)
{
  int i; 
  s7_pointer x; 

  for (i = 0; i < vector_length(sc->symbol_table); i++) 
    for (x  = vector_element(sc->symbol_table, i); is_not_null(x); x = cdr(x)) 
      if (symbol_func(symbol_name(car(x)), cdr(x), data))
	return;
}

/* (for-each
   (lambda (lst)
      (for-each
         (lambda (sym)
            (format #t "~A ~S~%" sym (symbol->value sym)))
         lst))
   (symbol-table))
   
   at normal motif-snd startup there are 5699 globals (2583 of them constant), and 411 other undefined symbols
*/


static s7_pointer g_symbol_table_is_locked(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_table_is_locked "set (-s7-symbol-table-locked?) to #t to prohibit the creation of any new symbols"
  return(make_boolean(sc, sc->symbol_table_is_locked));
}


static s7_pointer g_set_symbol_table_is_locked(s7_scheme *sc, s7_pointer args)
{
  sc->symbol_table_is_locked = (car(args) != sc->F);
  return(car(args));
}


static s7_pointer make_symbol(s7_scheme *sc, const char *name) 
{
  s7_pointer x; 
  int location;
  unsigned int loc = 0;

  location = symbol_table_hash(name, &loc); 
  x = symbol_table_find_by_name(sc, name, location); 
  if (is_not_null(x)) 
    return(x); 

  if (sc->symbol_table_is_locked)
    return(s7_error(sc, sc->ERROR, sc->NIL));

  x = new_symbol(sc, name, location); 
  symbol_hash(x) = loc;
  return(x);
} 


s7_pointer s7_make_symbol(s7_scheme *sc, const char *name) 
{ 
  if (!name) return(sc->F);
  return(make_symbol(sc, name));
}


s7_pointer s7_gensym(s7_scheme *sc, const char *prefix)
{ 
  char *name;
  int len, location;
  s7_pointer x;
  unsigned int loc = 0;
  
  len = safe_strlen(prefix) + 32;
  name = (char *)calloc(len, sizeof(char));
  
  for (; sc->gensym_counter < S7_LONG_MAX; ) 
    { 
      snprintf(name, len, "{%s}-%d", prefix, sc->gensym_counter++); 
      location = symbol_table_hash(name, &loc); 
      x = symbol_table_find_by_name(sc, name, location); 
      if (is_not_null(x))
	{
	  if (s7_symbol_value(sc, x) != sc->UNDEFINED)
	    continue; 
	  free(name);
	  return(x); 
	}
      
      x = new_symbol(sc, name, location); 
      symbol_hash(x) = loc;
      free(name);
      return(x); 
    } 
  free(name);
  return(sc->NIL); 
} 


static s7_pointer g_gensym(s7_scheme *sc, s7_pointer args) 
{
  #define H_gensym "(gensym (prefix \"gensym\")) returns a new, unused symbol"
  if (is_not_null(args))
    {
      if (!s7_is_string(car(args)))
	return(s7_wrong_type_arg_error(sc, "gensym prefix,", 0, car(args), "a string"));
      return(s7_gensym(sc, string_value(car(args))));
    }
  return(s7_gensym(sc, "gensym"));
}


s7_pointer s7_name_to_value(s7_scheme *sc, const char *name)
{
  return(s7_symbol_value(sc, make_symbol(sc, name)));
}


bool s7_is_symbol(s7_pointer p)   
{ 
  return(type(p) == T_SYMBOL);
}


static s7_pointer g_is_symbol(s7_scheme *sc, s7_pointer args)
{
  #define H_is_symbol "(symbol? obj) returns #t if obj is a symbol"
  return(make_boolean(sc, s7_is_symbol(car(args))));
}


const char *s7_symbol_name(s7_pointer p)   
{ 
  return(symbol_name(p));
}


static s7_pointer g_symbol_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_to_string "(symbol->string sym) returns the symbol sym converted to a string"
  s7_pointer sym;

  sym = car(args);
  if (!s7_is_symbol(sym))
    return(s7_wrong_type_arg_error(sc, "symbol->string", 0, sym, "a symbol"));
  
  /* s7_make_string uses strlen which stops at an embedded null
   */
  return(s7_make_string_with_length(sc, symbol_name(sym), symbol_name_length(sym)));    /* return a copy */
}


static s7_pointer g_string_to_symbol_1(s7_scheme *sc, s7_pointer args, const char *caller)
{
  s7_pointer str;
  str = car(args);

  if (!s7_is_string(str))
    return(s7_wrong_type_arg_error(sc, caller, 0, str, "a string"));

  /* currently if the string has an embedded null, it marks the end of the new symbol name.
   *   I wonder if this is a bug...
   */
  return(make_symbol(sc, string_value(str)));
}


static s7_pointer g_string_to_symbol(s7_scheme *sc, s7_pointer args)
{
  #define H_string_to_symbol "(string->symbol str) returns the string str converted to a symbol"
  return(g_string_to_symbol_1(sc, args, "string->symbol"));
}


static s7_pointer g_symbol(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol "(symbol str) returns the string str converted to a symbol"
  return(g_string_to_symbol_1(sc, args, "symbol"));
}





/* -------------------------------- environments -------------------------------- */

static unsigned long long int frame_number = 0;

#define NEW_FRAME(Sc, Old_Env, New_Env)  \
  do {                                   \
      s7_pointer x;                      \
      NEW_CELL(Sc, x);                   \
      frame_id(x) = ++frame_number; \
      car(x) = Sc->NIL;                  \
      cdr(x) = Old_Env;		         \
      set_type(x, T_ENVIRONMENT); \
      New_Env = x;		   \
     } while (0)


static s7_pointer new_frame_in_env(s7_scheme *sc, s7_pointer old_env) 
{ 
  /* return(cons(sc, sc->NIL, old_env)); */
  s7_pointer x;
  NEW_CELL(sc, x);
  frame_id(x) = ++frame_number;
  car(x) = sc->NIL;
  cdr(x) = old_env;
  set_type(x, T_ENVIRONMENT);
  return(x);
} 


static s7_pointer g_is_environment(s7_scheme *sc, s7_pointer args)
{
  #define H_is_environment "(environment? obj) returns #t if obj is an environment."
  return(make_boolean(sc, is_environment(car(args))));
}


static s7_pointer add_slot_to_environment(s7_scheme *sc, s7_pointer env, s7_pointer variable, s7_pointer value) 
{ 
  s7_pointer slot;

  if (!is_environment(env))
    {
      s7_pointer ge;

      if ((sc->safety == 0) &&
	  ((is_closure(value)) ||
	   (is_closure_star(value)) ||
	   (is_macro(value)) ||
	   (is_bacro(value))))
	s7_remove_from_heap(sc, closure_source(value));

      ge = sc->global_env;
      slot = permanent_cons(variable, value, T_PAIR | T_IMMUTABLE | T_DONT_COPY);
      vector_element(ge, vector_fill_pointer(ge)++) = slot;
      if (vector_fill_pointer(ge) >= vector_length(ge))
	{
	  int i;
	  vector_length(ge) *= 2;
	  vector_elements(ge) = (s7_pointer *)realloc(vector_elements(ge), vector_length(ge) * sizeof(s7_pointer));
	  for (i = vector_fill_pointer(ge); i < vector_length(ge); i++)
	    vector_element(ge, i) = sc->NIL;
	}
      symbol_global_slot(variable) = slot;
      symbol_local_slot(variable) = slot;
      /* fprintf(stderr, "%s: %p\n", symbol_name(variable), slot); */
      set_global(variable);
      symbol_id(variable) = 0;
      /* so if we (define hi "hiho") at the top level,  "hi" hashes to 1746 with symbol table size 2207
       *   s7->symbol_table->object.vector.elements[1746]->object.cons.car->object.cons.car->object.string.global_slot is (hi . \"hiho\")
       */
    }
  else
    {
      NEW_CELL(sc, slot);
      car(slot) = variable;
      cdr(slot) = value;
      set_type(slot, T_PAIR | T_IMMUTABLE | T_DONT_COPY);
      ecdr(slot) = car(env);
      car(env) = slot;
      set_local(variable);
      symbol_id(variable) = frame_id(env);
      symbol_local_slot(variable) = slot;
    }

  /* there are about the same number of frames as local variables -- this
   *   strikes me as surprising, but it holds up across a lot of code.
   */
  return(slot);
} 


#define ADD_SLOT(Frame, Symbol, Value) \
  do {\
    s7_pointer slot;\
    NEW_CELL_NO_CHECK(sc, slot);\
    car(slot) = Symbol;\
    cdr(slot) = Value;\
    set_type(slot, T_PAIR | T_IMMUTABLE | T_DONT_COPY);\
    ecdr(slot) = car(Frame);\
    car(Frame) = slot;\
    symbol_id(car(slot)) = frame_id(Frame);	\
    symbol_local_slot(car(slot)) = slot;\
  } while (0)

/* no set_local here -- presumably done earlier in check_* 
 */


static s7_pointer add_slot(s7_scheme *sc, s7_pointer variable, s7_pointer value) 
{ 
  /* this is called when it is guaranteed that there is a local environment */
  s7_pointer y;

  NEW_CELL(sc, y);
  car(y) = variable;
  cdr(y) = value;
  set_type(y, T_PAIR | T_IMMUTABLE | T_DONT_COPY);
  ecdr(y) = car(sc->envir);
  car(sc->envir) = y;
  set_local(variable);
  symbol_id(variable) = frame_id(sc->envir);
  symbol_local_slot(variable) = y;
  return(y);
} 


static void save_initial_environment(s7_scheme *sc)
{
  /* there are ca 270 predefined functions (and another 30 or so other things): 302 at last count
   */
  #define INITIAL_ENV_ENTRIES 400
  int i, k = 0, len;
  s7_pointer ge;
  s7_pointer *lsts, *inits;

  sc->initial_env = (s7_pointer)calloc(1, sizeof(s7_cell));
  set_type(sc->initial_env, T_VECTOR | T_DONT_COPY);
  vector_length(sc->initial_env) = INITIAL_ENV_ENTRIES;
  vector_elements(sc->initial_env) = (s7_pointer *)malloc(INITIAL_ENV_ENTRIES * sizeof(s7_pointer));
  inits = vector_elements(sc->initial_env);
  s7_vector_fill(sc, sc->initial_env, sc->NIL);
  sc->initial_env->hloc = NOT_IN_HEAP;

  ge = sc->global_env;
  len = vector_fill_pointer(ge);
  lsts = vector_elements(ge);
   
  for (i = 0; i < len; i++)
    {
      s7_pointer slot;
      slot = lsts[i];
      if (is_procedure(symbol_value(slot)))
	{
	  inits[k++] = permanent_cons(car(slot), cdr(slot), T_PAIR | T_IMMUTABLE | T_DONT_COPY);
	  if (k >= INITIAL_ENV_ENTRIES)
	    return;
	}
    }
}


static s7_pointer g_initial_environment(s7_scheme *sc, s7_pointer args)
{
  /* add sc->initial_env bindings to the current environment */
  #define H_initial_environment "(initial-environment) establishes the original bindings of all the predefined functions"

  /* maybe this should be named with-initial-environment or something -- it currently looks
   *   like it simply returns the initial env, but it actually shadows the global env entries
   *   that have changed.  But that doesn't behave the way one would expect:
   *
   *     (let () (define (x) 1) (defined? 'x (initial-environment)) -> #t!
   *   
   *   I can't see how to fix this short of copying the thing.
   */
  int i;
  s7_pointer *inits;
  s7_pointer x;

  sc->w = new_frame_in_env(sc, sc->envir);
  inits = vector_elements(sc->initial_env);

  for (i = 0; (i < INITIAL_ENV_ENTRIES) && (is_not_null(inits[i])); i++)
    if ((!is_global(car(inits[i]))) ||                                      /* it's shadowed locally */
	(cdr(inits[i]) != symbol_value(symbol_global_slot(car(inits[i]))))) /* it's not shadowed, but has been changed globally */
      add_slot_to_environment(sc, sc->w, car(inits[i]), cdr(inits[i]));
                         
  /* if (set! + -) then + needs to be overridden, but the local bit isn't set,
   *   so we have to check the actual values in the non-local case.
   *   (define (f x) (with-environment (initial-environment) (+ x 1))) 
   */

  x = sc->w;
  sc->w = sc->NIL;
  return(x);
}


static s7_pointer g_augment_environment_direct(s7_scheme *sc, s7_pointer args)
{
  #define H_augment_environment_direct "(augment-environment! env ...) adds its \
arguments (each a cons: symbol . value) directly to the environment env, and returns the \
environment."

  s7_pointer x, e;
  int i, gc_loc = -1;

  e = car(args);
  if (!is_environment(e))
    {
      if (is_null(e))       /* the empty environment */
	{
	  e = new_frame_in_env(sc, sc->NIL);
	  gc_loc = s7_gc_protect(sc, e);
	}
      else return(s7_wrong_type_arg_error(sc, "augment-environment!", 1, e, "an environment"));
    }

  for (i = 2, x = cdr(args); is_not_null(x); x = cdr(x), i++)
    if ((!is_pair(car(x))) ||
	(!s7_is_symbol(caar(x))))
      {
	if (gc_loc != -1)
	  s7_gc_unprotect_at(sc, gc_loc);
	return(s7_wrong_type_arg_error(sc, "augment-environment!", i, car(x), "a pair: '(symbol . value)"));
      }

  for (x = cdr(args); is_not_null(x); x = cdr(x))
    add_slot_to_environment(sc, e, caar(x), cdar(x));

  if (gc_loc != -1)
    s7_gc_unprotect_at(sc, gc_loc);
  return(e);
}


s7_pointer s7_augment_environment(s7_scheme *sc, s7_pointer e, s7_pointer bindings)
{
  s7_pointer x, new_e;
  int gc_loc;
  
  new_e = new_frame_in_env(sc, e);
  gc_loc = s7_gc_protect(sc, new_e);

  for (x = bindings; is_not_null(x); x = cdr(x))
    add_slot_to_environment(sc, new_e, caar(x), cdar(x));

  s7_gc_unprotect_at(sc, gc_loc);
  return(new_e);
}


static s7_pointer g_augment_environment(s7_scheme *sc, s7_pointer args)
{
  #define H_augment_environment "(augment-environment env ...) adds its \
arguments (each a cons: symbol . value) to the environment env, and returns the \
new environment."

  s7_pointer e, x;
  int i, gc_loc = -1;

  e = car(args);
  if (!is_environment(e))
    {
      if (is_null(e))       /* the empty environment */
	{
	  e = new_frame_in_env(sc, sc->NIL);
	  gc_loc = s7_gc_protect(sc, e);
	}
      else return(s7_wrong_type_arg_error(sc, "augment-environment", 1, e, "an environment"));
    }
  else
    {
      if (e == sc->global_env)
	{
	  e = new_frame_in_env(sc, sc->NIL);
	  gc_loc = s7_gc_protect(sc, e);
	}
    }

  for (i = 2, x = cdr(args); is_not_null(x); x = cdr(x), i++)
    if ((!is_pair(car(x))) ||
	(!s7_is_symbol(caar(x))))
      {
	if (gc_loc != -1)
	  s7_gc_unprotect_at(sc, gc_loc);
	return(s7_wrong_type_arg_error(sc, "augment-environment", i, car(x), "a pair: '(symbol . value)"));
      }

  if (gc_loc != -1)
    s7_gc_unprotect_at(sc, gc_loc);

  return(s7_augment_environment(sc, e, cdr(args)));
}


s7_pointer s7_environment_to_list(s7_scheme *sc, s7_pointer env)
{
  s7_pointer x;
  sc->w = sc->NIL;
  if (env == sc->global_env)
    {
      unsigned int i;
      for (i = 0; i < vector_fill_pointer(env); i++)
	if (is_pair(vector_element(env, i)))
	  sc->w = cons(sc, vector_element(env, i), sc->w);
      x = sc->w;
    }
  else
    {
      for (x = env; is_environment(x); x = cdr(x)) 
	{
	  s7_pointer y;
	  sc->z = sc->NIL;
	  for (y = car(x); is_pair(y); y = ecdr(y))
	    sc->z = cons(sc, y, sc->z);
	  sc->w = cons(sc, safe_reverse_in_place(sc, sc->z), sc->w);
	}
  
      x = safe_reverse_in_place(sc, sc->w);
      sc->z = sc->NIL;
    }
  sc->w = sc->NIL;
  return(x);
}


static s7_pointer g_environment_to_list(s7_scheme *sc, s7_pointer args)
{
  #define H_environment_to_list "(environment->list env) returns env as a list of lists.  The outer lists \
represent the frames working from the innermost up, and the inner lists are lists of cons's with each symbol \
in that frame and its value."

  s7_pointer env;

  env = car(args);
  if (!is_environment(env))
    return(s7_wrong_type_arg_error(sc, "environment->list", 0, env, "an environment"));

  return(s7_environment_to_list(sc, env));
}


static s7_pointer find_symbol(s7_scheme *sc, s7_pointer hdl)
{ 
  s7_pointer x;	
  for (x = sc->envir; symbol_id(hdl) < frame_id(x); x = cdr(x));
  if (frame_id(x) == symbol_id(hdl))
    return(symbol_local_slot(hdl));	
  for (; is_environment(x); x = cdr(x))
    {
      s7_pointer y; 
      for (y = car(x); is_pair(y); y = ecdr(y))	
	if (car(y) == hdl)
	  return(y); 
    }
  return(symbol_global_slot(hdl));
} 


s7_pointer s7_symbol_slot(s7_scheme *sc, s7_pointer symbol)
{
  return(find_symbol(sc, symbol));
}


static s7_pointer find_local_symbol(s7_scheme *sc, s7_pointer env, s7_pointer hdl) 
{ 
  s7_pointer y;

  if (!is_environment(env))
    return(symbol_global_slot(hdl));

  for (y = car(env); is_pair(y); y = ecdr(y))
    if (car(y) == hdl)
      return(y);

  return(sc->NIL);
} 


s7_pointer s7_symbol_value(s7_scheme *sc, s7_pointer sym) /* was searching just the global environment? */
{
  s7_pointer x;

  x = find_symbol(sc, sym);
  if (is_not_null(x))
    return(symbol_value(x));

  if (is_keyword(sym))
    return(sym);
  return(sc->UNDEFINED);
}


s7_pointer s7_symbol_local_value(s7_scheme *sc, s7_pointer sym, s7_pointer local_env)
{
  s7_pointer x;
  if (is_environment(local_env))
    {
      for (x = local_env; is_environment(x); x = cdr(x))
	{
	  s7_pointer y;
	  for (y = car(x); is_pair(y); y = ecdr(y))
	    if (car(y) == sym)
	      return(symbol_value(y));
	}
    }
  return(s7_symbol_value(sc, sym)); 
}


static s7_pointer g_symbol_to_value(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_to_value "(symbol->value sym (env (current-environment))) returns the binding of (the value associated with) the \
symbol sym in the given environment: (let ((x 32)) (symbol->value 'x)) -> 32"

  s7_pointer sym;
  sym = car(args);

  if (!s7_is_symbol(sym))
    return(s7_wrong_type_arg_error(sc, "symbol->value", (is_null(cdr(args))) ? 0 : 1, sym, "a symbol"));

  if (is_not_null(cdr(args)))
    {
      s7_pointer x, local_env;
      if (!is_environment(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "symbol->value", 2, cadr(args), "an environment"));

      local_env = cadr(args);
      if (local_env == sc->global_env)
	{
	  x = symbol_global_slot(sym);
	  if (is_not_null(x))
	    return(symbol_value(x));
	  return(sc->UNDEFINED);
	}
      return(s7_symbol_local_value(sc, sym, local_env));
    }
  
  if (is_global(sym))
    return(symbol_value(symbol_global_slot(sym)));

  return(s7_symbol_value(sc, sym));
}


s7_pointer s7_symbol_set_value(s7_scheme *sc, s7_pointer sym, s7_pointer val)
{
  s7_pointer x;
  /* if immutable should this return an error? */
  x = find_symbol(sc, sym);
  if (is_not_null(x))
    set_symbol_value(x, val);
  return(val);
}


static s7_pointer g_global_environment(s7_scheme *sc, s7_pointer ignore)
{
  #define H_global_environment "(global-environment) returns the current top-level definitions (symbol bindings). \
It is a hash-table."
  return(sc->global_env);
}

/* as with the symbol-table, this function can lead to disaster -- user could
 *   clobber the environment etc.  But we want it to be editable and augmentable,
 *   so I guess I'll leave it alone.  (See current|procedure-environment as well).
 */


static s7_pointer g_current_environment(s7_scheme *sc, s7_pointer args)
{
  #define H_current_environment "(current-environment) returns the current definitions (symbol bindings)"

  if (is_environment(sc->envir))
    return(sc->envir);
  return(sc->global_env);
}


static s7_pointer make_closure(s7_scheme *sc, s7_pointer code, int type) 
{
  /* this is called every time a lambda form is evaluated, or during letrec, etc */

  s7_pointer x;
  NEW_CELL(sc, x);
  car(x) = code;
  cdr(x) = sc->envir;
  set_type(x, type | T_PROCEDURE | T_DONT_COPY);
  return(x);
}


s7_pointer s7_make_closure(s7_scheme *sc, s7_pointer c, s7_pointer e)
{
  /* c is a list: args code, so 
   *   (define (proc a b) (+ a b)) becomes
   *   make_closure ((a b) (+ a b)) e
   */
  s7_pointer p;
  p = make_closure(sc, c, T_CLOSURE);
  cdr(p) = e;
  return(p);
}


s7_pointer s7_global_environment(s7_scheme *sc) 
{
  return(sc->global_env);
}


s7_pointer s7_current_environment(s7_scheme *sc) 
{
  return(sc->envir);
}


static s7_pointer g_is_defined(s7_scheme *sc, s7_pointer args)
{
  #define H_is_defined "(defined? obj (env (current-environment))) returns #t if obj has a binding (a value) in the environment env"
  s7_pointer sym, x;

  sym = car(args);
  if (!s7_is_symbol(sym))
    return(s7_wrong_type_arg_error(sc, "defined?", (is_null(cdr(args))) ? 0 : 1, sym, "a symbol"));
  
  if (is_not_null(cdr(args)))
    {
      s7_pointer e;
      if (!is_environment(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "defined?", 2, cadr(args), "an environment"));
      e = cadr(args);
      if (e == sc->global_env)
	{
	  x = symbol_global_slot(sym);
	  return(make_boolean(sc, (is_not_null(x)) && (x != sc->UNDEFINED)));
	}
      x = find_local_symbol(sc, e, sym); 
      if ((is_not_null(x)) && (x != sc->UNDEFINED))
	return(sc->T);
    }
  else 
    {
      if (is_global(sym))
	return(sc->T);
    }
  
  x = find_symbol(sc, sym); 
  return(make_boolean(sc, (is_not_null(x)) && (x != sc->UNDEFINED)));
}


bool s7_is_defined(s7_scheme *sc, const char *name)
{
  s7_pointer x;
  x = find_symbol(sc, make_symbol(sc, name));
  return((is_not_null(x)) && (x != sc->UNDEFINED));
}


void s7_define(s7_scheme *sc, s7_pointer envir, s7_pointer symbol, s7_pointer value) 
{
  s7_pointer x;

  if (envir == sc->global_env) envir = sc->NIL; /* for C-side backwards compatibility */
  x = find_local_symbol(sc, envir, symbol);
  if (is_not_null(x)) 
    set_symbol_value(x, value); 
  else add_slot_to_environment(sc, envir, symbol, value); /* I think this means C code can override "constant" defs */
}


void s7_define_variable(s7_scheme *sc, const char *name, s7_pointer value)
{
  s7_pointer sym;

  sym = make_symbol(sc, name);
  s7_define(sc, sc->NIL, sym, value);
}


void s7_define_constant(s7_scheme *sc, const char *name, s7_pointer value)
{
  s7_pointer x, sym;
  
  sym = make_symbol(sc, name);
  s7_define(sc, sc->NIL, sym, value);
  x = symbol_global_slot(sym);
  set_immutable(car(x));
}

/*        (define (func a) (let ((cvar (+ a 1))) cvar))
 *        (define-constant cvar 23)
 *        (func 1)
 *        ;can't bind an immutable object: cvar
 */




/* -------- keywords -------- */

bool s7_is_keyword(s7_pointer obj)
{
  return(is_keyword(obj));
}


static s7_pointer g_is_keyword(s7_scheme *sc, s7_pointer args)
{
  #define H_is_keyword "(keyword? obj) returns #t if obj is a keyword, (keyword? :key) -> #t"
  return(make_boolean(sc, is_keyword(car(args))));
}


s7_pointer s7_make_keyword(s7_scheme *sc, const char *key)
{
  s7_pointer sym;
  char *name;
  
  name = (char *)malloc((safe_strlen(key) + 2) * sizeof(char));
  sprintf(name, ":%s", key);                     /* prepend ":" */
  sym = make_symbol(sc, name);
  typeflag(sym) |= (T_IMMUTABLE | T_DONT_COPY); 
  free(name);
  
  add_slot_to_environment(sc, sc->NIL, sym, sym); /* make it global, not in the local env! */

  return(sym);
}


static s7_pointer g_make_keyword(s7_scheme *sc, s7_pointer args)
{
  #define H_make_keyword "(make-keyword str) prepends ':' to str and defines that as a keyword"
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-keyword", 0, car(args), "a string"));
  return(s7_make_keyword(sc, string_value(car(args))));
}


static s7_pointer g_keyword_to_symbol(s7_scheme *sc, s7_pointer args)
{
  #define H_keyword_to_symbol "(keyword->symbol key) returns a symbol with the same name as key but no prepended colon"
  const char *name;

  if (!is_keyword(car(args)))
    return(s7_wrong_type_arg_error(sc, "keyword->symbol", 0, car(args), "a keyword"));

  name = symbol_name(car(args));
  if (name[0] == ':')
    return(make_symbol(sc, (const char *)(name + 1)));

  /* else it ends in ":", (keyword->symbol foo:) */
  {
    char *temp;
    s7_pointer res;
    temp = copy_string(name);
    temp[strlen(temp) - 1] = '\0';
    res = make_symbol(sc, (const char *)temp);
    free(temp);
    return(res);
  }
}


static s7_pointer g_symbol_to_keyword(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_to_keyword "(symbol->keyword sym) returns a keyword with the same name as sym, but with a colon prepended"
  if (!s7_is_symbol(car(args)))
    return(s7_wrong_type_arg_error(sc, "symbol->keyword", 0, car(args), "a symbol"));
  return(s7_make_keyword(sc, symbol_name(car(args))));
}


/* for uninterpreted pointers */

bool s7_is_c_pointer(s7_pointer arg) 
{
  return(type(arg) == T_C_POINTER);
}


void *s7_c_pointer(s7_pointer p) 
{
  if ((type(p) == T_NUMBER) && (s7_integer(p) == 0))
    return(NULL); /* special case where the null pointer has been cons'd up by hand */

  if (type(p) != T_C_POINTER)
    {
      fprintf(stderr, "s7_c_pointer argument is not a c pointer?");
      return(NULL);
    }

  return(raw_pointer(p));
}


s7_pointer s7_make_c_pointer(s7_scheme *sc, void *ptr)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_C_POINTER | T_DONT_COPY);
  raw_pointer(x) = ptr;
  return(x);
}




/* -------------------------------- continuations and gotos -------------------------------- */

bool s7_is_continuation(s7_pointer p)    
{ 
  return(is_continuation(p));
}


static s7_pointer g_is_continuation(s7_scheme *sc, s7_pointer args)
{
  #define H_is_continuation "(continuation? obj) returns #t if obj is a continuation"
  return(make_boolean(sc, is_continuation(car(args))));
}

/* is this the right thing?  It returns #f for call-with-exit ("goto") because
 *   that form of continuation can't continue (via a jump back to its context).
 */


static s7_pointer copy_list(s7_scheme *sc, s7_pointer lst)
{
  if (is_null(lst))
    return(sc->NIL);
  return(cons(sc, car(lst), copy_list(sc, cdr(lst))));
}


static s7_pointer copy_object(s7_scheme *sc, s7_pointer obj)
{
  s7_pointer nobj;
  int nloc;

  NEW_CELL(sc, nobj);
  nloc = nobj->hloc;
  memcpy((void *)nobj, (void *)obj, sizeof(s7_cell));
  nobj->hloc = nloc;
  
  /* nobj is safe here because the gc is off */
  if (dont_copy(car(obj)))
    car(nobj) = car(obj);
  else car(nobj) = copy_object(sc, car(obj));

  
  if ((dont_copy(cdr(obj))) || (dont_copy_cdr(obj)))
    cdr(nobj) = cdr(obj); /* closure_environment in func cases */
  else cdr(nobj) = copy_object(sc, cdr(obj));
  
  return(nobj);
}


static s7_pointer copy_stack(s7_scheme *sc, s7_pointer old_v, int top)
{
  int i;
  s7_pointer new_v;
  s7_pointer *nv, *ov;

  new_v = s7_make_vector(sc, vector_length(old_v));
  set_type(new_v, T_STACK);
  /* we can't leave the upper stuff simply malloc-garbage because we're sure to call the GC.
   *   We also can't just copy the vector since that seems to confuse the gc mark process.
   */

  nv = vector_elements(new_v);
  ov = vector_elements(old_v);
  
  s7_gc_on(sc, false);

  for (i = 0; i < top; i += 4)
    {
      if (dont_copy(ov[i]))
	nv[i] = ov[i];
      else nv[i] = copy_object(sc, ov[i]);    /* code */
      nv[i + 1] = ov[i + 1];                  /* environment pointer */
      if (is_pair(ov[i + 2]))                 /* args need not be a list (it can be a port or #f, etc) -- if it is a list we assume it's a proper list */
	nv[i + 2] = copy_list(sc, ov[i + 2]); /* args (copy is needed -- see s7test.scm) */
      else nv[i + 2] = ov[i + 2];             /* is this a safe assumption? */
      nv[i + 3] = ov[i + 3];                  /* op (constant int) */
    }
  
  s7_gc_on(sc, true);
  return(new_v);
}


static s7_pointer make_goto(s7_scheme *sc) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  call_exit_goto_loc(x) = s7_stack_top(sc);
  call_exit_op_loc(x) = (int)(sc->op_stack_now - sc->op_stack);
  call_exit_active(x) = true;
  set_type(x, T_GOTO | T_DONT_COPY | T_PROCEDURE);
  return(x);
}


static s7_pointer *copy_op_stack(s7_scheme *sc)
{
  unsigned int i;
  s7_pointer *ops;
  ops = (s7_pointer *)malloc(sc->op_stack_size * sizeof(s7_pointer));
  for (i = 0; i < sc->op_stack_size; i++)
    ops[i] = sc->op_stack[i];
  return(ops);
}


s7_pointer s7_make_continuation(s7_scheme *sc) 
{
  s7_pointer x;
  int loc;

  if ((int)(sc->free_heap_top - sc->free_heap) < (int)(sc->heap_size / 4))
    gc(sc);

  /* this gc call is needed if there are lots of call/cc's -- by pure bad luck
   *   we can end up hitting the end of the gc free list time after time while
   *   in successive copy_stack's below, causing s7 to core up until it runs out of memory.
   */

  loc = s7_stack_top(sc);

  NEW_CELL(sc, x);
  continuation(x) = (s7_continuation_t *)calloc(1, sizeof(s7_continuation_t));
  continuation_stack_size(x) = sc->stack_size;
  continuation_stack(x) = copy_stack(sc, sc->stack, s7_stack_top(sc));
  continuation_stack_start(x) = vector_elements(continuation_stack(x));
  continuation_stack_end(x) = (s7_pointer *)(continuation_stack_start(x) + loc);

  continuation_op_stack(x) = copy_op_stack(sc);
  continuation_op_loc(x) = (int)(sc->op_stack_now - sc->op_stack);
  continuation_op_size(x) = sc->op_stack_size;

  set_type(x, T_CONTINUATION | T_DONT_COPY | T_PROCEDURE);
  add_continuation(sc, x);
  return(x);
}


static bool check_for_dynamic_winds(s7_scheme *sc, s7_pointer c)
{
  int i, s_base = 0, c_base = -1;
  opcode_t op;

  for (i = s7_stack_top(sc) - 1; i > 0; i -= 4)
    {
      s7_pointer x;

      op = stack_op(sc->stack, i);

      switch (op)
	{
	case OP_DYNAMIC_WIND:
	  {
	    int j;
	    x = stack_code(sc->stack, i);
	    for (j = 3; j < continuation_stack_top(c); j += 4)
	      if ((stack_op(continuation_stack(c), j) == OP_DYNAMIC_WIND) &&
		  (x == stack_code(continuation_stack(c), j)))
		{
		  s_base = i;
		  c_base = j;
		  break;
		}
	  
	    if (s_base != 0)
	      break;	  
	  
	    if (dynamic_wind_state(x) == DWIND_BODY)
	      {
		dynamic_wind_state(x) = DWIND_FINISH;
		push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
		sc->args = sc->NIL;
		sc->code = dynamic_wind_out(x);
		eval(sc, OP_APPLY);
	      }
	  }
	  break;

	case OP_BARRIER:
	  if (i > continuation_stack_top(c))  /* otherwise it's some unproblematic outer eval-string? */
	    return(false);
	  break;

	case OP_DEACTIVATE_GOTO:              /* here we're jumping out of an unrelated call-with-exit block */
	  if (i > continuation_stack_top(c))
	    call_exit_active(stack_args(sc->stack, i)) = false;
	  break;

	case OP_TRACE_RETURN:
	  if (i > continuation_stack_top(c))
	    {
	      sc->trace_depth--;
	      if (sc->trace_depth < 0) sc->trace_depth = 0;
	    }
	  break;
	  
	default:
	  break;
	}
    }
  
  for (i = c_base + 4; i < continuation_stack_top(c); i += 4)
    {
      op = stack_op(continuation_stack(c), i);

      if (op == OP_DYNAMIC_WIND)
	{
	  s7_pointer x;
	  x = stack_code(continuation_stack(c), i);
	  push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
	  sc->args = sc->NIL;
	  sc->code = dynamic_wind_in(x);
	  eval(sc, OP_APPLY);
	  dynamic_wind_state(x) = DWIND_BODY;
	}
      else
	{
	  if (op == OP_DEACTIVATE_GOTO)
	    call_exit_active(stack_args(continuation_stack(c), i)) = true;
	}
    }
  return(true);
}


static void call_with_current_continuation(s7_scheme *sc)
{
  if (!check_for_dynamic_winds(sc, sc->code))
    return;

  sc->stack = copy_stack(sc, continuation_stack(sc->code), continuation_stack_top(sc->code));
  sc->stack_size = continuation_stack_size(sc->code);
  sc->stack_start = vector_elements(sc->stack);
  sc->stack_end = (s7_pointer *)(sc->stack_start + continuation_stack_top(sc->code));
  sc->stack_resize_trigger = (s7_pointer *)(sc->stack_start + sc->stack_size / 2);
  
  {
    int i, top;
    top = continuation_op_loc(sc->code);
    sc->op_stack_now = (s7_pointer *)(sc->op_stack + top);
    sc->op_stack_size = continuation_op_size(sc->code);
    sc->op_stack_end = (s7_pointer *)(sc->op_stack + sc->op_stack_size);
    for (i = 0; i < top; i++)
      sc->op_stack[i] = continuation_op_stack(sc->code)[i];
  }

  if (is_null(sc->args))
    sc->value = sc->NIL;
  else
    {
      if (is_null(cdr(sc->args)))
	sc->value = car(sc->args);
      else sc->value = splice_in_values(sc, sc->args);
    }
}


static void call_with_exit(s7_scheme *sc)
{
  int i, new_stack_top;
  
  if (!call_exit_active(sc->code))
    s7_error(sc, make_symbol(sc, "invalid-escape-function"),
	     list_1(sc, make_protected_string(sc, "call-with-exit escape procedure called outside its block")));
  call_exit_active(sc->code) = false;
  new_stack_top = call_exit_goto_loc(sc->code);
  sc->op_stack_now = (s7_pointer *)(sc->op_stack + call_exit_op_loc(sc->code));

  /* look for dynamic-wind in the stack section that we are jumping out of */
  for (i = s7_stack_top(sc) - 1; i > new_stack_top; i -= 4)
    {
      opcode_t op;

      op = stack_op(sc->stack, i);
      switch (op)
	{
	case OP_DYNAMIC_WIND:
	  {
	    sc->z = stack_code(sc->stack, i);
	    if (dynamic_wind_state(sc->z) == DWIND_BODY)
	      {
		dynamic_wind_state(sc->z) = DWIND_FINISH;
		push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
		sc->args = sc->NIL;
		sc->code = dynamic_wind_out(sc->z);
		sc->z = sc->NIL;
		eval(sc, OP_APPLY);
	      }
	  }
	  break;

	case OP_EVAL_STRING_2:
	  s7_close_input_port(sc, sc->input_port);
	  pop_input_port(sc);
	  break;

	case OP_BARRIER:                /* oops -- we almost certainly went too far */
	  return; 

	case OP_DEACTIVATE_GOTO:        /* here we're jumping into an unrelated call-with-exit block */
	  call_exit_active(stack_args(sc->stack, i)) = false;
	  break;

	case OP_TRACE_RETURN:
	  sc->trace_depth--;
	  if (sc->trace_depth < 0) sc->trace_depth = 0;
	  break;

	  /* call/cc does not close files, but I think call-with-exit should */
	case OP_UNWIND_OUTPUT:
	  {
	    s7_pointer x;
	    x = stack_code(sc->stack, i);                /* "code" = port that we opened */
	    s7_close_output_port(sc, x);
	    x = stack_args(sc->stack, i);                /* "args" = port that we shadowed, if not #f */
	    if (x != sc->F)
	      sc->output_port = x;
	  }
	  break;

	case OP_UNWIND_INPUT:
	  s7_close_input_port(sc, stack_code(sc->stack, i)); /* "code" = port that we opened */
	  sc->input_port = stack_args(sc->stack, i);         /* "args" = port that we shadowed */
	  sc->input_is_file = (is_file_port(sc->input_port));
	  break;

	default:
	  break;
	}
    }
	    
  sc->stack_end = (s7_pointer *)(sc->stack_start + new_stack_top);

  /* the return value should have an implicit values call, just as in call/cc */
  if (is_null(sc->args))
    sc->value = sc->NIL;
  else
    {
      if (is_null(cdr(sc->args)))
	sc->value = car(sc->args);
      else sc->value = splice_in_values(sc, sc->args);
    }
}


static s7_pointer g_call_cc(s7_scheme *sc, s7_pointer args)
{
  #define H_call_cc "(call-with-current-continuation func) needs more than a one sentence explanation"
  s7_pointer proc_args;

  /* car(args) is the procedure passed to call/cc */
  
  if (!is_procedure(car(args)))                      /* this includes continuations */
    return(s7_wrong_type_arg_error(sc, "call/cc", 0, car(args), "a procedure"));

  proc_args = s7_procedure_arity(sc, car(args));
  if ((s7_integer(car(proc_args)) > 1) ||
      ((s7_integer(car(proc_args)) == 0) &&
       (s7_integer(cadr(proc_args)) == 0) &&
       (caddr(proc_args) == sc->F)))
    return(s7_error(sc, sc->WRONG_TYPE_ARG, 
		    list_2(sc, make_protected_string(sc, "call/cc procedure, ~A, should take one argument"), car(args))));

  sc->w = s7_make_continuation(sc);
  push_stack(sc, OP_APPLY, list_1(sc, sc->w), car(args));
  sc->w = sc->NIL;
  return(sc->NIL);
}


static s7_pointer g_call_with_exit(s7_scheme *sc, s7_pointer args)
{
  #define H_call_with_exit "(call-with-exit func) is call/cc without the ability to jump back into a previous computation."
  s7_pointer x;
  
  /* (call-with-exit (lambda (return) ...)) */
  /* perhaps "call/exit"? */
  
  if (!is_procedure(car(args)))                              /* this includes continuations */
    return(s7_wrong_type_arg_error(sc, "call-with-exit", 0, car(args), "a procedure"));

  x = make_goto(sc);
  push_stack(sc, OP_DEACTIVATE_GOTO, x, sc->NIL); /* this means call-with-exit is not tail-recursive */
  push_stack(sc, OP_APPLY, cons_unchecked(sc, x, sc->NIL), car(args));
  
  /* if the lambda body calls the argument as a function, 
   *   it is applied to its arguments, apply notices that it is a goto, and...
   *   
   *      (conceptually...) sc->stack_top = call_exit_goto_loc(sc->code);      
   *      s_pop(sc, (is_not_null(sc->args)) ? car(sc->args) : sc->NIL);
   * 
   *   which jumps to the point of the goto returning car(args).
   *
   * There is one gotcha: we can't jump back in from outside, so if the caller saves the goto
   *   and tries to invoke it outside the call-with-exit block, we have to
   *   make sure it triggers an error.  So, if the escape is called, it then
   *   deactivates itself.  Otherwise the block returns, we pop to OP_DEACTIVATE_GOTO,
   *   and it finds the goto in sc->args.
   * Even worse:
   *
       (let ((cc #f))
         (call-with-exit
           (lambda (c3)
             (call/cc (lambda (ret) (set! cc ret)))
             (c3)))
         (cc))
   *
   * where we jump back into a call-with-exit body via call/cc, the goto has to be
   * re-established.
   */
  
  return(sc->NIL);
}



/* -------------------------------- numbers -------------------------------- */

#if WITH_GMP
  static char *big_number_to_string_with_radix(s7_pointer p, int radix, int width);
  static bool big_numbers_are_eqv(s7_pointer a, s7_pointer b);
  static s7_pointer string_to_either_integer(s7_scheme *sc, const char *str, int radix);
  static s7_pointer string_to_either_ratio(s7_scheme *sc, const char *nstr, const char *dstr, int radix);
  static s7_pointer string_to_either_real(s7_scheme *sc, const char *str, int radix);
  static s7_pointer string_to_either_complex(s7_scheme *sc,
					     char *q, char *slash1, char *ex1, bool has_dec_point1, 
					     char *plus, char *slash2, char *ex2, bool has_dec_point2, 
					     int radix, int has_plus_or_minus);
  static s7_pointer big_add(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_subtract(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_multiply(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_divide(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_random(s7_scheme *sc, s7_pointer args);
  static s7_pointer s7_Int_to_big_integer(s7_scheme *sc, s7_Int val);
  static s7_pointer s7_ratio_to_big_ratio(s7_scheme *sc, s7_Int num, s7_Int den);
  static s7_pointer s7_number_to_big_real(s7_scheme *sc, s7_pointer p);
  static s7_pointer promote_number(s7_scheme *sc, int type, s7_pointer x);
  static s7_pointer big_negate(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_invert(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_inexact_to_exact(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_exact_to_inexact(s7_scheme *sc, s7_pointer args);
  static s7_pointer big_is_zero_1(s7_scheme *sc, s7_pointer x);
#endif


#define s7_Int_abs(x) ((x) >= 0 ? (x) : -(x))
/* can't use abs even in gcc -- it doesn't work with long long ints! */
#define s7_Double_abs(x) fabs(x)
#define s7_fabsl(x) (((x) < 0.0) ? -(x) : (x))
/* fabsl doesn't exist in netBSD! */


#ifdef _MSC_VER
/* need to provide inverse hyperbolic trig funcs and cbrt */

double asinh(double x);
double asinh(double x) 
{ 
  return(log(x + sqrt(1.0 + x * x))); 
} 


double acosh(double x);
double acosh(double x)
{ 
  return(log(x + sqrt(x * x - 1.0))); 
  /* perhaps less prone to numerical troubles (untested):
   *   2.0 * log(sqrt(0.5 * (x + 1.0)) + sqrt(0.5 * (x - 1.0)))
   */
} 


double atanh(double x);
double atanh(double x)
{ 
  return(log((1.0 + x) / (1.0 - x)) / 2.0); 
} 


double cbrt(double x);
double cbrt(double x)
{
  if (x >= 0.0)
    return(pow(x, 1.0 / 3.0));
  return(-pow(-x, 1.0 / 3.0));
}

static bool isnan(s7_Double x) {return(x != x);}
/* isnan shows up prominently in callgrind output for s7test, but it's not due to anything
 *    in this file.  If I replace all the local isnan's with is_nan based on this function,
 *    the callgrind value scarcely changes -- I guess the math library is calling it a lot.
 */

static bool isinf(s7_Double x) {return((x == x) && (isnan(x - x)));}

#endif

#if WITH_COMPLEX

#if __cplusplus
  #define _Complex_I (complex<s7_Double>(0.0, 1.0))
  #define creal(x) Real(x)
  #define cimag(x) Imag(x)
  #define carg(x) arg(x)
  #define cabs(x) abs(x)
  #define csqrt(x) sqrt(x)
  #define cpow(x, y) pow(x, y)
  #define clog(x) log(x)
  #define cexp(x) exp(x)
  #define csin(x) sin(x)
  #define ccos(x) cos(x)
  #define csinh(x) sinh(x)
  #define ccosh(x) cosh(x)
#else
  typedef double complex s7_Complex;
#endif

/* Trigonometric functions. FreeBSD's math library does not include the complex form of the trig funcs. */ 

/* FreeBSD supplies cabs carg cimag creal conj csqrt, so can we assume those exist if complex.h exists?
 */

#if 0
static s7_Double carg(s7_Complex z)
{ 
  return(atan2(cimag(z), creal(z))); 
} 


static s7_Double cabs(s7_Complex z) 
{ 
  return(hypot(creal(z), cimag(z))); 
} 


static s7_Complex conj(s7_Complex z) 
{ 
  return(~z); 
} 


static s7_Complex csqrt(s7_Complex z) 
{ 
  if (cimag(z) < 0.0) 
    return(conj(csqrt(conj(z)))); 
  else 
    { 
      s7_Double r = cabs(z); 
      s7_Double x = creal(z); 
      
      return(sqrt((r + x) / 2.0) + sqrt((r - x) / 2.0) * _Complex_I); 
    } 
} 
#endif


#if (!HAVE_COMPLEX_TRIG)

#if (!__cplusplus)
static s7_Complex csin(s7_Complex z) 
{ 
  return(sin(creal(z)) * cosh(cimag(z)) + (cos(creal(z)) * sinh(cimag(z))) * _Complex_I); 
} 


static s7_Complex ccos(s7_Complex z) 
{ 
  return(cos(creal(z)) * cosh(cimag(z)) + (-sin(creal(z)) * sinh(cimag(z))) * _Complex_I); 
} 


static s7_Complex csinh(s7_Complex z) 
{ 
  return(sinh(creal(z)) * cos(cimag(z)) + (cosh(creal(z)) * sin(cimag(z))) * _Complex_I); 
} 


static s7_Complex ccosh(s7_Complex z) 
{ 
  return(cosh(creal(z)) * cos(cimag(z)) + (sinh(creal(z)) * sin(cimag(z))) * _Complex_I); 
} 
#endif


static s7_Complex ctan(s7_Complex z) 
{ 
  return(csin(z) / ccos(z)); 
} 


static s7_Complex ctanh(s7_Complex z) 
{ 
  return(csinh(z) / ccosh(z)); 
} 


#if (!__cplusplus)
static s7_Complex cexp(s7_Complex z) 
{ 
  return(exp(creal(z)) * cos(cimag(z)) + (exp(creal(z)) * sin(cimag(z))) * _Complex_I); 
} 


static s7_Complex clog(s7_Complex z) 
{ 
  return(log(s7_Double_abs(cabs(z))) + carg(z) * _Complex_I); 
} 


static s7_Complex cpow(s7_Complex x, s7_Complex y) 
{ 
  s7_Double r = cabs(x); 
  s7_Double theta = carg(x); 
  s7_Double yre = creal(y); 
  s7_Double yim = cimag(y); 
  s7_Double nr = exp(yre * log(r) - yim * theta); 
  s7_Double ntheta = yre * theta + yim * log(r); 
  
  return(nr * cos(ntheta) + (nr * sin(ntheta)) * _Complex_I); /* make-polar */ 
} 
#endif


static s7_Complex casin(s7_Complex z) 
{ 
  return(-_Complex_I * clog(_Complex_I * z + csqrt(1.0 - z * z))); 
} 


static s7_Complex cacos(s7_Complex z) 
{ 
  return(-_Complex_I * clog(z + _Complex_I * csqrt(1.0 - z * z))); 
} 


static s7_Complex catan(s7_Complex z) 
{ 
  return(_Complex_I * clog((_Complex_I + z) / (_Complex_I - z)) / 2.0); 
} 


static s7_Complex casinh(s7_Complex z) 
{ 
  return(clog(z + csqrt(1.0 + z * z))); 
} 


static s7_Complex cacosh(s7_Complex z) 
{ 
  return(clog(z + csqrt(z * z - 1.0))); 
  /* perhaps less prone to numerical troubles (untested):
   *   2.0 * clog(csqrt(0.5 * (z + 1.0)) + csqrt(0.5 * (z - 1.0)))
   */
} 


static s7_Complex catanh(s7_Complex z) 
{ 
  return(clog((1.0 + z) / (1.0 - z)) / 2.0); 
} 
#endif

#else
/* not WITH_COMPLEX */
  typedef double s7_Complex;
  #define _Complex_I 1
  #define creal(x) x
  #define cimag(x) x
  #define csin(x) sin(x)
  #define casin(x) x
  #define ccos(x) cos(x)
  #define cacos(x) x
  #define ctan(x) x
  #define catan(x) x
  #define csinh(x) x
  #define casinh(x) x
  #define ccosh(x) x
  #define cacosh(x) x
  #define ctanh(x) x
  #define catanh(x) x
  #define cexp(x) exp(x)
  #define cpow(x, y) pow(x, y)
  #define clog(x) log(x)
  #define csqrt(x) sqrt(x)
  #define conj(x) x
#endif


#if (!WITH_GMP)

bool s7_is_number(s7_pointer p)
{
  return(type(p) == T_NUMBER);
}


bool s7_is_integer(s7_pointer p) 
{ 
  if (!(s7_is_number(p)))
    return(false);
  
  return(number_type(p) == NUM_INT);
}


bool s7_is_real(s7_pointer p) 
{ 
  if (!(s7_is_number(p)))
    return(false);
  
  return(number_type(p) < NUM_COMPLEX);
}


bool s7_is_rational(s7_pointer p)
{
  if (!(s7_is_number(p)))
    return(false);
  
  return(number_type(p) <= NUM_RATIO);
}


bool s7_is_ratio(s7_pointer p)
{
  if (!(s7_is_number(p)))
    return(false);
  
  return(number_type(p) == NUM_RATIO);
}


bool s7_is_complex(s7_pointer p)
{
  return(s7_is_number(p));
}

#endif 
/* !WITH_GMP */


bool s7_is_exact(s7_pointer p)
{
  return(s7_is_rational(p));
}


bool s7_is_inexact(s7_pointer p)
{
  return(!s7_is_rational(p));
}


static s7_Int c_gcd(s7_Int u, s7_Int v)
{
  s7_Int a, b, temp;
  
  a = s7_Int_abs(u);  /* trouble if either is most-negative-fixnum... */
  b = s7_Int_abs(v);
  while (b != 0)
    {
      temp = a % b;
      a = b;
      b = temp;
    }
  if (a < 0)
    return(-a);
  return(a);
}


static bool c_rationalize(s7_Double ux, s7_Double error, s7_Int *numer, s7_Int *denom)
{
  /*
    (define* (rat ux (err 0.0000001))
      ;; translated from CL code in Canny, Donald, Ressler, "A Rational Rotation Method for Robust Geometric Algorithms"
      (let ((x0 (- ux error))
	    (x1 (+ ux error)))
        (let ((i (ceiling x0))
	      (i0 (floor x0))
	      (i1 (ceiling x1))
	      (r 0))
          (if (>= x1 i)
	      i
	      (do ((p0 i0 (+ p1 (* r p0)))
	           (q0 1 (+ q1 (* r q0)))
	           (p1 i1 p0)
	           (q1 1 q0)
	           (e0 (- i1 x0) e1p)
	           (e1 (- x0 i0) (- e0p (* r e1p)))
	           (e0p (- i1 x1) e1)
	           (e1p (- x1 i0) (- e0 (* r e1))))
	          ((<= x0 (/ p0 q0) x1)
	           (/ p0 q0))
	        (set! r (min (floor (/ e0 e1))
			     (ceiling (/ e0p e1p)))))))))
  */
  
  double x0, x1, val;
  s7_Int i, i0, i1, r, r1, p0, q0, p1, q1;
  double e0, e1, e0p, e1p;
  s7_Int old_p1, old_q1;
  double old_e0, old_e1, old_e0p;
  /* don't use s7_Double here;  if it is "long double", the loop below will hang */

  /* #e1e19 is a killer -- it's bigger than most-positive-fixnum, but if we ceil(ux) below
   *   it turns into most-negative-fixnum.  1e19 is trouble in many places.
   */
  if ((ux > s7_Int_max) || (ux < s7_Int_min))
    {
      /* can't return false here because that confuses some of the callers!
       */
      if (ux > s7_Int_min) (*numer) = s7_Int_max; else (*numer) = s7_Int_min;
      (*denom) = 1;
      return(true);
    }

  if (error < 0.0) error = -error;
  x0 = ux - error;
  x1 = ux + error;
  i = (s7_Int)ceil(x0);
  
  if (error >= 1.0) /* aw good grief! */
    {
      if (x0 < 0)
	{
	  if (x1 < 0)
	    (*numer) = (s7_Int)floor(x1);
	  else (*numer) = 0;
	}
      else
	{
	  (*numer) = i;
	}
      (*denom) = 1;
      return(true);
    }
  
  if (x1 >= i)
    {
      if (i >= 0)
	(*numer) = i;
      else (*numer) = (s7_Int)floor(x1);
      (*denom) = 1;
      return(true);
    }

  i0 = (s7_Int)floor(x0);
  i1 = (s7_Int)ceil(x1);

  p0 = i0; 
  q0 = 1;
  p1 = i1; 
  q1 = 1; 
  e0 = i1 - x0;
  e1 = x0 - i0;
  e0p = i1 - x1;
  e1p = x1 - i0;

  while (true)
    {
      val = (double)p0 / (double)q0;
      
      if (((x0 <= val) && (val <= x1)) ||
	  (e1 == 0) ||
	  (e1p == 0))
	{
	  (*numer) = p0;
	  (*denom) = q0;
	  return(true);
	}

      r = (s7_Int)floor(e0 / e1);
      r1 = (s7_Int)ceil(e0p / e1p);
      if (r1 < r) r = r1;

      /* Scheme "do" handles all step vars in parallel */
      old_p1 = p1;
      p1 = p0;
      old_q1 = q1;
      q1 = q0;
      old_e0 = e0;
      e0 = e1p;
      old_e0p = e0p;
      e0p = e1;
      old_e1 = e1;

      p0 = old_p1 + r * p0;
      q0 = old_q1 + r * q0;
      e1 = old_e0p - r * e1p;
      /* if the error is set too low, we can get e1 = 0 here: (rationalize (/ pi) 1e-17) */
      e1p = old_e0 - r * old_e1;
    }
  return(false);
}

#if 0
/* there is another way to rationalize.  Here is a scheme version of
 *   Bill Gosper's farint:

(define* (farint x (err 1/1000000))
  
  (define* (farint-1 x nhi dhi (ln 0) (ld 1) (hn 1) (hd 0))
    (if (> (+ ln hn) (* (+ ld hd) x))
	(let* ((m (min (if (= 0 ln) 
			   nhi 
			 (floor (/ (- nhi hn) ln)))
		       (floor (/ (- dhi hd) ld))))
	       (d (- (* x ld) ln))
	       (k (if (= 0 d) 
		      m 
		    (ceiling (/ (- hn (* x hd)) d)))))
	  (if (< k m)
	      (let ((hn1 (+ (* k ln) hn))
		    (hd1 (+ (* k ld) hd)))
		(farint-1 x nhi dhi hn1 hd1 (- hn1 ln) (- hd1 ld)))

	    (let* ((n (+ (* m ln) hn)) (d (+ (* m ld) hd)))
	      (if (< (* 2 d ld x) (+ (* ld n) (* ln d)))
		  (/ ln ld) 
		(/ n d)))))

      (let* ((m (min (floor (/ (- nhi ln) hn))
		     (if (= 0 hd) 
			 dhi 
		       (floor (/ (- dhi ld) hd)))))
	     (d (- hn (* x hd)))
	     (k (if (= 0 d) 
		    m 
		  (ceiling (/ (- (* x ld) ln) d)))))
	(if (< k m)
	    (let ((ln1 (+ (* k hn) ln))
		  (ld1 (+ (* k hd) ld)))
	    (farint-1 x nhi dhi (- ln1 hn) (- ld1 hd) ln1 ld1))
	  (let* ((n (+ (* m hn) ln)) (d (+ (* m hd) ld)))
	    (if (< (* 2 d hd x) (+ (* hd n) (* hn d)))
		(/ n d) 
	      (/ hn hd)))))))

  (farint-1 x (/ err) (/ err)))
*/
#endif


s7_pointer s7_rationalize(s7_scheme *sc, s7_Double x, s7_Double error)
{
  s7_Int numer = 0, denom = 1;
  if (c_rationalize(x, error, &numer, &denom))
    return(s7_make_ratio(sc, numer, denom));
  return(s7_make_real(sc, x));
}


static s7_Double num_to_real(s7_num_t n)
{
  if (n.type >= NUM_REAL)
    return(real(n));
  if (n.type == NUM_INT)
    return((s7_Double)integer(n));
  return(fraction(n));
}


static s7_Int num_to_numerator(s7_num_t n)
{
  if (n.type == NUM_RATIO)
    return(numerator(n));
  return(integer(n));
}


static s7_Int num_to_denominator(s7_num_t n)
{
  if (n.type == NUM_RATIO)
    return(denominator(n));
  return(1);
}

static s7_Double num_to_real_part(s7_num_t n)
{
  /* no bignum parallel */
  switch (n.type)
    {
    case NUM_INT:   return((s7_Double)integer(n));
    case NUM_RATIO: return(fraction(n));
    case NUM_REAL:
    case NUM_REAL2: return(real(n));
    default:        return(real_part(n));
    }
}


static s7_Double num_to_imag_part(s7_num_t n)
{
  if (n.type >= NUM_COMPLEX)
    return(imag_part(n));
  return(0.0);
}


static s7_num_t make_ratio(s7_Int numer, s7_Int denom)
{
  s7_num_t ret;
  s7_Int divisor;

  if (numer == 0)
    {
      ret.type = NUM_INT;
      integer(ret) = 0;
      return(ret);
    }
  
  if (denom < 0)
    {
      numer = -numer;
      denom = -denom;
      /* this doesn't work in the case (/ most-positive-fixnum most-negative-fixnum)
       *   because (= (- most-negative-fixnum) most-negative-fixnum) is #t.
       */
    }
  
  divisor = c_gcd(numer, denom);
  if (divisor != 1)
    {
      numer /= divisor;
      denom /= divisor;
    }
  
  if (denom == 1)
    {
      ret.type = NUM_INT;
      integer(ret) = numer;
    }
  else
    {
      ret.type = NUM_RATIO;
      numerator(ret) = numer;
      denominator(ret) = denom;
    }
  return(ret);
}


s7_pointer s7_make_integer(s7_scheme *sc, s7_Int n) 
{
  s7_pointer x;

  if (n < NUM_SMALL_INTS)
    {
      if (n >= 0)
	return(small_ints[n]);
      if (n > (-NUM_SMALL_INTS))
	return(small_negative_ints[-n]);
    }

  NEW_CELL(sc, x); /*   6 5 */
  set_type(x, T_NUMBER | T_DONT_COPY);
  number_type(x) = NUM_INT;
  integer(number(x)) = n;

  return(x);
}


static s7_pointer make_mutable_integer(s7_scheme *sc, s7_Int n)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_NUMBER | T_DONT_COPY);
  number_type(x) = NUM_INT;
  integer(number(x)) = n;
  return(x);
}


static s7_pointer make_permanent_integer(s7_Int i)
{
  s7_pointer p;
  p = (s7_pointer)calloc(1, sizeof(s7_cell));
  typeflag(p) = T_IMMUTABLE | T_NUMBER | T_DONT_COPY;
  p->hloc = NOT_IN_HEAP;
  number_type(p) = NUM_INT;
  integer(number(p)) = i;
  return(p);
}


s7_pointer s7_make_real(s7_scheme *sc, s7_Double n) 
{
  s7_pointer x;

  if (n == 0.0)
    return(real_zero);

  NEW_CELL(sc, x); /* 4   27 */
  set_type(x, T_NUMBER | T_DONT_COPY);
  number_type(x) = NUM_REAL;
  real(number(x)) = n;
  
  return(x);
}


s7_pointer s7_make_complex(s7_scheme *sc, s7_Double a, s7_Double b)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_NUMBER | T_DONT_COPY);
  if (b == 0.0)
    {
      number_type(x) = NUM_REAL;
      real(number(x)) = a;
    }
  else
    {
      number_type(x) = NUM_COMPLEX;
      real_part(number(x)) = a;
      imag_part(number(x)) = b;
    }
  return(x);
}


s7_pointer s7_make_ratio(s7_scheme *sc, s7_Int a, s7_Int b)
{
  s7_pointer x;
  s7_Int divisor;

  if (b == 0)
    return(division_by_zero_error(sc, "make-ratio", list_2(sc, s7_make_integer(sc, a), small_ints[0])));
  if (a == 0)
    return(small_ints[0]);
  if (b == 1)
    return(s7_make_integer(sc, a));

#if (!WITH_GMP)
  if (b == S7_LLONG_MIN)
    {
      if (a == b)
	return(small_int(1));

      /* we've got a problem... This should not trigger an error during reading -- we might have the
       *   ratio on a switch with-bignums or whatever, so its mere occurrence is just an annoyance.
       *   We'll try to do something...
       */
      if (a & 1)
	{
	  if (a == 1)
	    return(s7_make_real(sc, NAN));
	  /* not an error here because 1/9223372036854775808 might be in a block of unevaluated code */
	  b = b + 1;
	}
      else
	{
	  a /= 2;
	  b /= 2;
	}
    }
#endif

  if (b < 0)
    {
      a = -a;
      b = -b;
    }
  divisor = c_gcd(a, b);
  if (divisor != 1)
    {
      a /= divisor;
      b /= divisor;
    }
  if (b == 1)
    return(s7_make_integer(sc, a));
  
  NEW_CELL(sc, x);
  set_type(x, T_NUMBER | T_DONT_COPY);
  number_type(x) = NUM_RATIO;
  numerator(number(x)) = a;
  denominator(number(x)) = b;

  return(x);
}



static s7_pointer exact_to_inexact(s7_scheme *sc, s7_pointer x)
{
  /* this is tricky because a big int can mess up when turned into a double:
   *   (truncate (exact->inexact most-positive-fixnum)) -> -9223372036854775808
   */
  if (s7_is_rational(x))
    return(s7_make_real(sc, s7_number_to_real(x)));
  return(x);
}



static double default_rationalize_error = 1.0e-12;

static s7_pointer inexact_to_exact(s7_scheme *sc, s7_pointer x)
{
  switch (number_type(x))
    {
    case NUM_INT:
    case NUM_RATIO:
      return(x);

    case NUM_REAL:
    case NUM_REAL2:
      {
	s7_Int numer = 0, denom = 1;
	s7_Double val;

	val = s7_real(x);
	if ((isinf(val)) || (isnan(val)))
	  return(s7_wrong_type_arg_error(sc, "inexact->exact", 0, x, "a normal real"));

	if ((val > S7_LLONG_MAX) ||
	    (val < S7_LLONG_MIN))
	  return(s7_out_of_range_error(sc, "inexact->exact", 0, x, "too large to express as an integer"));

	if (c_rationalize(val, default_rationalize_error, &numer, &denom))
	  return(s7_make_ratio(sc, numer, denom));
      }

    default:
      return(s7_wrong_type_arg_error(sc, "inexact->exact", 0, x, "a real"));
    }

  return(x);
}


#if (!WITH_GMP)
s7_Double s7_number_to_real(s7_pointer x)
{
  if (!s7_is_number(x))
    return(0.0); 
  /* what to do?? -- to return #f or throw an error, we need the s7_scheme pointer
   *   some sort of check is needed for FFI calls -- not a number -> segfault
   */

  switch (number_type(x))
    {
    case NUM_INT:   return((s7_Double)s7_integer(x));
    case NUM_RATIO: return((s7_Double)s7_numerator(x) / (s7_Double)s7_denominator(x));
    case NUM_REAL:
    case NUM_REAL2: return(s7_real(x));
    default:        return(complex_real_part(x));
    }
}


s7_Int s7_number_to_integer(s7_pointer x)
{
  switch (number_type(x))
    {
    case NUM_INT:   return(s7_integer(x));
    case NUM_RATIO: return((s7_Int)((s7_Double)s7_numerator(x) / (s7_Double)s7_denominator(x)));
    case NUM_REAL:
    case NUM_REAL2: return((s7_Int)s7_real(x));
    default:        return((s7_Int)complex_real_part(x));
    }
}


s7_Int s7_numerator(s7_pointer x)
{
  if (number_type(x) == NUM_RATIO)
    return(numerator(number(x)));
  return(integer(number(x)));
}


s7_Int s7_denominator(s7_pointer x)
{
  if (number_type(x) == NUM_RATIO)
    return(denominator(number(x)));
  return(1);
}


s7_Double s7_real_part(s7_pointer x)
{
  return(num_to_real_part(number(x)));
}


s7_Double s7_imag_part(s7_pointer x)
{
  return(num_to_imag_part(number(x)));
}


s7_Int s7_integer(s7_pointer p)
{
  return(integer(number(p)));
}


s7_Double s7_real(s7_pointer p)
{
  return(real(number(p)));
}


static s7_Complex s7_complex(s7_pointer p)
{
  return(num_to_real_part(number(p)) + num_to_imag_part(number(p)) * _Complex_I);
}


static s7_pointer s7_from_c_complex(s7_scheme *sc, s7_Complex z)
{
  return(s7_make_complex(sc, creal(z), cimag(z)));
}
#endif


static int integer_length(s7_Int a)
{
  static int bits[256] =
    {0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

  #define I_8 256LL
  #define I_16 65536LL
  #define I_24 16777216LL
  #define I_32 4294967296LL
  #define I_40 1099511627776LL
  #define I_48 281474976710656LL
  #define I_56 72057594037927936LL

  if (a < 0) a = -a;
  if (a < I_8) return(bits[a]);
  if (a < I_16) return(8 + bits[a >> 8]);
  if (a < I_24) return(16 + bits[a >> 16]);
  if (a < I_32) return(24 + bits[a >> 24]);
  if (a < I_40) return(32 + bits[a >> 32]);
  if (a < I_48) return(40 + bits[a >> 40]);
  if (a < I_56) return(48 + bits[a >> 48]);
  return(56 + bits[a >> 56]);
}


static int s7_int_max = 0, s7_int_min = 0, s7_int_bits = 0, s7_int_digits = 0; /* initialized later */
static int s7_int_digits_by_radix[17];

static s7_pointer s7_negate(s7_scheme *sc, s7_pointer p)     /* can't use "negate" because it confuses C++! */
{
  s7_num_t a;
  a = number(p);
  
  switch (a.type)
    {
    case NUM_INT: 
#if WITH_GMP
      if (integer(a) == S7_LLONG_MIN)
	return(big_negate(sc, list_1(sc, promote_number(sc, T_BIG_INTEGER, p))));
#endif	
      return(s7_make_integer(sc, -integer(a)));
      
    case NUM_RATIO:
      return(s7_make_ratio(sc, -numerator(a), denominator(a)));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, -real(a)));
      
    default:
      return(s7_make_complex(sc, -real_part(a), -imag_part(a)));
    }
}


static s7_pointer s7_invert(s7_scheme *sc, s7_pointer p)      /* s7_ to be consistent... */
{
  s7_num_t a;
  a = number(p);

  switch (a.type)
    {
    case NUM_INT:
#if WITH_GMP
      if (integer(a) == S7_LLONG_MIN)
	return(big_invert(sc, list_1(sc, promote_number(sc, T_BIG_INTEGER, p))));
#endif
      return(s7_make_ratio(sc, 1, integer(a)));      /* a already checked, not 0 */
      
    case NUM_RATIO:
      return(s7_make_ratio(sc, denominator(a), numerator(a)));

    case NUM_REAL:
    case NUM_REAL2:
      return(s7_make_real(sc, 1.0 / real(a)));

    default:
      {
	s7_Double r2, i2, den;
	r2 = num_to_real_part(a);
	i2 = num_to_imag_part(a);
	den = (r2 * r2 + i2 * i2);
	return(s7_make_complex(sc, r2 / den, -i2 / den));
      }
    }
}


#if WITH_OPTIMIZATION
static s7_pointer subtract_ratios(s7_scheme *sc, s7_num_t a, s7_num_t b)
{
  s7_Int d1, d2, n1, n2;
  d1 = num_to_denominator(a);
  n1 = num_to_numerator(a);
  d2 = num_to_denominator(b);
  n2 = num_to_numerator(b);
  
  if (d1 == d2)                                     /* the easy case -- if overflow here, it matches the int case */
    return(s7_make_ratio(sc, n1 - n2, d1));

#if (!WITH_GMP)
  if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
      (n1 > s7_int_max) || (n2 > s7_int_max) ||
      (n1 < s7_int_min) || (n2 < s7_int_min))
    {
      int d1bits, d2bits;
      d1bits = integer_length(d1);
      d2bits = integer_length(d2);
      if (((d1bits + d2bits) > s7_int_bits) ||
	  ((d1bits + integer_length(n2)) > (s7_int_bits - 1)) ||
	  ((d2bits + integer_length(n1)) > (s7_int_bits - 1)))
	return(s7_make_real(sc, ((long double)n1 / (long double)d1) - ((long double)n2 / (long double)d2)));
      return(s7_make_ratio(sc, n1 * d2 - n2 * d1, d1 * d2));
    }
#endif
  return(s7_make_ratio(sc, n1 * d2 - n2 * d1, d1 * d2));
}
#endif


#if (!WITH_GMP)
static bool s7_is_negative(s7_pointer obj)
{
  switch (number_type(obj))
    {
    case NUM_INT:   return(s7_integer(obj) < 0);
    case NUM_RATIO: return(s7_numerator(obj) < 0);
    default:        return(s7_real(obj) < 0);
    }
}


static bool s7_is_positive(s7_pointer x)
{
  switch (number_type(x))
    {
    case NUM_INT:   return(s7_integer(x) > 0);
    case NUM_RATIO: return(s7_numerator(x) > 0);
    default:        return(s7_real(x) > 0.0);
    }
}
#endif


static bool s7_is_zero(s7_pointer x)
{
  switch (number_type(x))
    {
    case NUM_INT:   return(s7_integer(x) == 0);
    case NUM_REAL2:
    case NUM_REAL:  return(s7_real(x) == 0.0);
    default:        return(false); /* ratios and complex numbers here are already collapsed into integers and reals */
    }
}


static bool s7_is_one(s7_pointer x)
  {
  switch (number_type(x))
    {
    case NUM_INT:   return(s7_integer(x) == 1);
    case NUM_REAL2:
    case NUM_REAL:  return(s7_real(x) == 1.0);
    default:        return(false);
    }
}


/* optimize exponents */
#define MAX_POW 32
static double pepow[17][MAX_POW], mepow[17][MAX_POW];

static void initialize_pows(void)
{
  int i, j;
  for (i = 2; i < 17; i++)        /* radix between 2 and 16 */
    for (j = 0; j < MAX_POW; j++) /* saved exponent between 0 and +/- MAX_POW */
      {
	pepow[i][j] = pow((double)i, (double)j);
	mepow[i][j] = pow((double)i, (double)(-j));
      }
}

static double ipow(int x, int y)
{
  if ((y < MAX_POW) && (y > (-MAX_POW)))
    {
      if (y >= 0)
	return(pepow[x][y]);
      return(mepow[x][-y]);
    }
  return(pow((double)x, (double)y));
}


static void s7_Int_to_string(char *p, s7_Int n, int radix, int width)
{
  static char dignum[] = "0123456789abcdef";
  int i = 2, len, start = 0, end = 0;
  s7_Int pown = (s7_Int)1;
  bool sign;

  if ((radix < 2) || (radix > 16))
    return;
  if (n == 0)
    {
      if (width <= 1)
	{
	  p[0] = '0';
	  p[1] = '\0';
	}
      else
	{
	  for (i = 0; i < width - 1; i++) 
	    p[i] = ' ';
	  p[width - 1] = '0';
	  p[width] = '\0';
	}
      return;
    }

  if (n == S7_LLONG_MIN)
    {
      /* a special case -- we can't use abs on this because it goes to 0, we won't get here if gmp.
       * (number->string most-negative-fixnum 2) -> "-0" unless we do something special 
       */
      int j;
      p[0] = '-';
      /* build it backwards (will reverse digits below) */
      p[1] = dignum[-(n % (s7_Int)radix)];
      n /= (s7_Int)radix;
      n = -n;
      for (i = 2; n >= (s7_Int)radix; i++)
	{
	  p[i] = dignum[n % (s7_Int)radix];
	  n /= (s7_Int)radix;
	}
      p[i] = dignum[n];
      len = i;
      /* reverse digits (leave sign alone) */
      for (i = 1, j = len; i < j; i++, j--)
	{
	  char tmp;
	  tmp = p[i];
	  p[i] = p[j];
	  p[j] = tmp;
	}
      p[len + 1] = 0;
      return;
      /* there has to be a better way... */
    }
      
  sign = (n < 0);
  n = s7_Int_abs(n); 

  /* the previous version that counted up to n, rather than dividing down below n, as here,
   *   could be confused by large ints on 64 bit machines
   */
  pown = n;
  for (i = 1; i < 100; i++)
    {
      if (pown < radix)
	break;
      pown /= (s7_Int)radix;
    }
  len = i - 1;

  if (sign) len++;

  if (width > len)                  /* (format #f "~10B" 123) */
    {
      start = width - len - 1;
      end += start;
      memset((void *)p, (int)' ', start);
      /*
      for (i = 0; i < start; i++) 
	p[i] = ' ';
      */
    }

  if (sign)
    {
      p[start] = '-';
      end++;
    }

  for (i = start + len; i >= end; i--)
    {
      p[i] = dignum[n % (s7_Int)radix];
      n /= (s7_Int)radix;
    }
  p[len + start + 1] = '\0';
}


static char *pad_number(const char *p, int len, int width)
{
  char *p1;
  int spaces;
  spaces = width - len;
  p1 = (char *)malloc((width + 1) * sizeof(char));
  p1[width] = '\0';
  memset((void *)p1, (int)' ', spaces);
  memcpy((void *)(p1 + spaces), (void *)p, len);
  return(p1);
}


#define BASE_10 10

static char *number_to_string_base_10(s7_pointer obj, int width, int precision, char float_choice)
{
  char *p;
  int len;

#if WITH_GMP
  if (is_c_object(obj))
    return(big_number_to_string_with_radix(obj, BASE_10, width));
  /* this ignores precision because it's way too hard to get the mpfr string to look like
   *   C's output -- we either have to call mpfr_get_str twice (the first time just to 
   *   find out what the exponent is and how long the string actually is), or we have
   *   to do messy string manipulations.  So (format #f "",3F" pi) ignores the "3" and
   *   prints the full string.
   */
#endif

  switch (number_type(obj))
    {
    case NUM_INT:
      len = 64 + width;
      p = (char *)malloc(len * sizeof(char));
      snprintf(p, len, 
	       (sizeof(int) >= sizeof(s7_Int)) ? "%*d" : "%*lld",
	       width, s7_integer(obj));
      break;
      
    case NUM_RATIO:
      p = (char *)malloc(128 * sizeof(char));
      len = snprintf(p, 128,
		     (sizeof(int) >= sizeof(s7_Int)) ? "%d/%d" : "%lld/%lld", 
		     s7_numerator(obj), s7_denominator(obj));
      if (width > len)
	{
	  char *p1;
	  p1 = pad_number(p, len, width);
	  free(p);
	  return(p1);
	}
      break;
      
    case NUM_REAL2:
    case NUM_REAL:
      {
	int i, loc = -1;
	const char *frmt;
	p = (char *)malloc((256 + width) * sizeof(char));

	if (sizeof(double) >= sizeof(s7_Double))
	  frmt = (float_choice == 'g') ? "%*.*g" : ((float_choice == 'f') ? "%*.*f" : "%*.*e");
	else frmt = (float_choice == 'g') ? "%*.*Lg" : ((float_choice == 'f') ? "%*.*Lf" : "%*.*Le");

	len = snprintf(p, 256 + width, frmt, width, precision, s7_real(obj));
	for (i = 0; i < len; i++) /* does it have an exponent (if so, it's already a float) */
	  if (p[i] == 'e')
	    {
	      loc = i;
	      break;
	    }
	if (loc == -1)            /* no, so make it explicitly a float! */
	  {
	    for (i = 0; i < len; i++)  
	      if (p[i] == '.') break;
	    if (i == len)
	      {
		p[i]='.';
		p[i+1]='0';
		p[i+2]='\0';
	      }
	  }
      }
      break;
      
    default:
      {
	const char *frmt;
	p = (char *)malloc(256 * sizeof(char));

	if (sizeof(double) >= sizeof(s7_Double))
	  {
	    if (complex_imag_part(obj) >= 0.0)
	      frmt = (float_choice == 'g') ? "%.*g+%.*gi" : ((float_choice == 'f') ? "%.*f+%.*fi" : "%.*e+%.*ei"); 
	    else frmt = (float_choice == 'g') ? "%.*g%.*gi" : ((float_choice == 'f') ? "%.*f-%.*fi" :"%.*e-%.*ei");
	  }
	else 
	  {
	    if (complex_imag_part(obj) >= 0.0)
	      frmt = (float_choice == 'g') ? "%.*Lg+%.*Lgi" : ((float_choice == 'f') ? "%.*Lf+%.*Lfi" : "%.*Le+%.*Lei");
	    else frmt = (float_choice == 'g') ? "%.*Lg%.*Lgi" : ((float_choice == 'f') ? "%.*Lf-%.*Lfi" : "%.*Le-%.*Lei");
	  }

	len = snprintf(p, 256, frmt, precision, complex_real_part(obj), precision, complex_imag_part(obj));
	if (width > len)
	  {                             /* (format #f "~20g" 1+i) */
	    char *p1;
	    p1 = pad_number(p, len, width);
	    free(p);
	    return(p1);
	  }
      }
      break;
    }
  return(p);
}


static char *number_to_string_with_radix(s7_scheme *sc, s7_pointer obj, int radix, int width, int precision, char float_choice)
{
  char *p, *n, *d;
  int len;

#if WITH_GMP
  if (is_c_object(obj))
    return(big_number_to_string_with_radix(obj, radix, width));
#endif

  if (radix == 10)
    return(number_to_string_base_10(obj, width, precision, float_choice));

  switch (number_type(obj))
    {
    case NUM_INT:
      p = (char *)malloc((128 + width) * sizeof(char));
      s7_Int_to_string(p, s7_integer(obj), radix, width);
      return(p);
      break;
      
    case NUM_RATIO:
      {
	char n[128], d[128];
	s7_Int_to_string(n, s7_numerator(obj), radix, 0);
	s7_Int_to_string(d, s7_denominator(obj), radix, 0);
	p = (char *)malloc(256 * sizeof(char));
	len = snprintf(p, 256, "%s/%s", n, d);
      }
      break;
      
    case NUM_REAL2:
    case NUM_REAL:
      {
	int i;
	s7_Int int_part;
	s7_Double x, frac_part, min_frac, base;
	bool sign = false;
	char n[128], d[256];

	x = s7_real(obj);

	if (isnan(x))
	  return(copy_string("nan.0"));
	if (isinf(x))
	  {
	    if (x < 0.0)
	      return(copy_string("-inf.0"));    
	    return(copy_string("inf.0"));    
	  }

	if (x < 0.0)
	  {
	    sign = true;
	    x = -x;
	  }

	int_part = (s7_Int)floor(x);
	frac_part = x - int_part;
	s7_Int_to_string(n, int_part, radix, 0);
	min_frac = (s7_Double)ipow(radix, -precision);

	for (i = 0, base = radix; (i < precision) && (frac_part > min_frac); i++, base *= radix)
	  {
	    s7_Int ipart;
	    ipart = (int)(frac_part * base);
	    if (ipart >= radix)         /* rounding confusion */
	      ipart = radix - 1;
	    frac_part -= (ipart / base);
	    if (ipart < 10)
	      d[i] = (char)('0' + ipart);
	    else d[i] = (char)('a' + ipart -  10);
	  }
	if (i == 0)
	  d[i++] = '0';
	d[i] = '\0';
	p = (char *)malloc(256 * sizeof(char));
	len = snprintf(p, 256, "%s%s.%s", (sign) ? "-" : "", n, d);
      }
      break;

    default:
      p = (char *)malloc(512 * sizeof(char));
      n = number_to_string_with_radix(sc, s7_make_real(sc, complex_real_part(obj)), radix, 0, precision, float_choice);
      d = number_to_string_with_radix(sc, s7_make_real(sc, complex_imag_part(obj)), radix, 0, precision, float_choice);
      len = snprintf(p, 512, "%s%s%si", n, (complex_imag_part(obj) < 0.0) ? "" : "+", d);
      free(n);
      free(d);
      break;
    }

  if (width > len)
    {
      char *p1;
      p1 = pad_number(p, len, width);
      free(p);
      return(p1);
    }
  return(p);
}


char *s7_number_to_string(s7_scheme *sc, s7_pointer obj, int radix)
{
  return(number_to_string_with_radix(sc, obj, radix, 0, 20, 'g')); 
  /* (log top 10) so we get all the digits in base 10 (??) */
}


static s7_pointer g_number_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_number_to_string "(number->string num (radix 10)) converts the number num into a string."
  s7_Int radix = 10;
  int size = 20;
  char *res;
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "number->string", (is_null(cdr(args))) ? 0 : 1, x, "a number"));

  if (is_pair(cdr(args)))
    {
      s7_pointer y;
      y = cadr(args);
      if (s7_is_integer(y))
	radix = s7_integer(y);
      else return(s7_wrong_type_arg_error(sc, "number->string radix,", 2, y, "an integer"));
      if ((radix < 2) || (radix > 16))
	return(s7_out_of_range_error(sc, "number->string radix,", 2, y, "should be between 2 and 16"));
    }

#if WITH_GMP
  if (s7_is_bignum(x))
    return(make_string_uncopied(sc, big_number_to_string_with_radix(x, radix, 0)));
#endif

  if (number_type(x) > NUM_RATIO)
    {
      /* if size = 20, (number->string .1) gives "0.10000000000000000555", but if it's less than 20,
       *    large numbers (or very small numbers) mess up the less significant digits.
       */
      if (number_type(x) < NUM_COMPLEX)
	{
	  s7_Double val;
	  val = s7_Double_abs(s7_real(x));
	  if ((val < (S7_LONG_MAX / 4)) && (val > 1.0e-6))
	    size = 14;
	}
      else
	{
	  s7_Double rl, im;
	  rl = s7_Double_abs(s7_real_part(x));
	  if ((rl < (S7_LONG_MAX / 4)) && (rl > 1.0e-6))
	    {
	      im = s7_Double_abs(s7_imag_part(x));
	      if ((im < (S7_LONG_MAX / 4)) && (im > 1.0e-6))
		size = 14;
	    }
	}
    }

  if (radix != 10)
    res = number_to_string_with_radix(sc, x, radix, 0, (radix == 10) ? size : 20, 'g');
  else res = number_to_string_base_10(x, 0, size, 'g');
  
  return(make_string_uncopied(sc, res));
}


#define CTABLE_SIZE 256
static bool *exponent_table, *slashify_table, *char_ok_in_a_name, *white_space;
static int *digits;

static void init_ctables(void)
{
  int i;

  exponent_table = (bool *)permanent_calloc(CTABLE_SIZE * sizeof(bool));
  slashify_table = (bool *)permanent_calloc(CTABLE_SIZE * sizeof(bool));
  char_ok_in_a_name = (bool *)permanent_calloc(CTABLE_SIZE * sizeof(bool));
  white_space = (bool *)permanent_calloc(CTABLE_SIZE * sizeof(bool));
  
  for (i = 1; i < CTABLE_SIZE; i++)
    char_ok_in_a_name[i] = true;
  char_ok_in_a_name[0] = false;
  char_ok_in_a_name['('] = false;
  char_ok_in_a_name[')'] = false;
  char_ok_in_a_name[';'] = false;
  char_ok_in_a_name['\t'] = false;
  char_ok_in_a_name['\n'] = false;
  char_ok_in_a_name['\r'] = false;
  char_ok_in_a_name[' '] = false;
  char_ok_in_a_name['"'] = false;
  /* double-quote is recent, but I want '(1 ."hi") to be parsed as '(1 . "hi") 
   * what about stuff like vertical tab?  or comma?
   */

  for (i = 0; i < CTABLE_SIZE; i++)
    white_space[i] = false;
  white_space['\t'] = true;
  white_space['\n'] = true;
  white_space['\r'] = true;
  white_space['\f'] = true;
  white_space['\v'] = true;
  white_space[' '] = true;

  /* surely only 'e' is needed... */
  exponent_table['e'] = true; exponent_table['E'] = true;
#if WITH_EXTRA_EXPONENT_MARKERS
  exponent_table['s'] = true; exponent_table['S'] = true; 
  exponent_table['f'] = true; exponent_table['F'] = true;
  exponent_table['d'] = true; exponent_table['D'] = true;
  exponent_table['l'] = true; exponent_table['L'] = true;
#endif

  for (i = 0; i < 32; i++)
    slashify_table[i] = true;
  for (i = 127; i < 160; i++)
    slashify_table[i] = true;
  slashify_table['\\'] = true;
  slashify_table['"'] = true;
  slashify_table['\n'] = false;

  digits = (int *)permanent_calloc(CTABLE_SIZE * sizeof(int));
  for (i = 0; i < CTABLE_SIZE; i++)
    digits[i] = 256;

  digits['0'] = 0; digits['1'] = 1; digits['2'] = 2; digits['3'] = 3; digits['4'] = 4;
  digits['5'] = 5; digits['6'] = 6; digits['7'] = 7; digits['8'] = 8; digits['9'] = 9;
  digits['a'] = 10; digits['A'] = 10;
  digits['b'] = 11; digits['B'] = 11;
  digits['c'] = 12; digits['C'] = 12;
  digits['d'] = 13; digits['D'] = 13;
  digits['e'] = 14; digits['E'] = 14;
  digits['f'] = 15; digits['F'] = 15;
}


static bool is_white_space(int c)
{
  /* this is much faster than C's isspace, and does not depend on the current locale */
  return((c >= 0) && (white_space[c]));
}


static s7_pointer check_sharp_readers(s7_scheme *sc, const char *name)
{
  s7_pointer reader, value, args;
  int args_loc = -1;
  value = sc->F;
  args = sc->F; /* make g++ happy */

  /* *#reader* is assumed to be an alist of (char . proc)
   *    where each proc takes one argument, the string from just beyond the "#" to the next delimiter.
   *    The procedure can call read-char to read ahead in the current-input-port.
   *    If it returns anything other than #f, that is the value of the sharp expression.
   * This search happens after #|, #t, and #f.
   */

  for (reader = symbol_value(sc->sharp_readers); is_not_null(reader); reader = cdr(reader))
    {
      if (name[0] == s7_character(caar(reader)))
	{
	  if (args_loc == -1)
	    {
	      args = list_1(sc, s7_make_string(sc, name));
	      args_loc = s7_gc_protect(sc, args);
	    }
	  value = s7_call(sc, cdar(reader), args);
	  if (value != sc->F)
	    break;
	}
    }
  if (args_loc != -1)
    s7_gc_unprotect_at(sc, args_loc);

  return(value);
}


static s7_pointer g_sharp_readers_set(s7_scheme *sc, s7_pointer args)
{
  /* new value must be either '() or a proper list of conses (char . func) */
  if (is_null(cadr(args))) return(cadr(args));
  if (is_pair(cadr(args)))
    {
      s7_pointer x;
      for (x = cadr(args); is_pair(x); x = cdr(x))
	{
	  if ((!is_pair(car(x))) ||
	      (!s7_is_character(caar(x))) ||
	      (!s7_is_procedure(cdar(x))))
	    return(sc->ERROR);
	}
      if (is_null(x))
	return(cadr(args));
    }
  return(sc->ERROR);
}


static bool is_abnormal(s7_pointer x)
{
  return((!s7_is_number(x)) ||
	 (isinf(s7_real_part(x))) || 
	 (isinf(s7_imag_part(x))) ||
	 (isnan(s7_real_part(x))) || 
	 (isnan(s7_imag_part(x))));
}


#define NESTED_SHARP false
#define UNNESTED_SHARP true

#define SYMBOL_OK true
#define NO_SYMBOLS false

static s7_pointer make_sharp_constant(s7_scheme *sc, char *name, bool at_top, int radix) 
{
  /* name is the stuff after the '#', return sc->NIL if not a recognized #... entity */
  int len;
  s7_pointer x;

  if ((name[0] == 't') && (name[1] == '\0'))
    return(sc->T);
  
  if ((name[0] == 'f') && (name[1] == '\0'))
    return(sc->F);

  if (is_not_null(symbol_value(sc->sharp_readers)))
    {
      x = check_sharp_readers(sc, name);
      if (x != sc->F)
	return(x);
    }
  
  len = safe_strlen(name);
  if (len < 2)
    return(sc->NIL);
      
  switch (name[0])
    {
      /* -------- #< ... > -------- */
    case '<':
      if (strings_are_equal(name, "<unspecified>"))
	return(sc->UNSPECIFIED);

      if (strings_are_equal(name, "<undefined>"))
	return(sc->UNDEFINED);

      if (strings_are_equal(name, "<eof>"))
	return(sc->EOF_OBJECT);

      return(sc->NIL);
      break;
      

      /* -------- #o #d #x #b -------- */
    case 'o':   /* #o (octal) */
    case 'd':   /* #d (decimal) */
    case 'x':   /* #x (hex) */
    case 'b':   /* #b (binary) */
      {
	bool to_inexact = false, to_exact = false;
	int num_at = 1;
  
	if (name[1] == '#')
	  {
	    if (!at_top)
	      return(sc->NIL);
	    if ((len > 2) && ((name[2] == 'e') || (name[2] == 'i'))) /* r6rs includes caps here */
	      {
		if ((len > 3) && (name[3] == '#'))
		  return(sc->NIL);
		to_inexact = (name[2] == 'i');
		to_exact = (name[2] == 'e');
		num_at = 3;
	      }
	    else return(sc->NIL);
	  }
	/* the #b or whatever overrides any radix passed in earlier */
	x = make_atom(sc, (char *)(name + num_at), (name[0] == 'o') ? 8 : ((name[0] == 'x') ? 16 : ((name[0] == 'b') ? 2 : 10)), NO_SYMBOLS);

	/* #x#i1 apparently makes sense, so #x1.0 should also be accepted.
	 * here we can get #b#e0/0 or #b#e+1/0 etc.
	 * surely if #e1+i is an error (or #f), and #e#x1+i is an error,
	 *   #x#e1+i should also be an error, but #e1+0i is not an error I guess since there actually isn't any imaginary part
	 */
	if (is_abnormal(x))
	  return(sc->NIL);

	if ((!to_exact) && (!to_inexact))
	  return(x);

	if ((s7_imag_part(x) != 0.0) && (to_exact))  /* #x#e1+i */
	  return(sc->NIL);

#if WITH_GMP
	if (s7_is_bignum(x))
	  {
	    if (to_exact)
	      return(big_inexact_to_exact(sc, list_1(sc, x)));
	    return(big_exact_to_inexact(sc, list_1(sc, x)));
	  }
#endif
	if (to_exact)
	  return(inexact_to_exact(sc, x));
	return(exact_to_inexact(sc, x));
      }
      break;


      /* -------- #i -------- */
    case 'i':   /* #i<num> = ->inexact (see token for table of choices here) */
      if (name[1] == '#')
	{
	  /* there are special cases here: "#e0/0" or "#e#b0/0" -- all infs are complex: 
	   *    #i1/0=nan.0 but #i1/0+i=inf+1i so e->i is a no-op but i->e is not
	   *
	   * even trickier: a *#reader* like #t<num> could be used as #e#t13.25 so make_sharp_constant
	   *   needs to be willing to call the readers even when not at_top (i.e. when NESTED_SHARP).
	   */

	  if ((name[2] == 'e') ||                        /* #i#e1 -- assume these aren't redefinable? */
	      (name[2] == 'i'))
	    return(sc->NIL);

	  x = make_sharp_constant(sc, (char *)(name + 2), NESTED_SHARP, radix);
	  if (s7_is_number(x))
	    {
	      if (is_abnormal(x))
		return(sc->NIL);
#if WITH_GMP
	      if (s7_is_bignum(x))                        /* (string->number "#b#e-11e+111") */
		return(big_exact_to_inexact(sc, list_1(sc, x)));
#endif
	      return(exact_to_inexact(sc, x));
	    }
	  return(sc->NIL);
	}
      x = make_atom(sc, (char *)(name + 1), radix, NO_SYMBOLS);
      if (!s7_is_number(x))  /* not is_abnormal(x) -- #i0/0 -> nan etc */
	return(sc->NIL);
#if WITH_GMP
      if (s7_is_bignum(x))
	return(big_exact_to_inexact(sc, list_1(sc, x)));
#endif
      return(exact_to_inexact(sc, x));
      break;
  

      /* -------- #e -------- */
    case 'e':   /* #e<num> = ->exact */
      if (name[1] == '#')
	{
	  if ((name[2] == 'e') ||                        /* #e#e1 */
	      (name[2] == 'i'))
	    return(sc->NIL);

	  x = make_sharp_constant(sc, (char *)(name + 2), NESTED_SHARP, radix);
	  if (s7_is_number(x))
	    {
	      if (is_abnormal(x))                        /* (string->number "#e#b0/0") */
		return(sc->NIL);
	      if (!s7_is_real(x))                        /* (string->number "#e#b1+i") */
		return(sc->NIL);
#if WITH_GMP
	      return(big_inexact_to_exact(sc, list_1(sc, x)));
#endif
	      return(inexact_to_exact(sc, x));
	    }
	  return(sc->NIL);
	}

      x = make_atom(sc, (char *)(name + 1), radix, NO_SYMBOLS);
#if WITH_GMP
      /* #e1e310 is a simple case */
      if (s7_is_bignum(x))
	return(big_inexact_to_exact(sc, list_1(sc, x)));
#endif	
      if (is_abnormal(x))                                /* (string->number "#e0/0") */
	return(sc->NIL);
      if (!s7_is_real(x))                                /* (string->number "#e1+i") */
	return(sc->NIL);
      
#if WITH_GMP
      /* there are non-big floats that are greater than most-positive-fixnum:
       *    :(> .1e20 most-positive-fixnum) -> #t
       *    :(bignum? .1e20) -> #f
       * so we have to check that, not just is it a bignum.
       */
      return(big_inexact_to_exact(sc, list_1(sc, x)));
#endif
      return(inexact_to_exact(sc, x));
      break;


      /* -------- #\... -------- */
    case '\\':
      if (name[2] == 0)                             /* the most common case: #\a */
	return(chars[(unsigned char)(name[1])]);
      /* not unsigned int here!  (unsigned int)255 (as a char) returns -1!! */

      if (strings_are_equal(name + 1, "space")) 
	return(chars[' ']);

      if ((strings_are_equal(name + 1, "newline")) || 
	  (strings_are_equal(name + 1, "linefeed")))
	return(chars['\n']);

      if (strings_are_equal(name + 1, "return")) 
	return(chars['\r']);

      if (strings_are_equal(name + 1, "tab")) 
	return(chars['\t']);

      if ((strings_are_equal(name + 1, "null")) || 
	  (strings_are_equal(name + 1, "nul")))
	return(chars[0]);

      /* the next 4 are for r7rs */
      if (strings_are_equal(name + 1, "alarm")) 
	return(chars[7]);

      if (strings_are_equal(name + 1, "backspace")) 
	return(chars[8]);

      if (strings_are_equal(name + 1, "escape")) 
	return(chars[0x1b]);

      if (strings_are_equal(name + 1, "delete")) 
	return(chars[0x7f]);

      if (name[1] == 'x')     /* #\x is just x, but apparently #\x<num> is int->char? #\x65 -> #\e -- Guile doesn't have this
			       *    (it is from r6rs -- perhaps it is a bad idea...)
			       */
	{
	  /* sscanf here misses errors like #\x1.4, but make_atom misses #\x6/3,
	   *   #\x#b0, #\x#e0.0, #\x-0, #\x#e0e100 etc, so we have to do it at
	   *   an even lower level.
	   */
	  bool happy = true;
	  char *tmp;
	  int lval = 0;

	  tmp = (char *)(name + 2);
	  while ((*tmp) && (happy))
	    {
	      int dig;
	      dig = digits[(int)(*tmp++)];
	      if (dig < 16)
		lval = dig + (lval * 16);
	      else happy = false;
	    }
	  if ((happy) &&
	      (lval < 256))
	    return(chars[lval]);
	}
    }
  return(sc->NIL);
}


static s7_Int string_to_integer(const char *str, int radix, bool *overflow)
{
  bool negative = false;
  s7_Int lval = 0;
  int dig;
  char *tmp = (char *)str;
  char *tmp1;

  if (str[0] == '+')
    tmp++;
  else 
    {
      if (str[0] == '-')
	{
	  negative = true;
	  tmp++;
	}
    }
  while (*tmp == '0') {tmp++;};
  tmp1 = tmp;

 if (radix == 10)
    {
      while (true)
	{
	  dig = digits[(unsigned char)(*tmp++)];
	  if (dig < 10)
	    lval = dig + (lval * 10);
	  else break;
	  dig = digits[(unsigned char)(*tmp++)];
	  if (dig < 10)
	    lval = dig + (lval * 10);
	  else break;
	}
    }
  else
    {
      while (true)
	{
	  dig = digits[(unsigned char)(*tmp++)];
	  if (dig < radix)
	    lval = dig + (lval * radix);
	  else break;
	  dig = digits[(unsigned char)(*tmp++)];
	  if (dig < radix)
	    lval = dig + (lval * radix);
	  else break;
	}
    }

#if WITH_GMP
  (*overflow) = ((lval > S7_LONG_MAX) ||
		 ((tmp - tmp1) > s7_int_digits_by_radix[radix]));
  /* this tells the string->number readers to create a bignum.  We need to be very
   *    conservative here to catch contexts such as (/ 1/524288 19073486328125)
   */
#else
  if ((tmp - tmp1 - 2) > s7_int_digits_by_radix[radix])
    {
      /* I can't decide what to do with these non-gmp overflows.  Perhaps NAN in all cases? 
       *     overflow: 9223372036854775810 -> -9223372036854775806 -- this is not caught currently
       */
      (*overflow) = true;
      if (negative)
	return(s7_Int_min);       /* or INFINITY? */
      return(s7_Int_max);         /* 0/100000000000000000000000000000000000000000000000000000000000000000000 */
    }
#endif

  if (negative)
    return(-lval);
  return(lval);
}


/*  9223372036854775807                9223372036854775807
 * -9223372036854775808               -9223372036854775808
 * 0000000000000000000000000001.0     1.0
 * 1.0000000000000000000000000000     1.0
 * 1000000000000000000000000000.0e-40 1.0e-12
 * 0.0000000000000000000000000001e40  1.0e12
 * 1.0e00000000000000000001           10.0
 */

static s7_Double string_to_double_with_radix(const char *ur_str, int radix, bool *overflow)
{
  /* strtod follows LANG which is not what we want (only "." is decimal point in Scheme).
   *   To overcome LANG in strtod would require screwing around with setlocale which never works.
   *   So we use our own code -- according to valgrind, this function is much faster than strtod.
   *
   * comma as decimal point causes ambiguities: `(+ ,1 2) etc
   */

  int i, sign = 1, frac_len, int_len, dig, max_len, exponent = 0;
  long long int int_part = 0, frac_part = 0;
  char *str;
  char *ipart, *fpart;
  s7_Double dval = 0.0;

  /* there's an ambiguity in number notation here if we allow "1e1" or "1.e1" in base 16 (or 15) -- is e a digit or an exponent marker?
   *   but 1e+1, for example disambiguates it -- kind of messy! -- the scheme spec says "e" can only occur in base 10. 
   *   mpfr says "e" as exponent only in bases <= 10 -- else use '@' which works in any base.  This can only cause confusion
   *   in scheme, unfortunately, due to the idiotic scheme polar notation.  But we accept "s" and "l" as exponent markers
   *   so, perhaps for radix > 10, the exponent, if any, has to use one of S s L l?  Not "l"!  And "s" originally meant "short".
   *
   * Another slight ambiguity: 1+1/2i is parsed as 1 + 0.5i, not 1+1/(2i), or (1+1)/(2i) or (1+1/2)i etc
   */

  max_len = s7_int_digits_by_radix[radix];
  str = (char *)ur_str;

  if (*str == '+')
    str++;
  else
    {
      if (*str == '-')
	{
	  str++;
	  sign = -1;
	}
    }
  while (*str == '0') {str++;};

  ipart = str;
  while (digits[(int)(*str)] < radix) str++;
  int_len = str - ipart;

  if (*str == '.') str++;
  fpart = str;
  while (digits[(int)(*str)] < radix) str++;
  frac_len = str - fpart;

  if ((*str) && (exponent_table[(unsigned char)(*str)]))
    {
      int exp_negative = false;
      str++;
      if (*str == '+') 
	str++;
      else
	{
	  if (*str == '-')
	    {
	      str++;
	      exp_negative = true;
	    }
	}
      while ((dig = digits[(int)(*str++)]) < 10) /* exponent is always base 10 */
	exponent = dig + (exponent * 10);
      if (exp_negative) exponent = -exponent;
    }

#if WITH_GMP
  /* 9007199254740995.0 */

  if (int_len + frac_len >= max_len)
    {
      (*overflow) = true;
      return(0.0);
    }
#endif
      
  str = ipart;
  if ((int_len + exponent) > max_len)
    {
      /*  12341234.56789e12                   12341234567889999872.0              1.234123456789e+19
       * -1234567890123456789.0              -1234567890123456768.0              -1.2345678901235e+18
       *  12345678901234567890.0              12345678901234567168.0              1.2345678901235e+19
       *  123.456e30                          123456000000000012741097792995328.0 1.23456e+32
       *  12345678901234567890.0e12           12345678901234569054409354903552.0  1.2345678901235e+31
       *  1.234567890123456789012e30          1234567890123456849145940148224.0   1.2345678901235e+30
       *  1e20                                100000000000000000000.0             1e+20
       *  1234567890123456789.0               1234567890123456768.0               1.2345678901235e+18
       *  123.456e16                          1234560000000000000.0               1.23456e+18
       *  98765432101234567890987654321.0e-5  987654321012345728401408.0          9.8765432101235e+23
       *  98765432101234567890987654321.0e-10 9876543210123456512.0               9.8765432101235e+18
       *  0.00000000000000001234e20           1234.0
       *  0.000000000000000000000000001234e30 1234.0
       *  0.0000000000000000000000000000000000001234e40 1234.0
       *  0.000000000012345678909876543210e15 12345.678909877
       *  0e1000                              0.0
       */

      for (i = 0; i < max_len; i++)
	{
	  dig = digits[(int)(*str++)];
	  if (dig < radix)
	    int_part = dig + (int_part * radix);
	  else break;
	}

      /* if the exponent is huge, check for 0 int_part and frac_part before complaining (0e1000 or 0.0e1000) */
      if ((int_part == 0) &&
	  (exponent > max_len))
	{
	  /* if frac_part is also 0, return 0.0 */
	  if (frac_len == 0)
	    return(0.0);

	  str = fpart;
	  while ((dig = digits[(int)(*str++)]) < radix)
	    frac_part = dig + (frac_part * radix);
	  if (frac_part == 0)
	    return(0.0);

#if WITH_GMP
	  (*overflow) = true;
#endif
	}
      
#if WITH_GMP
      (*overflow) = ((int_part > 0) || (exponent > 20));    /* .1e310 is a tricky case */
#endif
      
      if (int_part != 0) /* 0.<310 zeros here>1e310 for example --
			  *   pow (via ipow) thinks it has to be too big, returns Nan,
			  *   then Nan * 0 -> Nan and the NaN progogates
			  */
	{
	  if (int_len <= max_len)
	    dval = int_part * ipow(radix, exponent);
	  else dval = int_part * ipow(radix, exponent + int_len - max_len);
	}
      else dval = 0.0;

      /* shift by exponent, but if int_len > max_len then we assumed (see below) int_len - max_len 0's on the left */
      /*   using int_to_int or table lookups here instead of pow did not make any difference in speed */

      if (int_len < max_len)
	{
	  int k, flen;
	  str = fpart;
	  
	  for (k = 0; (frac_len > 0) && (k < exponent); k += max_len)
	    {
	      if (frac_len > max_len) flen = max_len; else flen = frac_len;
	      frac_len -= max_len;

	      frac_part = 0;
	      for (i = 0; i < flen; i++)
		frac_part = digits[(int)(*str++)] + (frac_part * radix);

	      if (frac_part != 0)                                /* same pow->NaN problem as above can occur here */
		dval += frac_part * ipow(radix, exponent - flen - k);
	    }
	}
      else
	{
	  /* some of the fraction is in the integer part before the negative exponent shifts it over */
	  if (int_len > max_len)
	    {
	      int ilen;
	      /* str should be at the last digit we read */
	      ilen = int_len - max_len;                          /* we read these above */
	      if (ilen > max_len)
		ilen = max_len;

	      for (i = 0; i < ilen; i++)
		frac_part = digits[(int)(*str++)] + (frac_part * radix);

	      dval += frac_part * ipow(radix, exponent - ilen);
	    }
	}

      return(sign * dval);
    }

  /* int_len + exponent <= max_len */

  if (int_len <= max_len)
    {
      char *iend;
      int int_exponent;

      /* a better algorithm (since the inaccuracies are in the radix^exponent portion):
       *   strip off leading zeros and possible sign,
       *   strip off digits beyond max_len, then remove any trailing zeros.
       *     (maybe fiddle with the lowest order digit here for rounding, but I doubt it matters)
       *   read digits until end of number or max_len reached, ignoring the decimal point
       *   get exponent and use it and decimal point location to position the current result integer
       * this always combines the same integer and the same exponent no matter how the number is expressed.
       */

      int_exponent = exponent;
      if (int_len > 0)
	{
	  iend = (char *)(str + int_len - 1);
	  while ((*iend == '0') && (iend != str)) {iend--; int_exponent++;}

	  while (str <= iend)
	    int_part = digits[(int)(*str++)] + (int_part * radix);
	}
      if (int_exponent != 0)
	dval = int_part * ipow(radix, int_exponent);
      else dval = (s7_Double)int_part;
    }
  else
    {
      int len, flen;
      long long int fpart = 0;

      /* 98765432101234567890987654321.0e-20    987654321.012346  
       * 98765432101234567890987654321.0e-29    0.98765432101235
       * 98765432101234567890987654321.0e-30    0.098765432101235
       * 98765432101234567890987654321.0e-28    9.8765432101235
       */

      len = int_len + exponent;
      for (i = 0; i < len; i++)
	int_part = digits[(int)(*str++)] + (int_part * radix);
      
      flen = -exponent;
      if (flen > max_len)
	flen = max_len;

      for (i = 0; i < flen; i++)
	fpart = digits[(int)(*str++)] + (fpart * radix);

      if (len <= 0)
	dval = int_part + fpart * ipow(radix, len - flen);
      else dval = int_part + fpart * ipow(radix, -flen);
    }

  if (frac_len > 0)
    {
      str = fpart;
      if (frac_len <= max_len)
	{
	  /* splitting out base 10 case saves very little here */
	  /* this ignores trailing zeros, so that 0.3 equals 0.300 */
	  char *fend;
	  
	  fend = (char *)(str + frac_len - 1);
	  while ((*fend == '0') && (fend != str)) {fend--; frac_len--;} /* (= .6 0.6000) */
	  
	  while (str <= fend)
	    frac_part = digits[(int)(*str++)] + (frac_part * radix);
	  dval += frac_part * ipow(radix, exponent - frac_len);
	  
	  /* fprintf(stderr, "frac: %lld, exp: (%d %d) %.20f, val: %.20f\n", frac_part, exponent, frac_len, ipow(radix, exponent - frac_len), dval); 
	   * 0.6:    frac:    6, exp: 0.10000000000000000555, val: 0.60000000000000008882
	   * 0.60:   frac:   60, exp: 0.01000000000000000021, val: 0.59999999999999997780
	   * 0.6000: frac: 6000, exp: 0.00010000000000000000, val: 0.59999999999999997780
	   * :(= 0.6 0.60)
	   * #f
	   * :(= #i3/5 0.6)
	   * #f
	   * so (string->number (number->string num)) == num only if both num's are the same text (or you get lucky)
	   * :(= 0.6 6e-1) ; but not 60e-2
	   * #t
	   *
	   * to fix the 0.60 case, we need to ignore trailing post-dot zeros.
	   */
	}
      else
	{
	  if (exponent <= 0)
	    {
	      for (i = 0; i < max_len; i++)
		frac_part = digits[(int)(*str++)] + (frac_part * radix);
	      
	      dval += frac_part * ipow(radix, exponent - max_len);
	    }
	  else
	    {
	      /* 1.0123456789876543210e1         10.12345678987654373771  
	       * 1.0123456789876543210e10        10123456789.87654304504394531250
	       * 0.000000010000000000000000e10   100.0
	       * 0.000000010000000000000000000000000000000000000e10 100.0
	       * 0.000000012222222222222222222222222222222222222e10 122.22222222222222
	       * 0.000000012222222222222222222222222222222222222e17 1222222222.222222
	       */
	      
	      int_part = 0;
	      for (i = 0; i < exponent; i++)
		int_part = digits[(int)(*str++)] + (int_part * radix);
	      
	      frac_len -= exponent;
	      if (frac_len > max_len)
		frac_len = max_len;
	      
	      for (i = 0; i < frac_len; i++)
		frac_part = digits[(int)(*str++)] + (frac_part * radix);
	      
	      dval += int_part + frac_part * ipow(radix, -frac_len);
	    }
	}
    }

#if WITH_GMP
  if ((int_part == 0) &&
      (frac_part == 0))
    return(0.0);
  (*overflow) = ((frac_len - exponent) > max_len);
#endif
  
  return(sign * dval);
}


/* make symbol or number atom from string */

static s7_pointer make_atom(s7_scheme *sc, char *q, int radix, bool want_symbol) 
{
  #define ISDIGIT(Chr, Rad) (digits[(unsigned char)Chr] < Rad)

  char c, *p;
  bool has_dec_point1 = false;

  p = q;
  c = *p++; 
  
  /* a number starts with + - . or digit, but so does 1+ for example */
  
  switch (c)
    {
    case '#':
      return(make_sharp_constant(sc, p, UNNESTED_SHARP, radix)); /* make_sharp_constant expects the '#' to be removed */

    case '+':
    case '-':
      c = *p++; 
      if (c == '.') 
	{ 
	  has_dec_point1 = true; 
	  c = *p++; 
	} 
      if ((!c) || (!ISDIGIT(c, radix)))
	return((want_symbol) ? make_symbol(sc, q) : sc->F);
      break;

    case '.':
      has_dec_point1 = true; 
      c = *p++; 

      if ((!c) || (!ISDIGIT(c, radix)))
	return((want_symbol) ? make_symbol(sc, q) : sc->F); 
      break;

    case '0':        /* these two are always digits */
    case '1':
      break;

    default:
      if (!ISDIGIT(c, radix))
	return((want_symbol) ? make_symbol(sc, q) : sc->F); 
      break;
    }

  /* now it's possibly a number -- the 1st character(s) could be part of a number in the current radix */

  {
    char *slash1 = NULL, *slash2 = NULL, *plus = NULL, *ex1 = NULL, *ex2 = NULL;
    bool has_i = false, has_dec_point2 = false;
    int has_plus_or_minus = 0, current_radix;

#if (!WITH_GMP)
    bool overflow = false;
#endif
    current_radix = radix;  /* current_radix is 10 for the exponent portions, but radix for all the rest */
  
    for ( ; (c = *p) != 0; ++p)
      {
	/* what about embedded null? (string->number (string #\1 (integer->char 0) #\0)) 
	 *   currently we stop and return 1, but Guile returns #f
	 */
	if (!ISDIGIT(c, current_radix))         /* moving this inside the switch statement was much slower */
	  {
	    current_radix = radix;
	    
	    switch (c)
	      {
		/* -------- decimal point -------- */
	      case '.':
		if (((has_dec_point1) ||
		     (slash1)) &&
		    (has_plus_or_minus == 0)) /* 1.. or 1/2. */
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if (((has_dec_point2) ||
		     (slash2)) &&
		    (has_plus_or_minus != 0)) /* 1+1.. or 1+1/2. */
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if ((!ISDIGIT(p[1], current_radix)) &&
		    (!ISDIGIT(p[-1], current_radix))) 
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if (has_plus_or_minus == 0)
		  has_dec_point1 = true;
		else has_dec_point2 = true;
		continue;

		
		/* -------- exponent marker -------- */
	      case 'e': case 'E':
#if WITH_EXTRA_EXPONENT_MARKERS
	      case 's': case 'S':
	      case 'd': case 'D':
	      case 'f': case 'F':
	      case 'l': case 'L':
#endif
		if (current_radix > 10)
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		/* see note above */
		
		current_radix = 10;
		
		if (((ex1) ||
		     (slash1)) &&
		    (has_plus_or_minus == 0)) /* ee */
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if (((ex2) ||
		     (slash2)) &&
		    (has_plus_or_minus != 0)) /* 1+1.0ee */
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if ((!ISDIGIT(p[-1], current_radix)) &&
		    (p[-1] != '.'))
		  return((want_symbol) ? make_symbol(sc, q) : sc->F); 
		
		if (has_plus_or_minus == 0)
		  {
		    ex1 = p;
		    has_dec_point1 = true; /* decimal point illegal from now on */
		  }
		else 
		  {
		    ex2 = p;
		    has_dec_point2 = true;
		  }
		p++;
		if ((*p == '-') || (*p == '+')) p++;
		if (ISDIGIT(*p, current_radix))
		  continue;
		break;


		/* -------- internal + or - -------- */
	      case '+':
	      case '-':
		if (has_plus_or_minus != 0) /* already have the separator */
		  return((want_symbol) ? make_symbol(sc, q) : sc->F);
		
		if (c == '+') has_plus_or_minus = 1; else has_plus_or_minus = -1;
		plus = (char *)(p + 1);
		continue;
		
		/* ratio marker */
	      case '/':
		if ((has_plus_or_minus == 0) &&
		    ((ex1) ||
		     (slash1) ||
		     (has_dec_point1)))
		  return((want_symbol) ? make_symbol(sc, q) : sc->F);
		
		if ((has_plus_or_minus != 0) &&
		    ((ex2) ||
		     (slash2) ||
		     (has_dec_point2)))
		  return((want_symbol) ? make_symbol(sc, q) : sc->F);
		
		if (has_plus_or_minus == 0)
		  slash1 = (char *)(p + 1);
		else slash2 = (char *)(p + 1);
		
		if ((!ISDIGIT(p[1], current_radix)) ||
		    (!ISDIGIT(p[-1], current_radix)))
		  return((want_symbol) ? make_symbol(sc, q) : sc->F);
		
		continue;


		/* -------- i for the imaginary part -------- */
	      case 'i':
		if ((has_plus_or_minus != 0) && 
		    (!has_i))
		  {
		    has_i = true;
		    continue;
		  }
		break;

	      default:
		break;
	      }

	    return((want_symbol) ? make_symbol(sc, q) : sc->F);
	  }
      }
    
    if ((has_plus_or_minus != 0) &&        /* that is, we have an internal + or - */
	(!has_i))                          /*   but no i for the imaginary part */
      return((want_symbol) ? make_symbol(sc, q) : sc->F);

    if (has_i)
      {
#if (!WITH_GMP)
	s7_Double rl = 0.0, im = 0.0;
#else
	char e1 = 0, e2 = 0;
#endif
	s7_pointer result;
	int len;
	char ql1, pl1;
	
	len = safe_strlen(q);
	
	if (q[len - 1] != 'i')
	  return((want_symbol) ? make_symbol(sc, q) : sc->F);
	
	/* save original string */
	ql1 = q[len - 1];
	pl1 = (*(plus - 1));
#if WITH_GMP
	if (ex1) {e1 = *ex1; (*ex1) = 'e';} /* for mpfr */
	if (ex2) {e2 = *ex2; (*ex2) = 'e';}
#endif
	
	/* look for cases like 1+i */
	if ((q[len - 2] == '+') || (q[len - 2] == '-'))
	  q[len - 1] = '1';
	else q[len - 1] = '\0'; /* remove 'i' */
	
	(*((char *)(plus - 1))) = '\0';
	
	/* there is a slight inconsistency here:
	   1/0      -> nan.0
           1/0+0i   -> inf.0 (0/1+0i is 0.0)
	   #i1/0+0i -> inf.0
	   0/0      -> nan.0
	   0/0+0i   -> -nan.0
	*/

#if (!WITH_GMP)
	if ((has_dec_point1) ||
	    (ex1))
	  {
	    /* (string->number "1100.1+0.11i" 2) -- need to split into 2 honest reals before passing to non-base-10 str->dbl */
	    rl = string_to_double_with_radix(q, radix, &overflow);
	  }
	else
	  {
	    if (slash1)
	      {
		/* here the overflow could be innocuous if it's in the denominator and the numerator is 0
		 *    0/100000000000000000000000000000000000000-0i
		 */
		s7_Int num, den;
		num = string_to_integer(q, radix, &overflow);
		den = string_to_integer(slash1, radix, &overflow);
		
		if ((num == 0) && (den != 0))
		  {
		    rl = 0.0;
		    overflow = false;
		  }
		else rl = (s7_Double)num / (s7_Double)den;
	      }
	    else rl = (s7_Double)string_to_integer(q, radix, &overflow);
	    if (overflow) return(s7_make_real(sc, NAN));
	  }
	if (rl == -0.0) rl = 0.0;
	
	if ((has_dec_point2) ||
	    (ex2))
	  im = string_to_double_with_radix(plus, radix, &overflow);
	else
	  {
	    if (slash2)
	      {
		/* same as above: 0-0/100000000000000000000000000000000000000i
		 */
		s7_Int num, den;
		num = string_to_integer(plus, radix, &overflow);
		den = string_to_integer(slash2, radix, &overflow);
		if ((num == 0) && (den != 0))
		  {
		    im = 0.0;
		    overflow = false;
		  }
		else im = (s7_Double)num / (s7_Double)den;
	      }
	    else im = (s7_Double)string_to_integer(plus, radix, &overflow);
	    if (overflow) return(s7_make_real(sc, NAN));
	  }
	if ((has_plus_or_minus == -1) && 
	    (im != 0.0))
	  im = -im;
	result = s7_make_complex(sc, rl, im);
#else
	result = string_to_either_complex(sc, q, slash1, ex1, has_dec_point1, plus, slash2, ex2, has_dec_point2, radix, has_plus_or_minus);
#endif
	
	/* restore original string */
	q[len - 1] = ql1;
	(*((char *)(plus - 1))) = pl1;
#if WITH_GMP
	if (ex1) (*ex1) = e1;
	if (ex2) (*ex2) = e2;
#endif
	
	return(result);
      }
    
    /* not complex */
    if ((has_dec_point1) ||
	(ex1))
      {
	s7_pointer result;
	
	if (slash1)  /* not complex, so slash and "." is not a number */
	  return((want_symbol) ? make_symbol(sc, q) : sc->F);
	
#if (!WITH_GMP)
	result = s7_make_real(sc, string_to_double_with_radix(q, radix, &overflow));
#else
	{
	  char old_e = 0;
	  if (ex1)
	    {
	      old_e = (*ex1);
	      (*ex1) = 'e';
	    }
	  result = string_to_either_real(sc, q, radix);
	  if (ex1)
	    (*ex1) = old_e;
	}
#endif
	return(result);
      }
    
    /* not real */
    if (slash1)
#if (!WITH_GMP)
      {
	s7_Int n, d;

	n = string_to_integer(q, radix, &overflow);
	d = string_to_integer(slash1, radix, &overflow);

	if ((n == 0) && (d != 0))                        /* 0/100000000000000000000000000000000000000 */
	  return(small_int(0));
	if ((d == 0) || (overflow))
	  return(s7_make_real(sc, NAN));
	/* it would be neat to return 1 from 10000000000000000000000000000/10000000000000000000000000000 
	 *   but q is the entire number ('/' included) and slash1 is the stuff after the '/', and every 
	 *   big number comes through here, so there's no clean and safe way to check that q == slash1.
	 */
	return(s7_make_ratio(sc, n, d));
      }
#else
    return(string_to_either_ratio(sc, q, slash1, radix));
#endif
    
    /* integer */
#if (!WITH_GMP)
    {
      s7_Int x;
      x = string_to_integer(q, radix, &overflow);
      if (overflow) 
	return(s7_make_real(sc, (q[0] == '-') ? -INFINITY : INFINITY)); /* was NaN */
      return(s7_make_integer(sc, x));
    }
#else
    return(string_to_either_integer(sc, q, radix));
#endif
  }
}


static s7_pointer s7_string_to_number(s7_scheme *sc, char *str, int radix)
{
  s7_pointer x;
  x = make_atom(sc, str, radix, NO_SYMBOLS);
  if (s7_is_number(x))  /* only needed because str might start with '#' and not be a number (#t for example) */
    return(x);
  return(sc->F);
}


static s7_pointer g_string_to_number_1(s7_scheme *sc, s7_pointer args, const char *caller)
{
  #define H_string_to_number "(string->number str (radix 10)) converts str into a number. \
If str does not represent a number, string->number returns #f.  If 'str' has an embedded radix, \
the 'radix' argument is ignored: (string->number \"#x11\" 2) -> 17 not 3."

  s7_Int radix = 0;
  char *str;

  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, caller, (is_null(cdr(args))) ? 0 : 1, car(args), "a string"));

  str = (char *)string_value(car(args));
  if ((!str) || (!(*str)))
    return(sc->F);

  if (is_pair(cdr(args)))
    {
      if (!s7_is_integer(cadr(args)))
	return(s7_wrong_type_arg_error(sc, caller, 2, cadr(args), "an integer"));

      if (s7_is_integer(cadr(args)))
	radix = s7_integer(cadr(args));
      if ((radix < 2) ||              /* what about negative int as base (Knuth), reals such as phi, and some complex like -1+i */
	  (radix > 16))               /* the only problem here is printing the number; perhaps put each digit in "()" in base 10: (123)(0)(34) */
	return(s7_out_of_range_error(sc, caller, 2, cadr(args), "should be between 2 and 16"));
    }
  else radix = 10;

  switch (str[0])
    {
    case 'n':
      if (safe_strcmp(str, "nan.0") == 0)
	return(s7_make_real(sc, NAN));
      break;

    case 'i':
      if (safe_strcmp(str, "inf.0") == 0)
	return(s7_make_real(sc, INFINITY));
      break;

    case '-':
      if ((str[1] == 'i') && (safe_strcmp((const char *)(str + 1), "inf.0") == 0))
	 return(s7_make_real(sc, -INFINITY));
       break;

    case '+':
      if ((str[1] == 'i') && (safe_strcmp((const char *)(str + 1), "inf.0") == 0))
	 return(s7_make_real(sc, INFINITY));
       break;
    }

  return(s7_string_to_number(sc, str, radix));
}


static s7_pointer g_string_to_number(s7_scheme *sc, s7_pointer args)
{
  return(g_string_to_number_1(sc, args, "string->number"));
}


static bool numbers_are_eqv(s7_pointer a, s7_pointer b)
{
  if (number_type(a) != number_type(b)) /* (eqv? 1 1.0) -> #f! */
    return(false);
  /* I think this is ok because we always use the base type when setting num.type.
   *   the other cases like NUM_REAL2 arise in switch statements using (a.type | b.type) etc
   */

  switch (number_type(a))
    {
    case NUM_INT:
      return((integer(number(a)) == integer(number(b))));
  
    case NUM_RATIO:
      return((numerator(number(a)) == numerator(number(b))) &&
	     (denominator(number(a)) == denominator(number(b))));

    case NUM_REAL:
    case NUM_REAL2:
      return(real(number(a)) == real(number(b)));
  
    default:
      return((real_part(number(a)) == real_part(number(b))) &&
	     (imag_part(number(a)) == imag_part(number(b))));
    }
  
  return(false);
}

#if WITH_OPTIMIZATION
static s7_pointer find_symbol_or_bust_65(s7_scheme *sc, s7_pointer hdl);
#endif


#if (!WITH_GMP)
static s7_pointer g_abs(s7_scheme *sc, s7_pointer args)
{
  #define H_abs "(abs x) returns the absolute value of the real number x"

  s7_pointer x;
  x = car(args);

  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "abs", 0, x, "a real"));

  if (s7_is_negative(x))
    return(s7_negate(sc, x));
  return(x);
}

#if WITH_OPTIMIZATION
static s7_pointer abs_sub_ss;
static s7_pointer g_abs_sub_ss(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, y;
  s7_num_t a, b;

  x = find_symbol_or_bust_65(sc, cadr(car(args)));
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "-", 1, x, "a real"));

  y = find_symbol_or_bust_65(sc, caddr(car(args)));
  if (!s7_is_real(y))
    return(s7_wrong_type_arg_error(sc, "-", 2, y, "a real"));

  a = number(x);
  b = number(y);

  switch (a.type | b.type)
    {
    case NUM_INT: 
      {
	s7_Int diff;
	diff = integer(a) - integer(b);
	return(s7_make_integer(sc, s7_Int_abs(diff)));
      }
      break;
      
    case NUM_RATIO:
      {
	s7_pointer diff;
	diff = subtract_ratios(sc, a, b);
	if (numerator(number(diff)) < 0)
	  return(s7_make_ratio(sc, -numerator(number(diff)), denominator(number(diff))));
	return(diff);
      }
      break;
      
    case NUM_REAL2:
    case NUM_REAL:
      {
	s7_Double diff;
	diff = num_to_real(a) - num_to_real(b);
	return(s7_make_real(sc, s7_Double_abs(diff)));
      }
      break;
    }
  return(x);
}
#endif

static s7_pointer g_magnitude(s7_scheme *sc, s7_pointer args)
{
  #define H_magnitude "(magnitude z) returns the magnitude of z"
  s7_num_t n;
  s7_pointer x;
  x = car(args);

  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "magnitude", 0, x, "a number"));

  if (s7_is_real(x))
    {
      if (s7_is_negative(x))
	return(s7_negate(sc, x));
      return(x);
    }

  n = number(car(args));
  return(s7_make_real(sc, hypot(imag_part(n), real_part(n))));
}


static s7_pointer g_angle(s7_scheme *sc, s7_pointer args)
{
  #define H_angle "(angle z) returns the angle of z"
  s7_pointer x;
  s7_Double f;

  /* (angle inf+infi) -> 0.78539816339745 ? */

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "angle", 0, x, "a number"));

  if (!s7_is_real(x))
    return(s7_make_real(sc, atan2(complex_imag_part(x), complex_real_part(x))));

  f = num_to_real(number(x));
  if (isnan(f)) return(x);

  if (f < 0.0)
    return(s7_make_real(sc, M_PI));
  if (number_type(x) <= NUM_RATIO)
    return(small_int(0));

  return(real_zero);
}


static s7_pointer g_rationalize(s7_scheme *sc, s7_pointer args)
{
  #define H_rationalize "(rationalize x err) returns the ratio with lowest denominator within err of x"
  s7_Double err, rat;
  s7_Int numer = 0, denom = 1;
  s7_pointer x;

  x = car(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "rationalize", (is_null(cdr(args))) ? 0 : 1, x, "a real"));

  if (is_not_null(cdr(args)))
    {
      if (!s7_is_real(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "rationalize error limit,", 2, cadr(args), "a real"));
      err = s7_number_to_real(cadr(args));
      if (isnan(err))
	return(s7_out_of_range_error(sc, "rationalize", 2, cadr(args), "error term is NaN"));
      if (err < 0.0) err = -err;
    }
  else err = default_rationalize_error;

  if (s7_is_integer(x))
    {
      s7_Int a, b, pa;
      if (err < 1.0) return(x);
      a = s7_integer(x);
      if (a < 0) pa = -a; else pa = a;
      if (err >= pa) return(small_int(0));
      b = (s7_Int)err;
      pa -= b;
      if (a < 0)
	return(s7_make_integer(sc, -pa));
      return(s7_make_integer(sc, pa));
    }

  if ((err == 0.0) &&                 /* (rationalize (/ 1 most-positive-fixnum) 0) */
      (s7_is_ratio(x)))
    return(x);

  rat = s7_number_to_real(x);

  if ((isnan(rat)) || (isinf(rat)))
    return(s7_wrong_type_arg_error(sc, "rationalize", (is_null(cdr(args))) ? 0 : 1, x, "a normal real"));
  if (isnan(err))
    return(s7_wrong_type_arg_error(sc, "rationalize error limit,", 2, cadr(args), "a normal real"));
  if (err >= s7_Double_abs(rat)) return(small_int(0));

  if ((rat > 9.2233720368548e+18) || (rat < -9.2233720368548e+18))
    return(s7_out_of_range_error(sc, "rationalize", 1, x, "a real between most-negative-fixnum and most-positive-fixnum"));

  if ((s7_Double_abs(rat) + s7_Double_abs(err)) < 1.0e-18)
    err = 1.0e-18;
  /* (/ 1.0 most-positive-fixnum) is 1.0842021e-19, so if we let err be less than that,
   * (rationalize 1e-19 1e-20) hangs, but this only affects the initial ceiling, I believe.
   */

  if (s7_Double_abs(rat) < s7_Double_abs(err))
    return(small_int(0));

  if (c_rationalize(rat, err, &numer, &denom))
    return(s7_make_ratio(sc, numer, denom));
  return(sc->F);
}


static s7_pointer g_make_polar(s7_scheme *sc, s7_pointer args)
{
  s7_Double ang, mag;
  #define H_make_polar "(make-polar mag ang) returns a complex number with magnitude mag and angle ang"
  
  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-polar magnitude,", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "make-polar angle,", 2, cadr(args), "a real"));

  if ((car(args) == small_int(0)) &&            /* (make-polar 0 1) -> 0 */
      (number_type(cadr(args)) < NUM_REAL))
    return(small_int(0));

  ang = num_to_real(number(cadr(args)));

  if (ang == 0.0)
    return(car(args));                          /* (make-polar 1 0) -> 1 */
  if ((ang == M_PI) || (ang == -M_PI))
    return(s7_negate(sc, car(args)));

  mag = num_to_real(number(car(args)));
  if ((isnan(mag)) || (isnan(ang)) || (isinf(ang)))
    return(s7_make_real(sc, NAN));

  return(s7_make_complex(sc, mag * cos(ang), mag * sin(ang)));
  /* since sin is inaccurate for large arguments, so is make-polar:
   *    (make-polar 1.0 1e40) -> -0.76267273202438+0.64678458842683i, not 8.218988919070239214448025364432557517335E-1-5.696334009536363273080341815735687231337E-1i
   */
}


static s7_pointer g_make_rectangular(s7_scheme *sc, s7_pointer args)
{
  s7_Double imag;
  #define H_make_rectangular "(make-rectangular x1 x2) returns a complex number with real-part x1 and imaginary-part x2"
  
  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-rectangular real part,", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "make-rectangular imaginary part,", 2, cadr(args), "a real"));
  
  imag = num_to_real(number(cadr(args)));
  if (imag == 0.0)
    return(car(args)); /* this preserves type: (make-rectangular 1 0) -> 1 */

  return(s7_make_complex(sc, 
			 num_to_real(number(car(args))), 
			 imag));
}


static s7_pointer g_exp(s7_scheme *sc, s7_pointer args)
{
  #define H_exp "(exp z) returns e^z, (exp 1) is 2.718281828459"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "exp", 0, x, "a number"));
  if (x == small_int(0)) return(small_int(1));                       /* (exp 0) -> 1 */

  if (s7_is_real(x))
    return(s7_make_real(sc, exp(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, cexp(s7_complex(x))));
  /* this is inaccurate for large arguments:
   *   (exp 0+1e20i) -> -0.66491178990701-0.74692189125949i, not 7.639704044417283004001468027378811228331E-1-6.45251285265780844205811711312523007406E-1i
   */
}


static s7_pointer g_log(s7_scheme *sc, s7_pointer args)
{
  #define H_log "(log z1 (z2 e)) returns log(z1) / log(z2) where z2 (the base) defaults to e: (log 8 2) = 3"
  s7_pointer x;
  
  x = car(args);

  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "log", (is_null(cdr(args))) ? 0 : 1, x, "a number"));

  if ((is_pair(cdr(args))) &&
      (!(s7_is_number(cadr(args)))))
    return(s7_wrong_type_arg_error(sc, "log base,", 2, cadr(args), "a number"));

  if (is_pair(cdr(args)))
    {
      s7_pointer y;

      y = cadr(args);
      if ((x == small_int(1)) && (y == small_int(1)))  /* (log 1 1) -> 0 (this is NaN in the bignum case) */
	return(small_int(0));

      /* (log 1 0) must be 0 since everyone says (expt 0 0) is 1 */
      if (s7_is_zero(y))
	{
	  if ((y == small_int(0)) &&
	      (x == small_int(1)))
	    return(y);
	  return(s7_out_of_range_error(sc, "log base,", 2, y, "can't be 0"));
	}

      if (s7_is_one(y))      /* this used to raise an error, but the bignum case is simpler if we return inf */
	{
	  if (s7_is_one(x))  /* but (log 1.0 1.0) -> 0.0 */
	    return(real_zero);
	  return(s7_make_real(sc, INFINITY));
	}

      if ((s7_is_real(x)) &&
	  (s7_is_real(y)) &&
	  (s7_is_positive(x)) &&
	  (s7_is_positive(y)))
	{
	  if ((s7_is_rational(x)) &&
	      (s7_is_rational(y)))
	    {
	      s7_Double res;
	      s7_Int ires;
	      res = log(num_to_real(number(x))) / log(num_to_real(number(y)));
	      ires = (s7_Int)res;
	      if (res - ires == 0.0)
		return(s7_make_integer(sc, ires));   /* (log 8 2) -> 3 or (log 1/8 2) -> -3 */
	      return(s7_make_real(sc, res));         /* perhaps use rationalize here? (log 2 8) -> 1/3 */
	    }
	  return(s7_make_real(sc, log(num_to_real(number(x))) / log(num_to_real(number(y)))));
	}
      return(s7_from_c_complex(sc, clog(s7_complex(x)) / clog(s7_complex(y))));
    }
  
  if (s7_is_real(x))
    {
      if (s7_is_positive(x))
	return(s7_make_real(sc, log(num_to_real(number(x)))));
      return(s7_make_complex(sc, log(-num_to_real(number(x))), M_PI));
    }

  return(s7_from_c_complex(sc, clog(s7_complex(x))));
}


static s7_pointer g_sin(s7_scheme *sc, s7_pointer args)
{
  #define H_sin "(sin z) returns sin(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "sin", 0, x, "a number"));
  if (x == small_int(0)) return(x);                                 /* (sin 0) -> 0 */

  if (s7_is_real(x))
    return(s7_make_real(sc, sin(num_to_real(number(x)))));

  /* sin is totally inaccurate over about 1e18.  There's a way to get true results,
   *   but it involves fancy "range reduction" techniques. 
   *   This mean lots of things are inaccurate:
   * (sin (remainder 1e22 (* 2 pi)))
   * -0.57876806033477
   * but it should be -8.522008497671888065747423101326159661908E-1
   * ---
   * (remainder 1e22 (* 2 pi)) -> 1.0057952155665e+22 !!
   *   it should be 5.263007914620499494429139986095833592117E0
   */

  return(s7_from_c_complex(sc, csin(s7_complex(x))));
}


static s7_pointer g_cos(s7_scheme *sc, s7_pointer args)
{
  #define H_cos "(cos z) returns cos(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "cos", 0, x, "a number"));
  if (x == small_int(0)) return(small_int(1));                     /* (cos 0) -> 1 */

  if (s7_is_real(x))
    return(s7_make_real(sc, cos(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, ccos(s7_complex(x))));
}


static s7_pointer g_tan(s7_scheme *sc, s7_pointer args)
{
  #define H_tan "(tan z) returns tan(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "tan", 0, x, "a number"));
  if (x == small_int(0)) return(x);                                /* (tan 0) -> 0 */

  if (s7_is_real(x))
    return(s7_make_real(sc, tan(num_to_real(number(x)))));

  if (complex_imag_part(x) > 350.0)
    return(s7_make_complex(sc, 0.0, 1.0));
  if (complex_imag_part(x) < -350.0)
    return(s7_make_complex(sc, 0.0, -1.0));

  return(s7_from_c_complex(sc, ctan(s7_complex(x))));
}


static s7_pointer g_asin(s7_scheme *sc, s7_pointer args)
{
  #define H_asin "(asin z) returns asin(z); (sin (asin 1)) = 1"
  s7_pointer n;

  n = car(args);
  if (!s7_is_number(n))
    return(s7_wrong_type_arg_error(sc, "asin", 0, n, "a number"));
  if (n == small_int(0)) return(n);

  if (s7_is_real(n))
    {
      s7_Double x, absx, recip;
      s7_Complex result;
      x = num_to_real(number(n));
      absx = s7_Double_abs(x);
      if (absx <= 1.0)
	return(s7_make_real(sc, asin(x)));
      
      /* otherwise use maxima code: */
      recip = 1.0 / absx;
      result = (M_PI / 2.0) - (_Complex_I * clog(absx * (1.0 + (sqrt(1.0 + recip) * csqrt(1.0 - recip)))));
      if (x < 0.0)
	return(s7_from_c_complex(sc, -result));
      return(s7_from_c_complex(sc, result));
    }

#if WITH_COMPLEX
  /* if either real or imag part is very large, use explicit formula, not casin */
  /*   this code taken from sbcl's src/code/irrat.lisp */
  /* break is around x+70000000i */

  if ((s7_Double_abs(complex_real_part(n)) > 1.0e7) ||
      (s7_Double_abs(complex_imag_part(n)) > 1.0e7))
    {
      s7_Complex sq1mz, sq1pz, z;

      z = s7_complex(n);
      sq1mz = csqrt(1.0 - z);
      sq1pz = csqrt(1.0 + z);
      return(s7_make_complex(sc, 
			     atan(complex_real_part(n) / creal(sq1mz * sq1pz)),
			     asinh(cimag(sq1pz * conj(sq1mz)))));
    }
#endif

  return(s7_from_c_complex(sc, casin(s7_complex(n))));
}


static s7_pointer g_acos(s7_scheme *sc, s7_pointer args)
{
  #define H_acos "(acos z) returns acos(z); (cos (acos 1)) = 1"
  s7_pointer n;

  n = car(args);
  if (!s7_is_number(n))
    return(s7_wrong_type_arg_error(sc, "acos", 0, n, "a number"));
  if (n == small_int(1)) return(small_int(0));

  if (s7_is_real(n))
    {
      s7_Double x, absx, recip;
      s7_Complex result;
      x = num_to_real(number(n));
      absx = s7_Double_abs(x);
      if (absx <= 1.0)
	return(s7_make_real(sc, acos(x)));
      
      /* else follow maxima again: */
      recip = 1.0 / absx;
      if (x > 0.0)
	result = _Complex_I * clog(absx * (1.0 + (sqrt(1.0 + recip) * csqrt(1.0 - recip))));
      else result = M_PI - _Complex_I * clog(absx * (1.0 + (sqrt(1.0 + recip) * csqrt(1.0 - recip))));
      return(s7_from_c_complex(sc, result));
    }

#if WITH_COMPLEX
  /* if either real or imag part is very large, use explicit formula, not cacos */
  /*   this code taken from sbcl's src/code/irrat.lisp */

  if ((s7_Double_abs(complex_real_part(n)) > 1.0e7) ||
      (s7_Double_abs(complex_imag_part(n)) > 1.0e7))
    {
      s7_Complex sq1mz, sq1pz, z;

      z = s7_complex(n);
      sq1mz = csqrt(1.0 - z);
      sq1pz = csqrt(1.0 + z);
      return(s7_make_complex(sc, 
			     2.0 * atan(creal(sq1mz) / creal(sq1pz)),
			     asinh(cimag(sq1mz * conj(sq1pz)))));
    }
#endif

  return(s7_from_c_complex(sc, cacos(s7_complex(n))));
}


static s7_pointer g_atan(s7_scheme *sc, s7_pointer args)
{
  #define H_atan "(atan z) returns atan(z), (atan y x) returns atan(y/x)"
  s7_pointer x, y;

  /* currently (atan inf.0 inf.0) -> 0.78539816339745, and (atan inf.0 -inf.0) -> 2.3561944901923 (etc) */

  x = car(args);
  if (!is_pair(cdr(args)))
    {
      if (!s7_is_number(x))
	return(s7_wrong_type_arg_error(sc, "atan", 0, x, "a number"));

      if (x == small_int(0)) return(x);                                /* (atan 0) -> 0 */
      if (s7_is_real(x))
	return(s7_make_real(sc, atan(num_to_real(number(x)))));

      return(s7_from_c_complex(sc, catan(s7_complex(x))));
    } 

  y = cadr(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "atan", 1, x, "a real"));
  if (!s7_is_real(y))
    return(s7_wrong_type_arg_error(sc, "atan", 2, y, "a real"));

  return(s7_make_real(sc, atan2(num_to_real(number(x)), 
				num_to_real(number(y)))));
}  


static s7_pointer g_sinh(s7_scheme *sc, s7_pointer args)
{
  #define H_sinh "(sinh z) returns sinh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "sinh", 0, x, "a number"));
  if (x == small_int(0)) return(x);                              /* (sinh 0) -> 0 */

  if (s7_is_real(x))
    return(s7_make_real(sc, sinh(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, csinh(s7_complex(x))));
}


static s7_pointer g_cosh(s7_scheme *sc, s7_pointer args)
{
  #define H_cosh "(cosh z) returns cosh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "cosh", 0, x, "a number"));
  if (x == small_int(0)) return(small_int(1));                    /* (cosh 0) -> 1 */

  if (s7_is_real(x))
    return(s7_make_real(sc, cosh(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, ccosh(s7_complex(x))));
}


static s7_pointer g_tanh(s7_scheme *sc, s7_pointer args)
{
  #define H_tanh "(tanh z) returns tanh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "tanh", 0, x, "a number"));

  if (x == small_int(0)) return(x);                                /* (tanh 0) -> 0 */
  if (s7_is_real(x))
    return(s7_make_real(sc, tanh(num_to_real(number(x)))));

  if (complex_real_part(x) > 350.0)
    return(s7_make_real(sc, 1.0));               /* closer than 0.0 which is what ctanh is about to return! */
  if (complex_real_part(x) < -350.0)
    return(s7_make_real(sc, -1.0));              /* closer than -0.0 which is what ctanh is about to return! */

  return(s7_from_c_complex(sc, ctanh(s7_complex(x))));
}


static s7_pointer g_asinh(s7_scheme *sc, s7_pointer args)
{
  #define H_asinh "(asinh z) returns asinh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "asinh", 0, x, "a number"));
  if (x == small_int(0)) return(x);

  if (s7_is_real(x))
    return(s7_make_real(sc, asinh(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, casinh(s7_complex(x))));
}


static s7_pointer g_acosh(s7_scheme *sc, s7_pointer args)
{
  #define H_acosh "(acosh z) returns acosh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "acosh", 0, x, "a number"));
  if (x == small_int(1)) return(small_int(0));

  if ((s7_is_real(x)) &&
      (num_to_real(number(x)) >= 1.0))
    return(s7_make_real(sc, acosh(num_to_real(number(x)))));
  return(s7_from_c_complex(sc, cacosh(s7_complex(x))));
}


static s7_pointer g_atanh(s7_scheme *sc, s7_pointer args)
{
  #define H_atanh "(atanh z) returns atanh(z)"
  s7_pointer x;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "atanh", 0, x, "a number"));

  if (x == small_int(0)) return(x);                                /* (atanh 0) -> 0 */
  if ((s7_is_real(x)) &&
      (s7_Double_abs(num_to_real(number(x))) < 1.0))
    return(s7_make_real(sc, atanh(num_to_real(number(x)))));

  /* if we can't distinguish x from 1.0 even with long doubles, we'll get inf.0:
   *    (atanh 9223372036854775/9223372036854776) -> 18.714973875119
   *    (atanh 92233720368547758/92233720368547757) -> inf.0
   */

  return(s7_from_c_complex(sc, catanh(s7_complex(x))));
}


static s7_pointer g_sqrt(s7_scheme *sc, s7_pointer args)
{
  #define H_sqrt "(sqrt z) returns the square root of z"
  s7_pointer n;

  n = car(args);
  if (!s7_is_number(n))
    return(s7_wrong_type_arg_error(sc, "sqrt", 0, n, "a number"));

  if (s7_is_real(n))
    {
      s7_Double x, sqx;
      x = num_to_real(number(n));
      if (x >= 0.0)
	{
	  sqx = sqrt(x);
	  if (s7_is_integer(n))
	    {
	      s7_Int ix;
	      ix = (s7_Int)sqx;
	      if ((ix * ix) == integer(number(n)))
		return(s7_make_integer(sc, ix));
	    }
	  if (s7_is_ratio(n))
	    {
	      s7_Int nm = 0, dn = 1;
	      if (c_rationalize(sqx, 1.0e-16, &nm, &dn)) /* 1e-16 so that (sqrt 1/1099511627776) returns 1/1048576 */
		{
		  if ((nm * nm == s7_numerator(n)) &&
		      (dn * dn == s7_denominator(n)))
		    return(s7_make_ratio(sc, nm, dn));
		}
	    }
	  return(s7_make_real(sc, sqx));
	}
    }
  return(s7_from_c_complex(sc, csqrt(s7_complex(n))));
}


static s7_Int int_to_int(s7_Int x, s7_Int n)
{
  /* from GSL */
  s7_Int value = 1;
  do {
    if (n & 1) value *= x;
    n >>= 1;
    x *= x;
  } while (n);
  return(value);
}


static long long int nth_roots[63] = {
  S7_LLONG_MAX, S7_LLONG_MAX, 3037000499LL, 2097151, 55108, 6208, 1448, 511, 234, 127, 78, 52, 38, 28, 22, 
  18, 15, 13, 11, 9, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};

static long int_nth_roots[31] = {
  S7_LONG_MAX, S7_LONG_MAX, 46340, 1290, 215, 73, 35, 21, 14, 10, 8, 7, 5, 5, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};

static bool int_pow_ok(s7_Int x, s7_Int y)
{
  if (s7_int_bits > 31)
    return((y < 63) &&
	   (nth_roots[y] >= s7_Int_abs(x)));
  return((y < 31) &&
	 (int_nth_roots[y] >= s7_Int_abs(x)));
}


static s7_pointer g_expt(s7_scheme *sc, s7_pointer args)
{
  #define H_expt "(expt z1 z2) returns z1^z2"
  s7_pointer n, pw;
  
  n = car(args);
  pw = cadr(args);

  if (!s7_is_number(n))
    return(s7_wrong_type_arg_error(sc, "expt", 1, n, "a number"));
  if (!s7_is_number(pw))
    return(s7_wrong_type_arg_error(sc, "expt power,", 2, pw, "a number"));

  /* this provides more than 2 args to expt:
   *  if (is_not_null(cddr(args)))
   *    return(g_expt(sc, list_2(sc, car(args), g_expt(sc, cdr(args)))));
   *
   * but it's unusual in scheme to process args in reverse order, and the
   * syntax by itself is ambiguous (does (expt 2 2 3) = 256 or 64?)
   */

  if (s7_is_zero(n))
    {
      if (s7_is_zero(pw))
	{
	  if ((s7_is_integer(n)) && (s7_is_integer(pw)))       /* (expt 0 0) -> 1 */
	    return(small_int(1));
	  return(real_zero);                                   /* (expt 0.0 0) -> 0.0 */
	}

      if (s7_is_real(pw))
	{
	  if (s7_is_negative(pw))                              /* (expt 0 -1) */
	    return(division_by_zero_error(sc, "expt", args));  
	  /* (Clisp gives divide-by-zero error here, Guile returns inf.0) */

	  if ((!s7_is_rational(pw)) &&                         /* (expt 0 most-positive-fixnum) */
	      (isnan(s7_real(pw))))                            /* (expt 0 +nan.0) */
	    return(pw);
	}
      else
	{                                                      /* (expt 0 a+bi) */
	  if (complex_real_part(pw) < 0.0)                     /* (expt 0 -1+i) */
	    return(division_by_zero_error(sc, "expt", args));  
	}

      if ((s7_is_integer(n)) && (s7_is_integer(pw)))           /* pw != 0, (expt 0 2312) */
	return(small_int(0));
      return(real_zero);                                       /* (expt 0.0 123123) */
    }

  if (s7_is_one(pw))
    {
      if (s7_is_integer(pw))
	return(n);
      if (number_type(n) <= NUM_RATIO)
	return(s7_make_real(sc, num_to_real(number(n))));
      return(n);
    }
  
  if (number_type(pw) == NUM_INT)
    {
      s7_Int y;
      y = s7_integer(pw);
      if (y == 0)
	{
	  /* (expt +nan.0 0) ?? */
	  if ((number_type(n) == NUM_INT) || (number_type(n) == NUM_RATIO))
	    return(small_int(1));
	  return(s7_make_real(sc, 1.0));
	}

      if (number_type(n) == NUM_INT)
	{
	  s7_Int x;
	  x = s7_integer(n);
	  if (x == 1)
	    return(n);
	  
	  if (x == -1)
	    {
	      if (s7_Int_abs(y) & 1)
		return(n);
	      return(small_int(1));
	    }

	  if (y == S7_LLONG_MIN)
	    return(small_int(0));                      /* (expt x most-negative-fixnum) !! */

	  if (int_pow_ok(x, s7_Int_abs(y)))
	    {
	      if (y > 0)
		return(s7_make_integer(sc, int_to_int(x, y)));
	      return(s7_make_ratio(sc, 1, int_to_int(x, -y)));
	    }
	}
      else
	{
	  if (number_type(n) == NUM_RATIO)
	    {
	      s7_Int nm, dn;
	      
	      nm = numerator(number(n));
	      dn = denominator(number(n));

	      if ((int_pow_ok(nm, s7_Int_abs(y))) &&
		  (int_pow_ok(dn, s7_Int_abs(y))))
		{
		  if (y > 0)
		    return(s7_make_ratio(sc, int_to_int(nm, y), int_to_int(dn, y)));
		  return(s7_make_ratio(sc, int_to_int(dn, -y), int_to_int(nm, -y)));
		}
	    }
	  /* occasionally int^rat can be int but it happens so infrequently it's probably not worth checking
	   *  one possibly easy case: (expt 1 1/2) -> 1 etc
	   */
	}
    }

  if ((s7_is_real(n)) &&
      (s7_is_real(pw)))
    {
      s7_Double x, y;

      if ((number_type(pw) == NUM_RATIO) &&
	  (numerator(number(pw)) == 1))
	{
	  if (denominator(number(pw)) == 2)
	    return(g_sqrt(sc, args));
	  if (denominator(number(pw)) == 3)
	    return(s7_make_real(sc, cbrt(num_to_real(number(n))))); /* (expt 27 1/3) should be 3, not 3.0... */
 
	  /* but: (expt 512/729 1/3) -> 0.88888888888889
	   */
	  /* and 4 -> sqrt(sqrt...) etc? */
	}

      x = num_to_real(number(n));
      y = num_to_real(number(pw));

      if (isnan(x)) return(n);
      if (isnan(y)) return(pw);
      if (y == 0.0) return(s7_make_real(sc, 1.0));

      if ((x > 0.0) ||
	  ((y - floor(y)) < 1.0e-16))
	return(s7_make_real(sc, pow(x, y)));
    }
  
  /* (expt 0+i 1e+16) = 0.98156860153485-0.19111012657867i ? 
   * (expt 0+i 1+1/0i) = 0.0 ??
   */
  return(s7_from_c_complex(sc, cpow(s7_complex(n), s7_complex(pw))));
}


static s7_Int c_lcm(s7_Int a, s7_Int b)
{
  if ((a == 0) || (b == 0)) return(0);
  if (a < 0) a = -a;
  if (b < 0) b = -b;
  return((a / c_gcd(a, b)) * b);
}


static s7_pointer g_lcm(s7_scheme *sc, s7_pointer args)
{
  #define H_lcm "(lcm ...) returns the least common multiple of its rational arguments"
  int i;
  s7_Int n = 1, d = 0;
  bool rats = false;
  s7_pointer x;

  if (!is_pair(args))
    return(small_int(1));

  if (!is_pair(cdr(args)))
    {
      if (!s7_is_rational(car(args)))
	return(s7_wrong_type_arg_error(sc, "lcm", 1, car(args), "an integer or ratio"));
      return(g_abs(sc, args));
    }

  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x)) 
    if (!s7_is_rational(car(x)))
      return(s7_wrong_type_arg_error(sc, "lcm", i, car(x), "an integer or ratio"));
    else rats = ((rats) || (number_type(car(x)) == NUM_RATIO));

  if (!rats)
    {
      for (x = args; is_not_null(x); x = cdr(x)) 
	{
	  n = c_lcm(n, s7_integer(car(x)));
	  if (n < 0) return(s7_out_of_range_error(sc, "lcm from", 0, args, "result is too large"));
	  if (n == 0)
	    return(small_int(0));
	}
      return(s7_make_integer(sc, n));
    }

  /* from A Jaffer */
  for (x = args; is_not_null(x); x = cdr(x)) 
    {
      n = c_lcm(n, s7_numerator(car(x)));
      if (n < 0) return(s7_out_of_range_error(sc, "lcm from", 0, args, "result is too large"));
      if (n == 0)
	return(small_int(0));
      d = c_gcd(d, s7_denominator(car(x)));
    }
  return(s7_make_ratio(sc, n, d));
}


static s7_pointer g_gcd(s7_scheme *sc, s7_pointer args)
{
  #define H_gcd "(gcd ...) returns the greatest common divisor of its rational arguments"
  int i;
  bool rats = false;
  s7_Int n = 0, d = 1;
  s7_pointer x;

  if (!is_pair(args))
    return(small_int(0));

  if (!is_pair(cdr(args)))
    {
      if (!s7_is_rational(car(args)))
	return(s7_wrong_type_arg_error(sc, "gcd", 1, car(args), "an integer or ratio"));
      return(g_abs(sc, args));
    }

  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x)) 
    if (!s7_is_rational(car(x)))
      return(s7_wrong_type_arg_error(sc, "gcd", i, car(x), "an integer"));
    else rats = ((rats) || (number_type(car(x)) == NUM_RATIO));
  
  if (!rats)
    {
      for (x = args; is_not_null(x); x = cdr(x)) 
	{
	  n = c_gcd(n, s7_integer(car(x)));
	  if (n < 0) return(s7_out_of_range_error(sc, "gcd from", 0, args, "intermediate result is too large"));
	  if (n == 1) return(small_int(1));
	}
      return(s7_make_integer(sc, n));
    }

  /* from A Jaffer */
  for (x = args; is_not_null(x); x = cdr(x)) 
    {
      n = c_gcd(n, s7_numerator(car(x)));
      if (n < 0) return(s7_out_of_range_error(sc, "gcd from", 0, args, "intermediate result is too large"));
      d = c_lcm(d, s7_denominator(car(x)));
      if (d < 0) return(s7_out_of_range_error(sc, "gcd from", 0, args, "intermediate result is too large"));
    }
  return(s7_make_ratio(sc, n, d));
}


static s7_pointer s7_truncate(s7_scheme *sc, const char *caller, s7_Double xf)   /* can't use "truncate" -- it's in unistd.h */
{
  if ((xf > S7_LLONG_MAX) ||
      (xf < S7_LLONG_MIN))
    return(s7_out_of_range_error(sc, caller, 0, s7_make_real(sc, xf), "too large to express as an integer"));

  if (xf > 0.0)
    return(s7_make_integer(sc, (s7_Int)floor(xf)));
  return(s7_make_integer(sc, (s7_Int)ceil(xf)));
}


static s7_pointer quotient(s7_scheme *sc, const char *caller, s7_num_t a, s7_num_t b) 
{
  /* (define (quo x1 x2) (truncate (/ x1 x2))) ; slib */

  switch (a.type | b.type)
    {
    case NUM_INT:
      return(s7_make_integer(sc, integer(a) / integer(b)));

    case NUM_RATIO:
      {
	s7_Int d1, d2, n1, n2;
	d1 = num_to_denominator(a);
	n1 = num_to_numerator(a);
	d2 = num_to_denominator(b);
	n2 = num_to_numerator(b);
	if (d1 == d2)
	  return(s7_make_integer(sc, n1 / n2));              /* (quotient 3/9223372036854775807 1/9223372036854775807) */
	if (n1 == n2)
	  return(s7_make_integer(sc, d2 / d1));              /* (quotient 9223372036854775807/2 9223372036854775807/8) */

	if ((integer_length(n1) + integer_length(d2) >= s7_int_bits) ||
	    (integer_length(n2) + integer_length(d1) >= s7_int_bits))
	  return(s7_truncate(sc, caller, num_to_real(a) / num_to_real(b)));
	/* this can lose:
	 *   (quotient 1 2305843009213693952/4611686018427387903) -> 2, not 1
	 *   (quotient 21053343141/6701487259 3587785776203/1142027682075) -> 1, not 0
	 */

	return(s7_make_integer(sc, (n1 * d2) / (n2 * d1)));  /* (quotient 922337203685477580 1/3) */
      }
      
    default:
      return(s7_truncate(sc, caller, num_to_real(a) / num_to_real(b)));
    }
}


static s7_pointer g_quotient(s7_scheme *sc, s7_pointer args)
{
  #define H_quotient "(quotient x1 x2) returns the integer quotient of x1 and x2; (quotient 4 3) = 1"
  
  s7_pointer x, y;
  x = car(args);
  y = cadr(args);

  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "quotient", 1, x, "a real"));
  if (!s7_is_real(y))
    return(s7_wrong_type_arg_error(sc, "quotient", 2, y, "a real"));

  if (s7_is_zero(y))
    return(division_by_zero_error(sc, "quotient", args));

  if (number_type(x) > NUM_RATIO)
    {
      s7_Double rx;
      rx = real(number(x));
      if ((isinf(rx)) || (isnan(rx)))
	return(s7_wrong_type_arg_error(sc, "quotient", 1, x, "a normal real"));
    }

  if (number_type(y) > NUM_RATIO)
    {
      s7_Double ry;
      ry = real(number(y));
      if ((isinf(ry)) || (isnan(ry)))
	return(s7_wrong_type_arg_error(sc, "quotient", 2, y, "a normal real"));

      /* if infs allowed we need to return infs/nans, else:
       *    (quotient inf.0 1e-309) -> -9223372036854775808
       *    (quotient inf.0 inf.0) -> -9223372036854775808
       */
    }

  return(quotient(sc, "quotient", number(car(args)), number(cadr(args))));
}


static s7_pointer g_remainder(s7_scheme *sc, s7_pointer args)
{
  #define H_remainder "(remainder x1 x2) returns the integer remainder of x1 and x2; (remainder 10 3) = 1"
  /* (define (rem x1 x2) (- x1 (* x2 (quo x1 x2)))) ; slib */

  s7_pointer ap, bp;
  s7_num_t a, b;
  
  ap = car(args);
  if (!s7_is_real(ap))
    return(s7_wrong_type_arg_error(sc, "remainder", 1, ap, "a real"));

  bp = cadr(args);
  if (!s7_is_real(bp))
    return(s7_wrong_type_arg_error(sc, "remainder", 2, bp, "a real"));

  if (s7_is_zero(bp))
    return(division_by_zero_error(sc, "remainder", args));

  if ((number_type(ap) > NUM_RATIO) &&
      (isnan(real(number(ap)))))                                 /* (remainder 1 (string->number "nan.0")) */
    return(s7_wrong_type_arg_error(sc, "remainder", 1, ap, "a normal real"));
  if ((number_type(bp) > NUM_RATIO) &&
      (isnan(real(number(bp)))))
    return(s7_wrong_type_arg_error(sc, "remainder", 2, bp, "a normal real"));

  a = number(ap);
  b = number(bp);

  switch (num_type(a) | num_type(b))
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) % integer(b)));

    case NUM_RATIO: 
      {
	/* as usual with ratios, there are lots of tricky cases */
	s7_Int quo, n1, n2, d1, d2;

	quo = s7_integer(quotient(sc, "remainder", a, b));
	if (quo == 0)
	  return(ap);

	d1 = num_to_denominator(a);
	n1 = num_to_numerator(a);
	d2 = num_to_denominator(b);
	n2 = num_to_numerator(b);

	if ((d1 == d2) &&
	    ((integer_length(n2) + integer_length(quo)) < s7_int_bits))
	  return(s7_make_ratio(sc, n1 - n2 * quo, d1));
      
	if ((integer_length(n1) + integer_length(d2) < s7_int_bits) &&
	    (integer_length(d1) + integer_length(d2) < s7_int_bits) &&
	    (integer_length(n2) + integer_length(d1) + integer_length(quo) < s7_int_bits))
	  return(s7_make_ratio(sc, n1 * d2 - n2 * d1 * quo, d1 * d2));

	return(s7_out_of_range_error(sc, "remainder", 0, ap, "intermediate (a/b) is too large"));
      }

    default:
      {
	s7_Int quo;
	quo = s7_integer(quotient(sc, "remainder", a, b));
	if (quo == 0)
	  return(ap);
	
	return(s7_make_real(sc, num_to_real(a) - num_to_real(b) * quo));

      /* see under sin -- this calculation is completely bogus if "a" is large
       * (quotient 1e22 (* 2 pi)) -> -9223372036854775808 -- should this return arithmetic-overflow?
       *          but it should be 1591549430918953357688, 
       * (remainder 1e22 (* 2 pi)) -> 1.0057952155665e+22
       * -- the "remainder" is greater than the original argument!
       * Clisp gives 0.0 here, as does sbcl
       * currently s7 throws an error (out-of-range).
       */
      }
    }
}


static s7_pointer g_floor(s7_scheme *sc, s7_pointer args)
{
  #define H_floor "(floor x) returns the integer closest to x toward -inf"
  s7_pointer x;

  x = car(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "floor", 0, x, "a real"));

  switch (number_type(x))
    {
    case NUM_INT:   
      return(x);

    case NUM_RATIO: 
      {
	s7_Int val;
	val = numerator(number(x)) / denominator(number(x)); 
	/* C "/" truncates? -- C spec says "truncation toward 0" */
	/* we're avoiding "floor" here because the int->double conversion introduces inaccuracies for big numbers */
	if (numerator(number(x)) < 0) /* not "val" because it might be truncated to 0 */
	  return(s7_make_integer(sc, val - 1));
	return(s7_make_integer(sc, val));
      }

    default: 
      {
	s7_Double z;
	z = real(number(x));
	if (isnan(z))
	  return(s7_out_of_range_error(sc, "floor", 0, x, "argument is NaN"));
	if (isinf(z))
	  return(s7_out_of_range_error(sc, "floor", 0, x, "argument is infinite"));

	/* I used to check for a big real arg here and throw and error, but that
	 *   can't work in general (see s7test), and gives the programmer a false
	 *   sense of security.
	 */
	return(s7_make_integer(sc, (s7_Int)floor(real(number(x))))); 
      }
    }
}


static s7_pointer g_ceiling(s7_scheme *sc, s7_pointer args)
{
  #define H_ceiling "(ceiling x) returns the integer closest to x toward inf"
  s7_pointer x;

  x = car(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "ceiling", 0, x, "a real"));

  switch (number_type(x))
    {
    case NUM_INT:   
      return(x);

    case NUM_RATIO:
      {
	s7_Int val;
	val = numerator(number(x)) / denominator(number(x));
	if (numerator(number(x)) < 0)
	  return(s7_make_integer(sc, val));
	return(s7_make_integer(sc, val + 1));
      }

    default:        
      {
	s7_Double z;
	z = real(number(x));
	if (isnan(z))
	  return(s7_out_of_range_error(sc, "ceiling", 0, x, "argument is NaN"));
	if (isinf(z))
	  return(s7_out_of_range_error(sc, "ceiling", 0, x, "argument is infinite"));
	return(s7_make_integer(sc, (s7_Int)ceil(real(number(x))))); 
      }
    }
}


static s7_pointer g_truncate(s7_scheme *sc, s7_pointer args)
{
  #define H_truncate "(truncate x) returns the integer closest to x toward 0"
  s7_pointer x;

  x = car(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "truncate", 0, x, "a real"));

  switch (number_type(x))
    {
    case NUM_INT: 
      return(x);

    case NUM_RATIO: 
      return(s7_make_integer(sc, (s7_Int)(numerator(number(x)) / denominator(number(x))))); /* C "/" already truncates */

    default: 
      {
	s7_Double z;
	z = real(number(x));
	if (isnan(z))
	  return(s7_out_of_range_error(sc, "truncate", 0, x, "argument is NaN"));
	if (isinf(z))
	  return(s7_out_of_range_error(sc, "truncate", 0, x, "argument is infinite"));
	return(s7_truncate(sc, "truncate", real(number(x)))); 
      }
    }
}


static s7_Double round_per_R5RS(s7_Double x) 
{
  s7_Double fl = floor(x);
  s7_Double ce = ceil(x);
  s7_Double dfl = x - fl;
  s7_Double dce = ce - x;
  
  if (dfl > dce) return(ce);
  if (dfl < dce) return(fl);
  if (fmod(fl, 2.0) == 0.0) return(fl);
  return(ce);
}


static s7_pointer g_round(s7_scheme *sc, s7_pointer args)
{
  #define H_round "(round x) returns the integer closest to x"
  s7_pointer x;

  x = car(args);
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "round", 0, x, "a real"));

  switch (number_type(x))
    {
    case NUM_INT: 
      return(x);

    case NUM_RATIO: 
      {
	s7_Int truncated, remains;
	long double frac;

	truncated = numerator(number(x)) / denominator(number(x));
	remains = numerator(number(x)) % denominator(number(x));
	frac = s7_fabsl((long double)remains / (long double)denominator(number(x)));

	if ((frac > 0.5) ||
	    ((frac == 0.5) &&
	     (truncated % 2 != 0)))
	  {
	    if (numerator(number(x)) < 0)
	      return(s7_make_integer(sc, truncated - 1));
	    return(s7_make_integer(sc, truncated + 1));
	  }
	return(s7_make_integer(sc, truncated));
      }

    default: 
      {
	s7_Double z;
	z = real(number(x));
	if (isnan(z))
	  return(s7_out_of_range_error(sc, "round", 0, x, "argument is NaN"));
	if (isinf(z))
	  return(s7_out_of_range_error(sc, "round", 0, x, "argument is infinite"));
	return(s7_make_integer(sc, (s7_Int)round_per_R5RS(real(number(x))))); 
      }
    }
}


static s7_Int c_mod(s7_Int x, s7_Int y)
{
  s7_Int z;
  if (y == 0) return(x); /* else arithmetic exception */
  z = x % y;
  if (((y < 0) && (z > 0)) ||
      ((y > 0) && (z < 0)))
    return(z + y);
  return(z);
}


static s7_pointer g_modulo(s7_scheme *sc, s7_pointer args)
{
  #define H_modulo "(modulo x1 x2) returns x1 mod x2; (modulo 4 3) = 1.  The arguments can be real numbers."
  s7_pointer ap, bp;
  s7_num_t a, b;
  /* (define (mod x1 x2) (- x1 (* x2 (floor (/ x1 x2))))) ; slib */

  ap = car(args);
  if (!s7_is_real(ap))
    return(s7_wrong_type_arg_error(sc, "modulo", 1, ap, "a real"));

  bp = cadr(args);
  if (!s7_is_real(bp))
    return(s7_wrong_type_arg_error(sc, "modulo", 2, bp, "a real"));

  if (s7_is_zero(bp))
    return(ap);                       /* (mod x 0) = x according to "Concrete Mathematics" */
  
  a = number(ap);
  b = number(bp);

  switch (num_type(a) | num_type(b))
    {
    case NUM_INT:
      return(s7_make_integer(sc, c_mod(integer(a), integer(b))));

    case NUM_RATIO:                   /* a or b might be integer here, hence the num_to_* */
      {
	s7_Int n1, n2, d1, d2;

	d1 = num_to_denominator(a);
	n1 = num_to_numerator(a);
	d2 = num_to_denominator(b);
	n2 = num_to_numerator(b);

	if (d1 == d2)
	  return(s7_make_ratio(sc, c_mod(n1, n2), d1));

	if ((n1 == n2) &&
	    (d1 > d2))
	  return(ap);                 /* signs match so this should be ok */

	if ((integer_length(n1) + integer_length(d2) < s7_int_bits) &&
	    (integer_length(n2) + integer_length(d1) < s7_int_bits) &&
	    (integer_length(d1) + integer_length(d2) < s7_int_bits))
	  {
	    s7_Int n1d2, n2d1, fl;
	    n1d2 = n1 * d2;
	    n2d1 = n2 * d1;

	    if (n2d1 == 1)
	      return(small_int(0));

	    /* can't use "floor" here (int->float ruins everything) */
	    fl = (s7_Int)(n1d2 / n2d1);
	    if (((n1 < 0) && (n2 > 0)) ||
		((n1 > 0) && (n2 < 0)))
	      fl -= 1;

	    if (fl == 0)
	      return(ap);

	    if (integer_length(n2d1) + integer_length(fl) < s7_int_bits)
	      return(s7_make_ratio(sc, n1d2 - (n2d1 * fl), d1 * d2));
	  }

	/* there are cases here we might want to catch:
	 *    (modulo 1/9223372036 9223372036) -> error, not 1/9223372036?
	 *    (modulo 9223372036 1/9223372036) -> error, not 0?
	 *    (modulo 1 1/9223372036854775807) -> error, not 0?
	 *    (modulo 1/9223372036854775807 9223372036854775807) -> error, not 1/9223372036854775807?
	 */
	return(s7_out_of_range_error(sc, "modulo", 0, ap, "intermediate (a/b) is too large"));	
      }

    default:
      {
	s7_Double ax, bx, cx;

	ax = num_to_real(a);
	if (isnan(ax)) return(ap);

	bx = num_to_real(b);
	if (isnan(bx)) return(bp);

	if ((isinf(ax)) || (isinf(bx)))
	  return(s7_make_real(sc, NAN));

	cx = ax / bx;
	return(s7_make_real(sc, ax - bx * (s7_Int)floor(cx)));
      }
    }
}
#endif
/* !WITH_GMP */


static s7_pointer g_add(s7_scheme *sc, s7_pointer args)
{
  #define H_add "(+ ...) adds its arguments"
  int i, ret_type;
  s7_pointer x;
  s7_num_t a, b;

#if (!WITH_GMP)
  if (is_null(args))
    return(small_int(0));

  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "+", 1, car(args), "a number"));
#endif
    
  x = cdr(args);
  if (is_null(x))
    return(car(args));

  i = 2;
  a = number(car(args));
  while (true)
    {
#if WITH_GMP
      switch (a.type)
	{
	case NUM_INT:
	  if ((integer(a) > S7_LONG_MAX) ||
	      (integer(a) < S7_LONG_MIN))
	    return(big_add(sc, cons(sc, s7_Int_to_big_integer(sc, integer(a)), x)));
	  break;

	case NUM_RATIO:
	  if ((numerator(a) > S7_LONG_MAX) ||
	      (denominator(a) > S7_LONG_MAX) ||
	      (numerator(a) < S7_LONG_MIN))
	    return(big_add(sc, cons(sc, s7_ratio_to_big_ratio(sc, (numerator(a)), denominator(a)), x)));
	  break;
	}
#else
      if (!s7_is_number(car(x)))
	return(s7_wrong_type_arg_error(sc, "+", i, car(x), "a number"));
#endif

      b = number(car(x));
      ret_type = a.type | b.type;
      x = cdr(x);
  
      switch (ret_type)
	{
	case NUM_INT: 
	  if (is_null(x))
	    return(s7_make_integer(sc, integer(a) + integer(b)));
	  integer(a) += integer(b);
	  break;
      
	case NUM_RATIO:
	  {
	    s7_Int d1, d2, n1, n2;
	    d1 = num_to_denominator(a);
	    n1 = num_to_numerator(a);
	    d2 = num_to_denominator(b);
	    n2 = num_to_numerator(b);
	    if (d1 == d2)                                     /* the easy case -- if overflow here, it matches the int case */
	      {
		if (is_null(x))
		  return(s7_make_ratio(sc, n1 + n2, d1));
		a = make_ratio(n1 + n2, d1);                  /* d1 can't be zero */
	      }
	    else
	      {
#if (!WITH_GMP)
		if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
		    (n1 > s7_int_max) || (n2 > s7_int_max) ||
		    (n1 < s7_int_min) || (n2 < s7_int_min))
		  {
		    int d1bits, d2bits;
		    d1bits = integer_length(d1);
		    d2bits = integer_length(d2);
		    if (((d1bits + d2bits) > s7_int_bits) ||
			((d1bits + integer_length(n2)) > (s7_int_bits - 1)) ||
			((d2bits + integer_length(n1)) > (s7_int_bits - 1)))
		      {
			if (is_null(x))
			  return(s7_make_real(sc, ((long double)n1 / (long double)d1) + ((long double)n2 / (long double)d2)));
			a.type = NUM_REAL;
			real(a) = ((long double)n1 / (long double)d1) + ((long double)n2 / (long double)d2);
			/* this can lose:
			 *   (+ 1 1/9223372036854775807 -1) -> 0.0 not 1/9223372036854775807
			 */
		      }
		    else 
		      {
			if (is_null(x))
			  return(s7_make_ratio(sc, n1 * d2 + n2 * d1, d1 * d2));
			a = make_ratio(n1 * d2 + n2 * d1, d1 * d2);
		      }
		  }
		else
#endif
		  {
		    if (is_null(x))
		      return(s7_make_ratio(sc, n1 * d2 + n2 * d1, d1 * d2));
		    a = make_ratio(n1 * d2 + n2 * d1, d1 * d2);
		  }
	      }
	  }
	  break;
      
	case NUM_REAL2:
	case NUM_REAL:
	  if (is_null(x))
	    return(s7_make_real(sc, num_to_real(a) + num_to_real(b)));
	  real(a) = num_to_real(a) + num_to_real(b);
	  a.type = NUM_REAL;
	  break;
      
	default:
	  /* NUM_COMPLEX is 4 separate types */
	  if (is_null(x))
	    return(s7_make_complex(sc, num_to_real_part(a) + num_to_real_part(b), num_to_imag_part(a) + num_to_imag_part(b)));
	  real_part(a) = num_to_real_part(a) + num_to_real_part(b);
	  imag_part(a) = num_to_imag_part(a) + num_to_imag_part(b);
	  if (imag_part(a) == 0.0)
	    a.type = NUM_REAL;
	  else a.type = NUM_COMPLEX;
	  break;
	}

      i++;
    }
  return(s7_error(sc, make_symbol(sc, "internal-error"),
		  list_2(sc, make_protected_string(sc, "s7 mishandled addition: ~S\n"), args)));
}


#if WITH_OPTIMIZATION
static s7_pointer add_1, add_2, add_1s, add_s1;

static s7_pointer g_add_1(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "+", 1, car(args), "a number"));
  return(car(args));
}

static s7_pointer g_add_2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, y;
  s7_num_t a, b;
  x = car(args);
  y = cadr(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "+", 1, x, "a number"));
  if (!s7_is_number(y))
    return(s7_wrong_type_arg_error(sc, "+", 2, y, "a number"));
  a = number(x);
  b = number(y);
  switch (a.type | b.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) + integer(b)));
      break;
      
    case NUM_RATIO:
      return(g_add(sc, args));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) + num_to_real(b)));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) + num_to_real_part(b), num_to_imag_part(a) + num_to_imag_part(b)));
      break;
    }
  return(x);
}

static s7_pointer g_add_s1(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  s7_num_t a;
  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "+", 1, x, "a number"));
  a = number(x);
  switch (a.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) + 1));
      break;
      
    case NUM_RATIO:
      return(g_add(sc, args));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) + 1.0));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) + 1.0, num_to_imag_part(a)));
      break;
    }
  return(x);
}

static s7_pointer g_add_1s(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  s7_num_t a;
  x = cadr(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "+", 2, x, "a number"));
  a = number(x);
  switch (a.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) + 1));
      break;
      
    case NUM_RATIO:
      return(g_add(sc, args));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) + 1.0));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) + 1.0, num_to_imag_part(a)));
      break;
    }
  return(x);
}

/* (let () (define (hi a) (+ a 1)) ((apply let '((x 32)) (list (procedure-source hi))) 12))
 */
#endif


static s7_pointer g_subtract(s7_scheme *sc, s7_pointer args)
{
  #define H_subtract "(- x1 ...) subtracts its trailing arguments from the first, or negates the first if only one argument is given"
  int i, ret_type;
  s7_pointer x;
  s7_num_t a, b;

#if (!WITH_GMP)
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "-", 1, car(args), "a number"));

  if (is_null(cdr(args))) 
    return(s7_negate(sc, car(args)));
#endif

  a = number(car(args));

  i = 2;
  x = cdr(args);

  while (true)
    {
#if WITH_GMP
      switch (a.type)
	{
	case NUM_INT:
	  if ((integer(a) > S7_LONG_MAX) ||
	      (integer(a) < S7_LONG_MIN))
	    return(big_subtract(sc, cons(sc, s7_Int_to_big_integer(sc, integer(a)), x)));
	  break;

	case NUM_RATIO:
	  if ((numerator(a) > S7_LONG_MAX) ||
	      (denominator(a) > S7_LONG_MAX) ||
	      (numerator(a) < S7_LONG_MIN))
	    return(big_subtract(sc, cons(sc, s7_ratio_to_big_ratio(sc, (numerator(a)), denominator(a)), x)));
	  break;
	}
#else
      if (!s7_is_number(car(x)))
	return(s7_wrong_type_arg_error(sc, "-", i, car(x), "a number"));
#endif

      b = number(car(x));
      ret_type = a.type | b.type;
      x = cdr(x);
  
      switch (ret_type)
	{
	case NUM_INT: 
	  if (is_null(x))
	    return(s7_make_integer(sc, integer(a) - integer(b)));
	  integer(a) -= integer(b);
	  break;
      
	case NUM_RATIO:
	  {
	    s7_Int d1, d2, n1, n2;
	    d1 = num_to_denominator(a);
	    n1 = num_to_numerator(a);
	    d2 = num_to_denominator(b);
	    n2 = num_to_numerator(b);

	    if (d1 == d2)                                     /* the easy case -- if overflow here, it matches the int case */
	      {
		if (is_null(x))
		  return(s7_make_ratio(sc, n1 - n2, d1));
		a = make_ratio(n1 - n2, d1);
	      }
	    else
	      {
#if (!WITH_GMP)
		if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
		    (n1 > s7_int_max) || (n2 > s7_int_max) ||
		    (n1 < s7_int_min) || (n2 < s7_int_min))
		  {
		    int d1bits, d2bits;
		    d1bits = integer_length(d1);
		    d2bits = integer_length(d2);
		    if (((d1bits + d2bits) > s7_int_bits) ||
			((d1bits + integer_length(n2)) > (s7_int_bits - 1)) ||
			((d2bits + integer_length(n1)) > (s7_int_bits - 1)))
		      {
			if (is_null(x))
			  return(s7_make_real(sc, ((long double)n1 / (long double)d1) - ((long double)n2 / (long double)d2)));
			a.type = NUM_REAL;
			real(a) = ((long double)n1 / (long double)d1) - ((long double)n2 / (long double)d2);
		      }
		    else 
		      {
			if (is_null(x))
			  return(s7_make_ratio(sc, n1 * d2 - n2 * d1, d1 * d2));
			a = make_ratio(n1 * d2 - n2 * d1, d1 * d2);
		      }
		  }
		else 
#endif
		  {
		    if (is_null(x))
		      return(s7_make_ratio(sc, n1 * d2 - n2 * d1, d1 * d2));
		    a = make_ratio(n1 * d2 - n2 * d1, d1 * d2);
		  }
	      }
	  }
	  break;
      
	case NUM_REAL2:
	case NUM_REAL:
	  if (is_null(x))
	    return(s7_make_real(sc, num_to_real(a) - num_to_real(b)));
	  real(a) = num_to_real(a) - num_to_real(b);
	  a.type = NUM_REAL;
	  break;
      
	default:
	  if (is_null(x))
	    return(s7_make_complex(sc, num_to_real_part(a) - num_to_real_part(b), num_to_imag_part(a) - num_to_imag_part(b)));
	  real_part(a) = num_to_real_part(a) - num_to_real_part(b);
	  imag_part(a) = num_to_imag_part(a) - num_to_imag_part(b);
	  if (imag_part(a) == 0.0)
	    a.type = NUM_REAL;
	  else a.type = NUM_COMPLEX;
	  break;
	}

      i++;
    }
  return(s7_error(sc, make_symbol(sc, "internal-error"),
		  list_2(sc, make_protected_string(sc, "s7 mishandled subtraction: ~S\n"), args)));
}


#if WITH_OPTIMIZATION
static s7_pointer subtract_1, subtract_s1, subtract_2;

static s7_pointer g_subtract_1(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "-", 1, car(args), "a number"));
  return(s7_negate(sc, car(args)));
}

static s7_pointer g_subtract_2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, y;
  s7_num_t a, b;

  x = car(args);
  y = cadr(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "-", 1, x, "a number"));
  if (!s7_is_number(y))
    return(s7_wrong_type_arg_error(sc, "-", 2, y, "a number"));
  a = number(x);
  b = number(y);

  switch (a.type | b.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) - integer(b)));
      break;
      
    case NUM_RATIO:
      return(subtract_ratios(sc, a, b));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) - num_to_real(b)));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) - num_to_real_part(b), num_to_imag_part(a) - num_to_imag_part(b)));
      break;
    }
  return(x);
}

static s7_pointer g_subtract_s1(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  s7_num_t a;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "-", 1, x, "a number"));

  a = number(x);
  switch (a.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) - 1));
      break;
      
    case NUM_RATIO:
      return(subtract_ratios(sc, a, number(small_int(1))));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) - 1.0));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) - 1.0, num_to_imag_part(a)));
      break;
    }
  return(x);
}
#endif

static s7_pointer g_multiply(s7_scheme *sc, s7_pointer args)
{
  #define H_multiply "(* ...) multiplies its arguments"

  int i, ret_type;
  s7_pointer x;
  s7_num_t a, b;

#if (!WITH_GMP)
  if (is_null(args))
    return(small_int(1));

  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "*", 1, car(args), "a number"));
#endif

  x = cdr(args);
  if (is_null(x))
    return(car(args));

  a = number(car(args));
  i = 2;

  while (true)
    {
#if WITH_GMP
      s7_pointer old_x;
      old_x = x;
      switch (a.type)
	{
	case NUM_INT:
	  if ((integer(a) > S7_LONG_MAX) ||
	      (integer(a) < S7_LONG_MIN))
	    return(big_multiply(sc, cons(sc, s7_Int_to_big_integer(sc, integer(a)), x)));
	  break;

	case NUM_RATIO:
	  if ((numerator(a) > S7_LONG_MAX) ||
	      (denominator(a) > S7_LONG_MAX) ||
	      (numerator(a) < S7_LONG_MIN))
	    return(big_multiply(sc, cons(sc, s7_ratio_to_big_ratio(sc, (numerator(a)), denominator(a)), x)));
	  break;
	}
#else
    if (!s7_is_number(car(x)))
      return(s7_wrong_type_arg_error(sc, "*", i, car(x), "a number"));
#endif

      b = number(car(x));
      ret_type = a.type | b.type;
      x = cdr(x);
  
      switch (ret_type)
	{
	case NUM_INT: 
#if WITH_GMP
	  if ((integer(b) > S7_LONG_MAX) ||
	      (integer(b) < S7_LONG_MIN))
	    return(big_multiply(sc, cons(sc, s7_Int_to_big_integer(sc, integer(a)), old_x)));

	  if (is_null(x))
	    return(s7_make_integer(sc, integer(a) * integer(b)));
	  integer(a) *= integer(b);
#else
	  if (sc->safety != 0)
	    {
	      bool a_signed;                                 /* (* 524288 19073486328125) -> -8446744073709551616 */
	      a_signed = (((integer(a) < 0) && (integer(b) > 0)) ||
			  ((integer(a) > 0) && (integer(b) < 0)));
	      integer(a) *= integer(b);
	      if (a_signed != (integer(a) < 0))
		return(s7_out_of_range_error(sc, "* with ", 0, args, "result is too large"));
	      if (is_null(x))
		return(s7_make_integer(sc, integer(a)));
	    }
	  else
	    {
	      if (is_null(x))
		return(s7_make_integer(sc, integer(a) * integer(b)));
	      integer(a) *= integer(b);
	    }
#endif
	  break;
      
	case NUM_RATIO:
	  {
	    s7_Int d1, d2, n1, n2;
	    d1 = num_to_denominator(a);
	    n1 = num_to_numerator(a);
	    d2 = num_to_denominator(b);
	    n2 = num_to_numerator(b);
#if (!WITH_GMP)
	    if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
		(n1 > s7_int_max) || (n2 > s7_int_max) ||     /*    (* 1/524288 1/19073486328125) for example */
		(n1 < s7_int_min) || (n2 < s7_int_min))
	      {
		if ((integer_length(d1) + integer_length(d2) > s7_int_bits) ||
		    (integer_length(n1) + integer_length(n2) > s7_int_bits))
		  {
		    if (is_null(x))
		      return(s7_make_real(sc, ((long double)n1 / (long double)d1) * ((long double)n2 / (long double)d2)));
		    a.type = NUM_REAL;
		    real(a) = ((long double)n1 / (long double)d1) * ((long double)n2 / (long double)d2);
		  }
		else
		  {
		    if (is_null(x))
		      return(s7_make_ratio(sc, n1 * n2, d1 * d2));
		    a = make_ratio(n1 * n2, d1 * d2);
		  }
	      }
	    else
#endif
	      {
		if (is_null(x))
		  return(s7_make_ratio(sc, n1 * n2, d1 * d2));
		a = make_ratio(n1 * n2, d1 * d2);
	      }
	  }
	  break;
      
	case NUM_REAL2:
	case NUM_REAL:
	  if (is_null(x))
	    return(s7_make_real(sc, num_to_real(a) * num_to_real(b)));
	  real(a) = num_to_real(a) * num_to_real(b);
	  a.type = NUM_REAL;
	  break;
      
	default:
	  {
	    s7_Double r1, r2, i1, i2;
	    r1 = num_to_real_part(a);
	    r2 = num_to_real_part(b);
	    i1 = num_to_imag_part(a);
	    i2 = num_to_imag_part(b);
	    if (is_null(x))
	      return(s7_make_complex(sc, r1 * r2 - i1 * i2, r1 * i2 + r2 * i1));
	    real_part(a) = r1 * r2 - i1 * i2;
	    imag_part(a) = r1 * i2 + r2 * i1;
	    if (imag_part(a) == 0.0)
	      a.type = NUM_REAL;
	    else a.type = NUM_COMPLEX;
	  }
	  break;
	}

      i++;
    }
  return(s7_error(sc, make_symbol(sc, "internal-error"),
		  list_2(sc, make_protected_string(sc, "s7 mishandled multiplication: ~S\n"), args)));
}


#if WITH_OPTIMIZATION
static s7_pointer multiply_2, multiply_i2, multiply_f2;

static s7_pointer g_multiply_2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, y;
  s7_num_t a, b;
  x = car(args);
  y = cadr(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "*", 1, x, "a number"));
  if (!s7_is_number(y))
    return(s7_wrong_type_arg_error(sc, "*", 2, y, "a number"));
  a = number(x);
  b = number(y);
  switch (a.type | b.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) * integer(b)));
      break;
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) * num_to_real(b)));
      break;
      
    default:
      return(g_multiply(sc, args));
      break;
    }
  return(x);
}

static s7_pointer g_multiply_i2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  s7_num_t a;
  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "*", 1, x, "a number"));
  a = number(x);
  switch (a.type)
    {
    case NUM_INT: 
      return(s7_make_integer(sc, integer(a) * 2));
      break;
      
    case NUM_RATIO:
      return(s7_make_ratio(sc, numerator(a) * 2, denominator(a)));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) * 2.0));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) * 2.0, num_to_imag_part(a) * 2.0));
      break;
    }
  return(x);
}

static s7_pointer g_multiply_f2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  s7_num_t a;
  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "*", 1, x, "a number"));
  a = number(x);
  switch (a.type)
    {
    case NUM_INT: 
      return(s7_make_real(sc, integer(a) * 2.0));
      break;
      
    case NUM_RATIO:
      return(s7_make_real(sc, numerator(a) * 2.0 / denominator(a)));
      
    case NUM_REAL2:
    case NUM_REAL:
      return(s7_make_real(sc, num_to_real(a) * 2.0));
      break;
      
    default:
      return(s7_make_complex(sc, num_to_real_part(a) * 2.0, num_to_imag_part(a) * 2.0));
      break;
    }
  return(x);
}
#endif


static s7_pointer g_divide(s7_scheme *sc, s7_pointer args)
{
  #define H_divide "(/ x1 ...) divides its first argument by the rest, or inverts the first if there is only one argument"
  int i, ret_type;
  s7_pointer x;
  s7_num_t a, b;

#if (!WITH_GMP)
    if (!s7_is_number(car(args)))
      return(s7_wrong_type_arg_error(sc, "/", 1, car(args), "a number"));

  if (is_null(cdr(args)))
    {
      if (s7_is_zero(car(args)))
	return(division_by_zero_error(sc, "/", car(args)));
      return(s7_invert(sc, car(args)));
    }
#endif

  a = number(car(args));
  i = 2;
  x = cdr(args);

  while (true)
    {
#if (!WITH_GMP)
      if (!s7_is_number(car(x)))
	return(s7_wrong_type_arg_error(sc, "/", i, car(x), "a number"));
#endif

      if (s7_is_zero(car(x)))
	return(division_by_zero_error(sc, "/", car(x)));
      /* to be consistent, I suppose we should search first for NaNs in the divisor list.
       *   (* 0 0/0) is NaN, so (/ 1 0 0/0) should equal (/ 1 0/0) = NaN.  But the whole
       *   thing is ridiculous.
       */

#if WITH_GMP
      switch (a.type)
	{
	case NUM_INT:
	  if ((integer(a) > S7_LONG_MAX) ||
	      (integer(a) < S7_LONG_MIN))
	    return(big_divide(sc, cons(sc, s7_Int_to_big_integer(sc, integer(a)), x)));
	  break;

	case NUM_RATIO:
	  if ((numerator(a) > S7_LONG_MAX) ||
	      (denominator(a) > S7_LONG_MAX) ||
	      (numerator(a) < S7_LONG_MIN))
	    return(big_divide(sc, cons(sc, s7_ratio_to_big_ratio(sc, (numerator(a)), denominator(a)), x)));
	  break;
	}
#endif
      
      b = number(car(x));
      ret_type = a.type | b.type;
      x = cdr(x);
  
      switch (ret_type)
	{
	case NUM_INT: 
#if (!WITH_GMP)
	  if (integer(b) == S7_LLONG_MIN)
	    {
	      if (integer(a) == integer(b))
		{
		  if (is_null(x))
		    return(small_ints[1]);
		  integer(a) = 1;
		}
	      else
		{
		  if (is_null(x))
		    {
		      if (integer(a) & 1)
			return(s7_make_ratio(sc, integer(a), integer(b) + 1));
		      else return(s7_make_ratio(sc, integer(a) / 2, integer(b) / 2));
		    }
		  else
		    {
		      if (integer(a) & 1)
			a = make_ratio(integer(a), integer(b) + 1);
		      else a = make_ratio(integer(a) / 2, integer(b) / 2);
		    }
		}
	    }
	  else
#endif
	    {
	      if (is_null(x))
		return(s7_make_ratio(sc, integer(a), integer(b)));
	      a = make_ratio(integer(a), integer(b));  /* b checked for 0 above */
	    }
	  break;

	case NUM_RATIO:
	  {
	    s7_Int d1, d2, n1, n2;
	    d1 = num_to_denominator(a);
	    n1 = num_to_numerator(a);
	    d2 = num_to_denominator(b);
	    n2 = num_to_numerator(b);

	    if (d1 == d2)
	      {
		if (is_null(x))
		  return(s7_make_ratio(sc, n1, n2));
		a = make_ratio(n1, n2);
	      }
	    else
	      {
#if (!WITH_GMP)
		if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
		    (n1 > s7_int_max) || (n2 > s7_int_max) ||
		    (n1 < s7_int_min) || (n2 < s7_int_min))
		  {
		    if ((integer_length(d1) + integer_length(n2) > s7_int_bits) ||
			(integer_length(d2) + integer_length(n1) > s7_int_bits))
		      {
			if (is_null(x))
			  return(s7_make_real(sc, ((long double)n1 / (long double)d1) / ((long double)n2 / (long double)d2)));
			a.type = NUM_REAL;
			real(a) = ((long double)n1 / (long double)d1) / ((long double)n2 / (long double)d2);
		      }
		    else 
		      {
			if (is_null(x))
			  return(s7_make_ratio(sc, n1 * d2, d1 * n2));
			a = make_ratio(n1 * d2, d1 * n2);
		      }
		  }
		else
#endif
		  {
		    if (is_null(x))
		      return(s7_make_ratio(sc, n1 * d2, d1 * n2));
		    a = make_ratio(n1 * d2, d1 * n2);
		  }
	      }
	  }
	  break;
      
	case NUM_REAL2:
	case NUM_REAL:
	  if (is_null(x))
	    return(s7_make_real(sc, num_to_real(a) / num_to_real(b)));
	  real(a) = num_to_real(a) / num_to_real(b);
	  a.type =  NUM_REAL; /* must follow num_to_real */
	  break;
      
	default:
	  {
	    s7_Double r1, r2, i1, i2, den;
	    r1 = num_to_real_part(a);
	    r2 = num_to_real_part(b);
	    i1 = num_to_imag_part(a);
	    i2 = num_to_imag_part(b);
	    den = (r2 * r2 + i2 * i2);

	    /* we could avoid the squaring (see Knuth II p613 16)
	     *    not a big deal: (/ 1.0e308+1.0e308i 2.0e308+2.0e308i) => nan
	     *    (gmp case is ok here) 
	     */
	    if (is_null(x))
	      return(s7_make_complex(sc, (r1 * r2 + i1 * i2) / den, (r2 * i1 - r1 * i2) / den));

	    real_part(a) = (r1 * r2 + i1 * i2) / den;
	    imag_part(a) = (r2 * i1 - r1 * i2) / den;
	    if (imag_part(a) == 0.0)
	      a.type = NUM_REAL;
	    else a.type = NUM_COMPLEX;
	  }
	  break;
	}

      i++;
    }
  return(s7_error(sc, make_symbol(sc, "internal-error"),
		  list_2(sc, make_protected_string(sc, "s7 mishandled division: ~S\n"), args)));
}


static s7_pointer g_max(s7_scheme *sc, s7_pointer args)
{
  #define H_max "(max ...) returns the maximum of its arguments"
  int i;
  s7_pointer x, ap, bp, result;
  s7_num_t a, b;

  ap = car(args);
  if (!s7_is_real(ap))
    return(s7_wrong_type_arg_error(sc, "max", (is_null(cdr(args))) ? 0 : 1, ap, "a real"));

  x = cdr(args);
  if (is_null(x))
    return(ap);

  result = ap;
  a = number(ap);
  if ((a.type > NUM_RATIO) && (isnan(real(a))))
    {
      for (i = 2, x = cdr(args); is_not_null(x); i++, x = cdr(x))
	if (!s7_is_real(car(x)))
	  return(s7_wrong_type_arg_error(sc, "max", i, car(x), "a real"));
      return(s7_make_real(sc, NAN));
    }

  i = 2;
  while (true)
    {
      bp = car(x);
      if (!s7_is_real(bp))
	return(s7_wrong_type_arg_error(sc, "max", i, bp, "a real"));

      b = number(bp);

      switch (a.type | b.type)
	{
	case NUM_INT: 
	  if (integer(a) < integer(b))
	    {
	      a = b;
	      result = bp;
	    }
	  break;
      
	case NUM_RATIO:
	  {
	    s7_Int num_a, num_b, den_a, den_b;
	    num_a = num_to_numerator(a);
	    num_b = num_to_numerator(b);
	    den_a = num_to_denominator(a);
	    den_b = num_to_denominator(b);

	    /* there are tricky cases here where long ints outrun doubles:
	     *   (max 92233720368547758/9223372036854775807 92233720368547757/9223372036854775807)
	     * which should be 92233720368547758/9223372036854775807) but 1st the fraction gets reduced
	     * to 13176245766935394/1317624576693539401, so we fall into the double comparison, and
	     * there we should be comparing 
	     *    9.999999999999999992410584792601468961145E-3 and
	     *    9.999999999999999883990367544051025548645E-3
	     * but if using doubles we get 
	     *    0.010000000000000000208166817117 and
	     *    0.010000000000000000208166817117
	     * that is, we can't distinguish these two fractions once they're coerced to doubles.
	     *
	     * Even long doubles fail in innocuous-looking cases:
	     *     (min 21053343141/6701487259 3587785776203/1142027682075) -> 3587785776203/1142027682075
	     *     (max 21053343141/6701487259 3587785776203/1142027682075) -> 3587785776203/1142027682075
	     *
	     * Another consequence: outside gmp, we can't handle cases like
	     *    (max 9223372036854776/9223372036854775807 #i9223372036854775/9223372036854775000)
	     *    (max #i9223372036854776/9223372036854775807 9223372036854775/9223372036854775000)
	     * I guess if the user is using "inexact" numbers (#i...), he accepts their inexactness.
	     */

	    if (den_a == den_b)
	      {
		if (num_a < num_b)
		  {
		    a = b;
		    result = bp;
		  }
	      }
	    else
	      {
		if (num_a == num_b)
		  {
		    if (((num_a >= 0) &&
			 (den_a > den_b)) ||
			((num_a < 0) &&
			 (den_a < den_b)))
		      {
			a = b;
			result = bp;
		      }
		  }
		else
		  {
		    s7_Int vala, valb;
		    vala = num_a / den_a;
		    valb = num_b / den_b;

		    if (!((vala > valb) ||
			  ((vala == valb) && (b.type == NUM_INT))))
		      {
			if ((valb > vala) ||
			    ((vala == valb) && (a.type == NUM_INT)) ||
			    /* sigh -- both are ratios and the int parts are equal */
			    (((long double)(num_a % den_a) / (long double)den_a) <= ((long double)(num_b % den_b) / (long double)den_b)))
			  {
			    a = b;
			    result = bp;
			  }
		      }
		  }
	      }
	  }
	  break;
      
	default:
	  if ((b.type > NUM_RATIO) && (isnan(real(b)))) 
	    {
	      for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x))
		if (!s7_is_real(car(x)))
		  return(s7_wrong_type_arg_error(sc, "max", i, car(x), "a real"));
	      return(s7_make_real(sc, NAN));
	    }
	  if (num_to_real(a) < num_to_real(b))
	    {
	      a = b;
	      result = bp;
	    }
	  break;
	}

      x = cdr(x);
      if (is_null(x))
	return(result);

      i++;
    }
  return(result);
}


static s7_pointer g_min(s7_scheme *sc, s7_pointer args)
{
  #define H_min "(min ...) returns the minimum of its arguments"
  int i;
  s7_pointer x, ap, bp, result;
  s7_num_t a, b;

  ap = car(args);
  if (!s7_is_real(ap))
    return(s7_wrong_type_arg_error(sc, "min", (is_null(cdr(args))) ? 0 : 1, ap, "a real"));

  x = cdr(args);
  if (is_null(x))
    return(ap);

  result = ap;
  a = number(ap);
  if ((a.type > NUM_RATIO) && (isnan(real(a)))) 
    {
      for (i = 2, x = cdr(args); is_not_null(x); i++, x = cdr(x))
	if (!s7_is_real(car(x)))
	  return(s7_wrong_type_arg_error(sc, "min", i, car(x), "a real"));
      return(s7_make_real(sc, NAN));
    }
  i = 2;
  while (true)
    {
      bp = car(x);
      if (!s7_is_real(bp))
	return(s7_wrong_type_arg_error(sc, "min", i, bp, "a real"));

      b = number(bp);

      switch (a.type | b.type)
	{
	case NUM_INT: 
	  if (integer(a) > integer(b))
	    {
	      a = b;
	      result = bp;
	    }
	  break;
      
	case NUM_RATIO:
	  {
	    s7_Int num_a, num_b, den_a, den_b;
	    num_a = num_to_numerator(a);
	    num_b = num_to_numerator(b);
	    den_a = num_to_denominator(a);
	    den_b = num_to_denominator(b);
	    /* there are tricky cases here where long ints outrun doubles */
	    if (den_a == den_b)
	      {
		if (num_a > num_b)
		  {
		    a = b;
		    result = bp;
		  }
	      }
	    else
	      {
		if (num_a == num_b)
		  {
		    if (((num_a >= 0) &&
			 (den_a < den_b)) ||
			((num_a < 0) &&
			 (den_a > den_b)))
		      {
			a = b;
			result = bp;
		      }
		  }
		else
		  {
		    s7_Int vala, valb;
		    vala = num_a / den_a;
		    valb = num_b / den_b;

		    if (!((vala < valb) ||
			  ((vala == valb) && (a.type == NUM_INT))))
		      {
			if ((valb < vala) ||
			    ((vala == valb) && (b.type == NUM_INT)) ||
			    /* sigh -- both are ratios and the int parts are equal (see comment under g_max above) */
			    (((long double)(num_a % den_a) / (long double)den_a) >= ((long double)(num_b % den_b) / (long double)den_b)))
			  {
			    a = b;
			    result = bp;
			  }
		      }
		  }
	      }
	  }
	  break;

	default:
	  if ((b.type > NUM_RATIO) && (isnan(real(b)))) 
	    {
	      for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x))
		if (!s7_is_real(car(x)))
		  return(s7_wrong_type_arg_error(sc, "min", i, car(x), "a real"));
	      return(s7_make_real(sc, NAN));
	    }
	  if (num_to_real(a) > num_to_real(b))
	    {
	      a = b;
	      result = bp;
	    }
	  break;
	}

      x = cdr(x);
      if (is_null(x))
	return(result);

      i++;
    }
  return(result);
}


static s7_pointer g_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_equal "(= z1 ...) returns #t if all its arguments are equal"
  int i, type_a, type_b;
  s7_pointer x;
  s7_num_t a, b;

  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "=", 1, car(args), "a number"));
  
  a = number(car(args));
  type_a = num_type(a);

  x = cdr(args);
  i = 2;
  while (true)
    {
      s7_pointer tmp;
      bool equal = true;

      tmp = car(x);
      if (!s7_is_number(tmp))
	  return(s7_wrong_type_arg_error(sc, "=", i, tmp, "a number"));

      b = number(tmp);
      type_b = num_type(b);

      switch (type_a)
	{
	case NUM_INT:
	  switch (type_b)
	    {
	    case NUM_INT: 
	      equal = (integer(a) == integer(b));
	      break;

	    case NUM_RATIO:
	      equal = false;
	      break;

	    case NUM_REAL:
	    case NUM_REAL2:
	      equal = (integer(a) == real(b));
	      break;

	    default: 
	      equal = ((imag_part(b) == 0.0) &&
		       (real_part(b) == integer(a)));
	      break;
	    }
	  break;
      
	case NUM_RATIO:  
	  switch (type_b)
	    {
	    case NUM_RATIO:
	      equal = ((numerator(a) == numerator(b)) &&
		       (denominator(a) == denominator(b)));
	      break;

	    case NUM_REAL:
	    case NUM_REAL2:
	      equal = (fraction(a) == real(b));
	      break;

	    default:
	      equal = false;
	      break;
	    }
	  break;
      
	case NUM_REAL2:
	case NUM_REAL:    
	  switch (type_b)
	    {
	    case NUM_INT:
	      equal = (real(a) == integer(b));
	      break;

	    case NUM_RATIO:
	      equal = (real(a) == fraction(b));
	      break;

	    case NUM_REAL:
	    case NUM_REAL2:
	      equal = (real(a) == real(b));
	      break;

	    default:
	      equal = ((imag_part(b) == 0.0) &&
		       (real_part(b) == real(a)));
	      break;
	    }
	  break;
      
	default:
	  switch (type_b)
	    {
	    case NUM_INT:
	      equal = ((imag_part(a) == 0.0) &&
		       (real_part(a) == integer(b)));
	      break;

	    case NUM_RATIO:
	      equal = ((imag_part(a) == 0.0) &&
		       (real_part(a) == fraction(b)));
	      break;

	    case NUM_REAL:
	    case NUM_REAL2:
	      equal = ((imag_part(a) == 0.0) &&
		       (real_part(a) == real(b)));
	      break;

	    default:
	      equal = ((real_part(a) == real_part(b)) &&
		       (imag_part(a) == imag_part(b)));
	      break;
	    }
	  break;
	}

      if (!equal)
	{
	  for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	    if (!s7_is_number(car(x)))
	      return(s7_wrong_type_arg_error(sc, "=", i, car(x), "a number"));
	  
	  return(sc->F);
	}

      x = cdr(x);
      if (is_null(x))
	return(sc->T);

      a = b;
      type_a = type_b;
      i++;
    }

  return(sc->T);
}

#if WITH_OPTIMIZATION
static s7_pointer equal_s_ic, equal_length_ic, equal_2;
static s7_pointer g_equal_s_ic(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a;
  s7_Int y;
  
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "=", 1, car(args), "a number"));
  
  a = number(car(args));
  y = s7_integer(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      return(make_boolean(sc, integer(a) == y));
      break;
      
    case NUM_RATIO:  
      return(sc->F);
      
    case NUM_REAL2:
    case NUM_REAL:    
      return(make_boolean(sc, real(a) == y));
      break;

    default:
      return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) == y)));
    }
  return(sc->T);
}

static s7_pointer object_length(s7_scheme *sc, s7_pointer obj);

static s7_pointer g_equal_length_ic(s7_scheme *sc, s7_pointer args)
{
  /* an experiment to avoid s7_make_integer (and telescope opts)
   *   we get here with car=length expr, cadr=int
   */
  s7_Int ilen;
  s7_pointer val;
  
  val = find_symbol_or_bust_65(sc, cadar(args));
  ilen = s7_integer(cadr(args));

  switch (type(val))
    {
    case T_PAIR:
      return(make_boolean(sc, s7_list_length(sc, val) == ilen));

    case T_NIL:
      return(make_boolean(sc, ilen == 0));

    case T_VECTOR:
      return(make_boolean(sc, vector_length(val) == ilen));

    case T_STRING:
      return(make_boolean(sc, string_length(val) == ilen));

    case T_HASH_TABLE:
      return(make_boolean(sc, hash_table_length(val) == ilen));

    case T_C_OBJECT:
      return(make_boolean(sc, s7_integer(object_length(sc, val)) == ilen));

    default:
      return(s7_wrong_type_arg_error(sc, "length", 0, val, "a list, vector, string, or hash-table"));
    }
  return(sc->F);
}

static s7_pointer g_equal_2(s7_scheme *sc, s7_pointer args)
{

  int type_a, type_b;
  s7_pointer x, y;
  s7_num_t a, b;

  x = car(args);
  if (!s7_is_number(x))
    return(s7_wrong_type_arg_error(sc, "=", 1, x, "a number"));

  y = cadr(args);
  if (!s7_is_number(y))
    return(s7_wrong_type_arg_error(sc, "=", 2, y, "a number"));
  
  a = number(x);
  type_a = num_type(a);

  b = number(y);
  type_b = num_type(b);

  switch (type_a)
    {
    case NUM_INT:
      switch (type_b)
	{
	case NUM_INT: 
	  return(make_boolean(sc, integer(a) == integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(sc->F);
	  break;
	  
	case NUM_REAL:
	case NUM_REAL2:
	  return(make_boolean(sc, integer(a) == real(b)));
	  break;
	  
	default: 
	  return(make_boolean(sc, (imag_part(b) == 0.0) && (real_part(b) == integer(a))));
	  break;
	}
      break;
      
    case NUM_RATIO:  
      switch (type_b)
	{
	case NUM_RATIO:
	  return(make_boolean(sc, (numerator(a) == numerator(b)) && (denominator(a) == denominator(b))));
	  break;
	  
	case NUM_REAL:
	case NUM_REAL2:
	  return(make_boolean(sc, fraction(a) == real(b)));
	  break;
	  
	default:
	  return(sc->F);
	  break;
	}
      break;
      
    case NUM_REAL2:
    case NUM_REAL:    
      switch (type_b)
	{
	case NUM_INT:
	  return(make_boolean(sc, real(a) == integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, real(a) == fraction(b)));
	  break;
	  
	case NUM_REAL:
	case NUM_REAL2:
	  return(make_boolean(sc, real(a) == real(b)));
	  break;
	  
	default:
	  return(make_boolean(sc, (imag_part(b) == 0.0) && (real_part(b) == real(a))));
	  break;
	}
      break;
      
    default:
      switch (type_b)
	{
	case NUM_INT:
	  return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) == integer(b))));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) == fraction(b))));
	  break;
	  
	case NUM_REAL:
	case NUM_REAL2:
	  return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) == real(b))));
	  break;
	  
	default:
	  return(make_boolean(sc, (real_part(a) == real_part(b)) && (imag_part(a) == imag_part(b))));
	  break;
	}
      break;
    }
  return(sc->F);
}

#endif



#if (!WITH_GMP)
static s7_pointer g_less_1(s7_scheme *sc, bool reversed, s7_pointer args)
{
  int i, type_a, type_b;
  s7_pointer x;
  s7_num_t a, b;

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, (reversed) ? ">=" : "<", 1, car(args), "a real"));

  a = number(car(args));
  type_a = num_type(a);

  if ((type_a > NUM_RATIO) && (isnan(real(a))))
    {
      for (i = 2, x = cdr(args); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	if (!s7_is_real(car(x)))
	  return(s7_wrong_type_arg_error(sc, (reversed) ? ">=" : "<", i, car(x), "a real"));
      return(sc->F);
    }

  i = 2;
  x = cdr(args);
  while (true)
    {
      s7_pointer tmp;
      bool less = true;

      tmp = car(x);
      if (!s7_is_real(tmp))
	return(s7_wrong_type_arg_error(sc, (reversed) ? ">=" : "<", i, tmp, "a real"));

      b = number(tmp);
      type_b = num_type(b);
      if ((type_b > NUM_RATIO) && (isnan(real(b))))
	{
	  for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	    if (!s7_is_real(car(x)))
	      return(s7_wrong_type_arg_error(sc, (reversed) ? ">=" : "<", i, car(x), "a real"));
	  return(sc->F);
	}

      switch (type_a)
	{
	case NUM_INT:
	  switch (type_b)
	    {
	    case NUM_INT:
	      less = (integer(a) < integer(b));
	      break;

	    case NUM_RATIO: 
	      /* no gmp here, but this can overflow: (< 9223372036 1/9223372036), but conversion to real is also problematic
	       */
	      if ((integer(a) >= 0) && (numerator(b) < 0))
		less = false;
	      else
		{
		  if ((integer(a) <= 0) && (numerator(b) > 0))
		    less = true;
		  else
		    {
		      if ((integer(a) < S7_LONG_MAX) && 
			  (integer(a) > S7_LONG_MIN) && 
			  (denominator(b) < S7_LONG_MAX) && 
			  (denominator(b) > S7_LONG_MIN))
			less = ((integer(a) * denominator(b)) < numerator(b));
		      else less = (integer(a) < fraction(b));
		    }
		}
	      break;

	    default:
	      less = (integer(a) < real(b));
	      break;
	    }
	  break;

	case NUM_RATIO:
	  switch (type_b)
	    {
	    case NUM_INT: 
	      /* same case as above (sigh) */
	      if ((integer(b) >= 0) && (numerator(a) < 0))
		less = true;
	      else
		{
		  if ((integer(b) <= 0) && (numerator(a) > 0))
		    less = false;
		  else
		    {
		      if ((integer(b) < S7_LONG_MAX) && 
			  (integer(b) > S7_LONG_MIN) && 
			  (denominator(a) < S7_LONG_MAX) && 
			  (denominator(a) > S7_LONG_MIN))
			less = (numerator(a) < (integer(b) * denominator(a)));
		      else less = (fraction(a) < integer(b));
		    }
		}
	      break;

	    case NUM_RATIO:
	      /* conversion to real and < is not safe here (see comment under g_greater) */
	      {
		s7_Int d1, d2, n1, n2;
		d1 = num_to_denominator(a);
		n1 = num_to_numerator(a);
		d2 = num_to_denominator(b);
		n2 = num_to_numerator(b);

		if (d1 == d2)                    
		  less = (n1 < n2);
		else
		  {
		    if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
			(n1 > s7_int_max) || (n2 > s7_int_max) ||
			(n1 < s7_int_min) || (n2 < s7_int_min))
		      {
			int d1bits, d2bits;
			d1bits = integer_length(d1);
			d2bits = integer_length(d2);
			if (((d1bits + d2bits) > s7_int_bits) ||
			    ((d1bits + integer_length(n2)) > (s7_int_bits - 1)) ||
			    ((d2bits + integer_length(n1)) > (s7_int_bits - 1)))
			  less = (fraction(a) < fraction(b));   
      
			  /* (< 21053343141/6701487259 3587785776203/1142027682075) -> #f because even long doubles aren't enough here 
			   * (= 21053343141/6701487259 3587785776203/1142027682075) is #f because it checks the actual ints and
			   * (> 21053343141/6701487259 3587785776203/1142027682075) is #f just like the < case.
			   * similarly
			   * (min 21053343141/6701487259 3587785776203/1142027682075) -> 3587785776203/1142027682075
			   * (max 21053343141/6701487259 3587785776203/1142027682075) -> 3587785776203/1142027682075
			   *
			   * if we print the long double results as integers, both are -3958705157555305931
			   *    so there's not a lot I can do in the non-gmp case.
			   */
			else less = ((n1 * d2) < (n2 * d1));
		      }
		    else
		      less = ((n1 * d2) < (n2 * d1));
		  }
	      }
	      break;

	    default:
	      less = (fraction(a) < real(b));
	      break;
	    }
	  break;

	default:
	  switch (type_b)
	    {
	    case NUM_INT: 
	      less = (real(a) < integer(b));
	      break;

	    case NUM_RATIO:
	      less = (real(a) < fraction(b)); /* (< 1.0 9223372036854775806/9223372036854775807) */
	      break;

	    default:
	      less = (real(a) < real(b));
	      break;
	    }
	  break;
	}
      
      if (reversed) less = !less;
      if (!less)
	{
	  for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	    if (!s7_is_real(car(x)))
	      return(s7_wrong_type_arg_error(sc, (reversed) ? ">=" : "<", i, car(x), "a real"));

	  return(sc->F);
	}

      x = cdr(x);
      if (is_null(x))
	return(sc->T);
      
      i++;
      a = b;
      type_a = type_b;
    }

  return(sc->T);
}


static s7_pointer g_less(s7_scheme *sc, s7_pointer args)
{
  #define H_less "(< x1 ...) returns #t if its arguments are in increasing order"
  return(g_less_1(sc, false, args));
}


static s7_pointer g_greater_or_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_greater_or_equal "(>= x1 ...) returns #t if its arguments are in decreasing order"
  /* (>= 1+i 1+i) is an error which seems unfortunate
   */
  return(g_less_1(sc, true, args));  
}


static s7_pointer g_greater_1(s7_scheme *sc, bool reversed, s7_pointer args)
{
  int i, type_a, type_b;
  s7_pointer x;
  s7_num_t a, b;

  /* (>= nan.0 inf.0) returns #t, but in Guile it's #f (and others similar) */
  
  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, (reversed) ? "<=" : ">", 1, car(args), "a real"));

  a = number(car(args));
  type_a = num_type(a);
  if ((type_a > NUM_RATIO) && (isnan(real(a))))
    {
      for (i = 2, x = cdr(args); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	if (!s7_is_real(car(x)))
	  return(s7_wrong_type_arg_error(sc, (reversed) ? "<=" : ">", i, car(x), "a real"));
      return(sc->F);
    }

  i = 2;
  x = cdr(args);
  while (true)
    {
      s7_pointer tmp;
      bool greater = true;

      tmp = car(x);
      if (!s7_is_real(tmp))
	return(s7_wrong_type_arg_error(sc, (reversed) ? "<=" : ">", i, tmp, "a real"));

      b = number(tmp);
      type_b = num_type(b);
      if ((type_b > NUM_RATIO) && (isnan(real(b))))
	{
	  for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	    if (!s7_is_real(car(x)))
	      return(s7_wrong_type_arg_error(sc, (reversed) ? "<=" : ">", i, car(x), "a real"));
	  return(sc->F);
	}

      /* the ">" operator here is a problem.
       *   we get different results depending on the gcc optimization level for cases like (< 1234/11 1234/11)
       *   so, to keep ratios honest, we'll subtract and compare against 0.  But that can cause problems:
       *   :(> 0 most-negative-fixnum)
       *   #f
       */
      switch (type_a)
	{
	case NUM_INT:
	  switch (type_b)
	    {
	    case NUM_INT:
	      greater = (integer(a) > integer(b));
	      break;

	    case NUM_RATIO: 
	      /* see comment above */
	      if ((integer(a) >= 0) && (numerator(b) < 0))
		greater = true;
	      else
		{
		  if ((integer(a) <= 0) && (numerator(b) > 0))
		    greater = false;
		  else
		    {
		      if ((integer(a) < S7_LONG_MAX) && 
			  (integer(a) > S7_LONG_MIN) && 
			  (denominator(b) < S7_LONG_MAX) && 
			  (denominator(b) > S7_LONG_MIN))
			greater = ((integer(a) * denominator(b)) > numerator(b));
		      else greater = (integer(a) > fraction(b));
		    }
		}
	      break;

	    default:
	      greater = (integer(a) > real(b));
	      break;
	    }
	  break;

	case NUM_RATIO:
	  switch (type_b)
	    {
	    case NUM_INT: 
	      if ((integer(b) >= 0) && (numerator(a) < 0))
		greater = false;
	      else
		{
		  if ((integer(b) <= 0) && (numerator(a) > 0))
		    greater = true;
		  else
		    {
		      if ((integer(b) < S7_LONG_MAX) && 
			  (integer(b) > S7_LONG_MIN) && 
			  (denominator(a) < S7_LONG_MAX) && 
			  (denominator(a) > S7_LONG_MIN))
			greater = (numerator(a) > (integer(b) * denominator(a)));
		      else greater = (fraction(a) > integer(b));
		    }
		}
	      break;

	    case NUM_RATIO:
	      {
		s7_Int d1, d2, n1, n2;
		d1 = num_to_denominator(a);
		n1 = num_to_numerator(a);
		d2 = num_to_denominator(b);
		n2 = num_to_numerator(b);

		if (d1 == d2)                    
		  greater = (n1 > n2);
		else
		  {
		    if ((d1 > s7_int_max) || (d2 > s7_int_max) ||     /* before counting bits, check that overflow is possible */
			(n1 > s7_int_max) || (n2 > s7_int_max) ||
			(n1 < s7_int_min) || (n2 < s7_int_min))
		      {
			int d1bits, d2bits;
			d1bits = integer_length(d1);
			d2bits = integer_length(d2);
			if (((d1bits + d2bits) > s7_int_bits) ||
			    ((d1bits + integer_length(n2)) > (s7_int_bits - 1)) ||
			    ((d2bits + integer_length(n1)) > (s7_int_bits - 1)))
			  greater = (fraction(a) > fraction(b));
			else greater = ((n1 * d2) > (n2 * d1));
		      }
		    else
		      greater = ((n1 * d2) > (n2 * d1));
		  }
	      }
	      break;

	    default:
	      greater = (fraction(a) > real(b));
	      break;
	    }
	  break;

	default:
	  switch (type_b)
	    {
	    case NUM_INT: 
	      greater = (real(a) > integer(b));
	      break;

	    case NUM_RATIO:
	      greater = (real(a) > fraction(b));
	      /* as always fraction is trouble: (> (* 4201378396/6659027209 1.0) 6189245291/9809721694) got #f but expected #t
	       */
	      break;

	    default:
	      greater = (real(a) > real(b));
	      break;
	    }
	  break;
	}

      if (reversed) greater = !greater;
      if (!greater)
	{
	  for (i++, x = cdr(x); is_not_null(x); i++, x = cdr(x)) /* check trailing args for bad type */
	    if (!s7_is_real(car(x)))
	      return(s7_wrong_type_arg_error(sc, (reversed) ? "<=" : ">", i, car(x), "a real"));

	  return(sc->F);
	}

      x = cdr(x);
      if (is_null(x))
	return(sc->T);

      i++;
      a = b;
      type_a = type_b;
    }

  return(sc->T);
}


static s7_pointer g_greater(s7_scheme *sc, s7_pointer args)
{
  #define H_greater "(> x1 ...) returns #t if its arguments are in decreasing order"
  return(g_greater_1(sc, false, args));
}


static s7_pointer g_less_or_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_less_or_equal "(<= x1 ...) returns #t if its arguments are in increasing order"
  return(g_greater_1(sc, true, args));  
}


#if WITH_OPTIMIZATION
static s7_pointer less_s_ic;
static s7_pointer g_less_s_ic(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a;
  s7_Int y;
  
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "<", 1, car(args), "a number"));  
  a = number(car(args));
  y = s7_integer(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      return(make_boolean(sc, integer(a) < y));
      break;
      
    case NUM_RATIO:  
      if ((y >= 0) && (numerator(a) < 0))
	return(sc->T);
      if ((y <= 0) && (numerator(a) > 0))
	return(sc->F);
      if ((y < S7_LONG_MAX) && 
	  (y > S7_LONG_MIN) && 
	  (denominator(a) < S7_LONG_MAX) && 
	  (denominator(a) > S7_LONG_MIN))
	return(make_boolean(sc, (numerator(a) < (y * denominator(a)))));
      return(make_boolean(sc, fraction(a) < y));
      break;
      
    case NUM_REAL2:
    case NUM_REAL:    
      return(make_boolean(sc, real(a) < y));
      break;

    default:
      return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) < y)));
    }
  return(sc->T);
}

static s7_pointer less_2;
static s7_pointer g_less_2(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a, b;

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "<", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "<", 2, cadr(args), "a real"));

  a = number(car(args));
  b = number(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      switch (num_type(b))
	{
	case NUM_INT:
	  return(make_boolean(sc, integer(a) < integer(b)));
	  break;
	  
	case NUM_RATIO: 
	  return(g_less_1(sc, false, args));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, integer(a) < real(b)));
	  break;
	}
      break;
      
    case NUM_RATIO:
      return(g_less_1(sc, false, args));
      break;
      
    default:
      if (isnan(real(a))) return(sc->F);
      switch (num_type(b))
	{
	case NUM_INT: 
	  return(make_boolean(sc, real(a) < integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, real(a) < fraction(b)));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, real(a) < real(b)));
	  break;
	}
      break;
    }

  return(sc->T);
}

static s7_pointer leq_s_ic;
static s7_pointer g_leq_s_ic(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a;
  s7_Int y;
  
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "<=", 1, car(args), "a number"));  
  a = number(car(args));
  y = s7_integer(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      return(make_boolean(sc, integer(a) <= y));
      break;
      
    case NUM_RATIO:  
      if ((y >= 0) && (numerator(a) <= 0))
	return(sc->T);
      if ((y <= 0) && (numerator(a) > 0))
	return(sc->F);
      if ((y < S7_LONG_MAX) && 
	  (y > S7_LONG_MIN) && 
	  (denominator(a) < S7_LONG_MAX) && 
	  (denominator(a) > S7_LONG_MIN))
	return(make_boolean(sc, (numerator(a) <= (y * denominator(a)))));
      return(make_boolean(sc, fraction(a) <= y));
      break;
      
    case NUM_REAL2:
    case NUM_REAL:    
      return(make_boolean(sc, real(a) <= y));
      break;

    default:
      return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) <= y)));
    }
  return(sc->T);
}

static s7_pointer leq_2;
static s7_pointer g_leq_2(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a, b;

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "<=", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "<=", 2, cadr(args), "a real"));

  a = number(car(args));
  b = number(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      switch (num_type(b))
	{
	case NUM_INT:
	  return(make_boolean(sc, integer(a) <= integer(b)));
	  break;
	  
	case NUM_RATIO: 
	  return(g_greater_1(sc, true, args));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, integer(a) <= real(b)));
	  break;
	}
      break;
      
    case NUM_RATIO:
      return(g_greater_1(sc, true, args));
      break;
      
    default:
      if (isnan(real(a))) return(sc->F);
      switch (num_type(b))
	{
	case NUM_INT: 
	  return(make_boolean(sc, real(a) <= integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, real(a) <= fraction(b)));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, real(a) <= real(b)));
	  break;
	}
      break;
    }

  return(sc->T);
}

static s7_pointer greater_s_ic;
static s7_pointer g_greater_s_ic(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a;
  s7_Int y;
  
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, ">", 1, car(args), "a number"));  
  a = number(car(args));
  y = s7_integer(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      return(make_boolean(sc, integer(a) > y));
      break;
      
    case NUM_RATIO:  
      if ((y >= 0) && (numerator(a) < 0))
	return(sc->F);
      if ((y <= 0) && (numerator(a) > 0))
	return(sc->T);
      if ((y < S7_LONG_MAX) && 
	  (y > S7_LONG_MIN) && 
	  (denominator(a) < S7_LONG_MAX) && 
	  (denominator(a) > S7_LONG_MIN))
	return(make_boolean(sc, (numerator(a) > (y * denominator(a)))));
      return(make_boolean(sc, fraction(a) > y));
      break;
      
    case NUM_REAL2:
    case NUM_REAL:    
      return(make_boolean(sc, real(a) > y));
      break;

    default:
      return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) > y)));
    }
  return(sc->T);
}


static s7_pointer greater_2;
static s7_pointer g_greater_2(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a, b;

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, ">", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, ">", 2, cadr(args), "a real"));

  a = number(car(args));
  b = number(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      switch (num_type(b))
	{
	case NUM_INT:
	  return(make_boolean(sc, integer(a) > integer(b)));
	  break;
	  
	case NUM_RATIO: 
	  return(g_greater_1(sc, false, args));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, integer(a) > real(b)));
	  break;
	}
      break;
      
    case NUM_RATIO:
      return(g_greater_1(sc, false, args));
      break;
      
    default:
      if (isnan(real(a))) return(sc->F);
      switch (num_type(b))
	{
	case NUM_INT: 
	  return(make_boolean(sc, real(a) > integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, real(a) > fraction(b)));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, real(a) > real(b)));
	  break;
	}
      break;
    }

  return(sc->T);
}


/* (define (hi a b) (> (abs (- a b)) .1)) */
static s7_pointer greater_abs;
static s7_pointer g_greater_abs(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, y;
  s7_Double a;

  x = find_symbol_or_bust_65(sc, cadr(cadr(car(args))));
  if (!s7_is_real(x))
    return(s7_wrong_type_arg_error(sc, "-", 1, x, "a real"));

  y = find_symbol_or_bust_65(sc, caddr(cadr(car(args))));
  if (!s7_is_real(y))
    return(s7_wrong_type_arg_error(sc, "-", 2, y, "a real"));

  a = s7_number_to_real(x) - s7_number_to_real(y);

  return(make_boolean(sc, s7_Double_abs(a) > s7_real(cadr(args))));
}


static s7_pointer geq_2;
static s7_pointer g_geq_2(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a, b;

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, ">=", 1, car(args), "a real"));
  if (!s7_is_real(cadr(args)))
    return(s7_wrong_type_arg_error(sc, ">=", 2, cadr(args), "a real"));

  a = number(car(args));
  b = number(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      switch (num_type(b))
	{
	case NUM_INT:
	  return(make_boolean(sc, integer(a) >= integer(b)));
	  break;
	  
	case NUM_RATIO: 
	  return(g_less_1(sc, true, args));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, integer(a) >= real(b)));
	  break;
	}
      break;
      
    case NUM_RATIO:
      return(g_less_1(sc, true, args));
      break;
      
    default:
      if (isnan(real(a))) return(sc->F);
      switch (num_type(b))
	{
	case NUM_INT: 
	  return(make_boolean(sc, real(a) >= integer(b)));
	  break;
	  
	case NUM_RATIO:
	  return(make_boolean(sc, real(a) >= fraction(b)));
	  break;
	  
	default:
	  if (isnan(real(b))) return(sc->F);
	  return(make_boolean(sc, real(a) >= real(b)));
	  break;
	}
      break;
    }

  return(sc->T);
}


static s7_pointer geq_s_ic;
static s7_pointer g_geq_s_ic(s7_scheme *sc, s7_pointer args)
{
  s7_num_t a;
  s7_Int y;
  
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, ">=", 1, car(args), "a number"));  
  a = number(car(args));
  y = s7_integer(cadr(args));

  switch (num_type(a))
    {
    case NUM_INT:
      return(make_boolean(sc, integer(a) >= y));
      break;
      
    case NUM_RATIO:  
      if ((y >= 0) && (numerator(a) < 0))
	return(sc->F);
      if ((y <= 0) && (numerator(a) >= 0))
	return(sc->T);
      if ((y < S7_LONG_MAX) && 
	  (y > S7_LONG_MIN) && 
	  (denominator(a) < S7_LONG_MAX) && 
	  (denominator(a) > S7_LONG_MIN))
	return(make_boolean(sc, (numerator(a) >= (y * denominator(a)))));
      return(make_boolean(sc, fraction(a) >= y));
      break;
      
    case NUM_REAL2:
    case NUM_REAL:    
      return(make_boolean(sc, real(a) >= y));
      break;

    default:
      return(make_boolean(sc, (imag_part(a) == 0.0) && (real_part(a) >= y)));
    }
  return(sc->T);
}

#endif
#endif



static s7_pointer g_real_part(s7_scheme *sc, s7_pointer args)
{
  #define H_real_part "(real-part num) returns the real part of num"
  s7_pointer p;
  p = car(args);
  if (!s7_is_number(p))
    return(s7_wrong_type_arg_error(sc, "real-part", 0, p, "a number"));
  if (number_type(p) < NUM_COMPLEX)
    return(p);                                      /* if num is real, real-part should return it as is (not exact->inexact) */
  return(s7_make_real(sc, real_part(number(p))));
}


static s7_pointer g_imag_part(s7_scheme *sc, s7_pointer args)
{
  #define H_imag_part "(imag-part num) returns the imaginary part of num"
  s7_pointer p;

  p = car(args);
  if (!s7_is_number(p))
    return(s7_wrong_type_arg_error(sc, "imag-part", 0, p, "a number"));

  /* currently (imag-part nan.0) -> 0.0 ? it's true but maybe confusing */

  switch (number_type(p))
    {
    case NUM_INT:   
    case NUM_RATIO: return(small_int(0));
    case NUM_REAL:
    case NUM_REAL2: return(real_zero);
    default:        return(s7_make_real(sc, complex_imag_part(p)));
    }
}


static s7_pointer g_numerator(s7_scheme *sc, s7_pointer args)
{
  #define H_numerator "(numerator rat) returns the numerator of the rational number rat"
  if (!s7_is_rational(car(args)))
    return(s7_wrong_type_arg_error(sc, "numerator", 0, car(args), "a rational"));
  return(s7_make_integer(sc, num_to_numerator(number(car(args)))));
}


static s7_pointer g_denominator(s7_scheme *sc, s7_pointer args)
{
  #define H_denominator "(denominator rat) returns the denominator of the rational number rat"
  if (!s7_is_rational(car(args)))
    return(s7_wrong_type_arg_error(sc, "denominator", 0, car(args), "a rational"));
  return(s7_make_integer(sc, num_to_denominator(number(car(args)))));
}


#if (!WITH_GMP)
static s7_pointer g_is_nan(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_nan "(nan? obj) returns #t if obj is a NaN"
  s7_pointer x;

  x = car(args);
  if (s7_is_number(x))
    {
      switch (number_type(x))
	{
	case NUM_INT:
	case NUM_RATIO:
	  return(sc->F);
	  
	case NUM_REAL:
	case NUM_REAL2:
	  return(make_boolean(sc, isnan(real(number(x)))));
	  
	default:
#ifndef _MSC_VER
	  return(make_boolean(sc, (isnan(complex_real_part(x))) || (isnan(complex_imag_part(x)))));
#else
	  if (isnan(complex_real_part(x)) || isnan(complex_imag_part(x)))
	    return(sc->T);
	  else return(sc->F);
#endif
	}
    }
  return(sc->F);
}


static s7_pointer g_is_infinite(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_infinite "(infinite? obj) returns #t if obj is an infinite real"
  s7_pointer x;
  x = car(args);
  if (!s7_is_number(x))
    return(sc->F);
  return(make_boolean(sc, (isinf(s7_real_part(x))) || (isinf(s7_imag_part(x)))));
}
#endif


static s7_pointer g_is_number(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_number "(number? obj) returns #t if obj is a number"
  return(make_boolean(sc, s7_is_number(car(args))));
}


static s7_pointer g_is_integer(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_integer "(integer? obj) returns #t if obj is an integer"
  return(make_boolean(sc, s7_is_integer(car(args))));
}


static s7_pointer g_is_real(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_real "(real? obj) returns #t if obj is a real number"
  return(make_boolean(sc, s7_is_real(car(args))));
}


static s7_pointer g_is_complex(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_complex "(complex? obj) returns #t if obj is a number"
  return(make_boolean(sc, s7_is_complex(car(args))));

  /* complex? is currently the same as number? */
}


static s7_pointer g_is_rational(s7_scheme *sc, s7_pointer args) 
{
  #define H_is_rational "(rational? obj) returns #t if obj is a rational number (either an integer or a ratio)"
  return(make_boolean(sc, s7_is_rational(car(args))));

  /* in the non-gmp case, (rational? 455702434782048082459/86885567283849955830) -> #f, not #t
   *  and similarly for exact? etc.
   */
}


static s7_pointer g_is_even(s7_scheme *sc, s7_pointer args)
{
  #define H_is_even "(even? int) returns #t if the integer int is even"
  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "even?", 0, car(args), "an integer"));
  return(make_boolean(sc, (s7_integer(car(args)) & 1) == 0));

  /* extension to gaussian integers: odd if a+b is odd? */
}


static s7_pointer g_is_odd(s7_scheme *sc, s7_pointer args)
{
  #define H_is_odd "(odd? int) returns #t if the integer int is odd"
  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "odd?", 0, car(args), "an integer"));
  return(make_boolean(sc, (s7_integer(car(args)) & 1) == 1));
}


#if (!WITH_GMP)
static s7_pointer g_is_zero(s7_scheme *sc, s7_pointer args)
{
  #define H_is_zero "(zero? num) returns #t if the number num is zero"
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "zero?", 0, car(args), "a number"));
  return(make_boolean(sc, s7_is_zero(car(args))));
}


static s7_pointer g_is_positive(s7_scheme *sc, s7_pointer args)
{
  #define H_is_positive "(positive? num) returns #t if the real number num is positive (greater than 0)"
  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "positive?", 0, car(args), "a real"));
  return(make_boolean(sc, s7_is_positive(car(args))));
}


static s7_pointer g_is_negative(s7_scheme *sc, s7_pointer args)
{
  #define H_is_negative "(negative? num) returns #t if the real number num is negative (less than 0)"
  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "negative?", 0, car(args), "a real"));
  return(make_boolean(sc, s7_is_negative(car(args))));
}


static s7_pointer g_exact_to_inexact(s7_scheme *sc, s7_pointer args)
{
  #define H_exact_to_inexact "(exact->inexact num) converts num to an inexact number; (exact->inexact 3/2) = 1.5"

  if (!s7_is_number(car(args)))   /* apparently (exact->inexact 1+i) is not an error */
    return(s7_wrong_type_arg_error(sc, "exact->inexact", 0, car(args), "a number"));

  if (s7_is_rational(car(args)))
    return(exact_to_inexact(sc, car(args)));

  return(car(args));
}


static s7_pointer g_inexact_to_exact(s7_scheme *sc, s7_pointer args)
{
  #define H_inexact_to_exact "(inexact->exact num) converts num to an exact number; (inexact->exact 1.5) = 3/2"

  if (s7_is_rational(car(args)))        /* (inexact->exact -2305843009213693952/4611686018427387903) which will confuse s7_real below */
    return(car(args));

  if (!s7_is_real(car(args)))
    return(s7_wrong_type_arg_error(sc, "inexact->exact", 0, car(args), "a real number"));

  return(inexact_to_exact(sc, car(args)));
}
#endif
/* (!WITH_GMP) */


static s7_pointer g_is_exact(s7_scheme *sc, s7_pointer args)
{
  #define H_is_exact "(exact? num) returns #t if num is exact (an integer or a ratio)"
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "exact?", 0, car(args), "a number"));
  return(make_boolean(sc, s7_is_exact(car(args))));
}


static s7_pointer g_is_inexact(s7_scheme *sc, s7_pointer args)
{
  #define H_is_inexact "(inexact? num) returns #t if num is inexact (neither an integer nor a ratio)"
  if (!s7_is_number(car(args)))
    return(s7_wrong_type_arg_error(sc, "inexact?", 0, car(args), "a number"));
  return(make_boolean(sc, s7_is_inexact(car(args))));
}


bool s7_is_ulong(s7_pointer arg) 
{
  return(s7_is_integer(arg));
}


unsigned long s7_ulong(s7_pointer p) 
{
  return(number(p).value.ul_value);
}


s7_pointer s7_make_ulong(s7_scheme *sc, unsigned long n) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_NUMBER | T_DONT_COPY);
  
  number_type(x) = NUM_INT;
  number(x).value.ul_value = n;
  return(x);
}


bool s7_is_ulong_long(s7_pointer arg) 
{
  return(s7_is_integer(arg));
}


unsigned long long s7_ulong_long(s7_pointer p) 
{
  return(number(p).value.ull_value);
}


s7_pointer s7_make_ulong_long(s7_scheme *sc, unsigned long long n) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_NUMBER | T_DONT_COPY);
  
  number_type(x) = NUM_INT;
  number(x).value.ull_value = n;
  return(x);
}


static s7_pointer g_integer_length(s7_scheme *sc, s7_pointer args)
{
  #define H_integer_length "(integer-length arg) returns the number of bits required to represent the integer 'arg': (ceiling (log (abs arg) 2))"
  s7_Int x;
  if (!s7_is_integer(car(args)))
      return(s7_wrong_type_arg_error(sc, "integer-length", 0, car(args), "an integer"));
    
  x = s7_integer(car(args));
  if (x < 0)
    return(s7_make_integer(sc, integer_length(-(x + 1))));
  return(s7_make_integer(sc, integer_length(x)));
}


static s7_pointer g_integer_decode_float(s7_scheme *sc, s7_pointer args)
{
  #define H_integer_decode_float "(integer-decode-float x) returns a list containing the significand, exponent, and \
sign of 'x' (1 = positive, -1 = negative).  (integer-decode-float 0.0): (0 0 1)"

  s7_Int ix;
  s7_pointer arg;
  arg = car(args);

  /* frexp doesn't work in edge cases.  Since the double and long long int fields are equivalenced
   *   in the s7_num struct, we can get the actual bits of the double from the int.  The problem with doing this
   *   is that bignums don't use that struct.  Assume IEEE 754 and double = s7_Double.
   */

  if ((!s7_is_real(arg)) ||
      (s7_is_rational(arg)))
    return(s7_wrong_type_arg_error(sc, "integer-decode-float", 0, arg, "a non-rational real"));

  if (s7_real(arg) == 0.0)
    return(list_3(sc, small_int(0), small_int(0), small_int(1)));

#if WITH_GMP
  if (is_c_object(arg)) 
    {
      s7_num_t num;
      real(num) = s7_number_to_real(arg);             /* need s7_num_t here for the equivalence */
      if ((isnan(real(num))) || (isinf(real(num))))   /* (integer-decode-float (bignum "1e310")) */
	return(s7_out_of_range_error(sc, "integer-decode-float", 0, arg, "a real that s7_Double can handle"));
      ix = integer(num);
    }
  else
#endif

  ix = integer(number(arg));
  return(list_3(sc,
		     s7_make_integer(sc, (s7_Int)((ix & 0xfffffffffffffLL) | 0x10000000000000LL)),
		     s7_make_integer(sc, (s7_Int)(((ix & 0x7fffffffffffffffLL) >> 52) - 1023 - 52)),
		     s7_make_integer(sc, ((ix & 0x8000000000000000LL) != 0) ? -1 : 1)));
}


static s7_pointer g_logior(s7_scheme *sc, s7_pointer args)
{
  #define H_logior "(logior int ...) returns the bitwise OR of its integer arguments (the bits that are on in any of the arguments)"
  s7_Int result = 0;
  int i; 
  s7_pointer x;

  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))
    if (!s7_is_integer(car(x)))
      return(s7_wrong_type_arg_error(sc, "logior", i, car(x), "an integer"));
    else result |= s7_integer(car(x));

  return(s7_make_integer(sc, result));
}


static s7_pointer g_logxor(s7_scheme *sc, s7_pointer args)
{
  #define H_logxor "(logxor int ...) returns the bitwise XOR of its integer arguments (the bits that are on in an odd number of the arguments)"
  s7_Int result = 0;
  int i;
  s7_pointer x;

  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))
    if (!s7_is_integer(car(x)))
      return(s7_wrong_type_arg_error(sc, "logxor", i, car(x), "an integer"));
    else result ^= s7_integer(car(x));

  return(s7_make_integer(sc, result));
}


static s7_pointer g_logand(s7_scheme *sc, s7_pointer args)
{
  #define H_logand "(logand int ...) returns the bitwise AND of its integer arguments (the bits that are on in every argument)"
  s7_Int result = -1;
  int i;
  s7_pointer x;

  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))
    if (!s7_is_integer(car(x)))
      return(s7_wrong_type_arg_error(sc, "logand", i, car(x), "an integer"));
    else result &= s7_integer(car(x));

  return(s7_make_integer(sc, result));
}


static s7_pointer g_lognot(s7_scheme *sc, s7_pointer args)
{
  #define H_lognot "(lognot num) returns the bitwise negation (the complement, the bits that are not on) in num: (lognot 0) -> -1"
  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "lognot", 0, car(args), "an integer"));
  return(s7_make_integer(sc, ~s7_integer(car(args))));
}


static s7_pointer g_ash(s7_scheme *sc, s7_pointer args)
{
  #define H_ash "(ash i1 i2) returns i1 shifted right or left i2 times, i1 << i2, (ash 1 3) -> 8, (ash 8 -3) -> 1"
  s7_Int arg1, arg2;

  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "ash", 1, car(args), "an integer"));
  if (!s7_is_integer(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "ash", 2, cadr(args), "an integer"));
  
  arg1 = s7_integer(car(args));
  if (arg1 == 0) return(small_int(0));

  arg2 = s7_integer(cadr(args));
  if (arg2 >= s7_int_bits)
    return(s7_out_of_range_error(sc, "ash", 2, cadr(args), "shift is too large"));
  if (arg2 < -s7_int_bits)
    {
      if (arg1 < 0)                      /* (ash -31 -100) */
	return(small_negative_ints[1]);
      return(small_int(0));
    }

  /* I can't see any point in protecting this:
   *    (ash 9223372036854775807 1) -> -2
   * but anyone using ash must know something about bits...
   */
  if (arg2 >= 0)
    return(s7_make_integer(sc, arg1 << arg2));
  return(s7_make_integer(sc, arg1 >> -arg2));
}


/* random numbers.  The simple version used in clm.c is probably adequate,
 *   but here I'll use Marsaglia's MWC algorithm as an experiment.
 *     (random num) -> a number (0..num), if num == 0 return 0, use global default state
 *     (random num state) -> same but use this state
 *     (make-random-state seed) -> make a new state
 *     (make-random-state seed type) ??
 *   to save the current seed, use copy
 *   to save it across load, random-state->list and list->random-state.
 */

typedef struct {
  unsigned long long int ran_seed, ran_carry;
} s7_rng_t;

static int rng_tag = 0;

#if WITH_GMP
static int big_rng_tag = 0;
#endif

static char *print_rng(s7_scheme *sc, void *val)
{
  char *buf;
  s7_rng_t *r = (s7_rng_t *)val;
  buf = (char *)malloc(64 * sizeof(char));
  snprintf(buf, 64, "#<rng %d %d>", (unsigned int)(r->ran_seed), (unsigned int)(r->ran_carry));
  return(buf);
}


static void free_rng(void *val)
{
  free(val);
}


static bool equal_rng(void *val1, void *val2)
{
  return(val1 == val2);
}


s7_pointer s7_make_random_state(s7_scheme *sc, s7_pointer args)
{
  #define H_make_random_state "(make-random-state seed) returns a new random number state initialized with 'seed'. \
Pass this as the second argument to 'random' to get a repeatable random number sequence:\n\
    (let ((seed (make-random-state 1234))) (random 1.0 seed))"

  s7_rng_t *r;

  if (!(s7_is_integer(car(args))))
    return(s7_wrong_type_arg_error(sc, "make-random-state,", 1, car(args), "an integer"));

  if (is_null(cdr(args)))
    {
      r = (s7_rng_t *)calloc(1, sizeof(s7_rng_t));
      r->ran_seed = s7_integer(car(args));
      r->ran_carry = 1675393560;  /* should this be dependent on the seed? */
      return(s7_make_object(sc, rng_tag, (void *)r));
    }

  if (!(s7_is_integer(cadr(args))))
    return(s7_wrong_type_arg_error(sc, "make-random-state,", 2, cadr(args), "an integer"));
  
  r = (s7_rng_t *)calloc(1, sizeof(s7_rng_t));
  r->ran_seed = s7_integer(car(args));
  r->ran_carry = s7_integer(cadr(args));
  return(s7_make_object(sc, rng_tag, (void *)r));
}


static s7_pointer copy_random_state(s7_scheme *sc, s7_pointer obj)
{
  if (object_type(obj) == rng_tag)
    {
      s7_rng_t *r, *new_r;
      r = (s7_rng_t *)s7_object_value(obj);
      new_r = (s7_rng_t *)calloc(1, sizeof(s7_rng_t));
      new_r->ran_seed = r->ran_seed;
      new_r->ran_carry = r->ran_carry;
      return(s7_make_object(sc, rng_tag, (void *)new_r));
    }
  /* I can't find a way to copy a gmp random generator */
  return(sc->F);
}


static double next_random(s7_rng_t *r)
{
  /* The multiply-with-carry generator for 32-bit integers: 
   *        x(n)=a*x(n-1) + carry mod 2^32 
   * Choose multiplier a from this list: 
   *   1791398085 1929682203 1683268614 1965537969 1675393560 
   *   1967773755 1517746329 1447497129 1655692410 1606218150 
   *   2051013963 1075433238 1557985959 1781943330 1893513180 
   *   1631296680 2131995753 2083801278 1873196400 1554115554 
   * ( or any 'a' for which both a*2^32-1 and a*2^31-1 are prime) 
   */
  double result;
  unsigned long long int temp;
  #define RAN_MULT 2131995753UL

  temp = r->ran_seed * RAN_MULT + r->ran_carry;
  r->ran_seed = (temp & 0xffffffffUL);
  r->ran_carry = (temp >> 32);
  result = (double)((unsigned int)(r->ran_seed)) / 4294967295.5;
  /* divisor was 2^32-1 = 4294967295.0, but somehow this can round up once in a billion tries? 
   *   do we want the double just less than 2^32?
   */

  /* (let ((mx 0) (mn 1000)) (do ((i 0 (+ i 1))) ((= i 10000)) (let ((val (random 123))) (set! mx (max mx val)) (set! mn (min mn val)))) (list mn mx)) */
  return(result);
}


static s7_rng_t *s7_default_rng(s7_scheme *sc)
{
  if (!sc->default_rng)
    {
      sc->default_rng = (s7_rng_t *)calloc(1, sizeof(s7_rng_t));
      ((s7_rng_t *)(sc->default_rng))->ran_seed = (unsigned int)time(NULL);
      ((s7_rng_t *)(sc->default_rng))->ran_carry = 1675393560;
    }
  return((s7_rng_t *)(sc->default_rng));
}


s7_pointer s7_random_state_to_list(s7_scheme *sc, s7_pointer args)
{
  #define H_random_state_to_list "(random-state->list r) returns the random state object as a list.\
You can later apply make-random-state to this list to continue a random number sequence from any point."

  s7_rng_t *r = NULL;
  s7_pointer obj;
  if (is_null(args))
    r = s7_default_rng(sc);
  else
    {
      obj = car(args);
      if ((!is_c_object(obj)) ||
	  (object_type(obj) != rng_tag))
	return(s7_wrong_type_arg_error(sc, "random-state->list,", 1, obj, "a random state as returned by make-random-state"));

	r = (s7_rng_t *)s7_object_value(obj);
    }
  
  if (r)
    return(list_2(sc, 
		       s7_make_integer(sc, r->ran_seed), 
		       s7_make_integer(sc, r->ran_carry)));
  return(sc->F);
}


void s7_set_default_random_state(s7_scheme *sc, s7_Int seed, s7_Int carry)
{
  sc->default_rng = (s7_rng_t *)calloc(1, sizeof(s7_rng_t));
  ((s7_rng_t *)(sc->default_rng))->ran_seed = (unsigned long long)seed;
  ((s7_rng_t *)(sc->default_rng))->ran_carry = (unsigned long long)carry;
}


s7_Double s7_random(s7_scheme *sc, s7_pointer state)
{
  if (!state)
    return(next_random(s7_default_rng(sc)));
  return(next_random((s7_rng_t *)s7_object_value(state)));
}


static s7_pointer g_random(s7_scheme *sc, s7_pointer args)
{
  #define H_random "(random num (state #f)) returns a random number between 0 and num (0 if num=0)."
  s7_pointer num, state;
  s7_rng_t *r;

  num = car(args);
  if (!s7_is_number(num))
    return(s7_wrong_type_arg_error(sc, "random bounds,", (is_null(cdr(args))) ? 0 : 1, num, "a number"));

  if (is_not_null(cdr(args)))
    {
      state = cadr(args);
      if (!is_c_object(state))
	return(s7_wrong_type_arg_error(sc, "random state,", 2, state, "a random state as returned by make-random-state"));

      if (object_type(state) == rng_tag)
	r = (s7_rng_t *)s7_object_value(state);
      else
	{
#if WITH_GMP
	  if (object_type(state) == big_rng_tag)
	    return(big_random(sc, args));
#endif
	  return(s7_wrong_type_arg_error(sc, "random state,", 2, state, "a random state as returned by make-random-state"));
	}
    }
  else r = s7_default_rng(sc);

  switch (number_type(num))
    {
    case NUM_INT:
      return(s7_make_integer(sc, (s7_Int)(s7_integer(num) * next_random(r))));

    case NUM_RATIO:
      {
	s7_Double x, error;
	s7_Int numer = 0, denom = 1;

	/* the error here needs to take the size of the fraction into account.  Otherwise, if
	 *    error is (say) 1e-6 and the fraction is (say) 9000000/9223372036854775807,
	 *    c_rationalize will always return 0.
	 */
	x = (s7_Double)s7_numerator(num) / (s7_Double)s7_denominator(num);

	error = 1e-6 * s7_Double_abs(x);
	if (error > 1e-6)
	  error = 1e-6;
	else
	  {
	    if (error < 1e-18)
	      error = 1e-18;
	  }
	c_rationalize(x * next_random(r), error, &numer, &denom);
	return(s7_make_ratio(sc, numer, denom));
      }

    case NUM_REAL:
    case NUM_REAL2:
      return(s7_make_real(sc, s7_real(num) * next_random(r)));

    default: 
      return(s7_make_complex(sc, complex_real_part(num) * next_random(r), complex_imag_part(num) * next_random(r)));
    }

  return(sc->F);
}




/* -------------------------------- characters -------------------------------- */

static s7_pointer g_char_to_integer(s7_scheme *sc, s7_pointer args)
{
  #define H_char_to_integer "(char->integer c) converts the character c to an integer"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char->integer", 0, car(args), "a character"));
  return(small_int(character(car(args))));
}


static s7_pointer g_integer_to_char(s7_scheme *sc, s7_pointer args)
{
  #define H_integer_to_char "(integer->char i) converts the non-negative integer i to a character"
  s7_pointer x;
  s7_Int ind;                   /* not int here!  (integer->char (expt 2 32)) -> #\null */
  x = car(args);

  if (!s7_is_integer(x))
    return(s7_wrong_type_arg_error(sc, "integer->char", 0, x, "an integer"));
  ind = s7_integer(x);
  if ((ind < 0) || (ind > 255))
    return(s7_wrong_type_arg_error(sc, "integer->char", 0, x, "an integer between 0 and 255"));

  return(s7_make_character(sc, (unsigned char)ind));
}


static s7_pointer g_char_upcase(s7_scheme *sc, s7_pointer args)
{
  #define H_char_upcase "(char-upcase c) converts the character c to upper case"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-upcase", 0, car(args), "a character"));
  return(s7_make_character(sc, (unsigned char)toupper(character(car(args)))));
}


static s7_pointer g_char_downcase(s7_scheme *sc, s7_pointer args)
{
  #define H_char_downcase "(char-downcase c) converts the character c to lower case"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-downcase", 0, car(args), "a character"));
  return(s7_make_character(sc, (unsigned char)tolower(character(car(args)))));
}


static s7_pointer g_is_char_alphabetic(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_alphabetic "(char-alphabetic? c) returns #t if the character c is alphabetic"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-alphabetic?", 0, car(args), "a character"));
  return(make_boolean(sc, isalpha(character(car(args)))));

  /* isalpha returns #t for (integer->char 226) and others in that range */
}


static s7_pointer g_is_char_numeric(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_numeric "(char-numeric? c) returns #t if the character c is a digit"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-numeric?", 0, car(args), "a character"));
  return(make_boolean(sc, isdigit(character(car(args)))));
}


static s7_pointer g_is_char_whitespace(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_whitespace "(char-whitespace? c) returns #t if the character c is non-printing character"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-whitespace?", 0, car(args), "a character"));
  return(make_boolean(sc, white_space[character(car(args))]));
}


static s7_pointer g_is_char_upper_case(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_upper_case "(char-upper-case? c) returns #t if the character c is in upper case"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-upper-case?", 0, car(args), "a character"));
  return(make_boolean(sc, isupper(character(car(args)))));
}


static s7_pointer g_is_char_lower_case(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_lower_case "(char-lower-case? c) returns #t if the character c is in lower case"
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-lower-case?", 0, car(args), "a character"));
  return(make_boolean(sc, islower(character(car(args)))));
}


static s7_pointer g_is_char(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char "(char? obj) returns #t if obj is a character"
  return(make_boolean(sc, s7_is_character(car(args))));
}


s7_pointer s7_make_character(s7_scheme *sc, unsigned int c) 
{
  return(chars[c]);
}


bool s7_is_character(s7_pointer p) 
{ 
  return(type(p) == T_CHARACTER);
}


char s7_character(s7_pointer p)  
{ 
  return(character(p));
}


static int charcmp(unsigned char c1, unsigned char c2, bool ci)
{
  if (ci)
    return(charcmp(toupper(c1), toupper(c2), false)); 
  /* not tolower here -- the single case is apparently supposed to be upper case
   *   this matters in a case like (char-ci<? #\_ #\e) which Guile and Gauche say is #f
   *   although (char<? #\_ #\e) is #t -- the spec does not say how to interpret this!
   */
  if (c1 == c2)
    return(0);
  if (c1 < c2)
    return(-1);
  return(1);
}


static s7_pointer g_char_cmp(s7_scheme *sc, s7_pointer args, int val, const char *name, bool ci)
{
  int i;
  s7_pointer x;
  unsigned char last_chr;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_character(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a character"));
  
  last_chr = character(car(args));
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (charcmp(last_chr, character(car(x)), ci) != val)
	return(sc->F);
      last_chr = character(car(x));
    }
  return(sc->T);
}


static s7_pointer g_char_cmp_not(s7_scheme *sc, s7_pointer args, int val, const char *name, bool ci)
{
  int i;
  s7_pointer x;
  unsigned char last_chr;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_character(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a character"));
  
  last_chr = character(car(args));
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (charcmp(last_chr, character(car(x)), ci) == val)
	return(sc->F);
      last_chr = character(car(x));
    }
  return(sc->T);
}


static s7_pointer g_chars_are_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_equal "(char=? char ...) returns #t if all the character arguments are equal"
  return(g_char_cmp(sc, args, 0, "char=?", false));
}	


static s7_pointer g_chars_are_less(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_less "(char<? char ...) returns #t if all the character arguments are increasing"
  return(g_char_cmp(sc, args, -1, "char<?", false));
}	


static s7_pointer g_chars_are_greater(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_greater "(char>? char ...) returns #t if all the character arguments are decreasing"
  return(g_char_cmp(sc, args, 1, "char>?", false));
}


static s7_pointer g_chars_are_geq(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_geq "(char>=? char ...) returns #t if all the character arguments are equal or decreasing"
  return(g_char_cmp_not(sc, args, -1, "char>=?", false));
}	


static s7_pointer g_chars_are_leq(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_leq "(char<=? char ...) returns #t if all the character arguments are equal or increasing"
  return(g_char_cmp_not(sc, args, 1, "char<=?", false));
}


#if WITH_OPTIMIZATION

static s7_pointer char_equal_s_ic, char_equal_2;
static s7_pointer g_char_equal_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char=?", 1, car(args), "a character"));
  return(make_boolean(sc, character(car(args)) == character(cadr(args))));
}

static s7_pointer g_char_equal_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, character(car(args)) == character(cadr(args))));
}


static s7_pointer char_less_s_ic, char_less_2;
static s7_pointer g_char_less_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char<?", 1, car(args), "a character"));
  return(make_boolean(sc, character(car(args)) < character(cadr(args))));
}

static s7_pointer g_char_less_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char<?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char<?", 2, cadr(args), "a character"));
  return(make_boolean(sc, character(car(args)) < character(cadr(args))));
}


static s7_pointer char_greater_s_ic, char_greater_2;
static s7_pointer g_char_greater_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char>?", 1, car(args), "a character"));
  return(make_boolean(sc, character(car(args)) > character(cadr(args))));
}

static s7_pointer g_char_greater_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char>?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char>?", 2, cadr(args), "a character"));
  return(make_boolean(sc, character(car(args)) > character(cadr(args))));
}


static s7_pointer char_geq_s_ic, char_geq_2;
static s7_pointer g_char_geq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char>=?", 1, car(args), "a character"));
  return(make_boolean(sc, character(car(args)) >= character(cadr(args))));
}

static s7_pointer g_char_geq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char>=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char>=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, character(car(args)) >= character(cadr(args))));
}


static s7_pointer char_leq_s_ic, char_leq_2;
static s7_pointer g_char_leq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char<=?", 1, car(args), "a character"));
  return(make_boolean(sc, character(car(args)) <= character(cadr(args))));
}

static s7_pointer g_char_leq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char<=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char<=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, character(car(args)) <= character(cadr(args))));
}
#endif



static s7_pointer g_chars_are_ci_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_ci_equal "(char-ci=? char ...) returns #t if all the character arguments are equal, ignoring case"
  return(g_char_cmp(sc, args, 0, "char-ci=?", true));
}


static s7_pointer g_chars_are_ci_less(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_ci_less "(char-ci<? char ...) returns #t if all the character arguments are increasing, ignoring case"
  return(g_char_cmp(sc, args, -1, "char-ci<?", true));
}	


static s7_pointer g_chars_are_ci_greater(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_ci_greater "(char-ci>? char ...) returns #t if all the character arguments are decreasing, ignoring case"
  return(g_char_cmp(sc, args, 1, "char-ci>?", true));
}	


static s7_pointer g_chars_are_ci_geq(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_ci_geq "(char-ci>=? char ...) returns #t if all the character arguments are equal or decreasing, ignoring case"
  return(g_char_cmp_not(sc, args, -1, "char-ci>=?", true));
}


static s7_pointer g_chars_are_ci_leq(s7_scheme *sc, s7_pointer args)
{
  #define H_chars_are_ci_leq "(char-ci<=? char ...) returns #t if all the character arguments are equal or increasing, ignoring case"
  return(g_char_cmp_not(sc, args, 1, "char-ci<=?", true));
}


#if WITH_OPTIMIZATION

static s7_pointer char_ci_equal_s_ic, char_ci_equal_2;
static s7_pointer g_char_ci_equal_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci=?", 1, car(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) == toupper(character(cadr(args)))));
}

static s7_pointer g_char_ci_equal_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) == toupper(character(cadr(args)))));
}


static s7_pointer char_ci_less_s_ic, char_ci_less_2;
static s7_pointer g_char_ci_less_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<?", 1, car(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) < toupper(character(cadr(args)))));
}

static s7_pointer g_char_ci_less_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<?", 2, cadr(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) < toupper(character(cadr(args)))));
}


static s7_pointer char_ci_greater_s_ic, char_ci_greater_2;
static s7_pointer g_char_ci_greater_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>?", 1, car(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) > toupper(character(cadr(args)))));
}

static s7_pointer g_char_ci_greater_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>?", 2, cadr(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) > toupper(character(cadr(args)))));
}


static s7_pointer char_ci_geq_s_ic, char_ci_geq_2;
static s7_pointer g_char_ci_geq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>=?", 1, car(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) >= toupper(character(cadr(args)))));
}

static s7_pointer g_char_ci_geq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci>=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) >= toupper(character(cadr(args)))));
}


static s7_pointer char_ci_leq_s_ic, char_ci_leq_2;
static s7_pointer g_char_ci_leq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<=?", 1, car(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) <= toupper(character(cadr(args)))));
}

static s7_pointer g_char_ci_leq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<=?", 1, car(args), "a character"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "char-ci<=?", 2, cadr(args), "a character"));
  return(make_boolean(sc, toupper(character(car(args))) <= toupper(character(cadr(args)))));
}
#endif



/* -------------------------------- strings -------------------------------- */


s7_pointer s7_make_string_with_length(s7_scheme *sc, const char *str, int len) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_STRING | T_DONT_COPY | T_SAFE_PROCEDURE); /* should this follow the malloc? */
  string_value(x) = (char *)malloc((len + 1) * sizeof(char)); 
  if (len != 0)                                             /* memcpy can segfault if string_value(x) is NULL */
    memcpy((void *)string_value(x), (void *)str, len + 1);
  else string_value(x)[0] = 0;
  string_length(x) = len;
  string_hash(x) = 0;
  add_string(sc, x);
  return(x);
}


static s7_pointer s7_make_terminated_string_with_length(s7_scheme *sc, const char *str, int len) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_STRING | T_DONT_COPY | T_SAFE_PROCEDURE); /* should this follow the malloc? */
  string_value(x) = (char *)malloc((len + 1) * sizeof(char)); 
  if (len != 0)                                             /* memcpy can segfault if string_value(x) is NULL */
    memcpy((void *)string_value(x), (void *)str, len);
  string_value(x)[len] = 0;
  string_length(x) = len;
  string_hash(x) = 0;
  add_string(sc, x);
  return(x);
}


static s7_pointer make_string_uncopied_with_length(s7_scheme *sc, char *str, int len) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_STRING | T_DONT_COPY | T_SAFE_PROCEDURE);
  string_value(x) = str;
  string_length(x) = len;
  string_hash(x) = 0;
  add_string(sc, x);
  return(x);
}


static s7_pointer make_protected_string(s7_scheme *sc, const char *str)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_STRING | T_IMMUTABLE | T_DONT_COPY | T_SAFE_PROCEDURE);
  string_value(x) = (char *)str;
  string_length(x) = safe_strlen(str);
  string_hash(x) = 0;
  return(x);
}


static s7_pointer make_empty_string(s7_scheme *sc, int len, char fill) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_STRING | T_DONT_COPY);
  
  if (fill == 0)
    string_value(x) = (char *)calloc((len + 1), sizeof(char));
  else
    {
      string_value(x) = (char *)malloc((len + 1) * sizeof(char));
      memset((void *)(string_value(x)), fill, len);
    }
  string_value(x)[len] = 0;
  string_hash(x) = 0;
  string_length(x) = len;
  add_string(sc, x);
  return(x);
}


s7_pointer s7_make_string(s7_scheme *sc, const char *str) 
{
  return(s7_make_string_with_length(sc, str, safe_strlen(str)));
}


static s7_pointer make_string_uncopied(s7_scheme *sc, char *str) 
{
  return(make_string_uncopied_with_length(sc, str, safe_strlen(str)));
}


static char *make_permanent_string(const char *str)
{
  char *x;
  int len;
  len = safe_strlen(str);
  x = (char *)permanent_calloc((len + 1) * sizeof(char)); 
  memcpy((void *)x, (void *)str, len);
  return(x);
}


s7_pointer s7_make_permanent_string(const char *str) 
{
  /* for the symbol table which is never GC'd */
  s7_pointer x;
  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;
  set_type(x, T_STRING | T_IMMUTABLE | T_DONT_COPY);
  if (str)
    {
      string_length(x) = safe_strlen(str);
      string_value(x) = (char *)permanent_calloc((string_length(x) + 1) * sizeof(char)); 
      memcpy((void *)string_value(x), (void *)str, string_length(x)); 
    }
  else 
    {
      string_value(x) = NULL;
      string_length(x) = 0;
    }
  string_hash(x) = 0;
  return(x);
}


bool s7_is_string(s7_pointer p)
{
  return((type(p) == T_STRING)); 
}


const char *s7_string(s7_pointer p) 
{ 
  return(string_value(p));
}


static s7_pointer g_is_string(s7_scheme *sc, s7_pointer args)
{
  #define H_is_string "(string? obj) returns #t if obj is a string"
  return(make_boolean(sc, s7_is_string(car(args))));
}


#define MAX_STRING_LENGTH 1073741824

static s7_pointer g_make_string(s7_scheme *sc, s7_pointer args)
{
  #define H_make_string "(make-string len (val #\\space)) makes a string of length len filled with the character val (default: space)"
  s7_Int len;
  char fill = ' ';
  
  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-string length,", (is_null(cdr(args))) ? 0 : 1, car(args), "an integer"));
  
  len = s7_integer(car(args));
  if (len < 0)
    return(s7_out_of_range_error(sc, "make-string length,", (is_null(cdr(args))) ? 0 : 1, car(args), "a non-negative integer"));
  if (len > MAX_STRING_LENGTH)
    return(s7_out_of_range_error(sc, "make-string length,", (is_null(cdr(args))) ? 0 : 1, car(args), "a reasonable integer!"));

  if (is_not_null(cdr(args))) 
    {
      if (!s7_is_character(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "make-string filler,", 2, cadr(args), "a character"));
      fill = s7_character(cadr(args));
    }
  return(make_empty_string(sc, (int)len, fill));
}


static s7_pointer g_string_length(s7_scheme *sc, s7_pointer args)
{
  #define H_string_length "(string-length str) returns the length of the string str"
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-length", 0, car(args), "string"));
  return(s7_make_integer(sc, string_length(car(args))));
}


static s7_pointer string_ref_1(s7_scheme *sc, s7_pointer strng, s7_pointer index)
{
  char *str;
  s7_Int ind;

  if (!s7_is_integer(index))
    return(s7_wrong_type_arg_error(sc, "string-ref", 2, index, "an integer"));

  ind = s7_integer(index);

  if (ind < 0)
    return(s7_wrong_type_arg_error(sc, "string-ref index,", 2, index, "a non-negative integer"));
  if (ind >= string_length(strng))
    return(s7_out_of_range_error(sc, "string-ref index,", 2, index, "should be less than string length"));

  str = string_value(strng);
  return(s7_make_character(sc, ((unsigned char *)str)[ind]));
}


static s7_pointer g_string_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_string_ref "(string-ref str index) returns the character at the index-th element of the string str"
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ref", 1, car(args), "a string"));

  return(string_ref_1(sc, car(args), cadr(args)));
}


static s7_pointer g_string_set(s7_scheme *sc, s7_pointer args)
{
  #define H_string_set "(string-set! str index chr) sets the index-th element of the string str to the character chr"
  
  s7_pointer x, index;
  char *str;
  s7_Int ind;

  x = car(args);
  index = cadr(args);
  
  if (!s7_is_string(x))
    return(s7_wrong_type_arg_error(sc, "string-set!", 1, x, "a string"));
  if (!s7_is_character(caddr(args)))
    return(s7_wrong_type_arg_error(sc, "string-set!", 3, caddr(args), "a character"));
  if (!s7_is_integer(index))
    return(s7_wrong_type_arg_error(sc, "string-set! index,", 2, index, "an integer"));
  
  ind = s7_integer(index);

  if (ind < 0)
    return(s7_wrong_type_arg_error(sc, "string-set! index,", 2, index, "a non-negative integer"));
  if (ind >= string_length(x))
    return(s7_out_of_range_error(sc, "string-set! index,", 2, index, "should be less than string length"));

  str = string_value(x);
  str[ind] = (char)s7_character(caddr(args));
  return(caddr(args));
}


static s7_pointer g_string_append_1(s7_scheme *sc, s7_pointer args, const char *name)
{
  int i, len = 0;
  s7_pointer x, newstr;
  char *pos;
  
  if (is_null(args))
    return(s7_make_string_with_length(sc, "", 0));
  
  /* get length for new string */
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x)) 
    {
      if (!s7_is_string(car(x)))
	return(s7_wrong_type_arg_error(sc, name, i, car(x), "a string"));
      len += string_length(car(x));
    }
  
  /* store the contents of the argument strings into the new string */
  newstr = make_empty_string(sc, len + 1, 0); /* +1 here because valgrind (but only in FC15) thinks we occasionally go one past the end */
  string_length(newstr) = len;
  for (pos = string_value(newstr), x = args; is_not_null(x); pos += string_length(car(x)), x = cdr(x)) 
    memcpy(pos, string_value(car(x)), string_length(car(x)));
  
  return(newstr);
}


static s7_pointer g_string_append(s7_scheme *sc, s7_pointer args)
{
  #define H_string_append "(string-append str1 ...) appends all its string arguments into one string"
  return(g_string_append_1(sc, args, "string-append"));
}


static s7_pointer g_string_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_string_copy "(string-copy str) returns a copy of its string argument"
  if (is_null(args))
    return(s7_wrong_type_arg_error(sc, "string-copy", 0, car(args), "a string"));
  
  return(g_string_append_1(sc, args, "string-copy"));
}


static s7_pointer g_substring(s7_scheme *sc, s7_pointer args)
{
  #define H_substring "(substring str start (end (length str))) returns the portion of the string str between start and \
end: (substring \"01234\" 1 2) -> \"1\""
  
  s7_pointer x, start, end, str;
  s7_Int i0, i1;
  int len;
  char *s;
  
  str = car(args);
  start = cadr(args);
  
  if (!s7_is_string(str))
    return(s7_wrong_type_arg_error(sc, "substring", 1, str, "a string"));
  
  if (!s7_is_integer(start))
    return(s7_wrong_type_arg_error(sc, "substring start point,", 2, start, "an integer"));
  i0 = s7_integer(start);
  if (i0 < 0)
    return(s7_wrong_type_arg_error(sc, "substring start point,", 2, start, "a non-negative integer"));
  if (i0 > string_length(str))            /* (substring "012" 10) */
    return(s7_out_of_range_error(sc, "substring start point,", 2, start, "start <= string length"));
  /* this is how guile handles it: (substring "012" 3) -> "" */

  if (is_not_null(cddr(args)))
    {
      end = caddr(args);
      if (!s7_is_integer(end))
	return(s7_wrong_type_arg_error(sc, "substring end point,", 3, end, "an integer"));
      i1 = s7_integer(end);
      if (i1 < i0)
	return(s7_wrong_type_arg_error(sc, "substring end point,", 3, end, "an integer >= start"));
      if (i1 > string_length(str))
	return(s7_out_of_range_error(sc, "substring end point,", 3, end, "end <= string length"));
    }
  else i1 = string_length(str);
  
  s = string_value(str);
  len = i1 - i0;
  x = make_empty_string(sc, len, 0);
  memcpy(string_value(x), s + i0, len);
  string_value(x)[len] = 0;
  return(x);
}

/* (set! (substring...) ...)? -- might require allocation
 */


#define USE_WRITE true
#define USE_DISPLAY false

static s7_pointer g_object_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_object_to_string "(object->string obj (write true)) returns a string representation of obj."
  
  if (is_not_null(cdr(args)))
    {
      if (s7_is_boolean(cadr(args)))
	return(s7_object_to_string(sc, car(args), s7_boolean(sc, cadr(args))));
      return(s7_wrong_type_arg_error(sc, "object->string", 2, cadr(args), "a boolean"));
    }
  return(s7_object_to_string(sc, car(args), USE_WRITE));
}


static int scheme_strcmp(s7_pointer s1, s7_pointer s2)
{
  /* tricky here because str[i] must be treated as unsigned
   *   (string<? (string (integer->char #xf0)) (string (integer->char #x70)))
   */
  int i, len, len1, len2;
  char *str1, *str2;

  len1 = string_length(s1);
  len2 = string_length(s2);
  if (len1 > len2)
    len = len2;
  else len = len1;

  str1 = string_value(s1);
  str2 = string_value(s2);

  for (i = 0; i < len; i++)
    if ((unsigned char)(str1[i]) < (unsigned char )(str2[i]))
      return(-1);
    else
      {
	if ((unsigned char)(str1[i]) > (unsigned char)(str2[i]))
	  return(1);
      }

  if (len1 < len2) 
    return(-1);
  if (len1 > len2)
    return(1);
  return(0);
}


static s7_pointer g_string_cmp(s7_scheme *sc, s7_pointer args, int val, const char *name)
{
  int i;
  s7_pointer x, y;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_string(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a string"));
  
  y = car(args);
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (scheme_strcmp(y, car(x)) != val)
	return(sc->F);
      y = car(x);
    }
  return(sc->T);
}


static s7_pointer g_string_cmp_not(s7_scheme *sc, s7_pointer args, int val, const char *name)
{
  int i;
  s7_pointer x, y;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_string(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a string"));
  
  y = car(args);
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (scheme_strcmp(y, car(x)) == val)
	return(sc->F);
      y = car(x);
    }
  return(sc->T);
}


static s7_pointer g_strings_are_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_equal "(string=? str ...) returns #t if all the string arguments are equal"

  /* C-based check stops at null, but we can have embedded nulls.  We can't
   *   just look at string-length because we need to check past the nulls.
   *   (let ((s1 "1234") (s2 "1245")) (string-set! s1 1 #\null) (string-set! s2 1 #\null) (string=? s1 s2))
   * hence scheme_strcmp above.
   */
  return(g_string_cmp(sc, args, 0, "string=?"));
}	


static s7_pointer g_strings_are_less(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_less "(string<? str ...) returns #t if all the string arguments are increasing"
  return(g_string_cmp(sc, args, -1, "string<?"));
}	


static s7_pointer g_strings_are_greater(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_greater "(string>? str ...) returns #t if all the string arguments are decreasing"
  return(g_string_cmp(sc, args, 1, "string>?"));
}	


static s7_pointer g_strings_are_geq(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_geq "(string>=? str ...) returns #t if all the string arguments are equal or decreasing"
  return(g_string_cmp_not(sc, args, -1, "string>=?"));
}	


static s7_pointer g_strings_are_leq(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_leq "(string<=? str ...) returns #t if all the string arguments are equal or increasing"
  return(g_string_cmp_not(sc, args, 1, "string<=?"));
}	

#if WITH_OPTIMIZATION

static s7_pointer string_equal_s_ic, string_equal_2;
static s7_pointer g_string_equal_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == 0));
}

static s7_pointer g_string_equal_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == 0));
}


static s7_pointer string_less_s_ic, string_less_2;
static s7_pointer g_string_less_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string<?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == -1));
}

static s7_pointer g_string_less_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string<?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string<?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == -1));
}


static s7_pointer string_greater_s_ic, string_greater_2;
static s7_pointer g_string_greater_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string>?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == 1));
}

static s7_pointer g_string_greater_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string>?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string>?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) == 1));
}


static s7_pointer string_geq_s_ic, string_geq_2;
static s7_pointer g_string_geq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string>=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) != -1));
}

static s7_pointer g_string_geq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string>=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string>=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) != -1));
}


static s7_pointer string_leq_s_ic, string_leq_2;
static s7_pointer g_string_leq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string<=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) != 1));
}

static s7_pointer g_string_leq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string<=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string<=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcmp(car(args), cadr(args)) != 1));
}
#endif


static int scheme_strcasecmp(s7_pointer s1, s7_pointer s2)
{
  /* same as scheme_strcmp -- watch out for unwanted sign! */
  int i, len, len1, len2;
  char *str1, *str2;

  len1 = string_length(s1);
  len2 = string_length(s2);
  if (len1 > len2)
    len = len2;
  else len = len1;

  str1 = string_value(s1);
  str2 = string_value(s2);

  for (i = 0; i < len; i++)
    if (toupper((unsigned char)(str1[i])) < toupper((unsigned char)(str2[i])))
      return(-1);
    else
      {
	if (toupper((unsigned char)(str1[i])) > toupper((unsigned char)(str2[i])))
	  return(1);
      }

  if (len1 < len2) 
    return(-1);
  if (len1 > len2)
    return(1);
  return(0);
}


static s7_pointer g_string_ci_cmp(s7_scheme *sc, s7_pointer args, int val, const char *name)
{
  int i;
  s7_pointer x, y;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_string(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a string"));
  
  y = car(args);
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (scheme_strcasecmp(y, car(x)) != val)
	return(sc->F);
      y = car(x);
    }
  return(sc->T);
}


static s7_pointer g_string_ci_cmp_not(s7_scheme *sc, s7_pointer args, int val, const char *name)
{
  int i;
  s7_pointer x, y;
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x))  
    if (!s7_is_string(car(x)))
      return(s7_wrong_type_arg_error(sc, name, i, car(x), "a string"));
  
  y = car(args);
  for (x = cdr(args); is_not_null(x); x = cdr(x))
    {
      if (scheme_strcasecmp(y, car(x)) == val)
	return(sc->F);
      y = car(x);
    }
  return(sc->T);
}


static s7_pointer g_strings_are_ci_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_ci_equal "(string-ci=? str ...) returns #t if all the string arguments are equal, ignoring case"
  return(g_string_ci_cmp(sc, args, 0, "string-ci=?"));
}	


static s7_pointer g_strings_are_ci_less(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_ci_less "(string-ci<? str ...) returns #t if all the string arguments are increasing, ignoring case"
  return(g_string_ci_cmp(sc, args, -1, "string-ci<?"));
}	


static s7_pointer g_strings_are_ci_greater(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_ci_greater "(string-ci>? str ...) returns #t if all the string arguments are decreasing, ignoring case"
  return(g_string_ci_cmp(sc, args, 1, "string-ci>?"));
}	


static s7_pointer g_strings_are_ci_geq(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_ci_geq "(string-ci>=? str ...) returns #t if all the string arguments are equal or decreasing, ignoring case"
  return(g_string_ci_cmp_not(sc, args, -1, "string-ci>=?"));
}	


static s7_pointer g_strings_are_ci_leq(s7_scheme *sc, s7_pointer args)
{
  #define H_strings_are_ci_leq "(string-ci<=? str ...) returns #t if all the string arguments are equal or increasing, ignoring case"
  return(g_string_ci_cmp_not(sc, args, 1, "string-ci<=?"));
}	


#if WITH_OPTIMIZATION

static s7_pointer string_ci_equal_s_ic, string_ci_equal_2;
static s7_pointer g_string_ci_equal_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == 0));
}

static s7_pointer g_string_ci_equal_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == 0));
}


static s7_pointer string_ci_less_s_ic, string_ci_less_2;
static s7_pointer g_string_ci_less_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == -1));
}

static s7_pointer g_string_ci_less_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == -1));
}


static s7_pointer string_ci_greater_s_ic, string_ci_greater_2;
static s7_pointer g_string_ci_greater_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == 1));
}

static s7_pointer g_string_ci_greater_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) == 1));
}


static s7_pointer string_ci_geq_s_ic, string_ci_geq_2;
static s7_pointer g_string_ci_geq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) != -1));
}

static s7_pointer g_string_ci_geq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci>=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) != -1));
}


static s7_pointer string_ci_leq_s_ic, string_ci_leq_2;
static s7_pointer g_string_ci_leq_s_ic(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<=?", 1, car(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) != 1));
}

static s7_pointer g_string_ci_leq_2(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<=?", 1, car(args), "a string"));
  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-ci<=?", 2, cadr(args), "a string"));
  return(make_boolean(sc, scheme_strcasecmp(car(args), cadr(args)) != 1));
}
#endif



static s7_pointer g_string_fill(s7_scheme *sc, s7_pointer args)
{
  #define H_string_fill "(string-fill! str chr) fills the string str with the character chr"
  s7_pointer x;
  x = car(args);

  if (!s7_is_string(x))
    return(s7_wrong_type_arg_error(sc, "string-fill!", 1, x, "a string"));
  if (!s7_is_character(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "string-fill! filler,", 2, cadr(args), "a character"));

  /* strlen and so on here is probably not right -- a scheme string has a length
   *   set when it is created, and (apparently) can contain an embedded 0, so its
   *   print length is not its length.
   *         char *str; char c; str = string_value(car(args)); c = character(cadr(args));
   *         int i, len = 0; if (str) len = safe_strlen(str); if (len > 0) for (i = 0; i < len; i++) str[i] = c; 
   */
  if (string_length(x) > 0)
    memset((void *)(string_value(x)), (int)character(cadr(args)), string_length(x));
  return(cadr(args)); 
}


static s7_pointer g_string_1(s7_scheme *sc, s7_pointer args, const char *name)
{
  int i, len;
  s7_pointer x, newstr;
  
  /* get length for new string and check arg types */
  for (len = 0, x = args; is_not_null(x); len++, x = cdr(x)) 
    if (!s7_is_character(car(x)))
      return(s7_wrong_type_arg_error(sc, name, len + 1, car(x), "a character"));
  
  newstr = make_empty_string(sc, len, 0);
  for (i = 0, x = args; is_not_null(x); i++, x = cdr(x)) 
    string_value(newstr)[i] = character(car(x));
  
  return(newstr);
}


static s7_pointer g_string(s7_scheme *sc, s7_pointer args)
{
  #define H_string "(string chr...) appends all its character arguments into one string"
  if (is_null(args))                                /* (string) but not (string '()) */
    return(s7_make_string_with_length(sc, "", 0));
  return(g_string_1(sc, args, "string"));
}


static s7_pointer g_list_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_list_to_string "(list->string lst) appends all the list's characters into one string; (apply string lst)"
  if (is_null(car(args)))
    return(s7_make_string_with_length(sc, "", 0));
  
  if (!is_proper_list(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "list->string", 0, car(args), "a (proper, non-circular) list of characters"));
  
  return(g_string_1(sc, car(args), "list->string"));
}


static s7_pointer s7_string_to_list(s7_scheme *sc, const char *str, int len)
{
  int i;
  s7_pointer p;

  if (len == 0)
    return(sc->NIL);

  if (len < (sc->free_heap_top - sc->free_heap))
    {
      sc->w = s7_cons (sc, s7_make_character(sc, ((unsigned char)str[0])), sc->NIL);
      for (i = 1; i < len; i++)
	sc->w = cons_unchecked(sc, s7_make_character(sc, ((unsigned char)str[i])), sc->w);
    }
  else
    {
      sc->w = sc->NIL;
      for (i = 0; i < len; i++)
	sc->w = cons(sc, s7_make_character(sc, ((unsigned char)str[i])), sc->w);
    }
  p = sc->w;
  sc->w = sc->NIL;

  return(safe_reverse_in_place(sc, p));
}


static s7_pointer g_string_to_list(s7_scheme *sc, s7_pointer args)
{
  #define H_string_to_list "(string->list str) returns the elements of the string str in a list; (map values str)"
  s7_pointer str;

  str = car(args);
  if (!s7_is_string(str))
    return(s7_wrong_type_arg_error(sc, "string->list", 0, str, "a string"));

  return(s7_string_to_list(sc, string_value(str), string_length(str)));
}




/* -------------------------------- ports -------------------------------- 
 *
 * originally nil served as stdin and friends, but that made it impossible to catch an error
 *   like (read-line (current-output-port)) when the latter was stdout.  So we now have
 *   the built-in constant ports *stdin*, *stdout*, and *stderr*.  Some way is needed to
 *   refer to these directly so that (read-line *stdin*) for example can insist on reading
 *   from the terminal, or whatever stdin is.
 */

static char *describe_port(s7_scheme *sc, s7_pointer p)
{
  char *desc;
  if ((p == sc->standard_input) || (p == sc->standard_output) || (p == sc->standard_error))
    return(copy_string(port_filename(p)));

  desc = (char *)malloc(64 * sizeof(char));
  snprintf(desc, 64, "<port%s%s%s>",
  	   (is_file_port(p)) ? " file" : ((is_string_port(p)) ? " string" : " function"),
	   (is_input_port(p)) ? " input" : " output",
	   (port_is_closed(p)) ? " (closed)" : "");
  return(desc);
}


static s7_pointer g_is_port_closed(s7_scheme *sc, s7_pointer args)
{
  #define H_is_port_closed "(port-closed? p) returns #t if the port p is closed."
  s7_pointer x;

  x = car(args);
  if ((is_input_port(x)) || (is_output_port(x)))
    return(make_boolean(sc, port_is_closed(x)));

  return(s7_wrong_type_arg_error(sc, "port-closed?", 0, x, "a port"));      
}


static s7_pointer g_port_line_number(s7_scheme *sc, s7_pointer args)
{
  #define H_port_line_number "(port-line-number input-file-port) returns the current read line number of port"
  s7_pointer x;

  if (is_null(args))
    x = sc->input_port;
  else x = car(args);

  if ((!(is_input_port(x))) ||
      (port_is_closed(x)))
    return(s7_wrong_type_arg_error(sc, "port-line-number", 0, x, "an open input port"));

  return(s7_make_integer(sc, port_line_number(x)));
}


const char *s7_port_filename(s7_pointer x)
{
  if (((is_input_port(x)) || 
       (is_output_port(x))) &&
      (!port_is_closed(x)))
    return(port_filename(x));
  return(NULL);
}


static s7_pointer g_port_filename(s7_scheme *sc, s7_pointer args)
{
  #define H_port_filename "(port-filename file-port) returns the filename associated with port"
  s7_pointer x;

  if (is_null(args))
    x = sc->input_port;
  else x = car(args);

  if (((is_input_port(x)) ||
       (is_output_port(x))) &&
      (!port_is_closed(x)))
    {
      if (port_filename(x))
	return(make_protected_string(sc, port_filename(x)));
      return(s7_make_string_with_length(sc, "", 0));   
      /* otherwise (eval-string (port-filename)) and (string->symbol (port-filename)) segfault */
    }

  return(s7_wrong_type_arg_error(sc, "port-filename", 0, x, "an open port"));
}


bool s7_is_input_port(s7_scheme *sc, s7_pointer p)   
{ 
  return(is_input_port(p));
}


static s7_pointer g_is_input_port(s7_scheme *sc, s7_pointer args)
{
  #define H_is_input_port "(input-port? p) returns #t if p is an input port"
  return(make_boolean(sc, is_input_port(car(args))));
}


bool s7_is_output_port(s7_scheme *sc, s7_pointer p)     
{ 
  return(is_output_port(p));
}


static s7_pointer g_is_output_port(s7_scheme *sc, s7_pointer args)
{
  #define H_is_output_port "(output-port? p) returns #t if p is an output port"
  return(make_boolean(sc, is_output_port(car(args))));
}


s7_pointer s7_current_input_port(s7_scheme *sc)
{
  return(sc->input_port);
}


static s7_pointer g_current_input_port(s7_scheme *sc, s7_pointer args)
{
  #define H_current_input_port "(current-input-port) returns the current input port"
  return(sc->input_port);
}


static s7_pointer g_set_current_input_port(s7_scheme *sc, s7_pointer args)
{
  #define H_set_current_input_port "(set-current-input-port port) sets the current-input port to port and returns the previous value of the input port"
  s7_pointer old_port, port;

  old_port = sc->input_port;
  port = car(args);
  if ((is_input_port(port)) &&
      (!port_is_closed(port)))
    sc->input_port = port;
  else return(s7_wrong_type_arg_error(sc, "set-current-input-port", 0, port, "an open input port"));
  sc->input_is_file = (is_file_port(sc->input_port));

  return(old_port);
}


s7_pointer s7_set_current_input_port(s7_scheme *sc, s7_pointer port)
{
  s7_pointer old_port;
  old_port = sc->input_port;
  sc->input_port = port;
  sc->input_is_file = (is_file_port(sc->input_port));
  return(old_port);
}


s7_pointer s7_current_output_port(s7_scheme *sc)
{
  return(sc->output_port);
}


s7_pointer s7_set_current_output_port(s7_scheme *sc, s7_pointer port)
{
  s7_pointer old_port;
  old_port = sc->output_port;
  sc->output_port = port;
  return(old_port);
}


static s7_pointer g_current_output_port(s7_scheme *sc, s7_pointer args)
{
  #define H_current_output_port "(current-output-port) returns the current output port"
  return(sc->output_port);
}


static s7_pointer g_set_current_output_port(s7_scheme *sc, s7_pointer args)
{
  #define H_set_current_output_port "(set-current-output-port port) sets the current-output port to port and returns the previous value of the output port"
  s7_pointer old_port, port;

  old_port = sc->output_port;
  port = car(args);
  if ((is_output_port(port)) &&
      (!port_is_closed(port)))
    sc->output_port = port;
  else return(s7_wrong_type_arg_error(sc, "set-current-output-port", 0, port, "an open output port"));

  return(old_port);
}


s7_pointer s7_current_error_port(s7_scheme *sc)
{
  return(sc->error_port);
}


s7_pointer s7_set_current_error_port(s7_scheme *sc, s7_pointer port)
{
  s7_pointer old_port;
  old_port = sc->error_port;
  sc->error_port = port;
  return(old_port);
}


static s7_pointer g_current_error_port(s7_scheme *sc, s7_pointer args)
{
  #define H_current_error_port "(current-error-port) returns the current error port"
  return(sc->error_port);
}


static s7_pointer g_set_current_error_port(s7_scheme *sc, s7_pointer args)
{
  #define H_set_current_error_port "(set-current-error-port port) sets the current-error port to port and returns the previous value of the error port"
  s7_pointer old_port, port;

  old_port = sc->error_port;
  port = car(args);
  if ((is_output_port(port)) &&
      (!port_is_closed(port)))
    sc->error_port = port;
  else return(s7_wrong_type_arg_error(sc, "set-current-error-port", 0, port, "an open output port"));

  return(old_port);
}


static s7_pointer g_is_char_ready(s7_scheme *sc, s7_pointer args)
{
  #define H_is_char_ready "(char-ready? (port (current-input-port))) returns #t if a character is ready for input on the given port"
  if (is_not_null(args))
    {
      s7_pointer pt = car(args);
      if (!is_input_port(pt))
	return(s7_wrong_type_arg_error(sc, "char-ready?", 0, pt, "an input port"));
      if (port_is_closed(pt))
	return(s7_wrong_type_arg_error(sc, "char-ready?", 0, pt, "an open input port"));

      if (is_function_port(pt))
	return((*(port_input_function(pt)))(sc, S7_IS_CHAR_READY, pt));
      return(make_boolean(sc, is_string_port(pt)));
    }
  return(make_boolean(sc, (is_input_port(sc->input_port)) && (is_string_port(sc->input_port))));
}      


static s7_pointer g_is_eof_object(s7_scheme *sc, s7_pointer args)
{
  #define H_is_eof_object "(eof-object? val) returns #t if val is the end-of-file object"
  return(make_boolean(sc, car(args) == sc->EOF_OBJECT));
}


void s7_close_input_port(s7_scheme *sc, s7_pointer p)
{
  if ((is_immutable(p)) ||
      ((is_input_port(p)) && (port_is_closed(p))))
    return;

  if (port_filename(p))
    {
      free(port_filename(p));
      port_filename(p) = NULL;
    }
  
  if ((is_file_port(p)) &&
      (port_file(p)))
    {
      fclose(port_file(p));
      port_file(p) = NULL;
    }

  if (port_needs_free(p))
    {
      if (port_string(p))
	{
	  free(port_string(p));
	  port_string(p) = NULL;
	}
      port_needs_free(p) = false;
    }

  /* if input string, someone else is dealing with GC */
  port_is_closed(p) = true;
}


static s7_pointer g_close_input_port(s7_scheme *sc, s7_pointer args)
{
  #define H_close_input_port "(close-input-port port) closes the port"
  s7_pointer pt;
  pt = car(args);
  if (!is_input_port(pt))
    return(s7_wrong_type_arg_error(sc, "close-input-port", 0, pt, "an input port"));
  if (!is_immutable(pt))
    s7_close_input_port(sc, pt);
  return(sc->UNSPECIFIED);
}


void s7_close_output_port(s7_scheme *sc, s7_pointer p)
{
  if ((is_immutable(p)) ||
      ((is_output_port(p)) && (port_is_closed(p))))
    return;
  
  if (port_filename(p))
    {
      free(port_filename(p));
      port_filename(p) = NULL;
    }
  
  if (is_file_port(p))
    {
      if (port_file(p))
	{
	  fflush(port_file(p));
	  fclose(port_file(p));
	  port_file(p) = NULL;
	}
    }
  else
    {
      if ((is_string_port(p)) && (port_string(p)))
	{
	  free(port_string(p));
	  port_string(p) = NULL;
	  port_needs_free(p) = false;
	}
    }
  port_is_closed(p) = true;
}


static s7_pointer g_close_output_port(s7_scheme *sc, s7_pointer args)
{
  #define H_close_output_port "(close-output-port port) closes the port"
  s7_pointer pt;
  pt = car(args);
  if (!is_output_port(pt))
    return(s7_wrong_type_arg_error(sc, "close-output-port", 0, pt, "an output port"));
  if (!(is_immutable(pt)))
    s7_close_output_port(sc, pt);
  return(sc->UNSPECIFIED);
}


static s7_pointer read_file(s7_scheme *sc, FILE *fp, const char *name, long max_size, const char *caller)
{
  s7_pointer port;
  long size;
  int port_loc;
  char *content = NULL;

  NEW_CELL(sc, port);
  port_loc = s7_gc_protect(sc, port);
  set_type(port, T_INPUT_PORT | T_DONT_COPY);
  port->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_is_closed(port) = false;

  /* if we're constantly opening files, and each open saves the file name in permanent
   *   memory, we gradually core-up.  
   */
  port_filename(port) = copy_string(name);
  port_line_number(port) = 1;  /* 1st line is numbered 1 */
  add_input_port(sc, port);

  fseek(fp, 0, SEEK_END);
  size = ftell(fp);
  rewind(fp);

  /* pseudo files (under /proc for example) have size=0, but we can read them, so don't assume a 0 length file is empty */

  if ((size != 0) &&
      ((max_size < 0) || (size < max_size)))
    {
      size_t bytes;
      content = (char *)malloc((size + 2) * sizeof(char));
      bytes = fread(content, sizeof(char), size, fp);
      if (bytes != (size_t)size)
	{
	  char tmp[256];
	  snprintf(tmp, 256, "(%s \"%s\") read %ld bytes of an expected %ld?", caller, name, (long)bytes, size);
	  write_string(sc, tmp, sc->output_port);
	}
      content[size] = '\0';
      content[size + 1] = '\0';
      fclose(fp);

      port_type(port) = STRING_PORT;
      port_string(port) = content;
      port_string_length(port) = size;
      port_string_point(port) = 0;
      port_needs_free(port) = true;
    }
  else
    {
      port_file(port) = fp;
      port_type(port) = FILE_PORT;
      port_needs_free(port) = false;
    }

  s7_gc_unprotect_at(sc, port_loc);
  return(port);
}


static s7_pointer make_input_file(s7_scheme *sc, const char *name, FILE *fp)
{
  #define MAX_SIZE_FOR_STRING_PORT 1000000
  return(read_file(sc, fp, name, MAX_SIZE_FOR_STRING_PORT, "open"));
}


static s7_pointer open_input_file_1(s7_scheme *sc, const char *name, const char *mode, const char *caller)
{
  FILE *fp;
  /* see if we can open this file before allocating a port */

  errno = 0;
  fp = fopen(name, mode);
  if (!fp)
    {
#ifndef _MSC_VER
      if (errno == EINVAL)
	return(file_error(sc, caller, "invalid mode", mode));
#endif
      return(file_error(sc, caller, strerror(errno), name));
    }

  return(make_input_file(sc, name, fp));
}


s7_pointer s7_open_input_file(s7_scheme *sc, const char *name, const char *mode)
{
  return(open_input_file_1(sc, name, mode, "open-input-file"));
}


static s7_pointer g_open_input_file(s7_scheme *sc, s7_pointer args)
{
  #define H_open_input_file "(open-input-file filename (mode \"r\")) opens filename for reading"
  s7_pointer name = car(args);

  if (!s7_is_string(name))
    return(s7_wrong_type_arg_error(sc, "open-input-file filename,", (is_null(cdr(args))) ? 0 : 1, name, "a string"));
  
  if (is_pair(cdr(args)))
    {
      if (!s7_is_string(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "open-input-file mode,", 2, cadr(args), "a string (a mode such as \"r\")"));
      return(open_input_file_1(sc, s7_string(name), s7_string(cadr(args)), "open-input-file"));
    }
  return(open_input_file_1(sc, s7_string(name), "r", "open-input-file"));
}


static void make_standard_ports(s7_scheme *sc)
{
  s7_pointer x;

  /* standard output */
  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;
  set_type(x, T_OUTPUT_PORT | T_IMMUTABLE | T_DONT_COPY);
  x->object.port = (s7_port_t *)permanent_calloc(sizeof(s7_port_t));
  port_type(x) = FILE_PORT;
  port_is_closed(x) = false;
  port_filename(x) = copy_string("*stdout*");
  port_file_number(x) = remember_file_name(sc, port_filename(x)); /* these numbers need to be correct for the evaluator (__FUNC__ data) */
  port_line_number(x) = 0;
  port_file(x) = stdout;
  port_needs_free(x) = false;
  sc->standard_output = x;

  /* standard error */
  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;
  set_type(x, T_OUTPUT_PORT | T_IMMUTABLE | T_DONT_COPY);
  x->object.port = (s7_port_t *)permanent_calloc(sizeof(s7_port_t));
  port_type(x) = FILE_PORT;
  port_is_closed(x) = false;
  port_filename(x) = copy_string("*stderr*");
  port_file_number(x) = remember_file_name(sc, port_filename(x));
  port_line_number(x) = 0;
  port_file(x) = stderr;
  port_needs_free(x) = false;
  sc->standard_error = x;

  /* standard input */
  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;
  set_type(x, T_INPUT_PORT | T_IMMUTABLE | T_DONT_COPY);
  x->object.port = (s7_port_t *)permanent_calloc(sizeof(s7_port_t));
  port_type(x) = FILE_PORT;
  port_is_closed(x) = false;
  port_filename(x) = copy_string("*stdin*");
  port_file_number(x) = remember_file_name(sc, port_filename(x));
  port_line_number(x) = 0;
  port_file(x) = stdin;
  port_needs_free(x) = false;
  sc->standard_input = x;

  s7_define_constant(sc, "*stdin*", sc->standard_input);
  s7_define_constant(sc, "*stdout*", sc->standard_output);
  s7_define_constant(sc, "*stderr*", sc->standard_error);

  sc->input_port = sc->standard_input;
  sc->output_port = sc->standard_output;
  sc->error_port = sc->standard_error;
  sc->current_file = NULL;
  sc->current_line = -1;
}


s7_pointer s7_open_output_file(s7_scheme *sc, const char *name, const char *mode)
{
  FILE *fp;
  s7_pointer x;
  /* see if we can open this file before allocating a port */
  
  errno = 0;
  fp = fopen(name, mode);
  if (!fp)
    {
#ifndef _MSC_VER
      if (errno == EINVAL)
	return(file_error(sc, "open-output-file", "invalid mode", mode));
#endif
      return(file_error(sc, "open-output-file", strerror(errno), name));
    }

  NEW_CELL(sc, x);
  set_type(x, T_OUTPUT_PORT | T_DONT_COPY);
  
  x->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_type(x) = FILE_PORT;
  port_is_closed(x) = false;
  port_filename(x) = copy_string(name);
  port_line_number(x) = 1;
  port_file(x) = fp;
  port_needs_free(x) = false;
  add_output_port(sc, x);
  return(x);
}


static s7_pointer g_open_output_file(s7_scheme *sc, s7_pointer args)
{
  #define H_open_output_file "(open-output-file filename (mode \"w\")) opens filename for writing"
  s7_pointer name = car(args);

  if (!s7_is_string(name))
    return(s7_wrong_type_arg_error(sc, "open-output-file filename,", (is_null(cdr(args))) ? 0 : 1, name, "a string"));
  
  if (is_pair(cdr(args)))
    {
      if (!s7_is_string(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "open-output-file mode,", 2, cadr(args), "a string (a mode such as \"w\")"));
      return(s7_open_output_file(sc, s7_string(name), s7_string(cadr(args))));
    }
  return(s7_open_output_file(sc, s7_string(name), "w"));
}


s7_pointer s7_open_input_string(s7_scheme *sc, const char *input_string)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_INPUT_PORT | T_DONT_COPY);
  
  x->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_type(x) = STRING_PORT;
  port_is_closed(x) = false;
  port_string(x) = (char *)input_string;
  port_string_length(x) = safe_strlen(input_string);
  port_string_point(x) = 0;
  port_filename(x) = NULL;
  port_file_number(x) = -1;
  port_needs_free(x) = false;
  add_input_port(sc, x);
  return(x);
}


static s7_pointer g_open_input_string(s7_scheme *sc, s7_pointer args)
{
  #define H_open_input_string "(open-input-string str) opens an input port reading str"
  s7_pointer input_string = car(args);

  if (!s7_is_string(input_string))
    return(s7_wrong_type_arg_error(sc, "open-input-string", 0, input_string, "a string"));
  
  return(s7_open_input_string(sc, s7_string(input_string))); /* presumably the caller is protecting the input string?? */
}


#define STRING_PORT_INITIAL_LENGTH 128

s7_pointer s7_open_output_string(s7_scheme *sc)
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_OUTPUT_PORT | T_DONT_COPY);
  
  x->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_type(x) = STRING_PORT;
  port_is_closed(x) = false;
  port_string_length(x) = STRING_PORT_INITIAL_LENGTH;
  port_string(x) = (char *)calloc(STRING_PORT_INITIAL_LENGTH, sizeof(char));
  port_string_point(x) = 0;
  port_needs_free(x) = true;
  add_output_port(sc, x);
  return(x);
}


static s7_pointer g_open_output_string(s7_scheme *sc, s7_pointer args)
{
  #define H_open_output_string "(open-output-string) opens an output string port"
  return(s7_open_output_string(sc));
}


const char *s7_get_output_string(s7_scheme *sc, s7_pointer p)
{
  return(port_string(p));
}


static s7_pointer g_get_output_string(s7_scheme *sc, s7_pointer args)
{
  #define H_get_output_string "(get-output-string port) returns the output accumulated in port"
  s7_pointer p = car(args);

  if ((!is_output_port(p)) ||
      (!is_string_port(p)))
    return(s7_wrong_type_arg_error(sc, "get-output-string", 0, p, "an output string port"));
  if (port_is_closed(p))
    return(s7_wrong_type_arg_error(sc, "get-output-string", 0, p, "an active (open) string port"));

  return(s7_make_string(sc, s7_get_output_string(sc, p)));
}


s7_pointer s7_open_input_function(s7_scheme *sc, s7_pointer (*function)(s7_scheme *sc, s7_read_t read_choice, s7_pointer port))
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_INPUT_PORT | T_DONT_COPY);
  
  x->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_type(x) = FUNCTION_PORT;
  port_is_closed(x) = false;
  port_needs_free(x) = false;
  port_input_function(x) = function;
  add_input_port(sc, x);
  return(x);
}


s7_pointer s7_open_output_function(s7_scheme *sc, void (*function)(s7_scheme *sc, unsigned char c, s7_pointer port))
{
  s7_pointer x;
  NEW_CELL(sc, x);
  set_type(x, T_OUTPUT_PORT | T_DONT_COPY);
  
  x->object.port = (s7_port_t *)calloc(1, sizeof(s7_port_t));
  port_type(x) = FUNCTION_PORT;
  port_is_closed(x) = false;
  port_needs_free(x) = false;
  port_output_function(x) = function;
  add_output_port(sc, x);
  return(x);
}


void *s7_port_data(s7_pointer port)
{
  return(port_data(port));
}


void *s7_port_set_data(s7_pointer port, void *stuff)
{
  port_data(port) = stuff;
  return(stuff);
}


static void push_input_port(s7_scheme *sc, s7_pointer new_port)
{
  sc->input_port_stack = cons(sc, sc->input_port, sc->input_port_stack);
  sc->input_port = new_port;
  sc->input_is_file = (is_file_port(sc->input_port));
}


static void pop_input_port(s7_scheme *sc)
{
  if (is_pair(sc->input_port_stack))
    {
      sc->input_port = car(sc->input_port_stack);

      /* is this safe? */
      typeflag(sc->input_port_stack) = 0;
      (*(sc->free_heap_top++)) = sc->input_port_stack;

      sc->input_port_stack = cdr(sc->input_port_stack);
    }
  else sc->input_port = sc->standard_input;
  sc->input_is_file = (is_file_port(sc->input_port));
}


static int inchar(s7_pointer pt)
{
  int c;
  if (is_file_port(pt))
    c = fgetc(port_file(pt)); /* not unsigned char! -- could be EOF */
  else 
    {
      if ((!(port_string(pt))) ||
	  (port_string_length(pt) <= port_string_point(pt)))
	return(EOF);
      c = (unsigned char)port_string(pt)[port_string_point(pt)++];
    }

  if (c == '\n')
    port_line_number(pt)++;

  return(c);
}


static void backchar(char c, s7_pointer pt) 
{
  if (c == '\n')
    port_line_number(pt)--;

  if (is_file_port(pt))
    ungetc(c, port_file(pt));
  else 
    {
      if (port_string_point(pt) > 0)
	port_string_point(pt)--;
    }
}


static int s7_read_char_1(s7_scheme *sc, s7_pointer port, s7_read_t read_choice)
{
  int c;              /* needs to be an int so EOF=-1, but not 255 */

  if (is_function_port(port))
    return(character((*(port_input_function(port)))(sc, read_choice, port)));

  if (is_file_port(port))
    c = fgetc(port_file(port)); /* not unsigned char! -- could be EOF */
  else 
    {
      if ((!(port_string(port))) ||
	  (port_string_length(port) <= port_string_point(port)))
	return(EOF);
      c = (unsigned char)port_string(port)[port_string_point(port)++];
    }

  if ((read_choice == S7_PEEK_CHAR) && (c != EOF))
    backchar(c, port);
  return(c);
}


int s7_read_char(s7_scheme *sc, s7_pointer port)
{
  return(s7_read_char_1(sc, port, S7_READ_CHAR));
}


int s7_peek_char(s7_scheme *sc, s7_pointer port)
{
  return(s7_read_char_1(sc, port, S7_PEEK_CHAR));
}


static s7_pointer g_read_char_1(s7_scheme *sc, s7_pointer args, bool peek)
{
  int c;
  s7_pointer port;

  if (is_not_null(args))
    port = car(args);
  else port = sc->input_port;

  if (!is_input_port(port))
    return(s7_wrong_type_arg_error(sc, (peek) ? "peek-char" : "read-char", 0, port, "an input port"));
  if (port_is_closed(port))
    return(s7_wrong_type_arg_error(sc, (peek) ? "peek-char" : "read-char", 0, port, "an open input port"));
      
  c = s7_read_char_1(sc, port, (peek) ? S7_PEEK_CHAR : S7_READ_CHAR);
  if (c == EOF)
    return(sc->EOF_OBJECT); 

  return(s7_make_character(sc, (unsigned char)c));
}


static s7_pointer g_read_char(s7_scheme *sc, s7_pointer args)
{
  #define H_read_char "(read-char (port (current-input-port))) returns the next character in the input port"
  return(g_read_char_1(sc, args, false));
}


static s7_pointer g_peek_char(s7_scheme *sc, s7_pointer args)
{
  #define H_peek_char "(peek-char (port (current-input-port))) returns the next character in the input port, but does not remove it from the input stream"
  return(g_read_char_1(sc, args, true));
}


static s7_pointer g_read_line(s7_scheme *sc, s7_pointer args)
{
  #define H_read_line "(read-line port (with-eol #f)) returns the next line from port, or #<eof> (use the function eof-object?).\
If 'with-eol' is not #f, read-line includes the trailing end-of-line character."

  s7_pointer port;
  unsigned int i;
  bool with_eol = false;

  if (is_not_null(args))
    {
      port = car(args);
      if (!is_input_port(port))
	return(s7_wrong_type_arg_error(sc, "read-line", (is_null(cdr(args))) ? 0 : 1, port, "an input port"));
      if (port_is_closed(port))
	return(s7_wrong_type_arg_error(sc, "read-line", (is_null(cdr(args))) ? 0 : 1, port, "an open input port"));

      if (is_not_null(cdr(args)))
	{
	  /* support (read-line fp 'concat) for compatibility with guile */
	  if ((!s7_is_boolean(cadr(args))) &&
	      (!s7_is_symbol(cadr(args))))
	    return(s7_wrong_type_arg_error(sc, "read-line", 2, cadr(args), "#f or #t"));
	  if (cadr(args) != sc->F)
	    with_eol = true;
	}
    }
  else port = sc->input_port;

  if (is_function_port(port))
    return((*(port_input_function(port)))(sc, S7_READ_LINE, port));

  if (sc->read_line_buf == NULL)
    {
      sc->read_line_buf_size = 256;
      sc->read_line_buf = (char *)malloc(sc->read_line_buf_size * sizeof(char));
    }

  if (port == sc->standard_input)
    {
      if (fgets(sc->read_line_buf, sc->read_line_buf_size, stdin) != NULL)
	return(s7_make_string(sc, sc->read_line_buf)); /* fgets adds the trailing '\0' */
      return(s7_make_string_with_length(sc, NULL, 0));
    }

  if (is_file_port(port))
    {
      for (i = 0; ; i++)
	{
	  int c;
	  if (i >= sc->read_line_buf_size)
	    {
	      sc->read_line_buf_size *= 2;
	      sc->read_line_buf = (char *)realloc(sc->read_line_buf, sc->read_line_buf_size * sizeof(char));
	    }
	  c = fgetc(port_file(port)); /* not unsigned char! -- could be EOF */
	  if (c == EOF)
	    {
	      if (i == 0)
		return(sc->EOF_OBJECT);
	      return(s7_make_terminated_string_with_length(sc, sc->read_line_buf, i));
	    }
	  sc->read_line_buf[i] = (char)c;
	  if (c == '\n')
	    {
	      port_line_number(port)++;
	      if (!with_eol) i--;
	      return(s7_make_terminated_string_with_length(sc, sc->read_line_buf, i + 1));
	    }
	}
    }
  else
    {
      unsigned int port_len;

      if (!(port_string(port)))
	return(sc->EOF_OBJECT);
      port_len = port_string_length(port);

      for (i = 0; ; i++)
	{
	  int c;
	  if (i >= sc->read_line_buf_size) /* here and above I was using i+1 */
	    {
	      sc->read_line_buf_size *= 2;
	      sc->read_line_buf = (char *)realloc(sc->read_line_buf, sc->read_line_buf_size * sizeof(char));
	    }

	  if (port_len <= port_string_point(port))
	    c = EOF;
	  else c = (unsigned char)port_string(port)[port_string_point(port)++];

	  if (c == EOF)
	    {
	      if (i == 0)
		return(sc->EOF_OBJECT);
	      return(s7_make_terminated_string_with_length(sc, sc->read_line_buf, i));
	    }
	  sc->read_line_buf[i] = (char)c;
	  if (c == '\n')
	    {
	      port_line_number(port)++;
	      if (!with_eol) i--;
	      return(s7_make_terminated_string_with_length(sc, sc->read_line_buf, i + 1));
	    }
	}
    }
  return(sc->EOF_OBJECT);
}


s7_pointer s7_read(s7_scheme *sc, s7_pointer port)
{
  if (is_input_port(port))
    {
      bool old_longjmp;
      old_longjmp = sc->longjmp_ok;
      if (!sc->longjmp_ok)
	{
	  sc->longjmp_ok = true;
	  if (setjmp(sc->goto_start) != 0)
	    return(sc->value);
	}
      push_input_port(sc, port);
      push_stack(sc, OP_EVAL_DONE, port, sc->NIL);
      eval(sc, OP_READ_INTERNAL);
      sc->longjmp_ok = old_longjmp;
      pop_input_port(sc);
      return(sc->value);
    }
  return(s7_wrong_type_arg_error(sc, "read", 0, port, "an input port"));
}


static s7_pointer g_read(s7_scheme *sc, s7_pointer args)
{
  #define H_read "(read (port (current-input-port))) returns the next object in the input port, or #<eof> at the end"
  s7_pointer port;
  
  if (is_not_null(args))
    port = car(args);
  else port = sc->input_port;
  
  if (!is_input_port(port)) /* was also not stdin */
    return(s7_wrong_type_arg_error(sc, "read", 0, port, "an input port"));
  if (port_is_closed(port))
    return(s7_wrong_type_arg_error(sc, "read", 0, port, "an open input port"));

  if (is_function_port(port))
    return((*(port_input_function(port)))(sc, S7_READ, port));
  
  if ((is_string_port(port)) &&
      (port_string_length(port) <= port_string_point(port)))
    return(sc->EOF_OBJECT);

  push_input_port(sc, port);

  push_stack(sc, OP_READ_DONE, sc->NIL, sc->NIL); /* this stops the internal read process so we only get one form */
  push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
  return(port);
}


static FILE *search_load_path(s7_scheme *sc, const char *name)
{
  int i, len, name_len;
  s7_pointer lst;

  lst = s7_load_path(sc);
  len = s7_list_length(sc, lst);
  name_len = safe_strlen(name);

  for (i = 0; i < len; i++)
    {
      const char *new_dir;
      int size;
      new_dir = s7_string(s7_list_ref(sc, lst, i));
      if (new_dir)
	{
	  char *new_name;
	  FILE *fp;
	  size = name_len + safe_strlen(new_dir) + 2;
	  new_name = (char *)malloc(size * sizeof(char));
	  snprintf(new_name, size, "%s/%s", new_dir, name);
	  fp = fopen(new_name, "r");
	  free(new_name);
	  if (fp) return(fp);
	}
    }

  return(NULL);
}


static s7_pointer load_file(s7_scheme *sc, FILE *fp, const char *name)
{
  return(read_file(sc, fp, name, -1, "load"));  /* -1 means always read its contents into a local string */
}


s7_pointer s7_load(s7_scheme *sc, const char *filename)
{
  bool old_longjmp;
  s7_pointer port;
  FILE *fp;
  
  fp = fopen(filename, "r");
  if (!fp)
    fp = search_load_path(sc, filename);
  if (!fp)
    return(file_error(sc, "load", "can't open", filename));

  if (is_pair(hook_functions(sc->load_hook)))
    s7_hook_apply(sc, sc->load_hook, list_1(sc, s7_make_string(sc, filename)));

  port = load_file(sc, fp, filename);
  port_file_number(port) = remember_file_name(sc, filename);
  push_input_port(sc, port);
  
  /* it's possible to call this recursively (s7_load is XEN_LOAD_FILE which can be invoked via s7_call)
   *   but in that case, we actually want it to behave like g_load and continue the evaluation upon completion
   */
  sc->envir = sc->NIL;
  
  
  if (!sc->longjmp_ok)
    {
      push_stack(sc, OP_LOAD_RETURN_IF_EOF, port, sc->NIL);
      
      old_longjmp = sc->longjmp_ok;
      if (!sc->longjmp_ok)
	{
	  sc->longjmp_ok = true;
	  if (setjmp(sc->goto_start) != 0)
	    eval(sc, sc->op);
	  else eval(sc, OP_READ_INTERNAL);
	}
      sc->longjmp_ok = old_longjmp;  
      pop_input_port(sc);
      s7_close_input_port(sc, port);
    }
  else
    {
      /* caller here is assuming the load will be complete before this function returns */
      push_stack(sc, OP_LOAD_RETURN_IF_EOF, sc->args, sc->code);

      eval(sc, OP_READ_INTERNAL);
      pop_input_port(sc);
      s7_close_input_port(sc, port);
    }

  return(sc->UNSPECIFIED);
}


#include <sys/stat.h>

static bool is_directory(const char *filename)
{
#if HAVE_WINDOZE
  return(false);

#else
  /* from snd-file.c */
#ifdef S_ISDIR
  struct stat statbuf;
#if HAVE_LSTAT
  return((lstat(filename, &statbuf) >= 0) &&
	 (S_ISDIR(statbuf.st_mode)));
  return(false);
#else
  return((stat(filename, &statbuf) == 0) && 
	 (S_ISDIR(statbuf.st_mode)));
#endif
#endif
#endif
}


static s7_pointer g_load(s7_scheme *sc, s7_pointer args)
{
  #define H_load "(load file (env (global-environment))) loads the scheme file 'file'. The 'env' argument \
defaults to the global environment.  To load into the current environment instead, pass (current-environment)."

  FILE *fp = NULL;
  s7_pointer name, port;
  const char *fname;
  
  name = car(args);
  if (!s7_is_string(name))
    return(s7_wrong_type_arg_error(sc, "load filename,", (is_null(cdr(args))) ? 0 : 1, name, "a string"));

  if (is_not_null(cdr(args))) 
    {
      if (!is_environment(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "load", 2, cadr(args), "an environment"));
      if (is_pair(cadr(args)))
	sc->envir = cadr(args);
      else sc->envir = sc->NIL;
    }
  else sc->envir = sc->NIL;
  
  fname = s7_string(name);
  if ((!fname) || (!(*fname)))                 /* fopen("", "r") returns a file pointer?? */
    return(s7_error(sc, sc->OUT_OF_RANGE, 
		    list_2(sc, 
				make_protected_string(sc, "load's first argument, ~S, should be a filename"),
				name)));

  if (is_directory(fname))
    return(s7_error(sc, sc->WRONG_TYPE_ARG, 
		    list_2(sc, make_protected_string(sc, "load argument, ~S, is a directory"), name)));

  fp = fopen(fname, "r");
  if (!fp)
    fp = search_load_path(sc, fname);
  if (!fp)
    return(file_error(sc, "load", "can't open", fname));
  
  port = load_file(sc, fp, fname);
  port_file_number(port) = remember_file_name(sc, fname);
  push_input_port(sc, port);

  push_stack(sc, OP_LOAD_CLOSE_AND_POP_IF_EOF, sc->NIL, sc->NIL);  /* was pushing args and code, but I don't think they're used later */
  push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
  
  /* now we've opened and moved to the file to be loaded, and set up the stack to return
   *   to where we were when it is read.  Call *load-hook* if it is a procedure.
   */
  
  if (is_not_null(hook_functions(sc->load_hook)))
    push_stack(sc, OP_HOOK_APPLY, list_1(sc, s7_make_string(sc, fname)), hook_functions(sc->load_hook));

  return(sc->UNSPECIFIED);
}


s7_pointer s7_load_path(s7_scheme *sc)
{
  return(s7_symbol_value(sc, make_symbol(sc, "*load-path*")));
}


s7_pointer s7_add_to_load_path(s7_scheme *sc, const char *dir)
{
  s7_pointer load_path;
  load_path = make_symbol(sc, "*load-path*");

  s7_symbol_set_value(sc, 
		      load_path,
		      cons(sc, 
			      s7_make_string(sc, dir), 
			      s7_symbol_value(sc, load_path)));
  return(s7_load_path(sc));
}


static s7_pointer g_load_path_set(s7_scheme *sc, s7_pointer args)
{
  /* new value must be either '() or a proper list of strings */
  if (is_null(cadr(args))) return(cadr(args));
  if (is_pair(cadr(args)))
    {
      s7_pointer x;
      for (x = cadr(args); is_pair(x); x = cdr(x))
	if (!s7_is_string(car(x)))
	  return(sc->ERROR);
      if (is_null(x))
	return(cadr(args));
    }
  return(sc->ERROR);
}


static s7_pointer eval_string_1(s7_scheme *sc, const char *str)
{
  s7_pointer port;

  port = s7_open_input_string(sc, str);
  push_input_port(sc, port);

  push_stack(sc, OP_BARRIER, port, sc->NIL);
  /* we're being called directly from C here, not as part of a scheme program.
   *    Use this op to protect the port, I guess.
   */
  push_stack(sc, OP_EVAL_STRING, sc->args, sc->code);  
  /* eval-string is not tail-recursive because it pushes markers in eval to catch
   *    multiple statements in one eval-string call.
   */
  eval(sc, OP_READ_INTERNAL);

  pop_input_port(sc);
  s7_close_input_port(sc, port);
  if (is_multiple_value(sc->value))                    /* (+ 1 (eval-string "(values 2 3)")) */
    sc->value = splice_in_values(sc, multiple_value(sc->value));

  return(sc->value);
}


s7_pointer s7_eval_c_string(s7_scheme *sc, const char *str)
{
  bool old_longjmp;
  s7_pointer port, old_envir;
  /* this can be called recursively via s7_call */

  old_envir = sc->envir;
  sc->envir = sc->NIL; /* C call assumes top level, I think.  This is needed in any case
			       *   by dlinit -- the init function will be called in some local environment,
			       *   but the library entities it defines should obviously be top level,
			       *   as if via load.
			       */
  if (sc->longjmp_ok)
    {
      s7_pointer result;
      result = eval_string_1(sc, str);
      sc->envir = old_envir;
      return(result);
    }
  
  stack_reset(sc); 
  push_stack(sc, OP_EVAL_STRING, old_envir, sc->NIL); /* GC protect envir */

  port = s7_open_input_string(sc, str);
  push_input_port(sc, port);
  
  old_longjmp = sc->longjmp_ok;
  if (!sc->longjmp_ok)
    {
      sc->longjmp_ok = true;
      if (setjmp(sc->goto_start) != 0)
	eval(sc, sc->op);
      else eval(sc, OP_READ_INTERNAL);
    }
  
  sc->longjmp_ok = old_longjmp;
  pop_input_port(sc);
  s7_close_input_port(sc, port);
  sc->envir = old_envir;  
  return(sc->value);
}


static s7_pointer g_eval_string(s7_scheme *sc, s7_pointer args)
{
  #define H_eval_string "(eval-string str (env (current-environment))) returns the result of evaluating the string str as Scheme code"
  s7_pointer port;
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "eval-string", (is_null(cdr(args))) ? 0 : 1, car(args), "a string"));
  
  if (is_not_null(cdr(args)))
    {
      if (!is_environment(cadr(args)))
 	return(s7_wrong_type_arg_error(sc, "eval-string", 2, cadr(args), "an environment"));
      if (cadr(args) == sc->global_env)
	sc->envir = sc->NIL;
      else sc->envir = cadr(args);
    }

  port = s7_open_input_string(sc, s7_string(car(args)));
  push_input_port(sc, port);
  
  push_stack(sc, OP_EVAL_STRING_1, args, sc->code); /* was sc->args */
  push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
  
  return(sc->F);
}



static s7_pointer call_with_input(s7_scheme *sc, s7_pointer port, s7_pointer args)
{
  push_stack(sc, OP_UNWIND_INPUT, sc->input_port, port);
  push_stack(sc, OP_APPLY, list_1(sc, port), cadr(args));
  return(sc->F);
}


static s7_pointer g_call_with_input_string(s7_scheme *sc, s7_pointer args)
{
  #define H_call_with_input_string "(call-with-input-string str proc) opens a string port for str and applies proc to it"
  
  /* (call-with-input-string "44" (lambda (p) (+ 1 (read p)))) -> 45
   */
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-string", 1, car(args), "a string"));
  if (!is_procedure(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-string", 2, cadr(args), "a procedure"));
  if ((is_continuation(cadr(args))) || is_goto(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-string", 2, cadr(args), "a normal procedure (not a continuation)"));
  
  return(call_with_input(sc, s7_open_input_string(sc, s7_string(car(args))), args));
}


static s7_pointer g_call_with_input_file(s7_scheme *sc, s7_pointer args)
{
  #define H_call_with_input_file "(call-with-input-file filename proc) opens filename and calls proc with the input port as its argument"
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-file", 1, car(args), "a string (a filename)"));
  if (!is_procedure(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-file", 2, cadr(args), "a procedure"));
  if ((is_continuation(cadr(args))) || is_goto(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-input-file", 2, cadr(args), "a normal procedure (not a continuation)"));
  
  return(call_with_input(sc, open_input_file_1(sc, s7_string(car(args)), "r", "call-with-input-file"), args));
}


static s7_pointer with_input(s7_scheme *sc, s7_pointer port, s7_pointer args)
{
  s7_pointer old_input_port;
  old_input_port = sc->input_port;
  sc->input_port = port;
  sc->input_is_file = (is_file_port(sc->input_port));
  
  push_stack(sc, OP_UNWIND_INPUT, old_input_port, port);
  push_stack(sc, OP_APPLY, sc->NIL, cadr(args));
  return(sc->F);
}


static s7_pointer g_with_input_from_string(s7_scheme *sc, s7_pointer args)
{
  #define H_with_input_from_string "(with-input-from-string str thunk) opens str as the temporary current-input-port and calls thunk"
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "with-input-from-string", 1, car(args), "a string"));
  if (!is_thunk(sc, cadr(args)))
    return(s7_wrong_type_arg_error(sc, "with-input-from-string", 2, cadr(args), "a thunk"));
  
  /* since the arguments are evaluated before we get here, we can get some confusing situations:
   *   (with-input-from-string "#x2.1" (read))
   *   (read) -> whatever it can get from the current input port!
   *   ";with-input-from-string argument 2, #<eof>, is untyped but should be a thunk"
   */
  
  return(with_input(sc, s7_open_input_string(sc, s7_string(car(args))), args));
}


static s7_pointer g_with_input_from_file(s7_scheme *sc, s7_pointer args)
{
  #define H_with_input_from_file "(with-input-from-file filename thunk) opens filename as the temporary current-input-port and calls thunk"
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "with-input-from-file", 1, car(args), "a string (a filename)"));
  if (!is_thunk(sc, cadr(args)))
    return(s7_wrong_type_arg_error(sc, "with-input-from-file", 2, cadr(args), "a thunk"));
  
  return(with_input(sc, open_input_file_1(sc, s7_string(car(args)), "r", "with-input-from-file"), args));
}



static void char_to_string_port(char c, s7_pointer pt)
{
  if (port_string_point(pt) >= port_string_length(pt))
    {
      int loc;
      loc = port_string_length(pt);
      port_string_length(pt) *= 2;
      port_string(pt) = (char *)realloc(port_string(pt), port_string_length(pt) * sizeof(char));
      memset((void *)(port_string(pt) + loc), 0, loc);
    }
  port_string(pt)[port_string_point(pt)++] = c;
}


static void write_char(s7_scheme *sc, int c, s7_pointer pt) 
{
  if (pt == sc->standard_error)
    fputc(c, stderr);
  else
    {
      if (pt == sc->standard_output)
	fputc(c, stdout);
      else
	{
	  if (port_is_closed(pt))
	    return;
	  if (is_file_port(pt))
	    {
	      if (fputc(c, port_file(pt)) == EOF)
		fprintf(stderr, "write to %s: %s\n", port_filename(pt), strerror(errno));
	    }
	  else 
	    {
	      if (is_string_port(pt))
		char_to_string_port(c, pt);
	      else (*(port_output_function(pt)))(sc, c, pt);
	    }
	}
    }
}


static void write_string(s7_scheme *sc, const char *s, s7_pointer pt) 
{
  if (!s) return;
  
  if (pt == sc->standard_error)
    fputs(s, stderr);
  else
    {
      if (pt == sc->standard_output)
	fputs(s, stdout);
      else
	{
	  if (port_is_closed(pt))
	    return;
	  
	  if (is_file_port(pt))
	    {
	      if (fputs(s, port_file(pt)) == EOF)
		fprintf(stderr, "write to %s: %s\n", port_filename(pt), strerror(errno));
	    }
	  else 
	    {
	      if (is_string_port(pt))
		{
		  for (; *s; s++)
		    char_to_string_port(*s, pt);
		}
	      else 
		{
		  for (; *s; s++)
		    (*(port_output_function(pt)))(sc, *s, pt);
		}
	    }
	}
    }
}


#define IN_QUOTES true
#define NOT_IN_QUOTES false

static char *slashify_string(const char *p, int len, bool quoted, bool *slashified)
{
  int i, j = 0, cur_size;
  char *s;

  cur_size = len + 256;
  s = (char *)calloc(cur_size + 2, sizeof(char));
  /* this can be non-null even if there's not enough memory, but I think I'll check in the caller */
  if (quoted) s[j++] = '"';

  for (i = 0; i < len; i++) 
    {
      if (slashify_table[((unsigned char)(p[i]))])
	{
	  s[j++] = '\\';
	  (*slashified) = true;
	  switch (p[i]) 
	    {
	    case '"':
	      s[j++] = '"';
	      break;
	      
	    case '\\':
	      s[j++] = '\\';
	      break;
	      
	    default:               /* this is the "\x01" stuff */
	      { 
		unsigned int n;
		static char dignum[] = "0123456789abcdef";
		s[j++] = 'x';
		n = (unsigned int)(p[i]);
		if (n < 16)
		  s[j++] = '0';
		else s[j++] = dignum[(n / 16) % 16];
		s[j++] = dignum[n % 16];
	      }
	      break;
	    }
	}
      else s[j++] = p[i];
      if (j >= cur_size) /* even with 256 extra, we can overflow (for example, inordinately many tabs in ALSA output) */
	{
	  int k;
	  cur_size *= 2;
	  s = (char *)realloc(s, (cur_size + 2) * sizeof(char));
	  for (k = j; k < cur_size + 2; k++) s[k] = 0;
	}
    }
  if (quoted) s[j++] = '"';
  return(s);
}


/* (let () (define (hi a) (+ a 1)) (object->string hi))
 * (let () (define (hi a) (asd a 1)) (environment->list (procedure-environment hi)))
 */

static const char *c_closure_name(s7_scheme *sc, s7_pointer closure)
{
  s7_pointer x;

  if (is_safe_closure(closure_body(closure)))
    x = find_local_symbol(sc, cdr(closure_environment(closure)), sc->__FUNC__);  /* skip the built-in arg list */
  else x = find_local_symbol(sc, closure_environment(closure), sc->__FUNC__);  /* returns nil if no __func__ */

  if (is_pair(x))
    {
      x = symbol_value(x);
      if (s7_is_symbol(x))
	return(symbol_name(x));
      if ((is_pair(x)) &&
	  (s7_is_symbol(car(x))))
	return(symbol_name(car(x)));
    }
  return("#<closure>");
}


#define WITH_ELLIPSES false

static char *atom_to_c_string(s7_scheme *sc, s7_pointer obj, bool use_write)
{
  switch (type(obj))
    {
    case T_BOOLEAN:
      if (obj == sc->T)
	return(copy_string("#t"));
      return(copy_string("#f"));

    case T_NIL:
      return(copy_string("()"));
  
    case T_UNTYPED:
      if (obj == sc->EOF_OBJECT)
	return(copy_string("#<eof>"));
  
      if (obj == sc->UNDEFINED) 
	return(copy_string("#<undefined>"));
  
      if ((is_unspecified(obj)) || (obj == sc->NO_VALUE))
	return(copy_string("#<unspecified>"));

      if (obj == sc->ELSE)
	return(copy_string("else"));
      break;

    case T_INPUT_PORT:
    case T_OUTPUT_PORT:
      return(describe_port(sc, obj));

    case T_HOOK:
      return(copy_string("#<hook>"));

    case T_COUNTER:
      return(copy_string("#<counter>"));

    case T_NUMBER:
      return(number_to_string_base_10(obj, 0, 14, 'g')); /* 20 digits is excessive in this context */

    case T_SYMBOL:
      {
	bool slashified = false;
	char *str;
	/* I think this is the only place we print a symbol's name */
	/* return(copy_string_with_len(symbol_name(obj), symbol_name_length(obj))); */

	str = slashify_string(symbol_name(obj), symbol_name_length(obj), NOT_IN_QUOTES, &slashified);
	if (slashified)
	  {
	    char *symstr;
	    int len;
	    len = safe_strlen(str) + 16;
	    symstr = (char *)calloc(len, sizeof(char));
	    snprintf(symstr, len, "(symbol \"%s\")", str);
	    free(str);
	    return(symstr);
	  }
	return(str);
      }

    case T_SYNTAX:
      return(copy_string(op_names[(int)syntax_opcode(obj)]));

    case T_STRING:
      if (string_length(obj) > 0)
	{
	  /* if string_length is enormous, this can cause an eventual segfault.
	   * for now, print enough chars to make anyone happy
	   */
	  int len;
	  bool slashified = false;
	  len = string_length(obj);
	  if (len > (1 << 24))
	    len = (1 << 24);
	  if (!use_write) 
	    return(copy_string_with_len(string_value(obj), len));
	  return(slashify_string(string_value(obj), len, IN_QUOTES, &slashified));
	}
      if (!use_write)
	return(NULL);
      return(copy_string("\"\""));

    case T_CHARACTER:
      {
	#define P_SIZE 16
	char *p;
	unsigned char c;
	p = (char *)malloc(P_SIZE * sizeof(char));
	c = (unsigned char)s7_character(obj);             /* if not unsigned, (write (integer->char 212) -> #\xffffffd4! */
	if (!use_write) 
	  {
	    p[0]= c;
	    p[1]= 0;
	  } 
	else 
	  {
	    switch (c) 
	      {
	      case ' ':
		snprintf(p, P_SIZE, "#\\space"); 
		break;

	      case '\n':
		snprintf(p, P_SIZE, "#\\newline"); 
		break;

	      case '\r':
		snprintf(p, P_SIZE, "#\\return"); 
		break;

	      case '\t':
		snprintf(p, P_SIZE, "#\\tab"); 
		break;

	      case '\0':
		snprintf(p, P_SIZE, "#\\null");
		break;

	      default:
		if ((c < 32) || (c >= 127))
		  snprintf(p, P_SIZE, "#\\x%x", c);
		else snprintf(p, P_SIZE, "#\\%c", c); 
		break;
	      }
	  }
	return(p);
      }

    case T_MACRO:
    case T_BACRO:
      return(copy_string("#<macro>"));
  
    case T_CLOSURE:
    case T_CLOSURE_STAR:
      return(copy_string(c_closure_name(sc, obj)));
  
    case T_C_OPT_ARGS_FUNCTION:
    case T_C_RST_ARGS_FUNCTION:
    case T_C_LST_ARGS_FUNCTION:
    case T_C_ANY_ARGS_FUNCTION:
    case T_C_FUNCTION:
      return(copy_string(c_function_name(obj)));

    case T_C_MACRO:
      return(copy_string(c_macro_name(obj)));
  
    case T_C_POINTER:
      {
	char *str;
	str = (char *)calloc(32, sizeof(char));
	snprintf(str, 32, "#<c_pointer %p>", raw_pointer(obj));
	return(str);
      }
  
    case T_CONTINUATION:
      return(copy_string("#<continuation>"));
  
    case T_GOTO:
      return(copy_string("#<goto>"));
  
    case T_CATCH:                        /* this can't happen */
      return(copy_string("#<catch>"));
  
    case T_DYNAMIC_WIND:                 /* this can't happen */
      return(copy_string("#<dynamic-wind>"));
  
    case T_C_OBJECT:
      return(object_print(sc, obj));     /* this allocates already */

    case T_VECTOR: 
      return(copy_string("#<vector>"));

    case T_ENVIRONMENT:
      return(copy_string("#<environment>"));

    case T_PAIR: 
      return(copy_string("#<pair>"));

    default:
      break;
    }

  {
    char *buf;
    buf = (char *)calloc(512, sizeof(char));
    snprintf(buf, 512, "<unknown object! type: %d (%s), flags: %x%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s>", 
	     type(obj), 
	     type_name(obj),
	     typeflag(obj),
	     is_procedure(obj) ?          " procedure" : "",
	     is_marked(obj) ?             " gc-marked" : "",
	     is_immutable(obj) ?          " immutable" : "",
	     dont_copy(obj) ?             " dont-copy" : "",
	     is_any_macro(obj) ?          " anymac" : "",
	     is_expansion(obj) ?          " expansion" : "",
	     is_multiple_value(obj) ?     " values" : "",
	     is_keyword(obj) ?            " keyword" : "",
             dont_eval_args(obj) ?        " dont-eval-args" : "",
	     is_syntactic(obj) ?          " syntactic" : "",
	     is_overlaid(obj) ?           " overlay" : "",
	     is_checked(obj) ?            " checked" : "",
	     is_unsafe(obj) ?             " unsafe" : "",
	     is_optimized(obj) ?          " optimized" : "",
	     is_safe_closure(obj) ?       " safe closure" : "",
	     is_setter(obj) ?             " setter" : "",
	     ((typeflag(obj) & UNUSED_BITS) != 0) ? " bad bits!" : "");
    return(buf);
  }
}


bool s7_is_valid_pointer(s7_pointer arg)
{
  return((arg) &&
	 (type(arg) > T_UNTYPED) && (type(arg) < BUILT_IN_TYPES));
}


static int display_multivector(s7_scheme *sc, s7_pointer vec, int out_len, int flat_ref, int dimension, int dimensions, char *out_str, char **elements, char *last)
{
  int i;

  if (*last == ')')
    strcat(out_str, " ");

  strcat(out_str, "(");
  (*last) = '(';

  for (i = 0; i < vector_dimension(vec, dimension); i++)
    {
      if (dimension == (dimensions - 1))
	{
	  if (flat_ref < out_len)
	    strcat(out_str, elements[flat_ref++]);
	  else
	    {
	      strcat(out_str, "...)");
	      return(flat_ref);
	    }
	  if (i < (vector_dimension(vec, dimension) - 1))
	    strcat(out_str, " ");
	}
      else 
	{
	  if (flat_ref < out_len)
	    flat_ref = display_multivector(sc, vec, out_len, flat_ref, dimension + 1, dimensions, out_str, elements, last);
	  else 
	    {
	      strcat(out_str, "...)");
	      return(flat_ref);
	    }
	}
    }
  strcat(out_str, ")");
  (*last) = ')';
  return(flat_ref);
}


static bool has_structure(s7_pointer p) 
{
  return((type(p) == T_PAIR) ||
	 (type(p) == T_VECTOR) ||
	 (type(p) == T_HASH_TABLE));
}

#define INITIAL_SHARED_INFO_SIZE 8

static void free_shared_info(shared_info *ci)
{
}


static int shared_ref(shared_info *ci, s7_pointer p)
{
  int i;
  for (i = 0; i < ci->top; i++)
    if (ci->objs[i] == p)
      {
	int val;
	val = ci->refs[i];
	if (val > 0)
	  ci->refs[i] = -ci->refs[i];
	return(val);
      }
  return(0);
}


static int peek_shared_ref(shared_info *ci, s7_pointer p)
{
  /* returns 0 if not found, otherwise the ref value for p */
  int i;
  for (i = 0; i < ci->top; i++)
    if (ci->objs[i] == p)
      return(ci->refs[i]);
  return(0);
}


static void check_shared_info_size(shared_info *ci)
{
  if (ci->top == ci->size)
    {
      int i;
      ci->size *= 2;
      ci->objs = (s7_pointer *)realloc(ci->objs, ci->size * sizeof(s7_pointer));
      ci->refs = (int *)realloc(ci->refs, ci->size * sizeof(int));
      for (i = ci->top; i < ci->size; i++)
	{
	  ci->refs[i] = 0;
	  ci->objs[i] = NULL;
	}
    }
}


static void add_equal_ref(shared_info *ci, s7_pointer x, s7_pointer y)
{
  /* assume neither x nor y is in the table, and that they should share a ref value */
  ci->ref++;
  check_shared_info_size(ci);
  ci->objs[ci->top] = x;
  ci->refs[ci->top++] = ci->ref;
  check_shared_info_size(ci);
  ci->objs[ci->top] = y;
  ci->refs[ci->top++] = ci->ref;
}


static void add_shared_ref(shared_info *ci, s7_pointer x, int ref_x)
{
  check_shared_info_size(ci);
  ci->objs[ci->top] = x;
  ci->refs[ci->top++] = ref_x;
}

/* TODO: this can appear to hang if we're trying to print an enormous structure
 */

static shared_info *collect_shared_info(s7_scheme *sc, shared_info *ci, s7_pointer top)
{
  int i, ref = -1;

  /* look for top in current list */
  for (i = 0; i < ci->top; i++)
    if (ci->objs[i] == top)
      {
	if (ci->refs[i] == 0)
	  ci->refs[i] = ++ci->ref;  /* if found, set the ref number */
	ref = ci->refs[i];
	break;
      }

  if (ref == -1)
    {
      /* top not found -- add it to the list */
      check_shared_info_size(ci);
      ci->objs[ci->top++] = top;

      /* now search the rest of this structure */
      if (is_pair(top))
	{
	  if (has_structure(car(top)))
	    collect_shared_info(sc, ci, car(top));
	  if (has_structure(cdr(top)))
	    collect_shared_info(sc, ci, cdr(top));
	}
      else
	{
	  int i, plen;
	  plen = s7_vector_print_length(sc);
	  if (plen > vector_length(top))
	    plen = vector_length(top);
	  for (i = 0; i < plen; i++)
	    if (has_structure(vector_element(top, i)))
	      collect_shared_info(sc, ci, vector_element(top, i));
	}
    }
  return(ci);
}


static shared_info *new_shared_info(s7_scheme *sc)
{
  shared_info *ci;
  if (sc->circle_info == NULL)
    {
      ci = (shared_info *)calloc(1, sizeof(shared_info));
      ci->size = INITIAL_SHARED_INFO_SIZE;
      ci->objs = (s7_pointer *)malloc(ci->size * sizeof(s7_pointer));
      ci->refs = (int *)calloc(ci->size, sizeof(int));   /* finder expects 0 = unseen previously */
      sc->circle_info = ci;
    }
  else 
    {
      ci = sc->circle_info;
      memset((void *)(ci->refs), 0, ci->top * sizeof(int));
    }
  ci->top = 0;
  ci->ref = 0;
  return(ci);
}


static shared_info *make_shared_info(s7_scheme *sc, s7_pointer top)
{
  shared_info *ci;
  int i, refs;

  ci = new_shared_info(sc);

  /* collect all pointers associated with top */
  collect_shared_info(sc, ci, top);

  /* find if any were referenced twice */
  for (i = 0, refs = 0; i < ci->top; i++)
    if (ci->refs[i] > 0)
      {
	if (i == refs)
	  refs++;
	else
	  {
	    ci->objs[refs] = ci->objs[i];
	    ci->refs[refs++] = ci->refs[i];

	    ci->refs[i] = 0;
	    ci->objs[i] = NULL;
	  }
      }
  ci->top = refs;

  if (refs == 0)
    {
      free_shared_info(ci);
      return(NULL);
    }
  return(ci);
}



static char *vector_to_c_string(s7_scheme *sc, s7_pointer vect, bool to_file, shared_info *ci);
static char *hash_table_to_c_string(s7_scheme *sc, s7_pointer hash, bool to_file, shared_info *ci);
static char *list_to_c_string(s7_scheme *sc, s7_pointer lst, shared_info *ci);

static char *s7_object_to_c_string_1(s7_scheme *sc, s7_pointer obj, bool use_write, bool to_file, shared_info *ci)
{
  if (s7_is_vector(obj))
    return(vector_to_c_string(sc, obj, to_file, ci));

  if (s7_is_hash_table(obj))
    return(hash_table_to_c_string(sc, obj, to_file, ci));

  if (is_pair(obj))
    return(list_to_c_string(sc, obj, ci));

  return(atom_to_c_string(sc, obj, use_write));
}


static char *object_to_c_string_with_circle_check(s7_scheme *sc, s7_pointer vr, bool use_write, bool to_file, shared_info *ci)
{
  if (ci)
    {
      int ref;
      ref = shared_ref(ci, vr);
      if (ref != 0)
	{
	  char *name;
	  if (ref > 0)
	    {
	      char *element;
	      element = s7_object_to_c_string_1(sc, vr, USE_WRITE, WITH_ELLIPSES, ci);
	      name = (char *)calloc(strlen(element) + 32, sizeof(char));
	      sprintf(name, "#%d=%s", ref, element);
	      free(element);
	      return(name);
	    }
	  else
	    {
	      name = (char *)calloc(32, sizeof(char));
	      snprintf(name, 32, "#%d#", -ref);
	      return(name);
	    }
	}
    }
  return(s7_object_to_c_string_1(sc, vr, use_write, to_file, ci));
}


static char *vector_to_c_string(s7_scheme *sc, s7_pointer vect, bool to_file, shared_info *ci)
{
  s7_Int i, len, bufsize = 0;
  bool too_long = false;
  char **elements = NULL;
  char *buf;
  
  len = vector_length(vect);
  if (len == 0)
    {
      if (vector_is_multidimensional(vect))
	{
	  buf = (char *)calloc(16, sizeof(char));
	  snprintf(buf, 16, "#%dD()", vector_ndims(vect));
	  return(buf);
	}
      else return(copy_string("#()"));
    }
  
  if (!to_file)
    {
      int plen;
      /* if to_file we ignore *vector-print-length* so a subsequent read will be ok
       *
       * (with-output-to-file "test.test" 
       *   (lambda () 
       *     (let ((vect (make-vector (+ *vector-print-length* 2) 1.0))) 
       *       (write vect))))
       */

      plen = s7_vector_print_length(sc);
      if (plen <= 0)
	return(copy_string("#(...)"));

      if (len > plen)
	{
	  too_long = true;
	  len = plen;
	}
    }

  elements = (char **)malloc(len * sizeof(char *));
  for (i = 0; i < len; i++)
    {
      elements[i] = object_to_c_string_with_circle_check(sc, vector_element(vect, i), USE_WRITE, WITH_ELLIPSES, ci);
      bufsize += safe_strlen(elements[i]);
    }

  if (vector_is_multidimensional(vect))
    {
      char c;

      bufsize += (len * 4 * vector_ndims(vect) + 256);
      buf = (char *)malloc(bufsize * sizeof(char));

      c = '#';
      if (vector_ndims(vect) > 1)
	snprintf(buf, bufsize, "#%dD", vector_ndims(vect));
      else snprintf(buf, bufsize, "#");

      display_multivector(sc, vect, len, 0, 0, vector_ndims(vect), buf, elements, &c);

      for (i = 0; i < len; i++)
	free(elements[i]);
      free(elements);
      return(buf);
    }

  bufsize += (len * 4 + 256);                   /* might be 2 parens per element + space, so at least len*4 here */
  buf = (char *)malloc(bufsize * sizeof(char));

  sprintf(buf, "#(");
  for (i = 0; i < len - 1; i++)
    {
      if (elements[i])
	{
	  strcat(buf, elements[i]);
	  free(elements[i]);
	  strcat(buf, " ");
	}
    }

  if (elements[len - 1])
    {
      strcat(buf, elements[len - 1]);
      free(elements[len - 1]);
    }

  free(elements);
  if (too_long)
    strcat(buf, " ...");
  strcat(buf, ")");
  return(buf);
}


static s7_pointer vector_or_hash_table_to_string(s7_scheme *sc, s7_pointer vect)
{
  s7_pointer result;
  shared_info *ci = NULL;
  ci = make_shared_info(sc, vect);
  result = make_string_uncopied(sc, object_to_c_string_with_circle_check(sc, vect, USE_WRITE, WITH_ELLIPSES, ci));
  if (ci) free_shared_info(ci);
  return(result);
}


static int circular_list_entries(s7_pointer lst)
{
  int i;
  s7_pointer x;
  for (i = 1, x = cdr(lst); ; i++, x = cdr(x))
    {
      int j;
      s7_pointer y;
      for (y = lst, j = 0; j < i; y = cdr(y), j++)
	if (x == y)
	  return(i + 1);
    }
}


static char *list_to_c_string(s7_scheme *sc, s7_pointer lst, shared_info *ci)
{
  s7_pointer x;
  int i, len, true_len, bufsize = 0, start = 0;
  char **elements = NULL;
  char *buf;

  true_len = s7_list_length(sc, lst);
  if (true_len < 0)                    /* a dotted list -- handle cars, then final cdr */
    len = (-true_len + 1);
  else
    {
      if (true_len == 0)               /* either '() or a circular list */
	{
	  if (is_not_null(lst))
	    len = circular_list_entries(lst);
	  else return(copy_string("()"));
	}
      else len = true_len;
    }

  elements = (char **)calloc(len, sizeof(char *));

  for (x = lst, i = 0; (is_not_null(x)) && (i < len); i++, x = cdr(x))
    {
      if (is_pair(x))
	{
	  if ((ci) && (i != 0) && (peek_shared_ref(ci, x) != 0))
	    {
	      elements[i] = object_to_c_string_with_circle_check(sc, x, USE_WRITE, WITH_ELLIPSES, ci);
	      len = i + 1;
	      bufsize += safe_strlen(elements[i]);
	      break;
	    }
	  else elements[i] = object_to_c_string_with_circle_check(sc, car(x), USE_WRITE, WITH_ELLIPSES, ci);
	}
      else 
	{
	  elements[i] = object_to_c_string_with_circle_check(sc, x, USE_WRITE, WITH_ELLIPSES, ci);
	  len = i + 1;
	  bufsize += safe_strlen(elements[i]);
	  break;
	}
      bufsize += safe_strlen(elements[i]);
    }
  
  bufsize += (256 + len * 2); /* len spaces */
  if (ci) bufsize += (ci->top * 16);
  buf = (char *)malloc(bufsize * sizeof(char));
  
  if (((car(lst) == sc->QUOTE) || (car(lst) == sc->QUOTE_UNCHECKED)) &&
      (true_len == 2))                    
    {
      /* len == 1 is important, otherwise (list 'quote 1 2) -> '1 2 which looks weird 
       *   or (object->string (apply . `''1)) -> "'quote 1"
       * so (quote x) = 'x but (quote x y z) should be left alone (if evaluated, it's an error)
       *
       * in CL:
       *    [2]> (list 'quote 1 2)
       *    (QUOTE 1 2)
       *    [3]> (list 'quote 1)
       *    '1
       *    [4]> (cons 'quote 1)
       *    (QUOTE . 1)
       *
       * in s7:
       *    :(list 'quote 1 2)
       *    (quote 1 2)
       *    :(list 'quote 1)
       *    '1
       *    :(cons 'quote 1)
       *    (quote . 1)
       */
      sprintf(buf, "'");
      start = 1;
    }
  else sprintf(buf, "(");
  if (is_multiple_value(lst))
    strcat(buf, "values ");

  for (i = start; i < len - 1; i++)
    {
      if (elements[i])
	{
	  strcat(buf, elements[i]);
	  strcat(buf, " ");
	}
    }

  if (is_not_null(x))
    strcat(buf, ". ");

  if (elements[len - 1])
    {
      strcat(buf, elements[len - 1]);
      if (((car(lst) != sc->QUOTE) && (car(lst) != sc->QUOTE_UNCHECKED)) ||
	  (true_len != 2))
	strcat(buf, ")");
    }

  for (i = 0; i < len; i++)
    if (elements[i])
      free(elements[i]);
  free(elements);
  return(buf);
}


static s7_pointer list_as_string(s7_scheme *sc, s7_pointer lst)
{
  s7_pointer result;
  shared_info *ci;
  ci = make_shared_info(sc, lst);
  result = make_string_uncopied(sc, object_to_c_string_with_circle_check(sc, lst, USE_WRITE, WITH_ELLIPSES, ci));
  if (ci) free_shared_info(ci);
  return(result);
}


char *s7_object_to_c_string(s7_scheme *sc, s7_pointer obj)
{
  char *result;
  shared_info *ci = NULL;
  if (has_structure(obj))
    ci = make_shared_info(sc, obj);
  result = object_to_c_string_with_circle_check(sc, obj, USE_WRITE, WITH_ELLIPSES, ci);
  if (ci) free_shared_info(ci);
  return(result);
}


s7_pointer s7_object_to_string(s7_scheme *sc, s7_pointer obj, bool use_write)
{
  char *str;
  if ((s7_is_vector(obj)) ||
      (s7_is_hash_table(obj)))
    return(vector_or_hash_table_to_string(sc, obj));

  if (is_pair(obj))
    return(list_as_string(sc, obj));

  str = atom_to_c_string(sc, obj, use_write);
  if (str)
    return(make_string_uncopied(sc, str));
  return(s7_make_string_with_length(sc, "", 0)); 
  /* else segfault in (string->symbol (object->string "" #f))
   *   this can't be optimized to make_string_uncopied -- gc trouble (attempt to free unallocated pointer)
   */
}


void s7_newline(s7_scheme *sc, s7_pointer port)
{
  write_char(sc, '\n', port);
}


static s7_pointer g_newline(s7_scheme *sc, s7_pointer args)
{
  #define H_newline "(newline (port (current-output-port))) writes a carriage return to the port"
  s7_pointer port;
  
  if (is_not_null(args))
    {
      port = car(args);
      if (!is_output_port(port))
	return(s7_wrong_type_arg_error(sc, "newline", 0, port, "an output port"));
      if (port_is_closed(port))
	return(s7_wrong_type_arg_error(sc, "newline", 0, port, "an open output port"));
    }
  else port = sc->output_port;
  
  s7_newline(sc, port);
  return(sc->UNSPECIFIED);
}


void s7_write_char(s7_scheme *sc, int c, s7_pointer port)
{
  write_char(sc, c, port);
}


static s7_pointer g_write_char(s7_scheme *sc, s7_pointer args)
{
  #define H_write_char "(write-char char (port (current-output-port))) writes char to the output port"
  s7_pointer port;
  
  if (!s7_is_character(car(args)))
    return(s7_wrong_type_arg_error(sc, "write-char", (is_null(cdr(args))) ? 0 : 1, car(args), "a character"));
  
  if (is_pair(cdr(args)))
    {
      port = cadr(args);
      if (!is_output_port(port))
	return(s7_wrong_type_arg_error(sc, "write-char port", 2, port, "an output port"));
      if (port_is_closed(port))
	return(s7_wrong_type_arg_error(sc, "write-char port", 2, port, "an open output port"));
    }
  else port = sc->output_port;
  s7_write_char(sc, s7_character(car(args)), port);
  return(sc->UNSPECIFIED);
}


static void write_or_display(s7_scheme *sc, s7_pointer obj, s7_pointer port, bool use_write)
{
  char *val;
  shared_info *ci = NULL;
  if (has_structure(obj))
    ci = make_shared_info(sc, obj);
  val = object_to_c_string_with_circle_check(sc, obj, use_write, is_file_port(port), ci);
  write_string(sc, val, port);
  if (ci) free_shared_info(ci);
  if (val) free(val);
}


void s7_write(s7_scheme *sc, s7_pointer obj, s7_pointer port)
{
  write_or_display(sc, obj, port, USE_WRITE);
}


static s7_pointer g_write(s7_scheme *sc, s7_pointer args)
{
  #define H_write "(write str (port (current-output-port))) writes str (a string) to the output port"
  s7_pointer port;
  
  if (is_pair(cdr(args)))
    {
      port = cadr(args);
      if (!is_output_port(port))
	return(s7_wrong_type_arg_error(sc, "write port", 2, port, "an output port"));
      if (port_is_closed(port))
	return(s7_wrong_type_arg_error(sc, "write port", 2, port, "an open output port"));
    }
  else port = sc->output_port;
  write_or_display(sc, car(args), port, USE_WRITE);
  return(sc->UNSPECIFIED);
}


void s7_display(s7_scheme *sc, s7_pointer obj, s7_pointer port)
{
  write_or_display(sc, obj, port, USE_DISPLAY);
}


static s7_pointer g_display(s7_scheme *sc, s7_pointer args)
{
  #define H_display "(display str (port (current-output-port))) writes str (a string) to the output port"
  s7_pointer port;
  
  if (is_pair(cdr(args)))
    {
      port = cadr(args);
      if (!is_output_port(port))
	return(s7_wrong_type_arg_error(sc, "display port", 2, port, "an output port"));
      if (port_is_closed(port))
	return(s7_wrong_type_arg_error(sc, "display port", 2, port, "an open output port"));
    }
  else port = sc->output_port;
  write_or_display(sc, car(args), port, USE_DISPLAY);
  return(sc->UNSPECIFIED);
}


static s7_pointer g_read_byte(s7_scheme *sc, s7_pointer args)
{
  #define H_read_byte "(read-byte (port (current-input-port))): reads a byte from the input port"
  s7_pointer port;
  
  if (is_not_null(args))
    port = car(args);
  else port = sc->input_port;

  if (!is_input_port(port))
    return(s7_wrong_type_arg_error(sc, "read-byte", 0, port, "an input port"));
  if (port_is_closed(port))
    return(s7_wrong_type_arg_error(sc, "read-byte", 0, port, "an open input port"));

  if (is_string_port(port))
    {
      if ((!(port_string(port))) ||
	  (port_string_length(port) <= port_string_point(port)))
	return(sc->EOF_OBJECT);
      return(small_int((int)((unsigned char)(port_string(port)[port_string_point(port)++]))));
    }

  if (is_file_port(port))
    {
      int c;
      c = fgetc(port_file(port));
      if (c == EOF)
	return(sc->EOF_OBJECT);
      return(small_int((unsigned char)c)); 
    }

  return((*(port_input_function(port)))(sc, S7_READ_BYTE, port));
}


static s7_pointer g_write_byte(s7_scheme *sc, s7_pointer args)
{
  #define H_write_byte "(write-byte byte (port (current-output-port))): writes byte to the output port"
  s7_pointer port;
  
  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "write-byte", (is_null(cdr(args))) ? 0 : 1, car(args), "an integer"));
  
  if (is_pair(cdr(args)))
    port = cadr(args);
  else port = sc->output_port;
  if ((!is_output_port(port)) ||
      (is_string_port(port)))
    return(s7_wrong_type_arg_error(sc, "write-byte port", 2, port, "an output file or function port"));
  if (port_is_closed(port))
    return(s7_wrong_type_arg_error(sc, "write-byte port", 2, port, "an open output port"));

  if (is_file_port(port))
    {
      if (fputc((unsigned char)s7_integer(car(args)), port_file(port)) == EOF)
	fprintf(stderr, "write to %s: %s\n", port_filename(port), strerror(errno));
    }
  else (*(port_output_function(port)))(sc, (char)s7_integer(car(args)), port);

  return(car(args));
}


static s7_pointer g_call_with_output_string(s7_scheme *sc, s7_pointer args)
{
  #define H_call_with_output_string "(call-with-output-string proc) opens a string port applies proc to it, then returns the collected output"
  s7_pointer port;

  if (!is_procedure(car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-string", 1, car(args), "a procedure"));
  if ((is_continuation(car(args))) || is_goto(car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-string", 2, car(args), "a normal procedure (not a continuation)"));
  if (is_thunk(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-string", 2, car(args), "a procedure of one argument (the port)"));
  
  port = s7_open_output_string(sc);
  push_stack(sc, OP_UNWIND_OUTPUT, sc->F, port);
  push_stack(sc, OP_GET_OUTPUT_STRING, sc->F, port);
  push_stack(sc, OP_APPLY, list_1(sc, port), car(args));
  return(sc->F);
}


static s7_pointer g_call_with_output_file(s7_scheme *sc, s7_pointer args)
{
  #define H_call_with_output_file "(call-with-output-file filename proc) opens filename and calls proc with the output port as its argument"
  s7_pointer port;
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-file filename,", 1, car(args), "a string"));
  if (!is_procedure(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-file", 2, cadr(args), "a procedure"));
  if ((is_continuation(cadr(args))) || is_goto(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-file", 2, cadr(args), "a normal procedure (not a continuation)"));
  if (is_thunk(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "call-with-output-file", 2, car(args), "a procedure of one argument (the port)"));
  
  port = s7_open_output_file(sc, s7_string(car(args)), "w");
  push_stack(sc, OP_UNWIND_OUTPUT, sc->F, port);
  push_stack(sc, OP_APPLY, list_1(sc, port), cadr(args));
  return(sc->F);
}


static s7_pointer g_with_output_to_string(s7_scheme *sc, s7_pointer args)
{
  #define H_with_output_to_string "(with-output-to-string thunk) opens a string as a temporary current-output-port, calls thunk, then returns the collected output"
  s7_pointer old_output_port;

  if (!is_thunk(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "with-output-to-string", 1, car(args), "a thunk"));
  
  old_output_port = sc->output_port;
  sc->output_port = s7_open_output_string(sc);
  push_stack(sc, OP_UNWIND_OUTPUT, old_output_port, sc->output_port);
  push_stack(sc, OP_GET_OUTPUT_STRING, sc->F, sc->output_port);
  push_stack(sc, OP_APPLY, sc->NIL, car(args));
  return(sc->F);
}

/* (string-ref (with-output-to-string (lambda () (write "1234") (values (get-output-string) 1)))) */


static s7_pointer g_with_output_to_file(s7_scheme *sc, s7_pointer args)
{
  #define H_with_output_to_file "(with-output-to-file filename thunk) opens filename as the temporary current-output-port and calls thunk"
  s7_pointer old_output_port;
  
  if (!s7_is_string(car(args)))
    return(s7_wrong_type_arg_error(sc, "with-output-to-file filename,", 1, car(args), "a string"));
  if (!is_thunk(sc, cadr(args)))
    return(s7_wrong_type_arg_error(sc, "with-output-to-file", 2, cadr(args), "a thunk"));
  
  old_output_port = sc->output_port;
  sc->output_port = s7_open_output_file(sc, s7_string(car(args)), "w");
  push_stack(sc, OP_UNWIND_OUTPUT, old_output_port, sc->output_port);
  push_stack(sc, OP_APPLY, sc->NIL, cadr(args));
  return(sc->F);
}



/* -------------------------------- lists -------------------------------- */

s7_pointer s7_cons(s7_scheme *sc, s7_pointer a, s7_pointer b) 
{
  s7_pointer x;
  NEW_CELL(sc, x);
  car(x) = a;
  cdr(x) = b;
  set_type(x, T_PAIR);
  return(x);
}


static s7_pointer cons_unchecked(s7_scheme *sc, s7_pointer a, s7_pointer b) 
{
  s7_pointer x;
  NEW_CELL_NO_CHECK(sc, x); /* 5 11 8 */
  car(x) = a;
  cdr(x) = b;
  set_type(x, T_PAIR);
  return(x);
}


static s7_pointer permanent_cons(s7_pointer a, s7_pointer b, int type)
{
  /* for the symbol table which is never GC'd (and its contents aren't marked) */
  s7_pointer x;
  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;
  car(x) = a;
  cdr(x) = b;
  set_type(x, type);
  return(x);
}


bool s7_is_pair(s7_pointer p) 
{
  return(is_pair(p));
}


s7_pointer s7_car(s7_pointer p) {return(car(p));}
s7_pointer s7_cdr(s7_pointer p) {return(cdr(p));}

s7_pointer s7_cadr(s7_pointer p) {return(cadr(p));}
s7_pointer s7_cddr(s7_pointer p) {return(cddr(p));}
s7_pointer s7_cdar(s7_pointer p) {return(cdar(p));}
s7_pointer s7_caar(s7_pointer p) {return(caar(p));}

s7_pointer s7_caadr(s7_pointer p) {return(caadr(p));}
s7_pointer s7_caddr(s7_pointer p) {return(caddr(p));}
s7_pointer s7_cadar(s7_pointer p) {return(cadar(p));}
s7_pointer s7_caaar(s7_pointer p) {return(caaar(p));}
s7_pointer s7_cdadr(s7_pointer p) {return(cdadr(p));}
s7_pointer s7_cdddr(s7_pointer p) {return(cdddr(p));}
s7_pointer s7_cddar(s7_pointer p) {return(cddar(p));}
s7_pointer s7_cdaar(s7_pointer p) {return(cdaar(p));}

s7_pointer s7_caaadr(s7_pointer p) {return(caaadr(p));}
s7_pointer s7_caaddr(s7_pointer p) {return(caaddr(p));}
s7_pointer s7_caadar(s7_pointer p) {return(caadar(p));}
s7_pointer s7_caaaar(s7_pointer p) {return(caaaar(p));}
s7_pointer s7_cadadr(s7_pointer p) {return(cadadr(p));}
s7_pointer s7_cadddr(s7_pointer p) {return(cadddr(p));}
s7_pointer s7_caddar(s7_pointer p) {return(caddar(p));}
s7_pointer s7_cadaar(s7_pointer p) {return(cadaar(p));}

s7_pointer s7_cdaadr(s7_pointer p) {return(cdaadr(p));}
s7_pointer s7_cdaddr(s7_pointer p) {return(cdaddr(p));}
s7_pointer s7_cdadar(s7_pointer p) {return(cdadar(p));}
s7_pointer s7_cdaaar(s7_pointer p) {return(cdaaar(p));}
s7_pointer s7_cddadr(s7_pointer p) {return(cddadr(p));}
s7_pointer s7_cddddr(s7_pointer p) {return(cddddr(p));}
s7_pointer s7_cdddar(s7_pointer p) {return(cdddar(p));}
s7_pointer s7_cddaar(s7_pointer p) {return(cddaar(p));}


s7_pointer s7_set_car(s7_pointer p, s7_pointer q) 
{ 
  car(p) = q;
  return(p);
}


s7_pointer s7_set_cdr(s7_pointer p, s7_pointer q) 
{ 
  cdr(p) = q;
  return(p);
}


s7_pointer s7_list_ref(s7_scheme *sc, s7_pointer lst, int num)
{
  int i;
  s7_pointer x;

  for (x = lst, i = 0; (i < num) && (is_pair(x)); i++, x = cdr(x)) {}
  if ((i == num) && (is_pair(x)))
    return(car(x));

  return(sc->NIL);
}


s7_pointer s7_list_set(s7_scheme *sc, s7_pointer lst, int num, s7_pointer val)
{
  int i;
  s7_pointer x;

  for (x = lst, i = 0; (i < num) && (is_pair(x)); i++, x = cdr(x)) {}
  if ((i == num) &&
      (is_pair(x)))
    car(x) = val;

  return(val);
}


static void list_set(s7_scheme *sc, s7_pointer lst, int num, s7_pointer val)
{
  /* internal form where we know the list is ok */
  int i;
  s7_pointer x;
  for (x = lst, i = 0; i < num; i++, x = cdr(x)) {}
  car(x) = val;
}


s7_pointer s7_member(s7_scheme *sc, s7_pointer sym, s7_pointer lst)
{
  s7_pointer x;

  for (x = lst; is_pair(x); x = cdr(x))
    if (s7_is_equal(sc, sym, car(x)))
      return(x);

  return(sc->F);
}


static bool symbol_is_in_list(s7_pointer sym, s7_pointer lst)
{
  s7_pointer x;
  for (x = lst; is_pair(x); x = cdr(x))
    if (is_pair(car(x)))
      {
	if (sym == caar(x))
	  return(true);
      }
    else 
      {
	if (sym == car(x))
	  return(true);
      }
  if (sym == x)
    return(true);

  return(false);
}


s7_pointer s7_assoc(s7_scheme *sc, s7_pointer sym, s7_pointer lst)
{
  s7_pointer x;

  for (x = lst; is_pair(x); x = cdr(x))
    if ((is_pair(s7_car(x))) &&
	(s7_is_equal(sc, sym, car(car(x)))))
      return(car(x));

  return(sc->F);
}


s7_pointer s7_reverse(s7_scheme *sc, s7_pointer a) 
{
  /* reverse list -- produce new list (other code assumes this function does not return the original!) */
  s7_pointer x, p;

  if (is_null(a)) return(a);

  if (!is_pair(cdr(a)))
    {
      if (is_not_null(cdr(a)))
	return(cons(sc, cdr(a), car(a)));
      return(cons(sc, car(a), sc->NIL)); /* don't return 'a' itself */
    }

  sc->w = list_1(sc, car(a));

  for (x = cdr(a), p = a; is_pair(x); x = cdr(x), p = cdr(p))
    {
      sc->w = cons(sc, car(x), sc->w);
      if (is_pair(cdr(x)))
	{
	  x = cdr(x);
	  sc->w = cons(sc, car(x), sc->w);
	}
      if (x == p) /* this can take awhile to notice there's a cycle, but what does the caller expect? */
	break;
    }

  if (is_not_null(x))
    p = cons(sc, x, sc->w);    /* ?? this means that (reverse '(1 2 . 3)) returns '(3 2 1) -- we used to return '() here */
  else p = sc->w;

  sc->w = sc->NIL;
  return(p);
}

/* s7_reverse sometimes tacks extra nodes on the end of a reversed circular list (it detects the cycle too late) 
 *  (let ((lst (list 0))) (set! (cdr lst) lst) (reverse lst)) -> (#1=(0 . #1#) 0 0 0)
 */


static s7_pointer reverse_in_place(s7_scheme *sc, s7_pointer term, s7_pointer list) 
{
  s7_pointer p = list, result = term, q;

  while (is_not_null(p))
    {
      q = cdr(p);
      if ((!is_pair(q)) &&
	  (is_not_null(q)))
	return(sc->NIL); /* improper list? */
      cdr(p) = result;
      result = p;
      p = q;
    }

  return(result);
}


static s7_pointer safe_reverse_in_place_via_ecdr(s7_scheme *sc, s7_pointer list)
{
  s7_pointer p = list, result, q;
  result = sc->NIL;

  while (is_not_null(p))
    {
      q = ecdr(p);
      ecdr(p) = result;
      result = p;
      p = q;
    }
  return(result);
}


static s7_pointer safe_reverse_in_place(s7_scheme *sc, s7_pointer list) /* "safe" here means we guarantee this list is unproblematic */
{
  s7_pointer p = list, result, q;
  result = sc->NIL;

  while (is_not_null(p))
    {
      q = cdr(p);
      /*   also if (is_null(list)) || (is_null(cdr(list))) return(list) */
      cdr(p) = result;
      result = p;
      p = q;

      /* unroll the loop for speed */
      if (is_null(p)) break;
      q = cdr(p);
      cdr(p) = result;
      result = p;
      p = q;

      if (is_null(p)) break;
      q = cdr(p);
      cdr(p) = result;
      result = p;
      p = q;

      if (is_null(p)) break;
      q = cdr(p);
      cdr(p) = result;
      result = p;
      p = q;
    }

  return(result);
}


/* is this correct? (let ((x (list 1 2))) (eq? x (append '() x))) -> #t
 */

s7_pointer s7_append(s7_scheme *sc, s7_pointer a, s7_pointer b) 
{
  s7_pointer p = b, q;
  
  if (is_not_null(a)) 
    {
      a = s7_reverse(sc, a);
      while (is_not_null(a)) 
	{
	  q = cdr(a);
	  cdr(a) = p;
	  p = a;
	  a = q;
	}
    }
  return(p);
}


static s7_pointer revappend(s7_scheme *sc, s7_pointer a, s7_pointer b) 
{
  /* (map (lambda (x) (if (odd? x) (apply values '(1 2 3)) (values))) (list 1 2 3 4)) 
   *   is a bad case -- we have to copy the incoming list.
   */
   
  s7_pointer p = b, q;
  
  if (is_not_null(a)) 
    {
      a = copy_list(sc, a); 
      while (is_not_null(a)) 
	{
	  q = cdr(a);
	  cdr(a) = p;
	  p = a;
	  a = q;
	}
    }
  return(p);
}

static int safe_list_length(s7_scheme *sc, s7_pointer a)
{
  /* assume that "a" is a proper list */
  int i = 0;
  s7_pointer b;
  for (b = a; is_not_null(b); i++, b = cdr(b)) {};
  return(i);
}


int s7_list_length(s7_scheme *sc, s7_pointer a) 
{
  /* returns -len if list is dotted, 0 if it's (directly) circular */
  int i;
  s7_pointer slow, fast;

  slow = fast = a;
  for (i = 0; ; i += 2)
    {
      if (!is_pair(fast))
	{
	  if (is_null(fast))
	    return(i);
	  return(-i);
	}
      
      fast = cdr(fast);
      if (!is_pair(fast)) 
	{
	  if (is_null(fast))
	    return(i + 1);
	  return(-i - 1);
	}
      /* if unrolled further, it's a lot slower? */
      
      fast = cdr(fast);
      slow = cdr(slow);
      if (fast == slow) 
	return(0);
    }
  return(0);
}


static s7_pointer g_is_null(s7_scheme *sc, s7_pointer args)
{
  #define H_is_null "(null? obj) returns #t if obj is the empty list"
  return(make_boolean(sc, is_null(car(args))));

  /* as a generic this could be: has_structure and length == 0 */
}


static s7_pointer g_is_pair(s7_scheme *sc, s7_pointer args)
{
  #define H_is_pair "(pair? obj) returns #t if obj is a pair (a non-empty list)"
  return(make_boolean(sc, is_pair(car(args))));
}


bool s7_is_list(s7_scheme *sc, s7_pointer p)
{
  return((is_pair(p)) ||
	 (is_null(p)));
}


static bool is_proper_list(s7_scheme *sc, s7_pointer lst)
{
  s7_pointer slow, fast;

  slow = fast = lst;
  while (true)
    {
      if (!is_pair(fast)) 
	return(is_null(fast)); /* else it's an improper list */

      fast = cdr(fast);
      if (!is_pair(fast)) 
	return(is_null(fast));

      fast = cdr(fast);
      slow = cdr(slow);
      if (fast == slow) 
	return(false);
    }
  return(true);
}


static s7_pointer g_is_list(s7_scheme *sc, s7_pointer args)
{
  #define H_is_list "(list? obj) returns #t if obj is a proper list"
  return(make_boolean(sc, is_proper_list(sc, car(args))));
}


#define MAX_LIST_LENGTH 1073741824

static s7_pointer g_make_list(s7_scheme *sc, s7_pointer args)
{
  #define H_make_list "(make-list length (initial-element #f)) returns a list of 'length' elements whose value is 'initial-element'."

  s7_pointer init, p;
  int i, ilen;
  s7_Int len;

  if (!s7_is_integer(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-list", (is_null(cdr(args))) ? 0 : 1, car(args), "an integer"));

  len = s7_integer(car(args));            /* needs to be s7_Int here so that (make-list most-negative-fixnum) is handled correctly */
  if (len < 0)
    return(s7_out_of_range_error(sc, "make-list length,", (is_null(cdr(args))) ? 0 : 1, car(args), "should be non-negative"));
  if (len == 0) return(sc->NIL);          /* what about (make-list 0 123)? */
  if (len > MAX_LIST_LENGTH)
    return(s7_out_of_range_error(sc, "make-list length,", (is_null(cdr(args))) ? 0 : 1, car(args), "should be a reasonable integer"));

  if (is_pair(cdr(args)))
    init = cadr(args);
  else init = sc->F;

  sc->w = sc->NIL;
  ilen = (int)len;

  if (len < (sc->free_heap_top - sc->free_heap))
    {
      sc->w = cons(sc, init, sc->NIL);
      for (i = 1; i < ilen; i++)
	sc->w = cons_unchecked(sc, init, sc->w);
    }
  else
    {
      for (i = 0; i < ilen; i++)
	sc->w = cons(sc, init, sc->w);
    }
  p = sc->w;
  sc->w = sc->NIL;

  return(p);
}


static s7_pointer list_ref_1(s7_scheme *sc, s7_pointer lst, s7_pointer ind)
{
  s7_Int i, index;
  s7_pointer p;

  if (!s7_is_integer(ind))
    return(s7_wrong_type_arg_error(sc, "list-ref index,", 2, ind, "an integer"));
  
  index = s7_integer(ind);
  if (index < 0)
    return(s7_out_of_range_error(sc, "list-ref index,", 2, ind, "should be non-negative"));
  if (index > MAX_LIST_LENGTH)
    return(s7_out_of_range_error(sc, "list-ref index,", 2, ind, "should be a reasonable integer"));
  
  for (i = 0, p = lst; (i < index) && is_pair(p); i++, p = cdr(p)) {}
  
  if (!is_pair(p))
    {
      if (is_null(p))
	return(s7_out_of_range_error(sc, "list-ref index,", 2, ind, "should be less than list length"));
      return(s7_wrong_type_arg_error(sc, "list-ref", 1, lst, "a proper list"));
    }
  return(car(p));
}


static s7_pointer g_list_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_list_ref "(list-ref lst i ...) returns the i-th element (0-based) of the list"
  
  /* (let ((L '((1 2 3) (4 5 6)))) (list-ref L 1 2)) 

    (define (lref L . args) 
      (if (null? (cdr args))
          (list-ref L (car args))
          (apply lref (list-ref L (car args)) (cdr args))))
  */

  s7_pointer lst, inds;
  lst = car(args);

  inds = cdr(args);
  while (true)
    {
      if (!is_pair(lst))
	return(s7_wrong_type_arg_error(sc, "list-ref", 1, lst, "a pair"));

      if (is_null(cdr(inds)))
	return(list_ref_1(sc, lst, car(inds)));
      lst = list_ref_1(sc, lst, car(inds));
      inds = cdr(inds);
    }
}


static s7_pointer g_list_set_1(s7_scheme *sc, s7_pointer lst, s7_pointer args, int arg_num)
{
  #define H_list_set "(list-set! lst i ... val) sets the i-th element (0-based) of the list to val"
  
  int i;
  s7_Int index;
  s7_pointer p, ind;

  /* (let ((L '((1 2 3) (4 5 6)))) (list-set! L 1 2 32) L) */
  if (!is_pair(lst))
    return(s7_wrong_type_arg_error(sc, "list-set!", 1, lst, "a pair"));

  ind = car(args);
  if (!s7_is_integer(ind))
    return(s7_wrong_type_arg_error(sc, "list-set! index,", arg_num, ind, "an integer"));
  
  index = s7_integer(ind);
  if (index < 0)
    return(s7_out_of_range_error(sc, "list-set!", arg_num, ind, "index should be non-negative"));
  if (index > MAX_LIST_LENGTH)
    return(s7_out_of_range_error(sc, "list-set! index,", arg_num, ind, "should be a reasonable integer"));
  
  for (i = 0, p = lst; (i < index) && is_pair(p); i++, p = cdr(p)) {}
  
  if (!is_pair(p))
    {
      if (is_null(p))
	return(s7_out_of_range_error(sc, "list-set! index,", arg_num, ind, "should be less than list length"));
      return(s7_wrong_type_arg_error(sc, "list-set!", 1, lst, "a proper list"));
    }
  if (is_null(cddr(args)))
    car(p) = cadr(args);
  else return(g_list_set_1(sc, car(p), cdr(args), arg_num + 1));
  return(cadr(args));
}


static s7_pointer g_list_set(s7_scheme *sc, s7_pointer args)
{
  /* fprintf(stderr, "list set: %s\n", s7_object_to_c_string(sc, args)); */
  return(g_list_set_1(sc, car(args), cdr(args), 2));
}


static s7_pointer g_list_tail(s7_scheme *sc, s7_pointer args)
{
  #define H_list_tail "(list-tail lst i) returns the list from the i-th element on"
  
  int i;
  s7_Int index;
  s7_pointer p;

  if (!s7_is_list(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "list-tail", 1, car(args), "a list"));
  if (!s7_is_integer(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "list-tail", 2, cadr(args), "an integer"));
  
  index = s7_integer(cadr(args));
  if (index < 0)
    return(s7_out_of_range_error(sc, "list-tail index,", 2, cadr(args), "should be non-negative"));
  if (index > MAX_LIST_LENGTH)
    return(s7_out_of_range_error(sc, "list-tail index,", 2, cadr(args), "should be a reasonable integer"));
  
  for (i = 0, p = car(args); (i < index) && (is_pair(p)); i++, p = cdr(p)) {}
  
  if (i < index)
    return(s7_out_of_range_error(sc, "list-tail", 2, cadr(args), "index should be less than list length"));

  /* I guess this would make sense with more than one index, but I'm not sure it's very important */
  
  return(p);
}


static s7_pointer g_car(s7_scheme *sc, s7_pointer args)
{
  #define H_car "(car pair) returns the first element of the pair"
  if (!is_pair(car(args))) return(s7_wrong_type_arg_error(sc, "car", 0, car(args), "a pair"));
  
  return(caar(args));
}


static s7_pointer g_cdr(s7_scheme *sc, s7_pointer args)
{
  #define H_cdr "(cdr pair) returns the second element of the pair"
  if (!is_pair(car(args))) return(s7_wrong_type_arg_error(sc, "cdr", 0, car(args), "a pair"));
  
  return(cdar(args));
}


static s7_pointer g_cons(s7_scheme *sc, s7_pointer args)
{
  /* n-ary cons could be the equivalent of CL's list*? */
  /*   it would be neater to have a single cons cell able to contain (directly) any number of elements */
  /*   (set! (cadr (cons 1 2 3)) 4) -> (1 4 . 3) */

  #define H_cons "(cons a b) returns a pair containing a and b"
  
  /* cdr(args) = cadr(args);
   * this is not safe -- it changes a variable's value directly:
   *   (let ((lst (list 1 2))) (list (apply cons lst) lst)) -> '((1 . 2) (1 . 2))
   */
  s7_pointer x;

  NEW_CELL(sc, x);
  car(x) = car(args);
  cdr(x) = cadr(args);
  set_type(x, T_PAIR);
  return(x);
}


static s7_pointer g_set_car(s7_scheme *sc, s7_pointer args)
{
  #define H_set_car "(set-car! pair val) sets the pair's first element to val"
  
  if (!is_pair(car(args)))  
    return(s7_wrong_type_arg_error(sc, "set-car!", 1, car(args), "a pair"));
  
  caar(args) = cadr(args);
  return(cadr(args));
}


static s7_pointer g_set_cdr(s7_scheme *sc, s7_pointer args)
{
  #define H_set_cdr "(set-cdr! pair val) sets the pair's second element to val"
  
  if (!is_pair(car(args))) 
    return(s7_wrong_type_arg_error(sc, "set-cdr!", 1, car(args), "a pair"));
  
  cdar(args) = cadr(args);
  return(cadr(args));
}


static s7_pointer g_caar(s7_scheme *sc, s7_pointer args)
{
  #define H_caar "(caar lst) returns (car (car lst)): (caar '((1 2))) -> 1"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "caar", 0, lst, "a list whose car is also a list"));

 return(car(car(lst)));
}

static s7_pointer g_cadr(s7_scheme *sc, s7_pointer args)
{
  #define H_cadr "(cadr lst) returns (car (cdr lst)): (cadr '(1 2 3)) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cadr", 0, lst, "a list whose cdr is also a list"));

  return(car(cdr(lst)));
}


static s7_pointer g_cdar(s7_scheme *sc, s7_pointer args)
{
  #define H_cdar "(cdar lst) returns (cdr (car lst)): (cdar '((1 2 3))) -> '(2 3)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cdar", 0, lst, "a list whose car is also a list"));

  return(cdr(car(lst)));
}


static s7_pointer g_cddr(s7_scheme *sc, s7_pointer args)
{
  #define H_cddr "(cddr lst) returns (cdr (cdr lst)): (cddr '(1 2 3 4)) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cddr", 0, lst, "a list whose cdr is also a list"));

  return(cdr(cdr(lst)));
}


static s7_pointer g_caaar(s7_scheme *sc, s7_pointer args)
{
  #define H_caaar "(caaar lst) returns (car (car (car lst))): (caaar '(((1 2)))) -> 1"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "caaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(car(car(lst)))) return(s7_wrong_type_arg_error(sc, "caaar", 0, lst, "a list whose caar is also a list"));

  return(car(car(car(lst))));
}


static s7_pointer g_caadr(s7_scheme *sc, s7_pointer args)
{
  #define H_caadr "(caadr lst) returns (car (car (cdr lst))): (caadr '(1 (2 3))) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "caadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(car(cdr(lst)))) return(s7_wrong_type_arg_error(sc, "caadr", 0, lst, "a list whose cadr is also a list"));

  return(car(car(cdr(lst))));
}


static s7_pointer g_cadar(s7_scheme *sc, s7_pointer args)
{
  #define H_cadar "(cadar lst) returns (car (cdr (car lst))): (cadar '((1 2 3))) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cadar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cadar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdr(car(lst)))) return(s7_wrong_type_arg_error(sc, "cadar", 0, lst, "a list whose cdar is also a list"));

  return(car(cdr(car(lst))));
}


static s7_pointer g_cdaar(s7_scheme *sc, s7_pointer args)
{
  #define H_cdaar "(cdaar lst) returns (cdr (car (car lst))): (cdaar '(((1 2 3)))) -> '(2 3)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cdaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(car(car(lst)))) return(s7_wrong_type_arg_error(sc, "cdaar", 0, lst, "a list whose caar is also a list"));

  return(cdr(car(car(lst))));
}


static s7_pointer g_caddr(s7_scheme *sc, s7_pointer args)
{
  #define H_caddr "(caddr lst) returns (car (cdr (cdr lst))): (caddr '(1 2 3 4)) -> 3"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "caddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cdr(cdr(lst)))) return(s7_wrong_type_arg_error(sc, "caddr", 0, lst, "a list whose cddr is also a list"));

  return(car(cdr(cdr(lst))));
}


static s7_pointer g_cdddr(s7_scheme *sc, s7_pointer args)
{
  #define H_cdddr "(cdddr lst) returns (cdr (cdr (cdr lst))): (cdddr '(1 2 3 4)) -> '(4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cdddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cdr(cdr(lst)))) return(s7_wrong_type_arg_error(sc, "cdddr", 0, lst, "a list whose cddr is also a list"));

  return(cdr(cdr(cdr(lst))));
}


static s7_pointer g_cdadr(s7_scheme *sc, s7_pointer args)
{
  #define H_cdadr "(cdadr lst) returns (cdr (car (cdr lst))): (cdadr '(1 (2 3 4))) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cdadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(car(cdr(lst)))) return(s7_wrong_type_arg_error(sc, "cdadr", 0, lst, "a list whose cadr is also a list"));

  return(cdr(car(cdr(lst))));
}


static s7_pointer g_cddar(s7_scheme *sc, s7_pointer args)
{
  #define H_cddar "(cddar lst) returns (cdr (cdr (car lst))): (cddar '((1 2 3 4))) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cddar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cddar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdr(car(lst)))) return(s7_wrong_type_arg_error(sc, "cddar", 0, lst, "a list whose cdar is also a list"));

  return(cdr(cdr(car(lst))));
}


static s7_pointer g_caaaar(s7_scheme *sc, s7_pointer args)
{
  #define H_caaaar "(caaaar lst) returns (car (car (car (car lst)))): (caaaar '((((1 2))))) -> 1"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caaaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "caaaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(caar(lst))) return(s7_wrong_type_arg_error(sc, "caaaar", 0, lst, "a list whose caar is also a list"));
  if (!is_pair(caaar(lst))) return(s7_wrong_type_arg_error(sc, "caaaar", 0, lst, "a list whose caaar is also a list"));

  return(car(car(car(car(lst)))));
}


static s7_pointer g_caaadr(s7_scheme *sc, s7_pointer args)
{
  #define H_caaadr "(caaadr lst) returns (car (car (car (cdr lst)))): (caaadr '(1 ((2 3)))) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caaadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "caaadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cadr(lst))) return(s7_wrong_type_arg_error(sc, "caaadr", 0, lst, "a list whose cadr is also a list"));
  if (!is_pair(caadr(lst))) return(s7_wrong_type_arg_error(sc, "caaadr", 0, lst, "a list whose caadr is also a list"));

  return(car(car(car(cdr(lst)))));
}


static s7_pointer g_caadar(s7_scheme *sc, s7_pointer args)
{
  #define H_caadar "(caadar lst) returns (car (car (cdr (car lst)))): (caadar '((1 (2 3)))) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caadar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "caadar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdar(lst))) return(s7_wrong_type_arg_error(sc, "caadar", 0, lst, "a list whose cdar is also a list"));
  if (!is_pair(cadar(lst))) return(s7_wrong_type_arg_error(sc, "caadar", 0, lst, "a list whose cadar is also a list"));

  return(car(car(cdr(car(lst)))));
}


static s7_pointer g_cadaar(s7_scheme *sc, s7_pointer args)
{
  #define H_cadaar "(cadaar lst) returns (car (cdr (car (car lst)))): (cadaar '(((1 2 3)))) -> 2"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cadaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cadaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(caar(lst))) return(s7_wrong_type_arg_error(sc, "cadaar", 0, lst, "a list whose caar is also a list"));
  if (!is_pair(cdaar(lst))) return(s7_wrong_type_arg_error(sc, "cadaar", 0, lst, "a list whose cdaar is also a list"));

  return(car(cdr(car(car(lst)))));
}


static s7_pointer g_caaddr(s7_scheme *sc, s7_pointer args)
{
  #define H_caaddr "(caaddr lst) returns (car (car (cdr (cdr lst)))): (caaddr '(1 2 (3 4))) -> 3"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caaddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "caaddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cddr(lst))) return(s7_wrong_type_arg_error(sc, "caaddr", 0, lst, "a list whose cddr is also a list"));
  if (!is_pair(caddr(lst))) return(s7_wrong_type_arg_error(sc, "caaddr", 0, lst, "a list whose caddr is also a list"));

  return(car(car(cdr(cdr(lst)))));
}


static s7_pointer g_cadddr(s7_scheme *sc, s7_pointer args)
{
  #define H_cadddr "(cadddr lst) returns (car (cdr (cdr (cdr lst)))): (cadddr '(1 2 3 4 5)) -> 4"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cadddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cadddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cddr(lst))) return(s7_wrong_type_arg_error(sc, "cadddr", 0, lst, "a list whose cddr is also a list"));
  if (!is_pair(cdddr(lst))) return(s7_wrong_type_arg_error(sc, "cadddr", 0, lst, "a list whose cdddr is also a list"));

  return(car(cdr(cdr(cdr(lst)))));
}


static s7_pointer g_cadadr(s7_scheme *sc, s7_pointer args)
{
  #define H_cadadr "(cadadr lst) returns (car (cdr (car (cdr lst)))): (cadadr '(1 (2 3 4))) -> 3"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cadadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cadadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cadr(lst))) return(s7_wrong_type_arg_error(sc, "cadadr", 0, lst, "a list whose cadr is also a list"));
  if (!is_pair(cdadr(lst))) return(s7_wrong_type_arg_error(sc, "cadadr", 0, lst, "a list whose cdadr is also a list"));

  return(car(cdr(car(cdr(lst)))));
}


static s7_pointer g_caddar(s7_scheme *sc, s7_pointer args)
{
  #define H_caddar "(caddar lst) returns (car (cdr (cdr (car lst)))): (caddar '((1 2 3 4))) -> 3"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "caddar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "caddar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdar(lst))) return(s7_wrong_type_arg_error(sc, "caddar", 0, lst, "a list whose cdar is also a list"));
  if (!is_pair(cddar(lst))) return(s7_wrong_type_arg_error(sc, "caddar", 0, lst, "a list whose cddar is also a list"));

  return(car(cdr(cdr(car(lst)))));
}


static s7_pointer g_cdaaar(s7_scheme *sc, s7_pointer args)
{
  #define H_cdaaar "(cdaaar lst) returns (cdr (car (car (car lst)))): (cdaaar '((((1 2 3))))) -> '(2 3)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdaaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cdaaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(caar(lst))) return(s7_wrong_type_arg_error(sc, "cdaaar", 0, lst, "a list whose caar is also a list"));
  if (!is_pair(caaar(lst))) return(s7_wrong_type_arg_error(sc, "cdaaar", 0, lst, "a list whose caaar is also a list"));

  return(cdr(car(car(car(lst)))));
}


static s7_pointer g_cdaadr(s7_scheme *sc, s7_pointer args)
{
  #define H_cdaadr "(cdaadr lst) returns (cdr (car (car (cdr lst)))): (cdaadr '(1 ((2 3 4)))) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdaadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cdaadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cadr(lst))) return(s7_wrong_type_arg_error(sc, "cdaadr", 0, lst, "a list whose cadr is also a list"));
  if (!is_pair(caadr(lst))) return(s7_wrong_type_arg_error(sc, "cdaadr", 0, lst, "a list whose caadr is also a list"));

  return(cdr(car(car(cdr(lst)))));
}


static s7_pointer g_cdadar(s7_scheme *sc, s7_pointer args)
{
  #define H_cdadar "(cdadar lst) returns (cdr (car (cdr (car lst)))): (cdadar '((1 (2 3 4)))) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdadar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cdadar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdar(lst))) return(s7_wrong_type_arg_error(sc, "cdadar", 0, lst, "a list whose cdar is also a list"));
  if (!is_pair(cadar(lst))) return(s7_wrong_type_arg_error(sc, "cdadar", 0, lst, "a list whose cadar is also a list"));

  return(cdr(car(cdr(car(lst)))));
}


static s7_pointer g_cddaar(s7_scheme *sc, s7_pointer args)
{
  #define H_cddaar "(cddaar lst) returns (cdr (cdr (car (car lst)))): (cddaar '(((1 2 3 4)))) -> '(3 4)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cddaar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cddaar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(caar(lst))) return(s7_wrong_type_arg_error(sc, "cddaar", 0, lst, "a list whose caar is also a list"));
  if (!is_pair(cdaar(lst))) return(s7_wrong_type_arg_error(sc, "cddaar", 0, lst, "a list whose cdaar is also a list"));

  return(cdr(cdr(car(car(lst)))));
}


static s7_pointer g_cdaddr(s7_scheme *sc, s7_pointer args)
{
  #define H_cdaddr "(cdaddr lst) returns (cdr (car (cdr (cdr lst)))): (cdaddr '(1 2 (3 4 5))) -> '(4 5)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdaddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cdaddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cddr(lst))) return(s7_wrong_type_arg_error(sc, "cdaddr", 0, lst, "a list whose cddr is also a list"));
  if (!is_pair(caddr(lst))) return(s7_wrong_type_arg_error(sc, "cdaddr", 0, lst, "a list whose caddr is also a list"));

  return(cdr(car(cdr(cdr(lst)))));
}


static s7_pointer g_cddddr(s7_scheme *sc, s7_pointer args)
{
  #define H_cddddr "(cddddr lst) returns (cdr (cdr (cdr (cdr lst)))): (cddddr '(1 2 3 4 5)) -> '(5)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cddddr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cddddr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cddr(lst))) return(s7_wrong_type_arg_error(sc, "cddddr", 0, lst, "a list whose cddr is also a list"));
  if (!is_pair(cdddr(lst))) return(s7_wrong_type_arg_error(sc, "cddddr", 0, lst, "a list whose cdddr is also a list"));

  return(cdr(cdr(cdr(cdr(lst)))));
}


static s7_pointer g_cddadr(s7_scheme *sc, s7_pointer args)
{
  #define H_cddadr "(cddadr lst) returns (cdr (cdr (car (cdr lst)))): (cddadr '(1 (2 3 4 5))) -> '(4 5)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cddadr", 0, lst, "a pair"));
  if (!is_pair(cdr(lst))) return(s7_wrong_type_arg_error(sc, "cddadr", 0, lst, "a list whose cdr is also a list"));
  if (!is_pair(cadr(lst))) return(s7_wrong_type_arg_error(sc, "cddadr", 0, lst, "a list whose cadr is also a list"));
  if (!is_pair(cdadr(lst))) return(s7_wrong_type_arg_error(sc, "cddadr", 0, lst, "a list whose cdadr is also a list"));

  return(cdr(cdr(car(cdr(lst)))));
}


static s7_pointer g_cdddar(s7_scheme *sc, s7_pointer args)
{
  #define H_cdddar "(cdddar lst) returns (cdr (cdr (cdr (car lst)))): (cdddar '((1 2 3 4 5))) -> '(4 5)"
  s7_pointer lst = car(args);

  if (!is_pair(lst)) return(s7_wrong_type_arg_error(sc, "cdddar", 0, lst, "a pair"));
  if (!is_pair(car(lst))) return(s7_wrong_type_arg_error(sc, "cdddar", 0, lst, "a list whose car is also a list"));
  if (!is_pair(cdar(lst))) return(s7_wrong_type_arg_error(sc, "cdddar", 0, lst, "a list whose cdar is also a list"));
  if (!is_pair(cddar(lst))) return(s7_wrong_type_arg_error(sc, "cdddar", 0, lst, "a list whose cddar is also a list"));

  return(cdr(cdr(cdr(car(lst)))));
}


/* reverse is in the generic function section */
static s7_pointer g_reverse_in_place(s7_scheme *sc, s7_pointer args)
{
  #define H_reverse_in_place "(reverse! lst) reverses lst in place"
  s7_pointer p, np;
  
  p = car(args);
  if (is_null(p))
    return(sc->NIL);
  
  if (!is_pair(p))
    return(s7_wrong_type_arg_error(sc, "reverse!", 0, p, "a list"));
  
  np = reverse_in_place(sc, sc->NIL, p);
  if (is_null(np))
    return(s7_wrong_type_arg_error(sc, "reverse!", 0, p, "a proper list"));
  
  return(np);
}


static s7_pointer g_assq(s7_scheme *sc, s7_pointer args)
{
  #define H_assq "(assq obj alist) returns the key-value pair associated (via eq?) with the key obj in the association list alist"
  /* this version accepts any kind of list 
   *   my little essay: the scheme standard should not unnecessarily restrict the kinds of arguments
   *                    a function can take (such as saying memq only accepts proper lists).  It is
   *                    trivial for the programmer to add such a check to a built-in function, but
   *                    not trivial to re-invent the built-in function with that restriction removed.
   *                    If some structure exists as a normal scheme object (a dotted or circular list),
   *                    every built-in function should be able to deal with it, if it makes sense at all.
   */

  s7_pointer x, y, obj;

  x = cadr(args);
  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "assq", 2, x, "a list"));
    }
  y = x;
  obj = car(args);

  while (true)
    {
      /* we can blithely take the car of anything, since we're not treating it as an object,
       *   then if we get a bogus match, the following check that caar made sense ought to catch it.
       */
      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      y = cdr(y);
      if (x == y) return(sc->F);
    }
  return(sc->F); /* not reached */
}


static s7_pointer g_assv(s7_scheme *sc, s7_pointer args)
{
  #define H_assv "(assv obj alist) returns the key-value pair associated (via eqv?) with the key obj in the association list alist"
  s7_pointer x, y, obj;

  x = cadr(args);
  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "assv", 2, x, "a list"));
    }
  y = x;
  obj = car(args);

  while (true)
    {
      /* here we can't play the assq == game because s7_is_eqv thinks it's getting a legit s7 object */
      if ((is_pair(car(x))) && (s7_is_eqv(obj, caar(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if ((is_pair(car(x))) && (s7_is_eqv(obj, caar(x)))) return(car(x));
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      y = cdr(y);
      if (x == y) return(sc->F);
    }
  return(sc->F); /* not reached */
}


static s7_pointer g_assoc(s7_scheme *sc, s7_pointer args)
{
  #define H_assoc "(assoc obj alist (func #f)) returns the key-value pair associated (via equal?) with the key obj in the association list alist.\
If 'func' is a function of 2 arguments, it is used for the comparison instead of 'equal?"

  s7_pointer x, y, obj;

  x = cadr(args);      

  if (!is_pair(x))
    {
      if (is_null(x)) 
	return(sc->F);
      return(s7_wrong_type_arg_error(sc, "assoc", 2, x, "a list"));
    }
  if (!is_pair(car(x)))
    return(s7_wrong_type_arg_error(sc, "assoc", 2, x, "an a-list")); /* we're assuming caar below so it better exist */
      
  if (is_not_null(cddr(args))) 
    {
      s7_pointer eq_func;
      /* check 3rd arg before 2nd (trailing arg error check) */

      eq_func = caddr(args);
      if (!is_procedure(eq_func))
	return(s7_wrong_type_arg_error(sc, "assoc function,", 3, eq_func, "a function"));

      if (!args_match(sc, eq_func, 2))
	return(s7_wrong_type_arg_error(sc, "assoc", 3, eq_func, "a procedure that can take 2 arguments"));

      /* now maybe there's a simple case */
      if (s7_list_length(sc, cadr(args)) > 0)
	{
	  if ((is_safe_procedure(eq_func)) &&
	      (is_c_function(eq_func)))
	    {
	      s7_function func;
	      
	      func = c_function_call(eq_func);
	      sc->z = list_2(sc, car(args), sc->F);
	      for (; is_pair(x); x = cdr(x))
		{
		  if (is_pair(car(x)))
		    {
		      cadr(sc->z) = caar(x);
		      if (is_true(sc, (*func)(sc, sc->z)))
			return(car(x));
		    }
		  else return(s7_wrong_type_arg_error(sc, "assoc", 2, cadr(args), "an a-list"));
		}
	      return(sc->F);
	    }
	}

      sc->args = list_3(sc, list_2(sc, car(args), caar(x)), x, x);
      sc->value = sc->F;
      push_stack(sc, OP_ASSOC_IF, sc->args, eq_func);
      push_stack(sc, OP_APPLY, car(sc->args), eq_func);
      return(sc->UNSPECIFIED);
    }

  x = cadr(args);
  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "assoc", 2, x, "a list"));
    }
  y = x;
  obj = car(args);

  if ((s7_is_symbol(obj)) ||
      (s7_is_boolean(obj)) ||
      (s7_is_character(obj)))
    {
      while (true)
	{
	  /* see assq */
	  if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  if ((obj == caar(x)) && (is_pair(car(x)))) return(car(x));
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  y = cdr(y);
	  if (x == y) return(sc->F);
	}
    }
  else
    {
      while (true)
	{
	  if ((is_pair(car(x))) && (s7_is_equal(sc, obj, caar(x)))) return(car(x));
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  if ((is_pair(car(x))) && (s7_is_equal(sc, obj, caar(x)))) return(car(x));
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  y = cdr(y);
	  if (x == y) return(sc->F);
	}
    }
  return(sc->F); /* not reached */
}



static s7_pointer g_memq(s7_scheme *sc, s7_pointer args)
{
  #define H_memq "(memq obj list) looks for obj in list and returns the list from that point if it is found, otherwise #f. memq uses eq?"

  /* this version accepts any kind of list (the previous one insisted on proper lists for some reason) */
  s7_pointer x, y, obj;

  x = cadr(args);
  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "memq", 2, x, "a list"));
    }
  y = x;
  obj = car(args);

  while (true)
    {
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      /* I think (memq 'c '(a b . c)) should return #f because otherwise
       *   (memq '() ...) would return the '() at the end.
       */

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      y = cdr(y);
      if (x == y) return(sc->F);
    }
  return(sc->F); /* not reached */
}


#if WITH_OPTIMIZATION
/* if memq's list is a quoted list, it won't be changing, so we can tell ahead of time that it is
 *   a proper list, and what its length is.
 */
static s7_pointer memq_3, memq_4, memq_any;

static s7_pointer g_memq_3(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, obj;
  x = cadr(args);
  obj = car(args);
  while (true)
    {
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);
    }
  return(sc->F);
}

static s7_pointer g_memq_4(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, obj;
  x = cadr(args);
  obj = car(args);
  while (true)
    {
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);
    }
  return(sc->F);
}

static s7_pointer g_memq_any(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, obj;
  x = cadr(args);
  obj = car(args);
  while (true)
    {
      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);

      if (obj == car(x)) return(x);
      x = cdr(x);
      if (!is_pair(x)) return(sc->F);
    }
  return(sc->F);
}

static s7_pointer memq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if ((is_pair(caddr(expr))) &&
      (car(caddr(expr)) == sc->QUOTE) &&
      (is_pair(cadr(caddr(expr)))))
    {
      int len;
      len = s7_list_length(sc, cadr(caddr(expr)));
      if (len > 0)
	{
	  if ((len % 4) == 0)
	    return(memq_4);
	  if ((len % 3) == 0)
	    return(memq_3);
	  return(memq_any);
	}
    }
  return(f);
}

#endif


static s7_pointer g_memv(s7_scheme *sc, s7_pointer args)
{
  #define H_memv "(memv obj list) looks for obj in list and returns the list from that point if it is found, otherwise #f. memv uses eqv?"
  s7_pointer x, y, obj;

  x = cadr(args);
  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "memv", 2, x, "a list"));
    }
  y = x;
  obj = car(args);

  if ((s7_is_symbol(obj)) ||
      (s7_is_boolean(obj)) ||
      (s7_is_character(obj)))
    {
      while (true)
	{
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  y = cdr(y);
	  if (x == y) return(sc->F);
	}
    }
  else
    {
      while (true)
	{
	  if (s7_is_eqv(obj, car(x))) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  if (s7_is_eqv(obj, car(x))) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  
	  y = cdr(y);
	  if (x == y) return(sc->F);
	}
    }
  return(sc->F); /* not reached */
}


static s7_pointer g_member(s7_scheme *sc, s7_pointer args)
{
  #define H_member "(member obj list (func #f)) looks for obj in list and returns the list from that point if it is found, otherwise #f. \
member uses equal?  If 'func' is a function of 2 arguments, it is used for the comparison instead of 'equal?"

  /* PERHAPS: this could be extended to accept sequences:
   *            (member #\a "123123abnfc" char=?) -> "abnfc"
   *            (member "abc" "123abc321" string=?) -> "abc321" but there's the string length complication
   *            (member 1 #(0 1 2) =) ? -- for c_objects (ffi) we would need a substring equivalent
   *            and what would it do for a hash-table?
   */

  s7_pointer x, y, obj;

  x = cadr(args);

  if (!is_pair(x))
    {
      if (is_null(x)) return(sc->F);
      return(s7_wrong_type_arg_error(sc, "member", 2, x, "a list"));
    }

  if (is_not_null(cddr(args))) 
    {
      s7_pointer eq_func;
      /* check 3rd arg before 2nd (trailing arg error check) */

      eq_func = caddr(args);
      if (!is_procedure(eq_func))
	return(s7_wrong_type_arg_error(sc, "member function,", 3, eq_func, "a function"));

      if (!args_match(sc, eq_func, 2))
	return(s7_wrong_type_arg_error(sc, "member", 3, eq_func, "a procedure that can take 2 arguments"));

      /* now maybe there's a simple case */
      if (s7_list_length(sc, x) > 0)
	{
	  if ((is_safe_procedure(eq_func)) &&
	      (is_c_function(eq_func)))
	    {
	      s7_function func;

	      func = c_function_call(eq_func);
	      sc->z = list_2(sc, car(args), sc->F);

	      for (; is_pair(x); x = cdr(x))
		{
		  cadr(sc->z) = car(x);
		  if (is_true(sc, (*func)(sc, sc->z)))
		    return(x);
		}
	      return(sc->F);
	    }

	}

      /* using a vector here (rather than list_3) is slower */
      /* sc->args = list_3(sc, list_2(sc, car(args), car(x)), x, x); */
      sc->args = cons_unchecked(sc, 
		   cons_unchecked(sc, car(args), cons_unchecked(sc, car(x), sc->NIL)),
		   cons_unchecked(sc, x, cons(sc, x, sc->NIL)));

      sc->value = sc->F;
      push_stack(sc, OP_MEMBER_IF, sc->args, eq_func);
      push_stack(sc, OP_APPLY, car(sc->args), eq_func);
      return(sc->UNSPECIFIED);
    }

  y = x;
  obj = car(args);
  if ((s7_is_symbol(obj)) ||
      (s7_is_boolean(obj)) ||
      (s7_is_character(obj)))
    {
      /* the only things that aren't simply == here are c_object, string, number, vector, hash-table, pair, and c_pointer
       *   but all the other cases are unlikely.
       */
      while (true)
	{
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  if (obj == car(x)) return(x);
	  x = cdr(x);
	  if (!is_pair(x)) return(sc->F);
	  y = cdr(y);
	  if (x == y) return(sc->F);
	}
    }
  else
    {
      if (s7_is_number(obj))
	{
	  while (true)
	    {
	      if ((s7_is_number(car(x))) && (numbers_are_eqv(obj, car(x)))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      if ((s7_is_number(car(x))) && (numbers_are_eqv(obj, car(x)))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      if ((s7_is_number(car(x))) && (numbers_are_eqv(obj, car(x)))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      if ((s7_is_number(car(x))) && (numbers_are_eqv(obj, car(x)))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      y = cdr(y);
	      if (x == y) return(sc->F);
	    }
	}
      else
	{
	  while (true)
	    {
	      if (s7_is_equal(sc, obj, car(x))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      
	      if (s7_is_equal(sc, obj, car(x))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      
	      if (s7_is_equal(sc, obj, car(x))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      
	      if (s7_is_equal(sc, obj, car(x))) return(x);
	      x = cdr(x);
	      if (!is_pair(x)) return(sc->F);
	      
	      y = cdr(y);
	      if (x == y) return(sc->F);
	    }
	}
    }
  return(sc->F); /* not reached */
}



static bool is_member(s7_pointer sym, s7_pointer lst)
{
  s7_pointer x;
  for (x = lst; is_pair(x); x = cdr(x))
    if (sym == car(x))
      return(true);
  return(false);
}


static s7_pointer g_is_provided(s7_scheme *sc, s7_pointer args)
{
  #define H_is_provided "(provided? symbol) returns #t if symbol is a member of the *features* list"
  if (!s7_is_symbol(car(args)))
    return(s7_wrong_type_arg_error(sc, "provided?", 0, car(args), "a symbol"));

  return(make_boolean(sc, is_member(car(args), s7_name_to_value(sc, "*features*"))));
}


static s7_pointer g_provide(s7_scheme *sc, s7_pointer args)
{
  #define H_provide "(provide symbol) adds symbol to the *features* list"
  s7_pointer features;

  if (!s7_is_symbol(car(args)))
    return(s7_wrong_type_arg_error(sc, "provide", 0, car(args), "a symbol"));

  features = make_symbol(sc, "*features*");
  if (!is_member(car(args), s7_symbol_value(sc, features)))
    s7_symbol_set_value(sc, 
			features,
			cons(sc, 
				car(args), 
				s7_symbol_value(sc, features)));
  return(car(args));
}


void s7_provide(s7_scheme *sc, const char *feature)
{
  g_provide(sc, cons(sc, s7_make_symbol(sc, feature), sc->NIL));
}


static s7_pointer g_features_set(s7_scheme *sc, s7_pointer args)
{
  if (s7_is_list(sc, cadr(args)))
    return(cadr(args));
  return(sc->ERROR);
}



static s7_pointer g_list(s7_scheme *sc, s7_pointer args)
{
  #define H_list "(list ...) returns its arguments in a list"

  return(args);
}


static s7_pointer g_append(s7_scheme *sc, s7_pointer args)
{
  #define H_append "(append ...) returns its argument lists appended into one list"
  /* but weirdly (append '() 1) returns 1 */
  s7_pointer x, y;
  int i;

  if (is_null(args)) 
    return(sc->NIL);

  if (is_null(cdr(args)))
    return(car(args)); 
  
  x = sc->NIL;
  for (i = 1, y = args; is_not_null(y); i++, y = cdr(y)) 
    {
      /* the original version used s7_append but that copies the arguments too many times if there are 3 or more lists */
      s7_pointer p;
      if (is_null(cdr(y)))
	return(reverse_in_place(sc, car(y), x)); /* i.e. tack car(y) onto end of x copied and reversed */

      p = car(y);
      if (!is_proper_list(sc, p))
	return(s7_wrong_type_arg_error(sc, "append", i, p, "a proper list"));

      while (is_not_null(p))
	{
	  x = cons(sc, car(p), x);
	  p = cdr(p);
	}
    }
  return(x);
}


static s7_pointer append_in_place(s7_scheme *sc, s7_pointer a, s7_pointer b)
{
  /* tack b onto the end of a without copying either -- 'a' is changed! */
  s7_pointer p;
  if (is_null(a))
    return(b);
  p = a;
  while (is_not_null(cdr(p))) p = cdr(p);
  cdr(p) = b;
  return(a);
}



/* -------------------------------- vectors -------------------------------- */

bool s7_is_vector(s7_pointer p)    
{ 
  return(type(p) == T_VECTOR);
}

#define FILLED true
#define NOT_FILLED false

static s7_pointer make_vector_1(s7_scheme *sc, s7_Int len, bool filled, bool add_to_cache) 
{
  s7_pointer x;
  if (len > 134217728)
    {
      /* len is an "int" currently */
      float ilog2;

      ilog2 = log((double)len) / log(2.0);
      if (sizeof(size_t) > 4)
	{
	  if (ilog2 > 56.0)
	    return(s7_out_of_range_error(sc, "make-vector length,", 1, s7_make_integer(sc, len), "should be less than about 2^56 probably"));
	}
      else
	{
	  if (ilog2 > 28.0)
	    return(s7_out_of_range_error(sc, "make-vector length,", 1, s7_make_integer(sc, len), "should be less than about 2^28 probably"));
	}
    }

  /* this has to follow the error checks!  (else garbage in free_heap temps portion confuses GC when "vector" is finalized) */

  NEW_CELL(sc, x);
  vector_length(x) = 0;
  vector_elements(x) = NULL;
  set_type(x, T_VECTOR | T_DONT_COPY | T_SAFE_PROCEDURE); /* (v 0) as vector-ref is safe */

  if (len > 0)
    {
      vector_elements(x) = (s7_pointer *)malloc(len * sizeof(s7_pointer));
      if (!(vector_elements(x)))
	return(s7_error(sc, make_symbol(sc, "out-of-memory"), 
			list_1(sc, make_protected_string(sc, "make-vector allocation failed!"))));

      vector_length(x) = len;
      if (filled) s7_vector_fill(sc, x, sc->NIL); /* make_hash_table assumes nil as the default value */
    }

  x->object.vector.vextra.dim_info = NULL;
  if (add_to_cache) add_vector(sc, x);
  return(x);
}


s7_pointer s7_make_vector(s7_scheme *sc, s7_Int len)
{
  return(make_vector_1(sc, len, FILLED, true));
}


s7_Int s7_vector_length(s7_pointer vec)
{
  return(vector_length(vec));
}


s7_Int s7_vector_print_length(s7_scheme *sc)
{
  return(s7_integer(symbol_value(sc->vector_print_length)));
}


s7_Int s7_set_vector_print_length(s7_scheme *sc, s7_Int new_len)
{
  s7_Int old_len;
  old_len = s7_integer(symbol_value(sc->vector_print_length));
  set_symbol_value(sc->vector_print_length, s7_make_integer(sc, new_len));
  return(old_len);
}


static s7_pointer g_vector_print_length_set(s7_scheme *sc, s7_pointer args)
{
  if (s7_is_integer(cadr(args)))
    {
      s7_Int len;
      len = s7_integer(cadr(args));
      if (len >= 0)
	return(cadr(args));
    }
  return(sc->ERROR);
}


#if (!WITH_GMP)
void s7_vector_fill(s7_scheme *sc, s7_pointer vec, s7_pointer obj)
#else
static void vector_fill(s7_scheme *sc, s7_pointer vec, s7_pointer obj)
#endif
{
  s7_Int len, i = 1, left;
  s7_pointer *orig, *cur;

  len = vector_length(vec);
  if (len == 0) return;

  orig = vector_elements(vec);
  orig[0] = obj;

  while (i < len)
    {
      cur = (s7_pointer *)(orig + i);
      left = len - i;
      if (left < i)
	memcpy((void *)cur, (void *)orig, sizeof(s7_pointer) * left);
      else memcpy((void *)cur, (void *)orig, sizeof(s7_pointer) * i);
      i *= 2;
    }
}


static s7_pointer g_vector_fill(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_fill "(vector-fill! v val) sets all elements of the vector v to val"
  s7_pointer x;
  x = car(args);

  if (!s7_is_vector(x))
    return(s7_wrong_type_arg_error(sc, "vector-fill!", 1, x, "a vector"));

  s7_vector_fill(sc, x, cadr(args));
  return(cadr(args));
}


s7_pointer s7_vector_ref(s7_scheme *sc, s7_pointer vec, s7_Int index) 
{
  if (index >= vector_length(vec))
    return(s7_out_of_range_error(sc, "vector-ref index,", 2, s7_make_integer(sc, index), "should be less than vector length"));

  return(vector_element(vec, index));
}


s7_pointer s7_vector_set(s7_scheme *sc, s7_pointer vec, s7_Int index, s7_pointer a) 
{
  if (index >= vector_length(vec))
    return(s7_out_of_range_error(sc, "vector-set! index,", 2, s7_make_integer(sc, index), "should be less than vector length"));

  vector_element(vec, index) = a;
  return(a);
}


s7_pointer *s7_vector_elements(s7_pointer vec)
{
  return(vector_elements(vec));
}


s7_Int *s7_vector_dimensions(s7_pointer vec)
{
  s7_Int *dims;
  if (vector_is_multidimensional(vec))
    return(vec->object.vector.vextra.dim_info->dims);
  dims = (s7_Int *)malloc(sizeof(s7_Int));
  dims[0] = vector_length(vec);
  return(dims);
}


s7_Int *s7_vector_offsets(s7_pointer vec)
{
  s7_Int *offs;
  if (vector_is_multidimensional(vec))
    return(vec->object.vector.vextra.dim_info->offsets);
  offs = (s7_Int *)malloc(sizeof(s7_Int));
  offs[0] = 1;
  return(offs);
}


s7_pointer s7_vector_to_list(s7_scheme *sc, s7_pointer vect)
{
  s7_Int i, len;
  s7_pointer p;

  len = vector_length(vect);
  if (len == 0) return(sc->NIL);

  if (len < (sc->free_heap_top - sc->free_heap))
    {
      sc->w = cons(sc, vector_element(vect, len - 1), sc->NIL);
      for (i = len - 2; i >= 0; i--)
	sc->w = cons_unchecked(sc, vector_element(vect, i), sc->w);
    }
  else
    {
      sc->w = sc->NIL;
      for (i = len - 1; i >= 0; i--)
	sc->w = cons(sc, vector_element(vect, i), sc->w);
    }
  p = sc->w;
  sc->w = sc->NIL;
  return(p);
}


static s7_pointer g_vector_to_list(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_to_list "(vector->list v) returns the elements of the vector v as a list; (map values v)"
  if (!s7_is_vector(car(args)))
    return(s7_wrong_type_arg_error(sc, "vector->list", 0, car(args), "a vector"));
  return(s7_vector_to_list(sc, car(args)));
}


s7_pointer s7_make_and_fill_vector(s7_scheme *sc, s7_Int len, s7_pointer fill)
{
  s7_pointer vect;
  vect = make_vector_1(sc, len, NOT_FILLED, true);
  s7_vector_fill(sc, vect, fill);
  return(vect);
}


static s7_pointer g_vector(s7_scheme *sc, s7_pointer args)
{
  #define H_vector "(vector ...) returns a vector whose elements are the arguments"
  s7_Int i, len;
  s7_pointer vec;
  
  len = s7_list_length(sc, args);
  vec = make_vector_1(sc, len, NOT_FILLED, true);
  if (len > 0)
    {
      s7_pointer x;
      for (x = args, i = 0; is_pair(x); x = cdr(x), i++) 
	vector_element(vec, i) =  car(x);
    }
  return(vec);
}


static s7_pointer g_list_to_vector(s7_scheme *sc, s7_pointer args)
{
  #define H_list_to_vector "(list->vector lst) returns a vector containing the elements of lst; (apply vector lst)"
  
  if (is_null(car(args)))
    return(s7_make_vector(sc, 0));
  if (!is_proper_list(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "list->vector", 0, car(args), "a proper list"));
  return(g_vector(sc, car(args)));
}


static s7_pointer g_vector_length(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_length "(vector-length v) returns the length of vector v"
  if (!s7_is_vector(car(args)))
    return(s7_wrong_type_arg_error(sc, "vector-length", 0, car(args), "a vector"));
  return(s7_make_integer(sc, vector_length(car(args))));
}


static s7_pointer make_shared_vector(s7_scheme *sc, s7_pointer vect, int skip_dims, s7_Int index)
{
  s7_pointer x;
  s7_vdims_t *v;

  /* (let ((v #2d((1 2) (3 4)))) (v 1)) 
   * (let ((v (make-vector '(2 3 4) 0))) (v 1 2))
   * (let ((v #3d(((0 1 2 3) (4 5 6 7) (8 9 10 11)) ((12 13 14 15) (16 17 18 19) (20 21 22 23))))) (v 0 1))
   */

  NEW_CELL(sc, x);
  vector_length(x) = 0;
  vector_elements(x) = NULL;
  set_type(x, T_VECTOR | T_DONT_COPY);

  v = (s7_vdims_t *)malloc(sizeof(s7_vdims_t));
 
  v->ndims = vector_ndims(vect) - skip_dims;
  v->dims = (s7_Int *)((vect)->object.vector.vextra.dim_info->dims + skip_dims);
  v->offsets = (s7_Int *)((vect)->object.vector.vextra.dim_info->offsets + skip_dims);
  v->original = vect;
  x->object.vector.vextra.dim_info = v;  

  vector_length(x) = vector_offset(vect, skip_dims - 1);
  vector_elements(x) = (s7_pointer *)(vector_elements(vect) + index);
  add_vector(sc, x);
  return(x);
}


static s7_pointer vector_ref_1(s7_scheme *sc, s7_pointer vect, s7_pointer indices)
{
  s7_Int index = 0;
  if (vector_length(vect) == 0)
    return(s7_out_of_range_error(sc, "vector-ref", 1, vect, "this vector has no elements, so vector-ref is hopeless"));

  if (vector_is_multidimensional(vect))
    {
      unsigned int i;
      s7_pointer x;
      for (x = indices, i = 0; (is_not_null(x)) && (i < vector_ndims(vect)); x = cdr(x), i++)
	{
	  s7_Int n;
	  if (!s7_is_integer(car(x)))
	    return(s7_wrong_type_arg_error(sc, "vector-ref index,", i + 2, car(x), "an integer"));

	  n = s7_integer(car(x));
	  if ((n < 0) || 
	      (n >= vector_dimension(vect, i)))
	    return(s7_out_of_range_error(sc, "vector-ref", i + 2, car(x), "index should be between 0 and the dimension size"));

	  index += n * vector_offset(vect, i);
	}
      if (is_not_null(x))
	return(s7_wrong_number_of_args_error(sc, "too many indices for vector-ref: ~A", indices));

      /* if not enough indices, return a shared vector covering whatever is left */
      if (i < vector_ndims(vect))
	return(make_shared_vector(sc, vect, i, index));
    }
  else
    {
      /* (let ((hi (make-vector 3 0.0)) (sum 0.0)) (do ((i 0 (+ i 1))) ((= i 3)) (set! sum (+ sum (hi i)))) sum) */

      if (!s7_is_integer(car(indices)))
	return(s7_wrong_type_arg_error(sc, "vector-ref index,", 2, car(indices), "an integer"));

      index = s7_integer(car(indices));
      if ((index < 0) ||
	  (index >= vector_length(vect)))
	return(s7_out_of_range_error(sc, "vector-ref index,", 2, car(indices), "should be between 0 and the vector length"));
      
      if (is_not_null(cdr(indices)))                /* (let ((L '#(#(1 2 3) #(4 5 6)))) (vector-ref L 1 2)) */
	{
	  s7_pointer new_vect;
	  new_vect = vector_element(vect, index);
	  if (!s7_is_vector(new_vect))             /* (vector-ref #(1) 0 0) */
	    return(s7_wrong_type_arg_error(sc, "vector-ref", 1, new_vect, "a vector"));

	  return(vector_ref_1(sc, new_vect, cdr(indices))); 
	}
    }

  return(vector_element(vect, index));
}


static s7_pointer g_vector_ref(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_ref "(vector-ref v ... i) returns the i-th element of vector v.  If v \
is a multidimensional vector, you can also use (vector-ref v ...) where the trailing args \
are the indices, or omit 'vector-ref': (v ...)."

  s7_pointer vec;

  vec = car(args);
  if (!s7_is_vector(vec))
    return(s7_wrong_type_arg_error(sc, "vector-ref", 1, vec, "a vector"));

  return(vector_ref_1(sc, vec, cdr(args)));
}

#if WITH_OPTIMIZATION
static s7_pointer vector_ref_ic; /* , vector_ref_add1; */
static s7_pointer g_vector_ref_ic(s7_scheme *sc, s7_pointer args)
{
  s7_pointer vec;
  s7_Int index;

  vec = car(args);
  if (!s7_is_vector(vec))
    return(s7_wrong_type_arg_error(sc, "vector-ref", 1, vec, "a vector"));
  if (vector_is_multidimensional(vec))
    return(g_vector_ref(sc, args));

  index = s7_integer(cadr(args));
  if (index >= vector_length(vec))
    return(s7_out_of_range_error(sc, "vector-ref index,", 2, cadr(args), "should be less than vector length"));

  return(vector_element(vec, index));
}

static s7_pointer vector_ref_2;
static s7_pointer g_vector_ref_2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer vec, ind;
  s7_Int index;

  vec = car(args);
  if (!s7_is_vector(vec))
    return(s7_wrong_type_arg_error(sc, "vector-ref", 1, vec, "a vector"));
  if (vector_is_multidimensional(vec))
    return(g_vector_ref(sc, args));
  
  ind = cadr(args);
  if (!s7_is_integer(ind))
    return(s7_wrong_type_arg_error(sc, "vector-ref index,", 2, ind, "an integer"));
  index = s7_integer(ind);
  if ((index < 0) ||
      (index >= vector_length(vec)))
    return(s7_out_of_range_error(sc, "vector-ref index,", 2, ind, "should be between 0 and the vector length"));

  return(vector_element(vec, index));
}
#endif


static s7_pointer g_vector_set(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_set "(vector-set! v i ... value) sets the i-th element of vector v to value.  If 'v' is \
multidimensional you can also use (vector-set! v ... val) where the ellipsis refers to the indices.  You \
can also use 'set!' instead of 'vector-set!': (set! (v ...) val) -- I find this form much easier to read."

  s7_pointer vec, val;
  s7_Int index;

  /* fprintf(stderr, "vector set: %s\n", s7_object_to_c_string(sc, args));   */
  vec = car(args);
  if (!s7_is_vector(vec))
    return(s7_wrong_type_arg_error(sc, "vector-set!", 1, vec, "a vector"));
  if (vector_length(vec) == 0)
    return(s7_out_of_range_error(sc, "vector-set!", 1, vec, "this vector has no elements, so vector-set! is hopeless"));
  
  if (vector_is_multidimensional(vec))
    {
      unsigned int i;
      s7_pointer x;
      index = 0;
      for (x = cdr(args), i = 0; (is_not_null(cdr(x))) && (i < vector_ndims(vec)); x = cdr(x), i++)
	{
	  s7_Int n;
	  if (!s7_is_integer(car(x)))
	    return(s7_wrong_type_arg_error(sc, "vector-set! index,", i + 2, car(x), "an integer"));

	  n = s7_integer(car(x));
	  if ((n < 0) || 
	      (n >= vector_dimension(vec, i)))
	    return(s7_out_of_range_error(sc, "vector-set!", i, car(x), "index should be between 0 and the dimension size"));

	  index += n * vector_offset(vec, i);
	}

      if (is_not_null(cdr(x)))
	return(s7_wrong_number_of_args_error(sc, "too many args for vector-set!: ~A", args));
      if (i != vector_ndims(vec))
	return(s7_wrong_number_of_args_error(sc, "not enough args for vector-set!: ~A", args));

      val = car(x);
    }
  else
    {
      if (!s7_is_integer(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "vector-set! index,", 2, cadr(args), "an integer"));

      index = s7_integer(cadr(args));
      if ((index < 0) ||
	  (index >= vector_length(vec)))
	return(s7_out_of_range_error(sc, "vector-set! index,", 2, cadr(args), "should be between 0 and the vector length"));

      if (is_not_null(cdddr(args)))
	return(g_vector_set(sc, cons(sc, vector_element(vec, index), cddr(args))));

      val = caddr(args);
    }
  
  vector_element(vec, index) = val;
  return(val);
}


#define MAX_VECTOR_DIMENSIONS 512

static s7_pointer g_make_vector(s7_scheme *sc, s7_pointer args)
{
  #define H_make_vector "(make-vector len (value #f)) returns a vector of len elements initialized to value. \
To create a multidimensional vector, put the dimension bounds in a list (this is to avoid ambiguities such as \
(make-vector 1 2) where it's not clear whether the '2' is an initial value or a dimension size).  (make-vector '(2 3) 1.0) \
returns a 2 dimensional vector of 6 total elements, all initialized to 1.0."

  s7_Int len;
  s7_pointer x, fill, vec;
  fill = sc->UNSPECIFIED;

  x = car(args);
  if (s7_is_integer(x))
    {
      len = s7_integer(x);
      if (len < 0)
	return(s7_wrong_type_arg_error(sc, "make-vector length,", (is_null(cdr(args))) ? 0 : 1, x, "a non-negative integer"));
    }
  else
    {
      s7_pointer y;
      if (!(is_pair(x)))
	return(s7_wrong_type_arg_error(sc, "make-vector", (is_null(cdr(args))) ? 0 : 1, x, "an integer or a list of integers"));

      if (!s7_is_integer(car(x)))
	return(s7_wrong_type_arg_error(sc, "make-vector", (is_null(cdr(args))) ? 0 : 1, car(x), "each dimension should be an integer"));

      if (is_null(cdr(x)))
	len = s7_integer(car(x));
      else
	{
	  int i, dims;

	  dims = s7_list_length(sc, x);
	  if (dims <= 0)                /* 0 if circular, negative if dotted */
	    return(s7_wrong_type_arg_error(sc, "make-vector", (is_null(cdr(args))) ? 0 : 1, x, "a proper list of dimensions"));
	  if (dims > MAX_VECTOR_DIMENSIONS)
	    return(s7_out_of_range_error(sc, "make-vector dimension list,", (is_null(cdr(args))) ? 0 : 1, x, "less than 512 dimensions"));

	  for (i = 1, len = 1, y = x; is_not_null(y); y = cdr(y), i++)
	    {
	      if (!s7_is_integer(car(y)))
		return(s7_wrong_type_arg_error(sc, "make-vector", i, car(y), "an integer"));
	      len *= s7_integer(car(y));
	      if (len < 0)
		return(s7_wrong_type_arg_error(sc, "make-vector", i, car(y), "a non-negative integer"));
	    }
	}
    }
  
  if (is_not_null(cdr(args))) 
    fill = cadr(args);

  vec = make_vector_1(sc, len, NOT_FILLED, true);
  if (len > 0) s7_vector_fill(sc, vec, fill);

  if ((is_pair(x)) &&
      (is_pair(cdr(x))))
    {
      int i;
      s7_Int offset = 1;
      s7_pointer y;
      s7_vdims_t *v;

      v = (s7_vdims_t *)malloc(sizeof(s7_vdims_t));
      v->ndims = safe_list_length(sc, x);
      v->dims = (s7_Int *)malloc(v->ndims * sizeof(s7_Int));
      v->offsets = (s7_Int *)malloc(v->ndims * sizeof(s7_Int));
      v->original = sc->F;

      for (i = 0, y = x; is_not_null(y); i++, y = cdr(y))
	v->dims[i] = s7_integer(car(y));

      for (i = v->ndims - 1; i >= 0; i--)
	{
	  v->offsets[i] = offset;
	  offset *= v->dims[i];
	}

      vec->object.vector.vextra.dim_info = v;
    }

  return(vec);
}


static s7_pointer g_is_vector(s7_scheme *sc, s7_pointer args)
{
  #define H_is_vector "(vector? obj) returns #t if obj is a vector"
  return(make_boolean(sc, s7_is_vector(car(args))));
}


int s7_vector_rank(s7_pointer vect)
{
  if (vector_is_multidimensional(vect))
    return(vector_ndims(vect));
  return(1);
}


static s7_pointer g_vector_dimensions(s7_scheme *sc, s7_pointer args)
{
  #define H_vector_dimensions "(vector-dimensions vect) returns a list of vect's dimensions.  In srfi-63 terms:\n\
    (define array-dimensions vector-dimensions)\n\
    (define (array-rank v) (length (vector-dimensions v)))"

  s7_pointer x;

  x = car(args);
  if (!s7_is_vector(x))
    return(s7_wrong_type_arg_error(sc, "vector-dimensions", 0, x, "a vector"));

  if (vector_is_multidimensional(x))
    {
      int i;
      sc->w = sc->NIL;
      for (i = vector_ndims(x) - 1; i >= 0; i--)
	sc->w = cons(sc, s7_make_integer(sc, vector_dimension(x, i)), sc->w);
      x = sc->w;
      sc->w = sc->NIL;
      return(x);
    }
  
  return(list_1(sc, s7_make_integer(sc, vector_length(x))));
}


#define MV_TOO_MANY_ELEMENTS -1
#define MV_NOT_ENOUGH_ELEMENTS -2

static int traverse_vector_data(s7_scheme *sc, s7_pointer vec, int flat_ref, int dimension, int dimensions, int *sizes, s7_pointer lst)
{
  /* we're filling vec, we're currently looking for element (flat-wise) flat_ref,
   *   we're at ref in dimension of dimensions, where sizes gives the bounds, and lst is our data
   *   #3D(((1 2 3) (4 5 6)) ((7 8 9) (10 11 12)))
   */
  int i;
  s7_pointer x;

  for (i = 0, x = lst; i < sizes[dimension]; i++, x = cdr(x))
    {
      if (!is_pair(x))
	return(MV_NOT_ENOUGH_ELEMENTS);

      if (dimension == (dimensions - 1))
	vector_element(vec, flat_ref++) = car(x);
      else 
	{
	  flat_ref = traverse_vector_data(sc, vec, flat_ref, dimension + 1, dimensions, sizes, car(x));
	  if (flat_ref < 0) return(flat_ref);
	}
    }

  if (is_not_null(x))
    return(MV_TOO_MANY_ELEMENTS);
  return(flat_ref);
}


static s7_pointer s7_multivector_error(s7_scheme *sc, const char *message, s7_pointer data)
{
  return(s7_error(sc, sc->READ_ERROR,
		  list_3(sc, 
			      make_protected_string(sc, "reading constant vector, ~A: ~A"),
			      make_protected_string(sc, message),
			      data)));
}


static s7_pointer g_multivector(s7_scheme *sc, int dims, s7_pointer data)
{
  /* get the dimension bounds from data, make the new vector, fill it from data */
  s7_pointer vec, x;
  int i, total_size = 1, vec_loc, err;
  int *sizes;
  
  /* (#2d((1 2 3) (4 5 6)) 0 0) -> 1
   * (#2d((1 2 3) (4 5 6)) 0 1) -> 2
   * (#2d((1 2 3) (4 5 6)) 1 1) -> 5
   * (#3D(((1 2) (3 4)) ((5 6) (7 8))) 0 0 0) -> 1
   * (#3D(((1 2) (3 4)) ((5 6) (7 8))) 1 1 0) -> 7
   * #3D(((1 2) (3 4)) ((5 6) (7))) -> error, #3D(((1 2) (3 4)) ((5 6) (7 8 9))), #3D(((1 2) (3 4)) (5 (7 8 9))) etc
   *
   * but a special case: #nD() is an n-dimensional empty vector
   */

  if (dims <= 0)      /* #0d(...) */
    return(s7_out_of_range_error(sc, "#nD(...) dimensions,", 1, s7_make_integer(sc, dims), "must be 1 or more"));

  sc->w = sc->NIL;
  if (is_null(data))  /* dims are already 0 (calloc above) */
    return(g_make_vector(sc, list_1(sc, g_make_list(sc, list_2(sc, s7_make_integer(sc, dims), small_int(0))))));

  sizes = (int *)calloc(dims, sizeof(int));
  for (x = data, i = 0; i < dims; i++)
    {
      sizes[i] = safe_list_length(sc, x);
      total_size *= sizes[i];
      sc->w = cons(sc, s7_make_integer(sc, sizes[i]), sc->w);
      x = car(x);
      if ((i < (dims - 1)) && 
	  (!is_pair(x)))
	{
	  free(sizes);
	  return(s7_multivector_error(sc, "we need a list that fully specifies the vector's elements", data));
	}
    }

  vec = g_make_vector(sc, list_1(sc, safe_reverse_in_place(sc, sc->w)));
  vec_loc = s7_gc_protect(sc, vec);
  sc->w = sc->NIL;

  /* now fill the vector checking that all the lists match */
  err = traverse_vector_data(sc, vec, 0, 0, dims, sizes, data);

  free(sizes);
  s7_gc_unprotect_at(sc, vec_loc);
  if (err < 0) 
    return(s7_multivector_error(sc, (err == MV_TOO_MANY_ELEMENTS) ? "found too many elements" : "not enough elements found", data));

  return(vec);
}


static s7_pointer g_qq_multivector(s7_scheme *sc, s7_pointer args)
{
  /* `#2d((1 2) ,(list 3 4)) */
  #define H_qq_multivector "quasiquote internal support for multidimensional vector constants"
  return(g_multivector(sc, s7_integer(car(args)), cdr(args)));
}


static s7_pointer vector_copy(s7_scheme *sc, s7_pointer old_vect)
{
  s7_Int len;
  s7_pointer new_vect;

  len = vector_length(old_vect);

  if (vector_is_multidimensional(old_vect))
    new_vect = g_make_vector(sc, list_1(sc, g_vector_dimensions(sc, list_1(sc, old_vect))));
  else new_vect = make_vector_1(sc, len, NOT_FILLED, true);

  /* here and in vector-fill! we have a problem with bignums -- should new bignums be allocated? (copy_list also) */

  memcpy((void *)(vector_elements(new_vect)), (void *)(vector_elements(old_vect)), len * sizeof(s7_pointer));
  return(new_vect);
}





/* -------- sort! -------- */

static s7_scheme *compare_sc;
static s7_function compare_func;
static s7_pointer compare_args;

static int vector_compare(const void *v1, const void *v2)
{
  car(compare_args) = (*(s7_pointer *)v1);
  cadr(compare_args) = (*(s7_pointer *)v2);
  if (is_true(compare_sc, (*(compare_func))(compare_sc, compare_args)))
    return(-1);
  return(1);
}


static s7_pointer g_sort(s7_scheme *sc, s7_pointer args)
{
  #define H_sort "(sort! list-or-vector less?) sorts a list or vector using the function 'less?' to compare elements.\
If its first argument is a list, the list is copied (despite the '!')."

  s7_pointer data, lessp;
  s7_Int len = 0, n, k;

  data = car(args);
  if (is_null(data)) return(sc->NIL);
  if ((!is_pair(data)) && 
      (!s7_is_vector(data)) &&
      (!is_c_object(data)))
    return(s7_wrong_type_arg_error(sc, "sort! data,", 1, data, "a vector, list, or an object from make-type and friends"));

  lessp = cadr(args);
  if (!is_procedure(lessp))
    return(s7_wrong_type_arg_error(sc, "sort! function,", 2, lessp, "a function"));
  if ((is_continuation(lessp)) || is_goto(lessp))
    return(s7_wrong_type_arg_error(sc, "sort!", 2, lessp, "a normal procedure (not a continuation)"));
  if (!args_match(sc, lessp, 2))
    return(s7_wrong_type_arg_error(sc, "sort!", 2, lessp, "a procedure that can take 2 arguments"));

  switch (type(data))
    {
    case T_PAIR:
      len = s7_list_length(sc, data);            /* nil disposed of above, so 0 here == infinite */
      if (len <= 0)
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "sort! argument 1 should be a proper list: ~S"), data)));
      if (len < 2) return(data);
      if (len == 2)
	{
	  push_stack(sc, OP_SORT_TWO, data, args);  /* this will return a list -- was sc->args  */
	  push_stack(sc, OP_APPLY, data, lessp);
	  return(sc->F);
	}
      push_stack(sc, OP_SORT4, args, sc->code);    /* gc protect the original list, OP_SORT4 calls s7_vector_to_list, was sc->args */
      car(args) = g_list_to_vector(sc, sc->x = list_1(sc, data));
      break;

    case T_VECTOR:
      if (is_immutable(data))
	return(s7_wrong_type_arg_error(sc, "sort!", 1, data, "a mutable vector"));
      len = vector_length(data);

      if ((is_safe_procedure(lessp)) &&
	  (is_c_function(lessp)))
	{
	  int gc_loc;
	  compare_sc = sc;
	  compare_func = c_function_call(lessp);
	  compare_args = list_2(sc, sc->F, sc->F);
	  gc_loc = s7_gc_protect(sc, compare_args);
	  qsort((void *)s7_vector_elements(data), len, sizeof(s7_pointer), vector_compare);
	  s7_gc_unprotect_at(sc, gc_loc);
	  return(data);

	  /* PERHAPS: other cases might be doable here: if optimized/safe, use sc->T2_1 etc
	   */
	}
      break;

    case T_C_OBJECT:
      {
	s7_pointer vect;
	vect = object_to_vector(sc, data);                      /* this can raise an error */
	len = vector_length(vect);
	push_stack(sc, OP_SORT_OBJECT, sc->args, list_2(sc, car(args), vect)); /* gc protect, OP_SORT_OBJECT calls vector_to_object */
	car(args) = vect;
	break;
      }
    }

  if (len < 2) return(data);
  n = len - 1;
  k = ((int)(n / 2)) + 1;

  sc->x = s7_make_vector(sc, (sc->safety == 0) ? 5 : 7); 
  vector_element(sc->x, 0) = make_mutable_integer(sc, n);
  vector_element(sc->x, 1) = make_mutable_integer(sc, k);
  vector_element(sc->x, 2) = make_mutable_integer(sc, 0);
  vector_element(sc->x, 3) = make_mutable_integer(sc, 0);
  vector_element(sc->x, 4) = list_2(sc, sc->F, sc->F);
  if (sc->safety != 0)
    {
      vector_element(sc->x, 5) = make_mutable_integer(sc, 0);
      vector_element(sc->x, 6) = s7_make_integer(sc, n * n);
    }

  push_stack(sc, OP_SORT, args, sc->x);
  sc->x = sc->NIL;
  return(sc->F);
  
  /* if the comparison function waffles, sort! can hang: (sort! '(1 2 3) (lambda (a b) (= a b)))
   * set *safety* to 1 to add a check for this loop, but the "safe" procedures are direct, so unchecked.
   */
}




/* -------- hash tables -------- */

bool s7_is_hash_table(s7_pointer p)
{
  return(type(p) == T_HASH_TABLE);
}


static s7_pointer g_is_hash_table(s7_scheme *sc, s7_pointer args)
{
  #define H_is_hash_table "(hash-table? obj) returns #t if obj is a hash-table"
  return(make_boolean(sc, s7_is_hash_table(car(args))));
}


static s7_pointer g_hash_table_size(s7_scheme *sc, s7_pointer args)
{
  #define H_hash_table_size "(hash-table-size obj) returns the size of the hash-table obj"
  if (!s7_is_hash_table(car(args)))
    return(s7_wrong_type_arg_error(sc, "hash-table-size", 0, car(args), "a hash-table"));
  return(s7_make_integer(sc, hash_table_length(car(args))));
}


static s7_Int hash_loc(s7_scheme *sc, s7_pointer key)
{
  s7_Int loc = 0;
  const char *c; 

  switch (type(key))
    {
    case T_STRING:
      if (string_hash(key) != 0)
	return(string_hash(key));
      for (c = string_value(key); *c; c++) 
	loc = *c + loc * HASH_MULT;
      string_hash(key) = loc;
      return(loc);

    case T_NUMBER:
      if (number_type(key) == NUM_INT)
	{
	  loc = s7_integer(key);
	  if (loc < 0) return(-loc);
	  return(loc);
	}
      
      if ((number_type(key) == NUM_REAL) ||
	  (number_type(key) == NUM_REAL2))
	{
	  loc = (s7_Int)floor(s7_real(key));
	  if (loc < 0) loc = -loc;
	  return(loc);
	}

      /* ratio or complex -- use type */
      break;

    case T_SYMBOL:
      return(symbol_hash(key));

    case T_SYNTAX:
      return((s7_Int)syntax_opcode(key));

    case T_CHARACTER:
      return((s7_Int)character(key));

    case T_VECTOR:
      return(vector_length(key));

    case T_PAIR:
      return(s7_list_length(sc, key));

    default:
      break;
    }

  return(type(key));
}


static s7_pointer hash_empty(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  return(sc->NIL);
}


static s7_pointer hash_equal(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  s7_pointer x;
  unsigned int hash_len, loc;
  hash_len = (int)hash_table_length(table) - 1;
  loc = hash_loc(sc, key) & hash_len;
  for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
    if (s7_is_equal(sc, caar(x), key))
      return(car(x));
  return(sc->NIL);
}


static s7_pointer hash_int(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  if (s7_is_integer(key))
    {
      s7_Int keyval;
      s7_pointer x;
      unsigned int hash_len, loc;
      hash_len = (int)hash_table_length(table) - 1;
      keyval = s7_integer(key);
      if (keyval < 0)
	loc = (-keyval) & hash_len;
      else loc = keyval & hash_len;
      for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
	if (s7_integer(caar(x)) == keyval)
	  return(car(x));
    }
  return(sc->NIL);
}


static s7_pointer hash_string(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  if (s7_is_string(key))
    {
      s7_pointer x;
      int hash_len, loc;
      hash_len = (int)hash_table_length(table) - 1;
      loc = string_hash(key);
      if (loc == 0)
	{
	  const char *c; 
	  for (c = string_value(key); *c; c++) 
	    loc = *c + loc * HASH_MULT;
	  string_hash(key) = loc;
	}
      loc &= hash_len;
      for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
	if (strings_are_equal(string_value(caar(x)), string_value(key)))
	  return(car(x));
    }
  return(sc->NIL);
}


static s7_pointer hash_char(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  if (s7_is_character(key))
    {
      s7_pointer x;
      int hash_len, loc;
      hash_len = (int)hash_table_length(table) - 1;
      loc = character(key) & hash_len;
      for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
	if (character(caar(x)) == character(key))
	  return(car(x));
    }
  return(sc->NIL);
}


static s7_pointer hash_float(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  #define HASH_FLOAT_EPSILON 1.0e-12
  if ((s7_is_real(key)) && 
      (!s7_is_rational(key)))
    {
      /* give the equality check some room */
      s7_Double keyval;
      s7_pointer x;
      int hash_len, loc;
      hash_len = (int)hash_table_length(table) - 1;
      loc = (int)floor(s7_real(key));
      if (loc < 0) loc = -loc;
      loc &= hash_len;
      keyval = s7_real(key);
      for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
	if (fabs(s7_real(caar(x)) - keyval) < HASH_FLOAT_EPSILON)
	  return(car(x));
    }
  return(sc->NIL);
}


static s7_pointer hash_symbol(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  if (s7_is_symbol(key))
    {
      s7_pointer x;
      int hash_len, loc;
      hash_len = (int)hash_table_length(table) - 1;
      loc = symbol_hash(key) & hash_len;
      for (x = hash_table_elements(table)[loc]; is_not_null(x); x = cdr(x))
	if (caar(x) == key)
	  return(car(x));
    }
  return(sc->NIL);
}


#define DEFAULT_HASH_TABLE_SIZE 511


s7_pointer s7_make_hash_table(s7_scheme *sc, s7_Int size)
{
  s7_pointer table;
  /* size is rounded up to the next power of 2 */

  if ((size & (size + 1)) != 0)      /* already 2^n - 1 ? */
    {
      size--;
      size |= (size >> 1);
      size |= (size >> 2);
      size |= (size >> 4);
      size |= (size >> 8);
      size |= (size >> 16);
      if (s7_int_bits > 31) /* this is either 31 or 63 */
	size |= (size >> 32);
    }

  table = make_vector_1(sc, size + 1, FILLED, false); /* nil is the default value, don't add to vector cache! */
  /* size + 1 can be fooled if we don't catch most-positive-fixnum */

  set_type(table, T_HASH_TABLE | T_DONT_COPY | T_SAFE_PROCEDURE);
  hash_table_function(table) = hash_empty;
  hash_table_entries(table) = 0;
  add_hash_table(sc, table);
  return(table);
}


static s7_pointer g_make_hash_table(s7_scheme *sc, s7_pointer args)
{
  #define H_make_hash_table "(make-hash-table (size 511)) returns a new hash table"
  s7_Int size = DEFAULT_HASH_TABLE_SIZE;

  if (is_not_null(args))
    {
      if (s7_is_integer(car(args)))
	{
	  size = s7_integer(car(args));
	  if (size <= 0)
	    return(s7_out_of_range_error(sc, "make-hash-table size,", 0, car(args), "should be a positive integer"));
	  if (size > MAX_LIST_LENGTH)
	    return(s7_out_of_range_error(sc, "make-hash-table size,", 0, car(args), "should be a reasonable integer"));
	}
      else return(s7_wrong_type_arg_error(sc, "make-hash-table size,", 0, car(args), "an integer"));
    }
  
  return(s7_make_hash_table(sc, size));
}


s7_pointer s7_hash_table_ref(s7_scheme *sc, s7_pointer table, s7_pointer key)
{
  s7_pointer x;
  x = (*hash_table_function(table))(sc, table, key);

  if (is_not_null(x))
    return(cdr(x));
  return(sc->F);
}


s7_pointer s7_hash_table_set(s7_scheme *sc, s7_pointer table, s7_pointer key, s7_pointer value)
{
  s7_pointer x;
  x = (*hash_table_function(table))(sc, table, key);

  if (is_not_null(x))
    cdr(x) = value;
  else
    {
      s7_Int hash_len, loc;
      int typ;

      hash_len = hash_table_length(table) - 1;
      loc = hash_loc(sc, key) & hash_len;
      hash_table_entries(table)++;
      typ = type(key);

      if (hash_table_function(table) == hash_empty)
	{
	  switch (typ)
	    {
	    case T_STRING:
	      hash_table_function(table) = hash_string;
	      break;

	    case T_NUMBER:
	      if (number_type(key) == NUM_INT)
		hash_table_function(table) = hash_int;
	      else
		{
		  if ((number_type(key) == NUM_REAL) ||
		      (number_type(key) == NUM_REAL2))
		    hash_table_function(table) = hash_float;
		  else hash_table_function(table) = hash_equal;
		}
	      break;

	    case T_SYMBOL:
	      hash_table_function(table) = hash_symbol;
	      break;

	    case T_CHARACTER:
	      hash_table_function(table) = hash_char;
	      break;
	      
	    default:
	      hash_table_function(table) = hash_equal;
	      break;
	    }
	}
      else
	{
	  switch (typ)
	    {
	    case T_STRING:
	      if (hash_table_function(table) != hash_string) 
		hash_table_function(table) = hash_equal;
	      break;
	      
	    case T_NUMBER:
	      if (number_type(key) == NUM_INT)
		{
		  if (hash_table_function(table) != hash_int)
		    hash_table_function(table) = hash_equal;
		}
	      else
		{
		  if ((number_type(key) == NUM_REAL) ||
		      (number_type(key) == NUM_REAL2))
		    {
		      if (hash_table_function(table) != hash_float)
			hash_table_function(table) = hash_equal;
		    }
		  else hash_table_function(table) = hash_equal;
		}
	      break;

	    case T_CHARACTER:
	      if (hash_table_function(table) != hash_char) 
		hash_table_function(table) = hash_equal;
	      break;

	    case T_SYMBOL:
	      if (hash_table_function(table) != hash_symbol) 
		hash_table_function(table) = hash_equal;
	      break;

	    default:
	      hash_table_function(table) = hash_equal;
	      break;
	    }
	}
      hash_table_elements(table)[loc] = cons_unchecked(sc, cons(sc, key, value), hash_table_elements(table)[loc]);
    }
  return(value);
}


static s7_pointer g_hash_table_ref(s7_scheme *sc, s7_pointer args)
{
  /* basically the same layout as the symbol table */
  #define H_hash_table_ref "(hash-table-ref table key) returns the value associated with key in the hash table"
  s7_pointer table;

  table = car(args);
  
  if (!s7_is_hash_table(table))
    return(s7_wrong_type_arg_error(sc, "hash-table-ref", 1, table, "a hash-table"));

  /*
    (define (href H . args) 
      (if (null? (cdr args))
          (hash-table-ref H (car args))
          (apply href (hash-table-ref H (car args)) (cdr args))))
  */

  if (is_null(cddr(args)))
    return(s7_hash_table_ref(sc, table, cadr(args)));
  return(g_hash_table_ref(sc, cons(sc, s7_hash_table_ref(sc, table, cadr(args)), cddr(args))));
}

#if WITH_OPTIMIZATION
static s7_pointer hash_table_ref_2;
static s7_pointer g_hash_table_ref_2(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x, table;
  table = car(args);
  
  if (!s7_is_hash_table(table))
    return(s7_wrong_type_arg_error(sc, "hash-table-ref", 1, table, "a hash-table"));
  
  if (hash_table_entries(table) == 0)
    return(sc->F);

  x = (*hash_table_function(table))(sc, table, cadr(args));
  if (is_not_null(x))
    return(cdr(x));
  return(sc->F);
}
#endif


static s7_pointer g_hash_table_set(s7_scheme *sc, s7_pointer args)
{
  #define H_hash_table_set "(hash-table-set! table key value) sets the value associated with key in the hash table to value"
  s7_pointer table;

  table = car(args);
  
  if (!s7_is_hash_table(table))
    return(s7_wrong_type_arg_error(sc, "hash-table-set!", 1, table, "a hash-table"));

  /* how would (set! (ht a b) c) choose the inner table if (ht a b) is not found?
   *   I'm not sure the multi-index case makes sense here
   */

  return(s7_hash_table_set(sc, table, cadr(args), caddr(args)));
}


static s7_pointer g_hash_table(s7_scheme *sc, s7_pointer args)
{
  #define H_hash_table "(hash-table ...) returns a hash-table containing the cons's passed as its arguments. \
That is, (hash-table '(\"hi\" . 3) (\"ho\" . 32)) returns a new hash-table with the two key/value pairs preinstalled."

  int i, len, ht_loc;
  s7_pointer x, ht;
  
  len = s7_list_length(sc, args);
  ht = s7_make_hash_table(sc, (len > 512) ? 4095 : 511);
  if (is_not_null(args))
    {
      ht_loc = s7_gc_protect(sc, ht); /* hash_table_set can cons, so we need to protect this */
      for (x = args, i = 1; i <= len; x = cdr(x), i++) 
	{
	  if (is_pair(car(x)))
	    s7_hash_table_set(sc, ht, caar(x), cdar(x));
	  else
	    {
	      if (is_not_null(car(x)))
		{
		  s7_gc_unprotect_at(sc, ht_loc);
		  return(s7_wrong_type_arg_error(sc, "hash-table", i, car(x), "a pair: (key value)"));
		}
	    }
	}
      s7_gc_unprotect_at(sc, ht_loc);
    }
  return(ht);
}


static s7_pointer hash_list_copy(s7_scheme *sc, s7_pointer obj)
{
  if (is_pair(obj))
    return(cons(sc, s7_copy(sc, car(obj)), hash_list_copy(sc, cdr(obj))));
  return(obj);
}


static s7_pointer hash_table_copy(s7_scheme *sc, s7_pointer old_hash)
{
  /* this has to copy not only the lists but the cons's in the lists! */
  s7_Int i, len;
  s7_pointer new_hash;
  s7_pointer *old_lists, *new_lists;
  int gc_loc;

  len = vector_length(old_hash);
  new_hash = s7_make_hash_table(sc, len);
  gc_loc = s7_gc_protect(sc, new_hash);

  old_lists = vector_elements(old_hash);
  new_lists = vector_elements(new_hash);

  for (i = 0; i < len; i++)
    if (is_not_null(old_lists[i]))
      new_lists[i] = hash_list_copy(sc, old_lists[i]);

  hash_table_entries(new_hash) = hash_table_entries(old_hash);
  hash_table_function(new_hash) = hash_table_function(old_hash);

  s7_gc_unprotect_at(sc, gc_loc);
  return(new_hash);
}


static s7_pointer hash_table_reverse(s7_scheme *sc, s7_pointer old_hash)
{
  s7_Int i, len;
  s7_pointer new_hash;
  s7_pointer *old_lists;
  int gc_loc;

  len = vector_length(old_hash);
  new_hash = s7_make_hash_table(sc, len);
  gc_loc = s7_gc_protect(sc, new_hash);

  old_lists = vector_elements(old_hash);
  /* don't set entries or function -- s7_hash_table_set below will handle those */

  for (i = 0; i < len; i++)
    {
      s7_pointer x;
      for (x = old_lists[i]; is_not_null(x); x = cdr(x))
	s7_hash_table_set(sc, new_hash, cdar(x), caar(x));
    }

  s7_gc_unprotect_at(sc, gc_loc);
  return(new_hash);
}


static s7_pointer hash_table_clear(s7_scheme *sc, s7_pointer table)
{
  int i, len;

  len = vector_length(table);
  for (i = 0; i < len; i++)
    vector_element(table, i) = sc->NIL;
  hash_table_entries(table) = 0;
  hash_table_function(table) = hash_empty;
  return(table);
}


static s7_pointer g_hash_table_iterate(s7_scheme *sc, s7_pointer args)
{
  /* internal func pointed to by sc->HASH_TABLE_ITERATE */
  s7_pointer lst, loc, table;
  s7_Int vloc, len;
  s7_pointer *elements;

  lst = caar(args);
  if (is_pair(lst))
    {
      caar(args) = cdr(lst);
      return(car(lst));
    }

  table = cadar(args);
  len = hash_table_length(table);
  elements = hash_table_elements(table);

  loc = caddar(args);
  for (vloc = integer(number(loc)) + 1; vloc < len;  vloc++)
    {
      s7_pointer x;
      x = elements[vloc];
      if (is_not_null(x))
	{
	  integer(number(loc)) = vloc;
	  caar(args) = cdr(x);
	  return(car(x));
	}
    }

  integer(number(loc)) = len;
  return(sc->NIL);
}


static s7_pointer g_make_hash_table_iterator(s7_scheme *sc, s7_pointer args)
{
  #define H_make_hash_table_iterator "(make-hash-table-iterator table) returns a function of no arguments that \
returns the next (key . value) pair in the hash-table each time it is called.  When there are no more pairs, it returns nil."

  if (!s7_is_hash_table(car(args)))
    return(s7_wrong_type_arg_error(sc, "make-hash-table-iterator", 0, car(args), "a hash-table"));

  return(make_closure(sc, list_2(sc, sc->NIL,                             /* no args to the new function */
				      list_2(sc, sc->HASH_TABLE_ITERATE,
						  list_2(sc, sc->QUOTE, 
							      list_3(sc, sc->NIL, car(args), make_mutable_integer(sc, -1))))),
		      T_CLOSURE));
}


static char *hash_table_to_c_string(s7_scheme *sc, s7_pointer hash, bool to_file, shared_info *ci)
{
  s7_Int i, len, bufsize = 0, gc_iter;
  bool too_long = false;
  char **elements = NULL;
  char *buf;
  s7_pointer iterator, iter_loc;
  
  len = hash_table_entries(hash);
  if (len == 0)
    return(copy_string("#<hash-table>"));

  if (!to_file)
    {
      int plen;
      plen = s7_vector_print_length(sc);
      if (plen <= 0)
	return(copy_string("#<hash-table ...>"));

      if (len > plen)
	{
	  too_long = true;
	  len = plen;
	}
    }

  iterator = g_make_hash_table_iterator(sc, list_1(sc, hash));
  gc_iter = s7_gc_protect(sc, iterator);
  iter_loc = cdadar(closure_body(iterator));
  elements = (char **)malloc(len * sizeof(char *));

  for (i = 0; i < len; i++)
    {
      elements[i] = object_to_c_string_with_circle_check(sc, g_hash_table_iterate(sc, iter_loc), USE_WRITE, WITH_ELLIPSES, ci);
      bufsize += safe_strlen(elements[i]);
    }
  s7_gc_unprotect_at(sc, gc_iter);

  bufsize += (len * 4 + 256);                   /* might be 2 parens per element + space + quote, so at least len*4 here */
  buf = (char *)malloc(bufsize * sizeof(char));

  sprintf(buf, "#<hash-table ");
  for (i = 0; i < len - 1; i++)
    {
      if (elements[i])
	{
	  /* strcat(buf, "'"); -- it's a constant so do we need a quote? #(0 (1 2)) for example */
	  strcat(buf, elements[i]);
	  free(elements[i]);
	  strcat(buf, " ");
	}
    }

  if (elements[len - 1])
    {
      /* strcat(buf, "'"); */
      strcat(buf, elements[len - 1]);
      free(elements[len - 1]);
    }

  free(elements);
  if (too_long)
    strcat(buf, " ...");
  strcat(buf, ">");
  return(buf);
}




/* -------------------------------- objects and functions -------------------------------- */

bool s7_is_function(s7_pointer p)  
{ 
  return(is_c_function(p));
}


bool s7_is_object(s7_pointer p) 
{ 
  return(is_c_object(p));
}



#if WITH_OPTIMIZATION
static unsigned int f_class = 0;

static s7_pointer fallback_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  return(f);
}


unsigned int s7_function_class(s7_pointer f)
{
  return(c_function_class(f));
}

void s7_function_set_class(s7_pointer f, unsigned int c)
{
  c_function_class(f) = c;
}


s7_pointer (*s7_function_chooser(s7_pointer fnc))(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  return(c_function_chooser(fnc));
}

void s7_function_set_chooser(s7_pointer fnc,  s7_pointer (*chooser)(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr))
{
  c_function_chooser(fnc) = chooser;
}

s7_function s7_function_choice(s7_pointer expr)
{
  if (is_c_function(ecdr(expr)))
    return(c_function_call(ecdr(expr)));
  return(NULL);
}

void s7_function_choice_set_direct(s7_pointer expr)
{
  optimize_data(expr) = HOP_SAFE_C_C;
}

#else

unsigned int s7_function_class(s7_pointer f)
{
  return(0);
}

void s7_function_set_class(s7_pointer f, unsigned int c)
{
}

s7_pointer (*s7_function_chooser(s7_pointer fnc))(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  return(NULL); /* not called, I hope */
}

void s7_function_set_chooser(s7_pointer f,  s7_pointer (*chooser)(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr))
{
}

s7_function s7_function_choice(s7_pointer expr)
{
  return(NULL);
}

void s7_function_choice_set_direct(s7_pointer expr)
{
}
#endif


s7_pointer s7_make_function(s7_scheme *sc, const char *name, s7_function f, int required_args, int optional_args, bool rest_arg, const char *doc)
{
  s7_func_t *ptr;
  int ftype = T_C_FUNCTION;
  s7_pointer x;

  x = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  x->hloc = NOT_IN_HEAP;

  ptr = (s7_func_t *)permanent_calloc(sizeof(s7_func_t));
  if (required_args == 0)
    {
      if (rest_arg)
	ftype = T_C_ANY_ARGS_FUNCTION;
      else 
	{
	  if (optional_args != 0)
	    ftype = T_C_OPT_ARGS_FUNCTION;
	  /* a thunk needs to check for no args passed */
	}
    }
  else
    {
      if (rest_arg)
	ftype = T_C_RST_ARGS_FUNCTION;
    }
  
  set_type(x, ftype | T_DONT_COPY | T_PROCEDURE);

  c_function(x) = ptr;
  c_function_call(x) = f;
  c_function_setter(x) = sc->F;
  c_function_name(x) = name;       /* (procedure-name proc) => (format #f "~A" proc) */
  if (doc)
    c_function_documentation(x) = make_permanent_string(doc);

  c_function_required_args(x) = required_args;
  c_function_optional_args(x) = optional_args;
  c_function_has_rest_arg(x) = rest_arg;
  if (rest_arg)
    c_function_all_args(x) = 10000000;
  else c_function_all_args(x) = required_args + optional_args;
  c_function_arity_list(x) = sc->NIL;

#if WITH_OPTIMIZATION
  c_function_class(x) = ++f_class;
  c_function_chooser(x) = fallback_chooser;
#endif

  return(x);
}


s7_pointer s7_apply_function(s7_scheme *sc, s7_pointer fnc, s7_pointer args)
{
  if (s7_is_symbol(fnc))
    fnc = s7_symbol_value(sc, fnc);

  if (is_c_function(fnc))
    return(c_function_call(fnc)(sc, args));

  push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
  sc->args = list_1(sc, args);
  sc->code = fnc;
  eval(sc, OP_APPLY);
  return(sc->value);
}


bool s7_is_procedure(s7_pointer x)
{
  return(is_procedure(x)); /* this returns "is applicable" so it is true for applicable c_objects, macros, etc */
}


static s7_pointer g_is_procedure(s7_scheme *sc, s7_pointer args)
{
  #define H_is_procedure "(procedure? obj) returns #t if obj is a procedure"
  s7_pointer x;
  int typ;

  x = car(args);
  if (!is_procedure(x)) return(sc->F);
  typ = type(x);

  /* make_object sets the T_PROCEDURE bit if the object has an apply function,
   *   but we currently return (procedure? "hi") -> #f, so we can't simply use
   *   is_procedure. 
   * 
   * Unfortunately much C code depends on s7_is_procedure treating applicable
   *  objects and macros as procedures.  Ideally we'd have s7_is_applicable.
   */
  return(make_boolean(sc,
		      (typ == T_CLOSURE) || 
		      (typ == T_CLOSURE_STAR) ||
		      (typ >= T_C_FUNCTION) ||
		      (typ == T_GOTO) ||
		      (typ == T_CONTINUATION) ||
		      (s7_is_procedure_with_setter(x))));
}


static void s7_function_set_setter(s7_scheme *sc, const char *getter, const char *setter)
{
  c_function_setter(s7_name_to_value(sc, getter)) = s7_name_to_value(sc, setter);
}


static char *pws_documentation(s7_pointer x);
static s7_pointer pws_source(s7_scheme *sc, s7_pointer x);
static s7_pointer pws_arity(s7_scheme *sc, s7_pointer obj);


s7_pointer s7_procedure_source(s7_scheme *sc, s7_pointer p)
{
  /* make it look like an internal lambda form */
  
  /* in this context, there's no way to distinguish between:
   *    (procedure-source (let ((b 1)) (lambda (a) (+ a b))))
   * and
   *    (let ((b 1)) (procedure-source (lambda (a) (+ a b))))
   * both become:
   * ((a) (+ a b)) (((b . 1)) #(() () () () () ((make-filtered-comb . make-filtered-comb)) () () ...))
   */
  
  if (is_closure(p) || is_closure_star(p) || is_macro(p) || is_bacro(p))
    {
      return(cons(sc, 
		     append_in_place(sc, 
				     list_2(sc, 
						 (is_closure_star(p)) ? sc->LAMBDA_STAR : sc->LAMBDA, 
						 closure_args(p)),
				     closure_body(p)),
		     closure_environment(p)));
    }
  
  if (s7_is_procedure_with_setter(p))
    return(pws_source(sc, p));
  return(sc->NIL);
}


static s7_pointer g_procedure_source(s7_scheme *sc, s7_pointer args)
{
  /* make it look like a scheme-level lambda */
  s7_pointer p;
  
  #define H_procedure_source "(procedure-source func) tries to return the definition of func"
  
  p = car(args);

  if (s7_is_symbol(p))
    {
      p = s7_symbol_value(sc, p);
      if (p == sc->UNDEFINED)
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "procedure-source arg, '~S, is unbound"), car(args))));
    }
  if (is_c_function(p))
    return(sc->NIL);

  if (is_c_macro(p))
    return(s7_wrong_type_arg_error(sc, "procedure-source", 0, p, "a scheme macro"));
  if ((!is_procedure(p)) &&
      (!is_macro(p)) &&
      (!is_bacro(p)))
    return(s7_wrong_type_arg_error(sc, "procedure-source", 0, car(args), "a procedure or a macro"));

  if (is_closure(p) || is_closure_star(p) || is_macro(p) || is_bacro(p))
    {
      s7_pointer body;
      body = closure_body(p);
      if (is_safe_closure(body))
	clear_safe_closure(body);
      return(append_in_place(sc, 
			     list_2(sc, 
					 (is_closure_star(p)) ? sc->LAMBDA_STAR : sc->LAMBDA, 
					 closure_args(p)),
			     body));
    }

  if (s7_is_procedure_with_setter(p))
    return(pws_source(sc, p));
  return(sc->NIL);
}


s7_pointer s7_procedure_environment(s7_pointer p)    
{ 
  return(closure_environment(p));
}


static s7_pointer g_procedure_environment(s7_scheme *sc, s7_pointer args)
{
  s7_pointer p;
  #define H_procedure_environment "(procedure-environment func) tries to return func's environment"

  /* this procedure gives direct access to a function's closure -- see s7test.scm 
   *   for some wild examples.  At least it provides a not-too-kludgey way for several functions
   *   to share a closure.
   */ 
  
  p = car(args);
  if (s7_is_symbol(p))
    {
      p = s7_symbol_value(sc, p);
      if (p == sc->UNDEFINED)
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "procedure-environment arg, '~S, is unbound"), car(args))));
    }

  if ((!is_procedure(p)) && 
      (!is_macro(p)) &&
      (!is_bacro(p)))
    return(s7_wrong_type_arg_error(sc, "procedure-environment", 0, car(args), "a procedure or a macro"));

  if ((is_closure(p) || is_closure_star(p) || is_macro(p) || is_bacro(p)) &&
      (is_not_null(closure_environment(p))))
    return(closure_environment(p));
  return(sc->global_env);
}


void s7_define_function(s7_scheme *sc, const char *name, s7_function fnc, int required_args, int optional_args, bool rest_arg, const char *doc)
{
  s7_pointer func;
  func = s7_make_function(sc, name, fnc, required_args, optional_args, rest_arg, doc);
  s7_define(sc, sc->NIL, make_symbol(sc, name), func);
}


void s7_define_safe_function(s7_scheme *sc, const char *name, s7_function fnc, int required_args, int optional_args, bool rest_arg, const char *doc)
{
  s7_pointer func;
  func = s7_make_function(sc, name, fnc, required_args, optional_args, rest_arg, doc);
  typeflag(func) |= T_SAFE_PROCEDURE;
  s7_define(sc, sc->NIL, make_symbol(sc, name), func);
}


static void s7_define_constant_function(s7_scheme *sc, const char *name, s7_function fnc, int required_args, int optional_args, bool rest_arg, const char *doc)
{
  s7_pointer func, sym;
  sym = make_symbol(sc, name);
  func = s7_make_function(sc, name, fnc, required_args, optional_args, rest_arg, doc);
  s7_define(sc, sc->NIL, sym, func);
  set_immutable(car(symbol_global_slot(sym)));
  {
    s7_pointer p;
    p = s7_symbol_value(sc, make_symbol(sc, name));
    typeflag(p) &= ~(T_SAFE_PROCEDURE);
  }
}


void s7_define_macro(s7_scheme *sc, const char *name, s7_function fnc, int required_args, int optional_args, bool rest_arg, const char *doc)
{
  s7_pointer func;
  func = s7_make_function(sc, name, fnc, required_args, optional_args, rest_arg, doc);
  set_type(func, T_C_MACRO | T_DONT_COPY | T_ANY_MACRO | T_DONT_EVAL_ARGS); /* this used to include T_PROCEDURE */
  s7_define(sc, sc->NIL, make_symbol(sc, name), func);
}


bool s7_is_macro(s7_scheme *sc, s7_pointer x)
{
  if ((is_macro(x)) || (is_bacro(x)) || (is_c_macro(x)))
    return(true);

  if (s7_is_symbol(x))
    {
      x = s7_symbol_value(sc, x);
      return(is_macro(x) || is_bacro(x) || is_c_macro(x));
    }
  return(false);
}


static s7_pointer g_is_macro(s7_scheme *sc, s7_pointer args)
{
  #define H_is_macro "(macro? arg) returns #t if 'arg' is a macro"
  return(make_boolean(sc, s7_is_macro(sc, car(args))));
  /* it would be more consistent (with procedure? for example) if this returned #f for a symbol,
   *   but fully-expand expects this version.
   */
}


void s7_define_function_star(s7_scheme *sc, const char *name, s7_function fnc, const char *arglist, const char *doc)
{
  /* make an internal function of any args that calls fnc, then wrap it in define* and use eval_c_string */
  /* should (does) this ignore :key and other such noise? */

  char *internal_function, *internal_arglist;
  int arglist_len, len, args;
  const char *local_sym;
  s7_pointer local_args;
  
  arglist_len = safe_strlen(arglist);
  internal_arglist = (char *)calloc(arglist_len + 64, sizeof(char));
  snprintf(internal_arglist, arglist_len + 64, "(map (lambda (arg) (if (symbol? arg) arg (car arg))) '(%s))", arglist);
  local_args = s7_eval_c_string(sc, internal_arglist);
  free(internal_arglist);
  
  args = safe_list_length(sc, local_args); /* since local_args is from map (above), I think it can't be improper */
  internal_arglist = s7_object_to_c_string(sc, local_args);
  /* this has an opening paren which we don't want */
  internal_arglist[0] = ' ';

  local_sym = symbol_name(s7_gensym(sc, "define*"));
  s7_define_function(sc, local_sym, fnc, args, 0, 0, NULL);

  len = 32 + 2 * arglist_len + safe_strlen(doc) + safe_strlen(name) + safe_strlen(local_sym);
  internal_function = (char *)calloc(len, sizeof(char));
  snprintf(internal_function, len, "(define* (%s %s) \"%s\" (%s %s)", name, arglist, doc, local_sym, internal_arglist);
  s7_eval_c_string(sc, internal_function);

  free(internal_function);
  free(internal_arglist);
}


const char *s7_procedure_documentation(s7_scheme *sc, s7_pointer x)
{
  if (s7_is_symbol(x))
    x = s7_symbol_value(sc, x); /* this is needed by Snd */

  if ((s7_is_function(x)) ||
      (is_c_macro(x)))
    return((char *)c_function_documentation(x));
  
  if (((is_closure(x)) || 
       (is_closure_star(x))) &&
      (s7_is_string(car(closure_body(x)))))
    return(s7_string(car(closure_body(x))));
  
  if (s7_is_procedure_with_setter(x))
    return(pws_documentation(x));
  
  if ((s7_is_macro(sc, x)) &&
      (s7_is_string(caddr(cadr(car(closure_body(x)))))))
    return(s7_string(caddr(cadr(car(closure_body(x))))));

  return(""); /* not NULL here so that (string=? "" (procedure-documentation no-doc-func)) -> #t */
}


static s7_pointer g_procedure_documentation(s7_scheme *sc, s7_pointer args)
{
  #define H_procedure_documentation "(procedure-documentation func) returns func's documentation string"
  s7_pointer p;

  p = car(args);
  if (s7_is_symbol(p))
    p = s7_symbol_value(sc, p);

  if ((!is_procedure(p)) &&
      (!s7_is_macro(sc, p)))
    return(s7_wrong_type_arg_error(sc, "procedure-doucmentation", 0, car(args), "a procedure"));
  return(s7_make_string(sc, s7_procedure_documentation(sc, p)));
}


const char *s7_help(s7_scheme *sc, s7_pointer obj)
{
  if (is_syntax(obj))
    {
      switch (syntax_opcode(obj))
	{
	case OP_QUOTE:
	  return("(quote obj) returns obj unevaluated.  'obj is an abbreviation for (quote obj).");
	  
	case OP_IF:
	  return("(if expr true-stuff optional-false-stuff) evaluates expr, then \
if it is true, evaluates true-stuff; otherwise, if optional-false-stuff exists, it is evaluated.");
	  
	case OP_BEGIN:
	  return("(begin ...) evaluates each form in its body, returning the value of the last one");

	case OP_SET:
	  return("(set! variable value) sets the value of variable to value.");

	case OP_LET:
	  return("(let ((var val)...) ...) binds each variable to its initial value, then evaluates its body,\
returning the value of the last form.  The let variables are local to it, and in the case of let (as opposed to let* for example), \
the variables are not available for use until all have been initialized.");

	case OP_LET_STAR:
	  return("(let* ((var val)...) ...) binds each variable to its initial value, then evaluates its body,\
returning the value of the last form.  The let* variables are local to it, and are available immediately (unlike let, for example).");

	case OP_LETREC:
	  return("(letrec ((var (lambda ...)))...) is like let, but var can refer to itself in \
its value (i.e. you can define local recursive functions)");

	case OP_COND:
	  return("(cond (expr clause...)...) is like if..then.  Each expr is evaluated in \
order, and if one is not #f, the associated clauses are evaluated, whereupon cond returns.");

	case OP_AND:
	  return("(and expr expr ...) evaluates each of its arguments in order, quitting (and returning #f) as soon \
as one of them returns #f.  If all are non-#f, it returns the last value.");

	case OP_OR:
	  return("(or expr expr ...) evaluates each of its argments in order, quitting as soon as \
one of them is not #f.  If all are #f, or returns #f.");

	case OP_CASE:
	  return("(case val ((key...) clause...)...) looks for val in the various lists of keys, \
and if a match is found (via eqv?), the associated clauses are evaluated, and case returns.");

	case OP_DO:
	  return("(do (vars...) (loop control and return value) ...) is a do-loop.");

	case OP_WITH_ENV:
	  return("(with-environment env ...) evaluates its body in the environment env.");

	case OP_LAMBDA:
	  return("(lambda args ...) returns a function.");

	case OP_LAMBDA_STAR:
	  return("(lambda* args ...) returns a function; the args list can have default values, \
the parameters themselves can be accessed via keywords.");

	case OP_DEFINE:
	  return("(define var val) assigns val to the variable (symbol) var.  (define (func args) ...) is \
shorthand for (define func (lambda args ...))");

	case OP_DEFINE_STAR:
	  return("(define* (func args) ...) defines a function with optional/keyword arguments.");

	case OP_DEFINE_CONSTANT:
	  return("(define-constant var val) defines var to be a constant (it can't be set or bound), with the value val.");

	case OP_DEFMACRO:
	  return("(defmacro mac (args) ...) defines mac to be a macro.");

	case OP_DEFMACRO_STAR:
	  return("(defmacro* mac (args) ...) defines mac to be a macro with optional/keyword arguments.");

	case OP_DEFINE_MACRO:
	  return("(define-macro (mac args) ...) defines mac to be a macro.");

	case OP_DEFINE_MACRO_STAR:
	  return("(define-macro* (mac args) ...) defines mac to be a macro with optional/keyword arguments.");

	case OP_DEFINE_EXPANSION:
	  return("(define-expansion (mac args) ...) defines mac to be a read-time macro.");

	case OP_DEFINE_BACRO:
	  return("(define-bacro (mac args) ...) defines mac to be a bacro.");

	case OP_DEFINE_BACRO_STAR:
	  return("(define-bacro* (mac args) ...) defines mac to be a bacro with optional/keyword arguments.");
	}
      
      return(NULL);

      /* others: macroexpand
            :(define-macro (hiho a) "a test" `(+ 1 ,a))
            hiho
            :(hiho 2)
            3
            :(s7-help hiho)
            "a test"
            with-sound #f etc -- all macros at least
       */
    }

  if (s7_is_symbol(obj))
    {
      /* here look for name */
    obj = s7_symbol_value(sc, obj);
    }

  if ((typeflag(obj) & (T_ANY_MACRO | T_PROCEDURE)) != 0)
    return(s7_procedure_documentation(sc, obj));

  if ((is_hook(obj)) &&
      (s7_is_string(hook_documentation(obj))))
    return(s7_string(hook_documentation(obj)));

  /* if is string, apropos? (can scan symbol table)
   */
  /* here keep a table as in xen.c? need s7_help and s7_set_help in C + maybe s7_define_constant_with_documentation
   */

  return(NULL);
}


static s7_pointer g_help(s7_scheme *sc, s7_pointer args)
{
  #define H_help "(help obj) returns obj's documentation"
  const char *doc;
  doc = s7_help(sc, car(args));
  if (!doc)
    return(sc->F);
  return(s7_make_string(sc, doc));
}


s7_pointer s7_procedure_arity(s7_scheme *sc, s7_pointer x)
{
  if (is_c_function(x))
    {
      if (is_null(c_function_arity_list(x)))
	{
	  c_function_arity_list(x) = 
	    permanent_cons(make_permanent_integer(c_function_required_args(x)),
 	      permanent_cons(make_permanent_integer(c_function_optional_args(x)),
  	        permanent_cons(make_boolean(sc, c_function_has_rest_arg(x)), sc->NIL,
			       T_PAIR | T_IMMUTABLE | T_DONT_COPY),
			     T_PAIR | T_IMMUTABLE | T_DONT_COPY),
			   T_PAIR | T_IMMUTABLE | T_DONT_COPY);
	}
      return(c_function_arity_list(x));
    }

  if ((is_closure(x)) ||
      (is_closure_star(x)) ||
      (is_pair(x)))
    {
      int len;
      
      if (is_pair(x))
	len = s7_list_length(sc, car(x));
      else 
	{
	  if (s7_is_symbol(closure_args(x)))
	    return(list_3(sc, small_int(0), small_int(0), sc->T));
	  len = s7_list_length(sc, closure_args(x));
	}

      if (is_closure_star(x))
	{
	  s7_pointer tmp;        /* make sure we aren't counting :optional and friends as arguments */
	  int opts = 0;

	  if (is_pair(x))
	    tmp = car(x);
	  else tmp = closure_args(x);

	  for (; is_pair(tmp); tmp = cdr(tmp))
	    {
	      if ((car(tmp) == sc->KEY_KEY) ||
		  (car(tmp) == sc->KEY_OPTIONAL) ||
		  (car(tmp) == sc->KEY_ALLOW_OTHER_KEYS))
		opts++;
	      if (car(tmp) == sc->KEY_REST)
		{
		  opts += 2;     /* both :rest and the arg name are not counted as optional args */
		  if (len > 0) len = -len;
		}
	    }
	  return(list_3(sc, small_int(0), s7_make_integer(sc, abs(len) - opts), make_boolean(sc, len < 0)));
	}

      return(list_3(sc, s7_make_integer(sc, abs(len)), small_int(0), make_boolean(sc, len < 0)));
    }
  
  if (s7_is_procedure_with_setter(x))
    {
      if (is_not_null(s7_procedure_getter(sc, x)))
	return(s7_procedure_arity(sc, s7_procedure_getter(sc, x)));
      return(pws_arity(sc, x));
    }

  if ((object_is_applicable(x)) ||
      (s7_is_continuation(x)) ||
      (is_goto(x)))
    return(list_3(sc, small_int(0), small_int(0), sc->T));

  /* it's not straightforward to add support for macros here -- the arity from the
   *   user's point of view refers to the embedded lambda, not the outer lambda.
   */
  return(sc->NIL);
}


static s7_pointer g_procedure_arity(s7_scheme *sc, s7_pointer args)
{
  #define H_procedure_arity "(procedure-arity func) returns a list describing func's arguments: '(required optional rest)"
  s7_pointer p;

  p = car(args);
  if (s7_is_symbol(p))
    {
      p = s7_symbol_value(sc, p);
      if (p == sc->UNDEFINED)
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "procedure-arity arg, '~S, is unbound"), car(args))));
    }

  if (!is_procedure(p))
    return(s7_wrong_type_arg_error(sc, "procedure-arity", 0, car(args), "a procedure"));
  return(s7_procedure_arity(sc, p));
}


static s7_pointer closure_name(s7_scheme *sc, s7_pointer closure)
{
  s7_pointer x;

  x = find_local_symbol(sc, closure_environment(closure), sc->__FUNC__);  /* returns nil if no __func__ */
  if (is_pair(x))
    {
      x = symbol_value(x);
      if (s7_is_symbol(x))
	return(x);
      if ((is_pair(x)) &&
	  (s7_is_symbol(car(x))))
	return(car(x));
    }

  if (is_pair(sc->cur_code))
    return(sc->cur_code);

  return(caar(closure)); /* desperation -- this is the parameter list */
}

/* (define* (hi (a 1) (b 2)) a) (hi :b 1 2) */
/* (let ((x (lambda* ((a 1) (b 2)) a))) (x :b 1 2)) */



/* -------------------------------- new types -------------------------------- */

typedef struct {
  int type;
  const char *name;
  char *(*print)(s7_scheme *sc, void *value);
  void (*free)(void *value);
  bool (*equal)(void *val1, void *val2);
  bool (*scheme_equal)(s7_scheme *sc, void *val1, void *val2);
  void (*gc_mark)(void *val);
  s7_pointer (*apply)(s7_scheme *sc, s7_pointer obj, s7_pointer args);
  s7_pointer (*set)(s7_scheme *sc, s7_pointer obj, s7_pointer args);
  s7_pointer (*length)(s7_scheme *sc, s7_pointer obj);
  s7_pointer (*copy)(s7_scheme *sc, s7_pointer obj);
  s7_pointer (*fill)(s7_scheme *sc, s7_pointer obj, s7_pointer args);
  s7_pointer print_func, equal_func, getter_func, setter_func, length_func, copy_func, fill_func;
  /*
  char *(*scheme_print)(s7_scheme *sc, s7_pointer obj);
  */
} s7_object_t;


static s7_object_t *object_types = NULL;
static int object_types_size = 0;
static int num_types = 0;

static char *fallback_print(s7_scheme *sc, void *val) /* obj is object_value(s7_pointer_obj) */
{
  return(copy_string("#<unprintable object>"));
}

static void fallback_free(void *value)
{
}

static bool fallback_equal(void *val1, void *val2)
{
  return(val1 == val2);
}

static s7_pointer fallback_ref(s7_scheme *sc, s7_pointer obj, s7_pointer args)
{
  return(apply_error(sc, obj, args));
}

static s7_pointer fallback_set(s7_scheme *sc, s7_pointer obj, s7_pointer args)
{
  return(eval_error(sc, "attempt to set ~A?", obj));
}

static s7_pointer fallback_length(s7_scheme *sc, s7_pointer obj)
{
  return(eval_error(sc, "attempt to get length of ~A?", obj));
}


int s7_new_type(const char *name, 
		char *(*print)(s7_scheme *sc, void *value), 
		void (*free)(void *value), 
		bool (*equal)(void *val1, void *val2),
		void (*gc_mark)(void *val),
                s7_pointer (*apply)(s7_scheme *sc, s7_pointer obj, s7_pointer args),
                s7_pointer (*set)(s7_scheme *sc, s7_pointer obj, s7_pointer args))
{
  int tag;
  tag = num_types++;
  if (tag >= object_types_size)
    {
      if (object_types_size == 0)
	{
	  object_types_size = 8;
	  object_types = (s7_object_t *)calloc(object_types_size, sizeof(s7_object_t));
	}
      else
	{
	  object_types_size = tag + 8;
	  object_types = (s7_object_t *)realloc((void *)object_types, object_types_size * sizeof(s7_object_t));
	}
    }
  object_types[tag].type = tag;
  object_types[tag].name = copy_string(name);

  if (free)
    object_types[tag].free = free;
  else object_types[tag].free = fallback_free;

  if (print)
    object_types[tag].print = print;
  else object_types[tag].print = fallback_print;

  if (equal)
    object_types[tag].equal = equal;
  else object_types[tag].equal = fallback_equal;

  object_types[tag].scheme_equal = NULL;
  object_types[tag].gc_mark = gc_mark;

  if (apply)
    object_types[tag].apply = apply;
  else object_types[tag].apply = fallback_ref;

  if (set)
    object_types[tag].set = set;
  else object_types[tag].set = fallback_set;

  object_types[tag].length = fallback_length;
  object_types[tag].copy = NULL;
  object_types[tag].fill = NULL;
  object_types[tag].print_func = NULL;
  object_types[tag].length_func = NULL;
  object_types[tag].equal_func = NULL;
  object_types[tag].getter_func = NULL;
  object_types[tag].setter_func = NULL;
  object_types[tag].copy_func = NULL;
  object_types[tag].fill_func = NULL;
  return(tag);
}


int s7_new_type_x(const char *name, 
		  char *(*print)(s7_scheme *sc, void *value), 
		  void (*free)(void *value), 
		  bool (*equal)(void *val1, void *val2),
		  void (*gc_mark)(void *val),
		  s7_pointer (*apply)(s7_scheme *sc, s7_pointer obj, s7_pointer args),
		  s7_pointer (*set)(s7_scheme *sc, s7_pointer obj, s7_pointer args),
		  s7_pointer (*length)(s7_scheme *sc, s7_pointer obj),
		  s7_pointer (*copy)(s7_scheme *sc, s7_pointer obj),
		  s7_pointer (*fill)(s7_scheme *sc, s7_pointer obj, s7_pointer val))
{
  int tag;
  tag = s7_new_type(name, print, free, equal, gc_mark, apply, set);

  if (length)
    object_types[tag].length = length;
  else object_types[tag].length = fallback_length;

  object_types[tag].copy = copy;
  object_types[tag].fill = fill;
  return(tag);
}


static char *object_print(s7_scheme *sc, s7_pointer a)
{
  return((*(object_types[object_type(a)].print))(sc, object_value(a))); /* assume allocation here (so we'll free the string later) */
}


static void free_object(s7_pointer a)
{
  (*(object_types[object_type(a)].free))(object_value(a));
}


static bool objects_are_equal(s7_scheme *sc, s7_pointer a, s7_pointer b)
{
  if (object_type(a) == object_type(b))
    {
      int tag;
      tag = object_type(a);
      if (object_types[tag].equal)
	return((*(object_types[tag].equal))(object_value(a), object_value(b)));
      if (object_types[tag].scheme_equal)
	return((*(object_types[tag].scheme_equal))(sc, object_value(a), object_value(b)));
      return(a == b);
    }
  return(false);
}


static void mark_embedded_objects(s7_pointer a) /* called by gc, calls fobj's mark func */
{
  int tag;
  tag = object_type(a);
  if (tag < num_types)
    {
      if (object_types[tag].gc_mark)
	(*(object_types[tag].gc_mark))(object_value(a));
    }
}


static bool object_is_applicable(s7_pointer x)
{
  return((is_c_object(x)) &&
	 (object_types[object_type(x)].apply));
}


void *s7_object_value(s7_pointer obj)
{
  return(object_value(obj));
}


int s7_object_type(s7_pointer obj)
{
  if (is_c_object(obj))
    return(object_type(obj));
  return(-1);
}


s7_pointer s7_make_object(s7_scheme *sc, int type, void *value)
{
  s7_pointer x;

  NEW_CELL(sc, x);
  object_type(x) = type;
  object_value(x) = value;
  set_type(x, T_C_OBJECT | T_DONT_COPY); /* free_object checks that the free function exists */

  if (object_types[type].apply)
    {
      object_ref(x) = object_types[type].apply;
      if (object_ref(x) != fallback_ref)
	typeflag(x) |= T_PROCEDURE; /* this is not always safe (pws) */
    }
  else object_ref(x) = fallback_ref;

  if (object_types[type].set)
    object_set(x) = object_types[type].set;
  else object_set(x) = fallback_set;

  add_c_object(sc, x);
  return(x);
}


static s7_pointer object_length(s7_scheme *sc, s7_pointer obj)
{
  return((*(object_types[object_type(obj)].length))(sc, obj));
}


static s7_pointer object_copy(s7_scheme *sc, s7_pointer obj)
{
  int tag;
  tag = object_type(obj);
  if (object_types[tag].copy)
    return((*(object_types[tag].copy))(sc, obj));

  return(eval_error(sc, "attempt to copy ~A?", obj));
}


#define SAVE_X_Y_Z(X, Y, Z)	     \
  do {                               \
    X = ((is_null(sc->x)) ? -1 : s7_gc_protect(sc, sc->x));	\
    Y = ((is_null(sc->y)) ? -1 : s7_gc_protect(sc, sc->y));	\
    Z = ((is_null(sc->z)) ? -1 : s7_gc_protect(sc, sc->z));	\
  } while (0)

#define RESTORE_X_Y_Z(X, Y, Z)                \
  do {                                        \
    if (X == -1) sc->x = sc->NIL; else {sc->x = s7_gc_protected_at(sc, X); s7_gc_unprotect_at(sc, X);} \
    if (Y == -1) sc->y = sc->NIL; else {sc->y = s7_gc_protected_at(sc, Y); s7_gc_unprotect_at(sc, Y);} \
    if (Z == -1) sc->z = sc->NIL; else {sc->z = s7_gc_protected_at(sc, Z); s7_gc_unprotect_at(sc, Z);} \
    } while (0)


static s7_pointer object_reverse(s7_scheme *sc, s7_pointer obj)
{
  /* someday this should be embedded in the evaluator
   *    it's called only in g_reverse.
   */
  int tag;
  tag = object_type(obj);
  if ((object_types[tag].copy) &&
      (object_types[tag].length) &&
      (object_types[tag].set) &&
      (object_types[tag].apply))
    {
      s7_pointer new_obj, i_args, j_args, i_set_args, j_set_args;
      int new_obj_gc_loc, i_gc_loc, j_gc_loc, i_set_gc_loc, j_set_gc_loc;
      s7_Int i, j, len;
      int save_x = -1, save_y = -1, save_z = -1;

      SAVE_X_Y_Z(save_x, save_y, save_z);

      new_obj = object_copy(sc, obj);
      new_obj_gc_loc = s7_gc_protect(sc, new_obj);
      len = s7_integer(object_length(sc, obj));

      i_args = list_1(sc, make_mutable_integer(sc, 0));
      i_gc_loc = s7_gc_protect(sc, i_args);
      j_args = list_1(sc, make_mutable_integer(sc, len - 1));
      j_gc_loc = s7_gc_protect(sc, j_args);
      i_set_args = list_2(sc, car(i_args), sc->NIL);
      i_set_gc_loc = s7_gc_protect(sc, i_set_args);
      j_set_args = list_2(sc, car(j_args), sc->NIL);
      j_set_gc_loc = s7_gc_protect(sc, j_set_args);
      /* all that to reduce consing during the loop! */

      for (i = 0, j = len - 1; i < j; i++, j--)
	{
	  s7_pointer tmp;
	  integer(number(car(i_args))) = i;
	  integer(number(car(j_args))) = j;

	  tmp = (*(object_ref(obj)))(sc, obj, i_args);         /* tmp = obj[i] */
	  cadr(i_set_args) = (*(object_ref(obj)))(sc, obj, j_args);
	  (*(object_set(new_obj)))(sc, new_obj, i_set_args);         /* obj[i] = obj[j] */
	  cadr(j_set_args) = tmp;
	  (*(object_set(new_obj)))(sc, new_obj, j_set_args);         /* obj[j] = tmp */
	}

      s7_gc_unprotect_at(sc, i_gc_loc);
      s7_gc_unprotect_at(sc, j_gc_loc);
      s7_gc_unprotect_at(sc, i_set_gc_loc);
      s7_gc_unprotect_at(sc, j_set_gc_loc);
      s7_gc_unprotect_at(sc, new_obj_gc_loc);
      RESTORE_X_Y_Z(save_x, save_y, save_z);
		     
      return(new_obj);
    }

  return(s7_wrong_type_arg_error(sc, "reverse", 0, obj, "a reversible object"));
}


static s7_pointer object_to_vector(s7_scheme *sc, s7_pointer obj)
{
  int tag;
  tag = object_type(obj);
  if ((object_types[tag].length) &&
      (object_types[tag].set) &&
      (object_types[tag].apply))
    {
      s7_pointer vect, i_args;
      int vect_gc_loc, i_gc_loc;
      s7_Int i, len;
      int save_x = -1, save_y = -1, save_z = -1;

      SAVE_X_Y_Z(save_x, save_y, save_z);

      len = s7_integer(object_length(sc, obj));
      vect = make_vector_1(sc, len, NOT_FILLED, true);
      vect_gc_loc = s7_gc_protect(sc, vect);

      i_args = list_1(sc, make_mutable_integer(sc, 0));
      i_gc_loc = s7_gc_protect(sc, i_args);

      for (i = 0; i < len; i++)
	{
	  integer(number(car(i_args))) = i;
	  vector_element(vect, i) = (*(object_ref(obj)))(sc, obj, i_args);
	}

      RESTORE_X_Y_Z(save_x, save_y, save_z);
      s7_gc_unprotect_at(sc, i_gc_loc);
      s7_gc_unprotect_at(sc, vect_gc_loc);

      return(vect);
    }
  return(s7_wrong_type_arg_error(sc, "object->vector", 0, obj, "an object with length, set!, and get functions"));
}


static s7_pointer vector_to_object(s7_scheme *sc, s7_pointer vect, s7_pointer obj)
{
  int tag;
  tag = object_type(obj);
  if ((object_types[tag].length) &&
      (object_types[tag].set) &&
      (object_types[tag].apply))
    {
      s7_pointer i_args, i_set_args;
      int i_gc_loc, i_set_gc_loc;
      s7_Int i, len;
      int save_x = -1, save_y = -1, save_z = -1;

      SAVE_X_Y_Z(save_x, save_y, save_z);

      len = vector_length(vect);
      i_args = list_1(sc, make_mutable_integer(sc, 0));
      i_gc_loc = s7_gc_protect(sc, i_args);
      i_set_args = list_2(sc, car(i_args), sc->NIL);
      i_set_gc_loc = s7_gc_protect(sc, i_set_args);

      for (i = 0; i < len; i++)
	{
	  integer(number(car(i_args))) = i;
	  cadr(i_set_args) = vector_element(vect, i);
	  (*(object_set(obj)))(sc, obj, i_set_args);
	}

      RESTORE_X_Y_Z(save_x, save_y, save_z);
      s7_gc_unprotect_at(sc, i_gc_loc);
      s7_gc_unprotect_at(sc, i_set_gc_loc);

      return(obj);
    }
  return(s7_wrong_type_arg_error(sc, "vector->object", 0, obj, "an object with length, set!, and get functions"));
}



/* ---------------- scheme-level new types ---------------- */

typedef struct {
  int type;
  s7_pointer value;
} s_type_t;

/* this just holds the type tag locally!  Very bad planning!
 */


static char *call_s_object_print(s7_scheme *sc, void *value)
{
  /* value here is the s_type_t object, the (scheme) function to call is object_types[tag].print_func */
  /*   it will be passed the value, not the original object */

  s_type_t *obj = (s_type_t *)value;
  car(sc->s_function_args) = obj->value;
  return(copy_string((char *)s7_string(s7_call(sc, object_types[obj->type].print_func, sc->s_function_args))));
  /* object_print assumes the value returned here can be freed */
}


static  bool s_type_equal(s7_scheme *sc, void *a, void *b)
{
  /* this is the fallback if no equal func is specified */
  s_type_t *obj1 = (s_type_t *)a;
  s_type_t *obj2 = (s_type_t *)b;
  return(s7_is_equal(sc, obj1->value, obj2->value));
}


static bool call_s_object_equal(s7_scheme *sc, void *a, void *b)
{
  /* we get here if an equal func was specified in make-type */
  s_type_t *obj1 = (s_type_t *)a;
  s_type_t *obj2 = (s_type_t *)b;
  return(s7_boolean(sc, s7_call(sc, object_types[obj1->type].equal_func, list_2(sc, obj1->value, obj2->value))));
}


static s7_pointer call_s_object_getter(s7_scheme *sc, s7_pointer a, s7_pointer args)
{
  /* still accessible via for-each */
  s_type_t *obj;
  obj = (s_type_t *)s7_object_value(a);
  return(s7_call(sc, object_types[obj->type].getter_func, cons(sc, obj->value, args))); /* ?? */
}


static s7_pointer call_s_object_setter(s7_scheme *sc, s7_pointer a, s7_pointer args)
{
  /* still accessible via reverse, for-each */
  s_type_t *obj;
  obj = (s_type_t *)s7_object_value(a);
  return(s7_call(sc, object_types[obj->type].setter_func, cons(sc, obj->value, args))); /* ?? */
}


/* generalized set! calls g_internal_object_set which then calls the object's set function 
 */

static s7_pointer g_internal_object_set(s7_scheme *sc, s7_pointer args)
{
  return((*(object_set(car(args))))(sc, car(args), cdr(args)));
}


static s7_pointer call_s_object_length(s7_scheme *sc, s7_pointer a)
{
  s_type_t *obj;
  s7_pointer result;
  int save_x = -1, save_y = -1, save_z = -1;

  obj = (s_type_t *)s7_object_value(a);
  car(sc->s_function_args) = obj->value;
  SAVE_X_Y_Z(save_x, save_y, save_z);
  result = s7_call(sc, object_types[obj->type].length_func, sc->s_function_args);
  RESTORE_X_Y_Z(save_x, save_y, save_z);

  return(result);
}


/* s7_call in this context can lead to segfaults:
 *
 *    (call-with-exit (lambda (exit) (length ((cadr (make-type :length (lambda (a) (exit 32)))) 1))))
 *      [partly fixed; still callable via object_reverse and applicable_length]
 * 
 *    (call-with-exit (lambda (exit) (object->string ((cadr (make-type :print (lambda (a) (exit 32)))) 1))))
 *      [hard to fix -- very low level access to the method (atom_to_c_string)]
 *
 *    (call-with-exit (lambda (exit) (copy ((cadr (make-type :copy (lambda (a) (exit 32)))) 1))))
 *      [called in object_reverse and s7_copy, g_copy calls s7_copy]
 *      [hard to fix because hash-tables use s7_copy -- needs at least expansion of g_copy]
 *      [  and in g_copy we'd need another operator OP_S7_MAKE_OBJECT maybe, to handle the ]
 *      [  result = s7_make_object(sc, new_obj->type, (void *)new_obj) business after the  ]
 *      [  value has been copied.]
 *
 *    (call-with-exit (lambda (exit) (fill! ((cadr (make-type :fill (lambda (a n) (exit 32)))) 1) 0)))
 *      [fixed]
 *
 *    (call-with-exit (lambda (exit) (let ((typ (make-type :equal (lambda (a n) (exit 32))))) (equal? ((cadr typ) 1) ((cadr typ) 1)))))
 *      [callable via s7_is_equal and s7_is_equal_ci]
 *      [hard to fix: g_is_equal calls s7_is_equal, but here I think we could split out s_object_equal if equal_func exists]
 *
 *    reverse uses length and copy
 *
 * the *#readers*, *unbound-variable-hook* funcs have the same problem [symbol-bind]
 *   [reader funcs are s7_call'ed in check_sharp_readers called from make_sharp_constant]
 */ 


static s7_pointer call_s_object_copy(s7_scheme *sc, s7_pointer a)
{
  s_type_t *obj, *new_obj;

  obj = (s_type_t *)s7_object_value(a);
  car(sc->s_function_args) = obj->value;

  new_obj = (s_type_t *)calloc(1, sizeof(s_type_t));
  new_obj->type = obj->type;

  new_obj->value = s7_call(sc, object_types[new_obj->type].copy_func, sc->s_function_args);
  return(s7_make_object(sc, new_obj->type, (void *)new_obj));
}


static s7_pointer call_s_object_fill(s7_scheme *sc, s7_pointer a, s7_pointer val)
{
  /* I think this is no longer accessible */
  s_type_t *obj;
  obj = (s_type_t *)s7_object_value(a);
  return(s7_call(sc, object_types[obj->type].fill_func, list_2(sc, obj->value, val)));
}


static char *s_type_print(s7_scheme *sc, void *val)
{
  /* object_print assumes the string is allocated here */
  s_type_t *obj = (s_type_t *)val;
  char *str, *full_str;
  int len, tag;
  
  tag = obj->type;
  str = s7_object_to_c_string(sc, obj->value);
  len = safe_strlen(str) + safe_strlen(object_types[tag].name) + 16;
  full_str = (char *)calloc(len, sizeof(char));
  snprintf(full_str, len, "#<%s %s>", object_types[tag].name, str);
  free(str);
  return(full_str);
}


static void s_type_free(void *val)
{
  free(val);
}


static void s_type_gc_mark(void *val)
{
  s_type_t *obj = (s_type_t *)val;
  s7_mark_object(obj->value);
}


static s7_pointer s_is_type(s7_scheme *sc, s7_pointer args)
{
  if (is_c_object(cadr(args)))
    {
      s_type_t *obj;
      obj = (s_type_t *)s7_object_value(cadr(args));
      return(s7_make_boolean(sc, obj->type == s7_integer(car(args))));
    }
  return(sc->F);
}


static s7_pointer s_type_make(s7_scheme *sc, s7_pointer args)
{
  s_type_t *obj;
  obj = (s_type_t *)calloc(1, sizeof(s_type_t));
  obj->type = s7_integer(car(args));
  obj->value = cadr(args);
  return(s7_make_object(sc, obj->type, (void *)obj));
}


static s7_pointer s_type_ref(s7_scheme *sc, s7_pointer args)
{
  s7_pointer x;
  int tag;

  if (s7_is_integer(car(args)))
    {
      tag = s7_integer(car(args));
      x = cadr(args);
      if (is_c_object(x))
	{
	  s_type_t *obj;
	  obj = (s_type_t *)s7_object_value(x);
	  if (obj->type == tag)
	    return(obj->value);
	}

      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
		      list_4(sc, 
				  make_protected_string(sc, "~A type's 'ref' function argument, ~S, is ~A?"),
				  make_protected_string(sc, object_types[tag].name),
				  x,
				  make_protected_string(sc, type_name(x)))));
    }
  return(sc->F); /* someone has completely messed up */
}


static s7_pointer g_make_type(s7_scheme *sc, s7_pointer args)
{
  #define H_make_type "(make-type print equal getter setter length name copy fill) returns a new type object, \
a list of three functions: ?, make, and ref.  The '?' function returns #t if passed an argument of the new type, \
the 'make' function creates a new object of that type, and the 'ref' function returns the value of that object.\
The optional arguments to make-type are functions that specify how objects of the new type display themselves (print, 1 argument), \
check for equality (equal, 2 args, both will be of the new type), apply themselves to arguments, (getter, any number \
of args, see vector for an example), respond to the generalized set! and length generic functions, and finally, \
one special case: name sets the type name (a string), which only matters if you're not specifying the print function. \
In each case, the argument is the value of the object, not the object itself."

  int tag;

  tag = s7_new_type("anonymous-type", s_type_print, s_type_free, NULL, s_type_gc_mark, NULL, NULL);
  object_types[tag].equal = NULL;
  object_types[tag].scheme_equal = s_type_equal;

  if (is_not_null(args))
    {
      int i, args_loc = -1, func_loc = -1;
      s7_pointer x;

      args_loc = s7_gc_protect(sc, args);

      /* if any of the special functions are specified, store them in the type object so we can find them later.
       *    they also need to be GC-protected:
       *    (let ((ctr ((cadr (make-type :getter (lambda (a b) b))))))
       *      (gc)
       *      ;; any reference here to the getter is likely to fail if it hasn't been protected
       */
      for (i = 0, x = args; is_not_null(x); i++, x = cdr(x))
	{
	  s7_pointer func, proc_args;
	  int nargs = 0;
	  bool rest_arg = false;

	  /* the closure_star mechanism passes the args in declaration order */
	  func = car(x);
	  if (func != sc->F)            /* #f means arg was not set */
	    {
	      if (i != 5)
		{
		  if (!is_procedure(func))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, 
						  make_protected_string(sc, "make-type arg, ~A, should be a function"),
						  func)));
		    }
		  func_loc = s7_gc_protect(sc, func); /* this ought to be faster in the mark phase than checking every function field of every scheme type(?) */
		  proc_args = s7_procedure_arity(sc, func);
		  nargs = s7_integer(car(proc_args)) + s7_integer(cadr(proc_args));
		  rest_arg = (caddr(proc_args) != sc->F);
		}

	      switch (i)
		{
		case 0:                 /* print, ((cadr (make-type :print (lambda (a) (format #f "#<typo: ~S>" a)))) "gypo") -> #<typo: "gypo"> */
		  if ((s7_integer(car(proc_args)) > 1) || 
		      ((nargs == 0) && (!rest_arg)))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :print procedure, ~A, should take one argument"), func)));
		    }

		  object_types[tag].print_func = func;
		  object_types[tag].print = call_s_object_print;
		  break;

		case 1:                 /* equal */
		  /* (let ((typo (make-type :equal (lambda (a b) (equal? a b))))) (let ((a ((cadr typo) 123)) (b ((cadr typo) 321))) (equal? a b))) */
		  if ((s7_integer(car(proc_args)) > 2) || 
		      ((nargs < 2) && (!rest_arg)))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :equal procedure, ~A, should take two arguments"), func)));
		    }
		  object_types[tag].equal = NULL;
		  object_types[tag].equal_func = func;
		  object_types[tag].scheme_equal = call_s_object_equal;
		  break;

		case 2:                 /* getter: (((cadr (make-type :getter (lambda (a b) (vector-ref a b)))) (vector 1 2 3)) 1) -> 2 */
		  if ((nargs == 0) && (!rest_arg))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :getter procedure, ~A, should take at least one argument"), func)));
		    }
		  object_types[tag].getter_func = func;
		  object_types[tag].apply = call_s_object_getter;
		  break;

		case 3:                 /* setter: (set! (((cadr (make-type :setter (lambda (a b c) (vector-set! a b c)))) (vector 1 2 3)) 1) 23) */
		  if ((nargs < 2) && (!rest_arg))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :setter procedure, ~A, should take at least two arguments"), func)));
		    }
		  object_types[tag].setter_func = func;
		  object_types[tag].set = call_s_object_setter;
		  break;

		case 4:                 /* length: (length ((cadr (make-type :length (lambda (a) (vector-length a)))) (vector 1 2 3))) -> 3 */
		  if ((s7_integer(car(proc_args)) > 1) || 
		      ((nargs == 0) && (!rest_arg)))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :length procedure, ~A, should take at one argument"), func)));
		    }

		  object_types[tag].length_func = func;
		  object_types[tag].length = call_s_object_length;
		  break;

		case 5:                 /* name, ((cadr (make-type :name "hiho")) 123) -> #<hiho 123> */
		  if (!s7_is_string(func))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :name arg, ~S, should be a string"), func)));
		    }
		  object_types[tag].name = copy_string(s7_string(func));
		  break;

		case 6:                 /* copy */
		  if ((s7_integer(car(proc_args)) > 1) || 
		      ((nargs == 0) && (!rest_arg)))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :copy procedure, ~A, should take at one argument"), func)));
		    }
		  object_types[tag].copy_func = func;
		  object_types[tag].copy = call_s_object_copy;
		  break;

		case 7:                 /* fill */
		  if ((s7_integer(car(proc_args)) > 2) || 
		      ((nargs < 2) && (!rest_arg)))
		    {
		      s7_gc_unprotect_at(sc, args_loc);
		      if (func_loc != -1) s7_gc_unprotect_at(sc, func_loc);
		      return(s7_error(sc, sc->WRONG_TYPE_ARG, 
				      list_2(sc, make_protected_string(sc, "make-type :fill procedure, ~A, should take at two arguments"), func)));
		    }
		  object_types[tag].fill_func = func;
		  object_types[tag].fill = call_s_object_fill;
		  break;
		}
	    }
	}
      s7_gc_unprotect_at(sc, args_loc);
    }

  {
    s7_pointer result;
    int result_loc;
    result = list_3(sc, sc->NIL, sc->NIL, sc->NIL);
    result_loc = s7_gc_protect(sc, result);

    /* ? method: (lambda (arg) (s_is_type tag arg)) 
     *     returns #t if arg is of the new type
     */
    car(result) = make_closure(sc, list_2(sc, 
					       list_1(sc, sc->S_TYPE_ARG),
					       list_3(sc, sc->S_IS_TYPE, s7_make_integer(sc, tag), sc->S_TYPE_ARG)),
			       T_CLOSURE);

    /* make method: (lambda* (arg) (s_type_make tag arg))
     *   returns an object of the new type with its value specified by arg (defaults to #f)
     */
    cadr(result) = make_closure(sc, list_2(sc, 
						list_1(sc, sc->S_TYPE_ARG),
						list_3(sc, sc->S_TYPE_MAKE, s7_make_integer(sc, tag), sc->S_TYPE_ARG)),
				T_CLOSURE_STAR);

    /* ref method: (lambda (arg) (s_type_ref arg))
     *   returns the value passed to make above 
     */
    caddr(result) = make_closure(sc, list_2(sc, 
						 list_1(sc, sc->S_TYPE_ARG),
						 list_3(sc, sc->S_TYPE_REF, s7_make_integer(sc, tag), sc->S_TYPE_ARG)),
				 T_CLOSURE);
    s7_gc_unprotect_at(sc, result_loc);
    return(result);
  }
}

/* here it would be neat if we allowed any keywords, and those not handled explicitly could
 *    be added to the methods list under the key-word->symbol name.  define* without the need
 *    to state in advance what keys -- undeclared key would be bound in the func env under its
 *    name and value -- define+?  -- the extra args would be in an alist accessible under
 *    the rest arg name?  
 */




/* -------- procedure-with-setter -------- */

s7_pointer s7_make_procedure_with_setter(s7_scheme *sc, 
					 const char *name,
					 s7_pointer (*getter)(s7_scheme *sc, s7_pointer args), 
					 int get_req_args, int get_opt_args,
					 s7_pointer (*setter)(s7_scheme *sc, s7_pointer args),
					 int set_req_args, int set_opt_args,
					 const char *documentation)
{
  /* on the C side, we merely define the two functions, and set the getter's setter, so there
   *   is no separate pws object.
   */
  s7_pointer get_func, set_func;
  char *internal_set_name;
  int len;

  len = 16 + safe_strlen(name);
  internal_set_name = (char *)calloc(len, sizeof(char));
  snprintf(internal_set_name, len, "[set-%s]", name);

  get_func = s7_make_function(sc, name, getter, get_req_args, get_opt_args, false, documentation); 
  typeflag(get_func) |= T_SAFE_PROCEDURE;
  s7_define(sc, sc->NIL, make_symbol(sc, name), get_func);
  set_func = s7_make_function(sc, internal_set_name, setter, set_req_args, set_opt_args, false, documentation); 
  typeflag(set_func) |= T_SAFE_PROCEDURE;
  s7_define(sc, sc->NIL, make_symbol(sc, internal_set_name), set_func);
  c_function_setter(get_func) = set_func;

  return(get_func);
}
  

static int pws_tag;

typedef struct {
  s7_pointer (*getter)(s7_scheme *sc, s7_pointer args);
  int get_req_args, get_opt_args;
  s7_pointer (*setter)(s7_scheme *sc, s7_pointer args);
  int set_req_args, set_opt_args;
  s7_pointer scheme_getter;
  s7_pointer scheme_setter;
  char *documentation;
  char *name;
} s7_pws_t;


static char *pws_print(s7_scheme *sc, void *obj)
{
  s7_pws_t *f = (s7_pws_t *)obj;
  if (f->name)
    return(copy_string(f->name));
  return(copy_string((char *)"#<procedure-with-setter>"));
}


static void pws_free(void *obj)
{
  s7_pws_t *f = (s7_pws_t *)obj;
  if (f)
    {
      if (f->documentation)
	free(f->documentation);
      if (f->name)
	free(f->name);
      free(f);
    }
}


static void pws_mark(void *val)
{
  s7_pws_t *f = (s7_pws_t *)val;
  S7_MARK(f->scheme_getter);
  S7_MARK(f->scheme_setter);
}


static bool pws_equal(void *obj1, void *obj2)
{
  return(obj1 == obj2);
}


static s7_pointer pws_apply(s7_scheme *sc, s7_pointer obj, s7_pointer args)
{
  /* this is called as the pws object apply method, not as the actual getter */
  s7_pws_t *f;

  f = (s7_pws_t *)s7_object_value(obj);
  if (f->getter != NULL)
    {
      /* this is the c_function case */
      int len;

      len = safe_list_length(sc, args);
      if (len < f->get_req_args)
	return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			list_3(sc, sc->NOT_ENOUGH_ARGUMENTS, obj, args)));

      if (len > (f->get_req_args + f->get_opt_args))
	return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			list_3(sc, sc->TOO_MANY_ARGUMENTS, obj, args)));

      return((*(f->getter))(sc, args));
    }

  push_stack(sc, OP_APPLY, args, f->scheme_getter);
  return(sc->F);
}


static s7_pointer pws_set(s7_scheme *sc, s7_pointer obj, s7_pointer args)
{
  /* this is the pws set method, not the actual setter */
  s7_pws_t *f;

  f = (s7_pws_t *)s7_object_value(obj);
  if (f->setter != NULL)
    {
      /* this is the c_function case */
      int len;

      len = safe_list_length(sc, args);
      if (len < f->set_req_args)
	return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			list_3(sc, sc->NOT_ENOUGH_ARGUMENTS, obj, args)));

      if (len > (f->set_req_args + f->set_opt_args))
	return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			list_3(sc, sc->TOO_MANY_ARGUMENTS, obj, args)));

      return((*(f->setter))(sc, args));
    }

  push_stack(sc, OP_APPLY, args, f->scheme_setter);
  return(sc->F);
}


static s7_pointer pws_arity(s7_scheme *sc, s7_pointer obj)
{
  s7_pws_t *f;
  f = (s7_pws_t *)s7_object_value(obj);

  return(cons(sc, s7_make_integer(sc, f->get_req_args),
	   cons(sc, s7_make_integer(sc, f->get_opt_args),
		cons(sc, sc->F, sc->NIL))));
}


static s7_pointer g_make_procedure_with_setter(s7_scheme *sc, s7_pointer args)
{
  #define H_make_procedure_with_setter "(make-procedure-with-setter getter setter) combines its \
two function arguments as a procedure-with-setter.  The 'getter' is called unless the procedure \
occurs as the object of set!."

  s7_pointer p, getter, setter, arity;
  s7_pws_t *f;
  int gc_loc;
  /* the two args should be functions, the setter taking one more arg than the getter */

  getter = car(args);
  if (!is_procedure(getter))
    return(s7_wrong_type_arg_error(sc, "make-procedure-with-setter getter,", 1, getter, "a procedure"));
  setter = cadr(args);
  if (!is_procedure(setter))
    return(s7_wrong_type_arg_error(sc, "make-procedure-with-setter setter,", 2, setter, "a procedure"));

  f = (s7_pws_t *)calloc(1, sizeof(s7_pws_t));
  p = s7_make_object(sc, pws_tag, (void *)f);
  typeflag(p) |= T_PROCEDURE;
  gc_loc = s7_gc_protect(sc, p);

  f->scheme_getter = getter;
  f->scheme_setter = setter;

  arity = s7_procedure_arity(sc, getter); /* calls cons -- might trigger GC, so setter/getter fields need to be set for s7_mark */
  if (is_pair(arity))
    f->get_req_args = s7_integer(car(arity));
  f->documentation = copy_string(s7_procedure_documentation(sc, getter)); /* pws might be GC'd whereupon the doc string is freed */
  
  arity = s7_procedure_arity(sc, setter);
  if (is_pair(arity))
    f->set_req_args = s7_integer(car(arity));
  
  s7_gc_unprotect_at(sc, gc_loc);
  return(p);
}


bool s7_is_procedure_with_setter(s7_pointer obj)
{
  return((is_c_object(obj)) &&
	 (object_type(obj) == pws_tag));
}


s7_pointer s7_procedure_getter(s7_scheme *sc, s7_pointer obj)
{
  if (is_c_function(obj))
    return(obj);

  if (s7_is_procedure_with_setter(obj))
    {
      s7_pws_t *f;
      f = (s7_pws_t *)s7_object_value(obj);
      return(f->scheme_getter);
    }
  
  return(sc->NIL);
}


s7_pointer s7_procedure_setter(s7_scheme *sc, s7_pointer obj)
{
  if (is_c_function(obj))     /* this includes pws via ffi */
    return(c_function_setter(obj));

  if (s7_is_procedure_with_setter(obj))
    {
      s7_pws_t *f;
      f = (s7_pws_t *)s7_object_value(obj);
      return(f->scheme_setter);
    }

  return(sc->NIL);
}


static s7_pointer g_procedure_setter(s7_scheme *sc, s7_pointer args)
{
  #define H_procedure_setter "(procedure-setter obj) returns the setter associated with obj, or #f"
  return(s7_procedure_setter(sc, car(args)));
}


static s7_pointer g_is_procedure_with_setter(s7_scheme *sc, s7_pointer args)
{
  #define H_is_procedure_with_setter "(procedure-with-setter? obj) returns #t if obj is a procedure-with-setter"
  return(make_boolean(sc, s7_is_procedure_with_setter(car(args))));
}


static char *pws_documentation(s7_pointer x)
{
  s7_pws_t *f = (s7_pws_t *)s7_object_value(x);
  return(f->documentation);
}


static s7_pointer pws_source(s7_scheme *sc, s7_pointer x)
{
  s7_pws_t *f;
  f = (s7_pws_t *)s7_object_value(x);
  if ((is_closure(f->scheme_getter)) ||
      (is_closure_star(f->scheme_getter)))
    return(append_in_place(sc, 
			   list_2(sc,
				       (is_closure(f->scheme_getter)) ? sc->LAMBDA : sc->LAMBDA_STAR,
				       closure_args(f->scheme_getter)),
			   closure_body(f->scheme_getter)));
  return(sc->NIL);
}


void s7_define_function_with_setter(s7_scheme *sc, const char *name, s7_function get_fnc, s7_function set_fnc, int req_args, int opt_args, const char *doc)
{
  s7_make_procedure_with_setter(sc, name, get_fnc, req_args, opt_args, set_fnc, req_args + 1, opt_args, doc);
}


static bool args_match(s7_scheme *sc, s7_pointer x, int args)
{
  switch (type(x))
    {
    case T_C_ANY_ARGS_FUNCTION:
    case T_C_OPT_ARGS_FUNCTION:
    case T_C_RST_ARGS_FUNCTION:
    case T_C_LST_ARGS_FUNCTION:
    case T_C_FUNCTION:
      return(((int)c_function_required_args(x) <= args) &&
	     ((int)c_function_all_args(x) >= args));

    case T_CLOSURE:
      return((s7_is_symbol(closure_args(x))) ||
	     (safe_list_length(sc, closure_args(x)) == args));

    case T_CLOSURE_STAR:
      return((s7_is_symbol(closure_args(x))) ||
	     (safe_list_length(sc, closure_args(x)) >= args));

    case T_C_OBJECT:
      if (object_type(x) == pws_tag)
	{
	  s7_pws_t *f;
	  if (is_not_null(s7_procedure_getter(sc, x))) /* a scheme function in this case */
	    return(args_match(sc, s7_procedure_getter(sc, x), 2));

	  f = (s7_pws_t *)s7_object_value(x);	  
	  return((f->get_req_args <= args) &&
		 ((f->get_req_args + f->get_opt_args) >= args));
	}

    case T_PAIR:
    case T_VECTOR:
    case T_HASH_TABLE:
    case T_STRING:
      return(args == 1); /* TODO: this is a stopgap */

      
      /* pws is a special case because the direct value is the getter procedure 
       *   (let ((p (make-procedure-with-setter < > ))) (procedure? p)) -> #t
       *   (procedure? ((cadr (make-type)) (lambda () 1))) -> #f
       */
    }
  return(false);
}


static bool is_thunk(s7_scheme *sc, s7_pointer x)
{
  switch (type(x))
    {
    case T_C_FUNCTION:
      return(c_function_all_args(x) == 0);

    case T_CLOSURE:
    case T_CLOSURE_STAR:
      return(is_null(caar(x)));

    case T_C_OBJECT:
      if (object_type(x) == pws_tag)
	{
	  s7_pws_t *f;
	  if (is_not_null(s7_procedure_getter(sc, x))) /* a scheme function in this case */
	    return(is_thunk(sc, s7_procedure_getter(sc, x)));

	  f = (s7_pws_t *)s7_object_value(x);	  
	  return((f->get_req_args == 0) &&
		 (f->get_opt_args == 0));
	}
    }
  return(false);
}




/* -------------------------------- symbol-access ------------------------------------------------ */
/*
 * originally in Snd I wanted notification when a variable was set, and it's not very pretty
 *      to have to use pws's everywhere.  Here (s7) we have constants and tracing.
 *
 * these are in the same realm:
 *   typed var: restrict set! to the desired type or do auto-conversions
 *   constant: disallow set!
 *   traced var: report either read/write
 *   keywords: can't set or bind, always return self as value
 *
 * and related (but much messier to implement):
 *   fluid-let: dynamic until exit (call/cc error normal)
 *   dynamic variables: insist any ref is to the current binding [dynamic-let]
 *
 * a value wrapper or transparent object won't work:
 * (define-macro (trace sym)
 *   `(set! ,sym (wrap ,sym :setter (lambda (binding a) (format #t "~A set to ~A~%" (car binding) a)))))
 * 
 * (define-macro (untrace sym)
 *   `(set! ,sym ,sym) ??? -- oops...
 *
 * (symbol-access sym) -- a pws, if set! it affects the current binding actions.
 *   the actions are local to the current environment, so
 *   we automatically undo the local accessors when leaving the current scope.
 *   a list of 3 funcs: getter setter binder -- rest is ignored so that
 *   trace can save the current accessors in cadddr of the symbol-access list, 
 *   untrace uses that to restore the old form, etc
 *
 * (define (notify-if-set var notifier) ; returns #t if it's ok to set
 *   (set! (symbol-access) 
 *         (list #f (lambda (symbol new-value) (or (notifier symbol new-value) new-value)) #f)))
 */


s7_pointer s7_symbol_access(s7_scheme *sc, s7_pointer sym)
{
  if (symbol_accessor(sym) >= 0)
    return(s7_gc_protected_at(sc, symbol_accessor(sym)));
  return(sc->F);
}


s7_pointer s7_symbol_set_access(s7_scheme *sc, s7_pointer symbol, s7_pointer funcs)
{
  if (symbol_accessor(symbol) >= 0)
    s7_gc_unprotect_at(sc, symbol_accessor(symbol));

  if ((is_pair(funcs)) &&
      (s7_list_length(sc, funcs) >= 3) &&
      ((is_procedure(car(funcs))) ||
       (is_procedure(cadr(funcs))) ||
       (is_procedure(caddr(funcs)))))
    symbol_accessor(symbol) = s7_gc_protect(sc, funcs);
  else symbol_accessor(symbol) = -1;
  return(funcs);
}


static s7_pointer g_symbol_get_access(s7_scheme *sc, s7_pointer args)
{
  #define H_symbol_access "(symbol-access sym) is a procedure-with-setter that adds or removes controls on how a \
symbol accesses its current binding."

  if (!s7_is_symbol(car(args)))
    return(s7_wrong_type_arg_error(sc, "symbol-access,", 0, car(args), "a symbol"));
  return(s7_symbol_access(sc, car(args)));
}


static s7_pointer g_symbol_set_access(s7_scheme *sc, s7_pointer args)
{
  s7_pointer sym, funcs;
  sym = car(args);
  if (!s7_is_symbol(sym))
    return(s7_wrong_type_arg_error(sc, "set! symbol-access,", 1, sym, "a symbol"));

  funcs = cadr(args);
  if (funcs != sc->F)
    {
      if ((!is_pair(funcs)) ||
	  (s7_list_length(sc, funcs) != 3))
	return(s7_wrong_type_arg_error(sc, "set! symbol-access,", 2, funcs, "a list of 3 settings"));	
      if ((is_procedure(car(funcs))) && (!args_match(sc, car(funcs), 2)))
	return(s7_wrong_type_arg_error(sc, "set! symbol-access get function,", 2, car(funcs), "a procedure of 2 arguments"));	
      if ((is_procedure(cadr(funcs))) && (!args_match(sc, cadr(funcs), 2)))
	return(s7_wrong_type_arg_error(sc, "set! symbol-access set function,", 2, cadr(funcs), "a procedure of 2 arguments"));	
      if ((is_procedure(caddr(funcs))) && (!args_match(sc, caddr(funcs), 2)))
	return(s7_wrong_type_arg_error(sc, "set! symbol-access bind function,", 2, caddr(funcs), "a procedure of 2 arguments"));	
    }
  return(s7_symbol_set_access(sc, sym, funcs));
}


static s7_pointer call_symbol_accessor(s7_scheme *sc, s7_pointer symbol, s7_pointer new_value, s7_pointer func)
{
  /* this happens in contexts that are tricky to implement with a clean use of the evaluator stack (as in
   *   the parallel symbol set case), so we need to use s7_call.  But if an uncaught error
   *   occurs in s7_call, the error handler marches up the stack looking for a catch, unwinding the stack
   *   past the point of the call.  In the worst case, we can segfault because any subsequent pop_stack
   *   (i.e. an unchecked goto START), walks off the start of the stack. 
   */
   
  car(sc->T2_1) = symbol;
  car(sc->T2_2) = new_value;

  if (is_c_function(func))
    new_value = c_function_call(func)(sc, sc->T2_1);
  else
    {
      bool old_off;
      old_off = sc->gc_off;
      sc->gc_off = true;
      new_value = s7_call(sc, func, sc->T2_1);
      sc->gc_off = old_off;
    }
  if (new_value == sc->ERROR)
    return(s7_error(sc, sc->ERROR,
		    list_3(sc, make_protected_string(sc, "can't bind ~S to ~S"), symbol, car(sc->T2_2))));
  return(new_value);
}


static s7_pointer call_symbol_bind(s7_scheme *sc, s7_pointer symbol, s7_pointer new_value)
{
  s7_pointer func;
  func = caddr(s7_gc_protected_at(sc, symbol_accessor(symbol)));
  if (is_procedure(func))
    return(call_symbol_accessor(sc, symbol, new_value, func));
  return(new_value);
}


static s7_pointer call_symbol_set(s7_scheme *sc, s7_pointer symbol, s7_pointer new_value)
{
  s7_pointer func;
  func = cadr(s7_gc_protected_at(sc, symbol_accessor(symbol)));
  if (is_procedure(func))
    return(call_symbol_accessor(sc, symbol, new_value, func));
  return(new_value);
}


void *s7_symbol_accessor_data(s7_pointer sym)
{
  return(symbol_accessor_data(sym));
}

void s7_symbol_set_accessor_data(s7_pointer sym, void *val)
{
  symbol_accessor_data(sym) = val;
}


#if WITH_OPTIMIZATION

bool s7_in_safe_do(s7_scheme *sc)
{
  return(sc->safe_do_level > 0);
}

static void safe_do_set_id(s7_scheme *sc, long long int id)
{
  if (sc->safe_do_level >= sc->safe_do_ids_size)
    {
      sc->safe_do_ids_size = sc->safe_do_level * 2;
      sc->safe_do_ids = (long long int *)realloc(sc->safe_do_ids, sc->safe_do_ids_size * sizeof(long long int));
    }
  sc->safe_do_ids[sc->safe_do_level] = id;
}

bool s7_is_do_local(s7_scheme *sc, s7_pointer symbol)
{
  return(sc->safe_do_ids[sc->safe_do_level] == symbol_id(symbol));
}

bool s7_is_do_local_or_global(s7_scheme *sc, s7_pointer symbol)
{
  return(sc->safe_do_ids[sc->safe_do_level] >= symbol_id(symbol));
}

bool s7_is_do_global(s7_scheme *sc, s7_pointer symbol)
{
  return(sc->safe_do_ids[sc->safe_do_level] > symbol_id(symbol));
}

#else

bool s7_in_safe_do(s7_scheme *sc)
{
  return(false);
}

bool s7_is_do_local(s7_scheme *sc, s7_pointer symbol)
{
  return(false);
}

bool s7_is_do_local_or_global(s7_scheme *sc, s7_pointer symbol)
{
  return(false);
}

bool s7_is_do_global(s7_scheme *sc, s7_pointer symbol)
{
  return(false);
}

#endif




/* -------------------------------- hooks -------------------------------- */


static bool is_function_with_arity(s7_pointer x)
{
  /* hook function lists are more restrictive than s7_is_procedure which accepts things like continuations */
  int typ;
  typ = type(x);
  return((typ == T_CLOSURE) || 
	 (typ == T_CLOSURE_STAR) ||
	 (typ >= T_C_FUNCTION) ||
	 (s7_is_procedure_with_setter(x)));
}


static bool function_arity_ok(s7_scheme *sc, s7_pointer hook, s7_pointer func)
{
  /* when a function is added to a hook, we need to check that its arity is compatible
   *   with the hook arity.  The function must accept the hook's required number of
   *   arguments, and optionally accept any optional hook arguments.  If the hook
   *   has a rest argument, the function must have one too.
   */
  s7_pointer func_args, hook_args;
  int hook_req = 0, hook_opt = 0, func_req = 0, func_opt = 0;
  bool hook_rst = false, func_rst = false;

  func_args = s7_procedure_arity(sc, func);
  func_req = s7_integer(car(func_args));

  hook_args = hook_arity(hook);
  hook_req = s7_integer(car(hook_args));

  if (hook_req < func_req) return(false); /* func requires too many args */

  func_rst = is_true(sc, caddr(func_args));
  hook_rst = is_true(sc, caddr(hook_args));

  if (func_rst) return(true);             /* func required args are ok, and it has a rest arg, so it matches */
  if (hook_rst) return(false);            /* func has no rest, hook has rest -- can't be safe */

  /* both rest args are false, hook-req >= func-req */
  func_opt = s7_integer(cadr(func_args));
  hook_opt = s7_integer(cadr(hook_args));

  /* most args hook handles must be <= most func handles */
  if ((hook_req + hook_opt) <= (func_req + func_opt)) return(true);
  return(false);
}


bool s7_is_hook(s7_pointer p)
{
  return(is_hook(p));
}


s7_pointer s7_hook_functions(s7_pointer hook)
{
  return(hook_functions(hook));
}


s7_pointer s7_hook_set_functions(s7_pointer hook, s7_pointer functions)
{
  if (is_pair(functions))
    hook_functions(hook) = functions;
  return(hook_functions(hook));
}


s7_pointer s7_hook_arity(s7_pointer hook)
{
  return(hook_arity(hook));
}


const char *s7_hook_documentation(s7_pointer hook)
{
  return(string_value(hook_documentation(hook)));
}


s7_pointer s7_make_hook(s7_scheme *sc, int required_args, int optional_args, bool rest_arg, const char *documentation) 
{
  /* arg order follows s7_make_function */
  s7_pointer x;
  NEW_CELL(sc, x);
  hook_arity(x) = list_3(sc, 
			      s7_make_integer(sc, required_args), 
			      s7_make_integer(sc, optional_args), 
			      make_boolean(sc, rest_arg));
  hook_functions(x) = sc->NIL;
  hook_documentation(x) = s7_make_string(sc, documentation);
  set_type(x, T_HOOK | T_DONT_COPY); /* not sure about this */
  return(x);
}


static s7_pointer hook_copy(s7_scheme *sc, s7_pointer hook)
{
  s7_pointer new_hook, arity;
  int gc_loc;

  arity = hook_arity(hook);
  new_hook = s7_make_hook(sc, s7_integer(car(arity)), s7_integer(cadr(arity)), s7_boolean(sc, caddr(arity)), s7_string(hook_documentation(hook)));
  if (is_null(hook_functions(hook)))
    return(new_hook);

  gc_loc = s7_gc_protect(sc, new_hook);
  hook_functions(new_hook) = copy_list(sc, hook_functions(hook));
  s7_gc_unprotect_at(sc, gc_loc);
  return(new_hook);
}


s7_pointer s7_hook_apply(s7_scheme *sc, s7_pointer hook, s7_pointer args)
{
  if (is_pair(hook_functions(hook)))
    {
      int gc_loc;
      s7_pointer x;
      gc_loc = s7_gc_protect(sc, args);
      for (x = hook_functions(hook); is_not_null(x); x = cdr(x))
	s7_call(sc, car(x), args);
      s7_gc_unprotect_at(sc, gc_loc);
    }
  return(sc->UNSPECIFIED);
}


static s7_pointer g_is_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_is_hook "(hook? obj) returns #t if obj is a hook"
  return(make_boolean(sc, is_hook(car(args))));
}


static s7_pointer g_make_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_make_hook "(make-hook (arity (1 0 #f)) (doc \"\")) returns a new hook.  'arity' is a list \
describing the argument list that the hook-functions will see: (list required optional rest). \
It defaults to no arguments: '(0 0 #f).  Any function added to the hook's list has to be compatible \
with the hook arity.  'doc' is a documentation string."

  s7_pointer x;
  NEW_CELL(sc, x);

  if (is_not_null(args))
    {
      s7_pointer arity;
      arity = car(args);
      if (is_pair(arity))
	{
	  s7_Int req, opt;
	  if ((s7_list_length(sc, arity) != 3) ||
	      (!s7_is_integer(car(arity))) ||
	      (!s7_is_integer(cadr(arity))) ||
	      (!s7_is_boolean(caddr(arity))))
	    return(s7_wrong_type_arg_error(sc, "make-hook", (is_null(cdr(args))) ? 0 : 1, arity, "an arity list: (required optional rest)"));
	  req = s7_integer(car(arity));
	  opt = s7_integer(cadr(arity));
	  if ((req < 0) ||
	      (opt < 0))
	    return(s7_wrong_type_arg_error(sc, "make-hook", (is_null(cdr(args))) ? 0 : 1, arity, "number of args can't be negative"));
	  hook_arity(x) = arity; 
	}
      else 
	{
	  /* backwards compatibility -- this used to be just an integer => required args */
	  if (s7_is_integer(arity))
	    {
	      if (s7_integer(arity) < 0)
		return(s7_wrong_type_arg_error(sc, "make-hook", (is_null(cdr(args))) ? 0 : 1, arity, "a non-negative integer, or an arity list: (required optional rest)"));
	      hook_arity(x) = list_3(sc, arity, small_int(0), sc->F);
	    }
	  else return(s7_wrong_type_arg_error(sc, "make-hook", (is_null(cdr(args))) ? 0 : 1, arity, "an arity list: (required optional rest)"));
	}

      if (is_not_null(cdr(args)))
	{
	  s7_pointer doc;
	  doc = cadr(args);
	  if (s7_is_string(doc))
	    hook_documentation(x) = doc;
	  else return(s7_wrong_type_arg_error(sc, "make-hook", 2, doc, "a string"));
	}
      else hook_documentation(x) = s7_make_string(sc, "");
    }
  else 
    {
      hook_arity(x) = list_3(sc, small_int(0), small_int(0), sc->F);
      hook_documentation(x) = s7_make_string(sc, "");
    }

  hook_functions(x) = sc->NIL;

  set_type(x, T_HOOK | T_DONT_COPY);
  return(x);
}


static s7_pointer g_hook(s7_scheme *sc, s7_pointer args)
{
  #define H_hook "(hook ...) returns a new hook object with its arguments (all functions) \
as the initial hook-functions list, and taking its arity from those functions.  This is a \
convenient short-hand similar to (vector ...) or (list ...).  The hook arity is that of the \
first function in the list, or '(0 0 #f) if there are no functions.  All the other functions \
must be compatible with the arity of the first."

  s7_pointer x, hook;
  int i, gc_loc;
  
  if (is_null(args))
    return(s7_make_hook(sc, 0, 0, false, NULL));

  for (i = 1, x = args; is_pair(x); x = cdr(x), i++)
    if (!is_function_with_arity(car(x)))
      return(s7_wrong_type_arg_error(sc, "hook", i, car(x), "a function"));

  hook = g_make_hook(sc, cons(sc, s7_procedure_arity(sc, car(args)), sc->NIL));
  hook_functions(hook) = args;
  gc_loc = s7_gc_protect(sc, hook);
  
  for (i = 2, x = cdr(args); is_pair(x); x = cdr(x), i++)
    if (!function_arity_ok(sc, hook, car(x)))
      {
	s7_gc_unprotect_at(sc, gc_loc);
	return(s7_wrong_type_arg_error(sc, "hook", i, car(x), "compatible function"));
      }
  s7_gc_unprotect_at(sc, gc_loc);
  return(hook);
}


static s7_pointer g_hook_functions(s7_scheme *sc, s7_pointer args)
{
  #define H_hook_functions "(hook-functions hook) returns the list of functions on the hook. \
It is settable;  (set! (hook-functions hook) (cons func (hook-functions hook))) adds func \
to the current list."

  if (!is_hook(car(args)))
    return(s7_wrong_type_arg_error(sc, "hook-functions", 0, car(args), "a hook"));

  return(hook_functions(car(args)));
}


static s7_pointer g_hook_set_functions(s7_scheme *sc, s7_pointer args)
{
  s7_pointer hook, funcs;
  hook = car(args);

  if (!is_hook(hook))
    return(s7_wrong_type_arg_error(sc, "hook-functions", 1, hook, "a hook"));

  funcs = cadr(args);
  if (!s7_is_list(sc, funcs))
    return(s7_wrong_type_arg_error(sc, "hook-functions", 2, funcs, "a list of functions or '()"));

  if (is_pair(funcs))
    {
      s7_pointer x, y;
      for (x = funcs, y = funcs; is_pair(x); x = cdr(x), y = cdr(y))
	{
	  if (!is_function_with_arity(car(x)))
	    return(s7_wrong_type_arg_error(sc, "hook-functions", 2, funcs, "a list of functions"));
	  if (!function_arity_ok(sc, hook, car(x)))
	    return(s7_wrong_type_arg_error(sc, "hook-functions", 2, funcs, "a list of functions of the correct arity"));
	  if (is_pair(y)) 
	    {
	      y = cdr(y);
	      if (x == y)
		return(s7_wrong_type_arg_error(sc, "hook-functions", 2, funcs, "a proper (non-circular) list of functions"));
	    }
	}
      if (is_not_null(x))
	return(s7_wrong_type_arg_error(sc, "hook-functions", 2, funcs, "a proper list of functions"));
    }

  hook_functions(hook) = funcs;
  return(funcs);
}


static s7_pointer g_hook_arity(s7_scheme *sc, s7_pointer args)
{
  #define H_hook_arity "(hook-arity hook) returns the hook's arity, a list giving the number \
of required arguments, optional arguments, and whether there is a rest argument.  Each function \
on the hook's function list has to be applicable to a list of arguments compatible with this description."

  if (!is_hook(car(args)))
    return(s7_wrong_type_arg_error(sc, "hook-arity", 0, car(args), "a hook"));

  return(hook_arity(car(args)));
}


static s7_pointer g_hook_documentation(s7_scheme *sc, s7_pointer args)
{
  #define H_hook_documentation "(hook-documentation hook) returns the documentation associated \
with the hook."

  if (!is_hook(car(args)))
    return(s7_wrong_type_arg_error(sc, "hook-documentation", 0, car(args), "a hook"));

  return(hook_documentation(car(args)));
}


static s7_pointer g_hook_apply(s7_scheme *sc, s7_pointer args)
{
  #define H_hook_apply "(hook-apply hook ...) applies each function in the hook's function \
list to the trailing arguments of hook-apply."

  s7_pointer hook, hook_args;

  hook = car(args);
  if (!is_hook(hook))
    return(s7_wrong_type_arg_error(sc, "hook-apply", 1, hook, "a hook"));

  if (is_null(cdr(args)))
    hook_args = sc->NIL;
  else 
    {
      hook_args = apply_list_star(sc, cdr(args));

      if (!is_proper_list(sc, hook_args))        /* (hook-apply + #f) etc */
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, 
				    make_protected_string(sc, "hook-apply's last argument should be a proper list: ~A"),
				    hook_args)));
    }

  if (caddr(hook_arity(hook)) == sc->F)
    {
      int arg_num;
      arg_num = safe_list_length(sc, hook_args);
      if ((arg_num < s7_integer(car(hook_arity(hook)))) ||
	  (arg_num > (s7_integer(car(hook_arity(hook))) + s7_integer(cadr(hook_arity(hook))))))
	return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			list_3(sc, 
				    make_protected_string(sc, "hook passed wrong number of args: ~A (arity: ~A)"),
				    hook_args,
				    hook_arity(hook))));
    }

  if (is_pair(hook_functions(hook)))
    push_stack(sc, OP_HOOK_APPLY, hook_args, hook_functions(hook));

  return(sc->UNSPECIFIED);
}


static bool hooks_are_equal(s7_scheme *sc, s7_pointer x, s7_pointer y)
{
  return(s7_is_equal(sc, hook_arity(x), hook_arity(y)) &&
	 s7_is_equal(sc, hook_functions(x), hook_functions(y)));
}


static bool internal_hook_arity_ok(s7_scheme *sc, s7_pointer hook, s7_pointer funcs)
{
  s7_pointer x;
  for (x = funcs; is_pair(x); x = cdr(x))
    if ((!is_function_with_arity(car(x))) ||
	(!function_arity_ok(sc, hook, car(x))))
      return(false);
  return(is_null(x));
}


static s7_pointer g_trace_hook_set(s7_scheme *sc, s7_pointer args)
{
  /* in normal use, we'd (set! (hook-functions *trace-hook*) ...), but for backwards compatibility,
   *   we also need to support (set! *trace-hook* func).
   */
  s7_pointer funcs;
  funcs = cadr(args);
  if (s7_is_list(sc, funcs))
    {
      if (internal_hook_arity_ok(sc, sc->trace_hook, funcs))
	hook_functions(sc->trace_hook) = funcs;
      else return(sc->ERROR);;
    }
  else
    {
      if (s7_is_procedure(funcs))
	hook_functions(sc->trace_hook) = cons(sc, funcs, sc->NIL);
      else return(sc->ERROR);
    }
  return(sc->trace_hook); /* kinda pointless... */
}


static s7_pointer g_load_hook_set(s7_scheme *sc, s7_pointer args)
{
  /* in normal use, we'd (set! (hook-functions *load-hook*) ...), but for backwards compatibility,
   *   we also need to support (set! *load-hook* func).
   */
  s7_pointer funcs;
  funcs = cadr(args);
  if (s7_is_list(sc, funcs))
    {
      if (internal_hook_arity_ok(sc, sc->load_hook, funcs))
	hook_functions(sc->load_hook) = funcs; 
      else return(sc->ERROR);
    }
  else
    {
      if (s7_is_procedure(funcs))
	hook_functions(sc->load_hook) = cons(sc, funcs, sc->NIL);
      else return(sc->ERROR);
    }
  return(sc->load_hook);
}


static s7_pointer g_unbound_variable_hook_set(s7_scheme *sc, s7_pointer args)
{
  /* in normal use, we'd (set! (hook-functions *unbound-variable-hook*) ...), but for backwards compatibility,
   *   we also need to support (set! *unbound-variable-hook* func).
   */
  s7_pointer funcs;
  funcs = cadr(args);
  if (s7_is_list(sc, funcs))
    {
      if (internal_hook_arity_ok(sc, sc->unbound_variable_hook, funcs))
	hook_functions(sc->unbound_variable_hook) = funcs;
      else return(sc->ERROR);
    }
  else
    {
      if (s7_is_procedure(funcs))
	hook_functions(sc->unbound_variable_hook) = cons(sc, funcs, sc->NIL);
      else return(sc->ERROR);
    }
  return(sc->unbound_variable_hook);
}


static s7_pointer g_error_hook_set(s7_scheme *sc, s7_pointer args)
{
  /* in normal use, we'd (set! (hook-functions *error-hook*) ...), but for backwards compatibility,
   *   we also need to support (set! *error-hook* func).
   */
  s7_pointer funcs;

  funcs = cadr(args);
  if (s7_is_list(sc, funcs))
    {
      if (internal_hook_arity_ok(sc, sc->error_hook, funcs))
	hook_functions(sc->error_hook) = funcs;
      else return(sc->ERROR);
    }
  else
    {
      if (s7_is_procedure(funcs))
	hook_functions(sc->error_hook) = cons(sc, funcs, sc->NIL);
      else return(sc->ERROR);
    }
  return(sc->error_hook);
}






/* -------------------------------- eq etc -------------------------------- */

bool s7_is_eq(s7_pointer obj1, s7_pointer obj2)
{
  return(obj1 == obj2);
}


bool s7_is_eqv(s7_pointer a, s7_pointer b) 
{
  if (a == b) 
    return(true);
  
#if WITH_GMP
  if (big_numbers_are_eqv(a, b)) return(true); /* T_NUMBER != T_C_OBJECT but both can represent numbers */
#endif

  if (type(a) != type(b)) 
    return(false);
  
  if (s7_is_string(a)) 
    return(string_value(a) == string_value(b));
  
  if (s7_is_number(a))
    return(numbers_are_eqv(a, b));
  
  return(false);
}


/* -------- structure equality -------- 
 *
 * equal? examines the entire structure (possibly a tree etc), which might contain
 *   cycles (vector element is the vector etc), so list/vector/hash-table equality
 *   needs to carry along a list of pointers seen so far.
 */

static bool structures_are_equal(s7_scheme *sc, s7_pointer x, s7_pointer y, shared_info *ci);

static bool s7_is_equal_tracking_circles(s7_scheme *sc, s7_pointer x, s7_pointer y, shared_info *ci)
{
  if (x == y) 
    return(true);
  
#if WITH_GMP
  if (big_numbers_are_eqv(x, y)) return(true); /* T_NUMBER != T_C_OBJECT but both can represent numbers */
#endif

  if (type(x) != type(y)) 
    return(false);
  
  switch (type(x))
    {
    case T_STRING:
      return(scheme_strings_are_equal(x, y));

    case T_C_OBJECT:
      return(objects_are_equal(sc, x, y));

    case T_NUMBER:
      return(numbers_are_eqv(x, y));

    case T_VECTOR:
    case T_HASH_TABLE:
    case T_ENVIRONMENT:
    case T_COUNTER:
    case T_PAIR:
      return(structures_are_equal(sc, x, y, ci));

    case T_HOOK:
      return(hooks_are_equal(sc, x, y));

    case T_C_POINTER:       /* might have a list of these for example */
      return(raw_pointer(x) == raw_pointer(y));
    }

  return(false); /* we already checked that x != y (port etc) */
}


static bool structures_are_equal(s7_scheme *sc, s7_pointer x, s7_pointer y, shared_info *ci)
{
  /* here we know x and y are pointers to the same type of structure */
  int ref_x, ref_y;

  ref_x = peek_shared_ref(ci, x);
  ref_y = peek_shared_ref(ci, y);

  if ((ref_x != 0) && (ref_y != 0))
    return(ref_x == ref_y);
  
  if ((ref_x != 0) || (ref_y != 0))
    {
      /* try to harmonize the new guy -- there can be more than one structure equal to the current one */
      if (ref_x != 0)
	add_shared_ref(ci, y, ref_x);
      else add_shared_ref(ci, x, ref_y);
    }
  else add_equal_ref(ci, x, y);
  
  /* now compare the elements of the structures. */
  if (is_pair(x))
    return((s7_is_equal_tracking_circles(sc, car(x), car(y), ci)) &&
	   (s7_is_equal_tracking_circles(sc, cdr(x), cdr(y), ci)));

  /* vector or hash table */
  {
    s7_Int i, len;
    len = vector_length(x);
    if (len != vector_length(y)) return(false);

    if (s7_is_vector(x))
      {
	/* there's one special case: shared vectors can have 1 dimension but include the dimension info */
	int x_dims = 1, y_dims = 1, j;

	if (vector_is_multidimensional(x))
	  x_dims = vector_ndims(x);
	if (vector_is_multidimensional(y))
	  y_dims = vector_ndims(y);

	if (x_dims != y_dims)
	  return(false);

	if (x_dims > 1)
	  for (j = 0; j < x_dims; j++)
	    if (vector_dimension(x, j) != vector_dimension(y, j))
	      return(false);
      }

    for (i = 0; i < len; i++)
      if (!(s7_is_equal_tracking_circles(sc, vector_element(x, i), vector_element(y, i), ci)))
	return(false);
  }
  return(true);
}


bool s7_is_equal(s7_scheme *sc, s7_pointer x, s7_pointer y)
{
  if (x == y) 
    return(true);
  
#if WITH_GMP
  if (big_numbers_are_eqv(x, y)) return(true); /* T_NUMBER != T_C_OBJECT but both can represent numbers */
#endif

  if (type(x) != type(y)) 
    return(false);
  
  switch (type(x))
    {
      /* one problematic case: #<unspecified> is currently not equal to (values) but they print the same.
       *   case T_UNTYPED: return((s7_is_unspecified(sc, x)) && (s7_is_unspecified(sc, y)))
       */

    case T_STRING:
      return(scheme_strings_are_equal(x, y));

    case T_C_OBJECT:
      return(objects_are_equal(sc, x, y));

    case T_NUMBER:
      return(numbers_are_eqv(x, y));

    case T_VECTOR:
    case T_HASH_TABLE:
      if (vector_length(x) != vector_length(y))
	return(false);
      /* fall through */

    case T_PAIR:
      {
	shared_info *ci;
	bool result;
	ci = new_shared_info(sc);
	result = structures_are_equal(sc, x, y, ci);
	free_shared_info(ci);
	return(result);
      }

    case T_HOOK:
      return(hooks_are_equal(sc, x, y));

    case T_C_POINTER:
      return(raw_pointer(x) == raw_pointer(y));
    }

  return(false); /* we already checked that x != y (port etc) */
}


static s7_pointer g_is_eq(s7_scheme *sc, s7_pointer args)
{
  #define H_is_eq "(eq? obj1 obj2) returns #t if obj1 is eq to (the same object as) obj2"
  return(make_boolean(sc, car(args) == cadr(args)));
}


static s7_pointer g_is_eqv(s7_scheme *sc, s7_pointer args)
{
  #define H_is_eqv "(eqv? obj1 obj2) returns #t if obj1 is equivalent to obj2"
  return(make_boolean(sc, s7_is_eqv(car(args), cadr(args))));
}


static s7_pointer g_is_equal(s7_scheme *sc, s7_pointer args)
{
  #define H_is_equal "(equal? obj1 obj2) returns #t if obj1 is equal to obj2"
  return(make_boolean(sc, s7_is_equal(sc, car(args), cadr(args))));
}



/* ---------------------------------------- length, copy, fill ---------------------------------------- */

static s7_pointer g_length(s7_scheme *sc, s7_pointer args)
{
  #define H_length "(length obj) returns the length of obj, which can be a list, vector, string, or hash-table. \
The length of a dotted list does not include the final cdr, and is returned as a negative number.  A circular \
list has infinite length."

  s7_pointer lst;
  lst = car(args);

  switch (type(lst))
    {
    case T_PAIR:
      {
	int len;
	len = s7_list_length(sc, lst);
	/* len < 0 -> dotted and (abs len) is length not counting the final cdr
	 * len == 0, circular so length is infinite
	 */
	if (len == 0)
	  return(s7_make_real(sc, INFINITY));
	return(s7_make_integer(sc, len));
      }

    case T_NIL:
      return(small_int(0));

    case T_VECTOR:
      return(g_vector_length(sc, args));

    case T_STRING:
      return(g_string_length(sc, args));

    case T_HASH_TABLE:
      return(g_hash_table_size(sc, args));

    case T_C_OBJECT:
      return(object_length(sc, car(args)));

    default:
      return(s7_wrong_type_arg_error(sc, "length", 0, lst, "a list, vector, string, or hash-table"));
    }
  
  return(small_int(0));
}

/* what about (length file)? 
 */


static s7_pointer list_copy(s7_scheme *sc, s7_pointer x, s7_pointer y, bool step)
{
  if ((!is_pair(x)) ||
       (x == y))
    return(x);
  return(cons(sc, car(x), list_copy(sc, cdr(x), (step) ? cdr(y) : y, !step)));
}


static s7_pointer s7_copy(s7_scheme *sc, s7_pointer obj)
{
  switch (type(obj))
    {
    case T_STRING:
      return(s7_make_string_with_length(sc, string_value(obj), string_length(obj)));

    case T_C_OBJECT:
      return(object_copy(sc, obj));

    case T_HASH_TABLE:              /* this has to copy nearly everything */
      return(hash_table_copy(sc, obj));
      
    case T_VECTOR:
      return(vector_copy(sc, obj)); /* "shallow" copy */

    case T_PAIR:
      return(cons(sc, car(obj), list_copy(sc, cdr(obj), obj, true)));  /* this is the only use of list_copy */

    case T_HOOK:
      return(hook_copy(sc, obj));
    }
  return(obj);
}


static s7_pointer g_copy(s7_scheme *sc, s7_pointer args)
{
  #define H_copy "(copy obj) returns a copy of obj"
  return(s7_copy(sc, car(args)));
}


static s7_pointer g_reverse(s7_scheme *sc, s7_pointer args)
{
  #define H_reverse "(reverse lst) returns a list with the elements of lst in reverse order.  reverse \
also accepts a string or vector argument."
  s7_pointer p, np;
  
  p = car(args);
  np = sc->NIL;

  switch (type(p))
    {
    case T_NIL:
      return(sc->NIL);

    case T_PAIR:
      return(s7_reverse(sc, p));
      /* if (is_null(np)) return(s7_wrong_type_arg_error(sc, "reverse", 0, p, "a proper list")); */
      break;

    case T_STRING:
      {
	int i, j, len;
	len = string_length(p);
	np = make_empty_string(sc, len, 0);
	if (len > 0)
	  for (i = 0, j = len - 1; i < len; i++, j--)
	    string_value(np)[i] = string_value(p)[j];
      }
      break;

    case T_VECTOR:
      {
	s7_Int i, j, len;
	len = vector_length(p);
	if (vector_is_multidimensional(p))
	  np = g_make_vector(sc, list_1(sc, g_vector_dimensions(sc, list_1(sc, p))));
	else np = make_vector_1(sc, len, NOT_FILLED, true);
	if (len > 0)
	  for (i = 0, j = len - 1; i < len; i++, j--)
	    vector_element(np, i) = vector_element(p, j);
      }
      break;

    case T_HASH_TABLE:
      return(hash_table_reverse(sc, p));

    case T_C_OBJECT:
      return(object_reverse(sc, p));
      break;

    default:
      return(s7_wrong_type_arg_error(sc, "reverse", 0, p, "a list, string, vector, or hash-table"));
    }
  
  return(np);
}


static s7_pointer list_fill(s7_scheme *sc, s7_pointer obj, s7_pointer val)
{
  /* ambiguous ("tree-fill"?) but if it's like vector-fill, we just stomp on the top level */
  s7_pointer x, y;

  x = obj;
  y = obj;

  while (true)
    {
      if (!is_pair(x)) return(val);
      car(x) = val;
      if (is_pair(cdr(x)))
	{
	  x = cdr(x);
	  car(x) = val;
	  if (is_pair(cdr(x)))
	    {
	      x = cdr(x);
	      y = cdr(y);
	      if (x == y) return(val);
	    }
	  else
	    {
	      if (is_not_null(cdr(x)))
		cdr(x) = val;
	      return(val);
	    }
	}
      else
	{
	  if (is_not_null(cdr(x)))
	    cdr(x) = val;
	  return(val);
	}
    }
  return(val);
}


static s7_pointer g_fill(s7_scheme *sc, s7_pointer args)
{
  #define H_fill "(fill obj val) fills obj with the value val"

  switch (type(car(args)))
    {
    case T_STRING:
      return(g_string_fill(sc, args));

    case T_HASH_TABLE:
      if (is_not_null(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "fill! hash-table value,", 2, cadr(args), "nil"));
      return(hash_table_clear(sc, car(args)));

    case T_VECTOR:
      return(g_vector_fill(sc, args));

    case T_C_OBJECT:
      {
	int tag;
	tag = object_type(car(args));
	if (object_types[tag].fill_func)
	  {
	    s_type_t *obj;
	    obj = (s_type_t *)s7_object_value(car(args));
	    car(args) = obj->value;
	    push_stack(sc, OP_APPLY, args, object_types[obj->type].fill_func);
	    return(sc->UNSPECIFIED);
	  }

	if (object_types[tag].fill)
	  return((*(object_types[tag].fill))(sc, car(args), cadr(args)));
	return(eval_error(sc, "attempt to fill ~A?", car(args)));
      }

    case T_PAIR:
      return(list_fill(sc, car(args), cadr(args)));

    case T_NIL:
      return(cadr(args));        /* this parallels the empty vector case */
    }

  return(s7_wrong_type_arg_error(sc, "fill!", 1, car(args), "a fillable object")); /* (fill! 1 0) */
}


static s7_pointer object_to_list(s7_scheme *sc, s7_pointer obj)
{
  switch (type(obj))
    {
    case T_VECTOR:
      return(s7_vector_to_list(sc, obj));

    case T_STRING:
      return(s7_string_to_list(sc, string_value(obj), string_length(obj)));

    case T_HASH_TABLE:
      {
	s7_pointer x, iterator, iter_loc;
	int gc_iter;
	/* (format #f "~{~A ~}" (hash-table '(a . 1) '(b . 2))) */

	iterator = g_make_hash_table_iterator(sc, list_1(sc, obj));
	gc_iter = s7_gc_protect(sc, iterator);
	iter_loc = cdadar(closure_body(iterator));

	sc->w = sc->NIL;
	while (true)
	  {
	    x = g_hash_table_iterate(sc, iter_loc);
	    if (is_null(x)) break;
	    sc->w = cons(sc, x, sc->w);
	  }

	x = sc->w;
	sc->w = sc->NIL;
	s7_gc_unprotect_at(sc, gc_iter);
	return(x);
      }
      
    case T_HOOK:
      return(hook_functions(obj));

    case T_ENVIRONMENT:
      return(s7_environment_to_list(sc, obj));

    case T_C_OBJECT:
      {
	long int i, len; /* the "long" matters on 64-bit machines */
	s7_pointer x, z, result;
	int save_x = -1, save_y = -1, save_z = -1, gc_res = -1, gc_z = -1;
	/* (format #f "~{~A ~}" (vct 1 2 3)) */

	x = object_length(sc, obj);
	if (s7_is_integer(x))
	  len = s7_integer(x);
	else return(sc->F);

	if (len < 0)
	  return(sc->F);
	if (len == 0)
	  return(sc->NIL);

	result = g_make_list(sc, list_1(sc, s7_make_integer(sc, len)));
	gc_res = s7_gc_protect(sc, result);
	z = list_1(sc, sc->F);
	gc_z = s7_gc_protect(sc, z);

	for (i = 0, x = result; i < len; i++, x = cdr(x))
	  {
	    car(z) = s7_make_integer(sc, i);
	    SAVE_X_Y_Z(save_x, save_y, save_z);
	    car(x) = (*(object_ref(obj)))(sc, obj, z);
	    RESTORE_X_Y_Z(save_x, save_y, save_z);
	  }
	
	s7_gc_unprotect_at(sc, gc_z);
	s7_gc_unprotect_at(sc, gc_res);
	return(result);
      }
    }
  return(obj);
}




/* -------------------------------- format -------------------------------- */

static char *format_error(s7_scheme *sc, const char *msg, const char *str, s7_pointer args, format_data *dat)
{
  int len;
  char *errmsg;
  s7_pointer x;

  if (dat->loc == 0)
    {
      len = safe_strlen(msg) + 32;
      errmsg = (char *)malloc(len * sizeof(char));
      if (is_pair(args))
	snprintf(errmsg, len, "format ~S ~{~S~^ ~}: %s", msg);
      else snprintf(errmsg, len, "format ~S: %s", msg);
    }
  else 
    {
      char *filler;
      int i;
      filler = (char *)calloc(dat->loc + 12, sizeof(char));
      for (i = 0; i < dat->loc + 11; i++)
	filler[i] = ' ';
      len = safe_strlen(msg) + 32 + dat->loc + 12;
      errmsg = (char *)malloc(len * sizeof(char));
      if (is_pair(args))
	snprintf(errmsg, len, "format: ~S ~{~S~^ ~}\n%s^: %s", filler, msg);
      else snprintf(errmsg, len, "format: ~S\n%s^: %s", filler, msg);
      free(filler);
    }

  if (is_pair(args))
    x = list_3(sc, make_string_uncopied(sc, errmsg), make_protected_string(sc, str), args);
  else x = list_2(sc, make_string_uncopied(sc, errmsg), make_protected_string(sc, str));

  if (dat->str) {free(dat->str); dat->str = NULL;}

  s7_error(sc, sc->FORMAT_ERROR, x);
  return(NULL);
}


static void format_append_char(format_data *dat, char c)
{
  if (dat->len <= dat->loc + 2)
    {
      dat->len *= 2;
      dat->str = (char *)realloc(dat->str, dat->len * sizeof(char));
    }
  dat->str[dat->loc++] = c;
}


static void format_append_string(format_data *dat, const char *str)
{
  const char *s;
  if (!str) return;
  for (s = str; (*s) != 0; s++)
    {
      if (dat->len <= dat->loc + 2)
	{
	  dat->len *= 2;
	  dat->str = (char *)realloc(dat->str, dat->len * sizeof(char));
	}
      dat->str[dat->loc++] = (*s);
    }
}


static int format_read_integer(s7_scheme *sc, int *cur_i, int str_len, const char *str, s7_pointer args, format_data *fdat)
{
  int i, arg1 = -1;
  char *tmp;
  i = *cur_i;
  if (isdigit(str[i]))
    {
      tmp = (char *)(str + i);
      if (sscanf(tmp, "%d", &arg1) < 1)
	format_error(sc, "bad number?", str, args, fdat);

      for (i = i + 1; i < str_len - 1; i++)
	if (!isdigit(str[i]))
	  break;
      if (i >= str_len)
	format_error(sc, "numeric argument, but no directive!", str, args, fdat);
    }
  *cur_i = i;
  return(arg1);
}


static void format_number(s7_scheme *sc, format_data *fdat, int radix, int width, int precision, char float_choice, char pad)
{
  char *tmp;
  if (width < 0) width = 0;

  /* precision choice depends on float_choice if it's -1 */
  if (precision < 0)
    {
      if ((float_choice == 'e') ||
	  (float_choice == 'f') ||
	  (float_choice == 'g'))
	precision = 6;
      else
	{
	  /* in the "int" cases, precision depends on the arg type */
	  switch (number_type(car(fdat->args)))
	    {
	    case NUM_INT: 
	    case NUM_RATIO:
	      precision = 0; 
	      break;

	    default:
	      precision = 6;
	      break;
	    }
	}
    }

  /* should (format #f "~F" 1/3) return "1/3"?? in CL it's "0.33333334" */

  tmp = number_to_string_with_radix(sc, car(fdat->args), radix, width, precision, float_choice);

  if (pad != ' ')
    {
      char *padtmp;
      padtmp = tmp;
      while (*padtmp == ' ') (*(padtmp++)) = pad;
    }
  format_append_string(fdat, tmp);
  free(tmp);
  fdat->args = cdr(fdat->args);
}


#if WITH_GMP
static bool s7_is_one_or_big_one(s7_pointer p);
#else
#define s7_is_one_or_big_one(Num) s7_is_one(Num)
#endif

static char *format_to_c_string(s7_scheme *sc, const char *str, s7_pointer args, s7_pointer *next_arg, int fdepth)
{
  #define INITIAL_FORMAT_LENGTH 128
  int i = 0, str_len = 0;
  format_data *fdat = NULL;
  char *result, *tmp = NULL;

  str_len = safe_strlen(str);

  if (fdepth >= sc->num_fdats)
    {
      int i, new_num_fdats;
      new_num_fdats = fdepth * 2;
      sc->fdats = (format_data **)realloc(sc->fdats, sizeof(format_data *) * new_num_fdats);
      for (i = sc->num_fdats; i < new_num_fdats; i++) sc->fdats[i] = NULL;
      sc->num_fdats = new_num_fdats;
    }

  fdat = sc->fdats[fdepth];

  if (!fdat)
    {
      fdat = (format_data *)malloc(sizeof(format_data));
      fdat->loc = 0;
      fdat->args = args;
      sc->fdats[fdepth] = fdat;
    }
  else
    {
      fdat->loc = 0;
      fdat->args = args;
    }

  fdat->len = INITIAL_FORMAT_LENGTH;
  fdat->str = (char *)calloc(fdat->len, sizeof(char)); /* ~nT col checks need true current string length, so malloc here is messy */
  /* fdat->str[0] = '\0'; */

  if (str_len == 0)
    {
      if ((is_not_null(args)) &&
	  (next_arg == NULL))
	return(format_error(sc, "too many arguments", str, args, fdat));
    }
  else
    {
      for (i = 0; i < str_len; i++)
	{
	  if (str[i] == '~')
	    {
	      if (i == str_len - 1)
		return(format_error(sc, "control string ends in tilde", str, args, fdat));

	      switch (str[i + 1])
		{
		case '%':                           /* -------- newline -------- */
		  format_append_char(fdat, '\n');
		  i++;
		  break;

		case '&':                           /* -------- conditional newline -------- */
		  if ((fdat->loc > 0) &&
		      (fdat->str[fdat->loc - 1] != '\n'))
		    format_append_char(fdat, '\n');
		  i++;
		  break;
		  
		case '~':                           /* -------- tilde -------- */
		  format_append_char(fdat, '~');
		  i++;
		  break;

		case '\n':                          /* -------- trim white-space -------- */
		  for (i = i + 2; i <str_len - 1; i++)
		    if (!(white_space[(unsigned char)(str[i])]))
		      {
			i--;
			break;
		      }
		  break;
		  
		case '*':                           /* -------- ignore arg -------- */
		  i++;
		  fdat->args = cdr(fdat->args);
		  break;

		case '^':                           /* -------- exit -------- */
		  if (is_null(fdat->args))
		    {
		      i = str_len;
		      goto ALL_DONE;
		    }
		  i++;
		  break;

		case '@':                           /* -------- plural, 'y' or 'ies' -------- */
		  i += 2;
		  if ((str[i] != 'P') && (str[i] != 'p'))
		    return(format_error(sc, "unknown '@' directive", str, args, fdat));
		  if (!s7_is_number(car(fdat->args)))   /* CL accepts non numbers here */
		    return(format_error(sc, "'@P' directive argument is not an integer", str, args, fdat));

		  if (!s7_is_one_or_big_one(car(fdat->args)))
		    format_append_string(fdat, "ies");
		  else format_append_char(fdat, 'y');

		  fdat->args = cdr(fdat->args);
		  break;

		case 'P': case 'p':                 /* -------- plural in 's' -------- */
		  if (!s7_is_real(car(fdat->args)))
		    return(format_error(sc, "'P' directive argument is not a real number", str, args, fdat));
		  if (!s7_is_one_or_big_one(car(fdat->args)))
		    format_append_char(fdat, 's');
		  i++;
		  fdat->args = cdr(fdat->args);
		  break;
		  
		case 'A': case 'a':                 /* -------- object->string -------- */
		case 'C': case 'c':
		case 'S': case 's':
		  {
		    shared_info *ci = NULL;
		    s7_pointer obj;

		    /* slib suggests num arg to ~A and ~S to truncate: ~20A sends only (up to) 20 chars of object->string result,
		     *   but that could easily(?) be handled with substring and an embedded format arg.
		     */

		    if (is_null(fdat->args))
		      return(format_error(sc, "missing argument", str, args, fdat));
		    i++;
		    obj = car(fdat->args);

		    if (((str[i] == 'C') || (str[i] == 'c')) &&
			(!s7_is_character(obj)))
		      return(format_error(sc, "'C' directive requires a character argument", str, args, fdat));

		    if (has_structure(obj))
		      ci = make_shared_info(sc, obj);
		    tmp = object_to_c_string_with_circle_check(sc, obj, (str[i] == 'S') || (str[i] == 's'), WITH_ELLIPSES, ci);
		    if (ci) free_shared_info(ci);

		    format_append_string(fdat, tmp);
		    if (tmp) free(tmp);
		    fdat->args = cdr(fdat->args);
		  }
		  break;
		  
		case '{':                           /* -------- iteration -------- */
		  {
		    int k, curly_len = -1, curly_nesting = 1;

		    if (is_null(fdat->args))
		      return(format_error(sc, "missing argument", str, args, fdat));

		    for (k = i + 2; k < str_len - 1; k++)
		      if (str[k] == '~')
			{
			  if (str[k + 1] == '}')
			    {
			      curly_nesting--;
			      if (curly_nesting == 0)
				{
				  curly_len = k - i - 1;
				  break;
				}
			    }
			  else
			    {
			      if (str[k + 1] == '{')
				curly_nesting++;
			    }
			}

		    if (curly_len == -1)
		      return(format_error(sc, "'{' directive, but no matching '}'", str, args, fdat));

		    /* what about cons's here?  I can't see any way in CL either to specify the car or cdr of a cons within the format string 
		     *   (cons 1 2) is applicable: ((cons 1 2) 0) -> 1
		     *   also there can be applicable objects that won't work in the map context (arg not integer etc)
		     */
 		    if (is_not_null(car(fdat->args)))               /* (format #f "~{~A ~}" '()) -> "" */
		      {
			s7_pointer curly_arg;

			curly_arg = object_to_list(sc, car(fdat->args)); 
			if (is_not_null(curly_arg))                 /* (format #f "~{~A ~}" #()) -> "" */
			  {
			    char *curly_str = NULL;               /* this is the local (nested) format control string */
			    int curly_gc;

			    if (!is_proper_list(sc, curly_arg))
			      return(format_error(sc, "'{' directive argument should be a proper list or something we can turn into a list", str, args, fdat));
			    curly_gc = s7_gc_protect(sc, curly_arg);

			    curly_str = (char *)malloc(curly_len * sizeof(char));
			    for (k = 0; k < curly_len - 1; k++)
			      curly_str[k] = str[i + 2 + k];
			    curly_str[curly_len - 1] = '\0';

			    while (is_not_null(curly_arg))
			      {
				s7_pointer new_arg = sc->NIL;
				tmp = format_to_c_string(sc, curly_str, curly_arg, &new_arg, fdepth + 1);
				format_append_string(fdat, tmp);
				if (tmp) free(tmp);
				if (curly_arg == new_arg)
				  {
				    if (curly_str) free(curly_str);
				    s7_gc_unprotect_at(sc, curly_gc);
				    return(format_error(sc, "'{...}' doesn't consume any arguments!", str, args, fdat));
				  }
				curly_arg = new_arg;
			      }

			    free(curly_str);
			    s7_gc_unprotect_at(sc, curly_gc);
			  }
		      }

		    i += (curly_len + 2); /* jump past the ending '}' too */
		    fdat->args = cdr(fdat->args);
		  }
		  break;
		  
		case '}':
		  return(format_error(sc, "unmatched '}'", str, args, fdat));
		  
		  /* -------- numeric args -------- */
		case '0': case '1': case '2': case '3': case '4': case '5':
		case '6': case '7': case '8': case '9': case ',':

		case 'B': case 'b':
		case 'D': case 'd':
		case 'E': case 'e':
		case 'F': case 'f':
		case 'G': case 'g':
		case 'O': case 'o':
		case 'T': case 't':
		case 'X': case 'x':
		  {
		    int width = -1, precision = -1;
		    char pad = ' ';
		    i++;

		    if (isdigit(str[i]))
		      width = format_read_integer(sc, &i, str_len, str, args, fdat);

		    if (str[i] == ',')
		      {
			i++;
			if (isdigit(str[i]))
			  precision = format_read_integer(sc, &i, str_len, str, args, fdat);
			/* is (format #f "~12,12D" 1) an error?  The precision has no use here. */
			else
			  {
			    if (str[i] == '\'')       /* (format #f "~12,'xD" 1) -> "xxxxxxxxxxx1" */
			      {
				pad = str[i + 1];
				i += 2;
			      }
			    /* is (let ((str "~12,'xD")) (set! (str 5) #\null) (format #f str 1)) an error? */
			  }
		      }
		    if ((str[i] != 'T') && (str[i] != 't'))
		      {
			if (is_null(fdat->args))
			  return(format_error(sc, "missing argument", str, args, fdat));
			if (!(s7_is_number(car(fdat->args))))
			  return(format_error(sc, "numeric argument required", str, args, fdat));
		      }

		    switch (str[i])
		      {
			/* -------- pad to column -------- */
			/*   are columns numbered from 1 or 0?  there seems to be disagreement about this directive */
			/*   does "space over to" mean including? */
		      case 'T': case 't':
			if (width == -1) width = 0;
			if (precision == -1) precision = 0;
			if ((width > 0) || (precision > 0))         /* (format #f "a~8Tb") */
			  {
			    int j, k, outstr_len;
			    outstr_len = safe_strlen(fdat->str);
			    for (k = outstr_len - 1; k >= 0; k--)
			      if (fdat->str[k] == '\n')
				break;

			    /* (length (substring (format #f "~%~10T.") 1)) == (length (format #f "~10T."))
			     * (length (substring (format #f "~%-~10T.~%") 1)) == (length (format #f "-~10T.~%"))
			     */

			    if (precision > 0)
			      {
				int mult;
				mult = (int)(ceil((s7_Double)(outstr_len - k - width) / (s7_Double)precision)); /* CLtL2 ("least positive int") */
				if (mult < 1) mult = 1;
				width += (precision * mult);
			      }
			    
			    for (j = outstr_len - k; j < width; j++)
			      format_append_char(fdat, pad);
			  }
			break;

			/* -------- numbers -------- */
		      case 'F': case 'f':
			format_number(sc, fdat, 10, width, precision, 'f', pad);
			break;

		      case 'G': case 'g':
			format_number(sc, fdat, 10, width, precision, 'g', pad);
			break;

		      case 'E': case 'e':
			format_number(sc, fdat, 10, width, precision, 'e', pad);
			break;

			/* how to handle non-integer arguments in the next 4 cases?  clisp just returns
			 *   the argument: (format nil "~X" 1.25) -> "1.25" which is perverse (ClTl2 p 581:
			 *   "if arg is not an integer, it is printed in ~A format and decimal base")!!
			 *   Guile raises an error ("argument is not an integer").  slib also raise an error.
			 *   I think I'll use the type of the number to choose the output format.
			 */
		      case 'D': case 'd':
			format_number(sc, fdat, 10, width, precision, 'd', pad);
			break;

		      case 'O': case 'o':
			format_number(sc, fdat, 8, width, precision, 'o', pad);
			break;

		      case 'X': case 'x':
			format_number(sc, fdat, 16, width, precision, 'x', pad);
			break;

		      case 'B': case 'b':
			format_number(sc, fdat, 2, width, precision, 'b', pad);
			break;
		      
		      default:
			return(format_error(sc, "unimplemented format directive", str, args, fdat));
		      }
		  }
		  break;

		default:
		  return(format_error(sc, "unimplemented format directive", str, args, fdat));
		}
	    }
	  else 
	    {
	      /* format_append_char(fdat, str[i]); */
	      if (fdat->len <= fdat->loc + 2)
		{
		  fdat->len *= 2;
		  fdat->str = (char *)realloc(fdat->str, fdat->len * sizeof(char));
		}
	      fdat->str[fdat->loc++] = str[i];
	    }
	}
    }

 ALL_DONE:
  if (next_arg)
    (*next_arg) = fdat->args;
  else
    {
      if (is_not_null(fdat->args))
	return(format_error(sc, "too many arguments", str, args, fdat));
    }
  if (i < str_len)
    format_append_char(fdat, str[i]);    /* possible trailing ~ is sent out */
  format_append_char(fdat, '\0');

  result = fdat->str;
  fdat->str = NULL;

  return(result);
}


static s7_pointer format_to_output(s7_scheme *sc, s7_pointer out_loc, const char *in_str, s7_pointer args)
{
  s7_pointer result;

  if ((!in_str) || (!(*in_str)))
    {
      if (is_not_null(args))
	return(s7_error(sc, 
			sc->FORMAT_ERROR, 
			list_2(sc, make_protected_string(sc, "format control string is null, but there are other arguments: ~A"), args)));
      return(make_protected_string(sc, ""));
    }

  result = make_string_uncopied(sc, format_to_c_string(sc, in_str, args, NULL, 0));

  if (out_loc != sc->F)
    s7_display(sc, result, out_loc);

  return(result);
}


static s7_pointer g_format(s7_scheme *sc, s7_pointer args)
{
  #define H_format "(format out str . args) substitutes args into str sending the result to out. Most of \
s7's format directives are taken from CL: ~% = newline, ~& = newline if the preceding output character was \
no a newline, ~~ = ~, ~<newline> trims white space, ~* skips an argument, ~^ exits {} iteration if the arg list is exhausted, \
~nT spaces over to column n, ~A prints a representation of any object, ~S is the same, but puts strings in double quotes, \
~C prints a character, numbers are handled by ~F, ~E, ~G, ~B, ~O, ~D, and ~X with preceding numbers giving \
spacing (and spacing character) and precision.  ~{ starts an embedded format directive which is ended by ~}: \n\
\n\
  >(format #f \"dashed: ~{~A~^-~}\" '(1 2 3))\n\
  \"dashed: 1-2-3\"\n\
\n\
~P inserts \"s\" if the current argument is not 1 or 1.0 (use ~@P for \"ies\" or \"y\").\n\
~B is number->string in base 2, ~O in base 8, ~D base 10, ~X base 16,\n\
~E: (format #f \"~E\" 100.1) -&gt; \"1.001000e+02\" (%e in C)\n\
~F: (format #f \"~F\" 100.1) -&gt; \"100.100000\"   (%f in C)\n\
~G: (format #f \"~G\" 100.1) -&gt; \"100.1\"        (%g in C)"

  s7_pointer pt;
  pt = car(args);

  if (s7_is_string(pt))
    return(format_to_output(sc, sc->F, s7_string(pt), cdr(args)));

  if (!s7_is_string(cadr(args)))
    return(s7_wrong_type_arg_error(sc, "format control string,", 2, cadr(args), "a string"));
    
  if (!((s7_is_boolean(pt)) ||               /* #f or #t */
	((is_output_port(pt)) &&             /* (current-output-port) or call-with-open-file arg, etc */
	 (!port_is_closed(pt)))))
    return(s7_wrong_type_arg_error(sc, "format", 1, pt, "#f, #t, or an open output port"));

  return(format_to_output(sc, (pt == sc->T) ? sc->output_port : pt, s7_string(cadr(args)), cddr(args)));
}


const char *s7_format(s7_scheme *sc, s7_pointer args)
{
  return(s7_string(g_format(sc, args))); /* for the run macro in run.c */
}



/* -------- trace -------- */

/* 
    (define (hiho arg) (if (> arg 0) (+ 1 (hiho (- arg 1))) 0))
    (trace hiho)
    (hiho 3)

    [hiho 3]
     [hiho 2]
      [hiho 1]
       [hiho 0]
        0
       1
      2
     3
*/

/* to trace an internal function, put the trace/untrace pair in the enclosing function
 */

static s7_pointer g_trace(s7_scheme *sc, s7_pointer args)
{
  #define H_trace "(trace . args) adds each function in its argument list to the trace list.\
Each argument can be a function, symbol, macro, or any applicable object: (trace abs '+ v) where v is a vct \
prints out data about any call on abs or +, and any reference to the vct v. Trace output is sent \
to the current-output-port.  If trace is called without any arguments, everything is traced -- use \
untrace without arguments to turn this off."

  int i;
  s7_pointer x;

  if (is_null(args))
    {
      trace_all = true;
      tracing = true;
      return(sc->F);
    }
  
  for (i = 1, x = args; is_not_null(x); i++, x = cdr(x)) 
    if ((!s7_is_symbol(car(x))) &&
	(!is_procedure(car(x))) &&
	(!is_any_macro(car(x))))
      return(s7_wrong_type_arg_error(sc, "trace", i, car(x), "a symbol, a function, or some other applicable object"));

  for (x = args; is_not_null(x); x = cdr(x)) 
    {
      if (s7_is_symbol(car(x)))
	sc->trace_list[sc->trace_top++] = eval_symbol(sc, car(x));
      else sc->trace_list[sc->trace_top++] = car(x);
      if (sc->trace_top >= sc->trace_list_size)
	{
	  sc->trace_list_size *= 2;
	  sc->trace_list = (s7_pointer *)realloc(sc->trace_list, sc->trace_list_size * sizeof(s7_pointer));
	}
    }

  tracing = (sc->trace_top > 0);
  return(sc->T);
}


static s7_pointer g_untrace(s7_scheme *sc, s7_pointer args)
{
  #define H_untrace "(untrace . args) removes each function in its arg list from the trace list. \
If untrace is called with no arguments, all functions are removed, turning off all tracing."
  int i, j, ctr;
  s7_pointer x;

  if (is_null(args))
    {
      trace_all = false;
      for (i = 0; i < sc->trace_top; i++)
	sc->trace_list[i] = sc->NIL;
      sc->trace_top = 0;
      tracing = false;
      return(sc->F);
    }

  for (ctr = 1, x = args; is_not_null(x); ctr++, x = cdr(x)) 
    {
      s7_pointer value;
      if (s7_is_symbol(car(x)))
	value = eval_symbol(sc, car(x));
      else 
	{
	  if ((is_procedure(car(x))) ||
	      (is_any_macro(car(x))))
	    value = car(x);
	  else return(s7_wrong_type_arg_error(sc, "untrace", ctr, car(x), "a symbol or procedure")); /* (untrace "hi") */
	}
      for (i = 0; i < sc->trace_top; i++)
	if (value == sc->trace_list[i])
	  sc->trace_list[i] = sc->NIL;
    }
  
  /* now collapse list and reset trace_top (and possibly tracing) */
  for (i = 0, j = 0; i < sc->trace_top; i++)
    if (is_not_null(sc->trace_list[i]))
      sc->trace_list[j++] = sc->trace_list[i];
  
  sc->trace_top = j;
  tracing = (sc->trace_top > 0);
  return(sc->T);
}


static void trace_apply(s7_scheme *sc)
{
  int i;
  bool trace_it = false;

  if (trace_all)
    trace_it = true;
  else
    {
      for (i = 0; i < sc->trace_top; i++)
	if (sc->code == sc->trace_list[i])
	  {
	    trace_it = true;
	    break;
	  }
    }

  if (trace_it)
    {
      int k, len;
      char *tmp1, *tmp2, *str;
      push_stack(sc, OP_TRACE_RETURN, sc->code, sc->NIL);
      tmp1 = s7_object_to_c_string(sc, sc->code);
      tmp2 = s7_object_to_c_string(sc, sc->args);

      len = safe_strlen(tmp2);
      tmp2[0] = ' ';
      tmp2[len - 1] = ']';
      
      len += (safe_strlen(tmp1) + sc->trace_depth + 64);
      str = (char *)calloc(len, sizeof(char));
      
      for (k = 0; k < sc->trace_depth; k++) str[k] = ' ';
      str[k] = '[';
      strcat(str, tmp1);
      strcat(str, tmp2);
      free(tmp1);
      free(tmp2);
      
      strcat(str, "\n");
      write_string(sc, str, sc->output_port);
      free(str);
      
      sc->trace_depth++;
 
      if (is_not_null(hook_functions(sc->trace_hook)))
	{
	  push_stack(sc, OP_TRACE_HOOK_QUIT, sc->args, sc->code); /* restore current state after dealing with the trace hook func */
	  /* we have to turn off tracing while evaluating the trace hook functions
	   */
	  tracing = false;
	  s7_hook_apply(sc, sc->trace_hook, list_2(sc, sc->code, sc->args));

	  /* it would be nice if *trace-hook* could return #f to turn off trace printout.
	   *   then it could be used (more cleanly) for a call-history list (a circular list)
	   */
	}
    }
}


static void trace_return(s7_scheme *sc)
{
  int k, len;
  char *str, *tmp;

  tmp = s7_object_to_c_string(sc, sc->value);  

  len = sc->trace_depth + safe_strlen(tmp) + 3;
  str = (char *)calloc(len, sizeof(char));

  for (k = 0; k < sc->trace_depth; k++) str[k] = ' ';
  strcat(str, tmp);
  strcat(str, "\n");
  free(tmp);

  write_string(sc, str, sc->output_port);
  free(str);

  sc->trace_depth--;
  if (sc->trace_depth < 0) sc->trace_depth = 0;
}





/* -------- error handlers -------- */

static const char *type_name(s7_pointer arg)
{
  switch (type(arg))
    {
    case T_NIL:          return("nil");
    case T_UNTYPED:      return("untyped");
    case T_BOOLEAN:      return("boolean");
    case T_STRING:       return("string");
    case T_SYMBOL:       return("symbol");
    case T_SYNTAX:       return("syntax");
    case T_PAIR:         return("pair");
    case T_CLOSURE:      return("closure");
    case T_CLOSURE_STAR: return("closure*");
    case T_GOTO:         return("goto");
    case T_CONTINUATION: return("continuation");
    case T_C_OPT_ARGS_FUNCTION:
    case T_C_RST_ARGS_FUNCTION:
    case T_C_LST_ARGS_FUNCTION:
    case T_C_ANY_ARGS_FUNCTION:
    case T_C_FUNCTION:   return("function");
    case T_C_MACRO:      return("macro");
    case T_C_POINTER:    return("c-pointer");
    case T_CHARACTER:    return("character");
    case T_VECTOR:       return("vector");
    case T_BACRO:
    case T_MACRO:        return("macro");
    case T_CATCH:        return("catch");
    case T_DYNAMIC_WIND: return("dynamic-wind");
    case T_HASH_TABLE:   return("hash-table");
    case T_C_OBJECT:     return(object_types[object_type(arg)].name);
    case T_HOOK:         return("hook");
    case T_COUNTER:      return("counter");
    case T_ENVIRONMENT:  return("environment");

    case T_INPUT_PORT:
      {
	if (is_file_port(arg))
	  return("input file port");
	if (is_string_port(arg))
	  return("input string port");
	return("input port");
      }

    case T_OUTPUT_PORT:
      {
	if (is_file_port(arg))
	  return("output file port");
	if (is_string_port(arg))
	  return("output string port");
	return("output port");
      }
      
    case T_NUMBER: 
      {
	switch (number_type(arg))
	  {
	  case NUM_INT:   return("integer");
	  case NUM_RATIO: return("ratio");
	  case NUM_REAL:  
	  case NUM_REAL2: return("real");
	  default:        return("complex number"); /* "a complex" doesn't sound right */
	  }
      }
    }
  return("messed up object");
}


static bool is_vowel(const char *name)
{
  return((name[0] == 'a') || 
	 (name[0] == 'e') || 
	 (name[0] == 'i') || 
	 (name[0] == 'o') || 
	 (name[0] == 'u'));
}


s7_pointer s7_wrong_type_arg_error(s7_scheme *sc, const char *caller, int arg_n, s7_pointer arg, const char *descr)
{
  /* info list is '(format_string caller arg_n arg type_name descr) */
  if (arg_n < 0) arg_n = 0;

  if (arg_n > 0)
    {
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 1, make_protected_string(sc, caller));
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 2, (arg_n < NUM_SMALL_INTS) ? small_int(arg_n) : s7_make_integer(sc, arg_n));
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 3, arg);
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 4, make_protected_string(sc, (is_vowel(type_name(arg))) ? "n" : ""));
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 5, make_protected_string(sc, type_name(arg)));
      list_set(sc, sc->WRONG_TYPE_ARG_INFO, 6, make_protected_string(sc, descr));
      return(s7_error(sc, sc->WRONG_TYPE_ARG, sc->WRONG_TYPE_ARG_INFO));
    }
  list_set(sc, sc->SIMPLE_WRONG_TYPE_ARG_INFO, 1, make_protected_string(sc, caller));
  list_set(sc, sc->SIMPLE_WRONG_TYPE_ARG_INFO, 2, arg);
  list_set(sc, sc->SIMPLE_WRONG_TYPE_ARG_INFO, 3, make_protected_string(sc, (is_vowel(type_name(arg))) ? "n" : ""));
  list_set(sc, sc->SIMPLE_WRONG_TYPE_ARG_INFO, 4, make_protected_string(sc, type_name(arg)));
  list_set(sc, sc->SIMPLE_WRONG_TYPE_ARG_INFO, 5, make_protected_string(sc, descr));
  return(s7_error(sc, sc->WRONG_TYPE_ARG, sc->SIMPLE_WRONG_TYPE_ARG_INFO));
}


s7_pointer s7_out_of_range_error(s7_scheme *sc, const char *caller, int arg_n, s7_pointer arg, const char *descr)
{
  /* info list is '(format_string caller arg_n arg descr) */
  if (arg_n < 0) arg_n = 0;

  if (arg_n > 0)
    {
      list_set(sc, sc->OUT_OF_RANGE_INFO, 1, make_protected_string(sc, caller));
      list_set(sc, sc->OUT_OF_RANGE_INFO, 2, (arg_n < NUM_SMALL_INTS) ? small_int(arg_n) : s7_make_integer(sc, arg_n));
      list_set(sc, sc->OUT_OF_RANGE_INFO, 3, arg);
      list_set(sc, sc->OUT_OF_RANGE_INFO, 4, make_protected_string(sc, descr));
      return(s7_error(sc, sc->OUT_OF_RANGE, sc->OUT_OF_RANGE_INFO));
    }
  list_set(sc, sc->SIMPLE_OUT_OF_RANGE_INFO, 1, make_protected_string(sc, caller));
  list_set(sc, sc->SIMPLE_OUT_OF_RANGE_INFO, 2, arg);
  list_set(sc, sc->SIMPLE_OUT_OF_RANGE_INFO, 3, make_protected_string(sc, descr));
  return(s7_error(sc, sc->OUT_OF_RANGE, sc->SIMPLE_OUT_OF_RANGE_INFO));
}


s7_pointer s7_wrong_number_of_args_error(s7_scheme *sc, const char *caller, s7_pointer args)
{
  return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
		  list_2(sc, 
			      make_protected_string(sc, caller), /* "caller" includes the format directives */
			      args)));
}


static s7_pointer division_by_zero_error(s7_scheme *sc, const char *caller, s7_pointer arg)
{
  return(s7_error(sc, make_symbol(sc, "division-by-zero"), 
		  list_3(sc, 
			      make_protected_string(sc, "~A: division by zero, ~A"), 
			      make_protected_string(sc, caller),
			      arg)));
}


static s7_pointer file_error(s7_scheme *sc, const char *caller, const char *descr, const char *name)
{
  return(s7_error(sc, make_symbol(sc, "io-error"), 
		  list_4(sc, 
			      make_protected_string(sc, "~A: ~A ~S"),
			      make_protected_string(sc, caller),
			      make_protected_string(sc, descr),
			      make_protected_string(sc, name))));
}


void s7_set_error_exiter(s7_scheme *sc, void (*error_exiter)(void))
{
  sc->error_exiter = error_exiter;
}


static s7_pointer g_dynamic_wind(s7_scheme *sc, s7_pointer args)
{
  #define H_dynamic_wind "(dynamic-wind init body finish) calls init, then body, then finish, \
each a function of no arguments, guaranteeing that finish is called even if body is exited"
  s7_pointer p;

  if (!is_thunk(sc, car(args)))
    return(s7_wrong_type_arg_error(sc, "dynamic-wind", 1, car(args), "a thunk"));
  if (!is_thunk(sc, cadr(args)))
    return(s7_wrong_type_arg_error(sc, "dynamic-wind", 2, cadr(args), "a thunk"));
  if (!is_thunk(sc, caddr(args)))
    return(s7_wrong_type_arg_error(sc, "dynamic-wind", 3, caddr(args), "a thunk"));

  /* this won't work:

       (let ((final (lambda (a b c) (list a b c))))
         (dynamic-wind
           (lambda () #f)
           (lambda () (set! final (lambda () (display "in final"))))
           final))

   * but why not?  'final' is a thunk by the time it is evaluated.
   *   catch (the error handler) is similar.
   *
   * It can't work here because we set up the dynamic_wind_out slot below and
   *   even if the thunk check was removed, we'd still be trying to apply the original function.
   */
  
  NEW_CELL(sc, p);
  dynamic_wind_in(p) = car(args);
  dynamic_wind_body(p) = cadr(args);
  dynamic_wind_out(p) = caddr(args);
  dynamic_wind_state(p) = DWIND_INIT;
  set_type(p, T_DYNAMIC_WIND | T_DONT_COPY); /* atom -> don't mark car/cdr, don't copy */

  push_stack(sc, OP_DYNAMIC_WIND, sc->NIL, p);          /* args will be the saved result, code = s7_dynwind_t obj */
  push_stack(sc, OP_APPLY, sc->NIL, car(args));
  return(sc->F);
}

/* C-side dynamic-wind would need at least void* context pointer passed to each function,
 *   and to fit with the scheme-side stuff above, the functions need to be s7 functions,
 *   so I wonder if it could be s7_dynamic_wind(s7_scheme *sc, s7_pointer init, s7_pointer body, s7_pointer finish)
 *   and the caller would use the C-closure idea (s7.html) to package up C-side data.
 *   Then, the caller would probably assume a return value, requiring s7_call?
 *   -> g_dynamic_wind(sc, list_3(sc, init, body, finish)) but with eval(sc, OP_APPLY) at end?
 */


static s7_pointer g_catch(s7_scheme *sc, s7_pointer args)
{
  #define H_catch "(catch tag thunk handler) evaluates thunk; if an error occurs that matches the tag (#t matches all), the handler is called"
  s7_pointer p;

  /* should this check for a tag that can't possibly be eq? to anything that error might throw? (a string for example)
   */
  if (!is_thunk(sc, cadr(args)))
    return(s7_wrong_type_arg_error(sc, "catch", 2, cadr(args), "a thunk"));
  if (!is_procedure(caddr(args)))
    return(s7_wrong_type_arg_error(sc, "catch", 3, caddr(args), "a procedure"));
  
  NEW_CELL(sc, p);
  catch_tag(p) = car(args);
  catch_goto_loc(p) = s7_stack_top(sc);
  catch_op_loc(p) = (int)(sc->op_stack_now - sc->op_stack);
  catch_handler(p) = caddr(args);
  set_type(p, T_CATCH | T_DONT_COPY); /* atom -> don't mark car/cdr, don't copy */

  push_stack(sc, OP_CATCH, sc->NIL, p);          /* {1} */

  if (is_closure(cadr(args)))
    {
      sc->code = closure_body(cadr(args));
      NEW_FRAME(sc, closure_environment(cadr(args)), sc->envir);
      push_stack(sc, OP_BEGIN, sc->args, sc->code);
    }
  else push_stack(sc, OP_APPLY, sc->NIL, cadr(args)); /* {1} */
  return(sc->F);
}



s7_pointer s7_catch_all(s7_scheme *sc, s7_pointer thunk, s7_pointer error_handler)
{
  s7_pointer p;

  NEW_CELL(sc, p);
  catch_tag(p) = sc->T;                   /* if we catch everything, the error handling stuff in s7_call is not needed */
  catch_goto_loc(p) = s7_stack_top(sc);
  catch_op_loc(p) = (int)(sc->op_stack_now - sc->op_stack);
  catch_handler(p) = error_handler;
  set_type(p, T_CATCH | T_DONT_COPY);

  push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
  push_stack(sc, OP_CATCH, sc->NIL, p);
  sc->args = sc->NIL;
  sc->code = thunk;
  eval(sc, OP_APPLY);

  return(sc->value);
}


#if 0
/* here's an example:
 *
    static s7_pointer error_handler(s7_scheme *sc, s7_pointer args)
    {
      fprintf(stderr, "got an error! %s\n", s7_object_to_c_string(sc, args));
      return(s7_car(args));
    }
    
    static s7_pointer adder(s7_scheme *sc, s7_pointer args)
    {
      return(s7_f(sc));
    }
    
    int main(int argc, char **argv)
    {
      s7_scheme *s7;
      s7 = s7_init();  
      fprintf(stderr, "catch: %s\n",
        s7_object_to_c_string(s7, 
    	  s7_catch_all(s7, 
    	    s7_make_function(s7, "adder", adder, 0, 0, false, "+"),
    	    s7_make_function(s7, "error-handler", error_handler, 0, 0, true, "error handler"))));
    }
 *
 * the function names are local (for error handling etc).  In general, it would be safer to
 *    call s7_gc_protect on the functions (s7_make_function does not protect them).  The
 *    body function ("adder") is a thunk -- args will always be nil.
 */
#endif


/* error reporting info -- save filename and line number */

#define INITIAL_FILE_NAMES_SIZE 8
static s7_pointer *file_names = NULL;
static int file_names_size = 0;
static int file_names_top = -1;

#define remembered_line_number(Line) (Line & 0xfffff)
#define remembered_file_name(Line)   (((Line >> 20) <= file_names_top) ? file_names[Line >> 20] : sc->F)
/* this gives room for 4000 files each of 1000000 lines */


static int remember_file_name(s7_scheme *sc, const char *file)
{
  int i, old_size = 0;

  file_names_top++;
  if (file_names_top >= file_names_size)
    {
      if (file_names_size == 0)
	{
	  file_names_size = INITIAL_FILE_NAMES_SIZE;
	  file_names = (s7_pointer *)calloc(file_names_size, sizeof(s7_pointer));
	}
      else
	{
	  old_size = file_names_size;
	  file_names_size *= 2;
	  file_names = (s7_pointer *)realloc(file_names, file_names_size * sizeof(s7_pointer));
	}
      for (i = old_size; i < file_names_size; i++)
	file_names[i] = sc->F;
    }
  file_names[file_names_top] = s7_make_permanent_string(file);

  return(file_names_top);
}


#define ERROR_INFO_DEFAULT sc->F
#define ERROR_TYPE 0
#define ERROR_DATA 1
#define ERROR_CODE 2
#define ERROR_CODE_LINE 3
#define ERROR_CODE_FILE 4
#define ERROR_ENVIRONMENT 5
#define ERROR_STACK_SIZE 8
#define ERROR_INFO_SIZE (6 + ERROR_STACK_SIZE)

/* *error-info* is a vector of 6 or more elements:
 *    0: the error type or tag ('division-by-zero)
 *    1: the message or information passed by the error function
 *    2: if not #f, the code that s7 thinks triggered the error
 *    3: if not #f, the line number of that code
 *    4: if not #f, the file name of that code
 *    5: the environment at the point of the error
 *    6..top: stack enviroment pointers (giving enough info to reconstruct the current call stack), ending in #f
 */

/* slightly ugly:

(define-macro (cerror . args)
  `(call/cc
    (lambda (continue)
      (apply error continue ',args))))

;;; now ((vector-ref *error-info* 0)) will continue from the error

(define (cerror . args)
  (format #t "error: ~A" (car args))
  (if (not (null? (cdr args)))
      (if (and (string? (cadr args))
	       (not (null? (cddr args))))
	  (let ((str (apply format (cdr args))))
	    (format #t "~S~%" str))
	  (format #t "~S~%" (cadr args))))
  (format #t "continue? (<cr>=yes) ")
  (let ((val (read-line ())))
    (if (not (char=? (val 0) #\newline))
	(error (car args)))))

;;; so perhaps wrap the caller-passed stuff in "continue?" etc?
*/


static s7_pointer s7_error_1(s7_scheme *sc, s7_pointer type, s7_pointer info, bool exit_eval)
{
  int i;
  bool reset_error_hook = false;
  s7_pointer catcher;
  const char *call_name = NULL, *call_file = NULL;
  int call_line = 0;

  /* set up *error-info*, look for a catch that matches 'type', if found
   *   call its error-handler, else if *error-hook* is bound, call it,
   *   else send out the error info ourselves.
   */
  sc->no_values = 0;
  catcher = sc->F;

  if (sc->s7_call_name)
    {
      call_name = sc->s7_call_name;
      call_file = sc->s7_call_file;
      call_line = sc->s7_call_line;
      sc->s7_call_name = NULL;
      sc->s7_call_file = NULL;
      sc->s7_call_line = -1;
    }

  vector_element(sc->error_info, ERROR_TYPE) = type;
  vector_element(sc->error_info, ERROR_DATA) = info;
  vector_element(sc->error_info, ERROR_CODE) = sc->cur_code;
  vector_element(sc->error_info, ERROR_CODE_LINE) = ERROR_INFO_DEFAULT;
  vector_element(sc->error_info, ERROR_CODE_FILE) = ERROR_INFO_DEFAULT;
  vector_element(sc->error_info, ERROR_ENVIRONMENT) = sc->envir;
  s7_gc_on(sc, true);  /* this is in case we were triggered from the sort function -- clumsy! */

  /* (let ((x 32)) (define (h1 a) (* a "hi")) (define (h2 b) (+ b (h1 b))) (h2 1)) */
  if (is_pair(sc->cur_code))
    {
      int line, j, top;
      line = pair_line_number(sc->cur_code);

      if ((line > 0) &&
	  (remembered_line_number(line) != 0) &&
	  (remembered_file_name(line) != sc->F))
	{
	  vector_element(sc->error_info, ERROR_CODE_LINE) = s7_make_integer(sc, remembered_line_number(line));
	  vector_element(sc->error_info, ERROR_CODE_FILE) = remembered_file_name(line);	  
	}

      for (top = s7_stack_top(sc) - 1, j = ERROR_ENVIRONMENT + 1; (top > 0) && (j < ERROR_INFO_SIZE); top -= 4, j++)
	vector_element(sc->error_info, j) = stack_environment(sc->stack, top);
      if (j < ERROR_INFO_SIZE)
	vector_element(sc->error_info, j) = ERROR_INFO_DEFAULT;
    }

  sc->cur_code = ERROR_INFO_DEFAULT;

  /* if (!s7_is_continuation(type))... */

  /* top is 1 past actual top, top - 1 is op, if op = OP_CATCH, top - 4 is the cell containing the catch struct */
  for (i = s7_stack_top(sc) - 1; i >= 3; i -= 4)
    {
      opcode_t op;
      s7_pointer x;

      op = stack_op(sc->stack, i);
      switch (op)
	{
	case OP_DYNAMIC_WIND:
	  x = stack_code(sc->stack, i);
	  if (dynamic_wind_state(x) == DWIND_BODY)
	    {
	      dynamic_wind_state(x) = DWIND_FINISH;   /* make sure an uncaught error in the exit thunk doesn't cause us to loop */
	      push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
	      sc->args = sc->NIL;
	      sc->code = dynamic_wind_out(x);
	      eval(sc, OP_APPLY);                     /* I guess this means no call/cc out of the exit thunk in an error-catching context */
	    }
	  break;

	case OP_CATCH:
	  x = stack_code(sc->stack, i);
	  if ((type == sc->T) ||
	      (catch_tag(x) == sc->T) ||
	      (catch_tag(x) == type))
	    {
	      catcher = x;
	      goto GOT_CATCH;
	    }
	  break;

	case OP_UNWIND_OUTPUT:
	  x = stack_code(sc->stack, i);                /* "code" = port that we opened */
	  s7_close_output_port(sc, x);
	  x = stack_args(sc->stack, i);                /* "args" = port that we shadowed, if not #f */
	  if (x != sc->F)
	    sc->output_port = x;
	  break;

	case OP_UNWIND_INPUT:
	  s7_close_input_port(sc, stack_code(sc->stack, i)); /* "code" = port that we opened */
	  sc->input_port = stack_args(sc->stack, i);         /* "args" = port that we shadowed */
	  sc->input_is_file = (is_file_port(sc->input_port));
	  break;

	case OP_READ_DONE:        /* perhaps an error during (read) */
	  pop_input_port(sc);
	  break;

	case OP_EVAL_STRING_1:    /* perhaps an error happened before we could push the OP_EVAL_STRING_2 */
	case OP_EVAL_STRING_2:
	  s7_close_input_port(sc, sc->input_port);
	  pop_input_port(sc);
	  break;

	case OP_BARRIER:
	  if (is_input_port(stack_args(sc->stack, i)))      /* (eval-string "'(1 .)") */
	    {
	      if (sc->input_port == stack_args(sc->stack, i))
		pop_input_port(sc);
	      s7_close_input_port(sc, stack_args(sc->stack, i));
	    }
	  break;

	case OP_DEACTIVATE_GOTO:
	  call_exit_active(stack_args(sc->stack, i)) = false;
	  break;

	case OP_TRACE_RETURN:
	  sc->trace_depth--;
	  if (sc->trace_depth < 0) sc->trace_depth = 0;
	  break;

	  /* perhaps also OP_LOAD_CLOSE_AND_POP_IF_EOF 
	   *  currently an error during a nested load stops all loads
	   */

	case OP_ERROR_HOOK_QUIT:
	  hook_functions(sc->error_hook) = stack_code(sc->stack, i);

	  /* apparently there was an error during *error-hook* evaluation, but Rick wants the hook re-established anyway */
	  reset_error_hook = true;
	  /* avoid infinite loop -- don't try to (re-)evaluate (buggy) *error-hook*! */
	  break;

	default:
	  break;
	}
    }
  
GOT_CATCH:
  if (catcher != sc->F)
    {
      int loc;

      sc->args = list_2(sc, type, info);
      sc->code = catch_handler(catcher);
      loc = catch_goto_loc(catcher);
      sc->op_stack_now = (s7_pointer *)(sc->op_stack + catch_op_loc(catcher));
      sc->stack_end = (s7_pointer *)(sc->stack_start + loc);

      /* if user (i.e. yers truly!) copies/pastes the preceding lambda () into the
       *   error handler portion of the catch, he gets the inexplicable message:
       *       ;(): too many arguments: (a1 ())
       *   when this apply tries to call the handler.  So, we need a special case
       *   error check here!
       */
      if (!args_match(sc, sc->code, 2))
	return(s7_wrong_number_of_args_error(sc, "catch error handler has wrong number of args: ~A", sc->args));

      sc->op = OP_APPLY;

      /* explicit eval needed if s7_call called into scheme where a caught error occurred (ex6 in exs7.c)
       *  but putting it here (via eval(sc, OP_APPLY)) means the C stack is not cleared correctly in non-s7-call cases, 
       *  so defer it until s7_call 
       */
    }
  else
    {
      /* (set! *error-hook* (list (lambda (tag args) (apply format (cons #t args))))) */

      if ((!reset_error_hook) && 
	  (is_pair(hook_functions(sc->error_hook))))
	{
	  s7_pointer error_list;
	  /* (set! (hook-functions *error-hook*) (list (lambda args (format *stderr* "got error ~A~%" args)))) */

	  error_list = hook_functions(sc->error_hook);
	  hook_functions(sc->error_hook) = sc->NIL;
	  /* if the *error-hook* functions trigger an error, we had better not have *error-hook* still set! */

	  push_stack(sc, OP_ERROR_HOOK_QUIT, sc->NIL, error_list); /* restore *error-hook* upon successful (or any!) evaluation */
	  sc->args = list_2(sc, type, info);
	  sc->code = error_list;
	  /* push_stack(sc, OP_HOOK_APPLY, sc->args, sc->code); */

	  /* if we drop into the longjmp below, the hook functions are not called!
	   *   OP_ERROR_HOOK_QUIT performs the longjmp, so it should be safe to go to eval.
	   */
	  eval(sc, OP_HOOK_APPLY);
	}
      else
	{
	  /* if info is not a list, send object->string to current error port,
	   *   else assume car(info) is a format control string, and cdr(info) are its args
	   *
	   * if at all possible, get some indication of where we are!
	   */
	  s7_pointer x, error_port;
	  error_port = s7_current_error_port(sc);

	  if ((!s7_is_list(sc, info)) ||
	      (!s7_is_string(car(info))))
	    format_to_output(sc, error_port, "\n;~A ~A", list_2(sc, type, info));
	  else
	    {
	      const char *carstr;
	      int i, len;
	      bool use_format = false;
	      
	      /* it's possible that the error string is just a string -- not intended for format */
	      carstr = s7_string(car(info));
	      len = string_length(car(info));
	      for (i = 0; i < len; i++)
		if (carstr[i] == '~')
		  {
		    use_format = true;
		    break;
		  }
	      
	      if (use_format)
		{
		  char *errstr;
		  len += 8;
		  errstr = (char *)malloc(len * sizeof(char));
		  snprintf(errstr, len, "\n;%s", s7_string(car(info)));
		  format_to_output(sc, error_port, errstr, cdr(info));
		  free(errstr);
		}
	      else format_to_output(sc, error_port, "\n;~A ~A", list_2(sc, type, info));
	    }
	  
	  /* now display location at end */
	  
	  if ((is_input_port(sc->input_port)) &&
	      (port_file(sc->input_port) != stdin))
	    {
	      const char *filename = NULL;
	      int line;
	      
	      filename = port_filename(sc->input_port);
	      line = port_line_number(sc->input_port);
	      
	      if (filename)
		format_to_output(sc, error_port, "\n;  ~A[~D]",
				 list_2(sc, make_protected_string(sc, filename), s7_make_integer(sc, line)));
	      else 
		{
		  if (line > 0)
		    format_to_output(sc, error_port, "\n;  line ~D", 
				     list_1(sc, s7_make_integer(sc, line)));
		}
	    }
	  else
	    {
	      if ((call_file != NULL) &&
		  (call_name != NULL) &&
		  (call_line >= 0))
		{
		  format_to_output(sc, error_port, "\n;  ~A ~A[~D]",
				   list_3(sc, 
					       make_protected_string(sc, call_name), 
					       make_protected_string(sc, call_file), 
					       s7_make_integer(sc, call_line)));
		}
	    }
	  s7_newline(sc, error_port);

	  if (is_pair(vector_element(sc->error_info, ERROR_CODE)))
	    {
	      format_to_output(sc, error_port, ";    ~A", 
			       list_1(sc, vector_element(sc->error_info, ERROR_CODE)));
	      s7_newline(sc, error_port);

	      if (s7_is_string(vector_element(sc->error_info, ERROR_CODE_FILE)))
		{
		  format_to_output(sc, error_port, ";    [~S, line ~D]",
				   list_2(sc, 
					       vector_element(sc->error_info, ERROR_CODE_FILE), 
					       vector_element(sc->error_info, ERROR_CODE_LINE)));
		  s7_newline(sc, error_port);
		}
	    }

	  /* look for __func__ in the error environment etc
	   */
	  x = find_local_symbol(sc, vector_element(sc->error_info, ERROR_ENVIRONMENT), sc->__FUNC__);  /* returns nil if no __func__ */

	  if ((is_pair(x)) &&
	      (error_port != sc->F))
	    {
	      s7_display(sc, make_protected_string(sc, ";    "), error_port);
	      s7_display(sc, cdr(x), error_port);
	      s7_newline(sc, error_port);
	    }
	  
	  if ((exit_eval) &&
	      (sc->error_exiter))
	    (*(sc->error_exiter))();

	  /* if (s7_is_continuation(type))
	   *   go into repl here with access to continuation?  Or expect *error-handler* to deal with it?
	   */
	  sc->value = type;
	  stack_reset(sc);
	  sc->op = OP_ERROR_QUIT;
	}
    }

  if (sc->longjmp_ok)
    {
      longjmp(sc->goto_start, 1); /* this is trying to clear the C stack back to some clean state */
    }

  return(type);
}


s7_pointer s7_error(s7_scheme *sc, s7_pointer type, s7_pointer info)
{
  return(s7_error_1(sc, type, info, false));
}


s7_pointer s7_error_and_exit(s7_scheme *sc, s7_pointer type, s7_pointer info)
{
  return(s7_error_1(sc, type, info, true));
}


static s7_pointer apply_error(s7_scheme *sc, s7_pointer obj, s7_pointer args)
{
  /* the operator type is needed here else the error message is confusing:
   *    (apply '+ (list 1 2))) -> ;attempt to apply + to (1 2)?
   */
  if (is_null(obj))
    return(s7_error(sc, sc->SYNTAX_ERROR, list_2(sc, make_protected_string(sc, "attempt to apply nil to ~S?"), args)));
  return(s7_error(sc, sc->SYNTAX_ERROR, 
		  list_4(sc, 
			      make_protected_string(sc, "attempt to apply the ~A ~S to ~S?"), 
			      make_protected_string(sc, type_name(obj)),
			      obj, 
			      args)));
}


static s7_pointer eval_error(s7_scheme *sc, const char *errmsg, s7_pointer obj)
{
  return(s7_error(sc, sc->SYNTAX_ERROR, list_2(sc, make_protected_string(sc, errmsg), obj)));
}


static s7_pointer eval_error_with_name(s7_scheme *sc, const char *errmsg, s7_pointer obj)
{
  return(s7_error(sc, sc->SYNTAX_ERROR, 
		  list_3(sc, 
			      make_protected_string(sc, errmsg),
			      make_protected_string(sc, op_names[(int)(sc->op)]),
			      obj)));
}


static s7_pointer eval_error_no_arg(s7_scheme *sc, const char *errmsg)
{
  return(s7_error(sc, sc->SYNTAX_ERROR, list_1(sc, make_protected_string(sc, errmsg))));
}


static s7_pointer read_error(s7_scheme *sc, const char *errmsg)
{
  /* reader errors happen before the evaluator gets involved, so forms such as:
   *   (catch #t (lambda () (car '( . ))) (lambda arg 'error))
   * do not catch the error if we simply signal an error when we encounter it.
   */
  char *msg;
  int len;
  s7_pointer pt;
  pt = sc->input_port;

  /* make an heroic effort to find where we slid off the tracks */

  if (is_string_port(sc->input_port))
    {
      #define QUOTE_SIZE 40
      unsigned int i, j, start = 0, end, slen;
      char *recent_input = NULL;

      /* we can run off the end in cases like (eval-string "(. . ,.)") or (eval-string " (@ . ,.)") */
      if (port_string_point(pt) >= port_string_length(pt))        
	port_string_point(pt) = port_string_length(pt) - 1;

      /* start at current position and look back a few chars */
      for (i = port_string_point(pt), j = 0; (i > 0) && (j < QUOTE_SIZE); i--, j++)
	if ((port_string(pt)[i] == '\0') ||
	    (port_string(pt)[i] == '\n') ||
	    (port_string(pt)[i] == '\r'))
	  break;
      start = i;

      /* start at current position and look ahead a few chars */
      for (i = port_string_point(pt), j = 0; (i < port_string_length(pt)) && (j < QUOTE_SIZE); i++, j++)
	if ((port_string(pt)[i] == '\0') ||
	    (port_string(pt)[i] == '\n') ||
	    (port_string(pt)[i] == '\r'))
	  break;

      end = i;
      slen = end - start;
      /* hopefully this is more or less the current line where the read error happened */

      if (slen > 0)
	{
	  recent_input = (char *)calloc((slen + 9), sizeof(char));
	  for (i = 0; i < (slen + 8); i++) recent_input[i] = '.';
	  recent_input[3] = ' ';
	  recent_input[slen + 4] = ' ';
	  for (i = 0; i < slen; i++) recent_input[i + 4] = port_string(pt)[start + i];
	}

      if ((port_line_number(pt) > 0) &&
	  (port_filename(pt)))
	{
	  len = safe_strlen(recent_input) + safe_strlen(errmsg) + safe_strlen(port_filename(pt)) + safe_strlen(sc->current_file) + 64;
	  msg = (char *)malloc(len * sizeof(char));
	  len = snprintf(msg, len, "%s: %s %s[%d], last top-level form at: %s[%d]", 
			 errmsg, (recent_input) ? recent_input : "", port_filename(pt), port_line_number(pt),
			 sc->current_file, sc->current_line);
	}
      else
	{
	  len = safe_strlen(recent_input) + safe_strlen(errmsg) + safe_strlen(sc->current_file) + 64;
	  msg = (char *)malloc(len * sizeof(char));

	  if ((sc->current_file) &&
	      (sc->current_line >= 0))
	    len = snprintf(msg, len, "%s: %s, last top-level form at %s[%d]", 
			   errmsg, (recent_input) ? recent_input : "",
			   sc->current_file, sc->current_line);
	  else len = snprintf(msg, len, "%s: %s", errmsg, (recent_input) ? recent_input : "");
	}
      
      if (recent_input) free(recent_input);
      return(s7_error(sc, sc->READ_ERROR, 
		      list_1(sc, make_string_uncopied_with_length(sc, msg, len))));
    }

  if ((port_line_number(pt) > 0) &&
      (port_filename(pt)))
    {
      len = safe_strlen(errmsg) + safe_strlen(port_filename(pt)) + safe_strlen(sc->current_file) + 64;
      msg = (char *)malloc(len * sizeof(char));
      len = snprintf(msg, len, "%s %s[%d], last top-level form at %s[%d]", 
		     errmsg, port_filename(pt), port_line_number(pt), 
		     sc->current_file, sc->current_line);
      return(s7_error(sc, sc->READ_ERROR, 
		      list_1(sc, make_string_uncopied_with_length(sc, msg, len))));
    }

  return(s7_error(sc, sc->READ_ERROR, 
		  list_1(sc, make_protected_string(sc, (char *)errmsg))));
}


static s7_pointer g_error(s7_scheme *sc, s7_pointer args)
{
  #define H_error "(error type ...) signals an error.  The 'type' can be used with catch to trap \
particular errors.  If the error is not caught, s7 treats the 2nd argument as a format control string, \
and applies it to the rest of the arguments."

  if (is_not_null(args))
    {
      if (s7_is_string(car(args)))                    /* CL-style error? -- use tag = 'no-catch */
	{
	  s7_error(sc, make_symbol(sc, "no-catch"), args);
	  return(sc->UNSPECIFIED);
	}
      return(s7_error(sc, car(args), cdr(args)));
    }
  return(s7_error(sc, sc->NIL, sc->NIL));
}


/* PERHAPS: make length a parameter, and use in format, ~40S etc
 */
static char *object_to_truncated_string(s7_scheme *sc, s7_pointer p)
{
  int form_len;
  char *form;

  form = s7_object_to_c_string(sc, p); /* TODO: in long lists, this should stop when we reach 80 */
  form_len = safe_strlen(form);
  if (form_len > 80)
    {
      int i;
      for (i = 76; i >= 40; i--)
	if (is_white_space((int)form[i]))
	  {
	    form[i] = '.';
	    form[i + 1] = '.';
	    form[i + 2] = '.';
	    form[i + 3] = '\0';
	    break;
	  }
    }

  return(form);
}


static bool too_many_arguments(s7_scheme *sc, s7_pointer proc, int len)
{
  s7_pointer proc_args;
  proc_args = s7_procedure_arity(sc, proc);
  return((is_pair(proc_args)) &&
	 (caddr(proc_args) == sc->F) &&
	 ((s7_integer(car(proc_args)) + s7_integer(cadr(proc_args))) < len));
}


static char *missing_close_paren_syntax_check(s7_scheme *sc, s7_pointer lst)
{
  s7_pointer p;
  char *msg = NULL;
  for (p = lst; is_pair(p); p = cdr(p))
    {
      if (is_pair(car(p)))
	{
	  if (s7_is_symbol(caar(p)))
	    {
	      int len;
	      
	      len = s7_list_length(sc, car(p));
	      if (((s7_is_eq(caar(p), s7_make_symbol(sc, "if"))) &&
		   (len > 4)) ||
		  ((s7_is_procedure(symbol_value(caar(p)))) &&
		   (too_many_arguments(sc, symbol_value(caar(p)), len))) ||
		  ((s7_is_eq(caar(p), s7_make_symbol(sc, "define"))) &&
		   (is_pair(cdr(p))) &&
		   (s7_is_symbol(cadr(p))) &&
		   (len > 3)))
		{
		  int msg_len, form_len;
		  char *form;
		  /* it's very tricky to try to see other errors here, especially because 'case'
		   *   can have syntax names in its key lists.  Even this may get fooled, but
		   *   I'm hoping that more often than not, it will help track down the missing
		   *   close paren.
		   */

		  form = object_to_truncated_string(sc, car(p));
		  form_len = safe_strlen(form);
		  msg_len = form_len + 128;
		  msg = (char *)calloc(msg_len, sizeof(char));
		  snprintf(msg, msg_len, ";  this looks bogus: %s", form);
		  free(form);

		  return(msg);
		}
	    }
	  msg = missing_close_paren_syntax_check(sc, car(p));
	  if (msg) 
	    return(msg);
	}
    }
  return(NULL);
}


static s7_pointer missing_close_paren_error(s7_scheme *sc)
{
  int len;
  char *msg, *syntax_msg = NULL;
  s7_pointer pt;
  pt = sc->input_port;

  /* it's hard to give a good idea here of where the missing paren is because we've already
   *   popped off all the stacked info, following ')' until eof.
   * but the current incoming program code is in sc->args, reversed at its top level,
   *   so it's worth looking for some problem involving too many clauses (if) or arguments, etc.
   * this can be a hard bug to track down in a large program, so s7 really has to make an effort to help.
   */

  if (is_pair(sc->args))
    {
      sc->x = s7_reverse(sc, sc->args);
      syntax_msg = missing_close_paren_syntax_check(sc, sc->x);

      /* PERHAPS: if syntax_msg is null, we didn't find the problem, so perhaps show it indented?
       */
    }

  if ((port_line_number(pt) > 0) &&
      (port_filename(pt)))
    {
      len = safe_strlen(port_filename(pt)) + safe_strlen(sc->current_file) + safe_strlen(syntax_msg) + 128;
      msg = (char *)malloc(len * sizeof(char));
      if (syntax_msg)
	{
	  len = snprintf(msg, len, "missing close paren, %s[%d], last top-level form at %s[%d]\n%s", 
			 port_filename(pt), port_line_number(pt), 
			 sc->current_file, sc->current_line, syntax_msg);
	  free(syntax_msg);
	}
      else len = snprintf(msg, len, "missing close paren, %s[%d], last top-level form at %s[%d]", 
			  port_filename(pt), port_line_number(pt), 
			  sc->current_file, sc->current_line);
      return(s7_error(sc, sc->READ_ERROR, make_string_uncopied_with_length(sc, msg, len)));
    }

  if (syntax_msg)
    {
      len = safe_strlen(syntax_msg) + 128;
      msg = (char *)malloc(len * sizeof(char));
      len = snprintf(msg, len, "missing close paren\n%s\n", syntax_msg);
      free(syntax_msg);
      return(s7_error(sc, sc->READ_ERROR, make_string_uncopied_with_length(sc, msg, len)));
    }
  return(s7_error(sc, sc->READ_ERROR, 
		  list_1(sc, make_protected_string(sc, "missing close paren"))));
}


static void improper_arglist_error(s7_scheme *sc)
{
  /* sc->code is the last (dotted) arg, sc->args is the arglist reversed not including sc->code
   *   the original was `(,@(reverse args) . ,code) essentially
   */
  s7_error(sc, sc->SYNTAX_ERROR, 
	   list_2(sc,
		       make_protected_string(sc, "improper list of arguments: ~A"),
		       append_in_place(sc, safe_reverse_in_place(sc, sc->args), sc->code)));
}


/* (let ((a 43) (c 123)) (define (hi b) (stacktrace) b) (hi a)) */

static void display_frame(s7_scheme *sc, s7_pointer envir, s7_pointer port)
{
  s7_pointer frame;
  int i;
  for (i = 0, frame = envir; is_pair(car(frame)) && (i < 4); i++, frame = cdr(frame))
    {
      s7_pointer arg;
      arg = car(frame);
      while (is_not_null(arg))
	{
	  if ((car(arg) == sc->__FUNC__) ||
	      (!s7_is_procedure(cdr(arg))))
	    {
	      s7_write(sc, arg, port);
	      s7_write_char(sc, ' ', port);
	    }
	  arg = ecdr(arg);
	}
      s7_newline(sc, port);    
    }
}


static s7_pointer g_stacktrace(s7_scheme *sc, s7_pointer args)
{
  /* 3 cases currently: 
   *    if args=nil, show current stack
   *           =vector, assume it is a vector of envs from *error-info*
   *           =continuation, show its stack
   * if trailing arg is a port, it sets where the output goes
   */
  #define H_stacktrace "(stacktrace (obj #f) (port (current-output-port))) displays a stacktrace.  If obj is not \
given, the current stack is displayed, if obj is *error-info*, the stack at the point of the error is displayed, and if obj \
is a continuation, its stack is displayed.  If the trailing port argument is not given, \
output is sent to the current-output-port."

  int i, top = 0;
  s7_pointer stk = sc->F, port, obj;
  port = s7_current_output_port(sc);

  if (is_not_null(args))
    {
      if (is_output_port(car(args)))
	{
	  port = car(args);
	  args = cdr(args);
	}
      else
	{
	  if (is_not_null(cdr(args)))
	    {
	      if ((is_output_port(cadr(args))) &&
		  (!port_is_closed(cadr(args))))
		port = cadr(args);
	      else return(s7_wrong_type_arg_error(sc, "stacktrace", 2, cadr(args), "an open output port"));
	    }
	}
      obj = car(args);
    }
  else obj = sc->F;

  /* *error-info* is the special case here */
  if (s7_is_vector(obj))
    {
      if (vector_length(obj) < ERROR_INFO_SIZE)
	return(s7_wrong_type_arg_error(sc, "stacktrace", 1, obj, "*error-info*"));

      for (i = ERROR_ENVIRONMENT; i < ERROR_INFO_SIZE; i++)
	{
	  if (vector_element(obj, i) == ERROR_INFO_DEFAULT)
	    break;
	  display_frame(sc, vector_element(obj, i), port);
	}
      return(sc->UNSPECIFIED);
    }

  if (is_null(args))
    {
      top = s7_stack_top(sc);
      stk = sc->stack;
    }
  else
    {
      if (s7_is_continuation(obj))
	{
	  top = continuation_stack_top(obj);
	  stk = continuation_stack(obj);
	}
    }
  if (stk == sc->F)
    return(s7_wrong_type_arg_error(sc, "stacktrace", 0, args, "a vector, or continuation"));
  
  if (sc->envir != stack_environment(stk, top - 1))
    display_frame(sc, sc->envir, port);
  for (i = top - 1; i > 0; i -= 4)
    display_frame(sc, stack_environment(stk, i), port);

  return(sc->UNSPECIFIED);
}


s7_pointer s7_stacktrace(s7_scheme *sc, s7_pointer arg)
{
  if (s7_is_list(sc, arg))
    return(g_stacktrace(sc, arg));
  return(g_stacktrace(sc, list_1(sc, arg)));
}




/* -------------------------------- leftovers -------------------------------- */


bool (*s7_begin_hook(s7_scheme *sc))(s7_scheme *sc)
{
  return(sc->begin_hook);
}


void s7_set_begin_hook(s7_scheme *sc, bool (*hook)(s7_scheme *sc))
{
  sc->begin_hook = hook;
}


void s7_quit(s7_scheme *sc)
{
  sc->longjmp_ok = false;
  pop_input_port(sc);

  stack_reset(sc);
  push_stack(sc, OP_EVAL_DONE, sc->NIL, sc->NIL);
}


static s7_pointer apply_list_star(s7_scheme *sc, s7_pointer d) 
{
  s7_pointer p, q;
  if (is_null(cdr(d)))
    return(car(d));
  
  p = cons(sc, car(d), cdr(d));
  q = p;
  while (is_not_null(cdr(cdr(p))))
    {
      d = cons(sc, car(p), cdr(p));
      if (is_not_null(cdr(cdr(p))))
	p = cdr(d);
    }
  cdr(p) = car(cdr(p));
  return(q);
}


static s7_pointer g_apply(s7_scheme *sc, s7_pointer args)
{
  #define H_apply "(apply func ...) applies func to the rest of the arguments"

  sc->code = car(args);
  if (is_null(cdr(args)))
    sc->args = sc->NIL;
  else 
    {
      if (is_safe_procedure(sc->code))
	{
	  s7_pointer p, q;
	  for (q = args, p = cdr(args); is_not_null(cdr(p)); q = p, p = cdr(p));

	  if (!is_proper_list(sc, car(p)))        /* (apply + #f) etc */
	    return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			    list_2(sc, 
					make_protected_string(sc, "apply's last argument should be a proper list: ~A"),
					args)));
	  
	  cdr(q) = car(p);
	  push_stack(sc, OP_APPLY, cdr(args), sc->code);
	  return(sc->NIL);
	}
      else
	{
	  /* here we have to copy the args */
	  sc->args = apply_list_star(sc, cdr(args));

	  if (!is_proper_list(sc, sc->args))        /* (apply + #f) etc */
	    return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			    list_2(sc, 
					make_protected_string(sc, "apply's last argument should be a proper list: ~A"),
					args)));
	}
    }

  if (is_any_macro(sc->code))                   /* (apply mac '(3)) -> (apply mac '((mac 3))) */
    {
      push_stack(sc, OP_EVAL_MACRO, sc->NIL, sc->NIL);
      sc->args = list_1(sc, cons(sc, sc->code, sc->args));
    }
  push_stack(sc, OP_APPLY, sc->args, sc->code);
  return(sc->NIL);
}


static s7_pointer g_eval(s7_scheme *sc, s7_pointer args)
{
  #define H_eval "(eval code (env (current-environment))) evaluates code in the environment env. 'env' \
defaults to the current environment; to evaluate something in the top-level environment instead, \
pass (global-environment):\n\
\n\
  (define x 32) \n\
  (let ((x 3))\n\
    (eval 'x (global-environment)))\n\
\n\
  returns 32"
  
  if (is_not_null(cdr(args)))
    {
      if (!is_environment(cadr(args)))
	return(s7_wrong_type_arg_error(sc, "eval", 2, cadr(args), "an environment"));

      if (cadr(args) == sc->global_env)
	sc->envir = sc->NIL;
      else sc->envir = cadr(args);
    }
  sc->code = car(args);

  if (s7_stack_top(sc) < 12)
    push_stack(sc, OP_BARRIER, sc->NIL, sc->NIL);
  push_stack(sc, OP_EVAL, sc->args, sc->code);
  return(sc->NIL);
}


s7_pointer s7_call(s7_scheme *sc, s7_pointer func, s7_pointer args)
{
  bool old_longjmp;
  jmp_buf old_goto_start;

  /* this can be called while we are in the eval loop (within eval_c_string for instance),
   *   and if we reset the stack, the previously running evaluation steps off the end
   *   of the stack == segfault. 
   */

  if (is_c_function(func))
    return(c_function_call(func)(sc, args));  /* no check for wrong-number-of-args -- is that reasonable? */

  sc->temp1 = func;
  sc->temp2 = args;

  old_longjmp = sc->longjmp_ok;
  memcpy((void *)old_goto_start, (void *)(sc->goto_start), sizeof(jmp_buf));

  /* if an error occurs during s7_call, and it is caught, catch (above) wants to longjmp
   *   to its caller to complete the error handler evaluation so that the C stack is
   *   cleaned up -- this means we have to have the longjmp location set here, but
   *   we could get here from anywhere, so we need to save and restore the incoming
   *   longjmp location.
   */

  sc->longjmp_ok = true;
  if (setjmp(sc->goto_start) != 0) /* returning from s7_error catch handler */
    {
      sc->longjmp_ok = old_longjmp;
      memcpy((void *)(sc->goto_start), (void *)old_goto_start, sizeof(jmp_buf));
      
      if ((sc->op == OP_ERROR_QUIT) &&
	  (sc->longjmp_ok))
	{
	  longjmp(sc->goto_start, 1); /* this is trying to clear the C stack back to some clean state */
	}

      eval(sc, sc->op); 
      /* sc->op can be OP_APPLY if s7_call raised an error that was caught (via catch) -- we're about to go to the error handler */
      return(sc->value);
    }

  push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); /* {4} this saves the current evaluation and will eventually finish this (possibly) nested call */
  sc->args = args; 
  sc->code = func; 

  eval(sc, OP_APPLY);

  sc->longjmp_ok = old_longjmp;
  memcpy((void *)(sc->goto_start), (void *)old_goto_start, sizeof(jmp_buf));

  return(sc->value);
} 


s7_pointer s7_call_with_location(s7_scheme *sc, s7_pointer func, s7_pointer args, const char *caller, const char *file, int line)
{ 
  s7_pointer result;

  if (caller)
    {
      sc->s7_call_name = caller;
      sc->s7_call_file = file;
      sc->s7_call_line = line;
    }

  result = s7_call(sc, func, args);
  
  if (caller)
    {
      sc->s7_call_name = NULL;
      sc->s7_call_file = NULL;
      sc->s7_call_line = -1;
    }

  return(result);
}


static s7_pointer g_s7_version(s7_scheme *sc, s7_pointer args)
{
  #define H_s7_version "(s7-version) returns some string describing the current s7"
  return(s7_make_string(sc, "s7 " S7_VERSION ", " S7_DATE));
}



/* ---------------------------------------- map and for-each ---------------------------------------- */

static s7_Int applicable_length(s7_scheme *sc, s7_pointer obj)
{
  switch (type(obj))
    {
    case T_PAIR:
      {
	s7_Int len;
	len = s7_list_length(sc, obj);
	if (len < 0)             /* dotted (does not include the final cdr -- perhaps this is a bug) */
	  return(-len);          /*         it means that (map abs '(1 . "hi")) returns '(1) */
	if (len == 0)            /* circular */
	  return(S7_LONG_MAX);
	return(len);
      }

    case T_C_OBJECT:
      {
	/* both map and for-each assume sc->x|y|z are unchanged across this call */
	s7_pointer result;

	result = object_length(sc, obj);
	if (s7_is_integer(result))   /* we need to check, else misinterpreting it as an integer can lead to a infinite loop */
	  return(s7_integer(result));
	return(-1);
      }

    case T_STRING:
      return(string_length(obj));

    case T_VECTOR:
      return(vector_length(obj));

    case T_HASH_TABLE:
      return(hash_table_entries(obj));

    case T_NIL:
      return(0);
    }
  
  return(-1);
}


static bool next_for_each(s7_scheme *sc)
{
  /* func = sc->code, func-args = cadr(sc->args), counter = car(sc->args), len = denominator(number(car(sc->args))), object(s) = cddr(sc->args) */
  s7_pointer x, y, z, vargs, fargs;
  int loc, zloc = -1;

  z = sc->NIL;
  vargs = cddr(sc->args);
  fargs = cadr(sc->args);
  loc = s7_integer(car(sc->args));

  /* for-each func ... -- each trailing sequence arg contributes one arg to the current call on func, 
   *   so in the next loop, gather one arg from each sequence.
   */

  for (x = fargs, y = vargs; is_not_null(x); x = cdr(x), y = cdr(y))
    switch (type(car(y)))
      {
      case T_PAIR:
	car(x) = caar(y);
	car(y) = cdar(y);
	break;

      case T_C_OBJECT: 
	{
	  int save_x = -1, save_y = -1, save_z = -1;
	  if (is_null(z))
	    {
	      z = list_1(sc, s7_make_integer(sc, loc));

	      /* we can't use car(sc->args) directly here -- it is a mutable integer, incremented below,
	       *   but the object application (the getter function) might return the index!
	       *   Then, we pre-increment, and the for-each application sees the incremented value.
	       *
               *    (let ((ctr ((cadr (make-type :getter (lambda (a b) b) :length (lambda (a) 4))))) (sum 0))
               *      (for-each (lambda (a b) (set! sum (+ sum a b))) ctr ctr) sum)
	       */
	      zloc = s7_gc_protect(sc, z);
	    }

	  SAVE_X_Y_Z(save_x, save_y, save_z);
	  car(x) = (*(object_ref(car(y))))(sc, car(y), z);
	  RESTORE_X_Y_Z(save_x, save_y, save_z);
	}
	break;

      case T_VECTOR:
	car(x) = vector_element(car(y), loc); 
	break;

      case T_CLOSURE: /* hash-table via an iterator */
	car(x) = g_hash_table_iterate(sc, cdadar(closure_body(car(y))));  /* cdadadar? I suppose this accessor could be optimized */
	break;

      case T_STRING:
	car(x) = s7_make_character(sc, ((unsigned char)(string_value(car(y))[loc])));
	break;

      default:           /* see comment in next_map: (let ((L (list 1 2 3 4 5))) (for-each (lambda (x) (set-cdr! (cddr L) 5) (display x)) L)) */
	if (is_not_null(z))
	  s7_gc_unprotect_at(sc, zloc);
	return(false);
	break;
      }

  if (zloc != -1)
    s7_gc_unprotect_at(sc, zloc);

  integer(number(car(sc->args))) = loc + 1;
  push_stack(sc, OP_FOR_EACH, sc->args, sc->code);
  sc->args = fargs;

  if (is_macro(sc->code))
    {
      push_stack(sc, OP_EVAL_MACRO, sc->NIL, sc->args);
      car(sc->TEMP_CELL_1) = sc->code;
      cdr(sc->TEMP_CELL_1) = sc->args;
      sc->args = sc->TEMP_CELL;
    }

  return(true);
}


static bool is_sequence(s7_scheme *sc, s7_pointer p)
{
  return((s7_is_list(sc, p)) ||
	 (s7_is_vector(p)) ||
	 (s7_is_string(p)) ||
	 (s7_is_hash_table(p)) ||
	 (is_c_object(p)));
}


static s7_pointer g_for_each(s7_scheme *sc, s7_pointer args)
{
  #define H_for_each "(for-each proc object . objects) applies proc to each element of the objects traversed in parallel. \
Each object can be a list (the normal case), string, vector, hash-table, or any applicable object."

  /* (for-each (lambda (n) (format #t "~A " n)) (vct 1.0 2.0 3.0)) */
  s7_Int i, len = 0; 
  /* "int" here is unhappy on 64-bit machines, and "long int" is unhappy on 32-bit machines, so try long long int.
   *    string_length is an int.
   */
  s7_pointer obj, x;
  sc->code = car(args); /* the function */

  /* macro application requires the entire call as the argument to apply, but apply itself fixes this up.
   *  that is, g_apply checks, then goes to OP_EVAL_MACRO after OP_APPLY with the fixed up list,
   *  but here we are simply sending it to OP_APPLY, so
   *
   *    (define-macro (hi a) `(+ ,a 1))
   *    (apply hi '(1))                 ; internally rewritten as (apply hi '((hi 1)))
   *    2                               ; apply adds the evaluation if its 1st arg is a macro
   *    (map hi '((hi 1) (hi 2)))       ; here we've rewritten the arg lists by hand
   *    ((+ 1 1) (+ 2 1))               ; but no evaluation
   *
   * ideally I think it should be
   *
   *    (map hi '(1 2))
   *    (2 3)
   *
   * OP_APPLY knows this is happening (in the 2nd case) and raises an error -- what would break
   *   if we handle it locally instead?  This actually affects only T_C_MACRO (quasiquote) --
   *   normal macros/bacros would still be broken.
   * or could we rewrite the args to fit just as in apply? (also need the evaluation)
   */

  /* before checking len=0, we need to check that the arguments are all sequences (this is like our handling of args to + for example)
   *   otherwise (for-each = "" 123) -> #<unspecified> 
   * the function may not actually be applicable to its sequence elements, but that isn't an error:
   *   (map abs "") -> '()
   */
  obj = cadr(args); 

  if ((is_pair(obj)) &&                                               /* arg is a list */
      (is_null(cddr(args))))                                          /* only one list arg */
    {
      len = s7_list_length(sc, obj);
      if ((len > 0) &&                                                /* a proper list arg */
	  (type(sc->code) == T_CLOSURE) &&                            /* not lambda* that might get confused about arg names */
	  (is_pair(closure_args(sc->code))) &&                        /* not a rest arg */
	  (!is_immutable(car(closure_args(sc->code)))) &&             /* not a bad arg name! TODO: accessor check here? */
	  (safe_list_length(sc, closure_args(sc->code)) == 1))        /* closure takes just one arg */
	{
	  /* one list arg -- special, but very common case */
	  push_stack(sc, OP_FOR_EACH_SIMPLE, obj, sc->code);
	  return(sc->UNSPECIFIED);

	  /* PERHAPS: this, and map, across a string (say) or other sequence involving
	   *          only 1 arg could be optimized in the same way. OP_FOR_EACH|MAP_STRING|VECTOR|C_OBJECT
	   */
	}

      if (len < 0)
	len = -len; 
      else
	if (len == 0) 
	  len = S7_LONG_MAX;
    }
  else 
    {
      for (i = 2, x = cdr(args); is_not_null(x); x = cdr(x), i++)
	{
	  s7_Int nlen;
	  if (!is_sequence(sc, car(x)))
	    return(s7_wrong_type_arg_error(sc, "for-each", i, car(x), "a sequence"));

	  nlen = applicable_length(sc, car(x));
	  if (nlen < 0)
	    return(s7_wrong_type_arg_error(sc, "for-each", i, car(x), "a vector, list, string, hash-table, or applicable object"));
	  if ((i == 2) || (nlen < len))
	    len = nlen;
	  if (len == 0) 
	    {
	      int k;
	      for (k = i + 1, x = cdr(x); is_not_null(x); x = cdr(x), k++)
		if (!is_sequence(sc, car(x)))
		  return(s7_wrong_type_arg_error(sc, "for-each", k, car(x), "a sequence"));
	      break;   /* need error check below */
	    }
	}
    }

  if (len != 0)
    {
      sc->x = list_1(sc, sc->NIL);
      if (s7_is_hash_table(obj))
	sc->z = list_1(sc, g_make_hash_table_iterator(sc, cdr(args)));
      else sc->z = list_1(sc, obj);

      /* we have to copy the args if any of them is a list:
       *     (let* ((x (list (list 1 2 3))) (y (apply for-each abs x))) (list x y))
       *  (is this trying to say that the for-each loop might otherwise change the original list as it cdrs down it?)
       */

      if (is_not_null(cddr(args)))
	{
	  for (i = 3, x = cddr(args); is_not_null(x); x = cdr(x), i++)
	    {
	      sc->x = cons(sc, sc->NIL, sc->x);          /* we're making a list to be filled in later with the individual args */

	      if (s7_is_hash_table(car(x)))
		sc->z = cons_unchecked(sc, g_make_hash_table_iterator(sc, x), sc->z);
	      else sc->z = cons_unchecked(sc, car(x), sc->z);
	    }
	}
    }
  else /* len == 0 */
    {
      /* here we can't depend on OP_APPLY to do the error check on the 1st arg:
       *   (map 0 '()) -> '()
       * so we check by hand before returning #<unspecified>
       */
      if (((typeflag(sc->code) & (T_ANY_MACRO | T_PROCEDURE)) != 0) ||
	  (is_pair(sc->code)) ||                   /* if this used is_sequence (above), (map '()...) would not be an error */
	  (s7_is_string(sc->code)) ||
	  (s7_is_vector(sc->code)) ||
	  (s7_is_hash_table(sc->code)) ||
	  (is_hook(sc->code)) ||
	  (is_syntax(sc->code)))
	return(sc->UNSPECIFIED);    /* circular -> S7_LONG_MAX in this case, so 0 -> nil */
      return(s7_wrong_type_arg_error(sc, "for-each", 1, sc->code, "a procedure or something applicable"));
    }

  if (len == S7_LONG_MAX)
    {
      /* if at this point len == S7_LONG_MAX, then all args are circular lists, assuming that
       *    we're not looking at some enormous vector or string -- perhaps -1 would be a
       *    better marker.  This actually might not be an error (the for-each function could
       *    have call-with-exit), but it seems better to complain about it.
       * 
       * this means that a make-type generator's length is tricky:
       *    (let ((ctr ((cadr (make-type :getter (lambda (a b) b) :length (lambda (a) (- (expt 2 31) 1)))))) (sum 0))
       *      (call-with-exit (lambda (go) (for-each (lambda (a) (set! sum (+ sum a)) (if (> sum 100) (go sum))) ctr))))
       * returns an error about circular lists, but should return 105.
       *
       * I think I'll at least check that the args were in fact lists.
       */
      for (x = cdr(args); (is_pair(x)) && (is_pair(car(x))); x = cdr(x)) {}
      if (!is_pair(x))
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "for-each's arguments are circular lists! ~A"), cdr(args))));
    }

  sc->y = args;
  x = make_mutable_integer(sc, 0);
  denominator(number(x)) = len;
  sc->args = cons_unchecked(sc, x,                         /* '(counter applicable-len func-args-holder . objects) */
               cons_unchecked(sc, sc->x, 
                 safe_reverse_in_place(sc, sc->z)));
  sc->x = sc->NIL;
  sc->y = sc->NIL;
  sc->z = sc->NIL;
  push_stack(sc, OP_FOR_EACH, sc->args, sc->code);
  return(sc->UNSPECIFIED);
}


static bool next_map(s7_scheme *sc)
{
  /* func = sc->code, results so far = cadr(sc->args), counter = car(sc->args), len = denominator(number(car(sc->args))), object(s) = cddr(sc->args) */
  s7_pointer y, z, vargs;
  int loc, zloc = -1;

  z = sc->NIL;
  vargs = cddr(sc->args);
  loc = s7_integer(car(sc->args));
  sc->x = sc->NIL;                     /* can't use preset args list here (as in for-each): (map list '(a b c)) */

  for (y = vargs; is_not_null(y); y = cdr(y))
    {
      s7_pointer x;
      switch (type(car(y)))
	{
	case T_PAIR:
	  x = caar(y);
	  car(y) = cdar(y);
	  break;
	  
	case T_C_OBJECT: 
	  {
	    int save_x = -1, save_y = -1, save_z = -1;
	    if (is_null(z))
	      {
		z = list_1(sc, s7_make_integer(sc, loc));
		zloc = s7_gc_protect(sc, z);
	      }
	    SAVE_X_Y_Z(save_x, save_y, save_z);
	    x = (*(object_ref(car(y))))(sc, car(y), z);
	    RESTORE_X_Y_Z(save_x, save_y, save_z);
	  }
	  break;
	
	case T_VECTOR:
	  x = vector_element(car(y), loc); 
	  break;

	case T_STRING:
	  x = s7_make_character(sc, ((unsigned char)(string_value(car(y))[loc])));
	  break;

	case T_CLOSURE:   /* hash-table via an iterator */
	  x = g_hash_table_iterate(sc, cdr(cadar(closure_body(car(y)))));
	  break;

	default: 
	  /* this can happen if one of the args is clobbered by the map function, so our initial
	   *   length is messed up:
	   *   (let ((L (list 1 2 3 4 5))) (map (lambda (x) (set-cdr! (cddr L) 5) x) L))
	   */

	  if (is_not_null(z))
	    s7_gc_unprotect_at(sc, zloc);
	  return(false);                  /* this stops the map process, so the code mentioned above returns '(1 2 3) */
	  break;
	}
      
      sc->x = cons(sc, x, sc->x);
    }

  if (is_not_null(z))
    s7_gc_unprotect_at(sc, zloc);
  sc->x = safe_reverse_in_place(sc, sc->x);

  integer(number(car(sc->args))) = loc + 1;
  push_stack(sc, OP_MAP, sc->args, sc->code);
  sc->args = sc->x;
  sc->x = sc->NIL;

  if (is_macro(sc->code))
    {
      /* (let ((lst '(1 2 3))) 
       *   (define-macro (hiho a) `(+ 1 ,a)) 
       *   (map hiho lst)) 
       * -> '(2 3 4)
       */
      push_stack(sc, OP_EVAL_MACRO, sc->NIL, sc->args);
      car(sc->TEMP_CELL_1) = sc->code;
      cdr(sc->TEMP_CELL_1) = sc->args;
      sc->args = sc->TEMP_CELL;
    }

  return(true);
}


static s7_pointer g_map(s7_scheme *sc, s7_pointer args)
{
  #define H_map "(map proc object . objects) applies proc to a list made up of the next element of each of its arguments, returning \
a list of the results.  Its arguments can be lists, vectors, strings, hash-tables, or any applicable objects."

  s7_Int i, len;
  s7_pointer obj, x;
  sc->code = car(args);

  for (i = 2, x = cdr(args); is_not_null(x); x = cdr(x), i++)
    if (!is_sequence(sc, car(x)))
      return(s7_wrong_type_arg_error(sc, "map", i, car(x), "a sequence"));

  sc->y = args;                     /* gc protect */
  obj = cadr(args); 

  /* there are two simple cases here: a safe function can be handled immediately, and a closure
   *   with one arg called with one list can be handled without all the elaborate run-time checks.
   */

  if ((is_pair(obj)) &&                                               /* arg is a list */
      (is_null(cddr(args))))                                          /* only one list arg */
    {
      len = s7_list_length(sc, obj);
      if (len > 0)                                                    /* a proper list arg */
	{
	  if ((type(sc->code) == T_CLOSURE) &&                        /* not lambda* that might get confused about arg names */
	      (is_pair(closure_args(sc->code))) &&                    /* not a rest arg */
	      (!is_immutable(car(closure_args(sc->code)))) &&         /* not a bad arg name! TODO: accessor check here? */
	      (safe_list_length(sc, closure_args(sc->code)) == 1))    /* closure takes just one arg */
	    {
	      s7_pointer p;
	      p = cons(sc, sc->NIL, obj);
	      set_type(p, T_COUNTER);
	      symbol_id(p) = len;
	      push_stack(sc, OP_MAP_SIMPLE, p, sc->code);
	      return(sc->NO_VALUE);
	    }

	  if ((is_safe_procedure(sc->code)) &&
	      (is_c_function(sc->code)) &&
	      (args_match(sc, sc->code, 1)))
	    {
	      s7_pointer p;
	      s7_function func;
	      func = c_function_call(sc->code);
	      sc->x = sc->NIL;
	      sc->z = cons(sc, sc->F, sc->NIL);
	      for (p = obj; is_pair(p); p = cdr(p))
		{
		  car(sc->z) = car(p);
		  sc->x = cons(sc, (*func)(sc, sc->z), sc->x); /* can we assume a safe function won't return multiple values? */
		}
	      p = safe_reverse_in_place(sc, sc->x);
	      sc->x = sc->NIL;
	      
	      typeflag(sc->z) = 0;
	      (*(sc->free_heap_top++)) = sc->z;
	      sc->z = sc->NIL;

	      return(p);
	    }
	}

      if (len < 0)
	len = -len; 
      else
	if (len == 0) 
	  len = S7_LONG_MAX;
    }
  else len = applicable_length(sc, obj);

  if (len < 0)
    return(s7_wrong_type_arg_error(sc, "map", 2, obj, "a vector, list, string, hash-table, or applicable object"));

  if (len != 0)
    {
      if (s7_is_hash_table(obj))
	sc->z = list_1(sc, g_make_hash_table_iterator(sc, cdr(args)));
      else sc->z = list_1(sc, obj);

      /* we have to copy the args if any of them is a list:
       * (let* ((x (list (list 1 2 3))) (y (apply map abs x))) (list x y))
       */
      
      if (is_not_null(cddr(args)))
	{
	  for (i = 3, x = cddr(args); is_not_null(x); x = cdr(x), i++)
	    {
	      s7_Int nlen;
	      
	      nlen = applicable_length(sc, car(x));
	      if (nlen < 0)
		return(s7_wrong_type_arg_error(sc, "map", i, car(x), "a vector, list, string, hash-table, or applicable object"));
	      if (nlen < len) len = nlen;
	      if (len == 0) break; /* need error check below */
	      
	      if (s7_is_hash_table(car(x)))
		sc->z = cons(sc, g_make_hash_table_iterator(sc, x), sc->z);
	      else sc->z = cons_unchecked(sc, car(x), sc->z);
	    }
	}
    }

  if (len == 0)   /* (map 1 "hi" '()) */
    {
      if (((typeflag(sc->code) & (T_ANY_MACRO | T_PROCEDURE)) != 0) ||
	  (is_pair(sc->code)) ||
	  (s7_is_string(sc->code)) ||
	  (s7_is_vector(sc->code)) ||
	  (s7_is_hash_table(sc->code)) ||
	  (is_hook(sc->code)) ||
	  (is_syntax(sc->code)))
	return(sc->NIL);    /* obj has no elements (the circular list case will return S7_LONG_MAX here) */
      return(s7_wrong_type_arg_error(sc, "map", 1, sc->code, "a procedure or something applicable"));
    }

  if (len == S7_LONG_MAX)
    {
      /* all args are circular lists, or perhaps an odd scheme type (see comment under for-each) */
      for (x = cdr(args); (is_pair(x)) && (is_pair(car(x))); x = cdr(x)) {}
      if (!is_pair(x))
	return(s7_error(sc, sc->WRONG_TYPE_ARG, 
			list_2(sc, make_protected_string(sc, "map's arguments are circular lists! ~A"), cdr(args))));
    }

  x = make_mutable_integer(sc, 0);
  denominator(number(x)) = len;
  sc->args = cons_unchecked(sc, x,
	       cons_unchecked(sc, sc->NIL, 
                 safe_reverse_in_place(sc, sc->z)));

  sc->y = sc->NIL;
  sc->z = sc->NIL;
  if (next_map(sc))
    push_stack(sc, OP_APPLY, sc->args, sc->code);

  return(sc->NIL);
}



/* -------------------------------- multiple-values -------------------------------- */

static s7_pointer splice_in_values(s7_scheme *sc, s7_pointer args)
{
  if (sc->stack_end > sc->stack_start)
    {
      /* code = args yet to eval in order, args = evalled args reversed */
      int top;
      s7_pointer x;
      top = s7_stack_top(sc) - 1;

      switch (stack_op(sc->stack, top))
	{
	  /* the normal case -- splice values into caller's args */
	case OP_EVAL_ARGS1:
	case OP_EVAL_ARGS2:
	case OP_EVAL_ARGS3:
	case OP_EVAL_ARGS4:
#if WITH_OPTIMIZATION
	case OP_EVAL_ARGS_P_1:
	case OP_EVAL_ARGS_P_2:
	case OP_EVAL_ARGS_P_3:
	case OP_EVAL_ARGS_P_4:
#endif
	  /* it's not safe to simply reverse args and tack the current stacked args onto its (new) end,
	   *   setting stacked args to cdr of reversed-args and returning car because the list (args)
	   *   can be some variable's value in a macro expansion via ,@ and reversing it in place
	   *   (all this to avoid consing), clobbers the variable's value.
	   */
	  for (x = args; is_not_null(cdr(x)); x = cdr(x))
	    stack_args(sc->stack, top) = cons(sc, car(x), stack_args(sc->stack, top));
	  return(car(x));

	case OP_EVAL_ARGS5:
	  /* code = previous arg saved, args = ante-previous args reversed
	   *   we'll take value->code->args and reverse in args5
	   *   if one value, return it, else
	   *      put code onto args, splice as above until there are 2 left
	   *      set code to 1st and value to last
	   */
	  if (is_null(args))
	    return(sc->UNSPECIFIED);

	  if (is_null(cdr(args)))
	    return(car(args));

	  stack_args(sc->stack, top) = cons(sc, stack_code(sc->stack, top), stack_args(sc->stack, top));
	  for (x = args; is_not_null(cddr(x)); x = cdr(x))
	    stack_args(sc->stack, top) = cons(sc, car(x), stack_args(sc->stack, top));
	  stack_code(sc->stack, top) = car(x);
	  return(cadr(x));

	  /* look for errors here rather than glomming up the set! and let code */
	case OP_SET1:                                             /* (set! var (values 1 2 3)) */
	  set_multiple_value(args);
	  return(eval_error(sc, "can't set! some variable to ~A", args));

	case OP_LET1:                                             /* (let ((var (values 1 2 3))) ...) */
	case OP_LET_STAR1:
	case OP_LETREC1:
	  set_multiple_value(args);
	  return(eval_error_with_name(sc, "~A: can't bind some variable to ~A", args));

	  /* handle 'and' and 'or' specially */
	case OP_AND1:
	  for (x = args; is_not_null(cdr(x)); x = cdr(x))
	    if (car(x) == sc->F)
	      return(sc->F);
	  return(car(x));

	case OP_OR1:
	  for (x = args; is_not_null(cdr(x)); x = cdr(x))
	    if (car(x) != sc->F)
	      return(car(x));
	  return(car(x));

	case OP_BARRIER: 
	  pop_stack(sc);
	  return(splice_in_values(sc, args));

	default:
	  break;
	}
    }

  /* let it meander back up the call chain until someone knows where to splice it */
  set_multiple_value(args);
  return(args);
}


static s7_pointer g_values(s7_scheme *sc, s7_pointer args)
{
  #define H_values "(values obj ...) splices its arguments into whatever list holds it (its 'continuation')"

  if (is_null(args))
    {
      if (stack_op(sc->stack, s7_stack_top(sc) - 1) == OP_SET1)  /* (set! var (values)) */
	return(eval_error(sc, "set!: can't assign (values) to something", args));
      return(sc->NO_VALUE); 
    }

  /* this was sc->NIL until 16-Jun-10, 
   *   nil is consistent with the implied values call in call/cc (if no args, the continuation function returns '())
   *   hmmm... 
   *   Guile complains ("too few values returned to continuation") in the call/cc case, and
   *   (equal? (if #f #f) (* (values))) complains "Zero values returned to single-valued continuation"
   *   so perhaps call/cc should also return #<unspecified> -- I don't know what is best.
   */
  
  if (is_null(cdr(args)))
    return(car(args));

  return(splice_in_values(sc, args));
}


s7_pointer s7_values(s7_scheme *sc, int num_values, ...)
{
  int i;
  va_list ap;
  s7_pointer p;
  
  if (num_values == 0)
    return(sc->NIL);

  sc->w = sc->NIL;
  va_start(ap, num_values);
  for (i = 0; i < num_values; i++)
    sc->w = cons(sc, va_arg(ap, s7_pointer), sc->w);
  va_end(ap);

  p = sc->w;
  sc->w = sc->NIL;

  return(g_values(sc, safe_reverse_in_place(sc, p)));
}



/* -------------------------------- quasiquote -------------------------------- */

static s7_pointer g_qq_list(s7_scheme *sc, s7_pointer args)
{
  #define H_qq_list "({list} ...) returns its arguments in a list (internal to quasiquote)"

  s7_pointer x, y, px;

  for (x = args; is_pair(x); x = cdr(x))
    if (car(x) == sc->NO_VALUE) 
      break;
  
  if (is_null(x))
    return(args);

  /* this is not maximally efficient, but it's not important:
   *   we've hit the rare special case where ({apply} {values} '())) needs to be ignored
   *   in the splicing process (i.e. the arglist acts as if the thing never happened)
   */
  px = sc->NIL;
  for (x = args, y = args; is_pair(y); y = cdr(y))
    if (car(y) != sc->NO_VALUE)
      {
	car(x) = car(y);
	px = x;
	x = cdr(x);
      }

  if ((is_not_null(y)) &&
      (y != sc->NO_VALUE))
    cdr(x) = cdr(y);
  else 
    {
      sc->no_values--;
      if (is_null(px))
	return(sc->NIL);
      cdr(px) = sc->NIL;
    }

  return(args);
}


static s7_pointer g_qq_values(s7_scheme *sc, s7_pointer args)
{
  #define H_qq_values "(apply {values} arg) is the quasiquote internal form for \",@arg\""

  /* for quasiquote handling: (apply values car(args)) if args not nil, else nil
   *    (values) -> #<unspecified> which is not wanted in this context.
   */
  if (is_null(args))
    {
      sc->no_values++;
      return(sc->NO_VALUE);
    }
  return(g_values(sc, args));
}


/* new version uses apply values for unquote_splicing
 *
 * (define-macro (hi a) `(+ 1 ,a) == (list '+ 1 a)
 * (define-macro (hi a) ``(+ 1 ,,a) == (list list '+ 1 (list quote a)))
 *
 * (define-macro (hi a) `(+ 1 ,@a) == (list '+ 1 (apply values a))
 * (define-macro (hi a) ``(+ 1 ,,@a) == (list list '+ 1 (apply values a))
 *
 * this is not the same as CL's quasiquote; for example:
 *   [1]> (let ((a 1) (b 2)) `(,a ,@b))
 *   (1 . 2)
 *   in s7 this is an error.  
 */

static bool is_simple_code(s7_scheme *sc, s7_pointer form)
{
  s7_pointer tmp;
  for (tmp = form; is_pair(tmp); tmp = cdr(tmp))
    if (is_pair(car(tmp)))
      {
	if (!is_simple_code(sc, car(tmp)))
	  return(false);
      }
    else
      {
	if ((car(tmp) == sc->UNQUOTE) ||
#if WITH_UNQUOTE_SPLICING
	    (car(tmp) == sc->UNQUOTE_SPLICING) ||
#endif
	    ((is_null(car(tmp))) && (is_null(cdr(tmp)))))
	  return(false);
      }
  return(is_null(tmp));
}


static s7_pointer g_quasiquote_1(s7_scheme *sc, s7_pointer form)
{
  if (!is_pair(form))
    {
      if (!s7_is_symbol(form))
	{
	  /* things that evaluate to themselves don't need to be quoted. 
	   *    but this means `() -> () whereas below `(1) -> '(1) -- should nil here return '()?
	   *    (this also affects vector constants since they call g_quasiquote at run time in OP_READ_QUASIQUOTE_VECTOR)
	   */
	  return(form);
	}
      return(list_2(sc, sc->QUOTE, form));
    }

  if (car(form) == sc->UNQUOTE)
    {
      if (is_not_null(cddr(form)))
	return(eval_error(sc, "unquote: too many arguments, ~S", form));
      return(cadr(form));
    }

#if WITH_UNQUOTE_SPLICING
  if (car(form) == sc->UNQUOTE_SPLICING)
    return(list_3(sc, sc->QQ_APPLY, sc->QQ_VALUES, cadr(form)));
#endif

  /* it's a list, so return the list with each element handled as above.
   *    we try to support dotted lists which makes the code much messier.
   */
  
  /* if no element of the list is a list or unquote, just return the original quoted */
  if (is_simple_code(sc, form))
    return(list_2(sc, sc->QUOTE, form));

  {
    int len, i, loc;
    s7_pointer orig, bq, old_scw;
    bool dotted = false;

    len = s7_list_length(sc, form);
    if (len < 0)
      {
	len = -len;
	dotted = true;
      }

    old_scw = sc->w;
    loc = s7_gc_protect(sc, old_scw);

    sc->w = sc->NIL;
    for (i = 0; i <= len; i++)
      sc->w = cons(sc, sc->NIL, sc->w);

    car(sc->w) = sc->QQ_LIST;
    
    if (!dotted)
      {
	/* fprintf(stderr, "%s\n", s7_object_to_c_string(sc, form)); */
	for (orig = form, bq = cdr(sc->w), i = 0; i < len; i++, orig = cdr(orig), bq = cdr(bq))
	  {
#if WITH_UNQUOTE_SPLICING
	    if ((is_pair(orig)) && 
		((cadr(orig) == sc->UNQUOTE) ||
		 (cadr(orig) == sc->UNQUOTE_SPLICING)))
	      {
		/* `(1 . ,2) -> '(1 unquote 2) -> '(1 . 2) 
		 */
		car(bq) = g_quasiquote_1(sc, car(orig));
		cdr(bq) = sc->NIL;
		if (cadr(orig) == sc->UNQUOTE)
		  sc->w = list_3(sc, sc->QQ_APPEND, sc->w, caddr(orig));
		else
		  { 
		    /* CL doesn't accept this case at all, but we accept `(1 . ,@('(2 3))) -> '(1 2 3)
		     */
		    if ((!is_pair(caddr(orig))) ||
			(is_not_null(cdddr(orig))) ||
			(!is_pair(caaddr(orig))))
		      {
			s7_gc_unprotect_at(sc, loc);
			return(read_error(sc, "stray dot?"));
		      }
		    sc->w = list_3(sc, sc->QQ_APPEND, sc->w, caaddr(orig));
		  }
		break;
	      }
	    else car(bq) = g_quasiquote_1(sc, car(orig));
#else
	    if ((is_pair(cdr(orig))) &&   /* this was is_pair(orig) which seems to be always the case */
		(cadr(orig) == sc->UNQUOTE))
	      {
		/* `(1 . ,(+ 1 1)) -> '(1 unquote (+ 1 1)) -> '(1 . 2) 
		 * `(1 . ,@'((2 3))) -> (1 unquote ({apply} {values} '((2 3)))) -> ({append} ({list} 1) ({apply} {values} '((2 3)))) -> '(1 2 3)
		 * this used to be `(1 . ,@('(2 3))).  
		 *     This now becomes (1 unquote ({apply} {values} ('(2 3)))) -> ({append} ({list} 1) ({apply} {values} ('(2 3)))) -> error
		 * `(1 . (,@'(2 3))) works in both cases, and `(1 . (,(+ 1 1)))
		 * so do we actually need this block? `(1 ,@'(2 3)) if undotted
		 */
		car(bq) = g_quasiquote_1(sc, car(orig));
		cdr(bq) = sc->NIL;
		sc->w = list_3(sc, sc->QQ_APPEND, sc->w, caddr(orig));
		break;
	      }
	    else car(bq) = g_quasiquote_1(sc, car(orig));
#endif
	  }
	/* fprintf(stderr, "%s\n", s7_object_to_c_string(sc, sc->w)); */
      }
    else
      {
	/* `(1 2 . 3) */
	len --;
	for (orig = form, bq = cdr(sc->w), i = 0; i < len; i++, orig = cdr(orig), bq = cdr(bq))
	  car(bq) = g_quasiquote_1(sc, car(orig));
	car(bq) = g_quasiquote_1(sc, car(orig));

	sc->w = list_3(sc, sc->QQ_APPEND, sc->w, g_quasiquote_1(sc, cdr(orig)));
	/* quasiquote might quote a symbol in cdr(orig), so it's not completely pointless */
      }

    bq = sc->w;
    sc->w = old_scw;
    s7_gc_unprotect_at(sc, loc);
    /* fprintf(stderr, "%s\n", DISPLAY(bq)); */
    return(bq);
  }
}


static s7_pointer g_quasiquote(s7_scheme *sc, s7_pointer args)
{
  /* this is for explicit quasiquote support, not the backquote stuff in macros */
  return(g_quasiquote_1(sc, car(args)));
}



/* ---------------- reader funcs for eval ---------------- */

static void back_up_stack(s7_scheme *sc)
{
  opcode_t top_op;
  top_op = stack_op(sc->stack, s7_stack_top(sc) - 1);
  if (top_op == OP_READ_DOT)
    {
      pop_stack(sc);
      top_op = stack_op(sc->stack, s7_stack_top(sc) - 1);
    }
  if (top_op == OP_READ_VECTOR)
    {
      pop_stack(sc);
      top_op = stack_op(sc->stack, s7_stack_top(sc) - 1);
    }
  if (top_op == OP_READ_QUOTE)
    pop_stack(sc);
}


static token_t token(s7_scheme *sc);

static token_t read_sharp(s7_scheme *sc, s7_pointer pt)
{
  int c;
  /* inchar can return EOF, so it can't be used directly as an index into the digits array */
  c = inchar(pt);
  if (c == EOF)
    s7_error(sc, sc->READ_ERROR,
	     list_1(sc, make_protected_string(sc, "unexpected '#' at end of input")));

  sc->w = small_int(1);
  if (c == '(') 
    return(TOKEN_VECTOR);

  if (isdigit(c)) /* #2D(...) */
    {
      int dims, dig, d, loc = 0;
      sc->strbuf[loc++] = c;
      dims = digits[c];

      while (true)
	{
	  d = inchar(pt);
	  if (d == EOF)
	    s7_error(sc, sc->READ_ERROR,
		     list_1(sc, make_protected_string(sc, "unexpected end of input while reading #n...")));

	  dig = digits[d];
	  if (dig >= 10) break;
	  dims = dig + (dims * 10);
	  sc->strbuf[loc++] = d;
	}
      sc->strbuf[loc++] = d;
      if ((d == 'D') || (d == 'd'))
	{
	  d = inchar(pt);
	  if (d == EOF)
	    s7_error(sc, sc->READ_ERROR,
		     list_1(sc, make_protected_string(sc, "unexpected end of input while reading #nD...")));
	  sc->strbuf[loc++] = d;
	  if (d == '(')
	    {
	      sc->w = s7_make_integer(sc, dims);
	      return(TOKEN_VECTOR);
	    }
	}

      /* try to back out */
      for (d = loc - 1; d > 0; d--)
	backchar(sc->strbuf[d], pt);
    }

#if (!S7_DISABLE_DEPRECATED)
  if (c == ':')  /* turn #: into : -- this is for compatiblity with Guile, #:optional in particular */
    {
      sc->strbuf[0] = ':';
      return(TOKEN_ATOM);
    }

  /* TODO: is it correct that these can't be commented out via semicolon?
   */
  /* block comments in either #! ... !# */
  if (c == '!') 
    {
      char last_char;
      last_char = ' ';
      while ((c = inchar(pt)) != EOF)
	{
	  if ((c == '#') &&
	      (last_char == '!'))
	    break;
	  last_char = c;
	}
      if (c == EOF)
	s7_error(sc, sc->READ_ERROR,
		 list_1(sc, make_protected_string(sc, "unexpected end of input while reading #!")));
      return(token(sc));
    }
#endif
      
  /*   or #| ... |# */
  if (c == '|') 
    {
      char last_char;
      last_char = ' ';
      while ((c = inchar(pt)) != EOF)
	{
	  if ((c == '#') &&
	      (last_char == '|'))
	    break;
	  last_char = c;
	}
      if (c == EOF)
	s7_error(sc, sc->READ_ERROR,
		 list_1(sc, make_protected_string(sc, "unexpected end of input while reading #|")));
      return(token(sc));
    }
      
  sc->strbuf[0] = c; 
  return(TOKEN_SHARP_CONST); /* next stage notices any errors */
}    


static token_t read_semicolon(s7_scheme *sc, s7_pointer pt)
{
  int c;
  if (sc->input_is_file)
    {
      do (c = fgetc(port_file(pt))); while ((c != '\n') && (c != EOF));
      port_line_number(pt)++;
      if (c == EOF)
	return(TOKEN_EOF);
    }
  else 
    {
      char *orig_str, *str;      
      str = (char *)(port_string(pt) + port_string_point(pt));
      orig_str = str;
      do {c = *str++;} while ((c != '\n') && (c != 0));
      port_string_point(pt) += (str - orig_str);
      port_line_number(pt)++;
      if (c == 0)
	return(TOKEN_EOF);
    }
  return(token(sc));
}


static token_t read_comma(s7_scheme *sc, s7_pointer pt)
{
  int c;
  /* here we probably should check for symbol names that start with "@":
     
     :(defmacro hi (@foo) `(+ ,@foo 1))
     hi
     :(hi 2)
     ;foo: unbound variable
	 
     but

     :(defmacro hi (.foo) `(+ ,.foo 1))
     hi
     :(hi 2)
     3

     and ambiguous:
     :(define-macro (hi @foo . foo) `(list ,@foo))

     what about , @foo -- is the space significant?  We accept ,@ foo.
  */

  if ((c = inchar(pt)) == '@') 
    return(TOKEN_AT_MARK);

  if (c == EOF)
    {
      sc->strbuf[0] = ',';  /* was '@' which doesn't make any sense */
      return(TOKEN_COMMA);  /* was TOKEN_ATOM, which also doesn't seem sensible */
    }
  backchar(c, pt);
  return(TOKEN_COMMA);
}


static token_t read_dot(s7_scheme *sc, s7_pointer pt)
{
  int c;
  c = inchar(pt);
  if (c != EOF)
    {
      backchar(c, pt);

      if ((!char_ok_in_a_name[c]) && (c != 0))
	return(TOKEN_DOT);
    }
  else
    {
      sc->strbuf[0] = '.'; 
      return(TOKEN_DOT);
    }
  sc->strbuf[0] = '.'; 
  return(TOKEN_ATOM);  /* i.e. something that can start with a dot like a number */
}


static token_t token(s7_scheme *sc)
{
  int c;
  s7_pointer pt;

  pt = sc->input_port;
  if (sc->input_is_file)
    {
      while (is_white_space(c = fgetc(port_file(pt))))
	if (c == '\n')
	  port_line_number(pt)++;
      if (c == EOF) 
	return(TOKEN_EOF);
    }
  else 
    {
      char *orig_str, *str;
      unsigned char c1;

      str = (char *)(port_string(pt) + port_string_point(pt));
      if (!(*str)) return(TOKEN_EOF);

      /* we can't depend on the extra 0 of padding at the end of an input string port --
       *   eval_string and others take the given string without copying or padding.
       */
      orig_str = str;
      while (white_space[c1 = (unsigned char)(*str++)]) /* (let ((a 1)) a) -- 255 is not -1 = EOF */
	if (c1 == '\n')
	  port_line_number(pt)++;
      if (c1 == 0)
	{
	  port_string_point(pt) += (str - orig_str - 1);
	  return(TOKEN_EOF);
	}
      port_string_point(pt) += (str - orig_str);
      c = c1;
    }

  switch (c) 
    {
    case '(':
      return(TOKEN_LEFT_PAREN);
      
    case ')':
      return(TOKEN_RIGHT_PAREN);
      
    case '.':
      return(read_dot(sc, pt));

    case '\'':
      return(TOKEN_QUOTE);
      
    case ';':
      return(read_semicolon(sc, pt));

    case '"':
      return(TOKEN_DOUBLE_QUOTE);
      
    case '`':
      return(TOKEN_BACK_QUOTE);
      
    case ',':
      return(read_comma(sc, pt));
      
    case '#':
      return(read_sharp(sc, pt));

    default: 
      sc->strbuf[0] = c; /* every TOKEN_ATOM return goes to read_delimited_string, so we save a backchar/inchar shuffle by starting the read here */
      return(TOKEN_ATOM);
    }
}


static void resize_strbuf(s7_scheme *sc)
{
  unsigned int i, old_size;
  old_size = sc->strbuf_size;
  sc->strbuf_size *= 2;
  sc->strbuf = (char *)realloc(sc->strbuf, sc->strbuf_size * sizeof(char));
  for (i = old_size; i < sc->strbuf_size; i++) sc->strbuf[i] = '\0';
}


#define WITH_SHARP false
#define NO_SHARP true

static s7_pointer read_delimited_string(s7_scheme *sc, bool atom_case)
{
  s7_pointer pt;

  pt = sc->input_port;
  /* sc->strbuf[0] has the 1st char of the string we're reading */

  if (sc->input_is_file)
    {
      int c;
      unsigned i = 1;
      do
	{
	  c = fgetc(port_file(pt)); /* might return EOF */
	  if (c == '\n')
	    port_line_number(pt)++;

	  sc->strbuf[i++] = c;
	  if (i >= sc->strbuf_size)
	    resize_strbuf(sc);
	}
      while ((c != EOF) && (char_ok_in_a_name[c]));

      if ((i == 2) && 
	  (sc->strbuf[0] == '\\'))
	sc->strbuf[2] = '\0';
      else 
	{
	  if (c != EOF)
	    {
	      if (c == '\n')
		port_line_number(pt)--;
	      ungetc(c, port_file(pt));
	    }
	  sc->strbuf[i - 1] = '\0';
	}
    }
  else
    {
      unsigned int k = 0;
      char *orig_str, *str;

      orig_str = (char *)(port_string(pt) + port_string_point(pt) - 1);
      str = (char *)(orig_str + 1);

      while (char_ok_in_a_name[(unsigned char)(*str)]) {str++;}
      k = str - orig_str;
      port_string_point(pt) += k;
      
      if ((!atom_case) &&             /* there's a bizarre special case here \ with the next char #\null: (eval-string "(list \\\x00 1)") */
	  (k == 1) && 
	  (*orig_str == '\\'))         
	{
	  /* must be from #\( and friends -- a character that happens to be not ok-in-a-name */
	  sc->strbuf[1] = orig_str[1];
	  sc->strbuf[2] = '\0';
	  return(make_sharp_constant(sc, sc->strbuf, UNNESTED_SHARP, BASE_10));
	}
      else 
	{
	  if (port_needs_free(pt)) 
	    {
	      /* port_string was allocated (and read from a file) so we can mess with it directly */
	      s7_pointer result;
	      char endc;
	      
	      endc = orig_str[k];
	      orig_str[k] = '\0';

	      if (atom_case)
		{
		  switch (*orig_str)
		    {
		    case '0': case '1': case '2': case '3': case '4':
		    case '5': case '6': case '7': case '8': case '9':
		    case '.': case '+': case '-':
		      result = make_atom(sc, orig_str, BASE_10, SYMBOL_OK);
		      break;
		      
		    case '#':
		      result = make_sharp_constant(sc, (char *)(orig_str + 1), UNNESTED_SHARP, BASE_10);
		      break;
		      
		    default:
		      /* result = make_symbol(sc, orig_str); 
		       *    expanded for speed
		       */
		      {
			int location;
			s7_pointer x; 
			unsigned int loc = 0;
			const char *c; 

			/* expanding these two calls saves a lot of time */
			/* location = symbol_table_hash(orig_str, &loc); */
			/* result = symbol_table_find_by_name(sc, orig_str, location); */

			for (c = orig_str; *c; c++) 
			  loc = *c + loc * HASH_MULT;
			location = loc % SYMBOL_TABLE_SIZE; 

			result = sc->NIL;
			for (x = vector_element(sc->symbol_table, location); is_not_null(x); x = cdr(x)) 
			  { 
			    const char *s; 
			    s = symbol_name(car(x)); 
			    if (/* (s) &&  */ /* I don't think a symbol can have a null name */
				(s[0] == orig_str[0]) &&
				(strings_are_equal(orig_str, s)))
			      {
				result = car(x);
				break;
			      }
			  }

			if (is_null(result))
			  {
			    if (sc->symbol_table_is_locked)
			      result = sc->F;
			    else 
			      {
				result = new_symbol(sc, orig_str, location); 
				symbol_hash(result) = loc;
			      }
			  }
		      }
		      break;
		    }
		}
	      else result = make_sharp_constant(sc, orig_str, UNNESTED_SHARP, BASE_10);
	      
	      orig_str[k] = endc;
	      if (*str != 0) port_string_point(pt)--;
	      /* skipping the null has one minor consequence:
	       *    (let ((str "(+ 1 2 3)")) (set! (str 2) #\null) (eval-string str)) ; "(+\x001 2 3)" -> 6
	       *    (let ((str "(+ 1 2 3)")) (set! (str 3) #\null) (eval-string str)) ; "(+ \x00 2 3)" -> missing paren error
	       */
	      return(result);
	    }
	  
	  /* eval_c_string string is a constant so we can't set and unset the token's end char */
	  if ((k + 1) >= sc->strbuf_size)
	    resize_strbuf(sc);
	  
	  memcpy((void *)(sc->strbuf), (void *)orig_str, k);
	  if (*str != 0) port_string_point(pt)--;
	  sc->strbuf[k] = '\0';
	}
    }

  if (atom_case)
    return(make_atom(sc, sc->strbuf, BASE_10, SYMBOL_OK));

  return(make_sharp_constant(sc, sc->strbuf, UNNESTED_SHARP, BASE_10));
}


#define NOT_AN_X_CHAR -1

static int read_x_char(s7_pointer pt)
{
  /* possible "\xnn" char (write creates these things, so we have to read them) 
   *   but we could have crazy input like "\x -- with no trailing double quote
   */
  int d1, d2, c;

  c = inchar(pt);
  if (c == EOF)
    return(NOT_AN_X_CHAR);

  d1 = digits[c];
  if (d1 < 16)
    {
      c = inchar(pt);
      if (c == EOF)
	return(NOT_AN_X_CHAR);
      d2 = digits[c];
      if (d2 < 16)
	return(16 * d1 + d2);           /* following char can be anything, including a number -- we ignore it */
      /* apparently one digit is also ok */
      backchar(c, pt);
      return(d1);
    }
  return(NOT_AN_X_CHAR);
}


static s7_pointer read_string_constant(s7_scheme *sc, s7_pointer pt)
{
  /* sc->F => error 
   *   no check needed here for bad input port and so on
   */
  unsigned int i = 0;
  int c;

  if (!(sc->input_is_file))
    {
      /* try the most common case first */
      char *s, *start, *end;
      start = (char *)(port_string(pt) + port_string_point(pt));
      end = (char *)(port_string(pt) + port_string_length(pt));
      for (s = start; s < end; s++)
	{
	  if (*s == '"')                         /* switch here no faster */
	    {
	      s7_pointer result;
	      int len;
	      len = s - start;
	      result = s7_make_terminated_string_with_length(sc, start, len);
	      port_string_point(pt) += (len + 1);
	      return(result);
	    }
	  else
	    {
	      if (*s == '\\')
		{
		  if ((unsigned int)(s - start) >= sc->strbuf_size)
		    resize_strbuf(sc);
		  for (i = 0; i < (unsigned int)(s - start); i++)
		    sc->strbuf[i] = port_string(pt)[port_string_point(pt)++];
		  break;
		}
	      else
		{
		  if (*s == '\n')
		    port_line_number(pt)++; 
		}
	    }
	}
    }

  while (true)
    {
      /* splitting this check out and duplicating the loop was slower?!? */
      if (sc->input_is_file)
	c = fgetc(port_file(pt)); /* not unsigned char! -- could be EOF */
      else 
	{
	  if (port_string_length(pt) <= port_string_point(pt))
	    return(sc->F);
	  c = (unsigned char)port_string(pt)[port_string_point(pt)++];
	}

      switch (c)
	{
	case '\n': 
	  port_line_number(pt)++; 
	  sc->strbuf[i++] = c;
	  break;

	case EOF:
	  return(sc->F);

	case '"':
	  return(s7_make_terminated_string_with_length(sc, sc->strbuf, i));

	case '\\':
	  c = inchar(pt);

	  if (c == EOF) 
	    return(sc->F);

	  if (c == '\\')
	    sc->strbuf[i++] = '\\';
	  else
	    {
	      if (c == '"')
		sc->strbuf[i++] = '"';
	      else
		{
		  if (c == 'n')
		    sc->strbuf[i++] = '\n';
		  else 
		    {
		      if (c == 't') /* this is for compatibility with other Schemes */
			sc->strbuf[i++] = '\t';
		      else 
			{
			  if (c == 'x')
			    {
			      c = read_x_char(pt);
			      if (c == NOT_AN_X_CHAR)
				return(sc->T);
			      sc->strbuf[i++] = (unsigned char)c;
			    }
			  else
			    {
			      if (!is_white_space(c))
				return(sc->T); 

			      /* #f here would give confusing error message "end of input", so return #t=bad backslash.
			       *     this is not optimal. It's easy to forget that backslash needs to be backslashed. 
			       *
			       * the white_space business implements Scheme's \<newline> or \<space> feature -- the character after \ is flushed.
			       *   It may be that r6rs expects all white space after \ to be flushed, but in that case
			       *   (string->number "1\   2") is 12??  Too bizarre.
			       */
			    }
			}
		    }
		}
	    }
	  break;

	default:
	  sc->strbuf[i++] = c;
	  break;
	}

      if (i >= sc->strbuf_size)
	resize_strbuf(sc);
    }
}


/* static const char *tokens[12] = {"eof", "left_paren", "right_paren", "dot", "atom", "quote", 
                                    "double_quote", "back_quote", "comma", "at_mark", "sharp_const", "vector"}; 
*/

static s7_pointer read_expression(s7_scheme *sc)
{ 
  while (true) 
    {
      int c;
      switch (sc->tok) 
	{
	case TOKEN_EOF:
	  return(sc->EOF_OBJECT);
	  
	case TOKEN_VECTOR:  /* already read #( -- TOKEN_VECTOR is triggered by #( */
	    push_stack(sc, OP_READ_VECTOR, sc->w, sc->NIL);   /* sc->w is the dimensions */
	    /* fall through */
	  
	case TOKEN_LEFT_PAREN:
	  sc->tok = token(sc);

	  if (sc->tok == TOKEN_RIGHT_PAREN)
	    return(sc->NIL);

	  if (sc->tok == TOKEN_DOT) 
	    {
	      back_up_stack(sc);
	      do {c = inchar(sc->input_port);} while ((c != ')') && (c != EOF));
	      return(read_error(sc, "stray dot after '('?"));         /* (car '( . )) */
	    }

	  if (sc->tok == TOKEN_EOF)
	    return(missing_close_paren_error(sc));

	  push_stack(sc, OP_READ_LIST, sc->NIL, sc->NIL);
	  /* all these push_stacks that don't care about code/args look wasteful, but if a read error
	   *   occurs, we need clean info in the error handler, so it's tricky to optimize this.
	   *   (and if we do optimize it, it saves maybe %1 of the total stack time).
	   */

	  if (sc->stack_end >= sc->stack_resize_trigger)
	    increase_stack_size(sc);
	  break;
	  
	case TOKEN_QUOTE:
	  push_stack(sc, OP_READ_QUOTE, sc->NIL, sc->NIL);
	  sc->tok = token(sc);
	  break;
	  
	case TOKEN_BACK_QUOTE:
	  sc->tok = token(sc);
	  if (sc->tok == TOKEN_VECTOR) 
	    {
	      push_stack(sc, OP_READ_QUASIQUOTE_VECTOR, sc->w, sc->NIL);
	      sc->tok = TOKEN_LEFT_PAREN; 
	    } 
	  else push_stack(sc, OP_READ_QUASIQUOTE, sc->NIL, sc->NIL);
	  break;
	  
	case TOKEN_COMMA:
	  push_stack(sc, OP_READ_UNQUOTE, sc->NIL, sc->NIL);
	  sc->tok = token(sc);
	  break;
	  
	case TOKEN_AT_MARK:
	  push_stack(sc, OP_READ_APPLY_VALUES, sc->NIL, sc->NIL);
	  sc->tok = token(sc);
	  break;
	  
	case TOKEN_ATOM:
	  return(read_delimited_string(sc, NO_SHARP));
	  /* If reading list (from lparen), this will finally get us to op_read_list */
	  
	case TOKEN_DOUBLE_QUOTE:
	  sc->value = read_string_constant(sc, sc->input_port);

	  if (sc->value == sc->F)                                   /* can happen if input code ends in the middle of a string */
	    return(read_error(sc, "end of input encountered while in a string"));
	  if (sc->value == sc->T)
	    return(read_error(sc, "unknown backslash usage -- perhaps you meant two backslashes?"));

	  return(sc->value);
	  
	case TOKEN_SHARP_CONST:
	  sc->value = read_delimited_string(sc, WITH_SHARP);

	  /* here we need the following character and form 
	   *   strbuf[0] == '#', false above = # case, not an atom
	   */
	  if (is_null(sc->value))
	    {
	      return(read_error(sc, "undefined # expression"));
	      /* a read error here seems draconian -- this unknown constant doesn't otherwise get in our way
	       *   but how to alert the caller to the problem without stopping the read?
	       */
	    }
	  return(sc->value);

	case TOKEN_DOT:                                             /* (catch #t (lambda () (+ 1 . . )) (lambda args 'hiho)) */
	  back_up_stack(sc);
	  do {c = inchar(sc->input_port);} while ((c != ')') && (c != EOF));
	  return(read_error(sc, "stray dot in list?"));             /* (+ 1 . . ) */

	case TOKEN_RIGHT_PAREN:                                     /* (catch #t (lambda () '(1 2 . )) (lambda args 'hiho)) */
	  back_up_stack(sc);
	  return(read_error(sc, "unexpected close paren"));         /* (+ 1 2)) or (+ 1 . ) */
	}
    }

  /* we never get here */
  return(sc->NIL);
}



/* ---------------- */

static s7_pointer unbound_variable(s7_scheme *sc, s7_pointer sym)
{
  /* handle *unbound-variable-hook* */

  /* this always occurs in a context where we're trying anything, so I'll move a couple of those tests here */
  if (is_keyword(sym))
    return(sym);
  if (sym == sc->UNQUOTE)
    return(eval_error_no_arg(sc, "unquote (',') occurred outside quasiquote"));
#if WITH_UNQUOTE_SPLICING
  if (sym == sc->UNQUOTE_SPLICING)
    return(eval_error_no_arg(sc, "unquote-splicing (',@') occurred without quasiquote"));
#endif
  /* actually we'll normally get an error from apply. (,@ 1) triggers this error.
   */

  if (is_not_null(hook_functions(sc->unbound_variable_hook)))
    {
      int save_x = -1, save_y = -1, save_z = -1, cur_code_loc = -1;
      s7_pointer x, cur_code;

      cur_code = sc->cur_code;
      if (!is_pair(cur_code))
	{
	  /* isolated typo perhaps -- no pair to hold the position info, so make one.
	   *   sc->cur_code is GC-protected, so this should be safe.
	   */
	  cur_code = cons(sc, sym, sc->NIL);     /* the error will say "(sym)" which is not too misleading */
	  pair_line_number(cur_code) = port_line_number(sc->input_port) | (port_file_number(sc->input_port) << 20);
	}
      cur_code_loc = s7_gc_protect(sc, cur_code);   /* we need to save this because it has the file/line number of the unbound symbol */

      SAVE_X_Y_Z(save_x, save_y, save_z);

      /* not s7_hook_apply here because we need the value that the hook function returns
       *   should we call the entire list?  or just call trailing funcs if x is #<unspecified>?
       */

      x = s7_call(sc, 
		  car(hook_functions(sc->unbound_variable_hook)),
		  list_1(sc, sym));

      RESTORE_X_Y_Z(save_x, save_y, save_z);

      sc->cur_code = cur_code;
      s7_gc_unprotect_at(sc, cur_code_loc);

      if (x != sc->UNDEFINED)
	return(x);
    }
  
  return(eval_error(sc, "~A: unbound variable", sym));
}


static s7_pointer eval_symbol(s7_scheme *sc, s7_pointer sym)
{
  s7_pointer x;

  x = find_symbol(sc, sym);
  if (is_not_null(x)) 
    return(symbol_value(x));

  return(unbound_variable(sc, sym));
}


static s7_pointer assign_syntax(s7_scheme *sc, const char *name, opcode_t op) 
{
  s7_pointer x, syn;
  unsigned int loc = 0;

  x = new_symbol(sc, name, symbol_table_hash(name, &loc)); 
  symbol_hash(x) = loc;

  syn = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  set_type(syn, T_SYNTAX | T_SYNTACTIC | T_DONT_COPY | T_DONT_EVAL_ARGS); 
  syntax_opcode(syn) = op;
  set_symbol_value(syn, syn); /* this saves us an error check in the main eval section */

  set_symbol_value(x, syn);
  symbol_global_slot(x) = permanent_cons(x, syn, T_SYNTAX | T_SYNTACTIC | T_DONT_COPY | T_DONT_EVAL_ARGS);
  typeflag(x) |= (T_DONT_COPY | T_DONT_EVAL_ARGS | T_SYNTACTIC);
  symbol_id(x) = 0;
  car(syn) = x;

  syntax_opcode(x) = op;

  return(x);
}


static s7_pointer assign_internal_syntax(s7_scheme *sc, const char *name, opcode_t op) 
{
  s7_pointer x, str, syn; 
  unsigned int loc = 0;

  str = s7_make_permanent_string(name);

  /* x = permanent_cons(str, sc->NIL, T_SYMBOL | T_DONT_COPY); */
  x = (s7_cell *)permanent_calloc(sizeof(s7_extended_cell));
  x->hloc = NOT_IN_HEAP;
  car(x) = str;
  cdr(x) = sc->NIL;
  set_type(x, T_SYMBOL | T_DONT_COPY);

  symbol_global_slot(x) = sc->NIL;
  symbol_table_hash(name, &loc); 
  symbol_hash(x) = loc;
  symbol_id(x) = 0;
  symbol_accessor(x) = -1;

  syn = (s7_cell *)permanent_calloc(sizeof(s7_cell));
  set_type(syn, T_SYNTAX | T_SYNTACTIC | T_DONT_COPY | T_DONT_EVAL_ARGS); 
  syntax_opcode(syn) = op;
  set_symbol_value(syn, syn); /* cdr(syn), this saves us an error check in the main eval section */

  set_symbol_value(x, syn);   /* cdr(x) */
  symbol_global_slot(x) = permanent_cons(x, syn, T_SYNTAX | T_SYNTACTIC | T_DONT_COPY | T_DONT_EVAL_ARGS);
  typeflag(x) |= (T_DONT_COPY | T_DONT_EVAL_ARGS | T_SYNTACTIC);
  symbol_id(x) = 0;
  car(syn) = s7_make_symbol(sc, name);

  syntax_opcode(x) = op;

  return(x);
}


static bool memq(s7_pointer symbol, s7_pointer list)
{
  s7_pointer x;
  for (x = list; is_pair(x); x = cdr(x))
    if (car(x) == symbol)
      return(true);
  return(false);
}


#if 0
static s7_pointer remq(s7_scheme *sc, s7_pointer a, s7_pointer obj) 
{
  s7_pointer p;

  sc->w = sc->NIL;
  for ( ; is_pair(a); a = cdr(a))
    if (car(a) != obj)
      sc->w = cons(sc, car(a), sc->w);
  p = sc->w;
  sc->w = sc->NIL;

  return(s7_reverse(sc, p));
}
#endif



static s7_pointer g_pair_line_number(s7_scheme *sc, s7_pointer args)
{
  #define H_pair_line_number "(pair-line-number pair) returns the line number at which it read 'pair'"

  if (!is_pair(car(args)))
    return(s7_wrong_type_arg_error(sc, "pair-line-number", 0, car(args), "a pair"));	
  return(s7_make_integer(sc, (s7_Int)(remembered_line_number(pair_line_number(car(args))))));
}


static s7_pointer quotify(s7_scheme *sc, s7_pointer pars)
{
  /* the default parameter values of define-macro* and define-bacro* should not be evaluated until
   * the expansion is evaluated.  That is, 
   *
   *   (let ((x 0)) (define-macro* (hi (a (let () (set! x (+ x 1)) x))) `(let ((x -1)) (+ x ,a))) (list (hi) x))
   *
   * should return the same value as the equivalent explicit form:
   *
   *   (let ((x 0)) (define-macro (hi a) `(let ((x -1)) (+ x ,a))) (list (hi (let () (set! x (+ x 1)) x)) x))
   *
   * '(-1 0) in both cases.
   *
   * But at the point in eval where we handle lambda* arguments, we can't easily tell whether we're part of
   * a function or a macro, so at definition time of a macro* we scan the parameter list for an expression
   * as a default value, and replace it with (quote expr).
   *
   * and... (define-macro* ((a x)) ...) should behave the same as (define-macro* ((a (+ x 0))) ...)
   */
  s7_pointer tmp;
  for (tmp = pars; is_pair(tmp); tmp = cdr(tmp))
    if ((is_pair(car(tmp))) &&
	(is_pair(cdar(tmp))) &&
	((is_pair(cadar(tmp))) ||
	 (s7_is_symbol(cadar(tmp))) ||
	 (is_syntax(cadar(tmp)))))
      cadar(tmp) = list_2(sc, sc->QUOTE, cadar(tmp));
  return(pars);
}


static s7_pointer lambda_star_argument_set_value(s7_scheme *sc, s7_pointer sym, s7_pointer val)
{
  s7_pointer x;

  for (x = car(sc->envir) /* presumably the arglist */; is_pair(x); x = ecdr(x))
    if (car(x) == sym)   /* car(x) won't be sc->NIL here even if no args and no locals because we at least have __func__ */
      {
	/* x is our binding (symbol . value) */
	if (is_not_checked(x))
	  set_checked(x); /* this is a special use of this bit, I think */
	else 
	  {
	    return(s7_error(sc, sc->WRONG_TYPE_ARG,
			    list_4(sc,
					make_protected_string(sc, "~A: parameter set twice, ~A in ~A"),
					closure_name(sc, sc->code), sc->y, sc->args)));
	  }
	cdr(x) = val;
	return(val);
      }
  return(sc->NO_VALUE);
}


static s7_pointer lambda_star_argument_default_value(s7_scheme *sc, s7_pointer val)
{
  /* if val is an expression, it needs to be evaluated in the definition environment
   *   (let ((c 1)) (define* (a (b (+ c 1))) b) (set! c 2) (a)) -> 3
   */

  s7_pointer x;
  if (s7_is_symbol(val))
    {
      x = find_symbol(sc, val);
      if (is_not_null(x)) 
	return(symbol_value(x));
    }
  
  if (is_pair(val))
    {
      if ((car(val) == sc->QUOTE) ||
	  (car(val) == sc->QUOTE_UNCHECKED))
	return(cadr(val));

      x = sc->z;

      if (s7_stack_top(sc) < 12)
	push_stack(sc, OP_BARRIER, sc->args, sc->code); 

      /* If this barrier is omitted, we get a segfault from 
       *    (call-with-exit (lambda (quit) ((lambda* ((a (quit 32))) a))))
       * when typed to the listener's prompt (it's ok in other situations).
       */

      push_stack(sc, OP_EVAL_DONE, sc->args, sc->code); 
      sc->args = sc->NIL;
      sc->code = val;
      eval(sc, OP_EVAL);

      /* ideally we'd drop into the evaluator here, not call it as a procedure.  This way
       *   of getting the value is only safe for a C-side call like s7_read; for s7-internal
       *   calls, error handling assumes we're using the s7 stack, not the C stack.  So,
       *   we better not get an error while evaluating the argument default value!
       */

      /* SOMEDAY: put this in the eval loop */

      sc->z = x;
      return(sc->value);
    }

  return(val);
}


static s7_pointer prepare_closure_star(s7_scheme *sc)
{
  /* sc->code is a closure: ((args body) envir)
   * (define* (hi a (b 1)) (+ a b))
   * (procedure-source hi) -> (lambda* (a (b 1)) (+ a b))
   *
   * so rather than spinning through the args binding names to values in the
   *   procedure's new environment (as in the usual closure case above),
   *   we scan the current args, and match against the
   *   template in the car of the closure, binding as we go.
   *
   * for each actual arg, if it's not a keyword that matches a member of the 
   *   template, bind it to its current (place-wise) arg, else bind it to
   *   that arg.  If it's the symbol :key or :optional, just go on.
   *   If it's :rest bind the next arg to the trailing args at this point.
   *   All args can be accessed by their name as a keyword.
   *   In other words (define* (hi (a 1)) ...) is the same as (define* (hi :key (a 1)) ...) etc.
   *
   * all args are optional, any arg with no default value defaults to #f.
   *   but the rest arg should default to '().
   *
   * I later decided to add two warnings: if a parameter is set twice and if
   *   an unknown keyword is seen in a keyword position and there is no rest arg.
   */

  bool allow_other_keys = false;
  s7_pointer z;
  
  /* set all default values */
  for (z = closure_args(sc->code); is_pair(z); z = cdr(z))
    {
      /* bind all the args to something (default value or #f or maybe #undefined) */
      if (!((car(z) == sc->KEY_KEY) ||
	    (car(z) == sc->KEY_OPTIONAL) ||
	    (car(z) == sc->KEY_ALLOW_OTHER_KEYS)))
	{
	  if (car(z) == sc->KEY_REST)
	    {
	      z = cdr(z);
	      add_slot(sc, car(z), sc->NIL); /* set :rest arg to sc->NIL, not sc->F */
	    }
	  else
	    {
	      if (is_pair(car(z)))                           /* (define* (hi (a mus-next)) a) */
		add_slot(sc, caar(z),                        /* or (define* (hi (a 'hi)) (list a (eq? a 'hi))) */
			 lambda_star_argument_default_value(sc, cadar(z)));
	      /* mus-next, for example, needs to be evaluated before binding */
	      else add_slot(sc, car(z), sc->F);
	    }
	}
    }
  if (s7_is_symbol(z))                                  /* dotted (last) arg? -- make sure its name exists in the current environment */
    add_slot(sc, z, sc->NIL); 
  
  /* now get the current args, re-setting args that have explicit values */
  sc->x = closure_args(sc->code);
  sc->y = sc->args; 
  sc->z = sc->NIL;
  while ((is_pair(sc->x)) &&
	 (is_pair(sc->y)))
    {
      /* fprintf(stderr, "x: %s, y: %s\n", DISPLAY(sc->x), DISPLAY(sc->y)); */

      if ((car(sc->x) == sc->KEY_KEY) ||
	  (car(sc->x) == sc->KEY_OPTIONAL))
	sc->x = cdr(sc->x);                         /* everything is :key and :optional, so these are ignored */
      else
	{
	  if (car(sc->x) == sc->KEY_ALLOW_OTHER_KEYS)
	    {
	      allow_other_keys = true;
	      sc->x = cdr(sc->x);
	    }
	  else
	    {
	      if (car(sc->x) == sc->KEY_REST)           /* the rest arg */
		{
		  /* next arg is bound to trailing args from this point as a list */
		  sc->z = sc->KEY_REST;
		  sc->x = cdr(sc->x);
		  
		  if (is_pair(car(sc->x)))
		    lambda_star_argument_set_value(sc, caar(sc->x), sc->y);
		  else lambda_star_argument_set_value(sc, car(sc->x), sc->y);
		  
		  sc->y = cdr(sc->y);
		  sc->x = cdr(sc->x);
		  if (car(sc->x) == sc->KEY_ALLOW_OTHER_KEYS)
		    break;
		}
	      else
		{
		  if (is_keyword(car(sc->y)))
		    {
		      char *name;                       /* found a keyword, need to remove the ':' before checking the lambda args */
		      s7_pointer sym;
		      
		      name = symbol_name(car(sc->y));
		      if (name[0] == ':')
			sym = make_symbol(sc, (const char *)(name + 1));
		      else
			{
			  /* must be a trailing ':' here, else not is_keyword */
			  name[symbol_name_length(car(sc->y)) - 1] = '\0';
			  sym = make_symbol(sc, name);
			  name[symbol_name_length(car(sc->y)) - 1] = ':';
			}
		      
		      if ((is_null(cdr(sc->y))) ||
			  (lambda_star_argument_set_value(sc, sym, car(cdr(sc->y))) == sc->NO_VALUE))
			{
			  /* if default value is a key, go ahead and use this value.
			   *    (define* (f (a :b)) a) (f :c) 
			   * this has become much trickier than I anticipated...
			   */
			  
			  if ((allow_other_keys) ||
			      (memq(sc->KEY_ALLOW_OTHER_KEYS, sc->x)))
			    {
			      allow_other_keys = true;
			      /* in CL: (defun hi (&key (a 1) &allow-other-keys) a) (hi :b :a :a 3) -> 3 
			       * in s7: (define* (hi (a 1) :allow-other-keys) a)    (hi :b :a :a 3) -> 3
			       */
			      sc->y = cddr(sc->y);
			      continue;
			    }
			  else
			    {
			      if ((is_pair(car(sc->x))) &&
				  (is_keyword(cadar(sc->x))))
				{
				  /* sc->x is the closure args list, not the copy of it in the current environment */
				  s7_pointer x;
				  
				  x = find_symbol(sc, caar(sc->x));
				  if (is_not_null(x))
				    {
				      if (is_not_checked(x))
					{
					  set_checked(x);
					  cdr(x) = car(sc->y);
					}
				      else 
					{
					  return(s7_error(sc, sc->WRONG_TYPE_ARG,
							  list_4(sc,
								      make_protected_string(sc, "~A: parameter set twice, ~A in ~A"),
								      closure_name(sc, sc->code), sc->y, sc->args)));
					}
				    }
				  else
				    {
				      return(s7_error(sc, sc->WRONG_TYPE_ARG,
						      list_4(sc,
								  make_protected_string(sc, "~A: unknown key: ~A in ~A"),
								  closure_name(sc, sc->code), sc->y, sc->args)));
				    }
				  /* (define* (f a (b :c)) b) (f :b 1 :d) */
				}
			      else
				{
				  return(s7_error(sc, sc->WRONG_TYPE_ARG,
						  list_4(sc,
							      make_protected_string(sc, "~A: unknown key: ~A in ~A"),
							      closure_name(sc, sc->code), sc->y, sc->args)));
				}
			    }
			}
		      sc->y = cdr(sc->y);
		      if (is_pair(sc->y)) sc->y = cdr(sc->y);
		    }
		  else                                  /* not a key/value pair */
		    {
		      if (is_pair(car(sc->x)))
			lambda_star_argument_set_value(sc, caar(sc->x), car(sc->y));
		      else lambda_star_argument_set_value(sc, car(sc->x), car(sc->y));
		      sc->y = cdr(sc->y);
		    }
		  sc->x = cdr(sc->x);
		}
	    }
	}
    }

  /* (let () (define* (hi (a 1) :allow-other-keys) a) (hi :a 2 32)) */
  /* (let () (define* (f (a :b)) a) (list (f) (f 1) (f :c) (f :a :c) (f :a 1) (f))) */
  /* fprintf(stderr, "at end x: %s, y: %s\n", DISPLAY(sc->x), DISPLAY(sc->y)); */

  /* check for trailing args with no :rest arg */
  if (is_not_null(sc->y))
    {
      if ((is_not_null(sc->x)) ||
	  (sc->z == sc->KEY_REST))
	{
	  if (s7_is_symbol(sc->x))
	    add_slot(sc, sc->x, sc->y); 
	}
      else
	{
	  if ((!allow_other_keys) ||
	      (!is_keyword(car(sc->y))))
	    {
	      return(s7_error(sc, sc->WRONG_NUMBER_OF_ARGS, 
			      list_3(sc, sc->TOO_MANY_ARGUMENTS, closure_name(sc, sc->code), sc->args)));
	    }
	} 
    }
  return(sc->NIL);
}



/* even with the frame_id optimization, this is still about 12% of our total computing: 210/1730 in lg
 */

#define FIND_SYMBOL_OR_BUST(Sc) \
  s7_pointer x;						 \
  if (frame_id(sc->envir) == symbol_id(hdl)) \
    return(symbol_value(symbol_local_slot(hdl)));	 \
  for (x = sc->envir; symbol_id(hdl) < frame_id(x); x = cdr(x)); \
  if (frame_id(x) == symbol_id(hdl))				 \
    return(symbol_value(symbol_local_slot(hdl)));		 \
  for (; is_environment(x); x = cdr(x))				 \
    { \
      s7_pointer y;					 \
      for (y = car(x); is_pair(y); y = ecdr(y))		 \
	if (car(y) == hdl)				 \
	  return(symbol_value(y));			 \
    } \
  x = symbol_global_slot(hdl);	 \
  if (is_not_null(x)) return(symbol_value(x));  \
  return(unbound_variable(sc, hdl));


#define SYMBOL_VALUE(Sym, Finder) ((is_global(Sym)) ? symbol_value(symbol_global_slot(Sym)) : Finder(sc, Sym)) 
#define ARG_SYMBOL_VALUE(Sym, Finder) Finder(sc, Sym)


static s7_pointer find_symbol_or_bust(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_1(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_2(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_3(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_4(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_5(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_6(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_7(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_8(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_9(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_34(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_37(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_38(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_39(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_40(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_41(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_42(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 


#if WITH_OPTIMIZATION

/* work in progress, to say the least... */

static s7_pointer find_symbol_or_bust_10(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_11(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_12(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_13(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_14(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_15(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_16(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_17(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_18(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_19(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_20(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_21(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_22(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_23(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_24(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_25(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_26(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_27(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_28(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_29(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_30(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_31(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_32(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_33(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_35(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_36(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 

static s7_pointer find_symbol_or_bust_43(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_44(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_45(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_46(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_47(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_48(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_49(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_50(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_51(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_52(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_53(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_54(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_55(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_56(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_57(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_58(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_59(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 

static s7_pointer find_symbol_or_bust_60(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_61(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_62(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_63(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_64(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_65(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_66(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 
static s7_pointer find_symbol_or_bust_67(s7_scheme *sc, s7_pointer hdl) {FIND_SYMBOL_OR_BUST(sc);} 

static s7_pointer abs_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
#if (!WITH_GMP)
  /*
  fprintf(stderr, "expr: %s\n", DISPLAY_80(cadr(expr)));
  fprintf(stderr, "opt: %d %d %s\n", is_optimized(cadr(expr)), optimize_data(cadr(expr)), opt_names[optimize_data(cadr(expr))]);
  fprintf(stderr, "f: %p %p\n", ecdr(cadr(expr)), subtract_2);
  */
  if ((is_optimized(cadr(expr))) &&
      (optimize_data(cadr(expr)) == HOP_SAFE_C_SS) &&
      (ecdr(cadr(expr)) == subtract_2))
    {
      optimize_data(expr) = HOP_SAFE_C_C;
      return(abs_sub_ss);
    }
#endif
  return(f);
}

static s7_pointer is_pair_car, is_pair_cdr;
static s7_pointer g_is_pair_car(s7_scheme *sc, s7_pointer args) 
{
  s7_pointer val;
  val = find_symbol_or_bust_65(sc, cadar(args));
  if (!is_pair(val))
    return(s7_wrong_type_arg_error(sc, "car", 0, val, "a pair"));
  return(make_boolean(sc, is_pair(car(val))));
}

static s7_pointer g_is_pair_cdr(s7_scheme *sc, s7_pointer args) 
{
  s7_pointer val;
  val = find_symbol_or_bust_65(sc, cadar(args));
  if (!is_pair(val))
    return(s7_wrong_type_arg_error(sc, "cdr", 0, val, "a pair"));
  return(make_boolean(sc, is_pair(cdr(val))));
}

static s7_pointer is_pair_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if ((is_optimized(cadr(expr))) &&
      (optimize_data(cadr(expr)) == HOP_SAFE_C_S) &&
      (is_c_function(ecdr(cadr(expr)))))
    {
      s7_function g;
      g = c_function_call(ecdr(cadr(expr)));
      if (g == g_car)
	{
	  optimize_data(expr) = HOP_SAFE_C_C;
	  return(is_pair_car);
	}
      if (g == g_cdr)
	{
	  optimize_data(expr) = HOP_SAFE_C_C;
	  return(is_pair_cdr);
	}
    }
  return(f);
}


static s7_pointer is_eq_car;
static s7_pointer g_is_eq_car(s7_scheme *sc, s7_pointer args) 
{
  s7_pointer lst, val;
  lst = find_symbol_or_bust_65(sc, cadar(args));
  if (!is_pair(lst))
    return(s7_wrong_type_arg_error(sc, "car", 0, lst, "a pair"));
  val = find_symbol_or_bust_65(sc, cadr(args));
  return(make_boolean(sc, car(lst) == val));
}

static s7_pointer is_eq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if ((s7_is_symbol(caddr(expr))) &&
      (is_optimized(cadr(expr))) &&
      (optimize_data(cadr(expr)) == HOP_SAFE_C_S) &&
      (is_c_function(ecdr(cadr(expr)))))
    {
      s7_function g;
      g = c_function_call(ecdr(cadr(expr)));
      if (g == g_car)
	{
	  optimize_data(expr) = HOP_SAFE_C_C;
	  return(is_eq_car);
	}
    }
  return(f);
}

static s7_pointer is_zero_logand_s_ash_cs; /* yow */
static s7_pointer g_is_zero_logand_s_ash_cs(s7_scheme *sc, s7_pointer args) 
{
  /* not logbitp */
  s7_pointer s1, s2, x;
  s7_Int i1, i2, i3;
  x = cdar(args);

  s1 = find_symbol_or_bust_65(sc, car(x)); /* car(args) = (logand sym (ash 1 pos)), cadar = sym */
  if (!s7_is_integer(s1))
    return(s7_wrong_type_arg_error(sc, "logand", 1, s1, "an integer"));

  s2 = find_symbol_or_bust_65(sc, caddr(cadr(x)));
  if (!s7_is_integer(s2))
    return(s7_wrong_type_arg_error(sc, "ash", 2, s2, "an integer"));

  i1 = s7_integer(cadr(cadr(x)));
  i2 = s7_integer(s2);
  i3 = s7_integer(s1);

  return(make_boolean(sc, ((i1 << i2) & i3) == 0));
}

static s7_pointer is_zero_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  /* (define (tst a b) (zero? (logand a (ash 1 b))))
   *     cadr(expr) = (logand a (ash 1 b))
   *     caddr(cadr(expr)) = (ash 1 b)
   */
  s7_pointer x;
  x = cadr(expr);

  if ((is_optimized(x)) &&
      (optimize_data(x) == HOP_SAFE_C_S_opCSq) &&
      (is_c_function(ecdr(x))) &&
      (c_function_call(ecdr(x)) == g_logand) &&
      (is_c_function(ecdr(caddr(x)))) &&
      (c_function_call(ecdr(caddr(x))) == g_ash) &&
      (s7_is_integer(cadr(caddr(x)))))
    {
      optimize_data(expr) = HOP_SAFE_C_C;
      return(is_zero_logand_s_ash_cs);
    }
  return(f);
}


/* also not-chooser for all the ? procs, ss case for not equal? etc
 */
static s7_pointer not_is_pair, not_is_symbol, not_is_null, not_is_list, not_is_number, not_is_real, not_is_rational, not_is_integer;
static s7_pointer not_is_boolean, not_is_char, not_is_string, not_is_eof;
static s7_pointer not_is_eq_sq, not_is_eq_ss;

static s7_pointer g_not_is_pair(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !is_pair(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_null(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !is_null(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_symbol(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_symbol(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_number(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_number(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_real(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_real(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_integer(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_integer(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_rational(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_rational(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_list(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !is_proper_list(sc, find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_boolean(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_boolean(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_char(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_character(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_string(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, !s7_is_string(find_symbol_or_bust_65(sc, cadar(args)))));}
static s7_pointer g_not_is_eof(s7_scheme *sc, s7_pointer args) {return(make_boolean(sc, find_symbol_or_bust_65(sc, cadar(args)) != sc->EOF_OBJECT));}

static s7_pointer g_not_is_eq_sq(s7_scheme *sc, s7_pointer args) 
{
  return(make_boolean(sc, find_symbol_or_bust_65(sc, cadr(car(args))) != cadr(caddr(car(args)))));
}

static s7_pointer g_not_is_eq_ss(s7_scheme *sc, s7_pointer args) 
{
  return(make_boolean(sc, find_symbol_or_bust_65(sc, cadr(car(args))) != find_symbol_or_bust_65(sc, caddr(car(args)))));
}


static s7_pointer not_chooser(s7_scheme *sc, s7_pointer g, int args, s7_pointer expr)
{
  if (is_optimized(cadr(expr))) /* cadr(expr) might be a symbol, for example; is_optimized includes is_pair */
    {
      if ((optimize_data(cadr(expr)) == HOP_SAFE_C_S) &&
	  (is_c_function(ecdr(cadr(expr)))))
	{
	  s7_function f;
	  f = c_function_call(ecdr(cadr(expr)));
	  
	  if (f == g_is_pair)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_pair);
	    }
	  if (f == g_is_null)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_null);
	    }
	  if (f == g_is_symbol)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_symbol);
	    }
	  if (f == g_is_list)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_list);
	    }
	  if ((f == g_is_number) || (f == g_is_complex))
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_number);
	    }
	  if (f == g_is_rational)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_rational);
	    }
	  if (f == g_is_real)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_real);
	    }
	  if (f == g_is_integer)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_integer);
	    }
	  if (f == g_is_char)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_char);
	    }
	  if (f == g_is_boolean)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_boolean);
	    }
	  if (f == g_is_string)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_string);
	    }
	  if (f == g_is_eof_object)
	    {
	      optimize_data(expr) = HOP_SAFE_C_C;
	      return(not_is_eof);
	    }
	}
      else
	{
	  if (((optimize_data(cadr(expr)) == HOP_SAFE_C_SS) || (optimize_data(cadr(expr)) == HOP_SAFE_C_SQ)) &&
	      (is_c_function(ecdr(cadr(expr)))))
	    {
	      s7_function f;
	      f = c_function_call(ecdr(cadr(expr)));
	      if (f == g_is_eq)
		{
		  optimize_data(expr) = HOP_SAFE_C_C;
		  if (is_pair(caddr(cadr(expr))))
		    return(not_is_eq_sq);
		  return(not_is_eq_ss);
		}
	    }
	}
    }
  return(g);
}


static s7_pointer vector_ref_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if ((s7_is_integer(caddr(expr))) &&
	  (s7_integer(caddr(expr)) >= 0))
	return(vector_ref_ic);
      return(vector_ref_2);
    }
  return(f);
}


static s7_pointer hash_table_ref_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    return(hash_table_ref_2);
  return(f);
}


static s7_pointer add_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  /* fprintf(stderr, "original add chooser: %s\n", DISPLAY_80(expr)); */
  if (args == 1)
    return(add_1);

  if (args == 2)
    {
      if (caddr(expr) == small_int(1))
	return(add_s1);
      if (cadr(expr) == small_int(1))
	return(add_1s);
      return(add_2);
    }
  return(f);
}


static s7_pointer multiply_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (caddr(expr) == small_int(2))
	return(multiply_i2);
      if ((s7_is_real(caddr(expr))) &&
	  (s7_real(caddr(expr)) == 2.0))
	return(multiply_f2);
      return(multiply_2);
    }
  return(f);
}


static s7_pointer subtract_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 1)
    return(subtract_1);

  if (args == 2)
    {
      if (caddr(expr) == small_int(1))
	return(subtract_s1);
      return(subtract_2);
    }
  return(f);
}


static s7_pointer equal_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_integer(caddr(expr)))
	{
	  if ((is_optimized(cadr(expr))) &&
	      (optimize_data(cadr(expr)) == HOP_SAFE_C_S) &&
	      (is_c_function(ecdr(cadr(expr)))))
	    {
	      s7_function f;
	      f = c_function_call(ecdr(cadr(expr)));
	      if (f == g_length)
		{
		  optimize_data(expr) = HOP_SAFE_C_C;
		  return(equal_length_ic);
		}
	    }
	  return(equal_s_ic);
	}
      return(equal_2);
    }
  return(f);
}


#if (!WITH_GMP)
static s7_pointer less_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_integer(caddr(expr)))
	return(less_s_ic);
      return(less_2);
    }
  return(f);
}


static s7_pointer leq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_integer(caddr(expr)))
	return(leq_s_ic);
      return(leq_2);
    }
  return(f);
}


static s7_pointer greater_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if ((s7_is_real(caddr(expr))) &&
	  (!s7_is_rational(caddr(expr))) &&
	  (is_optimized(cadr(expr))) &&
	  (optimize_data(cadr(expr)) == HOP_SAFE_C_C) &&
	  (ecdr(cadr(expr)) == abs_sub_ss))
	{
	  optimize_data(expr) = HOP_SAFE_C_C;
	  return(greater_abs);
	}

      if (s7_is_integer(caddr(expr)))
	return(greater_s_ic);
      return(greater_2);
    }
  return(f);
}


static s7_pointer geq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_integer(caddr(expr)))
	return(geq_s_ic);
      return(geq_2);
    }
  return(f);
}
#endif


static s7_pointer char_equal_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_equal_s_ic);
      return(char_equal_2);
    }
  return(f);
}

static s7_pointer char_less_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_less_s_ic);
      return(char_less_2);
    }
  return(f);
}

static s7_pointer char_greater_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_greater_s_ic);
      return(char_greater_2);
    }
  return(f);
}

static s7_pointer char_geq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_geq_s_ic);
      return(char_geq_2);
    }
  return(f);
}

static s7_pointer char_leq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_leq_s_ic);
      return(char_leq_2);
    }
  return(f);
}


static s7_pointer char_ci_equal_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_ci_equal_s_ic);
      return(char_ci_equal_2);
    }
  return(f);
}

static s7_pointer char_ci_less_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_ci_less_s_ic);
      return(char_ci_less_2);
    }
  return(f);
}

static s7_pointer char_ci_greater_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_ci_greater_s_ic);
      return(char_ci_greater_2);
    }
  return(f);
}

static s7_pointer char_ci_geq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_ci_geq_s_ic);
      return(char_ci_geq_2);
    }
  return(f);
}

static s7_pointer char_ci_leq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_character(caddr(expr)))
	return(char_ci_leq_s_ic);
      return(char_ci_leq_2);
    }
  return(f);
}


static s7_pointer string_equal_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_equal_s_ic);
      return(string_equal_2);
    }
  return(f);
}

static s7_pointer string_less_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_less_s_ic);
      return(string_less_2);
    }
  return(f);
}

static s7_pointer string_greater_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_greater_s_ic);
      return(string_greater_2);
    }
  return(f);
}

static s7_pointer string_geq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_geq_s_ic);
      return(string_geq_2);
    }
  return(f);
}

static s7_pointer string_leq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_leq_s_ic);
      return(string_leq_2);
    }
  return(f);
}


static s7_pointer string_ci_equal_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_ci_equal_s_ic);
      return(string_ci_equal_2);
    }
  return(f);
}

static s7_pointer string_ci_less_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_ci_less_s_ic);
      return(string_ci_less_2);
    }
  return(f);
}

static s7_pointer string_ci_greater_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_ci_greater_s_ic);
      return(string_ci_greater_2);
    }
  return(f);
}

static s7_pointer string_ci_geq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_ci_geq_s_ic);
      return(string_ci_geq_2);
    }
  return(f);
}

static s7_pointer string_ci_leq_chooser(s7_scheme *sc, s7_pointer f, int args, s7_pointer expr)
{
  if (args == 2)
    {
      if (s7_is_string(caddr(expr)))
	return(string_ci_leq_s_ic);
      return(string_ci_leq_2);
    }
  return(f);
}



static void init_choosers(s7_scheme *sc)
{
  s7_pointer f;

  /* + */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "+")));
  c_function_chooser(f) = add_chooser;

  add_1 = s7_make_function(sc, "+", g_add_1, 1, 0, false, "experimental + optimization");
  c_function_class(add_1) = c_function_class(f);
  add_2 = s7_make_function(sc, "+", g_add_2, 2, 0, false, "experimental + optimization");
  c_function_class(add_2) = c_function_class(f);
  add_1s = s7_make_function(sc, "+", g_add_1s, 2, 0, false, "experimental + optimization");
  c_function_class(add_1s) = c_function_class(f);
  add_s1 = s7_make_function(sc, "+", g_add_s1, 2, 0, false, "experimental + optimization");
  c_function_class(add_s1) = c_function_class(f);
  

  /* - */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "-")));
  c_function_chooser(f) = subtract_chooser;

  subtract_1 = s7_make_function(sc, "-", g_subtract_1, 1, 0, false, "experimental - optimization");
  c_function_class(subtract_1) = c_function_class(f);
  subtract_2 = s7_make_function(sc, "-", g_subtract_2, 2, 0, false, "experimental - optimization");
  c_function_class(add_2) = c_function_class(f);
  subtract_s1 = s7_make_function(sc, "-", g_subtract_s1, 2, 0, false, "experimental - optimization");
  c_function_class(subtract_s1) = c_function_class(f);
  

  /* * */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "*")));
  c_function_chooser(f) = multiply_chooser;

  multiply_2 = s7_make_function(sc, "*", g_multiply_2, 2, 0, false, "experimental * optimization");
  c_function_class(multiply_2) = c_function_class(f);
  multiply_i2 = s7_make_function(sc, "*", g_multiply_i2, 2, 0, false, "experimental * optimization");
  c_function_class(multiply_i2) = c_function_class(f);
  multiply_f2 = s7_make_function(sc, "*", g_multiply_f2, 2, 0, false, "experimental * optimization");
  c_function_class(multiply_f2) = c_function_class(f);


  /* = */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "=")));
  c_function_chooser(f) = equal_chooser;

  equal_s_ic = s7_make_function(sc, "=", g_equal_s_ic, 2, 0, false, "experimental = optimization");
  c_function_class(equal_s_ic) = c_function_class(f);
  equal_length_ic = s7_make_function(sc, "=", g_equal_length_ic, 2, 0, false, "experimental = optimization");
  c_function_class(equal_length_ic) = c_function_class(f);
  equal_2 = s7_make_function(sc, "=", g_equal_2, 2, 0, false, "experimental = optimization");
  c_function_class(equal_2) = c_function_class(f);

#if (!WITH_GMP)
  /* < */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "<")));
  c_function_chooser(f) = less_chooser;

  less_s_ic = s7_make_function(sc, "<", g_less_s_ic, 2, 0, false, "experimental < optimization");
  c_function_class(less_s_ic) = c_function_class(f);
  less_2 = s7_make_function(sc, "<", g_less_2, 2, 0, false, "experimental < optimization");
  c_function_class(less_2) = c_function_class(f);


  /* > */
  f = symbol_value(symbol_global_slot(make_symbol(sc, ">")));
  c_function_chooser(f) = greater_chooser;

  greater_s_ic = s7_make_function(sc, ">", g_greater_s_ic, 2, 0, false, "experimental > optimization");
  c_function_class(greater_s_ic) = c_function_class(f);
  greater_abs = s7_make_function(sc, ">", g_greater_abs, 2, 0, false, "experimental > optimization");
  c_function_class(greater_abs) = c_function_class(f);
  greater_2 = s7_make_function(sc, ">", g_greater_2, 2, 0, false, "experimental > optimization");
  c_function_class(greater_2) = c_function_class(f);


  /* <= */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "<=")));
  c_function_chooser(f) = leq_chooser;

  leq_s_ic = s7_make_function(sc, "<=", g_leq_s_ic, 2, 0, false, "experimental <= optimization");
  c_function_class(leq_s_ic) = c_function_class(f);
  leq_2 = s7_make_function(sc, "<=", g_leq_2, 2, 0, false, "experimental <= optimization");
  c_function_class(leq_2) = c_function_class(f);


  /* >= */
  f = symbol_value(symbol_global_slot(make_symbol(sc, ">=")));
  c_function_chooser(f) = geq_chooser;

  geq_s_ic = s7_make_function(sc, ">=", g_geq_s_ic, 2, 0, false, "experimental >= optimization");
  c_function_class(geq_s_ic) = c_function_class(f);
  geq_2 = s7_make_function(sc, ">=", g_geq_2, 2, 0, false, "experimental >= optimization");
  c_function_class(geq_2) = c_function_class(f);
#endif

  /* char=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char=?")));
  c_function_chooser(f) = char_equal_chooser;

  char_equal_s_ic = s7_make_function(sc, "char=?", g_char_equal_s_ic, 2, 0, false, "experimental char=? optimization");
  c_function_class(char_equal_s_ic) = c_function_class(f);
  char_equal_2 = s7_make_function(sc, "char=?", g_char_equal_2, 2, 0, false, "experimental char=? optimization");
  c_function_class(char_equal_2) = c_function_class(f);


  /* char>? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char>?")));
  c_function_chooser(f) = char_greater_chooser;

  char_greater_s_ic = s7_make_function(sc, "char>?", g_char_greater_s_ic, 2, 0, false, "experimental char>? optimization");
  c_function_class(char_greater_s_ic) = c_function_class(f);
  char_greater_2 = s7_make_function(sc, "char>?", g_char_greater_2, 2, 0, false, "experimental char>? optimization");
  c_function_class(char_greater_2) = c_function_class(f);


  /* char<? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char<?")));
  c_function_chooser(f) = char_less_chooser;

  char_less_s_ic = s7_make_function(sc, "char<?", g_char_less_s_ic, 2, 0, false, "experimental char<? optimization");
  c_function_class(char_less_s_ic) = c_function_class(f);
  char_less_2 = s7_make_function(sc, "char<?", g_char_less_2, 2, 0, false, "experimental char<? optimization");
  c_function_class(char_less_2) = c_function_class(f);


  /* char<=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char<=?")));
  c_function_chooser(f) = char_leq_chooser;

  char_leq_s_ic = s7_make_function(sc, "char<=?", g_char_leq_s_ic, 2, 0, false, "experimental char<=? optimization");
  c_function_class(char_leq_s_ic) = c_function_class(f);
  char_leq_2 = s7_make_function(sc, "char<=?", g_char_leq_2, 2, 0, false, "experimental char<=? optimization");
  c_function_class(char_leq_2) = c_function_class(f);


  /* char>=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char>=?")));
  c_function_chooser(f) = char_geq_chooser;

  char_geq_s_ic = s7_make_function(sc, "char>=?", g_char_geq_s_ic, 2, 0, false, "experimental char>=? optimization");
  c_function_class(char_geq_s_ic) = c_function_class(f);
  char_geq_2 = s7_make_function(sc, "char>=?", g_char_geq_2, 2, 0, false, "experimental char>=? optimization");
  c_function_class(char_geq_2) = c_function_class(f);


  /* char-ci=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char-ci=?")));
  c_function_chooser(f) = char_ci_equal_chooser;

  char_ci_equal_s_ic = s7_make_function(sc, "char-ci=?", g_char_ci_equal_s_ic, 2, 0, false, "experimental char-ci=? optimization");
  c_function_class(char_ci_equal_s_ic) = c_function_class(f);
  char_ci_equal_2 = s7_make_function(sc, "char-ci=?", g_char_ci_equal_2, 2, 0, false, "experimental char-ci=? optimization");
  c_function_class(char_ci_equal_2) = c_function_class(f);


  /* char-ci>? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char-ci>?")));
  c_function_chooser(f) = char_ci_greater_chooser;

  char_ci_greater_s_ic = s7_make_function(sc, "char-ci>?", g_char_ci_greater_s_ic, 2, 0, false, "experimental char-ci>? optimization");
  c_function_class(char_ci_greater_s_ic) = c_function_class(f);
  char_ci_greater_2 = s7_make_function(sc, "char-ci>?", g_char_ci_greater_2, 2, 0, false, "experimental char-ci>? optimization");
  c_function_class(char_ci_greater_2) = c_function_class(f);


  /* char-ci<? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char-ci<?")));
  c_function_chooser(f) = char_ci_less_chooser;

  char_ci_less_s_ic = s7_make_function(sc, "char-ci<?", g_char_ci_less_s_ic, 2, 0, false, "experimental char-ci<? optimization");
  c_function_class(char_ci_less_s_ic) = c_function_class(f);
  char_ci_less_2 = s7_make_function(sc, "char-ci<?", g_char_ci_less_2, 2, 0, false, "experimental char-ci<? optimization");
  c_function_class(char_ci_less_2) = c_function_class(f);


  /* char-ci<=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char-ci<=?")));
  c_function_chooser(f) = char_ci_leq_chooser;

  char_ci_leq_s_ic = s7_make_function(sc, "char-ci<=?", g_char_ci_leq_s_ic, 2, 0, false, "experimental char-ci<=? optimization");
  c_function_class(char_ci_leq_s_ic) = c_function_class(f);
  char_ci_leq_2 = s7_make_function(sc, "char-ci<=?", g_char_ci_leq_2, 2, 0, false, "experimental char-ci<=? optimization");
  c_function_class(char_ci_leq_2) = c_function_class(f);


  /* char-ci>=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "char-ci>=?")));
  c_function_chooser(f) = char_ci_geq_chooser;

  char_ci_geq_s_ic = s7_make_function(sc, "char-ci>=?", g_char_ci_geq_s_ic, 2, 0, false, "experimental char-ci>=? optimization");
  c_function_class(char_ci_geq_s_ic) = c_function_class(f);
  char_ci_geq_2 = s7_make_function(sc, "char-ci>=?", g_char_ci_geq_2, 2, 0, false, "experimental char-ci>=? optimization");
  c_function_class(char_ci_geq_2) = c_function_class(f);


  /* string=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string=?")));
  c_function_chooser(f) = string_equal_chooser;

  string_equal_s_ic = s7_make_function(sc, "string=?", g_string_equal_s_ic, 2, 0, false, "experimental string=? optimization");
  c_function_class(string_equal_s_ic) = c_function_class(f);
  string_equal_2 = s7_make_function(sc, "string=?", g_string_equal_2, 2, 0, false, "experimental string=? optimization");
  c_function_class(string_equal_2) = c_function_class(f);


  /* string>? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string>?")));
  c_function_chooser(f) = string_greater_chooser;

  string_greater_s_ic = s7_make_function(sc, "string>?", g_string_greater_s_ic, 2, 0, false, "experimental string>? optimization");
  c_function_class(string_greater_s_ic) = c_function_class(f);
  string_greater_2 = s7_make_function(sc, "string>?", g_string_greater_2, 2, 0, false, "experimental string>? optimization");
  c_function_class(string_greater_2) = c_function_class(f);


  /* string<? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string<?")));
  c_function_chooser(f) = string_less_chooser;

  string_less_s_ic = s7_make_function(sc, "string<?", g_string_less_s_ic, 2, 0, false, "experimental string<? optimization");
  c_function_class(string_less_s_ic) = c_function_class(f);
  string_less_2 = s7_make_function(sc, "string<?", g_string_less_2, 2, 0, false, "experimental string<? optimization");
  c_function_class(string_less_2) = c_function_class(f);


  /* string<=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string<=?")));
  c_function_chooser(f) = string_leq_chooser;

  string_leq_s_ic = s7_make_function(sc, "string<=?", g_string_leq_s_ic, 2, 0, false, "experimental string<=? optimization");
  c_function_class(string_leq_s_ic) = c_function_class(f);
  string_leq_2 = s7_make_function(sc, "string<=?", g_string_leq_2, 2, 0, false, "experimental string<=? optimization");
  c_function_class(string_leq_2) = c_function_class(f);


  /* string>=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string>=?")));
  c_function_chooser(f) = string_geq_chooser;

  string_geq_s_ic = s7_make_function(sc, "string>=?", g_string_geq_s_ic, 2, 0, false, "experimental string>=? optimization");
  c_function_class(string_geq_s_ic) = c_function_class(f);
  string_geq_2 = s7_make_function(sc, "string>=?", g_string_geq_2, 2, 0, false, "experimental string>=? optimization");
  c_function_class(string_geq_2) = c_function_class(f);


  /* string-ci=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string-ci=?")));
  c_function_chooser(f) = string_ci_equal_chooser;

  string_ci_equal_s_ic = s7_make_function(sc, "string-ci=?", g_string_ci_equal_s_ic, 2, 0, false, "experimental string-ci=? optimization");
  c_function_class(string_ci_equal_s_ic) = c_function_class(f);
  string_ci_equal_2 = s7_make_function(sc, "string-ci=?", g_string_ci_equal_2, 2, 0, false, "experimental string-ci=? optimization");
  c_function_class(string_ci_equal_2) = c_function_class(f);


  /* string-ci>? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string-ci>?")));
  c_function_chooser(f) = string_ci_greater_chooser;

  string_ci_greater_s_ic = s7_make_function(sc, "string-ci>?", g_string_ci_greater_s_ic, 2, 0, false, "experimental string-ci>? optimization");
  c_function_class(string_ci_greater_s_ic) = c_function_class(f);
  string_ci_greater_2 = s7_make_function(sc, "string-ci>?", g_string_ci_greater_2, 2, 0, false, "experimental string-ci>? optimization");
  c_function_class(string_ci_greater_2) = c_function_class(f);


  /* string-ci<? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string-ci<?")));
  c_function_chooser(f) = string_ci_less_chooser;

  string_ci_less_s_ic = s7_make_function(sc, "string-ci<?", g_string_ci_less_s_ic, 2, 0, false, "experimental string-ci<? optimization");
  c_function_class(string_ci_less_s_ic) = c_function_class(f);
  string_ci_less_2 = s7_make_function(sc, "string-ci<?", g_string_ci_less_2, 2, 0, false, "experimental string-ci<? optimization");
  c_function_class(string_ci_less_2) = c_function_class(f);


  /* string-ci<=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string-ci<=?")));
  c_function_chooser(f) = string_ci_leq_chooser;

  string_ci_leq_s_ic = s7_make_function(sc, "string-ci<=?", g_string_ci_leq_s_ic, 2, 0, false, "experimental string-ci<=? optimization");
  c_function_class(string_ci_leq_s_ic) = c_function_class(f);
  string_ci_leq_2 = s7_make_function(sc, "string-ci<=?", g_string_ci_leq_2, 2, 0, false, "experimental string-ci<=? optimization");
  c_function_class(string_ci_leq_2) = c_function_class(f);


  /* string-ci>=? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "string-ci>=?")));
  c_function_chooser(f) = string_ci_geq_chooser;

  string_ci_geq_s_ic = s7_make_function(sc, "string-ci>=?", g_string_ci_geq_s_ic, 2, 0, false, "experimental string-ci>=? optimization");
  c_function_class(string_ci_geq_s_ic) = c_function_class(f);
  string_ci_geq_2 = s7_make_function(sc, "string-ci>=?", g_string_ci_geq_2, 2, 0, false, "experimental string-ci>=? optimization");
  c_function_class(string_ci_geq_2) = c_function_class(f);


  /* abs */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "abs")));
  c_function_chooser(f) = abs_chooser;
#if (!WITH_GMP)
  abs_sub_ss = s7_make_function(sc, "abs", g_abs_sub_ss, 2, 0, false, "experimental abs(- a b) optimization");
  c_function_class(abs_sub_ss) = c_function_class(f);
#endif


  /* vector-ref */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "vector-ref")));
  c_function_chooser(f) = vector_ref_chooser;

  vector_ref_ic = s7_make_function(sc, "vector-ref", g_vector_ref_ic, 2, 0, false, "experimental vector-ref optimization");
  c_function_class(vector_ref_ic) = c_function_class(f);
  vector_ref_2 = s7_make_function(sc, "vector-ref", g_vector_ref_2, 2, 0, false, "experimental vector-ref optimization");
  c_function_class(vector_ref_2) = c_function_class(f);


  /* hash-table-ref */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "hash-table-ref")));
  c_function_chooser(f) = hash_table_ref_chooser;

  hash_table_ref_2 = s7_make_function(sc, "hash-table-ref", g_hash_table_ref_2, 2, 0, false, "experimental hash-table-ref optimization");
  c_function_class(hash_table_ref_2) = c_function_class(f);



  /* not */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "not")));
  c_function_chooser(f) = not_chooser;

  not_is_pair = s7_make_function(sc, "not", g_not_is_pair, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_pair) = c_function_class(f);
  not_is_null = s7_make_function(sc, "not", g_not_is_null, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_null) = c_function_class(f);
  not_is_list = s7_make_function(sc, "not", g_not_is_list, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_list) = c_function_class(f);
  not_is_symbol = s7_make_function(sc, "not", g_not_is_symbol, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_symbol) = c_function_class(f);
  not_is_number = s7_make_function(sc, "not", g_not_is_number, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_number) = c_function_class(f);
  not_is_real = s7_make_function(sc, "not", g_not_is_real, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_real) = c_function_class(f);
  not_is_rational = s7_make_function(sc, "not", g_not_is_rational, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_rational) = c_function_class(f);
  not_is_integer = s7_make_function(sc, "not", g_not_is_integer, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_integer) = c_function_class(f);
  not_is_boolean = s7_make_function(sc, "not", g_not_is_boolean, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_boolean) = c_function_class(f);
  not_is_string = s7_make_function(sc, "not", g_not_is_string, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_string) = c_function_class(f);
  not_is_char = s7_make_function(sc, "not", g_not_is_char, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_char) = c_function_class(f);
  not_is_eof = s7_make_function(sc, "not", g_not_is_eof, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_eof) = c_function_class(f);
  not_is_eq_ss = s7_make_function(sc, "not", g_not_is_eq_ss, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_eq_ss) = c_function_class(f);
  not_is_eq_sq = s7_make_function(sc, "not", g_not_is_eq_sq, 1, 0, false, "experimental not optimization");
  c_function_class(not_is_eq_sq) = c_function_class(f);


  /* pair? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "pair?")));
  c_function_chooser(f) = is_pair_chooser;

  is_pair_car = s7_make_function(sc, "pair?", g_is_pair_car, 1, 0, false, "experimental pair? optimization");
  c_function_class(is_pair_car) = c_function_class(f);
  is_pair_cdr = s7_make_function(sc, "pair?", g_is_pair_cdr, 1, 0, false, "experimental pair? optimization");
  c_function_class(is_pair_cdr) = c_function_class(f);


  /* eq? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "eq?")));
  c_function_chooser(f) = is_eq_chooser;

  is_eq_car = s7_make_function(sc, "eq?", g_is_eq_car, 2, 0, false, "experimental eq? optimization");
  c_function_class(is_eq_car) = c_function_class(f);


  /* zero? */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "zero?")));
  c_function_chooser(f) = is_zero_chooser;

  is_zero_logand_s_ash_cs = s7_make_function(sc, "zero?", g_is_zero_logand_s_ash_cs, 1, 0, false, "experimental zero? optimization");
  c_function_class(is_zero_logand_s_ash_cs) = c_function_class(f);


  /* memq */
  f = symbol_value(symbol_global_slot(make_symbol(sc, "memq")));
  c_function_chooser(f) = memq_chooser;
  
  memq_3 = s7_make_function(sc, "memq", g_memq_3, 2, 0, false, "experimental memq optimization");
  c_function_class(memq_3) = c_function_class(f);
  memq_4 = s7_make_function(sc, "memq", g_memq_4, 2, 0, false, "experimental memq optimization");
  c_function_class(memq_4) = c_function_class(f);
  memq_any = s7_make_function(sc, "memq", g_memq_any, 2, 0, false, "experimental memq optimization");
  c_function_class(memq_any) = c_function_class(f);
}

void s7_unoptimize(s7_scheme *sc, s7_pointer code)
{
  /* needed by the run macro -- the two optimization processes are not compatible
   *   my hope is to replace run with local (s7) optimizations
   */
  if (is_pair(code))
    {
      if ((s7_is_symbol(car(code))) &&
	  /* (is_syntax(symbol_value(car(code)))) && */ /* normal ops are now pretending to be syntax */
	  (is_syntactic(car(code))) &&
	  (syntax_opcode(symbol_value(car(code))) >= OP_QUOTE_UNCHECKED))
	car(code) = cadar(code);
      else s7_unoptimize(sc, car(code));
      s7_unoptimize(sc, cdr(code));
    }
}


static s7_pointer g_unoptimize(s7_scheme *sc, s7_pointer args)
{
  #define H_unoptimize "(unoptimize code) erases all the optimizer info in code"

  if ((s7_is_symbol(car(args))) &&
      (is_syntax(symbol_value(car(args)))))
    return(cadar(args));

  s7_unoptimize(sc, car(args));
  return(car(args));
}



static bool optimize_expression(s7_scheme *sc, s7_pointer x, int hop, s7_pointer e);
static int combine_ops(s7_scheme *sc, int op1, s7_pointer e1, s7_pointer e2);

static s7_pointer collect_collisions(s7_scheme *sc, s7_pointer lst, s7_pointer e)
{
  s7_pointer p;
  sc->w = e;
  for (p = lst; is_pair(p); p = cdr(p))
    {
      if ((s7_is_symbol(car(p))) &&
	  (symbol_global_slot(car(p)) != sc->NIL))
	sc->w = cons(sc, car(p), sc->w);
      else
	{
	  if ((is_pair(car(p))) &&
	      (s7_is_symbol(caar(p))) &&
	      (symbol_global_slot(caar(p)) != sc->NIL))
	    sc->w = cons(sc, caar(p), sc->w);
	}
    }
  return(sc->w);
}

static bool optimize_function(s7_scheme *sc, s7_pointer x, s7_pointer func, int hop, s7_pointer e)
{
  int pairs = 0, symbols = 0, args = 0, bad_pairs = 0, quotes = 0;
  s7_pointer p;
  
  /* fprintf(stderr, "    func: %s\n     e: %s\n", DISPLAY_80(car(x)), DISPLAY_80(e)); */

  for (p = cdar(x); is_pair(p); p = cdr(p), args++)
    {
      if (is_pair(car(p)))
	{
	  pairs++;
	  if (!is_checked(car(p)))
	    {
	      bool opt;
 	      opt = optimize_expression(sc, p, hop, e);
 	      if (!opt) 
		{
		  bad_pairs++;
		  /* fprintf(stderr, "    optexp: %s: unsafe: %d, opt: %d\n", DISPLAY_80(car(p)), is_unsafe(car(p)), is_optimized(car(p))); */
		  if ((caar(p) == sc->QUOTE) &&
		      (is_pair(cdar(p))) &&
		      (is_null(cddar(p))))
		    quotes++;
		}
	    }
	  else 
	    {
	      if ((!is_optimized(car(p))) ||
		  (is_unsafe(car(p))))
		{
		  bad_pairs++;
		  /* fprintf(stderr, "    checked before %s: unsafe: %d, opt: %d\n", DISPLAY_80(car(p)), is_unsafe(car(p)), is_optimized(car(p))); */
		  if ((caar(p) == sc->QUOTE) &&
		      (is_pair(cdar(p))) &&
		      (is_null(cddar(p))))
		    quotes++;
		}
	    }
	}
      else
	{
	  if (s7_is_symbol(car(p)))
	    symbols++;
	}
    }
  
  /* fprintf(stderr, "null: %d, match: %d\n", is_null(p), args_match(sc, func, args)); */

  if ((is_null(p)) &&                /* if not null, dotted list of args? */
      (args_match(sc, func, args)))  /* we have a legit call, at least syntactically */
    {
      /*
      if (is_closure_star(func))
	fprintf(stderr, "closure*: %s\n", DISPLAY_80(car(x)));
      */
      switch (args)
	{
	  /* -------------------------------------------------------------------------------- */
	case 0:                /* closure* */
	  if (is_c_function(func))
	    {
	      set_optimized(car(x));
	      set_optimize_data(car(x), OP_SAFE_C_C);
	      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
	      if (is_safe_procedure(func))
		return(true);
	      set_unsafe(car(x));
	      return(false);
	    }
	  if ((is_closure(func)) &&
	      (is_null(closure_args(func))))
	    /* suboptimal, but just a test -- closure* needs to load up default args.
	       also a rest arg matches 0 args, but its name needs to be added to the environment
	    */
	    {
	      set_optimized(car(x));
	      set_unsafe(car(x));
	      if (is_safe_closure(closure_body(func)))
		set_optimize_data(car(x), OP_SAFE_THUNK);
	      else optimize_data(car(x)) = OP_THUNK;
	      ecdr(car(x)) = func;
	      return(false); /* false because currently the C_PP stuff assumes safe procedure calls */
	    }
	  /* call-with-exit and call/cc require an argument */
	  
	  break;
	  
	  /* for a defined function, if the body is completely optimizable, and
	   *   there is no values object or anything that goofs with the stack,
	   *   can it be declared safe? no -- s7_call is a killer.
	   *
	   * if all constant args, and func is 1->1, save actual result?
	   */

	  /* -------------------------------------------------------------------------------- */
	case 1:
	  if (pairs == 0)
	    {
	      if (is_c_function(func))
		{
		  if (is_safe_procedure(func))
		    {     
		      set_optimized(car(x));
		      if (symbols == 0)
			set_optimize_data(car(x), OP_SAFE_C_C);
		      else set_optimize_data(car(x), OP_SAFE_C_S);
		      /* we can't simply check is_global here to forego symbol value lookup later because we aren't
		       *    tracking local vars, so the global bit may be on right now, but won't be when
		       *    this code is evaluated.  But memq(sym, e) would catch such cases.
		       *    I think it has already been checked for func, so we only need to look for cadar(x).
		       *    But global symbols are rare, and I don't see a huge savings in the lookup time --
		       *    in callgrind it's about 7/lookup in both cases.
		       */
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		      return(true);
		    }
		  else
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_C_ALL_G);
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		      return(false); 
		    }
		}
	      else
		{
		  if ((is_closure(func)) &&
		      (s7_list_length(sc, closure_args(func)) == 1))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      if (s7_is_symbol(cadar(x)))
			optimize_data(car(x)) = ((is_safe_closure(closure_body(func))) ? OP_SAFE_CLOSURE_S : OP_CLOSURE_S);
		      else optimize_data(car(x)) = ((is_safe_closure(closure_body(func))) ? OP_SAFE_CLOSURE_C : OP_CLOSURE_C);
		      ecdr(car(x)) = func;
		      return(false); 
		    }
		  /* we check args_match above, so I guess closure* is the only other useful case here
		   */
		}
	    }
	  
	  if (pairs == 1)
	    {
	      if (bad_pairs == 0)
		{
		  /* we can optimize whatever the arg involves */
		  if (is_c_function(func))
		    {
		      if (is_safe_procedure(func))
			{
			  int op;
			  op = combine_ops(sc, SAFE_C_P, car(x), cadar(x));
			  if (op != SAFE_C_P)
			    {
			      set_optimized(car(x));
			      set_optimize_data(car(x), op);
			      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
			    }
			}
		    }
		  else
		    {
		      if ((is_closure(func)) &&
			  (s7_list_length(sc, closure_args(func)) == 1) &&
			  (optimize_data_match(cadar(x), OP_SAFE_C_S)))
			{
			  set_optimized(car(x));
			  set_unsafe(car(x));
			  optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_opSq : OP_CLOSURE_opSq));
			  ecdr(car(x)) = func;
			  return(false); 
			}
		    }
		}
	      else
		{
		  if (quotes == 1)
		    {
		      if (is_c_function(func))
			{
			  if (is_safe_procedure(func))
			    {
			      set_optimized(car(x));
			      set_optimize_data(car(x), OP_SAFE_C_Q);
			      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
			    }
			}
		      else
			{
			  if ((is_closure(func)) &&
			      (s7_list_length(sc, closure_args(func)) == 1)) /* TODO: this seems to be needed, but why? */
			    {
			      set_optimized(car(x));
			      set_unsafe(car(x));
			      optimize_data(car(x)) = ((is_safe_closure(closure_body(func))) ? OP_SAFE_CLOSURE_Q : OP_CLOSURE_Q);
			      ecdr(car(x)) = func;
			      return(false); 
			    }
			}
		    }
		  else
		    {
		      if (is_c_function(func))
			{
			  if (is_safe_procedure(func))
			    {
			      /*
			      fprintf(stderr, "safe of bad 1: %s\n", DISPLAY_80(car(x)));
			      if (is_optimized(cadar(x)))
				fprintf(stderr, "  is opt: %s\n", opt_names[optimize_data(cadar(x))]);
			      */
			      
			      if (optimize_data_match(cadar(x), OP_SAFE_CLOSURE_SS))
				{
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  optimize_data(car(x)) = OP_SAFE_C_opSAFE_CLOSURE_SSq;
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				  return(false); 
				}

			      if (optimize_data_match(cadar(x), OP_SAFE_CLOSURE_opSq_S))
				{
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  optimize_data(car(x)) = OP_SAFE_C_opSAFE_CLOSURE_opSq_Sq;
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				  return(false); 
				}
			    }
			  else
			    {
			      if ((is_pair(cadar(x))) &&
				  (caadar(x) == sc->LAMBDA))
				{
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  set_optimize_data(car(x), OP_C_L);
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				  return(false);
				}
			    }
			}
		    }
		}
	    }

	  if ((!is_optimized(car(x))) &&
	      (pairs == 1) &&
	      /* (bad_pairs == 1) && */
	      (quotes == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));
	      if (bad_pairs == 0)
		{
		  set_optimize_data(car(x), OP_SAFE_C_Z);
		  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x)); /* was func */
		  return(true);
		}
	      else
		{
		  set_unsafe(car(x));
		  set_optimize_data(car(x), OP_SAFE_C_P);
		  ecdr(car(x)) = func;
		  return(false);
		}
	    }
	  /*
	  if ((!is_optimized(car(x))) && (pairs > 0) && (bad_pairs == quotes))
	    fprintf(stderr, "1 case: %s\n", DISPLAY_80(car(x)));
	  */
	  break; 
	  /* TODO: opt do??, tracing checks */

	  /* -------------------------------------------------------------------------------- */
	case 2:
	  /* fprintf(stderr, "quote: %d, pair: %d (bad: %d), sym: %d in %s\n", quotes, pairs, bad_pairs, symbols, s7_object_to_c_string(sc, car(x)));  */
	  if (pairs == 0)
	    {
	      if (is_c_function(func))
		{
		  if ((is_safe_procedure(func)) ||
		      (c_function_call(func) == g_member) || /* the unsafe case has a 3rd arg */
		      (c_function_call(func) == g_assoc))
		    {
		      if (symbols == 0)
			{
			  set_optimize_data(car(x), OP_SAFE_C_C);
			}
		      else
			{
			  if (symbols == 2)
			    {
			      set_optimize_data(car(x), OP_SAFE_C_SS); /* these two symbols are almost never the same, (sqrt (+ (* x x) (* y y))) */
			    }
			  else
			    {
			      if (s7_is_symbol(cadar(x)))
				{
				  set_optimize_data(car(x), OP_SAFE_C_SC);
				}
			      else 
				{
				  set_optimize_data(car(x), OP_SAFE_C_CS);
				}
			    }
			}
		      set_optimized(car(x));
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, 2, car(x));
		      return(true);
		    }
		  else
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_C_ALL_G);
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		      return(false); 
		    }
		}
	      else
		{
		  if ((is_closure(func)) &&
		      (s7_list_length(sc, closure_args(func)) == 2))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      if (symbols == 2)
			optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_SS : OP_CLOSURE_SS));
		      else
			{
			  if (symbols == 0)
			    optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_CC : OP_CLOSURE_CC));
			  else
			    {
			      if (s7_is_symbol(cadar(x)))
				optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_SC : OP_CLOSURE_SC));
			      else optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_CS : OP_CLOSURE_CS));
			    }
			}
		      ecdr(car(x)) = func;
		      return(false);
		    }
		}
	    }
	  else /* pairs != 0 */
	    {
	      if (bad_pairs == 0)
		{
		  if (pairs == 2)
		    {
		      if (is_c_function(func))
			{
			  if ((is_safe_procedure(func)) ||
			      (c_function_call(func) == g_member) ||
			      (c_function_call(func) == g_assoc))
			    {
			      int op;
			      op = combine_ops(sc, SAFE_C_PP, cadar(x), caddar(x));
			      if (op != SAFE_C_PP)
				{
				  set_optimized(car(x));
				  set_optimize_data(car(x), op);
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				}
			    }
			}
		      else
			{
			  if ((is_closure(func)) &&
			      (optimize_data_match(cadar(x), OP_SAFE_C_S)) &&
			      (optimize_data_match(caddar(x), OP_SAFE_C_S)))
			    {
			      set_optimized(car(x));
			      set_unsafe(car(x));
			      optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_opSq_opSq : OP_CLOSURE_opSq_opSq));
			      ecdr(car(x)) = func;
			      return(false);
			    }
			}
		    }
		  if (pairs == 1)
		    {
		      if (is_c_function(func))
			{
			  if ((is_safe_procedure(func)) ||
			      (c_function_call(func) == g_member) ||
			      (c_function_call(func) == g_assoc))
			    {
			      int orig_op, op;

			      if (is_pair(cadar(x)))
				{
				  if (s7_is_symbol(caddar(x)))
				    orig_op = SAFE_C_PS;
				  else orig_op = SAFE_C_PC;
				  op = combine_ops(sc, orig_op, car(x), cadar(x));
				}
			      else 
				{
				  if (s7_is_symbol(cadar(x)))
				    orig_op = SAFE_C_SP;
				  else orig_op = SAFE_C_CP;
				  op = combine_ops(sc, orig_op, car(x), caddar(x));
				}
				  
			      if (op != orig_op)
				{
				  set_optimized(car(x));
				  set_optimize_data(car(x), op);
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, 2, car(x));
				}
			    }
			  else
			    {
			      if ((symbols == 1) &&
				  (s7_is_symbol(cadar(x))) &&
				  (optimize_data_match(caddar(x), OP_SAFE_C_S)))
				{
				  /* fprintf(stderr, "set: %s\n", DISPLAY_80(car(x))); */
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  set_optimize_data(car(x), OP_C_S_opSq);
				  ecdr(car(x)) = func;
				  return(false);
				}
			    }
			}
		      else
			{
			  if ((is_closure(func)) &&
			      (s7_list_length(sc, closure_args(func)) == 2))
			    {
			      if ((optimize_data_match(cadar(x), OP_SAFE_C_S)) &&
				  (s7_is_symbol(caddar(x))))
				{
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_opSq_S : OP_CLOSURE_opSq_S));
				  ecdr(car(x)) = func;
				  return(false); 
				}
			      if ((optimize_data_match(caddar(x), OP_SAFE_C_S)) &&
				  (s7_is_symbol(cadar(x))))
				{
				  set_optimized(car(x));
				  set_unsafe(car(x));
				  optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_S_opSq : OP_CLOSURE_S_opSq));
				  ecdr(car(x)) = func;
				  return(false); 
				}
			    }
			}
		    }
		}
	      else /* pairs != 0 and bad_pairs != 0 */
		{
		  if ((bad_pairs == 1) && (quotes == 1))
		    {
		      if (is_c_function(func))
			{
			  if ((is_safe_procedure(func)) ||
			      (c_function_call(func) == g_member) ||
			      (c_function_call(func) == g_assoc))
			    {
			      if  (symbols == 1)
				{
				  set_optimized(car(x));
				  if (s7_is_symbol(cadar(x)))
				    set_optimize_data(car(x), OP_SAFE_C_SQ);
				  else set_optimize_data(car(x), OP_SAFE_C_QS);
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				}
			      else
				{
				  if (pairs == 2)
				    {
				      int orig_op, op;
				      if (car(cadar(x)) == sc->QUOTE)
					orig_op = SAFE_C_QP;
				      else orig_op = SAFE_C_PQ;
				      op = combine_ops(sc, orig_op, car(x), cadar(x));
				      
				      if (op != orig_op)
					{
					  set_optimized(car(x));
					  set_optimize_data(car(x), op);
					  ecdr(car(x)) = c_function_chooser(func)(sc, func, 2, car(x));
					}
				    }
				  else
				    {
				      set_optimized(car(x));
				      if (is_pair(cadar(x)))
					set_optimize_data(car(x), OP_SAFE_C_QC);
				      else set_optimize_data(car(x), OP_SAFE_C_CQ);
				      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				    }
				}
			    }
			}
		    }
		  else
		    {
		      if (quotes == 2)
			{
			  if (is_c_function(func))
			    {
			      if (is_safe_procedure(func))
				{
				  set_optimized(car(x));
				  set_optimize_data(car(x), OP_SAFE_C_QQ);
				  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				}
			    }
			}
		      else
			{
			  if ((bad_pairs == 1) &&
			      (is_pair(cadar(x))) &&
			      (caadar(x) == sc->LAMBDA))
			    {
			      if (is_c_function(func))
				{
				  if (s7_is_symbol(caddar(x)))
				    {
				      set_optimized(car(x));
				      set_unsafe(car(x));
				      set_optimize_data(car(x), OP_C_LS);
				      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				      return(false);
				    }
				  if ((pairs == 2) &&
				      (is_optimized(caddar(x))) &&
				      (optimize_data_match(caddar(x), OP_SAFE_C_S)))
				    {
				      set_optimized(car(x));
				      set_unsafe(car(x));
				      set_optimize_data(car(x), OP_C_L_opSq);
				      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				      return(false);
				    }
				}
			    }
			  else
			    {
			      if ((bad_pairs == 2) &&
				  (quotes == 0) &&
				  (is_pair(cadar(x))) &&
				  (caadar(x) == sc->LAMBDA) &&
				  (is_pair(caddar(x))) &&
				  (car(caddar(x)) == sc->LAMBDA))
				{
				  if (is_c_function(func))
				    {
				      set_optimized(car(x));
				      set_unsafe(car(x));
				      set_optimize_data(car(x), OP_C_LL);
				      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
				      return(false);
				    }
				}
			    }
			}
		    }
		}
	    }
	  /*
	  if (!is_optimized(car(x)))
	    fprintf(stderr, "%s not optimized (%d %d)\n", DISPLAY_80(car(x)), pairs, bad_pairs);
	  */
	  if ((!is_optimized(car(x))) &&
	      (pairs == 1) &&
	      /* (bad_pairs == 1) && */
	      (quotes == 0) &&
	      (symbols == 1) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));
	      if (bad_pairs == 0)
		{
		  if (s7_is_symbol(cadar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_SZ);
		  else set_optimize_data(car(x), OP_SAFE_C_ZS);
		  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		  return(true);
		}
	      else
		{
		  set_unsafe(car(x));
		  if (s7_is_symbol(cadar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_SP);
		  else set_optimize_data(car(x), OP_SAFE_C_PS);
		  ecdr(car(x)) = func;
		  return(false);
		}
	    }

	  if ((!is_optimized(car(x))) &&
	      (pairs == 1) &&
	      /* (bad_pairs == 1) && */
	      (quotes == 0) &&
	      (symbols == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));
	      if (bad_pairs == 0)
		{
		  if (s7_is_symbol(cadar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_CZ);
		  else set_optimize_data(car(x), OP_SAFE_C_ZC);
		  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		  return(true);
		}
	      else
		{
		  set_unsafe(car(x));
		  if (!is_pair(cadar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_CP);
		  else set_optimize_data(car(x), OP_SAFE_C_PC);
		  ecdr(car(x)) = func;
		  return(false);
		}
	    }
	  /*
	  fprintf(stderr, "%d %d %d %d %d\n", 
		  !is_optimized(car(x)),
		  (pairs == 2),
		  (bad_pairs == 0),
		  (is_c_function(func)),
		  (is_safe_procedure(func)));
	  */
	  if ((!is_optimized(car(x))) &&
	      (pairs == 2) &&
	      (bad_pairs == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      /* fprintf(stderr, "use z_z\n"); */
	      set_optimized(car(x));
	      set_optimize_data(car(x), OP_SAFE_C_ZZ);
	      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x)); /* was func */
	      return(true);
	    }
	  /*
	  if (!is_optimized(car(x)))
	    fprintf(stderr, "2 case: %s\n", DISPLAY_80(car(x)));
	  */
	  break;
	  
	  /* -------------------------------------------------------------------------------- */
	case 3:
	  /* here quotes in safe functions are somewhat rare: list-ref, format, etc */
	  if (pairs == 0)
	    {
	      if (is_c_function(func))
		{
		  if (is_safe_procedure(func))
		    {
		      set_optimized(car(x));
		      if (symbols == 0)
			set_optimize_data(car(x), OP_SAFE_C_C);
		      else 
			{
			  if (symbols == 3)
			    set_optimize_data(car(x), OP_SAFE_C_SSS);
			  else set_optimize_data(car(x), OP_SAFE_C_XXX);
			}
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		    }
		}
	      else
		{
		  if ((is_closure(func)) &&
		      (s7_list_length(sc, closure_args(func)) == 3) &&
		      (symbols == 3))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_SSS : OP_CLOSURE_SSS));
		      ecdr(car(x)) = func;
		      return(false);
		    }
		}
	    }

	  if ((pairs == 1) &&
	      (bad_pairs == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));		  
	      if (is_pair(cadar(x)))
		set_optimize_data(car(x), OP_SAFE_C_ZXX);
	      else
		{
		  if (is_pair(caddar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_XZX);
		  else set_optimize_data(car(x), OP_SAFE_C_XXZ);
		}
	      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
	    }


	  if ((pairs == 2) &&
	      (bad_pairs == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));		  
	      if (!is_pair(cadddr(car(x))))
		set_optimize_data(car(x), OP_SAFE_C_ZZX);
	      else
		{
		  if (!is_pair(caddar(x)))
		    set_optimize_data(car(x), OP_SAFE_C_ZXZ);
		  else set_optimize_data(car(x), OP_SAFE_C_XZZ);
		}
	      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
	    }


	  if ((pairs == 3) &&
	      (bad_pairs == 0) &&
	      (is_c_function(func)) &&
	      (is_safe_procedure(func)))
	    {
	      set_optimized(car(x));		  
	      set_optimize_data(car(x), OP_SAFE_C_ZZZ);
	      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
	    }


	  /* (define (hi) (catch #t (lambda () 1) (lambda args 2))) */

	  if ((bad_pairs == 2) &&
	      (symbols == 0) &&
	      (quotes == 0) &&
	      (is_pair(caddar(x))) &&
	      (car(caddar(x)) == sc->LAMBDA) &&
	      (is_pair(car(cdddr(car(x))))) &&
	      (car(car(cdddr(car(x)))) == sc->LAMBDA))
	    {
	      if (is_c_function(func))
		{
		  set_optimized(car(x));
		  set_unsafe(car(x));
		  set_optimize_data(car(x), OP_C_CLL);
		  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		  return(false);
		}
	    }

	  if (bad_pairs > quotes) return(false);
	  if ((!is_optimized(car(x))) &&
	      ((pairs == 0) || 
	       ((pairs == quotes) && 
		(bad_pairs == quotes))))
	    {
	      if (is_c_function(func))
		{
		  if (is_safe_procedure(func))
		    {
		      set_optimized(car(x));
		      set_optimize_data(car(x), OP_SAFE_C_ALL_G);
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		    }
		  else
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_C_ALL_G);
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		      return(false); 
		    }
		}
	      else
		{
		  if ((is_closure(func)) &&
		      (s7_list_length(sc, closure_args(func)) == 3))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_ALL_G : OP_CLOSURE_ALL_G));
		      ecdr(car(x)) = func;
		      return(false); 
		    }
		}
	    }
	  
	  /*
	  if (!is_optimized(car(x)))
	    fprintf(stderr, "3 case: %s\n", DISPLAY_80(car(x)));
	  */

	  break;
	  
	  /* -------------------------------------------------------------------------------- */
	default:
	  if (bad_pairs > quotes) return(false);
	  if (is_c_function(func))
	    {
	      if (is_safe_procedure(func))
		{
		  if (pairs == 0)
		    {
		      if (symbols == 0)
			{
			  set_optimized(car(x));
			  set_optimize_data(car(x), OP_SAFE_C_C);
			  ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
			}
		      else
			{
			  if ((symbols == args) &&
			      (args < GC_TRIGGER_SIZE))
			    {
			      set_optimized(car(x));
			      set_optimize_data(car(x), OP_SAFE_C_ALL_S);
			      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
			    }
			  /* all_g case handled below */
			}
		    }
		  /* all_g case handled below */
		}
	      /* all_g case handled below */
	    }
	  else
	    {
	      if ((is_closure(func)) &&
		  (pairs == 0) &&
		  ((symbols == args) || (symbols == 0)) &&
		  (args < GC_TRIGGER_SIZE))
		{
		  set_optimized(car(x));
		  set_unsafe(car(x));
		  if (symbols == 0)
		    optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_ALL_C : OP_CLOSURE_ALL_C));
		  else optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_ALL_S : OP_CLOSURE_ALL_S));
		  ecdr(car(x)) = func;
		  return(false);
		}
	    }

	  if ((!is_optimized(car(x))) &&
	      (args < GC_TRIGGER_SIZE) &&
	      ((pairs == 0) || 
	       ((pairs == quotes) && 
		(bad_pairs == quotes))))
	    {
	      if (is_c_function(func))
		{
		  if (is_safe_procedure(func))
		    {
		      set_optimized(car(x));
		      optimize_data(car(x)) = OP_SAFE_C_ALL_G;
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		    }
		  else
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_C_ALL_G);
		      ecdr(car(x)) = c_function_chooser(func)(sc, func, args, car(x));
		      return(false); 
		    }
		}
	      else
		{
		  /* none of the closures can skip the ecdr=func check via hop
		   *    unless they are globally defined.
		   */
		  if ((is_closure(func)) &&
		      (s7_list_length(sc, closure_args(func)) == args))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      optimize_data(car(x)) = ((is_safe_closure(closure_body(func)) ? OP_SAFE_CLOSURE_ALL_G : OP_CLOSURE_ALL_G));
		      ecdr(car(x)) = func;
		      return(false); 
		    }
		}
	    }
	  /*
	  if (!is_optimized(car(x)))
	    fprintf(stderr, "%d case: %s\n", s7_list_length(sc, cdar(x)), DISPLAY_80(car(x)));
	  */
	  break;
	}
      return(is_optimized(car(x)));
    }
  return(false);
}



static bool optimize_syntax(s7_scheme *sc, s7_pointer x, s7_pointer func, int hop, s7_pointer e)
{
  s7_pointer p;
  opcode_t op;

  p = car(x);
  if ((!is_pair(cdr(p))) ||
      (!is_pair(cddr(p))))			
    return(false);

  op = (opcode_t)syntax_opcode(func);

  /* fprintf(stderr, "optimize syntax %s\n     e: %s\n", DISPLAY(p), DISPLAY(e)); */
  if (op == OP_QUOTE)
    {
      /* fprintf(stderr, "quote\n"); */
      return(false);
    }

  sc->w = e;
  if (op == OP_LET)
    {
      /* fprintf(stderr, "let\n"); */
      if (s7_is_symbol(cadr(p)))
	{
	  if (symbol_global_slot(cadr(p)) != sc->NIL)
	    sc->w = cons(sc, cadr(p), sc->w);
	  sc->w = collect_collisions(sc, caddr(p), sc->w);
	}
      else 
	{
	  sc->w = collect_collisions(sc, cadr(p), sc->w);
	}
    }
  else
    {
      if ((op == OP_LET_STAR) ||
	  (op == OP_LETREC))
	{
	  sc->w = collect_collisions(sc, cadr(p), sc->w);
	}
      else
	{
	  if ((op == OP_DEFINE) || 
	      (op == OP_DEFINE_STAR) ||
	      (op == OP_LAMBDA) ||
	      (op == OP_LAMBDA_STAR))
	    {
	      /* fprintf(stderr, "define: %s\n", DISPLAY_80(p)); */
	      if (s7_is_symbol(cadr(p)))
		{
		  if (symbol_global_slot(cadr(p)) != sc->NIL)
		    sc->w = cons(sc, cadr(p), sc->w);
		}
	      else sc->w = collect_collisions(sc, cadr(p), sc->w);

	      if ((op == OP_DEFINE) &&
		  (is_pair(cadr(p))))
		sc->x = cons(sc, p, sc->x);
	    }
	  else
	    {
	      if (op == OP_SET)
		{
		  if ((s7_is_symbol(cadr(p))) &&
		      (symbol_global_slot(cadr(p)) != sc->NIL))
		    sc->w = cons(sc, cadr(p), sc->w);
		}
	      else
		{
		  if (op == OP_DO)
		    {
		      sc->w = collect_collisions(sc, cadr(p), sc->w);
		    }
		}
	    }
	}
    }

  for (p = cdar(x); is_pair(p); p = cdr(p))
    {
      if (is_pair(car(p)))
	{
	  if (!is_checked(car(p)))
	    optimize_expression(sc, p, hop, sc->w);
	}
    }

  return(false);
}


static s7_pointer find_uncomplicated_symbol(s7_scheme *sc, s7_pointer hdl, s7_pointer e)
{ 
  s7_pointer x;
  long long int id;

  if (memq(hdl, e))
    return(sc->NIL);

  if (is_global(hdl))
    return(symbol_global_slot(hdl));

  id = symbol_id(hdl);
  for (x = sc->envir; id < frame_id(x); x = cdr(x));
  for (; is_environment(x); x = cdr(x))
    {
      s7_pointer y;
      if (frame_id(x) == id)
	return(symbol_local_slot(hdl));

      for (y = car(x); is_pair(y); y = ecdr(y))
	if (car(y) == hdl)
	  return(y);
    }
  return(sc->NIL);
} 


static bool optimize_expression(s7_scheme *sc, s7_pointer x, int hop, s7_pointer e)
{
  s7_pointer y;
  set_checked(car(x));
  y = caar(x);

  /* fprintf(stderr, "optimize_expression %s\n     e: %s\n", DISPLAY(car(x)), DISPLAY(e)); */

  if (s7_is_symbol(y))
    {
      s7_pointer func;
      
      if (is_syntactic(y))
	return(optimize_syntax(sc, x, symbol_value(symbol_global_slot(y)), hop, e));

      func = find_uncomplicated_symbol(sc, y, e);
      if (is_not_null(func))
	func = symbol_value(func);
      else func = sc->F;

      if (is_syntax(func))
	return(optimize_syntax(sc, x, func, hop, e));

      /* we miss implicit indexing here because at this time, the data are not set */

      if ((is_procedure(func)) ||
	  (is_c_function(func)) ||
	  (is_safe_procedure(func))) /* built-in applicable objects like vectors */
	return(optimize_function(sc, x, func, hop, e));
      else                           /* caar(x) is a symbol but it's not a procedure or a "safe" case = vector etc */
	{
	  /* else it's something like a let variable binding: (sqrtfreq (sqrt frequency)) */
	  s7_pointer p;
	  int len = 0, pairs = 0, symbols = 0;
	  /* fprintf(stderr, "check out %s\n", s7_object_to_c_string(sc, cdar(x)));  */
	  for (p = cdar(x); is_pair(p); p = cdr(p), len++)
	    {
	      if (is_pair(car(p)))
		{
		  pairs++;
		  if (!is_checked(car(p)))
		    {
		      optimize_expression(sc, p, hop, e);
		    }
		}
	      else
		{
		  if (s7_is_symbol(car(p)))
		    symbols++;
		}
	    }

	  /* fprintf(stderr, "pairs: %d, symbols: %d, len: %d, is_optimized: %d\n", pairs, symbols, len, is_optimized(car(x))); */
	  /* (define (hi) (let ((v (vector 1 2 3)) (i 1)) (v i)))
	   * (define (ho v) (let ((i 1)) (v i))) (ho (vector 1 2 3)) (ho (list 1 22 3))
	   */
	  if ((is_null(p)) &&              /* (+ 1 . 2) */
	      (!is_optimized(car(x))))
	    {
	      if (pairs == 0)
		{
		  if (len == 1)
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      if (symbols == 1)
			set_optimize_data(car(x), OP_UNKNOWN_S);
		      else set_optimize_data(car(x), OP_UNKNOWN_C);
		      return(false); 
		    }
		  
		  if (len == 2)
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      if (symbols == 2)
			set_optimize_data(car(x), OP_UNKNOWN_SS);
		      else
			{
			  if (symbols == 0)
			    set_optimize_data(car(x), OP_UNKNOWN_CC);
			  else
			    {
			      if (s7_is_symbol(cadar(x)))
				set_optimize_data(car(x), OP_UNKNOWN_SC);
			      else set_optimize_data(car(x), OP_UNKNOWN_CS);
			    }
			}
		      return(false); 
		    }
		  
		  if ((len == 3) &&
		      (symbols == 3))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_UNKNOWN_SSS);
		      return(false); 
		    }
		}
	      else
		{
		  if ((pairs == 1) &&
		      (len == 1) &&
		      (is_optimized(cadar(x))) &&
		      (optimize_data_match(cadar(x), OP_SAFE_C_S)))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_UNKNOWN_opSq);
		      return(false); 
		    }
		  
		  if ((pairs == 1) &&
		      (len == 2) &&
		      (symbols == 1))
		    {
		      if ((is_pair(cadar(x))) &&
			  (is_optimized(cadar(x))) &&
			  (optimize_data_match(cadar(x), OP_SAFE_C_S)))
			{
			  set_optimized(car(x));
			  set_unsafe(car(x));
			  set_optimize_data(car(x), OP_UNKNOWN_opSq_S);
			  return(false); 
			}
		      if ((is_pair(caddar(x))) &&
			  (is_optimized(caddar(x))) &&
			  (optimize_data_match(caddar(x), OP_SAFE_C_S)))
			{
			  set_optimized(car(x));
			  set_unsafe(car(x));
			  set_optimize_data(car(x), OP_UNKNOWN_S_opSq);
			  return(false); 
			}
		    }
		  
		  
		  if ((pairs == 2) &&
		      (len == 2) &&
		      (is_optimized(cadar(x))) &&
		      (optimize_data_match(cadar(x), OP_SAFE_C_S)) &&
		      (is_optimized(caddar(x))) &&
		      (optimize_data_match(caddar(x), OP_SAFE_C_S)))
		    {
		      set_optimized(car(x));
		      set_unsafe(car(x));
		      set_optimize_data(car(x), OP_UNKNOWN_opSq_opSq);
		      return(false); 
		    }
		}
	    }
	}
    }
  else
    {
      /* caar(x) is not a symbol, but there might be interesting stuff here */
      /* (define (hi a) (case 1 ((1) (if (> a 2) a 2)))) */

      s7_pointer p;
      /* fprintf(stderr, "    check out %s\n", s7_object_to_c_string(sc, cdar(x))); */
      for (p = car(x); is_pair(p); p = cdr(p))
	{
	  if (is_pair(car(p)))
	    {
	      if (!is_checked(car(p)))
		{
		  optimize_expression(sc, p, hop, e);
		}
	    }
	}
    }
  return(false);
}


static bool optimize(s7_scheme *sc, s7_pointer code, int hop, s7_pointer e)
{
  s7_pointer x;
  bool happy = true;

  for (x = code; is_pair(x) && (!is_checked(x)); x = cdr(x))
    {
      /* fprintf(stderr, "optimize %s: %d %d\n", DISPLAY(x), is_checked(x), is_optimized(x));  */
      set_checked(x);
      if (is_pair(car(x)))
	{
	  bool opt;
	  opt = optimize_expression(sc, x, hop, e);
	  if (!opt) happy = false;
	}
      else
	{
	  if (!is_optimized(x))
	    happy = false;
	}
    }
  if (happy) set_optimized(code);
  return(happy);
}


static int combine_ops(s7_scheme *sc, int op1, s7_pointer e1, s7_pointer e2)
{
  int op2;
  op2 = optimize_data(e2) & 0xfffe;

  /* PERHAPS: make this an array, include closure choices here
   */
  switch (op1)
    {
    case SAFE_C_P:
      switch (op2)
	{
	case OP_SAFE_C_C: 
	  return(OP_SAFE_C_opCq); /* this includes the multi-arg C_C cases */

	case OP_SAFE_C_S: 
	  return(OP_SAFE_C_opSq);

	case OP_SAFE_C_Q: 
	  return(OP_SAFE_C_opQq);

	case OP_SAFE_C_SS: 
	  return(OP_SAFE_C_opSSq);

	case OP_SAFE_C_SQ: 
	  return(OP_SAFE_C_opSQq);

	case OP_SAFE_C_QS: 
	  return(OP_SAFE_C_opQSq);

	case OP_SAFE_C_SC: 
	  return(OP_SAFE_C_opSCq);

	case OP_SAFE_C_CS: 
	  return(OP_SAFE_C_opCSq);

	  /* CQ QQ QC */

	case OP_SAFE_C_XXX:
	  return(OP_SAFE_C_opXXXq);

	  /* safe_c_op_opCq_q
	   */

	default:
	  return(OP_SAFE_C_Z);
	  break;
	}
      break;
      

    case SAFE_C_SP:
      /* fprintf(stderr, "SP: e1: %s, e2: %s\n", DISPLAY(e1), DISPLAY(e2)); */
      switch (op2)
	{
	case OP_SAFE_C_S:
	  return(OP_SAFE_C_S_opSq);

	case OP_SAFE_C_C:
	  return(OP_SAFE_C_S_opCq);

	case OP_SAFE_C_SC:
	  return(OP_SAFE_C_S_opSCq);
	  
	case OP_SAFE_C_CS:
	  return(OP_SAFE_C_S_opCSq);

	case OP_SAFE_C_SS:
	  return(OP_SAFE_C_S_opSSq);

	default:
	  /* fprintf(stderr, "use s_z\n"); */
	  return(OP_SAFE_C_SZ);
	  break;
	}
      break;


    case SAFE_C_QP:
      return(OP_SAFE_C_QZ);

    case SAFE_C_PQ:
      return(OP_SAFE_C_ZQ);


    case SAFE_C_PS:
      /* fprintf(stderr, "PS: e1: %s, e2: %s\n", DISPLAY(e1), DISPLAY(e2));  */
      switch (op2)
	{
	case OP_SAFE_C_C:
	  return(OP_SAFE_C_opCq_S);

	case OP_SAFE_C_S:
	  return(OP_SAFE_C_opSq_S);
	  
	case OP_SAFE_C_CS:
	  return(OP_SAFE_C_opCSq_S);

	case OP_SAFE_C_SC:
	  return(OP_SAFE_C_opSCq_S);

	case OP_SAFE_C_SS:
	  return(OP_SAFE_C_opSSq_S);

	default:
	  /* fprintf(stderr, "use z_s\n"); */
	  return(OP_SAFE_C_ZS);
	  break;
	}
      break;


    case SAFE_C_PC:
      switch (op2)
	{
	case OP_SAFE_C_C:
	  return(OP_SAFE_C_opCq_C);

	case OP_SAFE_C_S:
	  return(OP_SAFE_C_opSq_C);

	case OP_SAFE_C_CS:
	  return(OP_SAFE_C_opCSq_C);

	case OP_SAFE_C_SS:
	  return(OP_SAFE_C_opSSq_C);

	case OP_SAFE_C_SC:
	  return(OP_SAFE_C_opSCq_C);

	default:
	  return(OP_SAFE_C_ZC);
	  break;
	}
      break;


    case SAFE_C_CP:
      /* fprintf(stderr, "e1: %s, e2: %s\n", DISPLAY(e1), DISPLAY(e2)); */
      switch (op2)
	{
	case OP_SAFE_C_C:
	  return(OP_SAFE_C_C_opCq);

	case OP_SAFE_C_S:
	  return(OP_SAFE_C_C_opSq);

	case OP_SAFE_C_CS:
	  return(OP_SAFE_C_C_opCSq);

	case OP_SAFE_C_SC:
	  return(OP_SAFE_C_C_opSCq);
	  
	case OP_SAFE_C_SS:
	  return(OP_SAFE_C_C_opSSq);

	default:
	  return(OP_SAFE_C_CZ);
	  break;
	}
      break;


    case SAFE_C_PP:
      /* fprintf(stderr, "e1: %s, e2: %s\n", DISPLAY(e1), DISPLAY(e2));  */
      switch (op2)
	{
	case OP_SAFE_C_S:
	  if (optimize_data_match(e1, OP_SAFE_C_S))
	    {
	      if (cadr(e1) == cadr(e2))
		return(OP_SAFE_C_opSq_opAq);
	      return(OP_SAFE_C_opSq_opSq);
	    }
	  break;

	case OP_SAFE_C_C:
	  if (optimize_data_match(e1, OP_SAFE_C_C))
	    return(OP_SAFE_C_opCq_opCq);
	  break;

	case OP_SAFE_C_SC:
	  if (optimize_data_match(e1, OP_SAFE_C_SC))
	    {
	      if (cadr(e1) == cadr(e2))
		return(OP_SAFE_C_opSCq_opACq);
	      return(OP_SAFE_C_opSCq_opSCq);
	    }
	  break;

	case OP_SAFE_C_SS:
	  if (optimize_data_match(e1, OP_SAFE_C_SS))
	    return(OP_SAFE_C_opSSq_opSSq);
	  break;

	default:
	  return(OP_SAFE_C_ZZ);
	  break;
	}
      break;


    default:
      break;
    }
  return(op1);
}


static bool sequence_is_safe_for_opteval(s7_scheme *sc, s7_pointer body)
{
  s7_pointer p;
  for (p = body; is_pair(p); p = cdr(p))
    {
      s7_pointer expr, x;
      expr = car(p);
      
      /* only pairs have the optimized bit set
	if ((!is_pair(expr)) || 
	  (!is_optimized(expr)))
	return(false);
      */
      if (!is_optimized(expr))
	return(false);

      /* we're checking twice in some cases, but the 2nd (later) check can't be
       *   omitted, (by using is_checked), because the function might 
       *   have been redefined since the initial check.  
       */
      if ((optimize_data(expr) & 1) != 1)
	{
	  switch (optimize_data(expr))
	    {
	    case OP_VECTOR_C:
	    case OP_VECTOR_S:
	    case OP_STRING_C:
	    case OP_STRING_S:
	    case OP_PAIR_C:
	    case OP_PAIR_S:
	    case OP_HASH_TABLE_C:
	    case OP_HASH_TABLE_S:
	    case OP_C_OBJECT_C:
	    case OP_C_OBJECT_S:
	      break;
	      
	      
	    case OP_SAFE_C_C: 
	    case OP_SAFE_C_S: 
	    case OP_SAFE_C_Q:
	    case OP_SAFE_C_CQ:
	    case OP_SAFE_C_QC:
	    case OP_SAFE_C_SS:
	    case OP_SAFE_C_SC:
	    case OP_SAFE_C_CS:
	    case OP_SAFE_C_SQ:
	    case OP_SAFE_C_QS:
	    case OP_SAFE_C_QQ:
	    case OP_SAFE_C_XXX:
	    case OP_SAFE_C_SSS:
	    case OP_SAFE_C_ALL_S:
	    case OP_SAFE_C_ALL_G:
	    case OP_SAFE_DO_C_S:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      break;
	      
	      
	    case OP_SAFE_C_opCq:
	    case OP_SAFE_C_opQq: 
	    case OP_SAFE_C_opSq: 
	    case OP_SAFE_C_opSSq:
	    case OP_SAFE_C_opSCq:
	    case OP_SAFE_C_opSQq:
	    case OP_SAFE_C_opQSq:
	    case OP_SAFE_C_opCSq:
	    case OP_SAFE_C_opCq_S:
	    case OP_SAFE_C_opSq_S:
	    case OP_SAFE_C_opCq_C:
	    case OP_SAFE_C_opSq_C:
	    case OP_SAFE_C_opCSq_C:
	    case OP_SAFE_C_opSSq_C:
	    case OP_SAFE_C_opSCq_S:
	    case OP_SAFE_C_opSCq_C:
	    case OP_SAFE_C_opCSq_S:
	    case OP_SAFE_C_opSSq_S:
	    case OP_SAFE_C_opXXXq:
	    case OP_SAFE_C_Z:
	    case OP_SAFE_C_ZS:
	    case OP_SAFE_C_ZC:
	    case OP_SAFE_C_ZQ:
	    case OP_SAFE_C_ZXX:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(cadr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadr(expr))) return(false);
	      break;
	      
	      
	    case OP_SAFE_C_C_opSq:
	    case OP_SAFE_C_C_opCq:
	    case OP_SAFE_C_C_opCSq:
	    case OP_SAFE_C_C_opSSq:
	    case OP_SAFE_C_S_opSq:
	    case OP_SAFE_C_S_opCq:
	    case OP_SAFE_C_S_opSCq:
	    case OP_SAFE_C_C_opSCq:
	    case OP_SAFE_C_S_opSSq:
	    case OP_SAFE_C_S_opCSq:
	    case OP_SAFE_C_SZ:
	    case OP_SAFE_C_CZ:
	    case OP_SAFE_C_QZ:
	    case OP_SAFE_C_XZX:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(caddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(caddr(expr))) return(false);
	      break;
	      
	      
	    case OP_SAFE_C_opCq_opCq:
	    case OP_SAFE_C_opSq_opSq:
	    case OP_SAFE_C_opSq_opAq:
	    case OP_SAFE_C_opSCq_opSCq:
	    case OP_SAFE_C_opSCq_opACq:
	    case OP_SAFE_C_opSSq_opSSq:
	    case OP_SAFE_C_ZZ:
	    case OP_SAFE_C_ZZX:
	      /* (op (op S) (op S)) */
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(cadr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadr(expr))) return(false);
	      x = SYMBOL_VALUE(car(caddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(caddr(expr))) return(false);
	      break;

	    case OP_SAFE_C_XXZ:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(cadddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadddr(expr))) return(false);
	      break;

	    case OP_SAFE_C_XZZ:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(caddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(caddr(expr))) return(false);
	      x = SYMBOL_VALUE(car(cadddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadddr(expr))) return(false);
	      break;

	    case OP_SAFE_C_ZXZ:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(cadr(expr)), find_symbol_or_bust_10);
	      if (ecdr(cadr(expr)) != x) return(false);
	      x = SYMBOL_VALUE(car(cadddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadddr(expr))) return(false);
	      break;

	    case OP_SAFE_C_ZZZ:
	      x = SYMBOL_VALUE(car(expr), find_symbol_or_bust_10);
	      if (ecdr(expr) != x) return(false);
	      x = SYMBOL_VALUE(car(cadr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadr(expr))) return(false);
	      x = SYMBOL_VALUE(car(caddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(caddr(expr))) return(false);
	      x = SYMBOL_VALUE(car(cadddr(expr)), find_symbol_or_bust_10);
	      if (x != ecdr(cadddr(expr))) return(false);
	      break;
	      
	    default:
	      return(false);
	    }
	}
    }
  return(true);
}


static bool form_is_safe(s7_scheme *sc, s7_pointer x)
{
  if (is_syntactic(car(x)))
    {
      /* here we can't depend on the syntax settings */
      if (syntax_opcode(car(x)) < OP_SAFE_AND)
	{
	  switch (syntax_opcode(car(x)))
	    {
	      /* TODO: finish this checker */
	    case OP_OR:
	    case OP_AND:
	    case OP_BEGIN:
	      if (!body_is_safe(sc, cdr(x)))
		return(false);
	      break;
	      
	    case OP_QUOTE:
	      break;
	      
	    case OP_LET:
	      if (s7_is_symbol(cadr(x)))
		return(false);
	      /* fall through */
	      
	    case OP_LET_STAR:
	    case OP_LETREC:
	      if (!body_is_safe(sc, cddr(x)))
		return(false);
	      if (is_pair(cadr(x)))
		{
		  s7_pointer vars;
		  for (vars = cadr(x); is_pair(vars); vars = cdr(vars))
		    if ((is_pair(cadr(vars))) &&
			(!form_is_safe(sc, cadr(vars))))
		      return(false);
		}
	      break;
	      
	    case OP_IF:
	      if (((is_pair(cadr(x))) && (!form_is_safe(sc, cadr(x)))) ||
		  ((is_pair(caddr(x))) && (!form_is_safe(sc, caddr(x)))) ||
		  ((is_pair(cadddr(x))) && (!form_is_safe(sc, cadddr(x)))))
		return(false);
	      break;

	    case OP_COND:
	      {
		s7_pointer p;
		for (p = cdr(x); is_pair(p); p = cdr(p))
		  {
		    s7_pointer expr;
		    expr = car(p);
		    if ((is_pair(expr)) && (is_pair(car(expr))) && (!form_is_safe(sc, car(expr))))
		      return(false);
		    if ((is_not_null(cdr(expr))) && (!body_is_safe(sc, cdr(expr))))
		      return(false);
		  }
		if (is_not_null(p)) return(false);
	      }
	      break;

	    case OP_CASE:
	      {
		s7_pointer p;
		if ((is_pair(cadr(x))) && (!form_is_safe(sc, cadr(x)))) return(false);
		for (p = cddr(x); is_pair(p); p = cdr(p))
		  {
		    if ((is_pair(car(p))) && (!body_is_safe(sc, cdar(p))))
		      return(false);
		  }
	      }
	      break;

#if 0
	    case OP_DO:
	      {
		
	      }
#endif
	      
	    case OP_SET:
	      return(false);

	    default:
	      return(false);
	    }
	}
    }
  else
    {
      if ((!is_optimized(x)) || 
	  (is_unsafe(x)))
	return(false);
    }
  return(true);
}


static bool body_is_safe(s7_scheme *sc, s7_pointer body)
{
  s7_pointer p;
  /*
  fprintf(stderr, "safe: %d, body: %s\n", is_safe_closure(body), DISPLAY_80(body));
  if (is_safe_closure(body))
    return(true);
  */

  for (p = body; is_pair(p); p = cdr(p))
    {
      if ((is_pair(car(p))) &&
	  (!form_is_safe(sc, car(p))))
	return(false);
    }
  return(true);
}
#else

void s7_unoptimize(s7_scheme *sc, s7_pointer code)
{
}


static s7_pointer g_unoptimize(s7_scheme *sc, s7_pointer args)
{
  #define H_unoptimize "(unoptimize code) erases all the optimizer info in code"
  return(car(args));
}

#endif


/* ---------------------------------------- error checks ---------------------------------------- */

static s7_pointer check_lambda_args(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_list(sc, args))
    {
      if (s7_is_constant(args))                       /* (lambda :a ...) */
	return(eval_error(sc, "lambda parameter '~S is a constant", args)); /* not ~A here, (lambda #\null do) for example */
      
      /* we currently accept (lambda i i . i) (lambda quote i)  (lambda : : . #()) (lambda : 1 . "")
       *   at this level, but when the lambda form is evaluated, it will trigger an error.
       */
      if (s7_is_symbol(args))
	set_local(args);
    }
  else
    {
      s7_pointer x;
      for (x = args; is_pair(x); x = cdr(x))
	{
	  if (s7_is_constant(car(x)))                      /* (lambda (pi) pi) */
	    return(eval_error(sc, "lambda parameter '~S is a constant", car(x)));

	  if (symbol_is_in_list(car(x), cdr(x)))       /* (lambda (a a) ...) or (lambda (a . a) ...) */
	    return(eval_error(sc, "lambda parameter '~S is used twice in the parameter list", car(x)));
	  set_local(car(x));
	}
      if ((is_not_null(x)) &&
	  (s7_is_constant(x)))                             /* (lambda (a . 0.0) a) or (lambda (a . :b) a) */
	return(eval_error(sc, "lambda :rest parameter '~A is a constant", x));
    }
  return(sc->F);
}


static s7_pointer check_lambda_star_args(s7_scheme *sc, s7_pointer args)
{
  if (!s7_is_list(sc, args))
    {
      if (s7_is_constant(args))                                  /* (lambda* :a ...) */
	return(eval_error(sc, "lambda* parameter '~A is a constant", args));
      if (s7_is_symbol(args))
	set_local(args);
    }
  else
    { 
      s7_pointer w;
      for (w = args; is_pair(w); w = cdr(w))
	{
	  if (is_pair(car(w)))
	    {
	      if (s7_is_constant(caar(w)))                            /* (lambda* ((:a 1)) ...) */
		return(eval_error(sc, "lambda* parameter '~A is a constant", caar(w)));
	      if (symbol_is_in_list(caar(w), cdr(w)))             /* (lambda* ((a 1) a) ...) */
		return(eval_error(sc, "lambda* parameter '~A is used twice in the argument list", caar(w)));

	      if (!is_pair(cdar(w)))                                  /* (lambda* ((a . 0.0)) a) */
		{
		  if (is_null(cdar(w)))                             /* (lambda* ((a)) ...) */
		    return(eval_error(sc, "lambda* parameter default value missing? '~A", car(w)));
		  return(eval_error(sc, "lambda* parameter is a dotted pair? '~A", car(w)));
		}
	      if (is_not_null(cddar(w)))                               /* (lambda* ((a 0.0 "hi")) a) */
		return(eval_error(sc, "lambda* parameter has multiple default values? '~A", car(w)));

	      set_local(caar(w));
	    }
	  else 
	    {
	      if (car(w) != sc->KEY_REST)
		{
		  if ((s7_is_constant(car(w))) &&
		      (car(w) != sc->KEY_KEY) &&
		      (car(w) != sc->KEY_OPTIONAL) &&
		      (car(w) != sc->KEY_ALLOW_OTHER_KEYS))           /* (lambda* (pi) ...) */
		    return(eval_error(sc, "lambda* parameter '~A is a constant", car(w)));

		  if (symbol_is_in_list(car(w), cdr(w)))          /* (lambda* (a a) ...) or (lambda* (a . a) ...) */
		    return(eval_error(sc, "lambda* parameter '~A is used twice in the argument list", car(w)));

		  if ((car(w) == sc->KEY_ALLOW_OTHER_KEYS) &&         /* (lambda* (:allow-other-keys x) x) */
		      (is_not_null(cdr(w))))
		    eval_error(sc, ":allow-other-keys should be the last parameter: ~A", args);

		  if (!is_keyword(car(w))) set_local(car(w));
		}
	      else
		{
		  if (!is_pair(cdr(w)))                               /* (lambda* (:rest) ...) */
		    return(eval_error(sc, "lambda* :rest parameter missing? ~A", w));
		  if (!s7_is_symbol(cadr(w)))                         /* (lambda* (:rest (a 1)) ...) */
		    {
		      if (!is_pair(cadr(w)))                          /* (lambda* (:rest 1) ...) */
			return(eval_error(sc, "lambda* :rest parameter is not a symbol? ~A", w));
		      return(eval_error(sc, "lambda* :rest parameter can't have a default value. ~A", w));
		    }
		  else
		    {
		      if (is_immutable(cadr(w)))
			return(s7_error(sc, sc->WRONG_TYPE_ARG,
					list_2(sc, make_protected_string(sc, "can't bind an immutable object: ~S"), w)));
		    }
		  set_local(cadr(w));
		}
	    }
	}
      if (is_not_null(w))
	{
	  if (s7_is_constant(w))                             /* (lambda* (a . 0.0) a) or (lambda* (a . :b) a) */
	    return(eval_error(sc, "lambda* :rest parameter '~A is a constant", w));
	  if (s7_is_symbol(w))
	    set_local(w);
	}
    }
  return(sc->F);
}


static s7_pointer check_case(s7_scheme *sc)
{
  s7_pointer x, y;
  if (!is_pair(sc->code))                                            /* (case) or (case . 1) */
    return(eval_error(sc, "case has no selector:  ~A", sc->code));
  if (!is_pair(cdr(sc->code)))                                       /* (case 1) or (case 1 . 1) */
    return(eval_error(sc, "case has no clauses?:  ~A", sc->code));
  if (!is_pair(cadr(sc->code)))                                      /* (case 1 1) */
    return(eval_error(sc, "case clause is not a list? ~A", sc->code));
  
  for (x = cdr(sc->code); is_not_null(x); x = cdr(x)) 
    {
      if ((!is_pair(x)) ||                                        /* (case 1 ((2) 1) . 1) */
	  (!is_pair(car(x))))
	return(eval_error(sc, "case clause ~A messed up", x));	 
      if (!is_pair(cdar(x)))                                      /* (case 1 ((1))) */
	return(eval_error(sc, "case clause result missing: ~A", car(x)));
      
      y = caar(x);
      if (!is_pair(y))
	{
	  if ((y != sc->ELSE) &&                                  /* (case 1 (2 1)) */
	      ((!s7_is_symbol(y)) ||
	       (s7_symbol_value(sc, y) != sc->ELSE)))             /* "proper list" below because: (case 1 (() 2) ... */
	    return(eval_error(sc, "case clause key list ~A is not a proper list or 'else'", y));
	  if (is_not_null(cdr(x)))                                  /* (case 1 (else 1) ((2) 1)) */
	    return(eval_error(sc, "case 'else' clause, ~A, is not the last clause", x));
	}
      else
	{
	  /* what about (case 1 ((1) #t) ((1) #f)) [this is ok by guile]
	   *            (case 1 ((1) #t) ())
	   *            (case 1 ((2 2 2) 1)): guile says #<unspecified>
	   */
	  
	  /* the selector (sc->value) is evaluated, but the search key is not
	   *    (case '2 ((2) 3) (else 1)) -> 3
	   *    (case '2 (('2) 3) (else 1)) -> 1
	   */
	  
	  for (y = cdr(y); is_not_null(y); y = cdr(y)) 
	    if (!is_pair(y))                                        /* (case () ((1 . 2) . hi) . hi) */
	      return(eval_error(sc, "case key list is improper? ~A", x));
	}

      y = car(x);
      if ((cadr(y) == sc->FEED_TO) &&
	  (s7_symbol_value(sc, sc->FEED_TO) == sc->UNDEFINED))
	{
	  if (!is_pair(cddr(y)))                                  /* (case 1 (else =>)) */
	    return(eval_error(sc, "case: '=>' target missing?  ~A", y));
	  if (is_pair(cdddr(y)))                                  /* (case 1 (else => + - *)) */
	    return(eval_error(sc, "case: '=>' has too many targets: ~A", y));
	}
    }

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (is_pair(car(sc->code)))
	car(ecdr(sc->code)) = sc->CASE_PAIR;
      else car(ecdr(sc->code)) = sc->CASE_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_let(s7_scheme *sc)
{
  s7_pointer x;
  bool named_let;

  if (!is_pair(sc->code))               /* (let . 1) */
    return(eval_error(sc, "let form is an improper list? ~A", sc->code));
  
  if (!is_pair(cdr(sc->code)))          /* (let () ) */
    {
      if (is_null(cdr(sc->code)))         /* (let) */
	return(eval_error(sc, "let has no variables or body: ~A", sc->code));
      return(eval_error(sc, "let has no body: ~A", sc->code));
    }
  if ((!s7_is_list(sc, car(sc->code))) && /* (let 1 ...) */
      (!s7_is_symbol(car(sc->code))))
    return(eval_error(sc, "let variable list is messed up or missing: ~A", sc->code));
  
  /* we accept these (other schemes complain, but I can't see why -- a no-op is the user's business!):
   *   (let () (define (hi) (+ 1 2)))
   *   (let () (begin (define x 3)))
   *   (let () 3 (begin (define x 3)))
   *   (let () (define x 3))
   *   (let () (if #t (define (x) 3)))
   *
   * similar cases:
   *   (case 0 ((0) (define (x) 3) (x)))
   *   (cond (0 (define (x) 3) (x)))
   *   (and (define (x) x) 1)
   *   (begin (define (x y) y) (x (define (x y) y)))
   *   (if (define (x) 1) 2 3)
   *   (do () ((define (x) 1) (define (y) 2)))
   *
   * but we can get some humorous results: 
   *   (let ((x (lambda () 3))) (if (define (x) 4) (x) 0)) -> 4
   */
  
  named_let = (s7_is_symbol(car(sc->code)));

  if (named_let)
    {
      if ((!s7_is_list(sc, cadr(sc->code))) ||  /* (let hi #t) */
	  (is_null(cddr(sc->code))))           /* (let hi ()) */
	return(eval_error(sc, "named let variable list is messed up or missing: ~A", sc->code));

      if (is_immutable(car(sc->code)))
	return(s7_error(sc, sc->WRONG_TYPE_ARG,
			list_2(sc, make_protected_string(sc, "can't bind an immutable object: ~S"), sc->code)));
      set_local(car(sc->code));
    }
  
  for (x = ((named_let) ? cadr(sc->code) : car(sc->code)); is_pair(x); x = cdr(x))
    {
      s7_pointer y, carx;
      
      carx = car(x);
      
      if (!is_pair(carx))                /* (let ((x)) ...) or (let ((x 1) . (y 2)) ...) */
	return(eval_error(sc, "let variable declaration, but no value?: ~A", x));
      
      if (!(is_pair(cdr(carx))))         /* (let ((x . 1))...) */
	return(eval_error(sc, "let variable declaration is not a proper list?: ~A", x));
      
      if (is_not_null(cddr(carx)))       /* (let ((x 1 2 3)) ...) */
	return(eval_error(sc, "let variable declaration has more than one value?: ~A", x));
      
      /* currently if the extra value involves a read error, we get a kind of panicky-looking message:
       *   (let ((x . 2 . 3)) x)
       *   ;let variable declaration has more than one value?: (x error error "stray dot?: ...  ((x . 2 . 3)) x) ..")
       */
      
      if (!(s7_is_symbol(car(carx))))
	return(eval_error(sc, "bad variable ~S in let bindings", carx));
      
      if (is_immutable(car(carx)))
	return(s7_error(sc, sc->WRONG_TYPE_ARG,
			list_2(sc, make_protected_string(sc, "can't bind an immutable object: ~S"), x)));

      /* check for name collisions -- not sure this is required by Scheme */
      for (y = s7_is_symbol(car(sc->code)) ? cadr(sc->code) : car(sc->code); y != x; y = cdr(y))
	if (car(carx) == caar(y))
	  return(eval_error(sc, "duplicate identifier in let: ~A", carx));

      set_local(car(carx));
    }
  
  /* we accept (let ((:hi 1)) :hi)
   *           (let ('1) quote) [guile accepts this]
   */
  
  if (is_not_null(x))                  /* (let* ((a 1) . b) a) */
    return(eval_error(sc, "let var list improper?: ~A", sc->code));

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (named_let)
	{
	  if (is_null(cadr(sc->code)))
	    car(ecdr(sc->code)) = sc->NAMED_LET_NO_VARS;
	  else car(ecdr(sc->code)) = sc->NAMED_LET;
	}
      else
	{
	  if (is_null(car(sc->code)))
	    car(ecdr(sc->code)) = sc->LET_NO_VARS;
	  else car(ecdr(sc->code)) = sc->LET_UNCHECKED;
	}
    }

  return(sc->code);
}


static s7_pointer check_let_star(s7_scheme *sc)
{
  s7_pointer y;
  if (!is_pair(sc->code))                    /* (let* . 1) */
    return(eval_error(sc, "let* variable list is messed up: ~A", sc->code));
  
  if ((!is_pair(cdr(sc->code))) ||           /* (let*) */
      (!s7_is_list(sc, car(sc->code))))      /* (let* 1 ...), also there's no named let* */
    {
      if (s7_is_symbol(car(sc->code)))
	return(eval_error(sc, "there is no named let*: ~A", sc->code));
      return(eval_error(sc, "let* variable list is messed up: ~A", sc->code));
    }
  
  if ((!is_null(car(sc->code))) &&
      ((!is_pair(car(sc->code))) ||            /* (let* x ... ) */
       (!is_pair(caar(sc->code))) ||           /* (let* (x) ...) */
       (!is_pair(cdaar(sc->code)))))            /* (let* ((x . 1)) ...) */
    return(eval_error(sc, "let* variable declaration value is missing: ~A", sc->code));
  
  for (y = car(sc->code); is_pair(y); y = cdr(y))
    {
      s7_pointer x, z;
      x = car(y);
      if (!(s7_is_symbol(car(x))))     /* (let* ((3 1)) 1) */
	return(eval_error(sc, "bad variable ~S in let* bindings", x));

      z = car(x);
      if (is_immutable(z))
	return(s7_error(sc, sc->WRONG_TYPE_ARG,
			list_2(sc, make_protected_string(sc, "can't bind an immutable object: ~S"), x)));

      if (!is_pair(x))                 /* (let* ((x)) ...) */
	return(eval_error(sc, "let* variable declaration, but no value?: ~A", x));
      
      if (!(is_pair(cdr(x))))          /* (let* ((x . 1))...) */
	return(eval_error(sc, "let* variable declaration is not a proper list?: ~A", x));
      
      if (is_not_null(cddr(x)))        /* (let* ((x 1 2 3)) ...) */
	return(eval_error(sc, "let* variable declaration has more than one value?: ~A", x));
      
      x = cdr(y);
      if (is_pair(x)) 
	{ 
	  if (!is_pair(car(x)))             /* (let* ((x -1) 2) 3) */
	    return(eval_error(sc, "let* variable/binding is ~S?", car(x)));
	  
	  if (!is_pair(cdar(x)))            /* (let* ((a 1) (b . 2)) ...) */
	    return(eval_error(sc, "let* variable list is messed up? ~A", x));
	}
      else
	{
	  if (is_not_null(x))               /* (let* ((a 1) . b) a) */
	    return(eval_error(sc, "let* var list improper?: ~A", x));
	}
      set_local(z);
    }

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      car(ecdr(sc->code)) = sc->LET_STAR_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_letrec(s7_scheme *sc)
{
  s7_pointer x;
  if ((!is_pair(sc->code)) ||                 /* (letrec . 1) */
      (!is_pair(cdr(sc->code))) ||            /* (letrec) */
      (!s7_is_list(sc, car(sc->code))))       /* (letrec 1 ...) */
    return(eval_error(sc, "letrec variable list is messed up: ~A", sc->code));
  
  for (x = car(sc->code); is_not_null(x); x = cdr(x))
    {
      if (!is_pair(x))                    /* (letrec ((a 1) . 2) ...) */
	return(eval_error(sc, "improper list of letrec variables? ~A", sc->code));
      
      if ((!is_pair(car(x))) ||           /* (letrec (1 2) #t) */
	  (!(s7_is_symbol(caar(x)))))
	return(eval_error(sc, "bad variable ~S in letrec bindings", car(x)));
      
      if (is_immutable(caar(x)))
	return(s7_error(sc, sc->WRONG_TYPE_ARG,
			list_2(sc, make_protected_string(sc, "can't bind an immutable object: ~S"), x)));

      if (!is_pair(cdar(x)))              /* (letrec ((x . 1))...) */
	{
	  if (is_null(cdar(x)))               /* (letrec ((x)) x) -- perhaps this is legal? */
	    return(eval_error(sc, "letrec variable declaration has no value?: ~A", car(x)));
	  return(eval_error(sc, "letrec variable declaration is not a proper list?: ~A", car(x)));
	}
      if (is_not_null(cddar(x)))          /* (letrec ((x 1 2 3)) ...) */
	return(eval_error(sc, "letrec variable declaration has more than one value?: ~A", car(x)));

      set_local(caar(x));
    }

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      car(ecdr(sc->code)) = sc->LETREC_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_quote(s7_scheme *sc)
{
  if (!is_pair(sc->code))                    /* (quote . -1) */
    {
      if (is_null(sc->code))
	return(eval_error(sc, "quote: not enough arguments: ~A", sc->code));
      return(eval_error(sc, "quote: stray dot?: ~A", sc->code));
    }
  if (is_not_null(cdr(sc->code)))             /* (quote . (1 2)) or (quote 1 1) */
    return(eval_error(sc, "quote: too many arguments ~A", sc->code));

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      car(ecdr(sc->code)) = sc->QUOTE_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_and(s7_scheme *sc)
{
  s7_pointer p;
  bool all_pairs;

  all_pairs = is_pair(sc->code);
  for (p = sc->code; is_pair(p); p = cdr(p))
    {
      if (!is_pair(car(p)))
	all_pairs = false;
    }

  if (is_not_null(p))                                    /* (and . 1) (and #t . 1) */
    return(eval_error(sc, "and: stray dot?: ~A", sc->code));
  
  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (all_pairs)
	{
#if WITH_OPTIMIZATION
  	  if (sequence_is_safe_for_opteval(sc, sc->code))
 	    {
 	      p = sc->code;
 	      if (optimize_data_match(car(p), OP_SAFE_C_S))
		{
		  bool opt = true;
		  s7_pointer sym;
		  sym = cadar(p);
		  for (p = cdr(sc->code); is_pair(p); p = cdr(p))
		    if ((!optimize_data_match(car(p), OP_SAFE_C_S)) ||
			(sym != cadar(p)))
		      {
			opt = false;
			break;
		      }
		  if (opt)
		    car(ecdr(sc->code)) = sc->SAFE_AND_S;
		  else car(ecdr(sc->code)) = sc->SAFE_AND;
		}
	      else car(ecdr(sc->code)) = sc->SAFE_AND;
 	    }
  	  else
#endif
	    car(ecdr(sc->code)) = sc->AND_P;
	}
      else car(ecdr(sc->code)) = sc->AND_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_or(s7_scheme *sc)
{
  s7_pointer p;
  bool all_pairs;

  all_pairs = is_pair(sc->code);
  for (p = sc->code; is_pair(p); p = cdr(p))
    {
      if (!is_pair(car(p)))
	all_pairs = false;
    }

  if (is_not_null(p))
    return(eval_error(sc, "or: stray dot?: ~A", sc->code));
  
  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (all_pairs)
	{
#if WITH_OPTIMIZATION
  	  if (sequence_is_safe_for_opteval(sc, sc->code))
 	    {
 	      p = sc->code;
 	      if (optimize_data_match(car(p), OP_SAFE_C_S))
		{
		  bool opt = true;
		  s7_pointer sym;
		  sym = cadar(p);
		  for (p = cdr(sc->code); is_pair(p); p = cdr(p))
		    if ((!optimize_data_match(car(p), OP_SAFE_C_S)) ||
			(sym != cadar(p)))
		      {
			opt = false;
			break;
		      }
		  if (opt)
		    car(ecdr(sc->code)) = sc->SAFE_OR_S;
		  else car(ecdr(sc->code)) = sc->SAFE_OR;
		}
	      else car(ecdr(sc->code)) = sc->SAFE_OR;
 	    }
  	  else
#endif
	    car(ecdr(sc->code)) = sc->OR_P;
	}
      else car(ecdr(sc->code)) = sc->OR_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_if(s7_scheme *sc)
{
  s7_pointer cdr_code;

  if (!is_pair(sc->code))                               /* (if) or (if . 1) */
    return(eval_error(sc, "(if): if needs at least 2 expressions: ~A", sc->code));
  
  cdr_code = cdr(sc->code);
  if (!is_pair(cdr_code))                          /* (if 1) */
    return(eval_error(sc, "(if ~A): if needs another clause", car(sc->code)));
  
  if (is_pair(cdr(cdr_code)))
    {
      if (is_not_null(cddr(cdr_code)))                   /* (if 1 2 3 4) */
	return(eval_error(sc, "too many clauses for if: ~A", sc->code));
    }
  else
    {
      if (is_not_null(cdr(cdr_code)))                    /* (if 1 2 . 3) */
	return(eval_error(sc, "if: ~A has improper list?", sc->code));
    }

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      s7_pointer test, t, f;

      test = car(sc->code);
      t = car(cdr_code);
      if (is_pair(cdr(cdr_code)))
	f = cadr(cdr_code);
      else f = sc->UNSPECIFIED;

      if (is_pair(test))
	{
	  if (is_pair(t))
	    {
	      if (is_pair(f))
		{
#if WITH_OPTIMIZATION
 		  if ((is_optimized(test)) &&
  		      (is_optimized(t)) &&
  		      (is_optimized(f)))
 		    car(ecdr(sc->code)) = sc->SAFE_IF2;
  		  else 
#endif
		  car(ecdr(sc->code)) = sc->IF_P_P_P;
		}
	      else 
		{
		  if (is_null(cdr(cdr_code)))
		    {
#if WITH_OPTIMIZATION
		      if ((is_optimized(test)) &&
			  (is_optimized(t)))
			car(ecdr(sc->code)) = sc->SAFE_IF1;
		      else 
#endif
		      car(ecdr(sc->code)) = sc->IF_P_P;
		    }
		  else car(ecdr(sc->code)) = sc->IF_P_P_X;
		}
	    }
	  else 
	    {

	      if (is_pair(f))
		car(ecdr(sc->code)) = sc->IF_P_X_P;
	      else 
		{

		  if (is_null(cdr(cdr_code)))
		    car(ecdr(sc->code)) = sc->IF_P_X;
		  else car(ecdr(sc->code)) = sc->IF_P_X_X;
		}
	    }
	}
      else /* test is symbol or constant */
	{
	  if (is_pair(t))
	    {
	      if (is_pair(f))
		car(ecdr(sc->code)) = sc->IF_X_P_P;
	      else 
		{
		  if (is_null(cdr(cdr_code)))
		    car(ecdr(sc->code)) = sc->IF_X_P;
		  else car(ecdr(sc->code)) = sc->IF_X_P_X;
		}
	    }
	  else 
	    {
	      if (is_pair(f))
		car(ecdr(sc->code)) = sc->IF_X_X_P;
	      else 
		{
		  if (is_null(cdr(cdr_code)))
		    car(ecdr(sc->code)) = sc->IF_X_X;
		  else car(ecdr(sc->code)) = sc->IF_X_X_X;
		}
	    }
	}
    }

  return(sc->code);
}


static s7_pointer check_define(s7_scheme *sc)
{
  s7_pointer x;
  if (!is_pair(sc->code))
    return(eval_error_with_name(sc, "~A: nothing to define? ~A", sc->code));   /* (define) */
  
  if (!is_pair(cdr(sc->code)))
    return(eval_error_with_name(sc, "~A: no value? ~A", sc->code));            /* (define var) */
  
  if (!is_pair(car(sc->code)))
    {
      if (is_not_null(cddr(sc->code)))                                           /* (define var 1 . 2) */
	return(eval_error_with_name(sc, "~A: more than 1 value? ~A", sc->code)); /* (define var 1 2) */
      if (sc->op == OP_DEFINE_STAR)
	return(eval_error(sc, "define* is restricted to functions: (define* ~{~S~^ ~})", sc->code));
      
      x = car(sc->code);
      if (!s7_is_symbol(x))                                             /* (define 3 a) */
	return(eval_error_with_name(sc, "~A: define a non-symbol? ~S", x));
      if (is_keyword(x))                                                /* (define :hi 1) */
	return(eval_error_with_name(sc, "~A ~A: keywords are constants", x));
      if (is_syntactic(x))                                              /* (define and a) */
	return(eval_error_with_name(sc, "~A ~A: syntactic keywords tend to behave badly if redefined", x));
    }
  else
    {
      x = caar(sc->code);
      if (!s7_is_symbol(x))                                             /* (define (3 a) a) */
	return(eval_error_with_name(sc, "~A: define a non-symbol? ~S", x));
      if (is_syntactic(x))                                              /* (define (and a) a) */
	return(eval_error_with_name(sc, "~A ~A: syntactic keywords tend to behave badly if redefined", x));
      
      if (sc->op == OP_DEFINE_STAR)
	check_lambda_star_args(sc, cdar(sc->code));
      else check_lambda_args(sc, cdar(sc->code));

#if WITH_OPTIMIZATION
      optimize(sc, cdr(sc->code), 1, collect_collisions(sc, cdar(sc->code), sc->NIL));

      /* if the body is safe, we can optimize the calling sequence */
      if ((body_is_safe(sc, cdr(sc->code))) &&
	  (is_proper_list(sc, cdar(sc->code))) &&
	  (sc->op == OP_DEFINE))
	{
	  /* fprintf(stderr, "safe: %s\n", DISPLAY_80(sc->code)); */
	  set_safe_closure(cdr(sc->code));
	}
#endif
    }

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (sc->op == OP_DEFINE)
	car(ecdr(sc->code)) = sc->DEFINE_UNCHECKED;
      else car(ecdr(sc->code)) = sc->DEFINE_STAR_UNCHECKED;
    }

  return(sc->code);
}


static s7_pointer check_set(s7_scheme *sc)
{
  if (!is_pair(sc->code))
    {
      if (is_null(sc->code))                                             /* (set!) */
	return(eval_error(sc, "set!: not enough arguments: ~A", sc->code));
      return(eval_error(sc, "set!: stray dot? ~A", sc->code));           /* (set! . 1) */
    }
  if (!is_pair(cdr(sc->code)))                                
    {
      if (is_null(cdr(sc->code)))                                         /* (set! var) */
	return(eval_error(sc, "set!: not enough arguments: ~A", sc->code));
      return(eval_error(sc, "set!: stray dot? ~A", sc->code));           /* (set! var . 1) */
    }
  if (is_not_null(cddr(sc->code)))                                       /* (set! var 1 2) */
    return(eval_error(sc, "~A: too many arguments to set!", sc->code));
  
  /* cadr (the value) has not yet been evaluated */
  
  if (is_immutable(car(sc->code)))                                       /* (set! pi 3) */
    return(eval_error(sc, "set!: can't alter immutable object: ~S", car(sc->code)));
  
  if (is_pair(car(sc->code)))
    {
      if (is_pair(caar(sc->code)))
	{
	  if (!s7_is_list(sc, cdar(sc->code)))                          /* (set! ('(1 2) . 0) 1) */
	    eval_error(sc, "improper list of args to set!: ~A", sc->code);
	}
      if (!is_proper_list(sc, car(sc->code)))                           /* (set! ("hi" . 1) #\a) or (set! (#(1 2) . 1) 0) */
	eval_error(sc, "set! target is an improper list: (set! ~A ...)", car(sc->code));
    }
  else
    {
      if (!s7_is_symbol(car(sc->code)))                                 /* (set! 12345 1) */
	return(eval_error(sc, "set! can't change ~S", car(sc->code)));
    }
  
  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      if (is_pair(car(sc->code)))
	{
	  s7_pointer inner, value;
	  inner = car(sc->code);
	  value = cadr(sc->code);
	  if ((s7_is_symbol(car(inner))) &&
	      (is_pair(cdr(inner))) &&
	      (!is_pair(cddr(inner))) &&
	      (!is_pair(cadr(inner))) &&
	      (!is_pair(cddr(sc->code))) &&
	      (!is_pair(value)))
	    car(ecdr(sc->code)) = sc->SET_PAIR;
	  else car(ecdr(sc->code)) = sc->SET_UNCHECKED;
	}
      else car(ecdr(sc->code)) = sc->SET_NORMAL;

      if (s7_is_symbol(car(sc->code)))
	{
	  if (s7_is_symbol(cadr(sc->code)))
	    car(ecdr(sc->code)) = sc->SET_SYMBOL_S;
	  else
	    {
	      if (is_pair(cadr(sc->code)))
		{
		  /* if cadr(cadr) == car, or cdr(cadr) not null and cadr(cadr) == car, and cddr(cadr) == null,
		   *   it's (set! <var> (<op> <var> val)) or (<op> val <var>) or (<op> <var>)
		   *   in the set code, we get the slot as usual, then in case 1 above,
		   *   car(sc->T2_1) = symbol_value(slot), car(sc->T2_2) = increment, call <op>, set symbol_value(slot)
		   *
		   * this can be done in all combined cases where a symbol is repeated (do in particular)
		   */

		  /* (define (hi) (let ((x 1)) (set! x (+ x 1)))) */
#if WITH_OPTIMIZATION
		  if ((symbol_accessor(car(sc->code)) == -1) &&
		      (!is_global(car(sc->code))) &&
		      (is_optimized(cadr(sc->code))))
		    {
		      if ((caddr(cadr(sc->code)) == small_int(1)) &&
			  (cadr(cadr(sc->code)) == car(sc->code)))
			{
			  if (ecdr(cadr(sc->code)) == add_s1)
			    car(ecdr(sc->code)) = sc->INCREMENT_1;
			  else 
			    {
			      if (ecdr(cadr(sc->code)) == subtract_s1)
				car(ecdr(sc->code)) = sc->DECREMENT_1;
			    }
			}
		      else
			{
			  if ((cadr(cadr(sc->code)) == small_int(1)) &&
			      (caddr(cadr(sc->code)) == car(sc->code)) &&
			      (ecdr(cadr(sc->code)) == add_1s))
			    car(ecdr(sc->code)) = sc->INCREMENT_1;
			  else
			    {
			      if ((car(sc->code) == cadr(cadr(sc->code))) &&
				  (caadr(sc->code) == sc->CDR))
				car(ecdr(sc->code)) = sc->SET_CDR;
			      else
				{
				  if ((car(sc->code) == caddr(cadr(sc->code))) &&
				      (s7_is_symbol(cadr(cadr(sc->code)))) &&
				      (caadr(sc->code) == s7_make_symbol(sc, "cons")))
				    car(ecdr(sc->code)) = sc->SET_CONS;
				  else car(ecdr(sc->code)) = sc->SET_SYMBOL_P;
				}
			    }
			}
		    }
		  else car(ecdr(sc->code)) = sc->SET_SYMBOL_P;
#else
		  car(ecdr(sc->code)) = sc->SET_SYMBOL_P;
#endif
		}
	      else car(ecdr(sc->code)) = sc->SET_SYMBOL_C;
	    }
	}
    }

  return(sc->code);
}


#if WITH_OPTIMIZATION
static void initialize_safe_do(s7_scheme *sc, s7_pointer tree)
{
  if (is_pair(tree))
    {
      initialize_safe_do(sc, car(tree));
      initialize_safe_do(sc, cdr(tree));
    }
  else
    {
      if (s7_is_symbol(tree))
	{
	  symbol_accessor_data(tree) = NULL;
	  symbol_op_data(tree) = NULL;
	}
    }
}


#define PRINTING 0
static bool safe_stepper(s7_scheme *sc, s7_pointer expr, s7_pointer stepper)
{
  /* for now, just look for stepper as last element of any list
   *    any embedded set is handled by do_is_safe, so we don't need to descend into the depths
   */
  if ((cadr(expr) == stepper) ||
      (caddr(expr) == stepper))
    return(false);

  if (is_pair(caddr(expr)))
    {
      s7_pointer p;
      for (p = caddr(expr); is_pair(cdr(p)); p = cdr(p));
      if (car(p) == stepper)
	return(false);
    }
  return(true);
}

/* (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (let ((val 1)) (set! val 2) )))
 * (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (let ((val 3)) (set! val i) )))
 * (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (display i)) (newline))
 */
static void optimize_do(s7_scheme *sc, s7_pointer expr)
{
  s7_pointer p;
  for (p = expr; is_pair(p); p = cdr(p))
    {
      if (is_pair(car(p)))
	{
	  if ((is_optimized(car(p))) &&
	      (optimize_data(car(p)) == HOP_SAFE_C_S))
	    optimize_data(car(p)) = HOP_SAFE_DO_C_S;
	  else
	    {
	      optimize_do(sc, car(p));
	      optimize_do(sc, cdr(p));
	    }
	}
    }
}

static void unoptimize_do(s7_scheme *sc, s7_pointer expr)
{
  s7_pointer p;
  for (p = expr; is_pair(p); p = cdr(p))
    {
      if (is_pair(car(p)))
	{
	  if ((is_optimized(car(p))) &&
	      (optimize_data(car(p)) == HOP_SAFE_DO_C_S))
	    optimize_data(car(p)) = HOP_SAFE_C_S;
	  else
	    {
	      optimize_do(sc, car(p));
	      optimize_do(sc, cdr(p));
	    }
	}
    }
}

static bool do_is_safe(s7_scheme *sc, s7_pointer body, s7_pointer stepper, s7_pointer var_list, bool *has_set)
{
  /* here any (unsafe?) closure or jumping-op (call/cc) or shadowed variable is trouble
   */
  s7_pointer p;
  /* if (s7_list_length(sc, body) <= 0) return(false); */
#if PRINTING
  fprintf(stderr, "do_is_safe: %s\n", DISPLAY_80(body));
#endif

  for (p = body; is_pair(p); p = cdr(p))
    {
      s7_pointer expr;
      expr = car(p);
#if PRINTING
      fprintf(stderr, "    expr: %s\n", DISPLAY_80(expr));
#endif
      if (is_pair(expr))
	{
	  s7_pointer x;
	  x = car(expr);
	  if (s7_is_symbol(x))
	    {
	      if (is_syntactic(x))
		{
		  opcode_t op;
		  s7_pointer func;
		  func = symbol_value(symbol_global_slot(x));
		  op = (opcode_t)syntax_opcode(func);
		  if (op != OP_QUOTE)
		    {
		      if ((op == OP_LET) ||
			  (op == OP_LET_STAR) ||
			  (op == OP_LETREC) || 
			  (op == OP_DO))
			{
			  s7_pointer vars;
			  if ((op == OP_LET) && 
			      (s7_is_symbol(cadr(expr))))
			    {
#if PRINTING
			      fprintf(stderr, "unsafe do(3): %s\n", DISPLAY_80(expr)); 
#endif
			      return(false);
			    }
			  
			  for (vars = cadr(expr); is_pair(vars); vars = cdr(vars))
			    {
			      s7_pointer var;
			      var = caar(vars);
			      if ((memq(var, var_list)) || (var == stepper))
				return(false);
			      var_list = cons(sc, var, var_list);
			      sc->x = var_list;
#if PRINTING
			      fprintf(stderr, "let var expr: %s\n", DISPLAY_80(cadar(vars)));
#endif
			      if ((is_pair(cdar(vars))) &&
				  (!do_is_safe(sc, cdar(vars), stepper, var_list, has_set)))
				{
#if PRINTING
				  fprintf(stderr, "unsafe do(6): %s\n", DISPLAY_80(expr)); 
#endif
				return(false);
				}
			    }

			  if (!do_is_safe(sc, (op == OP_DO) ? cdddr(expr) : cddr(expr), stepper, var_list, has_set))
			    {
#if PRINTING
			      fprintf(stderr, "unsafe do(7): %s\n", DISPLAY_80(expr)); 
#endif
			    return(false);
			    }
			}
		      else
			{
			  if ((op == OP_IF) ||
			      (op == OP_COND) || /* TODO: cond and case (and set for vectors et al) need special handling */
			      (op == OP_CASE) ||
			      (op == OP_AND) ||
			      (op == OP_OR) ||
			      (op == OP_BEGIN))
			    {
			      if (!do_is_safe(sc, cdr(expr), stepper, var_list, has_set))
				{
#if PRINTING
				  fprintf(stderr, "unsafe do(5): %s\n", DISPLAY_80(expr));
#endif
				  return(false);
				}
			      /* check exprs */
			    }
			  else
			    {
			      if (!memq(cadr(expr), var_list))
				{
#if PRINTING
				  fprintf(stderr, "%s is global\n", DISPLAY(cadr(expr)));
#endif
				(*has_set) = true;
				}
			      if ((!do_is_safe(sc, cddr(expr), stepper, var_list, has_set)) ||
				  (!safe_stepper(sc, expr, stepper)))
				{
#if PRINTING
				  fprintf(stderr, "unsafe do(set 1): %s\n", DISPLAY_80(expr));
#endif
				  return(false);
				}
			      else
				{
#if PRINTING
				  fprintf(stderr, "still safe do(set 2): %s\n", DISPLAY_80(expr));
#endif
				}
			    }
			}
		    }
		}
	      else
		{
#if PRINTING
		  fprintf(stderr, "    %s: %d %d %d\n", DISPLAY_80(expr), is_optimized(expr), is_unsafe(expr), is_setter(car(expr)));
#endif
		  if ((!is_optimized(expr)) ||
		      (is_unsafe(expr)) ||
		      (!do_is_safe(sc, cdr(expr), stepper, var_list, has_set)))
		    {
#if PRINTING
		      fprintf(stderr, "unsafe do(0): %s\n", DISPLAY_80(expr)); 
#endif
		    return(false);
		    }
		  else
		    {
		      if (is_setter(car(expr)))
			{
			  if (!memq(cadr(expr), var_list))
			    {
#if PRINTING
			      fprintf(stderr, "%s is global\n", DISPLAY(cadr(expr)));
#endif
			      (*has_set) = true;
			    }
			  if ((!do_is_safe(sc, cddr(expr), stepper, var_list, has_set)) ||
			      (!safe_stepper(sc, expr, stepper)))
			    {
			      return(false);
			    }
			}
		    }
		}
	    }
	  else 
	    {
#if PRINTING
	      fprintf(stderr, "unsafe do(1): %s\n", DISPLAY_80(expr));
#endif
	    return(false); /* what is this case? */
	    }
	}
    }
  return(true);
}
#endif
      

static s7_pointer check_do(s7_scheme *sc)
{
  s7_pointer x;
  
  if ((!is_pair(sc->code)) ||                             /* (do . 1) */
      ((!is_pair(car(sc->code))) &&                       /* (do 123) */
       (is_not_null(car(sc->code)))))                     /* (do () ...) is ok */
    return(eval_error(sc, "do: var list is not a list: ~S", sc->code));
  
  if (!is_pair(cdr(sc->code)))                            /* (do () . 1) */
    return(eval_error(sc, "do body is messed up: ~A", sc->code));
  
  if ((!is_pair(cadr(sc->code))) &&                       /* (do ((i 0)) 123) */
      (is_not_null(cadr(sc->code))))                      /* no end-test? */
    return(eval_error(sc, "do: end-test and end-value list is not a list: ~A", sc->code));
  
  if (is_pair(car(sc->code)))
    {
      for (x = car(sc->code); is_pair(x); x = cdr(x))
	{
	  if (!(is_pair(car(x))))                         /* (do (4) (= 3)) */
	    return(eval_error(sc, "do: variable name missing? ~A", sc->code));

	  if (!s7_is_symbol(caar(x)))                     /* (do ((3 2)) ()) */
	    return(eval_error(sc, "do step variable: ~S is not a symbol?", x));

	  if (is_immutable(caar(x)))                     /* (do ((pi 3 (+ pi 1))) ((= pi 4)) pi) */
	    return(eval_error(sc, "do step variable: ~S is immutable", x));
	  
	  if (is_pair(cdar(x)))
	    {
	      if ((!is_pair(cddar(x))) &&
		  (is_not_null(cddar(x))))               /* (do ((i 0 . 1)) ...) */
		return(eval_error(sc, "do: step variable info is an improper list?: ~A", sc->code));
	      
	      if ((is_pair(cddar(x))) && 
		  (is_not_null(cdr(cddar(x)))))          /* (do ((i 0 1 (+ i 1))) ...) */
		return(eval_error(sc, "do: step variable info has extra stuff after the increment: ~A", sc->code));
	    }
	  else return(eval_error(sc, "do: step variable has no initial value: ~A", x));

	  set_local(caar(x));

	  /* (do ((i)) ...) */
	}

      if (is_not_null(x))                                /* (do ((i 0 i) . 1) ((= i 1))) */
	return(eval_error(sc, "do: list of variables is improper: ~A", sc->code));
    }

  if (is_pair(cadr(sc->code)))
    {
      for (x = cadr(sc->code); is_pair(x); x = cdr(x));
      if (is_not_null(x))
	return(eval_error(sc, "stray dot in do end section?", sc->code));
    }

  for (x = cddr(sc->code); is_pair(x); x = cdr(x));
  if (is_not_null(x))
    return(eval_error(sc, "stray dot in do body?", sc->code));

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      car(ecdr(sc->code)) = sc->DO_UNCHECKED;
#if WITH_OPTIMIZATION
      {
	/* (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (display i)) (newline)) */
	s7_pointer vars, end;
	vars = car(sc->code);
	end = cadr(sc->code);

	if ((is_pair(end)) &&
	    (is_pair(vars)) &&
	    (is_null(cdr(vars))))
	  {
	    /* loop has one step variable, and normal-looking end test
	     */
	    vars = car(vars);

	    if ((safe_list_length(sc, vars) == 3) &&
		(!is_pair(cadr(vars))))
	      {
		s7_pointer step_expr;
		step_expr = caddr(vars);

		if ((is_optimized(step_expr)) &&
		    (((optimize_data(step_expr) == HOP_SAFE_C_SC) && (car(vars) == cadr(step_expr))) ||
		     ((optimize_data(step_expr) == HOP_SAFE_C_CS) && (car(vars) == caddr(step_expr)))))
		  {
		    /* step var is (var const|symbol (op var const)|(op const var)) 
		     */
		    end = car(end);

		    if ((is_optimized(end)) &&
			((optimize_data(end) == HOP_SAFE_C_SS) || (optimize_data(end) == HOP_SAFE_C_SC)) &&
			(car(vars) == cadr(end)))
		      {
			/* end var is (op var const|symbol) using same var as step 
			 *   so at least we can use SIMPLE_DO
			 */
			car(ecdr(sc->code)) = sc->SIMPLE_DO;

			/* now look for the very common dotimes case
			 */
			/*
			fprintf(stderr, "step: %s, %d %lld %d %d\n", 
				DISPLAY_80(step_expr),
				s7_is_integer(caddr(step_expr)),
				s7_integer(caddr(step_expr)),
				c_function_call(symbol_value(symbol_global_slot(car(step_expr)))) == g_add,
				c_function_call(symbol_value(symbol_global_slot(car(end)))) == g_equal);
			*/
			if ((((s7_is_integer(caddr(step_expr))) &&
			      (s7_integer(caddr(step_expr)) == 1)) ||
			     ((s7_is_integer(cadr(step_expr))) &&
			      (s7_integer(cadr(step_expr)) == 1))) &&

			    /* PERHAPS: check function_class of ecdr here? avoids the symbol lookup 
			     */
			    (c_function_call(symbol_value(symbol_global_slot(car(step_expr)))) == g_add) &&
			    (c_function_call(symbol_value(symbol_global_slot(car(end)))) == g_equal))
			  {
			    /* we're stepping by +1 and going to =
			     *   the final integer check has to wait until run time (symbol value dependent)
			     * now check that there's nothing problematic (shadowed vars, call/cc etc)
			     *   in the loop itself.
			     */
			    bool has_set = false;
			    if ((do_is_safe(sc, cddr(sc->code), car(vars), sc->NIL, &has_set)) &&
				(!has_set))
			      {
				/* fprintf(stderr, "found safe do: %s\n", DISPLAY_80(sc->code)); */
				car(ecdr(sc->code)) = sc->DOTIMES;

				optimize_do(sc, sc->code);

				{
				  s7_pointer x;
				  x = cddr(sc->code);
				  /*
				  fprintf(stderr, "cddr: %s %d %d\n", DISPLAY_80(x),
					  safe_list_length(sc, x),
					  is_pair(car(x)));
				  */

				  /* what are the most common cases here?
				   */
				  
				  /* TODO: obvious extensions: just SAFE_C_C, or let with no vars etc
				   */
				  if ((safe_list_length(sc, x) == 1) &&
				      (is_pair(car(x))) &&
				      (is_syntactic(caar(x))) &&
				      (syntax_opcode(caar(x)) == OP_LET))
				    {
				      x = cddar(x);

#if 0
				      fprintf(stderr, "cddar: %s\n", DISPLAY_80(x));
				      if (is_pair(car(x)))
					{
					  if (is_optimized(car(x)))
					    fprintf(stderr, "opt: %s\n", opt_names[optimize_data(car(x))]);
					  else fprintf(stderr, "not opt\n");
					}
				      else fprintf(stderr, "not pair\n");
#endif

				      if ((is_pair(car(x))) &&
					  (is_optimized(car(x))) &&
					  (is_null(cdr(x))) &&
					  (optimize_data(car(x)) == HOP_SAFE_C_C))
					{
					  bool happy = true;

					  /* fprintf(stderr, "safe let?: %s\n", DISPLAY_80(sc->code)); */

					  for (x = cadar(cddr(sc->code)); is_pair(x); x = cdr(x))
					    {
					      /* fprintf(stderr, "let var: %s\n", DISPLAY(car(x))); */
					      if ((!is_pair(cadar(x))) ||
						  (!is_optimized(cadar(x))) ||
						  (optimize_data(cadar(x)) != HOP_SAFE_C_C))
						{
						  happy = false;
						  break;
						}
					    }
					  if (happy)
					    {
					      /* fprintf(stderr, "safe: %s\n", DISPLAY_80(sc->code)); */
					      car(ecdr(sc->code)) = sc->SIMPLE_DOTIMES;
					    }
					}
				    }
				}
      
			      }
			  }
			return(sc->NIL); /* tell OP_DO that this is a special case */
		      }
		  }
	      }
	  }
      }
#endif
    }

  return(sc->code);
}


static s7_pointer check_defmacro(s7_scheme *sc)
{
  s7_pointer x, y, z;
  if (!is_pair(sc->code))                                               /* (defmacro . 1) */
    return(eval_error_with_name(sc, "~A name missing (stray dot?): ~A", sc->code));
  
  x = car(sc->code);
  if (!s7_is_symbol(x))                                             /* (defmacro) or (defmacro 1 ...) */
    return(eval_error_with_name(sc, "~A name: ~S is not a symbol?", x));     
  
  if (is_immutable(x))
    return(eval_error_with_name(sc, "~A: ~S is immutable", x)); /* (defmacro pi (a) `(+ ,a 1)) */
  
  z = cdr(sc->code);
  if (!is_pair(z))                                                  /* (defmacro a) */
    return(eval_error_with_name(sc, "~A ~A, but no args or body?", sc->code));
  
  y = car(z);            /* the arglist */
  if ((!s7_is_list(sc, y)) &&
      (!s7_is_symbol(y)))
    return(s7_error(sc, sc->SYNTAX_ERROR,                               /* (defmacro mac "hi" ...) */
		    list_3(sc, make_protected_string(sc, "defmacro ~A argument list is ~S?"), x, y)));
  
  for ( ; is_pair(y); y = cdr(y))
    if ((!s7_is_symbol(car(y))) &&
	(sc->op == OP_DEFMACRO))
      return(s7_error(sc, sc->SYNTAX_ERROR,                             /* (defmacro mac (1) ...) */
		      list_3(sc, make_protected_string(sc, "defmacro ~A argument name is not a symbol: ~S"), x, y)));
  
  /* other parameter error checks are handled by lambda/lambda* (see OP_LAMBDA above) at macro expansion time */
  
  if (!is_pair(cdr(z)))
    {
      if (is_null(cdr(z)))                                             /* (defmacro hi ()) */
	return(eval_error_with_name(sc, "~A ~A has no body?", x));
      return(eval_error_with_name(sc, "~A ~A has stray dot?", x));
    }
  return(sc->code);
}


static s7_pointer check_define_macro(s7_scheme *sc)
{
  s7_pointer x;
  if (!is_pair(sc->code))                                               /* (define-macro . 1) */
    return(eval_error_with_name(sc, "~A name missing (stray dot?): ~A", sc->code));
  if (!is_pair(car(sc->code)))                                          /* (define-macro a ...) */
    return(s7_wrong_type_arg_error(sc, op_names[(int)(sc->op)], 1, car(sc->code), "a list (name ...)"));
  
  x = caar(sc->code);
  if (!s7_is_symbol(x))
    return(eval_error_with_name(sc, "~A: ~S is not a symbol?", x));
  if (dont_eval_args(x))                                            /* (define-macro (quote a) quote) */
    return(eval_error_with_name(sc, "~A: syntactic keywords (such as ~S) tend to behave badly if redefined", x));
  
  if (is_immutable(x))
    return(eval_error_with_name(sc, "~A: ~S is immutable", x));
  
  if (!is_pair(cdr(sc->code)))                /* (define-macro (...)) */
    return(eval_error_with_name(sc, "~A ~A, but no body?", x));
  
  sc->y = cdar(sc->code);            /* the arglist */
  if ((!s7_is_list(sc, sc->y)) &&
      (!s7_is_symbol(sc->y)))
    return(s7_error(sc, sc->SYNTAX_ERROR,                                      /* (define-macro (mac . 1) ...) */
		    list_3(sc, make_protected_string(sc, "define-macro ~A argument list is ~S?"), x, sc->y)));
  
  for ( ; is_pair(sc->y); sc->y = cdr(sc->y))
    if ((!s7_is_symbol(car(sc->y))) &&
	((sc->op == OP_DEFINE_MACRO) || (sc->op == OP_DEFINE_BACRO)))
      return(s7_error(sc, sc->SYNTAX_ERROR,                                    /* (define-macro (mac 1) ...) */
		      list_3(sc, make_protected_string(sc, "define-macro ~A argument name is not a symbol: ~S"), x, sc->y)));
  
  return(sc->code);
}


static s7_pointer check_cond(s7_scheme *sc)
{
  s7_pointer x;
  if (!is_pair(sc->code))                                             /* (cond) or (cond . 1) */
    return(eval_error(sc, "cond, but no body: ~A", sc->code));

  for (x = sc->code; is_pair(x); x = cdr(x))
    {
      if (!is_pair(car(x)))                                         /* (cond 1) or (cond (#t 1) 3) */
	return(eval_error(sc, "every clause in cond must be a list: ~A", car(x)));
      else
	{
	  s7_pointer y;
	  y = car(x);
	  if ((cadr(y) == sc->FEED_TO) &&
	      (s7_symbol_value(sc, sc->FEED_TO) == sc->UNDEFINED))
	    {
	      if (!is_pair(cddr(y)))                                  /* (cond (#t =>)) or (cond (#t => . 1)) */
		return(eval_error(sc, "cond: '=>' target missing?  ~A", x));
	      if (is_pair(cdddr(y)))                                  /* (cond (1 => + abs)) */
		return(eval_error(sc, "cond: '=>' has too many targets: ~A", x));
	    }
	  /* currently we accept:
	   *     (cond (1 2) (=> . =>)) and all variants thereof, e.g. (cond (1 2) (=> 1 . 2) (1 2)) or 
	   *     (cond (1) (=>)) but Guile accepts this?
	   *     (cond (1) (1 =>))
	   * amusing (correct) case: (cond (1 => "hi")) -> #\i
	   */
	}
    }
  if (is_not_null(x))                                             /* (cond ((1 2)) . 1) */
    return(eval_error(sc, "cond: stray dot? ~A", sc->code));

  if ((is_overlaid(sc->code)) &&
      (cdr(ecdr(sc->code)) == sc->code))
    {
      car(ecdr(sc->code)) = sc->COND_UNCHECKED;
    }
  return(sc->code);
}



#if WITH_OPTIMIZATION

#if defined(__GNUC__)

  #define c_function_is_ok(Sc, X) ({ s7_pointer _p_; \
                                    _p_ = SYMBOL_VALUE(car(X), find_symbol_or_bust_26); \
                                    ((_p_ == ecdr(X)) || \
                                     ((is_c_function(_p_)) && \
                                      (c_function_class(_p_) == c_function_class(ecdr(X))))); })

/* turning find_symbol_or_bust into a macro did not speed up the search */
#else

static bool c_function_is_ok(s7_scheme *sc, s7_pointer x) 
{
  s7_pointer p;
  p = SYMBOL_VALUE(car(x), find_symbol_or_bust_26);
  return((p == ecdr(x)) ||
	 ((is_c_function(p)) &&
	  (c_function_class(p) == c_function_class(ecdr(x)))));
}

#endif


static s7_pointer fs(s7_scheme *sc, s7_pointer hdl)
{
  s7_pointer x;	

  if (frame_id(sc->envir) == symbol_id(hdl))
    return(symbol_value(symbol_local_slot(hdl)));

  for (x = sc->envir; symbol_id(hdl) < frame_id(x); x = cdr(x));

  if (frame_id(x) == symbol_id(hdl))
    return(symbol_value(symbol_local_slot(hdl)));	

  for (; is_environment(x); x = cdr(x))
    {
      s7_pointer y; 
      for (y = car(x); is_pair(y); y = ecdr(y))	
	if (car(y) == hdl)
	  return(symbol_value(y)); 
    }
  x = symbol_global_slot(hdl);	
  if (is_not_null(x)) 
    return(symbol_value(x)); 
  return(sc->UNDEFINED);
}

#define function_is_ok(Code) (fs(sc, car(Code)) == ecdr(Code))

#endif





/* -------------------------------- eval -------------------------------- */

/* all explicit write-* in eval assume current-output-port -- error fallback handling, etc */
/*   internal reads assume sc->input_port is the input port */

static s7_pointer eval(s7_scheme *sc, opcode_t first_op) 
{
  sc->cur_code = ERROR_INFO_DEFAULT;
  sc->op = first_op;
  
  /* this procedure can be entered recursively (via s7_call for example), so it's no place for a setjmp
   *   I don't think the recursion can hurt our continuations because s7_call is coming from hooks and
   *   callbacks that are implicit in our stack.
   */
  
  goto START_WITHOUT_POP_STACK;
  /* this ugly two-step is actually noticeably faster than other ways of writing this code
   */

 START:
  pop_stack(sc);

 START_WITHOUT_POP_STACK:

  switch (sc->op) 
    {
    case OP_READ_INTERNAL:
      /* if we're loading a file, and in the file we evaluate something like:
       *
       *    (let ()
       *      (set-current-input-port (open-input-file "tmp2.r5rs"))
       *      (close-input-port (current-input-port)))
       *    ... (with no reset of input port to its original value)
       *
       * the load process tries to read the loaded string, but the sc->input_port is now closed,
       * and the original is inaccessible!  So we get a segfault in token.  We don't want to put
       * a port_is_closed check there because token only rarely is in this danger.  I think this
       * is the only place where we can be about to call token, and someone has screwed up our port.
       *
       * We can't call read_error here because it assumes the input string is ok!
       */

      if (port_is_closed(sc->input_port))
	return(s7_error(sc, sc->READ_ERROR, 
			list_1(sc, make_protected_string(sc, "our input port got clobbered!"))));

      sc->tok = token(sc);

      switch (sc->tok)
	{
	case TOKEN_EOF:
	  goto START;

	case TOKEN_RIGHT_PAREN:
	  read_error(sc, "unexpected close paren");

	case TOKEN_COMMA:
	  read_error(sc, "unexpected comma");

	default:
	  sc->value = read_expression(sc);
	  sc->current_line = port_line_number(sc->input_port);  /* this info is used to track down missing close parens */
	  sc->current_file = port_filename(sc->input_port);
	  goto START;
	}

      
      /* (read p) from scheme
       *    "p" becomes current input port for eval's duration, then pops back before returning value into calling expr
       */
    case OP_READ_DONE:
      pop_input_port(sc);

      if (sc->tok == TOKEN_EOF)
	sc->value = sc->EOF_OBJECT;
      sc->current_file = NULL;
      goto START;
      
      
      /* load("file"); from C (g_load) -- assume caller will clean up
       *   read and evaluate exprs until EOF that matches (stack reflects nesting)
       */
    case OP_LOAD_RETURN_IF_EOF:  /* loop here until eof (via push stack below) */
      if (sc->tok != TOKEN_EOF)
	{
	  push_stack(sc, OP_LOAD_RETURN_IF_EOF, sc->NIL, sc->NIL);
	  push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
	  sc->code = sc->value;
	  goto EVAL;             /* we read an expression, now evaluate it, and return to read the next */
	}
      sc->current_file = NULL;
      return(sc->F);
      
      
      /* (load "file") in scheme 
       *    read and evaluate all exprs, then upon EOF, close current and pop input port stack
       */
    case OP_LOAD_CLOSE_AND_POP_IF_EOF:
      if (sc->tok != TOKEN_EOF)
	{
	  push_stack(sc, OP_LOAD_CLOSE_AND_POP_IF_EOF, sc->NIL, sc->NIL); /* was push args, code */
	  push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
	  sc->code = sc->value;
	  goto EVAL;             /* we read an expression, now evaluate it, and return to read the next */
	}
      s7_close_input_port(sc, sc->input_port);
      pop_input_port(sc);
      sc->current_file = NULL;
      goto START;
      

      /* read and evaluate string expression(s?)
       *    assume caller (C via g_eval_c_string) is dealing with the string port
       */
    case OP_EVAL_STRING:
      /* this is the C side s7_eval_c_string. 
       */

      /* (eval-string (string-append "(list 1 2 3)" (string #\newline) (string #\newline))) 
       *    needs to be sure to get rid of the trailing white space before checking for EOF
       *    else it tries to eval twice and gets "attempt to apply 1?, line 2"
       */
      if ((sc->tok != TOKEN_EOF) && 
	  (port_string_point(sc->input_port) < port_string_length(sc->input_port))) /* ran past end somehow? */
	{
	  unsigned char c;
	  while (white_space[c = port_string(sc->input_port)[port_string_point(sc->input_port)++]])
	    if (c == '\n')
	      port_line_number(sc->input_port)++;

	  if (c != 0)
	    {
	      backchar(c, sc->input_port);
	      push_stack(sc, OP_EVAL_STRING, sc->NIL, sc->value);
	      push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
	    }
	  else push_stack(sc, OP_EVAL_DONE, sc->NIL, sc->value);
	}
      else push_stack(sc, OP_EVAL_DONE, sc->NIL, sc->value);
      sc->code = sc->value;
      goto EVAL;

      
    case OP_EVAL_STRING_2:
      s7_close_input_port(sc, sc->input_port);
      pop_input_port(sc);

      if (is_multiple_value(sc->value))
	sc->value = splice_in_values(sc, multiple_value(sc->value));

      goto START;

      
    case OP_EVAL_STRING_1:
      if ((sc->tok != TOKEN_EOF) && 
	  (port_string_point(sc->input_port) < port_string_length(sc->input_port))) /* ran past end somehow? */
	{
	  unsigned char c;
	  while (white_space[c = port_string(sc->input_port)[port_string_point(sc->input_port)++]])
	    if (c == '\n')
	      port_line_number(sc->input_port)++;

	  if (c != 0)
	    {
	      backchar(c, sc->input_port);
	      push_stack(sc, OP_EVAL_STRING_1, sc->NIL, sc->value);
	      push_stack(sc, OP_READ_INTERNAL, sc->NIL, sc->NIL);
	    }
	  else push_stack(sc, OP_EVAL_STRING_2, sc->NIL, sc->NIL);
	}
      else push_stack(sc, OP_EVAL_STRING_2, sc->NIL, sc->NIL);
      sc->code = sc->value;
      goto EVAL;


      /* -------------------- sort! (heapsort, done directly so that call/cc in the sort function will work correctly) -------------------- */

    #define SORT_N integer(number(vector_element(sc->code, 0)))
    #define SORT_K integer(number(vector_element(sc->code, 1)))
    #define SORT_J integer(number(vector_element(sc->code, 2)))
    #define SORT_K1 integer(number(vector_element(sc->code, 3)))
    #define SORT_ARGS vector_element(sc->code, 4)
    #define SORT_CALLS integer(number(vector_element(sc->code, 5)))
    #define SORT_STOP integer(number(vector_element(sc->code, 6)))
    #define SORT_ARG_1 car(SORT_ARGS)
    #define SORT_ARG_2 cadr(SORT_ARGS)
    #define SORT_DATA(K) vector_element(car(sc->args), K)
    #define SORT_LESSP cadr(sc->args)

    HEAPSORT:
      {
	s7_Int n, j, k;
	n = SORT_N;
	k = SORT_K1;

	if ((n == k) || (k > ((s7_Int)(n / 2)))) /* k == n == 0 is the first case */
	  goto START;

	if (sc->safety != 0)
	  {
	    SORT_CALLS++;
	    if (SORT_CALLS > SORT_STOP)
	      return(eval_error(sc, "sort! is caught in an infinite loop, comparison: ~S", SORT_LESSP));
	  }
	j = 2 * k;
	SORT_J = j;
	if (j < n)
	  {
	    push_stack(sc, OP_SORT1, sc->args, sc->code);
	    SORT_ARG_1 = SORT_DATA(j);
	    SORT_ARG_2 = SORT_DATA(j + 1);

	    sc->x = SORT_LESSP;
	    sc->args = SORT_ARGS;
	    sc->code = sc->x;
	    goto APPLY_WITHOUT_TRACE;
	  }
	else sc->value = sc->F;
      }

    case OP_SORT1:
      {
	s7_Int j, k;
	k = SORT_K1;
	j = SORT_J;
	if (is_true(sc, sc->value))
	  {
	    j = j + 1;
	    SORT_J = j;
	  }
	push_stack(sc, OP_SORT2, sc->args, sc->code);
	SORT_ARG_1 = SORT_DATA(k);
	SORT_ARG_2 =  SORT_DATA(j);

	sc->x = SORT_LESSP;
	sc->args = SORT_ARGS;
	sc->code = sc->x;
	goto APPLY_WITHOUT_TRACE;
      }

    case OP_SORT2:
      {
	s7_Int j, k;
	k = SORT_K1;
	j = SORT_J;
	if (is_true(sc, sc->value))
	  {
	    sc->x = SORT_DATA(j);
	    SORT_DATA(j) = SORT_DATA(k);
	    SORT_DATA(k) = sc->x;
	  }
	else goto START;
	SORT_K1 = SORT_J;
	goto HEAPSORT;
      }

    case OP_SORT:
      /* coming in sc->args is sort args (data less?), sc->code = '(n k 0)
       *
       * here we call the inner loop until k <= 0 [the local k! -- this is tricky because scheme passes args by value]
       */
      {
	s7_Int k;
	k = SORT_K;
	if (k <= 0)
	  goto SORT3;

	SORT_K = k - 1;
	SORT_K1 = k - 1;

	push_stack(sc, OP_SORT, sc->args, sc->code);
	goto HEAPSORT;
      }

      SORT3:
      case OP_SORT3:
	{
	  s7_Int n;
	  n = SORT_N;
	  if (n <= 0)
	    {
	      sc->value = car(sc->args);
	      goto START;
	    }
	  sc->x = SORT_DATA(0);
	  SORT_DATA(0) = SORT_DATA(n);
	  SORT_DATA(n) = sc->x;
	  SORT_N = n - 1;
	  SORT_K1 = 0;
	  push_stack(sc, OP_SORT3, sc->args, sc->code);
	  goto HEAPSORT;
	}

    case OP_SORT4:
      /* sc->value is the sort vector which needs to be turned into a list */
      sc->value = s7_vector_to_list(sc, sc->value);
      goto START;

    case OP_SORT_OBJECT:
      /* sc->value is the sorted vector which needs to be loaded back into the original object */
      sc->value = vector_to_object(sc, sc->value, car(sc->code));
      goto START;

    case OP_SORT_TWO:
      /* here we're sorting a list of 2 items */
      if (is_true(sc, sc->value))
	sc->value = sc->args;
      else sc->value = list_2(sc, cadr(sc->args), car(sc->args));
      goto START;

      /* batcher networks:
       *    ((0 2) (0 1) (1 2))
       *    ((0 2) (1 3) (0 1) (2 3) (1 2))
       *    ((0 4) (0 2) (1 3) (2 4) (0 1) (2 3) (1 4) (1 2) (3 4))
       *    ((0 4) (1 5) (0 2) (1 3) (2 4) (3 5) (0 1) (2 3) (4 5) (1 4) (1 2) (3 4))
       *    ((0 4) (1 5) (2 6) (0 2) (1 3) (4 6) (2 4) (3 5) (0 1) (2 3) (4 5) (1 4) (3 6) (1 2) (3 4) (5 6))
       *    ((0 4) (1 5) (2 6) (3 7) (0 2) (1 3) (4 6) (5 7) (2 4) (3 5) (0 1) (2 3) (4 5) (6 7) (1 4) (3 6) (1 2) (3 4) (5 6))
       *
       * but since it has to be done here by hand, it turns into too much code, 3 is:
       *    < l0 l2 ?
       *    no goto L1
       *    < l0 l1 ?
       *    no  return 1 0 2
       *    < l1 l2?
       *    yes return 0 1 2 (direct)
       *    no  return 0 2 1
       *  L1:
       *    < l0 l1 ?
       *    yes return 2 0 1
       *    < l1 l2 ?
       *    yes return 1 2 0
       *    no  return 2 1 0
       * since each "<" op above goes to OP_APPLY, we have ca 5 labels, and ca 25-50 lines
       */


    case OP_MAP_SIMPLE:
      /* func = sc->code, func takes one arg, args = '(nil arglist) at the start with symbol_id = len
       *   the func is prechecked, as is the list.
       */
      /* fprintf(stderr, "%p %lld, value: %s, args: %s\n", sc->args, symbol_id(sc->args), s7_object_to_c_string(sc, sc->value), s7_object_to_c_string(sc, sc->args)); */
      if (sc->value != sc->NO_VALUE)
	{
	  if (is_multiple_value(sc->value))
	    car(sc->args) = revappend(sc, multiple_value(sc->value), car(sc->args));
	  else car(sc->args) = cons(sc, sc->value, car(sc->args));
	}
      if (is_pair(cdr(sc->args)))
	{
	  if ((--symbol_id(sc->args)) >= 0) /* protect against circular arg lists created by the map function! */
	    {
	      sc->x = cadr(sc->args);
	      cdr(sc->args) = cddr(sc->args);  /* move down list of args */
	      push_stack(sc, OP_MAP_SIMPLE, sc->args, sc->code);

	      /* now call the function directly -- we know it is a T_CLOSURE
	       *   and that it can be called with one argument, so there's no need to go to
	       *   apply.
	       */

	      NEW_FRAME(sc, closure_environment(sc->code), sc->envir);
	      ADD_SLOT(sc->envir, car(closure_args(sc->code)), sc->x);
	      sc->code = closure_body(sc->code);
	      goto BEGIN;
	    }
	}
      sc->value = safe_reverse_in_place(sc, car(sc->args));

      typeflag(sc->args) = 0;
      (*(sc->free_heap_top++)) = sc->args;
      sc->args = sc->NIL;

      goto START;
      

    case OP_MAP:
      if (sc->value != sc->NO_VALUE)                   /* (map (lambda (x) (values)) (list 1)) */
	{
	  if (is_multiple_value(sc->value))            /* (map (lambda (x) (if (odd? x) (values x (* x 20)) (values))) (list 1 2 3 4)) */
	    cadr(sc->args) = revappend(sc, multiple_value(sc->value), cadr(sc->args));
	  /* not append_in_place here because sc->value has the multiple-values bit set */
	  else cadr(sc->args) = cons(sc, sc->value, cadr(sc->args));
	}

      if (s7_integer(car(sc->args)) < denominator(number(car(sc->args))))
	{
	  if (next_map(sc))
	    goto APPLY_WITHOUT_TRACE;
	}
      
      sc->value = safe_reverse_in_place(sc, cadr(sc->args));
      goto START;

      
      /* -------------------------------- FOR-EACH -------------------------------- */
    case OP_FOR_EACH_SIMPLE:
      /* func = sc->code, func takes one arg, args = arglist 
       *
       * (for-each (lambda (x) (display x)) (list 1 2 3)) 
       */
      if (is_pair(sc->args))
	{
	  /* now call the function directly as in map above. 
	   *
	   * it's possible to preset the frame and its entry so that this allocation happens only
	   *   once per for-each call, but then for-each is like do in that exported args are equivalenced.
	   *   Since the savings isn't huge, I guess I'll go ahead and allocate every time.
	   */
	  NEW_FRAME(sc, closure_environment(sc->code), sc->envir); /*  4 */
	  ADD_SLOT(sc->envir, car(closure_args(sc->code)), car(sc->args)); /*  4 */      /* set function arg value */

	  push_stack(sc, OP_FOR_EACH_SIMPLE, cdr(sc->args), sc->code);
	  sc->code = closure_body(sc->code);
	  goto BEGIN;
	}
      sc->value = sc->UNSPECIFIED;
      goto START;


    case OP_FOR_EACH:
      /* func = sc->code, func-args = cadr(sc->args), counter = car(sc->args), len = denonimator(number(car(sc->args))), object(s) = cddr(sc->args) */
      if (s7_integer(car(sc->args)) < denominator(number(car(sc->args))))
	{
	  if (next_for_each(sc)) 
	    goto APPLY_WITHOUT_TRACE;
	}
      sc->value = sc->UNSPECIFIED;
      goto START;


    case OP_MEMBER_IF:
      /* code=func, args=((val (car list)) list list), value=result of comparison
       */
      if (sc->value != sc->F)            /* previous comparison was not #f -- return list */
	{
	  sc->value = cadr(sc->args);
	  goto START;
	}

      if (!is_pair(cdadr(sc->args)))     /* no more args -- return #f */
	{
	  sc->value = sc->F;
	  goto START;
	}
      cadr(sc->args) = cdadr(sc->args);  /* cdr down arg list */
      push_stack(sc, OP_MEMBER_IF1, sc->args, sc->code);
      cadar(sc->args) = caadr(sc->args);
      sc->args = car(sc->args);
      goto APPLY_WITHOUT_TRACE;


    case OP_MEMBER_IF1:
      if (sc->value != sc->F)            /* previous comparison was not #f -- return list */
	{
	  sc->value = cadr(sc->args);
	  goto START;
	}

      if (!is_pair(cdadr(sc->args)))     /* no more args -- return #f */
	{
	  sc->value = sc->F;
	  goto START;
	}
      cadr(sc->args) = cdadr(sc->args);  /* cdr down arg list */

      /* circular list check */
      if (cadr(sc->args) == cdaddr(sc->args)) 
	{
	  sc->value = sc->F;
	  goto START;
	}
      caddr(sc->args) = cdaddr(sc->args);  /* cdr down the slow list (check for circular list) */

      push_stack(sc, OP_MEMBER_IF, sc->args, sc->code);
      cadar(sc->args) = caadr(sc->args);
      sc->args = car(sc->args);

      goto APPLY_WITHOUT_TRACE;


    case OP_ASSOC_IF1:
    case OP_ASSOC_IF:
      /* code=func, args=((val (caar list)) list), value=result of comparison
       *   (assoc 3 '((1 . a) (2 . b) (3 . c) (4 . d)) =)
       */
      if (sc->value != sc->F)            /* previous comparison was not #f -- return (car list) */
	{
	  sc->value = caadr(sc->args);
	  goto START;
	}

      if (!is_pair(cdadr(sc->args)))     /* (assoc 3 '((1 . 2) . 3) =) or nil */
	{
	  sc->value = sc->F;
	  goto START;
	}
      cadr(sc->args) = cdadr(sc->args);  /* cdr down arg list */

      if (sc->op == OP_ASSOC_IF1)
	{
	  /* circular list check */
	  if (cadr(sc->args) == cdaddr(sc->args))
	    {
	      sc->value = sc->F;
	      goto START;
	    }
	  caddr(sc->args) = cdaddr(sc->args);  /* cdr down the slow list */
	  push_stack(sc, OP_ASSOC_IF, sc->args, sc->code);
	}
      else push_stack(sc, OP_ASSOC_IF1, sc->args, sc->code);

      if (!is_pair(caadr(sc->args)))     /* (assoc 1 '((2 . 2) 3) =) -- we access caaadr below */
	return(eval_error(sc, "assoc: 2nd arg is not an alist: ~S", caddr(sc->args)));
      /* not sure about this -- we could simply skip the entry both here and in g_assoc
       *   (assoc 1 '((2 . 2) 3)) -> #f
       *   (assoc 1 '((2 . 2) 3) =) -> error currently
       */

      cadar(sc->args) = caaadr(sc->args);
      sc->args = car(sc->args);
      goto APPLY_WITHOUT_TRACE;


    case OP_HOOK_APPLY:
      /* args = function args, code = function list */
      if (is_not_null(sc->code))
	{
	  push_stack(sc, OP_HOOK_APPLY, sc->args, cdr(sc->code));
	  sc->code = car(sc->code);
	  goto APPLY;
	}
      goto START;


      /* -------------------------------- DO -------------------------------- */

#if WITH_OPTIMIZATION
      /* (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (display i)) (newline)) 
       * (with-sound () (nrev 0 .1))
       */

    SIMPLE_DOTIMES:
    case OP_SIMPLE_DOTIMES:
      /* set up as in DOTIMES, pull in all the let vars
       *   run body without any jumps: update and check step,
       *   SAFE_C_C of each let var, SAFE_C_C of body
       *   goto START
       */
      {
	s7_pointer vars, init_val;
#if PRINTING
	fprintf(stderr, "simple_dotimes: %s\n", DISPLAY(sc->code));
#endif
	vars = car(sc->code);
	init_val = cadr(car(vars));
	if (s7_is_symbol(init_val))
	  init_val = ARG_SYMBOL_VALUE(init_val, find_symbol_or_bust_12);
	if (s7_is_integer(init_val))
	  {
	    s7_pointer end_expr, end_val, let_var, p;
	    end_expr = caadr(sc->code);
	    end_val = caddr(end_expr);
	    if (s7_is_symbol(end_val))
	      end_val = ARG_SYMBOL_VALUE(end_val, find_symbol_or_bust_12);
	    if (s7_is_integer(end_val))
	      {
		if (s7_integer(init_val) == s7_integer(end_val))
		  {
		    sc->code = cdr(cadr(sc->code));
		    goto BEGIN;
		  }
		sc->envir = new_frame_in_env(sc, sc->envir); 
		sc->args = add_slot(sc, caar(vars), make_mutable_integer(sc, s7_integer(init_val)));
		denominator(number(symbol_value(sc->args))) = s7_integer(end_val);
		initialize_safe_do(sc, sc->code);
		sc->safe_do_level++;
		safe_do_set_id(sc, frame_id(sc->envir));

		/* add the let vars but not initialized yet 
		 */
		for (let_var = car(cdaddr(sc->code)); is_pair(let_var); let_var = cdr(let_var))
		  {
		    add_slot(sc, caar(let_var), sc->UNDEFINED);
#if PRINTING
		    fprintf(stderr, "added %s\n", DISPLAY(caar(let_var)));
#endif
		  }
		
	      SIMPLE_DOTIMES_LOOP:

		/* eval let + body  (cddr(sc->code)) */
#if PRINTING
		fprintf(stderr, "let: %s\n%s\n", DISPLAY_80(cddr(sc->code)), DISPLAY_80(car(cdaddr(sc->code))));
#endif
		for (let_var = car(cdaddr(sc->code)); is_pair(let_var); let_var = cdr(let_var))
		  {
		    p = find_local_symbol(sc, sc->envir, caar(let_var));
#if PRINTING
		    fprintf(stderr, "var: %s %s\n", DISPLAY(caar(let_var)), DISPLAY(cadar(let_var)));
#endif
		    cdr(p) = c_function_call(ecdr(cadar(let_var)))(sc, cdadar(let_var));
		  }
		
		/* (with-sound () (fm-violin 0 .0001 440 .1))
		 */
#if PRINTING
		fprintf(stderr, "let body? %s\n", DISPLAY_80(caddr(caddr(sc->code))));
#endif
		c_function_call(ecdr(caddr(caddr(sc->code))))(sc, cdr(caddr(caddr(sc->code))));

		numerator(number(symbol_value(sc->args)))++;
		if (numerator(number(symbol_value(sc->args))) == denominator(number(symbol_value(sc->args))))
		  {
		    initialize_safe_do(sc, sc->code);
		    sc->code = cdr(cadr(sc->code));
		    sc->safe_do_level--;
		    goto BEGIN;
		  }
		goto SIMPLE_DOTIMES_LOOP;
	      }
	  }
      }


      /* ---------------- */



    DOTIMES:
    case OP_DOTIMES:
      {
	s7_pointer vars, init_val;
#if PRINTING
	fprintf(stderr, "dotimes: %s\n", DISPLAY(sc->code));
#endif
	vars = car(sc->code);
	init_val = cadr(car(vars));
	if (s7_is_symbol(init_val))
	  init_val = ARG_SYMBOL_VALUE(init_val, find_symbol_or_bust_12);
	if (s7_is_integer(init_val))
	  {
	    s7_pointer end_expr, end_val;
	    end_expr = caadr(sc->code);
	    end_val = caddr(end_expr);
	    if (s7_is_symbol(end_val))
	      end_val = ARG_SYMBOL_VALUE(end_val, find_symbol_or_bust_12);
	    if (s7_is_integer(end_val))
	      {
		if (s7_integer(init_val) == s7_integer(end_val))
		  {
		    sc->code = cdr(cadr(sc->code));
		    goto BEGIN;
		  }
		sc->envir = new_frame_in_env(sc, sc->envir); 
		sc->args = add_slot(sc, caar(vars), make_mutable_integer(sc, s7_integer(init_val)));
		denominator(number(symbol_value(sc->args))) = s7_integer(end_val);
		initialize_safe_do(sc, sc->code);
		sc->safe_do_level++;
		safe_do_set_id(sc, frame_id(sc->envir));
		push_stack(sc, OP_DOTIMES_STEP, sc->args, sc->code);
		sc->code = cddr(sc->code);
		goto BEGIN;
	      }
	  }
	else
	  {
	    unoptimize_do(sc, sc->code);
	    car(ecdr(sc->code)) = sc->SIMPLE_DO;
	    goto SIMPLE_DO;
	  }
      }

    case OP_DOTIMES_STEP:
      numerator(number(symbol_value(sc->args)))++;
      if (numerator(number(symbol_value(sc->args))) == denominator(number(symbol_value(sc->args))))
	{
	  initialize_safe_do(sc, sc->code);
	  sc->code = cdr(cadr(sc->code));
	  sc->safe_do_level--;
	  goto BEGIN;
	}
      push_stack(sc, OP_DOTIMES_STEP, sc->args, sc->code);
      sc->code = cddr(sc->code);
      goto BEGIN;



    SIMPLE_DO:
    case OP_SIMPLE_DO:
      {
	s7_pointer init, end;
#if PRINTING
	fprintf(stderr, "simple do: %s\n", DISPLAY(sc->code));
#endif
	sc->envir = new_frame_in_env(sc, sc->envir);
 
	init = cadaar(sc->code);
	if (s7_is_symbol(init))
	  sc->value = ARG_SYMBOL_VALUE(init, find_symbol_or_bust_41);
	else sc->value = init;
	
	end = caddr(car(cadr(sc->code)));
	if (s7_is_symbol(end))
	  sc->args = list_2(sc, add_slot(sc, caaar(sc->code), sc->value), find_symbol(sc, end));
	else sc->args = list_2(sc, add_slot(sc, caaar(sc->code), sc->value), cons_unchecked(sc, end, end));
	/* the list_2 can't be a cons -- if there's a call/cc in the loop, its stack copy 
	 *   assumes that sc->args is either not a list, or a proper list.
	 */
	goto SIMPLE_DO_END;
      }

    case OP_SIMPLE_DO_STEP:
      {
	s7_pointer step;
	step = caddr(caar(sc->code));
	/* fprintf(stderr, "step: %s\n", DISPLAY(step)); */
	if (s7_is_symbol(cadr(step)))
	  {
	    car(sc->T2_1) = symbol_value(car(sc->args));
	    car(sc->T2_2) = caddr(step);
	  }
	else
	  {
	    car(sc->T2_2) = symbol_value(car(sc->args));
	    car(sc->T2_1) = cadr(step);
	  }
	symbol_value(car(sc->args)) = c_function_call(ecdr(step))(sc, sc->T2_1);
      }

    SIMPLE_DO_END:
      {
	s7_pointer end_test;
	end_test = car(cadr(sc->code));
	/* fprintf(stderr, "args: %s\n", DISPLAY(sc->args)); */
	car(sc->T2_1) = symbol_value(car(sc->args));
	car(sc->T2_2) = symbol_value(cadr(sc->args));
	if (is_true(sc, c_function_call(ecdr(end_test))(sc, sc->T2_1)))
	  {
	    sc->code = cdr(cadr(sc->code));
	    goto BEGIN;
	  }
	push_stack(sc, OP_SIMPLE_DO_STEP, sc->args, sc->code);
	sc->code = cddr(sc->code);
	goto BEGIN;
      }
#endif


    #define DO_VAR_SLOT(P) ecdr(P)
    #define DO_VAR_NEW_VALUE(P) cdr(P)
    #define DO_VAR_STEP_EXPR(P) car(P)

    case OP_DO_STEP:
      /* increment all vars, return to endtest 
       *   these are also updated in parallel at the end, so we gather all the incremented values first
       */
      
      /* here we know car(sc->args) is not null */
      push_stack(sc, OP_DO_END, sc->args, sc->code);
      sc->args = car(sc->args);                /* the var data lists */
      sc->code = sc->args;                     /* save the top of the list */


    DO_STEP1:
      /* on each iteration, we first get here with args as the list of var bindings, exprs, and init vals
       *   e.g. (((i . 0) (+ i 1) 0))
       * each arg incr expr is evaluated and the value placed in caddr while we cdr down args
       * finally args is nil...
       */

      if (is_null(sc->args))
	{
	  s7_pointer x;
	  for (x = sc->code; is_not_null(x); x = cdr(x))
	    set_symbol_value(DO_VAR_SLOT(car(x)), DO_VAR_NEW_VALUE(car(x)));

	  /* some schemes rebind here, rather than reset, but that is expensive,
	   *    and only matters once in a blue moon (closure over enclosed lambda referring to a do var)
	   *    and the caller can easily mimic the correct behavior in that case by adding a let or using a named let,
	   *    making the rebinding explicit.
	   *
	   * Hmmm... I'll leave this alone, but there are other less cut-and-dried cases:
	   *
	   *   (let ((j (lambda () 0))
	   *         (k 0))
	   *     (do ((i (j) (j))
	   *          (j (lambda () 1) (lambda () (+ i 1)))) ; bind here hits different "i" than set!
	   *         ((= i 3) k)
	   *       (set! k (+ k i))))
	   *
	   *   is it 6 or 3?
	   *
	   * if we had a way to tell that there were no lambdas in the do expression, would that
	   *   guarantee that set was ok?  Here's a bad case:
	   *
	   *   (let ((f #f))
	   *     (do ((i 0 (+ i 1)))
	   *         ((= i 3))
	   *       (let () ; so that the define is ok
	   *         (define (x) i)
	   *         (if (= i 1) (set! f x))))
	   *    (f))
	   *
	   * s7 says 3, guile says 1.
	   *
	   * I wonder if what they're actually talking about is a kind of shared value problem.  If we
	   *   set the value directly (not the cdr(binding) but, for example, integer(cdr(binding))), then
	   *   every previous reference gets changed as a side-effect.  In the current code, we're "binding" 
	   *   the value in the sense that on each step, a new value is assigned to the step variable.
	   *   In the "direct" case, (let ((v #(0 0 0))) (do ((i 0 (+ i 1))) ((= i 3) v) (set! (v i) i)) 
	   *   would return #(3 3 3).
	   */
	  
	  sc->value = sc->NIL;
	  pop_stack(sc); 
	  goto DO_END;
	}
      push_stack(sc, OP_DO_STEP2, sc->args, sc->code);
      
      /* here sc->args is a list like (((i . 0) (+ i 1) 0) ...)
       *   so sc->code becomes (+ i 1) in this case 
       */
      sc->code = DO_VAR_STEP_EXPR(car(sc->args));
      goto EVAL;
      

    case OP_DO_STEP2:
      DO_VAR_NEW_VALUE(car(sc->args)) = sc->value;            /* save current value */
      sc->args = cdr(sc->args);                               /* go to next step var */
      goto DO_STEP1;
      

    case OP_DO: 
      /* setup is very similar to let */
      /* sc->code is the stuff after "do" */
#if WITH_OPTIMIZATION
      if (is_null(check_do(sc)))
	{
	  if (car(ecdr(sc->code)) == sc->SIMPLE_DO)
	    goto SIMPLE_DO;
	  if (car(ecdr(sc->code)) == sc->SIMPLE_DOTIMES)
	    goto SIMPLE_DOTIMES;
	  goto DOTIMES;
	}
#else
      check_do(sc);
#endif


    case OP_DO_UNCHECKED:
#if PRINTING
      fprintf(stderr, "do: %s\n", DISPLAY(sc->code));
#endif
      if (is_null(car(sc->code)))                           /* (do () ...) -- (let ((i 0)) (do () ((= i 1)) (set! i 1))) */
	{
	  sc->envir = new_frame_in_env(sc, sc->envir); 
	  sc->args = cons_unchecked(sc, sc->NIL, cadr(sc->code));
	  sc->code = cddr(sc->code);
	  goto DO_END;
	}
      
      /* eval each init value, then set up the new frame (like let, not let*) */
      sc->args = sc->NIL;                             /* the evaluated var-data */
      sc->value = sc->code;                           /* protect it */
      sc->code = car(sc->code);                       /* the vars */
      

    DO_INIT:
    case OP_DO_INIT:
      sc->args = cons(sc, sc->value, sc->args);    /* code will be last element (first after reverse) */
      if (is_pair(sc->code))
	{
	  /* here sc->code is a list like: ((i 0 (+ i 1)) ...)
	   *   so cadar gets the init value.
	   *
	   * we accept:
	   *       (do ((i 1) (i 2)) (#t i)) -> 2
	   *       (do () (1) . "hi") -- this is like (do () (#t #t) (asdf))
	   */
	  s7_pointer init;
	  init = cadar(sc->code);
	  if (is_pair(init))
	    {
	      push_stack(sc, OP_DO_INIT, sc->args, cdr(sc->code));
	      sc->code = init;
	      goto EVAL_PAIR;
	    }
	  if (s7_is_symbol(init))
	    sc->value = ARG_SYMBOL_VALUE(init, find_symbol_or_bust_41);
	  else sc->value = init;
	  sc->code = cdr(sc->code);
	  goto DO_INIT;
	}

      /* all the initial values are now in the args list */
      {
	s7_pointer x, y, z;
	sc->args = safe_reverse_in_place(sc, sc->args);
	sc->code = car(sc->args);                       /* saved at the start */
	z = sc->args;
	sc->args = cdr(sc->args);                       /* init values */

	/* sc->envir = new_frame_in_env(sc, sc->envir); */
	/* sc->args was cons'd above, so it should be safe to reuse it as the new frame */
	car(z) = sc->NIL;                  
	cdr(z) = sc->envir;
	set_type(z, T_ENVIRONMENT); 
	frame_id(z) = ++frame_number; 
	sc->envir = z;
	
	/* run through sc->code and sc->args adding '( caar(car(code)) . car(args) ) to sc->envir,
	 *    also reuse the value cells as the new frame slots.
	 */
	sc->value = sc->NIL;
	y = sc->args;
	for (x = car(sc->code); is_not_null(y); x = cdr(x)) 
	  {
	    s7_pointer sym, args, val;
	    sym = caar(x);
	    val = car(y);
	    args = cdr(y);
	    
	    car(y) = sym;
#if 0
	    /* this currently won't work */
	    if (symbol_accessor(sym) >= 0)
	      cdr(y) = call_symbol_bind(sc, sym, val);
	    else cdr(y) = val;
#endif
	    cdr(y) = val;
	    set_type(y, T_PAIR | T_IMMUTABLE | T_DONT_COPY);
	    ecdr(y) = car(sc->envir);
	    car(sc->envir) = y;
	    symbol_id(sym) = frame_id(sc->envir);
	    symbol_local_slot(sym) = y;

	    if (is_not_null(cddar(x)))                /* else no incr expr, so ignore it henceforth */
	      {
		s7_pointer p;
		p = cons(sc, caddar(x), val);
		ecdr(p) = y;
					              /* val is just a place-holder -- this is where we store the new value */
		sc->value = cons_unchecked(sc, p, sc->value);
	      }
	    y = args;
	  }
	
	sc->args = cons(sc, safe_reverse_in_place(sc, sc->value), cadr(sc->code));
	sc->code = cddr(sc->code);
	
	/* here args is a list of 2 or 3 lists, 1st is (list (list (var . binding) incr-expr init-value) ...), 2nd is end-expr, 3rd can be result expr
	 *   so for (do ((i 0 (+ i 1))) ((= i 3) (+ i 1)) ...) args is ((((i . 0) (+ i 1) 0 #f)) (= i 3) (+ i 1))
	 */
      }


    DO_END:
    case OP_DO_END:
      /* here vars have been init'd or incr'd
       *    args = (list var-data end-expr return-expr-if-any)
       *      if (do ((i 0 (+ i 1))) ((= i 3) 10)),            args: (vars (= i 3) 10)
       *      if (do ((i 0 (+ i 1))) ((= i 3))),               args: (vars (= i 3)) and result expr is () == (begin)
       *      if (do ((i 0 (+ i 1))) (#t 10 12)),              args: (vars #t 10 12), result: ([begin] 10 12) -> 12 
       *      if (call-with-exit (lambda (r) (do () () (r)))), args: '(())
       *    code = body
       */

      if (is_not_null(cdr(sc->args)))
	{
	  push_stack(sc, OP_DO_END1, sc->args, sc->code);
	  sc->code = cadr(sc->args);               /* evaluate the end expr */
	  /* fprintf(stderr, "end-test: %s %d %s\n", DISPLAY_80(sc->code), is_optimized(sc->code), opt_names[optimize_data(sc->code)]); */
	  goto EVAL;
	}
      else 
	{
	  /* (do ((...)) () ...) -- no endtest */

	  if (is_null(car(sc->args)))
	    push_stack(sc, OP_DO_END, sc->args, sc->code);
	  else push_stack(sc, OP_DO_STEP, sc->args, sc->code);

	  goto BEGIN;
	}


    case OP_DO_END1:
      /* sc->value is the result of end-test evaluation */
      if (is_true(sc, sc->value))
	{
	  /* we're done -- deal with result exprs 
	   *   if there isn't an end test, there also isn't a result (they're in the same list)
	   */
	  sc->code = cddr(sc->args);                /* result expr (a list -- implicit begin) */
	  /* fprintf(stderr, "result: %s\n", DISPLAY_80(sc->code)); */
	  
	  typeflag(sc->args) = 0;
	  (*(sc->free_heap_top++)) = sc->args;
	  sc->args = sc->NIL;

	  if (is_null(sc->code))
	    {
	      sc->value = sc->NIL;
	      goto START;
	    }
	}
      else
	{
	  /* evaluate the body and step vars, etc */
	  if (is_null(car(sc->args)))
	    push_stack(sc, OP_DO_END, sc->args, sc->code);
	  else push_stack(sc, OP_DO_STEP, sc->args, sc->code);
	  /* sc->code is ready to go */
	}
      /* fall through */


      /* -------------------------------- BEGIN -------------------------------- */

    BEGIN:
    case OP_BEGIN:
      /* sc->args is not used here */
      if (sc->begin_hook)
	{
	  opcode_t op;
	  op = sc->op;
	  push_stack(sc, OP_BARRIER, sc->args, sc->code);
	  if ((*(sc->begin_hook))(sc))
	    {
	      s7_quit(sc);
	      return(sc->F);
	    }
	  pop_stack(sc);
	  sc->op = op; /* for better error handling.  otherwise we get "barrier" as the offending function name in eval_error_with_name */
	}
      /* fall through */

    case OP_BEGIN1:
      {
	s7_pointer code;
	code = sc->code;
	if (!is_pair(code))                   /* (begin) -> () */
	  {
	    if (is_not_null(code))            /* (begin . 1), (cond (#t . 1)) */
	      return(eval_error_with_name(sc, "~A: unexpected dot or '() at end of body? ~A", code));
	    sc->value = sc->NIL;
	    goto START;
	  }
	
	if (type(cdr(code)) != T_NIL)
	  {
	    /* if there are more expressions following, and this is not a pair, it's a no-op!
	     *   but it also might be an error, which I suppose we should catch: (begin +> 1) 
	     *
	     * this double type check is hard to get around: everything would work if we pushed
	     *    nil and caught it on the rebound except multiple values and tail recursion.
	     *    (+ (begin 3 (values 1 2) 4)), (+ 1 (begin (values 5 6) (values 2 3))) etc
	     * moving the is_pair check above up to OP_BEGIN and so on is slower.
	     */
	    push_stack(sc, OP_BEGIN1, sc->NIL, cdr(code)); 
	  }
	sc->code = car(code);

	/* fprintf(stderr, "begin: %s\n", DISPLAY_80(sc->code));  */
      }

    EVAL:
    case OP_EVAL: 
      /* main part of evaluation 
       *   at this point, it's sc->code we care about; sc->args is not relevant.
       */
      /* fprintf(stderr, "    eval: %s\n", DISPLAY_80(sc->code)); */
      sc->cur_code = sc->code;               /* in case an error occurs, this helps tell us where we are */

      if (is_pair(sc->code))
	{
	  /* we jump here when we already know sc->code is a pair */

	EVAL_PAIR:
	  /* fprintf(stderr, "    eval_pair: %s\n", DISPLAY_80(sc->code)); */
	  if (is_syntactic(car(sc->code))) /* actually is_syntax(symbol_value(car(sc->code))) */
	    {
	      /* this can't simply assume syntax if dont_eval_args: (eval (list quasiquote (list values #t))) will segfault
	       */
	      sc->op = (opcode_t)syntax_opcode(car(sc->code));
	      sc->code = cdr(sc->code);
	      goto START_WITHOUT_POP_STACK;
	      /* it is only slightly faster to use labels as values (computed gotos) here
	       */
	    }
	  
	  /* sc->code is a pair, car(sc->code) is not syntax */

#if WITH_OPTIMIZATION
	  if (is_optimized(sc->code))
	    {
	      s7_pointer code;

	    OPT_EVAL:
	      code = sc->code;

	      /* fprintf(stderr, "    opt_eval: %s: %s\n", opt_names[optimize_data(code)], DISPLAY_80(sc->code)); */

	      switch (optimize_data(code))
		{
		case OP_NOT_AN_OP:
		case HOP_NOT_AN_OP:
		  fprintf(stderr, "bad op in opt_eval: op %d, is_opt: %d, %s\n",
 			  optimize_data(code), is_optimized(code), DISPLAY_80(code));
		  break;
		  
		case OP_THUNK:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_THUNK:
		  NEW_FRAME(sc, closure_environment(ecdr(code)), sc->envir);
		  sc->code = closure_body(ecdr(code));
		  goto BEGIN;


		case OP_SAFE_THUNK:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_SAFE_THUNK:
		  /* (let ((x 1)) (let () (define (f) x) (let ((x 0)) (define (g) (set! x 32) (f)) (g)))) */
		  NEW_FRAME(sc, closure_environment(ecdr(code)), sc->envir);
		  /* TODO: do we forego the builtin env in this case? */
		  sc->code = closure_body(ecdr(code));
		  goto BEGIN;


		case OP_SAFE_CLOSURE_C:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_C;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_C:
		  car(sc->T1_1) = cadr(code);
		  sc->args = sc->T1_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;


		case OP_SAFE_CLOSURE_Q:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_SAFE_CLOSURE_Q:
		  car(sc->T1_1) = cadr(cadr(code));
		  sc->args = sc->T1_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  

		case OP_SAFE_CLOSURE_S:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_S;
		      goto OPT_EVAL;
		    }

		case HOP_SAFE_CLOSURE_S:
		  car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_50);
		  sc->args = sc->T1_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;


		case OP_SAFE_CLOSURE_SS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_SS:
		  {
		    s7_pointer val;
		    val = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_59);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_52);
		    car(sc->T2_2) = val;
		    sc->args = sc->T2_1;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }
		  

		case OP_SAFE_CLOSURE_SC:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SC;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_SC:
		  car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_51);
		  car(sc->T2_2) = caddr(code);
		  sc->args = sc->T2_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  

		case OP_SAFE_CLOSURE_CS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_CS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_CS:
		  car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_51);
		  car(sc->T2_1) = cadr(code);
		  sc->args = sc->T2_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  

		case OP_SAFE_CLOSURE_CC:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_CC;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_CC:
		  car(sc->T2_1) = cadr(code);
		  car(sc->T2_2) = caddr(code);
		  sc->args = sc->T2_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  

		case OP_SAFE_CLOSURE_opSq_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_CLOSURE_opSq_opSq:
		  {
		    s7_pointer args, val1, val2;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    val1 = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_53);
		    val2 = c_function_call(ecdr(cadr(args)))(sc, sc->T1_1);
		    
		    car(sc->T2_1) = val1;
		    car(sc->T2_2) = val2;
		    sc->args = sc->T2_1;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }


		case OP_SAFE_CLOSURE_SSS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SSS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_SAFE_CLOSURE_SSS:
		  {
		    s7_pointer x, y, z;
		    z = ARG_SYMBOL_VALUE(cadddr(code), find_symbol_or_bust_18);
		    y = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_12);
		    x = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_60);
		    car(sc->T3_1) = x;
		    car(sc->T3_2) = y;
		    car(sc->T3_3) = z;
		    sc->args = sc->T3_1;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }


		case OP_SAFE_CLOSURE_ALL_S:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_SAFE_CLOSURE_ALL_S:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    sc->w = cons(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_23), sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      sc->w = cons_unchecked(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_28), sc->w);
		    sc->args = safe_reverse_in_place(sc, sc->w);
		    sc->code = ecdr(code);
		    sc->w = sc->NIL;
		    goto SAFE_CLOSURE;
		  }
		  
		  
		case OP_SAFE_CLOSURE_ALL_C:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_SAFE_CLOSURE_ALL_C:
		  sc->args = cdr(sc->code);
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  
		  
		case OP_SAFE_CLOSURE_ALL_G:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_SAFE_CLOSURE_ALL_G:
		  {
		    s7_pointer args, val;
		    args = cdr(code);

		    /* first one is to trigger GC if needed */
		    if (is_pair(car(args)))
		      val = cadr(car(args));
		    else
		      {
			if (s7_is_symbol(car(args)))
			  val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_55);
			else val = car(args);
		      }
		    sc->w = cons(sc, val, sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      {
			if (is_pair(car(args)))
			  val = cadr(car(args));
			else
			  {
			    if (s7_is_symbol(car(args)))
			      val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_55);
			    else val = car(args);
			  }
			sc->w = cons_unchecked(sc, val, sc->w);
		      }

		    sc->args = safe_reverse_in_place(sc, sc->w);
		    sc->w = sc->NIL;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }


		case OP_SAFE_CLOSURE_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_CLOSURE_opSq:
		  car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(code)), find_symbol_or_bust_48);
		  car(sc->T1_1) = c_function_call(ecdr(cadr(code)))(sc, sc->T1_1);
		  sc->args = sc->T1_1;
		  sc->code = ecdr(code);
		  goto SAFE_CLOSURE;
		  

		case OP_SAFE_CLOSURE_opSq_S:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq_S;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_CLOSURE_opSq_S:
		  {
		    s7_pointer val1;
		    val1 = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_47);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(code)), find_symbol_or_bust_48);
		    car(sc->T2_1) = c_function_call(ecdr(cadr(code)))(sc, sc->T1_1);
		    car(sc->T2_2) = val1;
		    sc->args = sc->T2_1;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }
		  break;
		  

		case OP_SAFE_CLOSURE_S_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_S_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_CLOSURE_S_opSq:
		  {
		    s7_pointer val;
		    val = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_47); /* the 1st S */

		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(caddr(code)), find_symbol_or_bust_48);
		    car(sc->T2_2) = c_function_call(ecdr(caddr(code)))(sc, sc->T1_1);
		    car(sc->T2_1) = val;
		    sc->args = sc->T2_1;
		    sc->code = ecdr(code);
		    goto SAFE_CLOSURE;
		  }
		  
		  
		case OP_CLOSURE_C:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_C;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_C:
		  {
		    s7_pointer x;
		    NEW_CELL(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = cadr(code);
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_Q:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_CLOSURE_Q:
		  {
		    s7_pointer x;
		    NEW_CELL(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = cadr(cadr(code));
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_S:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_S;
		      goto OPT_EVAL;
		    }

		case HOP_CLOSURE_S:
		  {
		    s7_pointer x, val;
		    val = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_50);
		    NEW_CELL(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val;
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_SS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_SS:
		  {
		    s7_pointer x, y, val1, val2;
		    val1 = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_66);
		    val2 = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_61);

		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = val1;
		    cdr(y) = sc->NIL;
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val2;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_SC:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SC;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_SC:
		  {
		    s7_pointer x, y, val;
		    val = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_51);

		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = caddr(code);
		    cdr(y) = sc->NIL;
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_CS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_CS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_CS:
		  {
		    s7_pointer x, y, val;
		    val = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_51);

		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = val;
		    cdr(y) = sc->NIL;
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = cadr(code);
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_CC:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_CC;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_CC:
		  {
		    s7_pointer x, y;
		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = caddr(code);
		    cdr(y) = sc->NIL;
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = cadr(code);
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  

		case OP_CLOSURE_opSq_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_CLOSURE_opSq_opSq:
		  {
		    s7_pointer x, y, args, val1, val2;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    val1 = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_53);
		    val2 = c_function_call(ecdr(cadr(args)))(sc, sc->T1_1);

		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = val2;
		    cdr(y) = sc->NIL;
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val1;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }


		case OP_CLOSURE_SSS:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_SSS;
		      goto OPT_EVAL;
		    }
		  
		case HOP_CLOSURE_SSS:
		  {
		    s7_pointer x, y, z, v1, v2, v3, args;
		    args = cdr(code);

		    v1 = ARG_SYMBOL_VALUE(caddr(args), find_symbol_or_bust_12);
		    v2 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_12);
		    v3 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_62);
		    
		    NEW_CELL(sc, z);
		    set_type(z, T_PAIR);
		    car(z) = v1;
		    cdr(z) = sc->NIL;
		    
		    NEW_CELL_NO_CHECK(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = v2;
		    cdr(y) = z;
		    
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = v3;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }


		case OP_CLOSURE_ALL_S:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_CLOSURE_ALL_S:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    sc->w = cons(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_29), sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      sc->w = cons_unchecked(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_46), sc->w);
		    sc->args = safe_reverse_in_place(sc, sc->w);
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    sc->w = sc->NIL;
		    goto CLOSURE;
		  }
		  
		  
		case OP_CLOSURE_ALL_C:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_CLOSURE_ALL_C:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    sc->w = cons(sc, car(args), sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      sc->w = cons_unchecked(sc, car(args), sc->w);
		    sc->args = safe_reverse_in_place(sc, sc->w);
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    sc->w = sc->NIL;
		    goto CLOSURE;
		  }
		  
		  
		case OP_CLOSURE_ALL_G:
		  if (!function_is_ok(code))
		    break;
		  
		case HOP_CLOSURE_ALL_G:
		  {
		    s7_pointer args, val;
		    args = cdr(code);

		    /* first one is to trigger GC if needed */
		    if (is_pair(car(args)))
		      val = cadr(car(args));
		    else
		      {
			if (s7_is_symbol(car(args)))
			  val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_55);
			else val = car(args);
		      }
		    sc->w = cons(sc, val, sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      {
			if (is_pair(car(args)))
			  val = cadr(car(args));
			else
			  {
			    if (s7_is_symbol(car(args)))
			      val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_55);
			    else val = car(args);
			  }
			sc->w = cons_unchecked(sc, val, sc->w);
		      }

		    sc->args = safe_reverse_in_place(sc, sc->w);
		    sc->w = sc->NIL;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }


		case OP_CLOSURE_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_CLOSURE_opSq:
		  {
		    s7_pointer x, val;
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(code)), find_symbol_or_bust_48);
		    val = c_function_call(ecdr(cadr(code)))(sc, sc->T1_1);
		    NEW_CELL(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val;
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  break;
		  

		case OP_CLOSURE_opSq_S:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_opSq_S;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_CLOSURE_opSq_S:
		  {
		    s7_pointer x, y, val, val1, args;
		    args = cdr(code);

		    val1 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_47);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_48);
		    val = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    
		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = val1;
		    cdr(y) = sc->NIL;
		    
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  break;
		  

		case OP_CLOSURE_S_opSq:
		  if (!function_is_ok(code))
		    {
		      optimize_data(code) = OP_UNKNOWN_S_opSq;
		      goto OPT_EVAL;
		    }
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_CLOSURE_S_opSq:
		  {
		    s7_pointer x, y, val, val1;
		    val = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_47); /* the 1st S */

		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(caddr(code)), find_symbol_or_bust_48);
		    val1 = c_function_call(ecdr(caddr(code)))(sc, sc->T1_1);
		    
		    NEW_CELL(sc, y);
		    set_type(y, T_PAIR);
		    car(y) = val1;
		    cdr(y) = sc->NIL;
		    
		    NEW_CELL_NO_CHECK(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = val;
		    cdr(x) = y;
		    sc->args = x;
		    sc->code = ecdr(code);
		    sc->from_eval = true;
		    goto CLOSURE;
		  }
		  break;
		  

		case OP_UNKNOWN_S:
		case HOP_UNKNOWN_S:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_58);
		    /* fprintf(stderr, "f: %s\n", DISPLAY(f)); */
		    
		    switch (type(f))
		      {
		      case T_VECTOR:
			optimize_data(code) = OP_VECTOR_S;
			goto OPT_EVAL;
			
		      case T_C_FUNCTION:
		      case T_C_ANY_ARGS_FUNCTION:
		      case T_C_OPT_ARGS_FUNCTION:
		      case T_C_RST_ARGS_FUNCTION:
		      case T_C_LST_ARGS_FUNCTION:
			if ((is_safe_procedure(f)) &&
			    (c_function_required_args(f) <= 1) &&
			    (c_function_all_args(f) >= 1))
			  {
			    optimize_data(code) = OP_SAFE_C_S;
			    ecdr(code) = f;
			    goto OPT_EVAL;
			  }
			break;
			
		      case T_STRING:
			optimize_data(code) = OP_STRING_S;
			goto OPT_EVAL;
			
		      case T_PAIR:
			optimize_data(code) = OP_PAIR_S;
			goto OPT_EVAL;
			
		      case T_CLOSURE:
			if ((s7_is_symbol(closure_args(f))) ||
			    (safe_list_length(sc, closure_args(f)) == 1))
			  {
			    if (is_safe_closure(closure_body(f)))
			      optimize_data(code) = OP_SAFE_CLOSURE_S;
			    else optimize_data(code) = OP_CLOSURE_S;
			    ecdr(code) = f;
			    goto OPT_EVAL;
			  }
			break;
			
		      case T_CLOSURE_STAR:
			break;
			
		      case T_C_OBJECT:
			if (args_match(sc, f, 1))
			  {
			    optimize_data(code) = OP_C_OBJECT_S;
			    goto OPT_EVAL;
			  }
			break;
			
		      case T_HASH_TABLE:
			optimize_data(code) = OP_HASH_TABLE_S;
			goto OPT_EVAL;
			
			
		      case T_SYNTAX:
			/* car(ecdr(code)) = sc->QUOTE_UNCHECKED; 
			 */
			
			break;
			
		      default:
			break;
		      }

		    break;
		  }
		  
		case OP_UNKNOWN_C:
		case HOP_UNKNOWN_C:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_16);
		    /* fprintf(stderr, "unknown c: f: %s\n", DISPLAY(f)); */
		    
		    if (args_match(sc, f, 1))
		      {
			switch (type(f))
			  {
			  case T_VECTOR:

			    /* fprintf(stderr, "use vector: %d %s\n", s7_is_vector(f), DISPLAY_80(code)); */
			    optimize_data(code) = OP_VECTOR_C;
			    goto OPT_EVAL;
			    
			  case T_C_FUNCTION:
			  case T_C_ANY_ARGS_FUNCTION:
			  case T_C_OPT_ARGS_FUNCTION:
			  case T_C_RST_ARGS_FUNCTION:
			  case T_C_LST_ARGS_FUNCTION:
			    if (is_safe_procedure(f))
			      optimize_data(code) = OP_SAFE_C_C;
			    else break;
			    ecdr(code) = f;
			    goto OPT_EVAL;
			    
			  case T_STRING:
			    optimize_data(code) = OP_STRING_C;
			    goto OPT_EVAL;
			    
			  case T_PAIR:
			    optimize_data(code) = OP_PAIR_C;
			    goto OPT_EVAL;
			    break;
			    
			  case T_CLOSURE:
			    if (is_safe_closure(closure_body(f)))
			      optimize_data(code) = OP_SAFE_CLOSURE_C;
			    else optimize_data(code) = OP_CLOSURE_C;
			    ecdr(code) = f;
			    goto OPT_EVAL;
			    
			  case T_CLOSURE_STAR:
			    break;
			    
			  case T_C_OBJECT:
			    optimize_data(code) = OP_C_OBJECT_C;
			    goto OPT_EVAL;
			    
			  case T_HASH_TABLE:
			    optimize_data(code) = OP_HASH_TABLE_C;
			    goto OPT_EVAL;
			    break;
			    
			  case T_SYNTAX:
			    /* car(ecdr(code)) = sc->QUOTE_UNCHECKED; 
			     */
			    
			    break;
			    
			  default:
			    break;
			  }
		      }

		    break;
		  }
		  
		case OP_UNKNOWN_SS:
		case HOP_UNKNOWN_SS:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_SS;
			else optimize_data(code) = OP_CLOSURE_SS;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_SC:
		case HOP_UNKNOWN_SC:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_SC;
			else optimize_data(code) = OP_CLOSURE_SC;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_CS:
		case HOP_UNKNOWN_CS:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_CS;
			else optimize_data(code) = OP_CLOSURE_CS;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_CC:
		case HOP_UNKNOWN_CC:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_CC;
			else optimize_data(code) = OP_CLOSURE_CC;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_SSS:
		case HOP_UNKNOWN_SSS:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 3)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_SSS;
			else optimize_data(code) = OP_CLOSURE_SSS;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_opSq:
		case HOP_UNKNOWN_opSq:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 1)))
		      {
			/* fprintf(stderr, "opSq: %d %s\n", is_safe_closure(closure_body(f)), DISPLAY_80(code)); */
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_opSq;
			else optimize_data(code) = OP_CLOSURE_opSq;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_opSq_S:
		case HOP_UNKNOWN_opSq_S:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_opSq_S;
			else optimize_data(code) = OP_CLOSURE_opSq_S;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_S_opSq:
		case HOP_UNKNOWN_S_opSq:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);

		    /* fprintf(stderr, "unknown S_opSq: %d %s\n", s7_is_vector(f), DISPLAY_80(code)); */

		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_S_opSq;
			else optimize_data(code) = OP_CLOSURE_S_opSq;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_UNKNOWN_opSq_opSq:
		case HOP_UNKNOWN_opSq_opSq:
		  {
		    s7_pointer f;
		    f = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if ((is_closure(f)) &&
			(args_match(sc, f, 2)))
		      {
			if (is_safe_closure(closure_body(f)))
			  optimize_data(code) = OP_SAFE_CLOSURE_opSq_opSq;
			else optimize_data(code) = OP_CLOSURE_opSq_opSq;
			ecdr(code) = f;
			goto OPT_EVAL;
		      }
		  }
		  break;


		case OP_VECTOR_C:
		case HOP_VECTOR_C:
		  {
		    /* this is the implicit indexing case (vector-ref is a normal safe op) 
		     *    (define (hi) (let ((v (vector 1 2 3))) (v 0)))
		     *    this starts as unknown_c [26608 in optimize_function] -> vector_c
		     *    but it still reports itself as unsafe, so there are higher levels possible
		     */
		    s7_pointer v; 
		    v = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!s7_is_vector(v))
		      break;

		    /* fprintf(stderr, "vector_c: %d %s\n", s7_is_vector(v), DISPLAY_80(code)); */
		  
		    if (!vector_is_multidimensional(v))
		      {
			s7_Int index;
			index = s7_integer(cadr(code));
			if (index < vector_length(v))
			  {
			    sc->value = vector_elements(v)[index];
			    goto START;
			  }
		      }
		    sc->value = vector_ref_1(sc, v, cdr(code));
		    goto START;
		  }

		case OP_VECTOR_S:
		case HOP_VECTOR_S:
		  {
		    s7_pointer v, ind; 
		    v = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    ind = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_31);
		    if ((!s7_is_vector(v)) ||
			(!s7_is_integer(ind)))
		      break;
		  
		    if (!vector_is_multidimensional(v))
		      {
			s7_Int index;
			index = s7_integer(ind);
			if (index < vector_length(v))
			  {
			    sc->value = vector_elements(v)[index];
			    goto START;
			  }
		      }
		    sc->value = vector_ref_1(sc, v, cons(sc, ind, sc->NIL));
		    goto START;
		  }

		case OP_STRING_C:
		case HOP_STRING_C:
		  {
		    s7_Int index;
		    s7_pointer s;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!s7_is_string(s))
		      break;

		    index = s7_integer(cadr(code));
		    if (index < string_length(s))
		      {
			sc->value = s7_make_character(sc, ((unsigned char *)string_value(s))[index]);
			goto START;
		      }
		    sc->value = string_ref_1(sc, s, cadr(code));
		    goto START;
		  }
		  

		case OP_STRING_S:
		case HOP_STRING_S:
		  {
		    s7_Int index;
		    s7_pointer s, ind;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    ind = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_31);
		    if ((!s7_is_string(s)) ||
			(!s7_is_integer(ind)))
		      break;

		    index = s7_integer(ind);
		    if (index < string_length(s))
		      {
			sc->value = s7_make_character(sc, ((unsigned char *)string_value(s))[index]);
			goto START;
		      }
		    sc->value = string_ref_1(sc, s, cons(sc, ind, sc->NIL));
		    goto START;
		  }
		  

		case OP_HASH_TABLE_C:
		case HOP_HASH_TABLE_C:
		  {
		    s7_pointer s;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!s7_is_hash_table(s))
		      break;

		    sc->value = s7_hash_table_ref(sc, s, cadr(code));
		    goto START;
		  }
		  

		case OP_HASH_TABLE_S:
		case HOP_HASH_TABLE_S:
		  {
		    s7_pointer s;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!s7_is_hash_table(s))
		      break;

		    sc->value = s7_hash_table_ref(sc, s, ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_31));
		    goto START;
		  }
		  

		case OP_PAIR_C:
		case HOP_PAIR_C:
		  {
		    s7_pointer s;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!is_pair(s))
		      break;

		    sc->value = list_ref_1(sc, s, cadr(code));
		    goto START;
		  }
		  

		case OP_PAIR_S:
		case HOP_PAIR_S:
		  {
		    s7_pointer s, ind;
		    s = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!is_pair(s))
		      break;
		    ind = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_31);

		    sc->value = list_ref_1(sc, s, ind);
		    goto START;
		  }
		  

		case OP_C_OBJECT_C:
		case HOP_C_OBJECT_C:
		  {
		    s7_pointer c;
		    c = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!is_c_object(c))
		      break;
		    sc->value = (*(object_ref(c)))(sc, c, cdr(code));
		    goto START;
		  }

		case OP_C_OBJECT_S:
		case HOP_C_OBJECT_S:
		  {
		    s7_pointer c;
		    c = ARG_SYMBOL_VALUE(car(code), find_symbol_or_bust_31);
		    if (!is_c_object(c))
		      break;
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_31);
		    sc->value = (*(object_ref(c)))(sc, c, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_C:
		  sc->value = c_function_call(ecdr(code))(sc, cdr(code)); /* this includes all safe calls where all args are constants */
		  goto START;
		  

		case OP_SAFE_C_Q:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_Q:
		  car(sc->T1_1) = cadar(cdr(code));
		  sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		  goto START;
		  

		case OP_SAFE_C_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_S:
		  car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_21);
		  sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		  goto START;

		  
		  /* an experiment that extends clm2xen generator lookup
		   *
		   * TODO:
		   *   need safe_simple_do since this is safe even with arbitrary sets and so on
		   *   once established, macroize the lookup process
		   */

		  /* (define (hi) (do ((i 0 (+ i 1))) ((= i 3)) (display i)) (newline))
		   */
		case OP_SAFE_DO_C_S:
		  /* fprintf(stderr, "op check: %s\n", DISPLAY(code)); */
		  /* this should not happen -- callgrind is confused */
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_DO_C_S:
		  /* assume its safe for now (clm2xen checks s7_in_safe_do, but that's too restrictive here)
		   */
		  {
		    s7_pointer val, sym;
		    /* fprintf(stderr, "hop check: %s\n", DISPLAY(code)); */
		    sym = cadr(code);
		    val = (s7_pointer)symbol_op_data(sym);
		    if (!val)
		      {
			val = find_symbol(sc, sym);
			/* fprintf(stderr, "%s null: %s\n", DISPLAY(sym), DISPLAY(val)); */
			if (is_null(val)) 
			  {
			    car(sc->T1_1) = unbound_variable(sc, sym);
			    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
			    goto START;
			  }
			if (s7_is_do_local_or_global(sc, sym))
			  {
			    /* fprintf(stderr, "set op_data\n"); */
			    symbol_op_data(sym) = (void *)val;
			  }
		      }
		    car(sc->T1_1) = symbol_value(val);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_QC:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_QC:
		  car(sc->T2_1) = cadr(cadr(code));
		  car(sc->T2_2) = cadr(cdr(code));
		  sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		  goto START;
		  

		case OP_SAFE_C_CQ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_CQ:
		  car(sc->T2_1) = cadr(code);
		  car(sc->T2_2) = cadr(cadr(cdr(code)));
		  sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		  goto START;
		  

		case OP_SAFE_C_SS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_SS:
		  {
		    s7_pointer val, args;
		    args = cdr(code);
		    val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_57);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_25);
		    car(sc->T2_1) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;

		  }
		  
		case OP_SAFE_C_ALL_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_ALL_S:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    sc->w = cons(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_56), sc->NIL);
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      sc->w = cons_unchecked(sc, ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_56), sc->w);
		    sc->value = c_function_call(ecdr(code))(sc, safe_reverse_in_place(sc, sc->w));
		    sc->w = sc->NIL;
		    goto START;

		  }
		  
		case OP_SAFE_C_SC:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_SC:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_14);
		    car(sc->T2_2) = cadr(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_CS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_CS:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_15);
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }
		  

		case OP_SAFE_C_SQ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_SQ:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_36);
		    car(sc->T2_2) = cadr(cadr(args));
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }
		  

		case OP_SAFE_C_QS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_QS:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_15);
		    car(sc->T2_1) = cadr(car(args));
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }
		  

		case OP_SAFE_C_QQ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_QQ:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = cadr(car(args));
		    car(sc->T2_2) = cadr(cadr(args));
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_XXX:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_XXX:
		  {
		    s7_pointer arg, val1, val2, val3, args;
		    args = cdr(code);
		    
		    arg = car(args);
		    if (s7_is_symbol(arg))
		      val1 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val1 = arg;
		    
		    arg = cadr(args);
		    if (s7_is_symbol(arg))
		      val2 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val2 = arg;
		    
		    arg = caddr(args);
		    if (s7_is_symbol(arg))
		      val3 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val3 = arg;
		    
		    car(sc->T3_1) = val1;
		    car(sc->T3_2) = val2;
		    car(sc->T3_3) = val3;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T3_1);
		    goto START;
		  }
		  

		case OP_SAFE_C_opXXXq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opXXXq:
		  {
		    s7_pointer arg, val1, val2, val3, args;
		    args = cdr(cadr(code));
		    
		    arg = car(args);
		    if (s7_is_symbol(arg))
		      val1 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val1 = arg;
		    
		    arg = cadr(args);
		    if (s7_is_symbol(arg))
		      val2 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val2 = arg;
		    
		    arg = caddr(args);
		    if (s7_is_symbol(arg))
		      val3 = ARG_SYMBOL_VALUE(arg, find_symbol_or_bust_30);
		    else val3 = arg;
		    
		    car(sc->T3_1) = val1;
		    car(sc->T3_2) = val2;
		    car(sc->T3_3) = val3;
		    car(sc->T1_1) = c_function_call(ecdr(cadr(code)))(sc, sc->T3_1);

		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }
		  
		case OP_SAFE_C_Z:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;

		case HOP_SAFE_C_Z:
		  push_stack(sc, OP_SAFE_C_P_1, sc->NIL, sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_CZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_CZ:
		  push_stack(sc, OP_SAFE_C_SZ_1, cadr(code), sc->code);
		  sc->code = caddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZC:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;

		case HOP_SAFE_C_ZC:
		  push_stack(sc, OP_SAFE_C_ZS_1, caddr(code), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_QZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_QZ:
		  push_stack(sc, OP_SAFE_C_SZ_1, cadr(cadr(code)), sc->code);
		  sc->code = caddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZQ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;

		case HOP_SAFE_C_ZQ:
		  push_stack(sc, OP_SAFE_C_ZS_1, cadr(caddr(code)), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_SZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_SZ:
		  push_stack(sc, OP_SAFE_C_SZ_1, ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_45), sc->code);
		  sc->code = caddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;

		case HOP_SAFE_C_ZS:
		  push_stack(sc, OP_SAFE_C_ZS_1, ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_45), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_ZZ:
		  push_stack(sc, OP_SAFE_C_ZZ_1, sc->NIL, sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  


		case OP_SAFE_C_ZXX:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;

		case HOP_SAFE_C_ZXX:
		  push_stack(sc, OP_SAFE_C_ZXX_1, (s7_is_symbol(caddr(code))) ? ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_45) : caddr(code), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_XZX:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_XZX:
		  push_stack(sc, OP_SAFE_C_XZX_1, (s7_is_symbol(cadr(code))) ? ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_45) : cadr(code), sc->code);
		  sc->code = caddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_XXZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadddr(code)))
		    break;

		case HOP_SAFE_C_XXZ:
		  push_stack(sc, OP_SAFE_C_XXZ_1, (s7_is_symbol(cadr(code))) ? ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_45) : cadr(code), sc->code);
		  sc->code = cadddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZZX:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_SAFE_C_ZZX:
		  push_stack(sc, OP_SAFE_C_ZZX_1, (s7_is_symbol(cadddr(code))) ? ARG_SYMBOL_VALUE(cadddr(code), find_symbol_or_bust_45) : cadddr(code), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZXZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, cadddr(code)))
		    break;

		case HOP_SAFE_C_ZXZ:
		  push_stack(sc, OP_SAFE_C_ZXZ_1, (s7_is_symbol(caddr(code))) ? ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_45) : caddr(code), sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_XZZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  if (!c_function_is_ok(sc, cadddr(code)))
		    break;

		case HOP_SAFE_C_XZZ:
		  push_stack(sc, OP_SAFE_C_XZZ_1, (s7_is_symbol(cadr(code))) ? ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_45) : cadr(code), sc->code);
		  sc->code = caddr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_SAFE_C_ZZZ:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  if (!c_function_is_ok(sc, cadddr(code)))
		    break;

		case HOP_SAFE_C_ZZZ:
		  push_stack(sc, OP_SAFE_C_ZZZ_1, sc->NIL, sc->code);
		  sc->code = cadr(sc->code);
		  goto OPT_EVAL;
		  

		case OP_C_S_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;

		case HOP_C_S_opSq:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_45);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_45);
		    sc->args = list_2(sc, val, c_function_call(ecdr(cadr(args)))(sc, sc->T1_1));
		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }


		case OP_C_ALL_G:
		case OP_SAFE_C_ALL_G:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_C_ALL_G:
		case HOP_SAFE_C_ALL_G:
		  {
		    s7_pointer args, val;
		    args = cdr(code);

		    if (is_pair(car(args)))
		      val = cadr(car(args));
		    else
		      {
			if (s7_is_symbol(car(args)))
			  val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_35);
			else val = car(args);
		      }
		    sc->w = cons(sc, val, sc->NIL);   /* first one is to trigger GC if needed */
		    for (args = cdr(args); is_pair(args); args = cdr(args))
		      {
			if (is_pair(car(args)))
			  val = cadr(car(args));
			else
			  {
			    if (s7_is_symbol(car(args)))
			      val = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_35);
			    else val = car(args);
			  }
			sc->w = cons_unchecked(sc, val, sc->w);
		      }

		    sc->value = c_function_call(ecdr(code))(sc, safe_reverse_in_place(sc, sc->w));
		    sc->w = sc->NIL;
		    goto START;
		  }
		  

		case OP_SAFE_C_SSS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_SSS:
		  {
		    s7_pointer val1, val2, args;
		    args = cdr(code);

		    val1 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_30);
		    val2 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_30);
		    car(sc->T3_3) = ARG_SYMBOL_VALUE(caddr(args), find_symbol_or_bust_30);
		    car(sc->T3_1) = val1;
		    car(sc->T3_2) = val2;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T3_1);
		    goto START;
		  }
		  
		  /* now ops that need extra op name checks */
		  
		case OP_SAFE_C_opCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCq:
		  car(sc->T1_1) = c_function_call(ecdr(car(cdr(code))))(sc, cdar(cdr(code))); /* OP_SAFE_C_C can involve any number of ops */
		  sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		  goto START;

		  
		case OP_SAFE_C_opQq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opQq:
		  car(sc->T1_1) = cadr(cadr(car(cdr(code))));
		  car(sc->T1_1) = c_function_call(ecdr(car(cdr(code))))(sc, sc->T1_1);
		  sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		  goto START;

		  
		case OP_SAFE_C_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSq:
		  {
		    s7_pointer args;
		    args = cadr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_49);
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T1_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }
		  
		  
		case OP_SAFE_C_P:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_P:
		  {
		    s7_pointer func;
		    func = ecdr(sc->code);
		    push_stack(sc, OP_EVAL_ARGS_P_1, sc->NIL, func); /* catch values etc */
		    sc->code = cadr(sc->code);
		    goto EVAL_PAIR;
		  }
		  

		case OP_SAFE_C_PS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_PS:
		  push_stack(sc, OP_EVAL_ARGS_P_3, sc->NIL, sc->code);
		  sc->code = cadr(sc->code);
		  goto EVAL_PAIR;
		  

		case OP_SAFE_C_PC:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_PC:
		  push_stack(sc, OP_EVAL_ARGS_P_4, sc->NIL, sc->code);
		  sc->code = cadr(sc->code);
		  goto EVAL_PAIR;
		  

		case OP_SAFE_C_SP:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_SP:
		  {
		    s7_pointer x, func;
		    func = ecdr(sc->code);
		    sc->x = ARG_SYMBOL_VALUE(cadr(sc->code), find_symbol_or_bust_47);
		    NEW_CELL(sc, x);  /*    4 */
		    set_type(x, T_PAIR);
		    car(x) = sc->x;
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    push_stack(sc, OP_EVAL_ARGS_P_2, sc->args, func);
		    sc->code = caddr(sc->code);
		    goto EVAL_PAIR;
		  }
		  

		case OP_SAFE_C_CP:
		  if (!c_function_is_ok(sc, code))
		    break;
		  
		case HOP_SAFE_C_CP:
		  {
		    s7_pointer x, func;
		    func = ecdr(sc->code);
		    NEW_CELL(sc, x);
		    set_type(x, T_PAIR);
		    car(x) = cadr(sc->code);
		    cdr(x) = sc->NIL;
		    sc->args = x;
		    push_stack(sc, OP_EVAL_ARGS_P_2, sc->args, func);
		    sc->code = caddr(sc->code);
		    goto EVAL_PAIR;
		  }
		  
		  
		case OP_SAFE_C_opSSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSSq:
		  {
		    s7_pointer args, val1;
		    args = cadr(code);
		    val1 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_11);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(args), find_symbol_or_bust_13);
		    car(sc->T2_1) = val1;
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T2_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSCq:
		  {
		    s7_pointer args;
		    args = cadr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_14);
		    car(sc->T2_2) = caddr(args);
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T2_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opCSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCSq:
		  {
		    s7_pointer args;
		    args = cadr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(args), find_symbol_or_bust_64);
		    car(sc->T2_1) = cadr(args);
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T2_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSQq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSQq:
		  {
		    s7_pointer args;
		    args = cadr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_19);
		    car(sc->T2_2) = cadr(caddr(args)); 
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T2_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opQSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opQSq:
		  {
		    s7_pointer args;
		    args = cadr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(args), find_symbol_or_bust_19);
		    car(sc->T2_1) = cadr(cadr(args)); 
		    car(sc->T1_1) = c_function_call(ecdr(args))(sc, sc->T2_1);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T1_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_S_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_S_opSq:
		  {
		    s7_pointer args, val;
		    args = caddr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_44);
		    val = c_function_call(ecdr(args))(sc, sc->T1_1);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(code), find_symbol_or_bust_43);
		    car(sc->T2_2) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		case OP_SAFE_C_S_opCq: 
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_S_opCq: 
		  {
		    s7_pointer val1, args;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_17);
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, cdr(cadr(args))); /* any number of constants here */
		    car(sc->T2_1) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_C_opSq:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T1_1);
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C_opCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_C_opCq:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, cdr(cadr(args))); /* any # of args */
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C_opCSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_C_opCSq:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = cadr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opCSq_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCSq_C:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = cadr(car(args));
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = cadr(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C_opSSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_C_opSSq:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    val = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = val;
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSSq_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSSq_C:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    val = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = val;
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = cadr(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSSq_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSSq_S:
		  {
		    s7_pointer args, val, val1;
		    args = cdr(code);
		    val = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_17);
		    val1 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = val;
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSCq_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSCq_S:
		  {
		    s7_pointer args, val1;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_17);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = caddr(car(args));
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSCq_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSCq_C:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = caddr(car(args));
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = cadr(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opCSq_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCSq_S:
		  {
		    s7_pointer args, val1;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(car(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = cadr(car(args));
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_S_opSCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_S_opSCq:
		  {
		    s7_pointer val1, args;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_17);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = caddr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_C_opSCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_C_opSCq:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = caddr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = car(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_S_opSSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_S_opSSq:
		  {
		    s7_pointer val1, val2, args;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_17);
		    val2 = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = val2;
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_S_opCSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_S_opCSq:
		  {
		    s7_pointer val1, args;
		    args = cdr(code);
		    val1 = ARG_SYMBOL_VALUE(car(args), find_symbol_or_bust_17);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(cadr(args)), find_symbol_or_bust_17);
		    car(sc->T2_1) = cadr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = val1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSq_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSq_S:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_20);
		    val = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T2_2) = ARG_SYMBOL_VALUE(cadr(args), find_symbol_or_bust_24);
		    car(sc->T2_1) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opCq_S:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCq_S:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    val = SYMBOL_VALUE(cadr(args), find_symbol_or_bust_32);
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, cdr(car(args)));
		    car(sc->T2_2) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opCq_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opCq_C:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, cdr(car(args)));
		    car(sc->T2_2) = cadr(args); /* the 2nd C stands for 1 arg? */
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSq_C:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  
		case HOP_SAFE_C_opSq_C:
		  {
		    s7_pointer args;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_33);
		    car(sc->T2_1) = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T2_2) = cadr(args);
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSq_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opSq_opSq:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    val = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_53);
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T1_1);
		    car(sc->T2_1) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }


		case OP_SAFE_C_opSq_opAq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opSq_opAq:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    val = c_function_call(ecdr(car(args)))(sc, sc->T1_1);
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T1_1);
		    car(sc->T2_1) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }


		case OP_SAFE_C_opCq_opCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opCq_opCq:
		  {
		    s7_pointer args, val;
		    args = cdr(code);
		    val = c_function_call(ecdr(car(args)))(sc, cdr(car(args)));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, cdr(cadr(args)));
		    car(sc->T2_1) = val;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }


		case OP_SAFE_C_opSCq_opSCq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opSCq_opSCq:
		  {
		    s7_pointer args, val2, opval1;
		    args = cdr(code);
		    val2 = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_53);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    car(sc->T2_2) = caddr(car(args));
		    opval1 = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = val2;
		    car(sc->T2_2) = caddr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = opval1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSCq_opACq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opSCq_opACq:
		  {
		    s7_pointer args, val2, opval1;
		    args = cdr(code);
		    val2 = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_53);
		    car(sc->T2_1) = val2;
		    car(sc->T2_2) = caddr(car(args));
		    opval1 = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_2) = caddr(cadr(args));
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = opval1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }

		  
		case OP_SAFE_C_opSSq_opSSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(code)))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  
		case HOP_SAFE_C_opSSq_opSSq:
		  {
		    s7_pointer args, val3, val4, opval1;
		    args = cdr(code);

		    val3 = ARG_SYMBOL_VALUE(caddr(car(args)), find_symbol_or_bust_45);
		    val4 = ARG_SYMBOL_VALUE(caddr(cadr(args)), find_symbol_or_bust_53);
		    
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(car(args)), find_symbol_or_bust_45);
		    car(sc->T2_2) = val3;
		    opval1 = c_function_call(ecdr(car(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(cadr(args)), find_symbol_or_bust_53);
		    car(sc->T2_2) = val4;
		    car(sc->T2_2) = c_function_call(ecdr(cadr(args)))(sc, sc->T2_1);
		    car(sc->T2_1) = opval1;
		    sc->value = c_function_call(ecdr(code))(sc, sc->T2_1);
		    goto START;
		  }


		case OP_SAFE_C_opSAFE_CLOSURE_SSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!function_is_ok(cadr(code)))
		    break;

		case HOP_SAFE_C_opSAFE_CLOSURE_SSq:
		  {
		    s7_pointer val;
		    val = ARG_SYMBOL_VALUE(caddr(cadr(code)), find_symbol_or_bust_67);
		    car(sc->T2_1) = ARG_SYMBOL_VALUE(cadr(cadr(code)), find_symbol_or_bust_63);
		    car(sc->T2_2) = val;
		    push_stack(sc, OP_SAFE_C_P_1, sc->code, sc->code);
		    sc->args = sc->T2_1;
		    sc->code = ecdr(cadr(code));
		    goto SAFE_CLOSURE;
		  }

		case OP_SAFE_C_opSAFE_CLOSURE_opSq_Sq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, cadr(cadr(code))))
		    break;
		  if (!function_is_ok(cadr(code)))
		    break;

		case HOP_SAFE_C_opSAFE_CLOSURE_opSq_Sq:
		  {
		    s7_pointer val1, arg;
		    arg = cadr(code);
		    val1 = ARG_SYMBOL_VALUE(caddr(arg), find_symbol_or_bust_47);
		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(cadr(arg)), find_symbol_or_bust_48);
		    car(sc->T2_1) = c_function_call(ecdr(cadr(arg)))(sc, sc->T1_1);
		    car(sc->T2_2) = val1;
		    push_stack(sc, OP_SAFE_C_P_1, sc->code, sc->code);
		    sc->args = sc->T2_1;
		    sc->code = ecdr(arg);
		    goto SAFE_CLOSURE;
		  }


		case OP_C_L:
		  if (!c_function_is_ok(sc, code))
		    break;
		  check_lambda_args(sc, cadr(cadr(code)));

		case HOP_C_L:
		  {
		    s7_pointer x, arg1;

		    NEW_CELL(sc, x);
		    car(x) = cdr(cadr(code));
		    cdr(x) = sc->envir;
		    set_type(x, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, arg1);
		    set_type(arg1, T_PAIR);
		    car(arg1) = x;
		    cdr(arg1) = sc->NIL;
		    sc->args = arg1;

		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }


		case OP_C_LL:
		  if (!c_function_is_ok(sc, code))
		    break;
		  check_lambda_args(sc, cadr(cadr(code)));
		  check_lambda_args(sc, cadr(caddr(code)));

		case HOP_C_LL:
		  {
		    s7_pointer x, y, arg1, arg2;
		    NEW_CELL(sc, x);
		    car(x) = cdr(cadr(code));
		    cdr(x) = sc->envir;
		    set_type(x, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, y);
		    car(y) = cdr(caddr(code));
		    cdr(y) = sc->envir;
		    set_type(y, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, arg1);
		    set_type(arg1, T_PAIR);
		    car(arg1) = x;

		    NEW_CELL_NO_CHECK(sc, arg2);
		    set_type(arg2, T_PAIR);
		    car(arg2) = y;
		    cdr(arg1) = arg2;
		    cdr(arg2) = sc->NIL;
		    sc->args = arg1;

		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }


		case OP_C_LS:
		  if (!c_function_is_ok(sc, code))
		    break;
		  check_lambda_args(sc, cadr(cadr(code)));

		case HOP_C_LS:
		  {
		    s7_pointer x, arg1, arg2;
		    NEW_CELL(sc, x);
		    car(x) = cdr(cadr(code));
		    cdr(x) = sc->envir;
		    set_type(x, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, arg1);
		    set_type(arg1, T_PAIR);
		    car(arg1) = x;

		    NEW_CELL_NO_CHECK(sc, arg2);
		    set_type(arg2, T_PAIR);
		    cdr(arg1) = arg2;
		    sc->args = arg1;
		    car(arg2) = ARG_SYMBOL_VALUE(caddr(code), find_symbol_or_bust_27);
		    cdr(arg2) = sc->NIL;

		    /* (define (hi a) (for-each (lambda (n) (display n) (newline)) a)) (hi '(1 2 3)) */
		    
		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }


		case OP_C_L_opSq:
		  if (!c_function_is_ok(sc, code))
		    break;
		  if (!c_function_is_ok(sc, caddr(code)))
		    break;
		  check_lambda_args(sc, cadr(cadr(code)));

		case HOP_C_L_opSq:
		  {
		    s7_pointer x, arg1, arg2;
		    NEW_CELL(sc, x);
		    car(x) = cdr(cadr(code));
		    cdr(x) = sc->envir;
		    set_type(x, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, arg1);
		    set_type(arg1, T_PAIR);
		    car(arg1) = x;

		    NEW_CELL_NO_CHECK(sc, arg2);
		    set_type(arg2, T_PAIR);
		    cdr(arg1) = arg2;
		    sc->args = arg1;

		    car(sc->T1_1) = ARG_SYMBOL_VALUE(cadr(caddr(code)), find_symbol_or_bust_27);
		    car(arg2) = c_function_call(ecdr(caddr(code)))(sc, sc->T1_1);
		    cdr(arg2) = sc->NIL;

		    /* (define (hi a) (for-each (lambda (n) (display n) (newline)) a)) (hi '(1 2 3)) */
		    
		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }


		case OP_C_CLL:
		  if (!c_function_is_ok(sc, code))
		    break;
		  check_lambda_args(sc, cadr(caddr(code)));
		  check_lambda_args(sc, cadr(cadddr(code)));

		case HOP_C_CLL:
		  {
		    s7_pointer x, y, arg1, arg2, arg3;
		    NEW_CELL(sc, x);
		    car(x) = cdr(caddr(code));
		    cdr(x) = sc->envir;
		    set_type(x, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, y);
		    car(y) = cdr(cadddr(code));
		    cdr(y) = sc->envir;
		    set_type(y, T_CLOSURE | T_PROCEDURE | T_DONT_COPY);

		    NEW_CELL_NO_CHECK(sc, arg1);
		    set_type(arg1, T_PAIR);
		    car(arg1) = cadr(code);

		    NEW_CELL_NO_CHECK(sc, arg2);
		    set_type(arg2, T_PAIR);
		    car(arg2) = x;
		    cdr(arg1) = arg2;

		    NEW_CELL_NO_CHECK(sc, arg3);
		    set_type(arg3, T_PAIR);
		    car(arg3) = y;
		    cdr(arg2) = arg3;
		    cdr(arg3) = sc->NIL;
		    sc->args = arg1;

		    sc->value = c_function_call(ecdr(code))(sc, sc->args);
		    goto START;
		  }



 		default:
 		  fprintf(stderr, "bad op in opt_eval: op %d, is_opt: %d, %s\n",
 			  optimize_data(code), is_optimized(code), DISPLAY_80(code));
 		  break;
		}

	      /* else cancel all the optimization info -- someone stepped on our symbol */
	      clear_optimized(code);
	      clear_optimize_data(code);
	      ecdr(code) = sc->NIL;
	      /* and fall into the normal evaluator */
	    }
#endif
	  
	  /* fprintf(stderr, "unopt: %s\n", DISPLAY_80(sc->code)); */
	  /* trailers */
	  {
	    s7_pointer carc;
	    carc = car(sc->code);
	    if (s7_is_symbol(carc))
	      {
		/* car is a symbol, sc->code a list */
		sc->value = SYMBOL_VALUE(carc, find_symbol_or_bust);
		sc->code = cdr(sc->code);
		sc->args = sc->NIL;
		/* drop into eval args
		 */
	      }
	    else
	      {
		/* very uncommon case: car is either itself a pair or some non-symbol */
		if (is_pair(carc))
		  {
		    /* evaluate the inner list */
		    push_stack(sc, OP_EVAL_ARGS, sc->NIL, cdr(sc->code));
		    if (is_syntactic(car(carc)))
		      {
			if ((car(carc) == sc->QUOTE) &&        /* ('and #f) */
			    (is_syntactic(cadr(carc))))
			  return(apply_error(sc, cadr(carc), cdr(sc->code)));
			
			sc->op = (opcode_t)syntax_opcode(car(carc));
			sc->code = cdr(carc);
			goto START_WITHOUT_POP_STACK;
		      }
		    
		    push_stack(sc, OP_EVAL_ARGS, sc->NIL, cdr(carc));
		    sc->code = car(carc);
		    goto EVAL;
		  }
		else
		  {
		    /* car must be the function to be applied */
		    sc->value = carc;
		    sc->code = cdr(sc->code);
		    sc->args = sc->NIL;
		    /* drop into OP_EVAL_ARGS */
		  }
	      }
	  }
	}
      else
	{
	  /* here sc->code is not a pair */
	  if (s7_is_symbol(sc->code))
	    {
	      /* fprintf(stderr, "eval: %s from %s\n", s7_object_to_c_string(sc, sc->code), s7_object_to_c_string(sc, sc->cur_code)); */
	      
	      sc->value = ARG_SYMBOL_VALUE(sc->code, find_symbol_or_bust_1);
	      pop_stack(sc);
	      if (sc->op != OP_EVAL_ARGS)
		goto START_WITHOUT_POP_STACK;
	      /* drop into EVAL_ARGS */
	    }
	  else
	    {
	      /* sc->code is not a pair or a symbol */
	      
	      /* fprintf(stderr, "eval: %s from %s\n", s7_object_to_c_string(sc, code), s7_object_to_c_string(sc, sc->cur_code)); */
	      
	      sc->value = sc->code;
	      goto START;
	    }
	}
      /* sc->value is car=something applicable
       * sc->code = rest of expression
       * sc->args is nil (set by the drop-through cases above -- perhaps clearer to bring that down?)
       */
      
      
    case OP_EVAL_ARGS:
      /* fprintf(stderr, "    op_eval_args: %s %s\n", DISPLAY(sc->value), DISPLAY_80(sc->code)); */

      if (dont_eval_args(sc->value))
	{
	  if (is_any_macro(sc->value))
	    {    
	      /* macro expansion */
	      push_stack(sc, OP_EVAL_MACRO, sc->NIL, sc->code); /* sc->code is here for (vital) GC protection */
	      /* 
	       * pass a list (mac . args) to the macro expander
	       */
	      car(sc->TEMP_CELL_1) = sc->value; /* macro */
	      cdr(sc->TEMP_CELL_1) = sc->code;  /* args */
	      sc->args = sc->TEMP_CELL;
	      sc->code = sc->value;
	      goto APPLY_WITHOUT_TRACE;
	    }

	  /* (define progn begin)
	   * (progn (display "hi") (+ 1 23))
	   */
	  sc->op = (opcode_t)syntax_opcode(sc->value);
	  goto START_WITHOUT_POP_STACK;
	}

      /* sc->value is the func
       *   we don't have to delay lookup of the func because arg evaluation order is not specified, so
       *     (let ((func +)) (func (let () (set! func -) 3) 2))
       *   can return 5.
       */

      push_op_stack(sc, sc->value);
      if (sc->op_stack_now >= sc->op_stack_end)
	resize_op_stack(sc);

      goto EVAL_ARGS;
      /* this code can almost certainly be simplified -- "it just growed..." */


    case OP_EVAL_ARGS5:
      /* sc->value is the last arg, sc->code is the previous
       */
      {
	s7_pointer x, y;

	sc->z = pop_op_stack(sc);
	if (is_safe_procedure(sc->z))
	  {
	    x = sc->TEMP_CELL_3;
	    y = sc->TEMP_CELL_2;
	  }
	else
	  {
	    NEW_CELL(sc, x); 
	    set_type(x, T_PAIR);
	    NEW_CELL_NO_CHECK(sc, y); 
	    set_type(y, T_PAIR);
	  }

	car(x) = sc->code;
	cdr(x) = sc->args;
	car(y) = sc->value;
	cdr(y) = x;
	sc->args = safe_reverse_in_place(sc, y); 
	sc->code = sc->z;
	goto APPLY;
      }

      
    case OP_EVAL_ARGS2:
      /* sc->value is the last arg, [so if is_null(cdr(sc->code) and current is pair, push args2]
       */
      {
	s7_pointer x;

	sc->code = pop_op_stack(sc);
	if (is_safe_procedure(sc->code))
	  x = sc->TEMP_CELL_2;
	else
	  {
	    NEW_CELL(sc, x); /*    5 */
	    set_type(x, T_PAIR);
	  }

	car(x) = sc->value;
	cdr(x) = sc->args;
	if (type(sc->args) != T_NIL)
	  sc->args = safe_reverse_in_place(sc, x);
	else sc->args = x;
	goto APPLY;
      }

#if WITH_OPTIMIZATION
      /* tricky cases here all involve values (i.e. multiple-values) */

    case OP_EVAL_ARGS_P_1:
      if (is_not_null(sc->args))
	{
	  car(sc->TEMP_CELL_2) = sc->value;
	  cdr(sc->TEMP_CELL_2) = sc->args;
	  sc->args = safe_reverse_in_place(sc, sc->TEMP_CELL_2);
	  goto APPLY;
	}
      car(sc->T1_1) = sc->value;
      sc->value = c_function_call(sc->code)(sc, sc->T1_1);
      goto START;

    case OP_EVAL_ARGS_P_2:
      if (is_not_null(cdr(sc->args)))
	{
	  /* P must have resulted in values being spliced into the arg list.
	   *   caller is being difficult, so we'll just mimic the code above.
	   */
	  car(sc->TEMP_CELL_2) = sc->value;
	  cdr(sc->TEMP_CELL_2) = sc->args;
	  sc->args = safe_reverse_in_place(sc, sc->TEMP_CELL_2);
	  goto APPLY;
	}
      
      car(sc->T2_2) = sc->value;
      car(sc->T2_1) = car(sc->args);
      sc->value = c_function_call(sc->code)(sc, sc->T2_1);
      goto START;

    case OP_EVAL_ARGS_P_3:
      {
	s7_pointer func;	
	sc->w = sc->value;
	if (is_not_null(sc->args))
	  {
	    /* (define (hi a) (+ (values 1 2) a)) */
	    sc->z = sc->args;
	    car(sc->TEMP_CELL_2) = ARG_SYMBOL_VALUE(caddr(sc->code), find_symbol_or_bust_41);
	    cdr(sc->TEMP_CELL_2) = sc->TEMP_CELL_3;
	    car(sc->TEMP_CELL_3) = sc->w;
	    cdr(sc->TEMP_CELL_3) = sc->z;
	    sc->args = safe_reverse_in_place(sc, sc->TEMP_CELL_2);
	    sc->code = ecdr(sc->code);
	    goto APPLY;
	  }

	func = ecdr(sc->code);
	car(sc->T2_2) = ARG_SYMBOL_VALUE(caddr(sc->code), find_symbol_or_bust_41);
	car(sc->T2_1) = sc->w;
	sc->value = c_function_call(func)(sc, sc->T2_1);
	goto START;
      }

    case OP_EVAL_ARGS_P_4:
	if (is_not_null(sc->args))
	  {
	    /* fprintf(stderr, "value: %s, args: %s, code: %s\n", DISPLAY(sc->value), DISPLAY(sc->args), DISPLAY(sc->code)); */
	    car(sc->TEMP_CELL_2) = caddr(sc->code);
	    cdr(sc->TEMP_CELL_2) = sc->TEMP_CELL_3;
	    car(sc->TEMP_CELL_3) = sc->value;
	    cdr(sc->TEMP_CELL_3) = sc->args;
	    sc->args = safe_reverse_in_place(sc, sc->TEMP_CELL_2);
	    sc->code = ecdr(sc->code);
	    goto APPLY;
	  }
      car(sc->T2_1) = sc->value;
      car(sc->T2_2) = caddr(sc->code);
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T2_1);
      goto START;

    case OP_SAFE_C_ZS_1:
      car(sc->T2_1) = sc->value;
      car(sc->T2_2) = sc->args;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T2_1);
      goto START;

    case OP_SAFE_C_SZ_1:
      car(sc->T2_1) = sc->args;
      car(sc->T2_2) = sc->value;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T2_1);
      goto START;

    case OP_SAFE_C_ZZ_1:
      push_stack(sc, OP_SAFE_C_ZZ_2, sc->value, sc->code);
      sc->code = caddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_ZZ_2:
      car(sc->T2_1) = sc->args;
      car(sc->T2_2) = sc->value;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T2_1);
      goto START;

    case OP_SAFE_C_ZXX_1:
      car(sc->T3_3) = (s7_is_symbol(cadddr(sc->code))) ? ARG_SYMBOL_VALUE(cadddr(sc->code), find_symbol_or_bust_45) : cadddr(sc->code);
      car(sc->T3_1) = sc->value;
      car(sc->T3_2) = sc->args;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_XZX_1:
      car(sc->T3_3) = (s7_is_symbol(cadddr(sc->code))) ? ARG_SYMBOL_VALUE(cadddr(sc->code), find_symbol_or_bust_45) : cadddr(sc->code);
      car(sc->T3_2) = sc->value;
      car(sc->T3_1) = sc->args;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_XXZ_1:
      car(sc->T3_2) = (s7_is_symbol(caddr(sc->code))) ? ARG_SYMBOL_VALUE(caddr(sc->code), find_symbol_or_bust_45) : caddr(sc->code);
      car(sc->T3_3) = sc->value;
      car(sc->T3_1) = sc->args;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_ZZX_1:
      push_op_stack(sc, sc->value);
      push_stack(sc, OP_SAFE_C_ZZX_2, sc->args, sc->code);
      sc->code = caddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_ZZX_2:
      car(sc->T3_1) = pop_op_stack(sc);
      car(sc->T3_2) = sc->value;
      car(sc->T3_3) = sc->args;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_ZXZ_1:
      push_op_stack(sc, sc->value);
      push_stack(sc, OP_SAFE_C_ZXZ_2, sc->args, sc->code);
      sc->code = cadddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_ZXZ_2:
      car(sc->T3_1) = pop_op_stack(sc);
      car(sc->T3_2) = sc->args;
      car(sc->T3_3) = sc->value;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_XZZ_1:
      push_op_stack(sc, sc->value);
      push_stack(sc, OP_SAFE_C_XZZ_2, sc->args, sc->code);
      sc->code = cadddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_XZZ_2:
      car(sc->T3_1) = sc->args;
      car(sc->T3_2) = pop_op_stack(sc);
      car(sc->T3_3) = sc->value;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;

    case OP_SAFE_C_ZZZ_1:
      push_stack(sc, OP_SAFE_C_ZZZ_2, sc->value, sc->code);
      sc->code = caddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_ZZZ_2:
      push_op_stack(sc, sc->value);
      push_stack(sc, OP_SAFE_C_ZZZ_3, sc->args, sc->code);
      sc->code = cadddr(sc->code);
      goto OPT_EVAL;

    case OP_SAFE_C_ZZZ_3:
      car(sc->T3_1) = sc->args;
      car(sc->T3_2) = pop_op_stack(sc);
      car(sc->T3_3) = sc->value;
      sc->value = c_function_call(ecdr(sc->code))(sc, sc->T3_1);
      goto START;
#endif
      
    case OP_EVAL_ARGS3:
      /* sc->value is the next-to-last arg, and we know the last arg is not a list (so values can't mess us up!)
       */
      {
	s7_pointer x, y;

	sc->x = pop_op_stack(sc);
	if (is_safe_procedure(sc->x))
	  {
	    x = sc->TEMP_CELL_3;
	    y = sc->TEMP_CELL_2;
	  }
	else
	  {
	    NEW_CELL(sc, x); /* 3 */
	    set_type(x, T_PAIR);
	    NEW_CELL_NO_CHECK(sc, y); /* 3 */
	    set_type(y, T_PAIR);
	  }
	car(x) = sc->value;
	cdr(x) = sc->args;
		  
	if (type(sc->code) == T_SYMBOL)
	  car(y) = ARG_SYMBOL_VALUE(sc->code, find_symbol_or_bust_8);
	else car(y) = sc->code;
	cdr(y) = x;
	sc->args = safe_reverse_in_place(sc, y); 
	sc->code = sc->x;
	goto APPLY;
      }

      
    case OP_EVAL_ARGS4:
      /* sc->code is a pair, and either cdr(sc->code) is not null or car(sc->code) is a pair 
       */
      {
        s7_pointer x;
	NEW_CELL(sc, x); /* 8 5 */
	car(x) = sc->value;
	cdr(x) = sc->args;
	set_type(x, T_PAIR);
	sc->args = x;
	goto EVAL_ARGS_PAIR;
      }


    case OP_EVAL_ARGS1:
      {
        s7_pointer x;
	NEW_CELL(sc, x); /*    3 */
	car(x) = sc->value;
	cdr(x) = sc->args;
	set_type(x, T_PAIR);
	sc->args = x;
      }


    EVAL_ARGS:
      /* 1st time, value = op, args = nil, code is args */
      /* fprintf(stderr, "    eval_args: %s\n", DISPLAY_80(sc->code)); */

      if (is_pair(sc->code))  /* evaluate current arg -- must check for pair here, not sc->NIL (improper list as args) */
	{ 
	  int typ;
	  s7_pointer car_code;

	EVAL_ARGS_PAIR:
	  car_code = car(sc->code);
	  typ = type(car_code);
	  
	  /* switch statement here is much slower for some reason */
	  if (typ == T_PAIR)
	    {
	      if (is_null(cdr(sc->code)))
		push_stack(sc, OP_EVAL_ARGS2, sc->args, sc->NIL);
	      else 
		{
		  if ((is_null(cddr(sc->code))) &&
		      (!is_pair(cadr(sc->code))))
		    push_stack(sc, OP_EVAL_ARGS3, sc->args, cadr(sc->code)); 
		  else push_stack(sc, OP_EVAL_ARGS4, sc->args, cdr(sc->code));
		}
	      sc->code = car_code;
	      goto EVAL_PAIR;
	    }

	  /* car(sc->code) is not a pair */
	  if (is_pair(cdr(sc->code)))
	    {
	      sc->code = cdr(sc->code);
	      if (typ == T_SYMBOL)
		sc->value = ARG_SYMBOL_VALUE(car_code, find_symbol_or_bust_2);
	      else sc->value = car_code;
	      /* sc->value is the current arg's value, sc->code is pointing to the next */

	      /* cdr(sc->code) may not be a pair or nil here! 
	       *   (eq? #f . 1) -> sc->code is 1
	       */
	      if (is_null(cdr(sc->code)))
		{
		  s7_pointer x, y;
		  /* we're at the last arg, sc->value is the previous one, not yet saved in the args list */
		  car_code = car(sc->code);
		  typ = type(car_code);

		  if (typ == T_PAIR)
		    {
		      push_stack(sc, OP_EVAL_ARGS5, sc->args, sc->value);
		      sc->code = car_code;
		      goto EVAL_PAIR;
		    }
		  
		  /* get the current arg, which is not a list */
		  sc->code = pop_op_stack(sc);
		  if (is_safe_procedure(sc->code)) /* this check does not currently pay for itself, I think */
		    {
		      x = sc->TEMP_CELL_3; /* these are already pairs */
		      y = sc->TEMP_CELL_2;
		    }
		  else
		    {
		      NEW_CELL(sc, x); 
		      set_type(x, T_PAIR);
		      NEW_CELL_NO_CHECK(sc, y); 
		      set_type(y, T_PAIR);
		    }
		  car(x) = sc->value;
		  cdr(x) = sc->args;
		  
		  /* get the last arg */
		  if (typ == T_SYMBOL)
		    car(y) = ARG_SYMBOL_VALUE(car_code, find_symbol_or_bust_3);
		  else car(y) = car_code;

		  cdr(y) = x;
		  sc->args = safe_reverse_in_place(sc, y); 
		  /* drop into APPLY */
		}
	      else 
		{
		  /* here we know sc->code is a pair, cdr(sc->code) is not null
		   *   sc->value is the previous arg's value
		   */
		  s7_pointer x;
		  NEW_CELL(sc, x); 
		  car(x) = sc->value;
		  cdr(x) = sc->args;
		  set_type(x, T_PAIR);
		  sc->args = x;
		  goto EVAL_ARGS_PAIR;
		}
	    }
	  else
	    {
	      /* here we've reached the last arg (sc->code == nil) 
	       *   it is not a pair (typ == T_PAIR was caught earlier)
	       *   if this is a safe function, we're going straight to
	       *   apply with no complications, so we can use TEMP_CELL_2.
	       */
	      s7_pointer x;

	      if (type(cdr(sc->code)) != T_NIL)
		improper_arglist_error(sc);

	      sc->code = pop_op_stack(sc);
	      if (is_safe_procedure(sc->code))
		x = sc->TEMP_CELL_2;
	      else
		{
		  NEW_CELL(sc, x); 
		  set_type(x, T_PAIR);
		}

	      if (typ == T_SYMBOL)
		car(x) = ARG_SYMBOL_VALUE(car_code, find_symbol_or_bust_42);
	      else car(x) = car_code;
	      cdr(x) = sc->args;
	      if (type(sc->args) != T_NIL)
		sc->args = safe_reverse_in_place(sc, x);
	      else sc->args = x;
	      /* fprintf(stderr, "    %s %s (%d)\n", s7_object_to_c_string(sc, sc->code), s7_object_to_c_string(sc, sc->args), (is_safe_procedure(sc->code))); */
	      /* drop into APPLY */
	    }
	}
      else                       /* got all args -- go to apply */
	{
	  if (is_not_null(sc->code))
	    improper_arglist_error(sc);
	  else
	    {
	      sc->code = pop_op_stack(sc);
	      sc->args = safe_reverse_in_place(sc, sc->args); 
	      /* fall through  */
	    }
	}
      /* we could omit the arg reversal in many cases, but lots of code assumes OP_APPLY gets the args in order;
       *   adding a bit for this in the type field saves some time in s7test (many + and * tests), but costs
       *   about the same time in other cases, so it's not a clear win.
       */

      sc->from_eval = true;
      if (tracing) 
	trace_apply(sc);
      goto APPLY2;


      /* ---------------- OP_APPLY ---------------- */
    APPLY:
    case OP_APPLY:      /* apply 'code' to 'args' */
      if (tracing) 
	trace_apply(sc);

    APPLY_WITHOUT_TRACE:
	sc->from_eval = false;

      /*
       * if (sc->stack_end >= sc->stack_resize_trigger)
       *   increase_stack_size(sc);
       *
       * the two places where the stack reaches it maximum size are in read_expression where TOKEN_LEFT_PAREN
       *   pushes OP_READ_LIST, and (the actual max) in OP_EVAL at the push of OP_EVAL_ARGS.  I've moved
       *   the stack size check from here (where it reflects the eval stack size) to read_expression (where
       *   it reflects nested list depth), and added it to the T_CLOSURE(*) parts of apply since (for example) 
       *   extremely deep recursion involving map or for-each can increase the stack size indefinitely:
       *
       * (define (tfe a b)
       *   (format #t "~A ~A -> ~A~%" a b (-s7-stack-size))
       *   (for-each
       *     (lambda (c)
       *       (if (< c b)
       *           (tfe (+ c 1) b)))
       *     (list a)))
       *
       * now (tfe 0 1000) triggers the stack increase.
       */

    APPLY2:
      switch (type(sc->code))
	{
	case T_C_FUNCTION: 	                    /* -------- C-based function -------- */
	  {
	    unsigned int len;
	    len = safe_list_length(sc, sc->args);

	    if (len < c_function_required_args(sc->code))
	      return(s7_error(sc, 
			      sc->WRONG_NUMBER_OF_ARGS, 
			      list_3(sc, sc->NOT_ENOUGH_ARGUMENTS, sc->code, sc->args)));

	    if (c_function_all_args(sc->code) < len)
	      return(s7_error(sc, 
			      sc->WRONG_NUMBER_OF_ARGS, 
			      list_3(sc, sc->TOO_MANY_ARGUMENTS, sc->code, sc->args)));
	  }
	  /* drop into ... */

	case T_C_ANY_ARGS_FUNCTION:                 /* -------- C-based function that can take any number of arguments -------- */
	  sc->value = c_function_call(sc->code)(sc, sc->args);
	  goto START;

	case T_C_OPT_ARGS_FUNCTION:                 /* -------- C-based function that has n optional arguments -------- */
	  {
	    unsigned int len;
	    len = safe_list_length(sc, sc->args);
	    if (c_function_all_args(sc->code) < len)
	      return(s7_error(sc, 
			      sc->WRONG_NUMBER_OF_ARGS, 
			      list_3(sc, sc->TOO_MANY_ARGUMENTS, sc->code, sc->args)));
	    sc->value = c_function_call(sc->code)(sc, sc->args);
	    goto START;
	  }

	case T_C_RST_ARGS_FUNCTION:                 /* -------- C-based function that has n required args, then any others -------- */
	  {
	    unsigned int len;
	    len = safe_list_length(sc, sc->args);
	    if (len < c_function