/* ANALYZE */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko

parse value init() with rcy
if rcy \= 0 then signal fineko

parse upper arg filein fileout modo

if (filein == "") | (fileout == '') then do
  say "ANALYZE:"
  say "Analizza un file audio e restituisce un file TXT con il contenuto"
  say "spettrale del file di origine"
  say ""
  say "Uso:"
  say "      ANALYZE nome_file file_fft [intervallo] [modo]"
  say ""
  say "Parametri:"
  say "      nome_file    il nome di un file WAV stereo (con estensione)"
  say "      file_fft     il nome del file di output"
  say "      intervallo   l'intervallo di campionamento (in secondi)"
  say "      modo         'G' per avere l'analizzatore grafico"
  return 1
  end


fc=44100

call SysCls
t=time(R)
c = chkwav(filein)

say "ANALYZE:"
say ""
say "   filein      :" filein
say "   fileout     :" fileout
say ""


tr1 = WavAllocTrac(c)
tr2 = WavAllocTrac(c)
say time(E) ":" c*4 "bytes memoria allocata"

rcy = WavReadStereo(filein, tr1, tr2)
say time(E) ":" filein "caricato in memoria"

parse value init() with rcy
l_sec = ((c / fc) - 0.01) * 10
k = 0
max = 0
call SchermoFFT





do i=1 to l_sec

   rcy = WavAnalyze(tr1+k, 'TER', fft.)
   l_out = i
   do j=1 to fft.0
      l_out = l_out || ' , ' fft.j
/*
*/
      x = (j*2) + 5
      y = 20 - trunc(trunc(fft.j)/2)

      do z=2 to 19
         rcy = SysCurPos(z, x)
         if z<y then say '  '
                else say ''
         end
      end

   rcy = SysCurPos(23, 8)
   say trunc((k/fc) * 100)
   rcy=lineout(fileout, l_out)
   /*
   */
   k = k + (fc / 10)
   end



fine:
rcy = WavDropTrac(tr1)
rcy = WavDropTrac(tr2)
say time(E) ": memoria rilasciata"
return 0



fineko:
say "fine ko !!!"
pull k
"exit"
/**********************************************************************/

SchermoFFT:

call SysCls
call SysCurState 'OFF'
say '    ͻ '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '    ͼ '
say '      2 . . 4 . . 8 . . 1 . . 3 . . 6 . . 1 . . 2 . . 5 . . 1 . . 2'
say '      0     0     0     6     2     4     ,     ,     ,     0     0'
say 'Offset=                 0     0     0     2     5     1     k     k'
return

