<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	List of hosts
-->

<xsl:template match="ui/hosts">
  <div class="part-content">
    <div class="control-title">
      <xsl:value-of select="$lang/comments/hosts"/>
    </div>
  </div>

  <div class="part-title"><xsl:value-of select="$lang/labels/hosts"/></div>
  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <xsl:apply-templates select="host"/>
  </table>

  <div class="part-title"><xsl:value-of select="$lang/labels/ui-acl"/></div>
  <form class="part-content" enctype="multipart/form-data" method="post"
        onsubmit="return locLoad();">
    <xsl:apply-templates select="acl[@type='ui']"/>
    <input style="margin-left: 2em;" type="submit" name="submitUIACLEdit"
           value="{$lang/buttons/submit}"/>
  </form>
</xsl:template>

<xsl:template match="ui/hosts/host">
    <form enctype="multipart/form-data" action="?id={@id-host}" method="post"
          onsubmit="return locLoad();">
      <tr>
        <td class="btn" rowspan="2" valign="middle" style="padding: 0 0.5em 2em 2em;">
          <xsl:choose>
            <xsl:when test="@id-host='new'">
              <xsl:value-of select="$lang/labels/new"/>
            </xsl:when>
            <xsl:when test="@check">
              <xsl:call-template name="delete-btn">
                <xsl:with-param name="link">?id=<xsl:value-of select="@id-host"/>&amp;del=1</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="delete-btn">
                <xsl:with-param name="link">?check=<xsl:value-of select="@id-host"/></xsl:with-param>
                <xsl:with-param name="check">1</xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td style="width: 1em;">
          <nobr>
            <span class="control-title">
              <span>
                <xsl:if test="bind-address/@error">
                  <xsl:attribute name="class">error</xsl:attribute>
                </xsl:if>
                <xsl:value-of select="$lang/labels/bind-address"/>:
              </span>
            </span>
            <input type="text" class="text" style="width: 10em;" maxlength="15"
                   name="bindAddr" value="{bind-address}"/>
          </nobr>
        </td>
        <td>
          <span class="control-title" style="text-align: left;">
            <span>
              <xsl:if test="bind-port/@error">
                <xsl:attribute name="class">error</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="$lang/labels/bind-port"/>:
            </span>
          </span>
          <input type="text" class="text" style="width: 4em;" maxlength="5"
                 name="bindPort" value="{bind-port}"/>
        </td>
        <td rowspan="2" valign="middle" style="padding-left: 2em; padding-bottom: 2em;">
          <input type="submit" name="submitHostEdit" value="{$lang/buttons/submit}"/>
        </td>
        <xsl:if test="error">
          <td rowspan="2" valign="middle" class="error" style="padding-left: 1em;">
            (<xsl:value-of select="error/@code"/>)
            <xsl:value-of select="error"/>
          </td>
        </xsl:if>
      </tr>
      <tr>
        <td colspan="2" style="padding-bottom: 2em;">
          <span class="control-title">
            <span>
              <xsl:if test="icy/@error">
                <xsl:attribute name="class">error</xsl:attribute>
              </xsl:if>
              <xsl:value-of select="$lang/labels/icy-mount-point"/>:
            </span>
          </span>
          <xsl:if test="icy and not(icy/@ready or @id-host='new')">
            (<xsl:value-of select="$lang/labels/icy-not-ready"/>
            <xsl:text>) </xsl:text>
          </xsl:if>
          <input class="text" maxlength="1024" type="text" name="icy"
                 value="{icy}"/>
        </td>
      </tr>
    </form>
</xsl:template>

</xsl:stylesheet>
