<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	Global properties
-->

<xsl:template match="ui/properties">
  <div class="part-title">
    <xsl:value-of select="$lang/labels/administrator"/>
  </div>
  <xsl:apply-templates select="user"/>
  <xsl:apply-templates select="admin-timeout"/>

  <div class="part-title">
    <xsl:value-of select="$lang/labels/start-page"/>
  </div>
  <xsl:apply-templates select="public-start-page"/>

  <div class="part-title">
    <xsl:value-of select="$lang/labels/log-events"/>
  </div>
  <xsl:apply-templates select="log-events"/>
</xsl:template>

<xsl:template match="properties/user">
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <form enctype="multipart/form-data" method="post"
          onsubmit="return locLoad();">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/user-name"/>
        </td>
        <td class="control">
          <input type="text" class="text" name="name" value="{.}"
                 maxlength="256"/>
        </td>
        <td rowspan="3" valign="top" style="padding-left: 1em; color: red;">
          <xsl:choose>
            <xsl:when test="@error">
              <xsl:choose>
                <xsl:when test="@error='emptyName'">
                  <xsl:value-of select="$lang/comments/empty-username"/>
                </xsl:when>
                <xsl:when test="@error='emptyPassword'">
                  <xsl:value-of select="$lang/comments/empty-password"/>
                </xsl:when>
                <xsl:when test="@error='emptyPassword2'">
                  <xsl:value-of select="$lang/comments/empty-repeat-password"/>
                </xsl:when>
                <xsl:when test="@error='notEqPassword'">
                  <xsl:value-of select="$lang/comments/passwords-not-match"/>
                </xsl:when>
                <xsl:otherwise>
                  Error
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test=".=''">
                <xsl:value-of select="$lang/comments/need-user"/>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/password"/>
        </td>
        <td class="control">
          <input type="password" class="text" name="password"
                 maxlength="256"/>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/password-repeat"/>
        </td>
        <td class="control">
          <input type="password" class="text" name="password2"
                 maxlength="256"/>
        </td>
      </tr>
      <tr>
        <td class="control-title"> </td>
        <td class="control">
          <input type="submit" name="submitUser" value="{$lang/buttons/submit}"/>
        </td>
      </tr>
    </form>
  </table>
</xsl:template>

<xsl:template match="properties/admin-timeout">
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <form enctype="multipart/form-data" method="post"
          onsubmit="return locLoad();">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/user-timeout"/>
        </td>
        <td class="control">
          <input type="text" class="text" name="adminTimeout" value="{.}"
                 style="width: 3em; margin-right: 0.5em;" maxlength="3"/>
          <xsl:value-of select="$lang/labels/min"/>
          <input type="submit" name="submitAdminTimeout" style="margin-left: 1em;"
                 value="{$lang/buttons/submit}"/>
        </td>
      </tr>
    </form>
  </table>
</xsl:template>

<xsl:template match="properties/public-start-page">
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <form enctype="multipart/form-data" method="post"
          onsubmit="return locLoad();">
      <tr>
        <xsl:choose>
          <xsl:when test=".='1'">
            <td class="control-title">
              <xsl:value-of select="$lang/comments/pub-start-page-on"/>
            </td>
            <td class="control">
              <input type="submit" value="{$lang/buttons/off}"
                     name="submitPublicStartPageOff"/>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td class="control-title">
              <xsl:value-of select="$lang/comments/pub-start-page-off"/>
            </td>
            <td class="control">
              <input type="submit" value="{$lang/buttons/on}"
                     name="submitPublicStartPageOn"/>
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </form>
  </table>
</xsl:template>

</xsl:stylesheet>
