/* im_dart.h
 * - Raw PCM input from OS/2 DART
 *
 * by Vasilkin Andrey <digi@os2.snc.ru>
 *
 * This program is distributed under the terms of the GNU General
 * Public License, version 2. You may use, modify, and redistribute
 * it under the terms of this license. A copy should be included
 * with this source.
 */

#ifndef __IM_DART_H__
#define __IM_DART_H__

#include "inputmodule.h"
#define INCL_OS2MM
#undef VERSION
#include <thread/thread.h>
#include <os2me.h>

typedef struct
{
  int                 id;
  MCI_MIXSETUP_PARMS  mci_mix_setup;
  MCI_BUFFER_PARMS    mci_buffer;
  int                 curbuf;
  int                 readycnt;
  mutex_t             mtx_readycnt;
  cond_t              ev_nextblk;

  char                **metadata;
  int                 newtrack;
  mutex_t             mtx_metadata;
} im_dart_state; 

input_module_t *dart_open_module(module_param_t *params);

#endif  /* __IM_DART_H__ */
