/*
  [Digi] A new metadata module to support characters encodings.
  We will not use metadata update service from libshout, it seems some memory
  leaks there.
*/

#include <string.h>
#include <process.h>
#include <malloc.h>
#include <types.h>
#include <iconv.h>
#include "xpl.h"
#include "definitions.h"
#include "util.h"
#include "metadata.h"
#include <debug.h>

#define MDITEM_COUNT         5
#define INITDELAY            5000
//#define _ICONV_PULL          1
//#define ICONV_CONST          const
#define ICONV_CONST

typedef struct _MDITEM {
  PSZ        pcText;
  int        cbText;
  int        cbTextMax;
  CHAR       acEnc[32];
} MDITEM, *PMDITEM;

extern ices_config_t   ices_config;

static MDITEM          aItems[MDITEM_COUNT] = { 0 };
static HMTX            hmtxItems;
static TID             tid = -1;
static HEV             hevUpdate = NULLHANDLE;

#ifdef _ICONV_PULL
typedef struct _ICONVHDL {
  struct _ICONVHDL     *pNext;
  PSZ                  pszEncIn;
  PSZ                  pszEncOut;
  iconv_t              cd;
} ICONVHDL, *PICONVHDL;

static PICONVHDL       pIConvHandles = NULL;
#endif

#define IS_ITEM_SET(item) ( aItems[item].cbText != 0 )
#define SAFE_STRICMP(s1,s2) stricmp( s1 == NULL ? "" : s1, s2 == NULL ? "" : s2 )

static ULONG _strConv(PSZ pszEncOut, PSZ pszEncIn, PCHAR pcOutBuf,
                      ULONG cbOutBuf, PCHAR pcInBuf, ULONG cbInBuf)
{
  ULONG      cbRes;
#if 0
  // For test - skip character encoding:
  cbRes = min( cbOutBuf - 1, cbInBuf );

  strlcpy( pcOutBuf, pcInBuf, cbRes );
  pcOutBuf[cbRes] = '\0';
#else
  iconv_t    cd = (iconv_t)(-1);
  PCHAR      _pcOutBuf = pcOutBuf;
  size_t     _cbOutBuf;
  PCHAR      _pcInBuf = pcInBuf;
  size_t     _cbInBuf = cbInBuf;
#ifdef _ICONV_PULL
  PICONVHDL  pIConvHdl = pIConvHandles;
#endif
  int        iRC;

  if ( cbOutBuf == 0 )
    return 0;

  if ( cbOutBuf == 1 )
  {
    *pcOutBuf = '\0';
    return 1;
  }

  if ( pszEncOut == NULL )
    pszEncOut = "";

  if ( pszEncIn == NULL )
    pszEncIn = "";

#ifdef _ICONV_PULL
  // Search handle.

  for( ; pIConvHdl != NULL; pIConvHdl = pIConvHdl->pNext )
  {
    if ( ( SAFE_STRICMP( pIConvHdl->pszEncIn, pszEncIn ) == 0 ) &&
         ( SAFE_STRICMP( pIConvHdl->pszEncOut, pszEncOut ) == 0 ) )
    {
      cd = pIConvHdl->cd;
      break;
    }
  }

  // Handle not found - create it.

  if ( cd == (iconv_t)(-1) )
  {
#endif
    cd = iconv_open( pszEncOut, pszEncIn );
    if ( cd == (iconv_t)(-1) )
    {
      ices_log_debug( "iconv_open(\"%s\",\"%s\") failed", pszEncOut, pszEncIn );
      return 0;
    }

#ifdef _ICONV_PULL
    pIConvHdl = debugMAlloc( sizeof(ICONVHDL) );
    if ( pIConvHdl == NULL )
    {
      debug( "Not enough memory" );
      iconv_close( cd );
      return 0;
    }

    // Add new handle to the list.

    pIConvHdl->cd = cd;
    pIConvHdl->pszEncIn = pszEncIn[0] == '\0' ? NULL : debugStrDup( pszEncIn );
    pIConvHdl->pszEncOut = pszEncOut[0] == '\0' ? NULL : debugStrDup( pszEncOut );
    pIConvHdl->pNext = pIConvHandles;
    pIConvHandles = pIConvHdl;
    debug( "New iconv handle created (%s -> %s)",
           pszEncIn[0] == '\0' ? "system" : pszEncIn,
           pszEncOut[0] == '\0' ? "system" : pszEncOut );
  }
#endif

  // Convert.

  cbOutBuf--;           // Reserve one byte for the terminating zero.
  _cbOutBuf = cbOutBuf;

  while( ( _cbInBuf > 0 ) && ( _cbOutBuf > 0 ) )
  {
    iRC = iconv( cd, (ICONV_CONST char **)&_pcInBuf, (size_t *)&_cbInBuf,
                 &_pcOutBuf, (size_t *)&_cbOutBuf );
    if ( ( iRC != -1 ) || ( errno != EILSEQ ) )
      break;

    // Try to skip some invalid input data. We'll lost some characters.
    _pcInBuf++;
    _cbInBuf--;
  }

  if ( _cbOutBuf > 0 )
    iconv( cd, NULL, NULL, &_pcOutBuf, (size_t *)&_cbOutBuf );
#ifndef _ICONV_PULL
  iconv_close( cd );
#endif

  cbRes = cbOutBuf - _cbOutBuf;
  *_pcOutBuf = '\0';
#endif
  return cbRes;
}

// LONG _urlEncode(PSZ pszSrc, PCHAR pcBuf, ULONG cbBuf)
//
// Encodes string pszSrc to buffer pcBuf. Returns result string length or
// -1 if not enough size of destination buffer.

static LONG _urlEncode(PSZ pszSrc, PCHAR pcBuf, ULONG cbBuf)
{
  static CHAR          acHex[16] = "0123456789ABCDEF";
  static BOOL          afSafeCh[256] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  };

  ULONG      cbLeft = cbBuf;

  while( *pszSrc != '\0' )
  {
    if ( afSafeCh[(UCHAR)(*pszSrc)] )
    {
      if ( cbLeft <= 1 )
        return -1;
      *(pcBuf++) = *pszSrc;
      cbLeft--;
    }
    else
    {
      if ( cbLeft <= 3 )
        return -1;
       *(pcBuf++) = '%';
       *(pcBuf++) = acHex[ (*pszSrc >> 4) & 0x0F ];
       *(pcBuf++) = acHex[ *pszSrc & 0x0F ];
       cbLeft -= 3;
    }
    pszSrc++;
  }

  *pcBuf = '\0';
  return cbBuf - cbLeft;
}

// LONG _b64Encode(PSZ pszSrc, PCHAR pcBuf, ULONG cbBuf)
//
// Encodes string pszSrc with base64 and strores result to the buffer pcBuf.
// Returns result string length or -1 if not enough size of destination buffer.

static LONG _b64Encode(PSZ pszSrc, PCHAR pcBuf, ULONG cbBuf)
{
  static CHAR          aB64Tbl[64] =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

  ULONG      cbSrc = strlen( pszSrc );
  ULONG      ulChunk;
  LONG       cbResult = 0;

  if ( cbBuf < ( cbSrc * 4 / 3 + 4 ) )
    return -1;

  while ( cbSrc > 0 )
  {
    ulChunk = min( cbSrc, 3 );
    *pcBuf++ = aB64Tbl[ (*pszSrc & 0xFC)>>2 ];
    *pcBuf++ = aB64Tbl[ ((*pszSrc & 0x03)<<4) | ((pszSrc[1] & 0xF0) >> 4) ];

    switch( ulChunk )
    {
      case 3:
         *pcBuf++ = aB64Tbl[ ((pszSrc[1] & 0x0F)<<2) | ((pszSrc[2] & 0xC0)>>6) ];
         *pcBuf++ = aB64Tbl[ pszSrc[2] & 0x3F ];
         break;

      case 2:
         *pcBuf++ = aB64Tbl[ ((pszSrc[1] & 0x0F)<<2) ];
         *pcBuf++ = '=';
         break;

      case 1:
         *pcBuf++ = '=';
         *pcBuf++ = '=';
         break;
    }
    pszSrc += ulChunk;
    cbSrc -= ulChunk;
    cbResult += 4;
  }
  *pcBuf = 0;

  return cbResult;
}


// BOOL _sendRequest(PSZ pszHost, USHORT usPort, PCHAR pcBuf, ULONG cbBuf)
//
// Send cbBuf bytes of data from the buffer pcBuf to the host pszHost:usPort.
// Returns TRUE on success.

static BOOL _sendRequest(PSZ pszHost, USHORT usPort, PCHAR pcBuf, ULONG cbBuf)
{
  static struct in_addr stResolved = { INADDR_NONE };

  int                  iRC;
  int                  iSock;
  struct sockaddr_in   stSockAddr;
  struct hostent       *pstHost;
  struct linger        stLinger;
  CHAR                 acRecvBuf[256];

  // Try convert ASCIIZ to ip-address.
  stSockAddr.sin_addr.s_addr = inet_addr( pszHost );
  if ( stSockAddr.sin_addr.s_addr == (u_long)(-1) )
  {
    // Search host's ip-address.
    pstHost = gethostbyname( pszHost );
    if ( pstHost == NULL )
    {
      ices_log_error_output( "Host not found: %s", pszHost );

      if ( stResolved.s_addr == INADDR_NONE )
        return FALSE;

      // We uses previous resolved address if host not found now.
      // I have a not stable DNS server sometimes. :)
    }
    else
      stResolved = *(struct in_addr *)pstHost->h_addr;

    stSockAddr.sin_addr = stResolved;
  }

  stSockAddr.sin_family = AF_INET;
  stSockAddr.sin_port = htons( usPort );

  iSock = socket( AF_INET, SOCK_STREAM, 0 );
  if ( iSock == -1 )
    return FALSE;

  if ( connect( iSock, (struct sockaddr *)&stSockAddr, sizeof(stSockAddr) )
       == -1 )
  {
    ices_log_error_output( "Cannot connect to the host: %s", pszHost );
    xplSockClose( iSock );
    return FALSE;
  }

  iRC = send( iSock, pcBuf, cbBuf, 0 );

  shutdown( iSock, 1 ); // No more data to send.

#if 1
  // Recevie an answer and check it.

  if ( iRC > 0 )
  {
    pcBuf = &acRecvBuf;
    cbBuf = sizeof(acRecvBuf);
    do
    {
      iRC = recv( iSock, pcBuf, cbBuf, 0 );
      if ( iRC > 0 )
      {
        pcBuf += iRC;
        cbBuf -= iRC;
      }
    }
    while( ( iRC > 0 ) && ( cbBuf > 0 ) );

    *pcBuf = '\0';
    // Search end of first line.
    pcBuf = strchr( &acRecvBuf, '\r' );
    if ( pcBuf != NULL )
      *pcBuf = '\0';

    pcBuf = strchr( &acRecvBuf, ' ' ); // Skip "HTTP/1.0"
    if ( pcBuf == NULL )
      ices_log_error_output( "Invalid answer on metadata update request" );
    else
    {
      if ( strcmp( pcBuf, " 200 OK" ) != 0 )
      {
        ices_log_error_output( "Server answer on metadata update request: %s",
                               &acRecvBuf );
        pcBuf = NULL;
      }
    }
  }
#else
  // Read all data from the socket.
  while( recv( iSock, &acRecvBuf, sizeof(acRecvBuf), 0 ) > 0 );
#endif

  stLinger.l_onoff = 1;
  stLinger.l_linger = 0;
  setsockopt( iSock, SOL_SOCKET, SO_LINGER, (char const *)&stLinger, sizeof(stLinger) );
  xplSockClose( iSock );

  if ( iRC == -1 )
  {
    ices_log_error_output( "Data send to the host %s failed", pszHost );
    return FALSE;
  }

  return pcBuf != NULL;
}

// LONG _encodePassword(PSZ pszPswd, PCHAR pcBuf, ULONG cbBuf)
//
// Encodes string "source:<password>", where <password> is pszPswd in base64
// and stores it to the buffer pcBuf.
// Returns number of stored bytes or -1 if not enough size of the given buffer.

static LONG _encodePassword(PSZ pszPswd, PCHAR pcBuf, ULONG cbBuf)
{
  PSZ        pszAuth = alloca( 8 + strlen( pszPswd ) );
  int        iRC;

  if ( pszAuth == NULL )
    return -1;

  sprintf( pszAuth, "source:%s", pszPswd );

  return _b64Encode( pszAuth, pcBuf, cbBuf );
}

static VOID _logUpdated(ices_stream_t* stream, PCHAR pcMetadata, ULONG cbMetadata)
{
  CHAR       acConBuf[1024];

  _strConv( NULL, stream->metadata_enc, &acConBuf, sizeof(acConBuf),
            pcMetadata, cbMetadata );
  ices_log_debug( "Updated metadata on %s to: %s", stream->mount, &acConBuf );
}


void threadUpdate(void *delay)
{
  CHAR                 acMetadata[2048];
  CHAR                 acBuf[5 * 1048];
  int                  cbBuf;
  int                  cbMetadata = 0;
  int                  iRC;
  ices_stream_t*       stream;

#if 1
  while( ( xplEventWait( hevUpdate, XPL_INDEFINITE_WAIT ) == NO_ERROR ) &&
         ( hevUpdate != NULLHANDLE ) )
  {
#else
  while( TRUE )
  {
    iRC = xplEventWait( hevUpdate, XPL_INDEFINITE_WAIT );
    if ( hevUpdate == NULLHANDLE )
    {
      ices_log_debug( "hevUpdate is NULL - exit signal for the thread" );
      break;
    }
    if ( iRC != NO_ERROR )
    {
      ices_log_error_output( "xplEventWait(), rc = %u", iRC );
      break;
    }
#endif

    for ( stream = ices_config.streams; stream != NULL; stream = stream->next )
    {
//    We don't use shout_get_connected() here because it will try to connect
//    and it may be not thread-safe.
//      if ( shout_get_connected( stream->conn ) != SHOUTERR_CONNECTED )
      if ( stream->online == 0 )
        continue;

      // Build and encode metadata to the stream's configured character encoding.

      xplMutexLock( hmtxItems, XPL_INDEFINITE_WAIT );

      if ( IS_ITEM_SET( MDITEM_PLAYLIST ) )
        cbMetadata = ices_metadata_get_item( MDITEM_PLAYLIST, &acMetadata,
                                     sizeof(acMetadata), stream->metadata_enc );
      else
      {
        if ( IS_ITEM_SET( MDITEM_ARTIST ) )
        {
          cbMetadata = ices_metadata_get_item( MDITEM_ARTIST, &acMetadata,
                                               sizeof(acMetadata) - 3,
                                               stream->metadata_enc );
          if ( cbMetadata < 0 )
            break;

          // Separator " - "
          cbMetadata += _strConv( stream->metadata_enc, "UTF-8", &acMetadata[cbMetadata],
                                  sizeof(acMetadata) - cbMetadata, " - ", 3 );
        }
        else
          cbMetadata = 0;

        iRC = ices_metadata_get_item( IS_ITEM_SET( MDITEM_TITLE ) ?
                                        MDITEM_TITLE : MDITEM_FILE,
                                      &acMetadata[cbMetadata],
                                      sizeof(acMetadata) - cbMetadata,
                                      stream->metadata_enc );

        if ( iRC < 0 )
          continue;
        cbMetadata += iRC;

        if ( IS_ITEM_SET( MDITEM_ALBUM ) )
        {
          // Separator " - "
          cbMetadata += _strConv( stream->metadata_enc, "UTF-8", &acMetadata[cbMetadata],
                                  sizeof(acMetadata) - cbMetadata, " - ", 3 );

          iRC = ices_metadata_get_item( MDITEM_ALBUM,
                                        &acMetadata[cbMetadata],
                                        sizeof(acMetadata) - cbMetadata,
                                        stream->metadata_enc );
          if ( iRC < 0 )
            continue;
          cbMetadata += iRC;
        }        
      }

      xplMutexUnlock( hmtxItems );

      // Build request to the server.

      switch( stream->protocol )
      {
        case icy_protocol_e:
          cbBuf = _snprintf( &acBuf, sizeof(acBuf), "GET /admin.cgi?mode=updinfo&pass=%s&song=",
                             stream->password );
          break;

        case http_protocol_e:
          cbBuf = _snprintf( &acBuf, sizeof(acBuf), "GET /admin/metadata?mode=updinfo&mount=%s&song=",
                             stream->mount );
          break;

        default:                     // xaudiocast_protocol_e
          cbBuf = _snprintf( &acBuf, sizeof(acBuf), "GET /admin.cgi?mode=updinfo&pass=%s&mount=%s&song=",
                             stream->password, stream->mount );
      }

      if ( cbBuf < 0 )
        continue;

      // URL-encoding for metadata.
      iRC = _urlEncode( &acMetadata, &acBuf[cbBuf], sizeof(acBuf) - cbBuf );
      if ( iRC == -1 )
        continue;
      cbBuf += iRC;

      iRC = _snprintf( &acBuf[cbBuf], sizeof(acBuf) - cbBuf,
                       " HTTP/1.0\r\nUser-Agent: ices-ne/"VERSION
                       " libshout/2.3.1%s",
                       stream->protocol == icy_protocol_e
                         ? " (Mozilla compatible)" : "" );
      if ( iRC <= 0 )
        continue;
      cbBuf += iRC;

      if ( stream->protocol == http_protocol_e )
      {
        // HTTP-autorization for Icecast.

        iRC = _snprintf( &acBuf[cbBuf], sizeof(acBuf) - cbBuf,
                         "\r\nAuthorization: Basic " );
        if ( iRC <= 0 )
          continue;
        cbBuf += iRC;

        iRC = _encodePassword( stream->password, &acBuf[cbBuf],
                               sizeof(acBuf) - cbBuf );
        if ( iRC <= 0 )
          continue;
        cbBuf += iRC;
      }

      if ( cbBuf <= 4 )
        continue;

      // Empty string - end of HTTP-request.
      *(PULONG)(&acBuf[cbBuf]) = '\n\r\n\r';
      cbBuf += 4;

      // Send request to the server.
      if ( _sendRequest( stream->host, stream->port, &acBuf, cbBuf ) &&
           ices_config.verbose )
        _logUpdated( stream, &acMetadata, cbMetadata );
    } // for stream

    xplEventReset( hevUpdate );

  } /* while( ( xplEventWait( hevUpdate, XPL_INDEFINITE_WAIT ) == NO_ERROR ) &&
              ( hevUpdate != NULLHANDLE ) ) */

#ifdef __NT__
  tid = -1;
#endif
  xplThreadEnd();
}


void ices_metadata_initialize(void)
{
  ULONG      ulRC;

  xplMutexCreate( &hmtxItems, FALSE );
  if ( hmtxItems == NULLHANDLE )
  {
    ices_log_error_output( "xplMutexCreate(), rc = %u", ulRC );
    hmtxItems = NULLHANDLE;
  }

  xplEventCreate( &hevUpdate, XPL_EV_MANUAL_RESET, FALSE );

  tid = xplThreadStart( threadUpdate, NULL );

  if ( tid == -1 )
    ices_log_debug( "Metadata update failed: can't start a thread" );
}

void ices_metadata_shutdown(void)
{
  ULONG         ulRC;
  ULONG         ulIdx;
#ifdef _ICONV_PULL
  PICONVHDL     pIConvHdl;
#endif
  volatile HEV  hevUpdateSave = hevUpdate;

  hevUpdate = NULLHANDLE;              // Thread shutdown signal.
  xplEventPost( hevUpdateSave );       // Unblock the thread.
  // Wait until thread has ended.
#ifdef __NT__
  while( tid != -1 )
    Sleep( 1 );
#else
  if ( tid != -1 )
    DosWaitThread( &tid, DCWW_WAIT );
#endif

  xplEventDestroy( hevUpdateSave );    // Destroy semaphore.

  if ( hmtxItems != NULLHANDLE )
  {
    xplMutexDestroy( hmtxItems );
    hmtxItems = NULLHANDLE;

    for( ulIdx = 0; ulIdx < MDITEM_COUNT; ulIdx++ )
      if ( aItems[ulIdx].pcText != NULL )
        debugFree( aItems[ulIdx].pcText );
  }

#ifdef _ICONV_PULL
  // Destroy iconv handles.

  while( pIConvHandles != NULL )
  {
    pIConvHdl = pIConvHandles->pNext;

    if ( pIConvHandles->pszEncIn != NULL )
      debugFree( pIConvHandles->pszEncIn );

    if ( pIConvHandles->pszEncOut != NULL )
      debugFree( pIConvHandles->pszEncOut );

    iconv_close( pIConvHandles->cd );
    debugFree( pIConvHandles );
    pIConvHandles = pIConvHdl;
  }
#endif
}

// Clear all metadata items
void ices_clear_items(void)
{
  ULONG  ulIdx;

  xplMutexLock( hmtxItems, XPL_INDEFINITE_WAIT );
  for( ulIdx = 0; ulIdx < MDITEM_COUNT; ulIdx++ )
    aItems[ulIdx].cbText = 0;
  xplMutexUnlock( hmtxItems );
}

void ices_metadata_set_item(int item, char* text, int text_len, char* enc)
{
  ULONG      ulRC;

  if ( item >= MDITEM_COUNT || text_len == 0 )
    return;

  ulRC = xplMutexLock( hmtxItems, XPL_INDEFINITE_WAIT );

  if ( ulRC != XPL_NO_ERROR )
    ices_log_debug( "xplMutexLock(), rc = %u", ulRC );
  else
  {
    PMDITEM            pItem = &aItems[item];
    PCHAR              pcNewBuf;

    if ( pItem->cbTextMax < text_len )
    {
      if ( pItem->pcText != NULL )
        debugFree( pItem->pcText );

      pItem->pcText = debugMAlloc( text_len );
      if ( pItem->pcText == NULL )
      {
        text_len = 0;
        pItem->cbTextMax = 0;
      }
      else
        pItem->cbTextMax = text_len;
    }
    memcpy( pItem->pcText, text, text_len );
    pItem->cbText = text_len;

    if ( enc != NULL )
      strlcpy( &pItem->acEnc, enc, sizeof(pItem->acEnc) );
    else
      pItem->acEnc[0] = '\0';

    xplMutexUnlock( hmtxItems );
  }
}

int ices_metadata_get_item(int item, char* buf, int buf_len, char* enc)
{
  ULONG      ulRC;
  int        cbRes;

  if ( buf == NULL || buf_len <= 0 )
    return 0;

  ulRC = xplMutexLock( hmtxItems, XPL_INDEFINITE_WAIT );
  if ( ulRC != NO_ERROR )
  {
    ices_log_debug( "xplMutexLock(), rc = %u", ulRC );
    buf[0] = '\0';
    return -1;
  }

  if ( !IS_ITEM_SET( item ) )
  {
    buf[0] = '\0';
    cbRes = 0;
  }
  else
  {
    cbRes = _strConv( enc, &aItems[item].acEnc,
                      buf, buf_len, aItems[item].pcText, aItems[item].cbText );
  }

  xplMutexUnlock( hmtxItems );

  while( cbRes > 0 && buf[cbRes - 1] == '\0' )
    cbRes--;

  return cbRes;
}




void ices_metadata_set(const char* artist, const char* title)
{
  ices_metadata_set_item( MDITEM_ARTIST, (char *)artist,
                          artist == NULL ? 0 : strlen( artist ), NULL );
  ices_metadata_set_item( MDITEM_TITLE, (char *)title,
                          title == NULL ? 0 : strlen( title ), NULL );
  ices_metadata_set_item( MDITEM_ALBUM, NULL, 0, NULL );
}

// void ices_metadata_set_file(const char* filename)
//
// Cleanup and store a file name so it looks more like a song name. It will be
// used when song name is not specified.

void ices_metadata_set_file(const char* filename)
{
  PCHAR      pcName;
  PCHAR      pcExtDot;

  if ( filename == NULL )
    ices_metadata_set_item( MDITEM_FILE, NULL, 0, NULL );
  else
  {
    pcName = strrchr( filename, '\\' );
    if ( pcName != NULL )
      pcName++;
    else
      pcName = (PCHAR)filename;

    pcExtDot = strrchr( pcName, '.' );
    if ( pcExtDot == NULL )
      pcExtDot = strchr( pcName, '\0' );

    ices_metadata_set_item( MDITEM_FILE, pcName, pcExtDot - pcName, NULL );
  }
}

void ices_metadata_get(char* artist, size_t alen, char* title, size_t tlen)
{
  ices_metadata_get_item( MDITEM_ARTIST, artist, alen, NULL );
  ices_metadata_get_item( MDITEM_TITLE, title, tlen, NULL );
}

void ices_metadata_update(int delay)
{
  char*      playlist_metadata = ices_playlist_get_metadata();

  ices_metadata_set_item( MDITEM_PLAYLIST, playlist_metadata,
                          playlist_metadata == NULL ?
                            0 : strlen( playlist_metadata ),
                          ices_config.pm.id3v1_enc );
  ices_util_free( playlist_metadata );

  xplEventPost( hevUpdate );
}
