@echo off

set package=icecast
set portdir=port

if .%1.==.clean. goto clean

rem Query current date (variable %archdate%).
@%unixroot%\usr\libexec\bin\date +"set archdate=%%Y%%m%%d" >archdate.cmd
call archdate.cmd
del archdate.cmd

set fnSrc=%package%-src-%archdate%.zip
set fnBIN=%package%-bin-%archdate%.zip

rem Cleaning.
call make-arch.cmd clean

rem Make archives of sources and binaries.

rem First archive - sources.
echo *** Packing sources: %fnSrc%.
del %fnSrc% 2>nul
7za.exe a -tzip -mx7 -r0 -x!*.zip %fnSrc% .\%portdir% make-arch.cmd

if .%1.==.sources. goto exit

echo *** Compiling the project.
cd %portdir%\src
make --no-print-directory
if errorlevel 1 goto exit
cd ..\..

rem Second archive - binaries.
echo *** Packing binaries: %fnBIN%.
del %fnBIN% 2>nul
7za.exe a -tzip -mx7 -r0 -xr!*.in -xr!Makefile %fnBIN% .\%portdir%\src\icecast.exe .\%portdir%\src\mime.types .\%portdir%\src\icecast.xqs .\%portdir%\src\admin .\%portdir%\src\doc .\%portdir%\src\web .\%portdir%\src\conf .\%portdir%\src\log
7za.exe a -tzip -mx7 -r0 %fnBIN% .\%portdir%\icecast.ico .\%portdir%\readme.os2 .\%portdir%\AUTHORS .\%portdir%\COPYING

:exit
exit

:clean
echo *** Cleaning.
cd %portdir%\src
make --no-print-directory clean
if exist .\log\* del /N .\log\*
cd ..\..
