/* Limited manual (non-WarpIn) LBMix installation by Lesha Bogdanow.
   Requires wic.exe from WarpIn 0.96 or above to be available in
   one of PATH directories.
*/
wicx="-x"
src="LBMix.wpi"

call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
call SysLoadFuncs

WarpIn=stream("wic.exe","c","query exists")
if WarpIn="" then WarpIn=EScan("PATH","wic.exe")
if WarpIn="" then do
   WarpIn=SysIni(,"WarpIN","Path")
   if (WarpIn<>'ERROR:')&(length(WarpIn)>1) then do
      if right(WarpIn,1)=D2C(0) then WarpIn=left(WarpIn,length(WarpIn)-1)
      if right(WarpIn,1)<>"\" then WarpIn=WarpIn||"\"
      WarpIn=stream(WarpIn||"wic.exe","c","query exists")
      end
   else WarpIn=""
end
if WarpIn<>"" then do
   if TestRun(WarpIN)=0 then do
      p=lastpos("\",WarpIn)
      if p>1 then
         "@SET BEGINLIBPATH="left(WarpIn,p-1)";"value('BEGINLIBPATH',,'OS2ENVIRONMENT')
      end
   if TestRun(WarpIN)=0 then WarpIn=""
   end
if WarpIn="" then do 
   say "Unable to locate or execute wic.exe from WarpIN package."
   say "Make sure you have WarpIn 0.9.6 or above installed or wic.exe and"
   say "wpirtl.dll are placed in the current or one of PATH directories."
   exit(1)
   end
wicx=WarpIn wicx

src=stream(src,'c',"query exists")
if src="" then do
   say "You have to place LBMix.wpi file into the current directory."
   exit(1)
   end
say "This is a limited manual LBMix installation utility. It will unpack LBMix base"
say "package, additional icons and preview images into the current directory and"
say "create LBMix WPS objects. Proceed with installation? (Y/N):"
do until rsp='Y'
   parse pull rsp
   rsp=translate(left(rsp,1))
   if rsp='N' then do
      say "Installation aborted."
      exit(1)
      end
   else if rsp<>'Y' then say "Invalid input. Enter Y(es) or N(o):"
   end
call Unpack 1
"@mkdir AddIcons"
"@mkdir Preview"
dir=directory()
call directory "AddIcons"
call Unpack 2
call directory "..\Preview"
call Unpack 3
call directory dir
"call LBMixUI.cmd -y"
say "Creating LBMix objects."
fdir=dir
if right(fdir,1)<>"\" then fdir=fdir||"\"
call SysCreateObject "WPFolder","LBMix","<WP_DESKTOP>","OBJECTID=<LBMIX_FOLDER>;ICONFILE="||fdir||"LBMixFld.ico;ICONNFILE=1,"||fdir||"LBMixFlO.ico"
call SysCreateObject "WPProgram","LBMix","<LBMIX_FOLDER>","OBJECTID=<LBMIX_MAIN>;EXENAME="||fdir||"LBMix.exe;STARTUPDIR="||dir
call SysCreateObject "WPProgram","LBMix Configuration","<LBMIX_FOLDER>","OBJECTID=<LBMIX_CONFIG>;EXENAME="||fdir||"LBMixCfg.cmd;ICONFILE="||fdir||"LBMixCfg.ico;STARTUPDIR="||dir
call SysCreateObject "WPProgram","Uninstall LBMix","<LBMIX_FOLDER>","OBJECTID=<LBMIX_UNINSTALL>;EXENAME="||fdir||"LBMixCfg.cmd;ICONFILE="||fdir||"LBMixRmv.ico;PARAMETERS=-u;STARTUPDIR="||dir
call SysCreateObject "WPProgram","LBMix Manual","<LBMIX_FOLDER>","OBJECTID=<LBMIX_MANUAL>;EXENAME=VIEW.EXE;ICONFILE="||fdir||"LBMixInf.ico;PARAMETERS="||fdir||"LBMix.inf"
say "Installation complete. An LBMix folder was created. See LBMix manual in this"
say "folder for details on LBMix configuration and usage."
say "You can delete LBMixIns.cmd and LBMix.wpi now."
exit(0)

Unpack:
   wicx src arg(1)
   if rc<>0 then do
      say "Failed to decompress .wpi archive."
      exit(1)
      end
   return

TestRun:
   procedure
   exe=arg(1)
   "@"exe "2>nul|rxqueue"
   ret=0
   do while queued()<>0
      parse upper pull result
      if pos("WARPIN ARCHIVE",result)<>0 then ret=1
      end
   return ret

/* Scan environment var arg(1) for a directory with file arg(2) */
EScan:
   procedure
   var=value(arg(1),,'OS2ENVIRONMENT')
   file=arg(2)
   ret=''
   do while (var<>'')&(ret='')
      if pos(';',var)<>0 then do
         dir=left(var,pos(';',var)-1)
         var=substr(var,pos(';',var)+1)
         end
      else do
         dir=var
         var=''
         end
      dir=strip(dir)
      if dir<>'' then do
         if right(dir,1)<>'\' then dir=dir'\'
         ret=stream(insert(dir,file),'c','query exists')
         end
      end
   return ret
