/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Karl Lillevold (Telenor / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_get_blk.c
 *
 * Author:	
 * Created:	
 *                                                                         
 * Description: 
 *
 * Notes: 	The functions contained in this file were adapted from
 *   		tmndecode 
 * 		Written by Karl Olav Lillevold <kol@nta.no>,
 *		1995 Telenor R&D.
 * 		Donated to the Momusys-project as background code by
 *		Telenor. 
 *   		
 *   		based on mpeg2decode, (C) 1994, MPEG Software Simulation Group
 *   		and mpeg2play, (C) 1994 Stefan Eckart
 *   					<stefan@lis.e-technik.tu-muenchen.de>
 *
 *
 * Modified:	7-May-96 Paulo Nunes: Reformatted. New headers.
 *              02.05.97 Luis Ducla-Soares: enabled the use of Reversible VLCs.
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include "vm_get_blk.h"
#include "vm_vlc_dec.h"

/***********************************************************CommentBegin******
 *
 * -- VlcGetBlock -- Decodes the DCT coefficients of one 8x8 block
 *
 * Author :		
 *	
 * Created :		
 *	
 * Purpose :		
 *	To decode the DCT coefficients of one 8x8 block.
 * 
 * Arguments in : 	
 *	Bitstream *texture_bits,	the input bitstream.
 *	SInt      inter_flag,		Inter coded mode flag. 
 *	Int        trace,		Flag to help trace.
 *	
 * Arguments in/out :	
 *	
 * Arguments out :	
 *	Int       *coeff_block,		block of DCT coefficients.
 *	Int       *error_flag,		error flag.
 *	
 * Return values :	
 *	
 * Side effects :	
 *	
 * Description :	
 *	
 * See also :
 *	
 * Modified :		
 *	04.11.96 Robert Danielsen: Passing parameter intra-luma through to
 *			VlcDecTCOEF().
 *      02.05.97 Luis Ducla-Soares: enabled the use of Reversible VLCs by
 *                                  calling function RvlcDecTCOEF().
 *      04.08.97 Minhua Zhou: added intra_dc_vlc_thr (switched)
 *
 ***********************************************************CommentEnd********/

Void
VlcGetBlock (Bitstream * texture_bits,
	     Int * coeff_block,
	     SInt inter_flag,
	     Trace *trace,
	     Int *error_flag,
	     Int intra, Int reverse_vlc,Int switched)
{

  SInt                i, j;
  Tcoef               run_level;
  Int                 last;

  if (switched) i=0;
   else
    i = (inter_flag == INTRA);
  
  do
    {
      if (reverse_vlc)
	run_level = RvlcDecTCOEF (texture_bits, error_flag, trace, intra);
      else
	run_level = VlcDecTCOEF (texture_bits, error_flag, trace, intra);
      i += run_level.run;
      
      if (*error_flag)
	return;

      if (i >= 64)
	{
	  *error_flag = 1;
          printf ("TOO MUCH COEFF !!");
	  return;
	}

      j = i;
      if (run_level.sign == 1)
	{
	  coeff_block[j] = -(run_level.level);
	}
      else
	{
	  coeff_block[j] = run_level.level;
	}
      last = run_level.last;
      i++;
    }
  while (!last);

}				/* VlcGetBlock */
