#ifndef _BVOP_H_
#define _BVOP_H_

struct refpic {
    Image   *fp_ref;    /* Full pel ME reference image */
    Image   *hp_ref;    /* Half pel ME reference image */
    SInt     mv[10];    /* MVs frame and 4 field vectors */
    Int      sad[5];    /* half-pel SADs for each MV */
    Int      vxmin;     /* X MV minimum */
    Int      vxmax;     /* X MV maximum */
    Int      vymin;     /* Y MV minimum */
    Int      vymax;     /* Y MV maximum */
};

typedef struct refpic RefPic;

struct bstate {
    Vop     *fwd_orig;  /* Forward original VOP */
    Vop     *fwd_rec;   /* Forward reconstructed VOP */
    Vop     *bak_orig;  /* Backward original VOP */
    Vop     *bak_rec;   /* Backward reconstructed VOP */
	Vop		*cur_orig;	/* current original VOP */
	Vop		*cur_rec;	/* current reconstructed VOP */
    Image   *modes;     /* Coding decisions for each MB */
    Image   *motvec;    /* motion vector components (8 SInt's per MB) */
    Image   *mottext;   /* Combined motion/texture bitstream */
    Image   *Pmode;     /* Fwd anchor macroblock modes (NULL if I-VOP) */
    Image   *Pmvx;      /* Fwd anchor MV X component (NULL if I-VOP) */
    Image   *Pmvy;      /* Fwd anchor MV Y component (NULL if I-VOP) */
    Int      interlaced;/* Interlaced (vs. progresssive) flag */
    Int      mb_height; /* image height in macroblocks */
    Int      mb_width;  /* image height in macroblocks */
    Int      mbx;       /* Current MB X coordinate */
    Int      mby;       /* Current MB Y coordinate */
    Int      x;         /* X coord of upper left pixel in currnet MB */
    Int      y;         /* Y coord of upper left pixel in currnet MB */
    Int      ewidth;    /* reference image width including edges */
    Int      ecwidth;   /* reference chroma width including edges */
    Int      cwidth;    /* Current chroma width */
    Int      ref_yoff;  /* Ref pic luma offset to upper left of cur MB */
    Int      ref_coff;  /* Ref pic chroma offset to upper left of cur MB */
    Int      cur_yoff;  /* Cur pic luma offset to upper left of cur MB */
    Int      cur_coff;  /* Cur pic chroma offset to upper left of cur MB */
    Int      mb_ndx;    /* Current macroblock index */
    Int      fieldDCT;  /* Field DCT flag */
	Int		 direct_rad;/* Direct mode search radius */
    Int      cbp;       /* Coded block pattern bits */
    RefPic   f;         /* Forward (past) reference picture info */
    RefPic   b;         /* Backward (future) reference picture info */
    Int      direct_sad;/* Direct mode SAD */
    SInt     quant;     /* Current macroblock quantizer */
    SInt     prev_quant;/* Previous macroblock quantization level */
    SInt     direct_dx; /* Direct mode X differential motion vector */
    SInt     direct_dy; /* Direct mode Y differential motion vector */
    SInt     mode;      /* Current macroblock mode */
    SInt     prev_bmt;  /* Previous MB motion type */
    SInt     mb[4*B_SIZE*B_SIZE];   /* 4:2:0 Spatial MB work area */
    SInt     mc[6*B_SIZE*B_SIZE];   /* Motion compensated MB */
    Int      diff[6*B_SIZE*B_SIZE]; /* 4:2:0 MB difference */
    Int      coef[6*B_SIZE*B_SIZE]; /* 4:2:0 Quantized coefficients */
    SInt     pmv[10];   /* Prediction motion vectors (+ zero vector) */
};

typedef struct bstate BState;

#include "interlaced_bvop.p"
#include "mom_access.p"
#include "mom_bitstream_i.p"
#include "mom_image.p"
#include "mom_putbits.p"
#include "mom_vop.p"
#include "mot_code.p"
#include "text_bits.p"
#include "text_code.p"
#include "text_code_mb.p"
#include "text_util.p"
#include "text_quant.p"
#include "vm_compos.p"
#include "vm_vop_code.p"
#include "putvlc.p"

#endif /* _BVOP_H_ */
