/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Michael Wollborn (TUH / ACTS-MoMuSys).   	  	               	
 *
 * and edited by 
 *
 * Minhua Zhou (HHI / ACTS-MoMuSys).   	  	 	              	
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        text_quant_mat_spec.h
 *
 * Author:      Michael Wollborn, TUH
 * Created:     April 23, 1997
 *
 * Description:
 *
 *	The file contains some predefined special
 *	quantization matrices for MPEG-like quantization
 *
 * Notes:
 *
 * Modified: 04.09.1997 Minhua Zhou:  changed VM matrices to flat
 *
 ***********************************************************HeaderEnd*********/


#ifndef _TEXT_QUANT_MAT_SPEC_H_ 
#define _TEXT_QUANT_MAT_SPEC_H_


/* Number of matrices */
#define NUM_MPEG_QMAT_SPEC 3

/* Special quantization matrices */

/* INTRA: 0-MPEG4 VM7, 1-MPEG2 Def., 2-MPEG2 TM5 (==MPEG2 Def.) */
static Int mpeg_iqmat_spec[3][64] = {	
					{  8,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16},


					{  8,16,19,22,26,27,29,34,
                                          16,16,22,24,27,29,34,37,
                                          19,22,26,27,29,34,34,38,
                                          22,22,26,27,29,34,37,40,
                                          22,26,27,29,32,35,40,48,
                                          26,27,29,32,35,40,48,58,
                                          26,27,29,34,38,46,56,69,
                                          27,29,35,38,46,56,69,83 },

					{  8,16,19,22,26,27,29,34,
                                          16,16,22,24,27,29,34,37,
                                          19,22,26,27,29,34,34,38,
                                          22,22,26,27,29,34,37,40,
                                          22,26,27,29,32,35,40,48,
                                          26,27,29,32,35,40,48,58,
                                          26,27,29,34,38,46,56,69,
                                          27,29,35,38,46,56,69,83 }
				    };

/* INTER: 0-MPEG4 VM7, 1-MPEG2 Def., 2-MPEG2 TM5 (==MPEG4 VM7) */
static Int mpeg_nqmat_spec[3][64] = {
					{ 16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16},

					{ 16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16 },

					{ 16,17,18,19,20,21,22,23,
                                          17,18,19,20,21,22,23,24,
                                          18,19,20,21,22,23,24,25,
                                          19,20,21,22,23,24,25,26,
                                          20,21,22,23,25,26,27,28,
                                          21,22,23,24,26,27,28,30,
                                          22,23,24,26,27,28,30,31,
                                          23,24,25,27,28,30,31,33 }
				    };


/* GRAY INTRA: 0-MPEG4 VM7, 1-MPEG2 Def., 2-MPEG2 TM5 (==MPEG2 Def.) */
static Int mpeg_giqmat_spec[3][64] = {	
					{  8,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16,
					   16,16,16,16,16,16,16,16},


					{  8,16,19,22,26,27,29,34,
                                          16,16,22,24,27,29,34,37,
                                          19,22,26,27,29,34,34,38,
                                          22,22,26,27,29,34,37,40,
                                          22,26,27,29,32,35,40,48,
                                          26,27,29,32,35,40,48,58,
                                          26,27,29,34,38,46,56,69,
                                          27,29,35,38,46,56,69,83 },

					{  8,16,19,22,26,27,29,34,
                                          16,16,22,24,27,29,34,37,
                                          19,22,26,27,29,34,34,38,
                                          22,22,26,27,29,34,37,40,
                                          22,26,27,29,32,35,40,48,
                                          26,27,29,32,35,40,48,58,
                                          26,27,29,34,38,46,56,69,
                                          27,29,35,38,46,56,69,83 }
			 	     };

/* GRAY INTER: 0-MPEG4 VM7, 1-MPEG2 Def., 2-MPEG2 TM5 (==MPEG4 VM7) */
static Int mpeg_gnqmat_spec[3][64] = {
					{ 16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16},

					{ 16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16,
					  16,16,16,16,16,16,16,16 },

					{ 16,17,18,19,20,21,22,23,
                                          17,18,19,20,21,22,23,24,
                                          18,19,20,21,22,23,24,25,
                                          19,20,21,22,23,24,25,26,
                                          20,21,22,23,25,26,27,28,
                                          21,22,23,24,26,27,28,30,
                                          22,23,24,26,27,28,30,31,
                                          23,24,25,27,28,30,31,33 }
				     };

#endif /* _TEXT_QUANT_MAT_SPEC_H_ */
