/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Noel O'Connor (TELTEC IRELAND / ACTS-MoMuSys).                   	
 *
 * and edited by 
 *
 * Cecile Dufour (LEP / ACTS-MoMuSys).     		              	
 * Bruno Loret (CNET / ACTS-MoMuSys). 	    		              	
 * Luis Ducla-Soares (IST / ACTS-MoMuSys).     	           	   	
 * Robert Danielsen (Telenor / ACTS-MoMuSys). 	    	              	
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm__enc_defs.h
 *
 * Author:	
 * Created:	
 *                                                                         
 * Description: Common definitions for Momusys VM Implementation to be used 
 *		whenever possible.
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: New header.
 *              23.04.96 Bruno Loret: Non reentrant ifndef
 *		20.02.97 Cecile Dufour: SPRITE_VOP 
 *              26.04.97 Luis Ducla-Soares: added (NON_)ERROR_RESILIENT
 *
 ***********************************************************HeaderEnd*********/


#ifndef _VM_ENC_DEFS_H_
#define _VM_ENC_DEFS_H_

#include "vm_common_defs.h"

#define DEFAULT_STATS_FILE	"encode.dat"   /* Name of file in which encoder
		bit statistics will be written  unless otherwised specified */


#define I_VOP		0		/* vop coding modes */
#define P_VOP		1
#define B_VOP		2
#define SPRITE_VOP	3	

#define VOP_VISIBLE 		1		

#define SEP_MOT_TEXT	1

#define UNRESTRICTED_MV_RANGE	16 	/* unrestricted MVs can poin
					outside VOP by this number of
 					pixels */

#define QUANT_TYPE_SEL		    0	    /* = 1 for MPEG quantization */
#define LOAD_INTRA_QUANT_MAT  	    1       /* Added, 12-JUN-1996, MW */
#define LOAD_NONINTRA_QUANT_MAT     1    

#define DEFAULT_COMP_ORDER 		TRUE	/* Vop Layer Defaults */
#define DEFAULT_VISIBILITY 		1
#define DEFAULT_SCALING 		0
#define DEFAULT_PRED_TYPE 		P_VOP
#define DEFAULT_DBQUANT			0	/* Not used */

#define BUFFER_EMPTY 			0	/* Initial state of buffer */


#define NON_ERROR_RESILIENT             1     /* non error resilient mode: 26.04.97 LDS */

#endif /* _VM_ENC_DEFS_H_ */
