/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.audio.MpaDecoder;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamProcessBase;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessAudio
extends StreamProcessBase {
    private final int AC3_AUDIOSTREAM = 0;
    private final int MP3_AUDIOSTREAM = 1;
    private final int MP2_AUDIOSTREAM = 2;
    private final int MP1_AUDIOSTREAM = 3;
    private final int DTS_AUDIOSTREAM = 4;
    private final int WAV_AUDIOSTREAM = 5;
    private final int AAC_AUDIOSTREAM = 6;
    private final int NO_AUDIOSTREAM = 10;
    private MpaDecoder MPADecoder = null;
    private PushbackInputStream InputStream;
    private IDDBufferedOutputStream OutputStream_Ch1;
    private IDDBufferedOutputStream OutputStream_Ch2;
    private String FileName_Ch1;
    private String FileName_Ch2;
    private boolean HasNewFormat;
    private boolean Debug;
    private boolean CreateChapters;
    private boolean WriteEnabled;
    private boolean AddWaveHeaderACM;
    private boolean AddWaveHeaderBWF;
    private boolean AddWaveHeaderAC3;
    private boolean DecodeMpgAudio;
    private boolean AC3_ReplaceWithSilence;
    private boolean AC3_Patch1stHeader;
    private boolean AC3_BitrateAdaption;
    private boolean ContainsVideoPTS;
    private boolean ContainsAudioPTS;
    private boolean CreateM2sIndex;
    private boolean Message_2;
    private boolean Message_7;
    private boolean PitchAudio;
    private boolean AllowSpaces;
    private boolean ValidateCRC;
    private boolean FillGapsWithLastFrame;
    private boolean LimitPts;
    private boolean AllowFormatChanges;
    private boolean AddFrames;
    private boolean DownMix;
    private boolean ChangeByteorder;
    private boolean AddRiffHeader;
    private boolean AddAiffHeader;
    private boolean ClearCRC;
    private boolean IgnoreErrors;
    private boolean CreateDDWave;
    private boolean FadeInOut;
    private boolean Normalize;
    private boolean RenameAudio;
    private int FadeInOutMillis;
    private int ResampleAudioMode;
    private int PitchValue;
    private int AudioType;
    private long ModeChangeCount;
    private long ModeChangeCount_JSS;
    private final long ModeChangeCount_Max = 100L;
    private FrameExportInfo FrameExportInfo;
    private int MpaConversionMode;
    private final int MpaConversion_None = 0;
    private final int MpaConversion_Mode1 = 1;
    private final int MpaConversion_Mode2 = 2;
    private final int MpaConversion_Mode3 = 3;
    private final int MpaConversion_Mode4 = 4;
    private final int MpaConversion_Mode5 = 5;
    private final int MpaConversion_Mode6 = 6;
    private long FileLength;
    private final long FileLength_Min = 100L;
    private double TimeCounter;
    private long FramePosition;
    private long CurrentFramePosition;
    private long TimePosition;
    private String str_wav = ".wav";
    private String str_ac3 = ".ac3";
    private String str_mpa = ".mpa";
    private String str_mp1 = ".mp1";
    private String str_mp2 = ".mp2";
    private String str_mp3 = ".mp3";
    private String str_mp4 = ".mp4";
    private String str_dts = ".dts";
    private String str_aif = ".aif";
    private String str_pcm = ".pcm";
    private String str_new = ".new";
    private String str_aac = ".aac";

    public StreamProcessAudio(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        this.processStream(jobCollection, xInputFile, string, string2, string3, n);
    }

    private void addWaveHeader(AudioFormat audioFormat, int n) {
        switch (n) {
            case 0: {
                if (this.AddWaveHeaderAC3) {
                    this.writeChannel1(audioFormat.getExtraWaveHeader(1, true));
                    Common.setMessage(Resource.getString("audio.msg.addriff.ac3"));
                } else if (this.CreateDDWave) {
                    this.writeChannel1(audioFormat.getRiffHeader());
                }
                return;
            }
            case 2: {
                this.writeChannel1(audioFormat.getExtraWaveHeader(1, true));
                if (this.MpaConversionMode >= 4) {
                    this.writeChannel2(audioFormat.getExtraWaveHeader(2, true));
                }
                return;
            }
            case 6: {
                if (this.CreateDDWave) {
                    this.writeChannel1(audioFormat.getRiffHeader());
                }
                return;
            }
        }
    }

    private boolean checkLastAudioBound(boolean bl, long l, long[] lArray, long l2) {
        if (!bl) {
            return true;
        }
        if (l > lArray[lArray.length - 1] + 10000L) {
            Common.updateProgressBar(l2, l2);
            return false;
        }
        return true;
    }

    private void closeInputStream() {
        try {
            this.InputStream.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void closeOutputStreams() {
        try {
            this.OutputStream_Ch1.flush();
            this.OutputStream_Ch1.close();
            this.OutputStream_Ch2.flush();
            this.OutputStream_Ch2.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void copyMpaFrameHeader(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        byArray2[3] = (byte)(byArray2[3] & 0xCF);
        byArray2[2] = (byte)(byArray2[2] & 0xFFFFFFFD);
    }

    private void countCurrentFramePosition(long l) {
        this.CurrentFramePosition += l;
    }

    private void countFramePosition(long l) {
        this.FramePosition += l;
    }

    private void countTimeCounter(double d) {
        this.TimeCounter += d;
    }

    private void countTimePosition(double d) {
        this.TimePosition += (long)d;
    }

    private void countTimePosition(long l) {
        this.TimePosition += l;
    }

    private boolean determineFormatChange(AudioFormat audioFormat, int n) {
        boolean bl = true;
        int n2 = audioFormat.compareHeader();
        if (n2 > 0) {
            if (!this.AllowFormatChanges && (n2 & 7) != 0 && this.FrameExportInfo.getWrittenFrames() > 0) {
                return bl ^ true;
            }
            this.HasNewFormat = true;
            if (n == 2 && n2 == 32) {
                ++this.ModeChangeCount_JSS;
                this.HasNewFormat = false;
            }
        }
        if (this.FrameExportInfo.getWrittenFrames() == 0) {
            this.HasNewFormat = true;
        }
        return bl;
    }

    private int determineStreamType(String string) {
        int n = 2;
        if (string.equals("ac")) {
            n = 0;
        } else if (string.equals("dt")) {
            n = 6;
        } else if (string.equals("wa")) {
            n = 4;
        }
        return n;
    }

    private void fillWaveHeader(AudioFormat audioFormat, int n) {
        long l = (long)(this.getTimeCounter() / 90.0);
        try {
            if (this.DecodeMpgAudio && n == 2 && MpaDecoder.WAVE) {
                if (audioFormat.getLayer() > 1) {
                    MpaDecoder.fillRIFF(this.FileName_Ch1, this.FadeInOut, this.FadeInOutMillis);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.fillRIFF(this.FileName_Ch2, this.FadeInOut, this.FadeInOutMillis);
                    }
                } else {
                    MpaDecoder.deleteRIFF(this.FileName_Ch1);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.deleteRIFF(this.FileName_Ch2);
                    }
                }
            } else if (this.DecodeMpgAudio && n == 2 && this.AddAiffHeader) {
                if (audioFormat.getLayer() > 1) {
                    MpaDecoder.fillAiff(this.FileName_Ch1, l, this.FadeInOut, this.FadeInOutMillis);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.fillAiff(this.FileName_Ch2, l, this.FadeInOut, this.FadeInOutMillis);
                    }
                } else {
                    MpaDecoder.deleteAiff(this.FileName_Ch1);
                    if (this.MpaConversionMode >= 4) {
                        MpaDecoder.deleteAiff(this.FileName_Ch2);
                    }
                }
            } else if (!this.DecodeMpgAudio && (this.AddWaveHeaderBWF || this.AddWaveHeaderACM) && n == 2) {
                RandomAccessFile[] randomAccessFileArray = new RandomAccessFile[]{new RandomAccessFile(this.FileName_Ch1, "rw"), new RandomAccessFile(this.FileName_Ch2, "rw")};
                audioFormat.setExtraWaveLength(randomAccessFileArray[0].length(), l, 1);
                audioFormat.setExtraWaveLength(randomAccessFileArray[1].length(), l, 2);
                randomAccessFileArray[0].seek(0L);
                randomAccessFileArray[1].seek(0L);
                randomAccessFileArray[0].write(audioFormat.getExtraWaveHeader(1, false));
                if (this.MpaConversionMode >= 4) {
                    randomAccessFileArray[1].write(audioFormat.getExtraWaveHeader(2, false));
                }
                randomAccessFileArray[0].close();
                randomAccessFileArray[1].close();
            } else if (this.AddWaveHeaderAC3 && n == 0) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.FileName_Ch1, "rw");
                audioFormat.setExtraWaveLength(randomAccessFile.length(), l, 1);
                randomAccessFile.seek(0L);
                randomAccessFile.write(audioFormat.getExtraWaveHeader(1, false));
                randomAccessFile.close();
            } else if (n == 4) {
                audioFormat.fillRiffHeader(this.FileName_Ch1);
            } else if (this.CreateDDWave && n == 0) {
                audioFormat.fillStdRiffHeader(this.FileName_Ch1, l);
            } else if (this.CreateDDWave && n == 6) {
                audioFormat.fillStdRiffHeader(this.FileName_Ch1, l);
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void finishOutputFile(JobProcessing jobProcessing, String string, String string2, File file, String string3, IDDBufferedOutputStream iDDBufferedOutputStream) {
        try {
            if (string == null) {
                file.delete();
                iDDBufferedOutputStream.deleteIdd();
                return;
            }
            if (string2 == null) {
                if (file.length() < 100L) {
                    file.delete();
                }
                iDDBufferedOutputStream.deleteIdd();
                return;
            }
            File file2 = new File(String.valueOf(string) + string2);
            if (file2.exists()) {
                file2.delete();
            }
            if (file.length() < 100L) {
                file.delete();
            } else {
                Common.renameTo(file, file2);
                Common.setMessage(String.valueOf(Resource.getString("msg.newfile", "")) + " '" + file2.toString() + "'");
                jobProcessing.addSummaryInfo(String.valueOf(string3) + "\t'" + file2.toString() + "'");
            }
            iDDBufferedOutputStream.renameIddTo(file2);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void finishOutputFiles(JobProcessing jobProcessing, String string, String string2, File file, File file2, String string3, IDDBufferedOutputStream iDDBufferedOutputStream, IDDBufferedOutputStream iDDBufferedOutputStream2) {
        this.finishOutputFile(jobProcessing, null, null, file2, string3, iDDBufferedOutputStream2);
        this.finishOutputFile(jobProcessing, string, string2, file, string3, iDDBufferedOutputStream);
    }

    private void finishOutputFiles(JobProcessing jobProcessing, String string, String string2, String string3, File file, File file2, String string4, IDDBufferedOutputStream iDDBufferedOutputStream, IDDBufferedOutputStream iDDBufferedOutputStream2) {
        this.finishOutputFile(jobProcessing, string, string3, file2, string4, iDDBufferedOutputStream2);
        this.finishOutputFile(jobProcessing, string, string2, file, string4, iDDBufferedOutputStream);
    }

    private String formatFrameTime(long l) {
        return Common.formatTime_1(l / 90L);
    }

    private long getCurrentFramePosition() {
        return this.CurrentFramePosition;
    }

    private long getFramePosition() {
        return this.FramePosition;
    }

    private byte[] getReplacementFrame(AudioFormat audioFormat, byte[] byArray, int n) {
        if (n != 0 || !this.AC3_ReplaceWithSilence) {
            return byArray;
        }
        if (audioFormat.getMode() == 7) {
            return byArray;
        }
        AudioFormat audioFormat2 = new AudioFormat(0);
        int n2 = 0;
        int n3 = Common.getAC3list().size();
        while (n2 < n3) {
            byte[] byArray2 = (byte[])Common.getAC3list().get(n2);
            audioFormat2.parseHeader(byArray2, 0);
            if (audioFormat2.getMode() == 7 && audioFormat2.getSamplingFrequency() == audioFormat.getSamplingFrequency() && audioFormat2.getBitrate() == audioFormat.getBitrate()) {
                byArray = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                byArray2 = audioFormat.editFrame(byArray2, 4);
                break;
            }
            ++n2;
        }
        return byArray;
    }

    private void getSettings(JobCollection jobCollection) {
        this.Debug = Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.Message_2 = Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.Message_7 = Common.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg7);
        this.CreateChapters = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createChapters);
        this.RenameAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_renameAudio);
        this.AddWaveHeaderACM = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudioL3);
        this.AddWaveHeaderBWF = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio);
        this.AddWaveHeaderAC3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffToAc3);
        this.AC3_ReplaceWithSilence = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_AC3_replaceWithSilence);
        this.AC3_Patch1stHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_AC3_patch1stHeader);
        this.AC3_BitrateAdaption = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_AC3_BitrateAdaption);
        this.CreateM2sIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createM2sIndex);
        this.PitchAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_pitchAudio);
        this.AllowSpaces = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces);
        this.ValidateCRC = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_validateCRC);
        this.FillGapsWithLastFrame = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fillGapsWithLastFrame);
        this.LimitPts = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Audio_limitPts);
        this.AllowFormatChanges = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Audio_allowFormatChanges);
        this.AddFrames = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addFrames);
        this.DownMix = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Downmix);
        this.ChangeByteorder = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_changeByteorder);
        this.AddRiffHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader);
        this.AddAiffHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader);
        this.ClearCRC = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_clearCRC);
        this.IgnoreErrors = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Audio_ignoreErrors);
        this.CreateDDWave = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_createDDWave);
        this.FadeInOut = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fadeInOut);
        this.Normalize = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Normalize);
        this.FadeInOutMillis = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_fadeInOutMillis);
        this.ResampleAudioMode = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode);
        this.PitchValue = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_PitchValue);
        this.messageSettings();
    }

    private double getTimeCounter() {
        return this.TimeCounter;
    }

    private long getTimePosition() {
        return this.TimePosition;
    }

    private void initDecoder(AudioFormat audioFormat, int n) {
        if (n != 2) {
            return;
        }
        if (!this.DecodeMpgAudio) {
            return;
        }
        MpaDecoder.init_work(this.ResampleAudioMode);
        MpaDecoder.DOWNMIX = this.DownMix;
        MpaDecoder.MONO = this.DownMix || this.MpaConversionMode == 4;
        MpaDecoder.MOTOROLA = this.ChangeByteorder;
        MpaDecoder.WAVE = this.AddRiffHeader;
        if (this.AddRiffHeader) {
            this.writeChannels(MpaDecoder.RIFF);
        }
        if (this.AddAiffHeader) {
            this.writeChannels(MpaDecoder.AIFF);
        }
    }

    private void initInputStream(XInputFile xInputFile) {
        try {
            this.InputStream = new PushbackInputStream(xInputFile.getInputStream(), 1000000);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void initOutputStreams() {
        try {
            this.OutputStream_Ch1 = new IDDBufferedOutputStream(new FileOutputStream(this.FileName_Ch1), 2048000);
            this.OutputStream_Ch2 = new IDDBufferedOutputStream(new FileOutputStream(this.FileName_Ch2), this.MpaConversionMode >= 4 ? 2048000 : 65536);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private void initProjectFiles() {
        if (this.CreateM2sIndex) {
            this.OutputStream_Ch1.InitIdd(this.FileName_Ch1, 2);
            this.OutputStream_Ch2.InitIdd(this.FileName_Ch2, 2);
        }
    }

    private boolean isCancelled(JobProcessing jobProcessing) {
        if (!CommonParsing.isProcessCancelled()) {
            return false;
        }
        CommonParsing.setProcessCancelled(false);
        jobProcessing.setSplitSize(0L);
        return true;
    }

    private void messageSettings() {
        if (this.IgnoreErrors) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_Audio_ignoreErrors[0]));
        }
        if (this.AllowSpaces) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_allowSpaces[0]));
        }
        if (this.LimitPts) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_Audio_limitPts[0]));
        }
        if (this.AllowFormatChanges) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_Audio_allowFormatChanges[0]));
        }
        if (this.ValidateCRC) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_validateCRC[0]));
        }
        if (this.ClearCRC) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_clearCRC[0]));
        }
        if (this.AC3_Patch1stHeader) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_AC3_patch1stHeader[0]));
        }
        if (this.AC3_ReplaceWithSilence) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_AC3_replaceWithSilence[0]));
        }
        if (this.AC3_BitrateAdaption) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_AC3_BitrateAdaption[0]));
        }
        if (this.FillGapsWithLastFrame) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_fillGapsWithLastFrame[0]));
        }
        if (this.AddFrames) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addFrames[0]));
        }
        if (this.CreateDDWave) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_createDDWave[0]));
        }
        if (this.AddWaveHeaderACM) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addRiffToMpgAudioL3[0]));
        }
        if (this.AddWaveHeaderBWF) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addRiffToMpgAudio[0]));
        }
        if (this.AddWaveHeaderAC3) {
            Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addRiffToAc3[0]));
        }
    }

    private void messageSourceFormat(JobProcessing jobProcessing, AudioFormat audioFormat, boolean bl, double d) {
        if (!this.HasNewFormat || bl && !this.WriteEnabled) {
            return;
        }
        String string = audioFormat.displayHeader();
        if (this.ModeChangeCount < 100L) {
            String string2 = this.formatFrameTime(d);
            Common.setMessage(String.valueOf(Resource.getString("audio.msg.source", string)) + " " + string2);
            if (this.CreateChapters) {
                jobProcessing.getChapters().addChapter(string2, string);
            }
        } else if (this.Debug) {
            System.out.println("=> src_audio: " + string + " @ " + this.formatFrameTime(d));
        }
        if (this.ModeChangeCount == 100L) {
            Common.setMessage(Resource.getString("audio.msg.source.max"));
        }
        ++this.ModeChangeCount;
        this.HasNewFormat = false;
    }

    /*
     * Exception decompiling
     */
    private boolean processAudio(JobCollection var1_1, XInputFile var2_2, String var3_3, String var4_4, String var5_5, int var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int processData(AudioFormat audioFormat, int n) {
        int n2 = 0;
        this.addWaveHeader(audioFormat, n);
        this.initDecoder(audioFormat, n);
        audioFormat.setAncillaryDataDecoder(this.Message_7, this.Debug);
        return n2;
    }

    private void processPCMData(JobProcessing jobProcessing, AudioFormat audioFormat, long[] lArray, long[] lArray2) {
        byte[] byArray = new byte[1000];
        this.readInputStream(byArray);
        audioFormat.parseHeader(byArray, 0);
        this.unreadInputStream(byArray, audioFormat.getEmphasis(), 1000 - audioFormat.getEmphasis());
        Common.setMessage(String.valueOf(Resource.getString("audio.msg.source", audioFormat.saveAndDisplayHeader())) + " " + this.formatFrameTime(this.getTimeCounter()));
        this.AudioType = 5;
        this.setFramePosition(audioFormat.getEmphasis());
        long l = audioFormat.getEmphasis() + audioFormat.getSizeBase();
        this.setTimePosition(lArray2[0]);
        this.writeChannel1(audioFormat.getRiffHeader());
        int n = 960000 / audioFormat.getMode();
        int n2 = 0;
        if (n2 < lArray2.length - 1) {
            int n3 = 0;
            int n4 = lArray.length;
            while (n3 < n4) {
                long l2;
                int n5;
                long l3;
                long l4;
                long l5;
                while (this.pause()) {
                }
                if (this.isCancelled(jobProcessing)) {
                    return;
                }
                if (this.ContainsVideoPTS && lArray[n3] < this.getTimePosition()) {
                    l5 = lArray[n3 + 1] > this.getTimePosition() ? this.getTimePosition() - lArray[n3] : lArray[n3 + 1] - lArray[n3];
                    l4 = Math.round((double)audioFormat.getSamplingFrequency() * (double)l5 / 90000.0) * (long)audioFormat.getMode();
                    if (this.Debug) {
                        System.out.println("i " + l5 + "/" + l4 + "/" + this.getFramePosition() + "/" + this.getTimePosition());
                    }
                    l3 = 0L;
                    while (l3 < l4) {
                        int n6 = n5 = l4 - l3 >= (long)n ? n : (int)(l4 - l3);
                        if (n5 != byArray.length) {
                            byArray = new byte[n5];
                        }
                        l3 += (long)n5;
                        this.writeChannel1(byArray);
                    }
                    this.countTimeCounter(l5);
                    this.FrameExportInfo.countWrittenFrames(l4 / (long)audioFormat.getMode());
                    Common.setFps(this.FrameExportInfo.getWrittenFrames());
                    if (lArray[n3 + 1] > this.getTimePosition()) {
                        l5 = lArray[n3 + 1] - this.getTimePosition();
                        l4 = Math.round((double)audioFormat.getSamplingFrequency() * (double)l5 / 90000.0) * (long)audioFormat.getMode();
                        if (this.Debug) {
                            System.out.println("b " + l5 + "/" + l4 + "/" + this.getFramePosition() + "/" + this.getTimePosition());
                        }
                        l2 = 0L;
                        while (l2 < l4) {
                            int n7 = n5 = l4 - l2 >= (long)n ? n : (int)(l4 - l2);
                            if (n5 != byArray.length) {
                                byArray = new byte[n5];
                            }
                            this.readInputStream(byArray);
                            l2 += (long)n5;
                            this.writeChannel1(byArray);
                        }
                        this.countFramePosition(l4);
                        this.countTimePosition(l5);
                        this.countTimeCounter(l5);
                        this.FrameExportInfo.countWrittenFrames(l4 / (long)audioFormat.getMode());
                    }
                } else {
                    long l6 = this.ContainsVideoPTS ? lArray[n3] - this.getTimePosition() : 0L;
                    long l7 = Math.round((double)audioFormat.getSamplingFrequency() * (double)l6 / 90000.0) * (long)audioFormat.getMode();
                    l5 = this.ContainsVideoPTS ? lArray[n3 + 1] - lArray[n3] : (long)((double)(audioFormat.getSizeBase() / audioFormat.getMode()) / (double)audioFormat.getSamplingFrequency() * 90000.0);
                    l4 = Math.round((double)audioFormat.getSamplingFrequency() * (double)l5 / 90000.0) * (long)audioFormat.getMode();
                    l3 = 0L;
                    while (l3 < l7) {
                        l3 += this.skipInputStream(l7 - l3);
                    }
                    this.countFramePosition(l7);
                    if (this.Debug) {
                        System.out.println("c " + l6 + "/" + l7 + "/" + l5 + "/" + l4 + "/" + this.getFramePosition() + "/" + this.getTimePosition());
                    }
                    l2 = 0L;
                    while (l2 < l4) {
                        int n8 = n5 = l4 - l2 >= (long)n ? n : (int)(l4 - l2);
                        if (n5 != byArray.length) {
                            byArray = new byte[n5];
                        }
                        this.readInputStream(byArray);
                        l2 += (long)n5;
                        this.writeChannel1(byArray);
                    }
                    this.countTimePosition(l6 + l5);
                    this.countTimeCounter(l5);
                    this.countFramePosition(l4);
                    this.FrameExportInfo.countWrittenFrames(l4 / (long)audioFormat.getMode());
                }
                if (this.Debug) {
                    System.out.println(String.valueOf(this.FrameExportInfo.getSummary()) + " @ " + this.formatFrameTime(this.getTimeCounter()));
                }
                Common.updateProgressBar(this.getFramePosition(), this.FileLength);
                if (this.Debug) {
                    System.out.println("FramePosition " + this.getFramePosition());
                }
                n3 += 2;
            }
        }
    }

    private void processStream(JobCollection jobCollection, XInputFile xInputFile, String string, String string2, String string3, int n) {
        Common.updateProgressBar(String.valueOf(Resource.getString("audio.progress")) + "  " + xInputFile.getName(), 0L, 0L);
        this.Normalize = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Normalize);
        this.DecodeMpgAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_decodeMpgAudio);
        if (this.MPADecoder == null) {
            this.MPADecoder = new MpaDecoder();
        }
        MpaDecoder.RESET = false;
        MpaDecoder.MAX_VALUE = this.Normalize ? Integer.parseInt(jobCollection.getSettings().getProperty(Keys.KEY_AudioPanel_NormalizeValue)) * Short.MAX_VALUE / 100 : Short.MAX_VALUE;
        MpaDecoder.MULTIPLY = this.Normalize ? Short.MAX_VALUE : 1;
        MpaDecoder.PRESCAN = MpaDecoder.NORMALIZE = this.Normalize;
        MpaDecoder.LEVELSCAN = false;
        if (MpaDecoder.MAX_VALUE > Short.MAX_VALUE) {
            MpaDecoder.MAX_VALUE = Short.MAX_VALUE;
            Common.setMessage(String.valueOf(Resource.getString("audio.msg.normalize.fixed")) + " 100%");
        }
        this.MpaConversionMode = jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_losslessMpaConversionMode);
        if (this.MpaConversionMode > 0) {
            Common.setMessage(String.valueOf(Resource.getString("audio.convert")) + " " + Keys.ITEMS_losslessMpaConversionMode[this.MpaConversionMode]);
        }
        if (this.DecodeMpgAudio) {
            Common.setMessage(Resource.getString("audio.decode"));
            Common.setMessage("-> " + Keys.ITEMS_resampleAudioMode[jobCollection.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode)]);
            if (this.Normalize) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_Normalize[0]) + " " + 100 * MpaDecoder.MAX_VALUE / Short.MAX_VALUE + "%");
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_Downmix)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_Downmix[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_fadeInOut)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_fadeInOut[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_changeByteorder)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_changeByteorder[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addRiffHeader[0]));
            }
            if (jobCollection.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_AudioPanel_addAiffHeader[0]));
            }
        }
        while (this.processAudio(jobCollection, xInputFile, string, string2, string3, n)) {
            CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() & 0xFFFFFFFFFFFFFFF3L);
            Common.setMessage(" ");
            Common.setMessage(String.valueOf(Resource.getString("audio.restart")) + " " + ((CommonParsing.getAudioProcessingFlags() >>> 18) - 1L));
            if (this.DecodeMpgAudio && this.Normalize) {
                Common.setMessage("-> normalize: multiply factor: " + MpaDecoder.MULTIPLY);
            }
            if ((0x10000L & CommonParsing.getAudioProcessingFlags()) == 0L) continue;
            this.MpaConversionMode = 0;
        }
        CommonParsing.setAudioProcessingFlags(CommonParsing.getAudioProcessingFlags() & 3L);
    }

    private int readInputStream(byte[] byArray) {
        return this.readInputStream(byArray, 0, byArray.length);
    }

    private int readInputStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.InputStream.read(byArray, n, n2);
            if (n3 < n2) {
                Arrays.fill(byArray, n + n3, n + n2, (byte)0);
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return n3;
    }

    private void setCurrentFramePosition(long l) {
        this.CurrentFramePosition = l;
    }

    private void setExtension(String[][] stringArray, String string) {
        int n = 0;
        while (n < 2) {
            int n2 = 1;
            while (n2 < 4) {
                String[] stringArray2 = stringArray[n];
                int n3 = n2++;
                stringArray2[n3] = String.valueOf(stringArray2[n3]) + string;
            }
            ++n;
        }
    }

    private void setExtension(String[][] stringArray, String string, String string2) {
        int n = 1;
        while (n < 4) {
            stringArray[0][n] = string;
            stringArray[1][n] = string2;
            ++n;
        }
    }

    private void setFramePosition(long l) {
        this.FramePosition = l;
    }

    private void setTimeCounter(double d) {
        this.TimeCounter = d;
    }

    private void setTimePosition(double d) {
        this.TimePosition = (long)d;
    }

    private void setTimePosition(long l) {
        this.TimePosition = l;
    }

    private long skipInputStream(long l) {
        long l2 = 0L;
        try {
            l2 = this.InputStream.skip(l);
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return l2;
    }

    private int unreadInputStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            this.InputStream.unread(byArray, n, n2);
            n3 = n2;
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        return n3;
    }

    private void writeChannel(byte[] byArray, int n) {
        try {
            switch (n) {
                case 1: {
                    this.OutputStream_Ch1.write(byArray);
                    return;
                }
                case 2: {
                    this.OutputStream_Ch2.write(byArray);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return;
        }
    }

    private void writeChannel1(byte[] byArray) {
        this.writeChannel(byArray, 1);
    }

    private void writeChannel2(byte[] byArray) {
        this.writeChannel(byArray, 2);
    }

    private void writeChannels(byte[] byArray) {
        this.writeChannels(byArray, byArray);
    }

    private void writeChannels(byte[] byArray, byte[] byArray2) {
        this.writeChannel(byArray, 1);
        if (this.MpaConversionMode >= 4) {
            this.writeChannel(byArray2, 2);
        }
    }

    private void writeChannels(byte[][] byArray) {
        this.writeChannels(byArray[0], byArray[1]);
    }

    private boolean writeFrame(AudioFormat audioFormat, byte[] byArray, byte[][] byArray2, boolean bl, int n) {
        if (bl && !this.WriteEnabled) {
            return false;
        }
        switch (n) {
            case 0: {
                if (this.AC3_BitrateAdaption) {
                    byArray = audioFormat.editFrame(byArray, 2);
                }
                if (this.AddWaveHeaderAC3) {
                    audioFormat.parseRiffData(byArray, 1);
                }
                this.writeChannel1(byArray);
                break;
            }
            case 2: {
                if (this.DecodeMpgAudio && audioFormat.getLayer() > 0) {
                    this.writeChannel1(MpaDecoder.decodeArray(byArray));
                    if (this.MpaConversionMode < 4) break;
                    this.writeChannel2(MpaDecoder.get2ndArray());
                    break;
                }
                if (this.MpaConversionMode != 0) {
                    byArray2 = audioFormat.convertFrame(byArray, this.MpaConversionMode);
                    this.writeChannel1(byArray2[0]);
                    if (this.MpaConversionMode < 4) break;
                    this.writeChannel2(byArray2[1]);
                    break;
                }
                this.writeChannel1(byArray);
                audioFormat.parseRiffData(byArray, 1);
                break;
            }
            case 6: {
                this.writeChannel1(byArray);
                break;
            }
        }
        this.FrameExportInfo.countWrittenFrames(1);
        this.countTimeCounter(audioFormat.getFrameTimeLength());
        return true;
    }

    private boolean writeSuccessiveFrame(AudioFormat audioFormat, byte[] byArray, byte[][] byArray2, boolean bl, long l, long[] lArray, int n, int n2) {
        if (lArray[n + 1] != -1L && lArray[n + 1] <= l) {
            return false;
        }
        this.writeFrame(audioFormat, byArray, byArray2, bl, n2);
        return true;
    }

    class FrameExportInfo {
        private int writtenFrames;
        private int preInsertedFrames;
        private int skippedFrames;
        private int insertedFrames;
        private int addedFrames;
        private String head = "Audio Frames: wri-pre-skip-ins-add: ";
        private String delim = "-";

        public FrameExportInfo() {
            this.reset();
        }

        public void countAddedFrames(int n) {
            this.addedFrames += n;
        }

        public void countInsertedFrames(int n) {
            this.insertedFrames += n;
        }

        public void countPreInsertedFrames(int n) {
            this.preInsertedFrames += n;
        }

        public void countSkippedFrames(int n) {
            this.skippedFrames += n;
        }

        public void countWrittenFrames(int n) {
            this.writtenFrames += n;
        }

        public void countWrittenFrames(long l) {
            this.writtenFrames += (int)l;
        }

        public String getShortSummary() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.preInsertedFrames);
            stringBuffer.append(this.delim);
            stringBuffer.append(this.skippedFrames);
            stringBuffer.append(this.delim);
            stringBuffer.append(this.insertedFrames);
            stringBuffer.append(this.delim);
            stringBuffer.append(this.addedFrames);
            return stringBuffer.toString();
        }

        public String getSummary() {
            StringBuffer stringBuffer = new StringBuffer(this.head);
            stringBuffer.append(this.writtenFrames);
            stringBuffer.append(this.delim);
            stringBuffer.append(this.getShortSummary());
            return stringBuffer.toString();
        }

        public int getWrittenFrames() {
            return this.writtenFrames;
        }

        public void reset() {
            this.writtenFrames = 0;
            this.preInsertedFrames = 0;
            this.skippedFrames = 0;
            this.insertedFrames = 0;
            this.addedFrames = 0;
        }
    }
}

