/*

@echo off
cls
echo.
echo This INSTALL routine requires OS/2 REXX support installed.
echo Run Selective Installation from the OS/2 Setup Folder to
echo install REXX support before attempting to run this CMD file.
pause
exit

       *-------------------------------------------------------------*
       |                                                             |
       |                 ProjectX OS/2 INSTALL SCRIPT                |
       |                                                             |
       |        INSTOS2.CMD - Install procedure for ProjectX         |
       |                      (Only installs already build archive)  |
       |                                                             |
       |             (C)Copyright 2001-2006 Juergen Ulbts            |
       |             Based on the Java Movie Database script         |
       |             All Rights Reserved                             |
       |                                                             |
       *-------------------------------------------------------------*
*/

PARSE ARG arg '[' WarpIN ']'

'@echo off'

BootDrive             = ''
ProgramInstallPath    = directory()
JavaEXEString         = 'JAVA.EXE'
searchJavaString01    = 'PROGRAMS\JAVA'
JDKInstallPath        = ''
ProgramIcon              = ProgramInstallPath||'\projectx_os2.ico'
ErrorCodeJAVA         = 0     /* ErrorCodes: 11=Java not found,...  */

CopyrightLine1  = 'OS/2 Install script for the ProjectX utility'
CopyrightLine2  = '(C) Copyright 2006 - Juergen Ulbts'
CopyrightLine3  = 'You are allowed to use this code to build your own install script!'
CopyrightLine4  = 'ProjectX is freeware program - Sourcecode available!'
CopyrightLine5  = 'The latest version can be found at: http://www.lucike.info/'

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


AvailDrives = SysDriveMap('C:', 'LOCAL')

/* Get boot drive letter */
done = 0
do while \ done
  IF WarpIN >< "WarpIN" then call ShowScriptCopyright
  BootDrive=GetBootDrive()
  done = 1
end

/* get the name of the Java Version from the bootdrive */
call getJavaVersionFromBootDrive
if ErrorCodeJAVA = 0 then
  if JDKInstallPath='' then ErrorCodeJAVA = 11


/* Check if this is an automatically called script... */
if WarpIN = "WarpIN" then do
   call CreateSTARTOS2CMD_NOOUTPUT
   EXIT
end /* do */




/* --------------- */
if ((ErrorCodeJAVA=0)) then
	do forever   /* main selection loop */
		call ShowScriptCopyright
		say 'Select one of the following:'
		say
		say '  0. Exit ProjectX install'
		say '  1. Create ProjectX desktop objects (including startos2*.cmd scripts)'
		say '  2. Create ProjectX "startos2*.cmd" scripts'
		say
		say '  ESC to quit'
		say
		call charout, 'Press 0,1,2 or ESC: '
		do forever 
			k = translate(SysGetKey('NOECHO'))
			if k = '0' | k = D2C(27) then
				call InstallEnd
			else do
				if k = '1' then do
					call CreatePMObjects
					leave
				end
			
				if k = '2' then do
					call CreateSTARTOS2CMD
					leave
				end
			end
			call beep 1760, 50
		end 
	end /* do forever */
/* --------------- */

Select

   when ErrorCodeJRE=11 then do
	say 'ERROR 11: Java Runtime not found! You have to manually update the CMD file!'
	say
	call PressAnyKey
	call InstallEnd
   end /* do */
	
   otherwise
	call InstallEnd
end  /* select */




/* ===================================== */
/*  ADDITIONAL PROCEDURES AND FUNCTIONS  */
/* ===================================== */


/* Create PM ProjectX objects on desktop */
CreatePMObjects:
  call ShowScriptCopyright
  say
  call CreateSTARTOS2CMD_NOOUTPUT

  if SysCreateObject("WPFolder","ProjectX","<WP_DESKTOP>", "OBJECTID=<ProjectX_Folder>", "R") Then
    if SysCreateObject("WPProgram", "ProjectX",               "<ProjectX_Folder>",  "EXENAME="ProgramInstallPath"\STARTOS2.CMD;STARTUPDIR="ProgramInstallPath";ICONFILE="ProgramIcon, "R") then 
      if SysCreateObject("WPProgram", "ProjectX-JavaDebug",    "<ProjectX_Folder>",  "EXENAME="ProgramInstallPath"\STARTOS2DEBUG.CMD;STARTUPDIR="ProgramInstallPath";ICONFILE="ProgramIcon, "R") then 
	if SysCreateObject("WPProgram", "ReleaseNotes", "<ProjectX_Folder>", "EXENAME=e.exe;PARAMETERS=ReleaseNotes_0.90.4.txt;STARTUPDIR="ProgramInstallPath";", "R") then
	say 'All objects were created!'
      Else say 'Failed to create ProjectX-JavaDebug program object!'
    Else say 'Failed to create ProjectX program object!'
  Else say 'Failed to create ProjectX folder on the desktop! No other objects were created!'




  if SysCreateObject("WPFolder","Help and Links","<ProjectX_Folder>", "OBJECTID=<ProjectX_Links>", "R") Then
    if SysCreateObject("WPUrl", "ProjectX Help", "<ProjectX_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(ProgramInstallPath||"/htmls", "/", "\")"/index.html;", "R")  then
      if SysCreateObject("WPUrl", "ProjectX Official Homepage", "<ProjectX_Links>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.lucike.info/page_projectx.htm;", "R") then
      say 'All Links were created!'
    Else say 'Failed to create ProjectX Help object!'
  Else say 'Failed to create additional LINKS folder on the desktop! No additional URL objects were created!'
  
  call PressAnyKey
  return




/* Create startos2.cmd */
CreateSTARTOS2CMD:
  call ShowScriptCopyright
  say
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  CALL lineout startfile, "@ECHO OFF"
  CALL lineout startfile, "SET BEGINLIBPATH=.\lib\os2\;"
  CALL lineout startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...')!"
  CALL lineout startfile, JDKInstallPath||"JAVAW.EXE -cp ProjectX.jar;.\lib\os2\;.; -jar ProjectX.jar"
  CALL lineout startfile
  say 'STARTOS2.CMD created.'

  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  CALL lineout startfile, "@ECHO OFF"
  CALL lineout startfile, "SET BEGINLIBPATH=.\lib\os2\;"
  CALL lineout startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...')!"
  CALL lineout startfile, JDKInstallPath||"JAVA.EXE -cp ProjectX.jar;.\lib\os2\;.; -jar ProjectX.jar"
  CALL lineout startfile
  say 'STARTOS2DEBUG.CMD created.'

  call PressAnyKey
  return


/* Create startos2.cmd without screen output */
CreateSTARTOS2CMD_NOOUTPUT:
  startfile = 'startos2.cmd'
  '@del 'startfile' >nul 2>>&1'
  CALL lineout startfile, "@ECHO OFF"
  CALL lineout startfile, "SET BEGINLIBPATH=.\lib\os2\;"
  CALL lineout startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...')!"
  CALL lineout startfile, JDKInstallPath||"JAVAW.EXE -cp ProjectX.jar;.\lib\os2\;.; -jar ProjectX.jar"
  CALL lineout startfile

  startfile = 'startos2debug.cmd'
  '@del 'startfile' >nul 2>>&1'
  CALL lineout startfile, "@ECHO OFF"
  CALL lineout startfile, "SET BEGINLIBPATH=.\lib\os2\;"
  CALL lineout startfile, "REM You may have to add the path to the Java1xx runtime ('x:\java1xx\bin\jre\java.exe -cp ...')!"
  CALL lineout startfile, JDKInstallPath||"JAVA.EXE -cp ProjectX.jar;.\lib\os2\;.; -jar ProjectX.jar"
  CALL lineout startfile
  return


/* Show script copyright notice */
ShowScriptCopyright:
  call SysCls
  say
  say
  say CopyrightLine1
  say CopyrightLine2
  say CopyrightLine3
  say
  say CopyrightLine4
  say CopyrightLine5
  say
  say
  return


/* Get installed JAVA version from the BootDrive */
getJavaVersionFromBootDrive:
   CALL SysFileTree BootDrive||'\'||searchJavaString01||'*', 'javaSysFileDir', 'DO'
   do jreCounter=javaSysFileDir.0 to 1 by -1
      PARSE UPPER VAR javaSysFileDir.jreCounter javaStr 

/* say 'JAVA Verzeichnis: '||javaStr */

      /* Start - Search in Directory for JAVA.EXE file... */
      CALL SysFileTree javaStr||'\BIN\'||JavaEXEString, 'javaEXESysFileDir', 'FSO'
      do jreCounterEXE=1 to javaEXESysFileDir.0
	 PARSE UPPER VAR javaEXESysFileDir.jreCounterEXE JDKInstallPath 'JAVA.EXE'
      end /* do - javaEXESysFileDir */

      if javaEXEPath='' then do
	 CALL SysFileTree javaStr||'\JRE\'||JavaEXEString, 'javaEXESysFileDir', 'FSO'
	 do jreCounterEXE=1 to javaEXESysFileDir.0
	    PARSE UPPER VAR javaEXESysFileDir.jreCounterEXE JDKInstallPath 'JAVA.EXE'
	 end   /* do - javaEXESysFileDir */
      end /* do - if then */
      /* End - Search in Directory for JAVA.EXE file... */
      
/* say 'Java EXE Path: '||JDKInstallPath */

      if JDKInstallPath><'' then LEAVE
      
   end /* do - javaSysFileDir - Search for x:\JAVA* directories */

  return JDKInstallPath
/* END GetJavaVersionFromBootDrive*/






/* Wait for a key press */
PressAnyKey:
  call charout, 'Press any key to continue...'
  call SysGetKey 'NOECHO'
  return



/* Get path from user */
GetPath:
  call charout, '> '
  parse pull APath
  len = length(APath)
  if len > 0 then
    if substr(APath, len, 1) = '\' then
      APath = substr(APath, 1, len-1)
  return APath




/*
GetBootDrive
   Use SysBootDrive (RexxUtils) if it is available, use RxBootDrive
   (RxExtras) if it is available, or use an alternate method to get the
   value if neither is available.  Uncomment following if GetBootDrive
   is imbedded in a routine.
*/

/* Get Bootdrive */
GetBootDrive: Procedure
If \Rxfuncquery('SysBootDrive') Then
   bootdrive = SysBootDrive()       /* Object or Updated Classic Rexx */
Else
   Do
      If \Rxfuncquery('RxBootDrive') Then
	 bootdrive = RxBootDrive()                        /* RxExtras */
      Else
	 Do                       /* Examine various config.sys items */
	    Parse Upper Value Value('PATH', ,'ENVIRONMENT') ,
	       With ':\OS2\SYSTEM' - 1 bootdrive + 2
	    If bootdrive = '' Then
	       bootdrive = ,
	       Substr(Value('RUNWORKPLACE', ,'ENVIRONMENT'), 1, 2 )
	    If bootdrive = '' Then
	       bootdrive = ,
	       Substr(Value('COMSPEC', ,'ENVIRONMENT'), 1, 2)
	    If bootdrive = '' Then
	       bootdrive = ,
	       Substr(Value('OS2_SHELL', ,'ENVIRONMENT'), 1, 2)
	    If bootdrive = '' Then
	       bootdrive = ,
	       Substr(Value('SYSTEM_INI', ,'ENVIRONMENT'), 1, 2)
	    If bootdrive = '' Then
	       bootdrive = ,
	       Substr(Value('USER_INI', ,'ENVIRONMENT'), 1, 2)
	    If bootdrive = '' Then                      /* no guesses */
	       bootdrive = 0
	 End
   End
Return bootdrive               /* Returns BootDrive, letter and colon */



/* End message */
InstallEnd:
  call SysCls
  say
  say
  say 'Program installation ended.'
  exit

