/* KMPFS Korean Movie Player File Selector front-end by DGD (mod'd from LD4)
  Play (tagging for multiple in sequence), Move, or Delete files.
  Keyboarding still beats mousing around! This makes KMP my favorite player.
  Uses Classic REXX (+ RexxUtil) only. Freeware, but only for OS/2 - ECS.
  Easily adaptable to most command line programs: modify just two lines!

Commands implemented: 
  <enter> launches executable (kmp.exe); on multiple files if tagged, though
    NOT on the one cursor highlighted if it's not tagged TOO
  <esc> exits
  <home> sets a directory to move files to, useful for sorting into categories
  <insert> moves highlighted file to "home" directory (no confirmation...)
  <del> asks to confirm, deletes file
  F1 brings up help for file selector subsystem (you should take a look...)
    lowercase a-z select drive; also uses some uppercase keys...
    <space> toggles tag and moves down; ctrl-up & ctrl-down set tag and move
  (keys not specifically assigned may bail out to the command line...)

NOTES:
 - Documentation for KMP is a bit terse; you may need to add to the file_types
   variable. No known limit on types or size of result list: it's REXX!

Version 1.01 corrects home/move problem that somehow passed initial tests...
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCurState 'OFF'
call syscls

/* CONSTANTs for some useful keys; see ex_read_key */
zky= d2c(0);  xky= d2c(224); /* prefixes for extended keys */
k_esc= x2c('1b');  k_enter= x2c('0d');  k_bksp= d2c(8);  k_tab= d2c(9);
k_up= 'H';    k_down= 'P';  k_left= 'K';  k_right= 'M';
k_ins= 'R';   k_del= 'S';   k_home= 'G';  k_end= 'O';
k_pgup= 'I';  k_pgdn= 'Q';
/* control keys */
k_cleft= 's'; k_cright= 't';  k_cup= ''||d2c(141); k_cdn= ''||d2c(145);
k_cpgup= ''||d2c(132);  k_cpgdn= 'v';
/* function keys; only F1 (Help) used in file_select */
k_f1= zky||';';  k_f2= zky||'<';  k_f3= zky||'=';  k_f4= zky||'>';
k_f5= zky||'?';  k_f6= zky||'@';  k_f7= zky||'A';  k_f8= zky||'B';
k_f9= zky||'C';  k_f10= zky||'D'; k_f11= zky||d2c(133);  k_f12= zky||d2c(134);

/* text screen colors: used for highlighting */
black= 0; red= 1; green= 2; yellow= 3;
blue= 4; magenta= 5; cyan= 6; white= 7;
fgnd = 30   /* add color: 30 + 2 = 32 ==> green foreground */
bgnd = 40   /* add color: 40 + 7 = 47 ==> white background */
AEsc= '1B'x||'['  /* define ANSI-ESCape; + 0 = low, 1 = high int*/
norcolr= AEsc||'0;'||fgnd + white||';'||bgnd + black||'m' /* normal */
revcolr= AEsc||'0;'||fgnd + black||';'||bgnd + white||'m' /* reversed */
ansi_clreol= AEsc||'K'

/* semi-CONSTANT */
parse value systextscreensize() with scry scrx
scry= scry - 1; scrx= scrx - 1; /* adj to 0, 0 based values */

numeric digits 12 /* necessary to display bytes of gigabytes */

glo_var= 'dirlist.' 

/* ============== ALL CODE ABOVE is necessary for file_select ============ */

/* ================== Begin FRONT-END SPECIFIC section. =================== */

file_types= '*.avi *.flv *.mov *.mp4 *.mpg *.rm *.rmvb *.webm *.wmv'
/* list all file types for directory list (initially will be in this order) */

fs_path= '' /* if '' on entry to "do until" loop, uses current directory */
curfil= ''
home_dir= filespec("path", directory()||'\') /* init to somewhere... */

do until k= k_esc /* <esc> exits */
/* calling parameters:
 fs_scol, glo_var, fs_path, fs_flspc, fs_attr, fs_cur, fs_sort, fs_initpos, fs_view, fs_filter
*/
/* ********* Ensure that spec'd initial directory actually exists! **********/
if fs_path = '' then fs_path= directory() /* handles case of started in dir */
rv= file_select(27, glo_var, fs_path, file_types, '', curfil, 'N', 'M', 'DTS', 1)
/* This is anchor^ column: DETAILS SHOW TO LEFT; FILE NAMES SHOW TO RIGHT
   The number 27 here effectively erases KMP's text output. */

k= word(rv, 1) /* the key code returned; see key constants above */

select /* on key */
when k = k_enter then do
  if pos('', rv) > 0 then do /* if any tagged, sequence ONLY tagged files: */
    do loop= 1 to length(word(rv, 3))  /* one highlighted at <enter> is NOT */
      if substr(word(rv, 3), loop, 1) = '' then do  /* played UNLESS tagged */
        t= dirlist.loop
        fn= substr(t, wordindex(t, 5), length(t) - wordindex(t, 5) + 1)
              /* dirlist. words #s ^ differ from those in rv    ^ */
        if filespec("drive", fn) = '' then fn= fs_path||fn
        'kmp.exe -vol 95 "'fn'"' /* double quote file names to handle spaces */
      end
    end
  end
  else do /* none tagged, just do the ONE highlighted at <enter> */
    fn= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
    'kmp.exe -vol 95 "'fn'"'
  end
end
when k = k_del then do /* ask, delete file */
  fn= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
  t= 0  /* ^ this line prepares for re-entering file_select */
  do until chars() > 0
    t= t + 1
    call syscurpos fs_sel.fs_lvl - 1, 1 /* CHEAT by using file_select variables */
    if t // 2 = 1 then call charout, revcolr||'  Delete this file? (Y)   '||norcolr
    else call charout, '                          '
    call syssleep 0.5 /* DECIMAL MAY NOT WORK IN OLDER REXXUTIL? Use 1 */
  end
  k= translate(ex_read_key())
  if k = 'Y' then do
    rv= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
    'del "'rv'"'
  end
  k= '' /* so doesn't exit if <esc> hit */
end
when k = k_home then do /* mark home directory */
  fn= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
  t= word(rv, 2) /* get index; check really is dir */
  if (t > 2) & (substr(dirlist.t, wordindex(dirlist.t, 4) + 1, 1) = 'D') then do
    rv= dirlist.t /* only as temp var */
    home_dir= '\'||substr(rv, wordindex(rv, 5), length(rv) - wordindex(rv, 5) + 1)
  end
end
when k = k_ins then do /* <insert> key moves the file IMMEDIATELY... */
  fn= substr(rv, wordindex(rv, 4), length(rv) - wordindex(rv, 4) + 1)
  rv= substr(rv, lastpos('\', rv) + 1, length(rv) - lastpos('\', rv))
  'move "'||rv||'" "'||home_dir||'"'
end
otherwise nop
end /* select */
fs_path= filespec("drive", fn)||filespec("path", fn) /* these two lines */
curfil= filespec("name", fn) /* reset loop back to same dir and file */
end /* key loop */
exit

/* ============== End of application (KMP) specific section. ============ */

/* Er, file_select is so complicated that for documentation (those interested
   in more than the basic application above) you'll just have to do what I do:
   READ the code. However, I direct your attention to the fs_filter variable
   in the fs_exit procedure that's called after a left-arrow key, which for 
   GENERAL purposes is handy to automatically turn off filtering when 
   ascending the tree; it's commented out for SPECIFIC applications as here, 
   but filtering can still be turned off manually with "F" (uppercase), OR 
   will be turned off if you delete the last of files in file_types in current
   directory, OR when changing drives. Can confuse, but HAS TO be that way...
*/

/* ============== ALL CODE BELOW is necessary for file_select ============ */

/* does not save or restore the screen. */

file_select:
parse arg fs_scol, glo_var, fs_path, fs_flspc, fs_attr, fs_cur, fs_sort, fs_initpos, fs_view, fs_filter
  ndx= 0; scrx= scrx; fs_showln= scry; /* initialize */
  fs_sort= translate(fs_sort); fs_initpos= translate(fs_initpos); fs_view= translate(fs_view);
  if pos(fs_sort, 'DENS') = 0 then fs_sort= 'N' /* useful default: fs_sort on Name */
  if pos(fs_initpos, 'HMT') = 0 then fs_initpos= 'M' /* show Middle of list */
  if fs_attr = '' then fs_attr= '*****'
  fs_dtlwid= 1; /* too complex to check fs_view correctness, SO UP TO YOU */
  if length(fs_view) > 0 then do fs_loop= 1 to length(fs_view)
    v= substr(fs_view, fs_loop, 1) /* always GET details, CHOOSE which to display */
    if v= 'D' then fs_dtlwid= fs_dtlwid + 9  /* date */
    if v= 'T' then fs_dtlwid= fs_dtlwid + 6  /* time */
    if v= 'S' then fs_dtlwid= fs_dtlwid + 11 /* size */
    if v= 'A' then fs_dtlwid= fs_dtlwid + 6  /* attributes */
    if v= 'L' then fs_dtlwid= fs_dtlwid + 5 /* show Long (Y2K) form */
  end
  /* end \ is crucial, ensure ALWAYS present, starting here to count fs_lvls */
  /* # of levels is actually limited only by a literal '10' in fs_enter_dir */
  /* DON'T advise entering here with more than 9 levels in path! */
  if substr(fs_path, length(fs_path), 1) \= '\' then fs_path= fs_path||'\'
  fs_lvl= 0
  do fs_loop= 1 to length(fs_path)
    if substr(fs_path, fs_loop, 1) = '\' then fs_lvl= fs_lvl + 1
  end
  fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
  if fs_ndx = 2 then do /* only dots back? turn off fs_filter and try for ANY */
    fs_filter= 0
    fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
  end
  if fs_ndx > 2 then do /* found more than dot dirs (no indent saves space) */
  fs_tags= copies('', fs_ndx) /* prepare tag "array" */
  call fs_set_sel
  call fs_show_new_dir
  do fs_loop= 0 to fs_showln /* helps to set off from previous text */
    call syscurpos fs_loop, fs_scol - fs_dtlwid
    call charout, ''
  end
  fs_quit= 0
  fs_t= time('R') /* BUSY in keyboard poll, but SLOW if sleeps every loop */
  /* sleeps after period (below) of no key -- reset timer every keypress */
  do while fs_quit < 1  /* begin key control */
    if chars() > 0 then do
    fs_kd= ex_read_key()
    fs_t= time('R') /* reset may conflict with app; could use counter var */
    fs_n= fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl /* used several times */
    select /* by key */
    when fs_kd = 'K' then call fs_exit_dir /* left arrow */
    when fs_kd = 'M' then call fs_enter_dir /* right arrow */
    when fs_kd = 'H' then do /* up arrow */
      if fs_sel.fs_lvl > 1 then do
        call fs_lowlight
        fs_sel.fs_lvl= fs_sel.fs_lvl - 1
        call fs_highlight
      end
      else do /* fs_sel.fs_lvl = 1 so scroll down */
        if fs_ndx_ofs.fs_lvl > 0 then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - 1
          call fs_show_section
        end
      end
    end
    when fs_kd = 'P' then do /* down arrow */
      if fs_sel.fs_lvl <= fs_maxln - 1 then do
        call fs_lowlight
        if fs_n < fs_ndx then fs_sel.fs_lvl= fs_sel.fs_lvl + 1
        call fs_highlight
      end
      else do /* fs_sel.fs_lvl > fs_maxln so scroll up */
        if fs_ndx_ofs.fs_lvl < fs_ndx - fs_showln then do
          if fs_sel.fs_lvl < fs_ndx - 1 then fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + 1
          call fs_show_section
        end
      end
    end
    when fs_kd = 'I' then do /* page up */
      fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - fs_showln
      if fs_ndx_ofs.fs_lvl < 0 then do
        fs_ndx_ofs.fs_lvl= 0
        fs_sel.fs_lvl= 1
      end
      call fs_show_section
    end
    when fs_kd = ''||d2c(132) then do /* ctrl-page up */
      fs_ndx_ofs.fs_lvl= 0
      fs_sel.fs_lvl= 1
      call fs_show_section
    end
    when fs_kd = 'Q' then do /* page down */
      if fs_ndx > fs_showln then do
        if fs_n + fs_showln < fs_ndx then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + fs_showln
        end
        else do
          fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
          fs_sel.fs_lvl= fs_showln
        end
      end
      else fs_sel.fs_lvl= fs_ndx
     call fs_show_section 
    end
    when fs_kd = 'v' then do /* ctrl-page down */
      if fs_ndx > fs_showln then do
        fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
        fs_sel.fs_lvl= fs_showln
        call fs_show_section
      end
    end
    when fs_kd > '`' & fs_kd < '{' then do /* LOWERCASE a-z, select drive */
      fs_kd = translate(fs_kd)
      if pos(fs_kd, sysdrivemap('A:', 'USED')) > 0 then do /* select new drive */
        fs_path= fs_kd||':\'
        fs_lvl= 1
        fs_filter= 0 /* cures not finding files when changing drive */
        fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
        fs_cur= ''
        fs_tags= copies('', fs_ndx)
        call fs_set_sel
        call fs_show_new_dir
      end
    end
    when fs_kd = 'F' then do  /* fs_filter toggle */
      if fs_filter = 1 then fs_filter= 0; else fs_filter= 1
      fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
      fs_tags= copies('', fs_ndx)
      call fs_set_sel
      call fs_show_new_dir
    end
    when fs_kd = 'H' | fs_kd = 'M' | fs_kd = 'T' then do
      fs_initpos= fs_kd
      fs_cur= '' /* set off so fs_set_sel uses fs_initpos rather than finds this */
      call fs_set_sel
      call fs_show_new_dir
    end
    when fs_kd = 'D' | fs_kd = 'E'| fs_kd = 'N' | fs_kd = 'S' then do
      fs_sort= 'N'; call fs_sort_list; /* always fs_sort first by name */
      if fs_kd <> 'N' then do       /* results in better ordering */
        fs_sort= fs_kd; call fs_sort_list;
      end
      call fs_show_new_dir
    end
    when fs_kd = ''||d2c(141) then do /* ctrl-up; SET tag and move up */
      if fs_n > 2 then fs_tags= overlay('', fs_tags, fs_n) /* don't tag dot dirs */
      if fs_sel.fs_lvl > 2 then do
        call syscurpos fs_sel.fs_lvl - 1, fs_scol
        call fs_show_tag(fs_n)
        call fs_lowlight
        fs_sel.fs_lvl= fs_sel.fs_lvl - 1
        call fs_highlight
      end
      else do
        if fs_ndx_ofs.fs_lvl > 0 then do
          fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl - 1
          call fs_show_section
        end
      end
    end
    when fs_kd = ' ' |,   /* <space> TOGGLE tag and move down */
      fs_kd = ''||d2c(145) then do /* ctrl-down; SET tag and move down */
      if fs_n > 2 then do
        if fs_kd= ' ' & substr(fs_tags, fs_n, 1) = '' then fs_tags= overlay('', fs_tags, fs_n)
          else fs_tags= overlay('', fs_tags, fs_n)
          call syscurpos fs_sel.fs_lvl - 1, fs_scol
          call fs_show_tag(fs_n)
          if fs_sel.fs_lvl <= fs_maxln - 1 then do
          call fs_lowlight
          if fs_n < fs_ndx then fs_sel.fs_lvl= fs_sel.fs_lvl + 1
          call fs_highlight
        end
        else do
          if fs_ndx_ofs.fs_lvl < fs_ndx - fs_showln then do
            if fs_sel.fs_lvl < fs_ndx - 1 then fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + 1
            call fs_show_section
          end
        end
      end
    end
    when fs_kd = d2c(0)||';' then do /* F1 Help */
      call fs_show_instructions fs_scol
      call fs_show_section
    end
    when fs_kd = x2c('0d') then do /* <enter>, return selected name */
      if fs_n < 3 then call fs_exit_dir /* EXCEPT on dot dir, go up */
      else do
        fs_action= fs_kd
        fs_quit= 1
      end
    end
    otherwise do /* EXIT all other keys, handle in caller. May be annoying */
      fs_action= fs_kd /* because loses settings merely to discard a key. */
      fs_quit= 1 /* Can add code here of course. Not easy to re-enter */
    end /* without re-initializing; need static variables. */
    end /* select */
    end /* if charin > 0 */
    else do /* without sleep keyboard poll keeps CPU BUSY */
      if time('E') > 3 then call syssleep 0.5 /* makes response lag, though */
    end
  end /* while fs_quit */
  end /* fs_ndx > 0 so some found */
  else do
    fs_action= 'Not_Found'
    fs_n= 0
    fs_rv= ''
  end
return fs_action' '||fs_n||' '||fs_tags||' ' ||fs_path||fs_filnam(fs_n)

fs_fildat: /* word 1, year 2 or 4 chars depending whether 'L' in fs_view */
arg fs_ni
fs_rv= word(dirlist.fs_ni, 1)
if pos('L', fs_view) = 0 then fs_rv= substr(fs_rv, 3, 8)
return fs_rv

fs_filtim: /* word 2, colon and seconds omitted in short form */
arg fs_ni
fs_rv= word(dirlist.fs_ni, 2)
if pos('L', fs_view) = 0 then fs_rv= substr(fs_rv, 1, 5)
return fs_rv

fs_filsiz: /* word 3 WITH spaces for ease in display */
arg fs_ni
fs_twi= wordindex(dirlist.fs_ni, 2) + length(word(dirlist.fs_ni, 2)) + 1
return substr(dirlist.fs_ni, fs_twi, 10)

fs_filatt: /* word 4 attributes */
arg fs_ni
return word(dirlist.fs_ni, 4)

fs_filnam: /* word 5 --> remainder INCLUDING spaces */
arg fs_ni
fs_twi= wordindex(dirlist.fs_ni, 5)
return substr(dirlist.fs_ni, fs_twi, length(dirlist.fs_ni) - fs_twi + 1)

fs_ellipsis: /* shorten fs_filnam if necessary to fit available space */
arg fs_ni, fs_nw
fs_twi= fs_filnam(fs_ni)
if length(fs_twi) > fs_nw then
  fs_twi= left(fs_twi, fs_nw % 2)||'//'||right(fs_twi, (fs_nw % 2) - 3)
return fs_twi

fs_show_section: /* displays however much of dirlist. fits screen space */
  do fs_loop= 0 to scry - 1/* sim clear screen; remove all of previous */
    if length(fs_view) = 0 then call syscurpos fs_loop, fs_scol
      else call syscurpos fs_loop, fs_scol - fs_dtlwid + 1
    call charout, ansi_clreol
  end
  fs_totlsiz= 0
  do fs_loop= 3 to fs_ndx
    fs_totlsiz= fs_totlsiz + fs_filsiz(fs_loop)
  end
  fs_loop= 0 /* 0 based for screen line */
  do until fs_loop + fs_ndx_ofs.fs_lvl >= fs_ndx | fs_loop >= fs_maxln
    fs_n= fs_loop + fs_ndx_ofs.fs_lvl + 1
    if length(fs_view) > 0 then do
      call syscurpos fs_loop, fs_scol - fs_dtlwid + 1
      call charout, ansi_clreol
      do fs_a= 1 to length(fs_view) /* order in fs_view sets displayed order! */
        fs_v= substr(fs_view, fs_a, 1)
        if fs_v= 'D' then call charout, fs_fildat(fs_n)' '
        if fs_v= 'T' then call charout, fs_filtim(fs_n)' '
        if fs_v= 'A' then call charout, fs_filatt(fs_n)' '
        if fs_v= 'S' then call charout, fs_filsiz(fs_n)' '
      end
    end
    call syscurpos fs_loop, fs_scol
    call charout, ansi_clreol
    select
      when fs_n = 1 then do
        call charout, d2c(17)||'.   '||fs_ndx - 2' files'
      end
      when fs_n = 2 then do
        call charout, d2c(17)||'..  'fs_totlsiz' bytes'
      end
      when fs_n > 2 then do
        call fs_show_tag(fs_n)
        call charout, fs_ellipsis(fs_n, scrx - fs_scol)
      end
    end /* select */
    fs_loop= fs_loop + 1
  end /* do until */
  call fs_highlight
return

fs_show_path: /* assembles bottom line, then truncates to available space */
  fs_ps= ' (F1 Help)  ['||word(sysdriveinfo(substr(fs_path, 1, 2)), 4)||'] '||fs_path
  fs_width= scrx - fs_scol + fs_dtlwid - 1
  do while length(fs_ps) < fs_width + 1
    fs_ps= fs_ps||'_' /* to clear prev */
  end
  call syscurpos scry, fs_scol - fs_dtlwid + 1 /* 0, 0 based */
  call charout, substr(fs_ps, length(fs_ps) - fs_width, fs_width)
return

fs_show_new_dir: /* code needed several times */
  if fs_ndx < fs_showln then fs_maxln= fs_ndx; else fs_maxln= fs_showln
  call fs_show_section
  call fs_show_path
return

fs_exit_dir: /* for left-arrow at any time, or <enter> on a dot dir */
  if fs_lvl > 1 & length(fs_path) > 3 then do /* backs up one fs_lvl */
    if fs_lvl > 2 then do
      fs_loop= length(fs_path) - 1
      do until substr(fs_path, fs_loop, 1) = '\' | length(fs_path) < 4
        fs_loop= fs_loop - 1
      end
      fs_loop= fs_loop + 1
    end
    else fs_loop= 4
    fs_cur= substr(fs_path, fs_loop, length(fs_path) - fs_loop)
    fs_loop= length(fs_path)
    do until substr(fs_path, fs_loop, 1) = '\' | length(fs_path) < 4
      fs_loop= fs_loop - 1
    end
    fs_path= substr(fs_path, 1, fs_loop)
    fs_lvl= fs_lvl - 1
/*     fs_filter= 0 going up, so off likely better (re-filter with 'H') */
/* !!! ^ you may want to comment this out for dedicated applications */
    fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
    fs_tags= copies('', fs_ndx)
    call fs_set_sel
    call fs_show_new_dir
  end
return

fs_enter_dir: /* for right-arrow or <enter> on a non-dot dir; 10 LEVEL LIMIT */
  fs_n= fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl
  if fs_lvl < 10 & fs_n > 2 & substr(fs_filatt(fs_n), 2, 1) = 'D' then do
    fs_cur= '' /* current selection always set off upon enter */
    fs_path= fs_path||fs_filnam(fs_n)||'\'
    fs_lvl= fs_lvl + 1
    fs_sel.fs_lvl= 1
    fs_ndx= get_1_directory(glo_var, fs_path, fs_flspc, fs_attr, fs_filter, 1)
    fs_tags= copies('', fs_ndx)
    call fs_set_sel
    call fs_show_new_dir
  end
return

fs_highlight: /* show selected item (only the name...) in reverse color */
  call syscurpos fs_sel.fs_lvl - 1, fs_scol + 1
  call charout, revcolr||fs_ellipsis(fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl, scrx - fs_scol)||norcolr
return

fs_lowlight: /* show name back in standard color */
  call syscurpos fs_sel.fs_lvl - 1, fs_scol + 1
  call charout, norcolr||fs_ellipsis(fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl, scrx - fs_scol)
return

fs_show_tag: /* show tag (for dirs, simulate block w reverse color) */
  arg fs_ni
  if substr(fs_filatt(fs_ni), 2, 1) = 'D' then do
    if substr(fs_tags, fs_ni, 1) = '' then call charout, revcolr||d2c(16)||norcolr
    else call charout, d2c(16)
  end
  else call charout, substr(fs_tags, fs_ni, 1)
return

fs_set_sel: /* figures out what part of list to display, and item to select */
  fs_n= 0
  if length(fs_cur) > 0 then do /* assumes fs_cur is valid... */
    fs_cs= 1
    do until fs_cs >= fs_ndx | pos(fs_cur, fs_filnam(fs_cs)) = 1
      fs_cs= fs_cs + 1
    end
  end
  else fs_cs= fs_ndx + 1
  if fs_cs <= fs_ndx then do
    if fs_cs > fs_showln then do
      fs_ndx_ofs.fs_lvl= fs_cs - fs_showln
      fs_sel.fs_lvl= fs_showln
      fs_n= fs_showln % 2
      if fs_ndx_ofs.fs_lvl + fs_sel.fs_lvl + fs_n < fs_ndx then do
        fs_ndx_ofs.fs_lvl= fs_ndx_ofs.fs_lvl + fs_n
        fs_sel.fs_lvl= fs_sel.fs_lvl - fs_n
      end
    end
    else do
      fs_ndx_ofs.fs_lvl= 0;
      fs_sel.fs_lvl= fs_cs;
    end
  end
  else do
    select
    when fs_initpos = 'H' then do /* show list from Head (top) */
      if fs_lvl > 1 & fs_ndx > 2 then fs_sel.fs_lvl= 3; else fs_sel.fs_lvl= 2
      fs_ndx_ofs.fs_lvl= 0
    end
    when fs_initpos = 'M' then do /* Middle */
      if fs_ndx > fs_showln then do /* more files than screen lines */
        fs_sel.fs_lvl= fs_showln % 2 + 1
        if (fs_ndx > 2 * fs_showln - 1) then fs_ndx_ofs.fs_lvl= fs_ndx % 2 - fs_sel.fs_lvl
          else fs_ndx_ofs.fs_lvl= (fs_ndx - fs_showln) % 2
      end
      else do
        if fs_ndx > 2 then fs_sel.fs_lvl= fs_ndx % 2 + 2; else fs_sel.fs_lvl = 2
        fs_ndx_ofs.fs_lvl= 0
      end
    end
    when fs_initpos = 'T' then do /* Tail (end) */
      if fs_ndx > fs_showln then do
        fs_sel.fs_lvl= fs_showln
        fs_ndx_ofs.fs_lvl= fs_ndx - fs_showln
      end
      else do
        fs_sel.fs_lvl= fs_ndx
        fs_ndx_ofs.fs_lvl= 0
      end
    end
    end /* select */
  end /* else of fs_cs <= fs_ndx */
return

/* get_1_directory can be invoked directly: gets only ONE level, NO recursion,
   BUT does all multiple file spec and filtering. Can be used for multiple
   concurrent lists by specifying stems in glo_var
   SPACES in file spec's present problems, that I DODGE by not allowing, but
   could be added if you're ambitious by changing the delimiter of g1_flspc
*/

get_1_directory:
parse arg glo_var, g1_path, g1_flspc, tattr, g1_filter, g1_dirs
/* get JUST ONE dir in Long (Y2K) form, and re-format:
2000-09-06 12:43:00  1234567890  A----  C:\os2\SWITCHRX.CMD
by removing unnecessary spaces and (known elsewhere) path to:
2000-09-06 12:43:00 1234567890 A---- SWITCHRX.CMD
1  words   2        3          4     5 --> remainder inc spaces */
  drop value(glo_var) /* toss any previous list */
  g1_addl= '____Date__ _Time___ ___Size___ Attrb  .'
  rc= value(glo_var||'1', g1_addl) /* fake dot dirs for sake of convention */
  g1_addl= 'yyyy-mm-dd hh:mm:ss          0 ADHRS  ..'
  rc= value(glo_var||'2', g1_addl) /* though will use the space for info */
  g1_addl= 2 /* additional, now is offset for accumulating to glo_var.0 */
  if substr(g1_path, length(g1_path), 1) \= '\' then g1_path= g1_path||'\'
  if g1_filter = 0 then do; g1_flspc= '*'; tattr= '*****'; end;
  do g1_nspec= 0 to words(g1_flspc) /* space delim'd, so NO OTHER spaces */
    ts.0= 0
    if g1_nspec > 0 then do
      rc= SysFileTree(g1_path||word(g1_flspc, g1_nspec), 'ts', 'FTL', tattr)
    end
    else do /* check get dirs */
      if g1_dirs = 1 then rc= SysFileTree(g1_path||'*', 'ts', 'DTL', tattr)
    end
    if ts.0 > 0 then do
      do g1_n= 1 to ts.0
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 3) - 1, 1)
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 4) - 1, 1)
        ts.g1_n= delstr(ts.g1_n, wordindex(ts.g1_n, 5) - 1, 1)
        p= pos(':\', ts.g1_n) - 1
        ts.g1_n= delstr(ts.g1_n, p, lastpos('\', ts.g1_n) - p + 1) /* strip out path */
        l= g1_n + g1_addl /* arithmetic */
        p= value(glo_var||l, ts.g1_n) /* SET (global) glo_var.[g1_n + addl] TO ts.g1_n */
      end
    end
    g1_addl= g1_addl + ts.0 /* sum # in current list plus all previous */
    p= value(glo_var||'0', g1_addl) /* set the number of elements */
  end
return g1_addl /* becomes fs_ndx, # of entries found */

fs_sort_list: /* Don't quibble that it's a slow primitive bubble sort; */
  if fs_ndx > 3 then do  /* makes for easy coding to sort on varied fields. */
    if substr(fs_filnam(2), 2, 1) = '.' then fs_head= 3; else fs_head= 1
    do until fs_head >= fs_ndx
      fs_cnt= fs_head + 1
      do until fs_cnt > fs_ndx
        select /* get which field: Date, Extension, Name, or Size */
          when fs_sort = 'D' then do
            fs_v1= word(dirlist.fs_cnt, 1)||word(dirlist.fs_cnt, 2)
            fs_v2= word(dirlist.fs_head, 1)||word(dirlist.fs_head, 2)
          end
          when fs_sort = 'E' then do /* Simplistic. Scrambles re full name. */
            parse upper var dirlist.fs_cnt with dummy '.' fs_v1
            parse upper var dirlist.fs_head with dummy '.' fs_v2
          end
          when fs_sort = 'N' then do
            fs_twi= wordindex(dirlist.fs_cnt, 5)
            fs_v1= substr(dirlist.fs_cnt, fs_twi, length(dirlist.fs_cnt) - fs_twi + 1)
            fs_twi= wordindex(dirlist.fs_head, 5)
            fs_v2= substr(dirlist.fs_head, fs_twi, length(dirlist.fs_head) - fs_twi + 1)
          end
          when fs_sort = 'S' then do
            fs_v1= word(dirlist.fs_cnt, 3)
            fs_v2= word(dirlist.fs_head, 3)
          end
        end /* select */
        if fs_v1 < fs_v2 then do /* compare and swap */
          fs_twi= dirlist.fs_cnt
          dirlist.fs_cnt= dirlist.fs_head
          dirlist.fs_head= fs_twi
        end
        fs_cnt= fs_cnt + 1
      end
      fs_head= fs_head + 1
    end
  end
return

fs_show_instructions:
arg ix
if ix > 40 then ix= 40 /* caller handles all screen clean-up, heh */
iy= 2
call say_inc 'ͻ'
call say_inc ' arrows:             uppercase:    '
call say_inc ' 'd2c(30)' up                Filter toggle '
call say_inc ' 'd2c(31)' down                            '
call say_inc ' 'd2c(16)' into directory    sort by:      '
call say_inc ' 'd2c(17)' out of directory  D: Date/Time  '
call say_inc '                     E: Extension  '
call say_inc ' <enter> select      N: Name       '
call say_inc ' <escape>            S: Size       '
call say_inc '                                   '
call say_inc ' lowercase a-z:      display from: '
call say_inc '   select drive      H: Head       '
call say_inc '                     M: Middle     '
call say_inc ' tagging:            T: Tail       '
call say_inc ' ctrl-up tag and up                '
call say_inc ' ctrl-down " " down  DGDs     v1.0 '
call say_inc ' <space> toggle      File Selector '
call say_inc 'ͼ'
kd= 0
do while chars() = 0
 if kd // 5 = 0 then do
   call syscurpos 2, ix + 5; call charout, ' Hit any key '
 end
 else do
   call syscurpos 2, ix + 5; call charout, ''
 end
 call syssleep 0.5
 kd= kd + 1
end
kd= ex_read_key()
kd= ''
return

say_inc:
parse arg it
call syscurpos iy, ix
call charout, it
iy= iy + 1
return

ex_read_key: /* returns two bytes for extended codes */
  xrkey= sysgetkey('noecho')
  if xrkey = d2c(0) | xrkey = d2c(224) then xrkey= xrkey||sysgetkey('noecho')
return xrkey
