/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 07/19/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to haen@veces or term@godot ***
 ***                                                      ***
 ************************************************************/

/**************************************************
 **  this struct was picked out of the SNews     **
 **  source written by John McCombs, New Zealand **
 **   <john@ahuriri.gen.nz>. Parts of it were    **
 **  rewritten, to meet our requirements         **
 **************************************************/

#ifndef OS2_PATCHES
#define OS2_PATCHES

#ifndef BOOL_DEFINED
#define BOOL_DEFINED
#define bool char
#define bool_int int
#endif

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

#define MAXLEN 256

/* this is the data we get from the UUPC .rc files */
typedef struct {
    char temp_name[MAXLEN];           /* temp files                    */
    char conf_dir[MAXLEN];            /* uupc config directory         */
    char news_dir[MAXLEN];            /* news base directory           */
    char mail_dir[MAXLEN];            /* incoming mail directory       */
    char mailsent[MAXLEN];   /* file in home, where sent mail is saved */
    char rmailpath[MAXLEN];       /* path to rmail, including filename */
    char active[MAXLEN];              /* the active file               */
    char active_times[MAXLEN];        /* the active.times file         */
    char user[MAXLEN];                /* current user id               */
    char mailfile[MAXLEN];            /* mail_dir + user = mailfile    */
    char name[MAXLEN];                /* users full name               */
    char domain[MAXLEN];              /* our domain                    */
    char from_domain[MAXLEN];         /* our domain, behind which we hide */
    char site[MAXLEN];                /* site name                     */
    char organization[MAXLEN];        /* organization                  */
    char mail_server[MAXLEN];         /* where posts are routed to     */
    char editor[MAXLEN];              /* system editor                 */
    char home[MAXLEN];                /* home mail directory           */
    char signature[MAXLEN];           /* signature file                */
    char newsadmin[MAXLEN];           /* mailadress of local newsguru  */
#ifdef COMPILING_TRN
    char trnlib[MAXLEN];   /* location of trn-executables and logfiles */
#endif
#ifdef COMPILING_MTHREADS
    char mthreadslib[MAXLEN]; /* location of mthreads-executable and logfile */
#endif
    char prefshell[MAXLEN];           /* the name of your commandshell */
    char locdist[MAXLEN];       /* distribution of your local computer */
    char orgdist[MAXLEN];             /* dist. of your organization    */
    char citydist[MAXLEN];            /* dist. of your city            */
    char statedist[MAXLEN];           /* dist. of your state           */
    char countrydist[MAXLEN];         /* dist. of your country         */
    char continentdist[MAXLEN];       /* dist. of your continent       */
} INFO;


/********************************************************
 ** now we need a global variable which will containt  **
 ** the settings which are picked out of the rc-files  **
 ********************************************************/

#ifndef OS2_PATCHES_C
/*** Global Variables ***/
extern INFO uupc_rc_settings;

/*** new function calls ***/
extern void change_sl2bsl(char *changeString);
extern void change_bsl2sl(char *changeString);
extern int load_uupc_rc(void);
extern int make_newsrc(char *rcname, char *activename);
extern int article_saver(bool mailbox, char *fromname, char *tosavename);
extern FILE *fos2open(const char *filename, const char *mode);
extern void mail_reply(void);
extern void article_poster(void);
extern int unsub_group(char *pattern);
extern int getstring(char *buf, int max_len);
#ifndef HAS_GETPWNAM
extern struct passwd *os2_getpwnam(char *name);
#endif

#endif /* OS2_PATCHES_C */

#endif /* OS2_PATCHES */
