/*  Installation script for PmNotes       */
/*  Copyright (C) 1997-1998 by Jeffrey Habets  */

'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

Say 'PmNotes installation script'
Say 'Copyright (C) 1997-1998 by Jeffrey Habets'
Say ''

Say 'Do you want me to create or update the PmNotes folder on your Desktop? (Y/N)'

Pull answer

If answer \= 'Y' Then
  Signal DONE


Say ''
Say 'Supercharging your desktop with PmNotes...'
Say ''

if \SysOpenObject('<PMN_FOLDER>', 'ICON', 'TRUE') then
Do
  Say 'Creating PmNotes folder on your Desktop...'
  Folder = '<WP_DESKTOP>'
  Type = 'WPFolder'
  Title = 'PmNotes'
  Parms = 'OBJECTID=<PMN_FOLDER>;SORT=NAME'
  If \SysCreateObject(Type, Title, Folder, Parms, 'FailIfExists') Then
  Do
    Say 'Error creating PmNotes folder! - installation ended!'
    signal DONE
  End
End
Else
Do
  Say 'Updating the existing PmNotes folder...'
End

filenames.0 = 5
filenames.1 = 'REGISTER.TXT'
filenames.2 = 'ORDER.FRM'
filenames.3 = 'WHEREBUY.TXT'
filenames.4 = 'INSTALL.TXT'
filenames.5 = 'HISTORY.TXT'

desc.0 = 5
desc.1 = 'Licence and Registration'D2C(13)D2C(10)'information'
desc.2 = 'BMT Micro'
desc.3 = 'BMT Micro'D2C(13)D2C(10)'resellers'
desc.4 = 'Install / Uninstall'
desc.5 = 'Changes history'

ID.0 = 5
ID.1 = '<PMN_REG>'
ID.2 = '<PMN_BMT>'
ID.3 = '<PMN_RESELLERS>'
ID.4 = '<PMN_INST>'
ID.5 = '<PMN_HIST>'

Say 'Creating objects for Licence and Registration information...'
Folder = '<PMN_FOLDER>'
Type = 'WPProgram'
Do i = 1 To desc.0
  Title = desc.i
  Parms = 'MINWIN=SYMBOL;PROGTYPE=PM;EXENAME=E.EXE;STARTUPDIR='Directory()';PARAMETERS='filenames.i';OBJECTID='ID.i';NOPRINT=YES;'
  Result = SysCreateObject(Type, Title, Folder, Parms, 'ReplaceIfExists')
End


Say 'Creating object for PmNotes documentation...'
Folder = '<PMN_FOLDER>'
Type = 'WPProgram'
Title = 'PmNotes documentation'
Parms = 'MINWIN=SYMBOL;PROGTYPE=PM;EXENAME=VIEW.EXE;STARTUPDIR='Directory()';PARAMETERS=PmnDoc.inf;OBJECTID=<PMN_DOC>;NOPRINT=YES;'
Result = SysCreateObject(Type, Title, Folder, Parms, 'ReplaceIfExists')

If Result \= 1 Then
  Say 'Error: Licence and Registration information object not created!'


Say 'Creating program object for PmNotes...'
Folder = '<PMN_FOLDER>'
Type = 'WPProgram'
Title = 'PmNotes'
Parms = 'MINWIN=SYMBOL;PROGTYPE=PM;EXENAME='Directory()'\PmNotes.exe;STARTUPDIR='Directory()';OBJECTID=<PMN_PROG>;NOPRINT=YES;'
Result = SysCreateObject(Type, Title, Folder, Parms, 'ReplaceIfExists')

If Result \= 1 Then
  Say 'Error: Program object not created!'


Say ''
Say 'By placing a shadow of the PmNotes program object in your startup folder,'
Say 'PmNotes will be started automatically each time you start your OS/2 system.'
Say ''
Say 'Do you want me to create a shadow of the PmNotes program'
Say 'object in the startup folder for you? (Y/N) '

Pull answer

If answer = 'Y' Then
Do
  Result = SysCreateShadow('<PMN_PROG>', '<WP_START>')

  If Result \= 1 Then
    Say 'Error: Shadow in Startup folder not created!'
End

Say ''
Say 'Installation complete!'

signal DONE

DONE:
Exit
