/*


File Name: CSVFIX.CMD
Purpose:   To cleanup .CSV files for import into Relish

           This program will map CR/LF to CR in the appropriate places of a
           .CSV file

*/

call RxFuncAdd 'SysTempFileName', 'REXXUTIL', 'SysTempFileName'


PARSE ARG FileName
if FileName = '' then call ShowUsage

TempFile = SysTempFileName('?????')

/* If any one of these characters are found before a LF, it will not be removed. */
BeginLineChars = '01"'

NextChar = CHARIN(FileName);

do while CHARS(FileName) > 0
        CurrentChar = NextChar
        NextChar = CHARIN(FileName)
        if CurrentChar = '0A'X & POS(NextChar, BeginLineChars) = 0 then
                iterate

        call CHAROUT TempFile, CurrentChar

        if ( CHARS(FileName)//100 = 0) then
                call CHAROUT ,'.'

end

call CHAROUT TempFile, NextChar

call CHAROUT TempFile
call CHAROUT FileName

call RenameFiles FileName,TempFile

return 0


RenameFiles:
        PARSE ARG OrigFile,NewFile

        PerPos = LASTPOS('.', OrigFile)
        if PerPos > 0 then
                BackupFile = SUBSTR(OrigFile, 1, PerPos) || 'bak'
        else
                BackupFile = OrigFile || '.bak'

        'rename ' OrigFile ' ' BackupFile
        'rename ' TempFile ' ' OrigFile
return 0

ShowUsage:

        say 'Correct command line is:'
        say 'CSVFIX <FILENAME>'
exit -1






