/* ------------------------------------------------------------------ */
/*                                                                    */
/* Copyright (c) Mike Cowlishaw, 1993-2019.  All rights reserved.     */
/* Parts Copyright (c) IBM, 1993-2009.                                */
/*                                                                    */
/* Permission to use, copy, modify, and distribute this software      */
/* for any non-commercial purpose without fee is hereby granted,      */
/* provided that the above copyright notice and this permission       */
/* notice appear in all copies, and that notice and the date of       */
/* any modifications be added to the software.                        */
/*                                                                    */
/* This software is provided "as is".  No warranties, whether         */
/* express, implied, or statutory, including, but not limited to,     */
/* implied warranties of merchantability and fitness for a            */
/* particular purpose apply to this software.  The author shall       */
/* not, in any circumstances, be liable for special, incidental,      */
/* or consequential damages, for any reason whatsoever.               */
/*                                                                    */
/* ------------------------------------------------------------------ */
* LongCOS(x), LongSIN(x)                           */
/*   X is *1000: -360000 to 360000                   */
/*   returns cosine*1000, i.e, 0->1000               */
/*   table is indexed by degrees * 10, looked up     */
/*   with range 0-900                                */
#include <stdio.h>
/* shared sine table */
static int table[901]={
  0, 2, 3, 5, 7, 9, 10, 12, 14, 16, 17, 19, 21, 23, 24, 26, 28, 30, 31,
  33, 35, 37, 38, 40, 42, 44, 45, 47, 49, 51, 52, 54, 56, 58, 59, 61, 63,
  65, 66, 68, 70, 71, 73, 75, 77, 78, 80, 82, 84, 85, 87, 89, 91, 92, 94,
  96, 98, 99, 101, 103, 105, 106, 108, 110, 111, 113, 115, 117, 118, 120,
  122, 124, 125, 127, 129, 131, 132, 134, 136, 137, 139, 141, 143, 144,
  146, 148, 150, 151, 153, 155, 156, 158, 160, 162, 163, 165, 167, 168,
  170, 172, 174, 175, 177, 179, 181, 182, 184, 186, 187, 189, 191, 193,
  194, 196, 198, 199, 201, 203, 204, 206, 208, 210, 211, 213, 215, 216,
  218, 220, 222, 223, 225, 227, 228, 230, 232, 233, 235, 237, 239, 240,
  242, 244, 245, 247, 249, 250, 252, 254, 255, 257, 259, 261, 262, 264,
  266, 267, 269, 271, 272, 274, 276, 277, 279, 281, 282, 284, 286, 287,
  289, 291, 292, 294, 296, 297, 299, 301, 302, 304, 306, 307, 309, 311,
  312, 314, 316, 317, 319, 321, 322, 324, 326, 327, 329, 331, 332, 334,
  335, 337, 339, 340, 342, 344, 345, 347, 349, 350, 352, 353, 355, 357,
  358, 360, 362, 363, 365, 367, 368, 370, 371, 373, 375, 376, 378, 379,
  381, 383, 384, 386, 388, 389, 391, 392, 394, 396, 397, 399, 400, 402,
  404, 405, 407, 408, 410, 412, 413, 415, 416, 418, 419, 421, 423, 424,
  426, 427, 429, 431, 432, 434, 435, 437, 438, 440, 442, 443, 445, 446,
  448, 449, 451, 452, 454, 456, 457, 459, 460, 462, 463, 465, 466, 468,
  469, 471, 473, 474, 476, 477, 479, 480, 482, 483, 485, 486, 488, 489,
  491, 492, 494, 495, 497, 498, 500, 502, 503, 505, 506, 508, 509, 511,
  512, 514, 515, 517, 518, 520, 521, 522, 524, 525, 527, 528, 530, 531,
  533, 534, 536, 537, 539, 540, 542, 543, 545, 546, 548, 549, 550, 552,
  553, 555, 556, 558, 559, 561, 562, 564, 565, 566, 568, 569, 571, 572,
  574, 575, 576, 578, 579, 581, 582, 584, 585, 586, 588, 589, 591, 592,
  593, 595, 596, 598, 599, 600, 602, 603, 605, 606, 607, 609, 610, 612,
  613, 614, 616, 617, 618, 620, 621, 623, 624, 625, 627, 628, 629, 631,
  632, 633, 635, 636, 637, 639, 640, 641, 643, 644, 645, 647, 648, 649,
  651, 652, 653, 655, 656, 657, 659, 660, 661, 663, 664, 665, 667, 668,
  669, 670, 672, 673, 674, 676, 677, 678, 679, 681, 682, 683, 685, 686,
  687, 688, 690, 691, 692, 693, 695, 696, 697, 698, 700, 701, 702, 703,
  705, 706, 707, 708, 710, 711, 712, 713, 714, 716, 717, 718, 719, 721,
  722, 723, 724, 725, 727, 728, 729, 730, 731, 733, 734, 735, 736, 737,
  738, 740, 741, 742, 743, 744, 745, 747, 748, 749, 750, 751, 752, 754,
  755, 756, 757, 758, 759, 760, 762, 763, 764, 765, 766, 767, 768, 769,
  771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 782, 783, 784, 785,
  786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 797, 798, 799, 800,
  801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814,
  815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828,
  829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842,
  842, 843, 844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 854,
  855, 856, 857, 858, 859, 860, 861, 862, 863, 863, 864, 865, 866, 867,
  868, 869, 869, 870, 871, 872, 873, 874, 875, 875, 876, 877, 878, 879,
  880, 880, 881, 882, 883, 884, 885, 885, 886, 887, 888, 889, 889, 890,
  891, 892, 893, 893, 894, 895, 896, 896, 897, 898, 899, 900, 900, 901,
  902, 903, 903, 904, 905, 906, 906, 907, 908, 909, 909, 910, 911, 911,
  912, 913, 914, 914, 915, 916, 916, 917, 918, 918, 919, 920, 921, 921,
  922, 923, 923, 924, 925, 925, 926, 927, 927, 928, 928, 929, 930, 930,
  931, 932, 932, 933, 934, 934, 935, 935, 936, 937, 937, 938, 938, 939,
  940, 940, 941, 941, 942, 943, 943, 944, 944, 945, 946, 946, 947, 947,
  948, 948, 949, 949, 950, 951, 951, 952, 952, 953, 953, 954, 954, 955,
  955, 956, 956, 957, 957, 958, 958, 959, 959, 960, 960, 961, 961, 962,
  962, 963, 963, 964, 964, 965, 965, 965, 966, 966, 967, 967, 968, 968,
  969, 969, 969, 970, 970, 971, 971, 972, 972, 972, 973, 973, 974, 974,
  974, 975, 975, 976, 976, 976, 977, 977, 977, 978, 978, 979, 979, 979,
  980, 980, 980, 981, 981, 981, 982, 982, 982, 983, 983, 983, 984, 984,
  984, 985, 985, 985, 985, 986, 986, 986, 987, 987, 987, 987, 988, 988,
  988, 988, 989, 989, 989, 990, 990, 990, 990, 991, 991, 991, 991, 991,
  992, 992, 992, 992, 993, 993, 993, 993, 993, 994, 994, 994, 994, 994,
  995, 995, 995, 995, 995, 995, 996, 996, 996, 996, 996, 996, 996, 997,
  997, 997, 997, 997, 997, 997, 998, 998, 998, 998, 998, 998, 998, 998,
  998, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
  1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
  1000, 1000, 1000, 1000, 1000, 1000, 1000 };
long lcos(long v) {
  int x; x=(int)(v/100L);  /* NB no round */
  /* x now in range -3600 to 3600 */
  if (x<0) x=-x;
  /* x now in range 0 to 3600 */
  if (x>1800) x=3600-x; /* fold */
  /* now 0-1800 (0-180 degrees) */
  if (x>900) return (long)(-table[x-900]);
  return (long)(table[900-x]);
  }; /* lcos */

long lsin(long v) {
  int x; x=(int)(v/100L);
  /* x now in range -3600 to 3600 */
  if (x<0) x=x+3600;
  /* x now in range 0 to 3600 */
  if (x>1800) {
    x=x-1800;
    if (x>900) x=1800-x;
    return (long)(-table[x]);}
  /* here if 0-1800 (0-180 degrees) */
  if (x>900) x=1800-x;
  return (long)(table[x]);
  }; /* lsin */
